<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'af', version '4.5'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TODO';
$string['activityisscheduledfordeletion'] = 'Aktiwiteit word tans geskrap...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" is nie \'n geldige waarde vir ouderdom nie.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" het meer of minder as een kommaskeier.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" is nie \'n geldige waarde vir land nie.';
$string['agedigitalconsentmapinvaliddefault'] = 'Verstek- (*) waarde ontbreek.';
$string['agelocationverificationdisabled'] = 'Ouderdom- en liggingverifiëring afgeskakel';
$string['alreadyloggedin'] = 'Jy is reeds ingeteken as {$a}. Jy moet eers uitteken voordat jy as \'n ander gebruiker kan inteken.';
$string['authnotexisting'] = 'Die inprop vir magtiging bestaan nie';
$string['backupcontainexternal'] = 'Hierdie rugsteunlêer bevat eksterne Moodle-netwerkgashere wat nie plaaslik gekonfigureer is nie';
$string['backuptablefail'] = 'Rugsteuntabelle kon NIE suksesvol opgestel word nie!';
$string['blockcannotconfig'] = 'Hierdie blok werk nie met globale konfigurasie nie';
$string['blockcannotinistantiate'] = 'Kon nie van hierdie blokobjek \'n eksemplaar maak nie';
$string['blockcannotread'] = 'Kon nie data vir blokid= {$a} lees nie';
$string['blockdoesnotexist'] = 'Hierdie blok bestaan nie';
$string['blockdoesnotexistonpage'] = 'Hierdie blok (id={$a->instanceid}) bestaan nie op hierdie bladsy ({$a->url}) nie.';
$string['blocknameconflict'] = 'Benamingskonflik: blok {$a->name} het dieselfde titel as \'n bestaande blok: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Kommentaarterugroeping het hierdie kommentaar verwerp.';
$string['cannotaddcoursemodule'] = 'Kon nie \'n nuwe kursusmodule byvoeg nie';
$string['cannotaddcoursemoduletosection'] = 'Kon nie die nuwe kursusmodule by daardie afdeling voeg nie';
$string['cannotaddmodule'] = '{$a} -module kon nie by die modulelys gevoeg word nie!';
$string['cannotaddnewmodule'] = 'Kon nie \'n nuwe module van {$a} byvoeg nie';
$string['cannotaddrss'] = 'Jy het nie toestemming om RSS-voere by te voeg nie';
$string['cannotaddthisblocktype'] = 'Jy kan nie \'n {$a}-blok by hierdie bladsy voeg nie.';
$string['cannotassignrole'] = 'Kan nie rolle in kursus toewys nie';
$string['cannotassignrolehere'] = 'Jy word nie toegelaat om hierdie rol (id = {$a->roleid}) in hierdie konteks ({$a->context}) toe te wys nie';
$string['cannotassignselfasparent'] = 'Kan nie jouself as ouer toewys nie!';
$string['cannotcallscript'] = 'Jy kan nie hierdie skrip op daardie wyse oproep nie';
$string['cannotcallusgetselecteduser'] = 'Jy kan nie user_selector::get_selected_user oproep as multiselekteer waar is nie.';
$string['cannotcreatebackupdir'] = 'Kon nie rugsteunlêergids skep nie. Die werf se administrateur sal lêervergunnings moet regstel.';
$string['cannotcreatecategory'] = 'Die kategorie is nie ingevoeg nie';
$string['cannotcreatedboninstall'] = '<p>Kon nie die databasis skep nie.</p>
<p>Die gespesifiseerde databasis bestaan nie en die aangetoonde gebruiker het nie toestemming om die databasis te skep nie.</p>
<p>Die werf se administrateur moet die konfigurasie van databasisse verifieer.</p>';
$string['cannotcreategroup'] = 'Kon nie groep skep nie';
$string['cannotcreatelangbase'] = 'Fout: Kon nie basistaalgids skep nie';
$string['cannotcreatelangdir'] = 'Kan nie taalgids skep nie';
$string['cannotcreateorfindstructs'] = '\'n Fout het opgeduik in die vind of skep van strukture vir die afdelings van hierdie kursus';
$string['cannotcreatepopupwin'] = 'Ongedefinieerde element - kan nie opspringvenster skep nie';
$string['cannotcreatesitedir'] = 'Kan nie lêergids vir werf skep nie. Die werf se administrateur sal lêervergunnings moet regstel.';
$string['cannotcreatetempdir'] = 'Kan nie tydelike gids skep nie';
$string['cannotcreateuploaddir'] = 'Kan nie lêergids vir oplaaie skep nie. Die werf se administrateur sal lêervergunnings moet regstel.';
$string['cannotcustomisefiltersblockuser'] = 'Jy kan nie filterinstellings in die konteks van gebruikers of blokke pasmaak nie.';
$string['cannotdeletebackupids'] = 'Kon nie vorige rugsteunidentiteite skrap nie';
$string['cannotdeletecategorycourse'] = 'Kon nie kursus \'{$a}\' skrap nie.';
$string['cannotdeletecategoryquestions'] = 'Kon nie vrae uit kategorie \'{$a}\' skrap nie';
$string['cannotdeletecourse'] = 'Jy het nie toestemming om hierdie kursus te skrap nie';
$string['cannotdeletecustomfield'] = 'Fout het opgeduik in die skrap van data uit pasgemaakte veld';
$string['cannotdeletedir'] = 'Kan nie \'{$a}\' skrap nie';
$string['cannotdeletefile'] = 'Kan nie hierdie lêer skrap nie';
$string['cannotdeleterole'] = 'Dit kan nie geskrap word nie, want {$a}';
$string['cannotdeleterolewithid'] = 'Kon nie rol met ID {$a} skrap nie';
$string['cannotdeletethisrole'] = 'Jy kan nie hierdie rol skrap nie omdat dit deur die stelsel gebruik word, of omdat dit die laaste rol is waaraan administrateurvermoëns toegeken is.';
$string['cannotdisableformat'] = 'Die verstekformaat kan nie gedeaktiveer word nie.';
$string['cannotdownloadcomponents'] = 'Kan nie komponente aflaai nie';
$string['cannotdownloadlanguageupdatelist'] = 'Kan nie lys van taalbywerkings via download.moodle.org aflaai nie';
$string['cannotdownloadzipfile'] = 'Kan nie ZIP-lêer aflaai nie';
$string['cannoteditcomment'] = 'Jy het nie die reg om hierdie opmerking te redigeer nie!';
$string['cannoteditcommentexpired'] = 'Jy kan nie hierdie redigeer nie. Die tyd het verstryk!';
$string['cannoteditpostorblog'] = 'Jy kan nie blogs plaas of redigeer nie';
$string['cannoteditsiteform'] = 'Jy kan nie via hierdie vorm die werfkursus redigeer nie';
$string['cannotedituserpreferences'] = 'Kan nie hierdie gebruiker se voorkeure redigeer nie';
$string['cannotedityourprofile'] = 'Jammer, jy kan nie jou eie profiel redigeer nie';
$string['cannotexecduringupgrade'] = 'Kan nie ten tyde van opgradering uitgevoer word nie';
$string['cannotfindcategory'] = 'Kan nie kategorierekord uit databasis met ID - {$a} vind nie';
$string['cannotfindcomponent'] = 'Kan nie komponent vind nie';
$string['cannotfindcontext'] = 'Kon nie konteks vind nie';
$string['cannotfindcourse'] = 'Kan nie kursus vind nie';
$string['cannotfinddocs'] = 'Kan nie "{$a}"-language.doc-lêers vind nie';
$string['cannotfindgradeitem'] = 'Kan nie grade_item vind nie';
$string['cannotfindgroup'] = 'Kon nie groep vind nie';
$string['cannotfindhelp'] = 'Kon nie hulplêers vir die taal "{$a}" vind nie';
$string['cannotfindinfo'] = 'Kon nie info vind vir: "{$a}"';
$string['cannotfindlang'] = 'Kan nie "{$a}"-taalpakkie vind nie!';
$string['cannotfindteacher'] = 'Kan nie onderwyser vind nie';
$string['cannotfinduser'] = 'Kon nie gebruiker genaamd "{$a}" vind nie';
$string['cannotgeoplugin'] = 'Kan nie met die geoPlugin-bediener by https://www.geoplugin.com verbind nie. Gaan asseblief jou volmaginstellings na of installeer die MaxMind GeoLite City-datalêer.';
$string['cannotgetblock'] = 'Kon nie blokke uit die databasis herwin nie';
$string['cannotgetcats'] = 'Kan nie kategorierekord kry nie';
$string['cannotgetdata'] = 'Kan nie data kry nie';
$string['cannotgradeuser'] = 'Kan nie punte vir hierdie gebruiker toeken nie';
$string['cannothaveparentcate'] = 'Kursuskategorie kan nie \'n ouer hê nie!';
$string['cannotimport'] = 'Intrekfout';
$string['cannotimportformat'] = 'Jammer, intrek van hierdie formaat is nog nie geïmplementeer nie!';
$string['cannotimportgrade'] = 'Gradeer intrekfout';
$string['cannotinsertgrade'] = 'Kan nie graderingsitem sonder kursus-ID invoeg nie!';
$string['cannotinsertrate'] = 'Kon nie \'n nuwe aanslag ({$a->id} = {$a->rating}) invoeg nie';
$string['cannotinsertrecord'] = 'Kon nie \'n nuwe rekord-ID {$a} invoeg nie';
$string['cannotmailconfirm'] = 'Iets het skeefgeloop met versending van e-pos om verandering van wagwoord te bevestig';
$string['cannotmanualctrack'] = 'Aktiwiteit maak nie voorsiening vir handmatige nasporing van voltooiing nie';
$string['cannotmapfield'] = 'Afbeeldingsbotsing bespeur - twee velde beeld af na dieselfde puntetoekenningsitem {$a}';
$string['cannotmarktopic'] = 'Kon nie daardie onderwerp vir hierdie kursus merk nie';
$string['cannotmigratedatacomments'] = 'Kan nie datamodule-opmerkings migreer nie';
$string['cannotmodulename'] = 'Kan nie die modulenaam in bounavigasie kry nie';
$string['cannotmoduletype'] = 'Kan nie die modulesoort in bounavigasie kry nie';
$string['cannotmovecategory'] = 'Kan nie kategorie skuif nie';
$string['cannotmovecourses'] = 'Kan nie kursusse vanuit die kategorie waarin hulle is na \'n ander verskuif nie.';
$string['cannotmoverolewithid'] = 'Kan nie rol met ID {$a} skuif nie';
$string['cannotopencsv'] = 'Kan nie CSV-lêer oopmaak nie';
$string['cannotopenfile'] = 'Kan nie lêer ({$a}) oopmaak nie';
$string['cannotopenforwrit'] = 'Kan nie vir skryf oopmaak nie: {$a}';
$string['cannotopentemplate'] = 'Kan nie templaatlêer ({$a}) oopmaak nie';
$string['cannotopenzip'] = 'Kan nie Zip-lêer oopmaak nie, waarskynlik weens \'n Zip-uitbreidingsfout op 64-bis-bedryfstelsel';
$string['cannotoverridebaserole'] = 'Kan nie basisrolvermoëns oorheers nie';
$string['cannotoverriderolehere'] = 'Jy word nie toegelaat om hierdie rol (id = {$a->roleid}) in hierdie konteks ({$a->context}) te oorheers nie';
$string['cannotreadfile'] = 'Kan nie lêer ({$a}) lees nie';
$string['cannotreadtmpfile'] = '\'n Fout het opgeduik met lees van tydelike lêer';
$string['cannotreaduploadfile'] = 'Kon nie opgelaaide lêer lees nie';
$string['cannotremovefrommeta'] = 'Kon nie die geselekteerde kursus uit hierdie metakursus verwyder nie!';
$string['cannotreprocessgrades'] = 'Kon nie puntetoekennings vir hierdie aktiwiteit {$a} herverwerk nie';
$string['cannotresetguestpwd'] = 'Jy kan nie die gastewagwoord terugstel nie';
$string['cannotresetmail'] = '\'n Fout het opgeduik in terugstelling van wagwoord en e-pos aan jou';
$string['cannotresetthisrole'] = 'Kan nie hierdie rol terugstel nie';
$string['cannotrestore'] = '\'n Fout het opgeduik en herstel kon nie voltooi word nie!';
$string['cannotrestoreadminorcreator'] = 'Jy moet \'n skepper of admingebruiker wees om weer in nuwe kursus herstel te word!';
$string['cannotrestoreadminoredit'] = 'Jy moet \'n redigerende onderwyser of admingebruiker wees om weer in geselekteerde kursus herstel te word!';
$string['cannotsaveagreement'] = 'Kon nie jou ooreenkoms stoor nie';
$string['cannotsaveblock'] = '\'n Fout het opgeduik met stoor van blok se konfigurasie';
$string['cannotsavecomment'] = 'Kan nie kommentaar stoor nie';
$string['cannotsavedata'] = 'Kan nie data stoor nie';
$string['cannotsavefile'] = 'Kan nie die lêer "{$a}" stoor nie!';
$string['cannotsavemd5file'] = 'Kan nie md5-lêer stoor nie';
$string['cannotsavezipfile'] = 'Kan nie ZIP-lêer stoor nie';
$string['cannotservefile'] = 'Kon nie lêer bedien nie weens \'n probleem met bedienerkonfigurasie.';
$string['cannotsetparentforcatoritem'] = 'Kan nie voorsaat vir kategorie of kursusitem stel nie!';
$string['cannotsetpassword'] = 'Kon nie gebruiker se wagwoord instel nie!';
$string['cannotsetprefgrade'] = 'Kan nie voorkeur vir bekyking van aggregasie na {$a} vir hierdie puntetoekenningskategorie stel nie';
$string['cannotsettheme'] = 'Kon nie die tema instel nie!';
$string['cannotsetupblock'] = 'Blok se tabelle kon NIE suksesvol ingestel word nie!';
$string['cannotsetupcapformod'] = 'Kon nie die vermoëns vir {$a} opstel nie';
$string['cannotsetupcapforplugin'] = 'Kon nie die vermoëns vir {$a} opstel nie';
$string['cannotshowhidecoursesincategory'] = 'Kan nie die kursusse in kategorie {$a} wys/verberg nie.';
$string['cannotsignup'] = 'Jy kan nie \'n nuwe rekening skep nie omdat jy reeds aangemeld is as {$a}.';
$string['cannotunassigncap'] = 'Kon nie toewysing van afkeuringsvermoë {$a->cap} aan rol {$a->role} ontdoen nie';
$string['cannotunassignrolefrom'] = 'Kan nie hierdie gebruiker se toewysing aan rol-ID {$a} ontdoen nie';
$string['cannotunzipfile'] = 'Kan nie lêer uitpak nie';
$string['cannotupdatemod'] = 'Kon nie {$a} bywerk nie';
$string['cannotupdatepasswordonextauth'] = 'Kon nie wagwoord op eksterne magtiging {$a} bywerk nie. Sien die bedienerlogs vir meer details.';
$string['cannotupdateprofile'] = '\'n Fout het opgeduik met bywerking van gebruiker se rekord';
$string['cannotupdaterecord'] = 'Kon nie rekord-ID {$a} bywerk nie';
$string['cannotupdaterss'] = 'Kan nie RSS bywerk nie';
$string['cannotupdatesubcourse'] = 'Kon nie \'n kinderkursus bywerk nie!';
$string['cannotupdateusermsgpref'] = 'Kan nie gebruiker se boodskapvoorkeure bywerk nie';
$string['cannotupdateuseronexauth'] = 'Kon nie gebruikerdata op eksterne magtiging {$a} bywerk nie. Sien die bedienerlogs vir meer details.';
$string['cannotuploadfile'] = '\'n Fout het opgeduik met die verwerking van lêer wat opgelaai moet word';
$string['cannotuseadmin'] = 'Om hierdie bladsy te gebruik, moet jy \'n admingebruiker wees';
$string['cannotuseadminadminorteacher'] = 'Om hierdie bladsy te gebruik, moet jy \'n onderwyser of admingebruiker wees';
$string['cannotusepage'] = 'Slegs onderwysers en administrateurs mag hierdie bladsy gebruik';
$string['cannotusepage2'] = 'Jammer, jy mag nie hierdie bladsy gebruik nie';
$string['cannotviewcategory'] = 'Jy het nie toestemming om hierdie lys van kursusse te bekyk nie.';
$string['cannotviewprofile'] = 'Jy kan nie die profiel van hierdie gebruiker bekyk nie';
$string['cannotviewreport'] = 'Jy kan nie hierdie verslag bekyk nie';
$string['cannotwritefile'] = 'Kan nie na lêer ({$a}) skryf nie';
$string['categoryerror'] = 'Kategoriefout';
$string['categoryidnumbertaken'] = 'ID-nommer word reeds vir \'n ander kategorie gebruik';
$string['categorynamerequired'] = 'Kategorienaam word verlang';
$string['categorytoolong'] = 'Kategorienaam té lank';
$string['commentmisconf'] = 'Kommentaar-ID is verkeerd gekonfigureer';
$string['componentisuptodate'] = 'Komponent is bygewerk';
$string['confirmationnotenabled'] = 'Gebruikerbevestiging is nie ontsper of hierdie werf nie';
$string['confirmsesskeybad'] = 'Jammer, jou sleutel tot die sessie kon nie bevestig word ter uitvoering van hierdie aksie nie.  Hierdie sekuriteitskenmerk verhoed enige toevallige of kwaadwillige uitvoering van belangrike funksies namens jou.  Maak asseblief doodseker dat jy regtig hierdie funksie wou uitvoer.';
$string['contenttypenotfound'] = 'Die \'{$a}\'-inhoudsbanktipe bestaan nie of word nie herken nie.';
$string['contentvisibilitynotfound'] = 'Die waarde \'{$a}\' vir sigbaarheid van inhoud bestaan nie of word nie erken nie.';
$string['couldnotassignrole'] = '\'n Ernstige maar ongespesifiseerde fout het opgeduik onderwyl daar gepoog is om \'n rol aan jou toe te wys';
$string['couldnotupdatenoexistinguser'] = 'Kan nie gebruiker bywerk nie - gebruiker bestaan nie';
$string['couldnotverifyagedigitalconsent'] = '\'n Fout het opgeduik onderwyl daar gepoog is om die digitale toestemmingsouderdom te verifieer.<br />Kontak administrateur asseblief.';
$string['countriesphpempty'] = 'Fout: Die lêer countries.php in taalpakkie {$a} is leeg of ontbreek.';
$string['coursedoesnotbelongtocategory'] = 'Die kursus hoort nie by hierdie kategorie nie';
$string['courseformatnotfound'] = 'Die kursusformaat \'{$a}\' bestaan nie of word nie herken nie.';
$string['coursegroupunknown'] = 'Kursus wat met groep {$a} ooreenstem, nie gespesifiseer nie';
$string['courseidnotfound'] = 'Die kursus-ID bestaan nie.';
$string['courseidnumbertaken'] = 'ID-nommer word reeds vir \'n ander kursus ({$a}) gebruik';
$string['coursemisconf'] = 'Kursus is verkeerd gekonfigureer';
$string['courserequestdisabled'] = 'Jammer, die administrateur het kursusversoeke versper.';
$string['csvcolumnduplicates'] = 'Gedupliseerde kolomme bespeur';
$string['csvemptyfile'] = 'Die CSV-lêer is leeg';
$string['csvfewcolumns'] = 'Nie genoeg kolomme nie; verifieer skeierinstellings asseblief';
$string['csvfileerror'] = 'Iets skeel met CSV-lêer se formaat. Maak asseblief seker dat die aantal opskrifte en kolomme ooreenstem, en dat die skeier en lêer se enkodering korrek is. {$a}';
$string['csvinvalidcols'] = '<b>Ongeldige CSV-lêer:</b> Eerste lyn moet "Header Fields" insluit en die lêer moet van die tipe <br />"Expanded Fields/Comma Separated"<br />of<br /> "Expanded Fields with CAVV Result Code/Comma Separated" wees';
$string['csvinvalidcolsnum'] = 'Ongeldige CSV-lêer - elke lyn moet 49 of 70 velde insluit';
$string['csvloaderror'] = '\'n Fout het opgeduik met die oplaai van die CSV-lêer: {$a}';
$string['csvnodata'] = 'Ongeldige CSV-lêer - die CSV-lêer bevat opskrifte maar bevat nie enige data nie.';
$string['csvweirdcolumns'] = 'Ongeldige CSV-lêerformaat - getal kolomme is nie konstant nie!';
$string['dbconnectionfailed'] = '<p>Fout: Kon nie met databasis verbind nie</p>
<p>Dit is moontlik dat die databasis oorlaai is of andersins nie na behore funksioneer nie.</p>
<p>Die werf se administrateur moet ook seker maak dat die databasis se details korrek gespesifiseer is in config.php</p>';
$string['dbdriverproblem'] = '<p>Fout: probleem met databasis se drywer bespeur</p>
<p>Die werf se administrateur moet die bediener se konfigurasie </p><p>{$a}</p> verifieer';
$string['dbsessionbroken'] = 'Erge probleme met databasissessie bespeur.<br /><br />Verwittig asseblief die werf se administrateur.';
$string['dbsessionhandlerproblem'] = 'Opstelling van databasissessie het misluk. Verwittig asseblief die werf se administrateur.';
$string['dbsessionmysqlpacketsize'] = '\'n Erge sessiefout is bespeur. Verwittig asseblief die werf se administrateur. Die probleem word waarskynlik veroorsaak deur klein waarde in max_allowed_packet MySQL-instelling.';
$string['dbupdatefailed'] = 'Bywerking van databasis het misluk';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" kan nie gewysig word nie. Afhanklikheid gevind tussen {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'DDL sql-uitvoeringsfout';
$string['ddlfieldalreadyexists'] = 'Veld "{$a}" bestaan reeds';
$string['ddlfieldnotexist'] = 'Veld "{$a->fieldname}" bestaan nie in tabel "{$a->tablename}" nie';
$string['ddltablealreadyexists'] = 'Tabel "{$a}" bestaan reeds';
$string['ddltablenotexist'] = 'Tabel "{$a}" bestaan nie';
$string['ddlunknownerror'] = 'Onbekende DDL-programmateekfout';
$string['ddlxmlfileerror'] = 'Foute met XML-databasislêers bespeur';
$string['ddsequenceerror'] = 'Inkorrekte definiëring van tabel "{$a}"; daar kan slegs een outokolom wees en dit moet as \'n sleutel gedefinieer word.';
$string['destinationcmnotexit'] = 'Die bestemde kursusmodule bestaan nie';
$string['detectedbrokenplugin'] = 'Die inprop "{$a}" is defektief of verouderd, daarom kan jy ongelukkig nie voortgaan nie.';
$string['dmlexceptiononinstall'] = '<p>\'n Databasisfout het opgeduik [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = '\'n Fout het opgeduik met sinsontleding van SQL-navraag';
$string['dmlreadexception'] = 'Kon nie van databasis lees nie';
$string['dmltransactionexception'] = 'Databasistransaksiefout';
$string['dmlwriteexception'] = 'Kon nie na databasis skryf nie';
$string['downgradedcore'] = 'FOUT!!! Die kode wat jy gebruik, is OUER as die weergawe wat hierdie databasisse daargestel het!';
$string['downloadedfilecheckfailed'] = 'Kontrolering van afgelaaide lêer het misluk';
$string['duplicatefieldname'] = 'Gedupliseerde veldnaam "{$a}" bespeur';
$string['duplicatenosupport'] = '\'{$a->modname}\'-aktiwiteit kon nie gedupliseer word nie omdat die  {$a->modtype}-module nie rugsteun en herstel ondersteun nie.';
$string['duplicateparaminsql'] = 'FOUT: Gedupliseerde parameternaam in navraag';
$string['duplicaterolename'] = 'Daar is reeds \'n  rol met hierdie naam!';
$string['duplicateroleshortname'] = 'Daar is reeds \'n rol met hierdie kort naam!';
$string['duplicateusername'] = 'Duplikaatgebruikernaam - slaan rekord  oor';
$string['emailfail'] = 'Versending van e-pos het misluk';
$string['encryption_decryptfailed'] = 'Dekodering het misluk';
$string['encryption_encryptfailed'] = 'Enkripsie het misluk';
$string['encryption_invalidkey'] = 'Ongeldige sleutel';
$string['encryption_keyalreadyexists'] = 'Sleutel bestaan reeds';
$string['encryption_nokey'] = 'Sleutel nie gevind nie';
$string['encryption_wrongmethod'] = 'Data pas nie by \'n ondersteunde enkripsiemetode nie';
$string['enddatebeforestartdate'] = 'Die kursus se einddatum moet ná die begindatum wees';
$string['error'] = 'Iets het skeefgeloop';
$string['error_question_answers_missing_in_db'] = 'Kon nie \'n antwoord in die question_answers-databasistabel vind wat by "{$a->answer}" pas nie. Dit het voorgekom onderwyl die vraag met ID {$a->filequestionid} in die rugsteunlêer herstel is, vir welke vraag trefslae met die bestaande vraag met ID {$a->dbquestionid} in die databasis gevind is.';
$string['errorcleaningdirectory'] = 'Iets het skeefgeloop met die skoonmaak van gids "{$a}"';
$string['errorcopyingfiles'] = 'Kon nie lêers kopieer nie';
$string['errorcreatingdirectory'] = 'Kon nie gids "{$a}" skep nie';
$string['errorcreatingfile'] = 'Kon nie lêer "{$a}" skep nie';
$string['errorcreatingrole'] = 'Iets het skeefgeloop met skep van rol';
$string['errorfetchingrssfeed'] = 'Iets het skeefgeloop met haal van RSS-voer';
$string['erroronline'] = 'Fout op lyn {$a}';
$string['erroroutput'] = 'Fout met afvoer, dus word outomatiese deurstuur versper';
$string['errorparsingxml'] = 'Fout met sinsontleding van XML: {$a->errorstring} by lyn {$a->errorline}, karakter {$a->errorchar}';
$string['errorprocessingarchive'] = 'Kon nie argieflêer verwerk nie';
$string['errorreadingfile'] = 'Kon nie lêer "{$a}" lees nie';
$string['errorsavingrequest'] = 'Iets het skeefgeloop met die poging om jou versoek te stoor.';
$string['errorsettinguserpref'] = 'Kon nie gebruikersvoorkeure instel nie';
$string['errorunzippingfiles'] = 'Kon nie lêers uitpak nie';
$string['expiredkey'] = 'Sleutel het verstryk';
$string['externalauthpassworderror'] = 'NIe-leë wagwoord vir eksterne magtiging';
$string['externalfilenolocation'] = 'Liggingsroete vir eksterne lêer ontbreek';
$string['failtoloadblocks'] = 'Een of meer blokke is in die databasis geregistreer, maar nie een van hulle kon gelaai word nie!';
$string['fieldrequired'] = '"{$a}" is \'n verlangde veld';
$string['fileexists'] = 'Lêer bestaan';
$string['filemismatch'] = 'Nie-kernlêer se naam pas nie. Die lêer "{$a->current}" moet {$a->file} wees.';
$string['filenotfound'] = 'Jammer, die verlangde lêer kon nie gevind word nie';
$string['filenotreadable'] = 'Lêer kan nie gelees word  nie';
$string['filterdoesnothavelocalconfig'] = 'Die lêer {$a} laat nie plaaslike konfigurasie toe nie';
$string['filternotactive'] = 'Filter {$a} is tans nie aktief nie';
$string['filternotenabled'] = 'Lêer is nie ontsper nie!';
$string['filternotinstalled'] = 'Filter {$a} is tans nie geïnstaller nie';
$string['forumblockingtoomanyposts'] = 'Jy het die plasingsdrumpel wat vir hierdie forum gestel is, oorsky';
$string['functionalityremoved'] = 'Jy probeer om toegang te verkry tot funksionaliteit wat verwyder is.';
$string['generalexceptionmessage'] = 'Uitsondering - {$a}';
$string['gradecantregrade'] = '\'n Fout het opgeduik ten tyde van die berekening van puntetoekennings: {$a}';
$string['gradepubdisable'] = 'Publisering van puntetoekennings versper';
$string['gradesneedregrading'] = 'Die kursus se puntetoekennings moet herbereken word';
$string['groupalready'] = 'Gebruiker behoort reeds aan groep {$a}';
$string['groupexistforcourse'] = 'Groep "{$a}" bestaan reeds vir hierdie kursus';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Groep "{$a->name}" met die ID-nommer "{$a->idnumber}" bestaan reeds vir hierdie kursus';
$string['grouphasidnumber'] = 'Groep "{$a}" het \'n ID-nommer en is dalk outomaties deur \'n eksterne stelsel geskep. Jy het nie toestemming om hierdie groep te verwyder nie.';
$string['groupinghasidnumber'] = 'Groepering "{$a}" het \'n ID-nommer en is dalk outomaties deur \'n eksterne stelsel geskep. Jy het nie toestemming om hierdie groepering te verwyder nie.';
$string['groupingnotaddederror'] = 'Groepering "{$a}" nie bygevoeg nie';
$string['groupnotaddederror'] = 'Groep "{$a}" nie bygevoeg nie';
$string['groupnotaddedtogroupingerror'] = 'Groep "{$a->groupname}" nie by groepering "{$a->groupingname}" gevoeg nie';
$string['groupunknown'] = 'Groep {$a} nie met gespesifiseerde kursus geassosieer nie';
$string['groupusernotmember'] = 'Gebruiker is nie lid van hierdie groep nie.';
$string['guestcantaccessprofiles'] = 'Gaste kan nie toegang tot verbruikers se profiele verkry nie. Om voort te gaan, meld aan met \'n volledige gebruikersrekening.';
$string['guestnocomment'] = 'Gaste word nie toegelaat om opmerkings te plaas nie!';
$string['guestnoeditprofile'] = '\'n Gebruiker wat \'n gas is, kan nie hul profiel redigeer nie';
$string['guestnoeditprofileother'] = 'Die profiel van \'n gebruiker wat \'n gas is, kan nie geredigeer word nie';
$string['guestnorate'] = 'Gaste word nie toegelaat om inskrywings te beoordeel nie';
$string['guestsarenotallowed'] = '\'n Gebruiker wat \'n gas is, word nie toegelaat om hierdie te doen nie';
$string['hackdetected'] = 'Kapery bespeur!';
$string['hashpoolproblem'] = 'Verkeerde poellêerinhoud {$a}.';
$string['headersent'] = 'Hofies reeds aangestuur';
$string['idnumbertaken'] = 'Hierdie ID-nommer is reeds in gebruik';
$string['idnumbertoolong'] = 'ID nommer is te lank';
$string['importformatnotimplement'] = 'Jammer, invoering van hierdie formaat is nog nie geïmplementeer nie!';
$string['incorrectext'] = 'Lêer het verkeerde uitbreiding';
$string['inplaceeditableerror'] = 'Kon nie bywerkingsverwerker oproep nie';
$string['installproblem'] = 'Dit is gewoonlik nie moontlik om te herstel van foute wat tydens installasie afgesit is nie. Jy moet dalk \'n nuwe databasis skep of \'n ander databaisvoorvoegsel gebruik as jy die installasie weer wil probeer.';
$string['internalauthpassworderror'] = 'Ontbrekende wagwoord of ongeldige wagwoordbeleid vir interne magtiging';
$string['invalidaccess'] = 'Daar is nie op die regte wyse toegang tot hierdie bladsy verkry nie';
$string['invalidaccessparameter'] = 'Ongeldige toegangsparameter';
$string['invalidaction'] = 'Ongeldige aksieparameter';
$string['invalidactivityid'] = 'Ongeldige aktiwiteit-ID';
$string['invalidadminsettingname'] = 'Ongeldige admininstelling ({$a})';
$string['invalidargorconf'] = 'Geen geldige argumente verskaf nie of verkeerde bedienerkonfigurasie';
$string['invalidarguments'] = 'Geen geldige argumente verskaf nie';
$string['invalidblockinstance'] = 'Ongeldige blokeksemplaar vir: {$a}';
$string['invalidbulkenrolop'] = 'Ongeldige bewerking van massa-inskrywing versoek.';
$string['invalidcategory'] = 'Verkeerde kategorie!';
$string['invalidcategoryid'] = 'Verkeerde kategorie-ID!';
$string['invalidcomment'] = 'Kommentaar is verkeerd';
$string['invalidcommentarea'] = 'Ongeldige kommentaar-area';
$string['invalidcommentid'] = 'Ongeldige kommentaar-ID';
$string['invalidcommentitemid'] = 'Ongeldige ID vir kommentaaritem';
$string['invalidcommentparam'] = 'Ongeldige kommentaar parameters';
$string['invalidcomponent'] = 'Ongeldige komponentnaam';
$string['invalidconfirmdata'] = 'Ongeldige bevestigingsdata';
$string['invalidcontentid'] = 'Ongeldige inhoud-ID';
$string['invalidcontext'] = 'Ongeldige konteks';
$string['invalidcountrycode'] = 'Ongeldige landkode: {$a}';
$string['invalidcourse'] = 'Ongeldige kursus';
$string['invalidcourseformat'] = 'Ongeldige kursusformaat';
$string['invalidcourseid'] = 'Jy probeer tans om \'n ongeldige kursus-ID te gebruik';
$string['invalidcourselevel'] = 'Verkeerde konteksvlak';
$string['invalidcoursemodule'] = 'Ongeldige kursusmodule-ID';
$string['invalidcoursenameshort'] = 'Ongeldige naam van kortkursus';
$string['invaliddata'] = 'Ingediende data is ongeldig';
$string['invaliddatarootpermissions'] = 'Ongeldige toestemming bespeur toe gepoog is om \'n gids te skep. Skakel ontfouting aan vir meer besonderhede.';
$string['invaliddevicetype'] = 'Ongeldige toesteltipe';
$string['invalidelementid'] = 'Verkeerde element-ID!';
$string['invalidentry'] = 'Hierdie is nie \'n geldige inskrywing nie!';
$string['invalidevent'] = 'Ongeldige gebeurtenis';
$string['invalidfieldname'] = '"{$a}" is nie \'n geldige veldnaam nie';
$string['invalidfiletype'] = '"{$a}" is nie \'n geldige veldtipe nie';
$string['invalidformatpara'] = 'Verkeerde formaat vir gekose parameter';
$string['invalidformdata'] = 'Verkeerde vormdata';
$string['invalidfunction'] = 'Verkeerde funksie';
$string['invalidgradeitemid'] = 'Verkeerde ID vir punte-item';
$string['invalidgroupid'] = 'Verkeerde groep-ID gespesifiseer';
$string['invalidipformat'] = 'Ongeldige IP-adresformaat';
$string['invaliditemid'] = 'Verkeerde item-ID';
$string['invalidkey'] = 'Verkeerde sleutel';
$string['invalidlanguagecode'] = 'Ongeldige taalkode: {$a}';
$string['invalidlegacy'] = 'Verkeerde argaïse rolomskrywing vir tipe: {$a}';
$string['invalidmd5'] = 'Die kontroleveranderlike was verkeerd - probeer weer';
$string['invalidmode'] = 'Ongeldige modus ({$a})';
$string['invalidmodule'] = 'Ongeldige module';
$string['invalidmoduleid'] = 'Ongeldige module-ID: {$a}';
$string['invalidmodulename'] = 'Ongeldige modulenaam: {$a}';
$string['invalidnum'] = 'Ongeldige numeriese waarde';
$string['invalidnumkey'] = 'Die skikking $voorwaardes mag nie numeriese sleutels bevat nie. Maak asseblief die kode reg!';
$string['invalidoutcome'] = 'Verkeerde uitkoms-ID';
$string['invalidpagesize'] = 'Ongeldige bladsygrootte';
$string['invalidpasswordpolicy'] = 'Ongeldige wagwoordbeleid';
$string['invalidpaymentmethod'] = 'Ongeldige betalingsmetode: {$a}';
$string['invalidqueryparam'] = 'FOUT: Verkeerde aantal navraagparameters. Verwagte {$a->expected}, het {$a->actual} opgelewer.';
$string['invalidratingarea'] = 'Ongeldige beoordelingsarea';
$string['invalidrecord'] = 'Kan nie datarekord in databasistabel {$a} vind nie.';
$string['invalidrecordunknown'] = 'Kan nie datarekord in databasis vind nie.';
$string['invalidrequest'] = 'Ongeldige versoek';
$string['invalidrole'] = 'Ongeldige rol';
$string['invalidroleid'] = 'Ongeldige rol-ID';
$string['invalidscaleid'] = 'Verkeerde skaal-ID';
$string['invalidsection'] = 'Rekord van kursusmodule bevat ongeldige afdeling';
$string['invalidsesskey'] = 'Jou sessie het waarskynlik sy spertydperk bereik. Meld asseblief weer aan.';
$string['invalidshortname'] = 'Ongeldige kortkursusnaam';
$string['invalidsourcefield'] = 'Konseplêer se bronveld is ongeldig';
$string['invalidstatedetected'] = 'Iets het skeefgeloop: {$a}. Dit behoort nooit normaalweg te gebeur nie.';
$string['invalidurl'] = 'Ongeldige URL';
$string['invaliduser'] = 'Ongeldige gebruiker';
$string['invaliduserdata'] = 'Ongeldige gebruikerdata: {$a}';
$string['invaliduserfield'] = 'Ongeldige gebruikerveld: {$a}';
$string['invaliduserid'] = 'Ongeldige gebruiker-ID';
$string['invalidusername'] = 'Die gebruikernaam wat verskaf is, bevat ongeldige karakters';
$string['invalidusernameblank'] = 'Die gebruikernaam kan nie leeg wees nie';
$string['invalidxmlfile'] = '"{$a}" is nie \'n geldige XML-lêer nie';
$string['iplookupfailed'] = 'Kan nie geo-inligting oor hierdie IP-adres {$a} vind nie';
$string['iplookupprivate'] = 'Kan nie opsoek van private IP-adres vertoon nie';
$string['ipmismatch'] = 'Mispassing van kliënt se IP-adres';
$string['listcantmovedown'] = 'Kon nie item afskuif nie aangesien dit laaste in sy lys van eweknieë verskyn.';
$string['listcantmoveleft'] = 'Kon nie item links skuif nie omdat dit geen voorsaat het nie';
$string['listcantmoveright'] = 'Kon nie item regs skuif nie omdat daar geen eweknie is om daarvan \'n kind te maak nie. Skuif dit tot onder \'n ander eweknie en dan kan jy dit regs skuif.';
$string['listcantmoveup'] = 'Kon nie item opskuif nie aangesien dit eerste in sy lys van eweknieë verskyn.';
$string['listnochildren'] = 'Geen kinders van item gevind nie';
$string['listnoitem'] = 'Item nie gevind nie';
$string['listnopeers'] = 'Geen eweknieë van item gevind nie';
$string['listupdatefail'] = 'DB-bewerking het misluk toe lyshiërargie geredigeer is';
$string['logfilenotavailable'] = 'Logs nie beskikbaar nie';
$string['loginasnoenrol'] = 'Wanneer in "Meld aan as"-sessie vir \'n kursus kan jy nie "skryf in" of "ontdoen inskrywing" gebruik nie';
$string['loginasonecourse'] = 'Jy kan nie by hierdie kursus aanteken nie.<br /> Jy moet die "Meld aan as"-sessie beëindig voordat jy by enige ander kursus aanteken.';
$string['maxareabytes'] = 'Die lêer is groter as die oorblywende spasie in hierdie area';
$string['maxbytesfile'] = 'Die lêer {$a->file} is te groot. Die maksimumgrootte wat jy kan oplaai, is {$a->size}.';
$string['maxdraftitemids'] = 'Die lêers wat jy kan oplaai, word tydelik beperk nadat jy \'n groot volume lêers opgelaai het. Wag asseblief en probeer dan weer.';
$string['messageundeliveredbynotificationsettings'] = 'Die boodskap kon nie gestuur word nie omdat persoonlike boodskappe tussen gebruikers (in Kennisgewinginstellings) deur \'n webwerfadministrateur afgeskakel is.';
$string['messagingdisable'] = 'Boodskapdiens is afgeskakel op hierdie webwerf';
$string['mimetexisnotexist'] = 'Jou stelsel is nie gekonfigureer om mimeTeX te laat loop nie. Jy moet die C-bron vanaf <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a> bekom, dit kompileer en die uitvoerbare in jou moodle/filter/tex/-gids plaas.';
$string['mimetexnotexecutable'] = 'Doelgemaakte mimeTeX is nie uitvoerbaar nie!';
$string['missing_moodle_backup_xml_file'] = 'Rugsteun ontbreek vir XML-lêer: {$a}';
$string['missingfield'] = 'Veld "{$a}" ontbreek';
$string['missingkeyinsql'] = 'FOUT: ontbrekende parameter "{$a}" in navraag';
$string['missingparam'] = '\'n Verlangde parameter ({$a}) het ontbreek';
$string['missingparameter'] = 'Parameter ontbreek';
$string['missingrequiredfield'] = 'Een of ander verlangde veld ontbreek';
$string['missinguseranditemid'] = 'Gebruiker-ID en item-ID ontbreek';
$string['missingvarname'] = 'Verlangde veranderlike se naam ontbreek!';
$string['mixedtypesqlparam'] = 'FOUT: SQL-navraagparameters is vermeng!';
$string['mnetdisable'] = 'MNET is afgeskakel';
$string['mnetlocal'] = 'Afstands-MNET-gebruikers kan nie plaaslik aanmeld nie';
$string['moduledisable'] = 'Hierdie module ({$a}) is vir hierdie spesifieke kursus buite werking gestel';
$string['moduledoesnotexist'] = 'Hierdie module bestaan nie';
$string['moduleinstancedoesnotexist'] = 'Die eksemplaar van hierdie module bestaan nie';
$string['modulemissingcode'] = 'Module {$a} kort die kode wat nodig is om hierdie funksie uit te voer';
$string['movecatcontentstoroot'] = 'Verskuiwing van die kategorie-inhoud na die stam word nie toegelaat nie. Jy moet die inhoud na \'n bestaande kategorie verskuif!';
$string['movecatcontentstoselected'] = 'Sommige kategorie-inhoud kan nie na die geselekteerde kategorie verskuif word nie.';
$string['movecategorynotpossible'] = 'Jy kan nie kategorie \'{$a}\' na die geselekteerde kategorie verskuif nie.';
$string['movecategoryownparent'] = 'Jy kan nie kategorie \'{$a}\' \'n voorsaat van homself maak nie.';
$string['movecategoryparentconflict'] = 'Jy kan nie kategorie \'{$a}\' \'n subkategorie van sy eie subkategorieë maak nie.';
$string['mssqlrcsmodemissing'] = 'Die databasis gebruik nie die verwagte READ_COMMITTED_SNAPSHOT-modus nie wat tot die verkeerde resultate aanleiding kan gee, veral in scenarios waar samelopendheid hoog is. Aktiveer dit asseblief om die korrekte gedrag te verseker. Vir meer inligting, sien die dokumentasie  <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Installing MSSQL for PHP</a>.';
$string['multiplerecordsfound'] = 'Multirekords gevind; slegs een rekord verwag.';
$string['multiplerestorenotallow'] = 'Multiherstelbewerkings word nie toegelaat nie!';
$string['mustbeloggedin'] = 'Jy moet aangemeld wees om hierdie te kan doen';
$string['mustbeteacher'] = 'Jy moet \'n onderwyser wees om hierdie bladsy te bekyk.';
$string['myisamproblem'] = 'Databasistabelle maak gebruik van die MyISAM-databasisenjin. Daar word aanbeveel dat \'n enjin met volle transaksie-ondersteuning wat aan ACID voldoen soos InnoDB gebruik word.';
$string['needcopy'] = 'Jy moet eers iets kopieer!';
$string['needcoursecategroyid'] = 'Óf die kursus-ID óf kategorie moet gespesifiseer word';
$string['needphpext'] = 'Jy moet {$a}-ondersteuning by jou PHP-installasie voeg';
$string['noadmins'] = 'Geen administrateurs nie!';
$string['noblocks'] = 'Geen blokke gevind nie!';
$string['nocapabilitytousethisservice'] = 'Die gebruiker het nie die verlangde beskkingsmag om van hierdie diens gebruik te maak nie';
$string['nocategorydelete'] = 'Kategorie \'{$a}\' kan nie geskrap word nie!';
$string['nocontext'] = 'Jammer, maar daardie kursus is nie \'n geldige konteks nie';
$string['nodata'] = 'Geen data nie';
$string['noexistingcategory'] = 'Geen bestaande kategorie nie';
$string['nofile'] = 'Lêer nie gespesifiseer nie';
$string['nofiltersenabled'] = 'Geen lêers ontsper nie.';
$string['nofolder'] = 'Die gids wat versoek is, bestaan nie';
$string['noformdesc'] = 'Geen lêer wat die formslib-vorm vir hierdie aktiwiteit beskryf, gevind nie.';
$string['noguest'] = 'Geen gaste hier nie!';
$string['noinstances'] = 'Daar is geen eksemplaar van \'{$a}\' in hierdie kursus nie!';
$string['nologinas'] = 'Jy word nie toegelaat om as daardie gebruiker aan te meld nie';
$string['nonmeaningfulcontent'] = 'Inhoud maak nie sin nie';
$string['noparticipants'] = 'Geen deelnemers vir hierdie kursus gevind nie';
$string['noparticipatorycms'] = 'Jammer, jy het geen deelnemende kursusmodules waaroor verslag gedoen kan word nie';
$string['nopermissions'] = 'Jammer, maar jy het nie tans toestemming om dit ({$a}) te doen nie.';
$string['nopermissiontocomment'] = 'Jy kan nie kommentaar byvoeg nie';
$string['nopermissiontodelentry'] = 'Jy kan nie hierdie kommentaar skrap nie!';
$string['nopermissiontoeditcomment'] = 'Jy kan nie ander mense se kommentaar redigeer nie!';
$string['nopermissiontohide'] = 'Geen toestemming om te verberg nie!';
$string['nopermissiontoimportact'] = 'Jy het nie die nodige toestemming om aktiwiteite na hierdie kursus in te voer nie.';
$string['nopermissiontolock'] = 'Geen toestemming om te sluit nie!';
$string['nopermissiontomanagegroup'] = 'Jy het nie die nodige toestemming om groepe te beheer nie';
$string['nopermissiontorate'] = 'Beoordeling van items nie toegelaat nie!';
$string['nopermissiontoshow'] = 'Geen toestemming om hierdie te sien nie!';
$string['nopermissiontounlock'] = 'Geen toestemming om te ontsluit nie!';
$string['nopermissiontoupdatecalendar'] = 'Jammer, jy het nie toestemming om die kalendergebeurtenis by te werk nie.';
$string['nopermissiontoviewgrades'] = 'Kan nie punte bekyk nie.';
$string['nopermissiontoviewletergrade'] = 'Toestemming om lettergraderings te bekyk ontbreek';
$string['nopermissiontoviewpage'] = 'Jy word nie toegelaat om na hierdie bladsy te kyk nie';
$string['nosite'] = 'Kon nie \'n topvlak-kursus vind nie!';
$string['nositeid'] = 'Geen werf-ID nie';
$string['nostartdatenoenddate'] = '\'n Kursus se einddatum kan slegs ingestel word indien \'n begindatum ook ingestel is.';
$string['nostatstodisplay'] = 'Jammer, daar is geen beskikbare data om te vertoon nie';
$string['notallowedtoupdateprefremotely'] = 'Afstandsbywerking van hierdie gebruiker se voorkeure nie aan jou vergun nie';
$string['notavailable'] = 'Daardie is nie tans beskikbaar nie';
$string['notlocalisederrormessage'] = '\'{$a}';
$string['notmemberofgroup'] = 'Jy is nie \'n lid van hierdie kursusgroep nie';
$string['notownerofkey'] = 'Jy is nie die eienaar van hierdie sleutel nie';
$string['nousers'] = 'Daar bestaan nie so \'n gebruiker nie!';
$string['oauth1accesstoken'] = 'OAuth 1.0-fout: Ons het nie die toegangsbewys gekry nie.';
$string['oauth1requesttoken'] = 'OAuth 1.0-fout: Ons het nie die versoekbewys gekry nie - die diensverskaffer ervaar dalk \'n tydelike onderbreking.';
$string['oauth2refreshtokenerror'] = 'Kon nie OAuth 2-bewys verfris nie. HTTP-status vir afstandseindpunt: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Kon nie OAuth 2-bewys vir een of meer uitreikers verfris nie. Sien taak se uitset vir  details.';
$string['oauth2upgradetokenerror'] = 'Kon nie OAuth 2-bewys opgradeer nie. HTTP-status vir afstandseindpunt: {$a}';
$string['onlyadmins'] = 'Slegs administrateurs kan dit doen';
$string['onlyeditingteachers'] = 'Slegs redigerende onderwysers kan dit doen';
$string['onlyeditown'] = 'Jy kan slegs jou eie inligting redigeer';
$string['orderidnotfound'] = 'Bestelling-ID {$a} nie gevind nie';
$string['pagenotexist'] = '<p>\'n Ongewone fout het opgeduik onderwyl gepoog is om na \'n bladsy te kyk wat nie bestaan nie:</p>{$a}';
$string['pagenotexisttitle'] = '404-fout: Lêer nie gevind nie';
$string['pathdoesnotstartslash'] = 'Geen geldige argumente verskaf nie. Roete begin nie met \'n skuinsstreep nie!';
$string['pleasereport'] = 'As jy \'n tydjie het, laat wees ons asseblief wat jy probeer doen het toe die fout opgeduik het:';
$string['pluginrequirementsnotmet'] = 'Inprop "{$a->pluginname}" ({$a->pluginversion}) kon nie geïnstalleer word nie.  Hiervoor is \'n nuwer weergawe van Moodle nodig. (Jy gebruik tans {$a->currentmoodle}; jy benodig {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Inprop "{$a->pluginname}" {$a->pluginversion} werk nie met hierdie weergawe van Moodle {$a->moodleversion} nie. Bekom inligting oor die inprop om weergawes te vind wat wel ondersteun word.';
$string['prefixcannotbeempty'] = '<p>Fout: databasistabel se voorvoegsel kan nie leeg wees nie ({$a})</p>
<p>Die webwerfadministrateur moet hierdie probleem regstel.</p>';
$string['prefixtoolong'] = '<p>Fout: databasistabel se voorvoegsel is te lank ({$a->dbfamily})</p>
<p>Die webwerfadministrateur moet hierdie probleem regstel;. Maksimumlengte vir tabelle se voorvoegsels in {$a->dbfamily} is {$a->maxlength} karakters.</p>';
$string['privatefilesupload'] = 'Regstreekse oplaai na gebruikers se private lêerareas werk nie meer nie. Laai op na konseparea en skuif die lêers dan via core_user::add_user_private_files';
$string['processingstops'] = 'Verwerking eindig hier. Oorblywende rekords geïgnoreer.';
$string['protected_cc_not_supported'] = 'Beskermde patrone word nie ondersteun nie.';
$string['querystringcannotbeempty'] = 'Die navraagstring kan nie leeg wees nie.';
$string['redirecterrordetected'] = 'Nie-ondersteunde aanstuur bespeur; skripuitvoering beëindig';
$string['refoundto'] = 'Kan terugbetaal word aan {$a}';
$string['refoundtoorigi'] = 'Terugbetaal aan oorspronklike rekening: {$a}';
$string['registrationdisabled'] = 'Registrasie is buite werking gestel op hierdie webwerf';
$string['remotedownloaderror'] = '<p>Die aflaai van die komponent na jou bediener het misluk. Verifieer asseblief instaanbediener se instellings; die uitbreiding PHP cURL word hoogs aanbeveel.</p>
<p>Jy moet die <a href="{$a->url}">{$a->url}</a>-lêer handmatig aflaai, dit na "{$a->dest}" in jou bediener kopieer en dit daar uitpak.</p>';
$string['remotedownloadnotallowed'] = 'Aflaai van komponente na jou bediener word nie toegelaat nie (allow_url_fopen is afgeskakel).<br /><br />Jy moet die <a href="{$a->url}">{$a->url}</a>-lêer handmatig aflaai, dit na "{$a->dest}" in jou bediener kopieer en dit daar uitpak.</p>.';
$string['reportnotavailable'] = 'Hierdie tipe verslag is slegs beskikbaar vir die webwerfkursus';
$string['requirecorrectaccess'] = 'Ongeldige URL of poort';
$string['requireloginerror'] = 'Kon nie toegang tot kursus of aktiwiteit verkry nie,';
$string['restore_path_element_missingmethod'] = 'Herstelmetode {$a} ontbreek. Dit moet deur \'n ontwikkelaar omskryf word.';
$string['restore_path_element_noobject'] = 'Herstelobjek {$a} is nie \'n objek nie.';
$string['restorechecksumfailed'] = 'Een of ander probleem het opgeduik met die herstelinligting wat in jou sessie gestoor is. Gaan asseblief die beperkings wat vir die grootte van jou PHP-geheue/DB-pakket gestel is na. Herstel gestaak.';
$string['restrictedcontextexception'] = 'Jammer, uitvoering van eksterne funksie oortree konteksbeperking.';
$string['restricteduser'] = 'Jammer, \'n inperking op jou huidige rekening "{$a}" verhoed dat jy dit kan doen';
$string['reverseproxyabused'] = 'Omgekeerde volmag aangeskakel, daarom kan toegang nie regstreeks tot die bediener verkry word nie.<br />Kontak bediener se administrateur asseblief.';
$string['rpcerror'] = 'Oeps! Jou MNET-kommunikasie het misluk! Hier is daardie foutboodskap wat jy vir jou administrateur moet aanstuur: {$a}';
$string['scheduledbackupsdisabled'] = 'Geskeduleerde rugsteuning is deur die bediener se administrateurs afgeskakel';
$string['secretalreadyused'] = 'Skakel om verandering van wagwoord te bevestig, is reeds gebruik. Wagwoord is nie verander nie.';
$string['sectionnotexist'] = 'Hierdie afdeling bestaan nie';
$string['sendmessage'] = 'Stuur boodskap';
$string['sendmessagesent'] = 'Dankie vir jou terugvoer oor:<br>{$a}';
$string['serverconnection'] = 'Kon nie met die bediener verbind nie';
$string['servicedonotexist'] = 'Die diens bestaan nie';
$string['sessioncookiesdisable'] = 'Verkeerde gebruik van require_key_login() - sessiekoekies moet afgeskakel wees!';
$string['sessiondiskfull'] = 'Die sessiepartisie is vol. Dit is nie moontlik om op hierdie tydstip aan te meld nie. Verwittig asseblief die bedieneradministrateur.';
$string['sessionerroruser'] = 'Jou sessie het verstryk. Meld asseblief weer aan.';
$string['sessionerroruser2'] = '\'n Bedienerfout wat \'n impak op jou aanmeldingsessie het, is bespeur. Meld asseblief weer aan of herbegin jou blaaier.';
$string['sessionexpired'] = 'Sessie het verstryk';
$string['sessionhandlerproblem'] = 'Sessiehanteerder verkeerd opgestel';
$string['sessionipnomatch'] = 'Jammer, jou IP-nommer het klaarblyklik verander sedert jy die eerste keer aangemeld het. Hierdie sekuriteitskenmerk verhoed dat krakers jou identiteit steel onderwyl jy by hierdie webwerf aangemeld is. Normale gebruikers behoort nie hierdie boodskap te sien nie - vra asseblief die webwerfadministrateur vir hulp.';
$string['sessionipnomatch2'] = '<p>Jammer, jou IP-nommer het klaarblyklik verander sedert jy die eerste keer aangemeld het. Hierdie sekuriteitskenmerk verhoed dat krakers jou identiteit steel onderwyl jy by hierdie webwerf aangemeld is. Jy sal dalk hierdie foutboodskap sien wanneer jy van \'n draadlose netwerk gebruik maak of tussen netwerke swerf. Vra asseblief die webwerfadministrateur vir hulp.</p><p>As jy wil voortgaan, druk asseblief die F5-sleutel om hierdie bladyse te  verfris.</p>';
$string['sessionwaiterr'] = 'Tyd het verstryk onderwyl daar of sessiesluiting gewag is.<br />Wag totdat jou huidige versoeke afgehandel is en probeer later weer.';
$string['shortnametaken'] = 'Verkorte naam word reeds vir \'n ander kursus( {$a}) gebruik';
$string['sitepolicynotagreed'] = 'Nie tot webwerfbeleid ingestem nie: <a href="{$a}">Klik hier om die webwerfbeleid oop te maak..</a>';
$string['socksnotsupported'] = 'SOCKS5-instaanbediener nie in PHP4 ondersteun nie';
$string['spellcheckernotconf'] = 'Speltoetser nie gekonfigureer nie';
$string['sslonlyaccess'] = 'Vir sekuriteit redes word net https-konneksies toegelaat, jammer.';
$string['statscatchupmode'] = 'Statistieke is tans in opvangmodus. Tot dusver is {$a->daysdone} dae verwerk en {$a->dayspending} afwagtend. Loer gou weer in!';
$string['statsdisable'] = 'Statistiek nie aangeskakel nie.';
$string['statsnodata'] = 'Daar is geen beskikbare data vir daardie kombinasie van kursus en tydperk nie';
$string['storedfilecannotcreatefile'] = 'Kan nie lêer vir plaaslike lêerpoel skep nie. Verifieer vergunnings in datastam en beskikbare skyfspasie asseblief.';
$string['storedfilecannotcreatefiledirs'] = 'Kan nie gidse vir plaaslike lêerpoel skep nie. Verifieer vergunnings in datastam asseblief.';
$string['storedfilecannotread'] = 'Kan nie lêer lees nie. Die lêer bestaan óf nie óf daar is \'n probleem met toestemming.';
$string['storedfilecannotreadfile'] = 'Kan nie lêer \'{$a}\' lees nie. Die lêer bestaan óf nie óf daar is \'n probleem met toestemming.';
$string['storedfilenotcreated'] = 'Kan nie lêer {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename} skep nie';
$string['storedfileproblem'] = 'Onbekende uitsondering verwant aan plaaslike lêers ({$a})';
$string['tagdisabled'] = 'Merkers is buite werking gestel!';
$string['tagnotfound'] = 'Die gespesifiseerde merker is nie in die databasis gevind nie';
$string['targetdatabasenotempty'] = 'Die geteikende databasis is leeg. Die oordrag is om veiligheidsredes gestaak.';
$string['textconditionsnotallowed'] = 'Vergelykings tussen tekskolomme se voorwaardes word nie toegelaat nie. Gebruik asseblief sql_compare_text() in jou navraag.';
$string['themenotinstall'] = 'Hierdie tema is nie geïnstalleer nie';
$string['tokengenerationfailed'] = 'Kan nie \'n nuwe bewys genereer nie.';
$string['transactionvoid'] = 'Transaksie kan nie nietig verklaar word nie omdat dit reeds nietig verklaar is';
$string['unenrolerror'] = '\'n Fout het opgeduik onderwyl daar gepoog is om daardie persoon se inskrywing te ontdoen';
$string['unicodeupgradeerror'] = 'Jammer, jou databasis is nie reeds in Unicode nie, en hierdie weergawe van Moodle is nie in staat om jou databasis na Unicode te migreer nie.  Gradeer asseblief eers op na Moodle 1.7.x en voer dan weer die Unicode-migrasie via die Adminbladsy uit.  Wanneer dit gedoen is, behoort jy in staat te wees om na Moodle {$a} te migreer.';
$string['unknowaction'] = 'Onbekende aksie!';
$string['unknowcategory'] = 'Kategorie nie bekend nie!';
$string['unknowcontext'] = 'Hierdie is \'n onbekende konteks ({$a}) in get_child_contexts!';
$string['unknowformat'] = 'Formaat nie bekend nie ({$a})';
$string['unknownbackupexporterror'] = 'Onbekende fout in voorbereiding van inligting vir invoer';
$string['unknownblockregion'] = 'Die blokstreek \'{$a}\' word nie op hierdie bladsy herken nie';
$string['unknowncontext'] = 'Hierdie is \'n onbekende konteks.';
$string['unknowncourse'] = 'Onbekende kursus genaamd "{$a}"';
$string['unknowncourseidnumber'] = 'Onbekende kursus-ID "{$a}"';
$string['unknowncourserequest'] = 'Onbekende kursusversoek';
$string['unknowncoursesection'] = 'Onbekende kursusafdeling in kursus "{$a}"';
$string['unknownevent'] = 'Onbekende gebeurtenis';
$string['unknownfiletype'] = 'Fout: onbekende filtertipe';
$string['unknowngroup'] = 'Onbekende groep "{$a}"';
$string['unknownhelp'] = 'Onbekende hulponderwerp {$a}';
$string['unknownjsinrequirejs'] = 'Kan JavaScript-biblioteek {$a} vind nie,';
$string['unknownmodulename'] = 'Onbekende modulenaam vir vorm';
$string['unknownrole'] = 'Onbekende rol "{$a}"';
$string['unknownsortcolumn'] = 'Onbekende sorteringskolom {$a}';
$string['unknownuseraction'] = 'Jammer, ek verstaan nie hierdie gebruikeraksie nie';
$string['unknownuserselector'] = 'Onbekende gebruikerselektor';
$string['unknoworder'] = 'Onbekende ordening';
$string['unknowparamtype'] = 'Onbekende parametertipe:  {$a}';
$string['unknowquestiontype'] = 'Vraagtipe {$a} werk nie';
$string['unknowuploadaction'] = 'Fout: Onbekende oplaai-aksie ({$a})';
$string['unspecifycourseid'] = 'Moet kursus-ID, verkorte naam of ID-nommer spesifiseer';
$string['unsupportedevent'] = 'Tipe gebeure nie ondersteun nie';
$string['unsupportedstate'] = 'Staat van voltooiing nie ondersteun nie';
$string['unsupportedwebserver'] = 'Webbediener se sagteware ({$a}) word nie ondersteun nie, jammer.';
$string['upgraderequires19'] = 'Fout: Nuwe weergawe van Moodle is op bediener geïnstalleer. Ongelukkig werk opgradering vanaf vorige weergawes nie.<br />Opgradeer asseblief eers na jongste 1.9.x-vrystelling. Jy kan ook terugkeer na vorige weergawe deur oorspronklike lêers weer te installeer.';
$string['upgraderunning'] = 'Webwerf word tans bygewerk. Probeer asseblief weer later.';
$string['urlnotdefinerss'] = 'URL nie gedefinieer vir RSS-voer nie';
$string['useradmineditadmin'] = 'Slegs administrateurs word toegelaat om ander administrateurs se rekeninge te wysig';
$string['useradminodelete'] = 'Administrateurs se rekeninge kan nie geskrap word nie.';
$string['userautherror'] = 'Onbekende inprop vir magtiging';
$string['userauthunsupported'] = 'Magtiging vir inprop word nie hier ondersteun nie';
$string['useremailduplicate'] = 'Gedupliseerde adres';
$string['usermustbemnet'] = 'Gebruikers in die MNET-toegangsbeheerlys moet afstandgebruikers van MNET wees';
$string['usernamelowercase'] = 'Die gebruikernaam moet in onderkas wees';
$string['usernotaddederror'] = 'Gebruiker nie bygevoeg nie - fout';
$string['usernotaddedregistered'] = 'Gebruiker nie bygevoeg nie - reeds geregistreer';
$string['usernotavailable'] = 'Die details van hierdie gebruiker is nie tot jou beskikking nie';
$string['usernotdeletedadmin'] = 'Gebruiker nie geskrap nie aangesien administrateurs se rekeninge nie geskrap kan word nie.';
$string['usernotdeleteddeleted'] = 'Die gebruiker is reeds geskrap';
$string['usernotdeletederror'] = 'Gebruiker nie geskrap nie - fout';
$string['usernotdeletedmissing'] = 'Gebruiker nie geskrap nie - kon nie die gebruikernaam vind nie';
$string['usernotdeletedoff'] = 'Gebruiker nie geskrap nie - skrapping word nie toegelaat nie';
$string['usernotfullysetup'] = 'Gebruiker nie ten volle opgestel nie';
$string['usernotincourse'] = 'Hierdie gebruiker is nie in hierdie kursus nie!';
$string['usernotrenamedadmin'] = 'Kan nie adminrekeninge hernoem nie';
$string['usernotrenamedexists'] = 'Gebruiker nie hernoem nie - die nuwe gebruikernaam word reeds gebruik';
$string['usernotrenamedmissing'] = 'Gebruiker nie herbenoem nie - kon nie die ou gebruikernaam vind nie';
$string['usernotrenamedoff'] = 'Gebruiker nie herbenoem nie - herbenoeming nie toegelaat nie';
$string['usernotupdatedadmin'] = 'Kan nie adminrekeninge bywerk nie';
$string['usernotupdatederror'] = 'Gebruiker nie bygewerk nie - fout';
$string['usernotupdatednotexists'] = 'Gebruiker nie bygewerk nie - bestaan nie';
$string['userquotalimit'] = 'Jy het jou lêerkwotaperk bereik';
$string['userselectortoomany'] = 'user_selector het meer as een geselekteerde gebruiker gekry, selfs al is multi-seleksie onwaar.';
$string['verifyagedigitalconsentnotpossible'] = 'Jammer, digitale verifiëring van ouderdomstoestemming is nie nou moontlik nie.';
$string['wrongcall'] = 'Die skrip is verkeerd opgeroep';
$string['wrongcontextid'] = 'Konteks-ID was verkeerd (kan dit nie vind nie)';
$string['wrongdestpath'] = 'Verkeerde bestemmingsroete';
$string['wrongroleid'] = 'Verkeerde rol-ID!';
$string['wrongsourcebase'] = 'Verkeerde bron vir URL-basis';
$string['wrongusernamepassword'] = 'Verkeerde gebruiker/wagwoord';
$string['wrongzipfilename'] = 'Verkeerde ZIP-lêernaam';
$string['wscouldnotcreateecoursenopermission'] = 'WW - Kon nie kursus skep nie - Geen toestemming nie';
$string['wwwrootmismatch'] = 'Verkeerde toegang bespeur. Toegang tot hierdie bediener mag slegs via "{$a}"-adres verkry word.<br />Verwittig bedieneradministrateur asseblief.';
$string['wwwrootslash'] = 'Verkeerde $CFG->wwwroot in config.php bespeur. Dit mag nie \'n skuinsstreep agteraan bevat nie.<br />Verwittig bedieneradministrateur asseblief.';
$string['xmldberror'] = 'XMLDB-fout!';
$string['youcannotdeletecategory'] = 'Jy kan nie kategorie \'{$a}\' skrap nie omdat jy nie die inhoud kan skrap nie en dit ook nie elders heen kan skuif nie.';
