<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'af', version '4.5'.
 *
 * @package     question
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Aksie';
$string['addanotherhint'] = 'Voeg nog \'n wenk by';
$string['addcategory'] = 'Voeg kategorie by';
$string['addmorechoiceblanks'] = 'Oop spasies vir {no} meer keuses';
$string['adminreport'] = 'Rapporteer moontilke probleme in jou vraag databasis.';
$string['advancedsearchoptions'] = 'Soekopsies';
$string['alltries'] = 'Alle probeerslae';
$string['answer'] = 'Antwoord';
$string['answers'] = 'Antwoorde';
$string['answersaved'] = 'Antwoord gestoor';
$string['attemptfinished'] = 'Poging voltooi';
$string['attemptfinishedsubmitting'] = 'Poging klaar ingedien:';
$string['attemptoptions'] = 'Poging opsies';
$string['availableq'] = 'Beskikbaar?';
$string['badbase'] = 'Slegte basis voor **: {$a}**';
$string['behaviour'] = 'Gedrag';
$string['behaviourbeingused'] = 'Gedrag wat gebruik word: {$a}';
$string['broken'] = 'Hierdie is \'n "gebreekte skakel", dit wys na \'n niebestaande lêer.';
$string['byandon'] = 'deur <em>{$a->user}</em> op <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Kon nie rugsteunlêer kopieer nie';
$string['cannotcreate'] = 'Kon nie nuwe';
$string['cannotcreatepath'] = 'Kon nie nuwe inskrywing in die vraag_pogingstabel skep nie';
$string['cannotdeletebehaviourinuse'] = 'Jy kan nie die gedrag \'{$a}\' uitvee nie. Dit word reeds gebruik deur vraagpogings.';
$string['cannotdeletecate'] = 'Jy kan nie die kategorie uitvee nie. Dit is die verstekkategorie vir hierdie konteks.';
$string['cannotdeleteneededbehaviour'] = 'Kan nie die vraaggedrag \'{$a}\' uitvee nie. Daar is ander gedrag geïnstalleer wat daarvan afhanklik is.';
$string['cannotdeleteqtypeinuse'] = 'Jy kan nie die vraagsoort uitvee nie \'{$ a}\'. Daar is vrae van hierdie soort in die vraagbank.';
$string['cannotdeleteqtypeneeded'] = 'Jy kan nie die vraagsoort uitvee nie \'{$ a}\'. Daar is ander vraagtipes geïnstalleer wat daarop staatmaak.';
$string['cannotdeletetopcat'] = 'Topkategorieë kan nie uitgevee word nie.';
$string['cannotedittopcat'] = 'Topkategorieë kan nie gewysig word nie.';
$string['cannotenable'] = 'Vraagtipe {$a} kan nie direk geskep word nie.';
$string['cannotenablebehaviour'] = 'Vraaggedrag {$a} kan nie direk gebruik word nie. Dit is slegs vir interne gebruik';
$string['cannotfindcate'] = 'Kon nie kategorierekord vind nie.';
$string['cannotfindquestionfile'] = 'Kon nie vraagdata in ziplêer vind nie';
$string['cannotgetdsfordependent'] = 'Kan nie die gespesifiseerde datastel vir \'n datastelafhanklike vraag kry nie! (vraag: {$a-> id}, datastelitem: {$a-> item})';
$string['cannotgetdsforquestion'] = 'Kan nie die gespesifiseerde datastel vir \'n berekende vraag kry nie! (vraag: {$a})';
$string['cannothidequestion'] = 'Was nie in staat om vraag te versteek nie';
$string['cannotimportformat'] = 'Jammer, invoer van hierdie formaat is nog nie geïmplementeer nie!';
$string['cannotinsertquestion'] = 'Kon nie \'n nuwe vraag invoeg nie!';
$string['cannotinsertquestioncatecontext'] = 'Kon nie nuwe vraagkategorie {$a->cat} invoeg nie. Onwettige konteksid {$a->ctx}';
$string['cannotloadquestion'] = 'Kon nie vraag laai nie';
$string['cannotmovequestion'] = 'Jy kan nie hierdie skrip gebruik om vrae met lêers wat daaraan verbonde is, uit verskillende gebiede te skuif nie.';
$string['cannotopenforwriting'] = 'Kan nie oopmaak vir skrywing nie: {$a}';
$string['cannotpreview'] = 'Jy kan nie \'n voorskou van hierdie vrae sien nie!';
$string['cannotread'] = 'Kan nie invoerlêer lees nie (of lêer is leeg)';
$string['cannotretrieveqcat'] = 'Kon nie vraagkategorie herwin nie';
$string['cannotunhidequestion'] = 'Het misluk om vraag weer sigbaar te maak';
$string['cannotunzip'] = 'Kon nie lêer ontzip nie.';
$string['cannotwriteto'] = 'Kan nie uitgevoerde vrae na {$a} skryf nie';
$string['categories'] = 'Kategorieë';
$string['category'] = 'Kategorie';
$string['categorycurrent'] = 'Huidige kategorie';
$string['categorycurrentuse'] = 'Gebruik hierdie kategorie';
$string['categorydoesnotexist'] = 'Hierdie kategorie bestaan nie';
$string['categoryinfo'] = 'Kategorie inligting';
$string['categorymove'] = 'Die kategorie \'{$a->name}\' bevat {$ a-> count} vrae (waarvan sommige verborge vrae of ewekansige vrae kan wees wat nog steeds in \'n vasvra gebruik word). Kies \'n ander kategorie om dit na te skuif.';
$string['categorymoveto'] = 'Stoor in kategorie';
$string['categorynamecantbeblank'] = 'Die kategorienaam kan nie leeg wees nie.';
$string['categorynamewithcount'] = '{$a->name} ({$a->questioncount})';
$string['categorynamewithidnumber'] = '{$a->name} [{$a->idnumber}]';
$string['categorynamewithidnumberandcount'] = '{$a->name} [{$a->idnumber}] ({$a->questioncount})';
$string['changeoptions'] = 'Verander opsies';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">Kategorie"{$a->name}"</a>in kursus "{$a->coursename}" sal se gedeelde status sal verander word vanaf {$a->changefrom} tot {$a->changeto}.';
$string['check'] = 'Toets';
$string['chooseqtypetoadd'] = 'Kies \'n vraagtipe om by te voeg';
$string['clearwrongparts'] = 'Vee verkeerde antwoorde uit';
$string['clickflag'] = 'Merk vraag';
$string['clicktoflag'] = 'Merk vraag vir toekomstige verwysing';
$string['clicktounflag'] = 'Verwyder merk';
$string['clickunflag'] = 'Verwyder merk';
$string['closepreview'] = 'Sluit voorskou';
$string['combinedfeedback'] = 'Gekombineerde terugvoer';
$string['comment'] = 'Kommentaar';
$string['commented'] = 'Kommentaar gelewer: {$a}';
$string['commentormark'] = 'Maak kommentaar of verander punt';
$string['comments'] = 'Kommentaar';
$string['commentx'] = 'Kommentaar: {$a}';
$string['complete'] = 'Voltooi';
$string['contexterror'] = 'Jy moes nie hier aangekom het as jy nie \'n kategorie na \'n ander konteks skuif nie.';
$string['copy'] = 'Verander vanaf {$a} en verander skakels.';
$string['correct'] = 'Reg';
$string['correctfeedback'] = 'Vir enige regte antwoorde';
$string['correctfeedbackdefault'] = 'Jou antwoord is reg.';
$string['created'] = 'Geskep';
$string['createdby'] = 'Geskep deur';
$string['createdmodifiedheader'] = 'Geskep / laas gestoor';
$string['createnewquestion'] = 'Skep \'n nuwe vraag ...';
$string['cwrqpfs'] = 'Ewekansige seleksie van vrae vanuit subkategorieë.';
$string['cwrqpfsinfo'] = '<p> Tydens die opgradering na Moodle 1.9 sal ons vraagkategorieë in verskillende kontekste skei. Sommige kategorieë en vrae op u webwerf moet hul deelstatus verander. Dit is nodig in die seldsame geval dat een of meer \'ewekansige\' vrae in \'n vasvra opgestel word om uit \'n mengsel van gedeelde en nie-gedeelde kategorieë te kies (soos op hierdie webwerf die geval is). Dit gebeur as \'n \'ewekansige\' vraag ingestel is om uit subkategorieë te kies en een of meer subkategorieë \'n ander deelstatus het as die ouerkategorie waarin die ewekansige vraag geskep word.</p>
<p> Die deelvraagkategorieë, waaruit \'ewekansige\' vrae in ouer kategorieë vrae kies, se deelstatus sal verander word na dieselfde deelstatus as die kategorie met die \'ewekansige\' vraag tydens die opgradering na Moodle 1.9. Die deelstatus word in die volgende kategorieë verander. Vrae wat geraak word, sal in alle bestaande vasvrae bly werk totdat u dit uit hierdie vasvrae verwyder.</p>';
$string['cwrqpfsnoprob'] = 'Geen vraagkategorieë op u webwerf word beïnvloed deur die kwessie \'Willekeurige vrae wat vrae uit subkategorieë kies nie\'.';
$string['decimalplacesingrades'] = 'Desimale plekke in punte';
$string['defaultfor'] = 'Verstek vir {$a}';
$string['defaultinfofor'] = 'Die standaardkategorie vir vrae wat in die konteks \'{$a}\' gedeel word.';
$string['defaultmark'] = 'Verstekpunt';
$string['defaultmarkmustbepositive'] = 'Die verstekpunt moet positief wees';
$string['deletecoursecategorywithquestions'] = 'Daar is vrae in die vraebank wat verband hou met hierdie kursuskategorie. As jy voortgaan, sal hulle verwyder word. Jy kan dit eers skuif met behulp van die vraagbankpaneelbord.';
$string['deletequestioncheck'] = 'Is jy doodseker jy wil \'{$a}\' uitvee?';
$string['deletequestionscheck'] = 'Is jy doodseker jy wil volgende vrae uitvee?<br /><br />{$a}';
$string['deletingbehaviour'] = 'Vee vraaggedrag uit \'{$a}\'';
$string['deletingqtype'] = 'Vee vraagtipe uit \'{$a}\'';
$string['didnotmatchanyanswer'] = '[Pas nie by enige antwoord nie]';
$string['disabled'] = 'Deaktiveer';
$string['displayoptions'] = 'Vertoonopsies';
$string['disterror'] = 'Die verspreiding {$a} het probleme veroorsaak';
$string['donothing'] = 'Moenie lêers verander of skuif of skakels verander nie.';
$string['editcategories'] = 'Wysig kategorie';
$string['editcategories_help'] = 'In stede daarvan om alles in een groot lys te hou, kan vrae in kategorieë en subkategorieë gerangskik word.

Elke kategorie het \'n konteks wat bepaal waar die vrae in die kategorie gebruik kan word:

* Aktiwiteitskonteks - vrae slegs beskikbaar in die aktiwiteitsmodule
* Kursuskonteks - vrae beskikbaar in alle aktiwiteitsmodules in die kursus
* Kursuskategoriekonteks - vrae beskikbaar in almal aktiwiteitsmodules en kursusse in die kursuskategorie
* Stelselkonteks - Vrae beskikbaar in alle kursusse en aktiwiteite op die webwerf

Kategorieë word ook gebruik vir ewekansige vrae, aangesien vrae uit \'n spesifieke kategorie gekies word.';
$string['editcategories_link'] = 'question/category';
$string['editcategory'] = 'Wysig kategorie';
$string['editingcategory'] = 'Wysiging van \'n kategorie';
$string['editingquestion'] = 'Wysiging van \'n vraag';
$string['editquestion'] = 'Wysig vraag';
$string['editquestions'] = 'Wysig vrae';
$string['editthiscategory'] = 'Wysig hierdie kategorie';
$string['emptyxml'] = 'Onbekende fout - leë imsmanifest.xml';
$string['enabled'] = 'Aktiveer';
$string['erroraccessingcontext'] = 'Kan nie toegang tot konteks verky nie';
$string['errordeletingquestionsfromcategory'] = 'Fout het plaasgevind tydens uitwissing van vrae uit hierdie kategorie {$a}.';
$string['errorduringpost'] = 'Fout het plaasgevind tydens post-verwerking!';
$string['errorduringpre'] = 'Fout het plaasgevind tydens vooraf-verwerking!';
$string['errorduringproc'] = 'Fout het plaasgevind tydens verwerking!';
$string['errorduringregrade'] = 'Kon nie vraag {$a->qid} hermerk nie, gaan na status {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Fout: kan nie lêer {$a} kopieer nie.';
$string['errorfilecannotbemoved'] = 'Fout: kan nie lêer {$a} skuif nie.';
$string['errorfileschanged'] = 'Fout: lêers waaraan vrae gekoppel is, het verander sedert die vorm vertoon is.';
$string['erroritemappearsmorethanoncewithdifferentweight'] = 'Die vraag ({$a}) verskyn meer as een keer met verskillende gewigte in verskillende posisies van die toets. Dit word tans nie deur die statistiekverslag ondersteun nie en kan die statistieke vir hierdie vraag onbetroubaar maak.';
$string['errormanualgradeoutofrange'] = 'Die punt {$a->grade} is nie tussen 0 en {$a->maxgrade} vir vraag {$a->name} nie. Die telling en kommentaar is nie gestoor nie.';
$string['errormovingquestions'] = 'Fout terwyl vrae met ids {$a} geskuif word.';
$string['errorpostprocess'] = 'Fout het plaasgevind tydens post-verwerking!';
$string['errorpreprocess'] = 'Fout het plaasgevind tydens vooraf-verwerking!';
$string['errorprocess'] = 'Fout het plaasgevind tydens verwerking!';
$string['errorprocessingresponses'] = '\'n Fout het voorgekom tydens die verwerking van jou antwoorde ({$ a}). Klik op Gaan voort om terug te keer na die bladsy waarop jy was en probeer weer.';
$string['errorsavingcomment'] = '\'n Fout het plaasgevind tydens die storing van vraag {$a->name} in die databasis.';
$string['errorsavingflags'] = 'Fout tydens storing van vlagstatus.';
$string['errorupdatingattempt'] = 'Fout tydens opdatering van poging {$a->id} in die databasis.';
$string['eventquestioncategorycreated'] = 'Vraagkategorie geskep';
$string['eventquestioncategorydeleted'] = 'Vraagkategorie uitgevee';
$string['eventquestioncategorymoved'] = 'Vraagkategorie geskuif';
$string['eventquestioncategoryupdated'] = 'Vraagkategorie opdateer';
$string['eventquestioncategoryviewed'] = 'Vraagkategorie beskou';
$string['eventquestioncreated'] = 'Vraag geskep';
$string['eventquestiondeleted'] = 'Vraag uitgevee';
$string['eventquestionmoved'] = 'Vraag geskuif';
$string['eventquestionsexported'] = 'Vraag uitgevoer';
$string['eventquestionsimported'] = 'Vraag ingevoer';
$string['eventquestionupdated'] = 'Vraag opdateer';
$string['eventquestionviewed'] = 'Vraag beskou';
$string['export'] = 'Uitvoer';
$string['exportasxml'] = 'Voer uit as Moodle XML';
$string['exportcategory'] = 'Uitvoer kategorie';
$string['exportcategory_help'] = 'Hierdie instelling bepaal die kategorie waaruit die uitgevoerde vrae geneem sal word.

Sekere invoerformate, soos GIFT en Moodle XML, laat toe dat kategorie- en konteksdata in die uitvoerlêer opgeneem word, wat dit moontlik maak om (opsioneel) by invoer weer te skep. Indien nodig, moet die toepaslike regmerkies aangeskakel word.';
$string['exporterror'] = 'Foute het plaasgevind tydens uitvoering!';
$string['exportfilename'] = 'vrae';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportonequestion'] = 'Laai hierdie vraag in Moodle XML formaat af';
$string['exportquestions'] = 'Voer vrae na lêer uit';
$string['exportquestions_help'] = 'Met hierdie funksie kan jy \'n volledige kategorie (en enige subkategorieë) se vrae uitvoer. Let daarop dat, afhangende van die gekose lêerformaat, sekere vrae en sekere vraagtipes nie uitgevoer kan word nie.';
$string['exportquestions_link'] = 'question/export';
$string['feedback'] = 'Terugvoer';
$string['filecantmovefrom'] = 'Die vrae-lêers kan nie geskuif word nie omdat jy nie toestemming het om lêers te verwyder van die plek waarheen jy vrae wil skuif nie.';
$string['filecantmoveto'] = 'Die vrae-lêers kan nie geskuif word nie omdat jy nie toestemming het om lêers by te voeg by die plek waarheen jy hul wil skuif nie.';
$string['fileformat'] = 'Lêerformaat';
$string['filesareacourse'] = 'die kursuslêer area';
$string['filesareasite'] = 'die webbladlêers area';
$string['filestomove'] = 'Skuif / kopieer lêer na {$a}?';
$string['fillincorrect'] = 'Vul die regte antwoorde in';
$string['filterbytags'] = 'Filter met merkers...';
$string['firsttry'] = 'Eerste probeerslag';
$string['flagged'] = 'Gemerk';
$string['flagthisquestion'] = 'Merk hierdie vraag';
$string['formquestionnotinids'] = 'Vorm bevat vrae wat nie in vraagids is nie';
$string['fractionsnomax'] = 'Een van die antwoorde moet \'n telling van 100% hê, dus is dit moontlik om die volledige punte vir hierdie vraag te behaal.';
$string['generalfeedback'] = 'Algemene terugvoer';
$string['generalfeedback_help'] = 'Algemene terugvoer word aan die student gewys nadat die vraag voltooi is. Anders as met spesifieke terugvoer, wat afhang van die vraagtipe en watter antwoord die student gegee het, word dieselfde algemene terugvoerteks aan alle studente vertoon.

Jy kan die algemene terugvoer gebruik om studente \'n volledig uitgewerkte antwoord te gee en miskien \'n skakel na meer inligting wat hulle kan gebruik as hulle nie die vrae verstaan nie.';
$string['getcategoryfromfile'] = 'Verkry kategorie vanaf lêer';
$string['getcontextfromfile'] = 'Verkry konteks vanaf lêer';
$string['hintn'] = 'Wenk {no}';
$string['hintnoptions'] = 'Wenk {no} opsies';
$string['hinttext'] = 'Wenkteks';
$string['howquestionsbehave'] = 'Hoe vrae hul gedra';
$string['howquestionsbehave_help'] = 'Studente kan op verskillende maniere met die vrae in die vasvra omgaan. Jy kan byvoorbeeld die studente versoek om \'n antwoord op elke vraag in te voer en dan die hele vasvra in te dien voordat daar nagesien word of terugvoer ontvang word. Dit sou die \'Uitgestelde terugvoer\'-modus wees.

Andersins, wil jy dalk hê dat studente elke vraag moet indien terwyl hulle voortgaan om dadelik terugvoer te kry, en as hulle dit nie dadelik regkry nie, dit weer probeer vir minder punte. Dit sou die modus \'Interaktief met verskeie probeerslae\' wees.

Dit is waarskynlik die twee mees algemene gebruikte gedragswyses.';
$string['howquestionsbehave_link'] = 'question/behaviour';
$string['idnumber'] = 'ID nommer';
$string['idnumber_help'] = 'As dit gebruik word, moet die ID-nommer binne elke vraagkategorie uniek wees. Dit bied \'n ander manier om \'n vraag te identifiseer wat soms nuttig is, maar wat gewoonlik leeg gelaat kan word.';
$string['ignorebroken'] = 'Ignoreer gebreekte skakels';
$string['import'] = 'Invoer';
$string['importcategory'] = 'Invoer kategorie';
$string['importcategory_help'] = 'Hierdie instelling bepaal die kategorie waarin die ingevoerde vrae gaan.

Sekere invoerformate, soos GIFT en Moodle XML, kan kategorie- en konteksdata in die invoerlêer insluit. Om van hierdie data gebruik te maak, eerder as die geselekteerde kategorie, moet die toepaslike regmerkies gemerk word. As daar nie kategorieë in die invoerlêer bestaan nie, sal dit geskep word.';
$string['importerror'] = '\'n Fout het plaasgevind tydens invoerverwerking';
$string['importerrorquestion'] = 'Fout tydens invoer van vraag';
$string['importfromcoursefiles'] = '... of kies \'n kursuslêer om in te voer.';
$string['importfromupload'] = 'Kies \'n lêer om op te laai ...';
$string['importingquestions'] = 'Invoering van {$a} vrae vanaf lêer';
$string['importparseerror'] = 'Fout(e) gevind tydens ontleding van die invoerlêer. Geen vrae is ingevoer nie. Probeer weer om goeie vrae in te voer en stel \'Stop by fout\' op \'Nee\'.';
$string['importquestions'] = 'Voer vrae vanaf lêer in';
$string['importquestions_help'] = 'Met hierdie funksie kan vrae in verskillende formate via \'n tekslêer ingevoer word. Let daarop dat die lêer UTF-8-kodering moet gebruik.';
$string['importquestions_link'] = 'question/import';
$string['importwrongfiletype'] = 'Die lêertipe wat jy gekies het ({$a->actualtype}) pas nie by die verwagte tipe by hierdie invoerformaat nie ({$a->expectedtype}).';
$string['impossiblechar'] = 'Onmoontlike karakter {$a} bespeur as hakkieskarakter';
$string['includesubcategories'] = 'Wys ook vrae vanaf subkategorieë';
$string['incorrect'] = 'Verkeerd';
$string['incorrectfeedback'] = 'Vir enige verkeerde antwoord';
$string['incorrectfeedbackdefault'] = 'Jou antwoord is verkeerd';
$string['information'] = 'Informasie';
$string['invalidanswer'] = 'Onvolledige antwoord';
$string['invalidarg'] = 'Geen geldige argumente verskaf of verkeerde bediener instelling';
$string['invalidcategoryidforparent'] = 'Ongeldige kategorie id vir ouerkategorie!';
$string['invalidcategoryidtomove'] = 'Ongeldige kategorie id om te skuif!';
$string['invalidconfirm'] = 'Bevestiging string was verkeerd';
$string['invalidcontextinhasanyquestions'] = 'Ongeldige konteks oorgedra aan question_context_has_any_questions.';
$string['invalidgrade'] = 'Punte ({$a}) pas nie by merkopsies nie - vraag oorgeslaan.';
$string['invalidpenalty'] = 'Ongeldige strafpunt';
$string['invalidwizardpage'] = 'Verkeerde of geen towerbladsy gevind nie!';
$string['lastmodifiedby'] = 'Laaste gewysig deur';
$string['lasttry'] = 'Laaste probeerslag';
$string['linkedfiledoesntexist'] = 'Gekoppelde lêer {$a} bestaan nie';
$string['makechildof'] = 'Maak \'n kind van \'{$a}\'';
$string['makecopy'] = 'Maak duplikaat';
$string['maketoplevelitem'] = 'Skuif na topvlak';
$string['manualgradeinvalidformat'] = 'Dit is nie \'n geldige syfer nie.';
$string['manualgradeoutofrange'] = 'Die punt is buite die geldige reeks.';
$string['manuallygraded'] = 'Handmatig gemerk {$a->mark} met kommentaar: {$a->comment}';
$string['mark'] = 'Punt';
$string['markedoutof'] = 'Gemerk uit';
$string['markedoutofmax'] = 'Gemerk uit {$a}';
$string['markoutofmax'] = 'Punt {$a->mark} uit {$a->max}';
$string['marks'] = 'Punte';
$string['matchgrades'] = 'Vergelyk punte';
$string['matchgrades_help'] = 'Ingevoerde punte moet ooreenstem met \'n vaste lys van geldige punte - 100, 90, 80, 75, 70, 66.666, 60, 50, 40, 33.333, 30, 25, 20, 16.666, 14.2857, 12.5, 11.111, 10, 5 , 0 (asook negatiewe waardes). Indien nie, is daar twee opsies:

* Fout as punt nie gelys word nie - As \'n vraag enige punte bevat wat nie in die lys voorkom nie, word \'n fout vertoon en die vraag sal nie ingevoer word nie
* Naaste punt indien nie gelys nie - As \'n punt gevind word wat nie ooreen stem met \'n waarde in die lys nie, word die punt verander na die naaste ooreenstemmende waarde in die lys';
$string['matchgradeserror'] = 'Fout indien punt nie gelys is nie';
$string['matchgradesnearest'] = 'Naaste punt is nie gelys nie';
$string['missingcourseorcmid'] = 'Nodig om kursusid of cmid te voorsien om te print_question.';
$string['missingcourseorcmidtolink'] = 'Nodig om kursusid of cmid te voorsien om get_question_edit_link te verkry.';
$string['missingimportantcode'] = 'Hierdie vraagtipe vermis \'n belangrike stuk kode: {$a}.';
$string['missingoption'] = 'Die geslote vraag {$a} vermis sy opsies';
$string['modified'] = 'Laaste gestoor';
$string['move'] = 'Skuif vanaf {$a} en verander skakels.';
$string['movecategory'] = 'Skuif kategorie';
$string['movedquestionsandcategories'] = 'Vrae en vraagkategorieë geskuif vanaf {$a->oldplace} na {$a->newplace}.';
$string['movelinksonly'] = 'Verander net na waarheen skakels wys, moenie lêers skuif of kopieer nie.';
$string['moveq'] = 'Skuif vraag/vrae';
$string['moveqtoanothercontext'] = 'Skuif vrae na \'n ander konteks.';
$string['moveto'] = 'Skuif na>>';
$string['movingcategory'] = 'Skuif kategorie';
$string['movingcategoryandfiles'] = 'Is jy seker dat jy kategorie {$a->name} en al die afhanklike kategorieë vir "{$a->contextto}" wil skuif?<br /> Ons het {$a->urlcount} lêers opgetel vanaf gekoppelde lêers vrae in {$a->fromareaname}, wil jy hierdie kopieer of skuif na {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Is jy seker jy wil kategorie "{$a->name}" en alle afhanklike kategorieë na konteks "{$a->contextto}" skuif?';
$string['movingquestions'] = 'Besig om vrae en enige lêers te skuif';
$string['movingquestionsandfiles'] = 'Is jy seker jy wil vrae {$a->questions} na konteks <strong>"{$a->tocontext}"</strong> skuif?<br /> Ons het <strong>{$a->urlcount}lêers</strong> gekoppel aan hierdie vrae {$a->fromareaname}opgetel, wil jy dit kopieer of skuif na {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Is jy seker jy wil vraag/vrae {$a->questions} na konteks <strong>"{$a->tocontext}"</strong> skuif?<br /> Daar is <strong>geen lêers</strong> gekoppel aan hierdie vrae in {$a->fromareaname} nie.';
$string['needtochoosecat'] = 'Jy moet \'n kategorie kies waarheen hierdie vrae geskuif moet word, of \'kanselleer\' druk.';
$string['nocate'] = 'Geen so \'n kategorie nie {$a}!';
$string['nopermissionadd'] = 'Jy het nie toestemming om vrae hier by te voeg nie.';
$string['noprobs'] = 'Geen probleme is gevind in jou vraagdatabasis nie.';
$string['noquestions'] = 'Geen vrae is gevind wat uitgevoer kon word nie. Maak seker dat jy \'n kategorie gekies het om uit te voer wat vrae bevat.';
$string['noquestionsinfile'] = 'Daar is geen vrae in die invoerlêer nie';
$string['noresponse'] = '[geen antwoord]';
$string['notagfiltersapplied'] = 'Geen merkfilters toegepas nie';
$string['notanswered'] = 'Onbeantwoord';
$string['notchanged'] = 'Onveranderd sedert laaste poging';
$string['notenoughanswers'] = 'Hierdie tipe vraag vereis ten minste {$a) antwoorde';
$string['notenoughdatatoeditaquestion'] = 'Nie \'n vraag id, of \'n kategorie id of \'n vraagtipe, is gespesifiseerd nie.';
$string['notenoughdatatomovequestions'] = 'Jy moet die vraag id\'s van die vrae wat jy wil skuif verskaf.';
$string['notgraded'] = 'Nie nagesien nie';
$string['notshown'] = 'Wys nie';
$string['notyetanswered'] = 'Onbeantwoord';
$string['notyourpreview'] = 'Hierdie voorskou behoort nie aan jou nie';
$string['novirtualquestiontype'] = 'Geen virtuele vraagtipe vir vraagtipe {$a}';
$string['numqas'] = 'Nr. vraag pogings';
$string['numquestions'] = 'Nr. vrae';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} versteek)';
$string['options'] = 'Opsies';
$string['page-question-category'] = 'Vraagkategoriebladsy';
$string['page-question-edit'] = 'Vraagredigeringbladsy';
$string['page-question-export'] = 'Vraaguitvoerbladsy';
$string['page-question-import'] = 'Vraaginvoerbladsy';
$string['page-question-x'] = 'Enige vraag bladsy';
$string['parent'] = 'Ouer';
$string['parentcategory'] = 'Ouer kategorie';
$string['parentcategory_help'] = 'Die ouerkategorie is die kategorie waarin die nuwe kategorie geplaas sal word. "Bo" beteken dat hierdie kategorie nie in enige ander kategorie vervat is nie. Kategoriekontekste word in vetdruk getoon. Daar moet ten minste een kategorie in elke konteks wees.';
$string['parentcategory_link'] = 'question/category';
$string['parenthesisinproperclose'] = 'Parentese voor ** is nie behoorlik ingesluit in {$a}** nie';
$string['parenthesisinproperstart'] = 'Parentese voor ** is nie behoorlik begin in {$a}** nie';
$string['parsingquestions'] = 'Ontleed vrae vanaf invoerlêer.';
$string['partiallycorrect'] = 'Gedeeltelik korrek';
$string['partiallycorrectfeedback'] = 'Vir enige gedeeltelik korrekte antwoord';
$string['partiallycorrectfeedbackdefault'] = 'Jou antwoord is gedeeltelik reg.';
$string['penaltyfactor'] = 'Strafmaatreël';
$string['penaltyfactor_help'] = 'Hierdie instelling bepaal watter breukdeel van die behaalde telling vir elke verkeerde reaksie afgetrek word. Dit is slegs van toepassing as die vasvra in die aanpasbare modus uitgevoer word. Die straffaktor moet \'n getal tussen 0 en 1 wees. \'n Straffaktor van 1 beteken dat die student in sy eerste antwoord die antwoord moet regkry om enigsins krediet daarvoor te kry. Met \'n straffaktor van 0 kan die student so gereeld probeer as wat hy wil en steeds die volle punte behaal.';
$string['penaltyforeachincorrecttry'] = 'Strafpunt vir elke foutiewe probeerslag';
$string['penaltyforeachincorrecttry_help'] = 'Wanneer vrae uitgevoer word met die gedrag \'Interaktief met veelvuldige probeerslae\' of \'Aanpasbare modus\', sodat die student verskeie pogings sal hê om die vraag reg te kry, dan bepaal hierdie opsie hoeveel hulle gestraf word vir elke verkeerde probeerslag.

Die straf is \'n deel van die totale vraagsyfer, dus as die vraag drie punte werd is en die straf 0,333333 is, sal die student 3 behaal as hy die eerste keer die vraag regkry, 2 as hy die tweede keer reg kry, en 1 van hulle kry dit reg met die derde probeerslag.

Vir sommige vrae uit meerdere dele word hierdie puntelogika afsonderlik toegepas op elke deel van die vraag. Die besonderhede hang af van die vraestel en kan ingewikkeld wees, maar die beginsel is om studente so eerlik moontlik krediet te gee vir die kennis wat hulle getoon het.';
$string['permissionedit'] = 'Wysig hierdie vraag';
$string['permissionmove'] = 'Skuif hierdie vraag';
$string['permissionsaveasnew'] = 'Stoor dit as \'n nuwe vraag';
$string['permissionto'] = 'Jy het toestemming om :';
$string['previewquestion'] = 'Voorskou vraag: {$a}';
$string['privacy:metadata:database:question'] = 'Besonderhede oor \'n spesifieke vraag';
$string['privacy:metadata:database:question:createdby'] = 'Die persoon wat die vraag geskep het';
$string['privacy:metadata:database:question:generalfeedback'] = 'Die algemene terugvoer vir hierdie vraag';
$string['privacy:metadata:database:question:modifiedby'] = 'Die persoon wat laaste hierdie vraag opdateer het.';
$string['privacy:metadata:database:question:name'] = 'Die naam van die vraag.';
$string['privacy:metadata:database:question:questiontext'] = 'Die vraagteks.';
$string['privacy:metadata:database:question:timecreated'] = 'Die datum en tyd toe hierdie vraag geskep was.';
$string['privacy:metadata:database:question:timemodified'] = 'Die datum en tyd toe hierdie vraag opdateer was.';
$string['privacy:metadata:database:question_attempt_step_data'] = 'Vraagpogings kan additionele data spesifiek tot daardie stap hê. Die data word gestoor in step_data table.';
$string['privacy:metadata:database:question_attempt_step_data:name'] = 'Die naam van die data-item';
$string['privacy:metadata:database:question_attempt_step_data:value'] = 'Die waarde van die data-item';
$string['privacy:metadata:database:question_attempt_steps'] = 'Elke vraagpoging het \'n aantal stappe om die verskillende fases aan te dui van begin tot voltooiing tot nasiening. Hierdie tabel stoor die inligting vir elk van hierdie stappe.';
$string['privacy:metadata:database:question_attempt_steps:fraction'] = 'Die punt wat aan hierdie vraagpoging toegeken is, is afgeskaal tot \'n waarde uit 1.';
$string['privacy:metadata:database:question_attempt_steps:state'] = 'Die status van hierdie vraagpoging aan die einde van die stapoorgang.';
$string['privacy:metadata:database:question_attempt_steps:timecreated'] = 'Die datum en tyd wanneer hierdie trapsgewyse oorgang begin het.';
$string['privacy:metadata:database:question_attempt_steps:userid'] = 'Die gebruiker wat die trapsgewyse oorgang uitgevoer het.';
$string['privacy:metadata:database:question_attempts'] = 'Die informasie oor \'n poging van \'n spesifieke vraag.';
$string['privacy:metadata:database:question_attempts:flagged'] = '\'n Aanduiding dat die gebruiker die vraag binne die poging gemerk het.';
$string['privacy:metadata:database:question_attempts:responsesummary'] = '\'n Opsomming van die vraagantwoord.';
$string['privacy:metadata:database:question_attempts:timemodified'] = 'Die tyd wanneer die vraagpoging opdateer was.';
$string['privacy:metadata:link:qbehaviour'] = 'Die Vraag subsisteem maak gebruik van die Vraag Gedrag inproptipe.';
$string['privacy:metadata:link:qformat'] = 'Die Vraag Subsisteem maak gebruik van die Vraag Formaat inproptipe vir die doel om vrae in verskillende formate in te voer.';
$string['privacy:metadata:link:qtype'] = 'Die Vraag substelsel is in wisselwerking met die invoegtipe Vraagtipe wat die verskillende soorte vrae bevat.';
$string['published'] = 'gedeel';
$string['qtypeveryshort'] = 'T';
$string['questionaffected'] = '<a href="{$a->qurl}">Vraag "{$a->name}" ({$a->qtype})</a> is in die vraagkategorie, maar word ook gebruik in<a href="{$a->qurl}">vasvra "{$a->quizname}"</a> in \'n ander kursus "{$a->coursename}".';
$string['questionbank'] = 'Vraag bank';
$string['questionbehaviouradminsetting'] = 'Vraaggedragsinstellings';
$string['questionbehavioursdisabled'] = 'Vraaggedragsinstellings om te deaktiveer';
$string['questionbehavioursdisabledexplained'] = 'Voer \'n komma-geskeide lys in met gedrag wat jy nie wil hê nie, in die vervolgkeuse.';
$string['questionbehavioursorder'] = 'Vraaggedragsinstellings orde';
$string['questionbehavioursorderexplained'] = 'Voer \'n komma-geskeide lys gedrag in in die volgorde waarin u dit in die keuselys wil laat verskyn.';
$string['questioncategories'] = 'Vraagkategorieë';
$string['questioncategory'] = 'Vraagkategorie';
$string['questioncatsfor'] = 'Vraagkategorie vir \'{$a}\'';
$string['questiondoesnotexist'] = 'Die vraag bestaan nie';
$string['questionformtagheader'] = '{$a} merkers';
$string['questionidmismatch'] = 'Vraag ids pas nie';
$string['questionname'] = 'Vraagnaam';
$string['questionnamecopy'] = '{$a} (duplikaat)';
$string['questionno'] = 'Vraag {$a}';
$string['questionpreviewdefaults'] = 'Standaardvoorkeure vir vrae';
$string['questionpreviewdefaults_desc'] = 'Hierdie verstekwaardes word gebruik wanneer \'n gebruiker die eerste keer \'n voorskou in die vraagbank sien. Sodra \'n gebruiker \'n voorbeeld van \'n vraag gesien het, word hul persoonlike voorkeure gestoor as gebruikersvoorkeure.';
$string['questions'] = 'Vrae';
$string['questionsaveerror'] = 'Foute kom voor tydens storing van vraag - ({$a})';
$string['questionsinuse'] = '(* Vrae gemerk met \'n sterretjie word êrens gebruik, byvoorbeeld in \'n vasvra. As jy voortgaan, sal hierdie vrae nie regtig uitgevee word nie, maar net weggesteek word.)';
$string['questionsmovedto'] = 'Vrae wat nog gebruik word, is in die ouerkursuskategorie na "{$a}" geskuif.';
$string['questionsrescuedfrom'] = 'Vrae gestoor vanaf konteks {$a}';
$string['questionsrescuedfrominfo'] = 'Hierdie vrae (waarvan sommige dalk weggesteek is) is gestoor toe konteks {$a} verwyder is omdat dit steeds deur sommige vasvrae of ander aktiwiteite gebruik word.';
$string['questiontags'] = 'Vraagmerkers';
$string['questiontext'] = 'Vraagteks';
$string['questiontype'] = 'Vraagtipe';
$string['questionuse'] = 'Gebruik vrae in hierdie aktiwiteit';
$string['questionvariant'] = 'Variantvraag';
$string['questionx'] = 'Vraag {$a}';
$string['requiresgrading'] = 'Vereis nasiening';
$string['responsehistory'] = 'Antwoord geskiedenis';
$string['restart'] = 'Begin weer';
$string['restartwiththeseoptions'] = 'Begin weer met hierdie opsies';
$string['restoremultipletopcats'] = 'Die rugsteunlêer bevat meer as een vraagvlakkategorieë op die hoogste vlak vir konteks {$a}.';
$string['reviewresponse'] = 'Hersien antwoord';
$string['rightanswer'] = 'Regte antwoord';
$string['rightanswer_help'] = '\'n Outomaties gegenereerde opsomming van die korrekte antwoord. Dit kan beperk word, dus oorweeg dit om die korrekte oplossing in die algemene terugvoer vir die vraag te verduidelik en hierdie opsie uit te skakel.';
$string['save'] = 'Stoor';
$string['savechangesandcontinueediting'] = 'Stoor veranderinge en gaan voort met redigering';
$string['saved'] = 'Gestoor: {$a}';
$string['saveflags'] = 'Stoor die status van die vlae';
$string['selectacategory'] = 'Kies \'n kategorie:';
$string['selectaqtypefordescription'] = 'Kies \'n vraagtipe om sy beskrywing te sien';
$string['selectcategoryabove'] = 'Kies \'n kategorie hierbo';
$string['selectquestionsforbulk'] = 'Kies vrae vir grootmaataksies';
$string['settingsformultipletries'] = 'Verskeie probeerslae';
$string['shareincontext'] = 'Deel in konteks vir {$a}';
$string['showhidden'] = 'Wys ook ou vrae';
$string['showmarkandmax'] = 'Wys punt en maksimum';
$string['showmaxmarkonly'] = 'Wys net maksimum punt';
$string['shown'] = 'Gewys';
$string['shownumpartscorrect'] = 'Wys die aantal regte antwoorde';
$string['shownumpartscorrectwhenfinished'] = 'Wys die aantal regte antwoorde sodra die vraag klaar is';
$string['showquestiontext'] = 'Wys vraagteks in die vraaglys';
$string['specificfeedback'] = 'Spesifieke terugvoer';
$string['specificfeedback_help'] = 'Terugvoer wat afhang van die antwoord wat \'n student gee.';
$string['started'] = 'Het begin';
$string['state'] = 'Status';
$string['step'] = 'Trap';
$string['steps'] = 'Trappe';
$string['stoponerror'] = 'Stop met fout';
$string['stoponerror_help'] = 'Hierdie instelling bepaal of die invoerproses stop wanneer \'n fout opgespoor word, wat veroorsaak dat geen vrae ingevoer word nie, en of vrae wat foute bevat geïgnoreer word en dat geldige vrae ingevoer word.';
$string['submissionoutofsequence'] = 'Toegang buite volgorde. Moenie op die terugknoppie klik as u aan vasvra-vrae werk nie.';
$string['submissionoutofsequencefriendlymessage'] = 'Jy het data buite die normale volgorde ingevoer. Dit kan voorkom as jy die knoppies Terug of vorentoe van jou blaaier gebruik; moet dit asseblief nie tydens die toets gebruik nie. Dit kan ook gebeur as jy op iets klik terwyl \'n bladsy laai. Klik op <strong> Gaan voort </strong> om voort te gaan.';
$string['submit'] = 'Handig in';
$string['submitandfinish'] = 'Handig in en maak klaar';
$string['submitted'] = 'Handig in: {$a}';
$string['tagarea_question'] = 'Vrae';
$string['technicalinfo'] = 'Tegniese informasie';
$string['technicalinfo_help'] = 'Hierdie tegniese inligting is waarskynlik net nuttig vir ontwikkelaars wat aan nuwe vrae werk. Dit kan ook nuttig wees om probleme met vrae te diagnoseer.';
$string['technicalinfomaxfraction'] = 'Maksimum breuk: {$a}';
$string['technicalinfominfraction'] = 'Minimum breuk: {$a}';
$string['technicalinfoquestionsummary'] = 'Vraag opsomming: {$a}';
$string['technicalinforesponsesummary'] = 'Antwoord opsomming: {$a}';
$string['technicalinforightsummary'] = 'Regte antwoord opsomming: {$a}';
$string['technicalinfostate'] = 'Vraagstatus: {$a}';
$string['technicalinfovariant'] = 'Variantvraag: {$a}';
$string['tofilecategory'] = 'Skryf kategorie na lêer';
$string['tofilecontext'] = 'Skryf konteks na lêer';
$string['topfor'] = 'Boonste vlak vir {$a}';
$string['uninstallbehaviour'] = 'Verwyder hierdie vraaggedrag.';
$string['uninstallqtype'] = 'Verwyder hierdie vraagtipe.';
$string['unknown'] = 'Onbekend';
$string['unknownbehaviour'] = 'Onbekende gedrag: {$a}';
$string['unknownorunhandledtype'] = 'Onbekende of onafgehandelde vraagtipe: {$a}';
$string['unknownquestion'] = 'Onbekende vraag: {$a}.';
$string['unknownquestioncatregory'] = 'Onbekende vraagkategorie: {$a}.';
$string['unknownquestiontype'] = 'Onbekende vraagtipe: {$a}';
$string['unknowntolerance'] = 'Onbekende toleransietipe {$a}';
$string['unpublished'] = 'ongedeel';
$string['unusedcategorydeleted'] = 'Hierdie kategorie is uitgevee omdat die vrae nie meer gebruik is nadat die kursus verwyder is nie.';
$string['updatedisplayoptions'] = 'Dateer vertoonopsies op';
$string['upgradeproblemcategoryloop'] = 'Probleem bespeur tydens die opgradering van vraagkategorieë. Daar is \'n lus in die kategorieboom. Die geaffekteerde kategorie-ID\'s is {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Kon nie vraagkategorie {$a->name} ({$a->id}) opdateer nie.';
$string['upgradeproblemunknowncategory'] = 'Probleem bespeur tydens die opgradering van vraagkategorieë. Kategorie {$a->id} verwys na ouer {$a->parent}, wat nie bestaan nie. Ouer verander om probleem op te los.';
$string['whethercorrect'] = 'Of dit reg is';
$string['whethercorrect_help'] = 'Dit dek sowel die teksbeskrywing \'Reg\', \'Gedeeltelik reg\' of \'Verkeerd\', en enige gekleurde beklemtooning wat dieselfde inligting oordra.';
$string['whichtries'] = 'Wat probeer is';
$string['withselected'] = 'Met verkose';
$string['wrongprefix'] = 'Verkeerde geformateerde naamvoegsel {$a}';
$string['xoutofmax'] = '{$a->mark} uit {$a->max}';
$string['yougotnright'] = 'Jy het regmatig {$a->num} verkies.';
$string['youmustselectaqtype'] = 'Jy moet \'n vraagtipe kies';
$string['yourfileshoulddownload'] = 'Jou uitvoerlêer moet begin om binnekort af te laai. Indien nie, <a href="{$a}">klik hier</a>.';
