<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_configurable_reports', language 'pl', version '4.5'.
 *
 * @package     block_configurable_reports
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitypost'] = 'Wyświetlenia aktywności';
$string['activityview'] = 'Wykonane aktywności';
$string['addreport'] = 'Dodaj raport';
$string['anyone'] = 'Każdy użytkownik';
$string['anyone_summary'] = 'Każdy użytkownik serwisu będzie mógł wyświetlić ten raport';
$string['availablemarks'] = 'Dostępne znaczniki';
$string['average'] = 'Średnia';
$string['badconditionexpr'] = 'Nieprawidłowe wyrażenie logiczne';
$string['badsize'] = 'Nieprawidłowy rozmiar, musi być podany w % lub px';
$string['badtablewidth'] = 'Nieprawidłowa szerokość, musi być podana w % lub wartości bezwzględnej';
$string['bar'] = 'Wykres słupkowy';
$string['barsummary'] = 'Wykres słupkowy';
$string['blockname'] = 'Konfigurowalne raporty';
$string['calcs'] = 'Obliczenia';
$string['categories'] = 'Kategorie';
$string['categoryfield'] = 'Atrybut kategorii';
$string['categoryfieldorder'] = 'Kolejność atrybutów kategorii';
$string['ccoursefield'] = 'Warunek dla atrybutu kategorii';
$string['cellalign'] = 'Wyrównanie komórek';
$string['cellsize'] = 'Rozmiar komórki';
$string['cellwrap'] = 'Zawijanie wierszy';
$string['column'] = 'Kolumna';
$string['columnandcellproperties'] = 'Właściwości kolumn i komórek';
$string['columncalculations'] = 'Obliczenia dla kolumn (atrybutów)';
$string['columns'] = 'Kolumny';
$string['comp_calcs'] = 'Obliczenia';
$string['comp_calcs_help'] = '<p>Tutaj możesz zdefiniować obliczenia dla kolumn, np. średnia liczba użytkowników zapisanych na kursy.</p>

<p>Więcej informacji znajdziesz w <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">dokumentacji wtyczki</a>.</p>';
$string['comp_calculations'] = 'Obliczenia';
$string['comp_calculations_help'] = '<p>Tutaj możesz zdefiniować obliczenia dla kolumn, np. średnia liczba użytkowników zapisanych na kursy.</p>';
$string['comp_columns'] = 'Kolumny';
$string['comp_columns_help'] = '<p>Tutaj możesz wybrać różne kolumny (atrybuty) zdefiniowane dla wybranego rodzaju raportu.</p>

<p>Więcej informacji znajdziesz w <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">dokumentacji wtyczki</a>.</p>';
$string['comp_conditions'] = 'Warunki';
$string['comp_conditions_help'] = '<p>Tutaj możesz zdefiniować warunki (np.: tylko kursy z tej kategorii, tylko użytkownicy z Hiszpanii itp. </p>

<p>Jeśli używasz więcej niż jednego warunku możesz użyć wyrażeń logicznych.</p>

<p>Więcej informacji znajdziesz w <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">dokumentacji wtyczki</a>.</p>';
$string['comp_customsql'] = 'Niestandardowy SQL';
$string['comp_filters'] = 'Filtry';
$string['comp_filters_help'] = '<p>Tutaj możesz określić dostępne filtry.</p>

<p>Filtr pozwala użytkownikowi wybrać kolumny z raportu w celu filtrowania wyników.</p>

<p>Więcej o używaniu filtrów w raportach SQL znajdziesz w <a href="http://docs.moodle.org/en/blocks/configurable_reports/#Creating_a_SQL_Report" target="_blank">samouczku tworzenia raportów SQL< /a>.</p>

<p>Więcej informacji znajdziesz w <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">dokumentacji wtyczki</a>.</p>';
$string['comp_ordering'] = 'Sortowanie';
$string['comp_ordering_help'] = '<p>Tutaj możesz wybrać sposób sortowania raportu według atrybutów oraz kierunku sortowania.</p>

<p>Więcej informacji znajdziesz w <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">dokumentacji wtyczki</a>.</p>';
$string['comp_permissions'] = 'Uprawnienia';
$string['comp_permissions_help'] = '<p>Tutaj możesz określić, kto może wyświetlać raport.</p>

<p>Jeśli używasz więcej niż jednego warunku, możesz użyć wyrażeń logicznych, aby określić ostateczne uprawnienie.</p>

<p>Więcej informacji znajdziesz w <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">dokumentacji wtyczki</a>.</p>';
$string['comp_plot'] = 'Wykres';
$string['comp_plot_help'] = '<p>Tutaj możesz dodać wykresy do raportu wykorzystując dostępne kolumny (atrybuty) i wartości.</p>

<p>Więcej informacji znajdziesz w <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">dokumentacji wtyczki</a>.</p>';
$string['comp_template'] = 'Szablon';
$string['comp_template_help'] = '<p>Szablon umożliwia zmodyfikowanie układu raportu.</p>

<p>Aby utworzyć szablon, zapoznaj się z dostępnymi znacznikami, które możesz użyć w nagłówku, stopce i dla każdego rekordu raportu. Listę dostępnych znaczników znajdziesz klikając w przyciski pomocy lub w informacjach wyświetlanych na tej stronie.</p>

<p>Więcej informacji znajdziesz w <a href="http://docs.moodle.org/en/blocks/configurable_reports/" target="_blank">dokumentacji wtyczki</a>.</p>';
$string['componenthelp'] = 'Pomoc';
$string['conditionexpr'] = 'Warunek';
$string['conditionexpr_conditions'] = 'Warunek';
$string['conditionexpr_conditions_help'] = '<p>Możesz łączyć warunki za pomocą wyrażeń logicznych.</p>

<p>Wprowadź prawidłowe wyrażenie logiczne z tymi operatorami: and, or.</p>';
$string['conditionexpr_permissions'] = 'Warunek';
$string['conditionexpr_permissions_help'] = '<p>Możesz łączyć warunki za pomocą wyrażeń logicznych.</p>

<p>Wprowadź prawidłowe wyrażenie logiczne z tymi operatorami: and, or.</p>';
$string['conditionexprhelp'] = 'Wprowadź poprawny warunek, tj. (c1and c2) lub (c4 and c3)';
$string['conditions'] = 'Warunki';
$string['configurable_reports:addinstance'] = 'Dodaj nowy blok Konfigurowalne raporty';
$string['configurable_reports:manageownreports'] = 'Zarządzaj własnymi raportami';
$string['configurable_reports:managereports'] = 'Zarządzaj raportami';
$string['configurable_reports:managesqlreports'] = 'Zarządzaj raportami SQL';
$string['configurable_reports:myaddinstance'] = 'Dodaj nowy blok „Konfigurowalne raporty” do Kokpitu';
$string['configurable_reports:viewreports'] = 'Podgląd raportów';
$string['confirmdeletereport'] = 'Czy na pewno chcesz usunąć ten raport?';
$string['coursecategories'] = 'Filtr kategorii kursów';
$string['coursecategory'] = 'Kurs w kategorii';
$string['coursefield'] = 'Atrybut kursu';
$string['coursefieldorder'] = 'Kolejność atrybutów kursu';
$string['coursemodules'] = 'Moduł w kursie';
$string['courses'] = 'Kursy';
$string['coursestats'] = 'Statystyki kursu';
$string['cron'] = 'Uruchamiaj codziennie';
$string['cron_help'] = 'Zaplanuj uruchamianie tego zapytania każdego dnia (w nocy)';
$string['crondescription'] = 'Zaplanuj uruchamianie tego zapytania każdego dnia (w nocy)';
$string['crrepository'] = 'Repozytorium raportów';
$string['crrepositoryinfo'] = 'Zdalne repozytorium z udostępnionymi przykładowymi raportami (w formacie: nazwa właściciela konta GitHub + ukośnik + nazwa repozytorium)';
$string['currentreportcourse'] = 'Bieżący kurs';
$string['currentreportcourse_summary'] = 'Kurs, w którym utworzono raport';
$string['currentuser'] = 'Bieżący użytkownik';
$string['currentuser_summary'] = 'Użytkownik przeglądający raport';
$string['currentusercourses'] = 'Kursy, do których zapisany jest bieżący użytkownik';
$string['currentusercourses_summary'] = 'Lista kursów do których zapisany jest bieżący użytkownik (tylko widoczne kursy)';
$string['currentuserfinalgrade'] = 'Ocena końcowa z kursu';
$string['currentuserfinalgrade_summary'] = 'Ta kolumna pokazuje ocenę końcową bieżącego użytkownika w kursie';
$string['cuserfield'] = 'Warunek dla atrybutów użytkownika';
$string['customdateformat'] = 'Niestandardowy format daty';
$string['customsql'] = 'Niestandardowy SQL';
$string['datatables'] = 'Włącz bibliotekę DataTables JS';
$string['datatables_emptytable'] = 'Brak danych w tabeli';
$string['datatables_first'] = 'Pierwszy';
$string['datatables_info'] = 'Wyświetlam od _START_ do _END_ z _TOTAL_ wpisów';
$string['datatables_infoempty'] = 'Wyświetlam od 0 do 0 z 0 wpisów';
$string['datatables_infofiltered'] = '(filtrowane z _MAX_ wszystkich wpisów)';
$string['datatables_last'] = 'Ostatni';
$string['datatables_lengthmenu'] = 'Pokaż elementy _MENU_';
$string['datatables_loadingrecords'] = 'Ładowanie...';
$string['datatables_next'] = 'Następny';
$string['datatables_previous'] = 'Poprzedni';
$string['datatables_processing'] = 'Przetwarzanie...';
$string['datatables_search'] = 'Szukaj:';
$string['datatables_sortascending'] = ': włącz, aby posortować kolumnę rosnąco';
$string['datatables_sortdescending'] = ': włącz, aby posortować kolumnę malejąco';
$string['datatables_zerorecords'] = 'Nie znaleziono pasujących danych';
$string['datatablesinfo'] = 'Biblioteka DataTables JS (umożliwia: sortowanie kolumn, stały nagłówek, wyszukiwanie, paginację, ...)';
$string['date'] = 'Data';
$string['dateformat'] = 'Format daty';
$string['dbhost'] = 'Adres zdalnej bazy danych';
$string['dbhostinfo'] = 'Adres hosta zdalnej bazy danych (na którym będziemy wykonywać nasze zapytania SQL)';
$string['dbname'] = 'Nazwa zdalnej bazy danych';
$string['dbnameinfo'] = 'Nazwa zdalnej bazy danych (na której będziemy wykonywać nasze zapytania SQL)';
$string['dbpass'] = 'Hasło użytkownika zdalnej bazy danych';
$string['dbpassinfo'] = 'Hasło do zdalnej bazy danych (dla powyższej nazwy użytkownika)';
$string['dbuser'] = 'Nazwa użytkownika zdalnej bazy danych';
$string['dbuserinfo'] = 'Nazwa użytkownika zdalnej bazy danych (powinna mieć uprawnienia SELECT do powyższej bazy danych)';
$string['decimals'] = 'Liczba miejsc po przecinku';
$string['direction'] = 'Kierunek';
$string['disabled'] = 'Wyłączony';
$string['displayglobalreports'] = 'Wyświetl globalne raporty';
$string['displayreportslist'] = 'Wyświetl listę raportów w bloku';
$string['donotshowtime'] = 'Nie pokazuj informacji o datach';
$string['download'] = 'Pobierz';
$string['downloadreport'] = 'Pobierz raport';
$string['email_message'] = 'Wiadomość';
$string['email_send'] = 'Wyślij';
$string['email_subject'] = 'Temat';
$string['enabled'] = 'Włączony';
$string['enableglobal'] = 'To jest raport globalny (dostępny z każdego kursu)';
$string['enablejsordering'] = 'Włącz sortowanie JavaScript';
$string['enablejspagination'] = 'Włącz paginację JavaScript';
$string['endtime'] = 'Data zakończenia';
$string['enrolledstudents'] = 'Zapisani studenci';
$string['error_field'] = 'Niedozwolony atrybut';
$string['error_operator'] = 'Niedozwolony operator';
$string['error_value_expected_integer'] = 'Oczekiwano wartości całkowitej';
$string['excludedeletedusers'] = 'Wyklucz usuniętych użytkowników (dostępne tylko dla raportów SQL)';
$string['executeat'] = 'Uruchom o';
$string['executeatinfo'] = 'CRON Moodle uruchomi zaplanowane zapytania SQL po wybranej godzinie. Raz na 24h.';
$string['export_csv'] = 'Eksport do formatu CSV';
$string['export_json'] = 'Eksport do formatu JSON';
$string['export_ods'] = 'Eksport do formatu ODS';
$string['export_xls'] = 'Eksport do formatu XLS';
$string['exportoptions'] = 'Opcje eksportu';
$string['exportreport'] = 'Eksportuj raport';
$string['fcoursefield'] = 'Filtr atrybutów kursu';
$string['field'] = 'Atrybut';
$string['filter'] = 'Filtr';
$string['filter_all'] = 'Wszystko';
$string['filter_apply'] = 'Zastosuj';
$string['filter_searchtext'] = 'Wyszukiwany tekst';
$string['filter_searchtext_summary'] = 'Filtrowanie według wyszukiwanego tekstu';
$string['filtercategories'] = 'Filtrowanie kategorii';
$string['filtercategories_summary'] = 'Filtrowanie według kategorii';
$string['filtercoursemodules'] = 'Moduły w kursie';
$string['filtercoursemodules_summary'] = 'Filtruj po modułach w kursie';
$string['filtercourses'] = 'Kursy';
$string['filtercourses_summary'] = 'Ten filtr pokazuje listę kursów. W tym samym czasie można wybrać tylko jeden kurs.';
$string['filterenrolledstudents'] = 'Studenci zapisani na kurs';
$string['filterrole'] = 'Rola';
$string['filterrole_summary'] = 'Filtruj role systemowe (nauczyciel, student, ...)';
$string['filters'] = 'Filtry';
$string['filtersemester'] = 'Semestr (format hebrajski)';
$string['filterstartendtime_summary'] = 'Filtr daty rozpoczęcia/zakończenia';
$string['filtersubcategories'] = 'Filtrowanie kategorii (uwzględnia podkategorie)';
$string['filtersubcategories_summary'] = 'Użyj: %%FILTER_SUBCATEGORIES:mdl_course_category.path%%';
$string['filteruser'] = 'Użytkownicy w bieżącym kursie';
$string['filteruser_summary'] = 'Filtruj po wszystkich użytkownikach (według id) w bieżącym kursie';
$string['filterusers'] = 'Wszyscy użytkownicy serwisu';
$string['filterusers_summary'] = 'Filtruj po wszystkich użytkownikach serwisu (według id)';
$string['filteryearhebrew'] = 'Rok (hebrajski)';
$string['filteryearhebrew_summary'] = 'Filtr używa roku w formacie hebrajskich (תשעג,...)';
$string['filteryearnumeric'] = 'Rok (numeryczny)';
$string['filteryearnumeric_summary'] = 'Filtr używa roku w formacie numerycznym (2013,...)';
$string['filteryears'] = 'Rok (numeryczny)';
$string['filteryears_list'] = '2010, 2011, 2012, 2013, 2014, 2015, ...';
$string['filteryears_summary'] = 'Filtruj według roku (reprezentacja numeryczna, 2012...)';
$string['finalgradeincurrentcourse'] = 'Ocena końcowa w bieżącym kursie';
$string['fixeddate'] = 'Ustalona data';
$string['footer'] = 'Stopka';
$string['forcemidnight'] = 'Wymuś uruchamianie o północy';
$string['fsearchuserfield'] = 'Wybrany atrybut użytkownika';
$string['fuserfield'] = 'Filtr atrybutów użytkownika';
$string['global'] = 'Raport globalny';
$string['global_help'] = 'Dostęp do raportu globalnego można uzyskać z dowolnego kursu na platformie, dodając  &courseid=MY_COURSE_ID w adresie URL raportu';
$string['globalstatsshouldbeenabled'] = 'Statystyki witryny muszą być włączone. Przejdź do Admin -> Serwer -> Statystyki';
$string['groupseries'] = 'Grupuj serie danych';
$string['groupvalues'] = 'Grupuj te same wartości (suma)';
$string['head_color'] = 'Kolor tła wykresu';
$string['head_data'] = 'Dane wykresu';
$string['head_size'] = 'Rozmiar wykresu';
$string['header'] = 'Nagłówek';
$string['height'] = 'Wysokość';
$string['importfromrepository'] = 'Importuj raport z repozytorium';
$string['importreport'] = 'Importuj raport';
$string['includesubcats'] = 'Uwzględnij podkategorie';
$string['jsordering'] = 'Sortowanie JavaScript';
$string['jsordering_help'] = 'Sortowanie JavaScript pozwala sortować tabelę raportów bez przeładowywania strony';
$string['label_field'] = 'Etykiety atrybutów';
$string['label_field_help'] = 'Etykiety elementów przedstawionych na wykresie';
$string['lastexecutiontime'] = 'Czas wykonania = {$a} (Sek)';
$string['limitcategories'] = 'Ogranicz kategorie na wykresie';
$string['line'] = 'Wykres liniowy';
$string['linesummary'] = 'Wykres liniowy z wieloma seriami danych';
$string['listofsqlreports'] = 'Naciśnij klawisz F11, gdy kursor znajduje się w edytorze, aby przełączyć do edycji pełnoekranowej. Klawisz Esc może być użyty do opuszczenia edycji pełnoekranowej.<br/><br/><a href="http://docs.moodle.org/en/ad-hoc_contributed_reports" target="_blank">Lista udostępnionych raportów SQL</a>';
$string['managereports'] = 'Zarządzaj raportami';
$string['max'] = 'Maksimum';
$string['min'] = 'Minimum';
$string['missingcolumn'] = 'Kolumna jest wymagana';
$string['module'] = 'Moduł';
$string['newreport'] = 'Nowy raport';
$string['nocalcsyet'] = 'Brak zdefiniowanych obliczeń';
$string['nocolumnsyet'] = 'Brak zdefiniowanych kolumn';
$string['noconditionsyet'] = 'Brak zdefiniowanych warunków';
$string['noexplicitprefix'] = 'Brak określonego prefiksu';
$string['nofiltersyet'] = 'Brak zdefiniowanych filtrów';
$string['nofilteryet'] = 'Brak zdefiniowanych filtrów';
$string['noorderingyet'] = 'Brak zdefiniowanego sortowania';
$string['nopermissionsyet'] = 'Brak zdefiniowanych uprawnień';
$string['noplotyet'] = 'Brak zdefiniowanych wykresów';
$string['norecordsfound'] = 'Nie znaleziono wpisów';
$string['noreportsavailable'] = 'Brak dostępnych raportów';
$string['norowsreturned'] = 'Nie zwrócono żadnych wierszy';
$string['nosemicolon'] = 'Brak średnika';
$string['notallowedwords'] = 'Niedozwolone wyrażenie';
$string['operator'] = 'Operator';
$string['ordering'] = 'Sortowanie';
$string['others'] = 'Inne';
$string['pagination'] = 'Paginacja';
$string['pagination_help'] = 'Liczba rekordów do pokazania na każdej stronie. Zero oznacza brak paginacji';
$string['parentcategory'] = 'Kategoria nadrzędna';
$string['percent'] = 'Odsetek';
$string['permissions'] = 'Uprawnienia';
$string['pie'] = 'Wykres kołowy';
$string['pieareaname'] = 'Nazwa';
$string['pieareavalue'] = 'Wartość';
$string['piesummary'] = 'Wykres kołowy';
$string['plot'] = 'Wykresy';
$string['pluginname'] = 'Konfigurowalne raporty';
$string['previousdays'] = 'Poprzednie dni';
$string['printreport'] = 'Drukuj raport';
$string['privacy:metadata:block_configurable_reports'] = 'Blok Konfigurowalne raporty zawiera konfigurowalne raporty dostępne w kursie.';
$string['privacy:metadata:block_configurable_reports:components'] = 'Konfiguracja raportu. Zawiera zapytanie, filtry...';
$string['privacy:metadata:block_configurable_reports:courseid'] = 'ID kursu';
$string['privacy:metadata:block_configurable_reports:global'] = 'Określa czy raport jest dostępny we wszystkich kursów.';
$string['privacy:metadata:block_configurable_reports:lastexecutiontime'] = 'Czas ostatniego wykonania raportu (w milisekundach).';
$string['privacy:metadata:block_configurable_reports:name'] = 'Nazwa raportu';
$string['privacy:metadata:block_configurable_reports:ownerid'] = 'Identyfikator użytkownika, który utworzył raport';
$string['privacy:metadata:block_configurable_reports:summary'] = 'Opis raportu';
$string['privacy:metadata:block_configurable_reports:type'] = 'Rodzaj raportu';
$string['privacy:metadata:block_configurable_reports:visible'] = 'Określa czy raport jest widoczny.';
$string['puserfield'] = 'Wartość atrybutu użytkownika';
$string['puserfield_summary'] = 'Użytkownik z zadaną wartością wybranego atrybutu';
$string['queryfailed'] = 'Zapytanie nie powiodło się <code><pre>{$ a}</pre></code>';
$string['querysql'] = 'Zapytanie SQL';
$string['remote'] = 'Wykonaj na zdalnej bazie danych';
$string['remote_help'] = 'Czy chcesz uruchomić to zapytanie na zdalnej bazie danych?';
$string['remotedescription'] = 'Czy chcesz uruchomić to zapytanie na zdalnej bazie danych?';
$string['remotequerysql'] = 'Zapytanie SQL';
$string['report'] = 'Raport';
$string['report_categories'] = 'Raport kategorii';
$string['report_courses'] = 'Raport kursów';
$string['report_sql'] = 'Raport SQL';
$string['report_timeline'] = 'Raport oś czasu';
$string['report_users'] = 'Raport użytkowników';
$string['reportcategories'] = '1) Wybierz kategorię raportu zdalnego';
$string['reportcolumn'] = 'Kolumna z innego raportu';
$string['reportcreated'] = 'Utworzono raport';
$string['reportlimit'] = 'Limit wierszy';
$string['reportlimitinfo'] = 'Ogranicz liczbę wierszy wyświetlanych w tabeli raportu (domyślnie 5000 wierszy; limit zabezpiecza przed przeciążeniem silnika bazy danych).';
$string['reports'] = 'Raporty';
$string['reportscapabilities_summary'] = 'Użytkownicy z uprawnieniem moodle/site:viewreports';
$string['reportsincategory'] = '2) Wybierz raport z listy';
$string['reporttable'] = 'Tabela raportu';
$string['reporttable_help'] = '<p>Szerokość tabeli, w której będą wyświetlane rekordy raportu.</p>

<p>Ta opcja nie ma wpływu na wyświetlanie jeśli używasz szablonu.</p>';
$string['reporttableui'] = 'UI raportu';
$string['reporttableuiinfo'] = 'Wyświetl tabelę raportu: jako przewijalną tabelę HTML, używając jQuery z sortowaniem kolumn lub używając biblioteki DataTables JS (umożliwia sortowanie według kolumn, stały nagłówek, wyszukiwanie, paginację, ...)';
$string['repository'] = 'Repozytorium raportów';
$string['repository_help'] = 'Możesz importować przykładowe raporty z publicznie udostępnionego repozytorium.

Pamiętaj, że obowiązuje dzienny limit połączeń do repozytorium.

Jeśli połączenie z repozytorium nie działa, możesz ręcznie pobrać raport z <a href="https://github.com/jleyva/moodle-configurable_reports_repository" target="_blank">https://github.com/jleyva/moodle-configurable_reports_repository</a>, a następnie zaimportuj go za pomocą funkcji „Importuj raport” dostępnej poniżej.';
$string['role'] = 'Rola';
$string['roleincourse'] = 'Użytkownik z wybraną rolą/rami w bieżącym kursie';
$string['roleusersn'] = 'Liczba użytkowników z rolą...';
$string['searchtext'] = 'Wyszukaj tekst';
$string['semester'] = 'Semestr (format hebrajski)';
$string['serieid'] = 'Kolumna serii danych';
$string['sessionlimittime'] = 'Limit czasu pomiędzy kliknięciami (w minutach)';
$string['sessionlimittime_help'] = 'Limit czasu pomiędzy kliknięciami określa jak często można odświeżać raport';
$string['sharedsqlrepository'] = 'Współdzielone repozytorium SQL';
$string['sharedsqlrepositoryinfo'] = 'W formacie: nazwa właściciela konta GitHub + ukośnik + nazwa repozytorium';
$string['sqlsecurity'] = 'Bezpieczny SQL';
$string['sqlsecurityinfo'] = 'Wyłącz, aby wykonywać zapytań SQL z instrukcjami pozwalającymi wstawiać dane';
$string['sqlsyntaxhighlight'] = 'Podświetl składnię SQL';
$string['sqlsyntaxhighlightinfo'] = 'Podświetl składnię SQL w edytorze kodu (biblioteka CodeMirror JS)';
$string['startendtime'] = 'Filtr daty rozpoczęcia/zakończenia';
$string['starttime'] = 'Data rozpoczęcia';
$string['stat'] = 'Statystyki';
$string['statstotalenrolments'] = 'Wszystkie zapisy';
$string['student'] = 'Student';
$string['subcategories'] = 'Kategoria (uwzględnia podkategorie)';
$string['sum'] = 'Suma';
$string['tablealign'] = 'Wyrównywanie tekstu w tabeli';
$string['tablecellpadding'] = 'Odstęp w komórkach tabeli';
$string['tablecellspacing'] = 'Odstęp między komórkami tabeli';
$string['tableclass'] = 'Klasa tabeli';
$string['tablewidth'] = 'Szerokość tabeli';
$string['template'] = 'Szablon';
$string['template_marks'] = 'Znaczniki dostępne w szablonie';
$string['template_marks_help'] = '<p>Możesz użyć poniższych znaczników:</p>

<ul>
<li>##reportname## - dołącz nazwę raportu</li>
<li>##reportsummary## - dołącz podsumowanie raportu</li>
<li>##graphs## - uwzględnij wykresy</li>
<li>##exportoptions## - dołącz opcje eksportu</li>
<li>##calculationstable## - dołącz tabelę obliczeń</li>
<li>##pagination## - uwzględnij paginację</li>

</ul>';
$string['templaterecord'] = 'Szablon pojedynczego rekordu';
$string['timeinterval'] = 'Przedział czasowy';
$string['timeline'] = 'Oś czasu';
$string['totalrecords'] = 'Łączna liczba rekordów = {$a->totalrecords}';
$string['type'] = 'Rodzaj raportu';
$string['typeofreport'] = 'Rodzaj raportu';
$string['typeofreport_help'] = 'Wybierz rodzaj raportu, który chcesz utworzyć. Ze względów bezpieczeństwa Raport SQL wymaga dodatkowych uprawnień.';
$string['user'] = 'ID użytkownika kursu';
$string['usercompletion'] = 'Status ukończenia kursu przez użytkownika';
$string['usercompletionsummary'] = 'Status ukończenia kursu';
$string['userfield'] = 'Atrybut profilu użytkownika';
$string['userfieldorder'] = 'Kolejność atrybutów użytkownika';
$string['users'] = 'Użytkownik serwisu (id)';
$string['usersincohorts'] = 'Użytkownik należący do jednej/kilku kohort';
$string['usersincohorts_summary'] = 'Tylko użytkownicy należący do wybranych kohort';
$string['usersincoursereport'] = 'Dowolny użytkownik w bieżącym kursie';
$string['usersincoursereport_summary'] = 'Dowolny użytkownik w bieżącym kursie';
$string['usersincurrentcourse'] = 'Użytkownicy bieżącego kursu';
$string['userstats'] = 'Statystyki użytkownika';
$string['value'] = 'Wartość';
$string['value_fields'] = 'Wartości atrybutów';
$string['value_fields_help'] = 'Atrybuty, których wartości powinny być wyświetlane na wykresie. Ctrl+klik (Cmd+klik na Macu), aby wybrać wiele. Wybrany atrybut etykiety lub z wartościami nienumerycznymi zostanie pominięty na wykresie.';
$string['viewreport'] = 'Wyświetl raport';
$string['width'] = 'Szerokość';
$string['xandynotequal'] = 'Osie X i Y muszą być różne';
$string['xaxis'] = 'Oś X';
$string['yaxis'] = 'Oś Y';
$string['yearhebrew'] = 'Rok (hebrajski)';
$string['yearnumeric'] = 'Rok (numerycznie)';
$string['years'] = 'Rok (numerycznie)';
