<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_openai', language 'da', version '4.5'.
 *
 * @package     aiprovider_openai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:generate_image:endpoint'] = 'API endpoint';
$string['action:generate_image:model'] = 'AI model';
$string['action:generate_image:model_desc'] = 'Modellen brugt til at generere billeder fra brugerens prompts.';
$string['action:generate_text:endpoint'] = 'API endpoint';
$string['action:generate_text:model'] = 'AI model';
$string['action:generate_text:model_desc'] = 'Modellen brugt til at generere tekstsvaret.';
$string['action:generate_text:systeminstruction'] = 'System instruktion';
$string['action:generate_text:systeminstruction_desc'] = 'Denne instruktion sendes til AI-modellen sammen med brugerens prompt. At redigere denne instruktion anbefales ikke, medmindre det er absolut nødvendigt.';
$string['action:summarise_text:endpoint'] = 'API endpoint';
$string['action:summarise_text:model'] = 'AI model';
$string['action:summarise_text:model_desc'] = 'Modellen brugt til at opsummere den angivne tekst.';
$string['action:summarise_text:systeminstruction'] = 'Systeminstruktion';
$string['action:summarise_text:systeminstruction_desc'] = 'Denne instruktion sendes til AI-modellen sammen med brugerens prompt. At redigere denne instruktion anbefales ikke, medmindre det er absolut nødvendigt.';
$string['apikey'] = 'OpenAI API nøgle';
$string['apikey_desc'] = 'Hent en nøgle fra <a href="OpenAI" target="_blank" rel="noreferrer">https://platform.openai.com/account/api-keys">OpenAI Platform API-nøgler</a>.';
$string['enableglobalratelimit'] = 'Indstil sidevid grænse for forespørgsler';
$string['enableglobalratelimit_desc'] = 'Begræns antallet af forespørgsler, som OpenAI API-udbyderen kan modtage på hele siden hver time.';
$string['enableuserratelimit'] = 'Indstil brugergrænse for forespørgsler';
$string['enableuserratelimit_desc'] = 'Begræns antallet af forespørgsler, som hver bruger kan foretage til OpenAI API-udbyderen hver time.';
$string['globalratelimit'] = 'Maksimalt antal sidewide forespørgsler';
$string['globalratelimit_desc'] = 'Antallet af sidewide forespørgsler tilladt pr. time.';
$string['orgid'] = 'OpenAI organisations ID';
$string['orgid_desc'] = 'Hent et OpenAI organisations-ID fra din <a href="OpenAI" target="_blank" rel="noreferrer">https://platform.openai.com/account/org-settings">OpenAI Platform-konto</a>.';
$string['pluginname'] = 'OpenAI API-udbyder';
$string['privacy:metadata'] = 'OpenAI API udbyder plugin gemmer ikke nogen personlige data.';
$string['privacy:metadata:aiprovider_openai:externalpurpose'] = 'Denne information sendes til OpenAI API for at generere et svar. Dine OpenAI kontoindstillinger kan ændre, hvordan OpenAI gemmer og beholder disse data. Ingen brugerdata sendes eksplicit til OpenAI eller gemmes i Moodle LMS af dette plugin.';
$string['privacy:metadata:aiprovider_openai:model'] = 'Modellen brugt til at generere svaret.';
$string['privacy:metadata:aiprovider_openai:numberimages'] = 'Når billeder genereres, er antallet af billeder brugt i svaret';
$string['privacy:metadata:aiprovider_openai:prompttext'] = 'Den brugerindtastede tekstprompt brugt til at generere svaret.';
$string['privacy:metadata:aiprovider_openai:responseformat'] = 'Formatet af svaret ved billedgenerering.';
$string['userratelimit'] = 'Maksimalt antal forespørgsler pr. bruger';
$string['userratelimit_desc'] = 'Antallet af forespørgsler tilladt pr. time, pr. bruger.';
