<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'feedback', language 'da', version '4.5'.
 *
 * @package     feedback
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_item'] = 'Tilføj spørgsmål til aktiviteten';
$string['add_pagebreak'] = 'Tilføj et sideskift';
$string['adjustment'] = 'Justering';
$string['after_submit'] = 'Efter aflevering';
$string['allowfullanonymous'] = 'Tillad fuld anonymitet';
$string['analysis'] = 'Analyse';
$string['anonymous'] = 'Anonym';
$string['anonymous_edit'] = 'Registrer brugernavne';
$string['anonymous_entries'] = 'Anonyme indlæg  ({$a})';
$string['anonymous_user'] = 'Anonym bruger';
$string['answerquestions'] = 'Svar på spørgsmålene';
$string['append_new_items'] = 'Tilføj nye poster';
$string['autonumbering'] = 'Nummerer spørgsmål automatisk';
$string['autonumbering_help'] = 'Aktiverer eller deaktiverer automatisk nummerering af hvert spørgsmål';
$string['average'] = 'Gennemsnit';
$string['bold'] = 'Fed';
$string['calendarend'] = '{$a} lukker';
$string['calendarstart'] = '{$a} åbner';
$string['cannotaccess'] = 'Du kan kun få adgang til denne feedback fra et kursus';
$string['cannotcreatepagebreak'] = 'Et sideskift kan ikke tilføjes i begyndelsen, og der kan kun tilføjes ét sideskift til slut.';
$string['cannotsavetempl'] = 'Det er ikke tilladt at gemme skabeloner';
$string['captcha'] = 'Captcha';
$string['captchanotset'] = 'Captcha er ikke konfigureret.';
$string['check'] = 'Multiple choice - flere svar';
$string['check_values'] = 'Mulige responser';
$string['checkbox'] = 'Multiple choice - flere svar er tilladt (afkrydsningsfelter)';
$string['choosefile'] = 'Vælg en fil';
$string['chosen_feedback_response'] = 'Valgt feedback-respons';
$string['closebeforeopen'] = 'Du har sat slutdatoen før startdatoen.';
$string['complete_the_form'] = 'Svar på spørgsmålene';
$string['completed'] = 'Fuldført';
$string['completed_feedbacks'] = 'Afleverede svar';
$string['completedon'] = 'Fuldført den {$a}';
$string['completiondetail:submit'] = 'Aflever feedback';
$string['completionsubmit'] = 'Aflever feedback';
$string['configallowfullanonymous'] = 'Er "ja" valgt, kan brugere gennemføre feedbackaktiviteter på forsiden uden at være logget ind.';
$string['confirmdeleteentry'] = 'Der du sikker på at du vil slette dette?';
$string['confirmdeleteitem'] = 'Er du sikker på at du vil slette dette element?';
$string['confirmdeletetemplate'] = 'Er du sikker på at du vil slette denne skabelon?';
$string['confirmusetemplate'] = 'Er du sikker på at du vil bruge denne skabelon?';
$string['continue_the_form'] = 'Fortsæt med at besvare spørgsmålene';
$string['count_of_nums'] = 'Optælling af numre';
$string['courseid'] = 'Kursus-id';
$string['creating_templates'] = 'Gem spørgsmålene som en ny skabelon';
$string['delete_entry'] = 'Slet';
$string['delete_item'] = 'Slet spørgsmål';
$string['delete_old_items'] = 'Slet gamle elementer';
$string['delete_pagebreak'] = 'Slet sideskift';
$string['delete_template'] = 'Slet skabelon';
$string['delete_templates'] = 'Slet skabelon...';
$string['depending'] = 'Afhængigheder';
$string['depending_help'] = 'Det er muligt at vise et element afhængig af værdien af et andet element.<br />
<strong>Her er et eksempel.</strong><br />
<ul>
<li>Start med at oprette et element som et andet element afhænger af.</li>
<li>Tilføj derefter et sideskift.</li>
<li>Tilføj de elementer der afhænger af værdien af det før oprettede element. Vælg elementet fra listen med "Afhængigt element" og angiv den krævede værdi i tekstboksen "Afhængig værdi".</li>
</ul>
<strong>Strukturen skal se sådan ud.</strong>
<ol>
<li>Spm.: Har du en bil? Sv: ja/nej</li>
<li>Sideskift</li>
<li>Spm.: Hvilken farve har din bil?<br />
(dette afhænger af svaret på første spørgsmål, værdi = ja)</li>
<li>Spm.: Hvorfor har du ikke en bil?<br />
(afhænger af værdi = nej)</li>
<li> ... osv</li>
</ol>';
$string['dependitem'] = 'Afhængigt element';
$string['dependvalue'] = 'Afhængig værdi';
$string['description'] = 'Beskrivelse';
$string['do_not_analyse_empty_submits'] = 'Udelad tomme afleveringer til analyse';
$string['downloadresponseas'] = 'Download alle svar som:';
$string['drop_feedback'] = 'Fjern fra dette kursus';
$string['dropdown'] = 'Multiple choice - enkelt svar tilladt (rullemenu)';
$string['dropdown_values'] = 'Svar';
$string['dropdownlist'] = 'Multiple choice - enkelt svar (rullemenu)';
$string['dropdownrated'] = 'Rullemenu (bedømt)';
$string['edit_item'] = 'Rediger spørgsmål';
$string['edit_items'] = 'Rediger spørgsmål';
$string['email_notification'] = 'Send e-mailnotifikationer';
$string['email_notification_help'] = 'Er indstillingen aktiveret, vil lærere underrettes om feedback-afleveringer.';
$string['emailteachermail'] = '{$a->username} har færdiggjort feedbackaktiviteten: "{$a->feedback}".

Du kan se den her:

{$a->url}';
$string['emailteachermailhtml'] = '<p>{$a->username} har færdiggjort feedbackaktiviteten: <i>"{$a->feedback}"</i>.</p> <p>Den er <a href="{$a->url}">tilgængelig her</a>.</p>';
$string['entries_saved'] = 'Dine svar er gemt. Tak skal du have!';
$string['eventresponsedeleted'] = 'Respons slettet';
$string['eventresponsesubmitted'] = 'Respons afleveret';
$string['export_questions'] = 'Eksporter spørgsmål';
$string['export_to_excel'] = 'Eksporter til Excel';
$string['feedback:addinstance'] = 'Tilføj en ny feedback';
$string['feedback:complete'] = 'Gennemfør en feedback';
$string['feedback:createprivatetemplate'] = 'Opret en privat skabelon';
$string['feedback:createpublictemplate'] = 'Opret en fælles skabelon';
$string['feedback:deletesubmissions'] = 'Slet fuldførte afleveringer';
$string['feedback:deletetemplate'] = 'Slet skabelon';
$string['feedback:edititems'] = 'Rediger elementer';
$string['feedback:mapcourse'] = 'Knyt kurser til globale feedbacks';
$string['feedback:receivemail'] = 'Modtag e-mailnotifikaton';
$string['feedback:view'] = 'Vis en feedback';
$string['feedback:viewanalysepage'] = 'Vis analysesiden efter aflevering';
$string['feedback:viewreports'] = 'Vis rapporter';
$string['feedback_is_not_for_anonymous'] = 'Feedback er ikke for anonyme';
$string['feedback_is_not_open'] = 'Feedbacken er ikke åben';
$string['feedbackclose'] = 'Tillad svar til';
$string['feedbackcompleted'] = '{$a->username} fulført {$a->feedbackname}';
$string['feedbackopen'] = 'Tillad svar fra';
$string['feedbackupdated'] = 'Feedback opdateret.';
$string['file'] = 'Fil';
$string['filter_by_course'] = 'Filtrer efter kursus';
$string['handling_error'] = 'Der opstod en fejl i feedback-modulets håndtering af en handling';
$string['hide_no_select_option'] = 'Skjul muligheden "Ikke valgt"';
$string['horizontal'] = 'Vandret';
$string['import_questions'] = 'Importer spørgsmål';
$string['import_successfully'] = 'Importeret';
$string['importfromthisfile'] = 'Importer fra denne fil';
$string['includeuserinrecipientslist'] = 'Medtag {$a} på modtagerlisten';
$string['indicator:cognitivedepth'] = 'Feedback kognitiv';
$string['indicator:cognitivedepth_help'] = 'Denne indikator er baseret på den kognitive dybde, som den studerende opnår i en Feedback-aktivitet.';
$string['indicator:cognitivedepthdef'] = 'Feedback kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Deltageren har opnået denne procentdel af den kognitive engagement, der tilbydes af Feedback-aktiviteterne i løbet af dette analyseinterval (Niveauer = Ingen visning, Visning, Indsendelse)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Feedback-social';
$string['indicator:socialbreadth_help'] = 'Denne indikator er baseret på den sociale dybde, som den studerende opnår i en Feedback-aktivitet.';
$string['indicator:socialbreadthdef'] = 'Feedback-social';
$string['indicator:socialbreadthdef_help'] = 'Deltageren har opnået denne procentdel af den sociale engagement, der tilbydes af Feedback-aktiviteterne i løbet af dette analyseinterval (Niveauer = Ingen deltagelse, Deltager alene, Deltager med andre)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Information';
$string['infotype'] = 'Informationstype';
$string['insufficient_responses'] = 'utilstrækkelige svar';
$string['insufficient_responses_for_this_group'] = 'Der er utilstrækkelig respons fra denne gruppe';
$string['insufficient_responses_help'] = 'Der er utilstrækkelig respons fra denne gruppe. For at holde feedbacken anonym, skal mindst 2 have afgivet respons.';
$string['item_label'] = 'Etiket';
$string['item_name'] = 'Spørgsmål';
$string['label'] = 'Tekst og medieområde';
$string['labelcontents'] = 'Indhold';
$string['mapcourse'] = 'Knyt feedback til kurser';
$string['mapcourse_help'] = 'Feedbacks oprettet på forsiden er som standard tilgængelig på alle kurser via feedback-blokken. Du kan tvinge feedbacken til at være synlig ved at oprette en fast blok og du kan begrænse de kurser hvori feedbacken vil optræde, ved at knytte dem til specifikke kurser.';
$string['mapcourseinfo'] = 'Denne feedback er tilgængelig på hele sitet via feedback-blokken. Du kan dog begrænse tilgængeligheden til visse kurser ved at oprette tilknytning til dem. Søg efter et kursus og knyt det til feedbacken.';
$string['mapcoursenone'] = 'Ingen kurser er tilknyttet. Feedbacken er tilgængelig fra alle kurser.';
$string['mapcourses'] = 'Tilknyt feedback til kurser';
$string['mappedcourses'] = 'Tilknyttede kurser';
$string['mappingchanged'] = 'Kursustilknytningen er ændret';
$string['maximal'] = 'Maksimum';
$string['messageprovider:message'] = 'Feedbackpåmindelse';
$string['messageprovider:submission'] = 'Feedback-notifikationer';
$string['minimal'] = 'Minimum';
$string['mode'] = 'Tilstand';
$string['modulename'] = 'Feedback';
$string['modulename_help'] = 'Med feedback-modulet kan lærere oprette brugerdefinerede undersøgelser til indsamling af feedback fra deltagere ved brug af forskellige spørgsmålstyper, deriblandt multiple choice, ja/nej eller tekst.

Feedback kan gives anonymt, og resultaterne kan vises til alle deltagere eller kun til lærere. Feedback-aktiviteter på forsiden kan også besvares af brugere der ikke er logget ind.

Feedback kan bruges til

* Kursusevalueringer til hjælp til forbedring af indhold fremover
* Til at muliggøre deltagere at tilmelde sig kursusmoduler, arrangementer mv.
* Til gæsteundersøgelser om valg af kurser, skolepolitikker mv.
* Til undersøgelse/analyse vedrørende mobning, hvor studerende anonymt kan rapportere hændelser.';
$string['modulename_link'] = 'mod/feedback/view';
$string['modulenameplural'] = 'Feedback';
$string['move_item'] = 'Flyt dette spørgsmål';
$string['multichoice'] = 'Multiple choice';
$string['multichoice_values'] = 'Multiple choice-værdier';
$string['multichoiceoption'] = '<span class="weight">({$a->weight}) </span>{$a->name}';
$string['multichoicerated'] = 'Multiple choice (bedømt)';
$string['multichoicetype'] = 'Multiple choice-type';
$string['multiplesubmit'] = 'Tillad flere besvarelser';
$string['multiplesubmit_help'] = 'Hvis sat til Ja:

* For anonyme undersøgelser: deltagere kan indsende ubegrænsede svar, og alle svar vil blive registreret.
* For ikke-anonyme undersøgelser: deltagere kan indsende ubegrænsede svar, men kun deres seneste svar vil blive registreret.Er indstillingen aktiveret for anonyme undersøgelser, kan brugere besvare undersøgelsen et ubegrænset antal gange.';
$string['name'] = 'Navn';
$string['name_required'] = 'Navn påkrævet';
$string['nameandlabelformat'] = '({$a->label}) {$a->name}';
$string['next_page'] = 'Næste side';
$string['no_handler'] = 'Der er ingen håndteringassistent til';
$string['no_itemlabel'] = 'Ingen etiket';
$string['no_itemname'] = 'Intet elementnavn';
$string['no_items_available_yet'] = 'Der er endnu ikke opsat nogen spørgsmål';
$string['no_templates_available_yet'] = 'Ingen tilgængelige skabeloner endnu';
$string['non_anonymous'] = 'Brugerens navn vil blive registreret og vist sammen med svarene';
$string['non_anonymous_entries'] = 'Ikke-anonyme bidrag ({$a})';
$string['non_respondents_students'] = 'Studerende der ikke har besvaret ({$a})';
$string['not_completed_yet'] = 'Ikke fuldført  endnu';
$string['not_selected'] = 'Ikke valgt';
$string['not_started'] = 'Ikke startet';
$string['numberoutofrange'] = 'Tal udenfor interval';
$string['numeric'] = 'Numerisk svar';
$string['numeric_range_from'] = 'Interval fra';
$string['numeric_range_to'] = 'Interval til';
$string['of'] = 'af';
$string['oldvaluespreserved'] = 'Alle gamle spørgsmål og de tildelte værdier vil blive bevaret';
$string['oldvalueswillbedeleted'] = 'De aktuelle spørgsmål og alle brugersvar vil blive slettet.';
$string['only_one_captcha_allowed'] = 'Kun en captcha er tilladt i en feedback';
$string['openafterclose'] = 'Du har sat åbningsdagen efter lukkedagen';
$string['overview'] = 'Overblik';
$string['page'] = 'Side';
$string['page-mod-feedback-x'] = 'Enhver side i feedback-modulet';
$string['page_after_submit'] = 'Fuldførelsesbesked';
$string['pagebreak'] = 'Sideskift';
$string['pluginadministration'] = 'Administration af feedback';
$string['pluginname'] = 'Feedback';
$string['position'] = 'Position';
$string['previewquestions'] = 'Forhåndsvis spørgsmål';
$string['previous_page'] = 'Forrige side';
$string['privacy:metadata:completed'] = 'En post med afleveringer til feedback\'en';
$string['privacy:metadata:completed:anonymousresponse'] = 'Hvorvidt afleveringen skal bruges anonymt.';
$string['privacy:metadata:completed:timemodified'] = 'Hvornår afleveringen blev redigeret.';
$string['privacy:metadata:completed:userid'] = 'Bruger-id på den der fuldførte feedback-aktiviteten';
$string['privacy:metadata:completedtmp'] = 'En post med uafsluttede afleveringer.';
$string['privacy:metadata:value'] = 'En post med svar på et spørgsmål.';
$string['privacy:metadata:value:value'] = 'Det valgte svar.';
$string['privacy:metadata:valuetmp'] = 'En post med svar på et spørgsmål i en igangværende aflevering.';
$string['public'] = 'Offentlig';
$string['question'] = 'Spørgsmål';
$string['questionandsubmission'] = 'Spørgsmåls- og afleveringsindstillinger';
$string['questions'] = 'Spørgsmål';
$string['questionslimited'] = 'Viser kun de {$a} første spørgsmål, se enkelte svar eller download tabel med data for at se dem alle.';
$string['radio'] = 'Multiple choice - enkelt svar';
$string['radio_values'] = 'Responser';
$string['ready_feedbacks'] = 'Færdige feedback';
$string['required'] = 'Påkrævet';
$string['resetting_data'] = 'Svar';
$string['resetting_delete'] = 'Slet svarene';
$string['resetting_feedbacks'] = 'Nulstiller feedbacks';
$string['response_nr'] = 'Svar nummer';
$string['responses'] = 'Svar';
$string['responsetime'] = 'Responstid';
$string['save_as_new_item'] = 'Gem som nyt spørgsmål';
$string['save_as_new_template'] = 'Gem som skabelon';
$string['save_entries'] = 'Aflever dine svar';
$string['save_item'] = 'Gem spørgsmål';
$string['saving_failed'] = 'Blev ikke gemt';
$string['search:activity'] = 'Feedback - aktivitetsinformation';
$string['search_course'] = 'Gennemsøg kursus';
$string['searchcourses'] = 'Søg kurser';
$string['searchcourses_help'] = 'Søg efter koden eller navnet på kurset/kurser du ønsker at associere med denne feedback.';
$string['selected_dump'] = 'Valgte indekser af $SESSION-variablen vises herunder:';
$string['send'] = 'Send';
$string['send_message'] = 'Send besked';
$string['show_all'] = 'Vis alle';
$string['show_analysepage_after_submit'] = 'Vis analyseside';
$string['show_entries'] = 'Vis svar';
$string['show_entry'] = 'Vis svar';
$string['show_nonrespondents'] = 'Vis ikke-respondenter';
$string['site_after_submit'] = 'Side efter aflevering';
$string['sort_by_course'] = 'Sorter efter kurser';
$string['started'] = 'Startet';
$string['startedon'] = 'Startet den {$a}';
$string['subject'] = 'Emne';
$string['switch_item_to_not_required'] = 'Sæt til frivillig besvarelse';
$string['switch_item_to_required'] = 'Sæt til krævet';
$string['template'] = 'Skabelon';
$string['template_deleted'] = 'Skabelon slettet';
$string['template_saved'] = 'Skabelon gemt';
$string['templates'] = 'Skabeloner';
$string['textarea'] = 'Længere tekstsvar';
$string['textarea_height'] = 'Antal linjer';
$string['textarea_width'] = 'Bredde';
$string['textfield'] = 'Kort tekstsvar';
$string['textfield_maxlength'] = 'Maksimalt tilladte antal tegn';
$string['textfield_size'] = 'Bredde på tekstfelt';
$string['there_are_no_settings_for_recaptcha'] = 'Der er ingen indstillinger for captcha';
$string['this_feedback_is_already_submitted'] = 'Du har allerede gennemført denne aktivitet.';
$string['typemissing'] = 'Manglende værdi "type"';
$string['update_item'] = 'Gem ændringer til spørgsmålet';
$string['url_for_continue'] = 'Link til næste aktivitet';
$string['url_for_continue_help'] = 'Som standard vil man blive ført til kursets forside når man klikker på fortsæt-knappen efter at have besvaret undersøgelsen. Du kan indsætte en alternativ URL i stedet.';
$string['use_one_line_for_each_value'] = 'Brug en linje til hvert svar!';
$string['use_this_template'] = 'Brug denne skabelon';
$string['using_templates'] = 'Brug en skabelon';
$string['vertical'] = 'Lodret';
$string['whatfor'] = 'Hvad vil du gerne gøre?';
