<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_openai', language 'pt', version '4.5'.
 *
 * @package     aiprovider_openai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:generate_image:endpoint'] = 'Endpoint da API';
$string['action:generate_image:model'] = 'Modelo IA';
$string['action:generate_image:model_desc'] = 'O modelo utilizado para gerar imagens a partir de prompts dos utilizadores.';
$string['action:generate_text:endpoint'] = 'Endpoint da API';
$string['action:generate_text:model'] = 'Modelo IA';
$string['action:generate_text:model_desc'] = 'O modelo utilizado para gerar o texto da resposta.';
$string['action:generate_text:systeminstruction'] = 'Instrução do sistema';
$string['action:generate_text:systeminstruction_desc'] = 'Esta instrução é enviada para o modelo IA juntamente com o pedido do utilizador. A edição desta instrução não é recomendada, a não ser que seja absolutamente necessário.';
$string['action:summarise_text:endpoint'] = 'Endpoint da API';
$string['action:summarise_text:model'] = 'Modelo IA';
$string['action:summarise_text:model_desc'] = 'O modelo utilizado para resumir o texto fornecido.';
$string['action:summarise_text:systeminstruction'] = 'Instrução do sistema';
$string['action:summarise_text:systeminstruction_desc'] = 'Esta instrução é enviada para o modelo IA juntamente com o pedido do utilizador. A edição desta instrução não é recomendada, a não ser que seja absolutamente necessário.';
$string['apikey'] = 'Chave API OpenAI';
$string['apikey_desc'] = 'Obtenha uma chave a partir das <a href="https://platform.openai.com/account/api-keys" target="_blank">chaves API da plataforma OpenAI</a>.';
$string['enableglobalratelimit'] = 'Definir limite da taxa para todo o site';
$string['enableglobalratelimit_desc'] = 'Limita o número de pedidos que o fornecedor da API OpenAI pode receber de todo o site a cada hora.';
$string['enableuserratelimit'] = 'Definir limite da taxa de utilizador';
$string['enableuserratelimit_desc'] = 'Limita o número de pedidos que cada utilizador pode fazer ao fornecedor da API OpenAI a cada hora.';
$string['globalratelimit'] = 'Número máximo de pedidos em todo o site';
$string['globalratelimit_desc'] = 'O número de pedidos permitidos em todo o site por hora.';
$string['orgid'] = 'ID OpenAI da organização';
$string['orgid_desc'] = 'Obtenha o ID da organização OpenAI na sua <a href="https://platform.openai.com/account/org-settings" target="_blank">conta na plataforma OpenAI</a>.';
$string['pluginname'] = 'Fornecedor da API OpenAI';
$string['privacy:metadata'] = 'O módulo Fornecedor de API OpenAI não armazena quaisquer dados pessoais.';
$string['privacy:metadata:aiprovider_openai:externalpurpose'] = 'Esta informação é enviada à API OpenAI para que seja gerada uma resposta. As definições da sua conta OpenAI podem alterar a forma como a OpenAI armazena e retém estes dados. Nenhum dado do utilizador é enviado explicitamente para a OpenAI ou armazenado no Moodle LMS por este módulo.';
$string['privacy:metadata:aiprovider_openai:model'] = 'O modelo utilizado para gerar a resposta.';
$string['privacy:metadata:aiprovider_openai:numberimages'] = 'O número de imagens utilizadas na resposta ao gerar imagens.';
$string['privacy:metadata:aiprovider_openai:prompttext'] = 'A prompt inserida pelo utilizador utilizada para gerar a resposta.';
$string['privacy:metadata:aiprovider_openai:responseformat'] = 'O formato da resposta ao gerar imagens.';
$string['userratelimit'] = 'Número máximo de pedidos por utilizador';
$string['userratelimit_desc'] = 'O número de pedidos permitidos por hora, por utilizador.';
