<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ai', language 'ja', version '4.5'.
 *
 * @package     ai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptai'] = '承諾して続行する';
$string['action'] = 'アクション';
$string['action_generate_image'] = 'イメージを生成する';
$string['action_generate_image_desc'] = 'テキストプロンプトに基づいて画像を生成します。';
$string['action_generate_text'] = 'テキストを生成する';
$string['action_generate_text_desc'] = 'テキストプロンプトに基づいてテキストを生成します。';
$string['action_generate_text_instruction'] = 'あなたはユーザからテキスト入力を受け取ります。あなたのタスクは、ユーザのリクエストに基づいてテキストを生成することです。以下の重要なインストラクションに従ってください:
    1. 要約をプレインテキストのみで返してください。
    2. マークダウンの書式、挨拶および決まり文句は含めないでください。';
$string['action_summarise_text'] = 'テキストを要約する';
$string['action_summarise_text_desc'] = 'コースページのコンテンツに基づいてテキストを要約します。';
$string['action_summarise_text_instruction'] = 'あなたはユーザからテキスト入力を受け取ります。あなたのタスクは提供されたテキストを要約することです。以下のガイドラインに従ってください:
    1. 要約する: 長い文章を要点をまとめて短くしてください。
    2. 単純化する: 複雑な情報を特に学習者にとって理解しやすくしてください。

重要なインストラクション:
    1. 要約はプレインテキストのみで返してください。
    2. マークダウンの書式、挨拶および決まり文句を含めないでください。
    3. 明瞭さ、簡潔さ、およびアクセシビリティを重視してください。

要約は読みやすく、かつ原文の要点を効果的に伝えるようにしてください。';
$string['action_translate_text'] = 'テキストを翻訳する';
$string['action_translate_text_desc'] = '提供されたテキストをある言語から別の言語に翻訳します。';
$string['actionsettingprovider'] = '{$a} アクション設定';
$string['actionsettingprovider_desc'] = 'これらの設定は {$a->providername} がどのようにアクション {$a->actionname} を実行するか制御します。';
$string['ai'] = 'AI';
$string['aiplacements'] = 'AI配置';
$string['aiproviders'] = 'AIプロバイダ';
$string['aiusagepolicy'] = 'AI利用ポリシー';
$string['availableplacements'] = 'AIアクションが利用可能な場所を選択する';
$string['availableplacements_desc'] = '配置はAIアクションがサイト内でどのようにどこで使用できるか定義します。あなたは設定によりそれぞれの配置で利用可能なアクションを選択できます。';
$string['availableproviders'] = 'あなたのLMSに接続されているAIプロバイダを管理する';
$string['availableproviders_desc'] = 'AIプロバイダはテキスト要約または画像生成等、「アクション」を通じてあなたのサイトにAI機能を追加します。<br/>
あなたはそれぞれのプロバイダの設定でアクションを管理できます。';
$string['contentwatermark'] = 'Generated by AI';
$string['declineaipolicy'] = '拒否';
$string['manageaiplacements'] = 'AI配置を管理する';
$string['manageaiproviders'] = 'AIプロバイダを管理する';
$string['noproviders'] = 'このアクションは利用できません。このアクションのために設定された<a href="{$a}">AI プロバイダ</a>はありません。';
$string['placement'] = '配置';
$string['placementactionsettings'] = 'アクション';
$string['placementactionsettings_desc'] = 'この配置で利用可能なAIアクションです。';
$string['placementsettings'] = '配置別設定';
$string['placementsettings_desc'] = 'これらの設定はAI配置がどのようにAIサービスに接続するか、および関連する操作を制御します。';
$string['privacy:metadata:ai_action_generate_image'] = 'ユーザによる画像生成リクエストを格納するテーブルです。';
$string['privacy:metadata:ai_action_generate_image:aspectratio'] = '生成される画像の縦横比です。';
$string['privacy:metadata:ai_action_generate_image:numberimages'] = '生成された画像数です。';
$string['privacy:metadata:ai_action_generate_image:prompt'] = '画像生成リクエストのプロンプトです。';
$string['privacy:metadata:ai_action_generate_image:quality'] = '生成された画像のクオリティです。';
$string['privacy:metadata:ai_action_generate_image:revisedprompt'] = '生成された画像の修正プロンプトです。';
$string['privacy:metadata:ai_action_generate_image:sourceurl'] = '生成された画像のソースURLです。';
$string['privacy:metadata:ai_action_generate_image:style'] = '生成された画像のスタイルです。';
$string['privacy:metadata:ai_action_generate_text'] = 'ユーザによるテキスト生成リクエストを格納するテーブルです。';
$string['privacy:metadata:ai_action_generate_text:completiontoken'] = 'テキストを生成するために使用される補完トークンです。';
$string['privacy:metadata:ai_action_generate_text:fingerprint'] = 'モデルおよびコンテンツの状態/バージョンを表すユニークなハッシュです。';
$string['privacy:metadata:ai_action_generate_text:generatedcontent'] = '入力プロンプトに基づいてAIモデルが生成した実際のテキストです。';
$string['privacy:metadata:ai_action_generate_text:prompt'] = 'テキスト生成リクエストのプロンプトです。';
$string['privacy:metadata:ai_action_generate_text:prompttokens'] = 'テキストを生成するために使用されるプロンプトトークンです。';
$string['privacy:metadata:ai_action_generate_text:responseid'] = 'レスポンスのIDです。';
$string['privacy:metadata:ai_action_register'] = 'ユーザによるアクションリクエストを格納するテーブルです。';
$string['privacy:metadata:ai_action_register:actionid'] = 'アクションリクエストのIDです。';
$string['privacy:metadata:ai_action_register:actionname'] = 'リクエストのアクション名です。';
$string['privacy:metadata:ai_action_register:provider'] = 'リクエストを処理したプロバイダ名です。';
$string['privacy:metadata:ai_action_register:success'] = 'アクションリクエストの状態です。';
$string['privacy:metadata:ai_action_register:timecompleted'] = 'リクエストの完了時間です。';
$string['privacy:metadata:ai_action_register:timecreated'] = 'リクエストの作成時間です。';
$string['privacy:metadata:ai_action_register:userid'] = 'リクエストしたユーザのIDです。';
$string['privacy:metadata:ai_action_summarise_text'] = 'ユーザによる要約テキスト要求を格納するテーブルです。';
$string['privacy:metadata:ai_action_summarise_text:completiontoken'] = 'テキストを要約するために使用される完了トークンです。';
$string['privacy:metadata:ai_action_summarise_text:fingerprint'] = 'モデルおよびコンテンツの状態/バージョンを表すユニークなハッシュです。';
$string['privacy:metadata:ai_action_summarise_text:generatedcontent'] = '入力プロンプトに基づいてAIモデルが生成した実際のテキストです。';
$string['privacy:metadata:ai_action_summarise_text:prompt'] = 'テキスト要約リクエストのプロンプトです。';
$string['privacy:metadata:ai_action_summarise_text:prompttokens'] = 'テキストの要約に使われたプロンプトトークンです。';
$string['privacy:metadata:ai_action_summarise_text:responseid'] = 'レスポンスのIDです。';
$string['privacy:metadata:ai_policy_register'] = 'それぞれのユーザのAIポリシーの受け入れ状況を格納するテーブルです。';
$string['privacy:metadata:ai_policy_register:contextid'] = 'データが保存されたコンテクストのIDです。';
$string['privacy:metadata:ai_policy_register:timeaccepted'] = 'ユーザがAIポリシーを承認した時間です。';
$string['privacy:metadata:ai_policy_register:userid'] = 'データを保存したユーザのIDです。';
$string['provider'] = 'プロバイダ';
$string['provideractionsettings'] = 'アクション';
$string['provideractionsettings_desc'] = 'あなたのサイト上で {$a} が実行できるアクションを選択および設定します。';
$string['providers'] = 'プロバイダ';
$string['providersettings'] = '設定';
$string['userpolicy'] = '<h4>新しいAI機能へようこそ!</h4
<p>この人工知能 (AI) 機能は外部大規模言語モデル (LLM) のみに基づいており、あなたの学習および指導体験を向上させます。あなたがこれらのAIサービス利用を開始する前にこの利用ポリシをお読みください。</p>

<h4><strong>AI生成コンテンツの精度</strong></h4>
<p>AIは有用な提案および情報を提供できますが、その正確性は異なる場合があります。提供された情報が正確で、完全で、あなたの特定の状況に適しているかどうか、常に再確認する必要があります。</p>

<h4><strong>あなたのデータの処理方法</strong></h4>
<p>このAI機能は外部の大規模言語モデル (LLM) を使用しています。あなたがこの機能を使用する場合、あなたが共有するすべての情報または個人データはそれらLLMのプライバシポリシーに従って取り扱われます。LLMがあなたのデータをどのように取り扱うかを理解するためにLLMのプライバシポリシーをお読みになることをお勧めします。さらに、あなたのAI機能との相互作用の記録が当サイトに保存される場合があります。</p>
<p>あなたのデータがどのように処理されるかについて質問がある場合、教師または学習組織に確認してください。</p>
<p>続行することにより、あなたはこのポリシーを理解して同意したものとみなされます。</p>';
