<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'et', version '4.5'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Tegevused hinda liidse jaoks';
$string['actionsforpost'] = 'Postituse toimingud';
$string['activitydate:due'] = 'Tähtaeg:';
$string['activityoverview'] = 'Foorumites on uued postitused';
$string['addanewdiscussion'] = 'Lisa uus aruteluteema';
$string['addanewquestion'] = 'Lisa uus küsimus';
$string['addanewtopic'] = 'Lisa uus teema';
$string['addreply'] = 'Lisa vastus';
$string['addtofavourites'] = 'Alusta seda arutelu';
$string['advancedsearch'] = 'Täpsem otsing';
$string['alldiscussions'] = 'Kõik arutelud';
$string['allforums'] = 'Kõik foorumid';
$string['allowdiscussions'] = 'Kas {$a} võib postitada siia foorumisse?';
$string['allowsallsubscribe'] = 'See foorum võimaldab igaühel algatada ühe arutlusteema';
$string['allowsdiscussions'] = 'See foorum võimaldab igaühel algatada ühe aruteluteema.';
$string['allsubscribe'] = 'Liitu kõigi foorumitega';
$string['allunsubscribe'] = 'Lahku kõigist foorumitest';
$string['allusers'] = 'Kõik kasutajad';
$string['alreadyfirstpost'] = 'See on juba arutelu esimene postitus';
$string['anyfile'] = 'Mistahes fail';
$string['areaattachment'] = 'Manused';
$string['areapost'] = 'Sõnumid';
$string['attachment'] = 'Manus';
$string['attachment_help'] = 'Soovi korral saate foorumipostitusele manustada ühe või mitu faili. Kui manustate pildi, kuvatakse see sõnumi järel.';
$string['attachmentname'] = 'Manus {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Sa ei saa manuseid ilma postituse ID-ta eksportida';
$string['attachments'] = 'Manused';
$string['attachmentswordcount'] = 'Manused ja sõnaarvestus';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} vastab privaatselt {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} vastab {$a->author}';
$string['availability'] = 'Kättesaadavus';
$string['blockafter'] = 'Postituste arv blokeerimiseni';
$string['blockafter_help'] = 'See säte määrab kasutaja postituste maksimaalse lubatud arvu teatud ajavahemiku jooksul. Kasutajatele tegevusloaga mod/forum:postwithoutthrottling see postituste arvu piirang ei rakendu.';
$string['blockperiod'] = 'Aeg blokeerimiseni';
$string['blockperiod_help'] = 'Õppijatele saab seada piirangu, et nad ei saaks teatud ajavahemiku jooksul postitada rohkem kui teatud arv postitusi. Kasutajatele, kellel on tegevusluba mod/forum:postwithoutthrottling, see postituste arvu piirang ei kehti.';
$string['blockperioddisabled'] = 'Ära blokeeri';
$string['blogforum'] = 'Tavafoorum kuvatud blogilaadses vormingus';
$string['bynameondate'] = '{$a->name} – {$a->date}';
$string['cachedef_forum_is_tracked'] = 'Foorumi jälgimise olek kasutaja jaoks';
$string['calendardue'] = '{$a} on tähtaeg';
$string['cancelreply'] = 'Tühista vastus';
$string['cannotadd'] = 'Sellesse foorumisse ei saanud arutelu lisada';
$string['cannotadddiscussion'] = 'Sellesse foorumisse vestluste lisamiseks peab olema rühma liige.';
$string['cannotadddiscussionall'] = 'Teil pole kõigile osalejatele uue aruteluteema lisamise õigust.';
$string['cannotadddiscussiongroup'] = 'Sul pole võimalik arutelu luua, kuna sa ei ole ühegi rühma liige.';
$string['cannotaddsubscriber'] = 'Liitujat ID-ga {$a} ei saa sellesse foorumisse lisada.';
$string['cannotaddteacherforumto'] = 'Konverteeritud õpetajafoorumieksemplari ei saa sellel kursusel jaotisse 0 lisada';
$string['cannotcreatediscussion'] = 'Uut arutelu ei saa luua';
$string['cannotcreateinstanceforteacher'] = 'Õpetajate foorumi jaoks ei saanud uut kursusemooduli eksemplari luua';
$string['cannotdeletepost'] = 'Te ei saa seda postitust kustutada.';
$string['cannoteditposts'] = 'Te ei saa teiste kasutajate postitusi muuta.';
$string['cannotexportforum'] = 'Sa ei saa seda foorumit eksportida';
$string['cannotfavourite'] = 'Vabandust, kuid sule pole luba arutelude tähistamiseks.';
$string['cannotfinddiscussion'] = 'Arutelu ei leitud sellest foorumist';
$string['cannotfindfirstpost'] = 'Selle foorumi esimest postitust ei leitud';
$string['cannotfindorcreateforum'] = 'Õpikeskkonna peamist teadaannetefoorumit ei leitud või ei saa luua';
$string['cannotfindparentpost'] = 'Postituse {$a} kõige ülemist ülatasemepostitust ei leitud';
$string['cannotmovefromsingleforum'] = 'Arutelu ei saa lihtsast üksikaruteluga foorumist teisaldada';
$string['cannotmovenotvisible'] = 'Foorum pole nähtav';
$string['cannotmovetonotexist'] = 'Te ei saa seda foorumit teisaldada – seda pole olemas.';
$string['cannotmovetonotfound'] = 'Sihtfoorumit ei leitud sellelt kursuselt.';
$string['cannotmovetosingleforum'] = 'Ei saa teisaldada arutelu lihtsasse üksikaruteluga foorumisse';
$string['cannotpindiscussions'] = 'Vabandust, sul pole luba arutelude kinnitamiseks.';
$string['cannotpurgecachedrss'] = 'Lähte- ja / või sihtfoorumi (de) vahemällu salvestatud RSS-vooge ei õnnestunud puhastada - kontrolli oma failide õigusi';
$string['cannotremovesubscriber'] = 'Liiget ID-ga {$a} ei saanud sellest foorumist eemaldada.';
$string['cannotreply'] = 'Te ei saa sellele postitusele vastata';
$string['cannotsplit'] = 'Selle foorumi arutelusid ei saa tükeldada';
$string['cannotsubscribe'] = 'Kahjuks peate liitumiseks olema rühma liige.';
$string['cannottrack'] = 'Te ei saa selle foorumi jälgimist peatada';
$string['cannotunsubscribe'] = 'Teie liitumist selle foorumiga ei saanus tühistada';
$string['cannotupdatepost'] = 'Te ei saa seda postitust värskendada';
$string['cannotviewpostyet'] = 'Te ei saa lugeda teiste õppurite küsimusi sellel arutelul, kuna Te pole veel oma küsimust postitanud';
$string['cannotviewusersposts'] = 'See kasutaja pole teinud postitusi, mida saaksite kuvada.';
$string['cleanreadtime'] = 'Märgi vanad postitused loetuks tunnil';
$string['clicktofavourite'] = 'Sa ei ole seda arutelu tärniga tähistanud. Vajuta, et lisada tärn.';
$string['clicktolockdiscussion'] = 'Vajuta arutelu lukustamiseks';
$string['clicktosubscribe'] = 'Te ei ole aruteluga liitunud. Klõpsa tellimiseks.';
$string['clicktounfavourite'] = 'Sa oled tähistanud selle arutelu tärniga. Vajuta, et tärn eemaldada.';
$string['clicktounlockdiscussion'] = 'Vajuta arutelu avamiseks';
$string['clicktounsubscribe'] = 'Olete aruteluga liitunud. Klõpsa tellimuse tühistamiseks.';
$string['close'] = 'Sulge';
$string['closegrader'] = 'Sulge hindaja';
$string['completiondetail:discussions'] = 'Alusta arutelu: {$a}';
$string['completiondetail:posts'] = 'Tee foorumipostitusi: {$a}';
$string['completiondetail:replies'] = 'Postita vastuseid: {$a}';
$string['completiondiscussions'] = 'Õppija peab looma arutelusid:';
$string['completiondiscussionsdesc'] = 'Õppija peab looma vähemalt {$a} arutelu';
$string['completiondiscussionsgroup'] = 'Nõua arutelusid';
$string['completiondiscussionshelp'] = 'nõuavad arutelude lõpuleviimist';
$string['completionposts'] = 'Õppija peab postitama arutelusid või vastuseid:';
$string['completionpostsdesc'] = 'Õppija peab postitama vähemalt {$a} arutelu või vastust';
$string['completionpostsgroup'] = 'Nõua postitusi';
$string['completionpostshelp'] = 'nõuavad arutelude või vastuste lõpuleviimist';
$string['completionreplies'] = 'Õppijad peavad postitama vastuseid:';
$string['completionrepliesdesc'] = 'Õppija peab postitama vähemalt {$a} vastust';
$string['completionrepliesgroup'] = 'Nõua vastuseid';
$string['completionreplieshelp'] = 'nõuavad vastuste lõpuleviimist';
$string['configcleanreadtime'] = 'Tund päevas, kui vanad postitused kustutatakse loetud postituste tabelist.';
$string['configdigestmailtime'] = 'Inimesed, kes valivad kokkuvõtvate meilisõnumite saamise, hakkavad saama igapäevaseid kokkuvõtteid. See säte kontrollib, mis ajal päeval kiri ära saadetakse (selle saadab ära järgmine pärast seda tundi käivituv cron).';
$string['configdisplaymode'] = 'Arutelude kuvamise viisi vaikeväärtus, mida kasutatakse, kui arutelude kuvamise viisi pole valitud.';
$string['configenablerssfeeds'] = 'See lüliti lubab RSS-kanali võimaluse kõigile foorumitele. Kanalid tuleb siiski igas foorumis sätete kaudu käsitsi sisse lülitada.';
$string['configenabletimedposts'] = 'Valige väärtus „Jah“, kui soovite, et uue foorumiarutelu postitamisel saab seadistada kuvamisperioodid.';
$string['configlongpost'] = 'Kõik postitused, mis on sellest pikkusest (tähemärkides, HTML-i ei arvestata) pikemad, loetakse pikaks. Õpikeskkonna esilehel, sotsiaalvorminguga kursuste lehtedel või kasutaja profiililehel kuvatavaid postitusi lühendatakse loomuliku lõiguvahetuseni väärtuste forum_shortpost ja forum_longpost vahel.';
$string['configmanydiscussions'] = 'Kuvatavate arutelude maksimaalne arv foorumis lehe kohta';
$string['configmaxattachments'] = 'Postituse manuste vaike-maksimumarv.';
$string['configmaxbytes'] = 'Kõigi õpikeskkonna foorumite manuste maksimaalse mahu vaikeväärtus (sellele kehtivad kursuse limiit ja teised kohalikud sätted)';
$string['configoldpostdays'] = 'Päevade arv, mille möödudes peetakse postitusi loetuks.';
$string['configreplytouser'] = 'Kui foorumipostitus saadetakse meilisõnumina välja, kas see peaks sisaldama postitaja meiliaadressi, et kirjasaajad saaksid postituse autorile foorumisse kirjutamise asemel isiklikult vastata? Isegi kui on valitud Jah, saab kasutaja oma andmetes meiliaadressi salajaseks märkida.';
$string['configrssarticlesdefault'] = 'Kui RSS-kanalid on lubatud, määratakse artiklite vaikearv (kas arutelud või postitused).';
$string['configrsstypedefault'] = 'Kui RSS-kanalid on lubatud, määratakse tegevuse vaiketüüp.';
$string['configshortpost'] = 'Kõik postitused, mis on sellest pikkusest (tähemärkides, HTML-i ei arvestata) lühemad, loetakse lühikeseks (vt lisateavet altpoolt).';
$string['configsubscriptiontype'] = 'Registreerimise režiimi vaikeseade.';
$string['configtrackingtype'] = 'Lugemise jälitamise vaikesäte.';
$string['configtrackreadposts'] = 'Valige Jah, kui soovite iga kasutaja jaoks loetud/lugemata postituste jälgimist.';
$string['configusermarksread'] = 'Kui valite Jah, peab kasutaja käsitsi postituse loetuks märkima. Kui valite Ei, märgitakse postitus selle kuvamise ajal loetuks.';
$string['confirmsubscribe'] = 'Kas soovite kindlasti liituda foorumiga „{$a}“?';
$string['confirmsubscribediscussion'] = 'Kas soovite kindlasti liituda aruteluga „{$a->discussion}“ foorumis „{$a->forum}“?';
$string['confirmunsubscribe'] = 'Kas soovite kindlasti tühistada liitumise foorumiga „{$a}“?';
$string['confirmunsubscribediscussion'] = 'Kas soovite kindlasti lahkuda arutelust „{$a->discussion}“ foorumis „{$a->forum}“?';
$string['couldnotadd'] = 'Teie postitust ei saanud tundmatu tõrke tõttu lisada.';
$string['couldnotdeletereplies'] = 'Kahjuks ei saa seda kustutada, kuna inimesed on sellele juba vastanud.';
$string['couldnotupdate'] = 'Teie kirja ei saa tundmatu tõrke tõttu värskendada.';
$string['created'] = 'Loodud';
$string['crontask'] = 'Foorumipostitused ja hooldustööd';
$string['cutoffdate'] = 'Sulgemisaeg';
$string['cutoffdate_help'] = 'Kui see on määratud, ei võta foorum pärast seda kuupäeva postitusi vastu.';
$string['cutoffdatereached'] = 'Sellesse foorumisse postitamise tähtaeg on läbi, nii et sa ei saa sinna enam postitada.';
$string['cutoffdatevalidation'] = 'Sulgemise aeg peab olema töö esitamise tähtajast hilisem.';
$string['delete'] = 'Kustuta';
$string['deleteddiscussion'] = 'See aruteluteema on kustutatud';
$string['deletedpost'] = 'Postitus on kustutatud';
$string['deletedposts'] = 'Need postitused on kustutatud';
$string['deleteduser'] = 'Kustutatud kasutaja';
$string['deletesure'] = 'Kas soovite selle postituse kindlasti kustutada?';
$string['deletesureplural'] = 'Kas soovite selle postituse ja kõik vastused kindlasti kustutada? ({$a} postitust)';
$string['digestmailheader'] = 'See on teie õpikeskkonna {$a->sitename} foorumite uute postituste päevakokkuvõte. Foorumi meilisätete muutmiseks avage {$a->userprefs}.';
$string['digestmailpost'] = 'Saate muuta enda foorumi kokkuvõtte-eelistusi';
$string['digestmailpostlink'] = 'Muuda foorumi ülevaate eelistusi: {$a}';
$string['digestmailprefs'] = 'teie kasutajaprofiil';
$string['digestmailsubject'] = '{$a}: foorumi kokkuvõte';
$string['digestmailtime'] = 'Tund, millal saata kokkuvõttemeilid';
$string['digestsentusers'] = 'Kokkuvõttemeilide saatmine {$a} kasutajale õnnestus.';
$string['disallowsubscribe'] = 'Tellimine pole lubatud';
$string['disallowsubscribeteacher'] = 'Liitumine pole lubatud (va õpetajad)';
$string['disallowsubscription'] = 'Liitumine';
$string['disallowsubscription_help'] = 'Foorum on konfigureeritud nii, et aruteludega ei saa liituda.';
$string['discussion'] = 'Arutelu';
$string['discussionlistsortbycreatedasc'] = 'Sorteeri loomise kuupäeva järgi kasvavas järjekorras';
$string['discussionlistsortbycreateddesc'] = 'Sorteeri loomise kuupäeva järgi kahanevas järjekorras';
$string['discussionlistsortbydiscussionasc'] = 'Sorteeri arutelu nime järgi kasvavas järjekorras';
$string['discussionlistsortbydiscussiondesc'] = 'Sorteeri arutelu nime järgi kahanevas järjekorras';
$string['discussionlistsortbygroupasc'] = 'Sorteeri rühma järgi kasvavas järjekorras';
$string['discussionlistsortbygroupdesc'] = 'Sorteeri grupi järgi kahanevas järjekorras';
$string['discussionlistsortbylastpostasc'] = 'Sorteeri viimase postituse loomise kuupäeva järgi kasvavas järjekorras';
$string['discussionlistsortbylastpostdesc'] = 'Sorteeri viimase postituse loomise kuupäeva järgi kahanevas järjekorras';
$string['discussionlistsortbyrepliesasc'] = 'Sorteeri vastuste arvu järgi kasvavas järjekorras';
$string['discussionlistsortbyrepliesdesc'] = 'Sorteeri vastuste arvu järgi kahanevas järjekorras';
$string['discussionlistsortbystarterasc'] = 'Sorteeri arutelu algataja nime järgi kasvavas järjekorras';
$string['discussionlistsortbystarterdesc'] = 'Sorteeri arutelu algataja nime järgi kahanevas järjekorras';
$string['discussionlocked'] = 'Arutelu on lukustatud, seetõttu ei saa te sellele enam vastata.';
$string['discussionlockingdisabled'] = 'Ära lukusta arutelusid';
$string['discussionlockingheader'] = 'Arutelu lukustamine';
$string['discussionmoved'] = 'See arutelu on teisaldatud asukohta {$a}.';
$string['discussionmovedpost'] = 'See arutelu on viidud üle asukohta <a href="{$a->discusshref}">here</a> in the forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Arutelu nimi';
$string['discussionnownotsubscribed'] = '{$a->name} EI SAA teavitusi uute postituste kohta foorumi „{$a->forum}“ arutelus „{$a->discussion}“.';
$string['discussionnowsubscribed'] = '{$a->name} saab teavitusi uute postituste kohta foorumi „{$a->forum}“ arutelus „{$a->discussion}“.';
$string['discussionpin'] = 'Kinnita';
$string['discussionpinned'] = 'Kinnitatud';
$string['discussionpinned_help'] = 'Kinnitatud arutelud kuvatakse foorumi ülaosas.';
$string['discussions'] = 'Arutelud';
$string['discussionsplit'] = 'Arutelu on jagatud';
$string['discussionsstartedby'] = 'Arutelud algatas {$a}';
$string['discussionsstartedbyrecent'] = 'Arutelud algatas viimati {$a}';
$string['discussionsstartedbyuserincourse'] = 'Arutelu algatas {$a->fullname} kursusel {$a->coursename}';
$string['discussionsstartedincourse'] = 'Arutelu alustatud: {$a}';
$string['discussionstartedby'] = 'Arutelu alustas {$a}';
$string['discussionsubscribed'] = 'Oled nüüd selle arutelu tellinud.';
$string['discussionsubscribestart'] = 'Saada teavitusi selle arutelu uute postituste kohta';
$string['discussionsubscribestop'] = 'Ma ei soovi saada teavitusi selle arutelu uute postituste kohta';
$string['discussionsubscription'] = 'Aruteluga liitumine';
$string['discussionsubscription_help'] = 'Aruteluga liitumine tähendab, et saate teavitusi arutelu uute postituse kohta.';
$string['discussionunpin'] = 'Vabasta';
$string['discussionunsubscribed'] = 'Oled nüüd selle arutelu tellimuse tühistanud';
$string['discussthistopic'] = 'Arutle sellel teemal';
$string['discusstopicname'] = 'Aruta teemat {$a}';
$string['displayend'] = 'Kuvamise lõpp';
$string['displayend_help'] = 'See säte määrab, kas foorumipostitus peaks olema pärast kindlat kuupäeva peidetud. Arvestage, et administraatorid saavad foorumipostitusi alati vaadata.';
$string['displayenddate'] = 'Kuva lõpp {$a}';
$string['displaymode'] = 'Kuvamisrežiim';
$string['displayperiod'] = 'Kuvamisperiood';
$string['displaystart'] = 'Kuvamise algus';
$string['displaystart_help'] = 'See säte määrab, kas foorumipostitus peaks olema kuvatud alates kindlast kuupäevast. Arvestage, et administraatorid saavad foorumipostitusi alati vaadata.';
$string['displaystartdate'] = 'Kuva algus {$a}';
$string['displaywordcount'] = 'Kuva sõnade arv';
$string['displaywordcount_help'] = 'Säte määrab, kas kõigi postituste sõnade arv kuvatakse või mitte.';
$string['duedate'] = 'Tähtaeg';
$string['duedate_help'] = 'See on siis, kui foorumisse postitamine peaks olema. Kuigi see kuupäev kuvatakse kalendris foorumi tähtpäevana, on postitamine siiski lubatud pärast seda kuupäeva. Määra foorumi lõppkuupäev, et vältida foorumisse postitamist pärast teatud kuupäeva.';
$string['duedatetodisplayincalendar'] = 'Tähtaeg kalendris kuvamiseks';
$string['eachuserforum'] = 'Igaüks postitab ühe arutelu';
$string['edit'] = 'Muuda';
$string['editdiscussion'] = 'Muuda arutelu';
$string['editdiscussiontopic'] = 'Muuda arutelu teemat';
$string['editedby'] = 'Muutis {$a->name} – algne esitus {$a->date}';
$string['editedpostupdated'] = 'Kasutaja {$a} postitust värskendati';
$string['editing'] = 'Muutmine';
$string['emaildigestcompleteshort'] = 'Kõik postitused';
$string['emaildigestdefault'] = 'Vaikimisi ({$a})';
$string['emaildigestoffshort'] = 'Ilma kokkuvõtteta';
$string['emaildigestsubjectsshort'] = 'Ainult pealkirjad';
$string['emaildigesttype'] = 'Meilikokkuvõtte valikud';
$string['emaildigesttype_help'] = 'Igast foorumist saadava teavituse tüüp:

* vaikimisi – järgib teie kasutajaprofiilist leitud kokkuvõttesätteid. Kui värskendate profiili, siis kajastub muudatus ka siin;
* ilma kokkuvõtteta – saate iga foorumipostituse kohta e-maili;
* kokkuvõte – kõik postitused – saate ühe kokkuvõtliku e-mail päevas, mis sisaldab kõiki foorumipostitusi;
* kokkuvõte – ainult teemad – saate ühe kokkuvõtliku e-maili päevas, mis sisaldab kõigi foorumipostituste teemasid.';
$string['emptymessage'] = 'Teie postitusel oli midagi viga. Võimalik, et jätsite postituse tühjaks või oli manus liiga suur. Teie tehtud muudatusi EI SALVESTATUD.';
$string['errorcannotlock'] = 'Sul ei ole õigusi arutelu lukustamiseks';
$string['errordiscussionnotfound'] = 'Arutelu ei leitud';
$string['erroremptymessage'] = 'Postituse sõnum ei saa olla tühi';
$string['erroremptysubject'] = 'Postituse pealkirja väli ei tohi olla tühi.';
$string['errorenrolmentrequired'] = 'Sellele sisule juurdepääsemiseks peate olema sellele kursusele registreeritud';
$string['errorforumnotfound'] = 'Foorumit, kuhu see arutelu kuulub, ei leitud';
$string['errorwhiledelete'] = 'Kirje kustutamisel ilmnes tõrge.';
$string['eventassessableuploaded'] = 'Uut sisu on postitatud';
$string['eventcoursesearched'] = 'Otsiti kursust';
$string['eventdiscussioncreated'] = 'Arutelu on loodud';
$string['eventdiscussiondeleted'] = 'Arutelu on eemaldatud';
$string['eventdiscussionmoved'] = 'Arutelu on teisaldatud';
$string['eventdiscussionpinned'] = 'Arutelu on kinnitatud';
$string['eventdiscussionsubscriptioncreated'] = 'Aruteluga liitumine on loodud';
$string['eventdiscussionsubscriptiondeleted'] = 'Aruteluga liitumine on kustutatud';
$string['eventdiscussionunpinned'] = 'Arutelu on vabastatud';
$string['eventdiscussionupdated'] = 'Arutelu on värskendatud';
$string['eventdiscussionviewed'] = 'Arutelu värskendatud';
$string['eventpostcreated'] = 'Postitus on loodud';
$string['eventpostdeleted'] = 'Postitus on kustutatud';
$string['eventpostupdated'] = 'Postitus on värskendatud';
$string['eventreadtrackingdisabled'] = 'Lugemise jälgimine on keelatud';
$string['eventreadtrackingenabled'] = 'Lugemise jälgimine on lubatud';
$string['eventsubscribersviewed'] = 'Liikmeid on vaadatud';
$string['eventsubscriptioncreated'] = 'Liitumine on loodud';
$string['eventsubscriptiondeleted'] = 'Liitumine kustutatud';
$string['eventuserreportviewed'] = 'Kasutajaaruannet on vaadatud';
$string['everyonecanchoose'] = 'Igaüks võib valida, kas liituda';
$string['everyonecannowchoose'] = 'Kõik saavad nüüd valida liitumise';
$string['everyoneisnowsubscribed'] = 'Kõik on nüüd selle foorumiga liitunud';
$string['everyoneissubscribed'] = 'Kõik on selle foorumiga liitunud';
$string['existingsubscribers'] = 'Olemasolevad liikmed';
$string['export'] = 'Ekspordi';
$string['exportattachmentname'] = 'Ekspordi manused {$a} portfooliosse';
$string['exportdiscussion'] = 'Ekspordi kogu arutelu mappi';
$string['exporthumandates'] = 'Inimloetavad kuupäevad';
$string['exporthumandates_help'] = 'Kas kuupäevad tuleks eksportida inimesele loetavas vormingus või ajatemplina (numbrite järjestus).';
$string['exportoptions'] = 'Eksportimise valikud';
$string['exportstriphtml'] = 'Eemalda HTML';
$string['exportstriphtml_help'] = 'Kas foorumi postitussõnumist tuleks eemaldada HTML-märgendid nagu p ja br?';
$string['favourites'] = 'Tärniga';
$string['favouriteupdated'] = 'Teie tärnivalikut on värskendatud.';
$string['firstpost'] = 'Esimene postitus';
$string['forcedreadtracking'] = 'Luba lugemise sundjälgimine';
$string['forcedreadtracking_desc'] = 'Võimaldab foorumites määrata lugemise sundjälgimise. Mõnedel kasutajatel on tulemuseks vähenenud jõudlus, eriti kursustel, millel on mitmeid foorumeid ja postitusi. Kui see säte on välja lülitatud, koheldakse foorumeid, millel varem oli määratud säte Sunnitud, valikulisena.';
$string['forcesubscribed'] = 'See foorum sunnib kõiki liituma';
$string['forcesubscribed_help'] = 'Foorum on konfigureeritud nii, et arutelust ei saa lahkuda.';
$string['forum'] = 'Foorum';
$string['forum:addinstance'] = 'Lisa uus foorum';
$string['forum:addnews'] = 'Lisa teadaandeid';
$string['forum:addquestion'] = 'Lisa küsimus';
$string['forum:allowforcesubscribe'] = 'Luba liitumise sundimine';
$string['forum:canoverridecutoff'] = 'Postita foorumitesse pärast nende lõppkuupäeva';
$string['forum:canoverridediscussionlock'] = 'Vasta lukustatud aruteludele';
$string['forum:canposttomygroups'] = 'Saate postitada kõigile rühmadele, kellele on juurdepääs';
$string['forum:cantogglefavourite'] = 'Tärniga tähistatud arutelud';
$string['forum:createattachment'] = 'Saate luua manuseid';
$string['forum:deleteanypost'] = 'Saate kustutada mis tahes postitusi (mis tahes ajal)';
$string['forum:deleteownpost'] = 'Saate kustutada enda postitusi (tähtaja jooksul)';
$string['forum:editanypost'] = 'Saate muuta mis tahes postitust';
$string['forum:exportdiscussion'] = 'Saate eksportida kogu arutelu';
$string['forum:exportforum'] = 'Ekspordi foorum';
$string['forum:exportownpost'] = 'Saate eksportida oma postituse';
$string['forum:exportpost'] = 'Saate eksportida postituse';
$string['forum:grade'] = 'Hinda foorumit';
$string['forum:managesubscriptions'] = 'Saad hallata tellijaid';
$string['forum:movediscussions'] = 'Saate teisaldada arutelusid';
$string['forum:pindiscussions'] = 'Kinnita arutelud';
$string['forum:postprivatereply'] = 'Vasta postitustele privaatselt';
$string['forum:postwithoutthrottling'] = 'Postituste arvu lävendi erand';
$string['forum:rate'] = 'Saate postitusi hinnata';
$string['forum:readprivatereplies'] = 'Vaata privaatseid vastuseid';
$string['forum:replynews'] = 'Vasta teadaannetele';
$string['forum:replypost'] = 'Saate postitustele vastata';
$string['forum:splitdiscussions'] = 'Saate arutelusid tükeldada';
$string['forum:startdiscussion'] = 'Saate uusi arutelusid algatada';
$string['forum:viewallratings'] = 'Kuva kõik üksikisikute antud töötlemata hinnangud';
$string['forum:viewanyrating'] = 'Igaühe saadud koguhinnangute vaatamine';
$string['forum:viewdiscussion'] = 'Saate arutelusid kuvada';
$string['forum:viewhiddentimedposts'] = 'Saate kuvada peidetud ajastatud postitused';
$string['forum:viewqandawithoutposting'] = 'Saate alati kuvada Q- ja A-postitused (küsimused ja vastused)';
$string['forum:viewrating'] = 'Teile antud koguhinnangu vaatamine';
$string['forum:viewsubscribers'] = 'Saate kuvada liikmed';
$string['forumauthorhidden'] = 'Autor (peidetud)';
$string['forumblockingalmosttoomanyposts'] = 'Lähenete postituste lävendile. Olete perioodi {$a->blockperiod} jooksul postitanud {$a->numposts} korda ja piirang on {$a->blockafter} postitust.';
$string['forumbodydeleted'] = 'Selle foorumi postituse sisu on eemaldatud ja sellele ei pääse enam juurde.';
$string['forumbodyhidden'] = 'Te ei saa seda postitust vaadata. Põhjus võib olla üks järgmistest: te pole veel sellesse arutelusse postitanud, maksimaalne muutmisaeg pole veel läbi saanud, see arutelu pole veel alanud või on arutelu aegunud.';
$string['forumgrader'] = 'Foorumi hindaja';
$string['forumgradingnavigation'] = 'Foorumi hindamise navigeerimine';
$string['forumgradingpanel'] = 'Foorumi hindamise paneel';
$string['forumintro'] = 'Kirjeldus';
$string['forumname'] = 'Foorumi nimi';
$string['forumposts'] = 'Foorumi postitused';
$string['forums'] = 'Foorumid';
$string['forumsubjectdeleted'] = 'Foorumipostitus on eemaldatud';
$string['forumsubjecthidden'] = 'Pealkiri (peidetud)';
$string['forumtracked'] = 'Lugemata postitusi jälgitakse';
$string['forumtrackednot'] = 'Lugemata postitusi ei jälgita';
$string['forumtype'] = 'Foorumi tüüp';
$string['forumtype_help'] = 'Foorumeid on viit tüüpi:

* üks lihtne arutelu – üks aruteluteema, millele igaüks saab vastata (ei saa kasutada eraldi rühmade korral);
* igaüks postitab ühe arutelu – iga õppija saab postitada täpselt ühe uue aruteluteema, millele siis kõik saavad vastata;
* küsimuste ja vastuste foorum – õppijad peavad postitama oma vaatenurga, enne kui saavad näha teiste õppijate postitusi;
* tavafoorum blogilaadses vormingus kuvatuna – avatud foorum, kus igaüks saab alustada suvalisel ajal uue arutelu ja kus aruteluteemad kuvatakse ühel lehel koos linkidega „Arutle sellel teemal“;
* tavafoorum üldiseks kasutamiseks – avatud foorum, kus igaüks saab alustada igal ajal uue arutelu.';
$string['generalforum'] = 'Tavafoorum üldiseks kasutamiseks';
$string['generalforums'] = 'Üldised foorumid';
$string['grade_forum_header'] = 'Terve foorumi hindamine';
$string['grade_forum_name'] = 'Kogu foorum';
$string['grade_forum_title'] = 'Hinne';
$string['grade_rating_name'] = 'Reiting';
$string['graded'] = 'Hinnatud';
$string['gradedby'] = 'Hinnatud';
$string['gradeforrating'] = 'Hinne reitingu andmiseks: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Hinne hindamiseks peidetud';
$string['gradeforwholeforum'] = 'Hinne foorumi jaoks: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Foorumi hinne peidetud';
$string['gradeitem:forum'] = 'Foorum';
$string['gradeitemnameforrating'] = 'Reitingu hinne {$a->name}';
$string['gradeitemnameforwholeforum'] = 'Kogu foorumi hinne {$a->name}';
$string['grades:gradesavedfor'] = 'Hinne salvestatud {$a->fullname} jaoks';
$string['grades:gradesavefailed'] = 'Hinde salvestamine ebaõnnestus {$a->fullname}: {$a->error}';
$string['gradeusers'] = 'Hinda kasutajaid';
$string['grading'] = 'Hindamine';
$string['gradingstatus'] = 'Hinde staatus:';
$string['hiddenforumpost'] = 'Varjatud foorumipostitus';
$string['hidegraderpanel'] = 'Peida hindaja paneel';
$string['hidepreviousrepliescount'] = 'Peida eelnevad vastused ({$a})';
$string['hideusersearch'] = 'Peida kasutaja otsing';
$string['indexoutoftotal'] = '{$a->index}  {$a->total}';
$string['indicator:cognitivedepth'] = 'Kognitiivne foorum';
$string['indicator:cognitivedepth_help'] = 'See näitaja põhineb kognitiivsel sügavusel, mille õpilane on foorumi tegevuses jõudnud.';
$string['indicator:cognitivedepthdef'] = 'Kognitiivne foorum';
$string['indicator:cognitivedepthdef_help'] = 'Osaleja on selle analüüsi intervalli jooksul saavutanud selle protsendi kognitiivsest seotusest, mida foorumi tegevused pakuvad (tasemed = vaade puudub, vaade, esitamine, tagasiside vaatamine, tagasiside kommenteerimine, pärast tagasiside vaatamist uuesti esitamine)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sotsiaalne foorum';
$string['indicator:socialbreadth_help'] = 'See näitaja põhineb sotsiaalsel laiusel, mille õpilane on foorumi tegevuses saavutanud.';
$string['indicator:socialbreadthdef'] = 'Sotsiaalne foorum';
$string['indicator:socialbreadthdef_help'] = 'Osaleja on selle analüüsi intervalli jooksul saavutanud foorumi tegevuste pakutava sotsiaalse kaasatuse protsendi (tasemed = ei osale, osales üksi, osales koos teistega)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = 'foorumis {$a}';
$string['inreplyto'] = 'Vastuses {$a}';
$string['introblog'] = 'Selle foorumi postitused kopeeriti siia automaatselt kursuse kasutajate blogidest, sest need blogisissekanded pole enam saadaval';
$string['intronews'] = 'Üldised uudised ja teadaanded';
$string['introsocial'] = 'Avatud foorum mis tahes teemal vestlemiseks';
$string['introteacher'] = 'Foorum üksnes õpetajate tähelepanekuteks ja aruteluks';
$string['invalidaccess'] = 'Juurdepääs sellele lehele polnud õige';
$string['invaliddigestsetting'] = 'Pakuti sobimatu kokkuvõtesäte';
$string['invaliddiscussionid'] = 'Arutelu ID oli vale või seda pole enam olemas';
$string['invalidforcesubscribe'] = 'Sundtellimise režiim ei sobi';
$string['invalidforumid'] = 'Foorumi ID oli vale';
$string['invalidparentpostid'] = 'Ülatasemepostituse ID oli vale';
$string['invalidpostid'] = 'Postituse ID {$a} ei sobi';
$string['lastpost'] = 'Viimane postitus';
$string['learningforums'] = 'Õppefoorumid';
$string['lockdiscussion'] = 'Lukusta see arutelu';
$string['lockdiscussionafter'] = 'Lukusta teatud perioodi vältel passiivsed olnud arutelud';
$string['lockdiscussionafter_help'] = 'Arutelud saab automaatselt lukustada, kui viimasest vastusest on möödunud määratud aeg.

Kasutajad, kellel on lukustatud aruteludele vastamise luba, saavad arutelule vastata ja selle niimoodi lukust avada.';
$string['locked'] = 'Lukustatud';
$string['lockupdated'] = 'Lukustamise valik on uuendatud';
$string['longpost'] = 'Pikk postitus';
$string['mailnow'] = 'Saada foorumipostituste kohta teavitused ilma muutmisaja viivituseta';
$string['managesubscriptionsoff'] = 'Lõpeta tellimuste haldamine';
$string['managesubscriptionson'] = 'Halda tellijaid';
$string['manydiscussions'] = 'Arutelusid lehel';
$string['markalldread'] = 'Saate märkida kõik selle arutelu postitused loetuks.';
$string['markallread'] = 'Saate märkida kõik selle foorumi postitused loetuks.';
$string['markasread'] = 'Märgi loetuks';
$string['markasreadonnotification'] = 'Foorumipostituste teavituste saatmisel';
$string['markasreadonnotification_help'] = 'Kui teid teavitatakse foorumipostitusest, saate valida, kas see tegevus märgib postituse loetuks.';
$string['markasreadonnotificationno'] = 'Ära märgi postitust loetuks';
$string['markasreadonnotificationyes'] = 'Märgi postitus loetuks';
$string['markread'] = 'Märgi loetuks';
$string['markreadbutton'] = 'Märgi<br />loetuks';
$string['markunread'] = 'Märgi mitteloetuks';
$string['markunreadbutton'] = 'Märgi<br />mitteloetuks';
$string['maxattachments'] = 'Manuste maksimumarv';
$string['maxattachments_help'] = 'See säte määrab foorumipostitusele manustada lubatavate failide maksimaalse arvu.';
$string['maxattachmentsize'] = 'Manuse maksimaalne maht';
$string['maxattachmentsize_help'] = 'See säte määrab foorumipostitusele manustatava faili suurima lubatava mahu.';
$string['maxtimehaspassed'] = 'Kahjuks on maksimaalne selle postituse muutmiseks lubatud aeg ({$a}) läbi.';
$string['message'] = 'Sõnum';
$string['messageinboundattachmentdisallowed'] = 'Vastust ei saanud postitada, kuna sellel on manus ja foorum ei luba manuseid.';
$string['messageinboundfilecountexceeded'] = 'Vastust ei saanud postitada, kuna sellel on rohkem manuseid kui maksimaalne foorumile lubatud arv ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Vastust ei saanud postitada, kuna manuste kogumaht ({$a->filesize}) on suurem, kui foorumile lubatud maksimaalne manuste maht ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Vastust ei saanud postitada, kuna foorum pole praegu saadaval.';
$string['messageinboundnopostforum'] = 'Vastust ei saanud postitada, kuna puudub õigus postitada foorumis {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Vastust ei saanud postitada. Olete ületanud sellele foorumile määratud postituste arvu lävendi';
$string['messageprovider:digests'] = 'Tellitud foorumite kokkuvõtted';
$string['messageprovider:posts'] = 'Tellitud foorumite postitused';
$string['missingsearchterms'] = 'Järgmised otsingusõnad leiduvad ainult selle sõnumi HTML-märgistuses.';
$string['modeflatnewestfirst'] = 'Kuva vastused lamedalt, uuemad eespool';
$string['modeflatoldestfirst'] = 'Kuva vastused lamedalt, vanemad eespool';
$string['modenested'] = 'Kuva vastused pesastatud kujul';
$string['modethreaded'] = 'Kuva vastused jutulõime kujul';
$string['modulename'] = 'Foorum';
$string['modulename_help'] = 'Foorumi tegevusmoodul lubab osalejatele asünkroonseid arutelusid, st arutelusid, mis toimuvad pikema aja jooksul.

Valida saab mitut tüüpi foorumi vahel: tavafoorum, kus igaüks võib igal ajal algatada uue arutelu; foorum, kus õppijad saavad postitada ainult ühe arutelu; või küsimuste-vastuste foorum, kus õppijad peavad enne teiste postituste nägemist ise midagi postitama. Õpetajad võivad lubada foorumipostitustele lisada manuseid. Manustatud pildid kuvatakse foorumipostitustes.

Osalejad saavad foorumiga liituda, et saada teavitusi foorumi uute postituste kohta. Õpetaja võib liitumisrežiimi seadistada valikuliseks, sunnituks või automaatseks või keelata liitumise täiesti. Vajaduse korral saab seada piirangu, et õppijad ei saaks kindla ajaperioodi jooksul postitada rohkem kui teatud arvu postitusi; nii saab ära hoida aruteludes domineerimise. Nii õppijad kui ka õpetajad saavad foorumipostitusi hinnata (õpikaaslaste hindamine).

Hinnanguid saab koondada lõpphinde moodustamiseks, mis jäädvustatakse hinnetelehel.

Foorumil on mitu otstarvet:

* sotsiaalne ruum õppijatele üksteise tundmaõppimiseks;
* kursuse teadaannete edastamiseks (kasutades sunnitud liitumisega uudistefoorumit);
* kursuse sisu või lugemismaterjalide üle arutamiseks;
* silmast silma seansil alustatud probleemi arutelu jätkamine võrgus;
* ainult õpetajatele mõeldud arutelud (kasutades peidetud foorumeid);
* abikeskus, kus juhendajad saavad nõu anda;
* üks-ühele-tugiala õppija-õpetaja privaatseks suhtluseks (kasutades eraldi rühmade foorumit, üks õppija rühma kohta);
* lisategevused, nagu nuputamisülesanded õppijatele mõtlemiseks ja lahenduste välja pakkumiseks.';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Foorumid';
$string['more'] = 'rohkem';
$string['movedmarker'] = 'Teisaldatud';
$string['movethisdiscussionlabel'] = 'Teisalda praegune arutelu määratud foorumisse';
$string['movethisdiscussionto'] = 'Teisalda arutelu kohta ...';
$string['mustprovidediscussionorpost'] = 'Eksportimiseks peate sisestama kas arutelu ID või postituse ID';
$string['myprofileotherdis'] = 'Foorumiarutelud';
$string['myprofileowndis'] = 'Minu foorumiarutelud';
$string['myprofileownpost'] = 'Minu foorumipostitused';
$string['namenews'] = 'Teated õppijatele / News Forum';
$string['namenews_help'] = 'Kursuse teadaannete foorum on teadaannete erifoorum ja luuakse kursuse loomisel automaatselt. Kursusel saab olla ainult üks teadaannetefoorum. Teadaannetefoorumisse saavad postitada ainult õpetajad ja administraatorid. Plokis „Värsked uudised“ kuvatakse viimatised teadaanded.';
$string['namesocial'] = 'Sotsiaalfoorum';
$string['nameteacher'] = 'Õpetajate foorum';
$string['newforumposts'] = 'Uued foorumipostitused';
$string['nextdiscussiona'] = 'Järgmine arutelu: {$a}';
$string['nextuser'] = 'Salvesta muudatused ja jätka järgmise kasutajaga';
$string['noattachments'] = 'Sellel postitusel ei ole manuseid';
$string['nodiscussions'] = 'Selles foorumis pole veel aruteluteemasid';
$string['nodiscussionsstartedby'] = '{$a} pole veel ühtegi arutelu alustanud';
$string['nodiscussionsstartedbyyou'] = 'Te pole veel algatanud ühtegi arutelu';
$string['noguestpost'] = 'Kahjuks pole külalistel lubatud postitada.';
$string['noguestsubscribe'] = 'Kahjuks pole külalistel lubatud liituda.';
$string['noguesttracking'] = 'Kahjuks pole külalistel lubatud postituse jälgimise valikuid määrata.';
$string['nomorepostscontaining'] = '\'{$a}\' sisaldavaid postitusi rohkem ei ole.';
$string['nonews'] = 'Teadaandeid pole veel postitatud.';
$string['noonecansubscribenow'] = 'Tellimused pole praegu lubatud';
$string['nopermissiontosubscribe'] = 'Teil pole foorumi liikmete kuvamiseks õigusi';
$string['nopermissiontoview'] = 'Teil pole selle postituse kuvamiseks õigusi';
$string['nopostforum'] = 'Kahjuks pole teil lubatud sellesse foorumisse postitada';
$string['noposts'] = 'Postitusi pole';
$string['nopostsmadebyuser'] = '{$a} ei ole postitusi teinud';
$string['nopostsmadebyyou'] = 'Te pole ühtegi postitust teinud';
$string['noquestions'] = 'Sellel foorumil pole veel küsimusi esitatud';
$string['nosubscribers'] = 'Sellel foorumil pole veel liikmeid';
$string['notexists'] = 'Arutelu pole enam olemas';
$string['notgraded'] = 'Ei ole hinnatud';
$string['nothingnew'] = 'Kasutajale {$a} pole midagi uut';
$string['notingroup'] = 'Kahjuks peate selle foorumi nägemiseks olema rühma liige.';
$string['notinstalled'] = 'Foorumimoodul pole installitud';
$string['notlocked'] = 'Lukusta';
$string['notpartofdiscussion'] = 'See postitus ei ole osa arutelust.';
$string['notrackforum'] = 'Ära jälgi lugemata sõnumeid';
$string['notsubscribed'] = 'Telli';
$string['nousersmatch'] = 'Antud kriteeriumiga kasutajaid ei leitud';
$string['noviewdiscussionspermission'] = 'Teil pole õigust selle foorumi arutelusid kuvada';
$string['nowallsubscribed'] = 'Kõigi üksuse {$a} foorumitega on liitutud.';
$string['nowallunsubscribed'] = 'Kõigi üksuse {$a} foorumitega pole liitutud.';
$string['nowgradinguser'] = 'Praegu hindab {$a}';
$string['nownotsubscribed'] = '{$a->name} EI saa teavitusi uute postituste kohta foorumis „{$a->forum}“';
$string['nownottracking'] = '{$a->name} ei jälgi enam foorumit „{$a->forum}“.';
$string['nowsubscribed'] = '{$a->name} saab teavitusi uute postituste kohta foorumis „{$a->forum}“';
$string['nowtracking'] = '{$a->name} jälgib nüüd foorumit „{$a->forum}“.';
$string['numberofreplies'] = 'Vastuste arv {$a}';
$string['numposts'] = '{$a} postitust';
$string['olderdiscussions'] = 'Vanemad arutelud';
$string['oldertopics'] = 'Vanemad teemad';
$string['oldpostdays'] = 'Päeva pärast loetud';
$string['page-mod-forum-discuss'] = 'Foorumimooduli arutelulõime leht';
$string['page-mod-forum-view'] = 'Foorumimooduli pealeht';
$string['page-mod-forum-x'] = 'Suvaline foorumimooduli leht';
$string['parent'] = 'Kuva ülatasemeüksus';
$string['parentofthispost'] = 'Selle postituse algataja';
$string['permalink'] = 'Püsilink';
$string['permanentlinktoparentpost'] = 'Püsilink selle postituse ülempostitusele';
$string['permanentlinktopost'] = 'Püsilint sellele postitusele';
$string['pindiscussion'] = 'Tõsta see arutelu esile';
$string['pinupdated'] = 'See esiletõstmise valik on uuendatud';
$string['pluginadministration'] = 'Foorumi haldamine';
$string['pluginname'] = 'Foorum';
$string['postadded'] = 'Teie postitus lisati edukalt.<br />Teil on soovi korral {$a} selle muutmiseks.';
$string['postaddedsuccess'] = 'Teie postituse lisamine õnnestus';
$string['postaddedtimeleft'] = 'Kui soovite teha muudatusi, siis on teil muutmiseks aega {$a}.';
$string['postbymailsuccess'] = 'Palju õnne, foorumipostitus teemal „{$a->subject}“ on nüüd lisatud. Saate seda vaadata siin: {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'Palju õnne, <a href="{$a->discussionurl}">foorumipostitus</a> teemal „{$a->subject}“ on nüüd postitatud.';
$string['postbyuser'] = 'Kasutaja {$a->user} postitus {$a->post}';
$string['postincontext'] = 'Kuva see postitus kontekstis';
$string['postisprivatereply'] = 'See on privaatne vastus. See ei ole teistele osalejatele nähtav.';
$string['postmailinfo'] = 'See on koopia sõnumist, mis postitati veebisaidil {$a}.

Vastamiseks klõpsake seda linki:';
$string['postmailnow'] = '<p>See postitus saadetakse kohe e-kirjana kõigile foorumi liikmetele.</p>';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['posts'] = 'Postitused';
$string['postsfrom'] = 'Postitused';
$string['postsmadebyuser'] = 'Kasutaja {$a} postitused';
$string['postsmadebyuserincourse'] = 'Kasutaja {$a->fullname} postitused kursusel {$a->coursename}';
$string['poststo'] = 'Postitused';
$string['posttoforum'] = 'Postita foorumisse';
$string['posttomygroups'] = 'Postita koopia kõigile rühmadale';
$string['posttomygroups_help'] = 'Postitab sõnumi koopia kõigile rühmadele, kellele on juurdepääs. Osalejad rühmades, kellele teil ei ole juurdepääsu, ei näe postitust';
$string['postupdated'] = 'Teie postitust värskendati';
$string['potentialsubscribers'] = 'Võimalikud liitujad';
$string['prevdiscussiona'] = 'Eelmine arutelu: {$a}';
$string['previoususer'] = 'Salvesta muudatused ja jätka eelmise kasutajaga';
$string['privacy:digesttypenone'] = 'Meil ei ole selle foorumi jaoks eelistatud foorumi kokkuvõtte tüübiga seotud andmeid.';
$string['privacy:digesttypepreference'] = 'Oled valinud järgmise foorumi kokkuvõtte tüübi: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Oled valinud selle foorumi jaoks järgmise arutelu tellimuseelistuse: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Foorum kasutab postituste hindamise toetamiseks reitingute alamsüsteemi.';
$string['privacy:metadata:core_tag'] = 'Foorum kasutab siltide alamsüsteemi postituste sildistamise toetamiseks.';
$string['privacy:metadata:forum_digests'] = 'Teave iga foorumi kokkuvõtlike eelistuste kohta.';
$string['privacy:metadata:forum_digests:forum'] = 'Foorum tellis.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Kokkuvõtte eelistus.';
$string['privacy:metadata:forum_digests:userid'] = 'Kokkuvõtte eelistuse märkinud kasutaja ID';
$string['privacy:metadata:forum_discussion_subs'] = 'Teave üksikute foorumiarutelude tellimuste kohta';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'Tellitud arutelu ID.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Tellimuse algusaeg.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'Tellimuse algusaeg.';
$string['privacy:metadata:forum_discussions'] = 'Teave kasutaja loodud individuaalsete foorumiarutelude kohta';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODO - mida see väli salvestab';
$string['privacy:metadata:forum_discussions:name'] = 'Arutelu nimi, mille autor on valinud.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Aeg, mil arutelu viimati muudeti.';
$string['privacy:metadata:forum_discussions:userid'] = 'Arutelu loonud kasutaja ID';
$string['privacy:metadata:forum_discussions:usermodified'] = 'Viimati arutelu kuidagi muutnud kasutaja ID.';
$string['privacy:metadata:forum_grades'] = 'Foorumi hinnete andmed';
$string['privacy:metadata:forum_grades:forum'] = 'Foorum mida hinnati';
$string['privacy:metadata:forum_grades:grade'] = 'Autasustatud hinne';
$string['privacy:metadata:forum_grades:userid'] = 'Kasutaja keda hinnati';
$string['privacy:metadata:forum_posts'] = 'Teave iga foorumi kokkuvõtlike eelistuste kohta.';
$string['privacy:metadata:forum_posts:created'] = 'Postituse loomise aeg';
$string['privacy:metadata:forum_posts:discussion'] = 'Diskussioon milles postitus asub';
$string['privacy:metadata:forum_posts:message'] = 'Sõnum foorumi postituses';
$string['privacy:metadata:forum_posts:modified'] = 'Viimane posituse muutmise aeg';
$string['privacy:metadata:forum_posts:parent'] = 'Ülempostitus millele vastati';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'Kasutaja ID kellele vastus saadeti';
$string['privacy:metadata:forum_posts:subject'] = 'Foorumipostituse teema';
$string['privacy:metadata:forum_posts:totalscore'] = 'Foorumi sõnum';
$string['privacy:metadata:forum_posts:userid'] = 'Foorumipostituse kirjutanud kasutaja ID.';
$string['privacy:metadata:forum_queue'] = 'Ajutine logi postitustest, mis postitatakse kokkuvõtlikult';
$string['privacy:metadata:forum_queue:discussionid'] = 'Foorumi arutelu ID';
$string['privacy:metadata:forum_queue:postid'] = 'Foorumi postituse ID';
$string['privacy:metadata:forum_queue:timemodified'] = 'Originaalspostituse muutmise kuupäev';
$string['privacy:metadata:forum_queue:userid'] = 'Kasutaja, keda tuleb postitusest teavitada';
$string['privacy:metadata:forum_read'] = 'Informatsioon selle kohta milliseid positusi on kasutaja poolt loetud';
$string['privacy:metadata:forum_read:discussionid'] = 'Arutelu milles postitus on';
$string['privacy:metadata:forum_read:firstread'] = 'Esimene kord kui postitust loeti';
$string['privacy:metadata:forum_read:lastread'] = 'Viimane aeg mil positust loeti';
$string['privacy:metadata:forum_read:postid'] = 'Postitus mida loeti';
$string['privacy:metadata:forum_read:userid'] = 'Kasutaja kellega see kaart on seotud';
$string['privacy:metadata:forum_subscriptions'] = 'Teave selle kohta, milliseid foorumeid kasutaja on tellinud.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Foorum mis telliti';
$string['privacy:metadata:forum_subscriptions:userid'] = 'Kasutaja ID kellega foorumi tellimus on seotud';
$string['privacy:metadata:forum_track_prefs'] = 'Teave selle kohta, milliste foorumite jaoks kasutaja on postituse lugemise valinud.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Foorum, millel on lugemise jälgimine lubatud.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'Kasutaja ID, kellega see foorumi jälgimiseelistus on seotud.';
$string['privacy:metadata:preference:autosubscribe'] = 'Kas tellida arutelusid, kui vastad nendes sisalduvatele postitustele.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Arutelude loendi eelistatud sortimisjärjestus';
$string['privacy:metadata:preference:maildigest'] = 'Saidi ülene postituse eelistus';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Kas märkida foorumi postitused loetuks, kui need sõnumina vastu võetakse';
$string['privacy:metadata:preference:trackforums'] = 'Kas lubada lugemise jälgimine.';
$string['privacy:postwasread'] = 'Seda postitust loeti esimest korda lehel {$a->firstread} ja viimati loeti lehel {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Oled otsustanud mitte jälgida selles foorumis lugenud postitusi.';
$string['privacy:request:delete:discussion:name'] = 'Kustuta autori soovil';
$string['privacy:request:delete:post:message'] = 'Selle postituse sisu on selle autori taotlusel kustutatud.';
$string['privacy:request:delete:post:subject'] = 'Kustuta autori soovil';
$string['privacy:subscribedtoforum'] = 'Oled tellinud selle foorumi.';
$string['privatereply'] = 'Vasta privaatselt';
$string['privatereply_help'] = 'Privaatset vastust saavad vaadata ainult postituse autor, millele vastatakse, ja kõik kasutajad, kellel on võimalus privaatseid vastuseid vaadata.';
$string['processingdigest'] = 'E-posti kokkuvõtte koostamine kasutajale {$a}';
$string['processingpost'] = 'Töötlen postitust {$a}';
$string['prune'] = 'Tükelda';
$string['prunedpost'] = 'Sellest postitusest arenes uus aruteluteema';
$string['pruneheading'] = 'Saate arutelu tükeldada ja teisaldada selle postituse uude arutelusse';
$string['qandaforum'] = 'Q ja A (küsimuste ja vastuste) foorum';
$string['qandanotify'] = 'See on küsimuste ja vastuste foorum. Et näha teiste vastuseid nendele küsimustele, tuleb kõigepealt postitada enda vastus.';
$string['re'] = 'Vastus:';
$string['readtherest'] = 'Loe selle teema kohta edasi';
$string['removeallforumtags'] = 'Eemalda kõik foorumisildid';
$string['removefromfavourites'] = 'Eemalda arutelult tärn';
$string['replies'] = 'Vastused';
$string['repliesmany'] = 'Praeguseks {$a} vastust';
$string['repliesone'] = 'Praeguseks {$a} vastus';
$string['reply'] = 'Vasta';
$string['reply_handler'] = 'Vasta foorumipostitustele meilisõnumiga';
$string['reply_handler_name'] = 'Vasta foorumipostitustele';
$string['replyauthorself'] = '{$a} (sina)';
$string['replyforum'] = 'Vasta foorumile';
$string['replyingtoauthor'] = 'Vastan {$a}...';
$string['replyplaceholder'] = 'Kirjuta oma vastus...';
$string['replytopostbyemail'] = 'Saate vastata sellele meilisõnumiga.';
$string['replytouser'] = 'Kasuta vastamisel meiliaadressi';
$string['resetdigests'] = 'Kustuta kõik kasutajakohased foorumi kokkuvõtte-eelistused';
$string['resetforums'] = 'Kustuta postitused kohast';
$string['resetforumsall'] = 'Kustuta kõik postitused';
$string['resetsubscriptions'] = 'Kustuta kõik foorumiga liitumised';
$string['resettrackprefs'] = 'Kustuta kõik foorumi jälgimise eelistused';
$string['rssarticles'] = 'Hiljutiste RSS-artiklite arv';
$string['rssarticles_help'] = 'See säte määrab RSS-kanalisse kaasatavate artiklite (arutelude või postituste) arvu. Vahemik 5–20 on üldiselt vastuvõetav.';
$string['rsssubscriberssdiscussions'] = 'Arutelude RSS-kanal';
$string['rsssubscriberssposts'] = 'Postituste RSS-kanal';
$string['rsstype'] = 'Selle tegevuse RSS-kanal';
$string['rsstype_help'] = 'Selle tegevuse kohta RSS-kanali sisselülitamiseks valige kanalisse kaasamiseks arutelud või postitused.';
$string['rsstypedefault'] = 'RSS-kanali tüüp';
$string['search'] = 'Otsing';
$string['search:activity'] = 'Foorum – tegevuse teave';
$string['search:post'] = 'Foorum – postitused';
$string['searchdatefrom'] = 'Postitused peavad sellest kuupäevast hilisemad olema';
$string['searchdateto'] = 'Postitused peavad sellest kuupäevast varasemad olema';
$string['searchforumintro'] = 'Sisestage otsingusõnad vähemalt ühele järgmistest väljadest:';
$string['searchforums'] = 'Otsing foorumitest';
$string['searchfullwords'] = 'Need sõnad peavad olema terved sõnad';
$string['searchnotwords'] = 'Neid sõnu EI tohi kaasata';
$string['searcholderposts'] = 'Otsi vanemaid postitusi ...';
$string['searchphrase'] = 'Postituses peab esinema täpselt see fraas';
$string['searchresults'] = 'Otsingutulemid';
$string['searchsubject'] = 'Need sõnad peavad esinema pealkirjas';
$string['searchtags'] = 'On märgistatud sildiga';
$string['searchuser'] = 'See nimi peab vastama autori nimele';
$string['searchuserid'] = 'Autori Moodle ID';
$string['searchusers'] = 'Otsi kasutajaid';
$string['searchwhichforums'] = 'Saate valida, millistest foorumitest otsida';
$string['searchwords'] = 'Need sõnad võivad esineda igal pool postituses';
$string['seeallposts'] = 'Vaata selle kasutaja kõiki postitusi';
$string['sendstudentnotificationsdefault'] = 'Vaikimisi seade "Teavita õppureid"';
$string['sendstudentnotificationsdefault_help'] = 'Määra hindamisvormi märkeruudu "Teata õpilasi" vaikeväärtus.';
$string['sendstudentnotificationsno'] = 'Ei';
$string['sendstudentnotificationsyes'] = 'Jah, saada õppurile teateid';
$string['settings'] = 'Seaded';
$string['shortpost'] = 'Lühike postitus';
$string['showgraderpanel'] = 'Kuva hindaja paneel';
$string['showingcountoftotaldiscussions'] = 'Arutelude loend. Kuvatakse {$a->count} arutelu / {$a->total} arutelust';
$string['showmoreusers'] = 'Kuva rohkem kasutajaid';
$string['showpreviousrepliescount'] = 'Kuva eelnevad vastused ({$a})';
$string['showsubscribers'] = 'Kuva liikmed / muuda liikmeid';
$string['showusersearch'] = 'Kuva kasutajate otsing';
$string['singleforum'] = 'Üksik lihtne arutelu';
$string['smallmessage'] = '{$a->user} postitas foorumis {$a->forumname}';
$string['smallmessagedigest'] = 'Foorumi kokkuvõte, mis sisaldab {$a} sõnumit';
$string['starredonly'] = 'Otsin ainult tärniga tähistatud vestlusi';
$string['startedby'] = 'Algatas';
$string['subject'] = 'Teema';
$string['subscribe'] = 'Liitu selle foorumiga';
$string['subscribeall'] = 'Liida kõik kasutajad selle foorumiga';
$string['subscribed'] = 'Liitunud';
$string['subscribediscussion'] = 'Liitu aruteluga';
$string['subscribeenrolledonly'] = 'Kahjuks saavad foorumipostituste teavitusi tellida ainult kursusele registreerunud kasutajad.';
$string['subscribenone'] = 'Eemalda kõik kasutajad sellest foorumist';
$string['subscribers'] = 'Liikmed';
$string['subscriberstowithcount'] = 'Arutelu „{$a->name}“ liikmed ({$a->count})';
$string['subscribestart'] = 'Saada mulle selle foorumi uute postituste kohta teavitused';
$string['subscribestop'] = 'Ma ei soovi selle foorumi uute postituste kohta teavitusi saada';
$string['subscription'] = 'Liitumine';
$string['subscription_help'] = 'Kui olete foorumiga liitunud, tähendab see seda, et teile saadetakse uute foorumipostituste kohta teavitusi. Tavaliselt saate valida, kas soovite liituda, kuigi mõnikord on liitumine sunnitud, nii et teavitusi saadetakse kõigile.';
$string['subscriptionandtracking'] = 'Liitumine ja jälgimine';
$string['subscriptionauto'] = 'Automaatne liitumine';
$string['subscriptiondisabled'] = 'Liitumine on keelatud';
$string['subscriptionforced'] = 'Sunnitud liitumine';
$string['subscriptionmode'] = 'Liitumisrežiim';
$string['subscriptionmode_help'] = 'Kui osaleja on foorumiga liitunud, tähendab see seda, et talle saadetakse foorumiposituste kohta teavitusi. Liitumisrežiimi valikuid on neli:

* valikuline liitumine – osaleja saab valida, kas liituda;
* sunnitud liitumine – kõik on liidetakse ega saa liitumist tühistada;
* automaatne liitumine – esialgu liidetakse kõik, kuid igaüks saab soovi korral alati liitumise tühistada;
* liitumine keelatud – liitumine pole lubatud.

Märkus: mis tahes liitumisrežiimi muudatus mõjutab ainult tulevasi kursusele registreerujaid, mitte olemasolevaid.';
$string['subscriptionoptional'] = 'Valikuline liitumine';
$string['subscriptions'] = 'Liitumised';
$string['tagarea_forum_posts'] = 'Foorumipostitused';
$string['tagsdeleted'] = 'Foorumisildid on kustutatud.';
$string['thisforumhasduedate'] = 'Sellesse foorumisse postitamise tähtaeg on {$a}.';
$string['thisforumisdue'] = 'Sellesse foorumisse postitamise tähtaeg oli {$a}.';
$string['thisforumisthrottled'] = 'Sellel foorumil on ajaperioodis tehtavate postituste arvu piirang. Saate teha ajavahemiku {$a->blockperiod} jooksul {$a->blockafter} postitust.';
$string['timed'] = 'Ajastatud';
$string['timeddiscussion'] = 'Ajastatud arutelu';
$string['timedhidden'] = 'Ajastatud olek: Õppijate eest peidetud';
$string['timedposts'] = 'Ajastatud postitused';
$string['timedvisible'] = 'Ajastatud olek: Kõigile kasutajatele nähtav';
$string['timestartenderror'] = 'Kuvatav lõpukuupäev ei saa olla alguskuupäevast varasem';
$string['togglediscussionmenu'] = 'Lülita arutelu menüüd';
$string['togglefullscreen'] = 'Lülita täisekraanile';
$string['togglesettingsdrawer'] = 'Lülita seadete sahtlit';
$string['trackforum'] = 'Jälgi lugemata postitusi';
$string['tracking'] = 'Jälgi';
$string['trackingoff'] = 'Välja lülitatud';
$string['trackingon'] = 'Sunnitud';
$string['trackingoptional'] = 'Valikuline';
$string['trackingtype'] = 'Lugemise jälgimine';
$string['trackingtype_help'] = 'Lugemise jälgimine tõstab uued postitused esile ja võimaldab nii osalejatel hõlpsalt kontrollida, milliseid postitusi nad pole veel näinud.

Kui see on määratud valikuliseks, saavad osalejad jälgimise soovi korral sisse või välja lülitada haldusplokis oleva lingi kaudu. (Kasutajad peavad foorumi jälgimise lubama ka oma foorumisätete menüüs.)

Kui haldusplokis on lubatud säte „Luba lugemise sundjälgimine“, on saadaval ka täpsem valik: sunnitud. See tähendab seda, et olenemata kasutajate foorumisätetetest, on jälgimine alati sisse lülitatud.';
$string['trackreadposts_header'] = 'Foorumi jälgimine';
$string['unlockdiscussion'] = 'Ava arutelu';
$string['unpindiscussion'] = 'Eemalda arutelu märkimine';
$string['unread'] = 'Lugemata';
$string['unreadpost'] = 'Märgi mitteloetuks';
$string['unreadposts'] = 'Lugemata postitused';
$string['unreadpostsnumber'] = '{$a} lugemata postitust';
$string['unreadpostsone'] = '1 lugemata postitus';
$string['unsubscribe'] = 'Tühista liitumine selle foorumiga';
$string['unsubscribeall'] = 'Lahku kõigist foorumitest';
$string['unsubscribeallconfirm'] = 'Praegu olete liitunud {$a->forums} foorumi, ja {$a->discussions} aruteluga. Kas soovite kindlasti tühistada kõigi foorumite ja aruteludega liitumised ja keelata automaatse aruteludega liitmise?';
$string['unsubscribeallconfirmdiscussions'] = 'Olete praegu tellinud {$a->discussions} arutelu. Kas soovite kindlasti loobuda kõikidest aruteludest ja keelata aruteludega automaatse liitumise?';
$string['unsubscribeallconfirmforums'] = 'Olete praegu tellinud {$a->forums} foorumit. Kas soovite kindlasti tühistada liitumise kõikide foorumite puhul ja keelata aruteludega automaatse liitmise?';
$string['unsubscribealldone'] = 'Kõik valikulised foorumiga liitumised eemaldati. Sunnitud liitumisega foorumitest saate sellegipoolest teavitusi. Foorumiteavituste haldamiseks avage menüü „Minu profiilisätted“ jaotis Teavitused.';
$string['unsubscribeallempty'] = 'Te pole ühegi foorumiga liitunud. Sellest serverist kõigi teavituste keelamiseks avage menüü „Minu profiilisätted“ jaotis Teavitused.';
$string['unsubscribed'] = 'Foorumiga liitumine tühistatud';
$string['unsubscribediscussion'] = 'Tühista liitumine selle aruteluga';
$string['unsubscribediscussionlink'] = 'Tühista liitumine selle aruteluga: {$a}';
$string['unsubscribelink'] = 'Tühista liitumine selle foorumiga: {$a}';
$string['unsubscribeshort'] = 'Eemalda foorumist';
$string['useexperimentalui'] = 'Kasutage eksperimentaalset sisseehitatud arutelu vaateid';
$string['usermarksread'] = 'Sõnumi loetuse käsitsi märkimine';
$string['usernavigation'] = 'Kasutaja navigeerimine';
$string['usersforumposts'] = 'Kasutaja foorumi postitused';
$string['viewalldiscussions'] = 'Kuva kõik arutelud';
$string['viewconversation'] = 'Vaata arutelu';
$string['viewgrades'] = 'Vaata hindeid';
$string['viewparentpost'] = 'Vaata ülempostitust';
$string['viewthediscussion'] = 'Kuva arutelu';
$string['warnafter'] = 'Postituste arvu hoiatuslävend';
$string['warnafter_help'] = 'Õppijaid saab hoiatada, kui nende postituste maksimaalne lubatud arv selle ajavahemiku jooksul hakkab täis saama. See säte määrab, kui mitme postituse järel neile hoiatus kuvatakse. Kasutajatele, kellel on tegevusluba mod/forum:postwithoutthrottling, see postituste arvu piirang ei kehti.';
$string['warnformorepost'] = 'Hoiatus. Selles foorumis on rohkem kui üks arutelu – kasutame kõige viimast';
$string['yournewquestion'] = 'Teie uus küsimus';
$string['yournewtopic'] = 'Teie uus aruteluteema';
$string['yourreply'] = 'Teie vastus';
