<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'factor_sms', language 'it', version '4.5'.
 *
 * @package     factor_sms
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:manage'] = 'Gestione numero di cellulare';
$string['action:revoke'] = 'Rimuovi numero di cellulare';
$string['addnumber'] = 'Numero cellulare';
$string['clientnotfound'] = 'Il client del servizio AWS non è stato trovato. Il client deve essere un nome di classe completo, ad esempio \\Aws\\S3\\S3Client.';
$string['editphonenumber'] = 'Modifica numero di telefono';
$string['editphonenumberinfo'] = 'Se non hai ricevuto il codice o hai inserito il numero sbagliato, modifica il numero e riprova.';
$string['error:emptyverification'] = 'Codice vuoto. Riprovare.';
$string['error:wrongphonenumber'] = 'Il numero di telefono fornito non è in un formato valido.';
$string['error:wrongverification'] = 'Codice errato. Riprovare.';
$string['errorawsconection'] = 'Si è verificato un errore durante il collegamento con il server AWS: {$a}';
$string['errorsmssent'] = 'Si è verificato un errore durante l\'invio del messaggio SMS contenente il codice di verifica.';
$string['event:smssent'] = 'Messaggio SMS inviato.';
$string['event:smssentdescription'] = 'Invio codice di verifica SMS all\'utente ID {$a->userid}. Informazioni: {$a->debuginfo}';
$string['info'] = 'Ricevi un codice di verifica al numero di cellulare scelto.';
$string['logindesc'] = 'Messaggio SMS contenente un codice di 6 cifre inviato al numero di cellulare {$a}';
$string['loginoption'] = 'Ricevi un codice sul tuo cellulare';
$string['loginskip'] = 'Non ho ricevuto il codice';
$string['loginsubmit'] = 'Prosegui';
$string['logintitle'] = 'Inserisci il codice di verifica inviato sul tuo cellulare';
$string['managefactor'] = 'Gestione SMS';
$string['managefactorbutton'] = 'Gestione';
$string['manageinfo'] = 'Stai utilizzando \'{$a}\' per autenticarti.';
$string['notification:smsgatewaymigration'] = 'Le impostazioni SMS sono state spostate';
$string['notification:smsgatewaymigrationinfo'] = 'È ora disponibile un nuovo sottosistema SMS per la gestione e la configurazione di tutte le funzioni correlate agli SMS. Le configurazioni SMS esistenti sono state migrate nella pagina <a href="{$a}">Gateway SMS</a>.';
$string['phonehelp'] = 'Inserire il proprio numero di cellulare (incluso il prefisso internazionale) per ricevere un codice di verifica.';
$string['pluginname'] = 'Cellulare SMS';
$string['privacy:metadata'] = 'Il plugin fattore SMS cellulare non memorizza dati personali.';
$string['revokefactorconfirmation'] = 'Rimuovere l\'SMS \'{$a}\'?';
$string['settings:aws'] = 'AWS SNS';
$string['settings:aws:key'] = 'Chiave';
$string['settings:aws:key_help'] = 'Credenziali della chiave Amazon API.';
$string['settings:aws:region'] = 'Regione';
$string['settings:aws:region_help'] = 'Regione del gateway Amazon API.';
$string['settings:aws:secret'] = 'Secret';
$string['settings:aws:secret_help'] = 'Secret delle API Amazon';
$string['settings:aws:usecredchain'] = 'Trova le credenziali AWS utilizzando la catena di provider di credenziali predefinita';
$string['settings:countrycode'] = 'Codice numerico del paese';
$string['settings:countrycode_help'] = 'Il codice chiamante senza il + iniziale come impostazione di default quando gli utenti non inseriscono un numero internazionale con un prefisso +.

Vedere il link seguente per un elenco dei codici di chiamata: {$a}';
$string['settings:duration'] = 'Durata della validità';
$string['settings:duration_help'] = 'Il periodo di tempo in cui il codice è valido.';
$string['settings:gateway'] = 'Gateway SMS';
$string['settings:gateway_help'] = 'Il provider da utilizzare per l\'invio degli SMS.';
$string['settings:heading'] = 'Gli utenti riceveranno un SMS con un codice a 6 cifre durante l\'autenticazione, che dovranno inserire per completare la procedura di accesso.

Gli utenti dovranno prima registrare il loro numero di cellulare.';
$string['settings:setupdesc'] = 'Per utilizzare gli SMS come fattore di autenticazione, è necessario prima <a href="{$a}">configurare un gateway SMS</a>.';
$string['settings:smsgateway'] = 'Gateway SMS';
$string['settings:smsgateway_help'] = 'Selezionare un gateway dall\'elenco oppure <a href="{$a}">crea un nuovo gateway</a>.';
$string['setupfactor'] = 'Impostazione SMS';
$string['setupfactorbutton'] = 'Impostazione';
$string['setupsubmitcode'] = 'Salva';
$string['setupsubmitphone'] = 'Invia codice';
$string['smsstring'] = '{$a->code} è il tuo codice di sicurezza monouso per {$a->fullname}.

@{$a->url} #{$a->code}';
$string['summarycondition'] = 'Utilizza un codice di sicurezza monouso SMS';
