<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_magnific', language 'it', version '4.5'.
 *
 * @package     theme_boost_magnific
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['background_color'] = 'Colore di sfondo';
$string['background_color_desc'] = 'Colore di sfondo dell\'intestazione e del piè di pagina!';
$string['background_color_random'] = 'Tema casuale {$a}';
$string['background_text_color'] = 'Colore del testo';
$string['background_text_color_desc'] = 'Colore del testo nella parte superiore e nel piè di pagina!';
$string['choosereadme'] = 'Boost Magnific è un tema realizzato con cura per portare colori vivaci a Moodle.';
$string['contact_address'] = 'Indirizzo';
$string['contact_email'] = 'Email';
$string['contact_phone'] = 'Numero di telefono';
$string['content_type_default'] = 'Predefinito Moodle';
$string['content_type_empty'] = '(Nessun contenuto)';
$string['content_type_footer'] = 'Tipo di contenuto per il piè di pagina';
$string['content_type_footer_desc'] = 'Seleziona il tipo di contenuto che desideri visualizzare nel piè di pagina.';
$string['content_type_home'] = 'Tipo di contenuto per la homepage';
$string['content_type_home_desc'] = 'Seleziona il tipo di contenuto che desideri visualizzare sulla homepage.';
$string['content_type_html'] = 'Pagina da creare con l\'editor';
$string['continuar'] = 'Continua a studiare';
$string['countlesson'] = '{$a} lezione';
$string['countlessons'] = '{$a} lezioni';
$string['course_access'] = 'Accedi al corso';
$string['course_moore'] = 'Maggiori dettagli';
$string['customcss'] = 'CSS personalizzato';
$string['customcss_desc'] = 'Qualsiasi regola CSS che aggiungi a questa area di testo verrà riflessa su tutte le pagine, facilitando la personalizzazione di questo tema.';
$string['custommenuitems'] = 'Elementi Personalizzati del Menu Principale';
$string['custommenuitems_desc'] = 'Puoi creare un menu personalizzato insieme ai menu principali. Il menu principale deve iniziare allineato con il bordo e i sottomenu devono essere preceduti da un trattino (-). Il numero di trattini determina la profondità dell\'elemento. Pertanto, gli elementi con un solo trattino appaiono in un sottomenu sotto l\'elemento principale precedente, e gli elementi con due trattini appaiono in un sottomenu sotto il sottomenu precedente.
Il contenuto di ogni elemento del menu deve consistere fino a tre elementi (<strong>etichetta</strong> | <strong>url</strong> | <strong>tooltip</strong> | <strong>lang</strong>), ciascuno separato dal carattere "|".
<ul>
<li><strong>etichetta</strong>: Questo è il testo che verrà visualizzato all\'interno dell\'elemento del menu. Devi specificare un\'etichetta per ogni elemento del menu.</li>
<li><strong>url</strong>: Questo è l\'URL al quale l\'utente sarà portato facendo clic sull\'elemento del menu. Questo è facoltativo; se non fornito, l\'elemento non sarà collegato a nessun luogo.<br>
Altri attributi come "target" possono essere aggiunti alla fine dell\'URL.</li>
<li><strong>tooltip</strong>: Se fornisci un URL, puoi anche scegliere di fornire un tooltip per il link creato con l\'URL. Questo è facoltativo, e se non definito, l\'etichetta viene utilizzata come tooltip per l\'elemento del menu.</li>
<li><strong>lang</strong>: Puoi aggiungere un codice lingua (o un elenco di codici separati da virgola) come quarto elemento della riga. La riga verrà visualizzata solo se l\'utente ha selezionato la/e lingua/e elencate.</li>
</ul>
Di seguito è riportato un esempio di come creare un menu personalizzato:
<blockquote><pre>
Corsi
-Tutti i corsi | /course/
-I miei corsi
--Corso Esempio
---Corso Esempio 7 | /course/view.php?id=7
---Corso Esempio 9 | /course/view.php?id=9
--Corso di Test
---Corso di Test 2 | /course/view.php?id=2
---Corso di Test 5 | /course/view.php?id=5
Google
-Google in qualsiasi lingua | https://google.com/" target="_blank
-Google in Messico | https://www.google.com.mx/" target="_blank|Etichetta Google|en
-Google in Portoghese | https://google.com.br/" target="_blank|Etichetta Google|pt,pt_br,pt_br_kids
Pagina di Supporto | https://support.com/" target="_blank
</pre></blockquote>
Per Moodle con supporto per più lingue, il valore <strong>etichetta</strong> deve essere formattato come <strong>"langstringname,componentname"</strong>.
<blockquote><pre>
profilo,moodle | /user/profile.php
messaggi,messaggio | /message/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Advanced_theme_settings" target="_blank">Ulteriori informazioni sul menu</a>';
$string['editor_link_footer'] = 'Modifica il blocco piè di pagina per la lingua {$a}';
$string['editor_link_footer_all'] = 'Modifica il blocco piè di pagina per tutte le lingue';
$string['editor_link_home'] = 'Modifica la homepage per la lingua {$a}';
$string['editor_link_home_all'] = 'Modifica la homepage per tutte le lingue';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Il favicon viene visualizzato accanto al titolo della pagina nella scheda del browser. Viene visualizzato un favicon di Moodle se non viene fornito un favicon personalizzato.';
$string['fontfamily'] = 'Font del testo del sito';
$string['fontfamily_desc'] = 'Scegli quale font utilizzare per il testo sul tuo sito Moodle.';
$string['fontfamily_menus'] = 'Font dei menu';
$string['fontfamily_menus_desc'] = 'Scegli quale font utilizzare per i menu sul tuo sito Moodle.';
$string['fontfamily_sitename'] = 'Font per il nome del sito';
$string['fontfamily_sitename_desc'] = 'Il font che verrà applicato al nome del sito se non viene fornito un logo.';
$string['fontfamily_title'] = 'Font del testo del titolo';
$string['fontfamily_title_desc'] = 'Scegli quale font utilizzare per i titoli sul tuo sito Moodle.';
$string['fontpreview'] = 'Anteprima Lista Font';
$string['footer_contact_title'] = 'Titolo blocco contatti';
$string['footer_contact_title_default'] = 'Contattaci';
$string['footer_contact_title_desc'] = 'Inserisci il titolo del blocco che apparirà nel piè di pagina con i dettagli di contatto.';
$string['footer_description'] = 'Descrizione';
$string['footer_description_desc'] = 'Descrivi il tuo Moodle, cosa fai, e queste informazioni saranno mostrate sotto il logo nel piè di pagina di Moodle';
$string['footer_frontpage_blockcourses_instructor'] = 'Mostra il nome del professore';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'Se selezionato, mostra i nomi dei professori nell\'elenco dei corsi!';
$string['footer_frontpage_blockcourses_text'] = 'Breve testo che spiega il blocco "{$a}"';
$string['footer_frontpage_blockcourses_text_desc'] = 'Aggiungi un testo che parli di "{$a}"!';
$string['footer_links_title'] = 'Titolo Blocco Collegamenti';
$string['footer_links_title_default'] = 'Collegamenti Importanti';
$string['footer_show_copywriter'] = 'Mostra Realizzato con ❤️';
$string['footer_show_copywriter_desc'] = 'Deseleziona se vuoi nascondere "Realizzato con ❤️"';
$string['footer_social_title'] = 'Titolo Blocco Collegamenti Social';
$string['footer_social_title_default'] = 'Seguici sui social media';
$string['footer_social_title_desc'] = 'Inserisci il titolo del blocco che apparirà nel piè di pagina con i dati dei tuoi social network.';
$string['footerblink'] = 'Collegamenti Piede di Pagina';
$string['footerblink_desc'] = 'Puoi configurare qui dei Collegamenti Piede di Pagina da mostrare nei temi.<br>Ogni riga consiste in un testo di menu o chiave di lingua o testo, un URL di collegamento (opzionale), separati da barre verticali. Per esempio:<br><pre>Supporto Moodle|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Blocco contatti';
$string['footerblock_copywriter'] = 'Realizzato con ❤️';
$string['footerblock_description'] = 'Blocco descrizione';
$string['footerblock_links'] = 'Blocco collegamenti';
$string['footerblock_social'] = 'Blocco social';
$string['free_name'] = 'Gratis';
$string['frontpage_about_description'] = 'Descrivi cosa fai';
$string['frontpage_about_description_desc'] = 'Descrivi in un massimo di 5 righe lo scopo del tuo Moodle';
$string['frontpage_about_enable'] = 'Abilita blocco Informazioni';
$string['frontpage_about_enable_desc'] = 'Se selezionato, il blocco Informazioni apparirà sotto il Banner!';
$string['frontpage_about_info'] = 'Riquadro dati {$a}';
$string['frontpage_about_logo'] = 'Diverso logo da mostrare qui';
$string['frontpage_about_logo_desc'] = 'Se impostato, questo logo verrà utilizzato qui invece del logo in alto.<br> Vuoto utilizza il logo in alto!';
$string['frontpage_about_number'] = 'Quantità di dati';
$string['frontpage_about_number_desc'] = 'Inserisci la quantità di informazioni sopra menzionata';
$string['frontpage_about_text'] = 'Nome dati';
$string['frontpage_about_text_1_defalt'] = 'Corsi';
$string['frontpage_about_text_2_defalt'] = 'Insegnanti';
$string['frontpage_about_text_3_defalt'] = 'Studenti';
$string['frontpage_about_text_4_defalt'] = 'Lezioni';
$string['frontpage_about_text_desc'] = 'Inserisci il nome dei dati da mostrare sulla home';
$string['frontpage_about_title'] = 'Titolo blocco Informazioni';
$string['frontpage_about_title_default'] = 'La nostra Community Globale';
$string['heart'] = 'Se ti piace questo tema, non dimenticare di cliccare ❤️ sulla pagina dei temi <a href="{$a}" target="_blank">cliccando qui</a>';
$string['instructor'] = 'Istruttore';
$string['login_backgroundcolor'] = 'Colore di sfondo';
$string['login_backgroundcolor_desc'] = 'Seleziona il colore di sfondo della pagina di recupero password';
$string['login_backgroundfoto'] = 'Immagine di sfondo';
$string['login_backgroundfoto_desc'] = 'Seleziona l\'immagine di sfondo per l\'accesso/Recupero password/Crea account. L\'immagine predefinita è: {$a}';
$string['login_forgot_description'] = 'Testo ai lati dello Schermo Password Dimenticata';
$string['login_forgot_description_desc'] = 'Testo che apparirà solo sullo Schermo Password Dimenticata';
$string['login_login_description'] = 'Testo ai lati dello Schermo di Accesso';
$string['login_login_description_desc'] = 'Testo che apparirà solo sullo Schermo di Accesso';
$string['login_signup_description'] = 'Testo ai lati dello Schermo Crea un Account';
$string['login_signup_description_desc'] = 'Testo che apparirà solo sullo Schermo Crea un Account';
$string['login_theme'] = 'Tema di accesso';
$string['login_theme_block'] = 'Blocco bianco centrale con sfondo opzionale';
$string['login_theme_desc'] = 'Scegli quale tema vuoi nell\'area di accesso';
$string['login_theme_image_login'] = 'Immagine di sfondo e accesso ai lati';
$string['login_theme_imagetext_login'] = 'Immagine di sfondo, testo sopra l\'immagine e accesso ai lati';
$string['login_theme_login'] = 'Solo schermata di accesso, senza immagine laterale';
$string['logo_color'] = 'Logo colorato';
$string['logo_color_desc'] = 'Carica il tuo LOGO a colori se desideri includerlo in alto. Questo logo verrà visualizzato mentre la pagina viene scorrere e il menu verrà visualizzato su uno sfondo bianco.';
$string['logo_write'] = 'Logo del menu superiore durante lo scrolling';
$string['logo_write_desc'] = 'Carica il tuo logo se desideri includerlo in alto. Questo logo verrà visualizzato quando lo scrolling rimane in alto e il menu verrà visualizzato su uno sfondo colorato.';
$string['matricular'] = 'Iscriviti';
$string['mycourses_color'] = 'Colore di Sfondo del Blocco';
$string['mycourses_color_desc'] = 'Il colore di sfondo per il blocco.';
$string['mycourses_icon'] = 'Icona';
$string['mycourses_icon_desc'] = 'Un\'icona rappresentativa per il blocco. La dimensione dell\'icona deve essere 48x48 pixel.';
$string['mycourses_info'] = 'Blocco {$a}';
$string['mycourses_numblocos'] = 'Nessun blocco';
$string['mycourses_numblocos_desc'] = 'Quante immagini vuoi nel Carosello?';
$string['mycourses_numblocos_nenhum'] = 'Nessun diaporama nella homepage';
$string['mycourses_title'] = 'Titolo Breve del Blocco';
$string['mycourses_title_desc'] = 'Un titolo breve e descrittivo per il blocco.';
$string['mycourses_url'] = 'Collegamento del Blocco';
$string['mycourses_url_desc'] = 'L\'URL da navigare quando si fa clic sul blocco. Può essere un collegamento esterno o un collegamento interno all\'interno della piattaforma.';
$string['pluginname'] = 'Boost Magnific';
$string['privacy:metadata'] = 'Il tema Boost Magnific non memorizza alcun dato personale su alcun utente.';
$string['settings_about_heading'] = 'Informazioni sul tuo Moodle';
$string['settings_css_heading'] = 'Font e CSS';
$string['settings_footer_heading'] = 'Blocco piè di pagina';
$string['settings_icons_change_icons'] = 'Cambia l\'icona predefinita nell\'elenco dei corsi';
$string['settings_login_heading'] = 'Schermata di accesso';
$string['settings_mycourses_heading'] = 'I miei Blocchi Corsi';
$string['settings_slideshow_heading'] = 'Presentazione';
$string['settings_theme_heading'] = 'Tema';
$string['settings_top_heading'] = 'Menu Principale';
$string['sitefonts'] = 'Fonti Google aggiuntive';
$string['sitefonts_desc'] = 'Inserisci il codice @import dalle Fonti Google come indicato nell\'immagine sottostante. Dopo aver salvato, il campo "Font del sito" verrà aggiornato, visualizzando questi font. Puoi aggiungere più @import come necessario.';
$string['slidecaption_desc'] = 'Inserisci il testo della didascalia da utilizzare sulla diapositiva';
$string['slideshow_image'] = 'Immagine diapositiva';
$string['slideshow_image_desc'] = 'L\'immagine dovrebbe essere di 1250px X 400px.';
$string['slideshow_info'] = 'Diapositiva {$a}';
$string['slideshow_numslides'] = 'Quante immagini nella presentazione';
$string['slideshow_numslides_desc'] = 'Quante immagini vuoi nella presentazione?';
$string['slideshow_numslides_nenhum'] = 'Nessuna diapositiva sulla Home';
$string['slideshow_text'] = 'Breve testo descrittivo per la diapositiva';
$string['slideshow_text_desc'] = 'Inserisci un breve testo sulla diapositiva.';
$string['slideshow_url'] = 'Link pulsante diapositive';
$string['slideshow_url_desc'] = 'Inserisci il link di destinazione per il pulsante dell\'immagine della diapositiva';
$string['social_facebook'] = 'Il tuo Facebook';
$string['social_facebook_desc'] = 'URL Facebook della tua organizzazione.';
$string['social_instagram'] = 'Il tuo Instagram';
$string['social_instagram_desc'] = 'URL Instagram della tua organizzazione.';
$string['social_linkedin'] = 'Il tuo Linkedin';
$string['social_linkedin_desc'] = 'URL Linkedin della tua organizzazione.';
$string['social_twitter'] = 'Il tuo Twitter';
$string['social_twitter_desc'] = 'URL Twitter della tua organizzazione.';
$string['social_youtube'] = 'Il tuo Youtube';
$string['social_youtube_desc'] = 'URL Youtube della tua organizzazione.';
$string['theme_boost_magnific_about_editbooton'] = 'Modifica Blocco Informazioni';
$string['theme_boost_magnific_frontpage_bloco'] = 'Blocco "{$a}"';
$string['theme_boost_magnific_frontpage_home'] = 'Blocchi Home';
$string['theme_boost_magnific_mycourses_editbooton'] = 'Modifica Blocchi';
$string['theme_boost_magnific_slideshow_editbooton'] = 'Modifica Slideshow';
$string['theme_color'] = 'Selezione del Colore';
$string['theme_color-color_buttons'] = 'Colore dei Pulsanti';
$string['theme_color-color_buttons_desc'] = 'Il colore usato per i pulsanti, aggiungendo coesione visiva ed enfatizzando azioni interattive.';
$string['theme_color-color_primary'] = 'Colore Primario';
$string['theme_color-color_primary_desc'] = 'Il colore principale primario del tema, di solito utilizzato per elementi in evidenza e di enfasi.';
$string['theme_color-color_secondary'] = 'Colore Secondario';
$string['theme_color-color_secondary_desc'] = 'Un colore secondario che complementa il colore primario, utilizzato per evidenziare elementi secondari o contrastare con il colore primario.';
$string['theme_color_desc'] = 'Seleziona i colori dei testi e dei pulsanti di Moodle o clicca sulla riga sotto:';
$string['theme_color_heading'] = 'Selezione del Colore dell\'Ambiente';
$string['theme_color_sugestion'] = 'Suggerimento di colore';
$string['theme_color_sugestion_text'] = 'Clicca sulla linea per applicare il colore ai campi sottostanti:';
$string['theme_login_branco'] = 'Schermo di accesso solo, senza immagine laterale, con il modulo su sfondo bianco';
$string['top_color_heading'] = 'Colore Scroll Top';
$string['top_scroll'] = 'Fissa il menu durante lo scorrimento della pagina';
$string['top_scroll_background_color'] = 'Colore di Sfondo del Menu Superiore in Scorrimento';
$string['top_scroll_background_color_desc'] = 'Imposta il colore di sfondo durante lo scorrimento della pagina.';
$string['top_scroll_desc'] = 'Quando attivato, il menu sarà fissato nella parte superiore dello schermo mentre scorri la pagina, garantendo un facile accesso alle opzioni del menu.';
$string['top_scroll_text_color'] = 'Colore del Testo del Menu in Scorrimento';
$string['top_scroll_text_color_desc'] = 'Imposta il colore del testo del menu durante lo scorrimento della pagina.';
$string['vvveb_footer_contact_title_default'] = 'Contattaci';
$string['vvveb_home_access'] = 'Accedi al corso';
$string['vvveb_home_automatically_catalogo'] = 'Non modificare. Questo blocco sarà sostituito automaticamente con il catalogo dei corsi.';
$string['vvveb_home_automatically_category'] = 'Non modificare. Questo blocco sarà sostituito automaticamente con le categorie dei corsi.';
$string['vvveb_home_automatically_my_course'] = 'Non modificare. Questo blocco verrà automaticamente sostituito con i corsi a cui lo studente è iscritto.';
$string['vvveb_home_automatically_popular'] = 'Non modificare. Questo blocco sarà sostituito automaticamente con i corsi più popolari.';
$string['vvveb_home_catalogo_heading'] = 'Catalogo dei corsi';
$string['vvveb_home_category_heading'] = 'Categorie dei corsi';
$string['vvveb_home_mycourses_heading'] = 'I Miei Corsi';
$string['vvveb_home_popular_course'] = 'Corsi Popolari';
$string['vvveb_home_team_subtitle'] = 'Siamo un gruppo di professionisti dedicati al loro lavoro';
$string['vvveb_home_team_title'] = 'Incontra Il Nostro Team';
