<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'publication', language 'pl', version '4.5'.
 *
 * @package     publication
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_uploads'] = 'Dodaj pliki';
$string['allfiles'] = 'Przesłane pliki';
$string['allowedfiletypes'] = 'Akceptowane typy plików';
$string['allowedfiletypes_err'] = 'Sprawdź dane! Nieprawidłowe rozszerzenia plików lub separatory';
$string['allowedfiletypes_help'] = 'Akceptowane typy plików można ograniczyć, wprowadzając listę typów oddzielonych przecinkami, np. „wideo / mp4, audio / mp3, image / png, image / jpeg” lub rozszerzenia plików zawierające kropkę, np. „.png, .jpg”. Jeśli pole pozostanie puste, dozwolone są wszystkie typy plików.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Szczegóły zadania i formularz zgłoszeniowy będą dostępne od <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Od';
$string['allowsubmissionsfromdate_help'] = 'Jeśli ta opcja jest włączona, uczestnicy nie mogą przesyłać plików przed tą datą. Jeśli opcja jest wyłączona, uczestnicy mogą rozpocząć przesyłanie plików od razu.';
$string['allowsubmissionsfromdate_import'] = 'Zatwierdzone od';
$string['allowsubmissionsfromdate_upload'] = 'Możliwość przesyłania od';
$string['allowsubmissionsfromdatesummary'] = 'To zadanie przyjmie zgłoszenia od <strong>{$a}</strong>';
$string['alwaysshowdescription'] = 'Zawsze pokazuj opis';
$string['alwaysshowdescription_help'] = 'Jeśli ta opcja jest wyłączona, powyższy opis zadania będzie widoczny tylko dla studentów w dniu „Zezwalaj na przesyłanie od”';
$string['approval_required'] = 'Decyzja w toku';
$string['approval_timeover'] = 'Możesz zmienić swoją zgodę tylko w okresie zmiany.';
$string['approvalchange'] = 'Zmiana statusu publikacji';
$string['approvalfromdate'] = 'Zatwierdzone od';
$string['approvalfromdate_help'] = 'Status zatwierdzenia nie może zostać zmieniony przed tą datą. To ustawienie jest istotne tylko wtedy, gdy zatwierdzenie studenta lub grupy nie jest automatyczne.';
$string['approvalsettings'] = 'Ustawienia publikacji';
$string['approvaltodate'] = 'Zatwierdzone do';
$string['approvaltodate_help'] = 'Status zatwierdzenia nie może zostać zmieniony po tej dacie. To ustawienie jest istotne tylko wtedy, gdy zatwierdzenie przez studenta lub grupę nie jest automatyczne.';
$string['approvaltodatevalidation'] = 'Data zatwierdzenia do musi być późniejsza niż data zatwierdzenia od.';
$string['approved'] = 'Zatwierdzony';
$string['approveusers'] = 'Zatwierdź';
$string['assignment'] = 'Zadanie';
$string['assignment_help'] = 'Wybierz zadanie, aby zaimportować pliki ze zgłoszeń indywidualnych lub grupowych.';
$string['assignment_notfound'] = 'Nie można już znaleźć zadania, z którego zaimportowano pliki.';
$string['assignment_notset'] = 'Nie wybrano zadania.';
$string['availability'] = 'Okres edycji (przesyłanie lub zatwierdzanie)';
$string['choose'] = 'Wybierz...';
$string['completiondetail:upload'] = 'Prześlij plik';
$string['completionupload'] = 'Student musi przesłać plik';
$string['configautoimport'] = 'Jeśli wolisz, aby zgłoszenia studentów były automatycznie importowane do instancji folderów studentów. Tę funkcję można włączyć / wyłączyć dla każdej instancji folderu studenta osobno.';
$string['configmaxbytes'] = 'Domyślny maksymalny rozmiar wszystkich plików w folderze studenta.';
$string['configmaxfiles'] = 'Domyślna maksymalna dozwolona liczba załączników na użytkownika.';
$string['courseuploadlimit'] = 'Limit przesyłania dla kursu';
$string['currentlynotapproved'] = '* Obecnie nie zatwierdzono ani nie odrzucono do publikacji.';
$string['cutoffdate'] = 'Data graniczna';
$string['cutoffdate_help'] = 'Jeśli ustawione, zadanie nie będzie przyjmować zgłoszeń po tej dacie bez przedłużenia.';
$string['cutoffdate_import'] = 'Ostatnia zgoda do';
$string['cutoffdate_upload'] = 'Ostatnie przesłanie do';
$string['cutoffdatefromdatevalidation'] = 'Data graniczna musi być późniejsza niż "data dopuszczenia zgłoszeń od daty."';
$string['cutoffdatevalidation'] = 'Data graniczna nie może być wcześniejsza niż termin';
$string['details'] = 'Szczegóły';
$string['downloadall'] = 'Pobierz wszystkie przesłane pliki';
$string['duedate'] = 'do';
$string['duedate_help'] = 'Jeśli ta opcja jest włączona, uczestnicy nie mogą przesyłać plików po tej dacie. Jeśli opcja jest wyłączona, uczestnicy mogą przesyłać pliki bezterminowo.';
$string['duedate_import'] = 'Zatwierdzenie do';
$string['duedate_upload'] = 'Prześlij do';
$string['duedatevalidation'] = 'Termin musi być późniejszy niż data dopuszczenia zgłoszeń od daty.';
$string['edit_timeover'] = 'Pliki można edytować tylko w okresie edycji.';
$string['edit_uploads'] = 'Edycja/przesyłanie plików';
$string['email:filechange:footer'] = '</ul><br />Prosimy o sprawdzenie, czy wymagana jest zgoda na publikację.';
$string['email:filechange_import:header'] = 'Następujący(e) plik(i) z Zadania <b>\'{$a->assign}\'</b> zostały zaimportowane do <b>\'{$a->publication}\'</b> w {$a->dayupdated} o {$a->timeupdated}:<br /><ul>';
$string['email:filechange_import:subject'] = 'Importowany plik(i)';
$string['email:filechange_upload:header'] = '<b>{$a->username}</b> przesłał następujący plik(i) do <b>\'{$a->publication}\'</b> w {$a->dayupdated} o {$a->timeupdated}:<br /><ul>';
$string['email:filechange_upload:subject'] = 'Przesłane pliki';
$string['email:statuschange:filename'] = '<li>\'{$a->filename}\' do \'<b>{$a->apstatus}</b>\'</li>';
$string['email:statuschange:footer'] = '</ul>';
$string['email:statuschange:header'] = 'Status publikacji następującego pliku(ów) dla <b>\'{$a->publication}\'</b> został zmieniony {$a->dayupdated} o {$a->timeupdated}: przez <b>{$a->username}</b>:<br /><ul>';
$string['email:statuschange:subject'] = 'Zmiana statusu publikacji';
$string['entiresperpage'] = 'Uczestnicy wyświetlani na stronie';
$string['eventpublicationapprovalchanged'] = 'Zmienił się status zatwierdzenia publikacji';
$string['eventpublicationduedateextended'] = 'Wydłużono termin publikacji';
$string['eventpublicationfiledeleted'] = 'Usunięcie pliku publikacji';
$string['eventpublicationfileimported'] = 'Import pliku publikacji';
$string['eventpublicationfileuploaded'] = 'Przesyłanie pliku publikacji';
$string['extensionduedate'] = 'Termin przedłużenia';
$string['extensionnotafterduedate'] = 'Przedłużenie musi nastąpić po terminie';
$string['extensionnotafterfromdate'] = 'Data przedłużenia musi być późniejsza niż data "dopuszczenia zgłoszeń od daty"';
$string['extensionto'] = 'Przedłużenie do';
$string['filedetails'] = 'Szczegóły';
$string['filesofthesetypes'] = 'Można dodawać pliki tego typu:';
$string['filter'] = 'Filtr';
$string['filter:allfiles'] = 'Wszystkie zgłoszenia plików';
$string['filter:approvalrequired'] = 'Decyzja w toku';
$string['filter:approved'] = 'Zatwierdzone zgłoszenia plików';
$string['filter:nofiles'] = 'Brak przesłanych plików';
$string['filter:nofilter'] = 'Brak filtra';
$string['filter:rejected'] = 'Odrzucone zgłoszenia plików';
$string['giveapproval'] = 'Zatwierdź';
$string['go'] = 'Dalej';
$string['grantextension'] = 'Przyznaj przedłużenie';
$string['group_approved'] = 'Zatwierdzone przez wszystkich członków grupy.';
$string['guideline'] = 'Publikacja przesłanych plików';
$string['hidden'] = 'Nie opublikowane';
$string['importfrom_err'] = 'Musisz wybrać zadanie, z którego chcesz zaimportować zgłoszenia plików.';
$string['maxbytes'] = 'Maksymalny rozmiar załącznika';
$string['maxbytes_help'] = 'Pliki przesłane przez studentów mogą mieć rozmiar do tego limitu.';
$string['maxfiles'] = 'Maksymalna liczba załączników';
$string['maxfiles_help'] = 'Każdy student będzie mógł przesłać maksymalnie taką liczbę plików dla ich zgłoszenia.';
$string['messageprovider:publication_updates'] = 'Powiadomienia o publikacji';
$string['mode'] = 'Tryb';
$string['mode_help'] = 'Wybierz, czy studenci mogą przesyłać tutaj dokumenty, czy też ich zgłoszenia zadań mają być importowane.';
$string['modeimport'] = 'Importowanie plików z zadania';
$string['modeupload'] = 'Przesyłanie plików bezpośrednio w bieżącej aktywności';
$string['modulename'] = 'Folder dla studentów';
$string['modulename_help'] = 'Folder dla studenta oferuje następujące funkcje:<br><ul><li>Studenci mogą przesyłać pliki lub importować je z zadania.</li><li>Pliki zostaną opublikowane (będą widoczne dla wszystkich) automatycznie lub po zatwierdzeniu publikacji przez studentówi/lub nauczycieli.</li><li>Studenci i/lub nauczyciele otrzymają powiadomienie, gdy uczniowie prześlą lub zmienią plik lub gdy plik zostanie zaimportowany lub zaktualizowany z aktywności zadania. Ponadto studenci i/lub nauczyciele otrzymają powiadomienie o wszelkich zmianach statusu publikacji.</li></ul>';
$string['modulenameplural'] = 'Foldery studenckie';
$string['myfiles'] = 'Własne pliki';
$string['mygroupfiles'] = 'Pliki mojej grupy';
$string['name'] = 'Nazwa';
$string['noentries'] = 'Brak wpisów';
$string['nofiles'] = 'Brak plików';
$string['nofilestodisplay'] = 'Obecnie pliki nie są dostępne lub nie zostały jeszcze opublikowane.';
$string['nofilestozip'] = 'Brak plików do spakowania zip-em';
$string['nonexistentfiletypes'] = 'Następujące typy plików nie zostały rozpoznane: {$a}';
$string['nopublicationsincourse'] = 'W tym kursie nie ma instancji folderu dla studenta.';
$string['nothing_to_show_groups'] = 'Nic do wyświetlenia - brak dostępnych grup';
$string['nothing_to_show_users'] = 'Nic do wyświetlenia - brak dostępnych studentów';
$string['nothingtodisplay'] = 'Brak wpisów do wyświetlenia';
$string['notice'] = '<strong>Uwaga: </strong>';
$string['notice_changes_possible_in_original'] = 'Zmiany w istniejących plikach są możliwe tylko w oryginalnej aktywności zadania.';
$string['notice_files_imported'] = 'Pokazane pliki są importowane z aktywności zadania.';
$string['notice_files_imported_group'] = 'Pokazane pliki pochodzą z zgłoszenia grupowego, zaimportowanego z aktywności zadania.';
$string['notice_group_all_teachernotrequired'] = 'Pliki będą publikowane dla wszystkich studentów tylko za zgodą <strong>WSZYSTKICH członków grupy.</strong>';
$string['notice_group_all_teacherrequired'] = 'Pliki zostaną opublikowane dla wszystkich studentów tylko za zgodą <strong>WSZYSTKICH członków grupy i nauczyciela.</strong> Nauczyciele zastrzegają sobie prawo do odrzucenia publikacji plików w dowolnym momencie.';
$string['notice_group_one_teachernotrequired'] = 'Pliki zostaną opublikowane dla wszystkich studentów tylko za zgodą <strong>co najmniej JEDNEGO członka grupy.</strong>.';
$string['notice_group_one_teacherrequired'] = 'Pliki zostaną opublikowane dla wszystkich uczniów tylko za zgodą <strong>co najmniej JEDNEGO członka grupy i nauczyciela.</strong> Nauczyciele zastrzegają sobie prawo do odrzucenia publikacji plików w dowolnym momencie.';
$string['notice_import_studentnotrequired_teachernotrequired'] = 'Pliki zostaną opublikowane (będą widoczne dla wszystkich) <strong>automatycznie.</strong>';
$string['notice_import_studentnotrequired_teacherrequired'] = 'Pliki zostaną opublikowane (będą widoczne dla wszystkich) dopiero <strong>po zatwierdzeniu przez nauczycieli.</strong> Nauczyciele zastrzegają sobie prawo do odrzucenia publikacji plików w dowolnym momencie.';
$string['notice_import_studentrequired_teachernotrequired'] = 'Pliki zostaną opublikowane (będą widoczne dla wszystkich) po <strong>zatwierdzeniu przez ciebie.</strong>.';
$string['notice_import_studentrequired_teacherrequired'] = 'Pliki zostaną opublikowane (będą widoczne dla wszystkich) po <strong>zatwierdzeniu przez Ciebie i nauczycieli.</strong> Nauczyciele zastrzegają sobie prawo do odrzucenia publikacji Twoich plików w dowolnym momencie.';
$string['notice_upload_studentnotrequired_teachernotrequired'] = 'Wszystkie pliki przesłane tutaj zostaną opublikowane (będą widoczne dla wszystkich) <strong>automatycznie.</strong>.';
$string['notice_upload_studentnotrequired_teacherrequired'] = 'Wszystkie pliki przesłane tutaj zostaną opublikowane (będą widoczne dla wszystkich) tylko <strong>po zatwierdzeniu przez nauczycieli.</strong> Nauczyciele zastrzegają sobie prawo do odrzucenia publikacji plików w dowolnym momencie.';
$string['notice_upload_studentrequired_teachernotrequired'] = 'Wszystkie pliki przesłane tutaj zostaną opublikowane (będą widoczne dla wszystkich) <strong>po twoim zatwierdzeniu.</strong>.';
$string['notice_upload_studentrequired_teacherrequired'] = 'Wszystkie pliki przesłane tutaj zostaną opublikowane (będą widoczne dla wszystkich) <strong>po zatwierdzeniu przez Ciebie i nauczycieli.</strong> Nauczyciele zastrzegają sobie prawo do odrzucenia publikacji plików w dowolnym momencie.';
$string['notifications'] = 'Powiadomienia';
$string['notify:filechange'] = 'Powiadomienia o przesłanych lub zaimportowanych plikach';
$string['notify:filechange_admin'] = 'Domyślne ustawienia powiadomień o zmianach plików - przesłanych lub importowanych';
$string['notify:filechange_help'] = 'W zależności od ustawienia, jeśli jest włączone, studenci i/lub nauczyciele otrzymają powiadomienie, gdy studenci prześlą lub zmienią plik, lub gdy plik zostanie zaimportowany lub zaktualizowany z zadania.';
$string['notify:setting:0'] = 'Brak powiadomień';
$string['notify:setting:1'] = 'Tylko nauczyciele';
$string['notify:setting:2'] = 'Tylko dla studentów';
$string['notify:setting:3'] = 'Nauczyciele i studenci';
$string['notify:statuschange'] = 'Powiadomienia o zmianach statusu publikacji';
$string['notify:statuschange_admin'] = 'Domyślne ustawienie powiadomień o zmianach statusu publikacji';
$string['notify:statuschange_help'] = 'W zależności od ustawienia, jeśli jest włączone, studenci i/lub nauczyciele otrzymają powiadomienie, gdy status publikacji jednego z plików zostanie zmieniony.';
$string['notifystudents'] = 'Powiadom studentów o zmianach w publikacjach';
$string['notifystudents_help'] = 'Jeśli opcja ta jest włączona, studenci otrzymają powiadomienie o zmianie statusu publikacji jednego z przesłanych przez nich plików.';
$string['notifyteacher'] = 'Powiadom nauczycieli o przesłanych materiałach';
$string['notifyteacher_help'] = 'Jeśli opcja ta jest włączona, nauczyciele otrzymają powiadomienie, gdy uczniowie prześlą plik.';
$string['obtainapproval_automatic'] = 'Automatycznie';
$string['obtainapproval_required'] = 'Wymagane';
$string['obtaingroupapproval'] = 'Zatwierdzenie przez grupę';
$string['obtaingroupapproval_admin'] = 'Domyślne ustawienie zatwierdzania grupowego';
$string['obtaingroupapproval_admin_desc'] = 'To ustawienie określa domyślne ustawienia zatwierdzania dla członków grupy. To ustawienie staje się istotne <b>tylko wtedy</b>, gdy tryb jest ustawiony na "Importuj pliki z aktywności zadanie", a zadanie ma możliwość przesyłania grupowego.';
$string['obtaingroupapproval_all'] = 'Wymagane od WSZYSTKICH członków';
$string['obtaingroupapproval_help'] = 'Ta opcja określa sposób publikacji (widoczności) plików przesłanych przez grupy: <br /><ul><li><strong>Automatycznie</strong> - nie jest wymagana zgoda członków grupy. W duchu prawa autorskiego prosimy, abyś poprosił o zgodę na publikację plików od studentów w oddzielny sposób. </li><li><strong>Wymagane od co najmniej JEDNEGO członka</strong> - co najmniej jeden członek grupy musi zatwierdzić</li><li><strong>Wymagane od WSZYSTKICH członków</strong> - wszyscy członkowie grupy muszą zatwierdzić.</li></ul>';
$string['obtaingroupapproval_single'] = 'Wymagane od co najmniej JEDNEGO członka';
$string['obtaingroupapproval_title'] = 'Zatwierdzenie grupy';
$string['obtainstudentapproval'] = 'Zatwierdzenie przez studenta';
$string['obtainstudentapproval_admin'] = 'Domyślne ustawienie zatwierdzania studentów';
$string['obtainstudentapproval_admin_desc'] = 'To ustawienie określa domyślne ustawienia zatwierdzania dla studentów.';
$string['obtainstudentapproval_help'] = 'Ta opcja określa, w jaki sposób odbywa się publikacja (widoczność) plików przesłanych przez studentów: <br><ul><li><strong>Automatycznie</strong> - nie jest wymagana zgoda studentów. W duchu prawa autorskiego prosimy, abyś poprosił o zgodę na publikację plików od studentów w osobny sposób.</li><li><strong>Wymagane</strong> - studenci muszą ręcznie zatwierdzić plik do publikacji.</li></ul>';
$string['obtainstudentapproval_no'] = 'Automatycznie';
$string['obtainstudentapproval_yes'] = 'Wymagane';
$string['obtainteacherapproval'] = 'Zatwierdzenie przez nauczyciela';
$string['obtainteacherapproval_admin'] = 'Domyślne ustawienie zatwierdzania przez nauczyciela';
$string['obtainteacherapproval_admin_desc'] = 'To ustawienie określa domyślne ustawienia zatwierdzania dla nauczycieli.';
$string['obtainteacherapproval_help'] = 'Ta opcja określa, w jaki sposób odbywa się publikacja (widoczność) plików przesłanych do zatwierdzenia przez nauczycieli: <br><ul><li><strong>Automatycznie</strong> - nie jest wymagane zatwierdzenie przez nauczycieli. </li><li><strong>Wymagane</strong> - nauczyciele muszą ręcznie zatwierdzić plik do publikacji.</li></ul>';
$string['obtainteacherapproval_no'] = 'Automatycznie';
$string['obtainteacherapproval_yes'] = 'Wymagane';
$string['optionalsettings'] = 'Opcje';
$string['overdue'] = 'Termin zakończenia okresu edycji minął';
$string['overview'] = 'Przegląd';
$string['pending'] = 'W oczekiwaniu';
$string['pluginadministration'] = 'Administrowanie folderami studentów';
$string['pluginname'] = 'Folder dla studentów';
$string['privacy:metadata:approval'] = 'Czy członek grupy zatwierdził lub odrzucił publikację.';
$string['privacy:metadata:contenthash'] = 'Klucz SHA1 zawartości pliku jest używany do ustalenia, czy plik się zmienił.';
$string['privacy:metadata:extduedates'] = 'Przechowuje informacje o zastąpionych / przedłużonych terminach publikacji mod_publication.';
$string['privacy:metadata:extensionduedate'] = 'Termin obowiązujący dla studenta w związku z wyjątkiem / przedłużeniem.';
$string['privacy:metadata:fileid'] = 'Identyfikator pliku.';
$string['privacy:metadata:filename'] = 'Nazwa pliku.';
$string['privacy:metadata:files'] = 'Przechowuje informacje (identyfikator, do kogo należy, skąd pochodzi, skrót treści, nazwę pliku i jeśli został zatwierdzony przez nauczyciela i / lub studenta) o plikach przesłanych / importowanych do mod_publication.';
$string['privacy:metadata:groupapproval'] = 'Przechowuje informacje o zatwierdzeniu lub odrzuceniu przez członków grupy plików zaimportowanych z zgłoszenia grupy.';
$string['privacy:metadata:publicationfileexplanation'] = 'Pliki i przekonwertowane zgłoszenia onlinetext dla tej wtyczki są przechowywane przez API plików Moodle.';
$string['privacy:metadata:publicationperpage'] = 'Ile wpisów powinno być wyświetlanych na jednej stronie tabeli!';
$string['privacy:metadata:studentapproval'] = 'Czy student zatwierdził lub odrzucił publikację pliku.';
$string['privacy:metadata:teacherapproval'] = 'Czy nauczyciel zatwierdził lub odrzucił publikację pliku.';
$string['privacy:metadata:timecreated'] = 'Data i godzina utworzenia rekordu danych.';
$string['privacy:metadata:timemodified'] = 'Ostatnia data i godzina aktualizacji / modyfikacji rekordu danych.';
$string['privacy:metadata:type'] = 'Zaznacza pochodzenie pliku (przesłanego przez studenta, importowanego z przedłożenia zadania lub przekonwertowanego tekstu onlinet z przedłożenia zadania).';
$string['privacy:metadata:userid'] = 'Identyfikator użytkownika.';
$string['privacy:path:files'] = 'Pliki';
$string['privacy:path:resources'] = 'Zasoby';
$string['privacy:type:import'] = 'Zaimportowany plik';
$string['privacy:type:onlinetext'] = 'Zaimportowany tekst online';
$string['privacy:type:upload'] = 'Przesłany plik';
$string['publication:addinstance'] = 'Dodaj nowy folder dla studentów';
$string['publication:approve'] = 'Zdecyduj, czy pliki powinny zostać opublikowane (widoczne dla wszystkich uczestników).';
$string['publication:grantextension'] = 'przyznaj przedłużenie';
$string['publication:receiveteachernotification'] = 'Otrzymuj powiadomienia dla prowadzących';
$string['publication:upload'] = 'Prześlij pliki do folderu studenckiego';
$string['publication:view'] = 'Wyświetl folder studenta';
$string['publicationstatus'] = 'Publikacje';
$string['publicationstatus_help'] = 'Status publikacji reprezentuje zatwierdzenie nauczyciela i ostateczną publikację: <ul><li><i class="fa fa-check text-success fa-fw"></i>  Plik jest opublikowany i dlatego jest widoczny dla wszystkich uczestników</li><li><i class="fa fa-times text-danger fa-fw"></i>Plik nie jest opublikowany (zatwierdzenie nie zostało jeszcze udzielone lub zostało odrzucone) i dlatego nie jest widoczny</li></ul>';
$string['publicfiles'] = 'Opublikowane pliki';
$string['published_aftercheck'] = 'Wymagana zgoda nauczycieli';
$string['published_immediately'] = 'Zatwierdź automatycznie';
$string['rejected'] = 'Odrzucony';
$string['rejectusers'] = 'Odrzuć';
$string['reset'] = 'Cofnij';
$string['reset_userdata'] = 'Wszystkie dane';
$string['resetstudentapproval'] = 'Cofnięcie zatwierdzenia studenta';
$string['save_changes'] = 'Zapisz zmiany';
$string['saveapproval'] = 'Zapisz zmiany';
$string['savestudentapprovalwarning'] = 'Czy na pewno chcesz zapisać te zmiany? Po ustawieniu statusu publikacji nie można go zmienić.';
$string['saveteacherapproval'] = 'Zapisz zmiany';
$string['search:activity'] = 'Folder dla studentów - informacje o aktywności';
$string['show_details'] = 'Pokaż szczegóły';
$string['status'] = 'Status';
$string['status:approved'] = 'Zatwiedzone';
$string['status:approvednot'] = 'Odrzucone';
$string['status:approvedrevoke'] = 'Cofnięte';
$string['student_approve'] = 'Zatwierdź';
$string['student_approved'] = 'Zatwierdzone przez studenta.';
$string['student_approved_automatically'] = 'Zatwierdzone przez studenta automatycznie.';
$string['student_pending'] = 'Decyzja studenta jest w toku.';
$string['student_reject'] = 'Odrzuć';
$string['student_rejected'] = 'Odrzucony przez studenta.';
$string['studentapproval'] = 'Zatwierdzenie (studenci)';
$string['studentapproval_help'] = 'W kolumnie "Zatwierdzenie (studenci)" wyświetlana jest informacja zwrotna od studentów:<br><ul><li><i class="fa fa-question fa-fw text-warning"></i> - Decyzja w toku</li><li><i class="fa fa-check text-success fa-fw"></i> - Zatwierdzenie udzielone</li><li><i class="fa fa-times text-danger fa-fw"></i> - Zatwierdzenie odrzucone</li></ul>';
$string['submissionsettings'] = 'Ustawienia zgłoszeń';
$string['teacher_approve'] = 'Zatwierdź';
$string['teacher_approved'] = 'Zatwierdzone przez nauczyciela.';
$string['teacher_approved_automatically'] = 'Zatwierdzone przez nauczyciela automatycznie.';
$string['teacher_pending'] = 'Decyzja nauczyciela jest w toku.';
$string['teacher_reject'] = 'Odrzuć';
$string['teacher_rejected'] = 'Nie opublikowano (odrzucono).';
$string['teacherapproval'] = 'Zatwierdź';
$string['teacherapproval_help'] = 'Bieżące zatwierdzanie/odrzucanie plików, tj. czy są one widoczne dla wszystkich uczestników: <br><ul><li><strong>Wybierz...</strong> - decyzja w toku/brak zatwierdzenia lub odrzucenie - pliki nie są widoczne. </li><li><strong>Zatwierdź</strong>- zatwierdzenie zostało udzielone, pliki są publikowane i widoczne dla wszystkich. </li><li><strong>Odrzuć</strong> - nie udzielono zgody, te pliki nie są publikowane, a zatem nie są widoczne.</li></ul>';
$string['total'] = 'Suma';
$string['updatefiles'] = 'Zaktualizuj pliki';
$string['updatefileswarning'] = 'Już zaimportowane pliki zostaną zastąpione lub usunięte, jeśli oryginalne pliki w zadaniu zostały odświeżone lub usunięte. Ustawienia studenta, takie jak zatwierdzenie do publikacji, pozostają bez zmian.';
$string['uploaded'] = 'Przesłano';
$string['visibility'] = 'Opublikowano';
$string['visible'] = 'Opublikowano';
$string['visibleforstudents'] = 'Opublikowano';
$string['visibleforstudents_no'] = 'Ten plik nie jest opublikowany (nie jest widoczny dla studentów).';
$string['visibleforstudents_yes'] = 'Ten plik jest opublikowany (widoczny dla studentów).';
$string['withselected'] = 'Z wybranymi ...';
$string['zipusers'] = 'Pobierz wybrane zgłoszenia plików';
