<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'pl', version '4.5'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Możesz obejrzeć ten test, ale gdyby to była prawdziwa próba, zostałbyś zablokowany, ponieważ:';
$string['action'] = 'Akcja';
$string['activityoverview'] = 'Masz otwarte, nieukończone testy';
$string['adaptive'] = 'Tryb adaptacyjny';
$string['adaptive_help'] = 'Jeśli aktywne, dopuszczalne będzie wielokrotne udzielenie odpowiedzi na to samo pytanie podczas jednego podejścia do testu. Na przykład, jeśli student udzieli nieprawidłowej odpowiedzi, będzie mógł natychmiast spróbować ponownie. Jednak, w zależności od ustawienia punktów karnych, za każdą złą odpowiedź punkty karne zostaną odjęte od końcowego wyniku.';
$string['add'] = 'Dodaj';
$string['addaquestion'] = 'Dodaj nowe pytanie...';
$string['addarandomquestion'] = 'losowe pytanie';
$string['addarandomquestion_help'] = 'Losowo wybierane pytanie z danej kategorii jest dodawane do testu. Oznacza to, że różni studenci najprawdopodobniej mogą uzyskać inny zestaw pytań, a kiedy testu pozwala na wiele podejść, każde następne może zawierać nowy dobór pytań.';
$string['addarandomquestion_success'] = 'Dodano losowe pytania';
$string['addarandomselectedquestion'] = 'Dodaj losowo wybrane pytanie ...';
$string['addasection'] = 'nowy nagłówek sekcji';
$string['adddescriptionlabel'] = 'Dodaj opis';
$string['addingquestion'] = 'Dodawanie pytania';
$string['addingquestions'] = 'Po prawej znajduje się baza pytań. Pytania przechowywane są w kategoriach w celu ułatwienia ich organizacji. Pytania mogą być wykorzystane nie tylko w dowolnym teście wchodzącym w skład kursu, lecz również w innych kursach, jeśli zostaną opublikowane. <br /><br /> Po wybraniu lub utworzeniu kategorii, można tworzyć i edytować pytania. Każde z tych pytań można następnie dodać do testu - lewa część strony.';
$string['addmoreoverallfeedbacks'] = 'Dodaj {no} pola odpowiedzi zwrotnej';
$string['addnewgroupoverride'] = 'Ustaw grupowe warunki testu';
$string['addnewpagesafterselected'] = 'Dodaj nowe strony po zaznaczonych pytaniach';
$string['addnewquestionsqbank'] = 'Dodaj pytanie do kategorii {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Ustaw indywidualne warunki testu';
$string['addpagebreak'] = 'Dodaj separator strony';
$string['addpagehere'] = 'Dodaj tutaj stronę ';
$string['addquestion'] = 'Dodaj pytanie';
$string['addquestionfrombankatend'] = 'Dodaj na końcu z banku pytań';
$string['addquestionfrombanktopage'] = 'Dodaj z bazy pytań do strony {$a}';
$string['addquestions'] = 'Dodaj pytania';
$string['addquestionstoquiz'] = 'Dodaj pytania do tego testu';
$string['addrandom'] = 'Dodaj {$a} losowe pytania';
$string['addrandom1'] = '<< Dodaj';
$string['addrandom2'] = 'pytania losowe';
$string['addrandomfromcategory'] = 'Dodaj losowe pytania z kategorii:';
$string['addrandomquestion'] = 'Dodaj losowe pytanie';
$string['addrandomquestionatend'] = 'Dodaj losowe pytanie na końcu';
$string['addrandomquestiontopage'] = 'Dodaj losowe pytanie do strony {$a}';
$string['addrandomquestiontoquiz'] = 'Dodaj losowe pytanie do testu{$a}';
$string['addselectedquestionstoquiz'] = 'Dodaj wybrane pytania do testu';
$string['addselectedtoquiz'] = 'Dodaj wybrane do testu';
$string['addtoquiz'] = 'Dodaj do testu';
$string['affectedstudents'] = 'Affected {$a}';
$string['aftereachquestion'] = 'Po dodaniu każdego pytania';
$string['afternquestions'] = 'Po dodaniu {$a} pytań';
$string['age'] = 'wiek';
$string['allattempts'] = 'Wszystkie podejścia';
$string['allinone'] = 'Bez ograniczeń';
$string['allowreview'] = 'Udostępnij przegląd';
$string['alreadysubmitted'] = 'Najprawdopodobniej zakończyłeś już to podejście do testu';
$string['alternativeunits'] = 'Alternatywne jednostki';
$string['alwaysavailable'] = 'Zawsze dostępne';
$string['alwayslatest'] = 'Zawsze najnowsze';
$string['analysisoptions'] = 'Opcje analizy';
$string['analysistitle'] = 'Pozycje tablicy analizy';
$string['answer'] = 'Odpowiedź';
$string['answered'] = 'Udzielono odpowiedzi';
$string['answerhowmany'] = 'Jedna lub wiele odpowiedzi?';
$string['answers'] = 'Poprawne odpowiedzi';
$string['answersingleno'] = 'Odpowiedź wielokrotna jest dozwolona';
$string['answersingleyes'] = 'Wyłącznie jedna odpowiedź';
$string['answertoolong'] = 'Odpowiedź jest zbyt długa po linii {$a} (maks. 255 znaków)';
$string['anytags'] = 'Dowolne tagi';
$string['aon'] = 'Format AON';
$string['areyousureremoveselected'] = 'Czy na pewno chcesz usunąć wszystkie wybrane pytania?';
$string['asshownoneditscreen'] = 'Jak pokazano w oknie edycji';
$string['attempt'] = 'Próba {$a}';
$string['attemptalreadyclosed'] = 'To podejście zostało już zakończone.';
$string['attemptclosed'] = 'Próba nie została jeszcze zakończona';
$string['attemptduration'] = 'Czas trwania';
$string['attemptedon'] = 'Data rozwiązania';
$string['attempterror'] = 'Nie możesz podejść do próby w tym teście teraz, ponieważ: {$a}';
$string['attempterrorcontentchange'] = 'Ten podgląd testu już nie istnieje. (Gdy test jest edytowany, wszelkie podglądy podejść w toku są automatycznie usuwane).';
$string['attempterrorcontentchangeforuser'] = 'To podejście do testu już nie istnieje.';
$string['attempterrorinvalid'] = 'Nieprawidłowy identyfikator próby testu';
$string['attemptfirst'] = 'Pierwsze podejście';
$string['attemptgradeddelay'] = 'Opóźnienie powiadomienia ocenionego podejścia/próby';
$string['attemptgradeddelay_desc'] = 'Przed wysłaniem powiadomienia o ocenie podejścia stosuje się opóźnienie, aby dać nauczycielowi czas na edycję oceny.';
$string['attemptincomplete'] = 'Podejście {$a} nie zostało zakończone';
$string['attemptlast'] = 'Ostatnie podejście';
$string['attemptnumber'] = 'Podejście';
$string['attemptquiz'] = 'Rozpocznij test';
$string['attemptquiznow'] = 'Spróbuj teraz rozwiązać test';
$string['attemptreviewtitle'] = '{$a}: Przegląd próby';
$string['attemptreviewtitlepaged'] = '{$a->name}: Przegląd podejścia  (page {$a->currentpage} of {$a->totalpages})';
$string['attempts'] = 'Podejścia';
$string['attempts_help'] = 'Całkowita liczba dozwolonych prób (a nie liczba dodatkowych podejść).';
$string['attemptsallowed'] = 'Dostępne podejścia';
$string['attemptsdeleted'] = 'Podejścia usunięte';
$string['attemptselection'] = 'Podejścia do analizy wybrane przez użytkownika';
$string['attemptsexist'] = 'Nie możesz dodawać ani usuwać pytań z test';
$string['attemptsnum'] = 'Podejść: {$a}';
$string['attemptsnumthisgroup'] = 'Podejść: {$a->total} ({$a->group} z tej grupy)';
$string['attemptsnumyourgroups'] = 'Podejść: {$a->total} ({$a->group} z twoich grup)';
$string['attemptsonly'] = 'Pokaż tylko studentów, którzy podeszli do testu';
$string['attemptstate'] = 'Stan';
$string['attemptstillinprogress'] = 'Podejście jeszcze w toku';
$string['attemptsummarytitle'] = '{$a}: Podsumowanie próby';
$string['attemptsunlimited'] = 'Nielimitowana liczba podejść';
$string['attempttitlepaged'] = '{$a->name} (strona {$a->currentpage} z {$a->totalpages})';
$string['autosaveperiod'] = 'Opóźnienie automatycznego zapisu';
$string['autosaveperiod_desc'] = 'Odpowiedzi studentów mogą być automatycznie zapisywane co kilka minut podczas rozwiązywania testu. Wiąże się to z kompromisem: zapisywanie odpowiedzi zwiększa obciążenie serwera, ale zmniejsza szansę, że uczestnicy stracą swoją pracę.';
$string['back'] = 'Powrót do podglądu pytania';
$string['backtocourse'] = 'Powrót do kursu';
$string['backtoquestionlist'] = 'Wróć do listy pytań';
$string['backtoquiz'] = 'Powrót do edycji testu';
$string['bestgrade'] = 'Najlepsza ocena';
$string['bothattempts'] = 'Pokaż wszystkich studentów';
$string['browsersecurity'] = 'Zabezpieczenia przeglądarki';
$string['browsersecurity_help'] = 'Jeśli "Pełny ekran pop-up zabezpieczony przez JavaScript " jest zaznaczony,

* test uruchomi się tylko wtedy, gdy student ma włączoną obsługę JavaScript w przeglądarce internetowej

* test pojawi się w oknie popup na pełnym ekranie, który zakrywa wszystkie inne okna i nie ma elementów sterujących nawigacją

* Studenci nie mają możliwości, o ile jest to możliwe, korzystania z udogodnień, takich jak kopiowanie i wklejanie';
$string['cachedef_overrides'] = 'Informacje o wyjątku użytkownika i grupy';
$string['calculated'] = 'Obliczeniowe';
$string['calculatedquestion'] = 'Kalkulowane pytanie w linii {$a} jest nie wspierane. Pytanie zostanie zignorowane.';
$string['cannotcreatepath'] = 'Ścieżka nie może zostać utworzona ({$a})';
$string['cannoteditafterattempts'] = 'Nie można dodawać ani usuwać pytań, gdyż istnieją już podejścia do testu. ({$a})';
$string['cannotfindprevattempt'] = 'Nie znaleziono poprzednich podejść na których można się oprzeć.';
$string['cannotfindquestionregard'] = 'Nie znajduje pytań do ponownej oceny!';
$string['cannotinsert'] = 'Nie można wstawić pytania';
$string['cannotinsertrandomquestion'] = 'Nie udało się wstawić nowego, losowo wybranego pytania!';
$string['cannotloadquestion'] = 'Nie udało się załadować opcji dla pytania';
$string['cannotloadtypeinfo'] = 'Nie udało się załadować informacji szczegółowych dla tego typu pytania';
$string['cannotopen'] = 'Nie można otworzyć pliku do exportu';
$string['cannotremoveallsectionslots'] = 'Wybrałeś wszystkie pytania pod nagłówkiem sekcji \'{$a}\'. Niedopuszczalne jest takie usuwanie wszystkich pytań.';
$string['cannotremoveslots'] = 'Nie można usunąć pytań';
$string['cannotrestore'] = 'Nie udało się przywrócić sesji pytań';
$string['cannotreviewopen'] = 'Nie możesz przeglądać tego podejścia, jest ono nadal otwarte.';
$string['cannotsavelayout'] = 'Nie można zapisać schematu wyglądu';
$string['cannotsavenumberofquestion'] = 'Nie można zapisać liczby pytań na stronę';
$string['cannotsavequestion'] = 'Nie można zapisać listy pytań';
$string['cannotsetgrade'] = 'Nie udało się ustawić oceny maksymalnej dla testu';
$string['cannotsetsumgrades'] = 'Nie udało się ustawić sumy ocen';
$string['cannotstartgradesmismatch'] = 'Nie można rozpocząć podejścia. Test musi zostać oceniony z {$a->grade}, lecz żadne z pytań w teście nie ma ustawionej oceny. Można to naprawić na stronie edycji testu.';
$string['cannotstartmissingquestion'] = 'Nie można uruchomić testu. Definicja testy zawiera pytanie, które nie istnieje.';
$string['cannotstartnoquestions'] = 'Nie można uruchomić testu. Nie dodano jeszcze żadnych pytań.';
$string['cannotwrite'] = 'Nie można zapisać pliku do eksportu ({$a})';
$string['canredoquestions'] = 'Dopuść warianty pytań w jednym podejściu';
$string['canredoquestions_desc'] = 'Jeśli opcja jest włączona, to po sprawdzeniu odpowiedzi na dane pytanie, osoba rozwiązująca test zobaczy guzik "Wypróbuj inne pytanie takie jak to". Pozwala to na udzielenie odpowiedzi na kolejny wariant tego pytania bez konieczności przesyłania wszystkich odpowiedzi i rozpoczynania nowego podejścia. Opcja ta jest użyteczna w przypadku quizów ćwiczeniowych.

Ustawienie dotyczy jedynie tych pytań i ich zachowań (np. "natychmiastowa informacja zwrotna" czy "interaktywne z powtórzeniami"), w których możliwe jest sprawdzenie pojedynczych odpowiedzi przed przesłaniem do oceny całego podejścia.';
$string['canredoquestions_help'] = 'Jeśli opcja jest włączona, to po sprawdzeniu odpowiedzi na dane pytanie, osoba rozwiązująca test zobaczy guzik "Wypróbuj inne pytanie takie jak to". Pozwala to na udzielenie odpowiedzi na kolejny wariant tego pytania bez konieczności przesyłania wszystkich odpowiedzi i rozpoczynania nowego podejścia. Opcja ta jest użyteczna w przypadku quizów ćwiczeniowych.

Ustawienie dotyczy jedynie tych pytań i ich zachowań (np. "natychmiastowa informacja zwrotna" czy "interaktywne z powtórzeniami"), w których możliwe jest sprawdzenie pojedynczych odpowiedzi przed przesłaniem do oceny całego podejścia.';
$string['canredoquestionsyes'] = 'Tak, daj możliwość wypróbowania innego pytania';
$string['caseno'] = 'Nie, wielkość liter jest nieważna';
$string['casesensitive'] = 'Uwzględnianie wielkości liter';
$string['caseyes'] = 'Tak, wielkość liter musi się zgadzać';
$string['categoryadded'] = 'Kategoria \'{$a}\' została dodana';
$string['categorydeleted'] = 'Kategoria \'{$a}\' została usunięta';
$string['categorynoedit'] = 'Nie możesz edtować kategorii \'{$a}\'';
$string['categoryupdated'] = 'Kategoria została poprawnie pobrana';
$string['close'] = 'Zamknij okno';
$string['closebeforeopen'] = 'Data zamknięcia musi być późniejsza niż data otwarcia.';
$string['closed'] = 'Zamknięty';
$string['closepreview'] = 'Zamknij podgląd';
$string['closereview'] = 'Zamknij przegląd';
$string['comment'] = 'Komentarz';
$string['commentorgrade'] = 'Skomentuj lub zmień ocenę';
$string['comments'] = 'Komentarze';
$string['completedon'] = 'Ukończono';
$string['completionattemptsexhausted'] = 'Pozytywna ocena lub ukończenie wszystkich możliwych podejść';
$string['completionattemptsexhausted_help'] = 'Oznacz test jako ukończony, gdy student wykorzysta maksymalną liczbę prób.';
$string['completiondetail:minattempts'] = 'Podejścia: {$a}';
$string['completiondetail:passorexhaust'] = 'Otrzymaj ocenę zaliczeniową lub ukończ wszystkie dostępne próby';
$string['completionminattempts'] = 'Minimalna liczba prób:';
$string['completionminattemptsdesc'] = 'Minimalna wymagana liczba prób: {$a}';
$string['completionminattemptserror'] = 'Minimalna liczba prób musi być mniejsza lub równa dozwolonym próbom.';
$string['completionminattemptsgroup'] = 'Wymagaj prób';
$string['completionpassorattemptsexhausteddesc'] = 'Uczeń musi uzyskać ocenę pozytywną lub wyczerpać wszystkie dostępne próby ukończenia tej aktywności';
$string['configadaptive'] = 'Jeśli wybierzesz \'Tak\', student będzie mógł udzielić wielu odpowiedzi na to samo pytanie, nawet w ciągu tego samego podejścia do testu.';
$string['configattemptsallowed'] = 'Ograniczenie liczby podejść do testu.';
$string['configdecimaldigits'] = 'Liczba cyfr po przecinku w ocenie.';
$string['configdecimalplaces'] = 'Liczba cyfr po przecinku w ocenie testu.';
$string['configdecimalplacesquestion'] = 'Liczba cyfr, które mają być wyświetlane po przecinku przy wyświetlaniu oceny za poszczególne pytania.';
$string['configdelay1'] = 'Tu można ustawić opóźnienie czasowe, po którym student może podjąć drugie podejście do testu';
$string['configdelay1st2nd'] = 'Opcja określa czas, który student musi przeczekać zanim po raz drugi podejdzie do testu.';
$string['configdelay2'] = 'Tu można ustawić opóźnienia czasowe, po którym student może podjąć trzeci i dalsze podejście do testu';
$string['configdelaylater'] = 'Opcja określa czas, który student musi przeczekać zanim po raz trzeci i kolejny podejdzie do testu.';
$string['configeachattemptbuildsonthelast'] = 'Jeśli wielokrotne podejścia są dozwolone,  każde nowe podejście zawiera wyniki poprzedniego.';
$string['configgrademethod'] = 'Która metoda powinna być użyta do wyznaczenia końcowej oceny za test w przypadku wielokrotnych podejść.';
$string['configintro'] = 'Tu można zdefiniować wartości domyślne, które są używane  podczas tworzenia nowego testu. Można również wskazać, które z ustawień należą do zaawansowanych.';
$string['configmaximumgrade'] = 'Domyślna ocena maksymalna, do której ocena z testu będzie skalowana.';
$string['confignavmethod'] = 'Przy ustawionej nawigacji Dowolnej, kolejność udzielanych odpowiedzi jest obojętna, gdyż pomiędzy pytaniami można swobodnie przechodzić. W nawigacji Sekwencyjnej, na pytania odpowiadać można jedynie w ustalonej kolejności.';
$string['confignewpageevery'] = 'Znaki nowej strony będą automatycznie wstawiane podczas dodawania pytań do testu, zgodnie z niniejszym ustawieniem.';
$string['configoutcomesadvanced'] = 'Jeśli ta opcja jest włączona, wyniki w formularzu edycji testu są ustawieniami zaawansowanymi.';
$string['configpenaltyscheme'] = 'Kara odejmowana za każdą błędną odpowiedź w trybie adaptacyjnym.';
$string['configpopup'] = 'Otwórz osobne okno i używaj JavaScript, aby zablokować kopiowanie i wklejanie itp. podczas wypełniania testu.';
$string['configrequirepassword'] = 'Studenci muszą wpisać to hasło, zanim będą mogli rozpocząć test.';
$string['configrequiresubnet'] = 'Studenci mogą podejść do rozwiązania testu tylko z tych komputerów.';
$string['configreviewoptions'] = 'Opcje te kontrolują to, co użytkownicy mogą zobaczyć kiedy przeglądają próby testu lub raport testu.';
$string['configshowblocks'] = 'Pokaż bloki kursu podczas rozwiązywania testu';
$string['configshowuserpicture'] = 'Pokaż na ekranie zdjęcie użytkownika  w czasie prób.';
$string['configshufflewithin'] = 'Jeśli włączysz tę opcję, poszczególne odpowiedzi do danego pytania będą każdorazowo losowo wymieszane, o ile opcja jest również włączona w ustawieniach pytania.';
$string['configtimelimit'] = 'Domyślny czas na rozwiązanie testu (w minutach). 0 oznacza brak limitu.';
$string['configtimelimitsec'] = 'Domyślny czas dla testów w sekundach. 0 - oznacza brak limitu czasowego.';
$string['configurerandomquestion'] = 'Konfiguruj pytanie';
$string['confirmclose'] = 'Po przesłaniu odpowiedzi nie będzie można ich zmienić.';
$string['confirmremovequestion'] = 'Czy na pewno chcesz usunąć to pytanie: {$a}?';
$string['confirmremovesectionheading'] = 'Czy na pewno chcesz usunąć nagłówek sekcji "{$a}"?';
$string['confirmserverdelete'] = 'Czy na pewno chcesz usunąć serwer <b>{$a}</b> z listy?';
$string['connectionerror'] = 'Utracono połączenie. (Automatyczny zapis nie powiódł się).

Zanotuj wszystkie odpowiedzi, jakich udzieliłeś na tej stronie w ciągu ostatnich kilku minut i spróbuj połączyć się z siecią ponownie.

Kiedy połączenie zostanie nawiązane, Twoje odpowiedzi zostaną zapisane, a ten komunikat zniknie.';
$string['connectionok'] = 'Połączenie sieciowe przywrócone. Możesz kontynuować bezpiecznie.';
$string['containercategorycreated'] = 'Do tej kategorii zostały przeniesione wszystkie dotychczasowe kategorie z przyczyn wyszczególnionych poniżej.';
$string['continueattemptquiz'] = 'Kontynuuj swoje podejście';
$string['continuepreview'] = 'Kontynuuj ostatni podgląd';
$string['copyingfrom'] = 'Utwórz kopię pytania \'{$a}\'';
$string['copyingquestion'] = 'Kopiowanie pytania';
$string['correct'] = 'Poprawnie';
$string['correctanswer'] = 'Poprawna odpowiedź';
$string['correctanswerformula'] = 'Formuła poprawnej odpowiedzi';
$string['correctansweris'] = 'Poprawna odpowiedź: {$a}';
$string['correctanswerlength'] = 'Poprawna długość odpowiedzi';
$string['correctanswers'] = 'Poprawne odpowiedzi';
$string['correctanswershows'] = 'Pokaż poprawne odpowiedzi';
$string['corrresp'] = 'Prawidłowa odpowiedź';
$string['countdown'] = 'Odliczanie';
$string['countdownfinished'] = 'Test jest zamykany. Wyślij teraz swoje odpowiedzi.';
$string['countdowntenminutes'] = 'Test zostanie zamknięty za 10 minut';
$string['coursetestmanager'] = 'Format Menedżera Testów Kursu';
$string['createcategoryandaddrandomquestion'] = 'Utwórz kategorię i dodaj losowe pytanie';
$string['createfirst'] = 'Musisz utworzyć najpierw pytania \'krótka odpowiedź\'.';
$string['createmultiple'] = 'Utwórz wiele pytań';
$string['createnewquestion'] = 'Utwórz nowe pytanie';
$string['createquestionandadd'] = 'Utwórz nowe pytanie i dodaj je do testu.';
$string['custom'] = 'Niestandardowy format';
$string['dataitemneed'] = 'Musisz dodać co najmniej jeden zestaw aby utworzyć prawidłowe pytanie.';
$string['datasetdefinitions'] = 'Zestawy wielokrotnego użytku dla kategorii {$a}';
$string['datasetnumber'] = 'Liczba';
$string['daysavailable'] = 'Dni dostępności';
$string['decimaldigits'] = 'Cyfry dziesiętne w ocenie';
$string['decimalplaces'] = 'Miejsca dziesiętne w ocenach';
$string['decimalplaces_help'] = 'Przez użycie tej opcji można wybierać liczbę cyfr dziesiętnych pokazywanych w ocenie. Ustawienie wpływa tylko na sposób wyświetlania ocen. Nie wpływa na wartości przechowywane w bazie danych ani obliczenia, które są prowadzone na pełnej dokładności.';
$string['decimalplacesquestion'] = 'Miejsca dziesiętne w ocenie pytania';
$string['decimalplacesquestion_help'] = 'Liczba cyfr wyświetlanych po przecinku przy wyświetlaniu punktów za poszczególne pytania.';
$string['decimalpoints'] = 'Miejsca dziesiętne';
$string['default'] = 'Domyślny';
$string['defaultgrade'] = 'Domyślna ocena za pytanie';
$string['defaultinfo'] = 'Domyślna kategoria pytań';
$string['delay1'] = 'Czas pomiędzy pierwszym a drugim podejściem';
$string['delay1st2nd'] = 'Wymuszone opóźnienie między 1 i 2 próbą';
$string['delay1st2nd_help'] = 'Jeśli opcja jest włączona, uczeń musi odczekać określony czas, zanim będzie mógł próbować rozwiązać testu po raz drugi.';
$string['delay2'] = 'Czas pomiędzy kolejnymi podejściami';
$string['delaylater'] = 'Wymuszone opóźnienie między późniejszymi próbami';
$string['delaylater_help'] = 'Jeśli opcja jest włączona, uczeń musi odczekać określony czas, zanim będzie mógł próbować rozwiązać testu po raz trzeci i kolejny raz.';
$string['deleteattemptcheck'] = 'Czy jesteś pewien, że chcesz usunąć te podejścia?';
$string['deleteselected'] = 'Usuń wybrane';
$string['deletingquestionattempts'] = 'Usuwanie podejść do pytania';
$string['description'] = 'Opis';
$string['disabled'] = 'Nieaktywny';
$string['displayoptions'] = 'Wyświetl opcje';
$string['donotuseautosave'] = 'Nie używaj auto-zapisu';
$string['download'] = 'Pobierz plik z kategoriami';
$string['downloadextra'] = '(Plik jest przechowywany w plikach kursu/katalogu testu)';
$string['dragtoafter'] = 'Po {$a}';
$string['dragtostart'] = 'Na początek';
$string['duplicateresponse'] = 'Ta próba jest zignorowana, ponieważ podałeś wcześniej równoważne odpowiedzi';
$string['eachattemptbuildsonthelast'] = 'Każda nowa próba na podstawie poprzedniej';
$string['eachattemptbuildsonthelast_help'] = '<p>Jeżeli dozwolone są wielokrotne próby, a ta opcja ustawiona jest na <B>Tak</B>, wtedy każda nowa próba będzie  już zawierać rozwiązania z poprzedniej próby. Pozwala to na wypełnienie testu w kilku podejściach.</p>
<p>Aby każdą  próbę rozpocząć od czystego testy, wybierz <B>Nie</B> dla tego ustawienia.</p>';
$string['edit_slotdisplaynumber_hint'] = 'Edytuj numer pytania (maksymalnie 16 znaków)';
$string['edit_slotdisplaynumber_label'] = 'Nowa wartość dla {$a}';
$string['editcategories'] = 'Edytuj kategorie';
$string['editcategory'] = 'Edytuj kategorię';
$string['editcatquestions'] = 'Edytuj pytania kategorii';
$string['editingquestion'] = 'Edycja pytania';
$string['editingquiz'] = 'Edycja testy';
$string['editingquiz_help'] = 'Główne pojęcia dotyczące testów:

* Test zawiera  jedną lub więcej stron wypełnionych pytaniami

 * Bank pytań, który przechowuje wszystkie pytania podzielone na kategorie

* Pytania Losowe - student dostaje różne pytania za każdym razem, gdy rozwiązuje  test jak i różni studenci mogą dostać różne pytania';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Edycja testu: {$a}';
$string['editmaxmark'] = 'Edytuj maksymalną punktację';
$string['editoverride'] = 'Indywidualne warunki testu';
$string['editqcats'] = 'Edytuj kategorie pytań';
$string['editquestion'] = 'Edytuj pytanie';
$string['editquestions'] = 'Edytuj pytania';
$string['editquiz'] = 'Edytuj zawartość testu';
$string['editquizquestions'] = 'Edycja pytań testu';
$string['emailconfirmautosubmitsmall'] = 'Dziękujemy za przesłanie odpowiedzi w \'{$a->quizname}\'';
$string['emailconfirmbody'] = 'Drogi {$a->username},

Dziękuję za udzielenie odpowiedzi w teście "{$a->quizname}" w kursie "{$a->coursename}" o {$a->submissiontime}.

Ta wiadomość potwierdza, że odpowiedzi zostały poprawnie zapisane.

Test jest dostępny na {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Drogi {$a->username},

Czas na na wypełnienie testu \'{$a->quizname}\' w kursie \'{$a->coursename}\' upłynął. Twoje odpowiedzi zostały przesłane automatycznie o {$a->submissiontime}.

Ta wiadomość potwierdza, że Twoje odpowiedzi zostały zapisane.

Możesz uzyskać dostęp do tego test pod adresem {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Dziękujemy za przesłanie odpowiedzi dot. \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Potwierdzenie przesłania: {$a->quizname}.';
$string['emailmanualgradedbody'] = 'Cześć {$a->nazwa studenta},

Twoje odpowiedzi w teście \'{$a->quizname}\', w kursie \'{$a->coursename}\' w {$a->attempttimefinish} zostały ocenione.

Będziesz mógł zobaczyć swój wynik i informacje zwrotne odwiedzając \'{$a->quizurl}\' i przeglądając swoją próbę.';
$string['emailmanualgradedsubject'] = 'Twoja próba {$a->quizname} została oceniona';
$string['emailnotifybody'] = 'Drogi {$a->username},
{$a->studentname} ukończył test "{$a->quizname}" ({$a->quizurl}) w kursie "{$a->coursename}".

Możesz przejrzeć udzielone odpowiedzi na {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} zakończył(a) {$a->quizname}. Zobacz {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} ukończył {$a->quizname}.';
$string['emailoverduebody'] = 'Witaj {$a->studentname},
rozpocząłeś próbę rozwiązania testu {$a->quizname} w kursie {$a->coursename}, jednak nie przesłałeś swoich odpowiedzi. Podejście powinno było zostać przesłane przed {$a->attemptduedate}.
Jeżeli nadal chcesz przesłać swoje podejście, przejdź do {$a->attemptsummaryurl} i kliknij "prześlij". Musisz to zrobić przed {$a->attemptgraceend} - w przeciwnym razie twoje podejście nie będzie brane pod uwagę.';
$string['emailoverduesmall'] = 'Nie zatwierdziłeś swojego podejścia do {$a->quizname}. Przejdź na {$a->attemptsummaryurl} przed upływem {$a->attemptgraceend} jeżeli nadal chcesz je zatwierdzić.';
$string['emailoverduesubject'] = 'Zaległe podejście: {$a->quizname}';
$string['empty'] = 'Puste';
$string['enabled'] = 'Włączone';
$string['endtest'] = 'Zapisz podejście ...';
$string['erroraccessingreport'] = 'Nie masz dostępu do tego raportu';
$string['errorinquestion'] = 'Błąd w pytaniu';
$string['errormissingquestion'] = 'Błąd: System opuścił pytanie z ID {$a}';
$string['errornotnumbers'] = 'Błąd - odpowiedź musi być liczbą';
$string['errorunexpectedevent'] = 'Nieoczekiwany kod zdarzenia {$a->event} znaleziono dla pytania {$a->questionid} w podejściu {$a->attemptid}.';
$string['essay'] = 'Dłuższa odpowiedź';
$string['essayquestions'] = 'Pytania';
$string['eventattemptautosaved'] = 'Próba podejścia do testu została automatycznie zapisana';
$string['eventattemptdeleted'] = 'Usunięto podejście do testu';
$string['eventattemptpreviewstarted'] = 'Rozpoczęto podgląd podejścia do testu';
$string['eventattemptquestionrestarted'] = 'Próba odpowiedzi na pytanie testu została wznowiona';
$string['eventattemptsummaryviewed'] = 'Wyświetlono podsumowanie podejścia do testu';
$string['eventattemptupdated'] = 'Zaktualizowano podejście do testu';
$string['eventattemptviewed'] = 'Wyświetlono próbę podejścia do testu';
$string['eventeditpageviewed'] = 'Wyświetlono stronę edycji testu';
$string['eventoverridecreated'] = 'Utworzono napisanie testu';
$string['eventoverridedeleted'] = 'Nadpisanie testu zostało usunięte';
$string['eventoverrideupdated'] = 'Nadpisanie testu zostało zaktualizowane';
$string['eventpagebreakcreated'] = 'Utworzono podział strony';
$string['eventpagebreakdeleted'] = 'Usunięto podział strony';
$string['eventquestionmanuallygraded'] = 'Pytanie ocenione ręcznie';
$string['eventquizattemptabandoned'] = 'Próba test porzucona';
$string['eventquizattemptstarted'] = 'Rozpoczęto podejście do testu';
$string['eventquizattemptsubmitted'] = 'Przesłano podejście do testu';
$string['eventquizattempttimelimitexceeded'] = 'Przekroczono limit czasu';
$string['eventquizgradeupdated'] = 'Zaktualizowano ocenę test';
$string['eventreportviewed'] = 'Wyświetlono raport testu';
$string['eventsectionbreakcreated'] = 'Utworzono podział sekcji';
$string['eventsectionbreakdeleted'] = 'Usunięto podział sekcji';
$string['eventsectionshuffleupdated'] = 'Zaktualizowano losowanie sekcji';
$string['eventsectiontitleupdated'] = 'Tytuł sekcji zaktualizowany';
$string['eventslotcreated'] = 'Slot utworzony';
$string['eventslotdeleted'] = 'Slot usunięty';
$string['eventslotdisplayedquestionnumberupdated'] = 'Zaktualizowano numer pytania wyświetlanego w slocie';
$string['eventslotmarkupdated'] = 'Oznaczenie slotu zostało zaktualizowane';
$string['eventslotmoved'] = 'Slot przeniesiony';
$string['everynquestions'] = '{$a} pytania/ń';
$string['everyquestion'] = '1 pytanie';
$string['everythingon'] = 'Wszystko włączone';
$string['existingcategory'] = 'Istniejąca kategoria';
$string['exportcategory'] = 'eksport kategorii';
$string['exporterror'] = 'Błąd podczas eksportu';
$string['exportingquestions'] = 'pytania są wyeksportowane do pliku';
$string['exportname'] = 'Nazwa pliku';
$string['exportquestions'] = 'Wyeksportuj pytania do pliku';
$string['extraattemptrestrictions'] = 'Dodatkowe ograniczenia podejść do testu';
$string['false'] = 'Fałsz';
$string['feedback'] = 'Informacja zwrotna';
$string['feedbackerrorboundaryformat'] = 'Granica oceny musi być wartością liczbową lub procentową. Wartość granicy {$a} nie została rozpoznana.';
$string['feedbackerrorboundaryoutofrange'] = 'Granica oceny musi zawierać się w przedziale od 0% do 100%. Wartość granicy {$a} jest poza zakresem.';
$string['feedbackerrorjunkinboundary'] = 'Musisz podać granice ocen bez przerw (luk).';
$string['feedbackerrorjunkinfeedback'] = 'Musisz wypełnić pola informacji zwrotnych bez przerw (luk).';
$string['feedbackerrororder'] = 'Granice ocen muszą być uporządkowane (najpierw najwyższa). Wartość wprowadzona w granicy {$a} jest w niewłaściwej kolejności.';
$string['file'] = 'Plik';
$string['fileformat'] = 'Format pliku';
$string['fillcorrect'] = 'Wypełnij poprawnymi';
$string['filloutnumericalanswer'] = 'Musisz podać co najmniej jedną możliwą odpowiedź i tolerancję. Punktacja i informacja zwrotna zostanie określona na podstawie pierwszej pasującej odpowiedzi. Na końcu możesz podać informację zwrotną bez odpowiedzi. Zostanie ona pokazana uczestnikom, których odpowiedź nie została przewidziana.';
$string['filloutoneanswer'] = 'Musisz stworzyć przynajmniej jedną odpowiedź. Pola odpowiedzi pozostawione puste będą ignorowane. Znak "*" może być stosowany jako symbol wieloznaczny zastępujący dowolna literę. Pierwsza pasująca odpowiedź będzie użyta do określenia oceny i informacji zwrotnej.';
$string['filloutthreequestions'] = 'Musisz wpisać przynajmniej trzy odpowiedzi. Pola odpowiedzi pozostawione puste będą ignorowane';
$string['fillouttwochoices'] = 'Musisz wpisać przynajmniej dwie odpowiedzi. Pola odpowiedzi pozostawione puste będą ignorowane';
$string['finishattemptdots'] = 'Zakończ podejście...';
$string['finishreview'] = 'Zakończ przegląd';
$string['forceregeneration'] = 'wymuś regenerację';
$string['formatnotfound'] = 'Formatu importu/exportu {$a} nie znaleziono';
$string['formulaerror'] = 'Błąd formuły!';
$string['fractionsaddwrong'] = 'Wybrane odpowiedzi pozytywne nie sumują się do 100% <br />Teraz sumują się do {$a}% <br />Czy chcesz wrócić i poprawić pytanie?';
$string['fractionsnomax'] = 'Jedna z odpowiedzi powinna być warta 100% tak,<br />aby można było uzyskać maksymalną ocenę za to pytanie.<br />Czy chcesz wrócić i poprawić pytanie?';
$string['fromfile'] = 'z pliku:';
$string['functiondisabledbysecuremode'] = 'Ta funkcja jest obecnie wyłączona';
$string['generalfeedback'] = 'Ogólna informacja zwrotna dotycząca pytania';
$string['generalfeedback_help'] = 'Ogólna informacja zwrotna to tekst wyświetlany po udzieleniu odpowiedzi na pytanie. W przeciwieństwie do informacji zwrotnej, która zależy od udzielonej odpowiedzi, ta informacja jest wyświetlana zawsze.';
$string['gobacktoquiz'] = 'Powrót';
$string['graceperiod'] = 'Okres karencji';
$string['graceperiod_help'] = 'Okres karencji można ustawić gdy opcja "Po upływie czasu" jest zaznaczona na istnienie okresu karencji w którym uczestnik ma możliwość zatwierdzenia swoich prób.';
$string['graceperiodmin'] = 'Okres karencji';
$string['graceperiodtoosmall'] = 'Okres karencji musi wynosić więcej niż {$a}.';
$string['grade'] = 'Ocena';
$string['gradeall'] = 'Oceń wszystkie';
$string['gradeaverage'] = 'średnia ocen';
$string['gradeboundary'] = 'Granica oceny';
$string['gradeessays'] = 'Ocena pytania Esej';
$string['gradehighest'] = 'Najwyższa ocena';
$string['gradeitemdefaultname'] = 'Nowy element oceny {$a}';
$string['gradeitemdelete'] = 'Usuń element oceny {$a}';
$string['gradeitemedit'] = 'Edytuj nazwę elementu oceny {$a}';
$string['gradeitemmarkscheme'] = 'Przypisz elementy oceny';
$string['gradeitemnewname'] = 'Nowa nazwa elementu oceny {$a}';
$string['gradeitemnoneselected'] = '[żaden]';
$string['gradeitemnoslots'] = 'Ten test nie zawiera jeszcze pytań. Najpierw dodaj pytania, a następnie wróć tutaj, aby skonfigurować elementy oceny.';
$string['gradeitems'] = 'Oceny';
$string['gradeitemsautosetup'] = 'Ustaw ocenę dla każdej sekcji';
$string['gradeitemsetup'] = 'Konfiguracja elementów oceny';
$string['gradeitemsnoneyet'] = 'Utwórz elementy oceny w swoim teście. Przydziel pytania lub sekcje testu do tych elementów oceny, aby podzielić wyniki oceny na różne obszary.';
$string['gradeitemsremoveall'] = 'Zresetuj ustawienia';
$string['gradeitemsremoveallconfirm'] = 'Zresetować ustawienia elementów oceny?';
$string['gradeitemsremoveallmessage'] = 'Spowoduje to usunięcie wszystkich elementów oceny i przypisania do nich pytań i sekcji.<br><br>Ta czynność nie wpłynie na same pytania i sekcje, ani na istniejące próby w ramach testu.';
$string['gradeitemsremovealltitle'] = 'Resetowanie ustawień elementów oceny';
$string['grademethod'] = 'Metoda oceniania';
$string['grademethod_help'] = 'Jeśli dozwolona jest wielokrotna próba, dostępne są następujące metody obliczania końcowej oceny quizu:

* Najwyższa ocena ze wszystkich prób
* Średnia ocena wszystkich prób
* Pierwsza próba (wszystkie inne próby są ignorowane)
* Ostatnia próba (wszystkie inne próby są ignorowane)';
$string['gradesdeleted'] = 'Oceny testu usunięte';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}';
$string['gradetopassoutof'] = 'Próg zaliczeniowy: {$a->grade} na {$a->maxgrade}';
$string['gradingdetails'] = 'Punkty dla tej propozycji: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Z poprzednimi karami to daje <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'To podejście otrzymuje karę {$a}.';
$string['gradingdetailszeropenalty'] = 'Nie dostałeś kary za to zadanie.';
$string['gradingmethod'] = 'Metoda oceniania: {$a}';
$string['groupoverrides'] = 'Wyjątki dla grupy';
$string['groupoverridesdeleted'] = 'Usunięto wyjątki dla grupy';
$string['groupsnone'] = 'Brak grup, do których masz dostęp.';
$string['guestsno'] = 'Goście nie mogą oglądać ani rozwiązywać testów';
$string['hidebreaks'] = 'Ukryj podział stron';
$string['hidereordertool'] = 'Ukryj narzędzie do porządkowania';
$string['history'] = 'Historia odpowiedzi:';
$string['howquestionsbehave_desc'] = 'Domyślne ustawienia dla zachowań pytań w teście.';
$string['imagedisplay'] = 'Obrazek do wyświetlenia';
$string['import_help'] = 'Funkcja ta pozwala na importowanie pytań z zewnętrznych plików tekstowych. Jeśli plik zawiera znaki spoza ASCII,  musi używać kodowania UTF-8. Bądź szczególnie ostrożny z plikami generowanych przez Microsoft Office, ponieważ często używają specjalnego kodowania, które nie będą prawidłowo obsługiwane. Import i eksport obsługiwane są przez wtyczki. Wiele opcjonalne formatów jest dostępnych w bazie modułów i wtyczek.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'importuj kategorię';
$string['importerror'] = 'Błąd podczas importu pliku';
$string['importfilearea'] = 'Importuj z pliku znajdującego się w plikach kursu';
$string['importfileupload'] = 'Import z pobranego pliku';
$string['importfromthisfile'] = 'Import z tego pliku';
$string['importingquestions'] = 'Importowanie {$a} pytań z pliku';
$string['importmax10error'] = 'Tu jest błąd w pytaniu. Nie można mieć więcej niż 10 odpowiedzi.';
$string['importmaxerror'] = 'W pytaniu występuje błąd. Zbyt dużo odpowiedzi.';
$string['importquestions'] = 'Importuj pytania z pliku';
$string['inactiveoverridehelp'] = '* To nadpisanie jest nieaktywne, ponieważ dostęp użytkownika do aktywności jest ograniczony. Może to być spowodowane przypisaniem do grupy lub roli, innymi ograniczeniami dostępu lub ukryciem aktywności.';
$string['incorrect'] = 'Niepoprawnie';
$string['indicator:cognitivedepth'] = 'Poznawczość Testu';
$string['indicator:cognitivedepth_help'] = 'Ten wskaźnik opiera się na głębi poznawczej osiągniętej przez studenta podczas korzystania z aktywności Test.';
$string['indicator:cognitivedepthdef'] = 'Poznawczość Testu';
$string['indicator:cognitivedepthdef_help'] = 'Uczestnik osiągnął określony procent zaangażowania poznawczego oferowanego przez aktywność Test w tym okresie analizy (Poziomy = Brak wyświetlenia, Wyświetlenie, Wysłanie, Wyświetlenie informacji zwrotnej, Skomentowanie informacji zwrotnej, Ponowne wysłanie po zapoznaniu się z informacją zwrotną)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Indywidualne odpowiedzi na dane pytanie';
$string['info'] = 'Informacja';
$string['infoshort'] = 'info';
$string['inprogress'] = 'W toku';
$string['introduction'] = 'Opis';
$string['invalidattemptid'] = 'Identyfikator próby nie istnieje';
$string['invalidcategory'] = 'ID kategorii jest niewłaściwe';
$string['invalidoverrideid'] = 'Nieprawidłowe ID przy nadpisywaniu';
$string['invalidquestionid'] = 'Nieprawidłowe id pytania';
$string['invalidquizid'] = 'Nieprawidłowe ID testu';
$string['invalidrandomslot'] = 'Nieprawidłowy identyfikator slotu losowego pytania.';
$string['invalidsource'] = 'Dane źródło nie są prawidłowe';
$string['invalidsourcetype'] = 'Niepoprawne dane źródłowe';
$string['invalidstateid'] = 'Niepoprawny status ID';
$string['lastanswer'] = 'Twoja ostatnia odpowiedź to';
$string['lastautosave'] = 'Ostatnio zapisano: {$a}';
$string['layout'] = 'Układ';
$string['layoutasshown'] = 'Układ strony jak widać';
$string['layoutasshownwithpages'] = 'Układ strony jak widać. <small>(Automatyczna nowa strona co {$a} pytań.)</small>';
$string['layoutshuffledandpaged'] = 'Ułóż pytania losowo, umieść {$a} pytań na stronę.';
$string['layoutshuffledsinglepage'] = 'Ułóż pytania losowo, wszystkie na jednej stronie.';
$string['link'] = 'Link';
$string['listitems'] = 'Lista pytań w teście';
$string['literal'] = 'Znak';
$string['loadingquestionsfailed'] = 'Przesyłanie pytań zakończone niepowodzeniem: {$a}';
$string['makecopy'] = 'Zachowaj jako nowe pytanie';
$string['managetypes'] = 'Edytuj typy pytań i serwery';
$string['manualgradequestion'] = 'Ręcznie ocenione pytanie {$a->question} dla testu {$a->quiz}, użytkownika {$a->user}';
$string['manualgrading'] = 'Ocenianie';
$string['mark'] = 'Zatwierdź';
$string['markall'] = 'Zatwierdź stronę';
$string['marks'] = 'Punkty';
$string['marks_help'] = 'Punkty przyznane za odpowiedź na poszczególne pytania oraz ogólny wynik próby. Punkty można wybrać tylko wtedy, gdy wybrana jest opcja "Maksymalna liczba punktów".';
$string['match'] = 'Dopasuj odpowiedź';
$string['matchanswer'] = 'Pasująca odpowiedź';
$string['matchanswerno'] = 'Pasująca odpowiedź {$a}';
$string['max'] = 'Max.';
$string['maxmark'] = 'Maksymalna ocena';
$string['maxmarks'] = 'Maksymalna liczba punktów';
$string['maxmarks_help'] = 'Maksymalna liczba punktów dostępna dla każdego pytania.';
$string['messageprovider:attempt_grading_complete'] = 'Powiadomienie, że Twoja próba została oceniona';
$string['messageprovider:attempt_overdue'] = 'Ostrzeżenie o przedawnieniu podejścia do testu';
$string['messageprovider:confirmation'] = 'Powiadomienie o wypełnieniu twojego testu';
$string['messageprovider:quiz_open_soon'] = 'Test wkrótce się otworzy';
$string['messageprovider:submission'] = 'Powiadomienie o przesłanych testach przez studentów';
$string['min'] = 'Min.';
$string['minutes'] = 'Minut';
$string['missingcategory'] = 'Brak kategorii pytań';
$string['missingcorrectanswer'] = 'Poprawna odpowiedź musi być określona';
$string['missingitemtypename'] = 'Pominięto nazwę';
$string['missingquestion'] = 'Wygląda na to, że to pytanie nie istnieje';
$string['modulename'] = 'Test';
$string['modulename_help'] = 'Moduł Test (dawniej Quiz) pozwala nauczycielowi na tworzenie testów składających się z pytań różnego typu, w tym pytań wielokrotnego wyboru, dopasowywania, krótkich odpowiedzi i numerycznych.

Nauczyciel może zezwolić na wielokrotne podejście do testu, pytaniami wybieranymi losowo z banku pytań. Może zostać ustalony limit czasowy.

Każda próba jest oceniana automatycznie, z wyjątkiem pytań opisowych/otwartych, a ocena jest zapisywana w dzienniku ocen.

Nauczyciel może wybrać, kiedy i czy wskazówki, informacje zwrotne i prawidłowe odpowiedzi będą pokazywane uczniom.

Można stosować testy:
* jako egzaminy z kursu
* jako mini testy do czytania zadań lub na koniec tematu
* jako praktyka egzaminacyjna z wykorzystaniem pytań z poprzednich egzaminów
* aby zapewnić natychmiastową informację zwrotną na temat wydajności
* do samooceny';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Testy';
$string['moveselectedonpage'] = 'Przesuń zaznaczone pytania na stronę: {$a}';
$string['multichoice'] = 'Wielokrotny wybór';
$string['multipleanswers'] = 'Wybierz co najmniej jedną odpowiedź';
$string['mustbesubmittedby'] = 'Podejście musi być zakończone przed: {$a}.';
$string['name'] = 'Nazwa';
$string['navigatenext'] = 'Następna strona';
$string['navigateprevious'] = 'Poprzednia strona';
$string['navmethod'] = 'Metoda nawigacji';
$string['navmethod_free'] = 'Dowolna';
$string['navmethod_help'] = 'W sekwencyjnym trybie nawigacji, student musi przejść przez test w określonej kolejności pytań, nie może wrócić do poprzedniego pytania, ani przeskoczyć do przodu';
$string['navmethod_seq'] = 'Sekwencyjna';
$string['navnojswarning'] = 'Uwaga: te linki nie zapiszą twoich odpowiedzi. Użyj następnego przycisku na dole strony.';
$string['neverallononepage'] = 'Wszystkie pytania na jednej stronie';
$string['newattemptfail'] = 'Błąd: Nie można uruchomić na nowo testu.';
$string['newcategory'] = 'Nowa kategoria';
$string['newpage'] = 'Pytań na stronie';
$string['newpage_help'] = 'W przypadku dłuższych testów sensowne jest rozciągnięcie testu na kilka stron, ograniczając liczbę pytań na stronie. Podczas dodawania pytań do testu podziały stron zostaną automatycznie wstawione zgodnie z tym ustawieniem. Jednak podziały stron można później zmienić ręcznie na stronie edycji testu.';
$string['newpageevery'] = 'Automatycznie rozpocznij nową stronę';
$string['newsectionheading'] = 'Nowy nagłowek';
$string['noanswers'] = 'Nie wybrano odpowiedzi!';
$string['noattempts'] = 'Nie ma podejść do testu';
$string['noattemptsfound'] = 'Nie znaleziono prób.';
$string['noattemptstoshow'] = 'Nie ma żadnych podejść do pokazania';
$string['nocategory'] = 'Nieprawidłowa lub nieokreślona kategoria';
$string['noclose'] = 'Brak daty zamknięcia';
$string['nocommentsyet'] = 'Nie ma jeszcze komentarzy';
$string['noconnection'] = 'Nie ma obecnie łączności z serwerem, który może sprawdzić te pytanie. Proszę skontaktować się z administratorem.';
$string['nodataset'] = 'nic - to nie jest symbol specjalny';
$string['nodatasubmitted'] = 'Nie przesłano żadnych danych';
$string['noessayquestionsfound'] = 'Nie znaleziono ręcznie ocenionych pytań';
$string['nogradewarning'] = 'Ten test nie jest oceniany, więc nie można wprowadzić ogólnej informacji zwrotnej, która zależy od oceny.';
$string['nomoreattempts'] = 'Dalsze podejścia nie są dostępne';
$string['none'] = 'Żaden';
$string['noopen'] = 'Brak daty otwarcia';
$string['nooverridedata'] = 'Musisz nadpisać przynajmniej jedno z ustawień testu.';
$string['nopossibledatasets'] = 'Brak zestawów';
$string['noquestionintext'] = 'Tekst pytania nie zawiera żadnych zamieszczonych pytań';
$string['noquestions'] = 'Nie dodano jeszcze żadnego pytania';
$string['noquestionsfound'] = 'Nie można znaleźć pytań';
$string['noquestionsinquiz'] = 'Brak pytań w tym teście.';
$string['noquestionsnotinuse'] = 'To losowe pytanie nie może być użyte, odkąd jego kategoria jest pusta.';
$string['noquestionsonpage'] = 'Pusta strona';
$string['noresponse'] = 'Brak odpowiedzi';
$string['noreview'] = 'Nie możesz przeglądać tego testu';
$string['noreviewattempt'] = 'Nie masz uprawnień do dokonania przeglądu tego podejścia.';
$string['noreviewshort'] = 'Przegląd próby niedozwolony';
$string['noreviewuntil'] = 'Nie możesz przeglądać tego testu do {$a}';
$string['noreviewuntilshort'] = 'Dostępny {$a}';
$string['noscript'] = 'JavaScript musi być włączony, aby można było kontynuować!';
$string['notavailabletostudents'] = 'Uwaga: Ten test jest obecnie niedostępny dla studentów.';
$string['notenoughrandomquestions'] = 'Niestety nie ma wystarczająco dużo pytań w kategorii {$a->category}, by utworzyć pytanie {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Nie zdefiniowano wystarczającej liczby podpunktów pytań! <br /> Czy chcesz wrócić i poprawić pytanie?';
$string['notifyattemptsgradedtask'] = 'Wyślij powiadomienia o ocenionych próbach testu';
$string['notimedependentitems'] = 'Czynniki zależne czasowo nie są w tej chwili wspierane przez moduł test. Tak jak dla całości pracy ustaw limit czasu dla całego testu. Chcesz wybrać inny czynnik (lub mimo to używać obecnego)?';
$string['notyetgraded'] = 'Jeszcze nie ocenione';
$string['notyetviewed'] = 'Jeszcze nie wyświetlany';
$string['notyourattempt'] = 'To nie jest Twoja próba!';
$string['noview'] = 'Zalogowany użytkownik nie może zobaczyć tego testu';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} wykonał {$a->attemptnum} podejść';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numeryczne';
$string['numquestionsx'] = 'Pytania:  {$a}';
$string['oneminute'] = '1 minuta';
$string['onlyteachersexport'] = 'Tylko nauczyciele mogą eksportować pytania';
$string['onlyteachersimport'] = 'Tylko nauczyciele z prawami edycji mogą importować pytania';
$string['onthispage'] = 'Ta strona';
$string['open'] = 'Nie udzielono odpowiedzi';
$string['openafterclose'] = 'Nie udało się zaktualizować testu. Podałeś datę otwarcia po dacie zamknięcia.';
$string['openclosedatesupdated'] = 'Daty otwarcia i zamknięcia';
$string['optional'] = 'opcjonalny';
$string['orderandpaging'] = 'Zmiana układu stron i porządkowanie';
$string['orderandpaging_help'] = 'Numery 10, 20, 30, ... przy pytanich określają kolejność pytań. Odstępy co 10 pozwalają wstawić dodatkowe pytań pomiędzy. Aby zmienić kolejność pytań, należy zmienić numery, a następnie kliknąć przycisk "Zmiana kolejności pytań". Aby dodać podziały stron po poszczególnych pytaniach, zaznacz pola wyboru obok tych pytań, następnie kliknij przycisk "Dodaj nowe strony po zaznaczonych pytaniach".
Aby inaczej podzielić pytania na strony, kliknij przycisk \'Zmień układ stron\' i wybierz żądaną liczbę pytań na stronę.';
$string['orderingquiz'] = 'Zmiana układu stron i kolejności';
$string['orderingquizx'] = 'Zmiana układu stron i kolejności: {$a}';
$string['outcomesadvanced'] = 'Efekty uczenia się są ustawieniami zaawansowanymi';
$string['outof'] = '{$a->grade} z {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} pkt. na {$a->maxgrade} pkt. możliwych do uzyskania ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Całościowa inf. zwrotna';
$string['overallfeedback_help'] = '"Całościowa informacja zwrotna" to tekst wyświetlany po zakończeniu podejścia do testu. Można wyświetlać różne informacje, w zależności od osiągniętych ocen, podając przedziały ocen (jako procenty lub liczby).';
$string['overdue'] = 'Opóźnienie';
$string['overduehandling'] = 'Po upływie czasu';
$string['overduehandling_desc'] = 'Co powinno się zdarzyć, jeśli uczeń nie zatwierdzi testu przed upływem czasu.';
$string['overduehandling_help'] = 'Za pomocą tego ustawienia można zadecydować o tym co się stanie gdy uczestnik nie zatwierdzi próby a skończy się czas przydzielony na rozwiązanie tego testu. Jeśli uczestnik nadal pracuje w teście - wszelkie podejścia zostaną zapisane. Jeśli natomiast nastąpi wylogowanie się - wtedy za pomocą tego ustawienia możemy precyzyjnie określić - jakiego działania oczekujemy.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Próby muszą być zatwierdzone przed upływem czasu, w przeciwnym razie nie są liczone';
$string['overduehandlingautosubmit'] = 'Otwarte podejścia są zapisywane automatycznie';
$string['overduehandlinggraceperiod'] = 'Istnieje okres karencji, gdy otwarte próby muszą być zatwierdzone, ale nie jest możliwe odpowiadanie na kolejne pytania.';
$string['overduemustbesubmittedby'] = 'To podejście jest opóźnione (karencja): powinno było zostać zatwierdzone i złożone. Jeśli chcesz, aby zostało ocenione, musisz je zatwierdzić i złożyć do: {$a} . Jeśli nie zrobisz tego do tego czasu, żadne punkty za to podejście nie zostaną przyznane.';
$string['override'] = 'Wyjątki';
$string['overridecannotchange'] = 'Po utworzeniu nadpisania nie można zmienić użytkownika ani grupy.';
$string['overridecannotsetbothgroupanduser'] = 'Nie można ustawić jednocześnie grupy i użytkownika.';
$string['overridedeletegroupsure'] = 'Czy jesteś pewien, że chcesz usunąć specjalne warunki testu dla grupy {$a}?';
$string['overridedeleteusersure'] = 'Czy jesteś pewien, że chcesz usunąć specjalne warunki testu dla użytkownika {$a}?';
$string['overridegroup'] = 'Nadpisz grupę';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}
';
$string['overrideinvalidattempts'] = 'Wartość dostępnych prób musi być większa od zera.';
$string['overrideinvalidgroup'] = 'Podana grupa nie istnieje.';
$string['overrideinvalidtimelimit'] = 'Limit czasu musi być większy od zera.';
$string['overrideinvaliduser'] = 'Podany użytkownik nie istnieje.';
$string['overrides'] = 'Wyjątki';
$string['overridesforquiz'] = 'Ustawienia nadpisań: {$a}';
$string['overridesnoneforgroups'] = 'W tym teście nie utworzono nadpisań ustawień grupy.';
$string['overridesnoneforusers'] = 'W tym teście nie utworzono żadnych nadpisań ustawień użytkownika.';
$string['overridessummary'] = 'Istnieją wyjątki ustawień ({$a})';
$string['overridessummarygroup'] = 'Grupy: {$a}';
$string['overridessummarythisgroup'] = 'Istnieją wyjątki ustawień ({$a}) dla tej grupy';
$string['overridessummaryuser'] = 'Użytkownicy: {$a}';
$string['overridessummaryyourgroups'] = 'Istnieją zastąpienia ustawień ({$a}) dla Twoich grup';
$string['overrideuser'] = 'Użytkownicy objęci zmianami';
$string['overrideusereventname'] = '{$a->quiz} - nadpisanie';
$string['page-mod-quiz-edit'] = 'Strona edycji testu';
$string['page-mod-quiz-summary'] = 'Podsumowanie podejścia';
$string['page-mod-quiz-view'] = 'Strona informacyjna testu';
$string['page-mod-quiz-x'] = 'Dowolna strona testu';
$string['pagesize'] = 'Rozmiar strony';
$string['parent'] = 'Nadrzędny';
$string['parentcategory'] = 'Kategoria nadrzędna';
$string['parsingquestions'] = 'Przetwarzanie pytań z importowanego pliku.';
$string['partiallycorrect'] = 'Częściowo poprawnie';
$string['penalty'] = 'Kara';
$string['penaltyscheme'] = 'Zastosuj kary';
$string['penaltyscheme_help'] = 'Jeśli ta opcja jest włączona, kara jest odejmowana od końcowej oceny za pytanie za złą odpowiedź. Wysokość kary określona jest w ustawieniach pytania. To ustawienie ma zastosowanie tylko wtedy, gdy włączony jest tryb adaptacyjny.';
$string['percentcorrect'] = 'Procent poprawnych odpowiedzi';
$string['pleaseclose'] = 'Żądanie zostało wykonane. Można już zamknąć okno.';
$string['pluginadministration'] = 'Administracja testu';
$string['pluginname'] = 'Test';
$string['popup'] = 'Pokaż test w "bezpiecznym" oknie';
$string['popupblockerwarning'] = 'Być może będziesz musiał rozwiązać test w bezpiecznym oknie. Wyłącz blokadę okien wyskakujących.';
$string['popupnotice'] = 'Studenci będą widzieć ten test w "bezpiecznym" oknie';
$string['preprocesserror'] = 'Wystąpił błąd podczas przetwarzania wstępnego!';
$string['preview'] = 'Podgląd';
$string['previewquestion'] = 'Podgląd pytania';
$string['previewquiz'] = 'Podgląd {$a}';
$string['previewquiznow'] = 'Pokaż podgląd testu';
$string['previewquizstart'] = 'Podgląd testu';
$string['previous'] = 'Poprzedni stan';
$string['privacy:metadata:quiz_attempts'] = 'Szczegóły dotyczące każdej próby testu.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Numer próby';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Bieżąca strona, na której znajduje się użytkownik.';
$string['privacy:metadata:quiz_attempts:state'] = 'Aktualny stan próby.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Suma ocen w próbie.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Czas ukończenia próby.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Czas aktualizacji próby.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Czas rozpoczęcia próby.';
$string['privacy:metadata:quiz_grades:grade'] = 'Ogólna ocena z tego quizu.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Test, który został oceniony.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Czas modyfikacji oceny.';
$string['privacy:metadata:quiz_grades:userid'] = 'Użytkownik, który został oceniony.';
$string['privacy:metadata:quiz_overrides'] = 'Szczegóły dotyczące nadpisań dla tego testu';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Test z nadpisanymi informacjami';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Nowy czas zamknięcia testu.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Nowy limit czasu testu.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Nowy czas otwarcia testu.';
$string['privacy:metadata:quizaccess'] = 'Aktywność test wykorzystuje zasady dostępu do testu.';
$string['publish'] = 'Opublikuj';
$string['publishedit'] = 'Musisz mieć odpowiednie uprawnienia w kursie aby dodawać lub edytować pytania w tej kategorii';
$string['qbrief'] = 'Pyt. {$a}';
$string['qname'] = 'nazwa';
$string['qti'] = 'Format IMS QTI';
$string['qtypename'] = 'typ, nazwa';
$string['question'] = 'Pytanie';
$string['questionbank'] = 'z bazy pytań';
$string['questionbankmanagement'] = 'Zarządzanie pytaniami';
$string['questionbehaviour'] = 'Zachowanie pytań';
$string['questioncats'] = 'Kategorie pytań';
$string['questiondeleted'] = 'To pytanie zostało usunięte. Skontaktuj się ze swoim nauczycielem.';
$string['questiondependencyadd'] = 'Brak ograniczeń co do tego, kiedy można podjąć próbę odpowiedzi na pytanie {$a->thisq} • Kliknij, aby zmienić';
$string['questiondependencyfree'] = 'Brak ograniczeń dla tego pytania';
$string['questiondependencyremove'] = 'Nie można podjąć próby odpowiedzi na pytanie {$a->thisq}, dopóki nie zostanie ukończone poprzednie pytanie {$a->previousq} • Kliknij, aby zmienić';
$string['questiondependsonprevious'] = 'Tego pytania nie możesz zobaczyć dopóki nie odpowiesz na pytanie poprzednie.';
$string['questiondraftonly'] = 'Pytanie {$a} jest w wersji roboczej. Aby użyć go w teście, przejdź do banku pytań i zmień status na gotowy.';
$string['questiondraftwillnotwork'] = 'Pytanie jest w wersji roboczej. Aby użyć go w teście, przejdź do banku pytań i zmień status na gotowy.';
$string['questioninuse'] = 'Pytanie \'{$a->questionname}\' jest używane w: <br />{$a->quiznames}<br />To pytanie nie zostanie usunięte z tych testów, lecz tylko z listy kategorii.';
$string['questionmissing'] = 'Brakuje pytania dla tej sesji';
$string['questionname'] = 'Nazwa pytania';
$string['questionnonav'] = '<span class="accesshide">Pytanie </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informacja</span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Pytanie {$a} nie zostało załadowane z bazy danych';
$string['questionorder'] = 'Kolejność pytań';
$string['questionposition'] = 'Nowe położenie na liście pytania {$a}';
$string['questions'] = 'Pytania';
$string['questionsetpreview'] = 'Podgląd zestawu pytań';
$string['questionsinclhidden'] = 'Pytania (również ukryte)';
$string['questionsinthisquiz'] = 'Pytania tego testu';
$string['questionsmatchingfilter'] = 'Pytania pasujące do tego filtra: {$a}';
$string['questionsperpage'] = 'Pytań na stronie';
$string['questionsperpageselected'] = 'Liczba pytań na stronie została ustawiona, co wymusza podział na strony. Dlatego kontrolni podziału na strony są nieaktywne. Można to zmienić w {$a}';
$string['questionsperpagex'] = 'Pytań na stonę: {$a}';
$string['questiontext'] = 'Tekst pytania';
$string['questiontextisempty'] = '[Pusty tekst pytania]';
$string['questiontype'] = 'Pytanie typu {$a}';
$string['questiontypesetupoptions'] = 'Ustawienia dla typów pytań:';
$string['questionversion'] = 'wer. {$a}';
$string['questionversionlatest'] = 'wer. {$a} (najnowsza)';
$string['quiz:addinstance'] = 'Dodaj nowy test';
$string['quiz:attempt'] = 'Rozwiąż testy';
$string['quiz:deleteattempts'] = 'Usuń podejścia do testów';
$string['quiz:emailconfirmsubmission'] = 'Otrzymuj potwierdzenie o przesłanych własnych testach';
$string['quiz:emailnotifyattemptgraded'] = 'Otrzymuj powiadomienie, gdy Twoja próba zostanie oceniona';
$string['quiz:emailnotifysubmission'] = 'Otrzymuj powiadomienia o przesłanych testach przez studentów';
$string['quiz:emailwarnoverdue'] = 'Otrzymuje informację kiedy czas podejścia się się kończy i należy zakończyć test.';
$string['quiz:grade'] = 'Oceniaj testy ręcznie';
$string['quiz:ignoretimelimits'] = 'Ignoruj limit czasu testu';
$string['quiz:manage'] = 'Zarządzaj testami';
$string['quiz:manageoverrides'] = 'Zarządzaj wyjątkami ustawień testu';
$string['quiz:preview'] = 'Podgląd testów';
$string['quiz:regrade'] = 'Oceń ponownie podejścia';
$string['quiz:reviewmyattempts'] = 'Zobacz swoje rozwiązania';
$string['quiz:view'] = 'Pokaż informacje o teście';
$string['quiz:viewreports'] = 'Oglądaj raporty testów';
$string['quizavailable'] = 'Test jest dostępny do: {$a}';
$string['quizclose'] = 'Zamknij test';
$string['quizclosed'] = 'Ten test został zamknięty {$a}';
$string['quizcloses'] = 'Test zamyka się';
$string['quizcloseson'] = 'Ten test zakończy się {$a}.';
$string['quizeventcloses'] = '{$a} zamyka się';
$string['quizeventopens'] = '{$a} otwiera się';
$string['quizisclosed'] = 'Ten test jest zamknięty';
$string['quizisclosedwillopen'] = 'Test zamknięty (zostanie otwarty {$a})';
$string['quizisopen'] = 'Ten test jest otwarty';
$string['quizisopenwillclose'] = 'Test otwarty (do {$a})';
$string['quiznavigation'] = 'Nawigacja w teście';
$string['quizopen'] = 'Otwórz test';
$string['quizopenclose'] = 'Daty otwarcia i zamknięcia';
$string['quizopenclose_help'] = 'Studenci mogą zacząć podejścia po dacie otwarcia, muszę je skończyć przed datą zamknięcia.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopendatesoonhtml'] = '<p>Drogi użytkowniku: {$a->firstname},<br>
wkrótce dostępny będzie test <strong>{$a->quizname}</strong> w kursie {$a->coursename}. </p>
<p><strong>Test otwiera się:</strong> {$a->timeopen}<br>
<strong>Test zamyka się:</strong> {$a->timeclose}<br>
<a href="{$a->url}">Przejdź do testu</a></p>';
$string['quizopendatesoonsubject'] = 'Otwiera się {$a->timeopen}: {$a->quizname}';
$string['quizopened'] = 'Ten test jest otwarty.';
$string['quizopenedon'] = 'Ten test został otwarty: {$a}';
$string['quizopens'] = 'Test się otwiera';
$string['quizopenwillclose'] = 'Ten test jest otwarty (zostanie zamknięty {$a})';
$string['quizordernotrandom'] = 'Kolejność w teście jest losowa';
$string['quizorderrandom'] = '* Kolejność w teście jest losowa';
$string['quizreport'] = 'Raport testu';
$string['quizsettings'] = 'Ustawienia testu';
$string['quizsetupnavigation'] = 'Nawigacja po ustawieniach testu';
$string['quiztimer'] = 'Stoper testu';
$string['quizwillopen'] = 'Ten test zostanie otwarty {$a}';
$string['random'] = 'Losowe pytanie';
$string['randomcatwithsubcat'] = '{$a} i podkategorie';
$string['randomcoursecatwithsubcat'] = 'Dowolna kategoria w kategorii kursu {$a}';
$string['randomcoursewithsubcat'] = 'Dowolna kategoria w tym kursie';
$string['randomcreate'] = 'Utwórz pytania wybierane losowo';
$string['randomediting'] = 'Edycja losowego pytania';
$string['randomfaultynosubcat'] = 'Błędne pytanie';
$string['randomfromcategory'] = 'Pytanie wybierane losowo z kategorii:';
$string['randomfromexistingcategory'] = 'Pytanie wybierane losowo z istniejącej kategorii';
$string['randomfromunavailabletag'] = '{$a} (niedostępne)';
$string['randommodulewithsubcat'] = 'Dowolna kategoria tego quizu';
$string['randomnosubcat'] = 'Pytania tylko z tej kategorii, z wyłączeniem subkategorii';
$string['randomnumber'] = 'Liczba losowych pytań';
$string['randomqname'] = 'Losowe pytanie bazujące na warunkach filtra';
$string['randomqnamecat'] = 'Losowe pytanie z kategorii ({$a->category}) bazujące na warunkach filtra';
$string['randomqnamecattags'] = 'Losowa kategoria ({$a->category}) na podstawie warunku filtra z tagami: {$a->tags}';
$string['randomqnametags'] = 'Losowe pytanie bazujące na warunkach filtra z tagami: {$a}';
$string['randomquestion'] = 'Pytanie losowe';
$string['randomquestion_help'] = 'Pytanie losowe polega na wstawieniu do aktywności losowo wybranego pytania z określonej kategorii lub o określonym tagu.';
$string['randomquestiontags'] = 'Tagi';
$string['randomquestiontags_help'] = 'Możesz dalej ograniczać kryteria wyboru, podając tutaj kilka tagów pytań.

Pytania "losowe" zostaną wybrane z pytań, które posiadają wszystkie te tagi.';
$string['randomquestionusinganewcategory'] = 'Pytanie wybierane losowo wykorzystujące nową kategorię';
$string['randomsystemwithsubcat'] = 'Dowolna kategoria na poziomie systemu';
$string['randomwithsubcat'] = 'Pytania z tej kategorii i jej podkategorii.';
$string['readytosend'] = 'Za chwilę twoje podejście do testu zostanie przesłane do ocenienia. Czy chcesz kontynuować?';
$string['reattemptquiz'] = 'Spróbuj ponownie rozwiązać test';
$string['recentlyaddedquestion'] = 'Ostatnio dodane pytanie!';
$string['recurse'] = 'Uwzględnij również pytania z podkategorii';
$string['redoesofthisquestion'] = 'Podjęto próbę rozwiązania innych pytań: {$a}';
$string['redoquestion'] = 'Wypróbuj inne pytanie, takie jak to';
$string['regrade'] = 'Ponownie oceń wszystkie próby';
$string['regradecomplete'] = 'Wszystkie próby zostały ponownie ocenione';
$string['regradecount'] = 'Zmieniono {$a->changed} z {$a->attempt} ocen';
$string['regradedisplayexplanation'] = 'Próby, które zostały zmienione podczas ponownego oceniania, są pokazane jako łącza';
$string['regradenotallowed'] = 'Nie masz uprawnień do ponownej oceny tego testu.';
$string['regradingquestion'] = 'Oceń ponownie "{$a}"';
$string['regradingquiz'] = 'Oceń ponownie test "{$a}"';
$string['remove'] = 'Usuń';
$string['removeallgroupoverrides'] = 'Wszystkie wyjątki dla grupy';
$string['removeallquizattempts'] = 'Wszystkie podejścia';
$string['removealluseroverrides'] = 'Wszystkie wyjątki dla użytkownika';
$string['removeemptypage'] = 'Usuń pustą stronę';
$string['removepagebreak'] = 'Usuń załamanie strony';
$string['removeselected'] = 'Usuń zaznaczone';
$string['rename'] = 'Zmień nazwę';
$string['renderingserverconnectfailed'] = 'Serwer {$a} jest niedostępny. Sprawdź, czy adres URL jest poprawny.';
$string['reopenattempt'] = 'Otwórz ponownie';
$string['reopenattemptareyousuremessage'] = 'To spowoduje ponowne otwarcie próby {$a->attemptnumber} dla {$a->attemptuser}.';
$string['reopenattemptareyousuretitle'] = 'Czy otworzyć ponownie podejście?';
$string['reopenattemptwrongstate'] = 'Próba {$a->attemptid} ma niewłaściwy status - ({$a->state}), aby można ją było ponownie otworzyć.';
$string['reopenedattemptwillbeinprogress'] = 'Próba zostanie otwarta i może być kontynuowana.';
$string['reopenedattemptwillbeinprogressuntil'] = 'Próba zostanie otwarta i może być kontynuowana do momentu zamknięcia testu {$a}.';
$string['reopenedattemptwillbesubmitted'] = 'Próba zostanie natychmiast przekazana do oceny.';
$string['reorderquestions'] = 'Zmień kolejność pytań';
$string['reordertool'] = 'Pokaż narzędzia do reorganizacji';
$string['repaginate'] = 'Zmień układ stron na {$a} pytań na stronę';
$string['repaginatecommand'] = 'Zmień układ stron';
$string['repaginatenow'] = 'Zmień układ stron teraz';
$string['replace'] = 'Zastąp';
$string['replacementoptions'] = 'Opcje wymiany';
$string['report'] = 'Raporty';
$string['reportanalysis'] = 'Analiza elementów';
$string['reportattemptsfrom'] = 'Podejścia od';
$string['reportattemptsthatare'] = 'Podejścia które są';
$string['reportdisplayoptions'] = 'Wyświetl opcje';
$string['reportfullstat'] = 'Szczegółowe statystyki';
$string['reportmulti_percent'] = 'Multi-Procenty';
$string['reportmulti_q_x_student'] = 'Wybory wielu studentów';
$string['reportmulti_resp'] = 'Indywidualne odpowiedzi';
$string['reportmustselectstate'] = 'Musisz wybrać przynajmniej jeden stan.';
$string['reportnotfound'] = 'Nieznany raport ({$a})';
$string['reportoverview'] = 'Przegląd';
$string['reportregrade'] = 'Ponownie oceń próby';
$string['reportresponses'] = 'Szczegółowe odpowiedzi';
$string['reports'] = 'Raporty';
$string['reportshowonly'] = 'Pokaż tylko podejścia';
$string['reportshowonlyfinished'] = 'Pokaż po jednym zakończonym podejściu na użytkownika ({$a})';
$string['reportsimplestat'] = 'Proste statystyki';
$string['reportusersall'] = 'wszyscy użytkownicy, którzy próbowali rozwiązać test';
$string['reportuserswith'] = 'zapisani użytkownicy, którzy próbowali rozwiązać test';
$string['reportuserswithorwithout'] = 'zapisani użytkownicy, którzy próbowali, lub nie, rozwiązać test';
$string['reportuserswithout'] = 'zapisani użytkownicy, którzy nie próbowali rozwiązać testu';
$string['reportwhattoinclude'] = 'Co zawrzeć w raporcie';
$string['requirepassword'] = 'Wymagane hasło';
$string['requirepassword_help'] = '<p>To pole jest opcjonalne</p>

<p>Jeśli wpiszesz tutaj hasło, studenci bedą musieli je podać aby
podejść do testu.</p>';
$string['requiresubnet'] = 'Wymagany adres sieciowy';
$string['requiresubnet_help'] = '<p align=center><b>Wymagaj adresu w sieci</b></p>

<p>To pole jest opcjonalne.</p>

<p>Możesz ograniczyć dostęp do testu do konkretnych studentów
łączących się za pomocą sieci LAN lub Internetu definiując listę oddzielonych przecinkami pełnych lub częściowych adresów IP.</p>

<p>Przykład:  <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>

<p>Są dostępne trzy sposoby zapisu adresu IP (nie możesz używać
nazwy hostów czy domeny, tylko adresy IP):
<ol>
<li>Pełen adres IP, taki jak <b>192.168.10.1</b> który jest przypisany do jednego komputera lub do serwera proxy.</li>
<li>Częściowy adres, taki jak <b>192.168</b>, który wpuści wszystkie adresy zaczynające się od tych cyfr.</li>
<li>Zapis CIDR, taki jak <b>231.54.211.0/20</b>, który zezwala Ci na zdefiniowanie konkretnych podsieci.</li>
</ol>
</p>

<p>Spacje są ignorowane.</p>';
$string['response'] = 'Odpowiedź';
$string['responses'] = 'Udzielone odpowiedzi';
$string['results'] = 'Wyniki';
$string['returnattempt'] = 'Powrót do podejścia';
$string['reuseifpossible'] = 'ponownie użyj poprzednio skasowane';
$string['reverttodefaults'] = 'Przywróć domyślne ustawienia testu';
$string['review'] = 'Przegląd';
$string['reviewafter'] = 'Pozwól przeglądać po zamknięciu testu';
$string['reviewalways'] = 'Pozwól przeglądać w dowolnym momencie';
$string['reviewattempt'] = 'Przegląd podejścia';
$string['reviewbefore'] = 'Pozwól przeglądać, gdy test jest otwarty';
$string['reviewclosed'] = 'Po zamknięciu testu';
$string['reviewduring'] = 'Podczas próby';
$string['reviewimmediately'] = 'Natychmiast po próbie';
$string['reviewnever'] = 'Nigdy nie pozwalaj przeglądać';
$string['reviewofquestion'] = 'Przegląd pytania  {$a->question} w teście {$a->quiz}, użytkownika  {$a->user}';
$string['reviewopen'] = 'Później, gdy test jest wciąż otwarty';
$string['reviewoptions'] = 'Student może przeglądać';
$string['reviewoptionsheading'] = 'Opcje przeglądu';
$string['reviewoptionsheading_help'] = 'Opcje te decydują, jaką informację i kiedy mogą zobaczyć studenci, gdy przeglądają podejścia do testu lub raporty testu.

"Natychmiast po próbie" oznacza w ciągu dwóch minut po zakończeniu.

"Później, gdy test jest wciąż otwarty" oznacza po dwóch minutach, a przed datą zamknięcia testu.

"Po zamknięciu testu" oznacza czas, gdy data zamknięcia testu minęła. Jeżeli test nie ma daty zamknięcia, ten stan nie zostanie nigdy osiągnięty.';
$string['reviewoverallfeedback'] = 'Całościowa inf. zwrotna';
$string['reviewoverallfeedback_help'] = 'Informacja zwrotna wyświetlana na końcu podejścia, w zależności od osiągniętej oceny';
$string['reviewresponse'] = 'Przejrzyj odpowiedź';
$string['reviewresponsetoq'] = 'Przejrzyj odpowiedź (pytanie {$a})';
$string['reviewthisattempt'] = 'Przejrzyj Twoje odpowiedzi w tym podejściu';
$string['rqp'] = 'Zdalne pytanie';
$string['rqps'] = 'Zdalne pytania';
$string['sameasoverall'] = 'Takie same jak dla ocen całościowych';
$string['save'] = 'Zapisz';
$string['saveandedit'] = 'Zapisz zmiany i edytuj pytania';
$string['saveattemptfailed'] = 'Nie udało się zapisać bieżącej próby rozwiązania testu';
$string['savedfromdeletedcourse'] = 'Zachowany z usuniętego kursu "{$a}"';
$string['savegrades'] = 'Zapisz oceny';
$string['savemanualgradingfailed'] = 'Modyfikacja nie została zapisana. Sprawdź poniższą wiadomość i spróbuj ponownie.';
$string['savemyanswers'] = 'Zapisz moje odpowiedzi';
$string['savenosubmit'] = 'Zapisz bez wysyłania rozwiązania';
$string['saveoverrideandstay'] = 'Zapisz i wprowadzaj następne zmiany';
$string['savequiz'] = 'Zapisz cały test';
$string['saving'] = 'Zapisywanie';
$string['savingnewgradeforquestion'] = 'Zapisywanie nowej oceny dla pytania o id {$a}.';
$string['savingnewmaximumgrade'] = 'Zapisywanie nowej maksymalnej oceny.';
$string['score'] = 'Wynik';
$string['scores'] = 'Punkty';
$string['search:activity'] = 'Test - informacje o aktywności';
$string['sectionheadingedit'] = 'Edytuj nagłówek \'{$a}\'';
$string['sectionheadingremove'] = 'Usuń nagłówek \'{$a}\'';
$string['sectionnoname'] = 'Sekcja bez tytułu';
$string['seequestions'] = '(Zobacz pytania)';
$string['select'] = 'Wybierz';
$string['selectall'] = 'Wybierz wszystkie';
$string['selectattempt'] = 'Wybierz podejście';
$string['selectcategory'] = 'Wybierz kategorię';
$string['selectedattempts'] = 'Wybrane podejścia...';
$string['selectmultipleitems'] = 'Zaznacz wiele pytań';
$string['selectnone'] = 'Odznacz wszystkie';
$string['selectquestionslot'] = 'Wybierz pytanie {$a}';
$string['selectquestiontype'] = '-- Wybierz typ pytania --';
$string['sendnotificationopendatesoon'] = 'Powiadom użytkownika o zbliżającej się dacie otwarcia testu';
$string['serveradded'] = 'Dodaj serwer';
$string['serveridentifier'] = 'Identyfikator';
$string['serverinfo'] = 'Informacje serwera';
$string['servers'] = 'Serwery';
$string['serverurl'] = 'Adres URL serwera';
$string['shortanswer'] = 'Krótka odpowiedź';
$string['show'] = 'Pokaż';
$string['showall'] = 'Pokaż wszystkie pytania na stronie';
$string['showblocks'] = 'Pokaż bloki kursu podczas rozwiązywania testu';
$string['showblocks_help'] = 'Jeśli aktywne, normalne bloki będą wyświetlane podczas rozwiązywania testu';
$string['showbreaks'] = 'Pokaż granice strony';
$string['showcategorycontents'] = 'Pokaż zawartość kategorii {$a->arrow}';
$string['showcorrectanswer'] = 'Czy informacja zwrotna ma zawierać poprawne odpowiedzi?';
$string['showdetailedmarks'] = 'Pokaż szczegóły';
$string['showeachpage'] = 'Pokaż jedną stronę na raz';
$string['showfeedback'] = 'Wyświetlić informację zwrotną po udzieleniu odpowiedzi?';
$string['showinsecurepopup'] = 'Pokaż test w \'bezpiecznym\' oknie';
$string['showlargeimage'] = 'Duże zdjęcie';
$string['shownoattempts'] = 'Pokaż studentów, którzy nie podeszli do testu';
$string['shownoattemptsonly'] = 'Pokaż tylko tych studentów, którzy nie podeszli do testu';
$string['shownoimage'] = 'Bez zdjęcia';
$string['showreport'] = 'Pokaż raport';
$string['showsmallimage'] = 'Małe zdjęcie';
$string['showteacherattempts'] = 'Pokaż próby nauczyciela';
$string['showuserpicture'] = 'Pokaż zdjęcie użytkownika';
$string['showuserpicture_help'] = 'Jeśli opcja jest włączona, nazwisko i zdjęcie studenta pojawi się na ekranie w czasie rozwiązywania testu, dzięki czemu łatwiej będzie sprawdzić tożsamość  studenta.';
$string['shuffle'] = 'Zmień kolejność';
$string['shuffleanswers'] = 'Zmień kolejność odpowiedzi';
$string['shuffledrandomly'] = 'Ułóż losowo';
$string['shufflequestions'] = 'Losowa kolejność pytań';
$string['shufflewithin'] = 'Mieszaj odpowiedzi';
$string['shufflewithin_help'] = 'Jeśli opcja jest włączona, możliwe odpowiedzi do każdego pytania będą losowo wymieszane, o ile opcja ta jest także włączona w ustawieniach samego pytania. To ustawienie ma zastosowanie tylko do pytań, które mają wiele wariantów odpowiedzi, takich jak wielokrotny wybór lub dopasowanie.';
$string['singleanswer'] = 'Wybierz odpowiedź';
$string['sortage'] = 'Sortuj wg wieku';
$string['sortalpha'] = 'Sortuj wg nazwy';
$string['sortquestionsbyx'] = 'Sortuj pytania wg: {$a}';
$string['sortsubmit'] = 'Sortuj pytania';
$string['sorttypealpha'] = 'Sortuj wg typu, nazwy';
$string['specificapathnotonquestion'] = 'Tej ścieżki do pliku nie ma w tym pytaniu';
$string['specificquestionnotonquiz'] = 'Tego pytania nie ma w tym teście.';
$string['startagain'] = 'Zacznij od nowa';
$string['startattempt'] = 'Rozpocznij podejście';
$string['startedon'] = 'Rozpoczęto';
$string['startnewpreview'] = 'Rozpocznij nowy podgląd';
$string['stateabandoned'] = 'Nigdy nie złożone';
$string['statefinished'] = 'Ukończone';
$string['statefinisheddetails'] = 'Złożony {$a}';
$string['stateinprogress'] = 'W toku';
$string['statenotloaded'] = 'Stan pytania {$a} nie został załadowany z bazy danych';
$string['stateoverdue'] = 'Zaległe';
$string['stateoverduedetails'] = 'Musi być przesłane przez {$a}';
$string['status'] = 'Stan';
$string['stoponerror'] = 'Zatrzymaj na błędzie';
$string['submission_confirmation'] = 'Czy przesłać wszystkie odpowiedzi i zakończyć?';
$string['submission_confirmation_unanswered'] = 'Pytania bez odpowiedzi: {$a}';
$string['submitallandfinish'] = 'Zatwierdź wszystkie i zakończ';
$string['subneterror'] = 'Możesz podejść do testu tylko z pewnych miejsc. Obecnie twój komputer nie znajduje się w takim miejscu.';
$string['subnetnotice'] = 'Możesz podejść do testu tylko z pewnych miejsc. Obecnie twój komputer znajduje się w takim miejscu. Jako nauczyciel, możesz jednak dokonać podglądu testu.';
$string['subplugintype_quiz'] = 'Raport';
$string['subplugintype_quiz_plural'] = 'Raporty';
$string['subplugintype_quizaccess'] = 'Reguła dostępu';
$string['subplugintype_quizaccess_plural'] = 'Reguły dostępu';
$string['substitutedby'] = 'zastanie zastąpiony przez';
$string['summaryofattempt'] = 'Podsumowanie podejścia';
$string['summaryofattempts'] = 'Twoje odpowiedzi';
$string['temporaryblocked'] = 'Tymczasowo nie możesz ponownie rozwiązać testu. Będziesz miał taka możliwość za:';
$string['theattempt'] = 'Próba';
$string['theattempt_help'] = 'W tym ustawieniu można zadecydować o tym czy uczestnik może mieć wgląd w swoje próby podejścia do testu.';
$string['time'] = 'Czas';
$string['timecompleted'] = 'Zakończono';
$string['timedelay'] = 'Nie możesz rozpocząć testu, gdyż nie upłynął ustalony czas pomiędzy kolejnymi podejściami do testu';
$string['timeleft'] = 'Pozostały czas';
$string['timelimit'] = 'Limit czasu';
$string['timelimit_help'] = '<p align="center"><strong>Ograniczenie czasowe</strong></p>

<p>Domyślnie testy nie mają ograniczenia czasowego. Student więc ma tyle czasu ile mu potrzeba na rozwiązanie testu.

<p>Jeśli ustalisz ograniczenie czasowe, Moodle robi kilka rzeczy aby
zapewnić jego przestrzeganie:</p>

<ul>
  <li>Wymagana jest obsługa JS w przeglądarce - dzięki temu działa stoper.</li>
  <li>Na stronie pokazuje się stoper odliczający czas.</li>
  <li>Gdy czas dobiegnie końca, test jest automatycznie wysyłany z takimi odpowiedziami, jakich udzielił do tej pory student.</li>
  <li>Jeśli studentowi udało się oszukać i poświęcił na test więcej niż 60 sekund ponad limit, otrzyma ocenę równą 0.</li>
</ul>';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Upłynął limit czasu!';
$string['timestr'] = '%H:%M:%S na %d/%m/%y';
$string['timesup'] = 'Czas minął!';
$string['timetaken'] = 'Wykorzystany czas';
$string['timing'] = 'Czas';
$string['tofile'] = 'do pliku';
$string['tolerance'] = 'Tolerancja';
$string['toomanyrandom'] = 'Liczba potrzebnych pytań wybieranych losowo jest większa od liczby pytań w tej kategorii! ({$a})';
$string['top'] = 'Góra';
$string['totalmarks'] = 'Suma punktów';
$string['totalmarksx'] = 'Łączna punktacja: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Łącznie {$a} pytań w kategorii.';
$string['true'] = 'Prawda';
$string['truefalse'] = 'Prawda/fałsz';
$string['type'] = 'Typ';
$string['unfinished'] = 'otwórz';
$string['ungraded'] = 'Nie ocenione';
$string['unit'] = 'Jednostka';
$string['unknowntype'] = 'Nie można odnaleźć tego typu pytania w linii {$a}. Pytanie zostanie zignorowane.';
$string['updatesettings'] = 'Aktualizuj ustawienia testu';
$string['updatingatttemptgrades'] = 'Uaktualnienie ocen podejść';
$string['updatingfinalgrades'] = 'Uaktualnienie ocen końcowych';
$string['updatingthegradebook'] = 'Uaktualnienie dziennika ocen';
$string['upgradesure'] = '<div style="color: red;">Moduł quiz przeszedł szereg zmian. Uaktualnienie testów nie zostało jeszcze dostatecznie sprawdzone. Dla bezpieczeństwa zalecamy zrobienie kopii zapasowych tabel z testami przed przystąpieniem do uaktualnienia.</div>';
$string['upgradingquizattempts'] = 'Uaktualniam podejścia do testu {$a->done}/{$a->outof} (ID testu {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Uaktualniam bardzo stare podejścia do testu {$a->done}/{$a->outof} (ID testu {$a->info})';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Kategoria zostanie zachowana i przesunięta, ponieważ jej pytania są używane w innych kursach.';
$string['useroverrides'] = 'Wyjątki dla użytkownika';
$string['useroverridesdeleted'] = 'Usunięto wyjątki dla użytkownika';
$string['usersnone'] = 'Studenci nie mają dostępu do tego testu';
$string['validate'] = 'Sprawdź';
$string['viewallanswers'] = 'Przeglądaj {$a} podejścia do testów';
$string['viewallreports'] = 'Obejrzyj raporty dla {$a} podejść';
$string['viewed'] = 'Wyświetlony';
$string['warningmissingtype'] = '<b>To pytanie jest typu, które nie zostało jeszcze zainstalowane na platformie Moodle.<br />Poinformuj o tym administratora platformy Moodle.</b>';
$string['wheregrade'] = 'Gdzie jest moja ocena?';
$string['wildcard'] = 'Symbol specjalny';
$string['windowclosing'] = 'To okno zostanie niedługo zamknięte';
$string['withsummary'] = 'wraz z ogólną statystyką';
$string['wronguse'] = 'Nie można wyświetlić strony';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Aby móc rozwiązywać ten test, musisz najpierw zapisać się do tego kursu.';
$string['yourfinalgradeis'] = 'Twoja końcowa ocena za ten test wynosi {$a}';
