<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_certification', language 'ja', version '4.5'.
 *
 * @package     tool_certification
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'アクション';
$string['actions'] = 'アクション';
$string['active'] = 'アクティブ';
$string['activecertifications'] = 'アクティブな認定';
$string['afteractualcertcompletion'] = '現在の認定完了以降';
$string['afteractualcertcompletionwithrelativedate'] = '現在の認定完了以降の{$a}';
$string['afterallocationdate'] = '割り当て日以後';
$string['afterallocationdatewithrelativedate'] = '割り当て日以後の{$a}';
$string['aftercompletion'] = '完了以後';
$string['aftercompletionwithrelativedate'] = '{$a} 完了後';
$string['afterduedate'] = '終了日以後';
$string['afterduedatewithrelativedate'] = '終了日以後の{$a}';
$string['afterlatest'] = '現在の完了後または期限切れ後';
$string['afterlatestwithrelativedate'] = '現在の完了後または期限切れ後の{$a}';
$string['afterpreviouscertexpdate'] = '前回の認定有効期限日以降';
$string['afterpreviouscertexpdatewithrelativedate'] = '前回の認定有効期限日以降の{$a}';
$string['afterstartdate'] = '開始日以降';
$string['afterstartdatewithrelativedate'] = '開始日以降の{$a}';
$string['allocatetocertification'] = '認定に割り当てる';
$string['allocatetocertifications'] = '認定資格に割り当てる…';
$string['allocateusers'] = 'ユーザを割り当てる';
$string['allocateuserstocertification'] = 'ユーザを認定に割り当てる…';
$string['allocationdate'] = '割り当て日';
$string['allocationdateisonorafter'] = '割り当て日が次の日以降';
$string['allocationdefaultvalue'] = '認定資格で定義されたものと同じ（デフォルト）';
$string['allocationenddate'] = '割り当て遮断日';
$string['allocationfor'] = '\'{$a}\' に割り当て';
$string['allocationsource'] = '割り当てソース';
$string['allocationstartdate'] = '割り当て開始日';
$string['allocationwindowenddate'] = '遮断日';
$string['allocationwindowenddate_help'] = '割り当てウィンドウの遮断日';
$string['allocationwindowendedon'] = 'この認定の割り当て期間は{$ a}で終了しました。';
$string['allocationwindowstartdate'] = '開始日';
$string['allocationwindowstartdate_help'] = '割り当てウィンドウの開始日';
$string['allocationwindowstartson'] = 'この認定の割り当てウィンドウは {$a} から始まります。';
$string['archive'] = 'アーカイブ';
$string['archived'] = 'アーカイブ済み';
$string['archivedcertifications'] = 'アーカイブ済みの認定';
$string['archivedconfirmation'] = '本当に認定 \'{$a}\' をアーカイブしますか？アーカイブされた認定は学習者とマネージャーが利用できなくなり、過去のレポートのみ閲覧できるようになります。';
$string['archivedon'] = 'アーカイブされた日';
$string['autocreategroups'] = 'コースグループに追加する';
$string['autocreategroups_help'] = 'ユーザがプログラムコースに登録すると、自動的に同じグループに追加されます。認定が選択されていると、認定用の新しいグループが作られ、同じプログラムの異なる認定に追加されます。';
$string['autocreategroupsasinprogram'] = 'プログラムで定義';
$string['autocreategroupscertification'] = 'この認定のグループを作成する';
$string['becamecertified'] = '認定された({$a})';
$string['beforepreviouscertexpdate'] = '前回の認定有効期限日前';
$string['calendarduedate'] = '認定 {$a} の修了日';
$string['calendarexpirydate'] = '認定 {$a} の有効期限';
$string['certification'] = '認定';
$string['certification:allocateuser'] = 'ユーザ割り当てのパーミッション';
$string['certification:configurecustomfields'] = '認定カスタムフィールドの設定';
$string['certification:edit'] = '編集のパーミッション';
$string['certificationdates'] = '日付';
$string['certificationdates_help'] = 'この認定資格の割り当てに適用する日付を選択してください：

- **認定資格で定義されたものと同じ:** 認定資格内で定義された日付を使用します。
- **日付を選択:** この認定資格の割り当てに対して、開始日や期限を個別に設定できます。';
$string['certificationfullname'] = '認定の名前';
$string['certificationfullname_help'] = '認定の名前';
$string['certificationidnumber'] = '認定のIDナンバー';
$string['certificationidnumber_help'] = '認定IDナンバーは、認定を外部システムと照合するときにのみ使われ、サイトのどこにも表示されません。
  入力されない限り認定が正式なコード名を記載していることはなく、通常は空白のままになります。';
$string['certificationname'] = '認定の名前';
$string['certificationnamewitheditlink'] = '編集リンク付きの認定資格名';
$string['certificationprogress'] = '認定の進捗';
$string['certificationprogressexport'] = '{$a}  認証の進捗状況';
$string['certificationrules'] = '認定の規定';
$string['certifications'] = '認定';
$string['certificationscustomfield'] = '認定カスタムフィールド';
$string['certificationslink'] = '<a href="{$a->href}">{$a->count} 認定証</a>';
$string['certificationslink_plural'] = '<a href="{$a->href}">{$a->count} 認定証</a>';
$string['certificationstatus'] = '認定ステータス';
$string['certificationstatus_help'] = '現在の認定ステータス';
$string['certificationtags'] = '認定のタグ';
$string['certificationtags_help'] = 'この認定のタグ';
$string['certificationtenant'] = '認定のテナント';
$string['certificationuserlog'] = '{$a} のアクティビティログ';
$string['certificationuserlogempty'] = 'このユーザ認定のイベントログはありません';
$string['certificationuserlogfilename'] = '{$a->user} のアクティビティログ {$a->certification}';
$string['certified'] = '認証済み';
$string['certifiedandrevoked'] = '認定および取り消し';
$string['certifiedby'] = '認定された';
$string['certifiedcertificationslink'] = '<a href="{$a->href}">{$a->count}件の認証された認定</a>';
$string['certifieddate'] = '認定日';
$string['certifieddateisonorafter'] = '認定日が次の日以降';
$string['certifiednotification'] = 'ユーザは正常に認定されました';
$string['certifiedtype'] = '認定タイプ';
$string['certify'] = '認定する';
$string['certifycertifieddate'] = '認定日';
$string['certifycertifieddate_help'] = 'このユーザの認定日を、「今すぐ」（ユーザはすぐに認定されます）または過去のカスタム日付を選択します。';
$string['certifyexpirydate'] = '有効期間';
$string['certifyexpirydate_help'] = 'この認定ユーザの有効期限を「デフォルト」、「なし」、「日付をカスタム」の中から選んでください。(デフォルトは現在の設定を表示する）';
$string['certifyuser'] = 'ユーザを認定';
$string['completedtheprogram'] = 'プログラム {$a} を完了しました';
$string['conditioncertificationcertified'] = '認定が認められました';
$string['conditioncertificationcertifieddescription'] = '認定 \'{$a->fullname}\' で認定されたユーザ';
$string['conditioncertificationcertifieddescriptionall'] = '以下すべての認定 \'{$a->fullname}\' で認定されたユーザ';
$string['conditioncertificationcertifieddescriptionallwithdate'] = '以下すべての認定を持つユーザ \'{$a->fullname}\'<br /> 認定日が \'{$a->conditiondate}\' 以降である。';
$string['conditioncertificationcertifieddescriptionany'] = '以下から最低でもひとつの認定を持つユーザ  \'{$a->fullname}\'';
$string['conditioncertificationcertifieddescriptionanywithdate'] = '以下から最低でもひとつの認定を持つユーザ  \'{$a->fullname}\'<br /> 認定日が \'{$a->conditiondate}\' 以降である。';
$string['conditioncertificationcertifieddescriptiononrecert'] = '再認定ごとに実行';
$string['conditioncertificationcertifieddescriptionstatusonly'] = 'ステータスが変更された場合のみ実行';
$string['conditioncertificationcertifieddescriptionwithdate'] = '認定証 \'{$a->fullname}\' を取得しているユーザ<br />
認定資格の日付が \'{$a->conditiondate}\' 以降';
$string['conditioncertificationcertifiedonrecert'] = 'すべての再認定時に常にアクションを実行';
$string['conditioncertificationcertifiedonrecert_help'] = 'これにより、条件が<b>「ユーザが認定されており、再認定期間は開始されていない」</b>に変更されます。
その結果、再認定期間が始まるとユーザは「不一致」とマークされ、たとえ常に認定された状態でも、プログラム完了時に再度アクションが実行されるようになります。';
$string['conditioncertificationcertifiedstatusonly'] = 'ユーザステータスが「未認定」から「認定済み」に変更された場合のみアクションを実行';
$string['conditioncertificationcertifiedstatusonly_help'] = 'この場合、前回の認定資格の有効期限が切れているかどうかによって、再認定時にアクションが実行される場合とされない場合があります。
再認定時にアクションが<b>決して</b>実行されないようにするには、ルール設定で「ルールアクションの制限」を設定することを検討してください。';
$string['conditioncertificationexpired'] = '認定の有効期限';
$string['conditioncertificationexpireddescription'] = '認定 \'{$a}\' が期限切れのユーザ';
$string['conditioncertificationexpireddescriptionwithdate'] = '認定 \'{$a->fullname}\' の有効期限が切れたユーザ <br />
有効期限の日付が \'{$a->conditiondate}\' 以降';
$string['conditioncertificationnotcertified'] = '認定されていない認定';
$string['conditioncertificationnotcertifieddescription'] = '認定 \'{$a}\' を取得していないユーザ';
$string['conditioncertificationoverdue'] = '認定の期限切れ';
$string['conditioncertificationoverduedescription'] = '認定 \'{$a}\' で期限切れのユーザ';
$string['conditioncertificationoverduedescriptionwithdate'] = '認定 \'{$a->fullname}\' の期限が過ぎているユーザ<br />
期限日が \'{$a->conditiondate}\' 以降';
$string['conditioncertificationsuspended'] = '一時停止の認定';
$string['conditioncertificationsuspendeddescription'] = '認定 \'{$a}\' で一時停止中のユーザ';
$string['conditioncertificationsuspendeddescriptionwithdate'] = '認定 \'{$a->fullname}\' が停止されているユーザ<br />
停止日が \'{$a->conditiondate}\' 以降';
$string['conditionrecertificationgraceperiod'] = '再認定の猶予期間終了';
$string['conditionrecertificationgraceperiodendsdescription'] = '認定 \'{$a->fullname}\' の猶予期間が終了するユーザ';
$string['conditionrecertificationgraceperiodendsdescriptionwithdate'] = '認定 \'{$a->fullname}\' で猶予期間が終了するユーザ<br />
再認定の猶予期間は \'{$a->conditiondate}\' 以前に終了します';
$string['conditionrecertificationstarted'] = '再認定の猶予期間開始';
$string['conditionrecertificationstarteddescription'] = '認定 \'{$a->fullname}\' の再認定期間が始まったユーザ';
$string['conditionrecertificationstarteddescriptionwithdate'] = '認定 \'{$a->fullname}\' の再認定期間が始まったユーザ<br />
再認定開始日が \'{$a->conditiondate}\' 以降';
$string['conditionuserallocated'] = '認定に割り当てられたユーザ';
$string['conditionuserallocateddescription'] = '認定 \'{$a}\' に割り当てられているユーザ';
$string['conditionuserallocateddescriptionwithdate'] = '認定 \'{$a->fullname}\' に割り当てられているユーザ<br />
割り当て日が \'{$a->conditiondate}\' 以降';
$string['conditionusernotallocated'] = '認定に割り当てられていないユーザ';
$string['conditionusernotallocateddescription'] = '認定 \'{$a}\' に割り当てられていないユーザ';
$string['confirmdeallocateusers'] = 'このアクションにより、選択したすべてのユーザの割り当てと関連データが完全に削除されます。このアクションは元に戻せません。';
$string['confirmdeallocateusersheader'] = 'ユーザの割り当て解除';
$string['confirmdeletecertification'] = '本当に認定 \'{$a}\' と関連するデータを消去しますか？この操作は元に戻せません。';
$string['confirmdeleteuserallocation'] = '本当にユーザ \'{$a}\' の割り当てと関連するデータを完全に消去しますか？この操作は元に戻せません。';
$string['confirmduplicate'] = '認定の設定が複製され、あなたはプログラムなどのプロパティを変更することができます。ユーザ割り当てが複製先に持ち越されることはありません。';
$string['content'] = 'コンテンツ';
$string['criteriaall'] = '選択されたすべての認定が完了しました';
$string['criteriaany'] = '選択された認定のうち、少なくとも1つが完了しています';
$string['criteriaany_help'] = 'ユーザがすでにいずれかの認定を取得している場合、別の認定を取得してもアクションは再実行されません。';
$string['criteriaeach'] = 'ユーザが選択された認定のいずれかを取得するたびに';
$string['criteriaeach_help'] = '選択された各認定ごとに、個別のルールを作成するのと同様です。';
$string['currentcertification'] = '現在の認定';
$string['currentprogram'] = '現在のプログラム';
$string['currentprogram_help'] = 'このユーザが受講している現在のプログラム';
$string['currentprogramprogress'] = '現在のプログラム進捗状況';
$string['currentprogramstatus'] = '現在のプログラムステータス';
$string['dateoverrided'] = '上書きされた日';
$string['dayssinceallocation'] = '割り当てからの期間';
$string['daystakingcertification'] = '認定にかかる期間';
$string['deallocateusers'] = 'ユーザ割り当てを解除する';
$string['default'] = 'デフォルト';
$string['deleteallocation'] = '割り当ての削除';
$string['deleteuserallocation'] = 'ユーザ割り当てを削除';
$string['displaycertificationdate'] = '認定日';
$string['displaycertificationduedate'] = '認定の終了日';
$string['displaycertificationid'] = 'URLに使われている内部の認定ID';
$string['displaycertificationname'] = '認定の名前';
$string['displaycertificationprogramname'] = 'この認定の最初のプログラム名';
$string['displaycertificationreopen'] = '再認定開始日';
$string['displayexpirydate'] = '認定の有効期限日';
$string['displayexpirydatetimestamp'] = '認定の有効期限のタイムスタンプ';
$string['displaygraceperiodend'] = '猶予期間終了日';
$string['displayrecertificationprogramname'] = '再認定プログラム名';
$string['dontchange'] = '変更しないでください';
$string['duedate'] = '終了日';
$string['duedate_help'] = '認定の終了日';
$string['duedateisonorafter'] = '終了日以降';
$string['duplicate'] = '複製';
$string['dynamic'] = 'ダイナミック';
$string['dynamicrules'] = 'ダイナミックルール';
$string['dynamicrulesplugincheck'] = 'tool_dynamicrulesのプラグインなしにダイナミックルールの一覧を表示することはできません。';
$string['dynamicrulewarningdeallocation'] = 'ユーザの割り当て解除は、別のダイナミックルールによって割り当てられた場合にのみ可能です。手動での割り当てには影響しません。';
$string['editallocation'] = '割り当ての編集';
$string['editcertificationname'] = '認定名の編集';
$string['editstatusanddates'] = 'ステータスと日付を編集する';
$string['editstatusanddatesbulk'] = '複数のユーザのステータスと日付を編集する';
$string['enddate'] = '遮断日';
$string['entitycertification'] = '認定';
$string['entitycertificationusers'] = '認定ユーザの割り当てと完了';
$string['errorallocatinguserintorelatedprogram'] = 'ユーザを関連したプログラムに割り当てできません';
$string['errorallocationsourcenotfound'] = '割り当てソース不明';
$string['erroralreadycertified'] = 'ユーザは開始日にすでにこの認定を取得しています。';
$string['errorcannotallocate'] = 'ユーザを認証に割り当てることができません（割り当てはすでに存在するか、許可されていません）';
$string['errorcantdeletecertification'] = '認定を削除できません';
$string['errorcantdeletenotarchivedcertification'] = 'アーカイブされていない認定は削除できません';
$string['errorcantmanageusers'] = 'ユーザを管理できません';
$string['errorcantrestorecertification'] = '認定をリストアできません';
$string['errorcertificationdateinfuture'] = '認定日は過去の日付でなければなりません。';
$string['errorcertificationsdontexist'] = '一部の認定は存在しません';
$string['errorcouldnotallocate'] = 'ユーザ \'{$a->originaluserfullname}\' を認定 \'{$a->certification}\' に割り当てることができませんでした。';
$string['errorevaluatinguserallocationstatus'] = 'ユーザ割り当てステータスの評価エラー';
$string['errorexpirydatepreviouscertifieddate'] = '有効期限は認定日より前になっていはいけません。';
$string['errorexpirydatepreviousduedate'] = '有効期限を終了日より前に設定できません';
$string['erroridnumberuniquetenant'] = 'このIDは他の認定で既に使用されています。';
$string['errorinvalidcertification'] = '無効な認定';
$string['errorinvaliddate'] = '無効な日付';
$string['errorinvalidpastduedate'] = '期限日は開始日より前に設定できません。';
$string['errorinvalidpastexpirydate'] = '有効期限を過去の日時に設定することはできません。';
$string['errorinvalidpaststartdate'] = '開始日を過去の日時に設定することはできません。';
$string['errorinvalidtimecertified'] = '認定日時を未来の日時に設定することはできません。';
$string['errormissingassociatedprogram'] = '関連したプログラムがありません';
$string['errormissingexpirydate'] = '有効期限が切れています。';
$string['errornopermissionallocateusers'] = 'ユーザを認定に割り当てる権限がありません';
$string['errornopermissioncertifyuser'] = 'このユーザは、すでに認定済みであるか、この操作を実行する権限がないため、認定済みとしてマークできません。';
$string['errornopermissionmanagecertifications'] = '認定を管理するパーミッションがありません';
$string['errornopermissionviewallocatedusers'] = '割り当てられたユーザを認証で表示する権限がありません';
$string['errornopermissionviewreports'] = 'レポートを閲覧するパーミッションがありません';
$string['errornothingtoexportforcertifications'] = '共有認証のためにエクスポートするものはありません: {$a}';
$string['errorrecertificationprogram'] = 'このプログラムは最初のプログラムとは別のものでなければいけません';
$string['errorreporttypedoesnotexist'] = 'レポートタイプが存在しません';
$string['errorsameidnumber'] = '同じID番号の認証がすでに存在します';
$string['erroruseralreadyallocatedincertification'] = '既に認定に割り当てられたユーザ';
$string['erroruseralreadyallocatedinprogram'] = '既にプログラムに割り当てられたユーザ';
$string['errorusernotinsametenant'] = '同じテナントではないユーザ';
$string['eventcertificationcompleted'] = '認定完了';
$string['eventcertificationcreated'] = '認定作成';
$string['eventcertificationdeleted'] = '認定の消去';
$string['eventcertificationupdated'] = '認定の更新';
$string['eventrecertificationgraceperiodended'] = '再認定の猶予期間終了済';
$string['eventrecertificationstarted'] = '再認定開始';
$string['eventuserallocated'] = '認定に割り当てられた';
$string['eventuserdeallocated'] = '割り当てを解除されたユーザ';
$string['eventuserupdated'] = 'ユーザ割り当てを更新';
$string['expired'] = '有効期限切れ';
$string['expiredcertificationslink'] = '<a href="{$a->href}">{$a->count}件の有効期限が切れた認定</a>';
$string['expireddateisonorafter'] = '有効期限切れ以降';
$string['expireson'] = '{$a} に期限が切れます';
$string['expirydate'] = '有効期限';
$string['expirydate_help'] = '認定の有効期限';
$string['export_content'] = '設定';
$string['export_content_help'] = '認定、名前、説明、日付、タグなど';
$string['export_dynamic_rules'] = 'ダイナミックルール';
$string['export_dynamic_rules_help'] = 'これらの認定のすべてのダイナミックルール構成';
$string['export_programs'] = '関連プログラム';
$string['export_programs_help'] = 'プログラム、名前、説明、日付、タグなど';
$string['export_user_allocations'] = '認定ユーザの割り当て';
$string['export_user_allocations_help'] = 'これらの認定へのユーザ割り当ては含まれません。ユーザ自身のコピーは含まれません。';
$string['exportcertificationsdescription'] = '関連するプログラム、コース、ユーザ割り当ておよびダイナミックルール要素を含む認定';
$string['exportonlyallocationspostfix'] = '（ユーザの割り当てのみ）';
$string['fullcertificationreport'] = 'すべての認定レポート';
$string['futureallocation'] = '未来の割り当て';
$string['gotocertification'] = '認定に移動';
$string['historicalcertificationcompletion'] = '認定ユーザの履歴完了状況';
$string['historicalstatus'] = 'ステータス履歴';
$string['idnumber'] = 'IDナンバー';
$string['import_content'] = '設定';
$string['import_content_help'] = '認定証、名称、説明、日付、タグなど。';
$string['import_dynamic_rules'] = 'ダイナミックルール';
$string['import_dynamic_rules_help'] = 'これらのプログラムのすべてのダイナミックルール';
$string['import_programs'] = '関連プログラム';
$string['import_programs_help'] = 'プログラム、名前、説明、日付、タグなど。';
$string['import_user_allocations'] = '認定ユーザの割り当て';
$string['import_user_allocations_help'] = 'これらの認定へのユーザ割り当てが含まれます。';
$string['importcannotallocate'] = 'ユーザ \'{$a->originaluserfullname}\' を認定証 \'{$a->certification}\' に割り当てることができません。割り当てはすでに存在するか、許可されていません';
$string['importlogfailed'] = '認定証 \'{$a->fullname}\' をインポートできませんでした';
$string['importlogidnumberexists'] = 'ID番号 \'{$a->originalidnumber}\' の認定証はすでに存在します';
$string['importlogsuccess'] = '新規認証の作成 \'<a href="{$a->url}">{$a->fullname}</a>\'';
$string['importlogsuccessuserallocations'] = 'ユーザ \'{$a->userfullname}\' を認定証 \'{$a->certification}\' に割り当てました';
$string['include_shared_entities'] = '共有エンティティを含める';
$string['include_shared_entities_help'] = 'このオプションを有効にすると、エクスポートされたファイルにも含まれます:

* 現在のテナントで利用可能なすべての共有認定
* 選択した認定資格にリンクされているすべての共有プログラム
* 現在のテナントコースカテゴリ以外のすべてのプログラムコース';
$string['isrecertification'] = '再認定';
$string['keepcertificationdefaults'] = '認定をデフォルトのままにする';
$string['lastallocationdate'] = '最終割り当て日：{$a}';
$string['lessthanaday'] = '1日以内';
$string['managedusersoverdue'] = 'いくつかのチームメンバーは認定の期限が切れています。';
$string['manageprograms'] = 'プログラムを管理する';
$string['manual'] = '手動';
$string['manuallycertifieduser'] = '手動認定 {$a->usertarget} ({$a->expirydate})';
$string['mappingerrorcertificationnotfound'] = '認定 {$a} が見つかりません';
$string['mappingnoticenoidnumber'] = 'ID番号が空だったため、認定は名前で検索されました。認定にID番号を割り当てることをお勧めします';
$string['markcertificationcompletednotice'] = 'プログラムの完了を待たずに認定を完了としてマークする';
$string['messageprovider:certificationcompleted'] = '認定完了';
$string['messageprovider:certificationuserallocated'] = '認定に割り当てられたユーザ';
$string['messageprovider:certificationuserdeallocated'] = '認定から割り当て解除されたユーザ';
$string['missingcertification'] = '認定がありません';
$string['missingfullname'] = '氏名がありません';
$string['missingprogram'] = 'プログラムがありません';
$string['never'] = 'なし';
$string['neverexpires'] = '有効期限なし';
$string['newcertification'] = '新しい認定';
$string['newvaluefor'] = '新しい値';
$string['notavailable'] = '利用不可';
$string['notificationcertification'] = 'このプログラムは、認定 \'{$a->certificationname}\' の一部です。<br /><br />';
$string['notificationcertificationcompletedexpiry'] = '{$a->expirymessage}：
{$a->reopendate} の後、プログラム \'{$a->recertificationprogram}\' を再受講して、認定を維持することができます。<br /><br />';
$string['notificationcertificationcompletedmanual'] = '{$a->userfullname} さん<br /><br />
\'{$a->certificationname}\' 認定取得おめでとうございます！<br /><br />
{$a->expirymessage}
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationcertificationcompletedprogram'] = '{$a->userfullname} さん、<br /><br />

プログラム \'{$a->programname}\' の完了、おめでとうございます！これで、\'{$a->certificationname}\' の認定を取得しました！<br /><br />

プログラム内のコースはいつでも再閲覧できます。プログラム全体は、「マイコース」ページで確認できます。<br /><br />

{$a->expirymessage}
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationcertificationdue'] = 'このプログラムは、{$a->duedate} に期限が切れる認定 \'{$a->certificationname}\' の一部です。<br /><br />';
$string['notificationcertificationuserallocated'] = '{$a->userfullname} さん、<br /><br />
プログラム \'{$a->programname}\' へようこそ！このプログラムは、「マイコース」ページで確認できます。<br /><br />
{$a->certmsg}<br /><br />
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationcertificationuserdeallocated'] = '{$a->userfullname} さん<br /><br />
プログラム \'{$a->programname}\' は終了し、アクセスできなくなりました。<br /><br />
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationcertificationwillexpireon'] = '認定は {$a} に期限切れになります。<br /><br />';
$string['notificationsubjectcertificationcompleted'] = '認定 \'{$a}\' が完了しました';
$string['notificationsubjectcertificationcompletedmanual'] = 'おめでとうございます - \'{$a}\' の認定を取得しました！';
$string['notificationsubjectcertificationuserallocated'] = '\'{$a}\' へようこそ';
$string['notificationsubjectcertificationuserdeallocated'] = '\'{$a}\' は閉じました';
$string['notset'] = '設定されていない';
$string['nousersselected'] = 'ユーザを1人以上選択してください';
$string['now'] = '現在';
$string['ongoingcertificationslink'] = '<a href="{$a->href}">{$a->count}件の進行中の認定</a>';
$string['open'] = '開く';
$string['outcomeallocation'] = 'ユーザを認定に割り当てる';
$string['outcomeallocationdescdate'] = 'ユーザを認定に割り当てる  {$a->certificationname}<br />
{$a->startdatestr}<br />
一時停止のユーザ: {$a->suspendedusers}';
$string['outcomeallocationdesckeepdate'] = '一時停止を解除し、既存の認定開始日のままにする';
$string['outcomeallocationdesckeepstartdate'] = '認定をデフォルトの開始日のままにする';
$string['outcomeallocationdescription'] = 'ユーザを認定 \'{$a}\' に割り当てる<br />
認定のデフォルトの開始日を維持';
$string['outcomeallocationdescstartdate'] = '認定の開始日 \'{$a->startdate}\'';
$string['outcomeallocationdescsuspendchangedate'] = '一時停止を解除し、認証開始日を変更する';
$string['outcomeallocationdontmodify'] = '割り当てを変更しない';
$string['outcomeallocationsuspendedusers'] = '一時停止したユーザ';
$string['outcomeallocationsuspendedusers_help'] = 'ユーザがすでに割り当てられているが、割り当てが中断または終了した場合に実行するアクション';
$string['outcomeallocationunsuspend'] = '一時停止を解除し、既存の認定開始日のままにする';
$string['outcomeallocationunsuspendchangedate'] = '一時停止を解除し、認定開始日を変更する';
$string['outcomedeallocate'] = 'ユーザを認定から割り当て解除する';
$string['outcomedeallocatesuspend'] = '既存の割り当てを一時停止する';
$string['outcomedeallocation'] = 'ユーザを認定から割り当て解除する';
$string['outcomedeallocationdescription'] = 'ユーザを認定 {$a} から割り当て解除する';
$string['outcomedeallocationdescriptionsuspend'] = '認定 \'{$a}\' からの既存のユーザ割り当てを一時停止する';
$string['overdue'] = '期限切れ';
$string['overduecertifications'] = '期限経過した認定';
$string['overduecertificationslink'] = '<a href="{$a->href}">{$a->count}件の締切を超過した認定</a>';
$string['overduex'] = '{$a} 期限超過';
$string['pluginname'] = '認定';
$string['previewcertificationname'] = '認定名のプレビュー';
$string['previouscertexpirydate'] = '以前の認定の有効期限';
$string['privacy:metadata:certification_completions'] = '認定の完了に関する情報';
$string['privacy:metadata:certification_completions:certificationid'] = 'ユーザが完了した認定';
$string['privacy:metadata:certification_completions:certifiedby'] = '認定を生成したユーザ';
$string['privacy:metadata:certification_completions:expirydate'] = 'この認定完了の有効期限';
$string['privacy:metadata:certification_completions:revokedby'] = '認定を取り消したユーザ';
$string['privacy:metadata:certification_completions:timecertified'] = 'ユーザが認定を完了した日時';
$string['privacy:metadata:certification_completions:timecreated'] = '完了記録の作成日時';
$string['privacy:metadata:certification_completions:timemodified'] = '認定完了の更新日時';
$string['privacy:metadata:certification_completions:userid'] = '認定を完了したユーザ';
$string['privacy:metadata:certification_users'] = 'ユーザの認定割り当てに関する情報';
$string['privacy:metadata:certification_users:certificationid'] = '認定は割り当てられています';
$string['privacy:metadata:certification_users:currentprogramid'] = '現在のプログラムユーザは割り当てられています';
$string['privacy:metadata:certification_users:isrecertification'] = 'ユーザが再認定中のとき';
$string['privacy:metadata:certification_users:status'] = 'ユーザが認定から一時停止されているかどうか。';
$string['privacy:metadata:certification_users:timemodified'] = 'ユーザ割り当ての更新日時';
$string['privacy:metadata:certification_users:userid'] = '割り当てられたユーザ';
$string['privacy:metadata:core_tag'] = '認定に追加されたタグ';
$string['program'] = 'プログラム';
$string['programchangewarning'] = '現在このプログラムを受講中のユーザは、自動的に再割り当てされません。必要に応じて、個別に手動で再割り当てを行うことができます。
すでにプログラムを完了したユーザや、手動で認定済みとマークされたユーザのステータスは変更されませんが、古いプログラムからは割り当て解除され、コース一覧ページには表示されなくなります。';
$string['programcourse'] = 'プログラムのコース';
$string['programuserallocation'] = 'プログラムユーザの割り当て';
$string['progress'] = '{$a} 完了';
$string['progressreport'] = '進捗レポート';
$string['recertdifferentprogram'] = '別のプログラムを選択する';
$string['recertdifferentprogram_help'] = '初期プログラムとして設定されているプログラムとは別のプログラムを再認定に選択する場合は、「Yes」を選択します。';
$string['recertduedaterelative'] = '終了日';
$string['recertduedaterelative_help'] = '再認定の終了日です。';
$string['recertexpirydate'] = '有効期限';
$string['recertexpirydate_help'] = 'これは、ユーザの再認定の有効期限が切れる日付です。<br />
「前回の認定有効期限日以降」が選択されている場合、この設定により、常に同じ日に有効期限が設定されます。ユーザが再認定を逃した場合、日付は自動的に調整されます。';
$string['recertexpirydatewarning'] = '最初の認定は有効期限なしに設定されています。再認定は、有効期限が個人的に設定されたユーザにのみ利用可能です。';
$string['recertgraceperiod'] = '猶予期間';
$string['recertgraceperiod_help'] = '猶予期間とは、前回の認定が失効した後、プログラムを終了して認定を受けるための追加の期間のことです。このオプションは、再認定プログラムが最初のプログラムと異なる場合にのみ利用可能です。';
$string['recertgraceperiodends'] = '猶予期間終了時間';
$string['recertification'] = '再認定';
$string['recertificationgraceperiodendsonorbefore'] = '再認定の猶予期間満了日';
$string['recertificationprogram'] = '再認定プログラム';
$string['recertificationprogram_help'] = '再認定に使用するプログラムを選択してください。このプログラムは最初の認定プログラムとは異なる必要があります。';
$string['recertificationstartdate'] = '再認定開始日';
$string['recertificationstartedonorafter'] = '再認定開始当日';
$string['recertstartdaterelative'] = '開始日';
$string['recertstartdaterelative_help'] = '再認定プログラムが利用できるようになる日です。';
$string['recertstartdatewarning'] = 'この日に再認定プログラムがリセットされます。ユーザが他の場所でプログラムのコースに登録していたり、同じプログラムに直接割り当てられたり、他の認定を経由して割り当てられたりしないように注意してください。進捗を失う可能性があります。';
$string['reg_wpcertifications'] = '認定数 ({$a})';
$string['requirerecertification'] = '再認定を求める';
$string['requirerecertification_help'] = 'この認定の再認定を可能にするには「Yes」を選択します。';
$string['resetadditionalcourses'] = '追加のコースをリセットする';
$string['resetadditionalcourses_help'] = '過去のプログラムになく、新しいプログラムにあるコースをリセットする';
$string['restore'] = 'リストア';
$string['revokecertification'] = '認定を取り消す';
$string['revoked'] = '取り消し済み';
$string['revokedby'] = '取り消し者';
$string['revokednotification'] = '認定は正常に取り消されました。';
$string['revokedon'] = '取り消し日';
$string['revokedthisuser'] = '{$a} の認定を取り消す';
$string['revokewarning'] = '本当に {$a} から認定を取り消しますか？完了時に与えられたバッジは取り消されません。';
$string['rolemanager'] = '認定マネージャー';
$string['rolemanagerdescription'] = '現在のテナントの範囲で認定を作成し管理することと、ユーザを割り当てることを許可する';
$string['schedule'] = '認定日';
$string['selectactiveandarchivedcertifications'] = 'アクティブな認定とアーカイブされた認定を選択する';
$string['selectadifferentprogram'] = '別のプログラムを選択する';
$string['selectallactivecertifications'] = 'アクティブな認定を選択する';
$string['selectallcertificationsinthisfile'] = 'このファイル内のすべての認定を選択してください';
$string['selectatleastonecertification'] = '少なくとも1つの認定を選択してください';
$string['selectcertificationcondition'] = '認定';
$string['selectcertificationcondition_help'] = 'この条件が適応される認定を選択';
$string['selectcertificationoutcome'] = '認定';
$string['selectcertificationoutcome_help'] = 'このアクションが適応される認定を選択';
$string['selectcertificationstoallocate'] = '認定';
$string['selectcertificationstoallocate_help'] = 'ユーザが割り当てられる認定を選択します';
$string['selectdate'] = '日付を選択';
$string['selectmanually'] = '手動で選択...';
$string['selectprogram'] = 'プログラムを選択';
$string['selectprogram_help'] = 'この認定に関連するプログラムを選択する';
$string['separatetenantsingroupswarning'] = 'テナント間で共有するコースでは、各テナントのユーザが別々のグループに追加されます。';
$string['startdate'] = '開始日';
$string['startdate_help'] = '認定の開始日';
$string['status'] = 'ステータス';
$string['suspended'] = '一時停止';
$string['suspendeddateisonorafter'] = '一時停止日以降';
$string['system'] = 'システム';
$string['tagarea_tool_certification'] = '認定';
$string['tags'] = 'タグ';
$string['timecreated'] = '作成日';
$string['timemodified'] = '最終更新日';
$string['timesuspended'] = '一時停止日';
$string['toomanycertificationstoshow'] = '表示する認定が多すぎます';
$string['uponcompletion'] = '完了日';
$string['userallocation'] = 'ユーザ割り当て';
$string['usercompletion'] = 'ユーザの完了';
$string['userduedate'] = '終了日';
$string['userduedate_help'] = 'このユーザに認定の終了日を選択';
$string['usergotsuspended'] = 'ユーザが一時停止されました';
$string['userlist'] = 'ユーザを選択';
$string['userlist_help'] = 'この認定に割り当てるユーザを選択します';
$string['users'] = 'ユーザ';
$string['usersallocatedsuccess'] = '{$a} 人のユーザが正常に割り当てられました。';
$string['usersallocationnotavailable'] = 'ユーザの割り当ては利用できません';
$string['usersdeallocatedsuccess'] = 'ユーザ {$a} の割り当てが正常に解除されました';
$string['userseditedsuccess'] = 'ユーザ {$a} が正常に変更されました';
$string['usersskipped'] = 'ユーザ {$a} は、このオプションを利用できないためスキップしました';
$string['userstartdate'] = '開始日';
$string['userstartdate_help'] = 'このユーザが認定を開始できる日付を選択してください。この日付はこのユーザにのみ適応されます。';
$string['userstatus'] = 'ステータス';
$string['userstatus_help'] = '通常は見えていますが、一時停止状態においては、この認定はこのユーザから非表示になります。';
$string['viewcertificationuserlog'] = '認定アクティビティログ';
