<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'cachestore_redis', language 'da', version '4.5'.
 *
 * @package     cachestore_redis
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ca_file'] = 'CA filsti';
$string['ca_file_help'] = 'Placering af certifikatmyndighedsfil på det lokale filsystem';
$string['clustermode'] = 'Cluster-tilstand';
$string['clustermode_help'] = 'Aktivering af cluster-tilstand vil køre Redis Cluster-funktionen, hvilket giver din server mulighed for at betjene flere servere til at håndtere samtidige requests samtidigt.';
$string['clustermodeunavailable'] = 'Redis Cluster er i øjeblikket utilgængelig. Venligst sørg for, at PHP Redis-udvidelsen understøtter Redis Cluster-funktionalitet.';
$string['compressor_none'] = 'Ingen komprimering.';
$string['compressor_php_gzip'] = 'Brug gzip-kompression.';
$string['compressor_php_zstd'] = 'Brug Zstandard-komprimering.';
$string['connectiontimeout'] = 'Forbindelsestimeout';
$string['connectiontimeout_help'] = 'Dette indstiller timeout ved forsøg på at oprette forbindelse til Redis-serveren.';
$string['encrypt_connection'] = 'Brug TLS-kryptering.';
$string['encrypt_connection_help'] = 'Brug TLS til at oprette forbindelse til Redis. Brug ikke \'tls://\' i værtsnavnet for Redis, brug denne mulighed i stedet.';
$string['password'] = 'Adgangskode';
$string['password_help'] = 'Her sættes adgangskode til Redisserveren';
$string['pluginname'] = 'Redis';
$string['prefix'] = 'Nøglepræfiks';
$string['prefix_help'] = 'Dette præfiks bruges til alle nøglenavne på Redisserveren.

* Har du kun en Moodle på denne server kan du bruge standardværdien.
* Grundet begrænsning på nøglens længde, kan der kun bruges 5 tegn.';
$string['prefixinvalid'] = 'Ugyldigt præfiks. Du kan kun bruge a-z A-Z 0-9-_.';
$string['privacy:metadata:redis'] = 'Redis cachestore-plugin gemmer data kortvarigt som en del af sin cache-funktionalitet. Disse data gemmes på en Redis-server, hvor data regelmæssigt fjernes.';
$string['privacy:metadata:redis:data'] = 'De forskellige data, der er gemt i cachen';
$string['serializer_igbinary'] = 'Igbinary serializer';
$string['serializer_php'] = 'Standard PHP serializer';
$string['server'] = 'Server (e)';
$string['server_help'] = 'Redis server der skal bruges til test.

Nogle eksempelværdier:

* testredis.abc.com - For at forbinde til en Redis-server via værtsnavn (Port 6379 som standard).
* testredis.abc.com:1234 - For at forbinde til en Redis-server via værtsnavn med en specifik port.
* 1.2.3.4 - For at forbinde til en Redis-server via IP-adresse (Port 6379 som standard).
* 1.2.3.4:1234 - For at forbinde til en Redis-server via IP-adresse med en specifik port.
* unix:///var/redis.sock - For at forbinde til en Redis-server ved hjælp af en Unix-socket.
* /var/redis.sock - For at forbinde til en Redis-server ved hjælp af en Unix-socket (alternativt format).

Hvis klyngetilstand er aktiveret, angiv servere adskilt af en ny linje, for eksempel:<br>
  172.23.0.11<br>
  172.23.0.12<br>
  172.23.0.13<br>

For yderligere information, se <a href="https://redis.io/docs/reference/clients/#accepting-client-connections">Accepterer klientforbindelser</a> og <a href="https://redis.io/resources/clients/#php">Redis PHP klienter</a>.';
$string['task_ttl'] = 'Frigør hukommelse brugt af udløbne poster i Redis-cacher';
$string['test_clustermode'] = 'Cluster-tilstand';
$string['test_clustermode_desc'] = 'Aktiver Test i Redis Cluster-tilstand.';
$string['test_password'] = 'Testserver-adgangskode';
$string['test_password_desc'] = 'Adgangskode til Redis-testserveren.';
$string['test_serializer'] = 'Serializer';
$string['test_serializer_desc'] = 'Serializer der skal bruges til test.';
$string['test_server'] = 'Testserver';
$string['test_server_desc'] = 'Redis-server der skal bruges til test.

Nogle eksempelværdier:

* testredis.abc.com - For at forbinde til en Redis-server via værtsnavn (Port 6379 som standard).
* testredis.abc.com:1234 - For at forbinde til en Redis-server via værtsnavn med en specifik port.
* 1.2.3.4 - For at forbinde til en Redis-server via IP-adresse (Port 6379 som standard).
* 1.2.3.4:1234 - For at forbinde til en Redis-server via IP-adresse med en specifik port.
* unix:///var/redis.sock - For at forbinde til en Redis-server ved hjælp af en Unix-socket.
* /var/redis.sock - For at forbinde til en Redis-server ved hjælp af en Unix-socket (alternativt format).

Hvis klyngetilstand er aktiveret, angiv servere adskilt af en ny linje, for eksempel:<br>
  172.23.0.11<br>
  172.23.0.12<br>
  172.23.0.13<br>

For yderligere information, se <a href="https://redis.io/docs/reference/clients/#accepting-client-connections">Accepterer klientforbindelser</a> og <a href="https://redis.io/resources/clients/#php">Redis PHP klienter</a>.';
$string['test_ttl'] = 'Test af TTL';
$string['test_ttl_desc'] = 'Kør ydelsestesten med en cache, der kræver TTL (langsommere sæt).';
$string['usecompressor'] = 'Brug kompressor';
$string['usecompressor_help'] = 'Angiver den kompressor, der skal bruges efter serialisering. Det udføres på Moodle Cache API-niveau, ikke på php-redis niveau.';
$string['useserializer'] = 'Brug serializer';
$string['useserializer_help'] = 'Angiver, hvilken serializer der skal bruges til serialisering.
De gyldige serializers er Redis::SERIALIZER_PHP eller Redis::SERIALIZER_IGBINARY.
Sidstnævnte understøttes kun, når phpredis er konfigureret med --enable-redis-igbinary optionen, og igbinary-udvidelsen er indlæst.';
