<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grading', language 'da', version '4.5'.
 *
 * @package     grading
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activemethodinfo'] = '"{$a->method}" er valgt som den aktive bedømmelsesmetode for området "{$a->area}"';
$string['activemethodinfonone'] = 'Der er ikke valgt en avanceret bedømmelsesmetode for området "{$a->area}". Simpel direkte bedømmelse vil blive brugt.';
$string['changeactivemethod'] = 'Skift aktiv bedømmelsesmetode til';
$string['clicktoclose'] = 'klik for at lukke';
$string['error:gradingunavailable'] = 'Den avancerede bedømmelsesmetode er ikke korrekt indstillet. Kontrollér venligst alle bedømmelsesindstillinger for forummet i forumindstillingerne.';
$string['error:notinrange'] = 'Ugyldig karakter "{$a->grade}" tildelt. Karakterer skal være mellem 0 og {$a->maxgrade}.';
$string['exc_gradingformelement'] = 'Kan ikke vise bedømmelsesformular-element';
$string['formnotavailable'] = 'Der blev valgt en avanceret bedømmelsesmetode, men der mangler stadig at blive fastlagt en bedømmelsesformular.';
$string['gradingformunavailable'] = 'Bemærk at formularen til avanceret bedømmelse ikke er klar for øjeblikket. Simpel bedømmelse vil blive brugt, indtil formularen er i orden.';
$string['gradingmanagement'] = 'Avanceret bedømmelse';
$string['gradingmanagementtitle'] = 'Avanceret bedømmelse: {$a->component} ({$a->area})';
$string['gradingmethod'] = 'Bedømmelsesmetode';
$string['gradingmethod_help'] = 'Vælg den avancerede bedømmelsesmetode der skal bruges til at beregne karakterer i den givne kontekst.

For at slå avanceret bedømmelse fra og gå tilbage til standardbedømmelse, vælges "Simpel direkte bedømmelse".';
$string['gradingmethodnone'] = 'Simpel direkte bedømmelse';
$string['gradingmethods'] = 'Bedømmelsesmetoder';
$string['manageactionclone'] = 'Opret ny bedømmelsesformular fra skabelon';
$string['manageactiondelete'] = 'slet den nuværende definerede formular';
$string['manageactiondeleteconfirm'] = 'Du er ved at slette bedømmelsesformularen "{$a->formname}" og alle de tilknyttede informationer fra "{$a->component} ({$a->area})". Vær opmærksom på følgende konsekvenser:

* Det kan ikke fortrydes.
* Du kan gå over til en anden bedømmelsesmetode inklusiv "Simpel direkte bedømmelse" uden at slette denne formular.
* Al information om hvordan bedømmelsesformularerne udfyldes, vil gå tabt.
* De beregnede resultatkarakterer som er gemt i karakterbogen, vil ikke blive påvirket. Dog vil forklaringen på hvordan de er beregnet, ikke være tilgængelig.
* Dette påvirker ikke eventuelle kopier af formularen i andre aktiviteter.';
$string['manageactiondeletedone'] = 'Formularen er slettet';
$string['manageactionedit'] = 'Rediger den nuværende formular-definition';
$string['manageactionnew'] = 'Definer ny bedømmelsesformular helt fra bunden';
$string['manageactionshare'] = 'Udgiv formularen som en ny skabelon';
$string['manageactionshareconfirm'] = 'Du er ved at gemme en kopi af bedømmelsesformularen "{$a}" som en ny offentlig skabelon. Andre brugere på sitet kan oprette nye bedømmelsesformularer i deres aktiviteter med denne skabelon.';
$string['manageactionsharedone'] = 'Formularen er gemt som skabelon';
$string['noitemid'] = 'Bedømmelse ikke mulig. Det bedømte element eksisterer ikke.';
$string['nosharedformfound'] = 'Der blev ikke fundet nogen skabelon';
$string['privacy:metadata:grading_definitions'] = 'Grundlæggende information om en avanceret bedømmelsesformular defineret i et bedømmelsesområde.';
$string['privacy:metadata:grading_definitions:areaid'] = 'Område-ID\'et hvor den avancerede bedømmelsesformular er defineret.';
$string['privacy:metadata:grading_definitions:copiedfromid'] = 'Bedømmelsesdefinitionens ID, hvorfra dette blev kopieret.';
$string['privacy:metadata:grading_definitions:description'] = 'Beskrivelsen af den avancerede bedømmelsesmetode.';
$string['privacy:metadata:grading_definitions:method'] = 'Bedømmelsesmetoden, der er ansvarlig for definitionen.';
$string['privacy:metadata:grading_definitions:name'] = 'Navnet på den avancerede bedømmelsesdefinition.';
$string['privacy:metadata:grading_definitions:options'] = 'Nogle indstillinger for denne bedømmelsesdefinition.';
$string['privacy:metadata:grading_definitions:status'] = 'Status for denne avancerede bedømmelsesdefinition';
$string['privacy:metadata:grading_definitions:timecopied'] = 'Tidspunktet for kopiering af bedømmelsesdefinitionen.';
$string['privacy:metadata:grading_definitions:timecreated'] = 'Tidspunktet for oprettelsen af bedømmelsesdefinitionen.';
$string['privacy:metadata:grading_definitions:timemodified'] = 'Tidspunktet for sidste ændring af bedømmelsesdefinitionen.';
$string['privacy:metadata:grading_definitions:usercreated'] = 'ID\'et på brugeren, som oprettede bedømmelsesdefinitionen.';
$string['privacy:metadata:grading_definitions:usermodified'] = 'ID\'et på brugeren, som sidst ændrede bedømmelsesdefinitionen.';
$string['privacy:metadata:grading_instances'] = 'Vurderingsoptegnelse for ét bedømmelsespunkt vurderet af én bedømmer.';
$string['privacy:metadata:grading_instances:feedback'] = 'Feedbacken givet af brugeren.';
$string['privacy:metadata:grading_instances:feedbackformat'] = 'Tekstformatet for feedbacken givet af brugeren.';
$string['privacy:metadata:grading_instances:raterid'] = 'ID\'et på brugeren, som vurderede bedømmelsesinstansen.';
$string['privacy:metadata:grading_instances:rawgrade'] = 'Karakteren for bedømmelsesinstansen.';
$string['privacy:metadata:grading_instances:status'] = 'Status for denne bedømmelsesinstans.';
$string['privacy:metadata:grading_instances:timemodified'] = 'Tidspunktet for sidste ændring af bedømmelsesinstansen.';
$string['privacy:metadata:gradingformpluginsummary'] = 'Data for bedømmelsesmetoden.';
$string['searchownforms'] = 'inkluder mine egne formularer';
$string['searchtemplate'] = 'Søg i bedømmelsesformularer';
$string['searchtemplate_help'] = 'Du kan søge efter en bedømmelsesformular og bruge den som skabelon til den nye bedømmelsesformular her. Skriv ord der skal stå i formularens navn, dens beskrivelse eller i selve formularen. Hvis du vil søge efter en sætning, skal du sætte hele spørgsmålet i anførselstegn (" ").

Som udgangspunkt inkluderes kun de bedømmelsesformularer der er blevet gemt som delte skabeloner i søgeresultaterne. Du kan også inkludere alle dine egne bedømmelsesformularer i søgeresultaterne.

På den måde kan du helt enkelt genbruge dine bedømmelsesformularer uden at dele dem. Kun formularer, der er markeret som "Klar til brug", kan genbruges på denne måde.';
$string['statusdraft'] = 'Kladde';
$string['statusready'] = 'Klar til brug';
$string['templatedelete'] = 'Slet';
$string['templatedeleteconfirm'] = 'Du vil slette den delte skabelon "{$a}". Sletning af en skabelon påvirker ikke eksisterende formularer som er oprettet i den.';
$string['templateedit'] = 'Rediger';
$string['templatepick'] = 'Brug denne skabelon';
$string['templatepickconfirm'] = 'Vil du bruge bedømmelsesformularen "{$a->formname}" som skabelon til den nye bedømmelsesformular i "{$a->component} ({$a->area})"?';
$string['templatepickownform'] = 'Brug denne formular som skabelon';
$string['templatesource'] = 'Lokation: {$a->component} ({$a->area})';
$string['templatetypeown'] = 'Egen formular';
$string['templatetypeshared'] = 'Delt skabelon';
