<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'ru', version '4.5'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Элементы курса';
$string['addcategory'] = 'Добавить категорию';
$string['addcategoryerror'] = 'Не удалось добавить категорию';
$string['addexceptionerror'] = 'Произошла ошибка при добавлении исключения для  userid:gradeitem';
$string['addfeedback'] = 'Добавить отзыв';
$string['addgradeletter'] = 'Добавить букву оценки';
$string['addidnumbers'] = 'Добавить ID';
$string['additem'] = 'Добавить элемент оценивания';
$string['additionalfeedback'] = 'Дополнительный отзыв';
$string['addoutcome'] = 'Добавить показатель';
$string['addoutcomeitem'] = 'Добавить оценку за показатель';
$string['addscale'] = 'Добавить шкалу';
$string['adjustedweight'] = 'Скорректированный вес';
$string['aggregateextracreditmean'] = 'Среднее оценок (с учетом доп. баллов)';
$string['aggregatemax'] = 'Лучшая оценка';
$string['aggregatemean'] = 'Среднее оценок';
$string['aggregatemedian'] = 'Медиана оценок';
$string['aggregatemin'] = 'Худшая оценка';
$string['aggregatemode'] = 'Мода оценок';
$string['aggregatenotonlygraded'] = 'Включая незаполненные оценки';
$string['aggregateonlygraded'] = 'Учитывать только заполненные оценки';
$string['aggregateonlygraded_help'] = 'Пустая оценка - это оценка, которая отсутствует в журнале оценок. Это может произойти, например, из-за того, что задание еще не было оценено или студент еще не приступал к тесту и т.п.

Этот параметр определяет, нужно ли учитывать пустые оценки при расчете итоговой. В том случае, если пустые оценки учитываются, вместо пустого значения используется наименьшее возможное значение - так, например, для задания, оцениваемого от 0 до 100, будет выбрано значение 0.';
$string['aggregateoutcomes'] = 'Включать оценки за показатели в итоговую оценку';
$string['aggregateoutcomes_help'] = 'Если параметр включен, оценки по отдельным показателям включаются в расчет итоговой оценки. Это может привести к непредсказуемому результату в категории.';
$string['aggregatesonly'] = 'Показать только итоги';
$string['aggregatesubcatsupgradedgrades'] = 'Обратите внимание: Настройка «Учитывать оценки из подкатегорий при расчете итоговой» была удалена в процессе обновления сайта. Поскольку эта настройка ранее использовалась в данном курсе, рекомендуется просмотреть это изменение в журнале оценок.';
$string['aggregatesum'] = 'Сумма оценок';
$string['aggregateweightedmean'] = 'Среднее взвешенное оценок';
$string['aggregateweightedmean2'] = 'Простое среднее взвешенное оценок';
$string['aggregation'] = 'Итоговая оценка';
$string['aggregation_help'] = 'Этот параметр определяет, каким образом рассчитывается итоговая оценка. Возможны варианты:

* Среднее оценок - Сумма всех оценок делится на их количество
* Медиана оценок - Выбирается значение, находящееся в середине упорядоченного по возрастанию списка оценок.
* Худшая оценка
* Лучшая оценка
* Мода оценок - Оценка, которая встречается наиболее часто
* Сумма оценок - Сумма значений всех оценок, пересчитанных с учетом веса.';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Коэффициент';
$string['aggregationcoefextra'] = 'Дополнительный балл / вес';
$string['aggregationcoefextra_help'] = 'Если итоговая оценка рассчитывается как «Сумма оценок» или как «Простое среднее взвешенное оценок» и поставлена галочка «Дополнительный балл», то максимальная оценка за оцениваемый элемент не добавляется к максимальной оценке за категорию. Это позволяет получить максимальную оценку в категории, не получая максимальный балл за каждый из элементов этой категории. Если администратор сайта разрешил оценки больше максимальной, то можно получить оценку больше максимальной.

Если итоговая оценка рассчитывается как «Среднее оценок (с учетом доп. баллов)» и значение дополнительного балла больше нуля, то дополнительный балл прибавляется к оценке перед добавлением ее к итогу после вычисления среднего.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Дополнительный балл';
$string['aggregationcoefextrasum_help'] = 'Если установлена отметка в поле «Дополнительный балл», то полученная оценка за оцениваемый элемент добавляется к максимальной оценке за категорию, что позволяет получить максимальную оценку (или оценку больше максимальной, если это разрешено администратором сайта) в категории, не получая максимальный балл за каждый из элементов этой категории.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Вес дополнительного балла';
$string['aggregationcoefextraweight_help'] = 'Если значение параметра «Вес дополнительного балла» больше нуля, то оценка выступает в роли дополнительного балла при расчете итога. «Вес дополнительного балла» - это множитель на который оценка будет умножаться перед тем как сложить все оценки при вычислении среднего.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Вес элемента';
$string['aggregationcoefweight_help'] = 'Вес элемента используется при расчете итога по категории, чтобы указать в категории важность одних элементов по сравнению с другими.';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '( Отброшено )';
$string['aggregationhintexcluded'] = '( Исключено )';
$string['aggregationhintextra'] = '( Дополнительный балл )';
$string['aggregationhintnovalue'] = '( Пусто )';
$string['aggregationofa'] = 'Итоговая оценка {$a}';
$string['aggregationposition'] = 'Расположение итогового столбца';
$string['aggregationposition_help'] = 'Этот параметр определяет расположение в журнале оценок столбцов с итоговыми оценками за категории и за весь курс.';
$string['aggregationsvisible'] = 'Доступные способы расчета итоговой оценки';
$string['aggregationsvisiblehelp'] = 'Выберите все способы расчета итоговой оценки, которые должны быть доступны. Для выбора нескольких элементов нажмите и удерживайте клавишу Ctrl.';
$string['allgrades'] = 'Все оценки по всем категориям';
$string['allstudents'] = 'Все студенты';
$string['allusers'] = 'Все пользователи';
$string['aria-toggledropdown'] = 'Переключить следующий раскрывающийся список';
$string['aria:dropdowngrades'] = 'Найдены элементы оценки';
$string['autosort'] = 'Авто-сортировка';
$string['availableidnumbers'] = 'Доступные значения ID';
$string['average'] = 'Средняя оценка';
$string['averagesdecimalpoints'] = 'Знаков после запятой в средних значениях';
$string['averagesdecimalpoints_help'] = 'Этот параметр определяет количество десятичных знаков, отображаемых в каждом столбце «Среднее». Если выбрано значение «Наследовать», то будет использоваться значение, установленное для родительской категории';
$string['averagesdisplaytype'] = 'Формат представления средних значений';
$string['averagesdisplaytype_help'] = 'Этот параметр определяет, будет ли среднее отображается в виде числовых оценок, процентов или букв. Если выбрано значение «Наследовать», то будет использоваться значение, установленное для родительской категории.';
$string['backupwithoutgradebook'] = 'Резервная копия не содержит конфигурации журнала оценок';
$string['badgrade'] = 'Указана некорректная оценка';
$string['badlyformattedscale'] = 'Пожалуйста, введите список значений через запятую (требуется указать по меньшей мере два значения).';
$string['baduser'] = 'Указан некорректный пользователь';
$string['bonuspoints'] = 'Премиальные<br />баллы';
$string['bulkcheckboxes'] = 'Флажки для массовых операций';
$string['calculatedgrade'] = 'Вычисляемая оценка';
$string['calculation'] = 'Вычисление';
$string['calculation_help'] = 'Вычисление оценки с использованием формулы для определения оценок. Формула должна начинаться со знака равенства (=); могут использоваться общие математические операторы, такие как максимум, минимум и сумма. При желании в расчет могут быть включены другие элементы оценки, при этом их ID номера вводятся в двойных квадратных скобках.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Добавить вычисление';
$string['calculationedit'] = 'Редактировать вычисление';
$string['calculationsaved'] = 'Вычисления сохранены';
$string['calculationview'] = 'Просмотреть вычисления';
$string['calculationwarning'] = 'В этой категории для итоговой оценки используется её расчет, а не совокупность оценок.';
$string['cannotaccessgroup'] = 'К сожалению, нет доступа к оценкам выбранной группы.';
$string['categories'] = 'Категории';
$string['category'] = 'Категория';
$string['categoryedit'] = 'Редактировать категорию';
$string['categoryname'] = 'Название категории';
$string['categorytotal'] = 'Итог категории';
$string['categorytotalfull'] = 'Итого в категории «{$a->category}»';
$string['categorytotalname'] = 'Название итога категории';
$string['changedefaults'] = 'Изменить настройки по умолчанию';
$string['changereportdefaults'] = 'Изменить значения по умолчанию для отчета';
$string['chooseaction'] = 'Выберите действие...';
$string['choosecategory'] = 'Выберите категорию';
$string['collapsecriterion'] = 'Свернуть критерий';
$string['compact'] = 'Сжатый';
$string['componentcontrolsvisibility'] = 'Скрыт этот оцениваемый элемент или нет - задается в настройках элемента курса.';
$string['contract'] = 'Категория соглашения';
$string['contributiontocoursetotal'] = 'Вклад в итог курса';
$string['controls'] = 'Управляющие элементы';
$string['courseavg'] = 'Среднее курса';
$string['coursegradecategory'] = 'Категория оценок курса';
$string['coursegradedisplaytype'] = 'Формат представления оценок курса';
$string['coursegradedisplayupdated'] = 'Формат представления оценок курса был обновлен';
$string['coursegradesettings'] = 'Настройки оценок курса';
$string['coursename'] = 'Название курса';
$string['coursescales'] = 'Шкалы курса';
$string['coursesettings'] = 'Настройки курса';
$string['coursesettingsexplanation'] = 'Параметры настройки оценок курса определяют, как журнал оценок будет выглядеть для всех участников курса.';
$string['coursesiamtaking'] = 'Курсы, на которых я учусь';
$string['coursesiamteaching'] = 'Курсы, на которых я преподаю';
$string['coursetotal'] = 'Итоговая оценка за курс';
$string['createcategory'] = 'Создать категорию';
$string['createcategoryerror'] = 'Не удалось создать новую категорию';
$string['creatinggradebooksettings'] = 'Создание настроек Журнала оценок';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Текущий способ расчета итоговой оценки в родительской категории';
$string['curveto'] = 'Привести к';
$string['decimalpoints'] = 'Знаков после запятой';
$string['decimalpoints_help'] = 'Этот параметр определяет количество десятичных знаков при отображении каждой оценки. Это не влияет на вычисление оценок, которые рассчитываются с точностью до 5 десятичных знаков.';
$string['default'] = 'По умолчанию';
$string['defaultprev'] = 'По умолчанию ({$a})';
$string['deletecategory'] = 'Удалить категорию';
$string['deletescale'] = 'Удалить шкалу';
$string['disablegradehistory'] = 'Отключить историю оценок';
$string['disablegradehistory_help'] = 'Отключить отслеживание и фиксацию изменений в таблицах, связанных с оценками. Это может немного ускорить сервер  и сэкономить место в базе данных.';
$string['displaylettergrade'] = 'Показать буквенные оценки';
$string['displaypercent'] = 'Показать проценты';
$string['displaypoints'] = 'Показать баллы';
$string['displayweighted'] = 'Показать вес оценок';
$string['droplow'] = 'Не учитывать худших оценок';
$string['droplow_help'] = 'Этот параметр позволяет не учитывать указанное число самых низких оценок при расчете итоговой оценки.';
$string['droplowestvalue'] = 'Задать отбрасывание самой низкой оценки';
$string['droplowestvalues'] = 'Отбросить {$a} самых низких значений';
$string['dropped'] = 'не учитывается';
$string['dropxlowest'] = 'Не учитывать X<br />худших оценок';
$string['dropxlowestwarning'] = 'Примечание: если вы используете функцию «Не учитывать X худших оценок», то подразумевается, что все элементы в данной категории оцениваются одним и тем же числом баллов каждый. Если баллы отличаются, результат может стать непредсказуемым.';
$string['duplicatedgradeitem'] = '{$a} (копия)';
$string['duplicatescale'] = 'Дублировать шкалу';
$string['edit'] = 'Редактировать';
$string['editcalculation'] = 'Редактировать формулу';
$string['editcalculationverbose'] = 'Редактировать расчет для {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Редактировать отзыв';
$string['editgrade'] = 'Редактировать оценку';
$string['editgradeletters'] = 'Редактировать буквенные оценки';
$string['editoutcome'] = 'Редактировать показатель';
$string['editoutcomes'] = 'Редактировать показатели';
$string['editscale'] = 'Редактировать шкалу';
$string['edittree'] = 'Настройки';
$string['editverbose'] = 'Редактировать {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Включить AJAX';
$string['enableajax_help'] = 'Добавляет в журнал оценок AJAX-функциональность, что позволяет упростить и ускорить многие операции. Для работы также необходимо, чтобы в браузере пользователя был включен Javascript.';
$string['enableoutcomes'] = 'Включить показатели';
$string['enableoutcomes_help'] = 'При включении этого параметра, оцениваемые элементы могут быть быть оценены по одной или нескольким шкалам, привязанным к показателям.';
$string['encoding'] = 'Кодировка';
$string['encoding_help'] = 'Выберите кодировку символов, используемую для данных. (Стандартная кодировка — UTF-8.) Если по ошибке выбрана неправильная кодировка, это можно будет заметить при предварительном просмотре данных для импорта.';
$string['errorcalculationbroken'] = 'Ошибка в расчете элемента оценки {$a}.';
$string['errorcalculationnoequal'] = 'Формула должна начинаться со знака «равно» (=1+2)';
$string['errorcalculationunknown'] = 'Некорректная формула';
$string['errorgradevaluenonnumeric'] = 'Получены нечисловые значения минимальной или максимальной оценки для';
$string['errornocalculationallowed'] = 'Для этого элемента не разрешено вычисление оценки';
$string['errornocategorisedid'] = 'Не удалось получить ID «Вне категорий»!';
$string['errornocourse'] = 'Не удалось получить информацию о курсе';
$string['erroroverweight'] = 'Общий вес превышает 100%.';
$string['errorreprintheadersnonnumeric'] = 'Получено нечисловое значение для повтора заголовков';
$string['errorsavegrade'] = 'К сожалению,оценку сохранить невозможно.';
$string['errorsettinggrade'] = 'Ошибка сохранения оценки «{$a->itemname}» для пользователя с ID {$a->userid}';
$string['errorunderweight'] = 'Общий вес составляет менее 100%.';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Ошибка при обновлении параметра «Учитывать только непустые оценки» для категории с ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Ошибка при обновлении параметра «Включать показатели в итог» для категории с ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Ошибка обновления способа расчета итоговой оценки для категории с ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Ошибка обновления итогового коэффициента (вес или дополнительный балл) элемента оценивания с ID {$a->id}';
$string['eventgradedeleted'] = 'Оценка удалена';
$string['eventgradeexported'] = 'Оценка экспортирована';
$string['eventgradeitemcreated'] = 'Создан элемент оценки';
$string['eventgradeitemdeleted'] = 'Элемент оценки удален';
$string['eventgradeitemupdated'] = 'Элемент оценки обновлен';
$string['eventgradelettercreated'] = 'Буква оценки создана';
$string['eventgradeletterdeleted'] = 'Буква оценки удалена';
$string['eventgradeletterupdated'] = 'Буква оценки обновлена';
$string['eventgradeviewed'] = 'Оценки были просмотрены в журнале оценок';
$string['eventscalecreated'] = 'Шкала создана';
$string['eventscaledeleted'] = 'Шкала удалена';
$string['eventscaleupdated'] = 'Шкала обновлена';
$string['eventusergraded'] = 'Пользователю поставлена оценка';
$string['excluded'] = 'НЕ оцени-<br />вается';
$string['excluded_help'] = 'Если отмечено, оценка не будет использоваться при расчете итоговых оценок';
$string['expand'] = 'Расширить категорию';
$string['expandcriterion'] = 'Развернуть критерий';
$string['export'] = 'Экспорт';
$string['exportalloutcomes'] = 'Экспортировать все показатели';
$string['exportas'] = 'Экспортировать как';
$string['exportfeedback'] = 'Включить отзыв в экспорт';
$string['exportfeedback_desc'] = 'Может быть переопределен во время экспорта.';
$string['exportformatoptions'] = 'Параметры формата экспорта';
$string['exportonlyactive'] = 'Исключить приостановленных пользователей';
$string['exportonlyactive_help'] = 'Включить в экспорт только реально обучающихся студентов, исключив приостановленных.';
$string['exportplugins'] = 'Плагины экспорта';
$string['exportsettings'] = 'Настройки экспорта';
$string['exportto'] = 'Экспорт в';
$string['externalurl'] = 'Внешний URL';
$string['externalurl_desc'] = 'Если используется внешний журнал оценок, здесь необходимо указать URL';
$string['extracreditvalue'] = 'Дополнительный балл для {$a}';
$string['extracreditwarning'] = 'Примечание: установка всех элементов категории в качестве дополнительных баллов исключит их из подсчета оценки. Следовательно, в этом случае вообще не будет итоговой оценки.';
$string['fail'] = 'Неудача';
$string['feedback'] = 'Отзыв';
$string['feedback_help'] = 'Это поле позволяет добавить какие-либо комментарии к оценке.';
$string['feedbackadd'] = 'Добавить отзыв';
$string['feedbackedit'] = 'Редактировать отзыв';
$string['feedbackfiles'] = 'Файлы отзыва';
$string['feedbackforgradeitems'] = 'Отзыв для {$a}';
$string['feedbackhistoryfiles'] = 'История файлов отзывов';
$string['feedbackprovided'] = 'Отзыв предоставлен';
$string['feedbacks'] = 'Отзывы';
$string['feedbacksaved'] = 'Отзыв сохранен';
$string['feedbackview'] = 'Просмотр отзыва';
$string['filterbothactive'] = 'Первый ({$a->first}) Последний ({$a->last})';
$string['filterbyname'] = 'Фильтровать по имени';
$string['filterfirstactive'] = 'Первый ({$a->first})';
$string['filterlastactive'] = 'Последний ({$a->last})';
$string['finalgrade'] = 'Итоговая оценка';
$string['finalgrade_help'] = 'Если отмечено поле «Переопределить», то оценка может быть добавлена или изменена.';
$string['fixedstudents'] = 'Закрепить столбец студентов';
$string['fixedstudents_help'] = 'Позволяет прокручивать оценки по горизонтали, не теряя при этом из виду столбец студентов, закрепив его.';
$string['forceimport'] = 'Принудительный импорт';
$string['forceimport_help'] = 'Принудительный импорт оценок, даже если оценки были изменены после  экспортирования файла импорта';
$string['forceoff'] = 'Принудительно: Выкл';
$string['forceon'] = 'Принудительно: Вкл';
$string['forelementtypes'] = 'для выбранных {$a}';
$string['forstudents'] = 'Для студентов';
$string['full'] = 'Полный';
$string['fullmode'] = 'Показать оценки и итоги';
$string['generalsettings'] = 'Общие настройки';
$string['grade'] = 'Оценка';
$string['grade_help'] = 'Оценка, выставляемая студенту за его работу.';
$string['gradeadministration'] = 'Управление оценками';
$string['gradealreadyupdated'] = 'Часть оценок ({$a}) не были импортированы, потому что оценки в импортируемом файле старше, чем в отчете оценщика. Чтобы при этом продолжить импорт оценок, используйте функцию принудительного импорта.';
$string['gradeanalysis'] = 'Анализ оценок';
$string['gradebook'] = 'Журнал оценок';
$string['gradebookcalculationsfixbutton'] = 'Принять изменения оценок и исправить ошибки вычислений';
$string['gradebookcalculationsuptodate'] = 'Вычисления в журнале оценок актуальны. Возможно, Вам надо перезагрузить эту страницу, чтобы увидеть изменения.';
$string['gradebookcalculationswarning'] = 'Примечание: Было обнаружено несколько ошибок в вычислении оценок, отображаемых в журнале оценок. Если курс еще не начался или уже идет, рекомендуется исправить эти ошибки, нажав на кнопку ниже, хотя это приведет к тому, что некоторые оценки изменятся. Если курс уже завершился и оценки были отправлены, Вы, возможно, решите не исправлять эту проблему.

Новая версия {$a->currentversion}. Вы используете журнал оценок версии {$a->gradebookversion}. Вы можете просмотреть список изменений на странице <a href="{$a->url}">Gradebook calculation changes</a>.';
$string['gradebookhiddenerror'] = 'В настоящее время все элементы журнала оценок скрыты от студентов';
$string['gradebookhistories'] = 'История оценок';
$string['gradebooknavigationmenu'] = 'Меню навигации Журнала оценок';
$string['gradebooksetup'] = 'Настройка журнала оценок';
$string['gradeboundary'] = 'Граница буквенной оценки';
$string['gradeboundary_help'] = 'Этот параметр определяет минимальный процент, при достижении которого будет назначена указанная буквенная оценка.';
$string['gradecategories'] = 'Категории оценок';
$string['gradecategory'] = 'Категория оценки';
$string['gradecategoryonmodform'] = 'Категория оценки';
$string['gradecategoryonmodform_help'] = 'Этот параметр определяет категорию в журнале оценок, в которой  размещаются оценки этого элемента курса.';
$string['gradecategorysettings'] = 'Настройки категорий оценок';
$string['gradedisplay'] = 'Представление оценки';
$string['gradedisplaytype'] = 'Формат представления оценки';
$string['gradedisplaytype_help'] = 'Этот параметр определяет, как оценки отображаются в Журнале оценок и отчетах.

* Буква - для представления диапазонов оценок используются буквы или слова, заданные в разделе «Буквы» в настройке журнала оценок.
* Процент - относительно максимальной и минимальной оценок.
* Значение - фактические оценки или значения шкалы';
$string['gradedon'] = 'Оценено: {$a}';
$string['gradeexport'] = 'Экспорт оценок';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Настраиваемые поля профиля в экспортируемой оценке';
$string['gradeexportcustomprofilefields_desc'] = 'Включить эти настраиваемые поля профиля в экспортируемую оценку (разделитель - запятая).';
$string['gradeexportdecimalpoints'] = 'Количество цифр после запятой при экспорте';
$string['gradeexportdecimalpoints_desc'] = 'Количество десятичных цифр, отображаемых при экспорте. Может быть переопределено настройками экспорта.';
$string['gradeexportdisplaytype'] = 'Тип отображения оценок при экспорте';
$string['gradeexportdisplaytype_desc'] = 'Оценки при экспорте могут быть выведены как реальные оценки, в процентах (по отношению к минимальной и максимальной оценке) или как буквы (A, B, C и т.д..). Этот параметр может быть переопределен при экспорте.';
$string['gradeexportdisplaytypes'] = 'Типы отображения оценок при экспорте';
$string['gradeexportuserprofilefields'] = 'Поля профиля пользователя в экспортируемой оценке';
$string['gradeexportuserprofilefields_desc'] = 'Включить эти поля профиля пользователя в экспортируемую оценку (разделитель - запятая).';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Изначальные минимальные и максимальные оценки';
$string['gradehelp'] = 'Справка по Оценкам';
$string['gradehistorylifetime'] = 'Время жизни истории оценок';
$string['gradehistorylifetime_help'] = 'Этот параметр отвечает за срок хранения истории изменений в таблицах, связанных с оценками. Рекомендуется устанавливать его как можно большим. Если у Вас возникают проблемы с производительностью или ограничено место в базе данных, попробуйте установить меньшее значение.';
$string['gradeimport'] = 'Импорт оценок';
$string['gradeimportfailed'] = 'Ошибка импорта оценок. Подробности:';
$string['gradeitem'] = 'Элемент оценивания';
$string['gradeitemaddusers'] = 'НЕ оценивать';
$string['gradeitemadvanced'] = 'Расширенные параметры элемента оценивания';
$string['gradeitemadvanced_help'] = 'Выделите все элементы, которые должны отображены как расширенные при редактировании элементов оценивания.';
$string['gradeitemislocked'] = 'Этот элемент курса заблокирован в журнале оценок. Изменения, сделанные в оценках этого элемента курса, не будут скопированы в журнал оценок, пока элемент не будет разблокирован.';
$string['gradeitemlocked'] = 'Оценивание заблокировано';
$string['gradeitemmembersselected'] = 'НЕ оцениваются';
$string['gradeitemminmax'] = 'Минимальные и максимальные оценки, заданные в настройках оцениваемого элемента';
$string['gradeitemnonmembers'] = 'Оцениваются';
$string['gradeitemremovemembers'] = 'Оценивать';
$string['gradeitems'] = 'Элементы оценивания';
$string['gradeitemsettings'] = 'Настройки оценок элементов';
$string['gradeitemsinc'] = 'Включаемые оценки';
$string['gradeletter'] = 'Буквенная оценка';
$string['gradeletter_help'] = 'Буквенная оценка: буквы - A, B, C, ... или слова - например, Отлично, Хорошо, Удовлетворительно, ..., используемые для представления диапазонов оценок.';
$string['gradeletternote'] = 'Чтобы удалить буквенную оценку, просто очистите любое из <br />трех текстовых полей данной оценки и нажмите кнопку «Сохранить изменения».';
$string['gradeletteroverridden'] = 'Буквы оценок по умолчанию сейчас переопределены.';
$string['gradeletters'] = 'Буквенные оценки';
$string['gradelocked'] = 'Оценка заблокирована';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Максимальная оценка';
$string['grademax_help'] = 'Этот параметр определяет максимальную оценку при использовании формата оценки «Значение». Для оценок, связанных с элементами курса, максимальная оценка устанавливается на странице настройки элемента курса.';
$string['grademin'] = 'Минимальная оценка';
$string['grademin_help'] = 'Этот параметр определяет минимальную оценку при использовании формата оценки Значение.';
$string['gradenotificationmessage'] = 'Есть новый отзыв о вашей работе для «{$a}»';
$string['gradenotificationsubject'] = 'Вам поставили оценку';
$string['gradeoutcomeitem'] = 'Оценка элемента показателя';
$string['gradeoutcomes'] = 'Показатели';
$string['gradeoutcomescourses'] = 'Показатели курса';
$string['gradepass'] = 'Проходной балл';
$string['gradepass_help'] = 'Этот параметр определяет минимальную оценку, необходимую для сдачи. Это значение учитывается при отслеживании выполнения элементов или завершения курса;  оценки выше проходного балла выделяются в журнале зеленым цветом, а ниже проходного балла - красным.';
$string['gradepassgreaterthangrade'] = 'Проходной балл не может быть больше максимально возможной оценки {$a}';
$string['gradepointdefault'] = 'Оценка в баллах по умолчанию';
$string['gradepointdefault_help'] = 'Этот параметр определяет значение в баллах по умолчанию, используемое для оценивания элемента курса.';
$string['gradepointdefault_validateerror'] = 'Значение этого параметра должно быть целым числом от 1 до максимального балла.';
$string['gradepointmax'] = 'Максимальная оценка в баллах';
$string['gradepointmax_help'] = 'Этот параметр определяет максимальное значение в баллах, используемое для оценивания элемента курса.';
$string['gradepointmax_validateerror'] = 'Значение этого параметра должно быть целым числом от 1 до 10 000.';
$string['gradepreferences'] = 'Настройки оценок';
$string['gradepreferenceshelp'] = 'Справка по настройками Журнала оценок';
$string['gradepublishing'] = 'Разрешить публикацию';
$string['gradepublishing_help'] = 'Публикация оценок - это способ импорта и экспорта оценок через URL без входа в Moodle. Если этот параметр включен, администраторам и пользователям с разрешением публиковать оценки (по умолчанию это только пользователи с ролью администратора) предоставляются настройки публикации экспорта оценок в каждом журнале оценок.';
$string['gradepublishinglink'] = 'Скачать: {$a}';
$string['gradereport'] = 'Отчет об оценках';
$string['graderreport'] = 'Отчет по оценкам';
$string['grades'] = 'Оценки';
$string['gradesforuser'] = 'Оценки для пользователя «{$a->user}»';
$string['gradesmoduledeletionpendingwarning'] = 'Предупреждение: Очистка элементов продолжается! Некоторые оценки будут удалены.';
$string['gradesmoduledeletionprefix'] = '[Процесс удаления]';
$string['gradesonly'] = 'Показать только оценки';
$string['gradessettings'] = 'Настройки оценок';
$string['gradetype'] = 'Тип оценки';
$string['gradetype_help'] = 'Существуют 4 типа оценок:

* Не оценивается - Оценка не выставляется
* Значение - числовое значение с максимумом и минимумом.
* Шкала - Один элемент из списка
* Текст - Только текстовый отзыв

Для расчета итоговой оценки могут использоваться только оценки типа «Значение» и «Шкала». Для оценок, связанных с элементами курса, тип устанавливается на странице настройки элемента курса.';
$string['gradevaluetoobig'] = 'Значение одной из оценок больше, чем допустимый максимум {$a}';
$string['gradevaluetoosmall'] = 'Одно из значений оценок меньше допустимого минимума, равного {$a}.';
$string['gradeview'] = 'Посмотреть оценку';
$string['gradewasmodifiedduringediting'] = 'Оценка, выставленная за {$a->itemname} для {$a->username} была проигнорирована, потому что она была совсем недавно обновлена кем-то другим.';
$string['gradeweighthelp'] = 'Справка по весу оценок';
$string['gradingmodulename'] = 'Оценивание ({$a})';
$string['groupavg'] = 'Среднее по группе';
$string['hidden'] = 'Скрыть';
$string['hidden_help'] = 'Если установлена отметка, то оценки скрыты от студентов. По желанию может быть установлена дата «Скрыть до», чтобы представить оценки уже после завершения оценивания.';
$string['hiddenasdate'] = 'Показывать дату представления вместо скрытых оценок';
$string['hiddenasdate_help'] = 'Если пользователь не может видеть скрытые оценки, то выводить дату их представления вместо « - ».';
$string['hiddenuntil'] = 'Скрыть до';
$string['hiddenuntildate'] = 'Скрыть до: {$a}';
$string['hideadvanced'] = 'Скрыть дополнительные настройки';
$string['hideaverages'] = 'Скрыть средние значения';
$string['hidecalculations'] = 'Скрыть вычисления';
$string['hidecategory'] = 'Скрытая<br />кат.';
$string['hideeyecons'] = 'Скрыть иконки «Отображать/скрыть»';
$string['hidefeedback'] = 'Скрыть отзыв';
$string['hideforcedsettings'] = 'Скрыть принудительные настройки';
$string['hideforcedsettings_help'] = 'Не показывать принудительные (заблокированные на уровне сайта) настройки оценивания в пользовательском интерфейсе.';
$string['hidegroups'] = 'Скрыть группы';
$string['hidelocks'] = 'Скрыть блокировки';
$string['hidenooutcomes'] = 'Отобразить показатели';
$string['hidequickfeedback'] = 'Скрыть быстрый отзыв';
$string['hideranges'] = 'Скрыть диапазоны';
$string['hidetotalifhiddenitems'] = 'Скрывать итоги, если они зависят от скрытых элементов';
$string['hidetotalifhiddenitems_help'] = 'Этот параметр определяет, будут ли итоги, зависящие от скрытых оценок, отображаться студентам или будут заменяться дефисом (-). Если будут отображаться, то итоговая оценка может быть рассчитана либо с учетом, либо без учета скрытых элементов.

Если скрытые элементы будут исключены из расчета итоговой оценки, то оценка, отображаемая преподавателю в журнале, будет отличаться от отображаемой студенту, так как преподаватель всегда видит итоги, рассчитываемые из всех элементов, скрытых или не скрытых. Если скрытые элементы включаются в расчет, то студенты, возможно, смогут вычислить значения скрытых элементов.';
$string['hidetotalshowexhiddenitems'] = 'Выводить итоги без учета скрытых элементов';
$string['hidetotalshowinchiddenitems'] = 'Выводить итоги с учетом скрытых элементов';
$string['hideverbose'] = 'Скрыть {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Сортировать по возрастанию наибольшей оценки';
$string['highgradedescending'] = 'Сортировать по убыванию наибольшей оценки';
$string['highgradeletter'] = 'Максимум';
$string['identifier'] = 'Определение пользователя';
$string['idnumbers'] = 'Значения ID';
$string['ignore'] = 'Игнорировать';
$string['import'] = 'Импорт';
$string['importas'] = 'Импортировать как';
$string['importcsv'] = 'Импорт CSV';
$string['importcsv_help'] = 'Оценки можно импортировать из выглядящего следующим образом файла формата CSV:

* Каждая строка файла содержит одну запись
* Каждая строка является набором данных, разделяемых запятыми или другим разделителем
* Первая строка содержит список имен полей, определяющих формат остального файла
* Обязательно имя поля, содержащее данные для идентификации пользователя — логин, идентификационный номер или адрес электронной почты

Файл правильного формата можно получить, предварительно экспортировав несколько оценок. Этот файл затем можно отредактировать и сохранить как файл CSV.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Импортировать как локальные показатели (только для этого курса)';
$string['importdata'] = 'Данные';
$string['importdata_help'] = 'Оценки можно вставлять непосредственно из электронной таблицы OpenDocument или Excel в следующем формате:

* По крайней мере, один столбец должен содержать идентификационные данные пользователя - имя пользователя (username), адрес электронной почты или ID-номер.
* Остальные столбцы должны иметь заголовки для существующих активных элементов или оцениваемых элементов.

Правильно отформатированную таблицу можно получить, предварительно экспортировав несколько оценок. Таблицу можно отредактировать, добавив больше оценок, и затем сохранить.

Выберите и скопируйте столбцы, которые вы хотите импортировать из электронной таблицы, а затем вставьте их в это поле.';
$string['importerror'] = 'Произошла ошибка, этот скрипт был вызван с некорректными параметрами.';
$string['importfailed'] = 'Импорт не удался. Данные не были импортированы.';
$string['importfeedback'] = 'Импортировать отзывы';
$string['importfile'] = 'Импортировать файл';
$string['importfilemissing'] = 'Файл не был получен, вернитесь назад к форме и убедитесь, что загружаете правильный файл.';
$string['importfrom'] = 'Импорт из';
$string['importoutcomenofile'] = 'Загруженный файл пуст или поврежден. Пожалуйста, проверьте, что это корректный файл. В строке {$a} была обнаружена проблема; она вызвана данными в строке, в которой число столбцов отличается от числа в первой строке (строке заголовка) или в файле вовсе отсутствуют ожидаемые заголовки. В качестве примера корректного файла можно взять экспортированный файл.';
$string['importoutcomes'] = 'Импортировать показатели';
$string['importoutcomes_help'] = 'Показатели можно импортировать из CSV-файла. Формат этого файла такой же, как и при экспорте показателей.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Импортирован показатель «{$a->name}» с ID #{$a->id}';
$string['importplugins'] = 'Плагины импорта';
$string['importpreview'] = 'Предварительный просмотр импорта';
$string['importsettings'] = 'Настройки импорта';
$string['importskippednomanagescale'] = 'Показатель «{$a}» был пропущен, так как для этого требуется создание новой шкалы, а у Вас нет на это прав.';
$string['importskippedoutcome'] = 'Показатель с кратким названием «{$a}» уже существует в этом контексте, поэтому показатель из импортируемого файла был пропущен.';
$string['importstandard'] = 'Импортировать как стандартные показатели';
$string['importsuccess'] = 'Оценки импортированы';
$string['importxml'] = 'Импортировать XML';
$string['includescalesinaggregation'] = 'Включать оценки по шкале в итоговую оценку';
$string['includescalesinaggregation_help'] = 'Вы можете выбрать, включать ли оценки по шкале (в виде чисел) во все итоговые оценки во всех журналах оценок во всех курсах. ВНИМАНИЕ: изменение этого параметра приведет к пересчету всех итоговых оценок.';
$string['incorrectcourseid'] = 'Неверный идентификатор курса';
$string['incorrectcustomscale'] = '(Некорректная локальная шкала; пожалуйста, измените.)';
$string['incorrectminmax'] = 'Минимум должен быть меньше максимума.';
$string['inherit'] = 'Наследовать';
$string['intersectioninfo'] = 'Студент/Оценка';
$string['invalidgradeexporteddate'] = 'Дата экспорта недействительна - прошло больше года или назначена в будущем, либо формат даты является недопустимым.';
$string['item'] = 'Элемент';
$string['iteminfo'] = 'Информация';
$string['iteminfo_help'] = 'Место для ввода информации об элементе оценивания. Эта информация больше нигде не отображается.';
$string['itemname'] = 'Название';
$string['itemnamehelp'] = 'Название элемента, установленное модулем.';
$string['items'] = 'Элементы';
$string['itemsedit'] = 'Редактировать элемент оценивания';
$string['keephigh'] = 'Учитывать лучших оценок';
$string['keephigh_help'] = 'Если параметр установлен, то при вычислении итоговой оценки будет учитываться только указанное число лучших оценок.';
$string['keephighestvalues'] = 'Взять лучшие оценки - ({$a})';
$string['keymanager'] = 'Управление ключами';
$string['lessthanmin'] = 'Оценка, введенная за элемент «{$a->itemname}» для пользователя «{$a->username}», меньше допустимого минимума';
$string['letter'] = 'Буква';
$string['lettergrade'] = 'Буквенная оценка';
$string['lettergradenonnumber'] = 'Минимальная и/или максимальная оценки нечисловые  для';
$string['letterpercentage'] = 'Буква (процент)';
$string['letterreal'] = 'Буква (значение)';
$string['letters'] = 'Буквы';
$string['linkedactivity'] = 'Связанный элемент курса';
$string['linkedactivity_help'] = 'Этот параметр определяет элемент курса, с которым будет связана оценка за показателю. Это может использоваться для измерения достижений студента с помощью критериев, не связанных с оценкой за элемент курса.';
$string['linktoactivity'] = '{$a->name} элемент курса {$a->title}';
$string['lock'] = 'Блокировка';
$string['locked'] = 'Заблокировано';
$string['locked_help'] = 'Если установлена отметка, то оценки не будут автоматически обновляться из связанного элемента курса.';
$string['locktime'] = 'Заблокировать после';
$string['locktimedate'] = 'Заблокировано после: {$a}';
$string['lockverbose'] = 'Заблокировать {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Минимальная';
$string['lowgradeletter'] = 'Минимум';
$string['manageoutcomes'] = 'Управление показателями';
$string['manualitem'] = 'Заполняемый вручную элемент';
$string['mapfrom'] = 'Взять значение из';
$string['mapfrom_help'] = 'Выберите столбец в электронной таблице, содержащий данные для идентификации пользователя, такие как логин или ID пользователя или адрес электронной почты.';
$string['mappings'] = 'Сопоставление данных с элементами оценивания';
$string['mappings_help'] = 'Для каждого столбца оценок в электронной таблице выберите соответствующий элемент оценивания, в который импортировать оценки.';
$string['mapto'] = 'сопоставить со значением поля';
$string['mapto_help'] = 'Выбрать те же идентификационные данные, которые указаны для «Сопоставить с».';
$string['max'] = 'Наибольшая оценка';
$string['maxgrade'] = 'Максимальная оценка';
$string['meanall'] = 'Все оценки';
$string['meangraded'] = 'Непустые оценки';
$string['meanselection'] = 'Оценки, используемые для подсчета средних';
$string['meanselection_help'] = 'Этот параметр определяет, будет ли пустая ячейка без оценки включена в расчет среднего значения оценки для всех категорий или элементов оценивания.';
$string['median'] = 'Медиана';
$string['min'] = 'Наименьшая оценка';
$string['minimum_show'] = 'Учитывать минимальную оценку';
$string['minimum_show_help'] = 'Минимальная оценка используется при расчете оценки и веса. Если не указана, то по умолчанию минимальная оценка будет равна нулю и не может быть изменена.';
$string['minmaxtouse'] = 'Минимальные и максимальные оценки, используемые в вычислениях';
$string['minmaxtouse_desc'] = 'Эта настройка определяет, какие максимальные и минимальные оценки использовать при вычислении в журнале оценок: изначальные максимальные и минимальные оценки, заданные при настройке оценок, или минимальные и максимальные оценки, заданные в настройках для оцениваемого элемента. Рекомендуется изменять эту настройку в период, когда на сервере не производится активных действий, так как все оценки будут пересчитаны, что может создать высокую нагрузку на сервер.';
$string['minmaxtouse_help'] = 'Эта настройка определяет, какие максимальные и минимальные оценки использовать при вычислении в журнале оценок: изначальные максимальные и минимальные оценки, заданные при настройке оценок, или минимальные и максимальные оценки, заданные в настройках для оцениваемого элемента.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Примечание: некоторые оценки были изменены для того, чтобы исправить обнаруженные несоответствия в журнале оценок.  Несоответствия возникли из-за изменения минимальных и максимальных оценок, используемых при вычислении оценок в журнале оценок. Рекомендуется просмотреть и принять эти изменения.';
$string['minmaxupgradefixbutton'] = 'Исправить несоответствия';
$string['minmaxupgradewarning'] = 'Примечание: обнаруженные несоответствия некоторых оценок возникли из-за изменения минимальных и максимальных оценок, используемых при вычислении оценок в журнале оценок. Рекомендуется исправить эти несоответствия, нажав на кнопку ниже, хотя это приведет к тому, что некоторые оценки изменятся.';
$string['missingitemtypeoreid'] = 'Ключ массива (itemtype или eid) не указан';
$string['missingscale'] = 'Необходимо выбрать шкалу';
$string['mode'] = 'Мода';
$string['modgrade'] = 'Оценка';
$string['modgrade_help'] = '* Балл - числовое значение
* Нет - только отзыв
* Шкала - элемент из списка';
$string['modgradecantchangegradetype'] = 'Вы не можете изменить тип, так как для этого элемента уже имеются оценки.';
$string['modgradecantchangegradetypemsg'] = 'Некоторые оценки уже были выставлены, поэтому тип оценки не может быть изменен. Если Вы хотите изменить максимальную оценку, то сначала нужно указать, хотите ли Вы или нет пересчитать существующие оценки по этой шкале.';
$string['modgradecantchangegradetyporscalemsg'] = 'Некоторые оценки уже были выставлены, поэтому тип оценки и шкала не могут быть изменены.';
$string['modgradecantchangeratingmaxgrade'] = 'Вы не можете изменить максимальную оценку, когда уже выставлены оценки для оцениваемого элемента.';
$string['modgradecantchangescale'] = 'Вы не можете изменить шкалу, так как оценки для этого элемента уже были выставлены.';
$string['modgradecategorycantchangegradetypemsg'] = 'Эта категория связана с оцениваемыми элементами, которые были переопределены. Некоторые оценки уже поставлены, поэтому тип оценки не может быть изменен. Если Вы хотите изменить максимальную оценку, то сначала надо определить, будут ли пересчитаны имеющиеся оценки.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'В этой категории есть связанные элементы оценивания, которые были переопределены. Поэтому некоторые оценки уже были выставлены, так что тип оценки и шкала не могут быть изменены.';
$string['modgradecategoryrescalegrades'] = 'Пересчитать переопределенные оценки по измененной шкале';
$string['modgradecategoryrescalegrades_help'] = 'При изменении максимальных оценок в элементе журнала оценок Вы должны указать, должно ли это также привести к изменению существующей оценки в процентах.

Если этот параметр установлен в «Да», то все существующие переопределенные оценки будут пересчитаны по измененной шкале так, что оценка в процентах останется прежней.

Например, если параметр установлен в «Да», изменение максимальной оценки по элементу с 10 до 20 приведет к пересчету оценки 6/10 (60%)  в оценку 12/20 (60%). Если этот параметр установлен в «Нет», оценка останется без изменений, и потребуется ручное исправление оцениваемых элементов, чтобы убедиться в корректности оценок.';
$string['modgradedonotmodify'] = 'Не менять существующие оценки';
$string['modgradeerrorbadpoint'] = 'Неправильное значение оценки. Она должна быть целым числом от 1 до {$a}';
$string['modgradeerrorbadscale'] = 'Выбрана неверная шкала. Пожалуйста, убедитесь, что Вы выбираете шкалу из нижеуказанных.';
$string['modgrademaxgrade'] = 'Максимальная оценка';
$string['modgraderescalegrades'] = 'Пересчитать существующие оценки по измененной шкале';
$string['modgraderescalegrades_help'] = 'При изменении максимальных оценок в элементе журнала оценок Вы должны указать, должно ли это также привести к изменению существующей оценки в процентах.

Если этот параметр установлен в «Да», то все существующие оценки будут пересчитаны по измененной шкале так, что оценка в процентах останется прежней.

Например, если параметр установлен в «Да», изменение максимальной оценки за элемент с 10 до 20 приведет к пересчету оценки 6/10 (60%) в оценку 12/20 (60%). Если этот параметр установлен в «Нет», то оценка изменится с 6/10 (60%) на 6/20 (30%), и потребуется ручное исправление оцениваемых элементов, чтобы убедиться в корректности оценок.';
$string['modgradetype'] = 'Тип';
$string['modgradetypenone'] = 'Отсутствует';
$string['modgradetypepoint'] = 'Балл';
$string['modgradetypescale'] = 'Шкала';
$string['morethanmax'] = 'Оценка, введенная за элемент «{$a->itemname}» для пользователя «{$a->username}» больше, чем допустимый максимум.';
$string['moveselectedto'] = 'Переместить выбранные элементы в:';
$string['movesitems'] = 'Переместить элементы';
$string['movingelement'] = 'Перемещение «{$a}»';
$string['multfactor'] = 'Коэффициент';
$string['multfactor_help'] = 'Коэффициент, на который будут умножены все оценки этого оцениваемого элемента до достижения максимального значения оценки. Например, если коэффициент равен 2, а максимальная оценка 100, то все оценки менее 50 умножаются на 2, а все оценки от 50 и выше изменяются на 100.';
$string['multfactorvalue'] = 'Множитель для {$a}';
$string['mustchooserescaleyesorno'] = 'Вы должны выбрать, нужно ли выполнять пересчет существующих оценок по измененной шкале.';
$string['mygrades'] = 'Ссылка на оценки в меню пользователя';
$string['mygrades_desc'] = 'Этот параметр позволяет указывать ссылку на внешний журнал оценок из меню пользователя.';
$string['mypreferences'] = 'Мои настройки';
$string['myreportpreferences'] = 'Мои настройки отчета';
$string['myself'] = 'самого себя';
$string['neverdeletehistory'] = 'Никогда не удалять историю';
$string['newcategory'] = 'Новая категория';
$string['newitem'] = 'Новый элемент оценивания';
$string['newoutcomeitem'] = 'Новый элемент показателя';
$string['no'] = 'Нет';
$string['nocategories'] = 'Не удалось добавить или найти категории для данного курса';
$string['nocategoryname'] = 'Не задано название категории.';
$string['nocategoryview'] = 'Нет категорий для отображения';
$string['nocourses'] = 'Пока еще нет ни одного курса';
$string['noexistingoutcomes'] = 'Показатели отсутствуют.';
$string['noexistingscales'] = 'Шкалы отсутствуют.';
$string['noforce'] = 'Не устанавливать принудительно';
$string['nogradeletters'] = 'Буквенные оценки не заданы';
$string['nogradesreturned'] = 'Нет оценок';
$string['noidnumber'] = 'Нет значения ID';
$string['nolettergrade'] = 'Нет буквенных оценок для';
$string['nomode'] = 'Н/О';
$string['nonnumericweight'] = 'Получено нечисловое значение для';
$string['nonunhideableverbose'] = 'Чтобы отобразить эту оценку, вам нужно отобразить {$a->itemname}.';
$string['nonunlockableverbose'] = 'Чтобы разблокировать эту оценку, вам нужно разблокировать элемент «{$a->itemname}».';
$string['nonweightedpct'] = 'невзвешенный %';
$string['nooutcome'] = 'Нет показателя';
$string['nooutcomes'] = 'Оценка за показатель должна быть привязана к одному из показателей курса, но в курсе не определено ни одного показателя. Вы хотите добавить показатель?';
$string['nopermissiontoresetweights'] = 'Нет разрешения на изменение веса';
$string['nopublish'] = 'Не публиковать';
$string['noreports'] = 'Вы не учитесь и не преподаете ни на одном из курсов на этом сайте.';
$string['norolesdefined'] = 'Нет ролей, определенных в Администрирование > Оценки > Общие настройки > Оцениваемые роли';
$string['noscales'] = 'Показатели должны быть привязаны к шкале курса или к глобальной шкале, но ни одной не существует. Вы хотите добавить шкалу?';
$string['noselectedcategories'] = 'не выбрано ни одной категории.';
$string['noselecteditems'] = 'не выбран ни один элемент.';
$string['notenrolled'] = 'Сейчас Вы не записаны ни на один курс.';
$string['notteachererror'] = 'Для использования этой функции Вы должны быть преподавателем.';
$string['nousersloaded'] = 'Не загружено ни одного пользователя';
$string['nouserstograde'] = 'Нечего оценивать';
$string['numberofgrades'] = 'Количество оценок';
$string['onascaleof'] = 'по шкале от {$a->grademin} до {$a->grademax}';
$string['operations'] = 'Операции';
$string['options'] = 'Параметры';
$string['others'] = 'Другие';
$string['otheruser'] = 'пользователя';
$string['outcome'] = 'Показатель';
$string['outcome_help'] = 'Этот параметр определяет, результат по какому из показателей будет представлен в журнале оценок для этого элемента оценивания.';
$string['outcomeassigntocourse'] = 'Назначить другой показатель для этого курса';
$string['outcomecategory'] = 'Создать показатели в категории';
$string['outcomecategorynew'] = 'Новая категория';
$string['outcomeconfirmdelete'] = 'Вы уверены, что хотите удалить показатель «{$a}»?';
$string['outcomecreate'] = 'Добавить новый показатель';
$string['outcomedelete'] = 'Удалить показатель';
$string['outcomefullname'] = 'Полное название';
$string['outcomeitem'] = 'Элемент показателя';
$string['outcomeitemsedit'] = 'Редактировать элемент показателя';
$string['outcomereport'] = 'Отчет по показателям';
$string['outcomes'] = 'Показатели';
$string['outcomescourse'] = 'Показатели, используемые в курсе';
$string['outcomescoursecustom'] = 'Локальные используемые (нельзя удалить)';
$string['outcomescoursenotused'] = 'Стандартные неиспользуемые';
$string['outcomescourseused'] = 'Стандартные используемые (нельзя удалить)';
$string['outcomescustom'] = 'Локальные показатели';
$string['outcomesdisabled'] = 'Показатели отключены';
$string['outcomeshortname'] = 'Краткое название';
$string['outcomesstandard'] = 'Стандартные показатели';
$string['outcomesstandardavailable'] = 'Доступные стандартные показатели';
$string['outcomestandard'] = 'Стандартный показатель';
$string['outcomestandard_help'] = 'Стандартный показатель доступен на всём сайте, во всех курсах.';
$string['overallaverage'] = 'Общее среднее';
$string['overridden'] = 'Переопределена';
$string['overridden_help'] = 'Если установлена отметка, то оценка больше не может быть изменена связанным элементом курса.

Когда оценка редактируется в журнале оценок, поле «Переопределена» отмечается автоматически. Однако эта отметка может быть снята, чтобы позволить изменять оценку из соответствующего элемента курса.';
$string['overriddennotice'] = 'Ваша итоговая оценка за этот элемента курса была скорректирована вручную.';
$string['overridecat'] = 'Разрешить переопределение вручную оценок категории';
$string['overridecat_help'] = 'Отключение этого параметра делает невозможным переопределение оценок категории.';
$string['overridesitedefaultgradedisplaytype'] = 'Разрешить переопределять настройки сайта по умолчанию';
$string['overridesitedefaultgradedisplaytype_help'] = 'Если установлена отметка, то помимо установленных на сайте, в курсе можно задавать собственные границы для буквенных оценок.';
$string['overrideweightofa'] = 'Переопределить вес для «{$a}»';
$string['parentcategory'] = 'Родительская категория';
$string['pass'] = 'Пройдено';
$string['pctoftotalgrade'] = '% итоговой<br />оценки';
$string['percent'] = 'Проценты';
$string['percentage'] = 'Проценты';
$string['percentageletter'] = 'Процент (буква)';
$string['percentagereal'] = 'Процент (значение)';
$string['percentascending'] = 'Сортировать по возрастанию процентов';
$string['percentdescending'] = 'Сортировать по убыванию процентов';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Прибавка';
$string['plusfactor_help'] = 'Число, которое будет добавлено к каждой оценке этого элемента после умножения на коэффициент.';
$string['plusfactorvalue'] = 'Недопустимое значение для {$a}';
$string['points'] = 'Баллы<br />';
$string['pointsascending'] = 'Сортировать по возрастанию баллов';
$string['pointsdescending'] = 'Сортировать по убыванию баллов';
$string['positionfirst'] = 'В начале';
$string['positionlast'] = 'В конце';
$string['preferences'] = 'Настройки';
$string['prefgeneral'] = 'Основные';
$string['prefletters'] = 'Буквы и границы оценок';
$string['prefrows'] = 'Специальные столбцы';
$string['prefshow'] = 'Показать/спрятать переключатели';
$string['previewrows'] = 'Строк предпросмотра';
$string['privacy:metadata:categorieshistory'] = 'Запись предыдущих версий категорий оценок';
$string['privacy:metadata:filepurpose'] = 'Файлы обратной связи хранятся в журнале оценок для пользователя.';
$string['privacy:metadata:grade_import_newitem'] = 'Временная таблица для хранения новых имен элементов оценивания из импорта оценок';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Уникальный код пакета для идентификации одного пакета импорта';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Пользователь, импортирующий данные';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Новое имя элемента оценивания';
$string['privacy:metadata:grade_import_values'] = 'Временная таблица для импорта оценок';
$string['privacy:metadata:grade_import_values:feedback'] = 'Отзыв к оценке';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Сырое значение оценки';
$string['privacy:metadata:grade_import_values:importcode'] = 'Уникальный код пакета для идентификации одного пакета импорта';
$string['privacy:metadata:grade_import_values:importer'] = 'Пользователь, импортирующий данные';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Отмечено, если импортированы только отзывы';
$string['privacy:metadata:grade_import_values:userid'] = 'Пользователь, чья оценка была импортирована';
$string['privacy:metadata:grades'] = 'Запись оценок';
$string['privacy:metadata:grades:aggregationstatus'] = 'Статус итоговой оценки';
$string['privacy:metadata:grades:aggregationweight'] = 'Вес в итоговой оценке';
$string['privacy:metadata:grades:feedback'] = 'Отзыв';
$string['privacy:metadata:grades:finalgrade'] = 'Оценка';
$string['privacy:metadata:grades:information'] = 'Дополнительная информация об оценке';
$string['privacy:metadata:grades:timemodified'] = 'Время последнего изменения оценки';
$string['privacy:metadata:grades:userid'] = 'ID пользователя, которому поставлена оценка';
$string['privacy:metadata:grades:usermodified'] = 'ID пользователя, который последним изменял запись';
$string['privacy:metadata:gradeshistory'] = 'Запись предыдущих оценок';
$string['privacy:metadata:history:loggeduser'] = 'ID пользователя, который был авторизован при появлении версий';
$string['privacy:metadata:history:timemodified'] = 'Время, когда произошла версия оценки';
$string['privacy:metadata:itemshistory'] = 'Запись предыдущих версий элементов оценивания';
$string['privacy:metadata:outcomes'] = 'Запись показателей';
$string['privacy:metadata:outcomes:timemodified'] = 'Время изменения записи';
$string['privacy:metadata:outcomes:usermodified'] = 'Пользователь, последним изменявший запись';
$string['privacy:metadata:outcomeshistory'] = 'Запись предыдущих версий показателей';
$string['privacy:metadata:scale'] = 'Запись шкал';
$string['privacy:metadata:scale:timemodified'] = 'Время последнего изменения записи';
$string['privacy:metadata:scale:userid'] = 'Пользователь, последним изменявший запись';
$string['privacy:metadata:scalehistory'] = 'Запись предыдущих версий шкал';
$string['privacy:path:relatedtome'] = 'Связанные со мной';
$string['privacy:request:historyactiondelete'] = 'Удалить';
$string['privacy:request:historyactioninsert'] = 'Вставить';
$string['privacy:request:historyactionupdate'] = 'Обновить';
$string['privacy:request:unknowndeletedgradeitem'] = 'Неизвестно (элемент оценивания был удален)';
$string['profilereport'] = 'Отчет по профилю пользователя';
$string['profilereport_help'] = 'Отчет об оценках, используемый на странице профиля';
$string['publishing'] = 'Публикация';
$string['publishingoptions'] = 'Параметры опубликования оценки';
$string['quickfeedback'] = 'Быстрый отзыв';
$string['quickgrading'] = 'Режим быстрой оценки';
$string['quickgrading_help'] = 'Если включен режим быстрой оценки, то при редактировании для каждой оценки отображается поле ввода, что позволяет одновременно редактировать несколько оценок. Изменения сохраняются при нажатии кнопки «Обновить».

Имейте в виду, что когда оценка редактируется в журнале оценок, то устанавливается флаг «Переопределена», это означает, что оценка больше не может быть изменена связанным элементом курса.';
$string['range'] = 'Диапазон';
$string['rangedecimals'] = 'Десятичных знаков для диапазона';
$string['rangedecimals_help'] = 'Количество десятичных знаков при отображении диапазона.';
$string['rangesdecimalpoints'] = 'Отображать десятичных знаков для диапазонов';
$string['rangesdecimalpoints_help'] = 'Этот параметр определяет количество десятичных знаков при отображении каждого диапазона. Также возможно использовать параметры, установленные для родительской категории или элемента (наследование).';
$string['rangesdisplaytype'] = 'Формат представления диапазона';
$string['rangesdisplaytype_help'] = 'Этот параметр определяет, будет ли диапазон отображаться в виде числовых оценок, процентов или букв. Также можно использовать (унаследовать) значение, установленное для родительской категории или элемента.';
$string['rank'] = 'Место';
$string['rawpct'] = '% выпол-<br />нения';
$string['real'] = 'Значение';
$string['realletter'] = 'Значение (буква)';
$string['realpercentage'] = 'Значение (процент)';
$string['recalculatinggrades'] = 'Пересчет оценок';
$string['recovergradesdefault'] = 'По умолчанию восстанавливать оценки';
$string['recovergradesdefault_help'] = 'По умолчанию восстанавливать старые оценки при повторной записи пользователя на курс';
$string['refreshpreview'] = 'Обновить предварительный просмотр';
$string['regradeanyway'] = 'Переоценить в любом случае';
$string['removeallcoursegrades'] = 'Удалить все оценки';
$string['removeallcoursegrades_help'] = 'При установленном флажке все элементы оценки, вручную добавленные в журнал оценок, будут удалены вместе с оценками и данными, относящимися к переопределенным, исключенным, скрытым и заблокированным оценкам. Останутся только оценки, связанные с элементами курса.';
$string['removeallcourseitems'] = 'Удалить все элементы и категории';
$string['removeallcourseitems_help'] = 'При установленном флажке все категории и элементы оценки, вручную добавленные в журнал оценок, будут удалены вместе с оценками и данными, относящимися к переопределенным, исключенным, скрытым и заблокированным оценкам. Останутся только оценки, связанные с элементами курса.';
$string['report'] = 'Отчет';
$string['reportdefault'] = 'По умолчанию ({$a})';
$string['reportplugins'] = 'Плагины отчетов';
$string['reportsettings'] = 'Настройки отчетов';
$string['reprintheaders'] = 'Повтор заголовков';
$string['resetweights'] = 'Сбросить вес - {$a->itemname}';
$string['resetweightsshort'] = 'Сбросить вес';
$string['respectingcurrentdata'] = 'не изменять текущую конфигурацию';
$string['rowpreviewnum'] = 'Строк предпросмотра';
$string['rowpreviewnum_help'] = 'Данные для импорта можно предварительно просмотреть перед началом процедуры импорта. Этот параметр определяет, сколько строк будет показываться в предварительном просмотре.';
$string['savechanges'] = 'Сохранить изменения';
$string['savepreferences'] = 'Сохранить настройки';
$string['scaleconfirmdelete'] = 'Вы уверены, что хотите удалить шкалу «{$a}»?';
$string['scaledpct'] = 'Масштабируемый %';
$string['searchcollapsedcolumns'] = 'Поиск свернутых столбцов';
$string['seeallcoursegrades'] = 'Просмотреть все оценки курса';
$string['select'] = 'Выберите {$a}';
$string['selectalloroneuser'] = 'Выберите одного или всех пользователей';
$string['selectauser'] = 'Выберите пользователя';
$string['selectdestination'] = 'Выбрать назначение для «{$a}»';
$string['selectgrouplink'] = 'Выберите группу';
$string['selectuserlink'] = 'Выберите пользователя';
$string['separator'] = 'Разделитель';
$string['separator_help'] = 'Выберите разделитель, используемый в файле CSV (обычно это запятая).';
$string['sepcolon'] = 'Двоеточие';
$string['sepcomma'] = 'Запятая';
$string['sepsemicolon'] = 'Точка с запятой';
$string['septab'] = 'Табуляция';
$string['setcategories'] = 'Задать категории';
$string['setcategorieserror'] = 'Вы должны сначала установить категории для своего курса, а потом уже задать им вес.';
$string['setgradeletters'] = 'Задать буквенные оценки';
$string['setpreferences'] = 'Настройки';
$string['setting'] = 'Установка';
$string['settings'] = 'Настройки';
$string['setup'] = 'Настройки';
$string['setweights'] = 'Задать веса';
$string['showactivityicons'] = 'Показывать значки элементов курса';
$string['showactivityicons_help'] = 'Если параметр включен, то значки рядом с названиями элементов курса отображаются соответствующие значки.';
$string['showallgrades'] = 'Показать все оценки';
$string['showallhidden'] = 'Отображать скрытые';
$string['showallstudents'] = 'Отобразить всех студентов';
$string['showanalysisicon'] = 'Отображать значок анализа оценок';
$string['showanalysisicon_desc'] = 'Показывать ли по умолчанию значок анализа оценки. Если модуль элемента курса позволяет это, то ссылка значка анализа оценки будет вести на страницу с более подробной информацией о полученной оценке.';
$string['showanalysisicon_help'] = 'Если модуль элемента курса позволяет это, то ссылка значка анализа оценки будет вести на страницу с более подробной информацией о полученной оценке.';
$string['showaverage'] = 'Отображать среднее';
$string['showaverage_help'] = 'Показывать среднее значение столбца? Студенты могут предположить оценки других студентов, если среднее значение рассчитывается исходя из небольшого количества оценок. Для повышения производительности среднее вычисляется приблизительно, если оно зависит от скрытых элементов.';
$string['showaverages'] = 'Отображать средние значения столбцов';
$string['showaverages_help'] = 'Если параметр включен, журнал оценок будет содержать дополнительные строки со средними значениями для каждой категории и элемента.';
$string['showcalculations'] = 'Отображать вычисления';
$string['showcalculations_help'] = 'Если параметр включен, то при редактировании у элементов и категорий может отображается значок калькулятора, который свидетельствует о том, что оценка является вычисляемой.';
$string['showcontributiontocoursetotal'] = 'Отображать вклад в итоговую оценку';
$string['showcontributiontocoursetotal_help'] = 'Показывать ли дополнительный столбец, содержащий рассчитанный вклад каждого из элементов (с учетом весовых коэффициентов) в итоговую оценку?';
$string['showeyecons'] = 'Отображать значки «показать/скрыть»';
$string['showeyecons_help'] = 'Если параметр включен, то при редактировании у каждой оценки отображается значок «показать/скрыть» для управления ее отображением для студента.';
$string['showfeedback'] = 'Отображать отзыв';
$string['showfeedback_help'] = 'Показать столбец отзыва?';
$string['showgrade'] = 'Отображать оценки';
$string['showgrade_help'] = 'Показать столбец оценок?';
$string['showgroups'] = 'Показать группы';
$string['showhiddenitems'] = 'Показ скрытых элементов';
$string['showhiddenitems_help'] = 'Скрывать ли и названия, и оценки для скрытых элементов, или же скрывать только оценки, а названия отображать.

* Отображать скрытые - названия скрытых элементов отображаются, но оценки студентов скрыты.
* Только скрытые до - элементы с установленной датой «Скрыть до» будут полностью скрыты до установленной даты, после чего весь элемент будет отображаться.
* Не отображать - скрытые элементы будут полностью скрыты.';
$string['showhiddenuntilonly'] = 'Только скрытые до';
$string['showingaggregatesonly'] = 'Отображаются только итоги';
$string['showingfullmode'] = 'Отображаются оценки и итоги';
$string['showinggradesonly'] = 'Отображаются только оценки';
$string['showlettergrade'] = 'Отображать буквенные оценки';
$string['showlettergrade_help'] = 'Показывать столбец буквенных оценок?';
$string['showlocks'] = 'Отображать блокировки';
$string['showlocks_help'] = 'Если включено, то при редактировании у каждой оценки отображается значок «заблокировано/разблокировано» для управления - может ли оценка автоматически обновляться соответствующим элементом.';
$string['shownohidden'] = 'Не отображать';
$string['shownooutcomes'] = 'Скрыть показатели';
$string['shownumberofgrades'] = 'Показать количество оценок в средних';
$string['shownumberofgrades_help'] = 'Если включено, то количество оценок, используемых для расчета среднего значения отображается в скобках после каждого среднего.';
$string['showonlyactiveenrol'] = 'Показывать только активных учащихся';
$string['showonlyactiveenrol_help'] = 'Этот параметр определяет, будут ли видны в журнале оценок только активные зачисленные пользователи. При включенном параметре приостановленные пользователи не будут отображаться в журнале оценок.';
$string['showpercentage'] = 'Отображать проценты';
$string['showpercentage_help'] = 'Показывать значение в процентах для каждого элемента оценивания?';
$string['showquickfeedback'] = 'Отображать быстрый отзыв';
$string['showquickfeedback_help'] = 'Если разрешено, то при редактировании к каждой оценке добавляется поле с пунктирной границей для ввода текста отзыва, что позволяет одновременно редактировать отзывы для нескольких оценок. Изменения сохраняются при нажатии кнопки «Обновить».

Учтите, что когда отзыв редактируется в журнале оценок, то для оценки устанавливается флаг «Переопределена», это означает, что оценка больше не может быть изменена связанным элементом курса.';
$string['showrange'] = 'Отображать диапазон';
$string['showrange_help'] = 'Показывать столбец для диапазона?';
$string['showranges'] = 'Отображать диапазоны';
$string['showranges_help'] = 'Если параметр включен, то журнал оценок будет содержать дополнительные строки с диапазоном значений для всех категорий и элементов.';
$string['showrank'] = 'Отображать рейтинг';
$string['showrank_help'] = 'Показывать для каждого элемента  оценивания положение студента по отношению к другим участникам курса?';
$string['showuserimage'] = 'Выводить изображения пользователей';
$string['showuserimage_help'] = 'Показывать ли в журнале оценок изображение пользователя рядом с его именем.';
$string['showverbose'] = 'Показать {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Отображать вес каждой оценки';
$string['showweight_help'] = 'Показывать столбец «Вес оценки»?';
$string['simpleview'] = 'Простой вид';
$string['sitewide'] = 'По всему сайту';
$string['sort'] = 'сортировка';
$string['sortasc'] = 'Сортировать по возрастанию';
$string['sortbyfirstname'] = 'Сортировать по имени';
$string['sortbylastname'] = 'Сортировать по фамилии';
$string['sortdesc'] = 'Сортировать по убыванию';
$string['standarddeviation'] = 'Стандартное отклонение';
$string['stats'] = 'Статистика';
$string['statslink'] = 'Стат.';
$string['student'] = 'Студент';
$string['studentsperpage'] = 'Студентов на странице';
$string['studentsperpage_help'] = 'Этот параметр определяет количество студентов,  отображаемых на одной странице в журнале оценок.';
$string['studentsperpagereduced'] = 'Снизьте максимальное количество студентов на страницу с {$a->originalstudentsperpage} до {$a->studentsperpage}. Рассмотрите возможность увеличения настройки PHP max_input_vars до {$a->maxinputvars}.';
$string['subcategory'] = 'Нормальная категория';
$string['submissions'] = 'Представления';
$string['submittedon'] = 'Представлено: {$a}';
$string['sumofgradesupgradedgrades'] = 'Обратите внимание: Метод «Сумма оценок» был изменен на «Естественный» в процессе обновления сайта. Поскольку «Сумма оценок» ранее использовалась в этом курсе, рекомендуется просмотреть это изменение в журнале оценок.';
$string['switchtofullview'] = 'Переключиться к полному виду';
$string['switchtosimpleview'] = 'Переключиться к простому виду';
$string['topcategory'] = 'Верхняя категория';
$string['total'] = 'Итого';
$string['totalweight100'] = 'Общий вес равен 100';
$string['totalweightnot100'] = 'Общий вес не равен 100';
$string['turnfeedbackoff'] = 'Выключить отзыв';
$string['turnfeedbackon'] = 'Включить отзыв';
$string['typenone'] = 'Не оценивается';
$string['typescale'] = 'Шкала';
$string['typescale_help'] = 'Этот параметр определяет шкалу, которая будет использоваться в случае, если параметр «Тип оценки» установлен в значение «Шкала». Шкала для оценок, связанных с элементами курса устанавливается на странице настройки элемента курса.';
$string['typetext'] = 'Текст';
$string['typevalue'] = 'Значение';
$string['uncategorised'] = 'Без категории';
$string['unchangedgrade'] = 'Оценка не изменена';
$string['unenrolledusersinimport'] = 'Этот импорт включает следующие оценки для пользователей, не записанных в настоящее время на этот курс: {$a}';
$string['unlimitedgrades'] = 'Неограниченные оценки';
$string['unlimitedgrades_help'] = 'По умолчанию оценки ограничены максимальным и минимальным значениями оценки конкретного элемента. Включение данного параметра снимает это ограничение, и позволяет вводить оценки более 100% непосредственно в журнал оценок.';
$string['unlock'] = 'Разблокировать';
$string['unlockverbose'] = 'Разблокировать {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Не используется';
$string['updatedgradesonly'] = 'Экспортировать только новые или обновленные оценки';
$string['upgradedgradeshidemessage'] = 'Убрать уведомление';
$string['upgradedminmaxrevertmessage'] = 'Откатить изменения';
$string['uploadgrades'] = 'Загрузить шкалы';
$string['useadvanced'] = 'Использовать дополнительные возможности';
$string['usedcourses'] = 'Используемые курсы';
$string['usedgradeitem'] = 'Используемый элемент оценивания';
$string['usenooutcome'] = 'Не использовать показатели';
$string['usenoscale'] = 'Не использовать шкалу';
$string['usepercent'] = 'Использовать проценты';
$string['user'] = 'Пользователь';
$string['userenrolmentsuspended'] = 'Действие зачисления пользователя на курс заблокировано';
$string['userfields_show'] = 'Показать пользовательские поля';
$string['userfields_show_help'] = 'Показать дополнительные пользовательские поля (например, адрес электронной почты) в отчете оценщика. Отображаемые конкретные поля определяются параметром сайта «showuseridentity».';
$string['usergrade'] = 'Пользователь «{$a->fullname}» ({$a->useridnumber}), элемент {$a->gradeidnumber}';
$string['userid'] = 'ID пользователя';
$string['useridnumberwarning'] = 'Пользователи, не имеющие идентификационного номера, исключаются из экспорта, поскольку они не смогут быть импортированы';
$string['usermappingerror'] = 'Ошибка соответствия пользователя: Не удалось найти пользователя с полем {$a->field}, имеющим значение «{$a->value}».';
$string['usermappingerrorcurrentgroup'] = 'Пользователь не является участником текущей группы.';
$string['usermappingerrormultipleusersfound'] = 'Ошибка сопоставления пользователей: найдено несколько пользователей с полем {$a->field} со значением «{$a->value}». Пожалуйста, используйте более уникальное поле сопоставления.';
$string['usermappingerrorusernotfound'] = 'Ошибка соответствия пользователя: Не удалось найти пользователя.';
$string['userpreferences'] = 'Мои настройки';
$string['useweighted'] = 'Использовать веса';
$string['verbosescales'] = 'Многословные шкалы';
$string['verbosescales_help'] = 'Многословная шкала использует слова вместо чисел. Установите  «Да», если должны быть импортированы числовые и многословные шкалы. Установите «Нет», если должны быть импортированы только числовые шкалы.';
$string['viewas'] = 'Просмотр отчета от лица';
$string['viewbygroup'] = 'Группа';
$string['viewfeedback'] = 'Посмотреть отзыв';
$string['viewgrades'] = 'Просмотр оценок';
$string['weight'] = 'Вес';
$string['weight_help'] = 'Значение используется для определения относительного вклада нескольких элементов оценки в категорию или курс.';
$string['weightcourse'] = 'Использовать взвешенные оценки для курса';
$string['weightedascending'] = 'Сортировать по возрастанию взвешенной суммы';
$string['weighteddescending'] = 'Сортировать по убыванию взвешенной суммы';
$string['weightedpct'] = 'взвешенный %';
$string['weightedpctcontribution'] = 'Взвешенный вклад';
$string['weightofa'] = 'Вес {$a}';
$string['weightorextracredit'] = 'Вес или дополнительный балл';
$string['weightoverride'] = 'корректировка весов';
$string['weightoverride_help'] = 'Отключите для изменения веса данного элемента оценки на автоматически рассчитанное значение. Включение  этого параметра предотвратит автоматическую корректировку веса.';
$string['weights'] = 'Весовые коэффициенты';
$string['weightsadjusted'] = 'Ваши веса были откорректированы так, чтобы в сумме они составили 100.';
$string['weightsedit'] = 'Редактировать весовые коэффициенты и дополнительные баллы';
$string['weightuc'] = 'Рассчитанный вес';
$string['writinggradebookinfo'] = 'Запись настроек Журнала оценок';
$string['xml'] = 'XML';
$string['yes'] = 'Да';
$string['yourgrade'] = 'Ваша оценка';
