<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'tr', version '4.5'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Eylemler';
$string['activate'] = 'Erişimi etkin kıl';
$string['activatesuccess'] = '\'{$a}\' rozetine erişim etkinleştirildi.';
$string['addalignment'] = 'Harici beceri veya standart ekleyin';
$string['addbadge'] = 'Rozet ekle';
$string['addbadge_help'] = 'Bu rozet gereksinimine eklenmesi gereken tüm rozetleri seçin. Birden çok öğe seçmek için CTRL tuşunu basılı tutun.';
$string['addbadgecriteria'] = 'Rozet ölçütü ekle';
$string['addcohort'] = 'Topluluk ekle';
$string['addcohort_help'] = 'Bu rozet gereksinimine eklenmesi gereken tüm topluluk seçin. Birden çok öğe seçmek için CTRL tuşunu basılı tutun.';
$string['addcompetency'] = 'Yetkinlik ekle';
$string['addcompetency_help'] = 'Bu rozet gereksinimine eklenmesi gereken tüm yetkinlikleri seçin. Birden çok öğe seçmek için CTRL tuşunu basılı tutun.';
$string['addcourse'] = 'Kurs ekle';
$string['addcourse_help'] = 'Bu rozet gerekliliğine eklenmesi gereken tüm kursları seçin. Birden fazla öğe seçmek için CTRL tuşunu basılı tutun.';
$string['addcriteria'] = 'Ölçütü ekle';
$string['addcriteriatext'] = 'Ölçütleri eklemeye başlamak için açılır menüdeki seçeneklerden birini seçiniz';
$string['addcriterion'] = 'Kriter ekle';
$string['addedtobackpack'] = 'Rozet paketine rozet eklendi';
$string['addrelated'] = 'İlgili rozeti ekleyin';
$string['addtobackpack'] = 'Rozet paketine ekle';
$string['adminonly'] = 'Bu sayfa sadece site yöneticileri ile kısıtlanmıştır.';
$string['after'] = 'yayın tarihinden sonra';
$string['aggregationmethod'] = 'Toplama yöntemi';
$string['alignment'] = 'Hizalanma';
$string['all'] = 'Tüm';
$string['allmethod'] = 'Seçilen tüm koşullar sağlanıyor';
$string['allmethodactivity'] = 'Seçilen tüm etkinlikler tamanlanmış';
$string['allmethodbadges'] = 'Seçilen tüm rozetler kazanıldı';
$string['allmethodcohort'] = 'Seçilen tüm gruplara üyelik';
$string['allmethodcompetencies'] = 'Seçilen tüm yetkinlikler tamamlandı';
$string['allmethodcourseset'] = 'Seçilen tüm kurslar tamamlanmış';
$string['allmethodmanual'] = 'Seçilen tüm roller rozeti ödüllendiriyor';
$string['allmethodprofile'] = 'Seçilen profil alanlarının hepsi tamamlandı';
$string['allowcoursebadges'] = 'Kurs rozetlerini etkinleştir';
$string['allowcoursebadges_desc'] = 'Kurs içinde rozet yaratmaya ve vermeye izin ver';
$string['allowexternalbackpack'] = 'Harici rozet paketi bağlantısı';
$string['allowexternalbackpack_desc'] = 'Etkinleştirilirse, kullanıcılar harici bir rozet paketine bağlanabilir ve bu siteden rozetlerini paylaşabilir. Kullanıcılar ayrıca bu sitedeki profil sayfalarında harici rozet paketinden herhangi bir genel rozet koleksiyonunu görüntülemeyi seçebilirler. Sitenize internetten erişilemiyorsa bu seçeneği devre dışı bırakmanız önerilir.';
$string['any'] = 'Herhangi';
$string['anymethod'] = 'Seçilen koşulların herhangi biri (ya da birden fazlası) sağlanıyor';
$string['anymethodactivity'] = 'Seçilen etkinlerin herhangi biri (ya da fazlası) tamamlandı';
$string['anymethodbadges'] = 'Seçilen rozetlerden herhangi biri kazanıldı';
$string['anymethodcohort'] = 'Seçilen gruplardan herhangi birinde üyelik';
$string['anymethodcompetencies'] = 'Seçilen yetkinliklerden herhangi biri tamamlandı';
$string['anymethodcourseset'] = 'Seçilen kurslardan bir veya daha fazlası tamamlanmış';
$string['anymethodmanual'] = 'Seçilen rollerden herhangi biri rozeti ödüllendirir';
$string['anymethodprofile'] = 'Seçilen profil alanlarından herhangi biri tamamlandı';
$string['apiversion'] = 'API sürümü desteklenir';
$string['archivebadge'] = '\'{$a}\' adlı rozeti silmek, ancak varolan rozetleri silecek silmek ister misiniz?';
$string['archiveconfirm'] = 'Mevcut rozetleri sil ve saklamaya devam et';
$string['archivehelp'] = '<p>Bu seçenek, rozetin " kullanımdan kaldırıldı" olarak işaretleneceği ve artık rozet listesinde görünmeyeceği anlamına gelir. Kullanıcılar artık bu rozeti kazanamayacak, ancak mevcut rozet alıcıları bu rozeti profil sayfalarında görüntülemeye ve harici rozet paketlerine göndermeye devam edebilecekler.</p>';
$string['attachment'] = 'Rozete mesaj ekle';
$string['attachment_help'] = 'Etkinleştirilirse, alıcının e-postasına indirilmek üzere verilen bir rozet eklenecektir. (Bu seçeneği kullanmak için Ekler Site yönetimi / Sunucu / E-posta / Giden posta yapılandırmasında etkinleştirilmelidir.)';
$string['award'] = 'Rozet ver';
$string['awardedto'] = '{$a}\'a verildi';
$string['awardedtoyou'] = 'Bana atanan';
$string['awardoncron'] = 'Çok sayıda kullanıcıya \'{$a->badgename}\' rozeti veriliyor. Tüm kullanıcıların bunu alması biraz zaman alabilir.';
$string['awards'] = 'Alıcılar';
$string['backpackapiurl'] = 'Sırt Çantası API URL\'si';
$string['backpackavailability'] = 'Harici rozet doğrulama';
$string['backpackavailability_help'] = 'Rozet alıcılarının rozetlerini sizden aldıklarını kanıtlayabilmeleri için, harici bir badges hizmetinin sitenize erişebilmesi ve sitenizden verilen rozetleri doğrulayabilmesi gerekir. Siteniz şu anda erişilebilir görünmüyor, bu da daha önce vermiş olduğunuz veya gelecekte yayınlayacağınız rozetlerin doğrulanamayacağı anlamına gelir.

**Neden bu mesajı görüyorum?**

Güvenlik duvarınız ağınız dışındaki kullanıcıların erişimini engelliyor olabilir, siteniz parola korumalı olabilir veya siteyi İnternet\'ten erişilemeyen bir bilgisayarda (yerel bir geliştirme makinesi gibi) çalıştırıyor olabilirsiniz.

**Bu bir sorun mu?**

Bu sorunu rozet vermeyi planladığınız tüm sitelerde düzeltmelisiniz, aksi takdirde alıcılar rozetlerini kendilerinden edindiklerini ispatlayamayacaktır.  Siteniz henüz yayında değilse, yayına geçmeden önce siteye erişilebildiği sürece test rozetleri oluşturabilir ve yayınlayabilirsiniz.

**Sitemin herkese açık olarak erişilebilir olmasını sağlayamazsam ne olur?**

Doğrulama için gereken tek URL, [yoru-site-url] /badges / assertion.php\'dir, güvenlik duvarınızı bu dosyaya harici olarak erişime izin verecek şekilde değiştirebiliyorsanız, rozet doğrulama işlemi yine de geçerli olacaktır.';
$string['backpackbadgessettings'] = 'Rozet paketi ayarlarını değiştir';
$string['backpackbadgessummary'] = '{$a->totalcollections} koleksiyondan görüntülenen {$a->totalbadges} rozetiniz var.';
$string['backpackcannotsendverification'] = 'Doğrulama için e-posta gönderilemiyor';
$string['backpackconnected'] = 'Rozet paketi bağlandı';
$string['backpackconnection'] = 'Rozet paketi bağlantısı';
$string['backpackconnection_connected'] = 'Rozet paketleriniiz';
$string['backpackconnection_help'] = 'Bu sitedeki rozetlerinizi saklayın ve paylaşın ve diğer web sitelerindeki herkese açık rozetleri kullanıcı profilinizde görüntüleyin.';
$string['backpackconnectioncancelattempt'] = 'Farklı bir e-posta adresi kullanarak bağlan';
$string['backpackconnectionconnect'] = 'Rozet paketi adresine bağlan';
$string['backpackconnectionnottested'] = 'Bu rozet paketi çin bağlantı test edilemez çünkü yalnızca Open Badges v2.0 rozet paketini destekler.';
$string['backpackconnectionok'] = 'Rozet paketi bağlantısı başarıyla kuruldu';
$string['backpackconnectionresendemail'] = 'Doğrulama için yeniden e-posta gönder';
$string['backpackconnectionunexpectedmessage'] = 'Rozet paketi şu hatayı döndürdü: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Rozet paketinize bağlanırken bir sorun oluştu.  Rozet paketi sağlayıcınız şu mesajı gönderiyor: \'{$a}\'.';
$string['backpackdetails'] = 'Rozet paketi ayarları';
$string['backpackdisconnected'] = 'Rozet paketi bağlantısı kesildi';
$string['backpackemail'] = 'Email adresi';
$string['backpackemail_help'] = 'Backpack\'inizle ilişkili e-posta adresi. Bağlandıkça, bu sitede kazanılan rozetler bu e-posta adresiyle ilişkilendirilir.';
$string['backpackemail_required'] = 'Eposta adresi boş olamaz';
$string['backpackemailverificationpending'] = 'Doğrulama bekleniyor';
$string['backpackemailverifyemailbody'] = 'Merhaba {$a->userfirstname},

\'{$a->sitename}\' üzerindeki rozet peketine bağlanmayı neredeyse tamamladınız.

Rozet paketinize bağlanmayı tamamlamak için, aşağıdaki düğmeyi kullanarak e-posta adresinizi doğrulayın:

{$a->buttonlink}

Düğme çalışmazsa, aşağıdaki URL\'yi kopyalayıp tarayıcınıza yapıştırabilirsiniz:
{$a->link}

Rozet paketinize bağlanmayı denemediyseniz, bu e-postayı güvenle göz ardı edebilirsiniz.

Daha fazla yardım için lütfen site desteğinizle iletişime geçin,

{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Badges Rozet paketi e-posta doğrulama';
$string['backpackemailverifypending'] = '<strong>{$a}</strong> adresine bir e-posta gönderdik. Rozet paketinizi etkinleştirmek için e-postadaki doğrulama bağlantısına tıklayın.';
$string['backpackemailverifysuccess'] = '<strong>{$a}</strong> adresine bir e-posta gönderdik. Rezet paketinize bağlantınızı etkinleştirmek için e-postadaki doğrulama bağlantısına tıklayın.';
$string['backpackemailverifytokenmismatch'] = 'Tıkladığınız bağlantıdaki anahtar ile depolanan anahtar uyuşmuyor. Size gönderilen en son iletideki bağlantıyı tıkladığınızdan emin olun.';
$string['backpackexporterror'] = 'Rozeti paketine aktaramıyorum';
$string['backpackexporterrorwithinfo'] = '"{$a->badgename}" rozeti rozet paketine aktarılamıyor.  Hata: {$a->error}';
$string['backpackimport'] = 'Rozet içe aktarım ayarları';
$string['backpackimport_help'] = 'Rozet paketi bağlantısı başarıyla kurulduktan sonra, rozet pekiti\'inizdeki rozetler rozetler sayfanızda ve profil sayfanızda görüntülenebilir.

Bu alanda, rozetpaketinizden profilinizde görüntülemek istediğiniz rozetleri koleksiyonlarını seçebilirsiniz.';
$string['backpackprovider'] = 'Rozet paketi sağlayıcısı';
$string['backpacksettings'] = 'Rozet paketi ayarları';
$string['backpackweburl'] = 'Rozet paketi  URL\'si';
$string['badgedetails'] = 'Rozet ayrıntıları';
$string['badgeimage'] = 'Resim';
$string['badgeimage_help'] = 'Resmin boyutu en az 300 x 300 piksel olmalıdır.  Rozet sayfasında 300x300 piksel, kullanıcının profil sayfasında 100x100 piksel olarak görüntülenecektir.';
$string['badgeissued'] = 'Rozet verildi';
$string['badgeprivacysetting'] = 'Rozet gizlilik ayarları';
$string['badgeprivacysetting_help'] = 'Kazandığınız rozetler hesap profil sayfanızda görüntülenebilir. Bu ayar, yeni kazanılan rozetlerin görünürlüğünü otomatik olarak ayarlamanıza izin verir.

Kişisel rozet gizlilik ayarlarınızı, rozetler sayfanızda da kontrol edebilirsiniz.';
$string['badgeprivacysetting_str'] = 'Kazandığım rozetleri otomatik olarak profil sayfamda göster';
$string['badges'] = 'Rozet';
$string['badgesalt'] = 'Alıcının e-posta adresini çırpmak için salt değeri';
$string['badgesalt_desc'] = 'Bir çırpı yöntemi kullanmak, backpac khizmetlerinin, rozet sahibinin e-posta adresini göstermek zorunda kalmadan onaylamasına olanak tanır. Bu ayar yalnızca sayı ve harf kullanmalıdır.

Not: Alıcı doğrulaması amacıyla, lütfen rozet vermeye başladığınızda bu ayarı değiştirmeyi düşünmeyin.';
$string['badgesdisabled'] = 'Rozetler bu sitede etkin değil.';
$string['badgesearned'] = 'Kazanılan rozet sayısı: {$a}';
$string['badgesettings'] = 'Rozet ayarları';
$string['badgestatus_0'] = 'Kullanılamaz';
$string['badgestatus_1'] = 'Kullanılabilir';
$string['badgestatus_2'] = 'Kullanılamaz (kriter kilitli)';
$string['badgestatus_3'] = 'Kullanılabilir (kriter kilitli)';
$string['badgestatus_4'] = 'Arşivlenmiş';
$string['badgestoearn'] = 'Erişilebilir rozet sayısı: {$a}';
$string['badgesview'] = 'Kurs rozetleri';
$string['badgetags'] = 'Rozet etiketi';
$string['badgeurl'] = 'Çıkarılan rozet bağlantısı';
$string['balignment'] = 'Hizalamalar ({$a})';
$string['bawards'] = 'Alıcılar ({$a})';
$string['bcriteria'] = 'Ölçüt';
$string['bdetails'] = 'Ayrıntıları düzenle';
$string['bendorsement'] = 'Onay';
$string['bmessage'] = 'Mesaj';
$string['boverview'] = 'Gözden geçirme';
$string['brelated'] = 'İlgili rozetler ({$a})';
$string['bydate'] = 'tarafından tamamlandı :';
$string['claim'] = 'Kazanılan';
$string['claimcomment'] = 'Onay yorumu';
$string['claimid'] = 'URL talep et';
$string['clearsettings'] = 'Ayarları temizle';
$string['completioninfo'] = 'Bu rozet, tamamlanması için verildi:';
$string['completionnotenabled'] = 'Kurs tamamlama bu kurs için etkinleştirilmemiştir, bu nedenle rozet kriterlerine dahil edilemez. Kurs tamamlama kurs ayarlarından etkinleştirilebilir.';
$string['configenablebadges'] = 'Etkinleştirilirse, bu özellik rozetler oluşturmanıza ve bunları site kullanıcılarına vermenize olanak tanır.';
$string['configuremessage'] = 'Rozet mesajı';
$string['connect'] = 'Bağlan';
$string['connected'] = 'Bağlı';
$string['connecting'] = 'Bağlanıyor...';
$string['contact'] = 'Sertifikayı veren kişi';
$string['contact_help'] = 'Rozet göndereniyle ilişkili bir e-posta adresi.';
$string['copy'] = 'Kopyala';
$string['copyof'] = '{$a} kopyası';
$string['course'] = 'Kurs: {$a}';
$string['coursebadges'] = 'Rozet';
$string['coursebadgesdisabled'] = 'Kurs rozetleri bu sitede etkinleştirilmemiştir.';
$string['coursebadgetitle'] = '{$a} kurs rozeti';
$string['coursecompletion'] = 'Kullanıcılar bu kursu tamamlamalıdır';
$string['create'] = 'Yeni rozet';
$string['createbutton'] = 'Rozet oluştur';
$string['creatorbody'] = '<p>{$a->user}, tüm rozet gereksinimlerini tamamladı ve rozet kazandı. Verilen rozeti {$a->link} adresinde görüntüle</p>';
$string['creatorsubject'] = '\'{$a}\' ödüllendirildi!';
$string['criteria_0'] = 'Bu rozet ne zaman ödüllendirildi...';
$string['criteria_1'] = 'Etkinlik tamamlama';
$string['criteria_1_help'] = 'Bir kurstaki bir dizi etkinlik tamamlanarak kullanıcılara bir rozet verilmesine izin verir.';
$string['criteria_2'] = 'Role bağlı manuel verilmesi';
$string['criteria_2_help'] = 'Site veya kurs içinde belirli bir role sahip kullanıcılar tarafından rozetlerin elle verilmesine izin verir.';
$string['criteria_3'] = 'Sosyal katılım';
$string['criteria_3_help'] = 'Sosyal';
$string['criteria_4'] = 'Kurs tamamlama';
$string['criteria_4_help'] = 'Kursu tamamlayan kullanıcılara bir rozet verilmesine izin verir. Bu kriter, minimum not ve kurs bitim tarihi gibi ek parametrelere sahip olabilir.';
$string['criteria_5'] = 'Bir dizi kursun tamamlanması';
$string['criteria_5_help'] = 'Bir dizi kursu tamamlayan kullanıcılara rozet verilmesini sağlar. Her kurs, minimum not ve kursun tamamlanma tarihi gibi ek parametrelere sahip olabilir.';
$string['criteria_6'] = 'Profil tamamlama';
$string['criteria_6_help'] = 'Profilindeki belirli alanları dolduran kullanıcılara bir rozet verilmesine izin verir. Kullanıcıların erişebileceği varsayılan ve özel profil alanlarından seçim yapabilirsiniz.';
$string['criteria_7'] = 'Kazınılan rozetler';
$string['criteria_7_help'] = 'Kullanıcılara, kazandıkları diğer rozetlere göre bir rozet verilmesine izin verir.';
$string['criteria_8'] = 'Kohort üyeliği';
$string['criteria_8_help'] = 'Grup üyeliğine göre kullanıcılara rozet verilmesine izin verir.';
$string['criteria_9'] = 'Yetkinlikler';
$string['criteria_9_help'] = 'Tamamladıkları yetkinliklere göre kullanıcılara bir rozet verilmesine izin verir.';
$string['criteria_descr'] = 'Kullanıcılar, aşağıdaki gereksinimi tamamladıklarında bu rozet kazanırlar:';
$string['criteria_descr_0'] = 'Listelenen gerekliliklerden <strong>{$a}</strong>\'yı tamamlayın.';
$string['criteria_descr_1'] = 'Aşağıdaki etkinliklerin <strong>{$a}</strong> kadarı tamamlandı:';
$string['criteria_descr_2'] = 'Bu rozet, aşağıdaki rollerden biri olan <strong>{$a}</strong> kullanıcısıyla ödüllendirilmelidir:';
$string['criteria_descr_4'] = 'Kullanıcılar bu kursu tamamlamalıdır';
$string['criteria_descr_5'] = '<strong>{$a}</strong>\'nın aşağıdaki kursların tamamlanması gerekmektedir:';
$string['criteria_descr_6'] = 'Aşağıdaki kullanıcı profili alanlarının <strong>{$a}</strong> tamamlanması gerekiyor:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> aşağıdaki rozetlerden birinin kazanılması gerekmektedir:';
$string['criteria_descr_8'] = 'Aşağıdaki kohortlardan <strong>{$a}</strong>\'ya üyelik gereklidir:';
$string['criteria_descr_9'] = 'Aşağıdaki yetkinliklerden <strong>{$a}</strong> tanesinin tamamlanması gerekiyor:';
$string['criteria_descr_bydate'] = 'tarafından <em>{$a}</em>';
$string['criteria_descr_grade'] = 'asgari notu <em>{$a}</em> ile';
$string['criteria_descr_short0'] = '<strong>{$a}</strong>\'nı tamamlayın:';
$string['criteria_descr_short1'] = '<strong>{$a}</strong>\'nı tamamlayın:';
$string['criteria_descr_short2'] = '<strong> {$a} </strong> tarafından ödüllendirildi:';
$string['criteria_descr_short4'] = 'Kursu tamamla';
$string['criteria_descr_short5'] = '<strong>{$a}</strong>\'nı tamamlayın:';
$string['criteria_descr_short6'] = '<strong>{$a}</strong>\'nı tamamlayın:';
$string['criteria_descr_short7'] = 'Şunlardan <strong>{$a}</strong> tanesini tamamlayın:';
$string['criteria_descr_short8'] = 'Şunlardan <strong>{$a}</strong> tanesini tamamlayın:';
$string['criteria_descr_short9'] = 'Şunlardan <strong>{$a}</strong> tanesini tamamlayın:';
$string['criteria_descr_single_1'] = 'Aşağıdaki etkinlik tamamlanmalıdır:';
$string['criteria_descr_single_2'] = 'Bu rozet, şu rolü taşıyan bir kullanıcı tarafından ödüllendirilmelidir:';
$string['criteria_descr_single_4'] = 'Kullanıcılar kursu tamamlamalıdır';
$string['criteria_descr_single_5'] = 'Aşağıdaki kurs tamamlanmalıdır:';
$string['criteria_descr_single_6'] = 'Aşağıdaki kullanıcı profili alanının doldurulması gerekiyor:';
$string['criteria_descr_single_7'] = 'Aşağıdaki rozetin kazanılması gerekir:';
$string['criteria_descr_single_8'] = 'Aşağıdaki grupta üyelik gereklidir:';
$string['criteria_descr_single_9'] = 'Aşağıdaki yetkinliklerin tamamlanması gerekir:';
$string['criteria_descr_single_short1'] = 'Tamamlayınız:';
$string['criteria_descr_single_short2'] = 'Şu tarafından ödüllendirildi:';
$string['criteria_descr_single_short4'] = 'Kursu tamamlayın';
$string['criteria_descr_single_short5'] = 'Tamamlayınız:';
$string['criteria_descr_single_short6'] = 'Tamamlayınız:';
$string['criteria_descr_single_short7'] = 'Tamamlanan:';
$string['criteria_descr_single_short8'] = 'Üyelik:';
$string['criteria_descr_single_short9'] = 'Tamamlandı:';
$string['criteriacreated'] = 'Rozet ölçütü başarıyla oluşturuldu';
$string['criteriadeleted'] = 'Rozet ölçütü başarıyla kaldırıldı';
$string['criteriasummary'] = 'Ölçüt özeti';
$string['criteriaupdated'] = 'Rozet ölçütleri başarıyla güncellendi';
$string['criterror'] = 'Geçerli parametre sorunları';
$string['criterror_help'] = 'Bu alan kümesi, başlangıçta bu rozet gereksinimine eklenen ancak artık mevcut olmayan tüm parametreleri gösterir. Kullanıcıların gelecekte bu rozeti kazanabileceğinden emin olmak için bu parametrelerin işaretini kaldırmanız önerilir.';
$string['currentimage'] = 'Geçerli resim';
$string['currentstatus'] = 'Mevcut durum';
$string['dateawarded'] = 'Verilen tarih';
$string['dateearned'] = 'Tarih: {$a}';
$string['day'] = 'Gün';
$string['deactivate'] = 'Erişimi devre dışı bırak';
$string['deactivatesuccess'] = '\'{$a}\' rozetine erişim devre dışı.';
$string['defaultissuercontact'] = 'Rozeti veren e-posta adresi';
$string['defaultissuercontact_desc'] = 'Rozeti veren kuruluşla ilişkili bir e-posta adresi.  Açık Rozetler v2.0 rozet paketi için bu, rozetleri bir rozet paketinden yayınlarken kimlik doğrulaması için kullanılır.';
$string['defaultissuername'] = 'Rozet veren kuruluş adı';
$string['defaultissuername_desc'] = 'Veren acente veya makamın adı.';
$string['defaultissuerpassword'] = 'Rozet verinin şifresi';
$string['defaultissuerpassword_help'] = 'Rozet veren e-posta adresi ayarında belirtilen e-posta adresiyle rozet paketi sitesinde bir hesap gereklidir Site yönetimi / Rozetler / Rozetler ayarları. Hesap için şifre buraya girilmelidir.';
$string['delbadge'] = '\'{$a}\' adlı rozeti silmek ve mevcut tüm rozeti kaldırmak ister misiniz?';
$string['delconfirm'] = 'Var olan rozetleri sil ve kaldır';
$string['delcritconfirm'] = 'Bu ölçütü kaldırmak istediğinize emin misiniz?';
$string['deletehelp'] = '<p>Bir rozetin tamamen silinmesi, tüm bilgi ve kriter kayıtlarının kalıcı olarak kaldırılacağı anlamına gelir. Bu rozeti kazanmış olan kullanıcılar artık ona erişip profil sayfalarında görüntüleyemez.</p>
<p>Not: Bu rozetini kazanmış olan kullanıcıların harici backpack\'a ait olan kullanıcılar, harici backpack bu rozeti hâlâ kullanacaktır. Bununla birlikte, bu web sitesine bağlantı veren kriterlere ve kanıt sayfalarına erişemeyeceklerdir.</p>';
$string['delexternalbackpack'] = 'Site rozet paketini sil';
$string['delexternalbackpackconfirm'] = '\'{$a}\' site rozet paketi silinsin mi?';
$string['delparamconfirm'] = 'Bu parametreyi silmek istediğinize emin misiniz?';
$string['description'] = 'Açıklama';
$string['disconnect'] = 'Bağlantıyı kes';
$string['donotaward'] = 'Şu anda, bu rozet etkin değil, bu nedenle kullanıcılara verilemiyor. Bu rozeti ödüllendirmek isterseniz, lütfen durumunu etkin olarak ayarlayın.';
$string['enablebadges'] = 'Rözetleri etkinleştir';
$string['endorsement'] = 'Onay';
$string['error:backpackdatainvalid'] = 'Backpack\'ten gelen veri geçersizdi.';
$string['error:backpackemailnotfound'] = '\'{$a}\' e-postası bir backpack\'la ilişkili değil. Bu hesap için <a href="http://backpack.openbadges.org">bir backpack oluşturmanız</a> veya başka bir e-posta adresiyle oturum açmanız gerekir.';
$string['error:badgeawardnotfound'] = 'Bu ödül alınan rozeti doğrulayamıyorum. Bu rozet iptal edilmiş olabilir.';
$string['error:badgenotfound'] = 'Rozet bulunamadı';
$string['error:cannotact'] = 'Rozet etkinleştirilemiyor';
$string['error:cannotawardbadge'] = 'Bir kullanıcıya rozet veremezsiniz.';
$string['error:cannotdeletecriterion'] = 'Bu kriter silinemez.';
$string['error:cannotrevokebadge'] = 'Rozeti bir kullanıcıdan iptal edemezsiniz.';
$string['error:clone'] = 'Rozet kopyalanamıyor';
$string['error:connectionunknownreason'] = 'Bağlantı başarısız oldu, ancak neden verilmedi.';
$string['error:duplicatename'] = 'Sistemde zaten bu isme sahip bir rozet bulunuyor.';
$string['error:externalbadgedoesntexist'] = 'Rozet bulunamadı';
$string['error:guestuseraccess'] = 'Şu anda konuk erişimini kullanıyorsunuz. Rozetleri görmek için kullanıcı hesabınızla giriş yapmanız gerekmektedir.';
$string['error:invalidcriteriatype'] = 'Geçersiz ölçüt türü';
$string['error:invalidexpiredate'] = 'Son kullanma tarihi gelecekte olmalıdır.';
$string['error:invalidexpireperiod'] = 'Vade sonu negatif veya eşit olamaz 0.';
$string['error:invalidparambadge'] = 'Rozet mevcut değil.';
$string['error:invalidparamcohort'] = 'Topluluk mevcut değil.';
$string['error:noactivities'] = 'Bu kursda tamamlama kriterleri etkin olan bir etkinlik yoktur.';
$string['error:nobadges'] = 'Şu anda, ölçüt olarak eklenebilecek erişime sahip rozet yok.  Bir site rozeti, ölçüt olarak yalnızca diğer site rozetlerine sahip olabilir.  Bir kurs rozetinde ölçüt olarak başka kurs rozetleri veya site rozetleri olabilir.';
$string['error:nocohorts'] = 'Topluluk yok';
$string['error:nocourses'] = 'Kurs tamamlama bu sitedeki herhangi bir kurs için etkinleştirilmediğinden hiçbiri görüntülenemez. Kursun tamamlanması, kurs ayarlarında etkinleştirilebilir.';
$string['error:nogroupslink'] = '<p>Yalnızca herkese açık koleksiyonlar gösterilir.  Bazı genel koleksiyonlar oluşturmak için <a href="{$a}" target="_blank" rel="nofollow">rozet paketinizi ziyaret edin</a>.</p>';
$string['error:nogroupssummary'] = '<p>Rozet paketinizde  halka açık rozet koleksiyonu yok.  </p>';
$string['error:nopermissiontoview'] = 'Rozet sahiplerini görüntüleme izniniz yok';
$string['error:nosuchbadge'] = '{$a} id ye sahip bir rozet mevcut değil';
$string['error:nosuchcohort'] = 'Uyarı: Bu topluluk uzun süredir mevcut değil.';
$string['error:nosuchcourse'] = 'Uyarı : Bu kurs artık mevcut değil';
$string['error:nosuchfield'] = 'Uyarı: Bu kullanıcı profili alanı artık mevcut değil.';
$string['error:nosuchmod'] = 'Uyarı : Bu etkinlik artık mevcut değil';
$string['error:nosuchrole'] = 'Uyarı: Bu rol artık kullanılamıyor.';
$string['error:nosuchuser'] = 'Bu e-posta adresine sahip olan kullanıcının mevcut rozet paketi sağlayıcısı ile bir hesabı yok.';
$string['error:notifycoursedate'] = 'Kurs ve etkinlik tamamlamalarıyla ilişkili rozetler, kurs başlangıç tarihine ({$a}) kadar verilmeyecektir.';
$string['error:parameter'] = 'Uyarı: Doğru rozet iş akışı sağlamak için en az bir parametre seçilmelidir.';
$string['error:relatedbadgedoesntexist'] = 'Bu tanımlayıcıya sahip genel bir rozet yok';
$string['error:requesterror'] = 'Bağlantı isteği başarısız oldu ({$a} hata kodu).';
$string['error:requesttimeout'] = 'Bağlantı isteği tamamlanmadan zaman aşımına uğradı.';
$string['error:save'] = 'Rozet kaydedilemiyor.';
$string['error:userdeleted'] = '{$a->user} (Bu kullanıcı {$a->site} sitesinde artık mevcut değil)';
$string['eventbadgearchived'] = 'Rozet arşivlendi';
$string['eventbadgeawarded'] = 'Rozet verildi';
$string['eventbadgecreated'] = 'Rozet oluşturuldu';
$string['eventbadgecriteriacreated'] = 'Rozet ölçütleri oluşturuldu';
$string['eventbadgecriteriadeleted'] = 'Rozet ölçütleri silindi';
$string['eventbadgecriteriaupdated'] = 'Rozet ölçütleri güncellendi';
$string['eventbadgedeleted'] = 'Rozet silindi';
$string['eventbadgedisabled'] = 'Rozet devre dışı bırakıldı';
$string['eventbadgeduplicated'] = 'Rozet kopyalandı';
$string['eventbadgeenabled'] = 'Rozet etkin';
$string['eventbadgelistingviewed'] = 'Rozet listesi görüntülendi';
$string['eventbadgerevoked'] = 'Rozet iptal edildi';
$string['eventbadgeupdated'] = 'Rozet güncellendi';
$string['eventbadgeviewed'] = 'Rozet izlendi';
$string['existingrecipients'] = 'Mevcut rozet alıcıları';
$string['existsinbackpack'] = 'Rozet zaten rozet paketinde mevcut';
$string['expired'] = 'Süresi dolan';
$string['expiredate'] = 'Bu rozet {$a} tarihinde doluyor.';
$string['expireddate'] = 'Bu rozet {$a} tarihinde doldu.';
$string['expiredin'] = 'Süresi dolmuş {$a}';
$string['expireperiod'] = 'Bu rozet yayınlandıktan sonra {$a} gün geçti.';
$string['expireperiodh'] = 'Bu rozet, yayınlanmasından sonra {$a} saat geçti.';
$string['expireperiodm'] = 'Bu rozet, yayınlanmaya başlandıktan sonra {$a} dakika geçti.';
$string['expireperiods'] = 'Bu rozet yayınlandıktan sonra {$a} saniye geçti.';
$string['expiresin'] = '{$a} sona eriyor';
$string['expirydate'] = 'Bitiş Tarihi';
$string['expirydate_help'] = 'İsteğe bağlı olarak, rozetler belirli bir tarihe göre dolabilir veya tarih, rozetin bir kullanıcıya verildiği tarihe göre hesaplanabilir.';
$string['externalbackpack_required'] = 'Rozet paketi sağlayıcısı boş olamaz';
$string['externalbadges'] = 'Diğer web sitelerindeki rozetlerim';
$string['externalbadges_help'] = 'Bu alan, dış backpack\'nızdaki rozetleri görüntüler.';
$string['externalbadgesp'] = 'Diğer web sitelerindeki rozetler';
$string['externalconnectto'] = 'Harici rozetleri görüntülemek için <a href="{$a}">bir backpack\'a bağlanmanız</a> gerekir.';
$string['fixed'] = 'Sabit tarih';
$string['hidden'] = 'Gizli';
$string['hiddenbadge'] = 'Maalesef, rozet sahibi bu bilgiyi ulaşmamıştır.';
$string['hostedurl'] = 'Harici URL';
$string['hostedurldescription'] = 'Harici URL';
$string['imageauthoremail'] = 'Resim yazarının e-postası';
$string['imageauthoremail_help'] = 'Belirtilmişse rozet resmi yazarının e-posta adresi rozet sayfasında görüntülenir.';
$string['imageauthorname'] = 'Resim yazarının adı';
$string['imageauthorname_help'] = 'Belirtilmişse, rozet resmi yazarının adı rozet sayfasında görüntülenir.';
$string['imageauthorurl'] = 'Resim yazarının URL\'si';
$string['imageauthorurl_help'] = 'Belirtilmişse, rozet sayfasında rozet görseli yazarının web sitesine bir bağlantı görüntülenir.  URL\'nin öneki http:// veya https:// olmalıdır.';
$string['imagecaption'] = 'Resim yazısı';
$string['imagecaption_help'] = 'Belirtilmişse, rozet sayfasında bir resim yazısı görüntülenir.';
$string['includeauthdetails'] = 'Rozet paketi ile  birlikte kimlik doğrulama ayrıntılarını ekleyin';
$string['invalidurl'] = 'Geçersiz URL';
$string['issuancedetails'] = 'Rozet sona erme';
$string['issuedbadge'] = 'Çıkarılan rozet bilgisi';
$string['issuedby'] = '{$a} tarafından yayınlandı';
$string['issuedon'] = '{$a} yayınlandı';
$string['issuerdetails'] = 'çıkaran ayrıntıları';
$string['issueremail'] = 'E-posta';
$string['issueremail_help'] = 'Onayı veren kuruluşun iletişim e-posta adresi.';
$string['issuername'] = 'Çıkaranın adı';
$string['issuername_endorsement'] = 'Onaylayan adı';
$string['issuername_endorsement_help'] = 'Onay veren kişinin adı';
$string['issuername_help'] = 'Veren acente veya makamın adı.';
$string['issuerurl'] = 'Çıkaran URL';
$string['issuerurl_help'] = 'Onay veren kuruluşun web sitesi.  URL\'nin öneki http:// veya https:// olmalıdır.';
$string['language'] = 'Dil';
$string['language_help'] = 'Rozet sayfasında kullanılan dil.';
$string['listbackpacks'] = 'Rozet paketi listesi';
$string['localbadges'] = '{$a} web sitesindeki rozetlerim';
$string['localbadgesh'] = 'Bu web sitesindeki rozetlerim';
$string['localbadgesh_help'] = 'Kursları, kurs etkinliklerini ve diğer şartları tamamlayarak bu web sitesinde kazanılan tüm rozetler.

Rozetlerinizi profil sayfanız için herkese açık veya gizli yaparak buradan yönetebilirsiniz.

Tüm rozetlerinizi veya her bir rozeti ayrı ayrı indirebilir ve bilgisayarınıza kaydedebilirsiniz. İndirilen rozetler harici rozet paketi hizmetinize eklenebilir.';
$string['localbadgesp'] = '{$a} numaralı rozetler:';
$string['localconnectto'] = 'Bu rozetleri bu web sitesinin dışında paylaşmak için <a href="{$a}"> bir backpack\'a bağlanmanız </a> gerekir.';
$string['loginbackpacktitle'] = '<strong>Rozet paketine giriş yapın</strong>';
$string['makeprivate'] = 'Özelleştirmek';
$string['makepublic'] = 'Herkese görünür yap';
$string['managebackpacks'] = 'Rozet paketi yönetimi';
$string['managebadges'] = 'Rozetleri yönet';
$string['message'] = 'Mesaj gövdesi';
$string['messagebody'] = '<p>"% badgename%" rozetini ödüllendirildi!</p>
<p>Bu rozet hakkında daha fazla bilgi  %badgelink%  rozeti bilgi sayfasında bulunabilir.</p>
<p>Rozeti {$a} sayfanızdan yönetebilir ve indirebilirsiniz.</p>';
$string['messagesubject'] = 'Tebrikler! Yeni bir rozet kazandınız!';
$string['method'] = 'Bu kriter tamamlandığında ...';
$string['mingrade'] = 'Minimum not gerekli';
$string['month'] = 'Ay';
$string['moredetails'] = 'Daha fazla detay';
$string['mybackpack'] = 'Rozet paketi ayarları';
$string['mybadges'] = 'Rozetlerim';
$string['namewithlink'] = 'Bağlantılı isim';
$string['never'] = 'Asla';
$string['newbackpack'] = 'Yeni bir rozet paketi ekle';
$string['newbadge'] = 'Yeni bir rozet ekle';
$string['newbadgedeprecated'] = 'badges/newbadge.php sayfasından yönlendirildiniz. Lütfen badges/newbadge.php sayfasının yakın gelecekte kaldırılacağını unutmayın. <br/>Bağlantıları ve yer imlerini güncel badges/edit.php sayfasını kullanacak şekilde güncelleyin.';
$string['newimage'] = 'Yeni resim';
$string['noalignment'] = 'Bu rozetin belirlenmiş herhangi bir dış yeteneği veya standardı yoktur.';
$string['noawards'] = 'Bu rozet henüz kazanılmamış.';
$string['nobackpack'] = 'Bu hesaba bağlı backpack servisi yok. <br/>';
$string['nobackpackbadgessummary'] = 'Seçtiğiniz koleksiyonlarda rozet yok.';
$string['nobackpackcollectionssummary'] = 'Rozet koleksiyonu seçilmedi.';
$string['nobackpacks'] = 'Rozet paketi mevcut değil';
$string['nobadges'] = 'Uygun rozet bulunmuyor.';
$string['nocompetencies'] = 'Yetkinlik seçilmedi.';
$string['nocriteria'] = 'Bu rozet için gereken ölçütler henüz ayarlanmamış';
$string['noendorsement'] = 'Bu rozetin bir onayı yok.';
$string['noexpiry'] = 'Bu rozetin son kullanma tarihi yoktur.';
$string['nomatchingawards'] = 'Henüz bu rozeti kazanmış eşleşen bir alıcı yok.';
$string['nomatchingbadges'] = 'Kullanıcıların kazanabileceği eşleşen rozetler bulunmamaktadır';
$string['noparamstoadd'] = 'Bu rozet gereksinimine eklenebilecek ek parametreler yok.';
$string['norelated'] = 'Bu rozetin ilgili rozetleri yok.';
$string['notacceptedrole'] = 'Mevcut rol atamanız, bu rozetle manuel olarak çıkarabilecek roller arasında değil. <br/>
Bu rozeti kazanmış olan kullanıcıları görmek isterseniz {$a} sayfasını ziyaret edebilirsiniz.';
$string['notconnected'] = 'Bağlı değil';
$string['notealignment'] = 'Rozetin uyumlu olduğu harici beceriler veya standartlar belirtilebilir. Tüm harici beceriler veya standartlar rozet sayfasında görüntülenir.';
$string['noteendorsement'] = 'Rozete değer katmak için üçüncü bir tarafın onayı kullanılabilir. Örneğin, bir öğretmen tarafından verilen bir rozet okul tarafından onaylanabilir veya yerel bir ödüllendirme kurumu tarafından verilen bir rozet ulusal ödüllendirme kurumu tarafından onaylanabilir.';
$string['noterelated'] = 'Bir bağlantıya sahip rozetler ilişkili olarak işaretlenebilir. Örneğin, farklı dillerde görüntülenen aynı kriterlere sahip rozetler ilişkili olarak işaretlenebilir. İlgili tüm rozetler rozet sayfasında görüntülenir.';
$string['nothingtoadd'] = 'Eklenebilecek uygun ölçüt bulunmuyor.';
$string['notification'] = 'Rozet oluşturucusuna bildir';
$string['notification_help'] = 'Bu ayar, bir rozet oluşturana gönderilen bildirimleri, rozet verildiğini bildirmek için yönetir.

Aşağıdaki seçenekler mevcuttur:

* **HİÇBİR ZAMAN** - Bildirimler göndermeyin.

* **HER ZAMAN** - Bu rozet her ödül verildiğinde bir bildirim gönderin.

* **GÜNLÜK** - Günde bir kez bildirim gönderin.

* **HAFTALIK** - Haftada bir bildirim gönderin.

* **AYLIK** - Ayda bir kez bildirim gönderin.';
$string['notifydaily'] = 'Günlük';
$string['notifyevery'] = 'Her zaman';
$string['notifymonthly'] = 'Aylık';
$string['notifyweekly'] = 'Haftalık';
$string['numawards'] = 'Kullanıcılar \'{$a->badgename}\' rozeti ile ödüllendirildi: <a href="{$a->link}">{$a->count}</a>.';
$string['numawardstat'] = 'Kullanıcılar \'{$a->badgename}\' rozeti ile ödüllendirildi: {$a->ödüller}.';
$string['oauth2issuer'] = 'OAuth 2 hizmetleri';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Diğer navigasyon...';
$string['overallcrit'] = 'Seçilen ölçütlerin tamamlanması.';
$string['password_required'] = 'Şifre alanı boş olamaz';
$string['potentialrecipients'] = 'Potansiyel rozet alıcıları';
$string['preferences'] = 'Rozet tercihleri';
$string['privacy:metadata:backpack'] = 'Kullanıcının rozet paketi kaydı';
$string['privacy:metadata:backpack:backpackuid'] = 'Rozet paketi benzersiz tanımlayıcısı';
$string['privacy:metadata:backpack:email'] = 'Rozet paketi ile ilişkili e-posta';
$string['privacy:metadata:backpack:externalbackpackid'] = 'Rozet paketi kimliği';
$string['privacy:metadata:backpack:userid'] = 'Rozet paketi olan kullanıcının kimliği';
$string['privacy:metadata:backpackoauth2'] = 'Kullanıcı harici bir rozet paketi bağlandığında OAuth 2 bilgisi';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'OAuth 2 hizmet kimliği';
$string['privacy:metadata:backpackoauth2:scope'] = 'Razet paketi bağlantısının kapsamını listele';
$string['privacy:metadata:backpackoauth2:token'] = 'Rozet paketi bağlantı belirteci';
$string['privacy:metadata:backpackoauth2:userid'] = 'Rozet paketine bağlanan kullanıcının kimliği';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'Bağlantısı değiştirilen kullanıcının kimliği';
$string['privacy:metadata:badge'] = 'Rozet koleksiyonu';
$string['privacy:metadata:badge:timecreated'] = 'Rozetin oluşturulduğu zaman';
$string['privacy:metadata:badge:timemodified'] = 'Rozetin en son değiştirildiği zaman';
$string['privacy:metadata:badge:usercreated'] = 'Rozeti oluşturan kullanıcının kimliği';
$string['privacy:metadata:badge:usermodified'] = 'Rozeti değiştiren kullanıcının kimliği';
$string['privacy:metadata:criteriamet'] = 'Karşılanan kriterlerin bir koleksiyonu';
$string['privacy:metadata:criteriamet:datemet'] = 'Kriterlerin karşılandığı tarih';
$string['privacy:metadata:criteriamet:userid'] = 'Kriterleri karşılayan kullanıcının kimliği';
$string['privacy:metadata:external:backpacks'] = 'Information shared when users submit their badges to an external backpack';
$string['privacy:metadata:external:backpacks:badge'] = 'Rozet adı';
$string['privacy:metadata:external:backpacks:description'] = 'Rozet açıklaması';
$string['privacy:metadata:external:backpacks:image'] = 'Rozetin görseli';
$string['privacy:metadata:external:backpacks:issuer'] = 'Yayıncı hakkında bazı bilgiler';
$string['privacy:metadata:external:backpacks:url'] = 'Verilen rozet bilgilerinin görülebileceği Moodle URL\'si';
$string['privacy:metadata:issued'] = 'Verilen rozetlerin kaydı';
$string['privacy:metadata:issued:dateexpire'] = 'Rozetin süresinin dolacağı tarih';
$string['privacy:metadata:issued:dateissued'] = 'Ödülün verildiği tarih';
$string['privacy:metadata:issued:userid'] = 'Rozet almaya hak kazanan kullanıcının kimliği';
$string['privacy:metadata:manualaward'] = 'Elle verilen ödüllerin kaydı';
$string['privacy:metadata:manualaward:datemet'] = 'Kullanıcının rozete layık görüldüğü tarih';
$string['privacy:metadata:manualaward:issuerid'] = 'Rozeti veren kullanıcının kimliği';
$string['privacy:metadata:manualaward:issuerrole'] = 'Rozeti veren kullanıcının rolü';
$string['privacy:metadata:manualaward:recipientid'] = 'El ile rozet verilen kullanıcının kimliği';
$string['recipient'] = 'Rozet alıcısı';
$string['recipients'] = 'Rozet alıcıları';
$string['recipientvalidationproblem'] = 'Mevcut kullanıcı bu rozetin sahibi olarak doğrulanamıyor.';
$string['relatedbages'] = 'İlgili rozetler';
$string['relative'] = 'Göreceli tarih';
$string['requiredbadge'] = 'Rozet kriterine en az bir rozet eklenmelidir';
$string['requiredcohort'] = 'Topluluk kriterine en az bir topluluk eklenmelidir.';
$string['requiredcompetency'] = 'Yetkinlik ölçütüne en az bir yetkinlik eklenmelidir.';
$string['requiredcourse'] = 'Kurs dizisi ölçütüne en az bir kurs eklenmelidir.';
$string['reviewbadge'] = 'Rozet erişimindeki değişiklikler';
$string['reviewconfirm'] = '<p>Bu, rozetinizi kullanıcılara görünür kılacak ve kazanmalarına izin verecektir.</p>

<p>Bazı kullanıcıların bu rozet ölçütlerini zaten karşılamaları mümkündür ve bu rozeti etkinleştirdikten hemen sonra yayınlanacaktır.</p>

<p>Bir rozet verildiğinde, <strong>kilitli</strong> olur - ölçütler ve son kullanım ayarları da dahil olmak üzere belirli ayarlar artık değiştirilemez.</p>

<p> \'{$a}\' isimli rozet\'e erişimi etkinleştirmek istediğinizden emin misiniz?</p>';
$string['revoke'] = 'Rozeti iptal et';
$string['save'] = 'Kaydet';
$string['searchname'] = 'İsme göre ara';
$string['selectaward'] = 'Lütfen bu rozet ödüllendirmek için kullanmak istediğiniz rolü seçin:';
$string['selectgroup_end'] = 'Yalnızca genel koleksiyonlar gösterilir.  Daha fazla genel koleksiyon oluşturmak için <a href="{$a}">rozet paketinizi ziyaret edin</a>.';
$string['selectgroup_start'] = 'Bu sitede sergilenecek backpack\'tan koleksiyon seçin:';
$string['selecting'] = 'Seçilen rozetlerle...';
$string['setup'] = 'Bağlantı kurulumu';
$string['sitebackpackdeleted'] = 'Site rozet paketi silindi.';
$string['sitebackpacknotdeleted'] = 'Bu rozet paketi şu anda site varsayılanı olduğundan silinemedi.';
$string['sitebackpackwarning'] = 'Rozet paketine bağlanılamadı.  <br/><br/>"Rozeti veren e-posta adresi" yönetici ayarının, rozet paketi web sitesindeki bir hesap için geçerli e-posta olduğunu kontrol edin.  <br/><br/><a href="{$a->url}">site rozet paketi ayarları sayfasında</a> "Rozet veren şifrenin", sitedeki hesap için doğru şifre olduğunu kontrol edin.  rozet paketiı web sitesi.  <br/><br/>Rozet paketi geri döndü: "{$a->uyarı}"';
$string['sitebadges'] = 'Site rozetleri';
$string['sitebadges_help'] = 'Site rozetleri yalnızca kullanıcılara site ile ilgili etkinlikler için verilebilir. Bunlara bir dizi kursu veya kullanıcı profillerini tamamlama dahildir. Site rozetleri bir kullanıcı tarafından başka birine manuel olarak da verilebilir.

Kursla ilgili faaliyetler için rozetler kurs seviyesinde oluşturulmalıdır. Kurs rozetleri, Kurs Yönetimi> Rozetler altında bulunabilir.';
$string['sitebadgetitle'] = '{$a} site rozeti';
$string['status'] = 'Rozet Durumu';
$string['status_help'] = 'Bir rozet durumu, sistemdeki davranışını belirler:

* **MEVCUT** - Bu rozet kullanıcıların kazanabileceği anlamına gelir. Kullanıcılar için bir rozet bulunurken kriterleri değiştirilemez.

* **MEVCUT DEĞİL** - Bu rozet kullanıcılara açık değildir ve kazanılamaz veya manuel olarak verilemez. Bu tür bir rozet daha önce hiç yayınlanmadıysa, kriterleri değiştirilebilir.

En az bir kullanıcıya bir rozet verildiğinde otomatik olarak
 ** KİLİTLİ ** olur. Kilitli rozetler hâlâ kullanıcılar tarafından kazanılabilir ancak kriterleri artık değiştirilemez. Kilitli bir rozetin ayrıntılarını veya ölçütlerini değiştirmeniz gerekiyorsa, bu rozeti kopyalayabilir ve gerekli tüm değişiklikleri yapabilirsiniz.

*Rozetleri neden kilitlemelisiniz?*

Bir rozet kazanmak için tüm kullanıcıların aynı gereksinimleri tamamladığından emin olmak istiyoruz. Şu anda, rozetleri iptal etmek mümkün değildir. Rozet gereksinimlerinin her zaman değiştirilmesi için izin verilmiş olsaydı, büyük olasılıkla tamamen farklı gereksinimleri karşılamak için aynı rozet kullanan kullanıcılar olurdu.';
$string['statusmessage_0'] = 'Bu rozet şu anda kullanıcılar tarafından kullanılamıyor. Kullanıcıların bu rozeti kazanmalarını istiyorsanız, erişimi etkinleştirin.';
$string['statusmessage_1'] = 'Bu rozet şu anda kullanıcılara açık. Değişiklik yapmak için erişimi devre dışı bırakın.';
$string['statusmessage_2'] = 'Bu rozet şu anda kullanıcılar tarafından kullanılamıyor ve kriterleri kilitlidir. Kullanıcıların bu rozeti kazanmalarını istiyorsanız, erişimi etkinleştirin.';
$string['statusmessage_3'] = 'Bu rozet şu anda kullanıcılara sunuluyor ve kriterleri kilitlidir.';
$string['statusmessage_4'] = 'Bu rozet şu an arşivlidir.';
$string['subject'] = 'Mesaj konusu';
$string['tagarea_badge'] = 'Rozetler';
$string['tags'] = 'Etiketler';
$string['targetcode'] = 'Kod';
$string['targetcode_help'] = 'Harici beceri veya standarda referans veren benzersiz bir dize tanımlayıcısı.';
$string['targetdescription'] = 'Açıklama';
$string['targetdescription_help'] = 'Harici beceri veya standardın kısa açıklaması';
$string['targetframework'] = 'Çerçeve';
$string['targetframework_help'] = 'Harici beceri veya standart çerçevenin adı.';
$string['targetname'] = 'İsim';
$string['targetname_help'] = 'Rozetin uyumlu olduğu harici beceri veya standart.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Harici beceriyi veya standardı açıklayan bir sayfaya bağlantı.  URL bir http: // veya https: // önekine sahip olmalıdır.';
$string['testbackpack'] = '\'{$a}\'rozet paketini test edin';
$string['testsettings'] = 'Test ayarları';
$string['type'] = 'Türü';
$string['userbadges'] = 'Kullanıcı rozetleri';
$string['variablesubstitution'] = 'Mesajlarda değişken yerine geçen';
$string['variablesubstitution_help'] = 'Bir rozet mesajında, mesaj gönderildiğinde gerçek değerlerle değiştirilecek belirli değişkenler bir mesajın konusuna ve / veya gövdesine eklenebilir. Değişkenler metne tam olarak aşağıda gösterildiği gibi eklenmelidir. Aşağıdaki değişkenler kullanılabilir:

%badgename%
: Bunun yerine rozetin tam adı geçecektir.

%username%
: Bu, alıcının tam adı ile değiştirilecektir.

%badgelink%
: Bu, yerini alacak olan rozet ile ilgili bilgilerin yer aldığı genel URL ile değiştirilecektir.';
$string['verifyemail'] = 'E-posta doğrulama';
$string['version'] = 'Sürüm';
$string['version_help'] = 'Sürüm alanı, rozetin gelişimini takip etmek için kullanılabilir. Belirtilmişse, sürüm rozet sayfasında görüntülenir.';
$string['viewbadge'] = 'Çıkarılan rozeti görüntüle';
$string['visible'] = 'Görünür';
$string['warnexpired'] = '(Bu rozet zaman aşımına uğramış!)';
$string['year'] = 'Yıl';
