<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'webservice', language 'sr_lt', version '4.5'.
 *
 * @package     webservice
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessexception'] = 'Izuzetak kontrole pristupa';
$string['actwebserviceshhdr'] = 'Aktivni protokoli Web servisa';
$string['addaservice'] = 'Dodaj servis';
$string['addcapabilitytousers'] = 'Proveri sposobnosti korisnika';
$string['addcapabilitytousersdescription'] = 'Korisnici treba da imaju dve sposobnosti - webservice:createtoken i sposobnost koja odgovara protokolu koji se koristi, npr. webservice/rest:use, webservice/soap:use. Da biste to postigli kreirajte ulogu za Web servis sa dopuštenim odgovorajućim sposobnostima i dodelite je korisniku Web servisa kao sistemsku ulogu.';
$string['addexternalservice'] = 'Dodaj spoljni servis';
$string['addfunction'] = 'Dodaj funkciju';
$string['addfunctionhelp'] = 'Izaberite funkciju koju želite da dodate servisu.';
$string['addfunctions'] = 'Dodaj funkcije';
$string['addfunctionsdescription'] = 'Izaberi neophodne funkcije za novokreirani servis';
$string['addrequiredcapability'] = 'Dodeli/ukloni potrebnu sposobnost';
$string['addservice'] = 'Dodaj novi servis: {$a->name} (id: {$a->id})';
$string['addservicefunction'] = 'Dodaj funkcije servisu "{$a}"';
$string['allusers'] = 'Svi korisnici';
$string['apiexplorer'] = 'API istraživač';
$string['apiexplorernotavalaible'] = 'API istraživač još nije dostupan.';
$string['arguments'] = 'Argumenti';
$string['authmethod'] = 'Način provere identiteta';
$string['callablefromajax'] = 'Može se pozvati pomoću AJAX-a';
$string['cannotcreatetoken'] = 'Nema dozvola za kreiranje tokena veb servisa za servis {$a}.';
$string['cannotgetcoursecontents'] = 'Nije moguće dobiti sadržaj kurseva';
$string['checkusercapability'] = 'Proveri sposobnosti korisnika';
$string['checkusercapabilitydescription'] = 'Korisnik treba da ima odgovorajuće sposobnosti shodno protokolu koji se koristi, npr. webservice/rest:use, webservice/soap:use. Da biste to postigli kreirajte ulogu za Web servis sa dopuštenim sposobnostima za izvršenje protokola i dodelite je korisniku Web servisa kao sistemsku ulogu.';
$string['configwebserviceplugins'] = 'Iz razloga bezbednosti treba da budu uključeni samo protokoli koji se koriste.';
$string['context'] = 'Kontekst';
$string['createservicedescription'] = 'Servis predstavlja skup funkcija Web servisa. Da bi korisnik mogu da pristupu novom servisu dozvolićete njegovu upotrebu. Na stranici <strong>Dodaj servis </strong> označite opcije Omogući\' i \'Autorizovani korisnik\'. Izaberite i \'Nema zahtevane sposobnosti\'.';
$string['createserviceforusersdescription'] = 'Servis predstavlja skup funkcija Web servisa. Da bi korisnik mogu da pristupu novom servisu dozvolićete njegovu upotrebu. Na stranici <strong>Dodaj servis </strong> označite opcije Omogući\' i uklonite oznaku sa opcije \'Autorizovani korisnik\'. Izaberite i \'Nema zahtevane sposobnosti\'.';
$string['createtoken'] = 'Kreiraj token';
$string['createtokenforuser'] = 'Kreiraj token za korisnika';
$string['createtokenforuserdescription'] = 'Kreiraj token za korisnika Web servisa';
$string['createuser'] = 'Kreiraj specifičnog korisnika';
$string['createuserdescription'] = 'Korisnik Web servisa je neophodan kako bi predstavljao sistem koji kontroliše Moodle.';
$string['criteriaerror'] = 'Nedostaju ovlašćenja za pretraživanje prema kriterijumu.';
$string['default'] = 'Podrazumevano za "{$a}"';
$string['deleteaservice'] = 'Obriši servis';
$string['deleteservice'] = 'Obriši servis: {$a->name} (id: {$a->id})';
$string['deleteserviceconfirm'] = 'Brisanjem servisa biće takođe obrisan tokeni koji se odnose na taj servis. Da li stvarno želite da obrišete spoljni servis "{$a}"?';
$string['deletetoken'] = 'Obriši token';
$string['deletetokenconfirm'] = 'Da li stvarno želite da obrišete ovaj token Web servisa za <strong>{$a->user}</strong> na servis <strong>{$a->service}</strong>?';
$string['deprecated'] = 'Zastarelo';
$string['disabledwarning'] = 'Svi protokoli veb servisa su onemogućeni. Podešavanje "Omogući veb servise" možete naći među u odeljku administracije sajta "Napredna svojstva".';
$string['doc'] = 'Dokumentacija';
$string['docaccessrefused'] = 'Nije Vam dozvoljeno da vidite dokumentaciju za ovaj token';
$string['downloadfiles'] = 'Moguće je preuzimanje datoteka';
$string['downloadfiles_help'] = 'Ako je ova opcija omogućena, bilo koji korisnik može da preuzme datoteke sa njihovim bezbednosnim ključevima. Naravno, ovo se odnosi samo na one datoteke na sajtu za koje postoji dozvola za preuzimanje.';
$string['editaservice'] = 'Uredi servis';
$string['editexternalservice'] = 'Uredi spoljni servis';
$string['editservice'] = 'Uredi servis: {$a->name} (id: {$a->id})';
$string['enabled'] = 'Omogućeno';
$string['enabledocumentation'] = 'Omogući dokumentaciju za razvojne programere';
$string['enabledocumentationdescription'] = 'Detaljna dokumentacija Web servisa je dostupna za omogućene protokole.';
$string['enableprotocols'] = 'Omogući protokole';
$string['enableprotocolsdescription'] = 'Najmanje jedan protokol mora biti uključen. Iz razloga bezbednosti, treba omogućite samo one protokole koji će se koristiti.';
$string['enablews'] = 'Omogući Web servise';
$string['enablewsdescription'] = 'Veb servisi moraju da budu omogućeni u "Naprednim svojstvima".';
$string['entertoken'] = 'Unesite bezbednosni ključ (token)';
$string['error'] = 'Greška: {$a}';
$string['errorcatcontextnotvalid'] = 'Ne možete da izvršite funkciju u kontekstu kategorije (category id:{$a->catid}). Poruka o grešci konteksta glasi: {$a->message}';
$string['errorcodes'] = 'Poruka o grešci';
$string['errorcoursecontextnotvalid'] = 'Ne možete da izvršite funkciju u kontekstu kursa (course id:{$a->courseid}). Poruka o grešci konteksta glasi: {$a->message}';
$string['errorinvalidparam'] = 'Parametar "{$a}" nije ispravan.';
$string['errornotemptydefaultparamarray'] = 'Parametar opisa Web servisa koji se naziva \'{$a}\' je jednostavna ili višestruka struktura. Podrazumevana vrednost je da on može biti samo prazan niz. Proverite opis Web servisa.';
$string['erroroptionalparamarray'] = 'Parametar opisa Web servisa koji se naziva \'{$a}\' je jednostavna ili višestruka struktura. Ne može biti podešen kao VALUE_OPTIONAL. Proverite opis Web servisa.';
$string['eventwebservicefunctioncalled'] = 'Funkcija veb servisa pozvana';
$string['eventwebserviceloginfailed'] = 'Prijava veb servisa nije uspela';
$string['eventwebserviceservicecreated'] = 'Veb servisa kreiran';
$string['eventwebserviceservicedeleted'] = 'Veb servisa obrisan';
$string['eventwebserviceserviceupdated'] = 'Veb servisa ažuriran';
$string['eventwebserviceserviceuseradded'] = 'Korisnik veb servisa dodat';
$string['eventwebserviceserviceuserremoved'] = 'Korisnik veb servisa uklonjen';
$string['eventwebservicetokencreated'] = 'Token veb servisa kreiran';
$string['eventwebservicetokensent'] = 'Token veb servisa poslat';
$string['execute'] = 'Izvrši';
$string['executewarnign'] = 'UPOZORENjE: Ako pokrenete izvršavanje Vaša baza podataka će biti izmenjena a promene ne mogu biti automatski poništene!';
$string['externalservice'] = 'Spoljni servis';
$string['externalservicefunctions'] = 'Funkcije spoljnog servisa';
$string['externalservices'] = 'Spoljni servisi';
$string['externalserviceusers'] = 'Korisnici spoljnog servisa';
$string['failedtolog'] = 'Neuspešna prijava';
$string['filenameexist'] = 'Naziv datoteke već postoji: {$a}';
$string['forbiddenwsuser'] = 'Nije moguće kreirati token za nepotvrđenog, obrisanog, suspendovanog ili korisnika u ulozi gosta.';
$string['function'] = 'Funkcija';
$string['functions'] = 'Funkcije';
$string['generalstructure'] = 'Opšta struktura';
$string['information'] = 'Informacija';
$string['installexistingserviceshortnameerror'] = 'Web servis sa skraćenim nazivom "{$a}" već postoji. Nije moguće instalirati/ažurirati različite Web servisa sa ovim skraćenim nazivom.';
$string['installserviceshortnameerror'] = 'Greška u kôdu: skraćeni naziv servisa "{$a}" može da sadrži samo alfanumeričke znake (slova i brojeve) donju crtu (_), crticu (-) ili tačku (.)';
$string['invalidextparam'] = 'Neispravan parametar spoljnog API-ja: {$a}';
$string['invalidextresponse'] = 'Neispravan odgovor spoljnog API-ja: {$a}';
$string['invalidiptoken'] = 'Neispravan token - vaša IP adresa nije podržana';
$string['invalidtimedtoken'] = 'Neispravan token - token je istekao';
$string['invalidtoken'] = 'Neispravan token - token nije pronađen';
$string['iprestriction'] = 'IP ograničenje';
$string['iprestriction_help'] = 'Korisnik će morati da pozove Web servis sa neke od navedenih IP adresa (razdvojenih zarezima).';
$string['key'] = 'Ključ';
$string['keyshelp'] = 'Ključevi se koriste za pristup Vašem Moodle korisničkom nalogu iz spoljnih aplikacija.';
$string['loginrequired'] = 'Pristup omogućen samo prijavljenim korisnicima';
$string['manageprotocols'] = 'Upravljanje protokolima';
$string['managetokens'] = 'Upravljanje tokenima';
$string['missingcaps'] = 'Nedostaju sposobnosti';
$string['missingcaps_help'] = 'Spisak neophodnih sposobnosti za servis, koje izabrani korisnik nema. Neke funkcije servisa možda neće biti dostupne bez ovih sposobnosti.';
$string['missingpassword'] = 'Nedostaje lozinka';
$string['missingrequiredcapability'] = 'Sposobnost {$a} je neophodna.';
$string['missingusername'] = 'Nedostaje korisničko ime';
$string['missingversionfile'] = 'Programska greška: nedostaje datoteka version.php za komponentu {$a}';
$string['nameexists'] = 'Ovo ime već koristi neki drugi servis';
$string['nocapabilitytouseparameter'] = 'Korisnik nema potrebnu sposobnost da bi koristio parametar {$a}';
$string['nofunctions'] = 'Ovaj servis nema funkcije.';
$string['norequiredcapability'] = 'Nema potrebnih sposobnosti';
$string['notoken'] = 'Spisak tokena je prazan.';
$string['onesystemcontrolling'] = 'Dozvoli spoljnjem sistemu da kontroliše Moodle';
$string['onesystemcontrollingdescription'] = 'Sledeći koraci vam pomažu da podesite Moodle veb servis kako biste omogućili spoljnom sistemu interakciju sa Moodleom. Ovo uključuje podešavanje tokena (bezbednosnog ključa) kao metoda za proveru identiteta.';
$string['onlyseecreatedtokens'] = 'Možete da vidite samo tokene koje ste kreirali. ';
$string['operation'] = 'Operacija';
$string['optional'] = 'Opciono';
$string['passwordisexpired'] = 'Lozinka je istekla';
$string['phpparam'] = 'XML-RPC (PHP struktura)';
$string['phpresponse'] = 'XML-RPC (PHP struktura)';
$string['postrestparam'] = 'PHP kôd za REST (POST zahtev)';
$string['potusers'] = 'Nema autorizovanih korisnika';
$string['potusersmatching'] = 'Nijedan ovlašćeni korisnik ne odgovara';
$string['print'] = 'Štampaj sve';
$string['privacy:metadata'] = 'WebService API';
$string['protocol'] = 'Protokol';
$string['removefunction'] = 'Ukloni';
$string['removefunctionconfirm'] = 'Da li stvarno želite da uklonite funkciju "{$a->function}" iz servisa "{$a->service}"?';
$string['requireauthentication'] = 'Ovaj metod zahteva proveru identiteta sa xxx ovlašćenjem.';
$string['required'] = 'Obavezno';
$string['requiredcapability'] = 'Potrebna sposobnost';
$string['requiredcapability_help'] = 'Ako je podešeno, servisu će moći da pristupe samo korisnici sa potrebnim sposobnostima.';
$string['requiredcaps'] = 'Potrebne sposobnosti';
$string['resettokencomplete'] = 'Izabrani token je resetovan';
$string['resettokenconfirm'] = 'Da li stvarno želite da resetujete ovaj ključ Web servisa za korisnika: <strong>{$a->user}</strong>, na servisu: <strong>{$a->service}</strong>?';
$string['resettokenconfirmsimple'] = 'Da li stvarno želite da resetujete ovaj ključ? Bilo koji sačuvani link koji sadrži stari ključ neće više raditi.';
$string['response'] = 'Odgovor';
$string['restcode'] = 'REST';
$string['restexception'] = 'REST';
$string['restoredaccountresetpassword'] = 'Pre dobijanja tokena za obnovljeni korisnički nalog neophodno je resetovanje lozinke.';
$string['restparam'] = 'REST (POST parametri)';
$string['restrictedusers'] = 'Samo autorizovani korisnici';
$string['restrictedusers_help'] = 'Ovo podešavanje određuje da li će korisnici sa ovlašćenjem da kreiraju token Web servisa, moći da generišu token za ovaj Web servis preko svojih stranica sa sigurnosnim ključem ili će to moći da urade samo ovlašćeni, autorizovani korisnici.';
$string['securitykey'] = 'Bezbednosni ključ (token)';
$string['securitykeys'] = 'Bezbednosni ključevi';
$string['selectauthorisedusers'] = 'Izaberi autorizovane korisnike';
$string['selectedcapability'] = 'Izabrane sposobnosti';
$string['selectedcapabilitydoesntexit'] = 'Trenutno podešena potrebna sposobnost ({$a}) više ne postoji. Promenite je i sačuvajte promene.';
$string['selectservice'] = 'Izaberi servis';
$string['selectspecificuser'] = 'Izaberi određenog korisnika';
$string['selectspecificuserdescription'] = 'Dodaj korisnika Web servisa kao ovlašćenog korisnika';
$string['service'] = 'Servis';
$string['servicehelpexplanation'] = 'Servis predstavlja skup funckija. Servisu mogu pristupiti svi ili samo određeni korisnici.';
$string['servicename'] = 'Naziv servisa';
$string['servicenotavailable'] = 'Veb servis nije dostupan (ne postoji ili je možda onemogućen).';
$string['servicerequireslogin'] = 'Veb servis nije dostupan (sesija je odjavljena ili je istekla.)';
$string['servicesbuiltin'] = 'Ugrađeni servisi';
$string['servicescustom'] = 'Prilagođeni servisi';
$string['serviceusers'] = 'Autorizovani korisnici';
$string['serviceusersettings'] = 'Korisnička podešavanja';
$string['serviceusersmatching'] = 'Autorizovani korisnici se poklapaju';
$string['serviceuserssettings'] = 'Promeni podešavanja za autorizovane korisnike';
$string['shortnametaken'] = 'Skraćeni naziv se već koristi za drugi servis ({$a})';
$string['simpleauthlog'] = 'Prijava pomoću jednostavne provere identiteta';
$string['step'] = 'Korak';
$string['supplyinfo'] = 'Više informacija';
$string['testauserwithtestclientdescription'] = 'Simulirajte spoljni pristup servisu koristeći probni klijent veb servisa. Pre toga, prijavite se kao korisnik koji ima sposobnost moodle/webservice:createtoken i preuzmite bezbednosni ključ (token) preko stranica za korisnička podešavanja- Ovaj token ćete koristiti u probnom klijentu. U klijentu, takođe, odaberite omogućeni protokol sa tokenom za proveru identiteta. <strong>UPOZORENJE: funkcije koje testirate BIĆE IZVRŠENE za ovog korisnika, pa budite pažljivi prilikom izbora onoga što želite da testirate!</strong>';
$string['testclient'] = 'Test klijent Web servisa';
$string['testclientdescription'] = '* Probni klijent veb servisa <strong>izvršava</strong> funkcije <strong>STVARNO</strong>. Nemojte da testirate funkcije koje ne poznajete. <br/>
* Sve postojeće funkcije veb servisa nisu još implementirane u probnom klijentu. <br/>* Kako biste proverili da li korisnik ne može da pristupi nekim funkcijama možete da testirate funkcije koje niste odobrili.<br/>* Da biste videli jasnije poruke o greškama podesite sistem za otklanjanje grešaka na <strong>{$a->mode}</strong> u {$a->atag}.';
$string['testwithtestclient'] = 'Testiraj servis';
$string['testwithtestclientdescription'] = 'Simulirajte spoljni pristup servisu koristeći probni klijent veb servisa. Upotrebite omogućeni protokol sa tokenom za proveru identiteta. <strong>UPOZORENJE: funkcije koje testirate BIĆE IZVRŠENE, pa budite pažljivi prilikom izbora onoga što želite da testirate!</strong>';
$string['token'] = 'Token';
$string['tokenauthlog'] = 'Provera identiteta putem tokena';
$string['tokencopied'] = 'Tekst je kopiran u klipbord.';
$string['tokencreatedbyadmin'] = 'Može biti resetovano od strane administratora (*)';
$string['tokencreator'] = 'Autor';
$string['tokenfilter'] = 'Filter tokena';
$string['tokenfilterreset'] = 'Prikaži sve tokene';
$string['tokenfiltersubmit'] = 'Prikaži samo tokene koji se podudaraju';
$string['tokenname'] = 'Naziv tokena';
$string['tokennamehint'] = 'Ako ne unesete naziv, koristiće se nasumični naziv.';
$string['tokennameprefix'] = 'Web servis-{$a}';
$string['tokennewmessage'] = 'Sada kopirajte token. Neće se ponovo prikazati kada napustite ovu stranicu.';
$string['unknownoptionkey'] = 'Nepoznat ključ opcije ({$a})';
$string['unnamedstringparam'] = 'Parametar stringa nije imenovan.';
$string['updateusersettings'] = 'Ažuriraj';
$string['uploadfiles'] = 'Može da učita datoteke';
$string['uploadfiles_help'] = 'Ako je ovo podešavanje omogućeno, svaki korisnik može da učita datoteke sa svojim sigurnosnim ključem u svoj privatni prostor za datoteke ili prostor za radne verzije datoteka. Primenjuju se korisničke kvote koje su postavljene.';
$string['userasclients'] = 'Korisnici kao klijenti sa tokenom';
$string['userasclientsdescription'] = 'Sledeći koraci vam pomažu da podesite Moodle veb servis za korisnike kao klijente. Ovi koraci, takođe, pomažu da podesite preporučeni metod za proveru identiteta pomoću tokena (bezbednosnih ključeva). U tom slučaju korisnik će generisati svoj token sa stranice za bezbednosne ključeve putem stranice sa svojim podešavanjima.';
$string['usermissingcaps'] = 'Nedostaju sposobnosti: {$a}';
$string['usernameorid'] = 'Korisničko ime/korisnički ID';
$string['usernameorid_help'] = 'Upiši korisničko ime ili korisnički ID';
$string['usernotallowed'] = 'Korisniku nije dozvoljeno da koristi ovaj servis. Prvo morate da mu dozvolite korišćenje na stranici  za administraciju {$a}.';
$string['userservices'] = 'Korisnički servisi: {$a}';
$string['usersettingssaved'] = 'Korisnička podešavanja su sačuvana';
$string['validuntil'] = 'Važi do';
$string['validuntil_empty'] = 'Ovaj token nema datum isteka.';
$string['validuntil_help'] = 'Ako je podešeno, servis će nakon ovog datuma biti deaktiviran za ovog korisnika.';
$string['webservice'] = 'Web servis';
$string['webservices'] = 'Web servisi';
$string['webservicesoverview'] = 'Pregled';
$string['webservicetokens'] = 'Tokeni za Web servise';
$string['wrongusernamepassword'] = 'Pogrešno korisničko ime ili lozinka';
$string['wsaccessuserdeleted'] = 'Odbijen je pristup veb servisu za obrisano korisničko ime: {$a}';
$string['wsaccessuserexpired'] = 'Odbijen je pristup veb servisu za korisničko ime: {$a} kojem je istekla lozinka';
$string['wsaccessusernologin'] = 'Odbijen je pristup veb servisu za korisničko ime: {$a} kojem je kao metod provere identiteta podešeno \'Bez prijave na sistem\'';
$string['wsaccessusersuspended'] = 'Odbijen je pristup veb servisu za suspendovano korisničko ime: {$a}';
$string['wsaccessuserunconfirmed'] = 'Odbijen je pristup veb servisu za nepotvrđeno korisničko ime: {$a}';
$string['wsclientdoc'] = 'Dokumentacija Moodle Web servis klijenta';
$string['wsdocapi'] = 'API Dokumentacija';
$string['wsdocumentation'] = 'Dokumentacija Web servisa';
$string['wsdocumentationdisable'] = 'Dokumentacija Web servisa je onemogućena';
$string['wsdocumentationintro'] = 'Za kreiranje klijenta preporučujemo Vam da pročitate {$a->doclink}';
$string['wsdocumentationlogin'] = 'ili unesite korisničko ime i lozinku Vašeg Web servisa';
$string['wspassword'] = 'Lozinka za Web servis';
$string['wsusername'] = 'Korisničko ime za Web servis';
