<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'sv', version '4.5'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'Att göra';
$string['activityisscheduledfordeletion'] = 'Borttagning av aktivitet pågår...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" är inte ett giltigt värde för ålder.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" måste ha exakt ett(1) kommatecken.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" är inte ett giltigt värde för land.';
$string['agedigitalconsentmapinvaliddefault'] = 'Standardvärde (*) saknas.';
$string['agelocationverificationdisabled'] = 'Ålder- och platsverifiering inaktiverad.';
$string['alreadyloggedin'] = 'Du är redan inloggad som <em>{$a}</em>. Du måste logga ut innan du kan logga in som en annan användare.';
$string['authnotexisting'] = 'Auktorisationspluginmodulen saknas';
$string['backupcontainexternal'] = 'Denna säkerhetskopia innehåller externa Moodle-nätverksservrar som inte är konfigurerade lokalt';
$string['backuptablefail'] = 'Backuptabellerna kunde INTE konfigureras!';
$string['blockcannotconfig'] = 'Det här blocket stöder inte global konfiguration';
$string['blockcannotinistantiate'] = 'Problem att instansiera blockobjekt';
$string['blockcannotread'] = 'Det gick inte att läsa data för blockid={$a}';
$string['blockdoesnotexist'] = 'Det här blocket finns inte';
$string['blockdoesnotexistonpage'] = 'Det här blocket (id={$a->instanceid}) finns inte på den här sidan ({$a->url}).';
$string['blocknameconflict'] = 'Namnkonflikt: blocket {$a->name} har samma titel som ett befintligt block: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Callback för kommentar avvisade den här kommentaren.';
$string['cannotaddcoursemodule'] = 'Det gick inte att lägga till en ny kursmodul';
$string['cannotaddcoursemoduletosection'] = 'Det gick inte att lägga till den nya kursmodulen till sektionen.';
$string['cannotaddmodule'] = '{$a}-modulen kunde inte läggas till modullistan!';
$string['cannotaddnewmodule'] = 'Det gick inte att lägga till en ny modul {$a}';
$string['cannotaddrss'] = 'Du har inte behörighet att lägga till RSS-flöden';
$string['cannotaddthisblocktype'] = 'Du kan inte lägga till ett {$a}-block till den här sidan.';
$string['cannotassignrole'] = 'Det går inte att tilldela en roll i kurs';
$string['cannotassignrolehere'] = 'Du har inte behörighet att tilldela den här rollen (id = {$a->roleid}) i det här sammanhanget ({$a->context})';
$string['cannotassignselfasparent'] = 'Det går inte att tilldela sig själv som förälder!';
$string['cannotcallscript'] = 'Du kan inte anropa det här skriptet på det här sättet.';
$string['cannotcallusgetselecteduser'] = 'Du kan inte anropa user_selector::get_selected_user om multi select är "true".';
$string['cannotcreatebackupdir'] = 'Kunde inte skapa katalogen för säkerhetskopior. Administratören måste konfigurera filbehörigheterna.';
$string['cannotcreatecategory'] = 'Kategorin infogades inte';
$string['cannotcreatedboninstall'] = '<p>Kan inte skapa databasen.</p>
<p>Den specificerade databasen existerar inte och den givna användaren har inte rättighet att skapa databasen.</p>
<p>Administratören för webbplatsen bör verifiera databaskonfigurationen.</p>';
$string['cannotcreategroup'] = 'Fel vid skapande av grupp';
$string['cannotcreatelangbase'] = 'Fel: Kunde inte skapa huvudkatalogen för språk';
$string['cannotcreatelangdir'] = 'Det går inte att skapa lang-katalogen';
$string['cannotcreateorfindstructs'] = 'Fel i samband med sökning efter eller skapande av sektionsstrukturer för den här kursen';
$string['cannotcreatepopupwin'] = 'Odefinierat element - kan inte skapa pop-up fönster';
$string['cannotcreatesitedir'] = 'Kan inte skapa webbplats-katalog. En administratör kan ändra filrättigheterna.';
$string['cannotcreatetempdir'] = 'Det går inte att skapa temp-katalogen';
$string['cannotcreateuploaddir'] = 'Det går inte att skapa uppladdningskatalogen. Webbplatsadministratören måste åtgärda filbehörigheterna.';
$string['cannotcustomisefiltersblockuser'] = 'Du kan inte anpassa filterinställningar i användar- eller kurskontext.';
$string['cannotdeletebackupids'] = 'Kunde inte ta bort tidigare backup-id.';
$string['cannotdeletecategorycourse'] = 'Det gick inte att ta bort kursen {$a}.';
$string['cannotdeletecategoryquestions'] = 'Det gick inte att ta bort frågor från kategorin {$a}.';
$string['cannotdeletecourse'] = 'Du har inte behörighet att ta bort den här kursen.';
$string['cannotdeletecustomfield'] = 'Fel i sb m borttagande av anpassade fältdata';
$string['cannotdeletedir'] = 'Kan inte ta bort ({$a})';
$string['cannotdeletefile'] = 'Det går inte att ta bort den här filen';
$string['cannotdeleterole'] = 'It cannot be deleted, because {$a}';
$string['cannotdeleterolewithid'] = 'Det gick inte att ta bort rollen med ID {$a}';
$string['cannotdeletethisrole'] = 'Du kan inte ta bort den här rollen eftersom den används av systemet eller så är det den sista rollen med administratörsrättigheter.';
$string['cannotdisableformat'] = 'Standardformatet kan inte inaktiveras.';
$string['cannotdownloadcomponents'] = 'Kan inte ladda ned komponenter';
$string['cannotdownloadlanguageupdatelist'] = 'Det går inte att ladda ner listan över språkuppdateringar från download.moodle.org';
$string['cannotdownloadzipfile'] = 'Kan inte ladda ned ZIP-fil';
$string['cannoteditcomment'] = 'Denna kommentar är inte din egen och du kan inte redigera den!';
$string['cannoteditcommentexpired'] = 'Du kan inte redigera detta. Tidgränsen har löpt ut.';
$string['cannoteditpostorblog'] = 'Du kan inte posta eller redigera bloggar';
$string['cannoteditsiteform'] = 'Du kan inte redigera kursen på webbplatsnivå med hjälp av det här formuläret';
$string['cannotedituserpreferences'] = 'Kan inte redigera den här användarens inställningar';
$string['cannotedityourprofile'] = 'Du kan tyvärr inte redigera din egna profil';
$string['cannotexecduringupgrade'] = 'Kan inte utföras under uppgradering';
$string['cannotfindcategory'] = 'Det går inte att hitta kategoripost från databasen genom ID - {$a}';
$string['cannotfindcomponent'] = 'Hittar inte komponenten';
$string['cannotfindcontext'] = 'Det gick inte att hitta kontext';
$string['cannotfindcourse'] = 'Det går inte att hitta kurs';
$string['cannotfinddocs'] = 'Kan inte hitta dokumentationsfiler för "{$a}"-språket.';
$string['cannotfindgradeitem'] = 'Det går inte att hitta grade_item';
$string['cannotfindgroup'] = 'Kunde inte hitta gruppen';
$string['cannotfindhelp'] = 'Kan inte hitta hjälpfiler för "{$a}"-språket';
$string['cannotfindinfo'] = 'Kan inte hitta information för: "{$a}"';
$string['cannotfindlang'] = 'Kan inte hitta &quot;{$a}&quot; språkpaketet!';
$string['cannotfindteacher'] = 'Det går inte att hitta lärare';
$string['cannotfinduser'] = 'Det går inte att hitta någon användare vid namn "{$a}"';
$string['cannotgeoplugin'] = 'Det går inte att ansluta till geoPlugin-servern på https://www.geoplugin.com. Kontrollera proxyinställningarna eller installera MaxMind GeoLite City-datafilen.';
$string['cannotgetblock'] = 'Kund inte hämta block från databasen';
$string['cannotgetcats'] = 'Kan inte hämta kategoripost';
$string['cannotgetdata'] = 'Kan inte få information';
$string['cannotgradeuser'] = 'Det går inte att sätta betyg på den här användaren';
$string['cannothaveparentcate'] = 'En kurskategori kan inte ha "förälder"!';
$string['cannotimport'] = 'Fel vid import';
$string['cannotimportformat'] = 'Funktionen att importera det här formatet är tyvärr ännu inte implementerad!';
$string['cannotimportgrade'] = 'Fel vid import av betyg';
$string['cannotinsertgrade'] = 'Det går inte infoga ett betygsobjekt utan kurs-ID!';
$string['cannotinsertrate'] = 'Kunde inte infoga ny bedömning ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Det gick inte att infoga ny post-ID {$a}';
$string['cannotmailconfirm'] = 'Fel vid skickande av e-postbekräftelse för lösenordsändring';
$string['cannotmanualctrack'] = 'Den här aktiviteten erbjuder inte manuell spårning av slutförande';
$string['cannotmapfield'] = 'En kollision vid kartläggning har upptäckts - två fält leder till samma betygsobjekt {$a}';
$string['cannotmarktopic'] = 'Kunde inte poängsätta det ämnet i denna kurs';
$string['cannotmigratedatacomments'] = 'Kan inte migrera datamodulskommentarer';
$string['cannotmodulename'] = 'Kan inte hämta modulnamn i byggnavigeringen';
$string['cannotmoduletype'] = 'Kan inte hämta modultyp i byggnavigering';
$string['cannotmovecategory'] = 'Kan inte flytta kategori';
$string['cannotmovecourses'] = 'Kan inte flytta kurser från kategorin de finns i.';
$string['cannotmoverolewithid'] = 'Det går inte att flytta rollen med ID {$a}';
$string['cannotopencsv'] = 'Det går inte att öppna CSV-filen';
$string['cannotopenfile'] = 'Det går inte att öppna filen ({$a})';
$string['cannotopenforwrit'] = 'Kan inte öppna för skrivning: {$a}';
$string['cannotopentemplate'] = 'Kan inte öppna mallfil ({$a})';
$string['cannotopenzip'] = 'Det går inte att öppna ZIP-filen. Detta beror troligtvis på en bugg i ZIP-tillägget på ett 64-bitars OS.';
$string['cannotoverridebaserole'] = 'Det går inte att åsidosätta de grundläggande rollbehörigheterna';
$string['cannotoverriderolehere'] = 'Du har inte tillstånd att åsidosätta den här rollen (id = {$a->roleid}) i det här sammanhanget ({$a->context})';
$string['cannotreadfile'] = 'Det går inte att läsa filen {$a}';
$string['cannotreadtmpfile'] = 'Fel vid läsning av en temporär fil';
$string['cannotreaduploadfile'] = 'Det gick inte att läsa den uppladdade filen';
$string['cannotremovefrommeta'] = 'Kunde inte ta bort den valda kursen från den här metakursen!';
$string['cannotreprocessgrades'] = 'Kunde inte ombearbeta betyg för denna aktivitet {$a}';
$string['cannotresetguestpwd'] = 'Du kan inte återställa lösenordet för gäster';
$string['cannotresetmail'] = 'Fel i sb m återställande av lösenord och e-post till dig';
$string['cannotresetthisrole'] = 'Kan inte återställa denna roll';
$string['cannotrestore'] = 'Ett fel har uppstått och det gick inte att fullfölja återställningen';
$string['cannotrestoreadminorcreator'] = 'Du behöver vara administratör för att återställa till ny kurs!';
$string['cannotrestoreadminoredit'] = 'Du behöver vara kursutvecklare eller administratör för att återställ till vald kurs!';
$string['cannotsaveagreement'] = 'Kunde inte spara ditt medgivande';
$string['cannotsaveblock'] = 'Fel uppstod då blockkonfigurationen skulle sparas';
$string['cannotsavecomment'] = 'Kan inte spara kommentar';
$string['cannotsavedata'] = 'Det går inte att spara data';
$string['cannotsavefile'] = 'Det går inte att spara filen "{$a}"!';
$string['cannotsavemd5file'] = 'Kan inte spara md5-fil';
$string['cannotsavezipfile'] = 'Kan inte spara ZIP-fil';
$string['cannotservefile'] = 'Det går inte att tillhandahålla filen på grund av ett serverkonfigurationsproblem.';
$string['cannotsetparentforcatoritem'] = 'Det går inte att ställa in "förälder" för kategori eller kurskomponent!';
$string['cannotsetpassword'] = 'Det gick inte att ställa in lösenord för användare!';
$string['cannotsetprefgrade'] = 'Kunde inte ange inställningarna för aggregeringsvyn till {$a} för denna betygskategori';
$string['cannotsettheme'] = 'Det gick inte att ställa in temat!';
$string['cannotsetupblock'] = 'Blocktabellerna kunde inte konfigureras framgångsrikt!';
$string['cannotsetupcapformod'] = 'Kunde inte konfigurera funktionsbehörigheterna för {$a}';
$string['cannotsetupcapforplugin'] = 'Kunde inte konfigurera funktionsbehörigheterna för {$a}';
$string['cannotshowhidecoursesincategory'] = 'Det går inte att visa/dölja kurser i kategori {$a}.';
$string['cannotsignup'] = 'Du kan inte skapa ett nytt konto eftersom du redan är inloggad som {$a}.';
$string['cannotunassigncap'] = 'Det gick inte att ta bort tilldelningen av en utgången kapacitet {$a->cap} från rollen {$a->role}';
$string['cannotunassignrolefrom'] = 'Kan inte ta bort rolltilldelningen för denna användare för roll-id: {$a}';
$string['cannotunzipfile'] = 'Det går inte att packa upp filen';
$string['cannotupdatemod'] = 'Det gick inte att uppdatera {$a}';
$string['cannotupdatepasswordonextauth'] = 'Uppdateringen av lösenordet på den externa autentiseringen misslyckades: {$a}. Kontrollera serverloggarna för mer detaljer.';
$string['cannotupdateprofile'] = 'Fel vid uppdatering av post för användare';
$string['cannotupdaterecord'] = 'Kunde inte uppdatera post-id: {$a}';
$string['cannotupdaterss'] = 'Kan inte uppdatera RSS';
$string['cannotupdatesubcourse'] = 'Kunde inte uppdatera en barnkurs!';
$string['cannotupdateusermsgpref'] = 'Kan inte uppdatera meddelandeinställningarna för användare';
$string['cannotupdateuseronexauth'] = 'Uppdateringen av användardata på den externa autentiseringen {$a} misslyckades. Se serverloggarna för mer detaljer.';
$string['cannotuploadfile'] = 'Fel när den uppladdade filen skulle behandlas';
$string['cannotuseadmin'] = 'Du måste vara en administratör för att använda den här sidan';
$string['cannotuseadminadminorteacher'] = 'Du måste vara lärare eller administratör för att använda den här sidan';
$string['cannotusepage'] = 'Endast lärare och administratörer kan använda den här sidan';
$string['cannotusepage2'] = 'Du får tyvärr inte använda den här sidan';
$string['cannotviewcategory'] = 'Du har inte behörighet att visa denna kurslista.';
$string['cannotviewprofile'] = 'Du kan inte visa den här användarens profil';
$string['cannotviewreport'] = 'Du kan inte visa den här rapporten';
$string['cannotwritefile'] = 'Kan inte skriva till filen ({$a})';
$string['categoryerror'] = 'Kategorifel';
$string['categoryidnumbertaken'] = 'ID-numret används redan för en annan kategori';
$string['categorynamerequired'] = 'Kategorinamn är obligatoriskt';
$string['categorytoolong'] = 'Kategorinamnet är för långt';
$string['commentmisconf'] = 'Kommentar ID är felkonfigurerad';
$string['componentisuptodate'] = 'Komponenten är aktuell';
$string['confirmationnotenabled'] = 'Användarbekräftelse är inte aktiverad på denna webbplats';
$string['confirmsesskeybad'] = 'Tyvärr, men sessionsnyckeln kunde inte bekräftas för att utföra den här åtgärden. Den här säkerhetsfunktionen förhindrar oavsiktlig eller skadlig körning av viktiga funktioner i ditt namn. Försäkra dig om att du verkligen ville köra den här funktionen.';
$string['contenttypenotfound'] = 'Innehållstypen \'{$a}\' finns inte eller känns inte igen.';
$string['contentvisibilitynotfound'] = 'Innehållssynligheten med värdet {$a} finns inte eller känns inte igen.';
$string['couldnotassignrole'] = 'Ett allvarligt men odefinierat fel inträffade när en roll skulle tilldelas till dig.';
$string['couldnotupdatenoexistinguser'] = 'Kan inte uppdatera användaren - användaren finns inte';
$string['couldnotverifyagedigitalconsent'] = 'Ett fel uppstod när du försökte verifiera åldern för digitalt samtycke.<br />Vänligen kontakta administratören.';
$string['countriesphpempty'] = 'Fel: Filen countries.php i språkpaketet {$a} är tom eller saknas.';
$string['coursedoesnotbelongtocategory'] = 'Kursen tillhör inte den här kategorin';
$string['courseformatnotfound'] = 'Kursformatet <b>\'{$a}\'</b> finns inte eller känns inte igen';
$string['coursegroupunknown'] = 'Den kurs som hör till grupp {$a} har inte angivits';
$string['courseidnotfound'] = 'Kurs-ID:t finns inte.';
$string['courseidnumbertaken'] = 'ID-numret används redan av en annan kurs ({$a})';
$string['coursemisconf'] = 'Kursen är felkonfigurerad';
$string['courserequestdisabled'] = 'Kursförfrågningar har inaktiverats av administratören';
$string['csvcolumnduplicates'] = 'Vi har upptäckt dubbletter av kolumner';
$string['csvemptyfile'] = 'CSV-filen är tom';
$string['csvfewcolumns'] = 'Det finns inte tillräckligt med kolumner. Vänligen verifiera inställningen för avgränsarna.';
$string['csvfileerror'] = 'Det är något fel med formatet på CSV-filen. Kontrollera antalet rubriker och kolumner som matchar och att avgränsaren samt filkodningen är korrekt. {$a}';
$string['csvinvalidcols'] = '<b>Ogiltig CSV-fil:</b> Första raden måste inkludera "Rubrikfält" och filen måste vara av typen <br />"Expanded Fields/Comma Separated"<br />eller<br /> "Expanded Fields with CAVV Result Code/Comma Separated"';
$string['csvinvalidcolsnum'] = 'Ogiltig CSV-fil - varje rad måste innehålla 49 eller 70 fält';
$string['csvloaderror'] = 'Fel uppstod vid uppladdningen av CSV-filen: {$a}';
$string['csvnodata'] = 'Ogiltig CSV-fil - CSV-filen har rubriker men inga data.';
$string['csvweirdcolumns'] = 'Ogiltigt format för CSV-fil - antalet kolumner är inte konstant.';
$string['dbconnectionfailed'] = '<p> Fel: Databas anslutningen misslyckades </p><p> Det är möjligt att databasen är överbelastad eller på annat sätt inte fungerar ordentligt. </p><p> Administratören bör också kontrollera att databasenuppgifterna har angetts korrekt i config.php </p>';
$string['dbdriverproblem'] = '<p>Fel: Problem med databasdrivrutin upptäckt</p>
<p>Administratören för webbplatsen bör verifiera serverkonfigurationen</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Ett allvarligt databassessionproblem har upptäckts. <br /><br /> Vänligen meddela serveradministratören.';
$string['dbsessionhandlerproblem'] = 'Upprättande av databassessionen misslyckades. <br /><br />Vänligen administratören.';
$string['dbsessionmysqlpacketsize'] = 'Allvarligt sessionsfel upptäckt.<br /><br />Var god notifiera administratören, det här problemet är sannolikt orsakat av ett för litet värde i <var>max_allowed_packet</var>-inställningen för MySQL.';
$string['dbupdatefailed'] = 'Uppdatering av databasen misslyckades';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" kan inte ändras. Beroende hittades med {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'DDL sql exekveringsfel';
$string['ddlfieldalreadyexists'] = 'Fältet "{$a}" finns redan';
$string['ddlfieldnotexist'] = 'Fältet "{$a->fieldname}" finns inte i tabellen "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabellen "{$a}" finns redan';
$string['ddltablenotexist'] = 'Tabellen "{$a}" finns inte';
$string['ddlunknownerror'] = 'Okänt DDL bibliotek fel';
$string['ddlxmlfileerror'] = 'Det fanns fel i XML-databasfilen';
$string['ddsequenceerror'] = 'Felaktig definition för tabell "{$a}"; det får bara finnas en autokolumn och den måste definieras som en nyckel.';
$string['destinationcmnotexit'] = 'Målkursmodulen finns inte.';
$string['detectedbrokenplugin'] = 'Pluginmodulen {$a} är defekt eller inaktuell. Du kan tyvärr inte fortsätta.';
$string['dmlexceptiononinstall'] = '<p>Ett databasfel har inträffat [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Fel vid parsning av SQL-fråga';
$string['dmlreadexception'] = 'Fel vid läsning av databas';
$string['dmltransactionexception'] = 'Fel vid överföring till databas';
$string['dmlwriteexception'] = 'Fel vid skrivning till databasen';
$string['dndmaxbytes'] = 'Filen är för stor. Största tillåtna storlek är {$a->size}';
$string['dndread'] = 'Kunde inte läsa fil';
$string['dndunkownfile'] = 'Filtypen stöds ej';
$string['dndupload'] = 'Ett okänt fel inträffade då filen skulle laddas upp';
$string['downgradedcore'] = 'FEL! Koden som du använder är äldre än den version som skapade dessa databaser!';
$string['downloadedfilecheckfailed'] = 'Kontrollen av den nedladdade filen misslyckades';
$string['duplicatefieldname'] = 'Duplicerat fältnamn "{$a}" upptäcktes';
$string['duplicatenosupport'] = 'Aktiviteten \'{$a->modname}\' kunde inte dupliceras eftersom modulen {$a->modtype} inte har stöd för säkerhetskopiering och återställning.';
$string['duplicateparaminsql'] = 'FEL: duplicerat parameternamn i sökning';
$string['duplicaterolename'] = 'Det finns redan en roll med detta namn!';
$string['duplicateroleshortname'] = 'Det finns redan en roll med detta korta namn!';
$string['duplicateusername'] = 'Dubblett av användarnamn - hoppar över posten';
$string['emailfail'] = 'Misslyckades att skicka e-post';
$string['encryption_decryptfailed'] = 'Misslyckades att dekryptera';
$string['encryption_encryptfailed'] = 'Misslyckades att kryptera';
$string['encryption_invalidkey'] = 'Ogiltig nyckel';
$string['encryption_keyalreadyexists'] = 'Nyckeln existerar redan';
$string['encryption_nokey'] = 'Nyckeln hittades inte';
$string['encryption_wrongmethod'] = 'Data matchar inte en krypteringsmetod som stöds';
$string['enddatebeforestartdate'] = 'Kursens slutdatum måste vara senare än startdatumet.';
$string['error'] = 'Ett fel inträffade';
$string['error_question_answers_missing_in_db'] = 'Det gick inte att hitta ett svar som matchar "{$a->answer}" i question_answers databastabellen. Detta inträffade när frågan med id {$a->filequestionid} återställdes i säkerhetskopian, som har matchats med den befintliga frågan med id {$a->dbquestionid} i databasen.';
$string['errorcleaningdirectory'] = 'Fel i samband med rensning av katalogen "{$a}"';
$string['errorcopyingfiles'] = 'Fel i samband med kopiering av filer';
$string['errorcreatingdirectory'] = 'Fel i samband med skapandet av katalogen  "{$a}"';
$string['errorcreatingfile'] = 'Fel i samband med skapandet av filen  "{$a}"';
$string['errorcreatingrole'] = 'Fel vid skapande av roll';
$string['errorfetchingrssfeed'] = 'Fel vid hämtning av RSS-flöde.';
$string['erroronline'] = 'Fel på rad {$a}';
$string['erroroutput'] = 'Felmeddelande - inaktiverar automatisk omdirigering.';
$string['errorparsingxml'] = 'Fel vid tolkning XML: {$a->errorstring} på rad {$a->errorline}, tecken {$a->errorchar}';
$string['errorprocessingarchive'] = 'Fel vid bearbetning av arkivfil';
$string['errorreadingfile'] = 'Fel i samband med läsningen av filen  "{$a}"';
$string['errorsavingrequest'] = 'Ett fel uppstod vid försök att spara din begäran.';
$string['errorsettinguserpref'] = 'Ett fel uppstod då användarinställningar skulle sparas.';
$string['errorunzippingfiles'] = 'Fel i samband med att filer skulle packas upp';
$string['expiredkey'] = 'Utgången nyckel';
$string['externalauthpassworderror'] = 'Lösenord för extern autentisering (kan ej lämnas tomt)';
$string['externalfilenolocation'] = 'Extern fil har ingen sökväg';
$string['failtoloadblocks'] = 'Ett eller flera block är registrerade i databasen, men inga kunde läsas in!';
$string['fieldrequired'] = '\'{$a}\' är ett obligatoriskt fält';
$string['fileexists'] = 'Det finns en sådan fil';
$string['filemismatch'] = 'Filnamnet för en icke-systemfil matchar inte. Filen "{$a->current}" ska vara {$a->file}';
$string['filenotfound'] = 'Den efterfrågade filen kan tyvärr inte skapas';
$string['filenotreadable'] = 'Det går inte att läsa filen';
$string['filterdoesnothavelocalconfig'] = 'Filtret {$a} kan inte konfigureras lokalt.';
$string['filternotactive'] = 'Filtret {$a} är inte aktiverat.';
$string['filternotenabled'] = 'Filter är inte aktiverat!';
$string['filternotinstalled'] = 'Filtret {$a} är inte installerat.';
$string['forumblockingtoomanyposts'] = 'Du har överskridit inläggströskeln som angivits för detta forum';
$string['functionalityremoved'] = 'Du försöker använda funktionalitet som tagits bort.';
$string['generalexceptionmessage'] = 'Undantag - {$a}';
$string['gradecantregrade'] = 'Ett fel inträffade under beräkning av betyg: {$a}';
$string['gradepubdisable'] = 'Betygspublicering inaktiverad';
$string['gradesneedregrading'] = 'Kursbetygen behöver beräknas om';
$string['groupalready'] = 'Användaren tillhör redan grupp {$a}';
$string['groupexistforcourse'] = 'Det finns redan en grupp "{$a}" i den här kursen.';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Gruppen "{$a->name}" med id-nummer "{$a->idnumber}" existerar redan för den här kursen';
$string['grouphasidnumber'] = 'Gruppen "{$a}" har ett id-nummer och kan ha skapats automatiskt av ett externt system. Du saknar rättigheter för att ta bort denna grupp.';
$string['groupinghasidnumber'] = 'Gruppering &quot;{$a}&quot; har ett idnumber och kan ha skapas automatiskt av ett externt system. Du har inte behörighet att ta bort denna gruppering.';
$string['groupingnotaddederror'] = 'Gruppering "{$a}" inte tillagd';
$string['groupnotaddederror'] = 'Grupp "{$a}" har inte lagts till';
$string['groupnotaddedtogroupingerror'] = 'Grupp "{$a->groupname}" inte tillagd till gruppering "{$a->groupingname}"';
$string['groupunknown'] = 'Grupp {$a} är inte kopplad till den angivna kursen';
$string['groupusernotmember'] = 'Användaren är inte meddlem av denna grupp.';
$string['guestcantaccessprofiles'] = 'Gäster kan inte se användarprofiler. Logga in med ditt användarkonto.';
$string['guestnocomment'] = 'Gäster kan inte skriva inlägg!';
$string['guestnoeditprofile'] = 'Gästanvändare kan inte redigera sin profil';
$string['guestnoeditprofileother'] = 'Gästanvändarens profil går inte att redigera';
$string['guestnorate'] = 'Gäster kan inte betygsätta.';
$string['guestsarenotallowed'] = 'Gästanvändare kan inte göra detta';
$string['hackdetected'] = 'Intrångsförsök upptäckta!';
$string['hashpoolproblem'] = 'Felaktigt innehåll i poolfil {$a}.';
$string['headersent'] = 'Headers är redan skickade';
$string['idnumbertaken'] = 'ID-nummer används redan';
$string['idnumbertoolong'] = 'ID-numret är för långt';
$string['importformatnotimplement'] = 'Tyvärr, import av detta format ännu inte implementerat!';
$string['incorrectext'] = 'Fil(-er) med fel filextension.';
$string['inplaceeditableerror'] = 'Det gick inte att anropa uppdateringshanteraren';
$string['installproblem'] = 'Det är vanligtvis inte möjligt för systemet att återhämta sig från fel som utlösts under installationen. Du kan behöva skapa en ny databas eller använda ett annat databasprefix om du vill försöka installera på nytt.';
$string['internalauthpassworderror'] = 'Lösenord saknas eller ogiltig lösenordspolicy för intern autentisering';
$string['invalidaccess'] = 'Åtkomsten till den här sidan skedde inte på ett korrekt sätt';
$string['invalidaccessparameter'] = 'Ogiltig parameter för åtkomst';
$string['invalidaction'] = 'Ogiltig parameter för åtgärd';
$string['invalidactivityid'] = 'Ogiltig aktivitets-ID';
$string['invalidadminsettingname'] = 'Ogiltig administratörsinställning ({$a})';
$string['invalidargorconf'] = 'Det gavs inga giltiga argument eller det handlar om felaktig serverkonfiguration.';
$string['invalidarguments'] = 'Det gavs inga giltiga argument';
$string['invalidblockinstance'] = 'Ogiltig blockinstans: {$a}';
$string['invalidbulkenrolop'] = 'Ogiltig bulkregistreringsoperation har begärts.';
$string['invalidcategory'] = 'Felaktig kategori!';
$string['invalidcategoryid'] = 'Felaktigt kategori-ID';
$string['invalidcomment'] = 'Felaktig kommentar';
$string['invalidcommentarea'] = 'Ogiltigt kommentarsfält';
$string['invalidcommentid'] = 'Ogiltigt kommentars-id';
$string['invalidcommentitemid'] = 'Ogiltigt kommentarsobjekt-ID';
$string['invalidcommentparam'] = 'Ogiltiga kommentarparametrar';
$string['invalidcomponent'] = 'Ogiltigt komponentnamn';
$string['invalidconfirmdata'] = 'Felaktiga data för bekräftelse';
$string['invalidcontentid'] = 'Ogiltigt innehålls-ID';
$string['invalidcontext'] = 'Ogiltigt sammanhang';
$string['invalidcountrycode'] = 'Felaktig landskod: {$a}';
$string['invalidcourse'] = 'Ogiltig kurs';
$string['invalidcourseformat'] = 'Ogiltigt kursformat';
$string['invalidcourseid'] = 'Du försöker använda en ogiltig kurs-ID';
$string['invalidcourselevel'] = 'Felaktig nivå på sammanhang';
$string['invalidcoursemodule'] = 'Ogiltig ID för kursmodul';
$string['invalidcoursemoduleid'] = 'Ogiltigt ID för kursmodul {$a}';
$string['invalidcoursenameshort'] = 'Ogiltigt kortnamn för kurs';
$string['invaliddata'] = 'De data som har skickats in är ogiltiga';
$string['invaliddatarootpermissions'] = 'Ogiltiga behörigheter upptäcktes när en katalog skulle skapas. Aktivera felsökning för mer information.';
$string['invaliddevicetype'] = 'Ogiltig enhetstyp';
$string['invalidelementid'] = 'Felaktigt element-id';
$string['invalidentry'] = 'Detta är inte ett giltig inmatning!';
$string['invalidevent'] = 'Ogiltig händelse';
$string['invalidfieldname'] = '\'{$a}\' är inte ett giltigt fältnamn';
$string['invalidfiletype'] = '\'{$a}\' är inte en giltig filtyp';
$string['invalidformatpara'] = 'Felaktigt format för välj parameter';
$string['invalidformdata'] = 'Felaktiga formulärdata';
$string['invalidfunction'] = 'Felaktig funktion';
$string['invalidgradeitemid'] = 'Felaktig betygsobjekt-ID';
$string['invalidgroupid'] = 'Ett felaktig grupp-ID har angivits';
$string['invalidipformat'] = 'Ogiltigt format för IP-adress';
$string['invaliditemid'] = 'Felaktigt objekts-ID';
$string['invalidkey'] = 'Felaktig nyckel';
$string['invalidlanguagecode'] = 'Ogiltig språkkod: {$a}';
$string['invalidlegacy'] = 'Felaktig äldre rolldefinition för typ: {$a}';
$string['invalidmd5'] = 'Kontrollvariabeln var felaktig - försök igen';
$string['invalidmode'] = 'Ogiltigt läge ({$a})';
$string['invalidmodule'] = 'Ogiltig modul';
$string['invalidmoduleid'] = 'Ogiltigt modul-ID: {$a}';
$string['invalidmodulename'] = 'Ogiltigt modulnamn: {$a}';
$string['invalidnum'] = 'Ogiltigt numeriskt värde';
$string['invalidnumkey'] = '$conditions-listan får inte innehålla numeriska nycklar. Vänligen korrigera koden!';
$string['invalidoutcome'] = 'Felaktig resultat-ID';
$string['invalidpagesize'] = 'Ogiltig storlek för sida';
$string['invalidpasswordpolicy'] = 'Ogiltig policy för lösenord';
$string['invalidpaymentmethod'] = 'Ogiltig betalningsmetod: {$a}';
$string['invalidpersistenterror'] = 'Fel: {$a}';
$string['invalidqueryparam'] = 'FEL: Felaktigt antal frågeparametrar. Förväntad {$a->expected} fick {$a->actual}.';
$string['invalidratingarea'] = 'Ogiltig betygsområde';
$string['invalidrecord'] = 'Kan inte hitta datapost i databastabellen {$a}.';
$string['invalidrecordunknown'] = 'Kan inte hitta post i databasen.';
$string['invalidrequest'] = 'Ogiltig förfrågan';
$string['invalidrole'] = 'Ogiltig roll';
$string['invalidroleid'] = 'Ogiltig ID för roll';
$string['invalidscaleid'] = 'Felaktigt ID för skala';
$string['invalidsection'] = 'Post för kursmodul innehåller ogiltig sektion';
$string['invalidsesskey'] = 'Din session har löpt ut. Vänligen logga in igen.';
$string['invalidshortname'] = 'Ogiltigt kortnamn för kurs';
$string['invalidsourcefield'] = 'Utkastfilens källa är ogiltigt';
$string['invalidstatedetected'] = 'Något har gått fel: {$a}. Detta bör aldrig normalt inträffa.';
$string['invalidurl'] = 'Ogiltig URL';
$string['invaliduser'] = 'Ogiltig användare';
$string['invaliduserdata'] = 'Ogiltiga användardata: {$a}';
$string['invaliduserfield'] = 'Ogiltig användarfält: {$a}';
$string['invaliduserid'] = 'Ogiltigt användar-ID';
$string['invalidusername'] = 'Det givna användarnamnet innehåller ogiltiga tecken';
$string['invalidusernameblank'] = 'Användarnamnet kan inte vara tomt';
$string['invalidxmlfile'] = '\'{$a}\' är inte en giltig XML-fil';
$string['iplookupfailed'] = 'Det går inte att hitta någon information om den här IP-adressen {$a}.';
$string['iplookupprivate'] = 'Det går inte att visa sökning av privat IP-adress.';
$string['ipmismatch'] = 'Klientens IP-adress stämmer ej';
$string['listcantmovedown'] = 'Det gick inte att flytta ner posten. Den är den sista på denna nivå.';
$string['listcantmoveleft'] = 'Det gick inte att flytta posten åt vänster. Den har ingen förälder.';
$string['listcantmoveright'] = 'Det gick inte att flytta posten åt höger. Det finns ingen post på samma nivå att göra om till en underliggande post. Flytta den nedanför en annan post på samma nivå. Därefter kan du flytta den åt höger.';
$string['listcantmoveup'] = 'Det gick inte att flytta upp posten. Den är den första av posterna på sin nivå.';
$string['listnochildren'] = 'Det gick inte att hitta några barn till listposten';
$string['listnoitem'] = 'Listposten hittades inte';
$string['listnopeers'] = 'Det gick inte att hitta några poster på samma nivå';
$string['listupdatefail'] = 'DB-operationen misslyckades när listhierarkin skulle redigeras.';
$string['logfilenotavailable'] = 'Loggar ej tillgängliga';
$string['loginasnoenrol'] = 'Du kan inte använda \'registrera\' eller \'avregistrera\' när du är i en session för \'logga in som\' för kurs.';
$string['loginasonecourse'] = 'Du har inte tillträde till den här kursen.<br/ > Du måste avsluta sessionen \'Logga in som\' innan du kan få tillträde till någon annan kurs.';
$string['maxareabytes'] = 'Filen är större än det kvarvarande utrymmet i den här arean.';
$string['maxbytesfile'] = 'Filen {$a->file} är för stor. Den största tillåtna storleken på en uppladdad fil är {$a->size}.';
$string['maxdraftitemids'] = 'På grund av att du laddat upp en stor mängd filer är dina filuppladdningar tillfälligt begränsade. Försök igen om en liten stund.';
$string['messageundeliveredbynotificationsettings'] = 'Det gick inte att skicka meddelandet eftersom personliga meddelanden mellan användare (i \'Inställningar för notiser\') har inaktiverats av en webbplatsadministratör.';
$string['messagingdisable'] = 'Meddelanden har inaktiverats på den här webbplatsen';
$string['mimetexisnotexist'] = 'Systemet är inte konfigurerat för att köra mimeTeX. Du måste hämta källkoden från <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a> och sedan kompilera den. Placera sedan programfilen i katalogen <em>moodle/filter/tex/</em> på servern.';
$string['mimetexnotexecutable'] = 'Anpassad mimetex är inte körbar!';
$string['missing_moodle_backup_xml_file'] = 'Säkerhetskopian saknar XML-fil: {$a}';
$string['missingcategoryrole'] = 'Kunde inte tilldela roll till användare. Roll för kategorin saknas.';
$string['missingfield'] = 'Fältet "{$a}" saknas';
$string['missingkeyinsql'] = 'FEL: parameter "{$a}" saknas i frågan';
$string['missingparam'] = 'En obligatorisk parameter ({$a}) saknades';
$string['missingparameter'] = 'Parameter saknas';
$string['missingrequiredfield'] = 'Det saknas några obligatoriska fält';
$string['missinguseranditemid'] = 'Userid och itemid saknas';
$string['missingvarname'] = 'Obligatorisk variabelnamn saknas!';
$string['mixedtypesqlparam'] = 'FEL: Blandade typer av SQL frågeparametrar!';
$string['mnetdisable'] = 'MNET är inaktiverat';
$string['mnetlocal'] = 'Externa MNET-användare kan inte logga in lokalt';
$string['moduledisable'] = 'Denna modul ({$a}) har inaktiverats för den aktuella kursen';
$string['moduledoesnotexist'] = 'Denna modul finns inte';
$string['moduleinstancedoesnotexist'] = 'Denna modulinstans existerar inte';
$string['modulemissingcode'] = 'Modulen {$a} saknar den kod som behövs för den här  funktionen.';
$string['movecatcontentstoroot'] = 'Att flytta kategoriinnehållet till roten är inte tillåtet. Du måste flytta innehållet till en existerande kategori!';
$string['movecatcontentstoselected'] = 'Visst kategoriinnehåll kan inte flyttas till den valda kategorin.';
$string['movecategorynotpossible'] = 'Du kan inte flytta kategorin \'{$a}\' till den valda kategorin.';
$string['movecategoryownparent'] = 'Du kan inte göra kategorin \'{$a}\' till en förälder till sig själv.';
$string['movecategoryparentconflict'] = 'Du kan inte göra kategorin \'{$a}\' till en underkategori till en av dess egna underkategorier.';
$string['mssqlrcsmodemissing'] = 'Databasen använder inte det förväntade <em>READ_COMMITTED_SNAPSHOT</em>-läget. Detta kan leda till felaktiga resultat, i synnerhet under perioder med en stor mängd samtidiga databasanrop. Aktivera detta läge för ett korrekt beteende. För mer information, se <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Installera MSSQL för PHP</a>.';
$string['multiplerecordsfound'] = 'Flera poster hittades, endast en post förväntades.';
$string['multiplerestorenotallow'] = 'Flera samtidiga återställningar är inte tillåtna.';
$string['mustbeloggedin'] = 'Du måste vara inloggad för att göra detta';
$string['mustbeteacher'] = 'Du måste vara lärare för få tillgång till den här sidan.';
$string['myisamproblem'] = 'Databastabellerna använder MyISAM databasmotorn, det är rekommenderat att använda en ACID-kompatibel databasmotor med fullt transaktionsstöd som InnoDB.';
$string['needcopy'] = 'Du måste kopiera något först!';
$string['needcoursecategroyid'] = 'Antingen kurs-id eller kategori måste anges';
$string['needphpext'] = 'Du måste lägga till {$a} stöd till din PHP-installation';
$string['noadmins'] = 'Inga administratörer!';
$string['noblocks'] = 'Inga block hittas!';
$string['nocapabilitytousethisservice'] = 'Användaren har inte den nödvändiga förmågan att använda den här tjänsten';
$string['nocategorydelete'] = 'Kategorin \'{$a}\' kan inte tas bort!';
$string['nocontext'] = 'Den där kursen är tyvärr inte ett giltigt sammanhang.';
$string['nodata'] = 'Inga data';
$string['noexistingcategory'] = 'Ingen befintlig kategori';
$string['nofile'] = 'Filen är inte specificerat';
$string['nofiltersenabled'] = 'Inga filter är aktiverade.';
$string['nofolder'] = 'Begärd katalog finns inte';
$string['noformdesc'] = 'Ingen formulärbeskrivningsfil för formslib hittad för den här aktiviteten.';
$string['noguest'] = 'Inga gäster här!';
$string['noinstances'] = 'Det finns inga instanser av {$a} i den här kursen!';
$string['nologinas'] = 'Du är inte behörig att logga in som den användaren';
$string['nonmeaningfulcontent'] = 'Inget meningsfullt innehåll';
$string['noparticipants'] = 'Inga deltagare hittades för denna kurs';
$string['noparticipatorycms'] = 'Du har tyvärr inga deltagande kursmoduler att rapportera för';
$string['nopermissions'] = 'Du har tyvärr inte behörighet att göra detta ({$a})';
$string['nopermissiontoaccesspage'] = 'Du har inte behörighet att visa den här sidan.';
$string['nopermissiontocomment'] = 'Du kan inte lägga till kommentarer';
$string['nopermissiontodelentry'] = 'Du kan inte ta bort den här kommentaren!';
$string['nopermissiontoeditcomment'] = 'Du kan inte redigera andras kommentarer!';
$string['nopermissiontohide'] = 'Ingen behörighet att dölja!';
$string['nopermissiontoimportact'] = 'Du har inte behörighet att importera aktiviteter till kursen';
$string['nopermissiontolock'] = 'Ingen behörighet att låsa!';
$string['nopermissiontomanagegroup'] = 'Du har inte behörighet att hantera grupper';
$string['nopermissiontorate'] = 'Bedömning av objekt är inte tillåtet!';
$string['nopermissiontoshow'] = 'Ingen behörighet att se detta!';
$string['nopermissiontounlock'] = 'Ingen behörighet för att låsa upp!';
$string['nopermissiontoupdatecalendar'] = 'Ledsen, men du har för närvarande inte behörighet att uppdatera kalenderhändelsen';
$string['nopermissiontoviewcalendar'] = 'Tyvärr, men du har inte behörighet att visa kalenderhändelsen.';
$string['nopermissiontoviewgrades'] = 'Kan inte visa betyg.';
$string['nopermissiontoviewletergrade'] = 'Tillåtelse att visa bokstavsbetyg saknas';
$string['nopermissiontoviewpage'] = 'Du har inte tillstånd att se denna sida';
$string['nosite'] = 'Kan inte hitta en toppnivå-kurs!';
$string['nositeid'] = 'Ingen plats-ID';
$string['nostartdatenoenddate'] = 'Det behövs ett startdatum för kursen innan du kan sätta ett slutdatum.';
$string['nostatstodisplay'] = 'Tyvärr, det finns inga tillgängliga data att visa';
$string['notallowedtoupdateprefremotely'] = 'Du är inte tillåten att uppdatera den här användarinställningen på distans';
$string['notavailable'] = 'Detta är inte tillgängligt f.n.';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Du är inte medlem i denna kursgrupp';
$string['notownerofkey'] = 'Du är inte ägare till denna nyckel';
$string['nousers'] = 'Ingen sådan användare!';
$string['oauth1accesstoken'] = 'OAuth 1.0-fel: Åtkomsttoken kunde inte erhållas.';
$string['oauth1requesttoken'] = 'OAuth 1.0-fel: Vi fick inget förfrågningstoken - tjänsteleverantören kan vara tillfälligt otillgänglig.';
$string['oauth2refreshtokenerror'] = 'Det gick inte att uppdatera OAuth 2-token. HTTP-status för ändpunkten: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Det gick inte att uppdatera OAuth 2-token för en eller flera utfärdare. Se utdata från aktiviteten för mer information.';
$string['oauth2upgradetokenerror'] = 'Det gick inte att uppgradera OAuth 2-token. HTTP-status för ändpunkten: {$a}';
$string['onlyadmins'] = 'Det är endast administratörer som kan göra detta.';
$string['onlyeditingteachers'] = 'Det är bara lärare som kan göra detta.';
$string['onlyeditown'] = 'Du kan bara redigera din egen information';
$string['orderidnotfound'] = 'Ordernummer {$a} hittades inte';
$string['pagenotexist'] = '<p>Ett ovanligt fel inträffade (ett försök att nå en sida som inte finns).</p>{$a}';
$string['pagenotexisttitle'] = '404-fel: Filen kunde inte hittas';
$string['pathdoesnotstartslash'] = 'Inga giltiga argument tillhandahölls, sökvägen börjar inte med snedstreck!';
$string['pleasereport'] = 'Om du har tid, var då snäll och låt oss få veta när felet uppträdde.';
$string['pluginrequirementsnotmet'] = 'Det gick inte att installera "{$a->pluginname}" ({$a->pluginversion}). Den kräver en nyare version av Moodle. Du använder f.n. {$a->currentmoodle} och du behöver {$a->requiremoodle} .';
$string['pluginunsupported'] = 'Pluginmodulen "{$a->pluginname}" {$a->pluginversion} stöder inte den här versionen av Moodle ({$a->moodleversion}). Se dokumentationen för aktuell plugin för information om vilka versioner som stöds.';
$string['prefixcannotbeempty'] = '<p>Fel: prefix för databastabell får inte vara tomt ({$a})</p>
<p>Administratören för webbplatsen måste åtgärda det här problemet.</p>';
$string['prefixtoolong'] = '<p>Fel: prefix för databastabell är för långt ({$a->dbfamily})</p>
<p>Administratören för webbplatsen måste åtgärda det här problemet. Maximal längd för tabellprefix i {$a->dbfamily} är {$a->maxlength} tecken.</p>';
$string['privatefilesupload'] = 'Uppladdning direkt till användarens privata filområde stöds inte längre. Ladda upp till ett utkastområde och flytta sedan filerna med <code>core_user::add_user_private_files</code>.';
$string['processingstops'] = 'Processandet upphör här.  De återstående posterna har inte ändrats.';
$string['protected_cc_not_supported'] = 'Säkra kort stöds inte';
$string['querystringcannotbeempty'] = 'Frågesträngen får inte vara tom.';
$string['redirecterrordetected'] = 'Omdirigering utan stöd upptäcktes, skriptet avslutades';
$string['refoundto'] = 'Kan återbetalas till {$a}';
$string['refoundtoorigi'] = 'Återbetalas till ursprungligt belopp: {$a}';
$string['registrationdisabled'] = 'Registrering är inaktiverad på den här webbplatsen';
$string['remotedownloaderror'] = 'Nedladdningen av en komponent till din server misslyckades. Vänligen verifiera inställningar för proxy. <br /><br />Du måste ladda ner <a href="{$a->url}">{$a->url}</a> filen manuellt, kopiera den till "{$a->dest}" på din server och packa upp den där.';
$string['remotedownloadnotallowed'] = 'De är inte tillåtet att ladda upp komponenter till din server (allow_url_fopen är inaktiverad). Du måste ladda ner filen <a href="{$a->url}">{$a->url}</a> manuellt, kopiera den till "{$a->dest}" på din server och packa upp den där.';
$string['reportnotavailable'] = 'Den här typen av rapport är endast tillgänglig för webbplatskursen';
$string['requirecorrectaccess'] = 'Ogiltig webbadress eller port.';
$string['requireloginerror'] = 'Kurs eller aktivitet inte tillgänglig.';
$string['restore_path_element_missingmethod'] = 'Återställningsmetod {$a} saknas. Den måste definieras av en utvecklare.';
$string['restore_path_element_noobject'] = 'Återställningsobjekt {$a} är inte ett objekt.';
$string['restorechecksumfailed'] = 'Ett problem uppstod med återställningsinformationen som lagras i sessionen. Kontrollera storleksgränserna för PHP-minne/DB-paket. Återställningen har stoppats.';
$string['restrictedcontextexception'] = 'Tyvärr, exekvering av extern funktion bryter mot kontextrestriktion.';
$string['restricteduser'] = 'Ditt nuvarande konto "{$a}" är förhindrat från att göra det';
$string['reverseproxyabused'] = 'Omvänd proxy är aktiverat, så servern inte kan nås direkt.<br>Kontakta administratören.';
$string['rpcerror'] = 'Din MNET kommunikation har misslyckats! Här är det ett felmeddelande att föra vidare till administratören: {$a}';
$string['scheduledbackupsdisabled'] = 'Schemalagda säkerhetskopieringar har inaktiverats av administratören';
$string['secretalreadyused'] = 'Länken för bekräftelse av ändring av lösenord var redan använd, lösenordet ändrades inte';
$string['sectionnotexist'] = 'Detta avsnitt finns inte';
$string['sendmessage'] = 'Skicka meddelande';
$string['sendmessagesent'] = 'Tack för din återkoppling angående:<br>{$a}';
$string['serverconnection'] = 'Fel vid anslutning till servern';
$string['servicedonotexist'] = 'Tjänsten finns inte';
$string['sessioncannotobtainlock'] = '<p>Det gick inte att hämta lås för sessions-id {$a->id} inom {$a->acquiretimeout}.</p>
<p>Det är troligt att en annan sida ({$a->whohaslock}) fortfarande körs på en annan webbläsarflik, eller att det inte släpptes på grund av ett fel.</p>
<p>Du kan vänta till tidsgränsen för sessionslåset ({$a->lockexpire}) infaller, eller så kan du starta om webbläsaren. Om det här felet kvarstår, meddela serveradministratören.</p>';
$string['sessioncookiesdisable'] = 'Felaktig användning av require_key_login() - sessions-cookies måste inaktiveras!';
$string['sessiondiskfull'] = 'Sessionspartitionen är full. Just nu är det inte möjligt att logga in. Kontakta administratören.';
$string['sessionerroruser'] = 'Tidsgränsen för din session har löpt ut. Vänligen logga in igen.';
$string['sessionerroruser2'] = 'Ett fel på servernivå som påverkar din session för inloggning har upptäckts. V.g. logga in igen och starta om din webbläsare.';
$string['sessionexpired'] = 'Sessionen har löpt ut';
$string['sessionhandlerproblem'] = 'Sessionshanteraren är felkonfigurerad';
$string['sessionipnomatch'] = 'Tyvärr, men ditt IP-nummer verkar ha ändrats från när du först loggade in. Den här säkerhetsfunktionen förhindrar att hackare stjäl din identitet när de är inloggade på den här webbplatsen. Vanliga användare bör inte se det här meddelandet. Be webbplatsadministratören om hjälp.';
$string['sessionipnomatch2'] = '<p>Tyvärr, men ditt IP-nummer verkar ha ändrats från när du först loggade in. Den här säkerhetsfunktionen förhindrar att hackare stjäl din identitet när de är inloggade på den här webbplatsen. Det här felet kan visas om du använder trådlösa nätverk eller om du hoppar mellan olika nätverk. Be webbplatsadministratören om hjälp.</p>
<p>Om du vill fortsätta trycker du på <kbd>F5</kbd> för att uppdatera den här sidan.</p>';
$string['sessionwaiterr'] = 'Timeout i väntan på sessionslås.<br />Vänta till din nuvarande förfrågan avslutats och försök igen senare.';
$string['shortnametaken'] = 'Kortnamnet används redan i en annan kurs ({$a})';
$string['sitepolicynotagreed'] = 'Webbplatsolicy ej godkänd: <a href="{$a}">Klicka här för att visa webbplatspolicyn.</a>';
$string['socksnotsupported'] = 'SOCKS5 proxy stöds inte i PHP4';
$string['spellcheckernotconf'] = 'Stavningskontrollen är inte konfigurerad';
$string['sslonlyaccess'] = 'Av säkerhetsskäl endast HTTPS-anslutningar är tillåtna.';
$string['statscatchupmode'] = 'Statistiken håller f.n på att uppdateras. Hittills har {$a->daysdone} dagar behandlats och  {$a->dayspending} återstår att behandla. Du kan snart komma tillbaka och kontrollera detta igen!';
$string['statsdisable'] = 'Statistikfunktionerna är inte aktiverade.';
$string['statsnodata'] = 'Det finns inga tillgängliga data för denna kombination av kurs och tidsperiod';
$string['storedfilecannotcreatefile'] = 'Kan inte skapa lokal filpool. Vänligen kontrollera filrättigheterna i dataroot-katalogen samt tillgängligt diskutrymme.';
$string['storedfilecannotcreatefiledirs'] = 'Kan inte skapa lokala filpoolskataloger. Vänligen kontrollera filrättigheterna i dataroot-katalogen.';
$string['storedfilecannotread'] = 'Det går inte att läsa filen. Antingen saknas filen eller så finns det ett behörighetsproblem.';
$string['storedfilecannotreadfile'] = 'Det går inte att läsa filen \'{$a}\'. Antingen saknas filen eller så finns det ett behörighetsproblem.';
$string['storedfilenotcreated'] = 'Kan inte skapa filen <em>{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}</em>';
$string['storedfileproblem'] = 'Okänt undantag relaterat till lokala filer ({$a})';
$string['tagdisabled'] = 'Taggar har inaktiveras!';
$string['tagnotfound'] = 'Den specificerade etiketten gick inte att hitta i databasen.';
$string['targetdatabasenotempty'] = 'Destinationsdatabasen är inte tom. Flytt avbruten av säkerhetsskäl.';
$string['textconditionsnotallowed'] = 'Jämförelser av textkolumner är inte tillåtna. Var god använd sql_compare_text() i din fråga.';
$string['themenotinstall'] = 'Detta tema är inte installerat!';
$string['tokengenerationfailed'] = 'Det går inte att skapa en ny token.';
$string['transactionvoid'] = 'Transaktionen kan inte annulleras eftersom den redan har annullerats';
$string['unenrolerror'] = 'Ett fel uppstod vid avregistrering sv personen';
$string['unicodeupgradeerror'] = 'Din databas är tyvärr ännu inte i Unicode och den här versionen av Moodle kan inte överföra din databas till Unicode. Vänligen uppgradera till Moodle 1.7.x först och genomför övergången till Unicode  via sidan för administration. Därefter bör du kunna överföra databasen till Moodle {$a}.';
$string['unknowaction'] = 'Okänd åtgärd!';
$string['unknowcategory'] = 'Kategori inte känd!';
$string['unknowcontext'] = 'Det här är en okänd kontext ({$a}) i get_child_contexts!';
$string['unknowformat'] = 'Format inte känt ({$a})';
$string['unknownbackupexporterror'] = 'Okänt fel vid förberedelse av information för import';
$string['unknownblockregion'] = 'Blockregionen \'{$a}\' kändes inte igen på den här sidan.';
$string['unknowncategory'] = 'Okänd kategori för kategori-ID "{$a}"';
$string['unknowncontext'] = 'Detta är en okänd kontext.';
$string['unknowncourse'] = 'Okänd kurs som kallas "{$a}"';
$string['unknowncourseidnumber'] = 'Okänt kurs-ID "{$a}"';
$string['unknowncourserequest'] = 'Okänd kursförfrågan';
$string['unknowncoursesection'] = 'Okänd kurssektion i kursen "{$a}"';
$string['unknownevent'] = 'Okänd händelse';
$string['unknownfiletype'] = 'Fel, okänd filtertyp';
$string['unknowngroup'] = 'Okänd grupp "{$a}"';
$string['unknownhelp'] = 'Okänt hjälpavsnitt {$a}';
$string['unknownjsinrequirejs'] = 'Kan inte hitta JavaScript-bibliotek: {$a}';
$string['unknownmodulename'] = 'Okänt modulnamn för formulär';
$string['unknownrole'] = 'Okänd roll "{$a}"';
$string['unknownsortcolumn'] = 'Okänd sorteringskolumn {$a}';
$string['unknownuseraction'] = 'Jag förstår tyvärr inte denna användaråtgärd';
$string['unknownuserselector'] = 'Okänd användarväljare';
$string['unknoworder'] = 'Okänd sorteringsordning';
$string['unknowparamtype'] = 'Okänd parameter typ: {$a}';
$string['unknowquestiontype'] = 'Frågetyp {$a} stöds inte';
$string['unknowuploadaction'] = 'Fel: Okänt uppladdningsåtgärd ({$a})';
$string['unspecifycourseid'] = 'Du måste ange kursen id, kortnamn eller id-number';
$string['unsupportedevent'] = 'Händelsetyp stöds inte';
$string['unsupportedstate'] = 'Status för slutförande stöds ej';
$string['unsupportedwebserver'] = 'Webbserver programvara ({$a}) stöds inte, tyvärr.';
$string['upgraderequires19'] = 'Fel: Ny Moodle version installerad på servern, uppgradering från den tidigare versionen stöds inte. <br /> Uppgradera först till senaste 1.9.x versionen. Du kan också gå tillbaka till tidigare version genom att installera originalfilerna.';
$string['upgraderunning'] = 'Webbplatsen uppgraderas, försök igen senare.';
$string['urlnotdefinerss'] = 'URL inte definierad för RSS-flöde';
$string['useradmineditadmin'] = 'Endast administratörer får modifiera andra administratörskonton';
$string['useradminodelete'] = 'Administratörskonton kan inte tas bort.';
$string['userautherror'] = 'Okänd plugin för autentisering';
$string['userauthunsupported'] = 'Denna plugin för autentisering stöds inte här.';
$string['useremailduplicate'] = 'Dublett av adress';
$string['userisfilteredout'] = 'Den här användaren matchar inte filter och tabellinställningar!';
$string['usermustbemnet'] = 'Användare i MNET åtkomstlistan måste vara fjärr MNET-användare';
$string['usernamelowercase'] = 'Användarnamnet måste skrivas med små bokstäver';
$string['usernotaddederror'] = 'Användare inte tillagd - fel';
$string['usernotaddedregistered'] = 'Användaren har inte lagts till eftersom denne/a redan är registrerad';
$string['usernotavailable'] = 'Detaljerna kring denne användare är inte tillgängliga för dig.';
$string['usernotdeletedadmin'] = 'Användaren har inte tagits bort eftersom administratörskonton inte kan tas bort.';
$string['usernotdeleteddeleted'] = 'Användaren har redan tagits bort.';
$string['usernotdeletederror'] = 'Användaren togs inte bort - fel';
$string['usernotdeletedmissing'] = 'Användaren togs inte bort - det gick inte att hitta användarnamnet';
$string['usernotdeletedoff'] = 'Användaren har inte tagits bort - det är inte tillåtet att ta bort';
$string['usernotfullysetup'] = 'Användare inte färdigkonfigurerad';
$string['usernotincourse'] = 'Denna användare finns inte i den här kursen!';
$string['usernotrenamedadmin'] = 'Det går inte att byta namn på ett konto för administratörer';
$string['usernotrenamedexists'] = 'Användarnamnet har inte ändrats eftersom det angivna namnet redan används';
$string['usernotrenamedmissing'] = 'Användarnamnet har inte ändrats eftersom det inte gick att hitta det gamla namnet';
$string['usernotrenamedoff'] = 'Användarens namn har inte bytts ut - det är inte tillåtet att ta byta namn.';
$string['usernotupdatedadmin'] = 'Det går inte att uppdatera ett konto för administratörer';
$string['usernotupdatederror'] = 'Användaren uppdaterades inte - okänt fel';
$string['usernotupdatednotexists'] = 'Användare har inte uppdaterats - den finns inte';
$string['userquotalimit'] = 'Du har nått gränsen för din filkvot.';
$string['userselectortoomany'] = 'user_selector har mer än en vald användare trots att multiselect har värdet falskt.';
$string['verifyagedigitalconsentnotpossible'] = 'Tyvärr är verifiering av samtycke för digital ålder inte möjlig just nu.';
$string['wrongcall'] = 'Detta skript anropas felaktigt';
$string['wrongcontextid'] = 'Kontext-ID var felaktig (kan inte hitta den)';
$string['wrongdestpath'] = 'Fel målsökväg';
$string['wrongroleid'] = 'Felaktig roll-ID!';
$string['wrongsourcebase'] = 'Felaktig käll- URL rot';
$string['wrongusernamepassword'] = 'Fel användarnamn/lösenord';
$string['wrongzipfilename'] = 'Felaktigt namn på ZIP-fil';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Kunde inte skapa kurs - Ingen behörighet';
$string['wwwrootmismatch'] = 'Felaktig åtkomst har upptäckts, denna server kan nås endast genom "{$a}" adressen.<br /> Vänligen meddela serveradministratören.';
$string['wwwrootslash'] = 'Upptäckte felaktig $CFG->wwwroot i config.php, den får inte innehålla ett avslutande snedstreck.<br />Var god notifiera serveradministratören.';
$string['xmldberror'] = 'XMLDB fel!';
$string['youcannotdeletecategory'] = 'Du kan inte radera kategorin \'{$a}\' eftersom du kan varken radera innehållet eller flytta dem någon annanstans.';
