<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'mnet', language 'sk', version '4.5'.
 *
 * @package     mnet
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['RPC_HTTPS_SELF_SIGNED'] = 'HTTPS (samopodpísané)';
$string['RPC_HTTPS_VERIFIED'] = 'HTTPS (podpísané)';
$string['RPC_HTTP_PLAINTEXT'] = 'HTTP (nešifrované)';
$string['RPC_HTTP_SELF_SIGNED'] = 'HTTP (samopodpísané)';
$string['RPC_HTTP_VERIFIED'] = 'HTTP (podpísané)';
$string['aboutyourhost'] = 'O vašom serveri';
$string['accesslevel'] = 'Úroveň prístupu';
$string['addhost'] = 'Pridať hostiteľa';
$string['addnewhost'] = 'Pridať nového hostiteľa';
$string['addtoacl'] = 'Pridať na zoznam pre riadenie prístupu';
$string['allhosts'] = 'Všetci hostitelia';
$string['allhosts_no_options'] = 'Pri prezeraní viacerých hostiteľov nie sú dostupné žiadne voľby';
$string['allow'] = 'Povoliť';
$string['applicationtype'] = 'Typ aplikácie';
$string['authfail_nosessionexists'] = 'Prihlasovanie neuspelo: Session mnet neexistuje';
$string['authfail_sessiontimedout'] = 'Prihlasovanie neuspelo: Session mnet vypršala.';
$string['authfail_usermismatch'] = 'Prihlasovanie neuspelo: používateľ nebol nájdený.';
$string['authmnetdisabled'] = 'Autentizačný modul MNet <strong>nie je povolený</strong>.';
$string['badcert'] = 'Toto nie je platný certifikát';
$string['certdetails'] = 'Detaily certifikátu';
$string['configmnet'] = 'MNET dovoľuje komunikáciu tohto servera s inými servermi alebo službami.';
$string['couldnotgetcert'] = 'Na <br />{$a} <br /> nebol nájdený certifikát. Hostiteľ môže byť nesprávne nakonfigurovaný.';
$string['couldnotmatchcert'] = 'Toto neodpovedá certifikátu, publikovanému webserverom.';
$string['courses'] = 'kurzy';
$string['courseson'] = 'kurzy na';
$string['current_transport'] = 'Súčasný transport';
$string['currentkey'] = 'Súčasný verejný kľúč';
$string['databaseerror'] = 'Nie je možné zapísať detaily do databázy';
$string['deleteaserver'] = 'Odstraňujem server';
$string['deletedhostinfo'] = 'Tento server bol odstránený. Ak chcete odstránenie zrušiť, prepnite odstránený stav späť na "Nie".';
$string['deletedhosts'] = 'Zrušené servery: {$a}';
$string['deletehost'] = 'Vymazať server';
$string['deletekeycheck'] = 'Určite chcete odstrániť tento kľúč?';
$string['deleteoutoftime'] = '60 sekundové okno pre odstránenie tohto kľúča vypršalo.';
$string['deleteuserrecord'] = 'SSO ACL: odstrániť záznam pre používateľa  \'{$a->user}\' z {$a->host}.';
$string['deletewrongkeyvalue'] = 'Vyskytla sa chyba. Ak ste sa nesnažili odstrániť SSL kľúč Vašeho servera, stali ste sa cieľom útoku. Nič sa nestalo';
$string['deny'] = 'Zakázať';
$string['description'] = 'Opis';
$string['duplicate_usernames'] = 'Nepodarilo sa vytvoriť index na stĺpcoch "mnethostid" a "username" vo vašich používateľských tabuľkách.<br />Toto sa môže stať ak máte <a href="{$a}" target="_blank">zdvojené používateľské mená vo vašich tabuľkách</a>.<br />Váš upgrade by sa mal aj tak ukončiť úspešne. Kliknite na odkaz vyššie a zjavia sa Vám inštrukcie na odstránenie tohto problému v novom okne. Môžete počkať na koniec upgrade.<br />';
$string['enabled_for_all'] = '(Táto služba bola povolená pre všetkých hostiteľov).';
$string['enterausername'] = 'Prosím vložte meno používateľa alebo zoznam používateľských mien oddelených čiarkami';
$string['error7020'] = 'Táto chyba sa zvyčajne objavuje, ak vzdialený portál vytvoril pre Vás záznam s nesprávnym www koreňom, napríklad, http://yoursite.com namiesto http://www.yoursite.com. Mali by ste kontaktovať administrátora externej strany s Vašim www koreňom (ako je špecifikované v config.php) s požiadavkou na aktualizovanie jeho záznamu pre vášho hostiteľa.';
$string['error7022'] = 'Vaša správa pre vzdialený portál bola zakryptovaná, ale nebola podpísaná. Toto je veľmi nezvyčajné; možno by ste mali vytvoriť správu o chybe (dodať toľko informácii, koľko je možné, o vašej Moodle verzii).';
$string['error7023'] = 'Vzdialený portál sa pokúsil dekódovať vašu správu so všetkými kľúčmi ktoré sú v záznamoch o vašej stránke, ale všetky zlyhali. Môžete napraviť tento problém ručne generovaním nového kľúča na vzdialenom portáli. Normálne by toto nemalo nastať, iba ak ste neboli v kontakte s vzdialeným portálom pár mesiacov.';
$string['error7024'] = 'Poslali ste nekryptovanú správu vzdialenému portálu, ale ten neprijíma nekryptované spojenie z vašeho portálu. Toto je veľmi nezvyčajné; možno by ste mali vytvoriť správu o chybe ak sa to stalo (dodať toľko informácii, koľko je možné o vašej Moodle verzii)';
$string['error7026'] = 'Kľúč, ktorým bola podpísaná vaša správa, sa líši od kľúča, ktorý má zaznamenaný vzdialený portál pre váš server. Ďalej, vzdialený portál sa pokúsil stiahnuť váš aktuálny kľúč, ale nepodarilo sa mu to. Prosím ručne obnovte kľúč so vzdialeným portálom a skúste znova.';
$string['error709'] = 'Vzdialený portál nedokázal získať Váš SSL kľúč.';
$string['eventaccesscontrolcreated'] = 'Riadenie prístupu vytvorené';
$string['eventaccesscontrolupdated'] = 'Riadenie prístupu aktualizované';
$string['expired'] = 'Tento kľúč vypršal dňa';
$string['expires'] = 'Platné do';
$string['expireyourkey'] = 'Zmazať tento kľúč';
$string['expireyourkeyexplain'] = 'Moodle automaticky obmeňuje vaše kľúče každých 28 dní (implicitne), ale môžete tento kľúč odvolať <em>ručne</em> kedykoľvek. To sa môže hodiť v prípade, že máte dojem, že tento kľúč bol prezradený. Okamžite bude vygenerovaná náhrada.<br /> Vymazanie tohto kľúča znemožní ostatným serverom komunikovať s Vami, kým ručne nedodáte ich administrátorom váš nový kľúč.';
$string['exportfields'] = 'Polia určené na export';
$string['failedaclwrite'] = 'Neprešiel zápis do zoznamu riadenia prístupu MNET pre používateľa \'{$a}\'.';
$string['findlogin'] = 'Nájsť používateľské meno';
$string['forbidden-function'] = 'Táto funkcia nebola sprístupnená pre RPC.';
$string['forbidden-transport'] = 'Pokúšate sa použiť nepovolenú transportnú metódu.';
$string['forcesavechanges'] = 'Vynútené uloženie zmien';
$string['helpnetworksettings'] = 'Konfigurovať Mnet komunikáciu';
$string['hidelocal'] = 'Skryť miestných používateľov';
$string['hideremote'] = 'Skryť vzdialených používateľov';
$string['host'] = 'hostiteľ';
$string['hostcoursenotfound'] = 'Hostiteľ alebo kurz nenájdený';
$string['hostdeleted'] = 'Hostiteľ odstránený';
$string['hostexists'] = 'Záznam pre tohto hostiteľa a inštaláciu Moodle už existuje (môže byť vymazaný). <a href="{$a}">kliknite sem</a> pre úpravu tohto záznamu.
';
$string['hostlist'] = 'Zoznam sieťových hostí';
$string['hostname'] = 'Názov hostiteľa';
$string['hostnamehelp'] = 'Plne kvalifikované doménové meno na vzdialenom hostiteľovi, napríklad www.example.com';
$string['hostnotconfiguredforsso'] = 'Tento server nie je konfigurovaný pre diaľkové prihlasovanie.';
$string['hostsettings'] = 'Nastavenie hostiteľa';
$string['http_self_signed_help'] = 'Povoliť spojenie pomocou samopodpísaného certifikátu DIY SSL na vzdialenom hostiteľovi.';
$string['http_verified_help'] = 'Povoliť spojenie pomocou overeného certifikátu SSL na vzdialenom hostiteľovi ale cez http (nie https).';
$string['https_self_signed_help'] = 'Povoliť spojenie pomocou samopodpísaného certifikátu DIY SSL na vzdialenom hostiteľovi cez http.';
$string['https_verified_help'] = 'Povoliť spojenie pomocou overeného certifikátu SSL na vzdialenom hostiteľovi.';
$string['id'] = 'ID';
$string['idhelp'] = 'Táto hodnota je priraďovaná automaticky a nemožno ju meniť.';
$string['importfields'] = 'Polia určené na import';
$string['inspect'] = 'Prezrieť';
$string['installnosuchfunction'] = 'Chyba v programe! Niečo sa snaží nainštalovať mnet xmlrpc funkciu ({$a->method}) zo súboru ({$a->file}) a nemôže ju nájsť.';
$string['installnosuchmethod'] = 'Chyba v programe! Niečo sa snaží nainštalovať mnet xmlrpc metódu ({$a->method}) v triede ({$a->class}) a nemôže ju nájsť.';
$string['installreflectionclasserror'] = 'Chyba v programe! MNET zlyhalo pre metódu \'{$a->method}\' v triede \'{$a->class}\'. Pôvodná chyba (ak by to pomohlo) je \'{$a->error}\'';
$string['installreflectionfunctionerror'] = 'Chyba v programe! MNET zlyhalo pre funkciu \'{$a->method}\' v súbore \'{$a->class}\'. Pôvodná chyba (ak by to pomohlo) je \'{$a->error}\'';
$string['invalidaccessparam'] = 'Neplatný prístupový parameter.';
$string['invalidactionparam'] = 'Neplatný parameter akcie.';
$string['invalidhost'] = 'Musíte poskytnúť platný identifikátor hostiteľa';
$string['invalidpubkey'] = 'Toto nie je platný kľúč SSL. ({$a})';
$string['invalidurl'] = 'Neplatný parameter URL.';
$string['ipaddress'] = 'IP adresa';
$string['is_in_range'] = 'IP adresa <code>{$a}</code> reprezentuje hostiteľa s platným overením.';
$string['ispublished'] = 'Túto službu pre Vás sprístupnil server {$a}.';
$string['issubscribed'] = 'Server {$a} sa zapisuje do tejto služby na vašom hostiteľovi.';
$string['keydeleted'] = 'Váš kľúč bol úspešne zmazaný a nahradený.';
$string['keymismatch'] = 'Verejný kľúč, ktorý máte pre tohto hostiteľa sa líši od platného verejného kľúča. Ten súčasne zverejnený je:';
$string['last_connect_time'] = 'Posledný čas pripojenia';
$string['last_connect_time_help'] = 'Čas, kedy ste sa naposledy pripojili k tomuto hostiteľovi';
$string['last_transport_help'] = 'Transport, ktorý ste použili pre posledné pripojenie k tomuto hostiteľovi.';
$string['leavedefault'] = 'Použiť predvolené nastavenia';
$string['listservices'] = 'Zoznam služieb';
$string['loginlinkmnetuser'] = '<br/>Ak ste vzdialeným používateľom siete Moodle a môžete na <a href="{$a}">potvrdiť vašu emailovú adresu</a>, budete presmerovaný na prihlasovaciu stránku.<br />';
$string['logs'] = 'záznamy';
$string['managemnetpeers'] = 'Spravovať peerov';
$string['method'] = 'Metódy';
$string['methodhelp'] = 'Nápoveda k metódam pre {$a}';
$string['methodsavailableonhost'] = 'Metódy dostupné na {$a}';
$string['methodsavailableonhostinservice'] = 'Metódy dostupné pre {$a->service} na {$a->host}';
$string['methodsignature'] = 'Metódy podpisu pre {$a}';
$string['mnet'] = 'MNet';
$string['mnet_concatenate_strings'] = 'Zlúčiť do 3 reťazcov a vrátiť výsledok';
$string['mnet_session_prohibited'] = 'Používatelia Vášho domovského servera teraz nemajú povolený roaming na {$a}.';
$string['mnetdisabled'] = 'Sieť MNet <strong>nie je povolená</strong>.';
$string['mnetidprovider'] = 'MNET ID poskytovateľ';
$string['mnetidproviderdesc'] = 'Môžete použiť tento mechanizmus pre získanie odkazu, kde je možné sa prihlásiť. Predpokladom je poskytnutie správnej emailovej adresy, ktorá zodpovedná používateľskému menu, s ktorým ste sa snažili prihlásiť.';
$string['mnetidprovidermsg'] = 'Mali by ste byť schopný sa prihlásiť u svojho poskytovateľa {$a}.';
$string['mnetidprovidernotfound'] = 'Ľutujem, ale žiadne ďalšie informácie neboli nájdené.';
$string['mnetpeers'] = 'Partneri';
$string['mnetservices'] = 'Služby';
$string['mnetsettings'] = 'Nastavenie siete Mnet';
$string['moodle_home_help'] = 'Cesta k domovskej stránke MNet na vzdialenom hostiteľovi, napr. /moodle/.';
$string['name'] = 'Názov';
$string['net'] = 'Sieť';
$string['networksettings'] = 'Nastavenie siete';
$string['never'] = 'Nikdy';
$string['noaclentries'] = 'V riadiacom zoznamu prístupu SSO nie sú záznamy';
$string['noaddressforhost'] = 'Ľutujeme, ale toto meno hostiteľa ({$a}) nemohlo byť zistené!';
$string['nocurl'] = 'Knižnica PHP Curl nie je inštalovaná';
$string['nolocaluser'] = 'Pre vzdialeného používateľa neexistuje miestny záznam a ani nemohol byť vytvorený, pretože tento hostiteľ nevytvára automaticky používateľov. Prosím, spojte sa s vašim administrátorom.';
$string['nomodifyacl'] = 'Nemáte právo meniť zoznam riadenia prístupu MNET.';
$string['nonmatchingcert'] = 'Predmet certifikátu <br /><em>{$a->subject}</em><br /> neodpovedá hostiteľovi prichádzajúcemu z <br /><em>{$a->host}</em>.';
$string['nopubkey'] = 'Vyskytol sa problém so získaním verejného kľúča.<br /> Možno, že hostiteľ nepovoľuje sieť MNet alebo je kľúč neplatný.';
$string['nosite'] = 'Nemôžem nájsť kurz na úrovni portálu.';
$string['nosuchfile'] = 'Súbor alebo funkcia {$a} neexistuje.';
$string['nosuchfunction'] = 'Nemôžem nájsť funkciu, alebo je táto funkcia zakázaná pre RPC.';
$string['nosuchmodule'] = 'Funkcia bola nesprávne adresovaná a nemožno ju nájsť. Prosím použite formát mod/modulename/lib/functionname.';
$string['nosuchpublickey'] = 'Nemožno získať verejný kľúč pre overenie podpisu.';
$string['nosuchservice'] = 'Služba RPC na tomto hostiteľovi nebeží.';
$string['nosuchtransport'] = 'Neexistuje transport s týmto ID.';
$string['notBASE64'] = 'Tento reťazec nie je v kódovanom formáte Base64. Nemôže to byť platný kľúč.';
$string['notPEM'] = 'Tento kľúč nie je vo formátu PEM. Nebude fungovať.';
$string['not_in_range'] = 'IP adresa <code>{$a}</code> nereprezentuje riadne overeného hostiteľa.';
$string['notenoughidpinfo'] = 'Váš poskytovateľ identity nám neposkytuje dostatočné informácie na to, aby bolo možné vytvoriť alebo aktualizovať vaše konto lokálne. Ľutujeme!';
$string['notinxmlrpcserver'] = 'Pokus o prístup k vzdialenému MNET klientovi mimo XMLRPC serverového vykonávania.';
$string['notmoodleapplication'] = 'Upozornenie: Toto nie je Moodle aplikácia, takže niektoré z inšpekčných metód nemusia správne fungovať. ';
$string['notpermittedtojump'] = 'Nemáte povolenie zahájiť vzdialenú reláciu z tohto počítača Moodle.';
$string['notpermittedtojumpas'] = 'Nemôžete začať vzdialenú reláciu, kým ste prihlásený ako iný používateľ.';
$string['notpermittedtoland'] = 'Nemáte povolenie zahájiť vzdialenú reláciu.';
$string['off'] = 'Vypnuté';
$string['on'] = 'Zapnuté';
$string['options'] = 'Možnosti';
$string['peerprofilefielddesc'] = 'V tomto nastavení môžete zmeniť globálne nastavenie toho, ktoré polia profilov sa budú posielať a importovať pri vytváraní nových účtov';
$string['permittedtransports'] = 'Povolené transporty';
$string['phperror'] = 'Vyskytla sa interná chyba PHP, ktorá znemožnila splnenie Vašej požiadavky.';
$string['position'] = 'Pozícia';
$string['postrequired'] = 'Odstránenie funkcie sa musí vykonať príkazom POST.';
$string['privacy:metadata'] = 'Zásuvný modul MNet neukladá žiadne osobné údaje';
$string['profileexportfields'] = 'Polia určené na odoslanie';
$string['profilefields'] = 'Polia profilu';
$string['profileimportfields'] = 'Polia určené na import';
$string['promiscuous'] = 'Zmiešaný';
$string['publickey'] = 'Verejný kľúč';
$string['publickey_help'] = 'Verejný kľúč je automaticky získaný zo vzdialeného servera.';
$string['publickeyrequired'] = 'Musíte zadať verejný kľúč.';
$string['publish'] = 'Publikovať';
$string['reallydeleteserver'] = 'Naozaj chcete odstrániť server?';
$string['receivedwarnings'] = 'Boli prijaté nasledujúce upozornenia';
$string['recordnoexists'] = 'Záznam neexistuje';
$string['reenableserver'] = 'Nie - zvoľte túto možnosť pre opätovné povolenie tohto serveru';
$string['registerallhosts'] = 'Zaregistrovať všetky počítače (promiskuitný režim)';
$string['registerallhostsexplain'] = 'Môžete si zvoliť, aby boli automaticky registrovaní všetci hostitelia, žiadajúci o spojenie s Vami.
To znamená, že sa objaví záznam vo Vašom zozname hostiteľov pre všetky Moodle, ktoré sa s Vami spoja a požiadajú o verejný kľúč.<br />Nižšie máte možnosť konfigurovať služby pre "Všetkých hostiteľov" a povolením nektorých týchto služieb poskytnete služby všetkým serverom MNet.';
$string['registerhostsoff'] = 'Registrácia všetkých hostiteľov je v súčasnosti <b>vypnutá</b>';
$string['registerhostson'] = 'Registrácia všetkých hostiteľov je v súčasnosti <b>zapnutá</b>';
$string['remotecourses'] = 'Vzdialené kurzy';
$string['remotehost'] = 'Vzdialený server';
$string['remotehosts'] = 'Vzdialení hostitelia';
$string['remoteuser'] = 'Vzdialený {$a->remotetype} používateľ';
$string['remoteuserinfo'] = 'Vzdialený používateľ zo systému  <a href="{$a->remoteurl}">{$a->remotename}</a>';
$string['requiresopenssl'] = 'Sieť vyžaduje OpenSSL rozšírenie';
$string['restore'] = 'Obnoviť';
$string['returnvalue'] = 'Vrátiť hodnotu';
$string['reviewhostdetails'] = 'Preskúmať detaily hostiteľa';
$string['reviewhostservices'] = 'Preskúmať služby hostiteľa';
$string['selectaccesslevel'] = 'Prosím vyberte zo zoznamu úroveň prístupu.';
$string['selectahost'] = 'Prosím vyberte vzdialeného hostiteľa.';
$string['service'] = 'Názov servisu';
$string['serviceid'] = 'ID číslo servisu';
$string['servicesavailableonhost'] = 'Služby dostupné na {$a}';
$string['serviceswepublish'] = 'Služby, ktoré publikujeme pre {$a}.';
$string['serviceswesubscribeto'] = 'Služby na {$a}, ku ktorým sme prihlásení.';
$string['settings'] = 'Nastavenie';
$string['showlocal'] = 'Ukázať miestnych používateľov';
$string['showremote'] = 'Ukázať vzdialených používateľov';
$string['ssl_acl_allow'] = 'SSO ACL: Povoliť používateľa "{$a->user}" z "{$a->host}"';
$string['ssl_acl_deny'] = 'SSO ACL: Zakázať používateľa "{$a->user}" z "{$a->host}"';
$string['sslverification'] = 'SSL overenie';
$string['sslverification_help'] = 'Táto možnosť vám umožňuje nakonfigurovať úroveň zabezpečenia pri pripájaní k peerovi pomocou HTTPS.

* Žiadne: žiadna úroveň zabezpečenia
* Overiť iba hostiteľa: overí doménu certifikátu SSL
* Overiť hostiteľa a partnera (odporúča sa): overí doménu a vydavateľa certifikátu SSL';
$string['ssoaccesscontrol'] = 'Riadenie prístupu SSO';
$string['ssoacldescr'] = 'Použite túto stránku k povoleniu alebo nepovoleniu prístupu konkrétnych používateľov zo vzdialených hostiteľov siete Moodle. Toto funguje, keď ponúkate SSO služby vzdialeným používateľom. Pre riadenie možností vašich <em>miestnych</em> používateľov používať vzdialených hostiteľov Moodle, použite systém rol a prideľte im možnosť <em>mnetlogintoremote</em>.';
$string['ssoaclneeds'] = 'Aby táto funkcia pracovala, musíte mať zapnutú sieť Moodle a mať povolený prihlasovací modul siete Moodle.';
$string['strict'] = 'Striktný';
$string['subscribe'] = 'Prihlásiť';
$string['system'] = 'Systém';
$string['testclient'] = 'MNET testovací klient';
$string['testtrustedhosts'] = 'Overiť adresu';
$string['testtrustedhostsexplain'] = 'Vložte IP adresu pre zistenie, či je dôveryhodným hostiteľom';
$string['theypublish'] = 'Publikujú';
$string['theysubscribe'] = 'Predplatení';
$string['transport_help'] = 'Tieto možnosti sú recipročné takže môžete iba donútiť vzdialeného hostiteľa, aby používal podpísaný SSL certifikát, ak aj Vy ho používate.';
$string['trustedhosts'] = 'XML-RPC hostitelia';
$string['trustedhostsexplain'] = '<p>Mechanizmus dôveryhodných hostiteľov umožňuje konkrétnym strojom vykonávať volanie ktorejkoľvek časti Moodle API cez XML-RPC. To je dostupné cez skripty, riadiace chovanie Moodle a môže byť veľmi nebezpečné to povoliť. Ak máte akékoľvek pochybnosti, nechajte vypnuté.</p><p>Toto <strong>nie je</strong> nutné pre sieť Moodle.</p><p>Povolíte vložením zoznamu IP addries alebo sietí, jedna na každom riadku.
Príklady:</p>Váš lokálny hostiteľ:<br />127.0.0.1<br />Váš lokálny hostiteľ (so sieťovým blokom):<br />127.0.0.1/32<br />Iba hostiteľ s IP adresou 192.168.0.7:<br />192.168.0.7/32<br />Všetci hostitelia s IP adresami medzi 192.168.0.1 a 192.168.0.255:<br />192.168.0.0/24<br />Všetci hostitelia:<br />192.168.0.0/0<br />Posledne uvedený spôsob <strong>nie je</strong> doporučený.';
$string['turnitoff'] = 'Vypnúť';
$string['turniton'] = 'Zapnúť';
$string['type'] = 'Typ';
$string['unknown'] = 'Neznámy';
$string['unknownerror'] = 'V priebehu vyjednávania sa vyskytla neočakávaná chyba.';
$string['usercannotchangepassword'] = 'Pretože ste vzdialený používateľ, nemôžete si zmeniť heslo tu.';
$string['userchangepasswordlink'] = '<br /> Môžete si zmeniť heslo u vášho poskytovateľa na <a href="{$a->wwwroot}/login/change_password.php">{$a->description}</a> .';
$string['usersareonline'] = 'Upozornenie: je k vám práve pripojených {$a} používateľov toho serveru.';
$string['validated_by'] = 'Overené pomocou siete: <code>{$a}</code>';
$string['verifyhostandpeer'] = 'Overiť hostiteľa a spoluštudujúceho';
$string['verifyhostonly'] = 'Overiť iba hostiteľa';
$string['verifysignature-error'] = 'Overenie podpisu zlyhalo. Vyskytla sa chyba.';
$string['verifysignature-invalid'] = 'Overenie podpisu zlyhalo. Zdá sa, že tento transport nebol Vami podpísaný.';
$string['version'] = 'Verzia';
$string['warning'] = 'Upozornenie';
$string['wrong-ip'] = 'Vaša IP adresa sa nezhoduje so zaznamenanou.';
$string['xmlrpc-missing'] = 'Aby ste mohli použiť túto vlastnosť, musíte mať nainštalované XML-RPC vo Vašom PHP.';
$string['yourhost'] = 'Váš hostiteľ';
$string['yourpeers'] = 'Vaši partneri';
