<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_mobile', language 'no', version '4.5'.
 *
 * @package     tool_mobile
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adodbdebugwarning'] = 'ADOdb debugging er aktivert. Det burde vært deaktivert i den eksterne databaseautentiseringen eller databasepåmeldingsmodulen.';
$string['androidappid'] = 'Android-appens unike identifikator.';
$string['androidappid_desc'] = 'Denne innstillingen bør bare endres om du har en skreddersydd Android-app.';
$string['apppolicy'] = 'URL til appens retningslinjer';
$string['apppolicy_help'] = 'URLen til retningslinjene for appens brukere som vises på "Om"-siden i appen. Dersom feltet er tomt vil portalens retningslinjer bl';
$string['apprequired'] = 'Denne funksjonaliteten er kun tilgjengelig i Moodle Mobile og Moodle Desktop';
$string['autologinkeygenerationlockout'] = 'Autologin nøkkelgenerering er blokkert. du må vente minst {$a} minutter mellom hver forespørsel.';
$string['autologinmintimebetweenreq'] = 'Minimum tid mellom forespørsler om automatisk pålogging';
$string['autologinmintimebetweenreq_desc'] = 'Minimumstiden mellom forespørsler om automatisk pålogging fra mobilappen. Hvis appbrukere ofte blir bedt om å oppgi påloggingsinformasjonen deres når de ser på innhold som er innebygd fra portalen, må du angi en lavere verdi.';
$string['autologinnotallowedtoadmins'] = 'Det er ikke tillatt for portaladministratorer å bruke autologin.';
$string['autologout'] = 'Håndhev automatisk utlogging for brukerne dine';
$string['autologout_desc'] = 'Av sikkerhetsgrunner kan du håndheve automatisk utlogging for brukerne dine når de forlater eller lukker appen, eller den går til bakgrunnen. Brukere må logge på igjen når de kommer tilbake til appen.';
$string['autologoutcustom'] = 'Egendefinert tid etter at brukere forlater eller lukker appen';
$string['autologoutinmediate'] = 'Umiddelbart etter at brukere forlater eller lukker appen';
$string['autologouttime'] = 'Nedteller for automatisk utlogging';
$string['cachedef_plugininfo'] = 'Dette lagrer listenfor moduler med mobiltillegg.';
$string['cachedef_subscriptiondata'] = 'Dette lagre Moodle appens abonnementsinformasjon.';
$string['clickheretolaunchtheapp'] = 'Kikk her hvis appen ikke åpnes automatisk';
$string['configmobilecssurl'] = 'En CSS-fil til å tilpasse brukergrensesnittet på mobilappen din.';
$string['customlangstrings'] = 'Språktilpasninger';
$string['customlangstrings_desc'] = 'Ord og uttrykk i appen kan defineres her. Legg til hver språkstreng du ønsker å definere på en egen linje med formatet: strengidentifikator, egendefinert språkstreng og språkkode, seperarert med pipetegn. For eksempel:
<pre>
mm.user.student|Learner|en
mm.user.student|Aprendiz|es
</pre>
For en komplett liste med strengidentifikatorer bør du sjekke dokumentasjonen.';
$string['custommenuitems'] = 'Egendefinerte menyelementer';
$string['custommenuitems_desc'] = 'Ytterligere elementer kan legges til appens hovedmeny ved å spesifisere dem her. Skriv inn hvert tilpassede menyelement på en ny linje med format: varetekst, lenke-URL, link-åpningsmetode og språkkode (valgfritt, for å vise elementet til brukere av bare det spesifiserte språket), atskilt med rørkarakterer.

Link-åpningsmetoder er: app (for kobling til en aktivitet som støttes av appen), inappbrowser (for å åpne en kobling i en nettleser uten å forlate appen), nettleser (for å åpne linken i enhetens standard nettleser utenfor appen) og innebygd (for å vise lenken i en iframe på en ny side i appen).

Når elementer mangler en oversettelse for et gitt språk, vil de bruke andre språk som tilbakelevering med mindre "_ bare" er lagt til språkkoden.

For eksempel:
<Pre>
Apphjelp | https: //someurl.xyz/help | inappbrowser
Karakterene mine | https: //someurl.xyz/local/mygrades/index.php | innebygd | no
Mis calificaciones | https: //someurl.xyz/local/mygrades/index.php | innebygd | es
Du vil bare se dette på engelsk | https: //someurl.xyz/english | nettleser | en_only
</ Pre>';
$string['darkmode'] = 'Mørk modus';
$string['disabledfeatures'] = 'Deaktiverte funksjoner';
$string['disabledfeatures_desc'] = 'Her kan du velge hvilke funksjoner du ønsker å deaktiverer i mobilappen for din portal. Du bør være klar over at noen av funksjonene som er listet opp her allerede kan være deaktivert via andre portalinnstillinger. Du må logge ut og inn igjen av appen for å se endringene.';
$string['displayerrorswarning'] = 'Visning av debugmeldinger er aktivert. Det bør være deaktivert.';
$string['downloadcourse'] = 'Last ned kurs';
$string['downloadcourses'] = 'Last ned kurs';
$string['enablesmartappbanners'] = 'Aktiver App-bannere';
$string['enablesmartappbanners_desc'] = 'Hvis aktivert, vil et banner med reklame for mobilappen vises når portalen besøkes via en nettleser på mobil eller nettbrett.';
$string['filetypeexclusionlist'] = 'Ekskluderingsliste for filtype';
$string['filetypeexclusionlist_desc'] = 'Velg alle filtyper som ikke er til bruk på en mobil enhet. Slike filer vil bli oppført i kurset. Hvis en bruker prøver å åpne dem, vises en advarsel om at filtypen ikke er ment for bruk på en mobil enhet. Brukeren kan deretter avbryte eller ignorere advarselen og åpne filen uansett.';
$string['filetypeexclusionlistplaceholder'] = 'Ekslusjonsliste for mobile filtyper';
$string['forcedurlscheme'] = 'Hvis du vil tillate at bare den tilpassede appen åpnes via et nettleservindu, angir du URL-skjemaet her. Hvis du bare vil tillate den offisielle appen, angir du standardverdien. La feltet være tomt hvis du vil tillate alle apper.';
$string['forcedurlscheme_key'] = 'URL-skjema';
$string['forcelogout'] = 'Tving utlogging';
$string['forcelogout_desc'] = 'Hvis aktivert vil valget "Bytt portal" i appen erstattes med "Logg ut". Dette gjør at brukeren vil logges helt ut av appen. De må da skrive inn passordet sitt på nytt neste gang de ønsker å få tilgang til portalen.';
$string['getmoodleonyourmobile'] = 'Hent mobilappen';
$string['h5poffline'] = 'Vis H5P innhold offline';
$string['httpsrequired'] = 'HTTPS påkrevd';
$string['insecurealgorithmwarning'] = 'Det ser ut som om HTTPS-sertifikatet bruker en usikker algoritme for signering (SHA-a). Vennligst prøv å oppdatere sertifikatet.';
$string['invalidcertificatechainwarning'] = 'Det ser ut til at sertifikatkjeden er ugyldig. Dette sertifikatet kan fungere for en nettleser, men ikke for en mobilapp.';
$string['invalidcertificateexpiredatewarning'] = 'HTTPS-sertifikatet for denne portalen er utløpt.';
$string['invalidcertificatestartdatewarning'] = 'Det ser ut til at HTTPS-sertifikatet for denne portalen ikke er gyldig fordi det har en fremtidig dato som startdato';
$string['invalidprivatetoken'] = 'Ugyldig privat token. Token skal ikke være tom eller sendt via en GET parameter.';
$string['invaliduserquotawarning'] = 'Brukerkvoten (userquota) er satt til et ugyldig tall. Det må settes til et gyldig tall (heltall) i portalens sikkerhetsinnstillinger.';
$string['iosappid'] = 'iOS-appens unike identifikator';
$string['iosappid_desc'] = 'Du trenger bare endre denne verdien om du har en egendefinert iOS-app';
$string['launchviasiteinbrowser'] = 'Start via portalen i systemleseren';
$string['loginintheapp'] = 'Via appen';
$string['logininthebrowser'] = 'Via et nettleservindu (for SSO-moduler)';
$string['loginintheembeddedbrowser'] = 'Via et innebygd nettleservindu (for SSO-moduler)';
$string['logoutconfirmation'] = 'Er du sikker på at du vil logge av fra mobilappen på dine mobile enheter? Ved å logge ut, må du deretter oppgi brukernavnet og passordet ditt i mobilappen på alle enheter der du har appen installert.';
$string['mainmenu'] = 'Hovedmeny';
$string['managefiletypes'] = 'Administrere filtyper';
$string['minimumversion'] = 'Hvis en appversjon er spesifisert (3.8.0 eller nyere), vil brukere som bruker en eldre appversjon bli bedt om å oppgradere appen sin før de får tilgang til portalen.';
$string['minimumversion_key'] = 'Minimum appversjon kreves';
$string['mobileapp'] = 'Mobilapp';
$string['mobileappearance'] = 'Mobilvisning';
$string['mobileappenabled'] = 'Denne portalen har aktivert tilgangen via mobilappen. <br /><a href="{$a}">Last ned mobilappen</a>.';
$string['mobileappsubscription'] = 'Moodle app abonnement';
$string['mobileauthentication'] = 'Mobilautentisering';
$string['mobilecssurl'] = 'CSS';
$string['mobilefeatures'] = 'Mobilfunksjoner';
$string['mobilenotificationsdisabledwarning'] = 'Mobilvarsler er ikke aktivert. De skal være aktivert i Varslingsinnstillinger.';
$string['mobilesettings'] = 'Mobilinnstillinger';
$string['moodleappsportalfeatureswarning'] = 'Vennligst merk at noen funksjoner kan være begrenset avhengig av ditt Moodle app abonnement. For detaljer, besøk <a href="{$a}" target="_blank">Moodle Apps Portal</a>.';
$string['notifications'] = 'Varslinger';
$string['notificationsactivedevices'] = 'Aktive enheter';
$string['notificationscurrentactivedevices'] = 'Enheter som har mottat varslinger denne måneden.';
$string['notificationsignorednotifications'] = 'Varslinger ikke sendt';
$string['notificationslimitreached'] = 'Den månedlige grensen for aktive brukerenheter er overskredet. Varsler for noen brukere vil ikke bli sendt. Det anbefales at du oppgraderer appplanen din i <a href="{$a}" target="_blank"> Moodle Apps Portal </a>.';
$string['notificationsmissingwarning'] = 'Moodle-appvarslingsstatistikk kunne ikke hentes. Dette er mest sannsynlig fordi mobilvarsler ennå ikke er aktivert på portalen. Du kan aktivere dem i Portaladministrasjon / Meldinger / Mobil.';
$string['notificationsnewdevices'] = 'Nye enheter';
$string['notificationsseemore'] = 'Merk: Bruk av statistikk for Moodle-apper beregnes ikke i sanntid. For å få tilgang til mer detaljert statistikk, inkludert data fra tidligere måneder, vennligst logg inn på <a href="{$a}" target="_blank"> Moodle Apps Portal </a>.';
$string['notificationssentnotifications'] = 'Varslinger sendt';
$string['oauth2identityproviders'] = 'OAuth 2 identitstilbydere';
$string['offlineuse'] = 'Offline bruk';
$string['pluginname'] = 'Moodle appverktøy';
$string['pluginnotenabledorconfigured'] = 'Modulen er ikke aktivert eller konfigurert';
$string['privacy:metadata:core_userkey'] = 'Brukernes nøkler brukt til å opprette autologinnøkkel for gjeldende bruker.';
$string['privacy:metadata:preference:tool_mobile_autologin_request_last'] = 'Datoen for siste autologinnøkkelforespørsel. Det kreves en ventetid på 6 minutter mellom hver forespørsel.';
$string['qrcodedisabled'] = 'Tilgang via QR-kode deaktivert';
$string['qrcodeformobileappaccess'] = 'QR-kode for mobilapptilgang';
$string['qrcodeformobileapploginabout'] = 'Skann QR-koden med mobilappen og logg inn automatisk. QR-koden vil utløpe om {$a} minutter.';
$string['qrcodeformobileappurlabout'] = 'Skann QR-koden med mobilappen og skriv inn portal-URLen i appen.';
$string['qrcodetype'] = 'QR-kodetilgang';
$string['qrcodetype_desc'] = 'En QR-kode kan gis for brukere av mobilapper å skanne. Dette kan brukes til å fylle ut nettadressen, eller der nettstedet er sikret ved hjelp av HTTPS, for automatisk å logge inn brukeren uten å måtte oppgi brukernavn og passord.';
$string['qrcodetypelogin'] = 'QR-kode med automatisk innlogging';
$string['qrcodetypeurl'] = 'QR kode med portal-URL';
$string['qrkeyttl'] = 'Varighet for QR-autentiseringsnøkkel';
$string['qrkeyttl_desc'] = 'Hvor lang tid en QR-kode for automatisk pålogging er gyldig.';
$string['qrsameipcheck'] = 'QR-autentisering samme IP-sjekk';
$string['qrsameipcheck_desc'] = 'Denne innstillingen tvinger brukere til å bruke samme nettverk for både å generere og skanne en QR-kode for pålogging. Deaktiver den bare i tilfelle brukerne dine rapporterer problemer med QR-pålogging.';
$string['qrsiteadminsnotallowed'] = 'På grunn av sikkerhetsårsaker er innlogging via QR-kode ikke tillatt for portaladministrater eller når du er innlogget som en annen bruker.';
$string['readingthisemailgettheapp'] = 'Leser du dette i en epost? <a href="{$a}">Last ned Moodle Mobile og motta varslinger på din mobil enhet</a>.';
$string['remoteaddons'] = 'Eksterne tillegsmoduler';
$string['responsivemainmenuitems'] = 'Responsive menyelementer';
$string['scanqrcode'] = 'Skann QR-kode';
$string['selfsignedoruntrustedcertificatewarning'] = 'Det ser ut til at HTTPS-sertifikatet er selvsignert eller ikke klarert. Mobilappen fungerer kun med pålitelige portaler. Bruk en hvilken som helst online SSL-kontroll for å diagnostisere problemet. Hvis det indikerer at sertifikatet ditt er OK, kan du ignorere denne advarselen.';
$string['setuplink'] = 'Nedlastingsside for appen.';
$string['setuplink_desc'] = 'URL til side med alternativer for å laste ned mobilappen fra App Store og Google Play. Applenken for nedlasting av sider vises i bunnteksten og i brukerprofilen. La være tomt for ikke å vise en kobling.';
$string['smartappbanners'] = 'App-bannere';
$string['subscription'] = 'Abonnement';
$string['subscriptioncreated'] = 'Startdato';
$string['subscriptionerrorrequest'] = 'Det oppstod en uventet feil under henting av Moodle app abonnementsinformasjon.';
$string['subscriptionexpiration'] = 'Utløpsdato';
$string['subscriptionfeaturenotapplied'] = 'Denne funksjonen er satt opp på portalen, men ikke inkludert i ditt Moodle app abonnement. Innstillingen vil derfor ikke har noen effekt.';
$string['subscriptionfeatures'] = 'Abonnementsfunksjoner';
$string['subscriptionlimitsurpassed'] = 'Abonnementsgrense overskredet';
$string['subscriptionregister'] = 'Hvis du vil ha detaljer om de forskjellige appplanene, og for å få tilgang til Moodle-appbruksstatistikk, kan du gå til <a href="{$a}" target="_blank"> Moodle Apps Portal </a>.';
$string['subscriptionsseemore'] = 'Merk: Informasjonen som vises blir ikke oppdatert i sanntid. Du må kanskje logge av og logge deg på igjen for å se oppdateringer. Hvis du vil ha informasjon om hvordan du oppgraderer appplanen din, kan du logge deg på <a href="{$a}" target="_blank"> Moodle Apps Portal </a>.';
$string['switchaccount'] = 'Bytt konto';
$string['typeoflogin'] = 'Innloggingsmetode';
$string['typeoflogin_desc'] = 'Dersom portalen bruker en SSO autentiseringsmetode, velg enten via nettleservindu eller via en innbygd nettleser. En innbygd nettleser gir en bedre brukeropplevelse, men det fungerer ikke med alle SSO-moduler.';
$string['viewqrcode'] = 'Vis QR kode';
