<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'filter_synhi', language 'eu', version '4.5'.
 *
 * @package     filter_synhi
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['brokenmarkup'] = 'Markaketa apurtuta dago, nabarmentzea gaizki egingo da.';
$string['codeexample'] = 'Kodea';
$string['codeexampledesc'] = 'Adibidean erabiltzeko kodea. Oharra: Gorde ezazu adibide honetan erabiltzeko.';
$string['engine'] = 'Motorra';
$string['enginedesc'] = 'Nabarmentzea egiteko erabili beharreko motorra, \'<a href="https://github.com/EnlighterJS/EnlighterJS" target="_blank">EnlighterJS</a> - Mozillaren Lizentzia Publikoa 2.0 (MPL-2.0) duena\' ala \'<a href="https://github.com/syntaxhighlighter/syntaxhighlighter" target="_blank">SyntaxHighlighter</a> - MIT lizentzia duena\'.';
$string['enlighterinformation'] = 'Inguratu zure kodea \'code\' etiketarekin for lerro arteko kodearentzat, eta lerro anitzeko kodearen kasuan \'pre\' etiketekin inguratu ezazu. Enlighter zure hizkuntza antzematen saiatuko da, baina hizkuntza espliziztuki zehaztu dezakezu \'code\' etiketari \'data-enlighter-language\' atributua gehituta, honela adibidez: \'data-enlighter-language="java"\'. Kako arteko testua aukera hauetako parentesi artekoa izan daiteke:
<br>
<ul>
  <li>ABAP (abap)</li>
  <li>Apache HTTPD (apache)</li>
  <li>Assembly (assembly, asm)</li>
  <li>AVR Assembly (avrassembly, avrasm)</li>
  <li>Windows Batch/Bat (bat,batch,cmd)</li>
  <li>C/C++ (c,cpp, c++)</li>
  <li>C# (csharp)</li>
  <li>CSS(css)</li>
  <li>Cython (cython)</li>
  <li>CordPro (cordpro)</li>
  <li>diff (diff)</li>
  <li>Dockerfile (docker, dockerfile)</li>
  <li>Generic (generic, standard) - nabarmentze eskema lehenetsia</li>
  <li>Groovy (groovy)</li>
  <li>Go (go, golang)</li>
  <li>HTML (html)</li>
  <li>Ini (ini, conf)</li>
  <li>Java (java)</li>
  <li>Javascript (js, javascript, jquery, mootools, ext.js)</li>
  <li>JSON (json)</li>
  <li>JSX (jsx)</li>
  <li>Kotlin (kotlin)</li>
  <li>LATEX (latex)</li>
  <li>LESS (less)</li>
  <li>lighttpd (lighttpd)</li>
  <li>LUA (lua)</li>
  <li>MariaDB (mariadb)</li>
  <li>Markdown (gfm, md, markdown)</li>
  <li>Matlab/Octave (octave, matlab)</li>
  <li>MSSQL (mssql)</li>
  <li>NGINX (nginx)</li>
  <li>NSIS (nsis)</li>
  <li>Oracle Database (oracledb)</li>
  <li>PHP (php)</li>
  <li>Powerhsell (powershell)</li>
  <li>Prolog (prolog)</li>
  <li>Python (py, python)</li>
  <li>PureBasic (purebasic, pb)</li>
  <li>QML (qml)</li>
  <li>R (r)</li>
  <li>RAW (raw) - kode gordina, EnlighterJS edukiontziaren estiloekin nabarmendu gabe!</li>
  <li>RouterOS/SwitchOS (routeros)</li>
  <li>Ruby (ruby)</li>
  <li>Rust (rust)</li>
  <li>Scala (scala)</li>
  <li>SCSS (scss, sass)</li>
  <li>Shellscript (shell, bash)</li>
  <li>Generic SQL (sql)</li>
  <li>Squirrel (squirrel)</li>
  <li>Swift (swift)</li>
  <li>Typescript (typescript)</li>
  <li>VHDL (vhdl)</li>
  <li>VisualBasic (visualbasic,vb)</li>
  <li>Verilog (verilog)</li>
  <li>XML (xml, html)</li>
  <li>YAML (yaml)</li>
</ul>';
$string['enlighterjs'] = 'EnlighterJS';
$string['enlighterjsstyle'] = 'EnlighterJS estiloa';
$string['filtername'] = 'SynHi sintaxi nabarmentzailea';
$string['generalinformation'] = 'Kodea nabarmentzeko soilik \'pre\' etiketa erabiltzea kendu da, horren ordez \'code\' etiketa erabili ezazu eta lerro anitzeko kodea \'pre\' etiketarekin inguratu ezazu. \'code\' etiketaren barruan \'<\' eta \'>\' sinboloak erabiltzeak arazoak eman ditzake; etiketa baten antza dutenean, zure kodean \'<i>(amphersand)</i>lt;\' eta \'<i>(amphersand)</i>gt;\'-rekin ordezkatu itzazu hurrenez urren - hemen <i>(amphersand)</i> \'&\' esan nahi du.';
$string['information'] = 'Informazioa';
$string['informationchanges'] = 'Aldaketak';
$string['informationheading'] = 'Informazioa';
$string['informationheadingdesc'] = 'Iragazkiaren inguruko informazioa';
$string['informationsettings'] = 'Informazioaren ezarpenak';
$string['informationsettingsdesc'] = 'SynHi sintaxi nabarmentzailearen informazioa';
$string['love'] = 'maitasunarekin';
$string['pluginname'] = 'SynHi sintaxi nabarmentzailea';
$string['privacy:nop'] = 'SynHi sintaxi nabarmentzailea iragazkiak bere ezarpenekin lotutako datuak gordetzen ditu. Ezarpen hauek ez dute inolako erabiltzailerekin loturarik. Zure ardura da inongo testu-eremuetan erabiltzaile-daturik ez idaztea. Ezarpen bat zehazteak ekintza hori Moodleko erregistroan aldaketa hori egin duen erabiltzaileari lotuta gordetzea eragingo du, eta hau iragazkiaren kontroletik kanpo dago, honekin lotutako pribatutasuna aztertzeko sistemako erregistro-sistemara jo ezazu. Zure kodea adi aztertu ezazu zure pribatutasun-legeen zure interpretazioa betetzen dutela ziurtatzeko. Ez naiz abokatu bat eta nire analisia nire interpretazioan oinarrituta dago. Inongo zalantzarik baduzu iragazkia berehala kendu ezazu.';
$string['settings'] = 'Ezarpenak';
$string['settingssettings'] = 'Ezarpenen konfigurazioa';
$string['settingssettingsdesc'] = 'SynHi sintaxi nabarmentzailea iragazkiaren ezarpenak';
$string['styledesc'] = 'Aukeratu erabili nahi duzun estiloa';
$string['syntaxhighlighter'] = 'SyntaxHighlighter';
$string['syntaxhighlighterexample'] = 'Adibidea';
$string['syntaxhighlighterexampledesc'] = '\'Kodea\' ezarpenetik hartuta...';
$string['syntaxhighlighterinformation'] = 'SyntaxHighlighter-entzako, zure kodea \'code\' etiketarekin inguratu ezazu eta class="brush: alias" gehitu ezazu non \'alias\' parentesi arteko hurrengo hauetako bat den:<br>
<ul>
  <li>ActionScript3 (as3, actionscript3)</li>
  <li>Bash/shell (bash, shell)</li>
  <li>ColdFusion (cf, coldfusion)</li>
  <li>C# (c-sharp, csharp)</li>
  <li>C++ (cpp, c)</li><li>CSS (css)</li>
  <li>Delphi (delphi, pas, pascal)</li>
  <li>Diff (diff, patch)</li>
  <li>Erlang (erl, erlang)</li>
  <li>Groovy (groovy)</li>
  <li>JavaScript (js, jscript, javascript)</li>
  <li>Java (java)</li>
  <li>JavaFX (jfx, javafx)</li>
  <li>Perl (perl, pl)</li>
  <li>PHP (php)</li>
  <li>Plain Text (plain, text)</li>
  <li>PowerShell (ps, powershell)</li>
  <li>Python (py, python)</li>
  <li>Ruby (rails, ror, ruby)</li>
  <li>Scala (scala)</li>
  <li>SQL (sql)</li>
  <li>Visual Basic (vb, vbnet)</li>
  <li>XML (xml, xhtml, xslt, html, xhtml)</li>
</ul>';
$string['syntaxhighlighterstyle'] = 'SyntaxHighlighter-en estiloa';
$string['versionalpha'] = 'Alfa bertsioa - Ziurrenik arazoak izango ditu. SOILIK garatzaileentzako den garapen bertsio bat da! Ezta pentsatu ere bertsio hau lanean dagoen zerbitzari batean instalatzean!';
$string['versionbeta'] = 'Beta bertsioa - Arazoak izatea ohikoa da. Kudeatzaileek soilik probetarako zerbitzari batean probatzeko prest dago.';
$string['versioninfo'] = '{$a->release} argitarapena, Moodle {$a->moodle}-(e)rako {$a->version} bertsioa. Erresuma Batuan {$a->love} eginda.';
$string['versionrc'] = 'Azken bertsiorako hautagaia den bertsioa - Baliteke arazoak izatea. Probetarako zerbitzari batean sakon probatu ezazu lanean dagoen zerbitzari batean instalatzean pentsatu baino lehen.';
$string['versionstable'] = 'Bertsio egonkorra - Arazoren bat izan dezake. Probetarako zerbitzari batean probatu ezazu lanean dagoen zerbitzari batean instalatu baino lehen.';
