<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'pt', version '4.5'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ação';
$string['activityoverview'] = 'Existem questionários que já expiraram';
$string['additionalinfo'] = 'Informação adicional';
$string['additionalinfo_help'] = 'Texto a exibir no topo da primeira página do questionário (por exemplo, instruções, informações gerais, objetivos, etc.)';
$string['addnewquestion'] = 'Adicionar questão do tipo: {$a}';
$string['addnewsection'] = 'Adicionar nova secção';
$string['addquestion'] = 'Adicionar questão...';
$string['addquestions'] = 'Adicionar questões';
$string['addquestiontosection'] = 'Adicionar questão à secção';
$string['addselqtype'] = 'Adicionar questão do tipo selecionado';
$string['alignment'] = 'Alinhamento dos botões de rádio';
$string['alignment_help'] = 'Selecione o alinhamento dos botões: vertical (predefinido) ou horizontal.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Todos';
$string['allnameddegrees'] = 'Avaliação alfabética';
$string['allnameddegrees_help'] = 'Especifique o texto a ser exibido para valores da avaliação em vez do número. Deixe em branco para não usar.';
$string['alreadyfilled'] = 'Já submeteu este questionário {$a}. Obrigado.';
$string['andaveragevalues'] = 'e valores médios';
$string['anonymous'] = 'Anónimo';
$string['answer'] = 'Resposta';
$string['answergiven'] = 'Dada esta resposta';
$string['answernotgiven'] = 'Não dada esta resposta';
$string['answerquestions'] = 'Responder ao questionário';
$string['answers'] = 'Respostas';
$string['attempted'] = 'Questionário submetido com sucesso';
$string['attemptstillinprogress'] = 'Resposta ao questionário em progresso. Guardado em:';
$string['autonumbering'] = 'Numeração automática';
$string['autonumbering_help'] = 'Numeração automática de questões e páginas. Não ative esta opção no caso de questionários com respostas dependentes (condicionadas).';
$string['autonumberno'] = 'Sem numeração automática de questões ou páginas';
$string['autonumberpages'] = 'Com numeração automática de páginas';
$string['autonumberpagesandquestions'] = 'Com numeração automática de questões e páginas';
$string['autonumberquestions'] = 'Com numeração automática de questões';
$string['average'] = 'Média';
$string['averageposition'] = 'Posição média';
$string['averagerank'] = 'Classificação média';
$string['averagesrow'] = 'Média (quando aplicável):';
$string['bodytext'] = 'Corpo da mensagem';
$string['boxesnbexact'] = 'exatamente {$a} caixa(s).';
$string['boxesnbmax'] = ' no máximo {$a} caixa(s).';
$string['boxesnbmin'] = ' no mínimo {$a} caixa(s).';
$string['boxesnbreq'] = 'Nesta questão deve assinalar';
$string['by'] = 'por';
$string['cannotviewpublicresponses'] = 'Não é possível visualizar as respostas deste questionário público.';
$string['centerlabel'] = 'Etiqueta central';
$string['chart:bipolar'] = 'Barras bipolares';
$string['chart:hbar'] = 'Barras horizontais';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Rosa';
$string['chart:type'] = 'Tipo de gráfico';
$string['chart:type_help'] = 'Selecione o tipo de gráfico que pretende usar no feedback';
$string['chart:vprogress'] = 'Barra de progressão vertical';
$string['checkallradiobuttons'] = 'Ao responder, tem de assinalar [<strong>{$a}</strong>] botões de rádio nesta questão.';
$string['checkboxes'] = 'Caixas de seleção';
$string['checkboxes_help'] = 'Insira uma opção por linha para que o participante selecione uma ou mais opções de resposta.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Nova(s) quebra(s) de página inserida(s) na(s) posição(ões):';
$string['checkbreaksok'] = 'Estão presentes todas as quebras de página necessárias!';
$string['checkbreaksremoved'] = 'Removida(s) {$a} quebra(s) de página extra.';
$string['checknotstarted'] = 'Selecionar não iniciado(s)';
$string['checkstarted'] = 'Selecionar iniciado(s)';
$string['clicktoswitch'] = '(clique para alternar)';
$string['closebeforeopen'] = 'Especificou uma data/hora de fecho antes da data de abertura';
$string['closed'] = 'O questionário terminou {$a}. Obrigado.';
$string['closedate'] = 'Permitir respostas até';
$string['closeson'] = 'O questionário termina {$a}.';
$string['completionsubmit'] = 'Os participantes têm de submeter o questionário para o concluir';
$string['condition'] = 'Condição';
$string['confalts'] = '- OU - <br />Página de confirmação';
$string['configemailreporting'] = 'Permitir relatórios por e-mail';
$string['configemailreportinglong'] = 'Se ativar esta opção, as opções para que alguns relatórios sejam enviados diretamente por e-mail para endereços de e-mail especificados estarão ativas.';
$string['configmaxsections'] = 'Máximo de secções de feedback';
$string['configusergraph'] = 'Mostrar gráficos no feedback de "Teste de personalidade"';
$string['configusergraphlong'] = 'Usar a biblioteca <a href="http://www.rgraph.net/">Rgraph</a> para mostrar gráficos no feedback de "Teste de Personalidade".';
$string['confirmdelallresp'] = 'Tem a certeza de que pretende apagar TODAS as respostas a este questionário?';
$string['confirmdelchildren'] = 'Se apagar esta questão, a(s) questão(ões) dependente(s) também será(ão) apagada(s):';
$string['confirmdeletesection'] = 'Tem a certeza de que pretende apagar a secção de comentários "{$a}"?';
$string['confirmdelgroupresp'] = 'Tem a certeza de que pretende apagar TODAS as respostas de {$a}?';
$string['confirmdelquestion'] = 'Tem a certeza de que pretende apagar a questão na posição {$a}?';
$string['confirmdelquestionresps'] = 'Isso também apagará {$a} resposta(s) já dada(s) a esta questão.';
$string['confirmdelresp'] = 'Tem a certeza de que pretende apagar a resposta de {$a}?';
$string['confirmremovequestion'] = 'Tem a certeza de que pretende apagar a questão "{$a->qname}" da secção "{$a->sname}"?';
$string['confpage'] = 'Titulo';
$string['confpage_help'] = 'Titulo (a negrito) e texto da mensagem que é mostrado na página de \'Confirmação\' após o participante responder/concluir o questionário. (Se definir um URL, este tem precedência em relação ao texto de confirmação).
Se deixar este campo em branco, será exibida uma mensagem predefinida (**Obrigado por ter respondido ao questionário**).';
$string['confpagedesc'] = 'Titulo (a negrito) e texto da mensagem que é mostrado na página de \'Confirmação\'; página exibida após o participante completar o questionário. (Se definir um URL, este tem precedência em relação ao texto de confirmação).';
$string['contentoptions'] = 'Opções do questionário';
$string['couldnotcreatenewsurvey'] = 'Não foi possível criar um novo questionário!';
$string['couldnotdelresp'] = 'Não foi possível apagar a resposta';
$string['createcontent'] = 'Conteúdo inicial do questionário';
$string['createcontent_help'] = 'Selecione um dos botões de rádio. \'Criar novo\' questionário é a opção predefinida.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Criar novo questionário';
$string['crontask'] = 'Trabalho de limpeza do questionário';
$string['date'] = 'Data';
$string['date_help'] = 'Use este tipo de questão se pretende uma resposta na forma de uma data corretamente formatada.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Use o formato ano-mês-dia (exemplo: 1969-07-20 para Domingo, 20 de julho de 1969)';
$string['deleteallresponses'] = 'Apagar TODAS as respostas';
$string['deletecurrentquestion'] = 'Apagar a questão {$a}';
$string['deletedallgroupresp'] = 'Foram apagadas TODAS as respostas de {$a}';
$string['deletedallresp'] = 'TODAS as respostas a este questionário foram apagadas';
$string['deletedisabled'] = 'Este item não pode ser apagado';
$string['deletedresp'] = 'Resposta apagada';
$string['deleteresp'] = 'Apagar esta resposta';
$string['deletesection'] = 'Apagar esta secção';
$string['deletingresp'] = 'A apagar resposta';
$string['dependencies'] = 'Dependências';
$string['dependquestion'] = 'Dependente da questão';
$string['dependquestion_help'] = 'Pode selecionar uma questão e uma opção de resposta da qual esta questão depende. A questão dependente só será exibida ao aluno, se a questão de que depende for respondida com a opção definida.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Não respondeu à questão';
$string['directwarnings'] = 'As dependências diretas para esta questão serão apagadas. Isso afetará:';
$string['displaymethod'] = 'Método de exibição não definido para a questão.';
$string['download'] = 'Descarregar';
$string['downloadpdf'] = 'Descarregar PDF';
$string['downloadtextformat'] = 'Descarregar';
$string['downloadtextformat_help'] = 'Esta opção permite que guarde todas as respostas do questionário num formato de ficheiro suportado e selecionável.
Pode optar por incluir itens de dados extras na exportação, além de poder enviar automaticamente o ficheiro para utilizadores selecionados.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Tipo de relatório';
$string['dropdown'] = 'Lista pendente';
$string['dropdown_help'] = 'Não existe grande vantagem em usar Listas pendentes em vez de Botões de Rádio, exceto quando as opções de resposta são uma lista grande.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Editar';
$string['editingfeedback'] = 'A editar as configurações do feedback';
$string['editingquestionnaire'] = 'Editar configurações';
$string['editquestion'] = 'Editar questão do tipo: {$a}';
$string['email'] = 'E-mail';
$string['emailextra'] = 'Enviar para e-mails';
$string['emailextra_help'] = 'O ficheiro descarregado será enviado para os endereços de e-mail listados, separados por vírgulas. Tenha em atenção que NÃO é feita nenhuma verificação de segurança ou privacidade.
A permissão \'allowemailreporting\' deve estar ativada nas configurações do módulo para aceder a esta funcionalidade.';
$string['emailroles'] = 'Enviar para papéis';
$string['emailroles_help'] = 'O ficheiro descarregado será enviado por e-mail para os papéis com a permissão "mod/questionnaire:submissionnotification".
A permissão \'allowemailreporting\' deve estar ativada nas configurações do módulo para aceder a esta funcionalidade.';
$string['emailsend'] = 'Enviar relatórios';
$string['emailsnotspecified'] = 'Não foram especificados e-mails.';
$string['emailssent'] = 'Os ficheiros descarregados foram enviados para o(s) e-mail(s) especificado(s).';
$string['errnewname'] = 'O nome já existe, escolha um nome diferente.';
$string['erroropening'] = 'Ocorreu um erro ao abrir o questionário.';
$string['errortable'] = 'Ocorreu um erro na tabela do sistema.';
$string['essaybox'] = 'Caixa de ensaio';
$string['essaybox_help'] = 'Esta questão irá exibir uma caixa de texto simples com **X** colunas (ou largura da área de texto) e **Y** linhas (número de linhas de texto).
Se deixar tanto X como Y com o seu valor predefinido de 0 (ou se alterar para 0), então será exibido um editor HTML com valores de altura e largura standard (se estiver disponível no contexto disciplina/aluno e perfil do participante).';
$string['event_all_responses_deleted'] = 'Todas as respostas foram apagadas';
$string['event_all_responses_saved_as_text'] = 'Todas as respostas foram guardadas como texto';
$string['event_all_responses_viewed'] = 'Relatório de todas as respostas visualizado';
$string['event_individual_responses_viewed'] = 'Relatório de respostas individuais visualizado';
$string['event_non_respondents_viewed'] = 'Visualizados os utilizadores sem resposta';
$string['event_previewed'] = 'Questionário pré-visualizado';
$string['event_question_created'] = 'Questão criada';
$string['event_question_deleted'] = 'Questão eliminada';
$string['event_response_deleted'] = 'Resposta individual eliminada';
$string['event_resumed'] = 'Retomada a tentativa';
$string['event_saved'] = 'Respostas guardadas';
$string['event_submitted'] = 'Respostas submedtidas';
$string['feedback'] = 'Feedback';
$string['feedback_help'] = 'Ajuda no Feedback do questionário';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Adicionar mais {no} campos de feedback';
$string['feedbackbysection'] = 'Secções de Feedback';
$string['feedbackdefaultlabel'] = '[Nova secção]';
$string['feedbackeditingglobal'] = 'Edição do Feedback Global';
$string['feedbackeditingmessages'] = 'Edição das Mensagens de Feedback';
$string['feedbackeditingsections'] = 'Edição das Secções de Feedback';
$string['feedbackeditmessages'] = 'Guardar as configurações e editar Mensagens de Feedback';
$string['feedbackeditsections'] = 'Guardar as configurações e editar Secções de Feedback';
$string['feedbackerrorboundaryformat'] = 'Os limites de pontuação de feedback devem ser uma percentagem ou um número. O valor inserido no limite {$a} não é reconhecido.';
$string['feedbackerrorboundaryoutofrange'] = 'A pontuação de feedback deve estar entre 0% e 100%. O valor inserido {$a} está fora do intervalo.';
$string['feedbackerrorjunkinboundary'] = 'Deve preencher todas as caixas de limite de pontuação de feedback sem deixar espaços em branco.';
$string['feedbackerrorjunkinfeedback'] = 'Deve preencher as caixas de feedback sem deixar espaços em branco.';
$string['feedbackerrororder'] = 'Os limites da pontuação devem estar por ordem, mais alto primeiro. O valor inserido no limite {$a} está fora da sequência.';
$string['feedbackglobal'] = 'Feedback Global';
$string['feedbackglobalheading'] = 'Título do Feedback global';
$string['feedbackglobalmessages'] = 'Mensagens de Feedback global';
$string['feedbackhdr'] = 'Feedbacks';
$string['feedbackheading'] = 'Título do Feedback';
$string['feedbackheading_help'] = 'No campo *Título do Feedback* pode usar 2 variáveis: $scorepercent e $oppositescorepercent.';
$string['feedbackmessages'] = 'Mensagens de Feedback da secção {$a}';
$string['feedbacknextsection'] = 'Próxima secção {$a}';
$string['feedbacknone'] = 'Sem mensagens de feedback';
$string['feedbacknotes'] = 'Notas do feedback';
$string['feedbacknotes_help'] = 'O texto aqui inserido será exibido no final do relatório de feedback aos utilizadores que responderem ao questionário';
$string['feedbackoptions'] = 'Opções de feedback';
$string['feedbackoptions_help'] = 'As opções de feedback estão disponíveis se o questionário contém um dos seguintes tipos e configurações de questões: *botões de rádio*, *lista pendente*, *sim/não* ou *classificação*. Estas questões devem ser definidas como de **Resposta obrigatória**, o Nome da questão **NÃO** pode estar vazio e as opções possíveis de resposta têm de conter um valor.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Esta questão faz parte da secção [{$a}] de feedback';
$string['feedbackremovesection'] = 'Eliminar esta questão irá remover completamente a secção [{$a}] do feedback';
$string['feedbackreport'] = 'Relatório do feedback';
$string['feedbackscore'] = 'Pontuação do feedback';
$string['feedbackscoreboundary'] = 'Limite da pontuação do feedback';
$string['feedbackscores'] = 'Mostrar pontuações';
$string['feedbackscores_help'] = 'Mostrar a tabela de pontuações de feedback';
$string['feedbacksection'] = 'Secção';
$string['feedbacksectionheading'] = 'Título do Feedback da secção {$a}';
$string['feedbacksectionheadingmissing'] = 'Deve digitar um título para esta secção de Feedback!';
$string['feedbacksectionheadingtext'] = 'Título do Feedback';
$string['feedbacksectionlabel'] = 'Etiqueta';
$string['feedbacksectionlabel_help'] = 'Esta etiqueta será utilizada nos gráficos/diagramas. Por favor, mantenha-a o mais curto possível!';
$string['feedbacksectionquestions'] = '{$a} questões da secção';
$string['feedbacksections'] = 'Secções de feedback';
$string['feedbacksectionsselect'] = 'Secções';
$string['feedbacksectionsselect_help'] = 'Disponha as questões para as diversas secções';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Configurações do Feedback guardadas';
$string['feedbacktype'] = 'Tipos de Feedback';
$string['field'] = 'Questão {$a}';
$string['fieldlength'] = 'Tamanho da caixa de texto';
$string['fieldlength_help'] = 'Para o tipo de questão **Caixa de Texto**, insira o valor do **Comprimento da caixa de texto** e o **Comprimento máximo do texto** permitido.
Os valores predefinidos são de 20 caracteres para o comprimento da caixa de texto e 25 caracteres para o comprimento máximo do texto.';
$string['finished'] = 'Respondeu a todas as questões deste questionário!';
$string['firstrespondent'] = 'Primeira resposta';
$string['formateditor'] = 'Editor HTML';
$string['formatplain'] = 'Texto simples';
$string['grade'] = 'Nota da submissão';
$string['gradesdeleted'] = 'Apagadas as avaliações das questões';
$string['headingtext'] = 'Titulo';
$string['horizontal'] = 'Horizontal';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Incluir código das opções de escolha';
$string['includechoicetext'] = 'Incluir designação das opções de escolha';
$string['includeincomplete'] = 'Incluir respostas incompletas';
$string['includerankaverages'] = 'Incluir classificação média da pergunta';
$string['incorrectcourseid'] = 'O ID da disciplina está incorreto';
$string['incorrectmodule'] = 'O ID do módulo da disciplina está incorreto';
$string['incorrectquestionnaire'] = 'O questionário está incorreto';
$string['indirectwarnings'] = 'Esta lista mostra as questões dependentes indiretas e as restantes dependências para questões dependentes diretas:';
$string['invalidincrement'] = 'Tenha em atenção que os incrementos de valor devem ser menores que o valor máximo. Por exemplo, se for uma escala de 1 a 10, o valor do incremento provavelmente será 1.';
$string['invalidminmaxrange'] = 'Este tipo de questão suporta um intervalo máximo absoluto de -100 a +100. É expectável que a grande maioria dos questionário use uma faixa de 1 a 10 ou -10 a +10.';
$string['invalidrange'] = 'O valor máximo do controlo deslizante deve ser maior que o valor mínimo.';
$string['invalidresponse'] = 'Resposta inválida';
$string['invalidresponserecord'] = 'Registo de resposta inválido';
$string['invalidsectionid'] = 'Especificada secção inválida de feedback.';
$string['invalidstartingvalue'] = 'O valor inicial deve ser igual ou entre os valores mínimo e máximo. Por exemplo, se estiver a usar uma escala de 1 a 10, o valor inicial pode ser 5.';
$string['invalidsurveyid'] = 'ID do questionário inválido';
$string['kindofratescale'] = 'Tipo de escala';
$string['kindofratescale_help'] = 'Clique com o botão direito do rato na hiperligação abaixo *Mais ajuda*.';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Última resposta';
$string['leftlabel'] = 'Etiqueta à esquerda';
$string['length'] = 'Comprimento';
$string['managequestions'] = 'Gerir questões';
$string['managequestions_help'] = 'Na secção *Gerir questões* da página **Questões**, pode realizar uma série de operações nas questões do questionário (editar, mover, apagar).';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Obrigatório - Todas estas dependências devem ser cumpridas.';
$string['maxdigitsallowed'] = 'Máximo de caracteres permitidos';
$string['maxdigitsallowed_help'] = 'Use **Max. dígitos permitidos** para definir um limite para o número de caracteres digitados numa questão numérica. Tenha em atenção que o ponto decimal também conta como um caractere!';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Número máximo de respostas';
$string['maxforcedresponses_help'] = 'Use estes parâmetros para obrigar a assinalar um mínimo de **Min.** e um máximo de **Máx.** caixas de seleção. Para obrigar a que um número exato de caixas de seleção seja assinalado, defina **Min.** e **Máx.** com o mesmo valor. Se apenas pretender definir um dos limites, mínimo ou máximo, basta deixar o outro com o valor predefinido de **0**. Se definir **Min.** ou **Máx.** com valores diferentes de **0**, aparecerá uma mensagem de aviso se o utilizador não cumprir estes requisitos. Obviamente, deve informar os requisitos de forma clara quer nas instruções gerais do Questionário quer no texto das respetivas questões.';
$string['maxrange'] = 'Máximo do controlo deslizante (direita)';
$string['maxrange_help'] = 'Defina o valor máximo do intervalo no lado direito. O valor predefinido é 100, mas pode ser qualquer número entre 1 e 100. Se o valor mínimo para o lado esquerdo for um valor negativo, o alcance máximo será expresso com um sinal positivo (+).';
$string['maxtextlength'] = 'Tamanho máximo do texto';
$string['maxtextlength_help'] = 'Para o tipo de questão caixa de texto, indique o comprimento da caixa de entrada e o tamanho máximo de texto de texto permitido na resposta.
Os valores predefinidos são 20 caracteres para a largura da caixa de entrada e 25 caracteres para o tamanho máximo do texto inserido.';
$string['messageprovider:message'] = 'Lembrete do questionário';
$string['messageprovider:notification'] = 'Submissão do questionário';
$string['minforcedresponses'] = 'Número mínimo de respostas';
$string['minforcedresponses_help'] = 'Use estas opções para forçar os alunos a selecionarem um número **Mínimo** e **Máximo** de caixas de seleção. Para especificar um número exato de caixas a serem selecionadas, configure **Mínimo** e **Máximo** com o mesmo valor. Se pretender apenas fixar o valor máximo ou o mínimo, deixe o outro campo preenchido com o valor **0**. Se definir os valores máximo e mínimo para um valor superior a **0** será exibida uma mensagem de alerta para que os alunos cumpram estes limites, sendo que tais instruções também devem ser apresentadas nas instruções gerais do questionário ou not texto das questões em que são aplicados.';
$string['minrange'] = 'Mínimo do controlo deslizante (esquerda)';
$string['minrange_help'] = 'Defina o valor mínimo do intervalo no lado esquerdo. O valor predefinido é 1, mas pode ser definido como -100. Se usar um número negativo (-100 a -1), o máximo à direita será expresso com um sinal positivo (+).';
$string['misconfigured'] = 'Disciplina mal configurada';
$string['missingname'] = 'A questão {$a} não pode ser utilizada nesta secção de feedback porque não tem nome.';
$string['missingnameandrequired'] = 'A questão {$a} não pode ser utilizada nesta secção de feedback porque não tem nome e não é obrigatória.';
$string['missingquestion'] = 'Responda à questão obrigatória';
$string['missingquestions'] = 'Responda às questões obrigatórias ';
$string['missingrequired'] = 'A questão {$a} não pode ser utilizada nesta secção de feedback porque não é obrigatória.';
$string['modulename'] = 'Questionário';
$string['modulename_help'] = 'O módulo Questionário permite construir inquéritos com vários tipos de questões, tendo por objetivo obter informação dos utilizadores.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Questionários';
$string['movedisabled'] = 'Este item não pode ser movido';
$string['myresponses'] = 'Todas as suas respostas';
$string['myresponsetitle'] = 'As suas [ {$a} ] respostas';
$string['myresults'] = 'Os seus resultados';
$string['name'] = 'Nome';
$string['navigate'] = 'Permitir questões dependentes';
$string['navigate_help'] = 'Ativar questões Sim/Não e Botões de Rádio de modo a ter questões dependentes das escolhas de respostas no questionário.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Ir para a secção de feedback';
$string['next'] = 'Seguinte';
$string['nextpage'] = 'Página Seguinte';
$string['nlines'] = '{$a} linhas';
$string['noanswer'] = 'Sem resposta';
$string['noattempts'] = 'Nenhuma tentativa de resposta a este questionário';
$string['nodata'] = 'Não foram submetidos dados.';
$string['noduplicates'] = 'Sem escolhas duplicadas';
$string['noduplicateschoiceserror'] = 'Deve inserir pelo menos 2 respostas possíveis para a opção "Sem escolhas duplicadas"!';
$string['non_respondents'] = 'Utilizadores que ainda não submeteram as suas respostas a este questionário';
$string['noneinuse'] = 'Este questionário ainda não contém questões.';
$string['nopublicsurveys'] = 'Não existem questionários centralizados.';
$string['noresponsedata'] = 'Nenhuma resposta para esta questão.';
$string['noresponses'] = 'Sem respostas';
$string['normal'] = 'Normal';
$string['not_started'] = 'não iniciado';
$string['notanumber'] = '<strong>{$a}</strong> não é um número ou está num formato de número não adequado.';
$string['notapplicable'] = 'NS/NR';
$string['notapplicablecolumn'] = 'Com coluna NS/NR';
$string['notavail'] = 'O questionário já não está disponível.';
$string['noteligible'] = 'Não é elegível para responder a este questionário.';
$string['notemplatesurveys'] = 'Não existem questionários modelo.';
$string['notenoughscaleitems'] = 'Deve inserir pelo menos 2 itens para a escala!';
$string['notificationfull'] = 'Submissão completa';
$string['notifications'] = 'Enviar notificações de submissão';
$string['notifications_help'] = 'Notificar os utilizadores com a permissão "mod/questionnaire:submissionnotification" sempre que for feita uma submissão.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Apenas notificação';
$string['notopen'] = 'Este questionário só estará disponível a partir de {$a}.';
$string['notrequired'] = 'Resposta facultativa';
$string['notset'] = 'não definido';
$string['nousersselected'] = 'Nenhum utilizador selecionado';
$string['num'] = '#';
$string['numattemptsmade'] = '{$a} tentativas de resposta a este questionário';
$string['numberfloat'] = 'O número que introduziu <strong>{$a->number}</strong> foi alterado/arredondado para <strong>{$a->precision}</strong> casas decimais.';
$string['numberofdecimaldigits'] = 'Número de casas decimais';
$string['numberofdecimaldigits_help'] = 'Use **Nº de dígitos decimais** para especificar o formato do valor da Média que é mostrado na página do relatório do Questionário.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Número de itens';
$string['numberscaleitems_help'] = 'Número de itens é o *número de itens de classificação* que são utilizados na escala. Normalmente são usados 3 a 5 itens.<br />Valor predefinido: **5**.';
$string['numeric'] = 'Numérica';
$string['numeric_help'] = 'Use esta questão se pretende uma resposta na forma de um número formatado corretamente.';
$string['of'] = 'de';
$string['openafterclose'] = 'Especificou uma data/hora de abertura após a data de fecho';
$string['opendate'] = 'Permitir respostas desde';
$string['option'] = 'opção {$a}';
$string['optional'] = 'Opcional - pelo menos uma destas dependências deve ser cumprida.';
$string['optionalname'] = 'Nome da Questão';
$string['optionalname_help'] = 'O nome da questão apenas é usado quando exporta as questões para o formato CSV/Excel.
Não necessita de se preocupar com estes nomes se não exportar para CSV.
Se pretender exportar regularmente os seus questionários para CSV, tem a opção de escolha entre duas opções para a nomenclatura a usar.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- OU -';
$string['order_ascending'] = 'Ordem ascendente';
$string['order_default'] = 'Ordem predefinida';
$string['order_descending'] = 'Ordem descendente';
$string['orderresponses'] = 'Ordem das respostas';
$string['orderresponses_help'] = 'Ao "Ver TODAS as respostas" pode ordenar as escolhas por número de respostas (coluna da média) para os seguintes 4 tipos de questões:

* Escolha única com Botões de Rádio
* Escolha única com Lista Pendente
* Escolha múltipla com Caixas de seleção
* Questões de Classificação (incluindo escalas Likert).

Quando entra na página **Ver TODAS as respostas**, por predefinição, as questões estão dispostas na ordem em que o criador do questionário as inseriu. Pode optar por ordená-las por ordem ascendente ou descendente.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Tipo Osgood';
$string['other'] = 'Outro:';
$string['otherempty'] = 'Se selecionar esta opção, deve introduzir texto na caixa de texto.';
$string['overviewnumresplog'] = 'respostas';
$string['overviewnumresplog1'] = 'resposta';
$string['overviewnumrespvw'] = 'respostas';
$string['overviewnumrespvw1'] = 'resposta';
$string['owner'] = 'Dono';
$string['page'] = 'Página';
$string['pageof'] = 'Página {$a->page} de {$a->totpages}';
$string['parent'] = 'Antecedente';
$string['participant'] = 'Participante';
$string['pleasecomplete'] = 'Por favor, preencha esta escolha.';
$string['pluginadministration'] = 'Administração do Questionário';
$string['pluginname'] = 'Questionário';
$string['position'] = 'posição';
$string['possibleanswers'] = 'Insira as opções de resposta';
$string['posteddata'] = 'Página com dados submetidos:';
$string['preview_label'] = 'Pré-visualização';
$string['preview_questionnaire'] = 'Pré-visualização do Questionário';
$string['previewing'] = 'Pré-visualização do Questionário';
$string['previous'] = 'Anterior';
$string['previouspage'] = 'Página Anterior';
$string['print'] = 'Imprimir esta resposta';
$string['printblank'] = 'Imprimir em branco';
$string['printblanktooltip'] = 'Abrir nova janela com questionário em branco para imprimir';
$string['printtooltip'] = 'Abrir nova janela com estas respostas para que possa imprimir';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Uma resposta a uma questão de escolha múltipla.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'ID do registo de opção para esta resposta.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'ID do registo da questão para esta resposta.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'ID do registo desta resposta.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Uma resposta a uma questão de escolha única.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'ID do registo de opção de resposta para esta resposta.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'ID do registo da questão para esta resposta.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'ID do registo desta resposta.';
$string['privacy:metadata:questionnaire_response'] = 'Uma resposta em progresso ou já submetida';
$string['privacy:metadata:questionnaire_response:complete'] = 'O estado de conclusão da resposta.';
$string['privacy:metadata:questionnaire_response:grade'] = 'A nota para esta resposta.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'O ID do registo do questionário desta resposta.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Data e hora da gravação mais recente desta resposta.';
$string['privacy:metadata:questionnaire_response:userid'] = 'ID do utilizador desta resposta.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Uma resposta a uma questão booleana (sim/não).';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'A resposta booleana específica.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'ID do registo da questão para esta resposta.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'ID do registo desta resposta.';
$string['privacy:metadata:questionnaire_response_date'] = 'Uma resposta a uma questão de data.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'ID do registo da questão para esta resposta.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'A resposta de data específica.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'ID do registo desta resposta.';
$string['privacy:metadata:questionnaire_response_other'] = 'Um texto de resposta à opção "outra"';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'ID do registo de escolha para esta resposta.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'ID do registo da questão para esta resposta.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'A resposta de texto específica.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'ID do registo desta resposta.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Uma resposta a uma questão de classificação.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'ID do registo de escolha para esta resposta.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'ID do registo da questão para esta resposta.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'A resposta de classificação específica.';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'ID do registo de resposta para esta resposta.';
$string['privacy:metadata:questionnaire_response_text'] = 'Uma resposta a uma questão de texto.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'ID do registo da questão para esta resposta.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'A resposta de texto específica.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'ID do registo desta resposta.';
$string['private'] = 'Privado';
$string['progressbar'] = 'Mostrar barra de progresso';
$string['progressbar_info'] = 'O questionário está \'{$a}\' completo.';
$string['progresshelp'] = 'Barra de progresso';
$string['progresshelp_help'] = 'Prossiga para a próxima página para preencher a barra de progresso';
$string['public'] = 'Centralizado';
$string['publiccopy'] = 'Cópia:';
$string['publicoriginal'] = 'Original:';
$string['qtype'] = 'Tipo de resposta';
$string['qtype_help'] = 'Selecione se os alunos podem responder apenas uma vez, se podem responder diariamente, semanalmente, mensalmente ou um número ilimitado de vezes.';
$string['qtypedaily'] = 'responder diariamente';
$string['qtypemonthly'] = 'responder mensalmente';
$string['qtypeonce'] = 'responder apenas uma vez';
$string['qtypeunlimited'] = 'responder várias vezes';
$string['qtypeweekly'] = 'responder semanalmente';
$string['questionnaire:addinstance'] = 'Adicionar novo questionário';
$string['questionnaire:copysurveys'] = 'Copiar questionários modelo e questionários privados';
$string['questionnaire:createpublic'] = 'Criar questionários centralizados';
$string['questionnaire:createtemplates'] = 'Criar questionários modelo';
$string['questionnaire:deleteresponses'] = 'Apagar respostas';
$string['questionnaire:downloadresponses'] = 'Exportar respostas para ficheiro CSV';
$string['questionnaire:editquestions'] = 'Criar e editar questões do questionário';
$string['questionnaire:manage'] = 'Criar e editar questionários';
$string['questionnaire:message'] = 'Enviar mensagem aos participantes que não responderam';
$string['questionnaire:preview'] = 'Pré-visualizar questionários';
$string['questionnaire:printblank'] = 'Imprimir questionário em branco';
$string['questionnaire:readallresponseanytime'] = 'Ver sempre todas as respostas';
$string['questionnaire:readallresponses'] = 'Ver estatísticas de resposta, no período definido';
$string['questionnaire:readownresponses'] = 'Ver as suas respostas';
$string['questionnaire:submissionnotification'] = 'Receber notificação de cada submissão';
$string['questionnaire:submit'] = 'Completar e submeter questionário';
$string['questionnaire:view'] = 'Ver o questionário';
$string['questionnaire:viewsingleresponse'] = 'Ver respostas individuais completas';
$string['questionnaireadministration'] = 'Administração do Questionário';
$string['questionnairecloses'] = 'Data de fecho';
$string['questionnaireopens'] = 'Data de abertura';
$string['questionnairereport'] = 'Relatório';
$string['questionnum'] = 'Questão #';
$string['questions'] = 'Questões';
$string['questionsinsection'] = 'Questões nesta secção:';
$string['questiontypes'] = 'Tipos de questões';
$string['questiontypes_help'] = 'Consulte a documentação geral do Moodle';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Botões de Rádio';
$string['radiobuttons_help'] = 'Neste tipo de questão, o aluno deve escolher uma das várias opções disponíveis.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Classificação';
$string['ratescale'] = 'Classificação (escala 1...5)';
$string['ratescale_help'] = 'Consulte a documentação geral do Moodle';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Tipo de Questionário';
$string['realm_help'] = '* **Existem três tipos de questionários:**
 * Privado - criado e acedido apenas numa disciplina.
 * Modelo - pode ser copiado e editado.
 * Centralizado - pode ser partilhado em várias disciplinas.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'URL para o qual o utilizador é redirecionado depois de completar este questionário.';
$string['remove'] = 'Apagar';
$string['removeallquestionnaireattempts'] = 'Apagar todas as respostas ao questionário';
$string['removenotinuse'] = 'Este questionário dependia de um questionário centralizado que foi apagado.
O questionário já não pode ser usado e deve ser apagado.';
$string['required'] = 'Resposta obrigatória';
$string['required_help'] = 'Se selecionar a opção **Sim**, a resposta a esta questão é obrigatória, ou seja o aluno não pode submeter o questionário enquanto não responder à questão.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'Está em falta um parâmetro obrigatório';
$string['reset'] = 'Reiniciar';
$string['respeligiblerepl'] = '(substituir pelos papéis)';
$string['respondent'] = 'Utilizador';
$string['respondenteligibleall'] = 'todos';
$string['respondenteligiblestudents'] = 'apenas alunos';
$string['respondenteligibleteachers'] = 'apenas professores';
$string['respondents'] = 'Utilizadores';
$string['respondenttype'] = 'Identificação do utilizador';
$string['respondenttype_help'] = 'O nome completo pode aparecer junto de cada resposta se escolher a opção "Nome Completo". Para ocultar a identidade dos utilizadores, escolha a opção "Anónimo".';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'Anónimo';
$string['respondenttypefullname'] = 'Nome Completo';
$string['response'] = 'Resposta';
$string['responsefieldlines'] = 'Tamanho da caixa';
$string['responseformat'] = 'Formatação da resposta';
$string['responseoptions'] = 'Opções de resposta';
$string['responses'] = 'Total de respostas';
$string['responseview'] = 'Os alunos podem ver TODAS as respostas';
$string['responseview_help'] = 'Pode especificar quem pode ver as respostas de todos os que responderam ao questionário (tabelas gerais de estatísticas).';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Sempre';
$string['responseviewstudentsnever'] = 'Nunca';
$string['responseviewstudentswhenanswered'] = 'Após responder ao questionário';
$string['responseviewstudentswhenclosed'] = 'Após o questionário fechar';
$string['restrictedtoteacher'] = 'Estas funções são permitidas apenas a professores editores!';
$string['resume'] = 'Permitir Guardar/Continuar as respostas';
$string['resume_help'] = 'Escolher esta opção permite aos utilizadores guardar as suas respostas antes de submetê-las.
Os participantes podem sair do questionário e mais tarde terminá-lo a partir do ponto onde ficaram.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Continuar/retomar o questionário';
$string['return'] = 'Voltar';
$string['rightlabel'] = 'Etiqueta à direita';
$string['save'] = 'Guardar';
$string['save_and_exit'] = 'Guardar e sair';
$string['saveasnew'] = 'Guardar como nova questão';
$string['savedbutnotsubmitted'] = 'Este questionário foi guardado mas ainda não foi submetido.';
$string['savedprogress'] = 'O seu progresso de respostas foi guardado. Pode retomar a qualquer instante para completar este questionário.';
$string['saveeditedquestion'] = 'Guardar questão {$a}';
$string['savesettings'] = 'Guardar configurações';
$string['search:activity'] = 'Questionário - informações da atividade';
$string['search:question'] = 'Questionário - questões';
$string['section'] = 'Descrição';
$string['sectionbreak'] = '----- Quebra de Secção -----';
$string['sectionbreak_help'] = '----- Quebra de Secção -----';
$string['sectionsnotset'] = 'Tem de selecionar pelo menos <strong>UMA</strong> questão por secção!<br />Secção(ões) não selecionada(s): <strong>{$a}</strong>';
$string['sectiontext'] = 'Separador';
$string['sectiontext_help'] = 'Não é propriamente uma questão mas sim um (curto) texto que será exibido para introduzir uma sequência de questões ou para servir de separador.';
$string['selecttheme'] = 'Selecione um tema (CSS) para usar com este questionário.';
$string['send'] = 'Enviar';
$string['send_message'] = 'Enviar mensagem aos utilizadores selecionados';
$string['send_message_to'] = 'Enviar mensagem a:';
$string['sendemail'] = 'Enviar e-mail';
$string['sendemail_help'] = 'Envia uma cópia de cada questionário submetido para o endereço de e-mail aqui indicado. Pode inserir mais que um endereço de e-mail separados por vírgulas.
Deixe em branco para não enviar e-mail. A permissão \'allowemailreporting\' deve estar ativada nas configurações do módulo para aceder a esta funcionalidade.';
$string['set'] = 'definido';
$string['settings'] = 'Configurações';
$string['settingssaved'] = 'Configurações guardadas';
$string['show_nonrespondents'] = 'Sem resposta';
$string['slider'] = 'Controlo deslizante';
$string['slider_help'] = 'O controlo deslizante da questão permite que os respondentes selecionem um valor de um intervalo contínuo arrastando um controlo deslizante entre dois extremos. Também pode ser definido Um valor central.';
$string['started'] = 'iniciado';
$string['startingvalue'] = 'Valor inicial do Slider';
$string['startingvalue_help'] = 'O valor inicial do controlo deslizante especifica a partir de onde o controlo deslizante deve aparecer para os respondentes. O valor predefinido é 1 porque o intervalo é desconhecido. Pode iniciá-lo no centro do intervalo, fornecendo um valor central (num intervalo de 1 a 100 tem o valor central de 50).';
$string['stepvalue'] = 'Valor de incremento do controlo deslizante';
$string['stepvalue_help'] = 'O valor de incremento do controlo deslizante especifica com que precisão pretende que os respondentes indiquem as suas respostas no intervalo. A predefinição da questão é um intervalo de 1 a 100 com um incremento de um, permitindo que os respondentes forneçam valores de 70, 71, 72, 73, 74, etc. Pode definir incrementos de cinco, permitindo que os respondentes forneçam valores de 60, 65, 70, 75, 80, etc., ou apenas um intervalo de 1 a 10 com incrementos de 1.';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['strictdateformatting'] = 'Insira a data utilizando o seletor de data abaixo.';
$string['subject'] = 'Assunto';
$string['submissionnotificationhtmlanon'] = 'Existe uma nova <a href="{$a->submissionurl}">submissão</a> do questionário "{$a->name}".';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> fez uma nova <a href="{$a->submissionurl}">submissão</a> do questionário "{$a->name}" na disciplina "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'Nova submissão do questionário';
$string['submissionnotificationtextanon'] = 'Existe uma nova submissão ({$a->submissionurl}) do questionário "{$a->name}".';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) fez uma nova submissão ({$a->submissionurl}) do questionário "{$a->name}" na disciplina "{$a->coursename}".';
$string['submitoptions'] = 'Opções de submissão';
$string['submitpreview'] = 'Pré-visualização da submissão';
$string['submitpreviewcorrect'] = 'Esta submissão será aceite como preenchida corretamente.';
$string['submitsurvey'] = 'Submeter respostas';
$string['submitted'] = 'Data/hora de submissão:';
$string['subtitle'] = 'Subtítulo';
$string['subtitle_help'] = 'O subtítulo do questionário aparece apenas abaixo do título na primeira página.';
$string['summary'] = 'Resumo';
$string['summaryreportattached'] = 'Relatório de resumo do questionário em anexo';
$string['surveynotexists'] = 'questionário não existe.';
$string['surveyowner'] = 'Só o dono do questionário pode realizar esta operação.';
$string['surveyresponse'] = 'Respostas ao questionário';
$string['template'] = 'Modelo';
$string['templatenotviewable'] = 'Os questionários modelo não são visíveis.';
$string['text'] = 'Texto da Questão';
$string['textareacolumns'] = 'Número de colunas';
$string['textareacolumns_help'] = 'Esta questão irá exibir uma caixa de texto simples com **X** colunas (ou largura da área de texto) e **Y** linhas (número de linhas de texto).
Se deixar tanto X como Y com o seu valor predefinido de 0 (ou se o configurar para 0), então será exibido um editor HTML com valores standard de altura e largura (se estiver disponível no contexto disciplina/aluno e perfil do participante).';
$string['textarearows'] = 'Número de linhas';
$string['textbox'] = 'Caixa de texto';
$string['textbox_help'] = 'Para o tipo de questão **Caixa de Texto**, insira o valor do **Comprimento da caixa de texto** e o **Comprimento máximo do texto** permitido.

Os valores predefinidos são de 20 caracteres para o comprimento da caixa de texto e 25 caracteres para o comprimento máximo do texto.';
$string['textdownloadoptions'] = 'Opções de exportação em formato Texto (CSV)';
$string['thank_head'] = 'Agradecemos a sua colaboração ao responder a este questionário.';
$string['theme'] = 'Tema';
$string['thismonth'] = 'este mês';
$string['thisresponse'] = 'Esta resposta';
$string['thisweek'] = 'esta semana';
$string['thousands'] = 'Não usar separador de milhares.';
$string['title'] = 'Título do questionário';
$string['title_help'] = 'Título do questionário que aparece no início de cada página. Por predefinição o título é igual ao nome do questionário mas pode editá-lo como desejar.';
$string['today'] = 'hoje';
$string['total'] = 'Total';
$string['totalofnumbers'] = 'Total de números digitados';
$string['totalresponses'] = 'Total de respostas à questão';
$string['type'] = 'Tipo de questão';
$string['undefinedquestiontype'] = 'Tipo de questão indefinido';
$string['unknown'] = 'Desconhecido';
$string['unknownaction'] = 'Acão especificada desconhecida…';
$string['url'] = 'URL de confirmação';
$string['url_help'] = 'O URL para o qual é redirecionado cada participante após submeter o questionário.';
$string['useprivate'] = 'Cópia de questionário';
$string['usepublic'] = 'Usar questionário centralizado';
$string['usetemplate'] = 'Usar questionário modelo';
$string['vertical'] = 'Vertical';
$string['view'] = 'Ver';
$string['viewallresponses'] = 'Ver TODAS as respostas';
$string['viewallresponses_help'] = 'Se o questionário está configurado para o **Modo de Grupos**: *Grupos visíveis*, ou definido para *Grupos separados* e o utilizador atual tem a permissão *moodle/site:accessallgroups* (no contexto atual), e os grupos foram definidos na disciplina atual, o utilizador tem acesso a uma lista pendente com os grupos. A lista pendente permite que o utilizador possa "filtrar" as respostas ao questionário por grupos. Se a definição **Modo de Grupos**: *Grupos separados* estiver ativa, os utilizadores que não têm a permissão *moodle/site:accessallgroups* (normalmente alunos ou professores não editores, etc.) só serão capazes de ver as respostas do(s) grupo(s) a que pertence(m).';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Lista de respostas';
$string['viewindividualresponse'] = 'Respostas individuais';
$string['viewindividualresponse_help'] = 'Clique no nome de cada participante no questionário para visualizar as respetivas respostas individuais.';
$string['viewresponses'] = 'Todas as respostas ({$a})';
$string['viewyourresponses'] = 'Ver as suas respostas';
$string['warning'] = 'Aviso, erro detetado.';
$string['wronganswers'] = 'Ocorreu um erro. Por favor, verifique as suas respostas.';
$string['wrongdateformat'] = 'O formato da data inserida [<strong>{$a}</strong>] não corresponde ao formato apresentado no exemplo.';
$string['wrongdaterange'] = '<strong>ERRO</strong>! O ano deve ser de 1902 a 2037.';
$string['wrongformat'] = 'Por favor, verifique a sua resposta à questão:&nbsp;';
$string['wrongformats'] = 'Por favor, verifique as suas respostas às questões:&nbsp;';
$string['yesno'] = 'Sim/Não';
$string['yesno_help'] = 'Tipo de questão em que o aluno só tem como opção de resposta *Sim* ou *Não*.';
$string['yourresponse'] = 'Ver a sua resposta';
$string['yourresponses'] = 'Ver as suas respostas';
