<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'id', version '4.5'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TODO';
$string['activityisscheduledfordeletion'] = 'Penghapusan sedang berlangsung ...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" bukanlah nilai yang valid untuk usia.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" memiliki lebih atau kurang dari satu pemisah koma.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" bukan nilai yang valid untuk negara.';
$string['agedigitalconsentmapinvaliddefault'] = 'Nilai bawaan (*) tidak ada.';
$string['agelocationverificationdisabled'] = 'Verifikasi usia dan lokasi dinonaktifkan';
$string['alreadyloggedin'] = 'Anda sudah masuk sebagai {$a}, Anda harus keluar sebelum masuk sebagai pengguna yang berbeda.';
$string['authnotexisting'] = 'Pengaya autorisasi tidak ada';
$string['backupcontainexternal'] = 'Berkas cadangan ini berisi Host Jaringan Moodle eksternal yang tidak dikonfigurasi secara lokal';
$string['backuptablefail'] = 'Tabel cadangan TIDAK dapat berhasil disiapkan!';
$string['blockcannotadd'] = 'Tidak bisa menambahkan blok';
$string['blockcannotconfig'] = 'Blok ini tidak mendukung konfigurasi global';
$string['blockcannotinistantiate'] = 'Blokir masalah yang membuat model objek';
$string['blockcannotread'] = 'Tidak bisa membaca data untuk blockid={$a}';
$string['blockdoesnotexist'] = 'Blok ini tidak ada';
$string['blockdoesnotexistonpage'] = 'Blok (id={$a->instanceid}) tidak ada pada halaman ({$a->url}).';
$string['blocknameconflict'] = 'Konflik penamaan: blok {$a->name} memiliki nama yang sama dengan blok yang ada: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Panggilan balik komentar menolak komentar ini.';
$string['cannotaddcoursemodule'] = 'Tidak dapat menambahkan modul kursus baru';
$string['cannotaddcoursemoduletosection'] = 'Tidak dapat menambahkan modul kursus baru pada topik tersebut';
$string['cannotaddmodule'] = 'Modul {$a} tidak dapat ditambahkan ke daftar modul!';
$string['cannotaddnewmodule'] = 'Tidak dapat menambahkan modul baru dari {$a}';
$string['cannotaddrss'] = 'Anda tidak memiliki izin untuk menambahkan umpan rss';
$string['cannotaddthisblocktype'] = 'Anda tidak dapat menambahkan blok {$a} ke halaman ini.';
$string['cannotassignrole'] = 'Tidak dapat menerapkan peran pada kursus';
$string['cannotassignrolehere'] = 'Anda tidak diizinkan untuk menetapkan peran ini (id = {$a->roleid}) dalam konteks ini ({$a->context})';
$string['cannotassignselfasparent'] = 'Tidak dapat menetapkan diri sendiri sebagai induk!';
$string['cannotcallscript'] = 'Anda tidak dapat memanggil skrip ini dengan cara itu';
$string['cannotcallusgetselecteduser'] = 'Anda tidak dapat memanggil user_selector::get_selected_user jika multi pilih benar.';
$string['cannotcreatebackupdir'] = 'Tidak dapat membuat folder backupdata. Administrator situs perlu memperbaiki izin berkas';
$string['cannotcreatecategory'] = 'Kategori tidak dimasukkan';
$string['cannotcreatedboninstall'] = '<p> Tidak dapat membuat basis data. </p> <p> Basis data yang ditentukan tidak ada dan pengguna yang diberikan tidak memiliki izin untuk membuat basis data. </p> <p> Administrator situs harus memverifikasi konfigurasi basis data. < / p>';
$string['cannotcreategroup'] = 'Kesalahan ketika membuat grup';
$string['cannotcreatelangbase'] = 'Kesalahan: Tidak dapat membuat direktori bahasa dasar';
$string['cannotcreatelangdir'] = 'Tidak dapat membuat direktori lang';
$string['cannotcreateorfindstructs'] = 'Galat menemukan atau membuat struktur bagian kursus ini';
$string['cannotcreatepopupwin'] = 'Elemen tidak ditentukan - tidak dapat membuat jendela pop-up';
$string['cannotcreatesitedir'] = 'Tidak dapat membuat folder situs. Administrator situs perlu memperbaiki izin berkas.';
$string['cannotcreatetempdir'] = 'Tidak dapat membuat direktori temp';
$string['cannotcreateuploaddir'] = 'Tidak dapat membuat folder unggahan. Administrator situs perlu memperbaiki izin berkas.';
$string['cannotcustomisefiltersblockuser'] = 'Anda tidak dapat menyesuaikan setelan filter di pengguna atau memblokir konteks.';
$string['cannotdeletebackupids'] = 'Tidak dapat menghapus id cadangan sebelumnya';
$string['cannotdeletecategorycourse'] = 'Kursus \'{$a}\' gagal dihapus.';
$string['cannotdeletecategoryquestions'] = 'Tidak dapat menghapus soal dari kategori \'{$a}\'';
$string['cannotdeletecourse'] = 'Anda tidak memiliki wewenang untuk menghapus kursus ini';
$string['cannotdeletecustomfield'] = 'Terjadi kesalahan saat menghapus data kolom kustom';
$string['cannotdeletedir'] = 'Tidak dapat menghapus ({$a})';
$string['cannotdeletefile'] = 'Tidak dapat menghapus berkas ini';
$string['cannotdeleterole'] = 'Ini tidak dapat dihapus, karena {$a}';
$string['cannotdeleterolewithid'] = 'Tidak dapat menghapus peran dengan ID {$a}';
$string['cannotdeletethisrole'] = 'Anda tidak dapat menghapus peran ini karena digunakan oleh sistem, atau karena ini adalah peran terakhir dengan kemampuan administrator.';
$string['cannotdisableformat'] = 'Anda tidak dapat menonaktifkan format bawaan';
$string['cannotdownloadcomponents'] = 'Tidak dapat mengunduh komponen';
$string['cannotdownloadlanguageupdatelist'] = 'Tidak dapat mengunduh daftar pembaruan bahasa dari download.moodle.org';
$string['cannotdownloadzipfile'] = 'Tidak dapat mengunduh berkas ZIP';
$string['cannoteditcomment'] = 'Komentar ini bukan milik Anda untuk diedit!';
$string['cannoteditcommentexpired'] = 'Anda tidak dapat mengeditnya. Waktu telah telah berakhir!';
$string['cannoteditpostorblog'] = 'Anda tidak dapat mengirim atau mengedit blog';
$string['cannoteditsiteform'] = 'Anda tidak dapat mengedit situs kursus ini menggunakan formulir ini';
$string['cannotedituserpreferences'] = 'Tidak dapat mengedit preferensi pengguna ini';
$string['cannotedityourprofile'] = 'Maaf, Anda tidak dapat mengedit profil sendiri';
$string['cannotexecduringupgrade'] = 'Tidak dapat dijalankan selama peningkatan';
$string['cannotfindcategory'] = 'Tidak dapat menemukan catatan kategori dari basis data dengan ID - {$a}';
$string['cannotfindcomponent'] = 'Tidak dapat menemukan komponen';
$string['cannotfindcontext'] = 'Tidak dapat menemukan konteks';
$string['cannotfindcourse'] = 'Tidak dapat menemukan kursus';
$string['cannotfinddocs'] = 'Tidak dapat menemukan berkas dokumen bahasa "{$a}"';
$string['cannotfindgradeitem'] = 'Tidak dapat menemukan grade_item';
$string['cannotfindgroup'] = 'Tidak dapat menemukan grup';
$string['cannotfindhelp'] = 'Tidak dapat menemukan file bantuan bahasa "{$a}"';
$string['cannotfindinfo'] = 'Tidak dapat menemukan info untuk: "{$a}"';
$string['cannotfindlang'] = 'Paket bahasa "{$a}" tidak ditemukan!';
$string['cannotfindteacher'] = 'Tidak dapat menemukan pengajar';
$string['cannotfinduser'] = 'Tidak dapat menemukan pengguna bernama "{$a}"';
$string['cannotgeoplugin'] = 'Tidak dapat terhubung ke server geoPlugin di https://www.geoplugin.com. Silakan periksa setelan proksi Anda atau instal berkas data MaxMind GeoIP City.';
$string['cannotgetblock'] = 'Tidak dapat mengambil blok dari basis data';
$string['cannotgetcats'] = 'Tidak bisa mendapatkan log kategori';
$string['cannotgetdata'] = 'Tidak bisa mendapatkan data';
$string['cannotgradeuser'] = 'Tidak dapat menilai pengguna ini';
$string['cannothaveparentcate'] = 'Kategori kursus tidak memiliki induk!';
$string['cannotimport'] = 'Kesalahan impor';
$string['cannotimportformat'] = 'Maaf, mengimpor format ini belum diterapkan!';
$string['cannotimportgrade'] = 'Kesalahan impor nilai';
$string['cannotinsertgrade'] = 'Tidak dapat memberikan nilai tanpa ID kursus!';
$string['cannotinsertrate'] = 'Tidak dapat memasukkan peringkat baru
 ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Tidak dapat memasukkan ID catatan baru {$a}';
$string['cannotmailconfirm'] = 'Terjadi kesalahan saat mengirim surel konfirmasi perubahan kata sandi';
$string['cannotmanualctrack'] = 'Aktivitas tidak menyediakan pelacakan penyelesaian manual';
$string['cannotmapfield'] = 'Benturan pemetaan terdeteksi - dua ruas dipetakan ke item nilai yang sama {$a}';
$string['cannotmarktopic'] = 'Tidak dapat menandai bagian itu untuk kursus ini';
$string['cannotmigratedatacomments'] = 'Tidak dapat memindahkan komentar modul data';
$string['cannotmodulename'] = 'Tidak bisa mendapatkan nama modul dalam navigasi build';
$string['cannotmoduletype'] = 'Tidak bisa mendapatkan jenis modul dalam navigasi build';
$string['cannotmovecategory'] = 'Tidak dapat memindahkan kategori';
$string['cannotmovecourses'] = 'Tidak dapat memindahkan kursus dari satu kategori ke yang lainnya.';
$string['cannotmoverolewithid'] = 'Tidak dapat memindahkan peran dengan ID {$a}';
$string['cannotopencsv'] = 'Tidak dapat membuka berkas CSV';
$string['cannotopenfile'] = 'Tidak dapat membuka berkas ({$a})';
$string['cannotopenforwrit'] = 'Tidak dapat dibuka untuk ditulis: {$a}';
$string['cannotopentemplate'] = 'Tidak dapat membuka file template ({$a})';
$string['cannotopenzip'] = 'Tidak dapat membuka file zip, mungkin bug ekstensi zip pada 64bit os';
$string['cannotoverridebaserole'] = 'Tidak dapat mengesampingkan kemampuan peran dasar';
$string['cannotoverriderolehere'] = 'Anda tidak diizinkan untuk mengganti peran ini (id = {$a->roleid}) pada konteks ini ({$a->context})';
$string['cannotreadfile'] = 'Tidak dapat membaca berkas ({$a})';
$string['cannotreadtmpfile'] = 'Kesalahan membaca file sementara';
$string['cannotreaduploadfile'] = 'Tidak dapat membaca berkas yang diunggah';
$string['cannotremovefrommeta'] = 'Tidak dapat menghapus kursus dari meta kursus ini!';
$string['cannotreprocessgrades'] = 'Tidak dapat memproses ulang nilai untuk aktivitas ini {$a}';
$string['cannotresetguestpwd'] = 'Anda tidak dapat mengatur ulang kata sandi tamu';
$string['cannotresetmail'] = 'Galat saat menyetel ulang sandi dan pengiriman surel pada Anda.';
$string['cannotresetthisrole'] = 'Tidak dapat setel ulang peran ini';
$string['cannotrestore'] = 'Terjadi kesalahan dan pemulihan tidak dapat diselesaikan!';
$string['cannotrestoreadminorcreator'] = 'Anda harus menjadi pembuat atau pengguna admin untuk dapat mengembalikan pada kursus baru!';
$string['cannotrestoreadminoredit'] = 'Anda harus menjadi pengajar yang dapat mengedit atau pengguna admin untuk mengembalikan pada kursus terpilih!';
$string['cannotsaveagreement'] = 'Tidak dapat menyimpan persetujuan Anda';
$string['cannotsaveblock'] = 'Galat saat menyimpan konfigurasi blok';
$string['cannotsavecomment'] = 'Tidak dapat menyimpan komentar';
$string['cannotsavedata'] = 'Tidak dapat menyimpan data';
$string['cannotsavefile'] = 'Tidak dapat menyimpan berkas "{$a}"!';
$string['cannotsavemd5file'] = 'Tidak dapat menyimpan berkas md5';
$string['cannotsavezipfile'] = 'Tidak dapat menyimpan berkas ZIP';
$string['cannotservefile'] = 'Tidak dapat melayani berkas - masalah pada konfigurasi server.';
$string['cannotsetparentforcatoritem'] = 'Tidak dapat menyetel induk untuk kategori atau kursus!';
$string['cannotsetpassword'] = 'Tidak dapat menyetel kata sandi pengguna!';
$string['cannotsetprefgrade'] = 'Tidak dapat menyetel tampilan agregasi preferensi ke {$a} untuk kategori nilai ini';
$string['cannotsettheme'] = 'Tidak dapat menyetel tema!';
$string['cannotsetupblock'] = 'Tabel blok TIDAK dapat berhasil disiapkan!';
$string['cannotsetupcapformod'] = 'Tidak dapat menyiapkan kapabilitas untuk {$a}';
$string['cannotsetupcapforplugin'] = 'Tidak dapat menyiapkan kapabilitas untuk {$a}';
$string['cannotshowhidecoursesincategory'] = 'Tidak dapat menampilkan/sembunyikan kursus dalam kategori {$a}.';
$string['cannotsignup'] = 'Anda tidak dapat membuat akun baru karena Anda sudah masuk sebagai {$a}.';
$string['cannotunassigncap'] = 'Tidak dapat membatalkan penetapan kemampuan yang tidak digunakan lagi {$a->cap} dari peran {$a->role}';
$string['cannotunassignrolefrom'] = 'Tidak dapat membatalkan penetapan pengguna ini dari id peran: {$a}';
$string['cannotunzipfile'] = 'Tidak dapat mengekstrak berkas';
$string['cannotupdatemod'] = 'Tidak dapat memperbarui {$a}';
$string['cannotupdatepasswordonextauth'] = 'Gagal memperbarui sandi pada autentikasi eksternal: {$a}. Lihat log server untuk lebih jelasnya.';
$string['cannotupdateprofile'] = 'Galat saat memperbarui catatan pengguna';
$string['cannotupdaterecord'] = 'Tidak dapat memperbarui ID catatan {$a}';
$string['cannotupdaterss'] = 'Tidak dapat memperbarui RSS';
$string['cannotupdatesubcourse'] = 'Tidak dapat perbarui kursus di bawahnya!';
$string['cannotupdateusermsgpref'] = 'Tidak dapat memperbaharui preferensi pesan pengguna';
$string['cannotupdateuseronexauth'] = 'Gagal memperbarui data pengguna di autentikasi eksternal: {$a}. Lihat log server untuk lebih jelasnya.';
$string['cannotuploadfile'] = 'Galat saat memproses berkas unggahan';
$string['cannotuseadmin'] = 'Anda harus menjadi pengguna admin untuk menggunakan halaman ini';
$string['cannotuseadminadminorteacher'] = 'Anda harus menjadi pengajar atau pengguna admin untuk menggunakan halaman ini';
$string['cannotusepage'] = 'Hanya pengajar dan administrator yang dapat menggunakan halaman ini';
$string['cannotusepage2'] = 'Maaf, Anda tidak dapat menggunakan halaman ini';
$string['cannotviewcategory'] = 'Anda tidak memiliki izin untuk melihat daftar kursus';
$string['cannotviewprofile'] = 'Anda tidak dapat melihat profil pengguna ini';
$string['cannotviewreport'] = 'Anda tidak dapat melihat laporan ini';
$string['cannotwritefile'] = 'Tidak dapat menulis ke berkas ({$a})';
$string['categoryerror'] = 'Kesalahan kategori';
$string['categoryidnumbertaken'] = 'Nomor ID telah digunakan kategori lain';
$string['categorynamerequired'] = 'Nama kategori harus diisi';
$string['categorytoolong'] = 'Nama kategori terlalu panjang';
$string['commentmisconf'] = 'ID komentar salah dikonfigurasi';
$string['componentisuptodate'] = 'Komponen sudah mutakhir';
$string['confirmationnotenabled'] = 'Konfirmasi pengguna tidak diaktifkan di situs ini';
$string['confirmsesskeybad'] = 'Maaf, tetapi kunci sesi Anda tidak dapat dikonfirmasi untuk melakukan tindakan ini. Fitur keamanan ini mencegah pelaksanaan fungsi penting yang tidak disengaja atau jahat atas nama Anda. Harap pastikan Anda benar-benar ingin menjalankan fungsi ini.';
$string['contenttypenotfound'] = 'Jenis bank konten \'{$a}\' tidak ada atau tidak dikenal.';
$string['contentvisibilitynotfound'] = 'Visibilitas konten dengan nilai \'{$a}\' tidak ada atau tidak dikenali.';
$string['couldnotassignrole'] = 'Terjadi kesalahan yang serius tetapi tidak ditentukan saat mencoba menetapkan peran untuk Anda';
$string['couldnotupdatenoexistinguser'] = 'Tidak dapat memperbarui pengguna - pengguna tidak ada';
$string['couldnotverifyagedigitalconsent'] = 'Galat saat mencoba memverifikasi usia persetujuan digital. <br /> Harap hubungi administrator.';
$string['countriesphpempty'] = 'Galat: Berkas countries.php pada paket bahasa {$a} kosong atau hilang';
$string['coursedoesnotbelongtocategory'] = 'Kursus tidak termasuk dalam kategori ini';
$string['courseformatnotfound'] = 'Format kursus \'{$a}\' tidak ada atau tidak dikenali';
$string['coursegroupunknown'] = 'Kursus yang sesuai dengan grup {$a} tidak ditentukan';
$string['courseidnotfound'] = 'ID kursus tidak ada';
$string['courseidnumbertaken'] = 'Nomor ID telah digunakan kursus lain ({$a})';
$string['coursemisconf'] = 'Kesalahan konfigurasi kursus';
$string['courserequestdisabled'] = 'Maaf, permintaan kursus telah dinonaktifkan oleh administrator';
$string['csvcolumnduplicates'] = 'Terdeteksi duplikasi kolom';
$string['csvemptyfile'] = 'Berkas CSV kosong';
$string['csvfewcolumns'] = 'Kolom tidak cukup, harap verifikasi setelan pembatas';
$string['csvfileerror'] = 'Ada yang salah dengan format berkas CSV. Harap periksa jumlah tajuk dan kolom yang cocok, dan apakah pemisah dan pengodean berkas sudah benar. {$a}';
$string['csvinvalidcols'] = '<b> Berkas CSV tidak valid: </b> Baris pertama harus menyertakan "Ruas Tajuk" dan berkas harus berjenis <br /> "Ruas diperluas/ Dibatasi koma" <br /> atau <br /> "Ruas diperluas dengan Kode Hasil CAVV/Dipisahkan Koma"';
$string['csvinvalidcolsnum'] = 'Berkas CSV tidak valid - setiap baris harus menyertakan 49 atau 70 ruas';
$string['csvloaderror'] = 'Galat saat memuat berkas CSV: {$a}';
$string['csvnodata'] = 'Berkas CSV tidak valid - Berkas CSV memiliki tajuk tetapi tidak berisi data apa pun.';
$string['csvweirdcolumns'] = 'Format berkas CSV tidak valid - jumlah kolom tidak konstan!';
$string['dbconnectionfailed'] = '<p> Galat: Koneksi basis data gagal </p> <p> Ada kemungkinan basis data kelebihan beban atau sebaliknya tidak berjalan dengan baik. </p> <p> Administrator situs juga harus memeriksa bahwa detail basis data telah ditentukan dengan benar di config.php </p>';
$string['dbdriverproblem'] = '<p> Galat: masalah pengandar basis data terdeteksi </p> <p> Administrator situs harus memverifikasi konfigurasi server </p> <p> {$a} </p>';
$string['dbsessionbroken'] = 'Masalah sesi basis data yang serius terdeteksi. <br /> <br /> Harap beri tahu administrator server.';
$string['dbsessionhandlerproblem'] = 'Gagal menyiapkan sesi basis data. Harap beri tahu administrator server.';
$string['dbsessionmysqlpacketsize'] = 'Kesalahan sesi yang serius terdeteksi. Harap beri tahu administrator situs. Masalahnya kemungkinan besar disebabkan oleh nilai kecil dalam setelan MySQL max_allowed_packet.';
$string['dbupdatefailed'] = 'Pembaruan basis data gagal';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" tidak dapat dimodifikasi.
 Ketergantungan ditemukan dengan
 {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Kesalahan eksekusi DDL sql';
$string['ddlfieldalreadyexists'] = 'Ruas "{$a}" sudah ada';
$string['ddlfieldnotexist'] = 'Ruas "{$a->fieldname}" tidak ada pada tabel "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabel "{$a}" sudah ada';
$string['ddltablenotexist'] = 'Tabel "{$a}" tidak ada';
$string['ddlunknownerror'] = 'Galat pustaka DDL tidak diketahui';
$string['ddlxmlfileerror'] = 'Kesalahan berkas basis data XML ditemukan';
$string['ddsequenceerror'] = 'Definisi tabel "{$a}" salah; hanya ada satu kolom otomatis dan harus didefinisikan sebagai kunci.';
$string['destinationcmnotexit'] = 'Modul kursus tujuan tidak ada';
$string['detectedbrokenplugin'] = 'Pengaya "{$a}" rusak atau ketinggalan zaman, tidak dapat melanjutkan, maaf.';
$string['dmlexceptiononinstall'] = '<p>Terjadi kesalahan basis data [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Galat saat mengurai kueri SQL';
$string['dmlreadexception'] = 'Galat membaca dari basis data';
$string['dmltransactionexception'] = 'Galat transaksi basis data';
$string['dmlwriteexception'] = 'Galat saat menulis ke basis data';
$string['dndmaxbytes'] = 'Berkas terlalu besar. Ukuran maksimum yang diperbolehkan adalah {$a->size}';
$string['dndread'] = 'Kesalahan membaca berkas';
$string['dndunkownfile'] = 'Tipe berkas ini tidak didukung';
$string['dndupload'] = 'Galat yang tidak diketahui saat mengunggah berkas';
$string['downgradedcore'] = 'GALAT!!! Kode yang Anda gunakan lebih lama daripada versi yang tersimpan di basis data ini!';
$string['downloadedfilecheckfailed'] = 'Pemeriksaan berkas yang diunduh gagal';
$string['duplicatefieldname'] = 'Terdeteksi duplikasi nama ruas "{$a}"';
$string['duplicatenosupport'] = 'Aktivitas \'{$a->modname}\' tidak dapat diduplikasi karena modul {$a->modtype} tidak mendukung pencadangan dan pemulihan.';
$string['duplicateparaminsql'] = 'GALAT: nama parameter duplikat dalam kueri';
$string['duplicaterolename'] = 'Sudah ada peran dengan nama ini!';
$string['duplicateroleshortname'] = 'Sudah ada peran dengan nama singkat ini!';
$string['duplicateusername'] = 'Duplikat nama pengguna  - lewati';
$string['editedpagenotfound'] = 'Sistem tidak dapat menentukan halaman tempat Anda berada. Segarkan halaman dan coba lagi.';
$string['emailfail'] = 'Pengiriman surel gagal';
$string['encryption_decryptfailed'] = 'Dekripsi gagal';
$string['encryption_encryptfailed'] = 'Enkripsi gagal';
$string['encryption_invalidkey'] = 'Kunci tidak sesuai';
$string['encryption_keyalreadyexists'] = 'Kunci sudah ada';
$string['encryption_nokey'] = 'Kunci tidak ditemukan';
$string['encryption_wrongmethod'] = 'Data tidak cocok dengan metode enkripsi yang didukung';
$string['enddatebeforestartdate'] = 'Tanggal akhir kursus harus setelah tanggal mulai.';
$string['error'] = 'Terjadi kesalahan';
$string['error_question_answers_missing_in_db'] = 'Gagal menemukan jawaban yang cocok "{$a->answer}" pada tabel basis data question_answers. Ini terjadi saat memulihkan pertanyaan dengan id {$a->filequestionid} pada berkas cadangan, yang telah cocok dengan soal yang ada dengan id {$a->dbquestionid} pada basis data.';
$string['errorcleaningdirectory'] = 'Galat saat membersihkan direktori "{$a}"';
$string['errorcopyingfiles'] = 'Galat menyalin berkas';
$string['errorcreatingdirectory'] = 'Galat membuat direktori {$a}"';
$string['errorcreatingfile'] = 'Galat membuat berkas {$a}"';
$string['errorcreatingrole'] = 'Galat membuat peran';
$string['errorfetchingrssfeed'] = 'Galat saat mengambil umpan RSS.';
$string['erroronline'] = 'Kesalahan pada baris {$a}';
$string['erroroutput'] = 'Galat keluaran, jadi nonaktifkan pengalihan otomatis.';
$string['errorparsingxml'] = 'Galat mengurai XML: {$a->errorstring} pada baris {$a->errorline}, karakter {$a->errorchar}';
$string['errorprocessingarchive'] = 'Galat saat memproses file arsip';
$string['errorreadingfile'] = 'Galat membaca berkas "{$a}"';
$string['errorsavingrequest'] = 'Galat saat mencoba menyimpan permintaan Anda.';
$string['errorsettinguserpref'] = 'Galat saat menyetel preferensi pengguna';
$string['errorunzippingfiles'] = 'Galat saat mengekstrak berkas';
$string['expiredkey'] = 'Kunci kedaluwarsa';
$string['externalauthpassworderror'] = 'Kata sandi tidak kosong untuk autentikasi eksternal';
$string['externalfilenolocation'] = 'File eksternal tidak memiliki jalur lokasi';
$string['failtoloadblocks'] = 'Satu atau lebih blok terdaftar di pangkalan data, tetapi semuanya gagal dimuat!';
$string['fieldrequired'] = '"{$a}" adalah ruas yang harus diisi';
$string['fileexists'] = 'Berkas telah ada';
$string['filemismatch'] = 'Ketidakcocokan nama berkas non-core. Berkas "{$a->current}" harus {$a->file}';
$string['filenotfound'] = 'Maaf, berkas yang diminta tidak dapat ditemukan';
$string['filenotreadable'] = 'Berkas tidak dapat dibaca';
$string['filterdoesnothavelocalconfig'] = 'Filter {$a} tidak mengizinkan konfigurasi lokal.';
$string['filternotactive'] = 'Filter {$a} saat ini tidak aktif';
$string['filternotenabled'] = 'Filter tidak diaktifkan!';
$string['filternotinstalled'] = 'Filter {$a} saat ini tidak dipasang';
$string['forumblockingtoomanyposts'] = 'Anda telah melampaui ambang pengeposan yang ditetapkan untuk forum ini';
$string['functionalityremoved'] = 'Anda mencoba mengakses fungsionalitas yang telah dihapus.';
$string['gdfeaturenotsupported'] = 'Ekstensi GD tidak dikompilasi dengan metode untuk {$a}';
$string['gdmimetypenotsupported'] = 'Tipe MIME tidak didukung.';
$string['generalexceptionmessage'] = 'Pengecualian - {$a}';
$string['gradecantregrade'] = 'Galat selama penghitungan nilai: {$a}';
$string['gradepubdisable'] = 'Penerbitan nilai dinonaktifkan';
$string['gradesneedregrading'] = 'Nilai kursus perlu dihitung ulang';
$string['groupalready'] = 'Pengguna sudah menjadi bagian dari grup {$a}';
$string['groupexistforcourse'] = 'Grup "{$a}" sudah ada di kursus';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Grup "{$a->name}" dengan nomor ID "{$a->idnumber}" sudah ada dalam kursus ini';
$string['grouphasidnumber'] = 'Grup "{$a}" memiliki nomor id dan mungkin telah dibuat secara otomatis oleh sistem eksternal. Anda tidak memiliki izin untuk menghapus grup ini.';
$string['groupinghasidnumber'] = 'Pengelompokan "{$a}" memiliki nomor id dan mungkin telah dibuat secara otomatis oleh sistem eksternal. Anda tidak memiliki izin untuk menghapus pengelompokan ini.';
$string['groupingnotaddederror'] = 'Pengelompokan "{$a}" tidak ditambahkan';
$string['groupnotaddederror'] = 'Grup "{$a}" tidak ditambahkan';
$string['groupnotaddedtogroupingerror'] = 'Grup "{$a->groupname}" tidak ditambahkan ke pengelompokan "{$a->groupingname}"';
$string['groupunknown'] = 'Grup {$a} tidak terkait dengan kursus tertentu';
$string['groupusernotmember'] = 'Pengguna bukan anggota grup ini.';
$string['guestcantaccessprofiles'] = 'Tamu tidak dapat mengakses profil pengguna. Masuk dengan akun pengguna penuh untuk melanjutkan.';
$string['guestnocomment'] = 'Tamu tidak diperbolehkan memberi komentar!';
$string['guestnoeditprofile'] = 'Pengguna tamu tidak dapat mengedit profil mereka';
$string['guestnoeditprofileother'] = 'Profil pengguna tamu tidak dapat diedit';
$string['guestnorate'] = 'Tamu tidak diizinkan untuk menilai entri';
$string['guestsarenotallowed'] = 'Pengguna tamu tidak diperbolehkan melakukan ini';
$string['hackdetected'] = 'Serangan retas terdeteksi!';
$string['hashpoolproblem'] = 'Pangkalan konten berkas salah {$a}.';
$string['headersent'] = 'Tajuk sudah terkirim';
$string['idnumbertaken'] = 'Nomor ID telah digunakan';
$string['idnumbertoolong'] = 'Nomor ID terlalu panjang';
$string['importformatnotimplement'] = 'Maaf, impor format ini belum diterapkan!';
$string['incorrectext'] = 'Berkas memiliki ekstensi yang salah';
$string['inplaceeditableerror'] = 'Galat memanggil prosesor pembaruan';
$string['installproblem'] = 'Biasanya tidak mungkin untuk memulihkan dari kesalahan yang dipicu selama instalasi, Anda mungkin perlu membuat pangkalan data baru atau menggunakan awalan pangkalan data yang berbeda jika Anda ingin mencoba instalasi lagi.';
$string['internalauthpassworderror'] = 'Kata sandi tidak ada atau kebijakan kata sandi tidak valid untuk autentikasi internal';
$string['invalidaccess'] = 'Halaman ini tidak diakses dengan benar';
$string['invalidaccessparameter'] = 'Parameter akses tidak valid';
$string['invalidaction'] = 'Parameter aksi tidak valid';
$string['invalidactivityid'] = 'ID aktivitas tidak valid';
$string['invalidadminsettingname'] = 'Setelan admin tidak valid ({$a})';
$string['invalidargorconf'] = 'Tidak ada argumen valid yang diberikan atau konfigurasi server salah';
$string['invalidarguments'] = 'Tidak ada argumen valid yang diberikan';
$string['invalidblockinstance'] = 'Contoh blokir tidak valid untuk: {$a}';
$string['invalidbulkenrolop'] = 'Operasi pendaftaran massal yang diminta tidak valid.';
$string['invalidcategory'] = 'Kategori salah!';
$string['invalidcategoryid'] = 'ID kategori salah!';
$string['invalidcomment'] = 'Komentar salah';
$string['invalidcommentarea'] = 'Area komentar tidak valid';
$string['invalidcommentid'] = 'ID komentar tidak valid';
$string['invalidcommentitemid'] = 'ID item komentar tidak valid';
$string['invalidcommentparam'] = 'Parameter komentar tidak valid';
$string['invalidcomponent'] = 'Nama komponen tidak valid';
$string['invalidconfirmdata'] = 'Data konfirmasi tidak valid';
$string['invalidcontentid'] = 'ID konten tidak valid';
$string['invalidcontext'] = 'Konteks tidak valid';
$string['invalidcountrycode'] = 'Kode negara tidak valid: {$a}';
$string['invalidcourse'] = 'Kursus tidak valid';
$string['invalidcourseformat'] = 'Format kursus tidak valid';
$string['invalidcourseid'] = 'Anda mencoba menggunakan ID kursus yang tidak valid';
$string['invalidcourselevel'] = 'Tingkat konteks tidak valid';
$string['invalidcoursemodule'] = 'ID modul kursus tidak valid';
$string['invalidcoursemoduleid'] = 'ID modul kursus tidak valid: {$a}';
$string['invalidcoursenameshort'] = 'Nama pendek kursus tidak valid';
$string['invaliddata'] = 'Data yang dikirim tidak valid';
$string['invaliddatarootpermissions'] = 'Izin yang tidak valid terdeteksi saat mencoba membuat direktori. Aktifkan awakutu untuk detail lebih lanjut.';
$string['invaliddevicetype'] = 'Jenis perangkat tidak valid';
$string['invalidelementid'] = 'ID elemen tidak valid!';
$string['invalidentry'] = 'Ini bukan entri yang valid!';
$string['invalidevent'] = 'Acara tidak valid';
$string['invalidfieldname'] = '"{$a}" bukan nama ruas yang valid';
$string['invalidfile'] = 'Berkas tidak ditemukan';
$string['invalidfiletype'] = '"{$a}" bukan jenis file yang valid';
$string['invalidformatpara'] = 'Format salah untuk memilih parameter';
$string['invalidformdata'] = 'Data formulir salah';
$string['invalidfunction'] = 'Fungsi salah';
$string['invalidgradeitemid'] = 'ID item nilai salah';
$string['invalidgroupid'] = 'ID grup yang salah ditentukan';
$string['invalidipformat'] = 'Format alamat IP tidak valid';
$string['invaliditemid'] = 'ID item salah';
$string['invalidkey'] = 'Kunci salah';
$string['invalidlanguagecode'] = 'Kode bahasa tidak valid: {$a}';
$string['invalidlegacy'] = 'Definisi peran warisan yang salah untuk jenis: {$a}';
$string['invalidmd5'] = 'Variabel periksa salah - coba lagi';
$string['invalidmode'] = 'Mode tidak valid ({$a})';
$string['invalidmodule'] = 'Modul tidak valid';
$string['invalidmoduleid'] = 'ID modul tidak valid: {$a}';
$string['invalidmodulename'] = 'Nama modul tidak valid: {$a}';
$string['invalidnum'] = 'Nilai numerik tidak valid';
$string['invalidnumkey'] = 'Larik $conditions tidak boleh berisi kunci numerik. Harap perbaiki kodenya!';
$string['invalidoutcome'] = 'ID Capaian salah';
$string['invalidpagesize'] = 'Ukuran halaman tidak valid';
$string['invalidpasswordpolicy'] = 'Kebijakan kata sandi tidak valid';
$string['invalidpaymentmethod'] = 'Metode pembayaran tidak valid: {$a}';
$string['invalidpersistenterror'] = 'Galat: {$a}';
$string['invalidqueryparam'] = 'GALAT: Jumlah parameter kueri salah. Diharapkan {$a->expected}, dapatkan {$a->actual}.';
$string['invalidratingarea'] = 'Area peringkat tidak valid';
$string['invalidrecord'] = 'Tidak dapat menemukan rekaman data dalam tabel pangkalan data {$a}.';
$string['invalidrecordunknown'] = 'Tidak dapat menemukan rekaman data dalam pangkalan data.';
$string['invalidrequest'] = 'Permintaan tidak valid';
$string['invalidrole'] = 'Peran tidak valid';
$string['invalidroleid'] = 'ID peran tidak valid';
$string['invalidscaleid'] = 'ID skala  tidak valid';
$string['invalidsection'] = 'Catatan modul kursus berisi topik yang tidak valid';
$string['invalidsesskey'] = 'Sesi Anda kemungkinan besar telah habis waktunya. Harap periksa apakah Anda sudah masuk atau kembali ke layar sebelumnya dan muat ulang halaman.';
$string['invalidshortname'] = 'Nama singkat kursus tidak valid';
$string['invalidsourcefield'] = 'Ruas sumber berkas draf tidak valid';
$string['invalidstatedetected'] = 'Ada yang tidak beres: {$a}. Ini seharusnya tidak pernah terjadi.';
$string['invalidurl'] = 'URL tidak valid';
$string['invaliduser'] = 'Pengguna tidak valid';
$string['invaliduserdata'] = 'Data pengguna tidak valid: {$a}';
$string['invaliduserfield'] = 'Ruas pengguna tidak valid: {$a}';
$string['invaliduserid'] = 'ID pengguna tidak valid';
$string['invalidusername'] = 'Nama pengguna yang diberikan mengandung karakter yang tidak valid';
$string['invalidusernameblank'] = 'Nama pengguna tidak boleh kosong';
$string['invalidxmlfile'] = '"{$a}" bukan berkas XML yang valid';
$string['iplookupfailed'] = 'Tidak dapat menemukan informasi geo tentang alamat IP ini {$a}';
$string['iplookupprivate'] = 'Tidak dapat menampilkan pencarian alamat IP privat';
$string['ipmismatch'] = 'Alamat IP klien tidak cocok';
$string['itemnotfound'] = 'Tidak ada {$a->itemtype} yang ditemukan dengan pengidentifikasi \'{$a->identifier}\'';
$string['listcantmovedown'] = 'Gagal memindahkan item ke bawah, karena ini adalah item terakhir dari yang lainnya';
$string['listcantmoveleft'] = 'Gagal memindahkan item ke kiri, karena tidak memiliki induk';
$string['listcantmoveright'] = 'Gagal memindahkan item ke kanan, karena tidak ada rekan untuk menjadikannya anak. Pindahkan ke bawah rekan lainnya dan kemudian Anda dapat memindahkannya ke kanan.';
$string['listcantmoveup'] = 'Gagal memindahkan item ke atas, karena ini adalah yang pertama.';
$string['listnochildren'] = 'Tidak ada anak dari item yang ditemukan';
$string['listnoitem'] = 'Item tidak ditemukan';
$string['listnopeers'] = 'Tidak ada item sejenis yang ditemukan';
$string['listupdatefail'] = 'Operasi DB gagal saat mengedit hierarki daftar';
$string['logfilenotavailable'] = 'Log tidak tersedia';
$string['loginasnoenrol'] = 'Anda tidak dapat menggunakan daftar atau batalkan pendaftaran saat dalam kursus sesi "Masuk sebagai"';
$string['loginasonecourse'] = 'Anda tidak dapat mengikuti kursus ini. <br /> Anda harus mengakhiri sesi "Masuk sebagai" sebelum memasuki kursus lain.';
$string['maxareabytes'] = 'Berkas lebih besar dari ruang yang tersisa di area ini.';
$string['maxbytesfile'] = 'File {$a->file} terlalu besar. Ukuran maksimum yang dapat Anda unggah adalah {$a->size}.';
$string['maxdraftitemids'] = 'Unggahan berkas Anda untuk sementara dibatasi setelah Anda mengunggah berkas dalam jumlah besar. Harap tunggu lalu coba lagi.';
$string['messageundeliveredbynotificationsettings'] = 'Pesan tidak dapat dikirim karena pesan pribadi antar pengguna (di setelan pemberitahuan) telah dinonaktifkan oleh administrator situs.';
$string['messagingdisable'] = 'Pesan dinonaktifkan di situs ini';
$string['mimetexisnotexist'] = 'Sistem Anda tidak dikonfigurasi untuk menjalankan mimeTeX. Anda perlu mendapatkan sumber C dari <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a>, kompilasi dan masukkan file yang dapat dieksekusi ke moodle/filter/tex/ directory.';
$string['mimetexnotexecutable'] = 'Mimetex kustom tidak dapat dieksekusi!';
$string['missing_moodle_backup_xml_file'] = 'Cadangan tidak memiliki berkas XML: {$a}';
$string['missingcategoryrole'] = 'Tidak bisa menugaskan peran kepada pengguna: kategori peran tidak ada';
$string['missingfield'] = 'Ruas "{$a}" tidak ada';
$string['missingkeyinsql'] = 'GALAT: parameter "{$a}" tidak ada dalam kueri';
$string['missingparam'] = 'Parameter yang dibutuhkan ({$a}) tidak ada';
$string['missingparameter'] = 'Parameter hilang';
$string['missingrequiredfield'] = 'Beberapa ruas wajib tidak ada';
$string['missinguseranditemid'] = 'userid dan itemid tidak ada';
$string['missingvarname'] = 'Nama variabel yang diperlukan tidak ada!';
$string['mixedtypesqlparam'] = 'GALAT: Campuran jenis parameter kueri sql !!';
$string['mnetdisable'] = 'MNET nonaktif';
$string['mnetlocal'] = 'Pengguna MNET jarak jauh tidak dapat masuk secara lokal';
$string['moduledisable'] = 'Modul ({$a}) ini telah dinonaktifkan untuk kursus khusus ini';
$string['moduledoesnotexist'] = 'Modul ini tidak ada';
$string['moduleinstancedoesnotexist'] = 'Model dari modul ini tidak ada';
$string['modulemissingcode'] = 'Modul {$a} tidak memiliki kode yang diperlukan untuk menjalankan fungsi ini';
$string['moodlenet:invalidshareformat'] = 'Format berbagi MoodleNet salah';
$string['moodlenet:invalidsharestatus'] = 'Status berbagi MoodleNet salah';
$string['moodlenet:invalidsharetype'] = 'Jenis berbagi MoodleNet tidak valid';
$string['moodlenet:usernotconfigured'] = 'Anda tidak memiliki izin untuk membagikan konten ke MoodleNet, atau akun Anda salah dikonfigurasi.';
$string['movecatcontentstoroot'] = 'Memindahkan konten kategori pada <em>root</em> tidak diizinkan. Anda harus memindahkan konten ke dalam direktori yang sudah ada!';
$string['movecatcontentstoselected'] = 'Beberapa konten kategori tidak dapat dipindahkan ke kategori yang dipilih.';
$string['movecategorynotpossible'] = 'Anda tidak dapat memindahkan kategori \'{$a}\' ke dalam kategori yang dipilih.';
$string['movecategoryownparent'] = 'Anda tidak dapat menjadikan kategori \'{$a}\' sebagai induknya sendiri.';
$string['movecategoryparentconflict'] = 'Anda tidak dapat membuat kategori \'{$a}\' sebagai subkategori dari salah satu subkategorinya sendiri.';
$string['mssqlrcsmodemissing'] = 'Basis data tidak menggunakan mode READ_COMMITTED_SNAPSHOT yang diharapkan yang dapat menyebabkan hasil yang salah, terutama dalam skenario konkurensi tinggi. Harap aktifkan untuk perilaku yang benar. Untuk informasi lebih lanjut, lihat dokumentasi <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Instalasi MSSQL untuk PHP</a>.';
$string['multiplerecordsfound'] = 'Beberapa rekaman ditemukan, hanya satu rekaman yang diharapkan.';
$string['multiplerestorenotallow'] = 'Eksekusi pemulihan dalam jumlah banyak tidak diizinkan!';
$string['mustbeloggedin'] = 'Anda harus masuk untuk melakukan ini';
$string['mustbeteacher'] = 'Anda harus menjadi pengajar untuk melihat halaman ini';
$string['myisamproblem'] = 'Tabel pangkalan data menggunakan mesin pangkalan data MyISAM, disarankan untuk menggunakan mesin yang sesuai dengan ACID dengan dukungan transaksi penuh seperti InnoDB.';
$string['needcopy'] = 'Anda perlu menyalin sesuatu terlebih dahulu!';
$string['needcoursecategroyid'] = 'Salah satu dari id atau kategori kursus harus ditentukan';
$string['needphpext'] = 'Anda perlu menambahkan dukungan {$a} ke instalasi PHP Anda';
$string['noadmins'] = 'Tidak ada administrator!';
$string['noblocks'] = 'Blok tidak ditemukan!';
$string['nocapabilitytousethisservice'] = 'Pengguna tidak memiliki kemampuan yang diperlukan untuk menggunakan layanan ini';
$string['nocategorydelete'] = 'Kategori \'{$a}\' tidak dapat dihapus!';
$string['nocontext'] = 'Maaf, tapi kursus itu bukan konteks yang valid';
$string['nodata'] = 'Tidak ada data';
$string['noexistingcategory'] = 'Tidak ada kategori';
$string['nofile'] = 'Berkas tidak ditentukan';
$string['nofiltersenabled'] = 'Tidak ada filter diaktifkan';
$string['nofolder'] = 'Direktori yang diminta tidak ada';
$string['noformdesc'] = 'Tidak ada berkas deskripsi formulir formslib yang ditemukan untuk aktivitas ini.';
$string['noguest'] = 'Tidak ada tamu di sini!';
$string['noinstances'] = 'Tidak ada model {$a} dalam kursus ini!';
$string['nologinas'] = 'Anda tidak diizinkan masuk sebagai pengguna tersebut';
$string['nonmeaningfulcontent'] = 'Konten yang tidak berarti';
$string['noparticipants'] = 'Belum ada peserta pada kursus ini';
$string['noparticipatorycms'] = 'Maaf, Anda tidak memiliki modul kursus partisipatif untuk dilaporkan';
$string['nopermissions'] = 'Maaf, tetapi saat ini Anda tidak memiliki izin untuk melakukan ({$a}).';
$string['nopermissiontoaccesspage'] = 'Anda tidak memiliki izin untuk mengakses halaman ini.';
$string['nopermissiontocomment'] = 'Anda tidak dapat menambahkan komentar';
$string['nopermissiontodelentry'] = 'Anda tidak dapat menghapus komentar ini!';
$string['nopermissiontoeditcomment'] = 'Anda tidak dapat mengedit komentar orang lain!';
$string['nopermissiontohide'] = 'Tidak diizinkan untuk menyembunyikan!';
$string['nopermissiontoimportact'] = 'Anda tidak memiliki kewenangan yang diperlukan untuk mengimpor aktivitas ke kursus ini';
$string['nopermissiontolock'] = 'Tidak ada izin untuk mengunci!';
$string['nopermissiontomanagegroup'] = 'Anda tidak memiliki izin yang diperlukan untuk mengelola grup';
$string['nopermissiontorate'] = 'Peringkat item tidak diperbolehkan!';
$string['nopermissiontoshow'] = 'Tidak ada izin untuk melihat ini!';
$string['nopermissiontounlock'] = 'Tidak ada izin untuk membuka kunci!';
$string['nopermissiontoupdatecalendar'] = 'Maaf, tetapi Anda tidak memiliki izin untuk memperbarui acara kalender.';
$string['nopermissiontoviewcalendar'] = 'Maaf, tetapi Anda tidak memiliki izin untuk melihat acara kalender.';
$string['nopermissiontoviewgrades'] = 'Tidak dapat melihat nilai.';
$string['nopermissiontoviewletergrade'] = 'Izin tidak ada untuk melihat nilai huruf';
$string['nopermissiontoviewpage'] = 'Anda tidak diizinkan untuk melihat halaman ini';
$string['nosite'] = 'Tidak dapat menemukan kursus tingkat atas!';
$string['nositeid'] = 'Tidak ada ID situs';
$string['nostartdatenoenddate'] = 'Tanggal berakhir kursus hanya dapat diatur jika tanggal mulai juga diatur.';
$string['nostatstodisplay'] = 'Maaf, tidak ada data yang tersedia untuk ditampilkan';
$string['notallowedtoupdateprefremotely'] = 'Anda tidak diperbolehkan memperbarui preferensi pengguna ini dari jarak jauh';
$string['notavailable'] = 'Itu saat ini tidak tersedia';
$string['notfound'] = 'Tidak ditemukan';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Anda bukan anggota grup kursus ini.';
$string['notownerofkey'] = 'Anda bukan pemilik kunci ini';
$string['nousers'] = 'Tidak ada pengguna!';
$string['oauth1accesstoken'] = 'Galat OAuth 1.0: Kami tidak mendapatkan token akses.';
$string['oauth1requesttoken'] = 'Galat OAuth 1.0: Kami tidak mendapatkan token permintaan - penyedia layanan mungkin sedang tidak aktif untuk sementara.';
$string['oauth2refreshtokenerror'] = 'Tidak dapat menyegarkan token OAuth 2. Status HTTP untuk titik akhir jarak jauh: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Tidak dapat menyegarkan token OAuth 2 untuk satu atau beberapa penerbit. Lihat keluaran tugas untuk mengetahui detailnya.';
$string['oauth2upgradetokenerror'] = 'Tidak dapat meningkatkan token OAuth 2. Status HTTP untuk titik akhir jarak jauh: {$a}';
$string['onlyadmins'] = 'Hanya administrator yang dapat melakukannya';
$string['onlyeditingteachers'] = 'Hanya pengajar yang mengedit yang dapat melakukannya';
$string['onlyeditown'] = 'Anda hanya dapat mengedit informasi Anda sendiri';
$string['opensslsealerror'] = 'OpenSSL tidak dapat menyegel data';
$string['opensslsignerror'] = 'OpenSSL tidak dapat menandatangani data';
$string['orderidnotfound'] = 'ID pesanan {$a} tidak ditemukan';
$string['pagenotexist'] = '<p> Galat yang tidak biasa saat mencoba melihat halaman yang tidak ada: </p> {$a}';
$string['pagenotexisttitle'] = 'GALAT 404: Berkas tidak ditemukan';
$string['passwordexceeded'] = 'Kata sandi tidak boleh lebih dari {$a} karakter.';
$string['pathdoesnotstartslash'] = 'Tidak ada argumen valid yang diberikan, jalur tidak dimulai dengan garis miring!';
$string['pleasereport'] = 'Jika Anda punya waktu, beri tahu kami apa yang Anda coba lakukan saat kesalahan terjadi:';
$string['pluginnotexist'] = 'Pengaya {$a} tidak ada';
$string['pluginrequirementsnotmet'] = 'Pengaya "{$a->pluginname}" ({$a->pluginversion}) tidak dapat dipasang. Ini membutuhkan versi Moodle yang lebih baru (saat ini Anda menggunakan {$a->currentmoodle}, Anda memerlukan {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Pengaya "{$a->pluginname}" {$a->pluginversion} tidak mendukung versi Moodle ini {$a->moodleversion}. Cari informasi pengaya untuk menemukan versi yang didukung.';
$string['prefixcannotbeempty'] = '<p> GALAT: prefiks tabel basis data tidak boleh kosong ({$a}) </p> <p> Administrator situs harus memperbaiki masalah ini. </p>';
$string['prefixtoolong'] = '<p> GALAT: prefiks tabel basis data terlalu panjang ({$a->dbfamily}) </p> <p> Administrator situs harus memperbaiki masalah ini. Panjang maksimum untuk prefiks tabel pada {$a->dbfamily} adalah {$a->maxlength} karakter. </p>';
$string['privatefilesupload'] = 'Mengunggah langsung ke area berkas pribadi pengguna tidak lagi didukung. Unggah ke area draf dan kemudian pindahkan berkas dengan
core_user::add_user_private_files';
$string['processingstops'] = 'Pemrosesan berhenti di sini. Rekaman yang tersisa diabaikan.';
$string['protected_cc_not_supported'] = 'Kartrid berpelindung tidak didukung.';
$string['querystringcannotbeempty'] = 'String kueri tidak boleh kosong.';
$string['redirecterrordetected'] = 'Pengalihan yang tidak didukung terdeteksi, eksekusi skrip dihentikan';
$string['redissessionhandlerproblem'] = 'Penyiapan sesi redis gagal. Harap beri tahu administrator server.';
$string['refoundto'] = 'Dapat dikembalikan ke {$a}';
$string['refoundtoorigi'] = 'Dikembalikan ke jumlah awal: {$a}';
$string['registrationdisabled'] = 'Pendaftaran dinonaktifkan di situs ini';
$string['remotedownloaderror'] = '<p> Pengunduhan komponen ke server Anda gagal. Harap verifikasi setelan proksi; ekstensi PHP cURL sangat direkomendasikan. </p> <p> Anda harus mengunduh berkas <a href="{$a->url} ">{$a->url} </a> secara manual, menyalinnya ke"{$a->dest} "di server Anda dan uraikan di sana. </p>';
$string['remotedownloadnotallowed'] = 'Pengunduhan komponen ke server Anda tidak diperbolehkan (allow_url_fopen dinonaktifkan). <br /> <br /> Anda harus mengunduh <a href="{$a->url} "> {$a->url} < / a> file secara manual, salin ke "{$a->dest}" di server Anda dan uraikan di sana.';
$string['reportnotavailable'] = 'Jenis laporan ini hanya tersedia untuk situs kursus';
$string['requirecorrectaccess'] = 'URL atau porta tidak valid.';
$string['requireloginerror'] = 'kursus atau aktivitas tidak dapat diakses.';
$string['restore_path_element_missingmethod'] = 'Metode pemulihan {$a} hilang. Ini harus ditentukan oleh pengembang.';
$string['restore_path_element_noobject'] = 'Pulihkan objek {$a} bukan objek.';
$string['restorechecksumfailed'] = 'Beberapa masalah terjadi dengan informasi pemulihan yang disimpan dalam sesi Anda. Harap periksa batas ukuran paket memori / DB Anda. Pemulihan dihentikan.';
$string['restrictedcontextexception'] = 'Maaf, pelaksanaan fungsi eksternal melanggar batasan konteks.';
$string['restricteduser'] = 'Maaf, tapi akun Anda saat ini "{$a}" dilarang melakukannya';
$string['reverseproxyabused'] = 'Proksi terbalik diaktifkan, server tidak dapat diakses secara langsung, maaf. <br /> Harap hubungi administrator server.';
$string['rpcerror'] = 'Ups! Komunikasi MNET Anda gagal! Berikut pesan kesalahan untuk diteruskan ke administrator Anda: {$a}';
$string['scheduledbackupsdisabled'] = 'Pencadangan terjadwal telah dinonaktifkan oleh admin server';
$string['secretalreadyused'] = 'Tautan konfirmasi perubahan kata sandi sudah digunakan, kata sandi tidak diubah';
$string['sectioncantbefound'] = '<p><strong>Konten ini tidak dapat ditemukan</strong></p><p>Mungkin telah dihapus, atau URL-nya mungkin salah.</p>';
$string['sectionnotexist'] = 'Bagian ini tidak ada';
$string['sendmessage'] = 'Kirim pesan';
$string['sendmessagesent'] = 'Terima kasih atas umpan balik Anda tentang: <br> {$a}';
$string['serverconnection'] = 'Gagal tersambung ke server';
$string['servicedonotexist'] = 'Layanan tidak ada';
$string['sessioncannotobtainlock'] = '<p>Tidak dapat memperoleh kunci untuk id sesi {$a->id} dalam {$a->acquiretimeout}.</p> <p>Kemungkinan halaman lain ({$a->whohaslock}) masih berjalan di tab peramban lain, atau tidak membuka kunci karena kesalahan.</p> <p>Anda dapat menunggu hingga batas waktu penguncian sesi ({$a->lockexpire}) atau Anda dapat memulai kembali sesi peramban Anda. Jika kesalahan ini berlanjut, harap beri tahu administrator server.</p>';
$string['sessioncookiesdisable'] = 'Penggunaan yang salah dari require_key_login() - kuki sesi harus dinonaktifkan!';
$string['sessiondiskfull'] = 'Partisi sesi penuh. Tidak mungkin untuk masuk saat ini. Harap beri tahu administrator server.';
$string['sessionerroruser'] = 'Sesi Anda telah habis. Silakan masuk lagi.';
$string['sessionerroruser2'] = 'Kesalahan server yang mempengaruhi sesi masuk Anda terdeteksi. Silakan masuk lagi atau mulai ulang peramban Anda.';
$string['sessionexpired'] = 'Sesi berakhir';
$string['sessionhandlerproblem'] = 'Penangan sesi salah dikonfigurasi';
$string['sessionipnomatch'] = 'Maaf, tetapi nomor IP Anda sepertinya telah berubah dari saat Anda pertama kali masuk. Fitur keamanan ini mencegah peretas jahat mencuri identitas Anda saat masuk ke situs ini. Pengguna biasa seharusnya tidak melihat pesan ini - silakan minta bantuan administrator situs.';
$string['sessionipnomatch2'] = '<p> Maaf, tetapi nomor IP Anda tampaknya telah berubah dari saat Anda pertama kali masuk. Fitur keamanan ini mencegah peretas jahat mencuri identitas Anda saat masuk ke situs ini. Anda mungkin melihat kesalahan ini jika Anda menggunakan jaringan nirkabel atau jika Anda roaming di antara jaringan yang berbeda. Silakan tanyakan kepada administrator situs untuk bantuan lebih lanjut. </p> <p> Jika Anda ingin melanjutkan, tekan tombol F5 untuk menyegarkan halaman ini. </p>';
$string['sessionstarterror'] = 'Sesi tidak dapat dimulai. Silakan coba lagi nanti.';
$string['sessionwaiterr'] = 'Waktu habis saat menunggu kunci sesi. <br /> Tunggu permintaan Anda saat ini selesai dan coba lagi nanti.';
$string['shortnametaken'] = 'Nama singkat sudah digunakan untuk kursus lain ({$a})';
$string['sitepolicynotagreed'] = 'Kebijakan situs tidak disetujui: <a href="{$a}"> Klik di sini untuk membuka kebijakan situs. </a>';
$string['socksnotsupported'] = 'Proksi SOCKS5 tidak didukung di PHP4';
$string['spellcheckernotconf'] = 'Pemeriksa ejaan tidak dikonfigurasi';
$string['sslonlyaccess'] = 'Untuk alasan keamanan, hanya koneksi https yang diperbolehkan, maaf.';
$string['statscatchupmode'] = 'Statistik saat ini dalam mode mengejar ketinggalan. Sejauh ini {$a->daysdone} hari telah diproses dan {$a->dayspending} sedang menunggu keputusan. Periksa kembali nanti!';
$string['statsdisable'] = 'Statistik belum diaktifkan.';
$string['statsnodata'] = 'Tidak ada data yang tersedia untuk kombinasi kursus dan periode waktu tersebut';
$string['storedfilecannotcreatefile'] = 'Tidak dapat membuat berkas kumpulan berkas lokal, harap verifikasi izin di dataroot dan ruang diska yang tersedia.';
$string['storedfilecannotcreatefiledirs'] = 'Tidak dapat membuat direktori kumpulan berkas lokal, harap verifikasi izin di dataroot.';
$string['storedfilecannotread'] = 'Tidak dapat membaca berkas. Mungkin berkas tidak ada atau ada masalah izin.';
$string['storedfilecannotreadfile'] = 'Tidak dapat membaca berkas \'{$a}\'. Mungkin berkas tidak ada atau ada masalah izin.';
$string['storedfilenotcreated'] = 'Tidak dapat membuat berkas "{$a->contextid} / {$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}"';
$string['storedfileproblem'] = 'Pengecualian tidak diketahui terkait dengan berkas lokal ({$a})';
$string['tagdisabled'] = 'Tag dinonaktifkan!';
$string['tagnotfound'] = 'Tag yang ditentukan tidak ditemukan dalam basis data';
$string['targetdatabasenotempty'] = 'Basis data target tidak kosong. Transfer dibatalkan untuk alasan keamanan.';
$string['textconditionsnotallowed'] = 'Perbandingan kondisi kolom teks tidak diperbolehkan. Harap gunakan sql_compare_text() dalam kueri Anda.';
$string['themenotinstall'] = 'Tema ini belum dipasang!';
$string['tokengenerationfailed'] = 'Tidak dapat membuat token baru.';
$string['transactionvoid'] = 'Transaksi tidak dapat dibatalkan karena telah dibatalkan';
$string['unenrolerror'] = 'Galat saat mencoba membatalkan pendaftaran orang itu';
$string['unicodeupgradeerror'] = 'Maaf, basis data Anda belum ada di Unicode, dan versi Moodle ini tidak dapat memindahkan basis data Anda ke Unicode. Harap tingkatkan ke Moodle 1.7.x terlebih dahulu dan lakukan migrasi Unicode dari halaman Admin. Setelah itu selesai, Anda seharusnya bisa bermigrasi ke Moodle {$a}';
$string['unknowaction'] = 'Tindakan tidak diketahui!';
$string['unknowcategory'] = 'Kategori tidak diketahui!';
$string['unknowcontext'] = 'Ini adalah konteks yang tidak diketahui ({$a}) di get_child_contexts!';
$string['unknowformat'] = 'Format tidak diketahui ({$a})';
$string['unknownbackupexporterror'] = 'Galat yang tidak diketahui saat menyiapkan informasi untuk diimpor';
$string['unknownblockregion'] = 'Wilayah blok \'{$a}\' tidak dikenali di halaman ini.';
$string['unknowncategory'] = 'Kategori tidak dikenal dengan nomor kategori ID "{$a}"';
$string['unknowncontext'] = 'Ini adalah konteks yang tidak diketahui.';
$string['unknowncourse'] = 'Nama kursus "{$a}" tidak diketahui';
$string['unknowncourseidnumber'] = 'ID kursus "{$a}" tidak diketahui';
$string['unknowncourserequest'] = 'Permintaan kursus tidak diketahui';
$string['unknowncoursesection'] = 'Topik kursus tidak diketahui pada kursus "{$a}"';
$string['unknownevent'] = 'Acara tidak diketahui';
$string['unknownfiletype'] = 'Kesalahan jenis filter tidak diketahui';
$string['unknowngroup'] = 'Grup tidak dikenal "{$a}"';
$string['unknownhelp'] = 'Topik bantuan tidak dikenal {$a}';
$string['unknownjsinrequirejs'] = 'Tidak dapat menemukan pustaka JS: {$a}';
$string['unknownmodulename'] = 'Nama modul tidak diketahui untuk formulir';
$string['unknownrole'] = 'Peran tidak diketahui "{$a}"';
$string['unknownsortcolumn'] = 'Kolom urutan tidak diketahui {$a}';
$string['unknownuseraction'] = 'Maaf, saya tidak mengerti tindakan pengguna ini';
$string['unknownuserselector'] = 'Pemilih pengguna tidak dikenal';
$string['unknoworder'] = 'Urutan tidak diketahui';
$string['unknowparamtype'] = 'Jenis parameter tidak diketahui: {$a}';
$string['unknowquestiontype'] = 'Jenis pertanyaan tidak didukung {$a}';
$string['unknowuploadaction'] = 'Galat: Aksi unggah tidak diketahui ({$a})';
$string['unspecifycourseid'] = 'Harus menentukan ID kursus, nama singkat atau nomor ID';
$string['unsupportedevent'] = 'Jenis acara tidak didukung';
$string['unsupportedstate'] = 'Status penyelesaian tidak didukung';
$string['unsupportedwebserver'] = 'Perangkat lunak server web ({$a}) tidak didukung, maaf.';
$string['upgraderequires19'] = 'Galat: Versi Moodle baru dipasang di server, sayangnya peningkatan versi dari versi sebelumnya tidak didukung. <br /> Harap tingkatkan dulu ke rilis 1.9.x terbaru. Anda juga dapat kembali ke versi sebelumnya dengan memasang ulang berkas asli.';
$string['upgraderunning'] = 'Situs sedang ditingkatkan, coba lagi nanti.';
$string['urlnotdefinerss'] = 'URL tidak ditentukan untuk umpan RSS';
$string['useradmineditadmin'] = 'Hanya administrator yang diizinkan untuk mengubah akun administrator lain';
$string['useradminodelete'] = 'Akun administrator tidak dapat dihapus';
$string['userautherror'] = 'Pengaya autentikasi tidak dikenal';
$string['userauthunsupported'] = 'Pengaya Auth tidak didukung di sini';
$string['useremailduplicate'] = 'Alamat duplikat';
$string['userisfilteredout'] = 'Pengguna ini tidak cocok dengan filter dan preferensi tabel!';
$string['usermustbemnet'] = 'Pengguna dalam daftar kontrol akses MNET harus pengguna MNET jarak jauh';
$string['usernamelowercase'] = 'Nama pengguna harus dalam huruf kecil';
$string['usernotaddederror'] = 'Pengguna tidak ditambahkan - galat';
$string['usernotaddedregistered'] = 'Pengguna tidak ditambahkan - sudah terdaftar';
$string['usernotaddedusernameexists'] = 'Pengguna tidak ditambahkan - nama pengguna sudah ada di surel yang berbeda';
$string['usernotavailable'] = 'Detail pengguna ini tidak tersedia untuk Anda';
$string['usernotdeletedadmin'] = 'Pengguna tidak dihapus - tidak dapat menghapus akun administrator';
$string['usernotdeleteddeleted'] = 'Pengguna ini telah dihapus.';
$string['usernotdeletederror'] = 'Pengguna tidak dihapus - kesalahan';
$string['usernotdeletedmissing'] = 'Pengguna tidak dihapus - tidak dapat menemukan nama pengguna';
$string['usernotdeletedoff'] = 'Pengguna tidak dihapus - menghapus tidak diperbolehkan';
$string['usernotfullysetup'] = 'Pengguna tidak sepenuhnya disiapkan';
$string['usernotincourse'] = 'Pengguna ini tidak ada dalam kursus ini!';
$string['usernotrenamedadmin'] = 'Tidak dapat mengganti nama akun admin';
$string['usernotrenamedexists'] = 'Nama pengguna tidak diganti - nama pengguna baru sudah digunakan';
$string['usernotrenamedmissing'] = 'Nama pengguna tidak diganti - tidak dapat menemukan nama pengguna lama';
$string['usernotrenamedoff'] = 'Pengguna tidak diganti namanya - tidak diperbolehkan mengganti nama';
$string['usernotupdatedadmin'] = 'Tidak dapat memperbarui akun admin';
$string['usernotupdatederror'] = 'Pengguna tidak diperbarui - galat';
$string['usernotupdatednotexists'] = 'Pengguna tidak diperbarui - tidak ada';
$string['userquotalimit'] = 'Anda telah mencapai batas kuota berkas Anda.';
$string['userselectortoomany'] = 'user_selector mendapatkan lebih dari satu pengguna yang dipilih, meskipun multiselect salah.';
$string['verifyagedigitalconsentnotpossible'] = 'Maaf, verifikasi persetujuan usia digital tidak dapat dilakukan saat ini.';
$string['wrongcall'] = 'Skrip yang dipanggil salah';
$string['wrongcontextid'] = 'ID konteks salah (tidak dapat menemukannya)';
$string['wrongdestpath'] = 'Jalur tujuan salah';
$string['wrongroleid'] = 'ID peran salah!';
$string['wrongsourcebase'] = 'Basis URL sumber salah';
$string['wrongusernamepassword'] = 'Pengguna/kata sandi salah';
$string['wrongzipfilename'] = 'Nama file ZIP salah';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Tidak dapat membuat kursus - Tidak ada izin';
$string['wwwrootmismatch'] = 'Akses salah terdeteksi, server ini hanya dapat diakses melalui alamat "{$a}", maaf. <br /> Harap beri tahu administrator server.';
$string['wwwrootslash'] = 'Terdeteksi salah $CFG->wwwroot di config.php, tidak boleh mengandung garis miring. <br /> Harap beri tahu administrator server.';
$string['xmldberror'] = 'Galat XMLDB!';
$string['youcannotdeletecategory'] = 'Anda tidak dapat menghapus kategori \'{$a}\' karena Anda tidak dapat menghapus konten atau memindahkannya ke tempat lain.';
