<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'ro', version '4.5'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Atașamentele activității sarcină de lucru';
$string['activitydate:submissionsdue'] = 'Dată limită:';
$string['activitydate:submissionsopen'] = 'Se deschide:';
$string['activitydate:submissionsopened'] = 'Deschis:';
$string['activityeditor'] = 'Instrucțiuni activitate';
$string['activityeditor_help'] = 'Acțiunile pe care ai dori ca studentul să le finalizeze pentru această sarcină de lucru. Se afișează doar pe pagina răspunsului în care un student își editează și trimite răspunsul.';
$string['activityoverview'] = 'Aveți sarcini de lucru de revăzut';
$string['addattempt'] = 'Permite altă încercare';
$string['addnewattempt'] = 'Adaugă o nouă încercare';
$string['addnewattempt_help'] = 'Aceasta va crea o nouă trimitere necompletată la care să lucrați.';
$string['addnewattemptfromprevious'] = 'Adăugați o nouă încercare pe baza trimiterii anterioare';
$string['addnewattemptfromprevious_help'] = 'Aceasta va copia conținutul răspunsului anterior într-un răspuns nou pentru a formular răspunsul în continuare.';
$string['addnewgroupoverride'] = 'Adăugați suprascrierea grupului';
$string['addnewuseroverride'] = 'Adăugare suprascriere reguli pentru utilizator';
$string['addsubmission'] = 'Adaugă un răspuns acestei sarcini de lucru';
$string['addsubmission_help'] = 'Nu ați trimis încă niciun răspuns';
$string['allocatedmarker'] = 'Persoană pentru notare alocat';
$string['allocatedmarker_help'] = 'Persoană pentru notare alocat acestui răspuns';
$string['allowsubmissions'] = 'Permiteți utilizatorului să continue să trimită răspunsuri la această sarcină.';
$string['allowsubmissionsfromdate'] = 'Acceptați răspunsuri de la data de:';
$string['allowsubmissionsfromdate_help'] = 'Dacă este activată, cursanții nu vor putea răspunde înainte de această dată. Dacă este dezactivat, cursanții vor putea începe să răspundă imediat.';
$string['allowsubmissionsshort'] = 'Premiteți schimbarea lucrărilor';
$string['alwaysshowdescription'] = 'Întotdeauna afișează descrierea';
$string['alwaysshowdescription_help'] = 'Dacă este dezactivată, descrierea sarcinii de mai sus va deveni vizibilă doar pentru cursanți la data „Permiteți răspunsuri de la”.';
$string['applytoteam'] = 'Aplică notele și feedback-ul întregului grup';
$string['assign:addinstance'] = 'Adaugă o nouă sarcină de lucru';
$string['assign:editothersubmission'] = 'Editează răspunsul altui cursant';
$string['assign:exportownsubmission'] = 'Exportul propriei teme trimise';
$string['assign:grade'] = 'Notare temă';
$string['assign:grantextension'] = 'Permiteți prelungirea';
$string['assign:manageallocations'] = 'Gestionați persoanele pentru notare alocați răspunsurilor';
$string['assign:managegrades'] = 'Revizuiește și afișează notele';
$string['assign:manageoverrides'] = 'Gestionați suprascrierea sarcinii';
$string['assign:receivegradernotifications'] = 'Primiți notificări cu privire la notare';
$string['assign:releasegrades'] = 'Afișează notele';
$string['assign:revealidentities'] = 'Afișează identitatea studentului';
$string['assign:reviewgrades'] = 'Revizuire note';
$string['assign:showhiddengrader'] = 'Vedeți identitatea unei persoane care face notarea și are status ascuns';
$string['assign:submit'] = 'Trimitere răspuns';
$string['assign:view'] = 'Vizualizare sarcină de lucru';
$string['assign:viewblinddetails'] = 'Vizualizați identitățile cursanților când este activată Trimitere răspuns anonim';
$string['assign:viewgrades'] = 'Afişează note';
$string['assign:viewownsubmissionsummary'] = 'Vizualizare rezumat sarcină de lucru proprie';
$string['assignfeedback'] = 'Plugin feedback';
$string['assignfeedbackpluginname'] = 'Plugin feedback';
$string['assignmentduedigesthtml'] = '<p>Bună ziua, {$a->firstname},</p>
<p>Răspunsul la următoarele sarcini de lucru trebuie predate <strong>{$a->duedate}</strong>.</p>
{$a->digest}';
$string['assignmentduedigestitem'] = '<strong>{$a->assignmentname}</strong> în curs {$a->coursename}<br/>
<strong>Due: {$a->duetime}</strong><br/>
<a href="{$a->url}" aria-label="Mergi la {$a->assignmentname}">Mergi la activitate</a>';
$string['assignmentduedigestsubject'] = 'Aveți sarcini de lucru care trebuie predate în 7 zile.';
$string['assignmentduesoonhtml'] = '<p>Bună ziua {$a->firstname},</p>
<p>Pentru sarcina de lucru <strong>{$a->assignmentname}</strong> din cursul {$a->coursename} trebuie trimis răspunsul în curând</p>
<p><strong>Trimitere răspuns: {$a->duedate}</strong></p>
<p><a href="{$a->url}">Mergi la activitate</a></p>';
$string['assignmentduesoonsubject'] = 'Se trimte în {$a->duedate}: {$a->assignmentname}';
$string['assignmentisdue'] = 'Data predării';
$string['assignmentmail'] = '{$a->grader} a postat câteva feedback-uri despre răspunsului dvs. pentru „{$a->assignment}”

Îl puteți vedea atașat la  răspunsul trimis sarcinii:

     {$a->url}';
$string['assignmentmailhtml'] = '<p> {$a->grader} a postat feedback despre răspunsul dvs. pentru „<i> {$a->assignment} </i>”. </p>
<p> Puteți vedea că este atașat la <a href="{$a->url} "> răspunsul dvs. al sarcinii </a>. </p>';
$string['assignmentmailsmall'] = '{$a->grader} a postat feedback despre răspunsul dvs. pentru „{$a->assignment}” Puteți să-l vedeți anexat la răspunsul dvs.';
$string['assignmentname'] = 'Denumirea sarcinii de lucru';
$string['assignmentoverduehtml'] = '<p>Bună ziua {$a->firstname},</p>
<p><strong>{$a->assignmentname}</strong> în cursul {$a->coursename} trebuia să trimiteți răspunsul în<strong>{$a->duedate}</strong>.</p>
<p>Puteți să trimiteți încă răspunsul{$a->cutoffsnippet}, dar va fi marcat ca întârziat.</p>
<p><a href="{$a->url}">Mergi la activitate</a></p>';
$string['assignmentoverduehtmlcutoffsnippet'] = '<strong>by {$a->cutoffdate}</strong>';
$string['assignmentoverduesubject'] = 'Depășit: {$a->assignmentname}';
$string['assignmentplugins'] = 'Plugin-uri ale sarcinii de lucru';
$string['assignmentsperpage'] = 'Sarcini de lucru per pagină';
$string['assignsubmission'] = 'Plugin temă';
$string['assignsubmissionpluginname'] = 'Plugin temă';
$string['assigntimeleft'] = 'Timp rămas';
$string['attemptheading'] = 'Încercarea {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Încercări anterioare';
$string['attemptnumber'] = 'Numărul încercării';
$string['attemptreopenmethod'] = 'Permite încercări';
$string['attemptreopenmethod_automatic'] = 'Automat';
$string['attemptreopenmethod_automatic_help'] = 'După fiecare încercare, următoarea este permisă automat.';
$string['attemptreopenmethod_help'] = 'Această setare controlează modul în care cursanților li se acordă încercări pentru această sarcină de lucru. Pentru fiecare încercare, nota și feedback-ul sunt salvate și pot fi vizualizate de profesor și cursant. Opțiunile disponibile sunt:

* Manual - După fiecare încercare, poți acorda următoarea încercare prin pagina Răspunsuri sau pe pagina Evaluatorului.
* Automat - După fiecare încercare, următoarea încercare este acordată automat.
* Automat până la promovare - După fiecare încercare, următoarea încercare va fi acordată automat, până când cursantul obține nota de trecere.';
$string['attemptreopenmethod_manual'] = 'Manual';
$string['attemptreopenmethod_manual_help'] = 'După fiecare încercare, puteți oferi următoarea încercare prin pagina Răspunsuri sau pagina evaluatorului.';
$string['attemptreopenmethod_none'] = 'Niciodată';
$string['attemptreopenmethod_untilpass'] = 'Automat până se obține notă de trecere';
$string['attemptreopenmethod_untilpass_help'] = 'După fiecare încercare, următoarea încercare va fi permisă automat până când cursantul obține notă de trecere.';
$string['attemptsettings'] = 'Setări încerecre';
$string['availability'] = 'Disponibilitate';
$string['back'] = 'Înapoi';
$string['backtoassignment'] = 'Înapoi la sarcina de lucru';
$string['batchoperationaddattempt'] = 'Permite încercări';
$string['batchoperationconfirmaddattempt'] = 'Permiteți o altă încercare pentru răspusurile selectate?';
$string['batchoperationconfirmdownloadselected'] = 'Descărcați răspunsurile selectate?';
$string['batchoperationconfirmgrantextension'] = 'Acordați o extensie tuturor răspusurilor selectate?';
$string['batchoperationconfirmlock'] = 'Blochează toate răspusurile selectate?';
$string['batchoperationconfirmremovesubmission'] = 'Elimină răspunsurile selectate?';
$string['batchoperationconfirmreverttodraft'] = 'Restabiliți răspunsurile trimise selectate cu status în lucru?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Setați alocarea punctelor pentru toate răspunsurile selectate?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Setați starea fluxului de lucru de punctare pentru toate răspunsurile selectate?';
$string['batchoperationconfirmunlock'] = 'Deblocați toate răspunsurile selectate?';
$string['batchoperationdownloadselected'] = 'Descarcă';
$string['batchoperationgrantextension'] = 'Extinde';
$string['batchoperationlock'] = 'Blocare';
$string['batchoperationremovesubmission'] = 'Șterge';
$string['batchoperationreverttodraft'] = 'Reveniți la ciornă';
$string['batchoperationsdescription'] = 'Cu cele selectate ...';
$string['batchoperationsetmarkingallocation'] = 'Alocă utilizator';
$string['batchoperationsetmarkingworkflowstate'] = 'Modifică statusul notării';
$string['batchoperationunlock'] = 'Deblochează';
$string['batchsetallocatedmarker'] = 'Setați persoana care notează alocată pentru cei {$a} utilizatori selectați.';
$string['batchsetmarkingworkflowstateforusers'] = 'Setați starea fluxului de lucru de punctare pentru cei {$a} utilizatori selectați.';
$string['beginassignment'] = 'Începeți sarcina de lucru';
$string['blindmarking'] = 'Trimitere răspuns anonim';
$string['blindmarking_help'] = 'Trimiterea unui răspuns anonim ascunde identitatea cursanților de persoanele care îi notează. Setările pentru Trimitere răspuns anonim vor fi blocate odată ce au fost trimise răspunsuri sau un cursant a fost notat în această sarcină de lucru.';
$string['blindmarkingenabledwarning'] = 'Trimiterea anonimă a răspunsurilor este activată pentru această activitate. Notele nu vor fi adăugate în carnetul de note până când identitățile elevilor nu sunt dezvăluite prin meniul acțiunii Notare.';
$string['cachedef_overrides'] = 'Suprascriere informații pentru utilizator și grup';
$string['calendardue'] = '{$a} este scadent';
$string['calendarextension'] = '{$a} trebuie predat (extension)';
$string['calendargradingdue'] = '{$a} urmează să fie notat';
$string['caneditsubmission'] = 'Puteți trimite/edita răspunsul după expirarea limitei de timp, dar va fi marcat ca fiind întârziat.';
$string['changefilters'] = 'Schimbați filtrele';
$string['changeuser'] = 'Modifică utilizatorul';
$string['choosegradingaction'] = 'Acțiune de notare';
$string['choosemarker'] = 'Alege...';
$string['chooseoperation'] = 'Alege operațiunea';
$string['clickexpandreviewpanel'] = 'Faceți click pentru a extinde panoul de analiză';
$string['collapsegradepanel'] = 'Restrângeți panoul de notare';
$string['collapsereviewpanel'] = 'Restrângeți panoul de analiză';
$string['comment'] = 'Comentariu';
$string['completiondetail:submit'] = 'Trimite un răspuns';
$string['completionsubmit'] = 'Trimite un răspuns';
$string['configshowrecentsubmissions'] = 'Notificările despre cursurile trimise sunt disponibile public în cadrul raportului despre activităţile recente.';
$string['confirmbatchgradingoperation'] = 'Sunteți sigur(ă) că doriți să {$a->operation} pentru {$a->count} cursanți?';
$string['confirmstart'] = 'Ai {$a} să termini această sarcină. Când începi, cronometrul va porni numărătoarea inversă și nu poate fi întrerupt.';
$string['confirmsubmission'] = 'Sunteți sigur că doriți să trimiteți răspunsul pentru a fi notat? Nu veți mai putea face alte modificări.';
$string['confirmsubmissionheading'] = 'Confirmă trimiterea';
$string['conversionexception'] = 'Nu s-a putut converti tema. Excepția a fost: {$a}.';
$string['couldnotconvertgrade'] = 'Nu s-a putut converti nota răspunsului utilizatorul {$a}.';
$string['couldnotconvertsubmission'] = 'Nu s-a putut converti răspunsului utilizatorul {$a}.';
$string['couldnotcreatecoursemodule'] = 'Nu se poate crea modulul de curs';
$string['couldnotcreatenewassignmentinstance'] = 'Nu s-a putut crea o nouă instanță pentru temă.';
$string['couldnotfindassignmenttoupgrade'] = 'Nu s-a putut găsi nicio instanță de sarcină veche de actualizat.';
$string['crontask'] = 'Procesare în fundal a modulului sarcină';
$string['currentassigngrade'] = 'Nota curentă în sarcina de lucru';
$string['currentattempt'] = 'Aceasta este încercarea {$a}.';
$string['currentattemptof'] = 'Aceasta este încercarea {$a->attemptnumber} ( {$a->maxattempts} încercări permise ).';
$string['currentgrade'] = 'Nota actuală în catalog';
$string['cutoffdate'] = 'Data limită';
$string['cutoffdate_help'] = 'Dacă este setată, sarcina de lucru nu va accepta răspunsuri după această dată fără o prelungire.';
$string['cutoffdatecolon'] = 'Data limită: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Data limită nu poate fi mai devreme de data de început a trimiteri răspunsurilor.';
$string['cutoffdatevalidation'] = 'Data limită nu poate fi mai devreme decât data de trimitere.';
$string['defaultgradescale'] = 'Scală de notare';
$string['defaultgradescale_help'] = 'Scală de notare implicită pentru sarcinile de lucru noi. Doar scalele standard sunt disponibile.';
$string['defaultgradetype'] = 'Tip de notare';
$string['defaultgradetype_help'] = 'Tipul implicit de notare pentru noile sarcini de lucru.';
$string['defaultlayout'] = 'Restabiliți aspectul implicit';
$string['defaultsettings'] = 'Setările implicite ale sarcinii de lucru';
$string['defaultsettings_help'] = 'Aceste setări determină valorile implicite ale tuturor sarcinilor de lucru noi.';
$string['defaultteam'] = 'Grup implicit';
$string['deleteallsubmissions'] = 'Toate răspunsurile';
$string['description'] = 'Descriere';
$string['disabled'] = 'Dezactivat';
$string['downloadall'] = 'Descărcați toate lucrările';
$string['downloadasfolders'] = 'Descărcați răspunsurile în dosare separate';
$string['downloadasfolders_help'] = 'Răspunsurile cursanților la sarcini pot fi descărcate în foldere separate. Fiecare răspuns este apoi pus într-un folder separat, cu structura de dosare păstrată pentru orice subfolder, iar fișierele nu sunt redenumite.';
$string['downloadselectedsubmissions'] = 'Descărcați lucrările selectate';
$string['duedate'] = 'Termen de predare';
$string['duedate_help'] = 'Acesta este momentul limită la care sarcina poate fi trimisă. Răspunsurile vor fi permise în continuare după această dată, dar orice sarcini trimise după această dată vor fi marcate ca întârziate. Setați o dată limită pentru trimiterea sarcinii pentru a preveni trimiterile după o anumită dată.';
$string['duedateaftersubmissionvalidation'] = 'Data limită de trimitere a răspunsurilor trebuie să fie după începerii trimiterii răspunsurilor.';
$string['duedatecolon'] = 'Data predării: {$a}';
$string['duedatereached'] = 'Data predării acestei lucrări este depășită';
$string['duedatevalidation'] = 'Data limită de trimitere nu poate fi mai devreme decât data de început permisă pentru trimiterea răspunsurilor.';
$string['duplicateoverride'] = 'Duplică suprascrierea';
$string['editaction'] = 'Acțiuni...';
$string['editattemptfeedback'] = 'Editați nota și feedback-ul pentru încercarea cu numărul {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Se editează feedback-ul unei încercări anterioare. Aceasta este încercarea {$a->attemptnumber} din {$a->totalattempts}.';
$string['editingstatus'] = 'Se editează statusul';
$string['editonline'] = 'Editați online';
$string['editoverride'] = 'Editează suprascrierea';
$string['editsubmission'] = 'Editează răspunsul trimis';
$string['editsubmission_help'] = 'Puteți face în continuare modificări la răspunsul trimis de dvs.';
$string['editsubmissionother'] = 'Editează răspunsul lui {$a}';
$string['enabled'] = 'Activat';
$string['enabletimelimit'] = 'Activează alocările cronometrate';
$string['enabletimelimit_help'] = 'Dacă este activat, poți seta o limită de timp pe pagina de setări de atribuire.';
$string['errornosubmissions'] = 'Nu sunt răspunsuri de downloadat';
$string['errorquickgradingvsadvancedgrading'] = 'Notele nu au fost salvate deoarece această sarcină de lucru utilizează în prezent notarea avansată';
$string['errorrecordmodified'] = 'Notele nu au fost salvate deoarece cineva a modificat una sau mai multe înregistrări mai recent decât atunci când ați încărcat dumneavoastră pagina.';
$string['eventallsubmissionsdownloaded'] = 'Toate răspunsurile trimise sunt descărcate.';
$string['eventassessablesubmitted'] = 'S-a trimis un răspuns';
$string['eventbatchsetmarkerallocationviewed'] = 'Alocarea markerului setului de loturi a fost vizualizat';
$string['eventbatchsetworkflowstateviewed'] = 'Statusul markerului setului de loturi a fost vizualizat';
$string['eventextensiongranted'] = 'A fost acordată o prelungire.';
$string['eventfeedbackupdated'] = 'Feedback actualizat';
$string['eventfeedbackviewed'] = 'Feedback vizualizat';
$string['eventgradingformviewed'] = 'Formular de notare vizualizat';
$string['eventgradingtableviewed'] = 'Tabel de notare vizualizat';
$string['eventidentitiesrevealed'] = 'Au fost afișate id-urile';
$string['eventmarkerupdated'] = 'Alocarea markerului setului de loturi a fost actualizat';
$string['eventoverridecreated'] = 'A fost creată o suprascriere a sarcinii';
$string['eventoverridedeleted'] = 'A fost ștearsă o suprascriere a sarcinii de lucru';
$string['eventoverrideupdated'] = 'A fost actualizată o suprascriere a sarcinii de lucru';
$string['eventremovesubmissionformviewed'] = 'Elimină confirmarea trimiterii vizualizată.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Faceți vizibilă pagina de confirmare a identităților vizualizate.';
$string['eventstatementaccepted'] = 'Utilizatorul a acceptat declarația trimiterii răspunsului.';
$string['eventsubmissionconfirmationformviewed'] = 'Formularul de confirmare a trimiterii a fost vizualizat.';
$string['eventsubmissioncreated'] = 'Răspuns creat';
$string['eventsubmissionduplicated'] = 'Utilizatorul și-a duplicat trimiterea.';
$string['eventsubmissionformviewed'] = 'Formularul de răspuns a fost vizualizat.';
$string['eventsubmissiongraded'] = 'Răspunsul a fost notat';
$string['eventsubmissionlocked'] = 'Trimiterea răspunsurilor a fost blocată pentru un utilizator.';
$string['eventsubmissionremoved'] = 'Răspuns șters.';
$string['eventsubmissionstatusupdated'] = 'Status-ul lucrării a fost actualizat';
$string['eventsubmissionstatusviewed'] = 'Status-ul lucrării a fost vizualizat';
$string['eventsubmissionunlocked'] = 'Trimiterea răspunsurilor a fost deblocată pentru un utilizator.';
$string['eventsubmissionupdated'] = 'Răspuns actualizat';
$string['eventsubmissionviewed'] = 'Răspuns vizualizat';
$string['eventworkflowstateupdated'] = 'Starea fluxului de lucru a fost actualizată.';
$string['expandreviewpanel'] = 'Extinde panoul de analiză';
$string['extensionduedate'] = 'Termen de predare extins';
$string['extensionduedatecurrent'] = 'Extinderea datei curente de trimitere a răspunsului';
$string['extensionduedatenone'] = 'Nici unul';
$string['extensionduedaterange'] = 'Variază între {$a->earliest} și {$a->latest}';
$string['extensionduedatewithout'] = 'Utilizatori fără extensie: {$a}';
$string['extensionnotafterduedate'] = 'Data prelungirii trebuie să fie ulterioară datei limită';
$string['extensionnotafterfromdate'] = 'Data prelungirii trebuie să fie ulterioară datei de început a trimiterii răspunsurilor';
$string['feedback'] = 'Feedback';
$string['feedbackavailableanonhtml'] = 'Aveți un feedback nou despre
trimiterea sarcinii pentru „<i> {$a->assignment} </i>” <br /> <br />
Îl puteți vedea atașat la <a href="{$a->url} "> trimiterea sarcinii </a>.';
$string['feedbackavailableanonsmall'] = 'Feedback nou pentru sarcina {$a->assignment}';
$string['feedbackavailableanontext'] = 'Aveți un feedback nou pentru
trimiterea sarcinii „{$a->assignment}”

Îl puteți vedea atașat la trimiterea sarcinii:

     {$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} a postat câteva feedback-uri pentru
trimiterea temei „<i> {$a->assignment} </i>” <br /> <br />
Îl puteți vedea atașat la <a href="{$a->url} "> trimiterea sarcinii </a>.';
$string['feedbackavailablesmall'] = '{$a->username} a oferit feedback pentru sarcina de lucru {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} a postat câteva feedback-uri pentru
trimiterea răspunsului șa sarcina de lucru „{$a->assignment}”

Îl puteți vedea atașat la trimiterea sarcinii:

     {$a->url}';
$string['feedbackplugin'] = 'Plugin feedback';
$string['feedbackpluginforgradebook'] = 'Plugin de feedback va împinge comentariile în carnetul de note';
$string['feedbackpluginforgradebook_help'] = 'Doar un singur plugin de feedback pentru sarcini poate împinge feedback-ul în carnetul de note.';
$string['feedbackplugins'] = 'Plugin-uri de feedback';
$string['feedbacksettings'] = 'Setări feedback';
$string['feedbacktypes'] = 'Tipuri de feedback';
$string['filesubmissions'] = 'Trimiteri de fișiere';
$string['filter'] = 'Filtru';
$string['filterall'] = 'Toate';
$string['filterdraft'] = 'Draft';
$string['filtergrantedextension'] = 'Prelungire acordată';
$string['filternone'] = 'Fără filtru';
$string['filternotsubmitted'] = 'Netrimis';
$string['filterrequiregrading'] = 'Necesită notare';
$string['filtersubmitted'] = 'Trimisă';
$string['fixrescalednullgrades'] = 'Această sarcină de lucru conține câteva note eronate. Puteți <a href="{$a->link} "> remedia automat aceste note </a>. Acest lucru poate afecta nota totală a cursului.';
$string['fixrescalednullgradesconfirm'] = 'Sigur doriți să remediați notele eronate? Toate notele afectate vor fi eliminate. Acest lucru poate afecta nota totală a cursului.';
$string['fixrescalednullgradesdone'] = 'Note ajustate.';
$string['gradeabovemaximum'] = 'Nota trebuie să fie mai mică sau egală cu {$a}.';
$string['gradeactions'] = 'Acțiuni de notare';
$string['gradebelowzero'] = 'Nota trebuie să fie mai mare sau egală cu zero.';
$string['gradebreakdown'] = 'Defalcare notă';
$string['gradecanbechanged'] = 'Nota poate fi schimbată';
$string['gradechangessaveddetail'] = 'Schimbările feedback-ului și ale notei au fost salvate';
$string['graded'] = 'Notat';
$string['gradedby'] = 'Notat de';
$string['gradedfollowupsubmit'] = 'Notat -  retrimis';
$string['gradedon'] = 'Notat în data de';
$string['gradeitem:submissions'] = 'Răspunsuri trimise';
$string['gradelocked'] = 'Această notă este blocată sau suprascrisă în catalog.';
$string['gradeoutof'] = 'O notă din {$a}';
$string['gradeoutofhelp'] = 'Notă';
$string['gradeoutofhelp_help'] = 'Inserați nota studentului aici. Se pot include zecimale.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} a modificat tema trimisă la
<i>\'{$a->assignment}\'</i><br /><br />
Tema modificată <a href="{$a->url}">este disponibilă pe site</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} a actualizat răspunsul corespunzător sarcinii de lucru {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} a modificat tema trimisă la
\'{$a->assignment}\'

Tema modificată este disponibilă aici:

    {$a->url}';
$string['gradestudent'] = 'Nota cursantului: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Notă {$a}';
$string['grading'] = 'Se notează';
$string['gradingchangessaved'] = 'Schimbările notei au fost salvate';
$string['gradingduedate'] = 'Amintește-mi să notez până la data de';
$string['gradingduedate_help'] = 'Data preconizată până la care notarea răspunsurilor ar trebui să fie încheiată. Această dată este utilizată pentru a prioritiza notificările în tabloul de bord al profesorilor.';
$string['gradingdueduedatevalidation'] = 'Data de reamintire a notării sarcinilor nu poate fi înainte de data limită de trimitere a sarcinilor.';
$string['gradingduefromdatevalidation'] = 'Data de reamintire a notării sarcinilor nu poate fi înainte de data de început  a trimitere a sarcinilor.';
$string['gradingmethodpreview'] = 'Criteriu de notare';
$string['gradingoptions'] = 'Opțiuni';
$string['gradingstatus'] = 'Starea de notare';
$string['gradingstudent'] = 'Se notează cursantul';
$string['gradingsummary'] = 'Sumarul notării';
$string['grantextension'] = 'Prelungirea perioadei de trimitere';
$string['grantextensionforusers'] = 'Extindeți perioada de trimitere pentru {$a} cursanți';
$string['groupoverrides'] = 'Suprascrieri de grup';
$string['groupoverridesdeleted'] = 'Suprascrieri de grup șterse';
$string['groupsnone'] = 'Nu puteți accesa niciun grup.';
$string['groupsubmissionsettings'] = 'Setări pentru trimiterea răspunsului în grup';
$string['hiddenuser'] = 'Participant';
$string['hidegrader'] = 'Ascundeți de cursanți identitatea utilizatorului care notează';
$string['hidegrader_help'] = 'Dacă este activată opțiunea, identitatea oricărui utilizator care notează un răspuns trimis nu este afișată, astfel încât cursanții nu pot vedea cine le-a notat răspunsul.

Rețineți că această setare nu are niciun efect asupra casetei de comentarii de pe pagina de notare.';
$string['hideshow'] = 'Ascunde/Afișează';
$string['inactiveoverridehelp'] = '* Această suprascriere este inactivă, deoarece accesul utilizatorului la activitate este restricționat. Acest lucru se poate datora sarcinii de grup sau de rol, altor restricții de acces sau activității ascunse.';
$string['includesuspendedparticipants'] = 'Include participanții suspendați';
$string['indicator:cognitivedepth'] = 'Informații cognitive despre activitatea sarcină';
$string['indicator:cognitivedepth_help'] = 'Acest indicator se bazează pe profunzimea cognitivă atinsă de cursant într-o activitate de sarcină.';
$string['indicator:cognitivedepthdef'] = 'Informații cognitive despre activitatea sarcină';
$string['indicator:cognitivedepthdef_help'] = 'Participantul a atins acest procent din implicarea cognitivă oferită de activitățile de tip sarcină în timpul acestui interval de analiză (niveluri = Fără vizualizare, Vizualizare, Trimitere, Vizualizare feedback, Comentariu la feedback, Retrimitere după vizualizare feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Informații sociale despre activitatea sarcină';
$string['indicator:socialbreadth_help'] = 'Acest indicator se bazează pe angajamentul socială atinsă de cursant într-o activitate de tip sarcină.';
$string['indicator:socialbreadthdef'] = 'Informații sociale despre activitatea sarcină';
$string['indicator:socialbreadthdef_help'] = 'Participantul a atins acest procent din angajamentul social oferit de activitățile de tip sarcină în timpul acestui interval de analiză (niveluri = Fără participare, Participare singur, Participare cu alții)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'Fișierul cu instrucțiuni';
$string['introattachments'] = 'Fișiere adiționale';
$string['introattachments_help'] = 'Pot fi adăugate fișiere suplimentare pentru utilizare în sarcină, cum ar fi șabloanele de răspuns.';
$string['invalidfloatforgrade'] = 'Nota furnizată nu a putut fi înțeleasă: {$a}';
$string['invalidgradeforscale'] = 'Nota furnizată nu a fost validă pentru scala actuală';
$string['invalidoverrideid'] = 'ID-ul suprascrierii nu este valid';
$string['lastmodifiedgrade'] = 'Ultima modificare (nota)';
$string['lastmodifiedsubmission'] = 'Ultima modificare (a răspunsului)';
$string['latesubmissions'] = 'Răspunsuri întârziate';
$string['latesubmissionsaccepted'] = 'Permis până în {$a}';
$string['loading'] = 'Se încarcă...';
$string['locksubmissionforstudent'] = 'Nu mai permiteți răspunsuri ale studentului: (id={$a->id}, fullname={$a->fullname}).';
$string['locksubmissions'] = 'Blocați trimiterile';
$string['manageassignfeedbackplugins'] = 'Gestionați plugin-urile de feedback ale sarcinii de lucru';
$string['manageassignsubmissionplugins'] = 'Gestionați plugin-urile de trimitere a sarcinilor de lucru';
$string['marker'] = 'Marker';
$string['markerfilter'] = 'Filtru utilizator notare';
$string['markerfilternomarker'] = 'Fără marker';
$string['markingallocation'] = 'Utilizați alocarea de utilizatori de notare';
$string['markingallocation_help'] = 'Dacă este activată împreună cu fluxul de notare, utilizatorii de notare pot fi alocați anumitor studenți.';
$string['markinganonymous'] = 'Permiteți publicarea parțială a notelor în timp ce punctați în mod anonim';
$string['markinganonymous_help'] = 'Dacă este activat împreună cu trimiterea răspunsurilor anonime și fluxul de lucru de notare, permite publicarea parțială a notelor în timp ce sunt notate anonim.';
$string['markingstate'] = 'Statusul notării';
$string['markingworkflow'] = 'Utilizați fluxul de notare';
$string['markingworkflow_help'] = 'Dacă este activată, notele vor trece printr-o serie de etape ale fluxului de notare înainte de a fi atribuite cursanților. Acest lucru permite mai multe runde de notare și permite atribuirea notelor pentru toți cursanții în același timp.';
$string['markingworkflowstate'] = 'Starea fluxului de notare';
$string['markingworkflowstate_help'] = 'Stările posibile ale fluxului de notare pot include (în funcție de permisiunile dvs.):

* Nu este notat - utilizatorul de notare nu a început încă notarea
* În curs de notare - utilizatorul de notare a început notarea, dar nu a terminat încă
* Notare finalizată - utilizatorul de notare a finalizat notarea, dar poate e necesar să facă verificări / corecții
* În revizuire - notarea este acum la profesorul responsabil pentru verificarea calității
* Gata pentru atribuite - profesorul responsabil este mulțumit de notare, dar poate aștepta înainte de a le oferi cursanților acces la notare
* Atribuit - cursantul poate accesa notele / feedback-ul';
$string['markingworkflowstateinmarking'] = 'Se notează';
$string['markingworkflowstateinreview'] = 'Se revizuiește';
$string['markingworkflowstatenotmarked'] = 'Nu este notat';
$string['markingworkflowstatereadyforrelease'] = 'Gata de lansare';
$string['markingworkflowstatereadyforreview'] = 'Notare completă';
$string['markingworkflowstatereleased'] = 'Lansat';
$string['maxattempts'] = 'Încercări permise';
$string['maxattempts_help'] = 'Numărul maxim de încercări care pot fi făcute de către un cursant. După ce a fost atins acest număr, trimiterea răspunsurilor nu mai poate fi redeschisă.';
$string['maxgrade'] = 'Notă maximă';
$string['maxperpage'] = 'NUmărul maxim de sarcini de lucru per pagină';
$string['maxperpage_help'] = 'Numărul maxim de sarcini pe care le poate afișa un utilizator care notează în pagina de notare a sarcinilor. Această setare este utilă pentru prevenirea expirării timpilor de notare pentru cursurile cu un număr mare de participanți.';
$string['messageprovider:assign_due_digest'] = 'Notificare că sarcina de lucru expiră în 7 zile';
$string['messageprovider:assign_due_soon'] = 'Notificare privind răspunsul care trebuie trimis în curând';
$string['messageprovider:assign_notification'] = 'Notificări pentru sarcina de lucru';
$string['messageprovider:assign_overdue'] = 'Notificare privind depășirea datei de trimitere';
$string['modulename'] = 'Sarcină de lucru';
$string['modulename_help'] = 'Modulul activitate de tip sarcină de lucru permite profesorului să comunice sarcini de lucru, să colecteze răspunsuri și să ofere note și feedback.

Cursanții pot trimite orice conținut digital (fișiere), cum ar fi documente procesate tip text, foi de calcul, imagini sau clipuri audio și video. Alternativ sau, în plus, sarcina de lucru le poate cere cursanților să introducă text direct în editorul de text. O sarcină poate fi, de asemenea, utilizată pentru a le reaminti cursanților sarcinile de lucru „din lumea reală” pentru a le finaliza offline, cum ar fi lucrările de artă și, prin urmare, să nu necesite conținut digital. Cursanții pot trimite lucrări individual sau ca membru al unui grup.

Atunci când examinează sarcinile, profesorii pot lăsa comentarii de feedback și pot încărca fișiere, cum ar fi răspunsurile cursanților marcate, documente cu comentarii sau feedback audio (vorbit). Sarcinile pot fi notate folosind o scală numerică sau personalizată sau o metodă avansată de notare, cum ar fi un barem. Notele finale sunt înregistrate în catalog.';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Sarcini de lucru';
$string['moreusers'] = 'încă {$a}...';
$string['multipleteams'] = 'Membru al mai mult de un grup';
$string['multipleteams_desc'] = 'Sarcina necesită trimiterea de răspuns în grupuri. Sunteți membru al mai multor grupuri. Pentru a putea trimite trebuie să fiți membru al unui singur grup. Vă rugăm să vă contactați profesorul pentru a vă schimba calitatea de membru al grupului.';
$string['multipleteamsgrader'] = 'Membru al mai multor grupuri, deci se pot trimite răspunsuri.';
$string['newsubmissions'] = 'Sarcini de lucru trimise';
$string['nextuser'] = 'Următorul utilizator';
$string['noattempt'] = 'Fără încercare';
$string['noclose'] = 'Nicio dată de încheiere';
$string['nofiles'] = 'Fără fișiere.';
$string['nofilters'] = 'Fără filtre';
$string['nograde'] = 'Fără notă.';
$string['nogroupoverrides'] = 'Nu sunt există suprascrieri ale grupului în prezent.';
$string['nomoresubmissionsaccepted'] = 'Permis numai pentru participanții cărora li s-a acordat o prelungire';
$string['none'] = 'Niciunul';
$string['noonlinesubmissions'] = 'Această sarcină nu necesită să trimiteți nimic online';
$string['noopen'] = 'Fără dată deschisă';
$string['nooverridedata'] = 'Trebuie să înlocuiți cel puțin una dintre setările de atribuire.';
$string['nosavebutnext'] = 'Următorul';
$string['nosubmission'] = 'Nu s-a primit răspuns la această sarcină de lucru';
$string['nosubmissionyet'] = 'Încă nu au fost trimise răspunsurile';
$string['noteam'] = 'Nu este un membru al vreunui grup';
$string['noteam_desc'] = 'Această sarcină necesită trimiterea în grupuri. Nu sunteți membru al niciunui grup, deci nu puteți trimite un răspuns. Vă rugăm să vă contactați profesorul pentru a vă adăuga la un grup.';
$string['noteamgrader'] = 'Nu este membru al niciunui grup, deci nu poate trimite răspunsuri.';
$string['notgraded'] = 'Fără notă';
$string['notgradedyet'] = 'Încă nu s-au acordat note';
$string['notifications'] = 'Notificări';
$string['notifystudents'] = 'Notifică studenții';
$string['nouseroverrides'] = 'Nu sunt suprascrieri ale niciunui utilizator în prezent.';
$string['nousers'] = 'Fără utilizatori';
$string['nousersselected'] = 'Fără utilizatori selectați';
$string['numberofdraftsubmissions'] = 'Draft-uri';
$string['numberofparticipants'] = 'Participanți';
$string['numberofsubmissionsneedgrading'] = 'Trebuie să fie notat';
$string['numberofsubmissionsneedgradinglabel'] = 'Trebuie să fie notat: {$a}';
$string['numberofsubmittedassignments'] = 'Trimis';
$string['numberofteams'] = 'Grupuri';
$string['offline'] = 'Nu se solicită răspunsuri online';
$string['open'] = 'Deschis';
$string['opensubmissionexists'] = 'Răspunsul a fost trimis deja.';
$string['outlinegrade'] = 'Notă: {$a}';
$string['outof'] = '{$a->current} din {$a->total}';
$string['overdue'] = 'Sarcina de lucru a fost depășită cu: {$a}';
$string['override'] = 'Suprascriere';
$string['overridedeletegroupsure'] = 'Sigur doriți să ștergeți suprascrierea pentru grupul {$a}?';
$string['overridedeleteusersure'] = 'Sigur doriți să ștergeți suprascrierea pentru utilizatorul {$a}?';
$string['overridegroup'] = 'Suprascriere de grup';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Suprascrieri';
$string['overrideuser'] = 'Suprascriere utilizator';
$string['overrideusereventname'] = '{$a->assign} - Suprascriere';
$string['page-mod-assign-view'] = 'Pagina principală a modulului sarcină și pagina de trimitere răspuns';
$string['page-mod-assign-x'] = 'Orice pagină a modulului sarcină';
$string['paramtimeremaining'] = '{$a} rămase';
$string['participant'] = 'Participant';
$string['pluginadministration'] = 'Administrare sarcină de lucru';
$string['pluginname'] = 'Sarcină de lucru';
$string['preventsubmissionnotingroup'] = 'Doar cursanții din grupuri pot să trimită răspunsuri';
$string['preventsubmissionnotingroup_help'] = 'Dacă este activată, utilizatorii care nu sunt membri ai unui grup nu vor putea trimite răspunsuri.';
$string['preventsubmissions'] = 'Împiedicați utilizatorul să mai trimită răspunsuri la această sarcină.';
$string['preventsubmissionsshort'] = 'Nu se permite modificarea răspunsurilor';
$string['previous'] = 'Precedent';
$string['previoususer'] = 'Utilizatorul de dinainte';
$string['privacy:attemptpath'] = 'răspuns {$a}';
$string['privacy:blindmarkingidentifier'] = 'Identificatorul utilizat pentru Trimitere răspuns anonim';
$string['privacy:gradepath'] = 'notă';
$string['privacy:metadata:assigndownloadasfolders'] = 'O preferință de utilizator pentru descărcarea în foldere diferite a fișierelor încărcate';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Fișiere și text de feedback pentru sarcina de lucru.';
$string['privacy:metadata:assignfilter'] = 'Opțiuni de filtrare precum „A fost trimis”, „Nu a fost trimis”, „Necesită notare” și „Extensie acordată”';
$string['privacy:metadata:assigngrades'] = 'Stochează notele utilizatorilor la sarcina de lucru';
$string['privacy:metadata:assignmarkerfilter'] = 'Filtrează rezumatul sarcinii de lucru după utilizatorul de notare atribuit.';
$string['privacy:metadata:assignmentid'] = 'ID sarcină de lucru';
$string['privacy:metadata:assignmessageexplanation'] = 'Mesajele sunt trimise cursanților prin intermediul sistemului de mesagerie.';
$string['privacy:metadata:assignoverrides'] = 'Stochează informațiile de înlocuire ale sarcinii de lucru';
$string['privacy:metadata:assignperpage'] = 'Numărul de sarcini afișate pe pagină.';
$string['privacy:metadata:assignquickgrading'] = 'O preferință dacă se utilizează sau nu notarea rapidă a sarcinilor de lucru.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Stochează informații despre sarcina trimisă de utilizator';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Fișiere și text trimise pentru sarcină.';
$string['privacy:metadata:assignuserflags'] = 'Stochează metadate ale utilizatorului, cum ar fi datele termenelor extinse';
$string['privacy:metadata:assignusermapping'] = 'Alocarea pentru Trimitere răspuns anonim';
$string['privacy:metadata:assignworkflowfilter'] = 'Filtrare după diferitele etape ale fluxului de notare.';
$string['privacy:metadata:grade'] = 'Valoare numerică a notei pentru răspunsul acestă sarcină. Poate fi determinat de scale / forme avansate de notare etc, dar va fi întotdeauna convertit înapoi la un număr în virgulă mobilă.';
$string['privacy:metadata:grader'] = 'ID-ul utilizatorului persoanei care a acordat nota.';
$string['privacy:metadata:groupid'] = 'ID-ul grupului în care utilizatorul este membru .';
$string['privacy:metadata:latest'] = 'Simplifică foarte mult interogările care adună informații despre cea mai recentă încercare.';
$string['privacy:metadata:mailed'] = 'A fost deja trimis mesaj acestui utilizator prin poștă?';
$string['privacy:metadata:timecreated'] = 'Creat în';
$string['privacy:metadata:timestarted'] = 'Început în';
$string['privacy:metadata:userid'] = 'ID-ul utilizatorului';
$string['privacy:studentpath'] = 'Răspunsuri cursanți';
$string['privacy:submissionpath'] = 'răspuns';
$string['quickgrading'] = 'Notare rapidă';
$string['quickgrading_help'] = 'Notarea rapidă vă permite să atribuiți note (și rezultate) direct în tabelul de răspunsuri. Notarea rapidă nu este compatibilă cu notarea avansată și nu este recomandată atunci când sunt mai mulți utilizatori care notează răspunsuri.';
$string['quickgradingchangessaved'] = 'S-a salvat modificarea notelor';
$string['quickgradingresult'] = 'Notare rapidă';
$string['recordid'] = 'Identificator';
$string['relativedatessubmissiontimeleft'] = 'Calculat pentru fiecare cursant';
$string['removeallgroupoverrides'] = 'Toate suprascrierile grupului';
$string['removealluseroverrides'] = 'Toate suprascrierile utilizatorului';
$string['removesubmission'] = 'Șterge răspunsul';
$string['removesubmissionconfirm'] = 'Sigur vrei să elimini datele răspunsului (fișiere și text)?';
$string['removesubmissionconfirmforstudent'] = 'Sigur vrei să elimini datele răspunsului (fișiere și text) pentru cursantul {$a}?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'Sigur vrei să elimini trimiterea răspunsului pentru {$a}? Te rugăm să reții că acest lucru nu va reseta limita de timp a studentului. Ppți acorda mai mult timp adăugând o limită de timp pentru anularea utilizatorului.';
$string['removesubmissionconfirmwithtimelimit'] = 'Sigur vrei să elimini mesajul trimis? Te rugăm să reții că acest lucru nu vă va reseta limita de timp.';
$string['removesubmissionforstudent'] = 'Elimină răspunsul pentru cursantul: (id={$a->id}, fullname={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Opțiunea Redeschis automat până când se obține o notă de trecere este incompatibilă cu setarea Trimitere răspuns anonim, deoarece notele nu sunt alocate în carnetul de note până când nu sunt dezvăluite identitățile cursanților.';
$string['requireallteammemberssubmit'] = 'Se solicită tuturor membrilor grupului să facă click pe butonul de trimitere a răspunsului';
$string['requireallteammemberssubmit_help'] = 'Această setare trebuie utilizată împreună cu „Solicită cursanților să dea click pe butonul de trimitere răspuns” din Setările de trimitere a Răspunsurilor.

Dacă este activat, toți membrii grupului trebuie să dea click pe butonul de trimitere răspuns pentru ca răspunsul trimis de grup să fie considerat trimis spre evaluare. Dacă este dezactivată această setare, orice membru al grupului poate da click pe butonul de trimitere răspuns.';
$string['requiresubmissionstatement'] = 'Solicită cursanților să accepte declarația de trimitere a răspunsului.';
$string['requiresubmissionstatement_help'] = 'Solicită cursanților să declare că răspunsul trimis este o lucrare proprie, acest lucru se aplică tuturor răspunsurile trimise la această sarcină de lucru.';
$string['revealidentities'] = 'Afișează identitatea studentului';
$string['revealidentitiesconfirm'] = 'Sunteți sigur că doriți să afișați identitățile cursanților pentru această sarcină? Această operațiune nu poate fi anulată. Odată ce identitățile cursanților au fost afișate, notele vor fi alocate în carnetul de note.';
$string['reverttodefaults'] = 'Reveniți la valorile implicite ale sarcinii';
$string['reverttodraft'] = 'Schimbă starea răspunsului în răspuns provizoriu.';
$string['reverttodraftforgroup'] = 'Schimbă starea răspunsului în răspuns provizoriu pentru grupul {$a}.';
$string['reverttodraftforstudent'] = 'Schimbă starea răspunsului în răspuns provizoriu pentru cursantul: (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Schimbă starea răspunsului în răspuns provizoriu.';
$string['reviewed'] = 'Verificat';
$string['save'] = 'Salvează';
$string['saveallquickgradingchanges'] = 'Salvează toate modificările rapide de note';
$string['saveandcontinue'] = 'Salvează și continuă';
$string['savechanges'] = 'Salvează modificări';
$string['savegradingresult'] = 'Notă';
$string['savenext'] = 'Salvează și afișează următoarea';
$string['saveoverrideandstay'] = 'Salează și inserează o altă suprascriere';
$string['savingchanges'] = 'Se salvează modificările...';
$string['scale'] = 'Scală';
$string['search:activity'] = 'Sarcină de lucru - informații despre activitate';
$string['selectedusers'] = 'Utlizatorii selectați';
$string['selectlink'] = 'Selectează...';
$string['selectuser'] = 'Selectează {$a}';
$string['sendlatenotifications'] = 'Notificare profesori cu privire la răspunsurile întârziate';
$string['sendlatenotifications_help'] = 'Dacă este activat, profesorii primesc o notificare ori de câte ori un cursant trimite un răspuns după data finală de trimitere. Metodele de trimitere mesaje sunt configurabile.';
$string['sendnotificationduedatesoon'] = 'Notificați utilizatorul cu privire la data de trimitere care se apropie';
$string['sendnotificationduedigest'] = 'Notifică utilizatorul că sarcina de lucru expiră în 7 zile';
$string['sendnotificationoverdue'] = 'Notifică utilizatorul că sarcina de lucru este depășită';
$string['sendnotifications'] = 'Notificare profesori cu privire la răspunsuri';
$string['sendnotifications_help'] = 'Dacă este activat, profesorii primesc un mesaj ori de câte ori un cursant trimite un răspuns. Metodele de trimitere mesaje sunt configurabile.';
$string['sendstudentnotifications'] = 'Notificare cursant';
$string['sendstudentnotifications_help'] = 'Bifați această casetă pentru a trimite o notificare despre nota sau feedback actualizat. Dacă tema folosește un flux de lucru de notare sau notele sunt ascunse în raportul evaluatorului, atunci notificarea nu va fi trimisă până când nota este eliberată.';
$string['sendstudentnotificationsdefault'] = 'Setare implicită pentru "Notificare cursant"';
$string['sendstudentnotificationsdefault_help'] = 'Când se evaluează fiecare cursant, ar trebui să fie bifată în mod implicit căsuța „Notificare cursant”?';
$string['sendsubmissionreceipts'] = 'Trimiteți cursanților dovada de trimitere a răspunsului';
$string['sendsubmissionreceipts_help'] = 'Acest comutator activează dovezile de trimitere a răspunsului de către cursanți. Cursanții vor primi o notificare de fiecare dată când trimit cu succes un răspuns la o sarcină.';
$string['setmarkerallocationforlog'] = 'Setați alocarea notelor : (id={$a->id}, fullname={$a->fullname}, marker={$a->marker}).';
$string['setmarkingallocation'] = 'Setați utilizatorul e notare alocat';
$string['setmarkingworkflowstate'] = 'Setați starea fluxului de notare';
$string['setmarkingworkflowstateforlog'] = 'Setați starea fluxului de notare : (id={$a->id}, fullname={$a->fullname}, state={$a->state}).';
$string['settings'] = 'Setările sarcinii de lucru';
$string['showrecentsubmissions'] = 'Afişează răspunsurile recente';
$string['status'] = 'Status';
$string['studentnotificationworkflowstateerror'] = 'Starea fluxului de notare trebuie să fie „Alocat” pentru a notifica toți cursanții.';
$string['submission'] = 'Temă trimisă';
$string['submissionactions'] = 'Acțiuni de trimitere a răspunsului';
$string['submissionattachments'] = 'Afișează fișierele doar în timpul trimiterii răspunsului.';
$string['submissionattachments_help'] = 'Când este activat, fișierele vor fi afișate numai pe ecranul de trimitere.
Când este dezactivat, fișierele vor fi afișate atât pe ecranul de vizualizare a sarcinilor, cât și pe ecranul de trimitere.';
$string['submissioncopiedhtml'] = '<p> Ați făcut o copie a versiunii anterioare
a răspunsului trimis pentru „<i> {$a->assignment} </i>”. </p>
<p> Puteți vedea starea <a href="{$a->url} "> răspunsului trimis pentru această sarcină </a>. </p>';
$string['submissioncopiedsmall'] = 'Ați copiat răspunsul trimis anterior pentru {$a->assignment}';
$string['submissioncopiedtext'] = 'Ați făcut o copie a versiunii anterioare
a răspunsului trimis pentru sarcina „{$a->assignment}”

Puteți vedea starea răspunsului trimis pentru sarcină:

     {$a->url}';
$string['submissiondrafts'] = 'Se solicită cursanților să dea click pe butonul de trimitere răspuns';
$string['submissiondrafts_help'] = 'Dacă este activat (opțiunea Da), cursanții vor trebui să facă clic pe un buton de trimitere răspuns pentru a se considera răspunsul ca fiind final. Acest lucru permite cursanților să păstreze în sistem o versiune provizorie a răspunsului (draft).
Atenție!!! Dacă această setare este schimbată de către profesor din „Nu” în „Da” după ce cursanții au trimis deja răspunsuri, aceste răspunsuri vor fi considerate finale.';
$string['submissioneditable'] = 'Cursantul își poate edita lucrările trimise';
$string['submissionempty'] = 'Nu a fost trimis nimic';
$string['submissionlog'] = 'Student: {$a->fullname}, Status: {$a->status}';
$string['submissionmodified'] = 'Aveți date de trimitere existente. Părăsiți această pagină și încercați din nou.';
$string['submissionmodifiedgroup'] = 'Răspunsul trimis a fost modificată de altcineva. Părăsiți această pagină și încercați din nou.';
$string['submissionnotcopiedinvalidstatus'] = 'Răspunsul trimis nu a fost copiat, deoarece a fost editată de când a fost redeschisă.';
$string['submissionnoteditable'] = 'Cursanții nu pot să editeze acest răspuns';
$string['submissionnotopen'] = 'Această sarcină de lucru nu este deschisă pentru timiterea de răspunsuri';
$string['submissionnotready'] = 'Această sarcină de lucru nu poate fi trimisă încă:';
$string['submissionplugins'] = 'Plugin-uri pentru răspuns';
$string['submissionreceipthtml'] = '<p> Ați trimis un răspuns pentru sarcina „<i> {$a->assignment} </i>”. </p>
<p> Puteți vedea starea <a href="{$a->url} "> răspunsului trimis pentru această sarcină</a>. </p>';
$string['submissionreceiptotherhtml'] = 'Răspunsul trimis pentru sarcina de lucru
„<i> {$a->assignment} </i>” a fost trimis. <br /> <br />
Puteți vedea starea <a href="{$a->url} ">răspunsului trimis pentru această sarcină</a>.';
$string['submissionreceiptothersmall'] = 'Răspunsul pentru sarcina {$a->assignment} a fost trimis.';
$string['submissionreceiptothertext'] = 'Răspunsul pentru sarcina de lucru
„{$a->assignment}” a fost trimis.

Puteți vedea răspunsul trimis pentru sarcină:

     {$a->url}';
$string['submissionreceipts'] = 'Trimiteți dovezile de depunere a răspunsului';
$string['submissionreceiptsmall'] = 'Ați trimis răspunsul la {$a->assignment}';
$string['submissionreceipttext'] = 'Ai trimis un
răspuns pentru sarcina de lucru  „{$a->assignment}”

Puteți vedea răspunsul trimis pentru sarcina de lucru:

     {$a->url}';
$string['submissionsclosed'] = 'Perioada de trimitere a răspunsurilor s-a încheiat';
$string['submissionsettings'] = 'Setările răspunsurilor';
$string['submissionslocked'] = 'Această temă nu acceptă răspunsuri';
$string['submissionslockedshort'] = 'Modificările răspunsurilor trimise nu sunt permise';
$string['submissionstatement'] = 'Declarație de depunere răspuns';
$string['submissionstatement_help'] = 'Declarație pe care fiecare cursant trebuie să o accepte pentru a-și putea trimite răspunsul.';
$string['submissionstatementacceptedlog'] = 'Declarație de trimitere răspuns acceptată de utilizatorul {$a}';
$string['submissionstatementdefault'] = 'Acest răspuns este lucrarea mea proprie, cu excepția cazului în care am recunoscut utilizarea lucrărilor altor persoane.';
$string['submissionstatementrequired'] = 'Vi se cere să fiți de acord cu această declarație înainte de a trimite răspunsul.';
$string['submissionstatementteamsubmission'] = 'Declarație de depunere în grup';
$string['submissionstatementteamsubmission_help'] = 'Declarație pe care fiecare cursant trebuie să o accepte pentru a trimite răspunsul pentru grupul său.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Declarație de depunere a grupului în care depun toți membrii grupului';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Declarație pe care fiecare student trebuie să o accepte pentru a-și trimite răspunsul ca membru al grupului.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Acest răspuns reprezintă lucrarea mea ca membru al grupului, cu excepția cazului în care am recunoscut utilizarea lucrărilor altor persoane.';
$string['submissionstatementteamsubmissiondefault'] = 'Această depunere a răspunsului este opera grupului meu, cu excepția cazului în care am recunoscut utilizarea lucrărilor altor persoane.';
$string['submissionstatus'] = 'Status răspuns';
$string['submissionstatus_'] = 'Fără răspunsu';
$string['submissionstatus_draft'] = 'Draft (netrimis)';
$string['submissionstatus_marked'] = 'Notat';
$string['submissionstatus_new'] = 'Fără răspunsur';
$string['submissionstatus_reopened'] = 'Redeschis';
$string['submissionstatus_submitted'] = 'Trimis pentru notare';
$string['submissionstatusheading'] = 'Status răspuns';
$string['submissionsummary'] = '{$a->status}. Ultima dată modificat în data de {$a->timemodified}';
$string['submissionteam'] = 'Grup';
$string['submissiontypes'] = 'Tipuri de răspuns';
$string['submitaction'] = 'Trimite';
$string['submitassignment'] = 'Trimite răspuns corespunzător temei';
$string['submitassignment_help'] = 'Odată ce această sarcină este trimisă, nu veți mai putea face alte modificări.';
$string['submitforgrading'] = 'Trimiteți pentru notare';
$string['submitted'] = 'Trimisă';
$string['submittedearly'] = 'Sarcina de lucru a fost rezolvată {$a} mai repede';
$string['submittedlate'] = 'Sarcina de lucru a fost rezolvată {$a} mai târziu';
$string['submittedlateshort'] = '{$a} întârziere';
$string['submittedovertime'] = 'Răspunsul a fost trimis cu {$a} după data limită';
$string['submittedundertime'] = 'Răspunsul a fost trimis cu {$a} înainte de data limită';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Plugin feedback';
$string['subplugintype_assignfeedback_plural'] = 'Plugin-uri feedback';
$string['subplugintype_assignsubmission'] = 'Plugin de trimitere răspuns';
$string['subplugintype_assignsubmission_plural'] = 'Pluginuri de trimitere răspuns';
$string['teamname'] = 'Echipa: {$a}';
$string['teamsubmission'] = 'Cursanții trimit răspuns în grupuri';
$string['teamsubmission_help'] = 'Dacă este activată, cursanții vor fi împărțiți în grupuri pe baza setului implicit de grupuri sau a unei grupări personalizate. O trimitere a unui răspuns de grup va fi partajată între membrii grupului și toți membrii grupului vor vedea cu o culoare diferită schimbările aduse de ceilalți colegi în răspunsul trimis.
Răspunsul final trimis va fi compus din textele scrise de toți colegii din acel grup.';
$string['teamsubmissiongroupingid'] = 'Gruparea grupurilor de cursanți';
$string['teamsubmissiongroupingid_help'] = 'Aceasta este gruparea grupurilor din curs pe care sarcina de lucru o va folosi pentru a găsi grupuri de cursanți. Dacă nu este setat, va fi utilizat setul implicit de grupuri.';
$string['textinstructions'] = 'Instrucțiuni pentru sarcina de lucru';
$string['timelimit'] = 'Limită de timp';
$string['timelimit_help'] = 'Dacă este activată, limita de timp este menționată pe pagina de atribuire și este afișat un cronometru cu numărătoare inversă în timpul atribuirii.';
$string['timelimitnotenabled'] = 'Limita de timp nu este activată pentru sarcina de lucru.';
$string['timelimitpassed'] = 'Limita de timp a fost depășită';
$string['timemodified'] = 'Modificat ultima dată';
$string['timeremaining'] = 'Timp rămas';
$string['timeremainingcolon'] = 'Timp rămas: {$a}';
$string['togglezoom'] = 'Măriți / micșorați regiunea';
$string['ungroupedusers'] = 'Setarea „Solicită grupului să trimită răspunsuri” este activată, iar unii utilizatori fie nu sunt membri ai niciunui grup, fie sunt membri ai mai multor grupuri, deci nu pot să trimită răspunsuri.';
$string['ungroupedusersoptional'] = 'Setarea „Cursanții trimit răspunsuri în grupuri” este activată, iar unii utilizatori fie nu sunt membri ai niciunui grup, fie sunt membri ai mai multor grupuri. Rețineți că acești cursanți vor trimite răspunsuri ca membri ai „grupului implicit”.';
$string['unlimitedattempts'] = 'Nelimitat';
$string['unlimitedattemptsallowed'] = 'Se permit încercări nelimitate';
$string['unlimitedpages'] = 'Nelimitat';
$string['unlocksubmissionforstudent'] = 'Permiteți trimiterea de răspunsuri pentru cursantul: (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'Deblochează trimiterile răspunsurilor';
$string['unsavedchanges'] = 'Modificări nesalvate';
$string['unsavedchangesquestion'] = 'Apar modificări nesalvate la note sau feedback. Doriți să salvați modificările și să continuați?';
$string['updategrade'] = 'Actualizează nota';
$string['updatetable'] = 'Salvează și actualizează tabelul';
$string['upgradenotimplemented'] = 'Upgrade-ul nu a fost implementat în plugin ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Valorile implicite ale sarcinii utilizatorului';
$string['userextensiondate'] = 'Extindere acordată până la: {$a}';
$string['usergrade'] = 'Nota utilizatorului';
$string['useridlistnotcached'] = 'Modificările de notă NU au fost salvate, deoarece nu a fost posibil să se determine pentru care sarcină au fost trimise.';
$string['useroverrides'] = 'Suprascrieri utilizator';
$string['useroverridesdeleted'] = 'Suprascrieri utilizator șterse';
$string['usersnone'] = 'Niciun cursant nu are acces la această sarcină.';
$string['usersubmissioncannotberemoved'] = 'Răspunsul {$a} nu poate fi eliminat.';
$string['userswhoneedtosubmit'] = 'Utilizatorii care trebuie să trimită un răspuns: {$a}';
$string['validmarkingworkflowstates'] = 'Stări valide ale fluxului de notare';
$string['viewadifferentattempt'] = 'Vizualizați un alt răspuns';
$string['viewbatchmarkingallocation'] = 'Vizualizați pagina de alocare a setului de note în loturi.';
$string['viewbatchsetmarkingworkflowstate'] = 'Vizualizați pagina de flux a setului de note în loturi.';
$string['viewfeedback'] = 'Vezi feedback';
$string['viewfeedbackforuser'] = 'Vezi feedback-ul utilizatorului: {$a}';
$string['viewfull'] = 'Vizualizare completă';
$string['viewfullgradingpage'] = 'Deschideți pagina completă de notare pentru a oferi feedback';
$string['viewgradebook'] = 'Vezi catalogul de note';
$string['viewgrader'] = 'Vezi evaluatorul';
$string['viewgrading'] = 'Vezi toate răspunsurile';
$string['viewgradingformforstudent'] = 'Vizualizați pagina de notare pentru cursantul: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Vizualizați propria pagină de trimitere răspunsurilor sarcinilor.';
$string['viewownsubmissionstatus'] = 'Vizualizați propria pagină cu starea trimiterii răspunsurilor sarcinilor.';
$string['viewrevealidentitiesconfirm'] = 'Vizualizați pagina de confirmare a identității cursanților.';
$string['viewsubmission'] = 'Vezi răspunsurile';
$string['viewsubmissionforuser'] = 'Vizualizați trimiterea răspunsurilor sarcinilor pentru utilizatorul: {$a}';
$string['viewsubmissiongradingtable'] = 'Vizualizați tabelul de notare a răspunsului.';
$string['viewsummary'] = 'Vezi rezumatul';
$string['workflowfilter'] = 'Filtru workflow';
$string['xofy'] = '{$a->x} din {$a->y}';
