<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'de', version '4.5'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility:rate:choice'] = 'Zeile{$a->rowposition}, {$a->choicetitle}: Spalte {$a->colposition}, {$a->choiceanswer}.';
$string['action'] = 'Aktion';
$string['activityoverview'] = 'Sie haben unbeantwortete Befragungen.';
$string['additionalinfo'] = 'Zusätzliche Infos';
$string['additionalinfo_help'] = 'Text, der am Anfang der ersten Seite dieser Befragung angezeigt werden soll, z.B. Anleitungen, Hintergrundinfos, usw.';
$string['addnewquestion'] = '{$a}-Frage hinzufügen';
$string['addnewsection'] = 'Abschnitt anlegen';
$string['addquestion'] = 'Frage hinzufügen ...';
$string['addquestions'] = 'Fragen hinzufügen';
$string['addquestiontosection'] = 'Weitere Fragen zum Abschnitt hinzufügen';
$string['addselqtype'] = 'Ausgewählten Fragetyp hinzufügen';
$string['alignment'] = 'Anordnung der Radio-Buttons';
$string['alignment_help'] = 'Anordnung wählen: senkrecht (Standard) oder waagerecht';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Alle';
$string['allnameddegrees'] = 'Benannte Abstufungen';
$string['allnameddegrees_help'] = 'Geben Sie für jede Abstufung einen Text ein. Verwenden Sie pro Abstufung eine neue Zeile. Lassen Sie eine Zeile leer, um die betreffende Abstufung nicht zu verwenden.';
$string['alreadyfilled'] = 'Sie haben diese Befragung bereits ausgefüllt. {$a}';
$string['andaveragevalues'] = 'und durchschnittliche Werte';
$string['anonymous'] = 'Anonym';
$string['answer'] = 'Antwort';
$string['answergiven'] = 'Beantwortet';
$string['answernotgiven'] = 'Nicht beantwortet';
$string['answerquestions'] = 'Beantworten Sie die Fragen ...';
$string['answers'] = 'Antworten';
$string['attempted'] = 'Die Befragung wurde abgegeben.';
$string['attemptstillinprogress'] = 'In Bearbeitung. Gespeichert unter:';
$string['autonumbering'] = 'Automatische Nummerierung';
$string['autonumbering_help'] = 'Automatische Nummerierung der Fragen und Seiten. Falls Sie abhängige Verzweigungen nutzen, sollten Sie dies ggfs. deaktivieren.';
$string['autonumberno'] = 'Keine Nummerierung der Fragen oder Seiten';
$string['autonumberpages'] = 'Automatische Nummerierung der Seiten';
$string['autonumberpagesandquestions'] = 'Automatische Nummerierung der Seiten und Fragen';
$string['autonumberquestions'] = 'Automatische Nummerierung der Fragen';
$string['average'] = 'Relative Häufigkeit';
$string['averageposition'] = 'Mittlere Position';
$string['averagerank'] = 'Durchschnittsbewertung';
$string['averagesrow'] = 'Durchschnittswerte (wenn möglich):';
$string['bodytext'] = 'Texterläuterung';
$string['boxesnbexact'] = 'genau {$a} Kästchen';
$string['boxesnbmax'] = 'maximal {$a} Kästchen';
$string['boxesnbmin'] = 'mindestens {$a} Kästchen';
$string['boxesnbreq'] = 'Antwort(en) auswählen';
$string['by'] = 'von';
$string['cannotviewpublicresponses'] = 'Sie können keine Antworten zu dieser öffentlichen Befragung sehen.';
$string['centerlabel'] = 'Zentrierte Beschriftung';
$string['chart:bipolar'] = 'Bipolare Achse';
$string['chart:hbar'] = 'Horizontale Achse';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Rose';
$string['chart:type'] = 'Grafiktyp';
$string['chart:type_help'] = 'Wählen Sie den Grafiktyp, den Sie für dieses Feedback verwenden möchten.';
$string['chart:vprogress'] = 'Vertikaler Fortschrittsbalken';
$string['checkallradiobuttons'] = 'Wählen Sie bitte <strong>{$a}</strong> Antwort(en)!';
$string['checkboxes'] = 'Checkboxen';
$string['checkboxes_help'] = 'Tragen Sie jeweils eine Option pro Zeile ein. Die Teilnehmer/innen können eine oder mehrere Antworten auswählen.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Neuer Seitenumbruch/Seitenumbrüche an folgenden Positione(n) eingefügt:';
$string['checkbreaksok'] = 'Alle erforderlichen Seitenumbrüche sind vorhanden!';
$string['checkbreaksremoved'] = 'Zusätzliche Seitenumbrüche entfernt: {$a}';
$string['checknotstarted'] = 'Auswahl nicht gestartet';
$string['checkstarted'] = 'Auswahl gestartet';
$string['clicktoswitch'] = '(klicken, um zu wechseln)';
$string['closebeforeopen'] = 'Das Enddatum muss nach dem Startdatum sein.';
$string['closed'] = 'Die Befragung wurde am {$a} beendet. Danke.';
$string['closedate'] = 'Antworten erlauben bis';
$string['closeson'] = 'Befragung schließt am {$a}';
$string['completionsubmit'] = 'Teilnehmer/innen müssen die Befragung abgeben, um abzuschließen.';
$string['condition'] = 'Bedingung';
$string['confalts'] = '- oder - <br />Bestätigungsseite';
$string['configemailreporting'] = 'Berichte per E-Mail erlauben';
$string['configemailreportinglong'] = 'Optionen für Berichte aktivieren, die direkt per E-Mail an bestimmte E-Mail-Adressen gesendet werden.';
$string['configmaxsections'] = 'Maximale Feedback-Abschnitte';
$string['configusergraph'] = 'Grafiken für das "Personality Test"-Feedback anzeigen';
$string['configusergraphlong'] = '<a href="http://www.rgraph.net/">Rgraph Library</a> verwenden, um die "Personality Test"-Feedback-Grafiken anzuzeigen.';
$string['confirmdelallresp'] = 'Möchten Sie wirklich alle Antworten in dieser Befragung löschen?';
$string['confirmdelchildren'] = 'Wenn Sie diese Frage löschen, werden die abhängigen Fragen ebenfalls gelöscht:';
$string['confirmdeletesection'] = 'Möchten Sie wirklich den Feedback-Abschnitt \'{$a}\' löschen?';
$string['confirmdelgroupresp'] = 'Möchten Sie wirklich alle Antworten von {$a} löschen?';
$string['confirmdelquestion'] = 'Möchten Sie wirklich die Frage an Position {$a} löschen?';
$string['confirmdelquestionresps'] = 'Dies wird auch die {$a} Antwort(en) löschen, die für die Frage bereits gegeben wurden.';
$string['confirmdelresp'] = 'Möchten Sie wirklich die Antwort von {$a} löschen?';
$string['confirmremovequestion'] = 'Möchten Sie wirklich die Frage \'{$a->qname}\' aus Abschnitt \'{$a->sname}\' entfernen?';
$string['confpage'] = 'Überschrift';
$string['confpage_help'] = 'Überschrift (fett) und Beschreibung für die "Bestätigungsseite", die nach der Abgabe der Befragung angezeigt wird. Wenn Sie eine URL angeben, wird diese statt der Bestätigungsseite angezeigt. Falls dieses Feld leer bleibt, wird nach der Abgabe eine Standardmitteilung angezeigt: Danke fürs Ausfüllen dieser Befragung.';
$string['confpagedesc'] = 'Überschrift (fett) und Beschreibung für die "Bestätigungsseite", die nach der Abgabe der Befragung angezeigt wird. Wenn Sie eine URL angeben, wird diese statt der Bestätigungsseite angezeigt.';
$string['contentoptions'] = 'Inhaltsoptionen';
$string['couldnotcreatenewsurvey'] = 'Neue Befragung konnte nicht angelegt werden!';
$string['couldnotdelresp'] = 'Antwort konnte nicht gelöscht werden';
$string['createcontent'] = 'Neuen Inhalt festlegen';
$string['createcontent_help'] = 'Wählen Sie eine Option für die Radio Buttons ("neu erstellen" ist der Standard).';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Neuen Inhalt festlegen';
$string['crontask'] = 'Befragungen bereinigen';
$string['date'] = 'Datum';
$string['date_help'] = 'Verwenden Sie diesen Fragetyp, wenn die Antwort in einem korrekten Datumsformat vorliegen soll.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Verwenden Sie das Format Jahr-Monat-Tag, z.B. für den 14. März 2019: <strong>2019-03-04</strong>';
$string['deleteallresponses'] = 'Alle Antworten löschen';
$string['deletecurrentquestion'] = 'Frage {$a} löschen';
$string['deletedallgroupresp'] = 'Alle Antworten in der Gruppe {$a} löschen';
$string['deletedallresp'] = 'Antworten der Befragung gelöscht';
$string['deletedisabled'] = 'Dieses Objekt kann nicht gelöscht werden.';
$string['deletedresp'] = 'Antwort löschen';
$string['deleteresp'] = 'Diese Antwort löschen';
$string['deletesection'] = 'Diesen Abschnitt löschen';
$string['deletingresp'] = 'Antwort wird gelöscht';
$string['dependencies'] = 'Abhängigkeiten';
$string['dependquestion'] = 'Übergeordnete Frage';
$string['dependquestion_help'] = 'Sie können eine übergeordnete Frage und eine Auswahlmöglichkeit für die Frage wählen. Eine untergeordnete Frage wird Teilnehmer/innen nur dann angezeigt, wenn die übergeordnete Wahlmöglichkeit vorher ausgewählt wurde.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Hat die Frage nicht beantwortet';
$string['directwarnings'] = 'Direkte Abhängigkeiten zu dieser Frage werden entfernt. Dies  betrifft:';
$string['displaymethod'] = 'Anzeigemethode für Frage nicht definiert';
$string['download'] = 'Herunterladen';
$string['downloadpdf'] = 'PDF herunterladen';
$string['downloadtextformat'] = 'Herunterladen';
$string['downloadtextformat_help'] = 'Mit dieser Funktion können Sie alle Antworten einer Befragung in einer Datei speichern. Die Datei kann dann in einem Tabellenkalkulationsprogramm (z. B. MS Excel oder Open Office Calc) oder einem Statistikprogramm weiter ausgewertet werden.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Berichtstyp';
$string['dropdown'] = 'Dropdown-Feld';
$string['dropdown_help'] = 'Es gibt keinen Vorteil, ein Dropdown-Feld an Stelle von Radio Buttons zu verwenden, außer um Platz zu sparen und die Länge der Liste zu reduzieren.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Bearbeiten';
$string['editingfeedback'] = 'Feedbackeinstellungen';
$string['editingquestionnaire'] = 'Einstellungen der Befragung bearbeiten';
$string['editquestion'] = 'Frage {$a} bearbeiten';
$string['email'] = 'E-Mail';
$string['emailextra'] = 'Bericht an E-Mail-Adressen senden';
$string['emailextra_help'] = 'Diese Einstellung legt fest, dass eine Berichtsdatei an alle aufgelisteten E-Mail-Adressen gesendet wird. Beachten Sie, dass KEINE Sicherheits- oder Datenschutzprüfungen durchgeführt werden.
In den Moduleinstellungen muss \'allowemailreporting\' aktiviert sein, um darauf zugreifen zu können.';
$string['emailroles'] = 'Bericht an Rollen senden';
$string['emailroles_help'] = 'Diese Einstellung legt fest, dass eine Berichtsdatei per E-Mail an alle Rollen mit der Funktion "mod/questionnaire:submissionnotification" gesendet wird.
In den Moduleinstellungen muss \'allowemailreporting\' aktiviert sein, um darauf zugreifen zu können.';
$string['emailsend'] = 'Berichte senden';
$string['emailsnotspecified'] = 'Es wurden keine E-Mail-Adressen angegeben.';
$string['emailssent'] = 'Die Berichte wurden an die angegebenen E-Mail-Adressen gesendet.';
$string['errnewname'] = 'Dieser Name wird bereits verwendet. Wählen Sie einen anderen Namen.';
$string['erroropening'] = 'Fehler beim Öffnen der Befragung.';
$string['errortable'] = 'Fehler: Befragungstabelle beschädigt.';
$string['essaybox'] = 'Texteingabebereich';
$string['essaybox_help'] = 'Diese Frage wird eine Textbox mit x Spalten (oder der entsprechenden Breite) und y Zeilen (Anzahl der Textzeilen) anzeigen.

Wenn Sie beides auf dem Standardwert 0 belassen (oder es auf 0 setzen), wird der Texteditor mit Standardhöhe und -breite angezeigt (Werte aus dem Kurs- oder Nutzerprofil).';
$string['event_all_responses_deleted'] = 'Alle Antworten gelöscht';
$string['event_all_responses_saved_as_text'] = 'Alle Antworten als Text gespeichert';
$string['event_all_responses_viewed'] = 'Bericht aller Antworten angezeigt';
$string['event_individual_responses_viewed'] = 'Bericht aller individuellen Antworten angezeigt';
$string['event_non_respondents_viewed'] = 'Nicht-Antwortende angezeigt';
$string['event_previewed'] = 'Befragungsvorschau angesehen';
$string['event_question_created'] = 'Frage erstellt';
$string['event_question_deleted'] = 'Frage gelöscht';
$string['event_response_deleted'] = 'Individuelle Antworten gelöscht';
$string['event_resumed'] = 'Versuch aufgenommen';
$string['event_saved'] = 'Antworten gespeichert';
$string['event_submitted'] = 'Antworten abgesendet';
$string['feedback'] = 'Feedback';
$string['feedback_help'] = 'Feedback-Hilfe';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Weitere Feedback-Felder hinzufügen';
$string['feedbackbysection'] = 'Abschnittsfeedback';
$string['feedbackdefaultlabel'] = '[Neuer Abschnitt]';
$string['feedbackeditingglobal'] = 'Globales Feedback des Fragebogens bearbeiten';
$string['feedbackeditingmessages'] = 'Feedback-Mitteilungen des Fragebogens bearbeiten';
$string['feedbackeditingsections'] = 'Feedback der Abschnitte des Fragebogens bearbeiten';
$string['feedbackeditmessages'] = 'Einstellungen des Abschnitts speichern und Feedback-Mitteilungen bearbeiten';
$string['feedbackeditsections'] = 'Einstellungen speichern und Abschnittsfeedback bearbeiten';
$string['feedbackerrorboundaryformat'] = 'Die Grenzwerte eines Feedbacks müssen entweder in Prozent oder als Zahl angegeben werden. Der angegebene Wert {$a} wird nicht erkannt.';
$string['feedbackerrorboundaryoutofrange'] = 'Die Grenzwerte eines Feedbacks müssen zwischen 0% und 100% sein. Der angegebene Wert {$a} liegt außerhalb des Bereichs.';
$string['feedbackerrorjunkinboundary'] = 'Sie müssen die Grenzwerte für das Feedback in den Feldern ohne Lücken eintragen.';
$string['feedbackerrorjunkinfeedback'] = 'Sie müssen die Feedback-Felder ohne Lücken ausfüllen.';
$string['feedbackerrororder'] = 'Die Grenzwerte eines Feedbacks müssen in einer Reihenfolge sein. Der angegebene Wert {$a} liegt außerhalb der Reihe.';
$string['feedbackglobal'] = 'Globales Feedback';
$string['feedbackglobalheading'] = 'Überschrift des globalen Feedbacks';
$string['feedbackglobalmessages'] = 'Text des globalen Feedbacks';
$string['feedbackhdr'] = 'Feedbacks';
$string['feedbackheading'] = 'Feedback-Überschrift';
$string['feedbackheading_help'] = 'In der Überschrift des Feedbacks können Sie zwei Variablen nutzen: $scorepercent und $oppositescorepercent.';
$string['feedbackmessages'] = 'Feedbacktext für Abschnitt {$a}';
$string['feedbacknextsection'] = 'Nächster Abschnitt {$a}';
$string['feedbacknone'] = 'Kein Feedbacktext';
$string['feedbacknotes'] = 'Anmerkungen zum Feedback';
$string['feedbacknotes_help'] = 'Der hier angegebene Text wird den Teilnehmer/innen am Ende ihres Feedbackberichts angezeigt.';
$string['feedbackoptions'] = 'Feedbackoptionen';
$string['feedbackoptions_help'] = 'Die Feedbackoptionen sind verfügbar, wenn Ihre Befragung eine der folgenden Fragetypen oder Frageeinstellungen enthält:
Radio Buttons, Dropdown-Feld, Ja/Nein oder Bewertung (Normal oder semantisches Differential) oder Schieberegler. Diese Fragen müssen als \'erforderlich\' gesetzt werden, der Name der Frage darf NICHT leer sein und die vorhandenen Frageauswahlmöglichkeiten müssen einen Wert enthalten.
Schieberegler-Fragen dürfen keinen negativen Wert für den Mindestbereich enthalten.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Diese Frage ist Teil des Feedback-Abschnitts [{$a}]';
$string['feedbackremovesection'] = 'Das Löschen dieser Frage wird den Feedback-Abschnitt [{$a}] komplett löschen.';
$string['feedbackreport'] = 'Feedbackbericht';
$string['feedbackscore'] = 'Feedback-Auswertung';
$string['feedbackscoreboundary'] = 'Bewertungsgrenze';
$string['feedbackscores'] = 'Anzeige der Auswertung';
$string['feedbackscores_help'] = 'Tabelle mit den Auswertungsergebnissen anzeigen';
$string['feedbacksection'] = 'Abschnitt';
$string['feedbacksectionheading'] = 'Titel für Abschnitt {$a}';
$string['feedbacksectionheadingmissing'] = 'Sie müssen einen Titel für diesen Feedback-Abschnitt eingeben!';
$string['feedbacksectionheadingtext'] = 'Überschrift';
$string['feedbacksectionlabel'] = 'Textfeld';
$string['feedbacksectionlabel_help'] = 'Dieses Textfeld wird in den Diagrammen genutzt. Halten Sie Ihren Text so kurz wie möglich.';
$string['feedbacksectionquestions'] = 'Fragen in Abschnitt {$a}';
$string['feedbacksections'] = 'Abschnittsfeedback';
$string['feedbacksectionsselect'] = 'Abschnitte';
$string['feedbacksectionsselect_help'] = 'Platzieren Sie Ihre Fragen in diese Abschnitte';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Feedback-Einstellungen gespeichert';
$string['feedbacktype'] = 'Art des Feedbacks';
$string['field'] = 'Frage {$a}';
$string['fieldlength'] = 'Textfeldlänge';
$string['fieldlength_help'] = 'Für den Fragetyp **Textfeld** können Sie die **Textfeldlänge** und die **Max. Textlänge** angeben.
Standardmäßig sind 20 Zeichen für die Textfeldlänge und 25 Zeichen für die maximale Textlänge eingestellt.';
$string['finished'] = 'Sie haben alle Fragen dieser Befragung beantwortet!';
$string['firstrespondent'] = 'Erste Abgabe';
$string['formateditor'] = 'HTML Editor';
$string['formatplain'] = 'Text';
$string['grade'] = 'Abgabe-Bewertung';
$string['gradesdeleted'] = 'Befragungsbenotung gelöscht';
$string['headingtext'] = 'Überschrift';
$string['horizontal'] = 'Waagerecht';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Auswahlcode einbeziehen';
$string['includechoicetext'] = 'Auswahltext einbeziehen';
$string['includeincomplete'] = 'Unvollständige Durchläufe einbeziehen';
$string['includerankaverages'] = 'Durchschnittswerte für Rangfragen einbeziehen';
$string['incorrectcourseid'] = 'Falsche Kurs-ID';
$string['incorrectmodule'] = 'Falsche Kursmodul-ID';
$string['incorrectquestionnaire'] = 'Falsche Befragung';
$string['indirectwarnings'] = 'Diese Liste zeigt die indirekt abhängigen Fragen und die verbleibenden Abhängigkeiten für direkt abhängige Fragen:';
$string['invalidincrement'] = 'Beachten Sie, dass die Inkrementwert kleiner als der Maximalwert sein muss. Bei einer Skala von 1 bis 10 ist der Inkrementwert beispielsweise 1.';
$string['invalidminmaxrange'] = 'Dieser Fragetyp unterstützt einen Maximalbereich von -100 bis +100. Wir gehen aber davon aus, dass die überwiegende Mehrheit der Fragebogenentwürfe einen Bereich von 1-10 oder -10 bis +10 verwenden wird.';
$string['invalidrange'] = 'Der maximale Schiebereglerwert muss größer sein als der minimale Schiebereglerwert.';
$string['invalidresponse'] = 'Falsche Antwort angegeben';
$string['invalidresponserecord'] = 'Falscher Antwortdatensatz angegeben';
$string['invalidsectionid'] = 'Ungültiger Feedback-Abschnitt.';
$string['invalidstartingvalue'] = 'Der Startwert muss gleich oder zwischen dem Minimal- und Maximalwert liegen. Wenn Sie eine Skala von 1 bis 10 verwenden, könnte der Startwert 5 sein.';
$string['invalidsurveyid'] = 'Falsche Befragungs-ID';
$string['kindofratescale'] = 'Typ der Bewertungsskala';
$string['kindofratescale_help'] = 'Rechtsklick auf den "Hilfe"-Link unten.';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Letzte Abgabe';
$string['leftlabel'] = 'Linke Beschriftung';
$string['leftpart'] = '{$a->min} ist {$a->leftlabel}';
$string['leftpartdefault'] = '{$a->min} ist der Mindest-Schiebereglerbereich';
$string['length'] = 'Länge';
$string['managequestions'] = 'Fragen bearbeiten';
$string['managequestions_help'] = 'Im Abschnitt "Fragen bearbeiten" können Sie mehrere Aktionen an den Fragen vornehmen.';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Verpflichtend - Alle Abhängigkeiten müssen erfüllt sein.';
$string['maxdigitsallowed'] = 'Max. erlaubte Ziffern';
$string['maxdigitsallowed_help'] = 'Legen Sie mit **Max. erlaubte Ziffern** die Anzahl der Zeichen fest, die als Antwort auf die Numerische Frage eingegeben werden können. Beachten Sie bitte, dass der Dezimalpunkt als Zeichen mitgezählt wird!';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Max. geforderte Antworten';
$string['maxforcedresponses_help'] = 'Verwenden Sie diese Parameter, um in den Antworten mindestens **Min.** und höchstens **Max.** Häkchen einzufordern.
Um eine bestimmte Anzahl von Häkchen zu erzwingen, setzen Sie  **Min.** und **Max.** auf den gleichen Wert. Wenn nur Minimum oder Maximum gewünscht wird, lassen Sie das andere Feld auf seinem Standardwert **0**. Wenn Sie **Min.** oder **Max.** auf einen anderen Wert als den Standard **0** setzen und eingegebene Antworten nicht mit Ihren Anforderungen übereinstimmen, wird eine Warnmeldung angezeigt. Selbstverständlich sollten die Anforderungen im Text zu den betreffenden Fragen eindeutig erläutert sein.';
$string['maxrange'] = 'Maximaler Schiebereglerbereich (rechts)';
$string['maxrange_help'] = 'Maximalwert des Bereichs auf der rechten Seite. Der Standardwert ist 100, aber es kann eine beliebige Zahl zwischen 1 und 100 sein. Wenn der minimale Wert auf der linken Seite ein negativer Wert ist, wird der maximale Bereich mit einem positiven (+) Vorzeichen ausgedrückt.';
$string['maxtextlength'] = 'Max. Textlänge';
$string['maxtextlength_help'] = 'Für die Textfeld-Frage geben Sie die Textfeldlänge und die maximale Textlänge an. Standardmäßig sind 20 Zeichen für die Textfeldlänge und 25 Zeichen für die maximale Textlänge eingestellt.';
$string['messageprovider:message'] = 'Erinnerung zu Befragung';
$string['messageprovider:notification'] = 'Mitteilung zur Befragungsabgabe';
$string['middlepart'] = ', {$a->centreval} ist {$a->middlelabel}';
$string['middlepartdefault'] = ', {$a->centreval} ist der Durchschnitt';
$string['middlepartwithtwovalues'] = ', {$a->centreval1} und {$a->centreval2} sind {$a->middlelabel}';
$string['middlepartwithtwovaluesdefault'] = ', {$a->centreval1} und {$a->centreval2} sind der Durchschnitt';
$string['minforcedresponses'] = 'Min. geforderte Antworten';
$string['minforcedresponses_help'] = 'Verwenden Sie diese Parameter, um in den Antworten mindestens **Min.** und höchstens **Max.** Häkchen einzufordern.
Um eine bestimmte Anzahl von Häkchen zu erzwingen, setzen Sie  **Min.** und **Max.** auf den gleichen Wert. Wenn nur Minimum oder Maximum gewünscht wird, lassen Sie das andere Feld auf seinem Standardwert **0**. Wenn Sie **Min.** oder **Max.** auf einen anderen Wert als den Standard **0** setzen und eingegebene Antworten nicht mit Ihren Anforderungen übereinstimmen, wird eine Warnmeldung angezeigt. Selbstverständlich sollten die Anforderungen im Text zu den betreffenden Fragen eindeutig erläutert sein.';
$string['minrange'] = 'Minimaler Schiebereglerbereich (links)';
$string['minrange_help'] = 'Mindestwert des Bereichs auf der linken Seite. Der Standardwert ist 1, kann aber auch auf -100 gesenkt werden. Wenn Sie eine negative Zahl (-100 bis -1) verwenden, wird das rechte Maximum mit einem positiven (+) Vorzeichen ausgedrückt.';
$string['misconfigured'] = 'Der Kurs ist falsch konfiguriert';
$string['missingname'] = 'Die Frage {$a} kann in diesem Feedback nicht genutzt werden, weil sie keinen Namen hat.';
$string['missingnameandrequired'] = 'Die Frage {$a} kann in diesem Feedback nicht genutzt werden, weil sie keinen Namen hat und nicht auf \'erforderlich\' gesetzt ist.';
$string['missingquestion'] = 'Füllen Sie das Pflichtfeld aus';
$string['missingquestions'] = 'Füllen Sie die Pflichtfelder aus:';
$string['missingrequired'] = 'Die Frage {$a} kann in diesem Feedback nicht genutzt werden, weil sie nicht auf \'erforderlich\' gesetzt ist.';
$string['modulename'] = 'Befragung';
$string['modulename_help'] = 'Das Modul Befragung ermöglicht die Erstellung von Fragebögen, die die Teilnehmer/innen ausfüllen sollen.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Befragungen';
$string['movedisabled'] = 'Dieses Objekt kann nicht bewegt werden';
$string['myresponses'] = 'Alle Ihre Antworten';
$string['myresponsetitle'] = 'Ihre {$a} Antworten';
$string['myresults'] = 'Ihre Ergebnisse';
$string['name'] = 'Name';
$string['navigate'] = 'Verzweigte Fragen erlauben';
$string['navigate_help'] = 'Aktivieren Sie diese Option, damit Ja/Nein-Fragen, Radio Button-Fragen und Mehrfachauswahlfragen, abhängig von den gegebenen Antworten, weitere Fragen sichtbar oder unsichtbar schalten.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Zu diesem Feedback-Abschnitt wechseln';
$string['next'] = 'Weiter';
$string['nextpage'] = 'Nächste Seite';
$string['nlines'] = '{$a} Zeilen';
$string['noanswer'] = 'Keine Antwort';
$string['noattempts'] = 'Bisher hat niemand diese Befragung ausgefüllt.';
$string['nodata'] = 'Keine Daten angegeben.';
$string['noduplicates'] = 'Keine doppelte Auswahl';
$string['noduplicateschoiceserror'] = 'Sie müssen mindestens zwei mögliche Antworten für die Option "Keine Duplikate" angeben.';
$string['non_respondents'] = 'Teilnehmer/innen, die noch keine Antworten zu diesem Fragebogen eingereicht haben.';
$string['noneinuse'] = 'Diese Befragung enthält noch keine Fragen.';
$string['nopermissions'] = 'Sie haben derzeit nicht die Berechtigung diese Seite anzuzeigen oder diese Aktion durchzuführen.';
$string['nopublicsurveys'] = 'Keine öffentlichen Befragungen';
$string['noresponsedata'] = 'Keine Antworten zu dieser Frage';
$string['noresponses'] = 'Keine Antworten';
$string['normal'] = 'Normal';
$string['not_started'] = 'nicht gestartet';
$string['notanumber'] = '<strong>{$a}</strong> ist kein mögliches Zahlenformat.';
$string['notapplicable'] = 'nicht zutreffend';
$string['notapplicablecolumn'] = 'Spalte N/A';
$string['notavail'] = 'Die Befragung steht nicht länger zur Verfügung. Die Befragung kann gelöscht werden.';
$string['noteligible'] = 'Sie können an dieser Befragung nicht teilnehmen.';
$string['notemplatesurveys'] = 'Keine Befragungsvorlagen';
$string['notenoughscaleitems'] = 'Sie müssen mindestens zwei Werte für die Skala angeben!';
$string['notificationfull'] = 'Vollständig beantwortet';
$string['notifications'] = 'Benachrichtigung über Antworten verschicken';
$string['notifications_help'] = 'Personen benachrichtigen, deren Rollen das Recht "mod/questionnaire:submissionnotification" haben, wenn eine Antwort erfolgt ist.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Nur Benachrichtigung';
$string['notopen'] = 'Diese Befragung steht ab {$a} zur Verfügung.';
$string['notrequired'] = 'Antwort ist nicht erforderlich';
$string['notset'] = 'nicht gewählt';
$string['nousersselected'] = 'Keine Teilnehmer/innen ausgewählt';
$string['num'] = '#';
$string['numattemptsmade'] = '{$a} Versuche bei dieser Befragung';
$string['numberfloat'] = 'Die eingegebene Zahl <strong>{$a->number}</strong> wurde neu gerundet mit <strong>{$a->precision}</strong> Dezimalstelle(n).';
$string['numberofdecimaldigits'] = 'Dezimalstellen';
$string['numberofdecimaldigits_help'] = 'Verwenden Sie **Dezimalstellen**, um das Format des berechneten und im Fragebogenbericht angezeigten Durchschnittswertes festzulegen.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Skalenstufen';
$string['numberscaleitems_help'] = 'Skalenstufen bezeichnet die Anzahl der Einheiten Ihrer Bewertungsskala. In der Regel sind 3 bis 5 Einheiten sinnvoll (standardmäßig 5).';
$string['numeric'] = 'Numerisch';
$string['numeric_help'] = 'Wählen Sie diesen Fragetyp, wenn Sie eine korrekt formatierte Zahl als Antwort erwarten.';
$string['of'] = 'von';
$string['openafterclose'] = 'Das Startdatum muss vor dem Enddatum sein.';
$string['opendate'] = 'Antworten erlauben ab';
$string['option'] = 'Option {$a}';
$string['optional'] = 'Optional - Mindestens eine dieser Abhängigkeiten muss erfüllt sein.';
$string['optionalname'] = 'Name der Frage';
$string['optionalname_help'] = 'Der Fragetitel wird nur benutzt, wenn Sie die Antworten als Tabelle (CSV/Excel) exportieren. Wenn Sie diese Funktion nicht verwenden, müssen Sie sich über die Fragetitel keine Gedanken machen. Wenn Sie einen regelmäßigen Export der Daten ins CSV-Format planen, haben Sie die Wahl von zwei Optionen, wie die Fragen betitelt werden sollen.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- ODER -';
$string['order_ascending'] = 'Aufsteigend';
$string['order_default'] = 'Standardreihenfolge';
$string['order_descending'] = 'Absteigend';
$string['orderresponses'] = 'Antworten sortieren';
$string['orderresponses_help'] = 'Wenn Sie alle Antworten anzeigen, können Sie die Auswahl nach Anzahl der Antworten (die Spalte \'Durchschnitt\') für die folgenden 4 Arten von Fragen auswählen:

* Einzelauswahl Radio Buttons
* Einzelauswahl Dropdown-Liste
* Mehrfachauswahl (Checkboxen)
* Bewertungsfragen (einschließlich Likert Skalen).

Wenn Sie auf der Seite \'Alle Antworten\' ankommen, werden standardmäßig alle Antworten in der Reihenfolge geordnet, in der der Fragebogen-Ersteller die Frage-Auswahl eingegeben hat.
Sie können sie in auf- oder absteigender Reihenfolge ordnen.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Semantisches Differential';
$string['other'] = 'Andere:';
$string['otherempty'] = 'Wenn Sie dies ankreuzen, müssen Sie etwas ins Textfeld eingeben.';
$string['overviewnumresplog'] = 'Antworten';
$string['overviewnumresplog1'] = 'Antwort';
$string['overviewnumrespvw'] = 'Antworten';
$string['overviewnumrespvw1'] = 'Antwort';
$string['owner'] = 'Ersteller';
$string['page'] = 'Seite';
$string['pageof'] = 'Seite {$a->page} von {$a->totpages}';
$string['parent'] = 'Vorgänger';
$string['participant'] = 'Teilnehmer/in';
$string['pleasecomplete'] = 'Auswahl bitte vervollständigen';
$string['pluginadministration'] = 'Befragungsadministration';
$string['pluginname'] = 'Befragung';
$string['position'] = 'Position';
$string['possibleanswers'] = 'Mögliche Antworten';
$string['posteddata'] = 'Letzte Seite mit bereits gesendeten Daten';
$string['preview_label'] = 'Vorschau';
$string['preview_questionnaire'] = 'Vorschau der Befragung';
$string['previewing'] = 'Befragung wird als Vorschau angezeigt';
$string['previous'] = 'Zurück';
$string['previouspage'] = 'Vorherige Seite';
$string['print'] = 'Druckversion (mit aktuellen Antworten)';
$string['printblank'] = 'Druckversion (ohne Antworten)';
$string['printblanktooltip'] = 'Ein Fenster mit einer druckfreundlichen Version der Befragung wird geöffnet (ohne Antworten)';
$string['printtooltip'] = 'Ein Fenster mit einer druckfreundlichen Version der Befragung wird geöffnet (mit den aktuellen Antworten).';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Eine Antwort auf eine Mehrfachauswahl-Frage';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'Die ID eines Auswahldatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'Die ID des Fragendatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'Die ID des Antwortdatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Eine Antwort auf eine Einfachauswahl-Frage';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'Die ID eines Auswahldatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'Die ID des Fragendatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'Die ID des Antwortdatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_response'] = 'Eine Antwort ist in Bearbeitung oder wurde eingereicht';
$string['privacy:metadata:questionnaire_response:complete'] = 'Der Antwortabschlussstatus.';
$string['privacy:metadata:questionnaire_response:grade'] = 'Die Bewertung für diese Antwort.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'Die ID des Fragebogendatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Der Zeitstempel für die letzte Speicherung dieser Antwort.';
$string['privacy:metadata:questionnaire_response:userid'] = 'Die Nutzer-ID für diese Antwort.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Eine Antwort auf eine Boolean (Ja/Nein)-Frage';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'Die spezifische Boolean-Antwort.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'Die ID des Fragendatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'Die ID des Antwortdatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_response_date'] = 'Eine Antwort auf eine Datums-Frage';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'Die ID des Fragendatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'Die spezifische Datumsantwort.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'Die ID des Antwortdatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_response_other'] = 'Eine \'andere\' Auswahl-Antwort.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'Die ID eines Auswahldatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'Die ID des Fragendatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'Die spezifische Textantwort.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'Die ID des Antwortdatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Eine Antwort auf eine Rangfrage.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'Die ID eines Auswahldatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'Die ID des Fragendatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'Die spezifische Antwort auf diesen Rang';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'Die ID des Antwortdatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_response_text'] = 'Eine Antwort auf eine Freitext-Frage';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'Die ID des Fragendatensatzes für diese Antwort.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'Die spezifische Textantwort.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'Die ID des Antwortdatensatzes für diese Antwort.';
$string['private'] = 'Privat';
$string['progressbar'] = 'Fortschritt anzeigen';
$string['progressbar_info'] = 'Befragung {$a} abgeschlossen.';
$string['progresshelp'] = 'Fortschrittsanzeige';
$string['progresshelp_help'] = 'Gehen Sie zur nächsten Seite, um die Fortschrittsanzeige zu aktualisieren.';
$string['public'] = 'Öffentlich';
$string['publiccopy'] = 'Kopie:';
$string['publicoriginal'] = 'Orginal:';
$string['qtype'] = 'Typ';
$string['qtype_help'] = 'Wählen Sie, ob Teilnehmer/innen die Befragung einmal, täglich, wöchentlich, monatlich oder beliebig oft ausfüllen können.';
$string['qtypedaily'] = 'täglich abgeben';
$string['qtypemonthly'] = 'monatlich abgeben';
$string['qtypeonce'] = 'einmal abgeben';
$string['qtypeunlimited'] = 'mehrfach abgeben';
$string['qtypeweekly'] = 'wöchentlich abgeben';
$string['questionnaire:addinstance'] = 'Neue Befragung hinzufügen';
$string['questionnaire:copysurveys'] = 'Vorlagen und persönliche Befragungen kopieren';
$string['questionnaire:createpublic'] = 'Öffentliche Befragungen anlegen';
$string['questionnaire:createtemplates'] = 'Vorlagen für Befragungen anlegen';
$string['questionnaire:deleteresponses'] = 'Jede Antwort löschen';
$string['questionnaire:downloadresponses'] = 'Antworten als Textdatei herunterladen';
$string['questionnaire:editquestions'] = 'Fragen für Befragungen erstellen und bearbeiten';
$string['questionnaire:manage'] = 'Befragungen erstellen und bearbeiten';
$string['questionnaire:message'] = 'Nachricht an Nicht-Antwortende schicken';
$string['questionnaire:preview'] = 'Befragungsvorschau';
$string['questionnaire:printblank'] = 'Leere Befragung drucken';
$string['questionnaire:readallresponseanytime'] = 'Alle Antworten jederzeit sehen';
$string['questionnaire:readallresponses'] = 'Zusammenfassung der Antworten sehen';
$string['questionnaire:readownresponses'] = 'Eigene Antworten sehen';
$string['questionnaire:submissionnotification'] = 'Für jede Abgabe Benachrichtigung senden';
$string['questionnaire:submit'] = 'Befragung abschließen und abgeben';
$string['questionnaire:view'] = 'Befragung sehen';
$string['questionnaire:viewsingleresponse'] = 'Alle persönlichen Antworten sehen';
$string['questionnaireadministration'] = 'Befragungsadministration';
$string['questionnairecloses'] = 'Befragung wird beendet';
$string['questionnaireopens'] = 'Befragung beginnt';
$string['questionnairereport'] = 'Bericht zur Befragung';
$string['questionnum'] = 'Frage # ';
$string['questions'] = 'Fragen';
$string['questionsinsection'] = 'Fragen in diesem Abschnitt:';
$string['questiontypes'] = 'Fragetypen';
$string['questiontypes_help'] = 'Beachten Sie die Moodle-Dokumentation';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Radio Buttons';
$string['radiobuttons_help'] = 'Für diesen Fragetyp muss eine von mehreren Antwortvorgaben gewählt werden.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Rang';
$string['ratescale'] = 'Bewertung (Skala 1 .. 5)';
$string['ratescale_help'] = 'Beachten Sie die Moodle-Dokumentation';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Befragungstyp';
$string['realm_help'] = '* **Es gibt 3 Typen von Befragungen:**
 * Privat - gehört ausschließlich zum Kurs in dem sie erstellt wurde.
 * Vorlage - kopierbar und editierbar.
 * Öffentlich - kann in verschiedenen Kursen mehrfach eingesetzt werden.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'URL, zu der Teilnehmer/innen nach Abschluss der Befragung weiter geleitet werden.';
$string['remove'] = 'Löschen';
$string['removeallquestionnaireattempts'] = 'Alle Antworten der Befragung löschen';
$string['removenotinuse'] = 'Diese Befragung war von einer öffentlichen Befragung abhängig, die gelöscht wurde. Sie kann nicht länger verwendet und sollte daher gelöscht werden.';
$string['required'] = 'Ausfüllen erforderlich';
$string['required_help'] = 'Wenn Sie **Ja** wählen, ist eine Antwort auf diese Frage obligatorisch, d.h. Teilnehmer/innen können die Befragung erst abgeben, wenn diese Frage beantwortet ist.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'Ein notwendiger Parameter fehlt.';
$string['reset'] = 'Zurücksetzen';
$string['respeligiblerepl'] = '(ersetzt durch Rollenänderung)';
$string['respondent'] = 'Befragte/r';
$string['respondenteligibleall'] = 'alle';
$string['respondenteligiblestudents'] = 'nur Teilnehmer/innen';
$string['respondenteligibleteachers'] = 'nur Trainer/innen';
$string['respondents'] = 'Befragte';
$string['respondenttype'] = 'Abgabetyp';
$string['respondenttype_help'] = 'Sie können die vollständigen Namen der Nutzer/innen zu jeder Antwort anzeigen lassen, wenn Sie diese Option auf "mit Namen" setzen.
Sie können die Identitäten der Nutzer/innen verstecken, wenn Sie diese Option auf "anonym" setzen.';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anonym';
$string['respondenttypefullname'] = 'Vollständiger Name';
$string['response'] = 'Antworten';
$string['responsefieldlines'] = 'Größe des Eingabefelds';
$string['responseformat'] = 'Format der Antwort';
$string['responseoptions'] = 'Antwortoptionen';
$string['responses'] = 'Antworten';
$string['responseview'] = 'Alle Antworten für Teilnehmer/innen anzeigen';
$string['responseview_help'] = 'Sie können festlegen, wer die Antworten aller Teilnehmer/innen auf abgegebene Befragungen sehen darf (allgemeine Auswertungstabelle).';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Immer';
$string['responseviewstudentsnever'] = 'Nie';
$string['responseviewstudentswhenanswered'] = 'Nach dem Ausfüllen der Befragung';
$string['responseviewstudentswhenclosed'] = 'Nach dem Ende der Befragung';
$string['restrictedtoteacher'] = 'Diese Funktionen sind nur für Trainer/innen mit Bearbeitungsrechten.';
$string['resume'] = 'Speichern/Fortsetzen';
$string['resume_help'] = 'Wenn diese Option aktiv ist, können Teilnehmer/innen die Antworten der Befragung speichern bevor sie sie einreichen. Teilnehmer/innen können die Befragung unvollendet verlassen und zu einem späteren Zeitpunkt wieder auf den gespeicherten Zustand zugreifen.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Weitermachen';
$string['return'] = 'Zurück';
$string['rightlabel'] = 'Rechte Beschriftung';
$string['rightpart'] = 'und {$a->max} ist {$a->rightlabel}';
$string['rightpartdefault'] = 'und {$a->max} ist der maximale Schiebereglerbereich';
$string['save'] = 'Speichern';
$string['save_and_exit'] = 'Speichern und fertig';
$string['saveasnew'] = 'Als neue Frage sichern';
$string['savedbutnotsubmitted'] = 'Die Befragung wurde gespeichert, aber noch nicht abgeschickt';
$string['savedprogress'] = 'Ihr Fortschritt wurde gespeichert. Sie können jederzeit zurückkehren und die Befragung abschließen.';
$string['saveeditedquestion'] = 'Frage {$a} sichern';
$string['savesettings'] = 'Einstellungen sichern';
$string['search:activity'] = 'Befragung - Infos zur Aktivität';
$string['search:question'] = 'Befragung - Fragen';
$string['section'] = 'Beschreibung';
$string['sectionbreak'] = '--- Seitenumbruch ---';
$string['sectionbreak_help'] = '--- Seitenumbruch ---';
$string['sectionsnotset'] = 'Sie müssen mindestens eine Frage pro Abschnitt auswählen!<br> Nicht ausgewählte Abschnitte: {$a}';
$string['sectiontext'] = 'Beschriftung';
$string['sectiontext_help'] = 'Dies ist keine Frage, sondern ein (kurzer) Text zur Einleitung oder Erläuterung.';
$string['selecttheme'] = 'Wählen Sie ein Design (css) für diese Befragung.';
$string['send'] = 'Senden';
$string['send_message'] = 'Ausgewählten Teilnehmer/innen eine Nachricht senden';
$string['send_message_to'] = 'Nachricht senden an:';
$string['sendemail'] = 'E-Mail versenden';
$string['sendemail_help'] = 'Eine Kopie jeder Abgabe wird an die angegebenen E-Mail-Adressen gesendet. Sie können mehr als eine E-Mail-Adresse angeben, indem Sie sie durch Kommas trennen.
Lassen Sie dieses Feld leer, wenn keine E-Mail gesendet werden sollen.
In den Moduleinstellungen muss \'allowemailreporting\' aktiviert sein, um darauf zugreifen zu können.';
$string['set'] = 'ausgewählt';
$string['settings'] = 'Einstellungen';
$string['settingssaved'] = 'Einstellungen gesichert';
$string['show_nonrespondents'] = 'Ohne Antwort';
$string['slider'] = 'Schieberegler';
$string['slider_help'] = 'Die Schiebereglerfrage ermöglicht es den Teilnehmer/innen, einen Wert aus einem kontinuierlichen Bereich auszuwählen, indem sie einen Schieberegler zwischen zwei Extremen ziehen. Es kann auch ein Mittelwert eingestellt werden.';
$string['started'] = 'gestartet';
$string['startingvalue'] = 'Startwert des Schiebereglers';
$string['startingvalue_help'] = 'Der Startwert des Schiebereglers gibt an, wo der Schieberegler für die Teilnehmer/innen zuerst angezeigt werden soll. Der Standardwert ist 1, da der Bereich unbekannt ist. Möglicherweise möchten Sie in der Mitte des Bereichs beginnen, indem Sie einen zentralen Wert angeben (ein Bereich von 1–100 hat einen zentralen Wert von 50).';
$string['stepvalue'] = 'Inkrementwert des Schiebereglers';
$string['stepvalue_help'] = 'Der Inkrementwert des Schiebereglers gibt an, wie fein die Teilnehmer/innen ihre Antwort innerhalb des Bereichs angeben sollen. Die Frage ist standardmäßig auf einen Bereich von 1–100 mit einer Schrittweite von 1 eingestellt, sodass Werte von 70, 71, 72, 73, 74 usw. angegeben werden können. Sie können aber auch Schrittweiten von fünf festlegen, sodass nur Werte von 60, 65, 70, 75, 80 usw.möglich sind. Sie können auch nur einen Bereich von 1-10 mit Schritten von 1 einstellen.';
$string['strfdate'] = '%d.%m.%Y';
$string['strfdateformatcsv'] = 'd.m.Y H:i:s';
$string['strictdateformatting'] = 'Wählen Sie das Datum über die Kalenderauswahl.';
$string['subject'] = 'Thema';
$string['submissionnotificationhtmlanon'] = 'Jemand hat eine neue <a href="{$a->submissionurl}">Antwort </a> zur Befragung "{$a->name}" abgegeben.';
$string['submissionnotificationhtmluser'] = '"<a href="{$a->profileurl}">{$a->username}</a>" hat eine neue <a href="{$a->submissionurl}">Antwort</a> zur Befragung "{$a->name}" abgegeben.';
$string['submissionnotificationsubject'] = 'Neue Antwort zur Befragung';
$string['submissionnotificationtextanon'] = 'Es wurde eine neue <a href="{$a->submissionurl}">Antwort</a> zur Befragung "{$a->name}" abgegeben.';
$string['submissionnotificationtextuser'] = '"<a href="{$a->profileurl}">{$a->username}</a>" hat eine neue <a href="{$a->submissionurl}">Antwort</a> zur Befragung "{$a->name}" abgegeben.';
$string['submitoptions'] = 'Abgabeoptionen';
$string['submitpreview'] = 'Vorschau der Abgabe';
$string['submitpreviewcorrect'] = 'Diese Antwort wird als richtig ausgefüllt akzeptiert.';
$string['submitsurvey'] = 'Befragung abgeben';
$string['submitted'] = 'Abgegeben:';
$string['subtitle'] = 'Untertitel';
$string['subtitle_help'] = 'Untertitel dieser Befragung, wird unterhalb des Titels (nur auf der ersten Seite) angezeigt.';
$string['summary'] = 'Zusammenfassung';
$string['summaryreportattached'] = 'Zusammenfassender Bericht zur Befragung beigefügt';
$string['surveynotexists'] = 'Die Befragung existiert nicht.';
$string['surveyowner'] = 'Sie müssen Eigentümer/in der Befragung sein, um diesen Vorgang auszuführen.';
$string['surveyresponse'] = 'Antwort der Befragung';
$string['template'] = 'Vorlage';
$string['templatenotviewable'] = 'Vorlagen-Befragungen stehen nicht zur Ansicht zur Verfügung.';
$string['text'] = 'Fragetext';
$string['textareacolumns'] = 'Textbereich Spalten';
$string['textareacolumns_help'] = 'Diese Frage wird ein Feld für unformatierten Text anzeigen (textarea, x columns / y rows) als Angaben für Breite und Menge der Textzeilen.
Werden x und y auf 0 belassen (oder auf 0 gesetzt), dann wird der HTML-Editor mit Standard-Höhe/Breite verwendet (falls im aktuellen Kontext der Berechtigungen verfügbar).';
$string['textarearows'] = 'Textbereich Zeilen';
$string['textbox'] = 'Textfeld';
$string['textbox_help'] = 'Für den Fragetyp **Textfeld** können Sie die "Textfeldlänge" und die "Max. Textlänge" angeben.
Standardmäßig sind 20 Zeichen für die Textfeldlänge und 25 Zeichen für die maximale Textlänge eingestellt.';
$string['textdownloadoptions'] = 'Optionen für das Herunterladen (CSV)';
$string['thank_head'] = 'Danke für das Ausfüllen dieser Befragung.';
$string['theme'] = 'Design';
$string['thismonth'] = 'dieser Monat';
$string['thisresponse'] = 'Diese Antwort';
$string['thisweek'] = 'diese Woche';
$string['thousands'] = 'Kein Tausendertrennzeichen verwenden.';
$string['title'] = 'Titel';
$string['title_help'] = 'Titel der Befragung, der oben auf jeder Seite angezeigt wird.
Standardmäßig ist dies der Name der Befragung, Sie können dies aber bearbeiten und nach Bedarf ändern.';
$string['today'] = 'heute';
$string['total'] = 'absolute Häufigkeit';
$string['totalofnumbers'] = 'Summe aller Antworten';
$string['totalresponses'] = 'Gesamtzahl der abgegebenen Antworten (inkl. unvollständiger Befragungen)';
$string['type'] = 'Typ';
$string['unanswered'] = 'unbeantwortet';
$string['undefinedquestiontype'] = 'Undefinierter Fragetyp';
$string['unknown'] = 'Unbekannt';
$string['unknownaction'] = 'Unbekannte Befragungsaktion angegeben ...';
$string['url'] = 'URL';
$string['url_help'] = 'URL, zu der Nutzer/innen nach Abschluss der Befragung weiter geleitet werden.';
$string['useprivate'] = 'Kopie existiert';
$string['usepublic'] = 'Öffentlich nutzen';
$string['usetemplate'] = 'Vorlage benutzen';
$string['vertical'] = 'Senkrecht';
$string['view'] = 'Anzeigen';
$string['viewallresponses'] = 'Alle Antworten anzeigen';
$string['viewallresponses_help'] = 'Wenn die Befragung im **Gruppenmodus** auf *Sichtbare Gruppen* oder *Getrennte Gruppen* gesetzt ist und der/die aktuelle Nutzer/in das Recht *moodle/site:accessallgroups* hat (im aktuellen Kontext) und im aktuellen Kurs Gruppen definiert wurden, dann haben Nutzer/innen den Zugriff auf eine Dropdown-Liste der Gruppen. Diese Dropdown-Liste ermöglicht es, die Antworten der Befragung nach Gruppen zu filtern. Bei der Einstellung **Gruppenmodus**: *Getrennte Gruppen* haben Nutzer/innen, die nicht das Recht *moodle/site:accessallgroups* haben (meist \'Teilnehmer/in\' oder \'Trainer/in ohne Bearbeitungsrecht\', etc.) nur Zugriff auf die Antworten der Gruppe in die sie selbst eingetragen sind.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Liste der Antworten';
$string['viewindividualresponse'] = 'Individuelle Antworten';
$string['viewindividualresponse_help'] = 'Klicken Sie auf die Namen der Teilnehmer/innen, um deren individuelle Antworten zu sehen.';
$string['viewresponses'] = 'Alle Antworten: ({$a})';
$string['viewyourresponses'] = 'Ihre Antworten anzeigen';
$string['warning'] = 'Warnung: Fehler aufgetreten';
$string['where'] = 'wo';
$string['wronganswers'] = 'Mit den Antworten stimmt etwas nicht. (siehe unten)';
$string['wrongdateformat'] = 'Das eingegebene Datum <strong>{$a}</strong> entspricht nicht dem vorgegebenen Format.';
$string['wrongdaterange'] = 'Fehler: die Jahreszahl muss zwischen 1902 und 2037 liegen.';
$string['wrongformat'] = 'Fehler bei der Antwort zur Frage:';
$string['wrongformats'] = 'Fehler bei der Antwort zur Frage: ';
$string['yesno'] = 'Ja/Nein';
$string['yesno_help'] = 'Einfache Ja/Nein-Frage.';
$string['yourresponse'] = 'Ihre Antworten anzeigen';
$string['yourresponses'] = 'Ihre Antworten anzeigen';
