<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'mn', version '4.5'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Даалгаврын хавсралт';
$string['activitydate:submissionsdue'] = 'Дуусах огноо:';
$string['activitydate:submissionsopen'] = 'Нээх огноо:';
$string['activitydate:submissionsopened'] = 'Нээгдсэн:';
$string['activityeditor'] = 'Үйл ажиллагааны зааварчилгаа';
$string['activityeditor_help'] = 'Энэ даалгаврыг гүйцэтгэхийн тулд суралцагчийн биелүүлэх үйлдлүүд. Энэ нь зөвхөн суралцагч өөрийн даалгаврыг засварлах, хянуулахаар илгээхэд зориулсан мэдүүлэх хуудсанд харагдана.';
$string['activityoverview'] = 'Танд анхаарал хандуулах шаардлагатай даалгавар байна';
$string['addattempt'] = 'Дахин оролдохыг зөвшөөрөх';
$string['addnewattempt'] = 'Шинэ оролдлого нэмэх';
$string['addnewattempt_help'] = 'Энэ нь таныг ажиллахад зориулан шинэ хоосон даалгаврын ноорог үүсгэх болно.';
$string['addnewattemptfromprevious'] = 'Өмнөх илгээсэн даалгавар дээрээ дээрээ суурилж шинээр оролдлого нэмэх';
$string['addnewattemptfromprevious_help'] = 'Энэ нь таныг ажиллахад зориулан өмнө илгээсэн даалгаврын агуулгыг хуулбарласан ноорог даалгавар үүсгэх болно.';
$string['addnewgroupoverride'] = 'Бүлгийн няцаалт нэмэх';
$string['addnewuseroverride'] = 'Хэрэглэгчийн няцаалт нэмэх';
$string['addsubmission'] = 'Даалгаврын гүйцэтгэл нэмэх';
$string['addsubmission_help'] = 'Та одоогоор даалгаврын гүйцэтгэл үүсгээгүй байна.';
$string['allocatedmarker'] = 'Хуваарилсан Тэмдэг';
$string['allocatedmarker_help'] = 'Энэ даалгаврын гүйцэтгэлд тэмдэг хуваарилсан.';
$string['allowsubmissions'] = 'Энэ даалгавар дээр хэрэглэгч даалгаврын гүйцэтгэлээ үргэлжлүүлж хийхийг зөвшөөрнө.';
$string['allowsubmissionsfromdate'] = 'Даалгаврын гүйцэтгэлийг хүлээн авч эхлэх огноо';
$string['allowsubmissionsfromdate_help'] = 'Идэвхжүүлсэн тохиолдолд суралцагч энэ огнооноос өмнө даалгаврын гүйцэтгэл илгээх боломжгүй. Харин идэвхжүүлээгүй тохиолдолд суралцагч яг одооноос даалгаврын гүйцэтгэлээ илгээх боломжтой болно.';
$string['allowsubmissionsshort'] = 'Даалгаврын гүйцэтгэлээ өөрчлөхийг зөвшөөрөх';
$string['alwaysshowdescription'] = 'Талбарыг үргэлж харуулна';
$string['alwaysshowdescription_help'] = 'Идэвхгүй болговол даалгаврын тайлбар нь суралцагчид "Даалгаврын гүйцэтгэлийг хүлээн авч эхлэх огноо"-с хойш харагдах болно.';
$string['applytoteam'] = 'Бүлэгт бүхэлд нь үнэлгээ болон хариу зурвасыг хэрэглэх';
$string['assign:addinstance'] = 'Шинэ даалгавар нэмэх';
$string['assign:editothersubmission'] = 'Бусад суралцагчийн гүйцэтгэсэн даалгаврыг засварлах';
$string['assign:exportownsubmission'] = 'Өөрийн гүйцэтгэсэн даалгаврыг экспорт хийх';
$string['assign:grade'] = 'Даалгаврыг дүгнэх';
$string['assign:grantextension'] = 'Нэмэлт хугацаа олгох';
$string['assign:manageallocations'] = 'Даалгаврын гүйцэтгэлд хуваарилсан тэмдгийг удирдах';
$string['assign:managegrades'] = 'Дүнг хянах, мэдээлэх';
$string['assign:manageoverrides'] = 'Даалгаврын няцаалтыг удирдах';
$string['assign:receivegradernotifications'] = 'Дүгнэгч даалгаврын гүйцэтгэлийг хүлээн авсан мэдэгдэл';
$string['assign:releasegrades'] = 'Дүнг мэдээлэх';
$string['assign:revealidentities'] = 'Суралцагчийн хувийн мэдээллийг харуулах';
$string['assign:reviewgrades'] = 'Дүнг хянах';
$string['assign:showhiddengrader'] = 'Нууц дүгнэгчийн хувийн мэдээллийг харах';
$string['assign:submit'] = 'Даалгавар илгээх';
$string['assign:view'] = 'Даалгаврыг харах';
$string['assign:viewblinddetails'] = 'Даалгаврыг нэргүй илгээхийг идэвхжүүлсэн үед суралцагчийн хувийн мэдээллийг харах боломжтой';
$string['assign:viewgrades'] = 'Дүнг харах';
$string['assign:viewownsubmissionsummary'] = 'Өөрийн илгээсэн даалгаврын хураангуй харах';
$string['assignfeedback'] = 'Хариу өгөх нэмэлт хэрэгсэл';
$string['assignfeedbackpluginname'] = 'Хариу өгөх нэмэлт хэрэгсэл';
$string['assignmentisdue'] = 'Даалгаврын хугацаа дуусах';
$string['assignmentmail'] = 'Таны \'{$a->assignment}\' даалгаврын гүйцэтгэлд {$a->grader} хариу нийтэлсэн байна.

Та үүнийг даалгаврын гүйцэтгэлийн хавсралтаас харах боломжтой:

    {$a->url}';
$string['assignmentmailhtml'] = '<p>Таны \'<i>{$a->assignment} даалгаврын гүйцэтгэлд {$a->grader} хариу нийтэлсэн байна.</i>\'.</p>
<p>Та үүнийг <a href="{$a->url}">даалгаврын гүйцэтгэл</a>ийн хавсралтаас харах боломжтой.</p>';
$string['assignmentmailsmall'] = 'Таны \'{$a->assignment}\' даалгаврын гүйцэтгэлд {$a->grader} хариу нийтэлсэн байна.Та үүнийг даалгаврын гүйцэтгэлийн хавсралтаас харах боломжтой.';
$string['assignmentname'] = 'Даалгаврын нэр';
$string['assignmentplugins'] = 'Даалгаврын нэмэлт хэрэгсэл';
$string['assignmentsperpage'] = 'Хуудас тус бүрийн даалгавар';
$string['assignsubmission'] = 'Даалгаврын гүйцэтгэл илгээх нэмэлт хэрэгсэл';
$string['assignsubmissionpluginname'] = 'Даалгаврын гүйцэтгэл илгээх нэмэлт хэрэгсэл';
$string['assigntimeleft'] = 'Үлдсэн цаг';
$string['attemptheading'] = 'Оролдлого {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Өмнөх оролдлого';
$string['attemptnumber'] = 'Оролдлогын дугаар';
$string['attemptreopenmethod'] = 'Нэмэлт оролдлого';
$string['attemptreopenmethod_help'] = 'Энэ тохиргоо нь суралцагч даалгавар дээр нэмэлт оролдлого хийх боломжтой эсэхийг тодорхойлдог. Оролдлого бүрийн хувьд үнэлгээ болон санал хүсэлтийг хадгалдаг бөгөөд багш, суралцагч үүнийг харах боломжтой. Боломжтой тохиргоо нь:

* Хэзээ ч үгүй - Зөвхөн нэг оролдлого хийх боломжтой.
* Гараар - Багш нэмэлт оролдлого хийхийг зөвшөөрч болно.
* Автоматаар тэнцэх хүртэл - Суралцагч энэ даалгаврын үнэлгээний дэвтэрт заасан тэнцэх оноо авах хүртэл нэмэлт оролдлогыг автоматаар зөвшөөрнө.';
$string['attemptreopenmethod_manual'] = 'Гараар';
$string['attemptreopenmethod_none'] = 'Хэзээ ч үгүй';
$string['attemptreopenmethod_untilpass'] = 'Автоматаар тэнцэх хүртэл';
$string['attemptsettings'] = 'Оролдлогын тохиргоо';
$string['availability'] = 'Ашиглагдах байдал';
$string['back'] = 'Буцах';
$string['backtoassignment'] = 'Даалгавар руу буцах';
$string['batchoperationconfirmaddattempt'] = 'Сонгосон даалгаврын гүйцэтгэлд нэмэлт оролдлогыг зөвшөөрөх үү?';
$string['batchoperationconfirmdownloadselected'] = 'Сонгосон даалгаврын гүйцэтгэлийг татаж авах уу?';
$string['batchoperationconfirmgrantextension'] = 'Бүх сонгосон даалгаврын гүйцэтгэлд нэмэлт хугацаа олгох уу?';
$string['batchoperationconfirmlock'] = 'Бүх сонгосон даалгаврын гүйцэтгэлийг түгжих үү?';
$string['batchoperationconfirmremovesubmission'] = 'Сонгосон даалгаврын гүйцэтгэлийг устгах уу?';
$string['batchoperationconfirmreverttodraft'] = 'Сонгосон даалгаврын гүйцэтгэлийг ноорог болгон буцаах уу?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Бүх сонгосон даалгаврын гүйцэтгэлд тэмдэг оноох уу?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Бүх сонгосон даалгаврын гүйцэтгэлд ажлын урсгалын төлөвийн тэмдэг оноох уу?';
$string['batchoperationconfirmunlock'] = 'Бүх сонгосон даалгаврын гүйцэтгэлийн түгжээг тайлах уу?';
$string['batchoperationlock'] = 'Даалгаврын гүйцэтгэлийг түгжих';
$string['batchoperationreverttodraft'] = 'даалгаврын гүйцэтгэлийг ноорог болгон буцаах';
$string['batchoperationsdescription'] = 'Сонгосон...';
$string['batchoperationunlock'] = 'Даалгаврын гүйцэтгэлийг түгжээг тайлах';
$string['batchsetallocatedmarker'] = 'Сонгосон {$a} хэрэглэгчдэд хуваарилагдсан тэмдэг оноох.';
$string['batchsetmarkingworkflowstateforusers'] = 'Сонгосон {$a} хэрэглэгчийн хувьд ажлын урсгалын төлөвийн тэмдэг оноох.';
$string['beginassignment'] = 'Даалгаврыг эхлүүлэх';
$string['blindmarking'] = 'Даалгаврыг нэргүйгээр илгээх';
$string['blindmarking_help'] = 'Даалгаврыг нэргүйгээр илгээх нь дүгнэгчээс суралцагчийн хувийн мэдээллийг нуудаг. Энэ даалгавартай холбоотой гүйцэтгэл илгээх эсвэл үнэлгээ өгсний дараа нэргүй илгээх тохиргоог түгжих болно.';
$string['blindmarkingenabledwarning'] = 'Энэ үйл ажиллагаанд даалгаврыг нэргүйгээр илгээхийг идэвхжүүлсэн байна. Үнэлгээний үйл ажиллагааны цэсээр сурагчдын хувийн мэдээллийг харуулах хүртэл дүнг журналд нэмэхгүй.';
$string['cachedef_overrides'] = 'Хэрэглэгч болон бүлгийн няцаалтын мэдээлэл';
$string['calendardue'] = '{$a} хугацаа дуусах';
$string['calendargradingdue'] = '{$a}-г дүгнэж байна';
$string['caneditsubmission'] = 'Хугацаа дууссаны дараа та даалгаврын гүйцэтгэлээ засварлаж, илгээх боломжтой боловч хожимдсон гэж тэмдэглэнэ.';
$string['changefilters'] = 'Шүүлтүүрийг өөрчлөх';
$string['changeuser'] = 'Хэрэглэгчийн өөрчлөх';
$string['choosegradingaction'] = 'Дүгнэх үйлдэл';
$string['choosemarker'] = 'Сонгох...';
$string['chooseoperation'] = 'Үйлдэл сонгох';
$string['clickexpandreviewpanel'] = 'Шүүмжийн самбарыг томруулж харахын тулд товшино уу';
$string['collapsegradepanel'] = 'Дүгнэх самбарыг хураах';
$string['collapsereviewpanel'] = 'Хянах самбарыг хураах';
$string['comment'] = 'Сэтгэгдэл';
$string['completiondetail:submit'] = 'Даалгаврын гүйцэтгэл үүсгэх';
$string['completionsubmit'] = 'Суралцагч даалгаврын гүйцэтгэл үүсгэх ёстой';
$string['configshowrecentsubmissions'] = 'Хүн бүр сүүлийн үеийн үйл ажиллагааны тайлангаас ирүүлсэн даалгаврын гүйцэтгэлийн мэдэгдлүүдийг харах боломжтой.';
$string['confirmbatchgradingoperation'] = 'Та {$a->count} оюутанд {$a->operation} үйлдэл хийхийг хүсэж байна уу?';
$string['confirmstart'] = 'Энэ даалгаврыг гүйцэтгэхэд танд {$a} хугацаа байна. Таныг эхлэх үед цагийг эхлүүлэх бөгөөд түр зогсоох боломжгүй болно.';
$string['confirmsubmission'] = 'Та үнэлгээ авахаар ажлаа илгээхийг хүсэж байгаадаа итгэлтэй байна уу? Та цаашид ямар нэгэн өөрчлөлт хийх боломжгүй.';
$string['confirmsubmissionheading'] = 'Даалгаврын гүйцэтгэлийг баталгаажуулах';
$string['conversionexception'] = 'Даалгаврыг хөрвүүлэх боломжгүй байна. Алдаа: {$a}';
$string['couldnotconvertgrade'] = '{$a} хэрэглэгчийн даалгаврын үнэлгээг хөрвүүлж чадсангүй.';
$string['couldnotconvertsubmission'] = '{$a} хэрэглэгчийн даалгаврын гүйцэтгэлийг хөрвүүлж чадсангүй.';
$string['couldnotcreatecoursemodule'] = 'Хичээлийн модуль үүсгэж чадсангүй.';
$string['couldnotcreatenewassignmentinstance'] = 'Шинэ даалгавар үүсгэж чадсангүй.';
$string['couldnotfindassignmenttoupgrade'] = 'Сайжруулах хуучин даалгаврыг олж чадсангүй.';
$string['crontask'] = 'Даалгаврын модулийн арын боловсруулалт';
$string['currentassigngrade'] = 'Даалгаврын одоогийн дүн';
$string['currentattempt'] = '{$a}-р оролдлого.';
$string['currentattemptof'] = '{$a->attemptnumber}-р оролдлого ( нийт {$a->maxattempts} оролдлогыг зөвшөөрнө ).';
$string['currentgrade'] = 'Дүнгийн журнал дээрх одоогийн үнэлгээ';
$string['cutoffdate'] = 'Хязгаарлах огноо';
$string['cutoffdate_help'] = 'Хэрэв утга оноовол энэ өдрөөс хойш даалгаврын гүйцэтгэл илгээх боломжгүй болно (нэмэлт хугацаа өгөхгүй).';
$string['cutoffdatecolon'] = 'Хязгаарлах огноо: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Хязгаарлах огноо нь даалгаврын гүйцэтгэлийг илгээж эхлэх огнооноос өмнө байж болохгүй.';
$string['cutoffdatevalidation'] = 'Хязгаарлах огноо нь дуусах огнооноос өмнө байж болохгүй.';
$string['defaultlayout'] = 'Өгөгдмөл загварыг сэргээх';
$string['defaultsettings'] = 'Даалгаврын өгөгдмөл тохиргоо';
$string['defaultsettings_help'] = 'Энэ нь бүх шинэ даалгаврын өгөгдмөл тохиргоог тодорхойлдог.';
$string['defaultteam'] = 'Өгөгдмөл бүлэг';
$string['deleteallsubmissions'] = 'Бүх даалгаврын гүйцэтгэлийг устгах';
$string['description'] = 'Тодорхойлолт';
$string['disabled'] = 'Идэвхгүй';
$string['downloadall'] = 'Бүх даалгаврын гүйцэтгэлийг татах';
$string['downloadasfolders'] = 'Даалгаврын гүйцэтгэлийг хавтсанд татах';
$string['downloadasfolders_help'] = 'Даалгаврын гүйцэтгэлийг хавтсанд татаж авсан байж магадгүй. Даалгаврын гүйцэтгэл бүрийг тусдаа хавтсанд хийх бөгөөд хавтас нь нэрийг нь өөрчлөх боломжгүй дэд хавтас болон файлуудаас бүтнэ.';
$string['downloadselectedsubmissions'] = 'Сонгосон даалгаврын гүйцэтгэлийг татах';
$string['duedate'] = 'Дуусах огноо';
$string['duedate_help'] = 'Энэ нь даалгавар хэзээ дуусахыг заана. Энэ огнооноос хойш даалгаврын гүйцэтгэлийг илгээх боломжтой байх бөгөөд илгээсэн гүйцэтгэлийг хоцорсон гэж тэмдэглэнэ. Хязгаарлах огноог тодорхойлсноор зааж өгсөн өдрөөс хойш даалгаврын гүйцэтгэл илгээхээс сэргийлэх боломжтой.';
$string['duedatecolon'] = 'Дуусах огноо: {$a}';
$string['duedatereached'] = 'Энэхүү даалгаврын дуусах хугацаа өнгөрсөн байна';
$string['duedatevalidation'] = 'Дуусах хугацаа нь даалгаврын гүйцэтгэлийг илгээж эхлэх өдрөөс өмнө байж болохгүй.';
$string['duplicateoverride'] = 'Няцаалтыг хувилах';
$string['editaction'] = 'Үйлдлүүд...';
$string['editattemptfeedback'] = '{$a} оролдлогын үнэлгээ болон хариуг засна уу.';
$string['editingpreviousfeedbackwarning'] = 'Та өмнөх оролдлогын хариуг засаж байна. Энэ нь {$a->totalattempts} оролдлогоос {$a->attemptnumber} дугаар оролдлого юм.';
$string['editingstatus'] = 'Засах төлөв';
$string['editonline'] = 'Онлайнаар засварлах';
$string['editoverride'] = 'Няцаалтыг засах';
$string['editsubmission'] = 'Даалгаврын гүйцэтгэлийг засах';
$string['editsubmission_help'] = 'Даалгаврын гүйцэтгэлдээ өөрчлөлт хийх боломжтой байна.';
$string['editsubmissionother'] = '{$a} даалгаврын гүйцэтгэлийг засах';
$string['enabled'] = 'Идэвхтэй';
$string['enabletimelimit'] = 'Хугацаатай даалгавруудыг идэвхжүүлэх';
$string['enabletimelimit_help'] = 'Идэвхжүүлсэн тохиолдолд даалгаврын тохиргооны хуудсанд хугацааны хязгаар оноох боломжтой болно.';
$string['errornosubmissions'] = 'Татаж авах даалгаврын гүйцэтгэл байхгүй байна';
$string['errorquickgradingvsadvancedgrading'] = 'Энэ даалгавар ахисан түвшний үнэлгээг ашиглаж байгаа тул үнэлгээг хадгалсангүй.';
$string['errorrecordmodified'] = 'Таныг хуудсыг ачаалснаас хойш хэн нэгэн нэг эсвэл хэд хэдэн бичлэгийг өөрчилсөн тул үнэлгээг хадгалсангүй.';
$string['eventallsubmissionsdownloaded'] = 'Бүх даалгаврын гүйцэтгэлийг татаж байна.';
$string['eventassessablesubmitted'] = 'Даалгаврын гүйцэтгэл илгээгдлээ.';
$string['eventbatchsetmarkerallocationviewed'] = 'Багцад хуваарилсан тэмдгийг үзсэн.';
$string['eventbatchsetworkflowstateviewed'] = 'Багцад оноосон ажлын урсгалын тэмдгийг үзсэн.';
$string['eventextensiongranted'] = 'Нэмэлт хугацаа олгосон.';
$string['eventfeedbackupdated'] = 'Хариуг шинэчилсэн';
$string['eventfeedbackviewed'] = 'Хариуг харсан';
$string['eventgradingformviewed'] = 'Үнэлгээний маягтыг үзсэн';
$string['eventgradingtableviewed'] = 'Үнэлгээний хүснэгтийг үзсэн';
$string['eventidentitiesrevealed'] = 'Хувийн мэдээллийг харуулсан.';
$string['eventmarkerupdated'] = 'Хуваарилсан тэмдгийг шинэчилсэн.';
$string['eventoverridecreated'] = 'Даалгаврын няцаалтыг үүсгэсэн';
$string['eventoverridedeleted'] = 'Даалгаврын няцаалтыг устгасан';
$string['eventoverrideupdated'] = 'Даалгаврын няцаалтыг шинэчилсэн';
$string['eventremovesubmissionformviewed'] = 'Даалгаврын гүйцэтгэлийг баталгаажуулалтыг устгасан.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Хувийн мэдээллийг харуулах баталгаажуулах хуудсыг үзсэн.';
$string['eventstatementaccepted'] = 'Хэрэглэгч даалгаврыг гүйцэтгэсэн баталгааг зөвшөөрсөн.';
$string['eventsubmissionconfirmationformviewed'] = 'Даалгаврын гүйцэтгэлийг баталгаажуулах маягтыг үзсэн.';
$string['eventsubmissioncreated'] = 'Даалгаврын гүйцэтгэл үүссэн.';
$string['eventsubmissionduplicated'] = 'Эдгээр даалгаврыг гүйцэтгэлийг хэрэглэгч хувилсан.';
$string['eventsubmissionformviewed'] = 'Даалгаврын гүйцэтгэлийн маягтыг үзсэн.';
$string['eventsubmissiongraded'] = 'Даалгаврын гүйцэтгэлийг үнэлсэн байна.';
$string['eventsubmissionlocked'] = 'Хэрэглэгчийн хувьд даалгаврын гүйцэтгэлийг түгжсэн байна.';
$string['eventsubmissionremoved'] = 'Даалгаврын гүйцэтгэлийг устгасан.';
$string['eventsubmissionstatusupdated'] = 'Даалгаврын гүйцэтгэлийн төлөвийг шинэчилсэн.';
$string['eventsubmissionstatusviewed'] = 'Даалгаврын гүйцэтгэлийн төлөвийг үзсэн.';
$string['eventsubmissionunlocked'] = 'Хэрэглэгчийн хувьд даалгаврын гүйцэтгэлийг түгжээгүй байна.';
$string['eventsubmissionupdated'] = 'Даалгаврын гүйцэтгэлийг шинэчилсэн.';
$string['eventsubmissionviewed'] = 'Даалгаврын гүйцэтгэлийг үзсэн.';
$string['eventworkflowstateupdated'] = 'Ажлын урсгалын төлөв шинэчлэгдсэн байна.';
$string['expandreviewpanel'] = 'Хяналтын самбарыг дэлгэх';
$string['extensionduedate'] = 'Сунгах огноо';
$string['extensionnotafterduedate'] = 'Сунгах огноо нь дуусах огнооноос хойно байх ёстой';
$string['extensionnotafterfromdate'] = 'Сунгах огноо нь даалгаврын гүйцэтгэл илгээж эхлэх онооноос хойно байх ёстой';
$string['feedback'] = 'Хариу';
$string['feedbackavailableanonhtml'] = '\'<i>{$a->assignment}</i>\' даалгаврын гүйцэтгэлд шинэ хариу ирсэн байна.<br /><br />
Та үүнийг <a href="{$a->url}">даалгаврын гүйцэтгэл</a>ийн хавсралтаас харах боломжтой.';
$string['feedbackavailableanonsmall'] = '{$a->assignment}даалгаврын гүйцэтгэлд шинэ хариу ирсэн байна.';
$string['feedbackavailableanontext'] = '{$a->assignment} даалгаврын гүйцэтгэлд шинэ хариу ирсэн байна.

Та үүнийг даалгаврын гүйцэтгэлийн хавсралтаас харах боломжтой:

{$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} таны {$a->assignment} даалгаврын гүйцэтгэлд хариу өгсөн байна.

Та үүнийг <a href="{$a->url}">даалгаврын гүйцэтгэл</a>ийн хавсралтаас харах боломжтой:

{$a->url}';
$string['feedbackavailablesmall'] = '{$a->username} таны {$a->assignment} даалгаврын гүйцэтгэлд хариу өгсөн байна.';
$string['feedbackavailabletext'] = '{$a->username} таны \'{$a->assignment}\' даалгаврын гүйцэтгэлд хариу өгсөн байна.

Та үүнийг даалгаврын гүйцэтгэлийн хавсралтаас харах боломжтой:

{$a->url}';
$string['feedbackplugin'] = 'Хариу өгөх нэмэлт хэрэгсэл';
$string['feedbackpluginforgradebook'] = 'Хариу өгөх нэмэлт хэрэгсэл нь журналд сэтгэгдэл оруулдаг';
$string['feedbackpluginforgradebook_help'] = 'Зөвхөн нэг даалгаварт хариу өгөх нэмэлт хэрэгсэл нь журналд сэтгэгдэл оруулах боломжтой.';
$string['feedbackplugins'] = 'Хариу өгөх нэмэлт хэрэгсэл';
$string['feedbacksettings'] = 'Хариуны тохиргоо';
$string['feedbacktypes'] = 'Хариуны төрөл';
$string['filesubmissions'] = 'Файл илгээлтүүд';
$string['filter'] = 'Шүүлтүүр';
$string['filterdraft'] = 'Ноорог';
$string['filtergrantedextension'] = 'Сунгасан хугацаа';
$string['filternone'] = 'Шүүлтүүргүй';
$string['filternotsubmitted'] = 'Илгээгээгүй';
$string['filterrequiregrading'] = 'Дүгнэх шаардлагатай';
$string['filtersubmitted'] = 'Илгээсэн';
$string['fixrescalednullgrades'] = 'Энэ даалгаварт алдаатай дүн байна. Та <a href="{$a->link}">Эдгээр дүнг автоматаар засах</a> боломжтой. Энэ нь хичээлийн нийт үнэлгээнд нөлөөлөх магадлалтай.';
$string['fixrescalednullgradesconfirm'] = 'Та алдаатай дүнг автоматаар засахыг хүсэж байна уу? Бүх үнэлэгдсэн дүн хасагдах болно. Энэ нь хичээлийн нийт үнэлгээнд нөлөөлөх магадлалтай.';
$string['fixrescalednullgradesdone'] = 'Дүн засагдсан.';
$string['gradeabovemaximum'] = 'Дүн нь {$a}-с бага буюу тэнцүү байх ёстой.';
$string['gradebelowzero'] = 'Дүн нь тэгээс их буюу тэнцүү байх ёстой.';
$string['gradebreakdown'] = 'Дүнгийн задаргаа';
$string['gradecanbechanged'] = 'Дүнг өөрчлөх боломжтой';
$string['gradechangessaveddetail'] = 'Дүн болон хариуд хийсэн өөрчлөлт хадгалагдсан';
$string['graded'] = 'Дүгнэгдсэн';
$string['gradedby'] = 'Дүгнэсэн:';
$string['gradedfollowupsubmit'] = 'Дүгнэгдсэн - үнэлгээний дараах даалгаврын гүйцэтгэл хүлээн авсан.';
$string['gradedon'] = 'Дүгнэсэн:';
$string['gradeitem:submissions'] = 'Даалгаврын гүйцэтгэл';
$string['gradelocked'] = 'Энэ дүн нь  журналд түгжигдсэн эсвэл хүчингүй болсон';
$string['gradeoutof'] = '{$a} -аас дүгнэх';
$string['gradeoutofhelp'] = 'Дүн';
$string['gradeoutofhelp_help'] = 'Суралцагчийн даалгаврын гүйцэтгэлийн дүнг энд оруулна уу. Та бутархай тоо оруулж болно.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} <i>\'{$a->assignment}\'</i><даалгаврын гүйцэтгэлээ шинэчилсэн. br/><br/>
Үүнийг <a href="{$a->url}">веб хуудас дээрээс үзэх боломжтой</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} <i>\'{$a->assignment}\'</i><даалгаврын гүйцэтгэлээ шинэчилсэн.';
$string['gradersubmissionupdatedtext'] = '{$a->username} <i>\'{$a->assignment}\'</i><даалгаврын гүйцэтгэлээ  {$a->timeupdated}-д шинэчилсэн.

Эндээс үзэж болно:

    {$a->url}';
$string['gradestudent'] = 'Дүгнэх суралцагч:  (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = '{$a}-г дүгнэх';
$string['grading'] = 'Дүгнэж байна';
$string['gradingchangessaved'] = 'Дүнгийн өөрчлөлийг хадгалсан';
$string['gradingduedate'] = 'Дүгнэхийг сануулах огноо:';
$string['gradingduedate_help'] = 'Даалгаврын гүйцэтгэлийг дууссан гэж тэмдэглэх огноо. Энэ огноог багш нарт зориулсан хяналтын самбарын мэдэгдлүүдийг эрэмбэлэх зорилгоор ашигладаг.';
$string['gradingdueduedatevalidation'] = 'Дүгнэхийг сануулах огноо нь дуусах огнооноос өмнө байж болохгүй.';
$string['gradingduefromdatevalidation'] = 'Дүгнэхийг сануулах огноо нь даалгаврын гүйцэтгэл илгээж эхлэх огнооноос өмнө байж болохгүй.';
$string['gradingmethodpreview'] = 'Үнэлэх шалгуур';
$string['gradingoptions'] = 'Сонголтууд';
$string['gradingstatus'] = 'Дүгнэсэн төлөв';
$string['gradingstudent'] = 'Дүгнэсэн оюутан';
$string['gradingsummary'] = 'Дүнгийн хураангуй';
$string['grantextension'] = 'Хугацааг сунгасан';
$string['grantextensionforusers'] = '{$a} суралцагчдад хугацааг сунгасан.';
$string['groupoverrides'] = 'Бүлгийн няцаалт';
$string['groupoverridesdeleted'] = 'Бүлгийн няцаалтыг устгасан';
$string['groupsnone'] = 'Танд хандах боломжтой бүлэг байхгүй байна.';
$string['groupsubmissionsettings'] = 'Бүлгээр хүлээн авах тохиргоо';
$string['hiddenuser'] = 'Оролцогч';
$string['hidegrader'] = 'Суралцагчаас дүгнэгчийн мэдээллийг нуух';
$string['hidegrader_help'] = 'Идэвхжүүлсэн тохиолдолд даалгаврын гүйцэтгэлийг үнэлсэн хэрэглэгчийн мэдээллийг харуулахгүй бөгөөд суралцагч хэн түүний ажлыг үнэлснийг харах боломжгүй.

Энэ тохиргоо нь дүгнэх хуудаст байгаа сэтгэгдлийн талбарт үйлчлэхгүй болохыг анхаарна уу.';
$string['hideshow'] = 'Нуух/Харуулах';
$string['inactiveoverridehelp'] = '* Хэрэглэгчийн үйл ажиллагаанд хандах эрхийг хязгаарласан тул энэ няцаалт идэвхгүй байна. Энэ нь бүлэг эсвэл дүрийн хуваарилалт, бусад хандалтын хязгаарлалт эсвэл нуусан үйл ажиллагаатай холбоотой байж болно.';
$string['indicator:cognitivedepth'] = 'Даалгаврын гүйцэтгэлийн танин мэдэхүйн гүн';
$string['indicator:cognitivedepth_help'] = 'Энэ үзүүлэлт нь суралцагчийн даалгаврын үйл ажиллагаанд хүрсэн танин мэдэхүйн гүнд үндэслэнэ.';
$string['indicator:cognitivedepthdef'] = 'Даалгаврын гүйцэтгэлийн танин мэдэхүйн гүн';
$string['indicator:cognitivedepthdef_help'] = 'Энэ дүн шинжилгээний интервалын хугацаанд Даалгаврын үйл ажиллагаанаас санал болгож буй танин мэдэхүйн оролцоонд хэрэглэгчийн хүрсэн хувь (Түвшин = Үзэх боломжгүй, Үзэх, Илгээх, Хариу харах, Хариунд сэтгэгдэл бичих, Хариуг үзсэний дараа дахин илгээх)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Даалгаврын гүйцэтгэлийн нийгмийн хүрээ';
$string['indicator:socialbreadth_help'] = 'Энэ үзүүлэлт нь суралцагчийн даалгаврын үйл ажиллагаанд хүрсэн нийгмийн хүрээг үндэслэнэ.';
$string['indicator:socialbreadthdef'] = 'Даалгаврын гүйцэтгэлийн нийгмийн хүрээ';
$string['indicator:socialbreadthdef_help'] = 'Энэ дүн шинжилгээний интервалын хугацаанд Даалгаврын үйл ажиллагаанаас санал болгож буй нийгмийн оролцоонд хэрэглэгчийн хүрсэн хувь (Түвшин = Оролцоогүй, Ганцаар оролцсон, Бусадтай хамт оролцсон)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'Зааварчилгаа файл';
$string['introattachments'] = 'Нэмэлт файл';
$string['introattachments_help'] = 'Даалгаварт ашиглах нэмэлт файлыг (жишээлбэл, хариултын загвар) нэмж болно.';
$string['invalidfloatforgrade'] = 'Өгсөн үнэлгээг ойлгохгүй байна: {$a}';
$string['invalidgradeforscale'] = 'Өгсөн үнэлгээ нь одоогийн хэмжүүрийн хувьд хүчингүй байсан';
$string['invalidoverrideid'] = 'Няцаалтын ID хүчингүй байна';
$string['lastmodifiedgrade'] = 'Хамгийн сүүлд өөрчилсөн (дүн)';
$string['lastmodifiedsubmission'] = 'Хамгийн сүүлд өөрчилсөн (даалгаврын гүйцэтгэл)';
$string['latesubmissions'] = 'Хоцорсон даалгаврын гүйцэтгэл';
$string['latesubmissionsaccepted'] = '{$a} хүртэл зөвшөөрсөн';
$string['loading'] = 'Ачаалж байна...';
$string['locksubmissionforstudent'] = 'Суралцагч дахин даалгаврын гүйцэтгэл илгээхээс сэргийлэх: (id={$a->id}, fullname={$a->fullname}).';
$string['locksubmissions'] = 'Даалгаврын гүйцэтгэл илгээхийг түгжсэн';
$string['manageassignfeedbackplugins'] = 'Даалгаврын хариуг удирдах нэмэлт хэрэгсэл';
$string['manageassignsubmissionplugins'] = 'Даалгаврын гүйцэтгэлийг удирдах нэмэлт хэрэгсэл';
$string['marker'] = 'Тэмдэг';
$string['markerfilter'] = 'Шүүлтүүр тэмдэг';
$string['markerfilternomarker'] = 'Тэмдэггүй';
$string['markingallocation'] = 'Хуваарилалтын тэмдэг ашиглах';
$string['markingallocation_help'] = 'Ажлын урсгалын тэмдэгтэй хамт идэвхжүүлвэл тэмдэг нь тухайн суралцагчид хуваарилагдана.';
$string['markingworkflow'] = 'Ажлын урсгалын тэмдэг ашиглах';
$string['markingworkflow_help'] = 'Идэвхжүүлсэн тохиолдолд суралцагчид мэдэгдэхээс өмнө ажлын урсгалын хэд хэдэн үе шатыг дамждаг. Энэ нь хэд хэдэн үе шаттайгаар тэмдэглэгээ хийх боломжийг олгож, бүх суралцагчид нэгэн зэрэг мэдэгдэх боломжийг олгодог.';
$string['markingworkflowstate'] = 'Ажлын урсгалын төлөвийг тэмдэглэх.';
$string['markingworkflowstate_help'] = 'Боломжтой ажлын урсгалын тэмдэг (таны эрхээс хамаарна):

* Тэмдэглээгүй - тэмдэглэгээ хараахан эхлээгүй байна
* Тэмдэглэж байна - тэмдэглэгээ эхэлсэн боловч хараахан дуусаагүй байна
* Тэмдэглэгээ дууссан - тэмдэглэгээ дууссан боловч шалгах/залруулахын тулд буцаж очих шаардлагатай байж магадгүй
* Хянаж байна - тэмдэглэгээг одоо чанарын шалгалтыг хариуцах багшийн мэдэлд байна
* Мэдэгдэхэд бэлэн - хариуцсан багш нь тэмдэглэгээнд сэтгэл хангалуун байгаа боловч оюутнуудад тэмдэгт хандах эрхийг өгөхөөс өмнө хүлээж байна.
* Мэдэгдсэн - оюутан дүн/санал хүсэлтэд хандах боломжтой';
$string['markingworkflowstateinmarking'] = 'Тэмдэглэж байгаа';
$string['markingworkflowstateinreview'] = 'Хянаж байна';
$string['markingworkflowstatenotmarked'] = 'Тэмдэглээгүй';
$string['markingworkflowstatereadyforrelease'] = 'Мэдэгдэхэд';
$string['markingworkflowstatereadyforreview'] = 'Тэмдэглэж дууссан';
$string['markingworkflowstatereleased'] = 'Мэдэгдсэн';
$string['maxattempts'] = 'Оролдлогын хамгийн их тоо';
$string['maxattempts_help'] = 'Суралцагчийн даалгаврын гүйцэтгэлийг илгээж болох хамгийн их тоо. Энэ тоонд хүрсэн тохиолдолд даалгаврын гүйцэтгэл илгээх боломжгүй болно.';
$string['maxgrade'] = 'Хамгийн их үнэлгээ';
$string['maxperpage'] = 'Нэг хуудсанд байх даалгаврын хамгийн их тоо';
$string['maxperpage_help'] = 'Дүгнэгч даалгаврын гүйцэтгэл үнэлэх хуудсанд харах боломжтой даалгаврын хамгийн их тоо. Энэ тохиргоо нь олон тооны оролцогчтой хичээлийн хугацаа хэтрэхээс урьдчилан сэргийлэхэд хэрэгтэй.';
$string['messageprovider:assign_notification'] = 'Даалгаврын мэдэгдэл';
$string['modulename'] = 'Даалгавар';
$string['modulename_help'] = 'Даалгаврын үйл ажиллагааны модуль нь багшид даалгавруудыг дамжуулах, бие даалтын ажил цуглуулах, дүгнэх, хариу өгөх боломжийг олгодог.

Суралцагч модулиар боловсруулсан баримт бичиг, хүснэгтэн файл, зураг, аудио болон видео гэх мэт аливаа файлыг илгээх боломжтой. Мөн суралцагч бичвэр засварлагч ашиглан даалгавар гүйцэтгэх боломжтой. Даалгаврыг суралцагчдад урлагийн бүтээл гэх мэт офлайнаар гүйцэтгэх ёстой файл илгээх шаардлагагүй "бодит ертөнц"-ийн даалгаврыг сануулахад ашиглаж болно. Суралцагч бие даан болон багаар гүйцэтгэсэн даалгавраа илгээж болно.

Даалгаврыг хянахдаа багш нар хариу өгөх, сэтгэгдэл бичих, тайлбар бүхий баримт бичиг (жишээлбэл, суралцагчийн даалгаврын гүйцэтгэл дээр тэмдэглэл хийсэн файл) эсвэл аудио хариу гэх мэт файлуудыг байршуулах боломжтой. Даалгаврыг тоон болон захиалгат маштаб эсвэл рубрикийн үнэлгээний аргыг ашиглан үнэлж болно. Нэгдсэн дүнг журналд тэмдэглэнэ.';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Даалгавар';
$string['moreusers'] = '{$a} илүү...';
$string['multipleteams'] = 'Нэгээс олон бүлгийн гишүүн';
$string['multipleteams_desc'] = 'Даалгаврыг бүлгээр илгээх шаардлагатай. Та нэгээс их бүлгийн гишүүн байна. Илгээхийн тулд та зөвхөн нэг бүлгийн гишүүн байх ёстой. Бүлгийн гишүүнчлэлээ өөрчлөхийн тулд багштайгаа холбоо барина уу.';
$string['multipleteamsgrader'] = 'Нэгээс олон бүлгийн гишүүн байгаа тул даалгаврын гүйцэтгэл илгээх боломжгүй байна.';
$string['newsubmissions'] = 'Даалгаврын гүйцэтгэлийг илгээлээ';
$string['nextuser'] = 'Дараагийн хэрэглэгч';
$string['noattempt'] = 'Оролдлого хийгдээгүй';
$string['noclose'] = 'Хаах огноо байхгүй';
$string['nofiles'] = 'Файл байхгүй';
$string['nofilters'] = 'Шүүлтүүргүй';
$string['nograde'] = 'Үнэлгээ байхгүй';
$string['nogroupoverrides'] = 'Одоогоор бүлгийн няцаалт байхгүй байна';
$string['nomoresubmissionsaccepted'] = 'Зөвхөн хугацааг сунгасан оролцогчдод зөвшөөрнө';
$string['none'] = 'Хоосон';
$string['noonlinesubmissions'] = 'Энэхүү даалгавар нь онлайнаар ямар нэгэн зүйлийг илгээхийг шаарддаггүй';
$string['noopen'] = 'Нээх огноо байхгүй';
$string['nooverridedata'] = 'Даалгаврын ттохиргоонд нэгээс багагүй няцаалт байх ёстой.';
$string['nosavebutnext'] = 'Дараах';
$string['nosubmission'] = 'Энэхүү даалгаварт юу ч илгээгээгүй байна';
$string['nosubmissionyet'] = 'Даалгаврын гүйцэтгэлийг хараахан үүсгээгүй байна';
$string['noteam'] = 'Аль ч бүлгийн гишүүн биш';
$string['noteam_desc'] = 'Энэхүү даалгаврыг бүлэгт илгээх шаардлагатай. Та ямар ч бүлгийн гишүүн биш учир илгээх боломжгүй. Бүлэгт нэмэгдэхийг хүсвэл өөрийн багштай холбоо барина уу.';
$string['noteamgrader'] = 'Ямар нэгэн бүлгийн гишүүн биш тул даалгаврын гүйцэтгэл үүсгэх боломжгүй.';
$string['notgraded'] = 'Дүгнээгүй';
$string['notgradedyet'] = 'Хараахан дүгнээгүй байна';
$string['notifications'] = 'Мэдэгдэл';
$string['nouseroverrides'] = 'Одоохондоо хэрэглэгчийн няцаалт байхгүй байна.';
$string['nousers'] = 'Хэрэглэгч байхгүй';
$string['nousersselected'] = 'Сонгосон хэрэглэгч байхгүй байна';
$string['numberofdraftsubmissions'] = 'Нооргууд';
$string['numberofparticipants'] = 'Оролцогчид';
$string['numberofsubmissionsneedgrading'] = 'Дүгнэх хэрэгтэй';
$string['numberofsubmissionsneedgradinglabel'] = 'Дүгнэх хэрэгтэй: {$a}';
$string['numberofsubmittedassignments'] = 'Илгээсэн';
$string['numberofteams'] = 'Бүлгүүд';
$string['offline'] = 'Онлайн даалгаврын гүйцэтгэл шаардлагагүй';
$string['open'] = 'Нээх';
$string['opensubmissionexists'] = 'Даалгаврын гүйцэтгэлийг аль хэдийн нээсэн байна.';
$string['outlinegrade'] = 'Үнэлгээ: {$a}';
$string['outof'] = '{$a->total} -аас {$a->current}';
$string['overdue'] = 'Даалгаврын хугацаа хэтэрсэн байна: {$a}';
$string['override'] = 'Няцаалт';
$string['overridedeletegroupsure'] = '{$a} бүлгийн няцаалтыг устгахыг хүсэж байна уу?';
$string['overridedeleteusersure'] = '{$a} хэрэглэгчийн няцаалтыг устгахыг хүсэж байна уу?';
$string['overridegroup'] = 'Бүлэг няцаах';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Няцаалтууд';
$string['overrideuser'] = 'Хэрэглэгч няцаах';
$string['overrideusereventname'] = '{$a->assign} - Няцаалт';
$string['page-mod-assign-view'] = 'Даалгаврын модулийн үндсэн хуудас болон илгээх хуудас';
$string['page-mod-assign-x'] = 'Даалгаврын модулийн дурын хуудас';
$string['paramtimeremaining'] = '{$a} үлдсэн';
$string['participant'] = 'Оролцогч';
$string['pluginadministration'] = 'Даалгаврын удирдлага';
$string['pluginname'] = 'Даалгавар';
$string['preventsubmissionnotingroup'] = 'Даалгаврын гүйцэтгэл үүсгэхийн тулд бүлэг шаардлагатай';
$string['preventsubmissionnotingroup_help'] = 'Идэвхжүүлсэн тохиолдолд бүлгийн гишүүн биш бол даалгаврын гүйцэтгэл үүсгэх боломжгүй болно.';
$string['preventsubmissions'] = 'Энэ даалгаварт хэрэглэгч олон гүйцэтгэл илгээхээс сэргийлэх.';
$string['preventsubmissionsshort'] = 'Даалгаврын гүйцэтгэлээ өөрчлөхөөс сэргийлэх';
$string['previous'] = 'Өмнөх';
$string['previoususer'] = 'Өмнөх хэрэглэгч';
$string['privacy:attemptpath'] = 'Оролдлого  {$a}';
$string['privacy:blindmarkingidentifier'] = 'Нэргүй илгээсэн даалгаврын хэрэглэгчийн мэдээлэл';
$string['privacy:gradepath'] = 'дүн';
$string['privacy:metadata:assigndownloadasfolders'] = 'Илгээсэн олон файлыг хавтсанд татаж авах эсэх талаар хэрэглэгчийн сонголт';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Даалгаврын хариу өгөгдөл';
$string['privacy:metadata:assignfilter'] = '\'Илгээсэн\', \'Илгээгүй\', \'Дүгнэх шаардлагатай\', \'Хугацаа сунгасан\' гэх мэт шүүлтүүрийн сонголтууд';
$string['privacy:metadata:assigngrades'] = 'Хэрэглэгчийн тухайн даалгаварт авсан дүнг хадгалдаг';
$string['privacy:metadata:assignmarkerfilter'] = 'Өгсөн даалгаврын нэгтгэлийг оноосон тэмдгээр шүүх';
$string['privacy:metadata:assignmentid'] = 'Даалгаврын ID';
$string['privacy:metadata:assignmessageexplanation'] = 'Зурвас илгээх системээр дамжуулан суралцагчдад зурвас илгээдэг.';
$string['privacy:metadata:assignoverrides'] = 'Даалгаврын няцаалтын мэдээллийг хадгалдаг';
$string['privacy:metadata:assignperpage'] = 'Нэг хуудсанд харуулах даалгаврын тоо';
$string['privacy:metadata:assignquickgrading'] = 'Шуурхай үнэлгээг ашиглах эсэх тэмдэглэгээ';
$string['privacy:metadata:assignsubmissiondetail'] = 'Хэрэглэгчийн даалгаврын гүйцэтгэлийн мэдээллийг хадгалдаг';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Даалгаврын гүйцэтгэлийн өгөгдөл';
$string['privacy:metadata:assignuserflags'] = 'Сунгасан огноо гэх мэт хэрэглэгчийн мета өгөгдлийг хадгалдаг';
$string['privacy:metadata:assignusermapping'] = 'Нэргүй даалгаврын гүйцэтгэлийг харгалзуулах';
$string['privacy:metadata:assignworkflowfilter'] = 'Ялгаатай ажлын урсгалын үе шатаар шүүх';
$string['privacy:metadata:grade'] = 'Энэ даалгаврын гүйцэтгэлийн тоон үнэлгээ. Масштаб/scales/advancedgradingforms гэх мэтээр тодорхойлж болох боловч бутархай тоо руу хөрвүүлэгдэх болно.';
$string['privacy:metadata:grader'] = 'Үнэлгээ өгсөн хэрэглэгчийн ID';
$string['privacy:metadata:groupid'] = 'Тухайн хэрэглэгчийн гишүүнчлэл бүхий бүлгийн ID.';
$string['privacy:metadata:latest'] = 'Сүүлчийн оролдлогын талаарх мэдээллийг мэдэхийг хүссэн асуулгыг хялбаршуулдаг.';
$string['privacy:metadata:mailed'] = 'Энэ хэрэглэгчид шуудангаар илгээж амжсан уу?';
$string['privacy:metadata:timecreated'] = 'Хугацааг үүсгэсэн';
$string['privacy:metadata:timestarted'] = 'Хугацаа эхэлсэн';
$string['privacy:metadata:userid'] = 'Хэрэглэгчийн ID';
$string['privacy:studentpath'] = 'суралцагчийн даалгаврын гүйцэтгэл';
$string['privacy:submissionpath'] = 'даалгаврын гүйцэтгэл';
$string['quickgrading'] = 'Шуурхай үнэлгээ';
$string['quickgrading_help'] = 'Шуурхай үнэлгээ нь дүнг (болон үр дүнг) даалгаврын гүйцэтгэлийн хүснэгтэд шууд тодорхойлох боломжийг олгодог. Шуурхай үнэлгээ нь ахисан түвшний үнэлгээнд тохирохгүй бөгөөд олон тэмдэглэгээтэй үед хэрэглэхийг зөвлөдөггүй.';
$string['quickgradingchangessaved'] = 'Дүнгийн өөрчлөлт хадгалагдлаа';
$string['quickgradingresult'] = 'Шуурхай үнэлгээ';
$string['recordid'] = 'Хувийн мэдээлэл';
$string['relativedatessubmissiontimeleft'] = 'Бүх суралцагчийн хувьд тооцоолсон';
$string['removeallgroupoverrides'] = 'Бүх бүлгийн няцаалтыг устгах';
$string['removealluseroverrides'] = 'Бүх хэрэглэгчийн няцаалтыг устгах';
$string['removesubmission'] = 'Даалгаврын гүйцэтгэлийг устгах';
$string['removesubmissionconfirm'] = 'Даалгаварт илгээсэн гүйцэтгэлээ устгахыг хүсэж байна уу?';
$string['removesubmissionconfirmforstudent'] = '{$a} даалгаварт илгээсэн гүйцэтгэлээ устгахыг хүсэж байна уу?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = '{$a} даалгаварт илгээсэн гүйцэтгэлээ устгахыг хүсэж байна уу? Үүний үр дүнд суралцагчийн хугацааны хязгаар өөрчлөгдөхгүй гэдгийг анхаарна уу. Хугацааны хязгаарыг хэрэглэгчийн няцаалтад оруулснаар та илүү их цаг өгөх боломжтой.';
$string['removesubmissionconfirmwithtimelimit'] = 'Даалгаварт илгээсэн гүйцэтгэлээ устгахыг хүсэж байна уу? Үүний үр дүнд суралцагчийн хугацааны хязгаар өөрчлөгдөхгүй гэдгийг анхаарна уу.';
$string['removesubmissionforstudent'] = 'Суралцагчийн даалгаврын гүйцэтгэлийг устгах: (id={$a->id}, fullname={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Суралцагчийн хувийн мэдээллийг харуултал дүнг журналд тэмдэглэхгүй тул тэнцэх сонголт нь нэргүй илгээлттэй нийцэхгүй болтол дахин нээнэ үү.';
$string['requireallteammemberssubmit'] = 'Бүх бүлгийн гишүүд илгээхийг шаардах';
$string['requireallteammemberssubmit_help'] = 'Идэвхжүүлсэн бол бүлгийн илгээлтийг илгээсэн гэж тооцохоос өмнө бүлгийн бүх гишүүд энэ даалгаврыг илгээх товчийг дарах ёстой. Хэрэв идэвхжүүлээгүй тохиолдолд бүлгийн аль нэг гишүүн илгээх товчийг дарснаар бүлгийн илгээлтийг илгээсэн гэж үзнэ.';
$string['requiresubmissionstatement'] = 'Даалгаврын гүйцэтгэлийн баталгааг суралцагч зөвшөөрөх шаардлагатай';
$string['requiresubmissionstatement_help'] = 'Энэ даалгаварт илгээсэн бүх даалгаврын гүйцэтгэлд суралцагч баталгааг зөвшөөрөх шаардлагатай';
$string['revealidentities'] = 'Суралцагчийн хувийн мэдээллийг буцаах';
$string['revealidentitiesconfirm'] = 'Энэ даалгаврын суралцагчийн хувийн мэдээллийг харуулахыг хүсэж байна уу? Энэ үйлдлийг буцаах боломжгүй. Суралцагчийн хувийн мэдээллийг ил харуулсны дараа дүнг журналд оруулна.';
$string['reverttodefaults'] = 'Өгөгдмөл даалгаврын гүйцэтгэл рүү буцаах';
$string['reverttodraft'] = 'Даалгаврын гүйцэтгэлийг ноорог төлөв рүү буцаах';
$string['reverttodraftforgroup'] = 'Даалгаврын гүйцэтгэлийг {$a} бүлгийн ноорог руу буцаах.';
$string['reverttodraftforstudent'] = 'Суралцагчийн даалгаврын гүйцэтгэлийг ноорог руу буцаах: (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Даалгаврын гүйцэтгэлийг ноорог руу буцаах';
$string['reviewed'] = 'Хянагдсан';
$string['save'] = 'Хадгалах';
$string['saveallquickgradingchanges'] = 'Бүх шуурхай үнэлгээний өөрчлөлтийг хадгалах';
$string['saveandcontinue'] = 'Хадгалаад үргэлжлүүлэх';
$string['savechanges'] = 'Өөрчлөлтийг хадгалах';
$string['savegradingresult'] = 'Дүн';
$string['savenext'] = 'Хадгалаад дараачийнхыг харуулах';
$string['saveoverrideandstay'] = 'Хадгалаад өөр няцаалт оруулах';
$string['savingchanges'] = 'Өөрчлөлтийг хадгалж байна...';
$string['scale'] = 'Хэмжээст';
$string['search:activity'] = 'Даалгавар - үйл ажиллагааны мэдээлэл';
$string['selectedusers'] = 'Сонгогдсон хэрэглэгчид';
$string['selectlink'] = 'Сонгох...';
$string['selectuser'] = '{$a}-г сонгох';
$string['sendlatenotifications'] = 'Хоцорсон даалгаврын гүйцэтгэл илгээсэн тухай дүгнэгчид мэдэгдэх';
$string['sendlatenotifications_help'] = 'Идэвхжүүлсэн бол суралцагч даалгаврын гүйцэтгэлээ хоцорч илгээсэн тохиолдол бүрд дүгнэгч (ихэвчлэн багш) зурвас хүлээн авна. Зурвасын аргыг тохируулах боломжтой.';
$string['sendnotifications'] = 'Даалгаврын гүйцэтгэл илгээсэн тухай дүгнэгчид мэдэгдэх';
$string['sendnotifications_help'] = 'Идэвхжүүлсэн бол суралцагч даалгаврын гүйцэтгэлээ илгээх бүрд дүгнэгч (ихэвчлэн багш) зурвас хүлээн авна. Зурвасын аргыг тохируулах боломжтой.';
$string['sendstudentnotifications'] = 'Суралцагчид мэдэгдэх';
$string['sendstudentnotifications_help'] = 'Үнэлгээ эсвэл хариу өөрчлөгдөх бүрд мэдэгдэл илгээхийн тулд энэ нүдийг чагтална уу. Хэрэв даалгавар нь ажлын урсгалын тэмдгээр тэмдэглэгдсэн эсвэл үнэлгээний тайланд дүнг нуусан бол дүнг харуулах хүртэл мэдэгдэл илгээхгүй.';
$string['sendstudentnotificationsdefault'] = '\'Суралцагчид мэдэгдэх\' өгөгдмөл тохиргоо';
$string['sendstudentnotificationsdefault_help'] = 'Суралцагч тус бүрийг дүгнэх үед \'Суралцагчид мэдэгдэх\'-ийг өгөгдмөлөөр чагтлах уу?';
$string['sendsubmissionreceipts'] = 'Суралцагч руу даалгаврын гүйцэтгэл хүлээн авсан баримт илгээх';
$string['sendsubmissionreceipts_help'] = 'Энэ шилжүүлэгч нь суралцагчид даалгаврын гүйцэтгэл илгээсэн баримт хүлээн авах боломжийг олгодог. Суралцагч даалгавраа амжилттай илгээх бүрдээ мэдэгдэл хүлээн авах болно.';
$string['setmarkerallocationforlog'] = 'Тэмдэг хуваарилах: (id={$a->id}, fullname={$a->fullname}, marker={$a->marker}).';
$string['setmarkingallocation'] = 'Хуваарилсан тэмдэг оноох';
$string['setmarkingworkflowstate'] = 'Ажлын урсгалыг тэмдэглэж буй төлөв оноох';
$string['setmarkingworkflowstateforlog'] = 'Ажлын урсгалыг тэмдэглэж буй төлөв оноох: (id={$a->id}, fullname={$a->fullname}, state={$a->state}).';
$string['settings'] = 'Даалгаврын тохиргоо';
$string['showrecentsubmissions'] = 'Сүүлийн даалгаврын гүйцэтгэлүүдийг харуулах';
$string['status'] = 'Төлөв';
$string['studentnotificationworkflowstateerror'] = 'Суралцагчид мэдэгдэхийн тулд ажлын урсгалын төлөвийн тэмдэг нь "Мэдэгдсэн" байх ёстой.';
$string['submission'] = 'Даалгаврын гүйцэтгэл';
$string['submissionattachments'] = 'Зөвхөн даалгаврын гүйцэтгэл илгээж байх үед файлыг харуулах';
$string['submissionattachments_help'] = 'Зөвхөн мэдүүлэх хуудсан дээрх файлуудыг харуулахын тулд нүдийг чагтална уу. Үгүй бол даалгаврын болон мэдүүлэх хуудасны аль алинд нь файлуудыг харуулах болно.';
$string['submissioncopiedhtml'] = '<p>Та  \'<i>{$a->assignment}</i>\'-д өмнө илгээсэн даалгаврын гүйцэтгэлийн хуулбарыг хийсэн байна.</p>
<p>Та  <a href="{$a->url}">даалгаврын гүйцэтгэл илгээсэн</a> төлөвөө харж болно.</p>';
$string['submissioncopiedsmall'] = 'Та {$a->assignment}-д өмнө илгээсэн даалгаврын гүйцэтгэлийн хуулбарыг хийсэн байна';
$string['submissioncopiedtext'] = 'Та \'{$a->assignment}\'-д өмнө илгээсэн даалгаврын гүйцэтгэлийн хуулбарыг хийсэн байна

Та даалгавраа илгээсэн төлөвийг харж болно:

     {$a->url}';
$string['submissiondrafts'] = 'Суралцагч илгээх товчийг дарах шаардлагатай';
$string['submissiondrafts_help'] = 'Идэвхжүүлсэн тохиолдолд суралцагч илгээх товчийг дарж, эцсийн байдлаар илгээсэн гэж мэдэгдэнэ. Энэ нь суралцагчид даалгаврын гүйцэтгэлийн ноорог хувилбарыг систем дээр хадгалах боломжийг олгодог. Суралцагч аль хэдийн даалгаврын гүйцэтгэлээ илгээсний дараа энэ тохиргоог "Үгүй"-ээс "Тийм" болгон өөрчилсөн тохиолдолд тэдгээр гүйцэтгэлийг эцсийнх гэж үзнэ.';
$string['submissioneditable'] = 'Суралцагч энэ даалгаврын гүйцэтгэлээ засварлах боломжтой';
$string['submissionempty'] = 'Ямар нэг зүйл илгээгээгүй байна';
$string['submissionlog'] = 'Суралцагч: {$a->fullname}, Төлөв: {$a->status}';
$string['submissionmodified'] = 'Танд даалгавар гүйцэтгэлийн өгөгдөл байна. Энэ хуудсыг орхиод дахин оролдоно уу.';
$string['submissionmodifiedgroup'] = 'Даалгаврын гүйцэтгэлийг хэн нэгэн өөрчилсөн байна. Энэ хуудсыг орхиод дахин оролдоно уу.';
$string['submissionnotcopiedinvalidstatus'] = 'Даалгаврын гүйцэтгэлийг нээснээс хойш засварласан байгаа тул хуулах боломжгүй байна.';
$string['submissionnoteditable'] = 'Суралцагч энэхүү даалгаврын гүйцэтгэлийг засах боломжгүй';
$string['submissionnotopen'] = 'Даалгаварт гүйцэтгэл илгээхээр нээгээгүй байна';
$string['submissionnotready'] = 'Даалгаварт гүйцэтгэл илгээх боломжгүй байна:';
$string['submissionplugins'] = 'Даалгаврын гүйцэтгэл илгээх нэмэлт хэрэгсэл';
$string['submissionreceipthtml'] = '<p>Та \'<i>{$a->assignment}</i>\' даалгаврын гүйцэтгэлийг илгээсэн байна.</p>
<p>Даалгаварт илгээсэн гүйцэтгэлийн төлөвийг <a href="{$a->url}">эндээс</a> харах боломжтой.</p>';
$string['submissionreceiptotherhtml'] = 'Таны \'<i>{$a->assignment}</i>\' даалгаврын гүйцэтгэлийг илгээсэн.<br /><br />
Даалгаварт илгээсэн гүйцэтгэлийн төлөвийг <a href="{$a->url}">эндээс</a> харах боломжтой.';
$string['submissionreceiptothersmall'] = 'Таны {$a->assignment} даалгаврын гүйцэтгэлийг илгээсэн.';
$string['submissionreceiptothertext'] = 'Таны \'{$a->assignment}\' даалгаврын гүйцэтгэлийг илгээсэн.

Даалгаварт илгээсэн гүйцэтгэлийн төлөвийг харах боломжтой:

    {$a->url}';
$string['submissionreceipts'] = 'Даалгаврын гүйцэтгэл хүлээн авсан баримт илгээх';
$string['submissionreceiptsmall'] = 'Та {$a->assignment} даалгаврын гүйцэтгэлийг илгээсэн байна.';
$string['submissionreceipttext'] = 'Та \'{$a->assignment}\' даалгаврын гүйцэтгэлийг илгээсэн байна.

Даалгаварт илгээсэн гүйцэтгэлийн төлөвийг харах боломжтой:

    {$a->url}';
$string['submissionsclosed'] = 'Даалгаврын гүйцэтгэл илгээхийг хаасан';
$string['submissionsettings'] = 'Даалгаврын гүйцэтгэл илгээх тохиргоо';
$string['submissionslocked'] = 'Энэхүү даалгавар нь даалгаврын гүйцэтгэл хүлээн авахгүй байна';
$string['submissionslockedshort'] = 'Даалгаврын гүйцэтгэлийг өөрчлөхийг зөвшөөрөөгүй';
$string['submissionstatement'] = 'Даалгаврыг гүйцэтгэсэн баталгаа';
$string['submissionstatement_help'] = 'Суралцагч бүр өөрийн ажлыг илгээхийн тулд баталгааг зөвшөөрөх ёстой.';
$string['submissionstatementacceptedlog'] = 'Хэрэглэгч {$a} даалгаврыг гүйцэтгэсэн баталгааг зөвшөөрсөн';
$string['submissionstatementdefault'] = 'Би энэхүү даалгаварт бусад хүмүүсийн бүтээлийг ашигласан бол тэдгээрийг ашигласан тухай дурдсан бөгөөд бусад нь миний ажил юм.';
$string['submissionstatementteamsubmission'] = 'Бүлгээр даалгаврыг гүйцэтгэсэн баталгаа';
$string['submissionstatementteamsubmission_help'] = 'Суралцагч бүр өөрийн бүлгийн ажлыг илгээхийн тулд баталгааг зөвшөөрөх ёстой.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Бүлгийн бүх гишүүдийн илгээх багаар даалгаврыг гүйцэтгэсэн баталгаа';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Суралцагч бүр өөрийн бүлгийн ажлыг бүлгийн гишүүний хувиар илгээхийн тулд баталгааг зөвшөөрөх ёстой.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Би энэхүү даалгаварт бусад хүмүүсийн бүтээлийг ашигласан бол тэдгээрийг ашигласан тухай дурдсан бөгөөд бусад нь багийн гишүүний хувьд миний гүйцэтгэсэн ажил юм.';
$string['submissionstatementteamsubmissiondefault'] = 'Бид энэхүү даалгаварт бусад хүмүүсийн бүтээлийг ашигласан бол тэдгээрийг ашигласан тухай дурдсан бөгөөд бусад нь бидний гүйцэтгэсэн ажил юм.';
$string['submissionstatus'] = 'Даалгаврын гүйцэтгэлийн төлөв';
$string['submissionstatus_'] = 'Илгээсэн зүйл байхгүй';
$string['submissionstatus_draft'] = 'Ноорог (илгээгдээгүй)';
$string['submissionstatus_marked'] = 'Дүгнэгдсэн';
$string['submissionstatus_new'] = 'Даалгаврын гүйцэтгэл байхгүй';
$string['submissionstatus_reopened'] = 'Дахин нээсэн';
$string['submissionstatus_submitted'] = 'Дүгнүүлэхээр илгээсэн';
$string['submissionstatusheading'] = 'Даалгаврын гүйцэтгэлийн төлөв';
$string['submissionsummary'] = '{$a->status}. Хамгийн сүүлд {$a->timemodified}-д өөрчилсөн';
$string['submissionteam'] = 'Бүлэг';
$string['submissiontypes'] = 'Даалгаврын гүйцэтгэлийн хэлбэр';
$string['submitaction'] = 'Илгээх';
$string['submitassignment'] = 'Даалгаврын гүйцэтгэлийн илгээх';
$string['submitassignment_help'] = 'Даалгаврын гүйцэтгэлийг илгээсэн тохиолдолд та ямар нэгэн өөрчлөлт хийх боломжгүй болно.';
$string['submitforgrading'] = 'Дүгнүүлэхээр илгээх';
$string['submitted'] = 'Илгээсэн';
$string['submittedearly'] = 'Даалгаврын гүйцэтгэлийг {$a} эрт илгээсэн байна';
$string['submittedlate'] = 'Даалгаврын гүйцэтгэлийг {$a} оройтуулж илгээсэн байна';
$string['submittedlateshort'] = '{$a} хоцорсон';
$string['submittedovertime'] = 'Даалгаврын гүйцэтгэлийг {$a} хугацааны хязгаарыг хэтрүүлж илгээсэн байна';
$string['submittedundertime'] = 'Даалгаврын гүйцэтгэлийг {$a} хугацааны хязгаар дотор илгээсэн байна';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Хариу өгөх нэмэлт хэрэгсэл';
$string['subplugintype_assignfeedback_plural'] = 'Хариу өгөх нэмэлт хэрэгсэл';
$string['subplugintype_assignsubmission'] = 'Даалгаврын гүйцэтгэл илгээх нэмэлт хэрэгсэл';
$string['subplugintype_assignsubmission_plural'] = 'Даалгаврын гүйцэтгэл илгээх нэмэлт хэрэгсэл';
$string['teamname'] = 'Баг: {$a}';
$string['teamsubmission'] = 'Суралцагчид бүлэг болж илгээнэ';
$string['teamsubmission_help'] = 'Хэрэв идэвхжүүлсэн бол суралцагчдыг өгөгдмөл бүлгүүд эсвэл тусгай бүлэгт тулгуурлан бүлгүүдэд хуваана. Бүлгийн даалгаврын гүйцэтгэлийг бүлгийн гишүүд дундаа хуваалцах бөгөөд бүлгийн бүх гишүүд бие биеийнхээ даалгаврын гүйцэтгэлд оруулсан өөрчлөлтийг харах болно.';
$string['teamsubmissiongroupingid'] = 'Суралцагчийн бүлгүүдийг бүлэглэх';
$string['teamsubmissiongroupingid_help'] = 'Энэ нь суралцагчдын бүлгүүдээс даалгаврыг гүйцэтгэхэд зориулан үүсгэсэн бүлэг юм. Хэрэв тохируулаагүй бол өгөгдмөл бүлгүүдийг ашиглана.';
$string['textinstructions'] = 'Даалгаврын зааварчилгаа';
$string['timelimit'] = 'Хугацааны хязгаар';
$string['timelimit_help'] = 'Идэвхжүүлсэн бол даалгаврын хуудсан дээр хугацааны хязгаарыг харуулах ба даалгаврын явцад цагийг доош нь тоолж харуулна.';
$string['timelimitnotenabled'] = 'Даалгаварт хугацааны хязгаарыг идэвхжүүлээгүй байна';
$string['timelimitpassed'] = 'Хугацааны хязгаар дууссан байна';
$string['timemodified'] = 'Хамгийн сүүлд өөрчлөгдсөн';
$string['timeremaining'] = 'Үлдсэн хугацаа';
$string['timeremainingcolon'] = 'Үлдсэн хугацаа: {$a}';
$string['togglezoom'] = 'Мужийг томруулах/жижгэрүүлэх';
$string['ungroupedusers'] = '\'Даалгаврын гүйцэтгэлийг бүлгээр үүсгэхийг шаардах\' тохиргоог идэвхжүүлсэн байгаа бөгөөд зарим хэрэглэгч аль ч бүлгийн гишүүн биш эсвэл нэгээс олон бүлгийн гишүүн тул илгээх боломжгүй байна.';
$string['ungroupedusersoptional'] = '"Суралцагч бүлэг болж илгээх" тохиргоог идэвхжүүлсэн бөгөөд зарим хэрэглэгчид аль ч бүлгийн гишүүн биш эсвэл нэгээс олон бүлгийн гишүүн байна. Эдгээр суралцагч \'Өгөгдмөл бүлгийн\' гишүүнээр байдлаар илгээх болно гэдгийг анхаарна уу.';
$string['unlimitedattempts'] = 'Хязгааргүй';
$string['unlimitedattemptsallowed'] = 'Хязгааргүй оролдлого зөвшөөрнө';
$string['unlimitedpages'] = 'Хязгааргүй';
$string['unlocksubmissionforstudent'] = 'Дараах суралцагчид даалгаврын гүйцэтгэл илгээхийг зөвшөөрөх: (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'Даалгаврын гүйцэтгэлийн түгжээх тайлах';
$string['unsavedchanges'] = 'Хадгалаагүй өөрчлөлтүүд';
$string['unsavedchangesquestion'] = 'Дүн болон хариуны өөрчлөлтийг хадгалаагүй байна. Та өөрчлөлтийг хадгалж, үргэлжлүүлэх үү?';
$string['updategrade'] = 'Дүнг шинэчлэх';
$string['updatetable'] = 'Хүснэгтийг хадгалах, шинэчлэх';
$string['upgradenotimplemented'] = '({$a->type} {$a->subtype}) нэмэлт хэрэгсэлд шинэчлэлт хийгдээгүй';
$string['userassignmentdefaults'] = 'Хэрэглэгчийн өгөгдмөл даалгавар';
$string['userextensiondate'] = '{$a} хүртэл хугацааг сунгасан';
$string['usergrade'] = 'Хэрэглэгчийн дүн';
$string['useridlistnotcached'] = 'Дүнгийн өөрчлөлтийг аль ангилалд оруулахыг тодорхойлох боломжгүй байсан тул хадгалсангүй.';
$string['useroverrides'] = 'Хэрэглэгчийн няцаалт';
$string['useroverridesdeleted'] = 'Хэрэглэгчийн няцаалтыг устгасан';
$string['usersnone'] = 'Энэ даалгаварт хандах эрхтэй суралцагч байхгүй байна.';
$string['usersubmissioncannotberemoved'] = '{$a} даалгаврын гүйцэтгэлийг устгаж чадсангүй.';
$string['userswhoneedtosubmit'] = 'Илгээх хэрэгтэй хэрэглэгчид: {$a}';
$string['validmarkingworkflowstates'] = 'Хүчинтэй тэмдэглэх ажлын урсгалын төлөв';
$string['viewadifferentattempt'] = 'Ялгаатай оролдлого харах';
$string['viewbatchmarkingallocation'] = 'Багцад оноосон тэмдэг хуваарилалтын хуудсыг харах.';
$string['viewbatchsetmarkingworkflowstate'] = 'Багцад оноосон тэмдгийн ажлын урсгалын төлөвийн хуудсыг харах.';
$string['viewfeedback'] = 'Хариу харах';
$string['viewfeedbackforuser'] = '{$a} хэрэглэгчийн хариу харах';
$string['viewfull'] = 'Бүтэн харах';
$string['viewfullgradingpage'] = 'Хариу өгөхийн тулд үнэлэх хуудсыг бүрэн нээнэ үү';
$string['viewgradebook'] = 'Дүнгийн журнал харах';
$string['viewgrading'] = 'Бүх даалгаврын гүйцэтгэл харах';
$string['viewgradingformforstudent'] = 'Дараах суралцагчийг үнэлэх хуудсыг харах: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Өөрийн даалгаврын гүйцэтгэл илгээх хуудсыг харах';
$string['viewownsubmissionstatus'] = 'Өөрийн оруулсан даалгаврын төлвийн хуудсыг харах';
$string['viewrevealidentitiesconfirm'] = 'Суралцагчийн хувийн мэдээлэл харуулахыг баталгаажуулах хуудсыг харах';
$string['viewsubmission'] = 'Даалгаврын гүйцэтгэл харах';
$string['viewsubmissionforuser'] = '{$a} хэрэглэгчийн даалгаврын гүйцэтгэл харах';
$string['viewsubmissiongradingtable'] = 'Даалгаврын гүйцэтгэлийн дүнгийн хүснэгт харах';
$string['viewsummary'] = 'Дүгнэлт харах';
$string['workflowfilter'] = 'Ажлын урсгалын шүүлтүүр';
$string['xofy'] = '{$a->x} of {$a->y}';
