<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'mn', version '4.5'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'суулгах гэж байна';
$string['accept'] = 'Зөвшөөрөх';
$string['action'] = 'Үйлдэл';
$string['actionchoice'] = 'Та \'{$a}\' энэ файлд юу хиймээр байна вэ?';
$string['actions'] = 'Үйлдлүүд';
$string['actionsfor'] = '{$a}-ын үйлдлүүд';
$string['actionsmenu'] = 'Үйлдлийн цэс';
$string['active'] = 'Идэвхтэй';
$string['activeusers'] = 'Идэвхтэй хэрэглэгчид';
$string['activities'] = 'Үйл ажиллагаа';
$string['activities_help'] = 'Хэлэлцүүлэг, куиз, вики зэрэг ажилбарууд нь хичээлд интерактив агуулга оруулах боломжтой болгодог.';
$string['activity'] = 'Үйл ажиллагаа';
$string['activityclipboard'] = 'Энэ үйлдлийг зөөх: <b>{$a}</b>';
$string['activityheader'] = 'Үйл ажиллагааны цэс';
$string['activityiscurrentlyhidden'] = 'Уучлаарай, энэ үйлдэлийг одоогоор нуусан байна';
$string['activitymodule'] = 'Ажилбарын модуль';
$string['activitymodules'] = 'Ажилбарын модулиуд';
$string['activitynotready'] = 'Үйл ажиллагаа хараахан бэлэн биш байна';
$string['activityreport'] = 'Ажилбарын тайлан';
$string['activityreports'] = 'Үйл ажиллагааны тайлангууд';
$string['activityselect'] = 'Өөр газарт зөөх гэж буй үйлдлийг сонгоно уу';
$string['activitysince'] = '{$a}-аас хойшхи үйл ажиллагаа';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Нэг хэрэглэгчид ноогдох үйлдэл';
$string['add'] = 'Нэмэх';
$string['addactivity'] = 'Ажилбар нэмэх ...';
$string['addactivitytosection'] = '\'{$a}\' бүлэгт шинээр ажилбар нэмэх';
$string['addadmin'] = 'Администратор нэмэх';
$string['addblock'] = 'Блок нэмэх';
$string['addcomment'] = 'Тайлбар нэмэх ...';
$string['addcondition'] = 'Нөхцөл нэмэх';
$string['addcountertousername'] = 'Хэрэглэгчийн нэрд дугаар нэмэх байдлаар хэрэглэгч үүсгэх';
$string['addcreator'] = 'Хичээл үүсгэгч нэмэх';
$string['adddots'] = 'Нэмэх ...';
$string['added'] = '{$a} нэмсэн';
$string['addedtogroup'] = '"{$a}" бүлэгт нэмлээ';
$string['addedtogroupnot'] = '"{$a}" бүлэгт нэмэгдсэнгүй';
$string['addedtogroupnotenrolled'] = '"{$a}" бүлэгт нэмэгдсэнгүй, учир нь курст бүртгүүлээгүй байна.';
$string['addfilehere'] = 'Энд файл нэмэх';
$string['addinganew'] = 'Шинэ {$a} нэмж байна';
$string['addinganewto'] = '{$a->to} руу шинэ {$a->what} нэмж байна';
$string['addingdatatoexisting'] = 'Дараахад мэдээлэл нэмж байна:';
$string['additionalcustomnav'] = 'Нэмэлт захиалгат удирдлагын мөр';
$string['additionalnames'] = 'Нэмэлт нэрүүд';
$string['addlinkhere'] = 'Энд холбоос нэмэх';
$string['addnew'] = 'Шинэ {$a} нэмэх';
$string['addnewcategory'] = 'Шинэ ангилал нэмэх';
$string['addnewcourse'] = 'Шинэ хичээл нэмэх';
$string['addnewuser'] = 'Шинэ хэрэглэгч нэмэх';
$string['addnousersrecip'] = 'Хүлээн авагчийн жагсаалтад {$a} руу нэвтэрч амжаагүй хэрэглэгчийг нэмэх';
$string['addpagehere'] = 'Текстийг энд оруул';
$string['addresource'] = 'Эх сурвалж нэмэх ...';
$string['addresourceoractivity'] = 'Үйл ажиллагаа эсвэл агуулга нэмэх';
$string['addresourcetosection'] = '\'{$a}\' хэсэгт эх сурвалж нэмэх';
$string['address'] = 'Хаяг';
$string['addsections'] = 'Хэсгийг нэмэх';
$string['addstudent'] = 'Суралцагч нэмэх';
$string['addsubcategory'] = 'Дэд ангилал нэмэх';
$string['addteacher'] = 'Багш нэмэх';
$string['admin'] = 'Админ';
$string['adminhelpaddnewuser'] = 'Шинэ хэрэглэгчийн бүртгэлийг гараар үүсгэхийн тулд';
$string['adminhelpassignadmins'] = 'Админ нь энэ сайтын аль ч хэсэгт юуг ч өөрчлөх эрхтэй';
$string['adminhelpassigncreators'] = 'Курс зохиогчид нь шинээр курс үүсгэх боломжтой';
$string['adminhelpassignsiteroles'] = 'Тусгай хэрэглэгч нарт сайтын тодорхойлсон үүргүүдийг ашиглах';
$string['adminhelpassignstudents'] = 'Хичээлийн дотор орж админ цэснээс оюутан нэмэх';
$string['adminhelpauthentication'] = 'Та дотоод хэрэглэгчийн бүртгэл эсвэл гадаад өгөгдлийн санг ашиглаж болно';
$string['adminhelpbackup'] = 'Автомат нөөцлөлт болон хуваарийг тохируулах';
$string['adminhelpconfiguration'] = 'Сайтын харагдах байдал болон ажиллагааг тохируулах';
$string['adminhelpconfigvariables'] = 'Сайтын ерөнхий үйл ажиллагаанд нөлөөлөх хувьсагчийг тохируулах';
$string['adminhelpcourses'] = 'Хичээл болон ангиллыг тодорхойлох, тэдгээрт суралцагчийг хуваарилах, хүлээгдэж буй хичээлийг засварлах';
$string['adminhelpeditorsettings'] = 'HTML засварлагчийн үндсэн тохиргоог тодорхойлох';
$string['adminhelpedituser'] = 'Хэрэглэгчдийн бүртгэлийг гүйлгэн үзэх, хүссэнээ засварлах';
$string['adminhelpenvironment'] = 'Суурилуулалтын одоогийн болон ирээдүйн шаардлагыг таны сервер хангаж байгаа эсэхийг шалгах';
$string['adminhelpfailurelogs'] = 'Амжилтгүй нэвтэрсэн лог бүртгэлийг харах';
$string['adminhelplanguage'] = 'Хэлний сонгосон багцыг хянах, шалгах';
$string['adminhelplogs'] = 'Сайтад хийгдсэн бүх үйлдлүүдийн тэмдэглэлийг гүйлгэн үзэх';
$string['adminhelpmanageblocks'] = 'Суулгасан булангуудын тохиргоо болон удирдлага';
$string['adminhelpmanagedatabase'] = 'Өгөгдлийн санд шууд хандах (болгоомжтой хандана уу!)';
$string['adminhelpmanagefilters'] = 'Бичвэр шүүлтүүр болон холбогдох тохиргоог сонгох';
$string['adminhelpmanagemodules'] = 'Суулгасан модулиуд, тэдгээрийн тохиргоог удирдах';
$string['adminhelpmanageroles'] = 'Хэрэглэгч нарт ашиглаж болох үүргүүдийг үүсгэж, тодорхойлох';
$string['adminhelpmymoodle'] = 'Хэрэглэгчдэд зориулж Миний Moodle блокуудад тохиргоо хийх';
$string['adminhelpreports'] = 'Сайтын түвшний тайлан';
$string['adminhelpsitefiles'] = 'Ерөнхий файлыг нийтлэх эсвэл гадаад нөөцлөлтийг байршуулахад зориулагдсан';
$string['adminhelpsitesettings'] = 'Сайтын нүүр хуудасны харагдах байдлыг тодорхойлох';
$string['adminhelpstickyblocks'] = 'Moodle-н өргөн наалттай блокуудыг тохируулах';
$string['adminhelpthemes'] = 'Сайтын харагдах байдлын тохиргоо (өнгө, фонт гэх мэт)';
$string['adminhelpuploadusers'] = 'Шинэ хэрэглэгчийн бүртгэлийг бичвэр файлаас импортлох';
$string['adminhelpusers'] = 'Хэрэглэгчээ тодорхойлж, баталгаажуулалтыг тохируулах';
$string['adminhelpxmldbeditor'] = 'XMLDB файлуудад засвар оруулах интерфэйс. Зөвхөн хөгжүүлэгч нарт зориулав.';
$string['administration'] = 'Удирдлага';
$string['administrationsite'] = 'Сайтын удирдлага';
$string['administrator'] = 'Администратор';
$string['administratordescription'] = 'Ер нь адинистратор сайтын аль хэсэгт, хичээлүүдэд юу ч хийж болно';
$string['administrators'] = 'Администраторууд';
$string['administratorsall'] = 'Бүх администратор';
$string['administratorsandteachers'] = 'Администраторууд болон багш нар';
$string['advanced'] = 'Нарийвчилсан тохиргоо';
$string['advancedfilter'] = 'Нарийвчилсан хайлт';
$string['advancedsettings'] = 'Нарийвчилсан тохиргоо';
$string['afterresource'] = '"{$a}" нөөцийн дараа';
$string['aftersection'] = '"{$a}" хэсгийн дараа';
$string['again'] = 'дахин';
$string['agelocationverification'] = 'Нас болон байршлын баталгаажуулалт';
$string['ajaxuse'] = 'АЯАКС болон Жаваскрипт';
$string['all'] = 'Бүгд';
$string['allactions'] = 'Бүх үйл ажиллагаа';
$string['allactivities'] = 'Бүх үйл ажиллагаанууд';
$string['allcategories'] = 'Бүх ангиллаар';
$string['allchanges'] = 'Бүх өөрчлөлт';
$string['alldays'] = 'Бүх өдөр';
$string['allfiles'] = 'Бүх файл';
$string['allgroups'] = 'Бүх бүлгүүд';
$string['alllogs'] = 'Бүх лог бүртгэл';
$string['allmods'] = 'Бүх {$a}';
$string['allow'] = 'Зөвшөөрөх';
$string['allowinternal'] = 'Дотоод аргуудыг нэгэн адил зөвшөөрөх';
$string['allownone'] = 'Аль нь ч зөвшөөрөхгүй';
$string['allownot'] = 'Зөвшөөрөхгүй';
$string['allowstealthmodules'] = 'Далд үйл ажиллагааг зөвшөөрөх';
$string['allowstealthmodules_help'] = 'Идэвхжүүлсэн тохиолдолд үйл ажиллагааг боломжтой болгох хэдий ч хичээлийн хуудасны харагдах хэсэгт харуулахгүй. Иймд далд үйл ажиллагааны холбоосыг хуудасны эх сурвалж зэрэг өөр газраас өгөх ёстой. Далд үйл ажиллагаа нь журнал болон бусад тайланд жагсаагдсан хэвээр байна.';
$string['allparticipants'] = 'Бүх оролцогч';
$string['allteachers'] = 'Бүх багш';
$string['alphanumerical'] = 'Зөвхөн цагаан толгойн үсэг, зураас (-) болон цэг (.) агуулж болно';
$string['alreadyconfirmed'] = 'Бүртгэлийг хэдийнэ баталгаажуулсан';
$string['alternatename'] = 'Хувилбар нэр';
$string['always'] = 'Үргэлж';
$string['and'] = '{$a->one} ба {$a->two}';
$string['answer'] = 'Хариулт';
$string['any'] = 'Ямар ч';
$string['appearance'] = 'Харагдах байдал';
$string['apply'] = 'Хэрэглэх';
$string['applyfilters'] = 'Шүүлтүүр хэрэглэх';
$string['approve'] = 'Батлах';
$string['areyousure'] = 'Та итгэлтэй байна уу?';
$string['areyousuretorestorethis'] = 'Та үргэлжлүүлэхийг хүсэж байна уу?';
$string['areyousuretorestorethisinfo'] = 'Энэ үйлдлийн үед таньд энэ нөөцийг одоогийн курс руу нэмэх эсвэл шинээр курс үүсгэх боломжтой хийх болно.';
$string['asc'] = 'Өсөх';
$string['assessment'] = 'Үнэлгээ';
$string['assignadmins'] = 'Админ эрх олгох';
$string['assigncreators'] = 'Үүсгэх эрх олгох';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Сайт-даяар ашиглах үүргүүдийг томилох';
$string['authenticateduser'] = 'Танигдсан хэрэглэгч';
$string['authenticateduserdescription'] = 'Бүх нэвтэрсэн хэрэглэгч';
$string['authentication'] = 'Таних';
$string['authenticationplugins'] = 'Баталгаажуулах плаг-ин-ууд';
$string['autosubscribe'] = 'Хэлэлцүүлэгт автоматаар бүртгүүлэх';
$string['autosubscribeno'] = 'Үгүй: би хэлэлцүүлэгт автоматаар бүртгүүлэхгүй';
$string['autosubscribeyes'] = 'Тийм: Намайг нийтлэх үед тухайн хэлэлцүүлэгт бүртгэнэ үү';
$string['availability'] = 'Боломжит';
$string['availablecourses'] = 'Явагдаж байгаа сургалтууд';
$string['back'] = 'Буцах';
$string['backto'] = '{$a} - д буцах';
$string['backtocourselisting'] = 'Хичээлийн жагсаалт руу буцах';
$string['backtohome'] = 'Сайтын нүүр хуудсанд буцах';
$string['backtopageyouwereon'] = 'Өмнөх хуудсанд очих';
$string['backup'] = 'Нөөцлөлт';
$string['backupactivehelp'] = 'Автоматжуулсан нөөц үүсгэх эсэхийг сонгох';
$string['backupadhocpending'] = 'Хичээлийн нөөцлөлтийн түр ажлууд хүлээгдэж байна';
$string['backupcancelled'] = 'Нөөцлөхийг цуцлах';
$string['backupcoursefileshelp'] = 'Хэрэв идэвхжүүлвэл, курсын файлууд автомат нөөцөд орох болно.';
$string['backupdate'] = 'Нөөц үүсгэсэн огноо';
$string['backupdatenew'] = '{$a->TAG}  {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />одоо болж байна';
$string['backupdateold'] = '{$a->TAG}  {$a->weekday}, {$a->mday} {$a->month} {$a->year} байсан байна';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Нөөцийн дэлгэрэнгүй';
$string['backuperrorinvaliddestination'] = 'Нөөцийг хадгалах фолдер үүсгэгдээгүй байна эсвэл бичвэр хийх боломжгүй байна.';
$string['backupexecuteathelp'] = 'Хэдэн цагт нөөцлөх ажиллагаа явагдахыг сонгох';
$string['backupfailed'] = 'Таны зарим хичээл хадгалагдаагүй байна!!';
$string['backupfilename'] = 'нөөцлөлт';
$string['backupfinished'] = 'Нөөцлөлт амжилттай дууссан';
$string['backupfromthissite'] = 'Энэ сайт дээр нөөц үүсгэгдсэн байсан уу?';
$string['backupgradebookhistoryhelp'] = 'Хэрэв идэвхжүүлсэн бол, дүнгийн дэвтэрийн түүх автоматаар сануулагдах нөөцд багтах болно. Үүнийг ажиллуулахын тулд серверийн тохиргоон дээрээс дүнгийн түүхийг идэвхгүйжүүлсэн (дүнгийн түүх идэвхгүйжүүлэх) байх ёсгүй';
$string['backupincludemoduleshelp'] = 'Хичээлийн модулийг хэрэглэгчийн өгөгдөлтэй эсвэл өгөгдөлгүй автомат нөөцлөлтөд оруулах эсэхийг сонгох';
$string['backupincludemoduleuserdatahelp'] = 'Автоматаар сануулагдах нөөцд модул хэрэглэгчийн датаг оруулахыг хүсч байгаа эсэхээ сонгох';
$string['backuplogdetailed'] = 'Гүйцэтгэлийн дэлгэрэнгүй лог бүртгэл';
$string['backuploglaststatus'] = 'Сүүлчийн гүйцэтгэлийн лог бүртгэл';
$string['backupmissinguserinfoperms'] = 'Тэмдэглэл: Энэ нөөц хэрэглэгчийн дата агуулаагүй байна. Дасгал болон Семинар ажлууд энэ төрлийн нөөцтэй нийцэмжгүй тул эдгээр модулууд нөөцд багтахгүй.';
$string['backupnext'] = 'Дараачийн нөөцлөлт';
$string['backupnonisowarning'] = 'Анхааруулга: Энэ нөөцлөлт нь Moodle системийн Юникод бус хувилбарынх (1.6-аас өмнөх) болно. Хэрэв энэ нөөцлөлтөд буй ISO-8859-1 бус дурын бичвэрийг Moodle системийн Юникод хувилбарт сэргээхийг оролдвол тэдгээр нь ЭВДЭРСЭН байж болзошгүй. Энэ нөөцлөлтийг зөв сэргээх талаарх нэмэлт мэдээллийг <a href="https://docs.moodle.org/en/Backup_FAQ">Нөөцлөлтийн түгээмэл асуултууд</a> хэсгээс авна уу.';
$string['backupnotyetrun'] = 'Автомат нөөцлөлт хүлээгдэж байна';
$string['backuporiginalname'] = 'Нөөцлөсөн нөөцийн нэр';
$string['backuproleassignments'] = 'Эдгээр үүргүүдийн үүрэг томилолтыг нөөцлөх';
$string['backupsavetohelp'] = 'Нөөц файлыг хадгалах лавлахын бүрэн зам';
$string['backupsitefileshelp'] = 'Хэрэв идэвхжүүлсэн бол, курсуудэд ашиглагдсан сайтын файлууд автоматаар нөөцлөгдөх нөөцд багтана';
$string['backuptakealook'] = 'Нөөцлөлтийн лог бүртгэлийг харна уу:
   {$a}';
$string['backupuserfileshelp'] = 'Хэрэглэгчийн файлыг (жишээ нь профайл зураг) автомат нөөцлөлтөд оруулах эсэхийг сонгох';
$string['backupversion'] = 'Нөөцлөсөн нөөцийн хувилбар';
$string['badges'] = 'Батламж тэмдэг';
$string['block'] = 'Блок';
$string['blockconfiga'] = '{$a} блокыг тохируулж байна';
$string['blockconfigbad'] = 'Энэ блокийг зөв хэрэгжүүлээгүй тул тохиргооны интерфэйсийг харуулах боломжгүй.';
$string['blocks'] = 'Блокууд';
$string['blocksaddedit'] = 'Блок нэмэх/засварлах';
$string['blockseditoff'] = 'Блок засварлалтыг зогсоох';
$string['blocksediton'] = 'Блок засварлалтыг идэвхжүүлэх';
$string['blocksetup'] = 'Булангийн хүснэгтүүдийг тохируулах';
$string['blocksuccess'] = '{$a} хүснэгтийг зөв тохируулсан';
$string['brief'] = 'Товч';
$string['bulkactions'] = 'Багц үйлдэл';
$string['bulkactionselect'] = '{$a} багц үйлдлийг сонгох';
$string['bulkmovecoursessuccess'] = '{$a->courses} хичээлийг {$a->category} ангилалд амжилттай шилжүүлэв.';
$string['bycourseorder'] = 'Курсын дарааллаар';
$string['byname'] = '{$a} нь';
$string['bypassed'] = 'Давсан';
$string['cachecontrols'] = 'Кэшийн хяналт';
$string['calltofeedback'] = 'Энэхүү программ хангамжийг бүтээгчид таныг санал хүсэлтээ ирүүлэхийг хүсэж байна.';
$string['calltofeedback_give'] = 'Энэхүү программ хангамжийг талаар санал хүсэлтээ өгөх';
$string['calltofeedback_remind'] = 'Надад хожим сануулна уу';
$string['cancel'] = 'Цуцлах';
$string['cancelled'] = 'Цуцлагдсан';
$string['categories'] = 'Курсын ангилал';
$string['categoriesandcourses'] = 'Хичээлийн ангилал ба хичээл';
$string['category'] = 'Ангилал';
$string['categoryadded'] = '\'{$a}\' ангиллыг нэмсэн';
$string['categorybulkaction'] = 'Сонгосон ангиллуудад хийх үйл ажиллагаа';
$string['categorycontents'] = 'Дэд ангиллууд ба курсүүд';
$string['categorycurrentcontents'] = '{$a}-н контентууд';
$string['categorydeleted'] = '\'{$a}\' ангиллыг устгасан';
$string['categoryduplicate'] = '\'{$a}\' нэртэй ангилал хэдийнэ байна!';
$string['categoryheader'] = 'Ангиллын цэс';
$string['categoryhidden'] = '(нуусан)';
$string['categorymodifiedcancel'] = 'Ангилал өөрчлөгдлөө! Цуцлах эсвэл дахин оролдоно уу.';
$string['categoryname'] = 'Ангилалын нэр';
$string['categorypath'] = 'Ангиллын зам';
$string['categorysubcategoryof'] = '{$a->category} нь {$a->parentcategory} ангиллын дэд ангилал';
$string['categoryupdated'] = '\'{$a}\' ангиллыг шинэчилсэн';
$string['changedpassword'] = 'Нууц үгийг өөрчилсөн';
$string['changepassword'] = 'Нууц үг өөрчлөх';
$string['changesmade'] = 'Өөрчлөлтийг хийсэн';
$string['changesmadereallygoaway'] = 'Та өөрчлөлт хийсэн байна. Та хийсэн өөрчлөлтөө хадгалахгүйгээр гарахыг хүсэж байна уу?';
$string['changessaved'] = 'Өөрчлөлтийг хадгалсан';
$string['check'] = 'Шалгах';
$string['checkactual'] = 'Бодит';
$string['checkall'] = 'Бүгдийг шалгах';
$string['checkexpected'] = 'Хүлээгдэж буй';
$string['checkingbackup'] = 'Нөөцлөлтийг шалгаж байна';
$string['checkingcourse'] = 'Хичээлийг шалгаж байна';
$string['checkingforbbexport'] = 'BlackBoard экспортыг шалгаж байна';
$string['checkinginstances'] = 'Тохиолдлыг шалгаж байна';
$string['checkingsections'] = 'Хэсгийг шалгаж байна';
$string['checklanguage'] = 'Хэл шалгах';
$string['checknone'] = 'Алийг ч шалгахгүй';
$string['checks'] = 'Шалгалт';
$string['checksok'] = 'Бүх \'{$a}\' шалгалт хэвийн';
$string['childcoursenotfound'] = 'Дэд хичээл олдсонгүй!';
$string['childcourses'] = 'Дэд хичээлүүд';
$string['choose'] = 'Сонгох';
$string['choosecourse'] = 'Хичээл сонгох';
$string['choosedots'] = 'Сонгох...';
$string['chooselivelogs'] = 'Эсвэл одоогийн үйл ажиллагааг харах';
$string['chooselogs'] = 'Харахыг хүсэн лог бүртгэлээ сонгох';
$string['choosereportfilter'] = 'Тайлангийн шүүлтүүрийг сонгох';
$string['choosetheme'] = 'Загвар сонгох';
$string['chooseuser'] = 'Хэрэглэгч сонгох';
$string['city'] = 'Хот/дүүрэг';
$string['cleaningtempdata'] = 'Завсрын өгөгдлийг цэвэрлэж байна';
$string['clear'] = 'Арилгах';
$string['clearfilterrow'] = 'Шүүлтүүрийн мөрийг арилгах';
$string['clearfilters'] = 'Шүүлтүүрийг цэвэрлэх';
$string['clearsearch'] = 'Хайлтын оролтыг арилгах';
$string['clickhelpiconformoreinfo'] = '... үргэлжилж байна ... Тусламжийн дүрст тэмдэг дээр дарж өгүүллийг бүтнээр уншина уу';
$string['clickhere'] = 'Энд дарна уу ...';
$string['clicktochangeinbrackets'] = '{$a} (Дарж өөрчилнө)';
$string['clicktohideshow'] = 'Дарж өргөтгөх эсвэл хураангуйлах';
$string['closeblockdrawer'] = 'Блок агуулагчийг хаах';
$string['closebuttontitle'] = 'Хаах';
$string['closecourseindex'] = 'Хичээлийн индексийг хаах';
$string['closedrawer'] = 'Агуулагчийг хаах';
$string['closewindow'] = 'Энэ цонхыг хаах';
$string['collapse'] = 'Хураангуйлах';
$string['collapseall'] = 'Бүгдийг хураангуйлах';
$string['collapsecategory'] = '{$a} хураангуйлах';
$string['comebacklater'] = 'Дараа дахин хандана уу.';
$string['commentincontext'] = 'Энэ сэтгэгдлийг агуулгаас олох';
$string['comments'] = 'Сэтгэгдлүүд';
$string['commentscount'] = 'Сэтгэгдлүүд ({$a})';
$string['commentsnotenabled'] = 'Сэтгэгдлийн функцыг идэвхжүүлээгүй байна';
$string['commentsrequirelogin'] = 'Та сэтгэгдэл харахын тулд нэвтрэх шаардлагатай.';
$string['comparelanguage'] = 'Идэвхтэй хэлийг харьцуулах ба засварлах';
$string['complete'] = 'Бүрэн';
$string['completed'] = 'Дууссан';
$string['completereport'] = 'Бүрэн тайлан';
$string['configuration'] = 'Тохиргоо';
$string['confirm'] = 'Батлах';
$string['confirmcheckfull'] = 'Та {$a}-г баталгаажуулахдаа итгэлтэй байна уу?';
$string['confirmcoursemove'] = 'Та энэ ({$a->course}) хичээлийг энэ ({$a->category}) ангилалд шилжүүлэхдээ итгэлтэй байна уу?';
$string['confirmdeletesection'] = 'Та "{$a}" болон түүний бүх үйл ажиллагааг бүрмөсөн устгахдаа илтгэлтэй байна уу?';
$string['confirmed'] = 'Таны бүртгэл баталгаажлаа';
$string['confirmednot'] = 'Таны бүртгэл хараахан баталгаажаагүй байна. Баталгаажуулах цахим шуудан ирсэн эсэхийг шалгана уу.';
$string['considereddigitalminor'] = 'Та энэ сайт дээр бүртгэл үүсгэхэд хэт залуу байна.';
$string['content'] = 'Агуулга';
$string['contentbank'] = 'Агуулгын сан';
$string['contentexport_aboutthiscourse'] = 'Хичээлийн хураангуй';
$string['contentexport_coursesummary'] = 'Энэ файл нь <a href="{$a->courselink} ">{$a->coursename}</a> хаягаас татаж авсан агуулгын хэсэг болно.';
$string['contentexport_footersummary'] = 'Энэ файл нь {$a->userfullname} хэрэглэгчийн {$a->date} өдөр <a href="{$a->courselink}">{$a->coursename}</a> хаягаас татаж авсан агуулгын хэсэг болно.';
$string['contentexport_modulesummary'] = 'Энэ хуудас нь <a href="{$a->modulelink}">{$a->modulename}</a> хаягаас {$a->date} өдөр татаж авсан агуулгын хэсэг болно. Зарим агуулга болон {$a->maxfilesize} хэмжээнээс  том файлыг татаж авдаггүйг анхаарна уу.';
$string['contentexport_viewfilename'] = '{$a} файлыг харах';
$string['context'] = 'Хамрах хүрээ';
$string['contexturl'] = 'Хамрах хүрээний URL хаяг';
$string['continue'] = 'Үргэлжлүүлэх';
$string['continuetocourse'] = 'Энд дарж хичээлээ оруулана уу';
$string['convertingwikitomarkdown'] = 'Викийг маркдаун хэл рүү хөрвүүлж байна';
$string['cookiesenabled'] = 'Күүкийг таны хөтөч дээр идэвхжүүлсэн байх ёстой';
$string['cookiesenabled_help'] = 'Энэ сайтад хоёр күүкийг ашигладаг. Үүнд:

Үндсэн күүки нь ихэвчлэн MoodleSession гэгдэх сейшн күүки юм. Та энэ күүкийг хөтөчдөө тасралтгүй ажиллуулж, сайтыг үзэх явцад нэвтэрсэн хэвээр байхыг зөвшөөрөх ёстой. Уг күүки нь таныг сайтаас гарах эсвэл хөтчөө хаах үед (таны хөтөч болон серверээс) устгагддаг.

Нөгөө күүки нь ихэвчлэн MOODLEID эсвэл үүнтэй төстэй нэрлэгддэг тохиромжит байдлыг хангадаг күүки юм. Энэ күүки нь хөтөч дээрх хэрэглэгчийн нэрийг л санадаг. Энэ нь таныг тухайн сайтад дахин хандахад нэвтрэх хуудас дээрх хэрэглэгчийн нэрийн талбарыг таны хэрэглэгчийн нэрээр автоматаар бөглөдөг. Уг күүкийг идэвхжүүлэх шаардлагагүй, та нэвтрэх тухай бүр хэрэглэгчийн нэрийг оруулахад л хангалттай.';
$string['cookiesenabled_help_html'] = 'Энэ сайтад хоёр күүкийг ашигладаг. Үүнд:<br/><br/>

Үндсэн күүки нь ихэвчлэн MoodleSession гэгдэх сейшн күүки юм. Та энэ күүкийг хөтөчдөө тасралтгүй ажиллуулж, сайтыг үзэх явцад нэвтэрсэн хэвээр байхыг зөвшөөрөх ёстой. Уг күүки нь таныг сайтаас гарах эсвэл хөтчөө хаах үед (таны хөтөч болон серверээс) устгагддаг.<br/><br/>

Нөгөө күүки нь ихэвчлэн MOODLEID эсвэл үүнтэй төстэй нэрлэгддэг тохиромжит байдлыг хангадаг күүки юм. Энэ күүки нь хөтөч дээрх хэрэглэгчийн нэрийг л санадаг. Энэ нь таныг тухайн сайтад дахин хандахад нэвтрэх хуудас дээрх хэрэглэгчийн нэрийн талбарыг таны хэрэглэгчийн нэрээр автоматаар бөглөдөг. Уг күүкийг идэвхжүүлэх шаардлагагүй, та нэвтрэх тухай бүр хэрэглэгчийн нэрийг оруулахад л хангалттай.';
$string['cookiesenabledonlysession'] = 'Күүкийг таны хөтөч дээр идэвхжүүлсэн байх ёстой';
$string['cookiesenabledonlysession_help'] = 'Энэ сайт нь ихэвчлэн MoodleSession гэгдэх ганц сейшний күүкийг ашигладаг. Та энэ күүкийг хөтөчдөө тасралтгүй ажиллуулж, сайтыг үзэх явцад нэвтэрсэн хэвээр байхыг зөвшөөрөх ёстой. Уг күүки нь таныг сайтаас гарах эсвэл хөтчөө хаах үед (таны хөтөч болон серверээс) устгагддаг.';
$string['cookiesnotenabled'] = 'Харамсалтай нь одоогоор таны хөтөч дээр күүкийг идэвхжүүлээгүй байна';
$string['cookiesnotice'] = 'Күүкийн анхааруулга';
$string['copy'] = 'хуулах';
$string['copyasnoun'] = 'хуулбар';
$string['copycourse'] = 'Хичээлийг хуулах';
$string['copyingcoursefiles'] = 'Хичээлийн файлыг хуулж байна';
$string['copyingsitefiles'] = 'Энэ хичээлд ашиглах сайтын файлыг хуулж байна';
$string['copyinguserfiles'] = 'Хэрэглэгчийн файлыг хуулж байна';
$string['copyingzipfile'] = 'Шахсан файлыг хуулж байна';
$string['copyrightnotice'] = 'Зохиогчийн эрхийн анхааруулга';
$string['copytoclipboard'] = 'Завсрын санах ойд хуулах';
$string['coresystem'] = 'Систем';
$string['cost'] = 'Үнэ';
$string['costdefault'] = 'Өгөгдсөл үнэ';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Улс';
$string['course'] = 'Хичээл';
$string['courseadministration'] = 'Хичээлийн удирдлага';
$string['courseapprovedemail'] = 'Таны хүсэлт гаргасан {$a->name} хичээл зөвшөөрөгдөж, таныг {$a->teacher} болголоо. Шинэ хичээлд {$a->url} холбоосоор хандана уу';
$string['courseapprovedemail2'] = 'Таны хүсэлт гаргасан {$a->name} хичээлийг зөвшөөрсөн байна. Шинэ хичээлд {$a->url} хаягаар хандана уу';
$string['courseapprovedfailed'] = 'Хичээлийг баталгаажуулж хадгалахад алдаа гарлаа!';
$string['courseapprovedsubject'] = 'Таны хичээл батлагдлаа!';
$string['courseavailable'] = 'Суралцагчид энэ хичээлийг судлах боломжтой';
$string['courseavailablenot'] = 'Суралцагчид энэ хичээлийг судлах боломжгүй';
$string['coursebackup'] = 'Хичээлийн нөөцлөлт';
$string['coursebulkaction'] = 'Сонгосон хичээлүүдэд хийгдэх багц үйлдлүүд';
$string['coursecategories'] = 'Хичээлийн ангиллууд';
$string['coursecategory'] = 'Хичээлийн ангилал';
$string['coursecategory_help'] = 'Энэ тохиргоогоор хичээлийн жагсаалтад гаргах ангиллыг тодорхойлно.';
$string['coursecategorydeleted'] = '{$a} хичээлийн ангиллыг устгасан';
$string['coursecatmanagement'] = 'Хичээл ба ангиллын удирдлага';
$string['coursecompletion'] = 'Хичээлийн төгсөлт';
$string['coursecompletions'] = 'Хичээлийн төгсөлт';
$string['coursecreators'] = 'Хичээл үүсгэгч';
$string['coursecreatorsdescription'] = 'Хичээл үүсгэгч шинэ хичээлийг үүсгэх боломжтой.';
$string['coursedeleted'] = '{$a} хичээлийг устгасан';
$string['coursedetails'] = 'Хичээлийн дэлгэрэнгүй мэдээлэл';
$string['coursedisplay'] = 'Хичээлийн бүтэц';
$string['coursedisplay_help'] = 'Энэ тохиргоогоор хичээлийг бүхэлд нь нэг хуудсанд эсвэл хэд хэдэн хуудсанд хувааж харуулах эсэхийг тодорхойлно.';
$string['coursedisplay_multi'] = 'Нэг хуудсанд нэг хэсгийг харуулах';
$string['coursedisplay_single'] = 'Нэг хуудсанд бүх хэсгийг харуулах';
$string['courseduration'] = 'Хичээлийн үргэлжлэх хугацаа';
$string['courseduration_desc'] = 'Хичээлийн үргэлжлэх хугацааг өгөгдмөл байдлаар хичээлийн дуусах огноог тооцоолоход ашигладаг. Хичээл дуусах огноог тухайн хичээлийг хэрэглэгчийн хичээлийн жагсаалтад оруулах эсэхийг тодорхойлоход ашигладаг. Үүнийг тусгайлсан тайланд ашиглаж болно. Суралцагч хугацаа дууссан ч хичээлд орох боломжтой.';
$string['courseenddateenabled'] = 'Хичээл дуусах огноог өгөгдмөл утгаар идэвхжүүлсэн';
$string['courseenddateenabled_desc'] = 'Энэхүү тохиргоогоор хичээл дуусах огноог шинэ хичээлүүдэд өгөгдмөл байдлаар идэвхжүүлж, хичээлийн үргэлжлэх хугацаанаас тооцсон огноогоор тохируулах эсэхийг тодорхойлдог.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Хуучин хичээлийн файлууд';
$string['coursefilesedit'] = 'Хуучин хичээлийн файлыг засварлах';
$string['coursefileswarning'] = 'Хичээлийн файлууд хуучирсан';
$string['coursefileswarning_help'] = 'Moodle 2.0 хувилбараас хойш хичээлийн файлууд хуучирсан тул оронд нь гадаад өгөгдлийн агуулахыг аль болох түлхүү ашиглана уу.';
$string['courseformatdata'] = 'Хичээлийн форматын өгөгдөл';
$string['courseformatoptions'] = '{$a}-ийг форматлах сонголтууд';
$string['courseformats'] = 'Хичээлийн форматууд';
$string['courseformatudpate'] = 'Форматыг шинэчлэх';
$string['coursegrades'] = 'Хичээлийн үнэлгээ';
$string['courseheader'] = 'Хичээлийн цэс';
$string['coursehelpcategory'] = 'Хичээлийн жагсаалтад хичээлийг байрлуулбал суралцагч олоход илүү хялбар болно.';
$string['coursehelpforce'] = 'Хичээлийн үйл ажиллагаа бүрд хичээлийн бүлгийн горимыг шаардана.';
$string['coursehelpformat'] = 'Хичээлийн үндсэн хуудсыг энэ форматаар харуулах болно.';
$string['coursehelphiddensections'] = 'Хичээлийн нуусан хэсгүүдийг суралцагчдад яаж харуулах вэ.';
$string['coursehelpmaximumupload'] = 'Сайтын тохиргоогоор хязгаарлагдлах энэ хичээлд байршуулж болох файлын хамгийн их хэмжээг заана.';
$string['coursehelpnewsitemsnumber'] = 'Хичээлийн хуудас дээрх хамгийн сүүлийн зар мэдээний блокт гарах сүүлийн үеийн зарын тоо. Тэг гэж тохируулсан тохиолдолд мэдэгдлийн хэлэлцүүлэг үүсэхгүй.';
$string['coursehelpnumberweeks'] = 'Хичээлийн хэсгийн тоо (зөвхөн тодорхой хичээлийн форматад хамаарна).';
$string['coursehelpshowgrades'] = 'Журналыг харуулахыг идэвхжүүлнэ. Энэ нь бие даасан үйл ажиллагааны хүрээнд үнэлгээг харуулахад саад болохгүй.';
$string['coursehidden'] = 'Суралцагчид одоогоор энэ хичээлийг судлах боломжгүй';
$string['courseinfo'] = 'Хичээлийн мэдээлэл';
$string['courselegacyfiles'] = 'Хуучин хичээлийн файлууд';
$string['courselegacyfiles_help'] = 'Хичээлийн файлын талбар нь Moodle 1.9 болон түүнээс өмнөх хувилбартай зарим талаараа нийцдэг. Хичээлийн бүх оролцогч энэ талбарт байгаа бүх файлд (тэдгээрт холбосон эсэхээс үл хамааран) үргэлж хандах боломжтой бөгөөд эдгээр файлыг Moodle системд хаана ашиглагдаж буйг мэдэх боломжгүй.

Хичээлийн файлыг хадгалахад уг талбарыг ашиглах тохиолдолд нууцлал, аюулгүй байдалтай холбоотой олон асуудалд өртөхөөс гөднө нөөцлөлт, хичээл импортлох болон агуулгыг хуваалцах эсвэл дахин ашиглах үед файл алга болж болзошгүй. Иймд та сайн мэдэхгүй бол уг талбарыг ашиглахгүй байхыг зөвлөж байна.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Хуучин хичээлийн файлууд: {$a}';
$string['coursenotaccessible'] = 'Энэ хичээл нь нээлттэй хандалтыг зөвшөөрдөггүй';
$string['courseoverview'] = 'Хичээлийн тойм';
$string['courseoverviewfiles'] = 'Хичээлийн зураг';
$string['courseoverviewfiles_help'] = 'Хичээлийн зураг нь удирдах самбар дээрх хичээлийн тойм хэсэгт харагдана. Сайтын админ нь нэмэлт зөвшөөрөгдсөн файлын төрөл болон нэгээс олон файлыг идэвхжүүлж болно. Энэ тохиолдолд эдгээр файлыг хичээлийн жагсаалтын хуудасны хичээлийн хураангуй хэсгийн хажууд харуулах болно.';
$string['courseoverviewfilesext'] = 'Хичээлийн зургийн файлын өргөтгөл';
$string['courseoverviewfileslimit'] = 'Хичээлийн зургийн файлын хязгаар';
$string['courseoverviewgraph'] = 'Хичээлийн тойм график';
$string['courseprofiles'] = 'Хичээлийн профайл';
$string['coursereasonforrejecting'] = 'Таны энэ хүсэлтээс татгалзах болсон шалтгаан';
$string['coursereasonforrejectingemail'] = 'Үүнийг хүсэлт гаргагчид цахим шуудангаар илгээх болно';
$string['coursereject'] = 'Хичээлийн хүсэлтийг үл зөвшөөрөх';
$string['courserejected'] = 'Хичээлийг үл зөвшөөрч, хүсэлт гаргагчид мэдэгдсэн.';
$string['courserejectemail'] = 'Уучлаарай, таны хүссэн хичээлийг зөвшөөрөөгүй байна. Шалтгаан нь:

{$a}';
$string['courserejectreason'] = 'Та уг хичээлийг зөвшөөрөөгүй шалтгаан тоочно уу<br />(үүнийг хүсэлт гаргагчид цахим шуудангаар илгээнэ)';
$string['courserejectsubject'] = 'Таны хичээлийг зөвшөөрөөгүй байна';
$string['coursereport'] = 'Хичээлийн тайлан';
$string['coursereports'] = 'Хичээлийн тайлангууд';
$string['courserequest'] = 'Хичээлийн хүсэлт';
$string['courserequestdetails'] = 'Таны хүсэлт гаргаж буй хичээлийн дэлгэрэнгүй мэдээлэл';
$string['courserequestfailed'] = 'Таны хичээлийн хүсэлтийг зарим шалтгааны улмаас хадгалах боломжгүй байна';
$string['courserequestintro'] = 'Хичээл үүсгэх хүсэлтээ энэ маягтыг ашиглан гаргана уу<br />Администраторт уг хичээлийг хүсэх болсон шалтгааныг ойлгуулахын тулд<br /> аль болох дэлгэрэнгүй бөглөнө үү.';
$string['courserequestreason'] = 'Энэ хичээлийг хүсэх болсон шалтгаан';
$string['courserequestsuccess'] = 'Таны хичээлийн хүсэлт амжилттай хадгалагдлаа. Таны хүсэлтийг зөвшөөрсөн эсэх талаарх цахим шууданг илгээх болно.';
$string['courserequestsupport'] = 'Администраторт энэ хүсэлтийг үнэлэхэд туслах нэмэлт мэдээлэл';
$string['courserequestwarning'] = 'Энэ хичээлд хамрагдахыг хүссэн хэрэглэгч автоматаар бүртгүүлж, {$a} эрхтэй болох болно.';
$string['courserestore'] = 'Хичээлийг сэргээх';
$string['coursereuse'] = 'Хичээлийг дахин ашиглах';
$string['courses'] = 'Хичээлүүд';
$string['coursesearch'] = 'Хичээл хайх';
$string['coursesearch_help'] = 'Та нэг дор хэд хэдэн үг хайх боломжтой бөгөөд хайлтаа дараах байдлаар сайжруулж болно.

* үг - бичвэрээс энэ үгтэй тохирох дурын үгийг хайх
* +үг - зөвхөн энэ үгтэй яг тохирсон үгийг хайх
* -word - энэ үгийг агуулсан илэрцийг оруулахгүй.';
$string['coursesectionsummaries'] = 'Хичээлийн хэсгийн хураангуй';
$string['coursesectiontitle'] = 'Хичээл: {$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = 'Хичээлийн өгөгдмөл тохиргоо';
$string['coursesmovedout'] = '{$a}-аас хичээлийг шилжүүлсэн';
$string['coursespending'] = 'Зөвшөөрөл хүлээгдэж буй хичээлүүд';
$string['coursestart'] = 'Хичээлийн эхлэл';
$string['coursesummary'] = 'Хичээлийн хураангуй';
$string['coursesummary_help'] = 'Хичээлийн хураангуйг хичээлийн жагсаалтад харуулна. Хичээлийн хайлт нь хичээлийн нэрээс гадна хичээлийн хураангуй бичвэрийг хайдаг.';
$string['coursetitle'] = 'Хичээд: {$a->course}';
$string['courseupdates'] = 'Хичээлийн шинэчлэл';
$string['coursevisibility'] = 'Хичээлийн харагдах байдал';
$string['coursevisibility_help'] = 'Энэ тохиргоо хичээлийн жагсаалтад тухайн хичээлийг харуулах эсэх, суралцагч уг хичээлд хандах боломжтой эсэхийг тодорхойлно. Хэрэв нуух гэж тохируулбал нуусан хичээлийг харах боломжтой хэрэглэгчийн (багш гэх мэт) хандах эрхийг хязгаарлах болно.';
$string['create'] = 'Үүсгэх';
$string['createaccount'] = 'Миний шинэ бүртгэлийг үүсгэх';
$string['createcategory'] = 'Ангилал үүсгэх';
$string['createfolder'] = '{$a}-д шинэ хавтас үүсгэх';
$string['createnew'] = 'Шинийг үүсгэх';
$string['createnewcategory'] = 'Шинэ ангилал үүсгэх';
$string['createnewcourse'] = 'Шинэ хичээл үүсгэх';
$string['createnewsubcategory'] = 'Шинэ дэд ангилал үүсгэх';
$string['createsubcategoryof'] = '{$a}-ийн дэд ангилал үүсгэх';
$string['createuser'] = 'Хэрэглэгч үүсгэх';
$string['createziparchive'] = 'Шахсан архив үүсгэх';
$string['creatingblocks'] = 'Блок үүсгэж байна';
$string['creatingblocksroles'] = 'Блокын түвшний эрх хуваарилалтыг үүсгэх, хүчингүй болгох';
$string['creatingblogsinfo'] = 'Блогийн мэдээллийг үүсгэж байна';
$string['creatingcategoriesandquestions'] = 'Ангилал болон асуултыг үүсгэж байна';
$string['creatingcoursemodules'] = 'Хичээлийн модулийг үүсгэж байна';
$string['creatingcourseroles'] = 'Хичээлийн түвшний эрхийн хуваарилалтыг үүсгэх, хүчингүй болгох';
$string['creatingevents'] = 'Арга хэмжээг үүсгэж байна';
$string['creatinggradebook'] = 'Журнал үүсгэж байна';
$string['creatinggroupings'] = 'Бүлэг үүсгэж байна';
$string['creatinggroupingsgroups'] = 'Бүлэгт бүлэг нэмж байна';
$string['creatinggroups'] = 'Бүлэг үүсгэж байна';
$string['creatinglogentries'] = 'Лог бүртгэлийн бичлэгийг үүсгэж байна';
$string['creatingmessagesinfo'] = 'Зурвас мэдээллийг үүсгэж байна';
$string['creatingmodroles'] = 'Модулийн түвшний эрх хуваарилалтыг үүсгэх, хүчингүй болгох';
$string['creatingnewcourse'] = 'Шинэ хичээл үүсгэж байна';
$string['creatingrolesdefinitions'] = 'Хэрэглэгчийн эрхийг тодорхойлолтыг үүсгэж байна';
$string['creatingscales'] = 'Хэмжүүр үүсгэж байна';
$string['creatingsections'] = 'Хэсгийг үүсгэж байна';
$string['creatingtemporarystructures'] = 'Түр бүтцийг үүсгэж байна';
$string['creatinguserroles'] = 'Хэрэглэгчийн түвшний эрх хуваарилалтыг үүсгэх, хүчингүй болгох';
$string['creatingusers'] = 'Хэрэглэгчийг үүсгэж байна';
$string['creatingxmlfile'] = 'XML файлыг үүсгэж байна';
$string['currency'] = 'Мөнгөн тэмдэгт';
$string['currentcourse'] = 'Явагдаж буй хичээл';
$string['currentcourseadding'] = 'Явагдаж буй хичээл, өгөгдөл нэмж байна';
$string['currentcoursedeleting'] = 'Явагдаж буй хичээл, эхэлж устгаж байна';
$string['currentlanguage'] = 'Сонгосон хэл';
$string['currentlocaltime'] = 'таны одоогийн орон нутгийн цаг';
$string['currentpicture'] = 'Одоогийн зураг';
$string['currentrelease'] = 'Одоогийн хувилбарын мэдээлэл';
$string['currentversion'] = 'Ашиглаж буй хувилбар';
$string['databasechecking'] = 'Moodle өгөгдлийн санг {$a->oldversion} хувилбараас {$a->newversion} хувилбар болгон шинэчилж байна';
$string['databaseperformance'] = 'Өгөгдлийн сангийн гүйцэтгэл';
$string['databasesetup'] = 'Өгөгдлийн сангийн тохиргоог хийж байна';
$string['databasesuccess'] = 'Өгөгдлийн санг амжилттай шинэчиллээ';
$string['databaseupgradebackups'] = 'Нөөцлөлтийн хувилбар нь {$a} болсон';
$string['databaseupgradeblocks'] = 'Блокын хувилбар нь {$a} болсон';
$string['databaseupgradegroups'] = 'Бүлгийн хувилбар нь {$a} болсон';
$string['databaseupgradelocal'] = 'Дотоод өгөгдлийн сангийн тохируулгын хувилбар нь {$a} болсон';
$string['databaseupgrades'] = 'Өгөгдлийн санг шинэчилж байна';
$string['dataformats'] = 'Өгөгдлийн формат';
$string['date'] = 'Огноо';
$string['datechanged'] = 'Огноо өөрчлөгдсөн';
$string['datemostrecentfirst'] = 'Огноо - хамгийн сүүлийнх нь эхэнд байна';
$string['datemostrecentlast'] = 'Огноо - хамгийн сүүлийнх нь сүүлд байна';
$string['day'] = 'өдөр';
$string['days'] = 'өдрүүд';
$string['decodinginternallinks'] = 'Дотоод холбоосыг тайлж уншиж байна';
$string['default'] = 'Өгөгдмөл';
$string['defaultcategoryname'] = 'Ангилал 1';
$string['defaultcompetencescale'] = 'Чадамжийн өгөгдмөл хэмжүүр';
$string['defaultcompetencescaledesc'] = 'Хэн нэгэн нь ур чадвараа харуулсан эсэхээс өөр мэдээллийг өгдөггүй хоёртын үнэлгээний хэмжүүр.';
$string['defaultcompetencescalenotproficient'] = 'Хараахан шаардлага хангаагүй';
$string['defaultcompetencescaleproficient'] = 'Шаардлага хангасан';
$string['defaultcoursestudent'] = 'Суралцагч';
$string['defaultcoursestudentdescription'] = 'Ихэнх тохиолдолд суралцагч хичээлийн хүрээнд цөөн тооны давуу эрхтэй байдаг.';
$string['defaultcoursestudents'] = 'Суралцагчид';
$string['defaultcoursesummary'] = 'Энд уг хичээлийн талаар тайлбарласан товч бөгөөд сонирхолтой тэмдэглэлийг бичнэ үү.';
$string['defaultcourseteacher'] = 'Багш';
$string['defaultcourseteacherdescription'] = 'Багш хичээлийн хүрээнд үйл ажиллагааг өөрчлөх, суралцагчийг үнэлэх дурын үйлдлийг хийх боломжтой.';
$string['defaultcourseteachers'] = 'Багш нар';
$string['defaulteditor'] = 'Үндсэн засварлагч';
$string['defaulthomepageuser'] = 'Эхлэх хуудас';
$string['defaulthomepageuser_help'] = 'Сайтад нэвтэрсний дараа аль хуудас руу шилжих шаардлагатай вэ?';
$string['delete'] = 'Устгах';
$string['deleteablock'] = 'Блокыг устгах';
$string['deleteall'] = 'Бүгдийг устгах';
$string['deleteallcannotundo'] = 'Бүгдийг устгах - буцаах боломжгүй';
$string['deleteallcomments'] = 'Бүх тайлбарыг устгах';
$string['deleteallratings'] = 'Бүх үнэлгээг устгах';
$string['deletecategory'] = 'Ангиллыг устгах: {$a}';
$string['deletecategorycheck'] = 'Та <b>\'{$a}\'</b> ангиллыг бүрмөсөн устгахдаа итгэлтэй байна уу?<br /> Энэ нь хэрэв байгаа бол бүх хичээлийг үндсэн ангилал эсвэл Miscellaneous ангилалд зөөх болно.';
$string['deletecategorycheck2'] = 'Энэ ангиллыг устгасан тохиолдолд түүнд байгаа хичээл болон дэд ангиллыг яах ёстойгоо сонгох шаардлагатай.';
$string['deletecategoryempty'] = 'Энэ ангилал хоосон байна.';
$string['deletecheck'] = '{$a} устгах эсэх?';
$string['deletecheckfiles'] = 'Та эдгээр файлыг устгахдаа итгэлтэй байна уу?';
$string['deletecheckfull'] = 'Та {$a} хэрэглэгчийг түүний бүртгэл, үйл ажиллагаа болон хэрэглэгчийн бусад өгөгдлийг оролцуулан бүрмөсөн устгахдаа итгэлтэй байна уу?';
$string['deletechecktype'] = 'Та {$a->type} төрлийг устгахдаа итгэлтэй байна уу?';
$string['deletechecktypename'] = 'Та "{$a->name}" {$a->type} төрлийг устгахдаа итгэлтэй байна уу?';
$string['deletecheckwarning'] = 'Та эдгээр файлыг устгах гэж байна';
$string['deletecommentbyon'] = '{$a->user} хэрэглэгчийн {$a->time} цагт оруулсан сэтгэгдлийг устгах';
$string['deletecompletely'] = 'Бүрмөсөн устгах';
$string['deletecourse'] = 'Хичээлийг устгах';
$string['deletecoursecheck'] = 'Та энэ хичээл болон түүний бүх өгөгдлийг бүрмөсөн устгахдаа итгэлтэй байна уу?';
$string['deleted'] = 'Устгагдсан';
$string['deletedactivity'] = '{$a} устгагдсан';
$string['deletedcourse'] = '{$a} бүрмөсөн устгагдсан';
$string['deletednot'] = '{$a}-ийг устгах боломжгүй байна !';
$string['deletepicture'] = 'Зургийг устгах';
$string['deletesection'] = 'Хэсгийг устгах';
$string['deleteselected'] = 'Сонгосныг устгах';
$string['deleteselectedkey'] = 'Сонгосон түлхүүрийг устгах';
$string['deletingcourse'] = '{$a}-ийг устгаж байна';
$string['deletingexistingcoursedata'] = 'Одоо байгаа хичээлийн өгөгдлийг устгаж байна';
$string['deletingolddata'] = 'Хуучин өгөгдлийг устгаж байна';
$string['department'] = 'Тэнхим';
$string['deprecatedeventname'] = '{$a} (ашиглахаа больсон)';
$string['desc'] = 'Буурах';
$string['description'] = 'Тодорхойлолт';
$string['deselectall'] = 'Бүх сонгосныг цуцлах';
$string['deselectnos'] = 'Бүх \'Үгүй\' гэж сонгосныг цуцлах';
$string['detailedless'] = 'Дэлгэрэнгүй мэдээлэл багатай';
$string['detailedmore'] = 'Илүү дэлгэрэнгүй мэдээлэлтэй';
$string['details'] = 'Дэлгэрэнгүй мэдээлэл';
$string['digitalminor'] = 'Дижитал насанд хүрээгүй';
$string['digitalminor_desc'] = 'Өөрийн эцэг эх/асран хамгаалагчаа холбоо бариулна уу:';
$string['directory'] = 'Лавлах';
$string['disable'] = 'Идэвхгүй болгох';
$string['disabledcomments'] = 'Сэтгэгдлийг идэвхгүй болгосон';
$string['dismissnotification'] = 'Энэ мэдэгдлийг хаах';
$string['displayingfirst'] = 'Эхний эхний {$a->count}{$a->things} харагдана';
$string['displayingrecords'] = '{$a} бичлэгийг харуулж байна';
$string['displayingusers'] = '{$a->start}-аас {$a->end} хүртэлх хэрэглэгчийг харуулж байна';
$string['displayonpage'] = 'Хуудсанд харуулах';
$string['dndcourse'] = 'Та энэ хичээлийн эрэмбийг чирэх даралтаар өөрчлөх эсвэл өөр ангилалд шилжүүлэх боломжтой.';
$string['dndenabled_inbox'] = 'Та энд файлыг чирэх даралтаар нэмж болно.';
$string['dndnotsupported'] = 'Чирэх даралтаар байршуулах боломжгүй';
$string['dndnotsupported_help'] = 'Таны хөтөч чирэх даралтаар байршуулахыг дэмждэггүй. Энэ функц нь Chrome, Firefox Safari хөтчийн сүүлийн хувилбарууд болон Internet Explorer v10, түүнээс дээших хувилбарт байдаг.';
$string['dndnotsupported_insentence'] = 'чирэх даралтаар байршуулахыг дэмждэггүй';
$string['dnduploadwithoutcontent'] = 'Байршуулах ямар ч агуулга байхгүй байна';
$string['dndworkingfile'] = 'Хичээлийн хэсэгт файлыг чирэх даралтаар байршуулах';
$string['dndworkingfilelink'] = 'Хичээлийн хэсэгт файл эсвэл холбоосыг чирэх даралтаар байршуулах';
$string['dndworkingfiletext'] = 'Хичээлийн хэсэгт файл эсвэл бичвэрийг чирэх даралтаар байршуулах';
$string['dndworkingfiletextlink'] = 'Хичээлийн хэсэгт файл, бичвэр эсвэл холбоосыг чирэх даралтаар байршуулах';
$string['dndworkinglink'] = 'Хичээлийн хэсэгт холбоосыг чирэх даралтаар байршуулах';
$string['dndworkingtext'] = 'Хичээлийн хэсэгт бичвэрийг чирэх даралтаар байршуулах';
$string['dndworkingtextlink'] = 'Хичээлийн хэсэгт бичвэр эсвэл холбоосыг чирэх даралтаар байршуулах';
$string['documentation'] = 'Moodle бичиг баримт';
$string['dontsortcategories'] = 'Ангиллыг эрэмбэлэхгүй';
$string['dontsortcourses'] = 'Хичээлийг эрэмбэлэхгүй';
$string['down'] = 'Доошоо';
$string['download'] = 'Татаж авах';
$string['downloadall'] = 'Бүгдийг татаж авах';
$string['downloadexcel'] = 'Excel форматаар татаж авах';
$string['downloadfile'] = 'Файл татаж авах';
$string['downloadods'] = 'ODS форматаар татаж авах';
$string['downloadtext'] = 'Бичвэр форматаар татаж авах';
$string['doyouagree'] = 'Та эдгээр нөхцөлийг уншиж, ойлгосон уу?';
$string['droptoupload'] = 'Байршуулах файлыг чирэх даралтаар энд авчрах';
$string['duplicate'] = 'Хувилах';
$string['duplicatedmodule'] = '{$a} (хуулах)';
$string['duplicatedsection'] = '{$a} (хуулах)';
$string['edhelpaspellpath'] = 'Засварлагчид зөв бичгийн дүрмийн алдааг шалгахын тулд та сервертээ <strong>aspell 0.50</strong> эсвэл түүнээс дээших хувилбарыг суулгаж, программын хоёртын файлд хандах зөв замыг зааж өгөх шаардлагатай. Unix/Linux үйлдлийн системүүдэд уг зам нь ихэвчлэн <strong>/usr/bin/aspell</strong> байдаг ч өөр байж бас болно.';
$string['edhelpbgcolor'] = 'Засварлах талбарын дэвсгэр өнгийг тодорхойлно.<br />Зөвшөөрөгдөх утга нь, жишээлбэл: #FFFFFF буюу цагаан';
$string['edhelpcleanword'] = 'Энэ тохиргоо нь Word форматын шүүлтүүрийг идэвхтэй эсвэл идэвхгүй болгоно.';
$string['edhelpenablespelling'] = 'Зөв бичгийн дүрмийн алдааг шалгахыг идэвхжүүлэх эсвэл идэвхгүй болгох. Идэвхжүүлсэн тохиолдолд сервер дээр <strong>алдаа шалгах программ</strong> суулгагдсан байх шаардлагатай. Хоёр дахь утга нь <strong>өгөгдмөл толь бичиг</strong> байна. Энэ нь үгийн алдаа шалгах программ нь хэрэглэгчийн хэлний толь бичиггүй байх тохиолдолд ашиглах зориулалттай.';
$string['edhelpfontfamily'] = 'Бүл-фонтын шинж чанар гэдэг нь бүл фонтын нэрс ба/буюу үндсэн бүлийн нэрсийн жагсаалт болно. Бүлийн нэрсийг таслалаар тусгаарлах шаардлагатай.';
$string['edhelpfontlist'] = 'Засварлагчийн нээгдэх цэсэд ашиглах фонтыг тодорхойлох';
$string['edhelpfontsize'] = 'Өгөгдмөл фонт-хэмжээ нь фонтын хэмжээг тохируулдаг. <br />Хүчинтэй утгууд нь, жишээлбэл: дунд, маш том, жижиг, том, 10pt, 11px.';
$string['edit'] = 'Засварлах';
$string['edita'] = '{$a}-ийг засварлах';
$string['editcategorysettings'] = 'Ангиллын тохиргоог засварлах';
$string['editcategorythis'] = 'Энэ ангиллыг засварлах';
$string['editcoursesettings'] = 'Хичээлийн тохиргоог засварлах';
$string['editfiles'] = 'Файл засварлах';
$string['editgroupprofile'] = 'Бүлгийн профайлыг засварлах';
$string['editinga'] = '{$a}-ийг засварлаж байна';
$string['editingteachershort'] = 'Засварлагч';
$string['editlock'] = 'Энэ утгыг заса боломжгүй!';
$string['editmode'] = 'Горимыг засварлах';
$string['editmyprofile'] = 'Профайлыг засварлах';
$string['editorbgcolor'] = 'Дэвсгэр өнгө';
$string['editorcleanonpaste'] = 'Хуулах үед Word HTML цэвэрлэх';
$string['editorcommonsettings'] = 'Нийтлэг тохиргоо';
$string['editordefaultfont'] = 'Өгөгдмөл фонт';
$string['editorenablespelling'] = 'Үсгийн алдаа шалгахыг идэвхжүүлэх';
$string['editorfontlist'] = 'Фонтын жагсаалт';
$string['editorfontsize'] = 'Өгөгдмөл фонт-хэмжээ';
$string['editorpreferences'] = 'Засварлагчийн тохируулга';
$string['editorresettodefaults'] = 'Өгөгдмөл утгаар дахин тохируулах';
$string['editorsettings'] = 'Засварлагчийн тохиргоо';
$string['editorshortcutkeys'] = 'Засварлагчийн товчилбор товчлуурууд';
$string['editsection'] = 'Хэсгийг засварлах';
$string['editsectionname'] = 'Хэсгийн нэрийг засварлах';
$string['editsettings'] = 'Тохиргоог засварлах';
$string['editsummary'] = 'Дүгнэлтийг засварлах';
$string['editthisactivity'] = 'Энэ үйл ажиллагааг засварлах';
$string['editthiscategory'] = 'Энэ ангиллыг засварлах';
$string['edittitle'] = 'Гарчгийг засварлах';
$string['edittitleinstructions'] = 'Цуцлахдаа Escape, дуусгахдаа Enter товчлуурыг дарах';
$string['edituser'] = 'Хэрэглэгчийн бүртгэлийг засварлах';
$string['edulevel'] = 'Бүх арга хэмжээ';
$string['edulevel_help'] = '* Сургах - багшийн хийсэн үйлдэл, жишээ нь нөөцийг шинэчлэх
* Оролцох - суралцагчийн хийсэн үйлдэл, жишээ нь хэлэлцүүлэгт нийтлэл оруулах
* Бусад - багш, суралцагчаас бусад эрх бүхий хэрэглэгчийн хийсэн үйлдэл';
$string['edulevelother'] = 'Бусад';
$string['edulevelparticipating'] = 'Оролцож байгаа';
$string['edulevelteacher'] = 'Сургаж байгаа';
$string['email'] = 'Цахим шуудангийн хаяг';
$string['emailactive'] = 'Цахим шууданг идэвхжүүлсэн';
$string['emailagain'] = 'Цахим шуудан (дахин бичих)';
$string['emailalreadysent'] = 'Нууц үг шинэчлэх цахим шууданг хэдийнэ илгээсэн байна. Цахим шуудангаа шалгана уу.';
$string['emailcharset'] = 'Цахим шуудангийн тэмдэгтийн багц';
$string['emailconfirm'] = 'Бүртгэлээ баталгаажуулах';
$string['emailconfirmation'] = 'Сайн байна уу,

\'{$a->sitename}\' сайтад таны цахим шуудангийн хаягаас
бүртгэл үүсгэх хүсэлт ирсэн байна.

Шинэ бүртгэлээ дараах веб хаягаар хандан баталгаажуулна уу:

{$a->link}

Энэ нь ихэнх цахим шуудангийн программд цэнхэр өнгийн холбоос байдлаар
харагдах бөгөөд дээр нь дарахад хангалттай. Хэрэв энэ нь ажиллахгүй
байвал уг холбоосыг хуулж аваад веб хөтчийнхөө цонхны
дээд талд байрлах хаягийн мөрөнд оруулна.

Танд тусламж хэрэгтэй бол сайтын {$a->admin} администраторт хандана уу.';
$string['emailconfirmationresend'] = 'Баталгаажуулах цахим шууданг дахин илгээх';
$string['emailconfirmationsubject'] = '{$a}: бүртгэлийн баталгаажуулалт';
$string['emailconfirmsent'] = '<p>Таны <b>{$a}</b> хаяг руу цахим шуудан илгээсэн байх ёстой.</p>
   <p>Цахим шууданд бүртгэлийг дуусгах хялбар зааварчилгаа бий.</p>
   <p>Хэрэв танд асуудал байвал сайтын администратортой холбогдоно уу.</p>';
$string['emailconfirmsentfailure'] = 'Баталгаажуулах цахим шууданг илгээж чадсангүй';
$string['emailconfirmsentsuccess'] = 'Баталгаажуулах цахим шууданг амжилттай илгээсэн';
$string['emaildigest'] = 'Цахим шуудангийн товч агуулгын төрөл';
$string['emaildigest_help'] = 'Энэ нь хэлэлцүүлэгт өгөгдмөл байдлаар ашиглах өдөр тутмын товч агуулгын тохиргоо болно.

* Товч агуулга байхгүй - та хэлэлцүүлгийн нийтлэл тус бүрээр цахим шуудан хүлээн авах болно;
* Товч агуулга - бүрэн нийтлэл - та өдөр бүр хэлэлцүүлгийн нийтлэл бүрийн бүрэн агуулга бүхий товч агуулгын цахим шууданг хүлээн авах болно;
* Товч агуулга - зөвхөн гарчиг - та өдөр бүр хэлэлцүүлгийн нийтлэл бүрийн зөвхөн гарчгийг агуулсан товч агуулгын цахим шууданг хүлээн авах болно.

Хэрэв та хүсвэл хэлэлцүүлэг бүрд өөр өөр тохиргоог сонгож болно.';
$string['emaildigestcomplete'] = 'Бүрэн (бүтэн нийтлэл бүхий өдөр тутмын цахим шуудан)';
$string['emaildigestoff'] = 'Товч агуулгагүй (хэлэлцүүлгийн нийтлэл бүрээр нэг цахим шуудан)';
$string['emaildigestsubjects'] = 'Сэдэв (зөвхөн сэдэв бүхий өдөр тутмын цахим шуудан)';
$string['emaildisable'] = 'Энэ цахим шуудангийн хаяг идэвхгүй байна';
$string['emaildisableclick'] = 'Энэ хаяг руу бүх цахим шууданг илгээхийг идэвхгүй болгохын тулд энд дарна уу';
$string['emaildisplay'] = 'Цахим шуудангийн харагдах байдал';
$string['emaildisplay_help'] = '* Нуусан - Зөвхөн багш зэрэг зохих зөвшөөрөлтэй хэрэглэгч таны цахим шуудангийн хаягийг харах боломжтой.
* Хүн бүрд харагдана - Сайтын бүх хэрэглэгч таны цахим шуудангийн хаягийг харах боломжтой.
* Хичээлийн суралцагчид харагдана - Зөвхөн таны бүртгүүлсэн хичээлийн суралцагч таны цахим шуудангийн хаягийг харах боломжтой.';
$string['emaildisplaycourse'] = 'Хичээлийн суралцагчид харагдана';
$string['emaildisplaycoursemembersonly'] = '(Хичээлийн бусад оролцогчид харагдана)';
$string['emaildisplayeveryone'] = '(Хүн бүрд харагдана)';
$string['emaildisplayhide'] = '(Зохих зөвшөөрөлтэй хэрэглэгчээс бусад бүх хэрэглэгчээс нуусан)';
$string['emaildisplayno'] = 'Нуусан';
$string['emaildisplayyes'] = 'Хүн бүрд харагдана';
$string['emailenable'] = 'Энэ цахим шуудангийн хаягийг идэвхжүүлсэн';
$string['emailenableclick'] = 'Энэ хаяг руу илгээсэн бүх цахим шууданг дахин идэвхжүүлэхийн тулд энд дарна уу';
$string['emailexists'] = 'Энэ цахим шуудангийн хаяг өмнө нь бүртгэгдсэн байна.';
$string['emailexistshintlink'] = 'Мартагдсан хэрэглэгчийн нэр эсвэл нууц үгийг сэргээх';
$string['emailexistssignuphint'] = 'Та өмнө нь бүртгэл үүсгэсэн эсэх? {$a}';
$string['emailformat'] = 'Цахим шуудангийн формат';
$string['emailmustbereal'] = 'Жич: Таны цахим шуудангийн хаяг жинхэнэ байх ёстой';
$string['emailnotallowed'] = 'Эдгээр домэйны цахим шуудангийн хаягийг зөвшөөрөхгүй ({$a})';
$string['emailnotfound'] = 'Өгөгдлийн санд цахим шуудангийн хаяг олдсонгүй';
$string['emailonlyallowed'] = 'Энэ цахим шуудан нь зөвшөөрөгдсөн цахим шуудан биш байна ({$a})';
$string['emailpasswordchangeinfo'] = 'Сайн байна уу {$a->firstname},

Хэн нэгэн (магадгүй та өөрөө) \'{$a->sitename}\' сайт дахь таны \'{$a->username}\'
бүртгэлд шинэ нууц үг авах хүсэлт ирүүлсэн байна.

Нууц үгээ дараах веб хаягаар хандан өөрчилнө үү:

{$a->link}

Энэ нь ихэнх цахим шуудангийн программд цэнхэр өнгийн холбоос байдлаар
харагдах бөгөөд дээр нь дарахад хангалттай. Хэрэв энэ нь ажиллахгүй
байвал уг холбоосыг хуулж аваад веб хөтчийнхөө цонхны
дээд талд байрлах хаягийн мөрөнд оруулна.

Танд тусламж хэрэгтэй бол сайтын {$a->admin} администраторт хандана уу.';
$string['emailpasswordchangeinfodisabled'] = 'Сайн байна уу? {$a->firstname},

Хэн нэгэн (магадгүй та өөрөө) \'{$a->sitename}\' сайт дахь таны бүртгэлд шинэ нууц үг авах хүсэлт ирүүлсэн байна.

Харамсалтай нь энэ сайт дээрх таны бүртгэл идэвхгүй болсон тул нууц үгийг сэргээх боломжгүй. Сайтын {$a->admin} администратортой холбогдоно уу.';
$string['emailpasswordchangeinfofail'] = 'Сайн байна уу? {$a->firstname},

Хэн нэгэн  (магадгүй та өөрөө) \'{$a->sitename}\' сайт дахь таны бүртгэлд шинэ нууц үг авах хүсэлт ирүүлсэн байна.

Харамсалтай нь энэ сайт дээр нууц үгийг сэргээх боломжгүй. Сайтын {$a->admin} администратортой холбогдоно уу.';
$string['emailpasswordchangeinfosubject'] = '{$a}: Нууц үг солих мэдээлэл';
$string['emailpasswordconfirmation'] = 'Сайн байна уу {$a->firstname},

Хэн нэгэн (магадгүй та өөрөө) \'{$a->sitename}\' сайт дахь таны бүртгэлд шинэ нууц үг авах хүсэлт ирүүлсэн байна.

Хүсэлтээ баталгаажуулж, өөрийн цахим шуудангаар шинэ нууц үг авахын тулд
дараах веб хаягаар хандана уу:

{$a->link}

Энэ нь ихэнх цахим шуудангийн программд цэнхэр өнгийн холбоос байдлаар
харагдах бөгөөд дээр нь дарахад хангалттай. Хэрэв энэ нь ажиллахгүй
байвал уг холбоосыг хуулж аваад веб хөтчийнхөө цонхны
дээд талд байрлах хаягийн мөрөнд оруулна.

Танд тусламж хэрэгтэй бол {$a->admin} сайтын администраторт хандана уу.';
$string['emailpasswordconfirmationsubject'] = '{$a}: Нууц үг өөрчлөх баталгаажуулалт';
$string['emailpasswordconfirmmaybesent'] = '<p>Хэрэв та хэрэглэгчийн нэр эсвэл давтагдашгүй цахим шуудангийг хаягийг зөв оруулсан бол танд цахим шуудан илгээгдсэн байх ёстой.</p>
   <p>Энэ нь нууц үгийн өөрчлөлтийг баталгаажуулж, дуусгах хялбар зааварчилгаатай.
Хэрэв танд асуудал байвал сайтын администратортой холбогдоно уу.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Таны тодорхойлсон хэрэглэгчийн бүртгэлд бүртгэгдсэн цахим шуудангийн хаяг байхгүй байна.</p>
   <p>Сайтын администратортой холбогдоно уу.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Таны оруулсан хэрэглэгчийн мэдээлэл нь тухайн хэрэглэгчийн бүртгэлийг тодорхойлохгүй байна.</p>
   <p>Оруулсан мэдээллээ шалгаад дахин оролдоно уу.
Хэрэв танд асуудал байвал сайтын администратортой холбогдоно уу.</p>';
$string['emailpasswordconfirmsent'] = 'Таны <b>{$a}</b хаяг руу цахим шуудан илгээсэн байх ёстой.
<br />Энэ нь нууц үгийн өөрчлөлтийг баталгаажуулах, дуусгах хялбар зааварчилгаатай.
Хэрэв танд асуудал байвал сайтын администратортой холбогдоно уу.';
$string['emailpasswordsent'] = 'Нууц үгийн өөрчлөлтийг баталгаажуулсанд баярлалаа.
Таны шинэ нууц үгийг агуулсан цахим шууданг таны <br /><b>{$a->email}</b> хаягаар илгээсэн.<br />
Шинэ нууц үг автоматаар үүсгэгдсэн тул та тогтооход хялбар нууц үгээр<a href="{$a->link}">өөрийн нууц үгээ өөрчлөх</a> боломжтой.';
$string['emailresetconfirmation'] = 'Сайн байна уу {$a->firstname},

Таны {$a->sitename} дээрх \'{$a->username}\' бүртгэлд нууц үгийг шинэчлэх хүсэлт ирүүлсэн байна.

Энэ хүсэлтийг баталгаажуулж, өөрийн бүртгэлийн шинэ нууц үгийг дараах веб хаягаар хандан тохируулна орно уу:

{$a->link}
(Энэ холбоос нь нууц үгийг дахин тохируулах хүсэлт гаргаснаас хойш {$a->resetminutes} минутын хугацаанд хүчинтэй)

Хэрэв та энэ нууц үгийг шинэчлэх хүсэлтийг гаргаагүй бол ямар нэг үйлдэл хийх шаардлагагүй.

Танд тусламж хэрэгтэй бол сайтын {$a->admin} администратортой холбогдоно уу';
$string['emailresetconfirmationsubject'] = '{$a}: Нууц үг шинэчлэх хүсэлт';
$string['emailresetconfirmsent'] = 'Таны <b>{$a}</b> хаяг руу цахим шуудан илгээсэн.
<br />Энэ нь нууц үгийн өөрчлөлтийг баталгаажуулах, дуусгах хялбар зааварчилгаатай.
Хэрэв танд асуудал байвал сайтын администратортой холбогдоно уу.';
$string['emailstop'] = 'Мэдэгдлийг идэвхгүй болгох';
$string['emailtoprivatefiles'] = 'Түүнчлэн та файлыг шууд хавсралт хэлбэрээр цахим шуудангаар илгээх боломжтой. Файлаа цахим шуудандаа хавсаргаж, {$a} руу илгээнэ';
$string['emailtoprivatefilesdenied'] = 'Таны администратор хувийн файл байршуулах сонголтыг идэвхгүй болгосон байна.';
$string['emailvia'] = '{$a->name} ({$a->siteshortname} нэрээр)';
$string['emojicategoryactivities'] = 'Үйл ажиллагаанууд';
$string['emojicategoryanimalsnature'] = 'Амьтан ба байгаль орчин';
$string['emojicategoryflags'] = 'Далбаа';
$string['emojicategoryfooddrink'] = 'Хоол хүнс ба ундаа';
$string['emojicategoryobjects'] = 'Объектууд';
$string['emojicategorypeoplebody'] = 'Хүмүүс ба бие махбод';
$string['emojicategoryrecent'] = 'Сүүлийн үеийн';
$string['emojicategorysmileysemotion'] = 'Инээмсэглэл ба сэтгэл хөдлөл';
$string['emojicategorysymbols'] = 'Тэмдгүүд';
$string['emojicategorytravelplaces'] = 'Аялал ба газар орон';
$string['emptycmids'] = 'Хоосон хичээлийн модулийн ID дугаар';
$string['emptydragdropregion'] = 'хоосон бүс';
$string['emptysectionids'] = 'Хоосон хэсгийн ID дугаар';
$string['enable'] = 'Идэвхжүүлэх';
$string['encryptedcode'] = 'Шифрлэгдсэн код';
$string['enddate'] = 'Хичээл дуусах огноо';
$string['enddate_help'] = 'Хичээлийн тоймд тухайн хичээлийг дууссан гэж жагсаагдах эсэхийг хичээл дуусах огноогоор тодорхойлдог. Хичээл дуусах огноог тусгайлсан тайланд ашиглах боломжтой. Хэрэглэгч нь дуусах хугацааны дараа ч хичээлд орох боломжтой хэвээр байхыг анхаарна уу. Өөрөөр хэлбэл огноо нь хандалтыг хязгаарлахгүй.';
$string['english'] = 'Англи';
$string['enrolmentmethods'] = 'Элсэлтийн аргууд';
$string['entercourse'] = 'Энэ хичээлд орохын тулд энд дарна уу.';
$string['enteremail'] = 'Цахим шуудангийн хаягаа оруулна уу';
$string['enteremailaddress'] = 'Нууц үгээ шинэчлэхийн тулд цахим шуудангийн хаягаа оруулна
шинэ нууц үгийг цахим шуудангийн хаягаар илгээх болно.';
$string['enterusername'] = 'Өөрийн хэрэглэгчийн нэрээ оруулна уу';
$string['entries'] = 'Бичлэгүүд';
$string['error'] = 'Алдаа';
$string['errorcreatingactivity'] = '\'{$a}\' үйл ажиллагааны хүсэлтийг үүсгэх боломжгүй байна';
$string['errorfiletoobig'] = 'Файл нь {$a} байтын хязгаараас илүү том байсан';
$string['errornouploadrepo'] = 'Энэ сайтад байршуулах агуулахыг идэвхжүүлээгүй байна';
$string['errorwhenconfirming'] = 'Алдаа гарсан тул таныг хараахан баталгаажуулаагүй байна. Цахим шуудан доторх холбоос дээр дарж, тухайн холбоос эвдэрсэн эсвэл алдаатай эсэхийг шалгана. Холбоосыг зөв сэргээхийн тулд сонгон хуулаад хөтөчдөө оруулж болно.';
$string['eventcommentcreated'] = 'Сэтгэгдлийг үүсгэсэн';
$string['eventcommentdeleted'] = 'Сэтгэгдлийг устгасан';
$string['eventcommentsviewed'] = 'Сэтгэгдлийг үзсэн';
$string['eventconfiglogcreated'] = 'Тохиргооны лог бүртгэлийг үүсгэсэн';
$string['eventcontentviewed'] = 'Агуулгыг үзсэн';
$string['eventcoursebackupcreated'] = 'Хичээлийн нөөцлөлтийг үүсгэсэн';
$string['eventcoursecategorycreated'] = 'Ангиллыг үүсгэсэн';
$string['eventcoursecategorydeleted'] = 'Ангиллыг устгасан';
$string['eventcoursecategoryupdated'] = 'Ангиллыг шинэчилсэн';
$string['eventcoursecategoryviewed'] = 'Ангиллыг үзсэн';
$string['eventcoursecontentdeleted'] = 'Хичээлийн агуулгыг устгасан';
$string['eventcoursecreated'] = 'Хичээлийг үүсгэсэн';
$string['eventcoursedeleted'] = 'Хичээлийг устгасан';
$string['eventcourseinformationviewed'] = 'Хичээлийн хураангуйг үзсэн';
$string['eventcoursemodulecreated'] = 'Хичээлийн модулийг үүсгэсэн';
$string['eventcoursemoduledeleted'] = 'Хичээлийн модулийг устгасан';
$string['eventcoursemoduleinstancelistviewed'] = 'Хичээлийн модулийн хүсэлтийн жагсаалтыг үзсэн';
$string['eventcoursemoduleupdated'] = 'Хичээлийн модулийг шинэчилсэн';
$string['eventcoursemoduleviewed'] = 'Хичээлийн модулийг үзсэн';
$string['eventcourseresetended'] = 'Хичээлийг дахин тохируулж дууссан';
$string['eventcourseresetstarted'] = 'Хичээлийг дахин тохируулж эхэлсэн';
$string['eventcourserestored'] = 'Хичээлийг сэргээсэн';
$string['eventcoursesectioncreated'] = 'Хичээлийн хэсгийг үүсгэсэн';
$string['eventcoursesectiondeleted'] = 'Хичээлийн хэсгийг устгасан';
$string['eventcoursesectionupdated'] = 'Хичээлийн хэсгийг шинэчилсэн';
$string['eventcoursessearched'] = 'Хайлт хичээлүүд';
$string['eventcourseupdated'] = 'Хичээлийг шинэчилсэн';
$string['eventcourseuserreportviewed'] = 'Хичээлийн хэрэглэгчийн тайланг үзсэн';
$string['eventcourseviewed'] = 'Хичээлийг үзсэн';
$string['eventdashboardreset'] = 'Удирдах самбарыг дахин тохируулах';
$string['eventdashboardsreset'] = 'Удирдах самбаруудыг дахин тохируулах';
$string['eventdashboardviewed'] = 'Удирдах самбарыг харсан';
$string['eventdatabasetextfieldcontentreplaced'] = 'Өгөгдлийн санг нээлттэй хайх, орлуулах';
$string['eventemailfailed'] = 'Цахим шууданг илгээж чадсангүй';
$string['eventmycoursesviewed'] = 'Миний хичээлийг үзсэн';
$string['eventname'] = 'Арга хэмжээний нэр';
$string['eventrecentactivityviewed'] = 'Сүүлийн үйл ажиллагааг үзсэн';
$string['eventsearchindexed'] = 'Хайлтын өгөгдлийг индекслэсэн';
$string['eventsearchresultsviewed'] = 'Хайлтын үр дүнг харсан';
$string['eventunknownlogged'] = 'Тодорхойгүй арга хэмжээ';
$string['eventurlblocked'] = 'URL хаяг блоклогдсон';
$string['eventusercreated'] = 'Хэрэглэгчийг үүсгэсэн';
$string['eventuserdeleted'] = 'Хэрэглэгчийг устгасан';
$string['eventuserfeedbackgiven'] = 'Санал хүсэлтийн холбоосыг дарсан';
$string['eventuserfeedbackremind'] = 'Санал хүсэлтийн холбоос дарсныг сануулах';
$string['eventuserinfocategorycreated'] = 'Хэрэглэгчийн профайлын талбарын ангиллыг үүсгэсэн';
$string['eventuserinfocategorydeleted'] = 'Хэрэглэгчийн профайлын талбарын ангиллыг устгасан';
$string['eventuserinfocategoryupdated'] = 'Хэрэглэгчийн профайлын талбарын ангиллыг шинэчилсэн';
$string['eventuserinfofieldcreated'] = 'Хэрэглэгчийн профайлын талбарыг үүсгэсэн';
$string['eventuserinfofielddeleted'] = 'Хэрэглэгчийн профайлын талбарыг устгасан';
$string['eventuserinfofieldupdated'] = 'Хэрэглэгчийн профайлын талбарыг шинэчилсэн';
$string['eventuserlistviewed'] = 'Хэрэглэгчийн жагсаалтыг харсан';
$string['eventuserloggedout'] = 'Хэрэглэгч системээс гарсан';
$string['eventuserpasswordpolicyfailed'] = 'Хэрэглэгчийн нууц үг шаардлага хангахгүй байна';
$string['eventuserpasswordupdated'] = 'Хэрэглэгчийн нууц үг шинэчлэгдсэн байна';
$string['eventuserprofileviewed'] = 'Хэрэглэгчийн профайлыг харсан';
$string['eventuserupdated'] = 'Хэрэглэгч шинэчлэгдсэн';
$string['everybody'] = 'Бүгд';
$string['executeat'] = 'Гүйцэтгэх';
$string['existing'] = 'Одоо байгаа';
$string['existingadmins'] = 'Одоо байгаа админууд';
$string['existingcourse'] = 'Одоо байгаа хичээл';
$string['existingcourseadding'] = 'Одоо байгаа хичээл, түүнд өгөгдөл нэмж байна';
$string['existingcoursedeleting'] = 'Одоо байгаа хичээл, түүнийг эхэлж устгаж байна';
$string['existingcreators'] = 'Одоо байгаа хичээл үүсгэгчид';
$string['existingstudents'] = 'Бүртгэгдсэн суралцагчид';
$string['existingteachers'] = 'Одоо байгаа багш нар';
$string['expand'] = 'Өргөтгөх';
$string['expandall'] = 'Бүгдийг өргөтгөх';
$string['expandcategory'] = '{$a}-г өргөтгөх';
$string['explanation'] = 'Тайлбар';
$string['explanationdigitalminor'] = 'Энэ мэдээлэл нь таны насыг зөвшөөрөгдсөн дижитал наснаас хэтэрсэн эсэхийг тодорхойлоход шаардагддаг. Энэ бол хувь хүн нь ерөнхий нөхцөлийг тохиролцох, тэдгээрийн өгөгдлийг хууль ёсны дагуу хадгалах, боловсруулахыг зөвшөөрдөг нас юм.';
$string['extendperiod'] = 'Сунгасан хугацаа';
$string['extendsession'] = 'Сейшнийг сунгах';
$string['failedloginattempts'] = 'Та сүүлийн нэвтрэлтээс хойш {$a->attempts} удаа нэвтэрч чадсангүй.';
$string['favourites'] = 'Одоор тэмдэглэсэн';
$string['feedback'] = 'Санал хүсэлт';
$string['file'] = 'Файл';
$string['fileexists'] = '{$a} нэртэй файл байна';
$string['filemissing'] = '{$a} дутуу байна';
$string['filereaderror'] = '\'{$a}\' файлыг унших боломжгүй. Энэ нь хавтас бус, файл мөн эсэхийг шалгана уу.';
$string['files'] = 'Файлууд';
$string['filesanduploads'] = 'Файл болон байршуулалт';
$string['filesfolders'] = 'Файл/хавтас';
$string['fileuploadwithcontent'] = 'Файл байршуулалтад агуулгын параметрийг оруулахгүй';
$string['filloutallfields'] = 'Энэ маягтын бүх талбарыг бөглөнө үү';
$string['filter'] = 'Шүүлтүүр';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = '{$a} шүүлтүүр';
$string['filters'] = 'Шүүлтүүрүүд';
$string['filtersetmatchdescription'] = 'Олон шүүлтүүрийг хэрхэн нэгтгэх ёстой вэ';
$string['filtertype'] = 'Шүүлтүүрийн төрөл';
$string['findmorecourses'] = 'Илүү олон хичээлийг хайх...';
$string['first'] = 'Эхний';
$string['firstaccess'] = 'Эхний хандалт';
$string['firstname'] = 'Нэр';
$string['firstnamephonetic'] = 'Нэр -  авиа зүй';
$string['firstpage'] = 'Нэгдүгээр хуудас';
$string['firstsiteaccess'] = 'Сайтад анх удаа нэвтрэх';
$string['firsttime'] = 'Та энд анх удаагаа хандаж байна уу?';
$string['folder'] = 'Хавтас';
$string['folderclosed'] = 'Хаалттай хавтас';
$string['folderopened'] = 'Нээлттэй хавтас';
$string['followingoptional'] = 'Дараах зүйлс нь сонголттой';
$string['followingrequired'] = 'Дараах зүйлс нь шаардлагатай';
$string['for'] = 'Тулд';
$string['force'] = 'Албадах';
$string['forcelanguage'] = 'Хэлийг албадан оноох';
$string['forceno'] = 'Шаардахгүй';
$string['forcepasswordchange'] = 'Нууц үг солихыг шаардах';
$string['forcepasswordchange_help'] = 'Энэ нүдийг сонгосон тохиолдолд хэрэглэгч дараагийн удаа нэвтрэхэд нууц үгээ солихыг шаардах болно';
$string['forcepasswordchangecheckfull'] = 'Та нууц үгээ {$a} болгон өөрчлөхөд итгэлтэй байна уу?';
$string['forcepasswordchangenot'] = 'Нууц үгийг {$a} болгон өөрчилж чадсангүй';
$string['forcepasswordchangenotice'] = 'Та үргэлжлүүлэхийн тулд нууц үгээ өөрчлөх шаардлагатай.';
$string['forcepasswordresetfailurenotice'] = 'Таны одоо ашиглаж байгаа нууц үг нь нууц үгийн шаардлагыг хангаж чадахгүй болсон байна. Тусламж шаардлагатай бол Moodle системийн администратортой холбогдоно уу.
  {$a}';
$string['forcepasswordresetnotice'] = 'Таны одоо ашиглаж байгаа нууц үг нь нууц үгийн шаардлагыг хангаж чадахгүй болсон тул нэвтрэхийн тулд нууц үгээ шинэчлэх шаардлагатай.
   {$a}';
$string['forcetheme'] = 'Загварыг шууд оноох';
$string['forgotaccount'] = 'Нууц үгээ алдсан эсэх?';
$string['forgotten'] = 'Хэрэглэгчийн нэр эсвэл нууц үгээ мартсан эсэх?';
$string['forgottenduplicate'] = 'Энэ цахим шуудангийн хаягийг хэд хэдэн бүртгэлд ашиглаж байгаа тул үүний оронд хэрэглэгчийн нэрийн оруулна уу';
$string['forgotteninvalidurl'] = 'Нууц үг шинэчлэх URL хаяг буруу байна';
$string['format'] = 'Формат';
$string['format_help'] = 'Хичээлийн формат нь хичээлийн хуудасны бүтцийг тодорхойлдог.

* Нэг үйл ажиллагааны формат - Хичээлийн хуудсанд нэг үйл ажиллагаа эсвэл нөөцийг (Quiz, SCORM багц гэх мэт) харуулахад зориулагдсан
* Нийтийн формат - Хичээлийн хуудсанд хэлэлцүүлгийг харуулна
* Сэдвийн формат - Хичээлийн хуудсыг сэдвийн хэсгүүдэд хуваан харуулна
* Долоо хоногийн формат - Хичээлийн хуудсыг долоо хоногийн хэсгүүдэд хуваах ба хичээл эхэлсэн өдрөөс хичээлийн эхний долоо хоног эхэлнэ';
$string['formathtml'] = 'HTML формат';
$string['formatmarkdown'] = 'Маркдаун формат';
$string['formatplain'] = 'Энгийн бичвэр формат';
$string['formattext'] = 'Moodle авто-формат';
$string['forumpreferences'] = 'Хэлэлцүүлгийн тохиргоо';
$string['framesetinfo'] = 'Энэ хүрээний баримт бичиг нь:';
$string['from'] = 'Хаанаас';
$string['fromdate'] = 'Хаанаас';
$string['fromsender'] = 'Хаанаас';
$string['frontpagecategorycombo'] = 'Бичвэрт жагсаалт';
$string['frontpagecategorynames'] = 'Ангиллын жагсаалт';
$string['frontpagecourselist'] = 'Хичээлийн жагсаалт';
$string['frontpagecoursesearch'] = 'Хичээл хайх талбар';
$string['frontpagedescription'] = 'Сайтын нүүр хуудасны хураангуй';
$string['frontpagedescriptionhelp'] = 'Сайтын нүүр хуудсанд энэ тоймыг хичээл/сайтын тоймын блокыг ашиглан харуулж болно.';
$string['frontpageenrolledcourselist'] = 'Хамрагдсан хичээлүүд';
$string['frontpageformat'] = 'Сайтын нүүр хуудасны формат';
$string['frontpageformatloggedin'] = 'Нэвтэрсний дараах сайтын нүүр хуудасны формат';
$string['frontpagenews'] = 'Зарлал';
$string['frontpagesettings'] = 'Сайтын нүүр хуудасны тохиргоо';
$string['fulllistofcourses'] = 'Бүх хичээл';
$string['fullname'] = 'Бүтэн нэр';
$string['fullnamecourse'] = 'Хичээлийн бүтэн нэр';
$string['fullnamecourse_help'] = 'Хичээлийн бүтэн нэрийг хичээлийн хуудас бүрийн дээд талд болон хичээлийн жагсаалтад харуулна.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Хэрэглэгчийн бүтэн нэр';
$string['fullprofile'] = 'Бүрэн профайл';
$string['fullsitename'] = 'Сайтын бүтэн нэр';
$string['functiondisabled'] = 'Энэ функц одоогоор идэвхгүй байна';
$string['general'] = 'Ерөнхий';
$string['geolocation'] = 'өргөрөг - уртраг';
$string['gettheselogs'] = 'Эдгээр лог бүртгэлийг авах';
$string['go'] = 'Ажиллах';
$string['gpl'] = 'Зохиогчийн эрх (C) 1999 оноос хойш Мартин Доугиамас (http://moodle.com)

Энэ нь  үнэгүй программ хангамж юм. Та уг программын лицензийн хувилбар 2 эсвэл дараагийн дурын хувилбарыг (таны сонголтоор) Чөлөөт программ хангамжийн сангаас гаргасан GNU олон нийтийн ерөнхий лицензийн дагуу дахин түгээх ба/буюу сайжруулах боломжтой.

Энэ программыг ЯМАР Ч БАТАЛГААГҮЙ, АРИЛЖААНЫ эсвэл ТОДОРХОЙ ЗОРИУЛАЛТЫН ТААРАМЖИЙН  баталгааг үл харгалзан ашигтай байх болно хэмээн үзэж тараадаг.

Дэлгэрэнгүй мэдээллийг Moodle лицензийн мэдээллийн хуудаснаас авна уу:
http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Зохиогчийн эрх (c) 1999 оноос хойш Мартин Доугиамас  (http://moodle.com)

Энэ бол үнэгүй программ хангамж юм. Энэ программ нь  үнэгүй программ хангамж юм. Та уг программын лицензийн хувилбар 3 эсвэл дараагийн дурын хувилбарыг (таны сонголтоор) Чөлөөт программ хангамжийн сангаас гаргасан GNU олон нийтийн ерөнхий лицензийн дагуу дахин түгээх ба/буюу сайжруулах боломжтой.

Энэ программыг ЯМАР Ч БАТАЛГААГҮЙ, АРИЛЖААНЫ эсвэл ТОДОРХОЙ ЗОРИУЛАЛТЫН ТААРАМЖИЙН  баталгааг үл харгалзан ашигтай байх болно хэмээн үзэж тараадаг.

Дэлгэрэнгүй мэдээллийг Moodle лицензийн мэдээллийн хуудаснаас авна уу:
http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'GPL лиценз';
$string['gradenoun'] = 'Үнэлгээ';
$string['grades'] = 'Үнэлгээ';
$string['gradeverb'] = 'Үнэлгээ';
$string['gravatarenabled'] = 'Энэ сайтад <a href="http://www.gravatar.com/">Граватар</a> идэвхтэй байна. Хэрэв та профайлдаа зураг байршуулахгүй бол Moodle Граватараас таны профайлын зургийг ачаалах болно.';
$string['group'] = 'Бүлэг';
$string['groupadd'] = 'Шинэ бүлэг нэмэх';
$string['groupaddusers'] = 'Сонгосныг бүлэгт нэмэх';
$string['groupfor'] = 'бүлэгт';
$string['groupinfo'] = 'Сонгосон бүлгийн талаарх мэдээлэл';
$string['groupinfoedit'] = 'Бүлгийн тохиргоог засварлах';
$string['groupinfomembers'] = 'Сонгосон гишүүний талаарх мэдээлэл';
$string['groupinfopeople'] = 'Сонгосон хүмүүсийн талаарх мэдээлэл';
$string['groupmembers'] = 'Бүлгийн гишүүд';
$string['groupmemberssee'] = 'Бүлгийн гишүүдийг харах';
$string['groupmembersselected'] = 'Сонгосон бүлгийн гишүүд';
$string['groupmode'] = 'Бүлгийн горим';
$string['groupmodeforce'] = 'Бүлгийн горимыг шууд тогтоох';
$string['groupmy'] = 'Миний бүлэг';
$string['groupnonmembers'] = 'Бүлэггүй хүмүүс';
$string['groupnotamember'] = 'Уучлаарай, та энэ бүлгийн гишүүн биш байна';
$string['grouprandomassign'] = 'Бүгдийг бүлэгт санамсаргүй байдлаар хуваарилах';
$string['groupremove'] = 'Сонгосон бүлгийг устгах';
$string['groupremovemembers'] = 'Сонгосон гишүүдийг устгах';
$string['groups'] = 'Бүлгүүд';
$string['groupsnone'] = 'Бүлэггүй';
$string['groupsseparate'] = 'Бие даасан бүлгүүд';
$string['groupsvisible'] = 'Харагдах бүлгүүд';
$string['guest'] = 'Зочин';
$string['guestdescription'] = 'Зочин нь хамгийн бага давуу эрхтэй байх ба бичвэрийг хаана ч оруулж чадахгүй.';
$string['guestskey'] = 'Түлхүүртэй зочныг зөвшөөрөх';
$string['guestsno'] = 'Зочин хандахыг хориглох';
$string['guestsnotallowed'] = 'Уучлаарай, \'{$a}\' нь зочинг хандахыг зөвшөөрөхгүй байна';
$string['guestsyes'] = 'Түлхүүргүй зочныг зөвшөөрөх';
$string['guestuser'] = 'Зочин хэрэглэгч';
$string['guestuserinfo'] = 'Энэ хэрэглэгч нь зарим хичээлд зөвхөн унших эрхтэй тусгай хэрэглэгч байна.';
$string['help'] = 'Тусламж';
$string['helpprefix2'] = '{$a} бүхий тусламж';
$string['helpwiththis'] = 'Энэ талаар туслах';
$string['hiddenassign'] = 'Нуусан даалгавар';
$string['hiddenfromstudents'] = 'Суралцагчаас нуусан';
$string['hiddenoncoursepage'] = 'Боломжтой боловч хичээлийн хуудсанд харагдахгүй байна';
$string['hiddensections'] = 'Нуусан хэсгүүд';
$string['hiddensections_help'] = 'Нуусан хэсгүүдийг суралцагчдад боломжгүй гэж харуулах (магадгүй амралтын өдрийг заах долоо хоногийн формат бүхий хичээл байж болно) эсвэл огт бүрмөсөн нууна.';
$string['hiddensectionscollapsed'] = 'Нуусан хэсгүүдийг боломжгүй гэж харуулна';
$string['hiddensectionsinvisible'] = 'Нуусан хэсгүүдийг бүрмөсөн харуулахгүй';
$string['hiddenwithbrackets'] = '(нуусан)';
$string['hide'] = 'Нуух';
$string['hideadvancedsettings'] = 'Дэлгэрэнгүй тохиргоог нуух';
$string['hidechartdata'] = 'Диаграммын өгөгдлийг нуух';
$string['hidefromstudents'] = 'Хичээлийн хуудсанд нуух';
$string['hideoncoursepage'] = 'Боломжтой боловч хичээлийн хуудсанд харуулахгүй';
$string['hidepopoverwindow'] = 'Давхарга цонхыг нуух';
$string['hidesection'] = '{$a} хэсгийг нуух';
$string['hidesettings'] = 'Тохиргоог нуух';
$string['hideshowblocks'] = 'Блокыг нуух эсвэл харуулах';
$string['highlight'] = 'Тодруулах';
$string['highlighted'] = 'Тодруулсан';
$string['highlightoff'] = 'Тодруулсныг арилгах';
$string['hits'] = 'Даралт';
$string['hitsoncourse'] = '{$a->username} хэрэглэгчийн {$a->coursename} дээр дарсан тоо';
$string['hitsoncoursetoday'] = '{$a->username} хэрэглэгчийн {$a->coursename} дээр дарсан өнөөдрийн тоо';
$string['home'] = 'Нүүр хуудас';
$string['homeheader'] = 'Нүүр хуудасны цэс';
$string['hour'] = 'цаг';
$string['hours'] = 'цаг';
$string['howtomakethemes'] = 'Шинэ загварыг хэрхэн гаргах вэ';
$string['htmleditor'] = 'HTML засварлагч ашиглах';
$string['htmleditoravailable'] = 'HTML засварлагчийг хэрэглэх боломжтой';
$string['htmleditordisabled'] = 'Та хэрэглэгчийн профайл дээрх HTML засварлагчийг идэвхгүй болгосон байна';
$string['htmleditordisabledadmin'] = 'Администратор энэ сайт дээрх HTML засварлагчийг идэвхгүй болгосон байна';
$string['htmleditordisabledbrowser'] = 'Таны веб хөтөч тохирохгүй тул HTML засварлагчийг ашиглах боломжгүй';
$string['htmlfilesonly'] = 'Зөвхөн HTML файл';
$string['htmlformat'] = 'HTML формат';
$string['icon'] = 'Дүрст тэмдэг';
$string['idnumber'] = 'ID дугаар';
$string['idnumbercourse'] = 'Хичээлийн ID дугаар';
$string['idnumbercourse_help'] = 'Хичээлийн ID дугаарыг зөвхөн тухайн хичээлийг гадаад системтэй нийцүүлэхэд ашигладаг бөгөөд сайтын хаана ч харуулдаггүй. Хичээл нь албан ёсны кодын нэртэй бол түүнийг оруулах эсвэл уг талбарыг хоосон орхиж болно.';
$string['idnumbercoursecategory'] = 'Ангиллын ID дугаар';
$string['idnumbercoursecategory_help'] = 'Хичээлийн ангиллын ID дугаарыг зөвхөн тухайн ангиллыг гадаад системтэй нийцүүлэхэд ашигладаг бөгөөд сайтын хаана ч харуулдаггүй. Ангилал нь албан ёсны кодын нэртэй бол түүнийг оруулах эсвэл уг талбарыг хоосон орхиж болно.';
$string['idnumbergroup'] = 'Бүлгийн ID дугаар';
$string['idnumbergroup_help'] = 'Бүлгийн ID дугаарыг зөвхөн тухайн бүлгийг гадаад системтэй нийцүүлэхэд ашигладаг бөгөөд сайтын хаана ч харуулдаггүй. Бүлэг нь албан ёсны кодын нэртэй бол түүнийг оруулах эсвэл уг талбарыг хоосон орхиж болно.';
$string['idnumbergrouping'] = 'Бүлэглэлийн ID дугаар';
$string['idnumbergrouping_help'] = 'Бүлэглэлийн ID дугаарыг зөвхөн тухайн бүлэглэлийг гадаад системтэй нийцүүлэхэд ашигладаг бөгөөд сайтын хаана ч харуулдаггүй. Бүлэглэл нь албан ёсны кодын нэртэй бол түүнийг оруулах эсвэл уг талбарыг хоосон орхиж болно.';
$string['idnumbermod'] = 'ID дугаар';
$string['idnumbermod_help'] = 'ID дугаарын тохируулга нь үнэлгээг тооцоолох, тусгайлсан тайлан гаргах зэрэг зорилгоор хийгдэх үйл ажиллагаа эсвэл нөөцийг тодорхойлох боломжийг олгодог. Шаардлагагүй бол уг талбарыг хоосон үлдээж болно.

Үнэлэгдэх үйл ажиллагааны тухайд ID дугаарыг журналд оруулж болох ч үүнийг зөвхөн үйл ажиллагааны тохиргооны хуудсанд л засварлах боломжтой.';
$string['idnumbertaken'] = 'Энэ ID дугаарыг хэдийнэ олгосон байна';
$string['imagealt'] = 'Зургийн тайлбар';
$string['import'] = 'Импортлох';
$string['importdata'] = 'Хичээлийн өгөгдлийг импортлох';
$string['importdataexported'] = '\'Хаанаас\' хичээлийн өгөгдлийг амжилттай экспортоллоо.<br /> \'Оруулах\' хичээл рүү үргэлжлүүлэн импортолно уу.';
$string['importdatafinished'] = 'Импортолж дууслаа! Хичээлээ үргэлжлүүлнэ үү';
$string['importdatafrom'] = 'Өгөгдлийг нь импортлох хичээл хайх:';
$string['inactive'] = 'Идэвхгүй';
$string['include'] = 'Оруулах';
$string['includeallusers'] = 'Бүх хэрэглэгчийг оруулах';
$string['includecoursefiles'] = 'Хичээлийн файлыг оруулах';
$string['includecourseusers'] = 'Хичээлийн суралцагчдыг оруулах';
$string['included'] = 'Оруулсан';
$string['includelogentries'] = 'Лог бүртгэлийн бичилтийг оруулах';
$string['includemodules'] = 'Модуль оруулах';
$string['includemoduleuserdata'] = 'Модулийн хэрэглэгчийн өгөгдлийг оруулах';
$string['includeneededusers'] = 'Шаардлагатай хэрэглэгчдийг оруулах';
$string['includenoneusers'] = 'Хэрэглэгчийг оруулахгүй';
$string['includeroleassignments'] = 'Эрхийн хуваарилалтыг оруулах';
$string['includesitefiles'] = 'Энэ хичээлд ашигласан сайтын файлыг оруулах';
$string['includesubcategories'] = 'Дэд ангилал оруулах';
$string['includeuserfiles'] = 'Хэрэглэгчийн файлыг оруулах';
$string['increasesections'] = 'Хэсгийн тоог ихэсгэх';
$string['indicator:accessesafterend'] = 'Хичээл дуусах хугацаанаас хойш хичээлд хандсан';
$string['indicator:accessesafterend_help'] = 'Энэ шалгуур үзүүлэлт нь суралцагч хичээл дуусах хугацаанаас хойш тухайн хичээлд хандсан эсэхийг харуулна.';
$string['indicator:accessesbeforestart'] = 'Хичээл эхлэх хугацаанаас өмнө хичээлд хандсан';
$string['indicator:accessesbeforestart_help'] = 'Энэ шалгуур үзүүлэлт нь суралцагч хичээл эхлэх хугацаанаас өмнө тухайн хичээлд хандсан эсэхийг харуулна.';
$string['indicator:activitiesdue'] = 'Гүйцэтгэвэл зохих үйл ажиллагаа';
$string['indicator:activitiesdue_help'] = 'Хэрэглэгчийн гүйцэтгэвэл зохих үйл ажиллагаа байна.';
$string['indicator:anycourseaccess'] = 'Бүх хичээлд нэвтрэх боломж';
$string['indicator:anycourseaccess_help'] = 'Энэ шалгуур үзүүлэлт нь суралцагч бүртгүүлсэн бүх хичээлдээ хандах боломжийг харуулна.';
$string['indicator:anywrite'] = 'Дурын бичих үйлдэл';
$string['indicator:anywrite_help'] = 'Энэ шалгуур үзүүлэлт нь суралцагчийн гүйцэтгэсэн бичих (илгээх) дурын үйлдлийг харуулна.';
$string['indicator:anywriteincourse'] = 'Хичээлийн хүрээнд бичих дурын үйлдэл';
$string['indicator:anywriteincourse_help'] = 'Энэ шалгуур үзүүлэлт нь суралцагч хичээлийн хүрээнд гүйцэтгэсэн бичих (илгээх) дурын үйлдлийг харуулна.';
$string['indicator:completeduserprofile'] = 'Хэрэглэгчийн профайлыг бүрэн үүсгэсэн';
$string['indicator:completeduserprofile_help'] = 'Энэ шалгуур үзүүлэлт нь суралцагч өөрийн хэрэглэгчийн профайлыг бүрэн үүсгэснийг харуулна.';
$string['indicator:completeduserprofiledef'] = 'Хэрэглэгчийн профайлыг бүрэн үүсгэсэн';
$string['indicator:completeduserprofiledef_help'] = 'Хэрэглэгч сайтын бодлогыг хүлээн зөвшөөрч, дараах талбарыг бөглөсөн байна. Үүнд: Байгууллага, Хэлтэс, Хаяг, Хот, Улс, URL хаяг.';
$string['indicator:completionenabled'] = 'Гүйцэтгэлийн хяналтыг идэвхжүүлсэн';
$string['indicator:completionenabled_help'] = 'Энэ шалгуур үзүүлэлт нь хичээлийн гүйцэтгэлийн хяналтыг идэвхжүүлснийг харуулна.';
$string['indicator:nostudent'] = 'Суралцагчийн бүртгэл';
$string['indicator:nostudent_help'] = 'Энэ шалгуур үзүүлэлт нь хичээлд хамрагдах боломжтой суралцагчдыг харуулна.';
$string['indicator:noteacher'] = 'Багшийн хүртээмж';
$string['indicator:noteacher_help'] = 'Энэ шалгуур үзүүлэлт нь хичээлийг заах боломжтой багш нарыг харуулна.';
$string['indicator:potentialcognitive'] = 'Хичээлийн танин мэдэхүйн боломжит гүнзгийрэлт';
$string['indicator:potentialcognitive_help'] = 'Энэ шалгуур үзүүлэлт нь хичээлд хамрагдаж байгаа суралцагчийн эзэмших танин мэдэхүйн боломжит гүйнзгийрэлтэд тулгуурладаг.';
$string['indicator:potentialcognitivedef'] = 'Хичээлийн танин мэдэхүйн боломжит гүнзгийрэлт';
$string['indicator:potentialcognitivedef_help'] = 'Хичээлд санал болгож буй танин мэдэхүйн "идэвхтэй" оролцооны түвшин. Жишээлбэл санал хүсэлтийн дагуу ажил илгээх, бусдын ажлыг хянан үзэх, ажлаа хянан засварлаж, дахин илгээх боломж.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Хичээлийн нийгмийн боломжит чөлөөт байдал';
$string['indicator:potentialsocial_help'] = 'Энэ шалгуур үзүүлэлт нь хичээлийн үйл ажиллагаанд оролцож буй суралцагчийн хүрвэл зохих нийгмийн боломжит чөлөөт байдалд тулгуурладаг.';
$string['indicator:potentialsocialdef'] = 'Хичээлийн нийгмийн боломжит чөлөөт байдал';
$string['indicator:potentialsocialdef_help'] = 'Хичээлийн хүрээнд суралцагч бусад оролцогч болон хичээлээс гадуурх бусад хүмүүстэй харилцах нийгмийн "өргөн хүрээний" оролцооны түвшин.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Унших үйлдлийн тоо';
$string['indicator:readactions_help'] = 'Энэ шалгуур үзүүлэлт нь суралцагчийн гүйцэтгэсэн унших (харах) үйлдлийн тоог харуулна.';
$string['indicator:userforumstracking'] = 'Хэрэглэгч хэлэлцүүлгийг дагаж байна';
$string['indicator:userforumstracking_help'] = 'Энэ шалгуур үзүүлэлт нь суралцагч хэлэлцүүлэгт дагах үйлдлийг идэвхжүүлсэн эсэхийг харуулна.';
$string['info'] = 'Мэдээлэл';
$string['inprogress'] = 'Явагдаж байна';
$string['insertresourceoractivitybefore'] = '\'{$a->activityname}\' үйл ажиллагааны өмнө үйл ажиллагаа эсвэл нөөц оруулах';
$string['institution'] = 'Байгууллага';
$string['instudentview'] = 'Суралцагчийн харагдацаар';
$string['interests'] = 'Сонирхол';
$string['interestslist'] = 'Сонирхлын жагсаалт';
$string['interestslist_help'] = 'Өөрийн сонирхлыг нэг нэгээр нь оруулбал профайл хуудсанд таг хэлбэрээр харагдах болно.';
$string['invalidemail'] = 'Хүчингүй цахим шуудангийн хаяг';
$string['invalidlogin'] = 'Нэвтрэлт алдаатай байна, дахин хандана уу';
$string['invalidtaskclassname'] = '{$a} даалгаврын класс буруу';
$string['invalidtaskid'] = 'Даалгаврын ID дугаар буруу';
$string['invalidusername'] = 'Хэрэглэгчийн нэр нь зөвхөн жижиг тэмдэгт (үсэг ба тоо), доогуур зураас (_), дундуур зураас (-), цэг (.) эсвэл эт тэмдэг (@) агуулсан байж болно.';
$string['invalidusernameupload'] = 'Хэрэглэгчийн нэр буруу';
$string['ip_address'] = 'IP хаяг';
$string['jump'] = 'Шилжих';
$string['jumpto'] = 'Шилжих...';
$string['keep'] = 'Хадгалах';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Хэлний чиглэл нь зүүнээс-баруун';
$string['langrtl'] = 'Хэлний чиглэл нь баруунаас-зүүн';
$string['language'] = 'Хэл';
$string['languagegood'] = 'Энэ хэлний багц шинэчлэгдсэн! :-)';
$string['languageselector'] = 'Хэл сонгогч';
$string['last'] = 'Хамгийн сүүлийн';
$string['lastaccess'] = 'Хамгий сүүлийн хандалт';
$string['lastcourseaccess'] = 'Хичээлийн хамгийн сүүлийн хандалт';
$string['lastedited'] = 'Хамгийн сүүлд засварласан';
$string['lastip'] = 'Хамгийн сүүлийн IP хаяг';
$string['lastlogin'] = 'Хамгийн сүүлийн нэвтрэлт';
$string['lastmodified'] = 'Хамгийн сүүлд засварласан';
$string['lastname'] = 'Овог';
$string['lastnamephonetic'] = 'Овог - галигласан';
$string['lastpage'] = 'Сүүлчийн хуудас';
$string['lastsiteaccess'] = 'Сайтын хамгийн сүүлийн хандалт';
$string['lastyear'] = 'Өнгөрсөн жил';
$string['latestlanguagepack'] = 'moodle.org сайтаас хамгийн сүүлд шинэчлэгдсэн хэлний багцыг шалгах';
$string['layouttable'] = 'Бүтцийн хүснэгт';
$string['leavetokeep'] = 'Одоогийн нууц үгийг хэвээр хадгалах бол хоосон үлдээнэ үү';
$string['legacylogginginuse'] = 'Энэ сайт одоогоор хуучин лог бүртгэлийн санд бичилт хийхийг идэвхжүүлсэн байна. Энэ лог бүртгэлийн санд бичилт хийх шаардлагагүй. "Стандарт" эсвэл "гадаад" зэрэг дэмжигдсэн лог бүртгэлийн санд бичилт хийнэ үү.';
$string['legacythemeinuse'] = 'Таны хөтөч хэт хуучирсан тул энэ сайт тохирох горимоор харуулж байна.';
$string['license'] = 'Лиценз';
$string['licenses'] = 'Лицензүүд';
$string['liketologin'] = 'Та хэрэглэгчийн бүрэн бүртгэлээр нэвтрэхийг хүсэж байна уу?';
$string['list'] = 'Жагсаалт';
$string['listfiles'] = '{$a}-д байгаа файлын жагсаалт';
$string['listofallpeople'] = 'Бүх хүмүүсийн жагсаалт';
$string['listofcourses'] = 'Хичээлийн жагсаалт';
$string['loading'] = 'Ачаалж байна';
$string['loadinghelp'] = 'Ачаалж байна...';
$string['local'] = 'Дотоод';
$string['localplugins'] = 'Дотоод нэмэлт хэрэгсэл';
$string['localpluginsmanage'] = 'Дотоод нэмэлт хэрэгслийг удирдах';
$string['location'] = 'Байрлал';
$string['locktimeout'] = 'Түгжихийг хүлээх зуур үйл ажиллагааны хугацаа дууссан.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Та {$a} нэрээр нэвтэрсэн байна';
$string['loggedinasguest'] = 'Та одоогоор зочны хандалтыг ашиглаж байна';
$string['loggedinnot'] = 'Та нэвтэрч ороогүй байна';
$string['login'] = 'Нэвтрэх';
$string['login_failure_logs'] = 'Нэвтрэлтийн алдааны лог бүртгэл';
$string['loginactivity'] = 'Нэвтрэх үйл ажиллагаа';
$string['loginagain'] = 'Дахин нэвтрэх';
$string['loginalready'] = 'Та хэдийнэ нэвтэрсэн байна';
$string['loginas'] = 'Нэвтрэх';
$string['loginaspasswordexplain'] = '<p>Та энэ функцыг ашиглахын тулд "loginas password" гэж тусгайлан оруулна.<br />Энэ талаар мэдэхгүй бол серверийн администратороос асууна уу.</p>';
$string['loginguest'] = 'Зочин эрхээр нэвтрэх';
$string['loginsite'] = 'Сайтад нэвтрэх';
$string['loginsteps'] = 'Та энэ сайтад бүрэн нэвтрэхийн тулд эхлээд бүртгэлээ үүсгэх хэрэгтэй.';
$string['loginstepsnone'] = '<p>Сайн байна уу!</p>
<p>Хичээлд бүрэн хандахын тулд та өөрөө бүртгэл үүсгэх шаардлагатай.</p>
<p>Та хэрэглэгчийн нэр, нууц үгээ үүсгээд энэ хуудасны маягтад оруулах хэрэгтэй!</p>
<p>Хэрэв хэн нэгэн таны хэрэглэгчийн нэрийг хэдийнэ сонгосон бол та өөр хэрэглэгчийн нэрээр дахин оролдох хэрэгтэй.</p>';
$string['loginto'] = '{$a} руу нэвтрэх';
$string['logoof'] = '{$a}-н лого';
$string['logout'] = 'Гарах';
$string['logoutconfirm'] = 'Та гарахыг хүсэж байна уу?';
$string['logs'] = 'Лог бүртгэл';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">илүү</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">илүү</a> ]';
$string['lookback'] = 'Эргэж харах';
$string['mailadmins'] = 'Админд мэдэгдэх';
$string['mailstudents'] = 'Суралцагчид мэдэгдэх';
$string['mailteachers'] = 'Багшид мэдэгдэх';
$string['maincoursepage'] = 'Хичээлийн үндсэн хуудас';
$string['makeafolder'] = 'Хавтас шинээр үүсгэх';
$string['makeavailable'] = 'Боломжтой болгох';
$string['makeeditable'] = 'Хэрэв та \'{$a}\' файлыг веб серверийн процессоор (apache гэх мэт) засварлах боломжтой болговол энэ хуудаснаас уг файлыг шууд засварлаж болно';
$string['makethismyhome'] = 'Үүнийг миний нүүр хуудас болгох';
$string['makeunavailable'] = 'Боломжгүй болгох';
$string['manageblocks'] = 'Блок';
$string['managecategories'] = 'Хичээлийн ангиллыг удирдах';
$string['managecategorythis'] = 'Энэ ангиллыг удирдах';
$string['managecombined'] = 'Хичээлийн ангилал ба хичээлийг удирдах';
$string['managecontentbanktypes'] = 'Агуулгын төрлийг удирдах';
$string['managecourses'] = 'Хичээлийг удирдах';
$string['managedatabase'] = 'Өгөгдлийн сан';
$string['managedataformats'] = 'Өгөгдлийн форматыг удирдах';
$string['manageeditorfiles'] = 'Засварлагчийн ашигласан файлыг удирдах';
$string['managefilters'] = 'Шүүлтүүр';
$string['managemodules'] = 'Модуль';
$string['manageroles'] = 'Эрх ба зөвшөөрөл';
$string['markallread'] = 'Бүгдийг уншсан гэж тэмдэглэх';
$string['markedthistopic'] = 'Энэ сэдвийг одоогийн сэдэв болгон онцолсон байна';
$string['markthistopic'] = 'Энэ сэдвийг одоогийн сэдэв болгон онцлох';
$string['match'] = 'Нийцүүлэх';
$string['matchingsearchandrole'] = '\'{$a->search}\' ба {$a->role} нийцүүлэх';
$string['matchofthefollowing'] = 'дор дурдсанаас:';
$string['maxareabytesreached'] = 'Файл (эсвэл хэд хэдэн файлын нийт хэмжээ) нь энэ талбарт үлдсэн зайнаас том хэмжээтэй байна.';
$string['maxfilesize'] = 'Шинэ файлын зөвшөөрөгдөх хамгийн дээд хэмжээ: {$a}';
$string['maxfilesreached'] = 'Та энэ зүйлд хамгийн ихдээ {$a} файл хавсаргах боломжтой';
$string['maximumchars'] = 'Хамгийн ихдээ {$a} тэмдэгт';
$string['maximumgrade'] = 'Хамгийн дээд үнэлгээ';
$string['maximumgradex'] = 'Хамгийн дээд үнэлгээ: {$a}';
$string['maximumshort'] = 'Хамгийн их';
$string['maximumupload'] = 'Байршуулах хэмжээний дээд хязгаар';
$string['maximumupload_help'] = 'Энэ тохиргоо нь администраторын тогтоосон сайтын тохиргоогоор хязгаарлагдах хичээлд байршуулж болох файлын хамгийн том хэмжээг тодорхойлдог. Үйл ажиллагааны модульд цаашид файлын хэмжээг хязгаарлах хамгийн их байршуулах хэмжээний тохиргоо байдаг.';
$string['maxnumberweeks'] = 'Хэсгийн хамгийн их тоо';
$string['maxnumberweeks_desc'] = 'Нээгдэх жагсаалт бүхий цэсний хэсгийн тооны хамгийн их утга (зөвхөн тодорхой хичээлийн форматад хамаарна).';
$string['maxnumcoursesincombo'] = '<a href="{$a->link}">{$a->numberofcourses} хичээлийг харна</a>.';
$string['maxsectionslimit'] = 'Энэ ({$a}) хичээлд зөвшөөрөгдсөн хэсгийн дээд хязгаараас хэтрэх тул шинэ хэсэг үүсгэх боломжгүй.';
$string['maxsize'] = 'Хамгийн дээд хэмжээ: {$a}';
$string['maxsizeandareasize'] = 'Шинэ файлын хамгийн дээд хэмжээ: {$a->size}, нийт хязгаар: {$a->areasize}';
$string['maxsizeandattachments'] = 'Шинэ файлын хамгийн дээд хэмжээ: {$a->size}, файлын хамгийн их тоо: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Шинэ файлын хамгийн дээд хэмжээ: {$a->size}, файлын хамгийн их тоо: {$a->attachments}, хамгийн их нийт хэмжээ: {$a->areasize}';
$string['memberincourse'] = 'Хичээлд хамрагдсан суралцагчид';
$string['menu'] = 'Цэс';
$string['message'] = 'Зурвас';
$string['messagebody'] = 'Зурвасын үндсэн хэсэг';
$string['messagedselectedusers'] = 'Сонгосон хэрэглэгчид зурвас илгээж, хүлээн авагчийн жагсаалтыг шинэчилсэн.';
$string['messagedselectedusersfailed'] = 'Сонгосон хэрэглэгчид зурвас илгээх явцад алдаа гарлаа. Зарим нь цахим шуудан хүлээн авсан байж магадгүй.';
$string['messageprovider:asyncbackupnotification'] = 'Асинхрон нөөцлөлт/сэргээх мэдэгдэл';
$string['messageprovider:availableupdate'] = 'Боломжит шинэчлэлтийн мэдэгдэл';
$string['messageprovider:backup'] = 'Нөөцлөлтийн мэдэгдэл';
$string['messageprovider:badgecreatornotice'] = 'Ялгах тэмдэг үүсгэгчийн мэдэгдэл';
$string['messageprovider:badgerecipientnotice'] = 'Ялгах тэмдэг хүлээн авагчийн мэдэгдэл';
$string['messageprovider:competencyplancomment'] = 'Сургалтын төлөвлөгөөний талаар нийтэлсэн сэтгэгдэл';
$string['messageprovider:competencyusercompcomment'] = 'Чадамжийн талаар нийтэлсэн сэтгэгдэл';
$string['messageprovider:coursecompleted'] = 'Хичээл дууссан';
$string['messageprovider:coursecontentupdated'] = 'Хичээлийн агуулгын өөрчлөлт';
$string['messageprovider:courserequestapproved'] = 'Хичээл үүсгэх хүсэлтийг зөвшөөрсөн талаарх мэдэгдэл';
$string['messageprovider:courserequested'] = 'Хичээл үүсгэх хүсэлтийн мэдэгдэл';
$string['messageprovider:courserequestrejected'] = 'Хичээл үүсгэх хүсэлтийг татгалзсан талаарх мэдэгдэл';
$string['messageprovider:errors'] = 'Сайттай холбоотой ноцтой алдаа';
$string['messageprovider:errors_help'] = 'Эдгээр нь администраторын мэдэх ёстой ноцтой алдаа болно.';
$string['messageprovider:gradenotifications'] = 'Үнэлгээний мэдэгдэл';
$string['messageprovider:infected'] = 'Вирусын эсрэг программын алдааны мэдэгдэл.';
$string['messageprovider:insights'] = 'Таамаглалын загвараар боловсруулсан өгөгдөл';
$string['messageprovider:instantmessage'] = 'Хэрэглэгч хоорондын хувийн зурвас';
$string['messageprovider:instantmessage_help'] = 'Энэ хэсэг нь танд сайтын бусад хэрэглэгчээс шууд илгээсэн зурвасыг тохируулна.';
$string['messageprovider:messagecontactrequests'] = 'Зурвас илгээх хүсэлтийн мэдэгдэл';
$string['messageprovider:newlogin'] = 'Шинэ нэвтрэлтийн мэдэгдэл';
$string['messageprovider:notices'] = 'Бага зэргийн асуудлын талаарх мэдэгдэл';
$string['messageprovider:notices_help'] = 'Эдгээр нь администратор үзэхийг хүсэж болох мэдэгдэл болно.';
$string['messageprovider:reportbuilderschedule'] = 'Тусгай тайлан боловсруулагчийн хуваарь';
$string['messageselect'] = 'Энэ хэрэглэгчийг зурвас хүлээн авагчаар сонгох';
$string['messageselectadd'] = 'Зурвас илгээх';
$string['middlename'] = 'Дунд нэр';
$string['migratinggrades'] = 'Үнэлгээг шилжүүлж байна';
$string['min'] = 'минут';
$string['mins'] = 'минут';
$string['minute'] = 'минут';
$string['minutes'] = 'минут';
$string['miscellaneous'] = 'Бусад';
$string['missingcategory'] = 'Та ангилал сонгох хэрэгтэй';
$string['missingdescription'] = 'Тодорхойлолт байхгүй байна';
$string['missingemail'] = 'Цахим шуудангийн хаяг байхгүй байна';
$string['missingfirstname'] = 'Өөрийн нэр байхгүй байна';
$string['missingfromdisk'] = 'Дискээс алга болсон';
$string['missingfullname'] = 'Бүтэн нэр байхгүй байна';
$string['missinglastname'] = 'Овог байхгүй байна';
$string['missingname'] = 'Нэр байхгүй байна';
$string['missingnewpassword'] = 'Шинэ нууц үг байхгүй байна';
$string['missingpassword'] = 'Нууц үг байхгүй байна';
$string['missingrecaptchachallengefield'] = 'reCAPTCHA сорилт амжилтгүй боллоо, дахин оролдоно уу.';
$string['missingreqreason'] = 'Алга байгаа шалтгаан';
$string['missingshortname'] = 'Богино нэр алга байна';
$string['missingshortsitename'] = 'Сайтын богино нэр байхгүй байна';
$string['missingsitedescription'] = 'Сайтын тодорхойлолт алга байна';
$string['missingsitename'] = 'Сайтын нэр байхгүй байна';
$string['missingstrings'] = 'Орчуулагдаагүй үг, өгүүлбэр байгаа эсэхийг шалгах';
$string['missingstudent'] = 'Ямар нэг зүйлийг сонгох хэрэгтэй';
$string['missingsummary'] = 'Дүгнэлт байхгүй байна';
$string['missingteacher'] = 'Ямар нэг зүйлийг сонгох хэрэгтэй';
$string['missingurl'] = 'URL хаяг байхгүй байна';
$string['missingusername'] = 'Хэрэглэгчийн нэр байхгүй байна';
$string['moddoesnotsupporttype'] = '{$a->modname} модуль нь {$a->type} төрлийн байршуулалтыг дэмждэггүй';
$string['modhide'] = 'Нуух';
$string['modified'] = 'Засварлагдсан';
$string['modshow'] = 'Харуулах';
$string['moduleintro'] = 'Тодорхойлолт';
$string['modulesetup'] = 'Модулийн хүснэгтийг үүсгэж байна';
$string['modulesuccess'] = '{$a} хүснэгтийг зөв тохируулсан';
$string['modulesused'] = 'Ашигласан модулиуд';
$string['modvisible'] = 'Бэлэн байдал';
$string['modvisible_help'] = '* Хичээлийн хуудсанд харуулах: Суралцагчид харах боломжтой (тогтоож болох дурын хандалтын хязгаарлалтын дагуу).
* Хичээлийн хуудсанд нуух: Суралцагчид харах боломжгүй.';
$string['modvisiblehiddensection'] = 'Бэлэн байдал';
$string['modvisiblehiddensection_help'] = '* Хичээлийн хуудсанд нуух: Суралцагчид харах боломжгүй.
* Боломжтой боловч хичээлийн хуудсанд харуулахгүй: Холбоосыг оруулсан тохиолдолд суралцагч харах боломжтой. Үйл ажиллагаа нь журнал болон бусад тайланд харагдах болно.';
$string['modvisiblewithstealth'] = 'Бэлэн байдал';
$string['modvisiblewithstealth_help'] = '* Хичээлийн хуудсанд харуулах: Суралцагчид харах боломжтой (тогтоож болох дурын хандалтын хязгаарлалтын дагуу).
* Хичээлийн хуудсанд нуух: Суралцагчид харах боломжгүй.
* Боломжтой боловч хичээлийн хуудсанд харуулахгүй: Холбоосыг оруулсан тохиолдолд суралцагч харах боломжтой. Үйл ажиллагаа нь журнал болон бусад тайланд харагдах болно.';
$string['month'] = 'Сар';
$string['months'] = 'Сар';
$string['moodledocs'] = 'Moodle баримт бичгүүд';
$string['moodledocslink'] = 'Тусламж, баримт бичиг';
$string['moodlelogo'] = 'Moodle лого';
$string['moodlenet:cannotconnecttoserver'] = 'MoodleNet серверт холбогдох боломжгүй байна';
$string['moodlenet:configoauthservice'] = 'MoodleNet сайт руу хуваалцахыг идэвхжүүлэхийн тулд MoodleNet OAuth 2 сервисийг сонгоно. Уг сервис байхгүй тохиолдолд түүнийг <a href="{$a}">үүсгэх</a> хэрэгтэй.';
$string['moodlenet:eventresourceexported'] = 'Нөөцийг экспортолсон';
$string['moodlenet:gotomoodlenet'] = 'MoodleNet ноорогт хандах';
$string['moodlenet:issuerisnotauthorized'] = 'MoodleNet гаргагч нь зөвшөөрөлгүй байна';
$string['moodlenet:issuerisnotenabled'] = 'MoodleNet гаргагч нь идэвхжээгүй байна';
$string['moodlenet:issuerisnotset'] = 'MoodleNet гаргагчийг сайтын удирдлагад тохируулаагүй байна';
$string['moodlenet:outboundsettings'] = 'MoodleNet гадаад тохиргоо';
$string['moodlenet:packagingandsending'] = 'Таын файлыг багцалж, MoodleNet руу илгээж байна...';
$string['moodlenet:sharefailtext'] = 'Таны агуулгыг MoodleNet рүү хуваалцахад алдаа гарлаа.<br>Дараа дахин оролдоно уу.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Таны агуулгыг MoodleNet рүү хуваалцахад алдаа гарлаа.<br>Дараа дахин хандах буюу <a href="{$a}">Сайтын тусламжтай холбогдоно уу</a>.';
$string['moodlenet:sharefailtitle'] = 'Ямар нэг алдаа байна';
$string['moodlenet:sharefilesizelimitexceeded'] = 'Хуваалцаж буй нөөцийн хэмжээ ({$a->file size} байт) нь {$a->filesizelimitbytes-ын хязгаараас хэтэрсэн байна.';
$string['moodlenet:sharesuccesstext'] = 'Хийгдэж дууслаа! Агуулгаа хуваалцаж дуусгахын тулд MoodleNet дээрх нооргоо харна уу.';
$string['moodlenet:sharesuccesstitle'] = 'MoodleNet ноорог дээр хадгалсан';
$string['moodlenet:sharetomoodlenet'] = 'MoodleNet рүү хуваалцах';
$string['moodlenet:sharetyperesource'] = 'нөөц';
$string['moodlenet:sharinglargefile'] = 'Том файл нь бага зэрэг хугацаа шаарддаг.';
$string['moodlenet:sharingstatus'] = 'MoodleNet рүү хуваалцаж байна';
$string['moodlenet:sharingto'] = 'Хуваалцах:';
$string['moodlerelease'] = 'Moodle хувилбар';
$string['moodleservicesandsupport'] = 'Үйлчилгээ ба дэмжлэг';
$string['moodleversion'] = 'Moodle системийн хувилбар';
$string['more'] = 'дэлгэрэнгүй';
$string['moreactions'] = 'Илүү олон үйлдэл';
$string['morehelp'] = 'Нэмэлт тусламж';
$string['morehelpaboutmodule'] = '{$a} үйл ажиллагааны талаарх нэмэлт тусламж';
$string['moreinfo'] = 'Дэлгэрэнгүй мэдээлэл';
$string['moreinformation'] = 'Энэ алдааны талаарх дэлгэрэнгүй мэдээлэл';
$string['moremenu'] = 'Дэлгэрэнгүй';
$string['morenavigationlinks'] = 'Дэлгэрэнгүй...';
$string['moreprofileinfoneeded'] = 'Та бидэнд өөрийнхөө талаар дэлгэрэнгүй ярина уу';
$string['mostrecently'] = 'хамгийн сүүлийн';
$string['move'] = 'Зөөх';
$string['movecategoriessuccess'] = '{$a->count} ангиллыг \'{$a->to}\' ангилалд амжилттай шилжүүллээ';
$string['movecategoriestotopsuccess'] = '{$a->count} ангиллыг дээд түвшинд амжилттай шилжүүллээ';
$string['movecategorycontentto'] = 'Шилжүүлэх';
$string['movecategorysuccess'] = '\'{$a->moved}\' ангиллыг \'{$a->to}\' ангилалд амжилттай шилжүүллээ';
$string['movecategoryto'] = 'Ангиллыг шилжүүлэх:';
$string['movecategorytotopsuccess'] = '{$a->moved}\' ангиллыг дээд түвшинд амжилттай шилжүүллээ';
$string['movecontent'] = '{$a}-г шилжүүлэх';
$string['movecontentafter'] = '"{$a}"-н дараа';
$string['movecontentstoanothercategory'] = 'Агуулгыг өөр ангилалд шилжүүлэх';
$string['movecontenttothetop'] = 'Жагсаалтын эхэнд очих';
$string['movecoursemodule'] = 'Үйл ажиллагааг шилжүүлэх';
$string['movecoursesection'] = 'Хэсгийг шилжүүлэх';
$string['movecourseto'] = 'Хичээлийг шилжүүлэх:';
$string['movedown'] = 'Доош нь шилжүүлэх';
$string['movefilestohere'] = 'Файлыг энд зөөх';
$string['movefull'] = '{$a}-г энэ байрлал руу зөөх';
$string['movehere'] = 'Энд зөөх';
$string['moveleft'] = 'Зүүн тийш шилжүүлэх';
$string['moveright'] = 'Баруун тийш шилжүүлэх';
$string['movesection'] = '{$a} хэсгийг шилжүүлэх';
$string['moveselectedcategoriesto'] = 'Сонгосон ангиллыг шилжүүлэх';
$string['moveselectedcoursesto'] = 'Сонгосон хичээлийг шилжүүлэх...';
$string['movetoanotherfolder'] = 'Өөр хавтас руу зөөх';
$string['moveup'] = 'Дээш нь зөөх';
$string['mustchangepassword'] = 'Шинэ нууц үг нь одоогийн нууц үгээс өөр байх ёстой';
$string['mustconfirm'] = 'Та бүртгэлээ баталгаажуулах шаардлагатай';
$string['mycourses'] = 'Миний хичээлүүд';
$string['myfiles'] = 'Миний хувийн файлууд';
$string['myfilesmanage'] = 'Хувийн файлаа зохион байгуулах';
$string['myhome'] = 'Удирдах самбар';
$string['mymoodledashboard'] = 'My Moodle удирдах самбар';
$string['myprofile'] = 'Миний профайл';
$string['name'] = 'Нэр';
$string['namedfiletoolarge'] = '\'{$ a-> filename}\' файл хэт том тул байршуулах боломжгүй';
$string['nameforlink'] = 'Та энэ холбоосыг юу гэж нэрлэхийг хүсэж байна вэ?';
$string['nameforpage'] = 'Нэр';
$string['navigation'] = 'Удирдлага';
$string['needed'] = 'Хэрэгцээтэй';
$string['networkdropped'] = 'Бид таны интернэт холболтыг найдваргүй эсвэл тасалдаж байгааг илрүүллээ.<br />
Таны холболт сайжрах хүртэлх хугацаанд хийсэн өөрчлөлт зөв хадгалагдахгүй байж болзошгүйг анхаарна уу.';
$string['never'] = 'Хэзээ ч';
$string['neverdeletelogs'] = 'Лог бүртгэлийг хэзээ ч устгахгүй';
$string['new'] = 'Шинэ';
$string['newaccount'] = 'Шинэ бүртгэл';
$string['newactivityname'] = '{$ a} үйл ажиллагааны шинэ нэр';
$string['newcourse'] = 'Шинэ хичээл';
$string['newloginnotificationbodyfull'] = '<p>Сайн байна уу {$a->userfullname},</p>
<p>Таны {$a->sitename} бүртгэлээр дөнгөж сая шинэ төхөөрөмжөөс нэвтэрсэн байна.</p>
<ul>
<li>Таны бүртгэл: {$a->хэрэглэгчийн нэр} {$a->хэрэглэгчийн шуудан}</li>
<li>{$a->logintime}</li>
<li>Төхөөрөмж: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Хэрэв та өөрөө нэвтэрсэн бол юу ч хийх шаардлагагүй.</p>
<p>Хэрэв та энэ үйлдлийг хийгээгүй бол <a href="{$a->changepasswordlink}">өөрийн нууц үгээ солино уу</a>.</p>';
$string['newloginnotificationbodysmall'] = 'Таны {$a} бүртгэлээр дөнгөж сая шинэ төхөөрөмжөөс нэвтэрсэн байна.';
$string['newloginnotificationtitle'] = 'Өөрийн {$a} бүртгэлдээ шинээр нэвтрэх';
$string['newpassword'] = 'Шинэ нууц үг';
$string['newpassword_help'] = 'Шинэ нууц үг оруулах эсвэл хоосон үлдээж одоогийн нууц үгийг хэвээр үлдээнэ.';
$string['newpasswordfromlost'] = '<strong>АНХААРУУЛГА:</strong> Алдагдсан нууц үгийг сэргээх процессын хүрээнд таны <strong>одоогийн нууц үгийг</strong> таны <strong>хоёр дахь</strong> цахим шуудангаар илгээх болно. Үргэлжлүүлэхээсээ өмнө солих нууц үгээ хүлээн авсан эсэхээ нягтална уу.';
$string['newpasswordtext'] = 'Сайн байна уу {$a->firstname},

Таны \'{$a->sitename}\' дээрх бүртгэлийн нууц үгийг шинэчилж,
танд түр зуурын шинэ нууц үг олгосон байна.

Таны одоогийн нэвтрэх мэдээлэл:
    хэрэглэгчийн нэр: {$a->username}
    нууц үг: {$a->newpassword}

Нууц үгээ солихын тулд дараах хуудсанд хандана уу:
    {$a->link}

Ихэнх цахим шуудангийн программд энэ нь цэнхэр өнгөтэй холбоос
хэлбэрээр харагдах ба уг холбоос дээр дарахад л хангалттай. Хэрэв
энэ нь ажиллахгүй байвал уг холбоосыг хуулж аваад веб хөтчийнхөө
цонхны дээд талд байрлах хаягийн мөрөнд оруулна.

Хүндэтгэсэн \'{$a->sitename}\' сайтын админ,
{$a->signoff}';
$string['newpicture'] = 'Шинэ зураг';
$string['newpicture_help'] = 'Шинэ зураг нэмэхийн тулд зургаа (JPG эсвэл PNG форматтай) сонгоод "Профайл шинэчлэх" дээр дарна. Зургийг дөрвөлжин болгон тайрч, хэмжээг 100х100 пискель болгон өөрчилнө.';
$string['newpictureusernotsetup'] = 'Профайлын зургийг тухайн профайлын бүх шаардлагатай мэдээллийг хадгалсны дараа л нэмэх боломжтой.';
$string['newsectionname'] = '{$a} хэсгийн шинэ нэр';
$string['newsitem'] = 'мэдээний зүйл';
$string['newsitems'] = 'зарлал';
$string['newsitemsnumber'] = 'Зарлалын тоо';
$string['newsitemsnumber_help'] = 'Зарлалын хэлэлцүүлэг гэдэг нь хичээлд автоматаар үүсгэгддэг тусгай хэлэлцүүлэг бөгөөд өгөгдмөл тохиргоогоор бүртгэгдсэн байхыг шаардаж, зөвхөн холбогдох зөвшөөрөл бүхий хэрэглэгч (өгөгдмөл тохиргоогоор багш) нийтлэх боломжтой байна.

Энэ тохиргоогоор зарлалын блокт хамгийн сүүлийн хэдэн зарлалыг харуулахыг тодорхойлдог.

Хичээлд зарлалын хэлэлцүүлэг шаардлагагүй тохиолдолд уг тохиргоог тэг болгоно.';
$string['newuser'] = 'Шинэ хэрэглэгч';
$string['newusernewpasswordsubj'] = 'Шинэ хэрэглэгчийн бүртгэл';
$string['newusernewpasswordtext'] = 'Сайн байна уу{$a->firstname},

\'{$a->sitename}\' дээр танд шинэ бүртгэл үүсгэж,
танд түр зуурын шинэ нууц үг олгосон байна.

Таны одоогийн нэвтрэх мэдээлэл:
хэрэглэгчийн нэр: {$a->username}
нууц үг: {$a->newpassword}
           (та анх удаа нэвтрэхдээ нууц үгээ
           солих шаардлагатай)

\'{$a->sitename}\' сайтыг ашиглахын тулд дараах холбоосоор нэвтэрнэ үү
{$a->link}

Ихэнх цахим шуудангийн программд энэ нь цэнхэр өнгөтэй холбоос
хэлбэрээр харагдах ба уг холбоос дээр дарахад л хангалттай. Хэрэв
энэ нь ажиллахгүй байвал уг холбоосыг хуулж аваад веб хөтчийнхөө
цонхны дээд талд байрлах хаягийн мөрөнд оруулна.

Хүндэтгэсэн \'{$a->sitename}\' сайтын администратор,
 {$a->signoff}';
$string['newusers'] = 'Шинэ хэрэглэгчид';
$string['newwindow'] = 'Шинэ цонх';
$string['next'] = 'Дараагийн';
$string['nextpage'] = 'Дараагийн хуудас';
$string['nextsection'] = 'Дараагийн хэсэг';
$string['no'] = 'Үгүй';
$string['noblockstoaddhere'] = 'Энэ хуудсанд нэмж оруулах блок байхгүй байна.';
$string['nobody'] = 'Хэн ч';
$string['nochange'] = 'Өөрчлөлт байхгүй';
$string['nocomments'] = 'Сэтгэгдэл байхгүй';
$string['nocourses'] = 'Хичээл байхгүй';
$string['nocoursesfound'] = '\'{$a}\' үг орсон хичээл олдсонгүй';
$string['nocoursestarttime'] = 'Хичээл нь эхлэх огноогүй байна.';
$string['nocoursesyet'] = 'Энэ ангилалд хичээл байхгүй байна';
$string['nodstpresets'] = 'Администратор нь зуны цагийн тоололд шилжүүлэх тохиргоог идэвхжүүлээгүй байна.';
$string['nofilesselected'] = 'Сэргээх файлыг сонгоогүй байна';
$string['nofilesyet'] = 'Одоогоор таны хичээлд ямар ч файл байршуулаагүй байна.';
$string['nofiltersapplied'] = 'Шүүлтүүр ашиглаагүй';
$string['nograde'] = 'Үнэлгээ байхгүй';
$string['nohelpforactivityorresource'] = 'Одоогоор энэ нөөц, үйл ажиллагаатай холбоотой ямар ч тусламж байхгүй байна';
$string['noimagesyet'] = 'Одоогоор таны хичээлд ямар ч зураг байршуулаагүй байна';
$string['nologsfound'] = 'Ямар ч лог бүртгэл олдсонгүй';
$string['nomatchingusers'] = '\'{$a}\'-д тохирох хэрэглэгч байхгүй';
$string['nomorecourses'] = 'Өөр тохирох хичээл олдсонгүй';
$string['nomoreidnumber'] = 'Алдаанаас сэргийлсэн ID дугаар хэрэглээгүй';
$string['none'] = 'Аль нь ч';
$string['noneditingteacher'] = 'Засварлах эрхгүй багш';
$string['noneditingteacherdescription'] = 'Засварлах эрхгүй багш нь хичээл заах, суралцагчийг үнэлэх боловч үйл ажиллагааг  өөрчлөх боломжгүй.';
$string['nonstandard'] = 'Стандарт бус';
$string['nopendingcourses'] = 'Зөвшөөрөл хүлээж буй хичээл алга байна';
$string['nopotentialadmins'] = 'Боломжит админ байхгүй';
$string['nopotentialcreators'] = 'Боломжит хичээл үүсгэгч байхгүй';
$string['nopotentialstudents'] = 'Боломжит суралцагч байхгүй';
$string['nopotentialteachers'] = 'Боломжит багш байхгүй';
$string['norecentactivity'] = 'Сүүлд хийгдсэн үйл ажиллагаа байхгүй';
$string['noreplybouncemessage'] = 'Та хариулт өгдөггүй цахим шуудангийн хаяг руу хариу илгээсэн байна. Та хэлэлцүүлгийн нийтлэлд хариу бичих бол үүний оронд {$a} хэлэлцүүлгийг ашиглан хариу өгнө үү.

Таны цахим шуудангийн агуулгыг дор харуулав:';
$string['noreplybouncesubject'] = '{$a} - цахим шуудангийн серверт хүргэх боломжгүй цахим шуудан.';
$string['noreplyname'] = 'Энэ цахим шууданд хариу бичих хэрэггүй';
$string['noresetrecord'] = 'Нууц үг сэргээх хүсэлтийн бүртгэл байхгүй байна. Нууц үг сэргээх хүсэлтээ шинээр гаргана уу.';
$string['noresults'] = 'Үр дүн алга байна';
$string['normal'] = 'Энгийн';
$string['normalfilter'] = 'Энгийн хайлт';
$string['nosite'] = 'Сайтын түвшний хичээлийг олж чадсангүй';
$string['nostudentsfound'] = '{$a} олдсонгүй';
$string['nostudentsingroup'] = 'Энэ бүлэгт одоогоор суралцагч байхгүй байна';
$string['nostudentsyet'] = 'Энэ хичээлд бүртгэгдсэн суралцагч байхгүй байна.';
$string['nosuchemail'] = 'Ийм цахим шуудангийн хаяг байхгүй';
$string['notavailable'] = 'Боломжгүй';
$string['notavailablecourse'] = '{$a} байхгүй байна';
$string['noteachersyet'] = 'Энэ хичээлд одоогоор багш байхгүй байна';
$string['noteachingupcomingcourses'] = 'Удахгүй эхлэх хичээлд багш, суралцагч байхгүй байна';
$string['notenrolled'] = 'Энэ хичээлд {$a} нь бүртгэгдээгүй байна.';
$string['notenrolledprofile'] = 'Энэ хэрэглэгч уг хичээлд бүртгүүлээгүй тул ийм профайл байхгүй байна.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Тэмдэглэл</strong> Танд шаардлагатай зөвшөөрөл байхгүй тул уг нөөцлөлтийг сэргээх үед огноог шилжүүлэх боломжийг идэвхгүй болгосон байна.';
$string['noteuserschangednonetocourse'] = '<strong>Тэмдэглэл:</strong> Хэрэглэгчийн өгөгдлийг (үйл ажиллагаа, файл, зурвас зэрэгт) сэргээх үед хичээлийн хэрэглэгчдийг сэргээх шаардлагатай. Энэ тохиргоог танд зориулан өөрчилсөн байна.';
$string['nothingnew'] = 'Сүүлд хийгдсэн үйл ажиллагаа байхгүй';
$string['nothingtodisplay'] = 'Харуулах зүйл алга';
$string['notice'] = 'Сануулга';
$string['noticenewerbackup'] = 'Энэ нөөц файлыг Moodle {$a->backuprelease} ({$a->backupversion}) ашиглан үүсгэсэн бөгөөд энэ нь таны одоогоор суулгасан Moodle {$a->serverrelease} ({$a->serverversion}) хувилбараас илүү шинэ болно. Нөөц файлын нийцтэй байдлыг баталгаажуулах боломжгүй тул энэ нь зарим нэг зөрчлийг үүсгэж болзошгүй.';
$string['notifications'] = 'Мэдэгдэл';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Хэрэглэгч: {$a->info}, Хэрэглэгчийн бүтэн нэр: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Та эдгээр лог бүртгэлийг {$a} дээр харах боломжтой';
$string['notifyloginfailuresmessagestart'] = 'Энэ нь танд хамгийн сүүлд мэдэгдсэнээс хойш {$a} руу нэвтэрч чадаагүй оролдлогын жагсаалт болно';
$string['notifyloginfailuressubject'] = '{$a} :: Амжилтгүй нэвтрэлтийн талаарх мэдэгдэл';
$string['notincluded'] = 'Оруулаагүй';
$string['notingroup'] = 'Уучлаарай, та энэ хуудсыг харахын тулд бүлгийн гишүүн байх шаардлагатай.';
$string['notpublic'] = 'Нээлттэй биш!';
$string['nousersfound'] = 'Хэрэглэгч олдсонгүй';
$string['nousersmatching'] = '\'{$a}\'-тай тохирох хэрэглэгч олдсонгүй';
$string['nousersyet'] = 'Одоогоор хэрэглэгч алга байна';
$string['novalidcourses'] = 'Харуулах хүчинтэй хичээл байхгүй байна';
$string['now'] = 'одоо';
$string['numattempts'] = '{$a} амжилтгүй нэвтрэх оролдлого';
$string['numberofcourses'] = 'Хичээлийн тоо';
$string['numberweeks'] = 'Хэсгийн тоо';
$string['numday'] = '{$a} өдөр';
$string['numdays'] = '{$a} өдөр';
$string['numhours'] = '{$a} цаг';
$string['numletters'] = '{$a} үсэг';
$string['numminutes'] = '{$a} минут';
$string['nummonth'] = '{$a} сар';
$string['nummonths'] = '{$a} сар';
$string['numseconds'] = '{$a} секунд';
$string['numviews'] = '{$a} үзэлт';
$string['numweek'] = '{$a} долоо хоног';
$string['numweeks'] = '{$a} долоо хоног';
$string['numwords'] = '{$a} үг';
$string['numyear'] = '{$a} он';
$string['numyears'] = '{$a} он';
$string['ok'] = 'ОК';
$string['oldpassword'] = 'Одоо ашиглаж буй нууц үг';
$string['olduserdirectory'] = 'Энэ бол ашиглагдахаа больсон хэрэглэгчийн ХУУЧИН лавлах. Та үүнийг устгаж болно. Үүнд байсан файлыг хэрэглэгчийн ШИНЭ лавлах руу хуулсан болно.';
$string['opendrawerblocks'] = 'Блок агуулагчийг нээх';
$string['opendrawerindex'] = 'Хичээлийн индексийг нээх';
$string['opensinnewwindow'] = 'Шинэ цонхонд нээх';
$string['operator_and'] = 'ба';
$string['operator_andnot'] = 'ба';
$string['operator_or'] = 'эсвэл';
$string['optional'] = 'сонголттой';
$string['options'] = 'сонголтууд';
$string['order'] = 'Дараалал';
$string['originalpath'] = 'Үндсэн зам';
$string['orphanedactivitiesinsectionno'] = 'Салангид үйл ажиллагаа ({$a} хэсэг)';
$string['other'] = 'Бусад';
$string['outline'] = 'Тойм';
$string['outlinereport'] = 'Тойм тайлан';
$string['page'] = 'Хуудас';
$string['pagea'] = '{$a} хуудас';
$string['pagedcontentnavigation'] = 'Хуудаслалтын удирдлага';
$string['pagedcontentnavigationactiveitem'] = 'Одоогийн хуудас, {$a} хуудас';
$string['pagedcontentnavigationitem'] = '{$a} хуудсанд очих';
$string['pagedcontentpagingbaritemsperpage'] = 'Нэг хуудсанд {$a} зүйлийг харуулах';
$string['pageheaderconfigablock'] = '{$a->fullname} дахь блокыг тохируулж байна';
$string['pagepath'] = 'Хуудасны зам';
$string['pageshouldredirect'] = 'Энэ хуудсыг автоматаар чиглүүлэх шаардлагатай. Чиглүүлэгдэхгүй бол доорх үргэлжлүүлэх холбоосыг дарна уу.';
$string['parentcategory'] = 'Үндсэн ангилал';
$string['parentcoursenotfound'] = 'Үндсэн хичээл олдсонгүй!';
$string['parentfolder'] = 'Үндсэн хавтас';
$string['participants'] = 'Оролцогчид';
$string['participantslist'] = 'Оролцогчдын жагсаалт';
$string['participationratio'] = 'Оролцооны харьцаа';
$string['participationreport'] = 'Оролцооны тайлан';
$string['password'] = 'Нууц үг';
$string['passwordchanged'] = 'Нууц үгийг өөрчилсөн';
$string['passwordconfirmchange'] = 'Нууц үгийн өөрчлөлтийг батлах';
$string['passwordextlink'] = 'Та алдсан нууц үгээ дараах холбоосоор сэргээнэ. Уг холбоос нь таныг Moodle системээс гаргах болно.';
$string['passwordforgotten'] = 'Мартагдсан нууц үг';
$string['passwordforgotteninstructions'] = 'Таны дэлгэрэнгүй мэдээллийг эхлээд хэрэглэгчийн мэдээллийн сангаас олох ёстой. Хэрэглэгчийн нэр, бүртгүүлсэн цахим шуудангийн хаягийн <strong>аль нэгийг</strong> харгалзах талбарт оруулна уу. Хоёуланг нь оруулах шаардлагагүй.';
$string['passwordforgotteninstructions2'] = 'Нууц үгээ шинэчлэхийн тулд хэрэглэгчийн нэр эсвэл цахим шуудангийн хаягийг доор оруулна. Мэдээллийн сангаас таны мэдээллийг олсон тохиолдолд хандалтын зааварчилгаа бүхий цахим шууданг таны цахим шуудангийн хаяг руу илгээх болно.';
$string['passwordnohelp'] = 'Таны алдагдсан нууц үгийг олоход туслах боломжгүй. Moodle администратортой холбогдоно уу.';
$string['passwordpolicynomatch'] = 'Таны одоогийн нууц үг нь нууц үгийн бодлогод нийцэхгүй байна.
     {$a}';
$string['passwordrecovery'] = 'Тийм, надад нэвтрэхэд тусална уу';
$string['passwordsdiffer'] = 'Эдгээр нууц үг нийцэхгүй байна';
$string['passwordsent'] = 'Нууц үгийг илгээсэн';
$string['passwordsenttext'] = '<p>Таны {$a->email} хаяг руу цахим шуудан илгээсэн.</p>
    <p><b>Шинэ нууц үг авахын тулд цахим шуудангаа шалгана уу</b></p>
    <p>Шинэ нууц үгийг автоматаар үүсгэсэн тул та тогтооход хялбар нууц үгээр
    <a href="{$a->link}">өөрчлөх боломжтой</a>.</p>';
$string['passwordset'] = 'Таны нууц үг шинэчлэгдлээ.';
$string['path'] = 'Зам';
$string['pathnotexists'] = 'Таны серверт зам байхгүй байна!';
$string['pathslasherror'] = 'Зам нь ташуу зураасаар төгсөж болохгүй!!';
$string['paymentinstant'] = 'Доорх товчийг ашиглан төлбөрөө хийгээд хэдхэн минутын дотор бүртгүүлээрэй!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> хүлээгдэж байна</small>)';
$string['paymentrequired'] = 'Энэ хичээл элсэлтийн төлбөр шаарддаг.';
$string['payments'] = 'Төлбөр';
$string['paymentsorry'] = 'Төлбөрөө төлсөнд баярлалаа! Харамсалтай нь таны төлбөр бүрэн баталгаажаагүй байгаа тул таныг "{$a->fullname}" хичээлд хараахан бүртгүүлээгүй байна. Хичээлийг хэдхэн секундын дараа дахин үргэлжлүүлнэ үү. Асуудал хэвээр байвал {$a->teacher} эсвэл сайтын администраторт мэдэгдэнэ үү.';
$string['paymentthanks'] = 'Төлбөрөө төлсөнд баярлалаа! Та хичээлдээ бүртгэгдсэн байна:<br />"{$a}"';
$string['pendingrequests'] = 'Хүлээгдэж буй хүсэлтүүд';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Хугацаа дуусах ({$a})';
$string['perpage'] = 'Нэг хуудсанд';
$string['perpagea'] = 'Нэг хуудсанд: {$a}';
$string['personal'] = 'Хувийн';
$string['personalprofile'] = 'Хувийн профайл';
$string['phone'] = 'Утас';
$string['phone1'] = 'Утас';
$string['phone2'] = 'Гар утас';
$string['phpinfo'] = 'PHP мэдээлэл';
$string['picture'] = 'Зураг';
$string['pictureof'] = '{$a} зураг';
$string['pictureofuser'] = 'Хэрэглэгчийн зураг';
$string['placeholdertypeorselect'] = 'Бичих эсвэл сонгох...';
$string['pleaseclose'] = 'Энэ цонхыг одоо хаана уу.';
$string['pleasesearchmore'] = 'Дахин хайлт хийнэ үү';
$string['pleaseusesearch'] = 'Хайлтыг ашиглана уу';
$string['plugin'] = 'Нэмэлт хэрэгсэл';
$string['pluginarea'] = 'Талбар';
$string['plugincheck'] = 'Нэмэлт хэрэгслийг шалгах';
$string['plugindeletefiles'] = '\'{$a->name}\' нэмэлт хэрэгсэлтэй холбоотой бүх өгөгдлийг энэ өгөгдлийн сангаас устгасан байна. Нэмэлт хэрэгслийг дахин суулгахаас сэргийлэх үүднээс серверээс {$a->directory} лавлахыг устгах хэрэгтэй.';
$string['pluginitemid'] = 'Нэгжийн ID дугаар';
$string['pluginmissingfromdisk'] = '{$a->name} (Дискэд байхгүй)';
$string['pluginsetup'] = 'Нэмэлт хэрэгслийн хүснэгтийг тохируулж байна';
$string['policyaccept'] = 'Би ойлгож, зөвшөөрч байна';
$string['policyagree'] = 'Та энэ сайтыг үргэлжлүүлэн ашиглахын тулд энэ бодлогыг зөвшөөрөх ёстой. Та зөвшөөрч байна уу?';
$string['policyagreement'] = 'Сайтын бодлогын гэрээ';
$string['policyagreementclick'] = 'Сайтын бодлогын гэрээний холбоос';
$string['popup'] = 'нэмэлт цонх';
$string['popupwindow'] = 'Файлыг шинэ цонхонд нээх';
$string['popupwindowname'] = 'Нэмэлт цонх';
$string['post'] = 'Нийтлэл';
$string['posts'] = 'Нийтлэлүүд';
$string['potentialadmins'] = 'Боломжит админ';
$string['potentialcreators'] = 'Боломжит хичээл үүсгэгч';
$string['potentialstudents'] = 'Боломжит суралцагч';
$string['potentialteachers'] = 'Боломжит багш';
$string['poweredbymoodle'] = '<a href="https://moodle.com">Moodle</a> дэмжсэн';
$string['preferences'] = 'Сонголтууд';
$string['preferredlanguage'] = 'Сонгосон хэл';
$string['preferredtheme'] = 'Сонгосон загвар';
$string['preprocessingbackupfile'] = 'Нөөц файлыг урьдчилан боловсруулж байна';
$string['prev'] = 'Өмнөх';
$string['preview'] = 'Урьдчилан харах';
$string['previeworchoose'] = 'Урьдчилан харах эсвэл загвар сонгох';
$string['previous'] = 'Өмнөх';
$string['previouslyselectedusers'] = 'Өмнө нь сонгосон хэрэглэгчид \'{$a}\'-тай тохирохгүй байна';
$string['previouspage'] = 'Өмнөх хуудас';
$string['previoussection'] = 'Өмнөх хэсэг';
$string['primaryadminsetup'] = 'Администраторын бүртгэл тохируулах';
$string['privacy:metadata:config_log'] = 'Тохиргооны өөрчлөлтийн лог бүртгэл.';
$string['privacy:metadata:config_log:name'] = 'Тохиргооны өөрчлөлтийн нэр.';
$string['privacy:metadata:config_log:oldvalue'] = 'Энэ тохиргооны өмнөх утга.';
$string['privacy:metadata:config_log:plugin'] = 'Нэмэлт хэрэгслийг өөрчилсөн.';
$string['privacy:metadata:config_log:timemodified'] = 'Өөрчлөлт хийсэн цаг.';
$string['privacy:metadata:config_log:userid'] = 'Өөрчлөлт хийсэн хэрэглэгч.';
$string['privacy:metadata:config_log:value'] = 'Энэ тохиргооны шинэ утга.';
$string['privacy:metadata:events_queue'] = 'Боловсруулагдахаар хүлээгдэж буй хэрэглэгчийн үйл явдлын дараалал.';
$string['privacy:metadata:events_queue:eventdata'] = 'Үйл явдалд хадгалагдсан өгөгдөл.';
$string['privacy:metadata:events_queue:stackdump'] = 'Энэ үйл явдалтай холбоотой стекийн алдааны тэмдэглэл.';
$string['privacy:metadata:events_queue:timecreated'] = 'Энэ үйл явдлыг үүсгэсэн цаг';
$string['privacy:metadata:events_queue:userid'] = 'Энэ үйл явдалтай холбоотой хэрэглэгчийн ID дугаар';
$string['privacy:metadata:log'] = 'Өмнөх үйл явдлын цуглуулга';
$string['privacy:metadata:log:action'] = 'Үйлдлийн тодорхойлолт';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'хичээл';
$string['privacy:metadata:log:info'] = 'Нэмэлт мэдээлэл';
$string['privacy:metadata:log:ip'] = 'Үйл явдлын үед ашигласан IP хаяг';
$string['privacy:metadata:log:module'] = 'модуль';
$string['privacy:metadata:log:time'] = 'Үйлдэл хугацаа';
$string['privacy:metadata:log:url'] = 'Үйл явдалтай холбоотой URL хаяг';
$string['privacy:metadata:log:userid'] = 'Үйлдлийг гүйцэтгэсэн хэрэглэгчийн ID дугаар';
$string['privacy:metadata:oauth2_refresh_token'] = 'OAuth 2.0 харилцаанд ашигласан токенг шинэчлэх';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'Токен нийцэх гаргагчийн ID дугаар';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'Токен нийцэх хэрэглэгчийн ID дугаар';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Токен үүсгэсэн хугацаа';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Токеныг хамгийн сүүлд шинэчилсэн хугацаа';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Холбогдох хамрах хүрээ болон хэрэглэгчид зориулсан сэргээх токен';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'Токен нийцэх хэрэглэгчийн ID дугаар';
$string['privacy:metadata:task_adhoc'] = 'Түр зуурын ажлын төлөв.';
$string['privacy:metadata:task_adhoc:component'] = 'Ажлыг эзэмшиж буй бүрэлдэхүүн хэсэг.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Энэ ажлыг гүйцэтгэх хамгийн эрт хугацаа.';
$string['privacy:metadata:task_adhoc:userid'] = 'Хэрэглэгч ажлыг дараах байдлаар гүйцэтгэнэ.';
$string['privacy:metadata:task_log'] = 'Лог бүртгэлд зориулсан бүртгэлийн гаралт';
$string['privacy:metadata:task_log:component'] = 'Ажлыг эзэмшиж буй бүрэлдэхүүн хэсэг.';
$string['privacy:metadata:task_log:userid'] = 'Энэ ажил хамаарах хэрэглэгч.';
$string['privacy:metadata:upgrade_log'] = 'Шинэчлэлтийн лог бүртгэл.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Энэ шинэчлэх үе шаттай холбоотой дурын учир шалтгаан.';
$string['privacy:metadata:upgrade_log:details'] = 'Шинэчлэлттэй холбоотой нэмэлт мэдээлэл.';
$string['privacy:metadata:upgrade_log:info'] = 'Энэ шинэчлэх үе шатын үндсэн мэдээлэл.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Шинэчлэгдсэн нэмэлт хэрэгсэл.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Шинэчлэх шинэ хувилбар.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Шинэчлэлт хийгдсэн хугацаа.';
$string['privacy:metadata:upgrade_log:type'] = 'Лог бүртгэлийн бичлэгийн төрөл.';
$string['privacy:metadata:upgrade_log:userid'] = 'Шинэчлэлт хийсэн хэрэглэгч.';
$string['privacy:metadata:upgrade_log:version'] = 'Нэмэлт хэрэгслийн хуучин хувилбар.';
$string['private_files_handler'] = 'Цахим шуудангийн хавсралтыг хэрэглэгчийн хувийн файл хадгалах зайд хадгална.';
$string['private_files_handler_name'] = 'Цахим шуудангаар хувийн файл илгээх';
$string['privatefiles'] = 'Хувийн файл';
$string['privatefilesmanage'] = 'Хувийн файлаа зохион байгуулах';
$string['proceed'] = 'Үргэлжлүүлэх';
$string['profile'] = 'Профайл';
$string['profilenotshown'] = 'Энэ хүнийг хамгийн багадаа нэг хичээлд бүртгүүлэх хүртэл уг профайлын тайлбарыг харуулахгүй.';
$string['progress'] = 'Явц';
$string['publicprofile'] = 'Нээлттэй профайл';
$string['publicsitefileswarning'] = 'Тэмдэглэл: энд байрлуулсан файлд хэн ч хандах боломжтой';
$string['publicsitefileswarning2'] = 'Тэмдэглэл: Энд байрлуулсан файлд URL хаягийг мэдэх (эсвэл тааж чадах) хэн ч хандах боломжтой. Аюулгүй байдлын үүднээс нөөц файлыг сэргээсний дараа шууд устгахыг зөвлөж байна.';
$string['publicsitefileswarning3'] = 'Тэмдэглэл: Энд байрлуулсан файлд URL хаягийг мэдэх (эсвэл тааж чадах) хэн ч хандах боломжтой. <br />Аюулгүй байдлын үүднээс нөөц файлыг зөвхөн аюулгүй нөөц өгөгдлийн хавтаст хадгалах хэрэгтэй.';
$string['question'] = 'Асуулт';
$string['questionsinthequestionbank'] = 'Асуултын санд буй асуултууд';
$string['queued'] = 'Дараалалд орсон';
$string['quotausage'] = 'Та одоогоор өөрийн {$a->total} хязгаарын {$a->used}-г ашигласан байна.';
$string['readinginfofrombackup'] = 'Нөөцлөлтөөс мэдээлэл уншиж байна';
$string['readme'] = 'НАМАЙГ УНШ';
$string['recentactivity'] = 'Сүүлийн үеийн үйл ажиллагаа';
$string['recentactivityreport'] = 'Сүүлийн үеийн үйл ажиллагааны бүрэн тайлан...';
$string['recipientslist'] = 'Хүлээн авагчийн жагсаалт';
$string['recommended'] = 'Зөвлөмж болгосон';
$string['recreatedcategory'] = '{$a} ангиллыг дахин үүсгэсэн';
$string['redirect'] = 'Дахин чиглүүлэх';
$string['reducesections'] = 'Хэсгийн тоог багасгах';
$string['refresh'] = 'Дахин ачаалах';
$string['refreshingevents'] = 'Дахин ачаалах үйл явдал';
$string['registration'] = 'Moodle системийн бүртгэл';
$string['registrationcontact'] = 'Олон нийтээс холбоо барих';
$string['registrationcontactno'] = 'Үгүй, би бусад хүмүүстэй холбогдохыг хүсэхгүй байна';
$string['registrationcontactyes'] = 'Тийм, надад бусад мүүдлчүүдтэй холбогдох маягтыг өгнө үү';
$string['registrationemail'] = 'Цахим шуудангийн мэдэгдэл';
$string['registrationinfo'] = '<p>Энэ хуудас нь танд өөрийн Moodle сайтаа moodle.org сайтад бүртгүүлэх боломжийг олгоно. Бүртгэл үнэ төлбөргүй. Бүртгүүлэхийн гол давуу тал нь таныг аюулгүй байдлын сэрэмжлүүлэг, Moodle системийн шинэ хувилбар зэрэг чухал мэдэгдлийг илгээх цахим шуудангийн жагсаалтад оруулах болно.</p>
<p>Өгөгдмөл байдлаар таны мэдээлэл нууц хадгалах ба хэзээ ч зарж борлуулах эсвэл  бусдад дамжуулахгүй. Энэ мэдээллийг
     цуглуулах цорын ганц шалтгаан нь дэмжлэг үзүүлэх, нийт Moodle хэрэглэгчдийн статистик
     дүр зургийг бий болгоход туслах зорилготой.</p>
<p>Сонгосон тохиолдолд та сайтынхаа нэр, улс, URL хаягийг Moodle сайтын нээлттэй жагсаалтад оруулах боломжтой.</p>
<p>Бүх шинэ бүртгэлийг жагсаалтад нэмэхээс өмнө гараар баталгаажуулдаг боловч нэмэгдсэний дараа та энэ маягтыг дахин илгээх замаар хүссэн үедээ бүртгэлээ (болон нээлттэй жагсаалтад орсон бүртгэлээ) шинэчлэх боломжтой.</p>';
$string['registrationinfotitle'] = 'Бүртгэлийн мэдээлэл';
$string['registrationsend'] = 'Бүртгэлийн мэдээллээ moodle.org руу илгээх';
$string['registrationyes'] = 'Тийм, шинэ Moodle хувилбар, аюулгүй байдлын сэрэмжлүүлэг болон бусад чухал мэдээний талаар надад мэдэгдээрэй';
$string['reject'] = 'Татгалзах';
$string['rejectdots'] = 'Татгалзах...';
$string['relativedatesmode'] = 'Холбоотой огнооны горим';
$string['relativedatesmode_help'] = 'Хэрэглэгчийн хичээл эхлэх огноотой холбоотой хичээл, үйл ажиллагааны огноог харуулна.

Хэрэглэгчийн хичээл эхлэх огноо нь бүртгэл эхлэх огноо байх ба хичээл эхлэхээс өмнө бүртгүүлснээс бусад тохиолдолд хэрэглэгчийн хичээл эхлэх огноо нь хичээлийн эхлэх өдөр байх болно.

АНХААРУУЛГА: Энэ бол туршилтын боломж бөгөөд үүнийг бүх үйл ажиллагаа дэмжихгүй байж болно. Хичээлийг үүсгэсний дараа энэ хичээлийн тохиргоог өөрчлөх боломжгүй.';
$string['relativedatesmode_warning'] = '<strong>Анхааруулга:</strong> Хичээлийг үүсгэсний дараа холбоотой огнооны горимыг өөрчлөх боломжгүй.';
$string['reload'] = 'Дахин ачаалах';
$string['remoteappuser'] = 'Алсын {$a} хэрэглэгч';
$string['remove'] = 'Хасах';
$string['removeadmin'] = 'Админыг хасах';
$string['removecreator'] = 'Хичээл үүсгэгчийг хасах';
$string['removestudent'] = 'Суралцагчийг хасах';
$string['removeteacher'] = 'Багшийг хасах';
$string['rename'] = 'Нэр өөрчлөх';
$string['renamefileto'] = '<b>{$a}</b> нэрийг өөрчлөх';
$string['report'] = 'Тайлан';
$string['reports'] = 'Тайлан';
$string['reporttype'] = 'Тайлангийн төрөл';
$string['repositories'] = 'Өгөгдлийн агуулах';
$string['requestcourse'] = 'Хичээл хүсэх';
$string['requestedby'] = 'Хүсэлт гаргасан';
$string['requestedcourses'] = 'Хүссэн хичээл';
$string['requestreason'] = 'Хичээлийн хүсэлтийн шалтгаан';
$string['requests'] = 'Хүсэлтүүд';
$string['required'] = 'Шаардлагатай';
$string['requirespayment'] = 'Энэ хичээл нь хандалтын төлбөр шаарддаг';
$string['resendemail'] = 'Цахим шууданг дахин илгээх';
$string['reset'] = 'Дахин тохируулах';
$string['resetcomponent'] = 'Бүрэлдэхүүн хэсэг';
$string['resetcourse'] = 'Хичээлийг дахин тохируулах';
$string['resetinfo'] = 'Энэ хуудас нь үйл ажиллагаа болон бусад тохиргоог хэвээр хадгалахын зэрэгцээ хэрэглэгчийн өгөгдлөөс хичээлийг хоосон болгох боломжийг олгоно. Доорх зүйлсийг сонгож, энэ хуудсыг илгээснээр уг хичээлээс сонгосон хэрэглэгчийн өгөгдлийг бүрмөсөн устгахыг анхаарна уу!';
$string['resetnotimplemented'] = 'Дахин тохируулга хийгдээгүй';
$string['resetrecordexpired'] = 'Таны ашигласан нууц үгийг шинэчлэх холбоос {$a} минутаас илүү хугацаатай бөгөөд хүчинтэй хугацаа нь дууссан байна. Нууц үг шинэчлэх хүсэлт дахин гаргана уу.';
$string['resetstartdate'] = 'Эхлэх огноог дахин тохируулах';
$string['resetstatus'] = 'Төлөв';
$string['resettable'] = 'Хүснэгтийн тохиргоог дахин тохируулах';
$string['resettask'] = 'Ажил';
$string['resettodefaults'] = 'Өгөгдмөл тохиргоогоор дахин тохируулах';
$string['resortcourses'] = 'Хичээлийг эрэмбэлэх';
$string['resortsubcategoriesby'] = 'Дэд ангиллыг {$a} өсөх дарааллаар эрэмбэлэх';
$string['resortsubcategoriesbyreverse'] = 'Дэд ангиллыг {$a} буурах дарааллаар эрэмбэлэх';
$string['resource'] = 'Нөөц';
$string['resourcedisplayauto'] = 'Автомат';
$string['resourcedisplaydownload'] = 'Татаж авахыг шаардах';
$string['resourcedisplayembed'] = 'Эмбэд';
$string['resourcedisplayframe'] = 'Хүрээнд';
$string['resourcedisplaynew'] = 'Шинэ цонх';
$string['resourcedisplayopen'] = 'Нээх';
$string['resourcedisplaypopup'] = 'Нэмэлт цонхонд';
$string['resources'] = 'Нөөц';
$string['resources_help'] = 'Нөөцийн төрөл нь хичээлд оруулах бараг бүх төрлийн веб агуулгыг идэвхжүүлдэг.';
$string['restore'] = 'Сэргээх';
$string['restorecancelled'] = 'Сэргээх үйлдлийг цуцалсан';
$string['restorecannotassignroles'] = 'Сэргээхийн тулд эрх хуваарилах шаардлагатай бөгөөд танд үүнийг хийх зөвшөөрөл байхгүй байна';
$string['restorecannotcreateorassignroles'] = 'Сэргээхийн тулд эрх үүсгэх эсвэл хуваарилах шаардлагатай бөгөөд танд үүнийг хийх зөвшөөрөл байхгүй байна';
$string['restorecannotcreateuser'] = 'Сэргээхийн тулд нөөц файлаас \'{$a}\' хэрэглэгчийг үүсгэх шаардлагатай бөгөөд танд үүнийг хийх зөвшөөрөл байхгүй байна';
$string['restorecannotoverrideperms'] = 'Сэргээхийн тулд зөвшөөрлийг хүчингүй болгох шаардлагатай бөгөөд танд үүнийг хийх зөвшөөрөл байхгүй байна';
$string['restorecoursenow'] = 'Энэ хичээлийг одоо сэргээ!';
$string['restoredaccount'] = 'Сэргээгдсэн бүртгэл';
$string['restoredaccountinfo'] = 'Энэ бүртгэлийг өөр серверээс импортолсон бөгөөд нууц үг нь алдагдсан байна. Цахим шуудангаар шинэ нууц үг үүсгэхийн тулд "Үргэлжлүүлэх" дээр дарна уу.';
$string['restorefinished'] = 'Сэргээлт амжилттай дууссан';
$string['restoremnethostidmismatch'] = '\'{$a}\' хэрэглэгчийн MNet хостын ID нь локал MNet хостын ID дугаартай таарахгүй байна.';
$string['restoreto'] = 'Сэргээх';
$string['restoretositeadding'] = 'Анхааруулга: Та сайтын нүүр хуудсанд өгөгдөл нэмж, сэргээх гэж байна!';
$string['restoretositedeleting'] = 'Анхааруулга: Та сайтын нүүр хуудаснаас өгөгдлийг устгачихаад сэргээх гэж байна!';
$string['restoreuserconflict'] = 'Нөөц файлаас \'{$a}\' хэрэглэгчийг сэргээхийг оролдвол зөрчил үүсэх болно';
$string['restoreuserinfofailed'] = 'Та хэрэглэгчийн өгөгдлийг сэргээх зөвшөөрөлгүй тул сэргээх процессыг зогсоосон.';
$string['restoreusersprecheck'] = 'Хэрэглэгчийн өгөгдлийг шалгаж байна';
$string['restoreusersprecheckerror'] = 'Хэрэглэгчийн өгөгдлийг шалгах явцад зарим асуудал илэрсэн байна';
$string['restricted'] = 'Хязгаарласан';
$string['resultsfound'] = '{$a} илэрц олдсон';
$string['retry'] = 'Дахин оролдлого хийх';
$string['returningtosite'] = 'Энэ сайт руу буцах эсэх?';
$string['returntooriginaluser'] = '{$a} руу буцах';
$string['revert'] = 'Буцах';
$string['role'] = 'Эрх';
$string['roleassignments'] = 'Эрхийн хуваарилалт';
$string['rolemappings'] = 'Эрхийн зураглал';
$string['rolerenaming'] = 'Эрхийн нэрийг өөрчлөх';
$string['rolerenaming_help'] = 'Энэ тохиргоогоор хичээлд ашигласан эрхийн харагдах нэрийг өөрчлөх боломжтой. Зөвхөн харуулах нэрийг өөрчлөх ба эрхийн зөвшөөрөлд нөлөөлөхгүй. Эрхийн шинэ нэр нь хичээлд оролцогчийн болон тухайн хичээлийн бүх хуудсанд гарах болно. Шинээр нэрлэсэн эрх нь администраторыг хичээлийн менежерийн эрхээр сонгосон эрх байвал уг эрхийн шинэ нэр нь хичээлийн жагсаалтын нэг хэсэг болон харагдах болно.';
$string['roles'] = 'Эрх';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Сүүлийн үеийн RSS нийтлэлийн тоо';
$string['rsserror'] = 'RSS өгөгдлийг уншихад алдаа гарлаа';
$string['rsserrorauth'] = 'Таны RSS холбоос нь хүчинтэй баталгаажуулалтын токенг агуулаагүй байна.';
$string['rsserrorguest'] = 'Энэ RSS мэдэгдэл нь өгөгдөлд хандахын тулд зочны хандалтыг ашигладаг боловч зочин нь өгөгдлийг унших зөвшөөрөлгүй байдаг. Эрх бүхий хэрэглэгчийн тухайд RSS мэдэгдлийн үндсэн байршил (URL) руу хандаж, шинэ RSS холбоосыг авна.';
$string['rsskeyshelp'] = '<p>Аюулгүй байдал, нууцлалыг хангах үүднээс RSS мэдэгдлийн URL хаяг нь хэрэглэгчийг таних тусгай токенг агуулдаг. Энэ нь бусад хэрэглэгчийг сайтын зөвшөөрөөгүй хэсэгт хандахаас сэргийлдэг.</p><p>Энэ токен нь таныг RSS мэдэгдэл үүсгэдэг талбарт анх удаа нэвтрэхэд автоматаар үүсгэгддэг. Хэрэв та өөрийн RSS мэдэгдлийн токенг алдагдсан гэж үзвэл дахин тохируулах холбоосоор дамжуулан шинийг авч болно. Шинээр авсан тохиолдолд таны одоогийн RSS мэдэгдлийн URL хаяг хүчингүй болохыг анхаарна уу.<p>';
$string['rsstype'] = 'Энэ үйл ажиллагааны RSS мэдэгдэл';
$string['save'] = 'Хадгалах';
$string['saveandnext'] = 'Хадгалаад харуулах';
$string['savechanges'] = 'Өөрчлөлтийг хадгалах';
$string['savechangesanddisplay'] = 'Хадгалаад харуулах';
$string['savechangesandreturn'] = 'Хадгалаад буцах';
$string['savechangesandreturntocourse'] = 'Хадгалаад хичээл рүү буцах';
$string['savecomment'] = 'Сэтгэгдлийг хадгалах';
$string['savedat'] = 'Хадгалсан:';
$string['savepreferences'] = 'Тохиргоог хадгалах';
$string['saveto'] = 'Хадгалах';
$string['scale'] = 'Хэмжээс';
$string['scale_help'] = 'Хэмжээс нь үйл ажиллагааны гүйцэтгэлийг үнэлэх, үнэлгээ өгөх аргыг тодорхойлдог. Үүнийг таслалаар тусгаарлагдсан хасахаас нэмэх хүртэлх утгын эрэмбэлэгдсэн жагсаалтаар тодорхойлдог. Жишээ нь "Маш хангалтгүй, Хангалтгүй, Дунд, Сайн, Маш сайн, Онц!" гэх мэт.';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Хэмжүүр';
$string['scalescustom'] = 'Тусгай хэмжүүр';
$string['scalescustomcreate'] = 'Шинэ хэмжээс нэмэх';
$string['scalescustomno'] = 'Тусгай хэмжүүр хараахан үүсгээгүй байна';
$string['scalesstandard'] = 'Стандарт хэмжүүр';
$string['scalestandard'] = 'Стандарт хэмжээс';
$string['scalestandard_help'] = 'Стандарт хэмжээсийг сайтын хэмжээнд, бүх хичээлд ашиглана.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Тусгай хэмжүүрийг үүсгэхийн тулд хичээлийн удирдлагын цэсний \'Хэмжүүр...\' холбоосыг ашиглана.';
$string['scalestip2'] = 'Тусгай хэмжүүрийг үүсгэхийн тулд хичээлийн удирдлагын цэсний Үнэлгээ холбоосыг дарж, Засварлах, Хэмжүүр командыг сонгоно.';
$string['schedule'] = 'Хуваарь';
$string['screenshot'] = 'Дэлгэцийн агшин';
$string['search'] = 'Хайх';
$string['search_help'] = 'Бичвэрээс нэг буюу хэд хэдэн үг хайх энгийн хайлтад үгийг сул зайтай оруулна. Хоёр тэмдэгтээс урт бүх үгийг ашиглана.

Нарийвчилсан хайлтад хайлтын талбарт юу ч бичихгүйгээр хайх товчийг дарж, нарийвчилсан хайлтын маягтад хандана.';
$string['searchactivities'] = 'Үйл ажиллагааг нэр эсвэл тайлбараар хайх';
$string['searchagain'] = 'Дахин хайх';
$string['searchbyemail'] = 'Цахим шуудангийн хаягаар хайх';
$string['searchbyusername'] = 'Хэрэглэгчийн нэрээр хайх';
$string['searchcoursecategories'] = 'Ангиллыг хайх';
$string['searchcourses'] = 'Хичээлийг хайх';
$string['searchoptions'] = 'Хайлтын сонголтууд';
$string['searchresults'] = 'Хайлтын илэрц';
$string['sec'] = 'секунд';
$string['seconds'] = 'секунд';
$string['secondsleft'] = '{$a} секунд';
$string['secondstotime172800'] = '2 өдөр';
$string['secondstotime259200'] = '3 өдөр';
$string['secondstotime345600'] = '4 өдөр';
$string['secondstotime432000'] = '5 өдөр';
$string['secondstotime518400'] = '6 өдөр';
$string['secondstotime604800'] = 'Долоо хоног';
$string['secondstotime86400'] = '1 өдөр';
$string['secretalreadyused'] = 'Нууц үгийн өөрчлөлтийн баталгаажуулалтын холбоосыг хэдийнэ ашигласан байна, нууц үг өөрчлөгдсөнгүй.';
$string['secs'] = 'секунд';
$string['section'] = 'Хэсэг';
$string['sectionactionnotsupported'] = 'Энд "{$a}" хэсгийн үйлдлийг дэмжихгүй';
$string['sectionname'] = 'Хэсгийн нэр';
$string['sections'] = 'Хэсэг';
$string['seealsostats'] = 'Статистикийг харна уу';
$string['selctauser'] = 'Хэрэглэгч сонгох';
$string['select'] = 'Сонгох';
$string['selectacategory'] = 'Ангиллаа сонгоно уу';
$string['selectacountry'] = 'Улс сонгох';
$string['selectacourse'] = 'Хичээл сонгох';
$string['selectacoursesite'] = 'Хичээл эсвэл сайт сонгох';
$string['selectagroup'] = 'Бүлэг сонгох';
$string['selectall'] = 'Бүгдийг сонгох';
$string['selectallusersonpage'] = 'Энэ хуудас дээрх бүх хэрэглэгчийг сонгох';
$string['selectalluserswithcount'] = 'Бүх {$a} хэрэглэгчийг сонгох';
$string['selectamodule'] = 'Үйл ажиллагааны модулийг сонгоно уу';
$string['selectanaction'] = 'Үйлдэл сонгох';
$string['selectanoptions'] = 'Сонголт хийх';
$string['selectaregion'] = 'Бүс сонгох';
$string['selectcategorysort'] = 'Та аль ангиллыг эрэмбэлэхийг хүсэж байна вэ?';
$string['selectcategorysortby'] = 'Ангиллыг хэрхэн эрэмбэлэхээ сонгох';
$string['selectcoursesortby'] = 'Хичээлийг хэрхэн эрэмбэлэхээ сонгох';
$string['selectdefault'] = 'Өгөгдмөл утгыг сонгох';
$string['selectedcategories'] = 'Сонгосон ангилал';
$string['selectedfile'] = 'Сонгосон файл';
$string['selectednowmove'] = '{$a} файлыг шилжүүлэхээр сонгосон байна. Шилжүүлэх хавтас руу ороод \'Файлыг энд шилжүүл\' товчийг дарна.';
$string['selectfiles'] = 'Файл сонгох';
$string['selectfiltertype'] = 'Сонгох';
$string['selectgroupsseparate'] = 'Тусдаа бүлгүүдийг сонгох';
$string['selectgroupsvisible'] = 'Харагдах бүлгийг сонгох';
$string['selectitem'] = '\'{$a}\' сонгох';
$string['selectmoduletoviewhelp'] = 'Үйл ажиллагаа, нөөцийн тусламжийг харахын тулд тэдгээрийг сонгоно.

Үйл ажиллагаа, нөөцийн нэр дээр хоёр товшиж нэмнэ.';
$string['selectnos'] = 'Бүх \'Үгүй\'-г сонгох';
$string['selectperiod'] = 'Хугацааг сонгох';
$string['senddetails'] = 'Миний дэлгэрэнгүй мэдээллийг цахим шуудангаар илгээнэ үү';
$string['separate'] = 'Холбоогүй';
$string['separateandconnected'] = 'Мэдлэгийн холбоогүй ба холбоотой арга';
$string['separateandconnected1'] = 'Ихэвчлэн холбогдоогүй байхдаа мэддэг';
$string['separateandconnected2'] = 'Холбогдоогүй байхдаа болон холбогдсон байхдаа';
$string['separateandconnected3'] = 'Ихэвчлэн холбогдож мэддэг';
$string['separateandconnectedinfo'] = 'Мэдлэгийн холбоотой ба холбоогүй онолд үндэслэсэн хэмжээс. Энэ онолоор бидний харж, сонсож буй зүйлийг үнэлэх, сурах хоёр өөр аргыг тайлбарладаг. <ul><li<strong>Холбоогүй мэдэгч</strong> нь мэдрэмж, сэтгэл хөдлөлгүйгээр аль болох бодитой ханддаг. Тэд бусадтай ярилцахдаа эсрэг талынхаа дэвшүүлсэн санаанаас сул талыг олох байдлаар өөрийнхөө санааг хамгаалах дуртай байдаг. </li><li><strong>Холбоотой мэдэгч</strong> нь бусдад илүү мэдрэмтгий ханддаг. Тэд бусдыг ойлгодог, холбогдон "асуудлыг тэдний өмнөөс ойлгож" чадах хүртлээ бусдыг сайтар сонсож, асуулт асуухыг зорьдог. Тэд бусдын мэдэж байгаа зүйлийг мэдэхийн тулд бусдаас олсон туршлагаа хуваалцах замаар суралцахыг хичээдэг.</li></ul>';
$string['servererror'] = 'Сервертэй холбогдох үед алдаа гарлаа';
$string['serverlocaltime'] = 'Серверийн дотоод цаг';
$string['sessionforceclean'] = 'Аюулгүй байдлыг хангах үүднээс энэ сейшны хүрээнд хэрэглэгчийн үүсгэсэн скриптыг идэвхгүй болгосон.';
$string['sessiontimeoutsoon'] = 'Таны сейшны хугацаа дуусах гэж байна. Та одоогийн сейшныг сунгахыг хүсэж байна уу?';
$string['setcategorytheme'] = 'Ангиллын загварыг тохируулах';
$string['setmode'] = 'Горимыг тохируулах';
$string['setpassword'] = 'Нууц үгийг тохируулах';
$string['setpasswordinstructions'] = 'Шинэ нууц үгээ дор оруулаад өөрчлөлтийг хадгална уу.';
$string['settings'] = 'Тохиргоо';
$string['share'] = 'Хуваалцах';
$string['shortname'] = 'Товч нэр';
$string['shortnamecollisionwarning'] = '[*] = Хичээлд энэ товч нэрийг хэдийнэ ашиглаж байгаа бөгөөд зөвшөөрөгдсөний дараа өөрчлөх шаардлагатай';
$string['shortnamecourse'] = 'Хичээлийн товч нэр';
$string['shortnamecourse_help'] = 'Хичээлийн товч нэрийг удирдлага дээр харуулах ба хичээлийн цахим шуудангийн сэдвийн мөрөнд ашигладаг.';
$string['shortnametaken'] = 'Товч нэрийг өөр хичээлд хэдийн ашигласан байна ({$a})';
$string['shortnameuser'] = 'Хэрэглэгчийн товч нэр';
$string['shortsitename'] = 'Сайтын товч нэр (жишээ нь нэг үг)';
$string['show'] = 'Харуулах';
$string['showactions'] = 'Үйлдлийг харуулах';
$string['showactivitydates'] = 'Үйл ажиллагааны огноог харуулах';
$string['showactivitydates_help'] = 'Үйл ажиллагааны хуудсанд үйл ажиллагааны огноог үргэлж харуулдаг. Энэ тохиргоо нь хичээлийн хуудасны үйл ажиллагаа бүрийн доор тухайн үйл ажиллагааны огноог харуулах эсэхийг тодорхойлдог.';
$string['showadvancededitor'] = 'Нарийвчилсан';
$string['showadvancedsettings'] = 'Нарийвчилсан тохиргоог харуулах';
$string['showall'] = 'Бүх {$a}-г харуулах';
$string['showallcourses'] = 'Бүх хичээлийг харуулах';
$string['showallusers'] = 'Бүх хэрэглэгчийг харуулах';
$string['showblockcourse'] = 'Блок бүхий хичээлийн жагсаалтыг харуулах';
$string['showcategory'] = '{$a}-г харуулах';
$string['showchartdata'] = 'График өгөгдлийг харуулах';
$string['showcomments'] = 'Сэтгэгдлийг харуулах/нуух';
$string['showcommentsnonjs'] = 'Сэтгэгдлийг харуулах';
$string['showdescription'] = 'Хичээлийн хуудсанд тодорхойлолтыг харуулах';
$string['showdescription_help'] = 'Идэвхжүүлсэн тохиолдолд дээрх тодорхойлолтыг хичээлийн хуудасны үйл ажиллагаа эсвэл нөөцийн холбоосын яг доор харуулах болно.';
$string['showgrades'] = 'Журналыг суралцагчид харуулах';
$string['showgrades_help'] = 'Олон үйл ажиллагаанд үнэлгээг тогтоох боломжтой. Энэ тохиргоо нь суралцагч тухайн хичээлийн бүх үнэлгээний жагсаалтыг харах боломжтой эсэхийг тодорхойлдог.';
$string['showingacourses'] = 'Бүх {$a} хичээлийг харуулж байна';
$string['showingxofycourses'] = '{$a->total} хичээлийн {$a->start} - {$a->end} хүртэлх хичээлийг харуулж байна';
$string['showlistofcourses'] = 'Хичээлийн жагсаалтыг харуулах';
$string['showmodulecourse'] = 'Үйл ажиллагаа бүхий хичээлийн жагсаалтыг харуулах';
$string['showoncoursepage'] = 'Хичээлийн хуудсанд харуулах';
$string['showonly'] = 'Зөвхөн харуулах';
$string['showperpage'] = 'Нэг хуудсанд {$a} харуулах';
$string['showpopoverwindow'] = 'Давхарга цонхыг харуулах';
$string['showrecent'] = 'Сүүлийн үеийн үйл ажиллагааг харуулах';
$string['showreports'] = 'Үйл ажиллагааны тайланг харуулах';
$string['showreports_help'] = 'Үйл ажиллагааны тайлан нь суралцагч тус бүрээр хичээлийн үйл ажиллагааг харуулдаг. Уг тайлан нь хэлэлцүүлгийн нийтлэл, илгээсэн даалгавар зэрэг тухайн суралцагчийн гүйцэтгэсэн ажлын жагсаалтаас гадна хандалтын лог бүртгэлийг агуулна. Энэ тохиргоо нь суралцагч профайл хуудсаараа дамжуулан өөрийн гүйцэтгэсэн үйл ажиллагааны тайланг харах боломжтой эсэхийг тодорхойлдог.';
$string['showsettings'] = 'Тохиргоог харуулах';
$string['showtheselogs'] = 'Эдгээр лог бүртгэлийг харуулах';
$string['showthishelpinlanguage'] = 'Энэ тусламжийг энэ хэлээр харуулах: {$a}';
$string['sidepanel'] = 'Хажуугийн самбар';
$string['signoutofotherservices'] = 'Бүгдээс гарах';
$string['signoutofotherservices_help'] = 'Сонгож тэмдэглэсэн тохиолдолд мобайл аппликейшн зэрэг веб сервис ашигладаг бүх төхөөрөмж, системээс гарах болно.';
$string['since'] = 'Хойш';
$string['sincelast'] = 'хамгийн сүүлд нэвтэрснээс хойш';
$string['site'] = 'Сайт';
$string['sitedefault'] = 'Сайтын өгөгдмөл тохиргоо';
$string['sitedefaultspecified'] = 'Сайтын өгөгдмөл тохиргоо ({$a})';
$string['siteerrors'] = 'Сайтын алдаа';
$string['sitefiles'] = 'Сайтын файлууд';
$string['sitefilesused'] = 'Энэ хичээлд ашигласан сайтын файлууд';
$string['sitehome'] = 'Сайтын нүүр хуудас';
$string['sitelegacyfiles'] = 'Хуучин сайтын файлууд';
$string['sitelogs'] = 'Сайтын лог бүртгэл';
$string['sitenews'] = 'Сайтын зар мэдээ';
$string['sitepages'] = 'Сайтын хуудаснууд';
$string['sitepartlist'] = 'Танд оролцогчдын жагсаалтыг харахад шаардлагатай зөвшөөрөл байхгүй байна';
$string['sitepartlist0'] = 'Та сайтын оролцогчдын жагсаалтыг харахын тулд уг сайтын багш байх ёстой';
$string['sitepartlist1'] = 'Та сайтын оролцогчдын жагсаалтыг харахын тулд уг багш байх ёстой';
$string['sites'] = 'Сайтууд';
$string['sitesection'] = 'Сэдвийн хэсгийг оруулах';
$string['sitesettings'] = 'Сайтын тохиргоо';
$string['siteteachers'] = 'Сайтын багш';
$string['size'] = 'Хэмжээ';
$string['sizeb'] = 'байт';
$string['sizegb'] = 'ГБ';
$string['sizekb'] = 'КБ';
$string['sizemb'] = 'МБ';
$string['sizepb'] = 'ПБ';
$string['sizetb'] = 'ТБ';
$string['skipped'] = 'Алгассан';
$string['skiptocategorylisting'] = 'Ангиллын жагсаалтад очих';
$string['skiptocoursedetails'] = 'Хичээлийн дэлгэрэнгүй мэдээлэлд очих';
$string['skiptocourselisting'] = 'Хичээлийн жагсаалтад очих';
$string['socialheadline'] = 'Нийгмийн хэлэлцүүлэг - хамгийн сүүлийн үеийн сэдвүүд';
$string['someallowguest'] = 'Зарим хичээл зочны хандалтыг зөвшөөрдөг';
$string['someerrorswerefound'] = 'Зарим мэдээлэл дутуу эсвэл буруу байна. Дэлгэрэнгүйг дороос харна уу.';
$string['sort'] = 'Эрэмбэлэх';
$string['sortby'] = 'Эрэмбэлэх';
$string['sortbyx'] = '{$a} өсөх дарааллаар эрэмбэлэх';
$string['sortbyxreverse'] = '{$a} буурах дарааллаар эрэмбэлэх';
$string['sorting'] = 'Эрэмбэлэлт';
$string['sourcerole'] = 'Эх сурвалжийн эрх';
$string['specifyname'] = 'Та нэр зааж өгөх шаардлагатай.';
$string['standard'] = 'Стандарт';
$string['starpending'] = '([*] = зөвшөөрөл хүлээгдэж буй хичээл)';
$string['startdate'] = 'Хичээл эхлэх огноо';
$string['startdate_help'] = 'Энэ тохиргоо нь долоо хоногийн форматаар хичээлийн эхний долоо хоногийн эхлэлийг тодорхойлдог. Түүнчлэн хичээлийн үйл ажиллагааны лог бүртгэлийг авах боломжит хамгийн эрт огноог тодорхойлдог. Хичээлийг шинэчилж, хичээл эхлэх огноог өөрчилсөн тохиолдолд хичээлийн бүх огноог шинэ эхлэх огноотой уялдуулж шилжүүлэх болно.';
$string['startingfrom'] = 'Эхлэх';
$string['startsignup'] = 'Шинэ бүртгэл үүсгэх';
$string['state'] = 'Хот/Аймаг';
$string['statistics'] = 'Статистик мэдээ';
$string['statisticsgraph'] = 'Статистикийн график';
$string['stats'] = 'Статистик мэдээ';
$string['statslogins'] = 'Нэвтрэлт';
$string['statsmodedetailed'] = 'Дэлгэрэнгүй (хэрэглэгч) харагдац';
$string['statsmodegeneral'] = 'Ерөнхий харагдац';
$string['statsnodata'] = 'Тухайн хичээл ба хугацаанд нийцэх бэлэн өгөгдөл байхгүй байна.';
$string['statsnodatauser'] = 'Тухайн хичээл, суралцагч ба хугацаанд нийцэх бэлэн өгөгдөл байхгүй.';
$string['statsoff'] = 'Статистик мэдээг одоогоор идэвхжүүлээгүй байна';
$string['statsreads'] = 'Харагдац';
$string['statsreport1'] = 'Нэвтрэлт';
$string['statsreport10'] = 'Хэрэглэгчийн үйл ажиллагаа';
$string['statsreport11'] = 'Хамгийн идэвхтэй хичээлүүд';
$string['statsreport12'] = 'Хамгийн идэвхтэй хичээлүүд (жинлэсэн)';
$string['statsreport13'] = 'Хамгийн их оролцоотой хичээлүүд (бүртгэл)';
$string['statsreport14'] = 'Хамгийн их оролцоотой хичээлүүд (нийтлэл/үзэлт)';
$string['statsreport2'] = 'Үзэлт (бүх үүрэг)';
$string['statsreport3'] = 'Нийтлэл (бүх үүрэг)';
$string['statsreport4'] = 'Бүх үйл ажиллагаа (бүх үүрэг)';
$string['statsreport5'] = 'Бүх үйл ажиллагаа (үзэлт ба нийтлэл)';
$string['statsreport7'] = 'Хэрэглэгчийн үйл ажиллагаа (үзэлт ба нийтлэл)';
$string['statsreport8'] = 'Хэрэглэгчийн бүх үйл ажиллагаа';
$string['statsreport9'] = 'Нэвтрэлт (сайтын хичээл)';
$string['statsreportactivity'] = 'Бүх үйл ажиллагаа (бүх эрх)';
$string['statsreportactivitybyrole'] = 'Бүх үйл ажиллагаа (үзэлт ба нийтлэл)';
$string['statsreportforuser'] = 'тулд';
$string['statsreportlogins'] = 'Нэвтрэлт';
$string['statsreportreads'] = 'Үзэлт (бүх үүрэг)';
$string['statsreporttype'] = 'Тайлангийн төрөл';
$string['statsreportwrites'] = 'Нийтлэл (бүх үүрэг)';
$string['statsstudentactivity'] = 'Суралцагчийн үйл ажиллагаа';
$string['statsstudentreads'] = 'Суралцагчийн үзэлт';
$string['statsstudentwrites'] = 'Суралцагчийн нийтлэлүүд';
$string['statsteacheractivity'] = 'Багшийн үйл ажиллагаа';
$string['statsteacherreads'] = 'Багшийн үзэлт';
$string['statsteacherwrites'] = 'Багшийн нийтлэлүүд';
$string['statstimeperiod'] = 'Хугацаа - сүүлийн:';
$string['statsuniquelogins'] = 'Давтагдаагүй нэвтрэлт';
$string['statsuseractivity'] = 'Бүх үйл ажиллагаа';
$string['statsuserlogins'] = 'Нэвтрэлт';
$string['statsuserreads'] = 'Үзэлт';
$string['statsuserwrites'] = 'Нийтлэл';
$string['statswrites'] = 'Нийтлэл';
$string['status'] = 'Төлөв';
$string['statuscritical'] = 'Ноцтой';
$string['statuserror'] = 'Алдаа';
$string['statusinfo'] = 'Мэдээлэл';
$string['statusna'] = 'Байхгүй';
$string['statusok'] = 'ОК';
$string['statusunknown'] = 'Тодорхойгүй';
$string['statuswarning'] = 'Анхааруулга';
$string['stringsnotset'] = '{$a}-д дараах тэмдэгт мөрийг тодорхойлоогүй байна';
$string['studentnotallowed'] = 'Уучлаарай, та энэ хичээлд \'{$a}\' эрхээр орж боломжгүй';
$string['students'] = 'Суралцагчид';
$string['studentsandteachers'] = 'Суралцагчид, багш нар';
$string['subcategories'] = 'Дэд ангиллууд';
$string['subcategory'] = 'Дэд ангилал';
$string['subcategoryof'] = '{$a}-н дэд ангилал';
$string['subject'] = 'Сэдэв';
$string['submit'] = 'Илгээх';
$string['success'] = 'Амжилт';
$string['successduration'] = 'Амжилт ({$a} секунд)';
$string['summary'] = 'Дүгнэлт';
$string['summary_help'] = 'Дүгнэлтийн санаа нь суралцагчдыг тодорхой сэдэв эсвэл долоо хоногийн хүрээнд хийх үйл ажиллагаанд бэлтгэх богино бичвэр юм. Уг бичвэрийг хичээлийн хуудсанд бүлгийн нэрийн дор харуулна.';
$string['summaryof'] = '{$a} дүгнэлт';
$string['suspended'] = 'Түдгэлзүүлсэн';
$string['suspendedusers'] = 'Түдгэлзүүлсэн хэрэглэгч';
$string['switchdevicedefault'] = 'Стандарт загварт шилжих';
$string['switchdevicerecommended'] = 'Таны төхөөрөмжид нийцүүлэн санал болгосон загварт шилжих';
$string['switchrolereturn'] = 'Миний ердийн эрх рүү буцах';
$string['switchroleto'] = 'Эрхийг шилжүүлэх...';
$string['switchroleto_help'] = 'Тухайн эрх бүхий хэрэглэгч энэ хичээлийг хэрхэн үзэх талаар санаа авахын тулд эрхээ сонгоно.

Энэ харагдац төгс биш байж болзошгүйг анхаарна уу (<a href="https://docs.moodle.org/en/Switch_roles">Дэлгэрэнгүй мэдээлэл, хувилбарыг харна уу</a>).';
$string['tag'] = 'Таг';
$string['tagalready'] = 'Ийм таг хэдийнэ байна';
$string['tagmanagement'] = 'Таг нэмэх/устгах...';
$string['tags'] = 'Тагууд';
$string['targetrole'] = 'Тагийн эрх';
$string['teacheronly'] = 'зөвхөн {$a}-д';
$string['teacherroles'] = '{$a} үүрэг';
$string['teachers'] = 'Багш';
$string['textcopiedtoclipboard'] = 'Бичвэрийг завсрын санах ойд хуулсан';
$string['textediting'] = 'Бичвэр засварлагч';
$string['textediting_help'] = 'Хэрэв Atto, TinyMCE зэрэг HTML засварлагчийг сонговол бичвэр оруулах талбар нь агуулгыг хялбархан нэмэх товчлуур бүхий хэрэгсэлтэй байх болно.

Хэрэв \'энгийн бичвэр талбарыг\' сонговол HTML, Markdown зэрэг бичвэр оруулах талбарын форматыг сонгох боломжтой болно.

Сайтын администратор нь боломжит бичвэр засварлагчийн жагсаалтыг тодорхойлно.';
$string['texteditor'] = 'Стандарт веб маягтыг ашиглах';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Энгийн бичвэр формат';
$string['thanks'] = 'Талархал';
$string['theme'] = 'Загвар';
$string['themes'] = 'Загварууд';
$string['themesaved'] = 'Шинэ загварыг хадгалсан';
$string['therearecourses'] = '{$a} хичээл байна';
$string['thereareno'] = 'Энэ хичээлд {$a} байхгүй';
$string['thiscategory'] = 'Энэ ангилал';
$string['thiscategorycontains'] = 'Энэ ангилалд багтана';
$string['time'] = 'Хугацаа';
$string['timecreated'] = 'Хугацааг үүсгэсэн';
$string['timecreatedcourse'] = 'Хичээлийн хугацааг үүсгэсэн';
$string['timesplitting:deciles'] = 'Сүүлийн аравт';
$string['timesplitting:deciles_help'] = 'Энэхүү шинжилгээний интервал нь хичээлийг аравтад (10 тэнцүү хэсэгт) хувааж, таамаглал бүр нь зөвхөн хамгийн сүүлийн аравтын өгөгдөлд тулгуурладаг.';
$string['timesplitting:decilesaccum'] = 'Өмнөх бүх аравт';
$string['timesplitting:decilesaccum_help'] = 'Энэхүү шинжилгээний интервал нь хичээлийг аравтад (10 тэнцүү хэсэгт) хувааж, таамаглал бүрийг бүх өмнөх аравтын хуримтлагдсан өгөгдөлд тулгуурладаг.';
$string['timesplitting:nosplitting'] = 'Хугацааны хязгаарлалт байхгүй';
$string['timesplitting:nosplitting_help'] = 'Энэ загварт шинжилгээний интервалыг тодорхойлоогүй байна.';
$string['timesplitting:onemonthafterstart'] = 'Эхэлснээс хойш нэг сарын дараа';
$string['timesplitting:onemonthafterstart_help'] = 'Энэхүү шинжилгээний интервал нь шинжилгээ хийж эхэлснээс хойш 1 сарын дараа таамаглал боловсруулдаг.';
$string['timesplitting:oneweekafterstart'] = 'Эхэлснээс хойш нэг долоо хоногийн дараа';
$string['timesplitting:oneweekafterstart_help'] = 'Энэхүү шинжилгээний интервал нь шинжилгээ хийж эхэлснээс хойш 1 долоо хоногийн дараа таамаглал боловсруулдаг.';
$string['timesplitting:past3days'] = 'Өнгөрсөн 3 хоног';
$string['timesplitting:past3days_help'] = 'Энэхүү шинжилгээний интервал нь 3 хоног тутам таамаглал боловсруулдаг. Шалгуур үзүүлэлтийн тооцооллыг сүүлийн 3 хоногт үндэслэн хийнэ.';
$string['timesplitting:pastmonth'] = 'Өнгөрсөн сар';
$string['timesplitting:pastmonth_help'] = 'Энэхүү шинжилгээний интервал нь сар тутам таамаглал боловсруулдаг. Шалгуур үзүүлэлтийн тооцооллыг сүүлийн сард үндэслэн хийнэ.';
$string['timesplitting:pastweek'] = 'Өнгөрсөн долоо хоног';
$string['timesplitting:pastweek_help'] = 'Энэхүү шинжилгээний интервал нь долоо хоног тутам таамаглал боловсруулдаг. Шалгуур үзүүлэлтийн тооцооллыг сүүлийн долоо хоногт үндэслэн хийнэ.';
$string['timesplitting:quarters'] = 'Сүүлийн улирал';
$string['timesplitting:quarters_help'] = 'Энэхүү шинжилгээний интервал нь хичээлийг улиралд (4 тэнцүү хэсэгт) хувааж,  таамаглал бүрийг зөвхөн хамгийн сүүлийн улирлын өгөгдөлд тулгуурладаг.';
$string['timesplitting:quartersaccum'] = 'Өмнөх бүх улирал';
$string['timesplitting:quartersaccum_help'] = 'Энэхүү шинжилгээний интервал нь хичээлийг улиралд (4 тэнцүү хэсэгт) хувааж,  таамаглал бүрийг өмнөх бүх улирлын хуримтлагдсан өгөгдөлд тулгуурладаг.';
$string['timesplitting:singlerange'] = 'Эхлэхээс дуусах хүртэл';
$string['timesplitting:singlerange_help'] = 'Энэхүү шинжилгээний интервал нь хичээлийг бүхэлд нь нэг үе гэж үздэг.';
$string['timesplitting:tenpercentafterstart'] = 'Эхэлснээс хойш 10%';
$string['timesplitting:tenpercentafterstart_help'] = 'Энэхүү шинжилгээний интервал нь хичээлийн 10% дууссаны дараа таамаглал боловсруулдаг.';
$string['timesplitting:upcoming3days'] = 'Ирэх 3 хоног';
$string['timesplitting:upcoming3days_help'] = 'Энэхүү шинжилгээний интервал нь 3 хоног тутам таамаглал боловсруулдаг. Шалгуур үзүүлэлтийн тооцооллыг ирэх 3 хоногт үндэслэн хийх болно.';
$string['timesplitting:upcomingfortnight'] = 'Ирэх хоёр долоо хоног';
$string['timesplitting:upcomingfortnight_help'] = 'Энэхүү шинжилгээний интервал нь хоёр долоо хоног тутам таамаглал боловсруулдаг. Шалгуур үзүүлэлтийн тооцооллыг ирэх хоёр долоо хоногт үндэслэн хийх болно.';
$string['timesplitting:upcomingweek'] = 'Ирэх долоо хоног';
$string['timesplitting:upcomingweek_help'] = 'Энэхүү шинжилгээний интервал нь долоо хоног тутам таамаглал боловсруулдаг. Шалгуур үзүүлэлтийн тооцооллыг ирэх долоо хоногт үндэслэн хийх болно.';
$string['timezone'] = 'Цагийн бүс';
$string['to'] = 'Хүртэл';
$string['tocontent'] = '"{$a}" зүйл рүү';
$string['tocreatenewaccount'] = 'Шинэ бүртгэл үүсгэхэд очих';
$string['todate'] = 'Хүртэл';
$string['today'] = 'Өнөөдөр';
$string['todaylogs'] = 'Өнөөдрийн лог бүртгэл';
$string['toeveryone'] = 'бүх хүнд';
$string['toggleemojipicker'] = 'Эмож сонгох хэсгийг сонгон тэмдэглэх';
$string['togglesearch'] = 'Хайлтын оролтыг сонгох';
$string['toomanybounces'] = 'Энэ цахим шуудангийн хаягаас хэт олон удаа амжилтгүй шуудан илгээгдсэн байна. Үргэлжлүүлэхийн тулд та үүнийг өөрчлөх <b>шаардлагатай</b>.';
$string['toomanytags'] = 'Энэ хайлтад хэт олон таг орсон, зарим нь цуцлагдах болно.';
$string['toomanytoshow'] = 'Харуулахад хэт олон хэрэглэгч байна';
$string['toomanyusersmatchsearch'] = 'Хэт олон ({$a->count}) хэрэглэгч \'{$a->search}\'-тай нийцэж байна';
$string['toomanyuserstoshow'] = 'Харуулахад хэт олон ({$a}) хэрэглэгч байна';
$string['toonly'] = 'зөвхөн {$a} хүртэл';
$string['top'] = 'Дээд';
$string['topic'] = 'Сэдэв';
$string['topichide'] = '{$a}-аас энэ сэдвийг нуух';
$string['topicoutline'] = 'Сэдвийн тойм';
$string['topicshow'] = 'Энэ сэдвийг {$a}-д харуулах';
$string['toplevelcategory'] = 'Дээд түвшний ангилал';
$string['torecipient'] = 'Хүртэл';
$string['total'] = 'Нийт';
$string['totopofsection'] = '"{$a}" хэсгийн эхэнд хүртэл';
$string['trackforums'] = 'Хэлэлцүүлгийн хяналт';
$string['trackforumsno'] = 'Үгүй: миний харсан нийтлэлийг хянах шаардлагагүй';
$string['trackforumsyes'] = 'Тийм: надад шинэ нийтлэлийг онцолж өгнө үү';
$string['trysearching'] = 'Оронд нь хайлт хийнэ үү.';
$string['turneditingoff'] = 'Засварлах боломжийг хаах';
$string['turneditingon'] = 'Засварлах боломжийг нээх';
$string['unabletocopytoclipboard'] = 'Бичвэрийг завсрын санах ой руу хуулах боломжгүй';
$string['unauthorisedlogin'] = 'Энэ сайтад "{$a}" хэрэглэгчийн бүртгэл байхгүй байна';
$string['undecided'] = 'Тодорхой бус';
$string['unexistingcmid'] = 'Хичээлийн модулийн ID дугаар олдсонгүй';
$string['unexistingsectionid'] = 'Хичээлийн хэсгийн ID дугаар олдсонгүй';
$string['unfinished'] = 'Дуусаагүй';
$string['unknowncategory'] = 'Тодорхойгүй ангилал';
$string['unknownerror'] = 'Үл мэдэгдэх алдаа';
$string['unknownuser'] = 'Үл мэдэгдэх хэрэглэгч';
$string['unlimited'] = 'Хязгааргүй';
$string['unpacking'] = '{$a}-г задалж байна';
$string['unsafepassword'] = 'Эрсдэлтэй нууц үг байна - өөр үг оруулна уу';
$string['untilcomplete'] = 'Дуусгах хүртэл';
$string['unusedaccounts'] = '{$a} хоногоос дээш хугацаанд ашиглаагүй бүртгэлийг автоматаар хасна';
$string['unzip'] = 'Архив задлах';
$string['unzippingbackup'] = 'Нөөцлөлтийг задалж байна';
$string['up'] = 'Дээшээ';
$string['update'] = 'Шинэчлэх';
$string['updated'] = '{$a} шинэчлэгдсэн';
$string['updatemymoodleoff'] = 'Энэ хуудсыг тусгайлан өөрчлөхийг зогсоох';
$string['updatemymoodleon'] = 'Энэ хуудсыг тусгайлан өөрчлөх';
$string['updatemyprofile'] = 'Профайлыг шинэчлэх';
$string['updatesevery'] = '{$a} секунд бүрд шинэчлэх';
$string['updatethis'] = 'Энэ {$a}-г шинэчлэх';
$string['updatethiscourse'] = 'Энэ хичээлийг шинэчлэх';
$string['updatinga'] = 'Шинэчилж байна: {$a}';
$string['updatingain'] = '{$a->what} нь {$a->in} руу шинэчлэгдэж байна';
$string['upload'] = 'Байршуулах';
$string['uploadafile'] = 'Файл байршуулах';
$string['uploadcantwrite'] = 'Файлыг диск рүү бичих чадсангүй';
$string['uploadedfile'] = 'Файлыг амжилттай байршууллаа';
$string['uploadedfileto'] = '{$a->file} файлыг {$a->directory} хавтсанд байршуулсан';
$string['uploadedfiletoobig'] = 'Уучлаарай, энэ файл хэт том байна (хязгаар нь {$a} байт)';
$string['uploadextension'] = 'Файлын байршуулалтыг PHP өргөтгөлөөр зогсоосон';
$string['uploadfailednotrecovering'] = '{$a->name} файлд асуудал гарсан тул файл байршуулалт амжилтгүй боллоо.<br /> Асуудлын лог бүртгэл:<br />{$a->problem}<br />Сэргээгдэхгүй байна.';
$string['uploadfilelog'] = '{$a} файлын байршуулалтын лог бүртгэл';
$string['uploadformlimit'] = 'Байршуулсан {$a} файл нь маягтад тогтоосон дээд хэмжээний хязгаараас хэтэрсэн';
$string['uploadlabel'] = 'Гарчиг:';
$string['uploadlimitwithsize'] = '{$a->contextname} байршуулах хязгаар ({$a->displaysize})';
$string['uploadnewfile'] = 'Шинэ файл байршуулах';
$string['uploadnofilefound'] = 'Ямар ч файл олдсонгүй - та байршуулах файлаа сонгосондоо итгэлтэй байна уу?';
$string['uploadnotallowed'] = 'Байршуулахыг зөвшөөрөхгүй';
$string['uploadnotempdir'] = 'Түр хавтас байхгүй байна';
$string['uploadoldfilesdeleted'] = 'Таны байршуулах талбарт байсан хуучин файл устгагдсан';
$string['uploadpartialfile'] = 'Файлыг зөвхөн хэсэгчлэн байршуулсан';
$string['uploadproblem'] = '\'{$a}\' файлыг байршуулах явцад үл мэдэгдэх алдаа гарлаа (файл хэт том эсэх?)';
$string['uploadrenamedchars'] = 'Файлын нэрэнд буруу тэмдэгт орсон тул {$a->oldname} нэрийг {$a->newname} болгон өөрчиллөө.';
$string['uploadrenamedcollision'] = 'Файлын нэр зөрчилтэй байгаа тул {$a->oldname} нэрийг {$a->newname} болгон өөрчиллөө.';
$string['uploadserverlimit'] = 'Байршуулсан файл нь серверийн тогтоосон дээд хэмжээнээс хэтэрсэн байна';
$string['uploadthisfile'] = 'Энэ файлыг байршуулах';
$string['url'] = 'URL хаяг';
$string['used'] = 'Ашигласан';
$string['usedinnplaces'] = '{$a} талбарт хэрэглэсэн';
$string['user'] = 'Хэрэглэгч';
$string['useraccount'] = 'Хэрэглэгчийн бүртгэл';
$string['useractivity'] = 'Үйл ажиллагаа';
$string['userconfirmed'] = '{$a} батлагдсан';
$string['userdata'] = 'Хэрэглэгчийн өгөгдөл';
$string['userdeleted'] = 'Энэ хэрэглэгчийн бүртгэл устгагдсан';
$string['userdescription'] = 'Тодорхойлолт';
$string['userdescription_help'] = 'Энэ талбар нь өөрийнхөө талаарх бичвэр оруулах боломжийг олгож, улмаар бусдад харуулах боломжтойгоор профайл хуудсанд гаргах болно.';
$string['userdetails'] = 'Хэрэглэгчийн дэлгэрэнгүй мэдээлэл';
$string['userfiles'] = 'Хэрэглэгчийн файлууд';
$string['userlist'] = 'Хэрэглэгчийн жагсаалт';
$string['usermenu'] = 'Хэрэглэгчийн цэс';
$string['usermenugoback'] = 'Хэрэглэгчийн цэс рүү буцах';
$string['username'] = 'Хэрэглэгчийн нэр';
$string['usernameemail'] = 'Хэрэглэгчийн нэр эсвэл цахим шуудан';
$string['usernameemailmatch'] = 'Хэрэглэгчийн нэр, цахим шуудангийн хаяг нь ижил хэрэглэгчтэй холбоогүй байна';
$string['usernameexists'] = 'Энэ хэрэглэгчийн нэр хэдийнэ байгаа тул өөр нэр сонгоно уу';
$string['usernamelowercase'] = 'Зөвхөн жижиг үсгийг зөвшөөрнө';
$string['usernamenotfound'] = 'Өгөгдлийн сангаас хэрэглэгчийн нэр олдсонгүй';
$string['usernameoremail'] = 'Хэрэглэгчийн нэр эсвэл цахим шуудангийн хаягийг оруулах';
$string['usernotconfirmed'] = '{$a}-г баталгаажуулж чадсангүй';
$string['userpic'] = 'Хэрэглэгчийн зураг';
$string['userpreferences'] = 'Хэрэглэгчийн сонголтууд';
$string['users'] = 'Хэрэглэгчид';
$string['userselectorautoselectunique'] = 'Хэрэв хайлтад зөвхөн нэг хэрэглэгч таарч байвал тэдгээрийг автоматаар сонгоно';
$string['userselectorpreserveselected'] = 'Хэрэв хайлтад таарахгүй байвал сонгосон хэрэглэгчдийг үлдээнэ';
$string['userselectorsearchanywhere'] = 'Хайлтын бичвэрийг үзүүлсэн талбаруудын дурын хэсэгт тааруулах';
$string['usersnew'] = 'Шинэ хэрэглэгч';
$string['usersnoaccesssince'] = '-аас дээш хугацаанд идэвхгүй байна';
$string['userswithfiles'] = 'Файл бүхий хэрэглэгч';
$string['useruploadtype'] = 'Хэрэглэгчийн байршуулалтын төрөл: {$a}';
$string['userzones'] = 'Хэрэглэгчийн бүс';
$string['usetheme'] = 'Хэрэглэгчийн загвар';
$string['usingexistingcourse'] = 'Одоогийн хичээлийг хэрэглэж байна';
$string['validatehtml'] = 'HTML баталгаажуулах';
$string['valuealreadyused'] = 'Энэ утгыг хэдийнэ ашигласан байна.';
$string['version'] = 'Хувилбар';
$string['view'] = 'Харах';
$string['viewallcourses'] = 'Бүх хичээлийг харах';
$string['viewallcoursescategories'] = 'Бүх хичээл, ангиллыг харах';
$string['viewallsubcategories'] = 'Бүх дэд ангиллыг харах';
$string['viewfileinpopup'] = 'Файлыг нэмэлт цонхонд харах';
$string['viewing'] = 'Харах зүйл:';
$string['viewmore'] = 'Илүү олныг харах';
$string['viewprofile'] = 'Профайл харах';
$string['views'] = 'Харагдац';
$string['viewsolution'] = 'шийдэл харах';
$string['visible'] = 'Харагдахуйц';
$string['visible_help'] = 'Энэ тохиргоо нь хичээлийн жагсаалтад тухайн хичээлийг харуулах эсэхийг тодорхойлдог. Багш, администратороос бусад хэрэглэгчийг хичээлд орохыг зөвшөөрөхгүй.';
$string['visibletostudents'] = '{$a}-д харагдах';
$string['warning'] = 'Анхааруулга';
$string['warningdeleteresource'] = 'Анхааруулга: {$a} нь нөөцөд байна. Та нөөцийг шинэчлэхийг хүсэж байна уу?';
$string['wcagcheck'] = 'Веб контентын хүртээмжийн удирдамж (WCAG) шалгах';
$string['webpage'] = 'Веб хуудас';
$string['week'] = 'Долоо хоног';
$string['weekhide'] = '{$a}-аас энэ долоо хоногийг нуух';
$string['weeklyoutline'] = 'Долоо хоног тутмын тойм';
$string['weeks'] = 'долоо хоног';
$string['weekshow'] = '{$a}-д энэ долоо хоногийг харуулах';
$string['welcomeback'] = '{$a->firstname}, дахин тавтай морилно уу! 👋';
$string['welcometocourse'] = '{$a}-д тавтай морилно уу!';
$string['welcometocoursetext'] = '{$a->coursename} тавтай морилно уу!

Та өөрийн профайл хуудсыг засварлах шаардлагатай. Ингэснээр бид таны талаар илүү ихийг мэдэх боломжтой болно:

  {$a->profileurl}';
$string['welcometosite'] = '{$a->firstname} тавтай морилно уу! 👋';
$string['whatforlink'] = 'Та энэ холбоосоор юу хийхийг хүсэж байна вэ?';
$string['whatforpage'] = 'Та энэ бичвэрээр юу хийхийг хүсэж байна вэ?';
$string['whatisyourage'] = 'Та хэдэн настай вэ?';
$string['whattocallzip'] = 'Та шахсан файлыг юу гэж нэрлэхийг хүсэж байна вэ?';
$string['whattodo'] = 'Юу хийх вэ';
$string['wheredoyoulive'] = 'Та аль улсад амьдардаг вэ?';
$string['whyisthisrequired'] = 'Энэ яагаад шаардлагатай вэ?';
$string['windowclosing'] = 'Энэ цонх автоматаар хаагдах ёстой. Хаагдаагүй бол яг одоо хаана уу.';
$string['withchosenfiles'] = 'Сонгосон файлын хамтаар';
$string['withdisablednote'] = '{$a} (идэвхгүй болгосон)';
$string['withoutuserdata'] = 'хэрэглэгчийн өгөгдөлгүйгээр';
$string['withselectedusers'] = 'Сонгосон хэрэглэгчийн хамт...';
$string['withuserdata'] = 'хэрэглэгчийн өгөгдөлтэй хамт';
$string['wontrunfuturescheduledtask'] = 'Амжилтгүй бус, цаашид ажиллуулахаар төлөвлөсөн ажлыг гүйцэтгэхгүй';
$string['wordforstudent'] = 'Суралцагчид зориулсан таны үг';
$string['wordforstudenteg'] = 'жишээ нь суралцагч, оролцогч гэх мэт';
$string['wordforstudents'] = 'Суралцагчдад зориулсан таны үг';
$string['wordforstudentseg'] = 'жишээ нь суралцагчид, оролцогчид гэх мэт';
$string['wordforteacher'] = 'Багшид зориулсан таны үг';
$string['wordforteachereg'] = 'жишээ нь багш, сургагч, чиглүүлэгч гэх мэт';
$string['wordforteachers'] = 'Багш нарт зориулсан таны үг';
$string['wordforteacherseg'] = 'жишээ нь багш нар, сургагчид, чиглүүлэгчид гэх мэт';
$string['writingblogsinfo'] = 'Блогийн мэдээллийг бичиж байна';
$string['writingcategoriesandquestions'] = 'Ангилал, асуултыг бичиж байна';
$string['writingcoursedata'] = 'Хичээлийн өгөгдлийг бичиж байна';
$string['writingeventsinfo'] = 'Арга хэмжээний мэдээллийг бичиж байна';
$string['writinggeneralinfo'] = 'Ерөнхий мэдээллийг бичиж байна';
$string['writinggradebookinfo'] = 'Журналын мэдээллийг бичиж байна';
$string['writinggroupingsgroupsinfo'] = 'Бүлэглэл-бүлгийн мэдээллийг бичиж байна';
$string['writinggroupingsinfo'] = 'Бүлэглэлийн мэдээлэл бичиж байна';
$string['writinggroupsinfo'] = 'Бүлгийн мэдээллийг бичиж байна';
$string['writingheader'] = 'Толгой хэсгийн мэдээллийг бичиж байна';
$string['writingloginfo'] = 'Лог бүртгэлийн мэдээллийг бичиж байна';
$string['writingmessagesinfo'] = 'Зурвасын мэдээллийг бичиж байна';
$string['writingmoduleinfo'] = 'Модулийн мэдээллийг бичиж байна';
$string['writingscalesinfo'] = 'Хэмжүүрийн мэдээллийг бичиж байна';
$string['writinguserinfo'] = 'Хэрэглэгчийн мэдээллийг бичиж байна';
$string['wrongpassword'] = 'Хэрэглэгчийн нэрийн нууц үг нь буруу байна';
$string['year'] = 'жил';
$string['years'] = 'жил';
$string['yes'] = 'Тийм';
$string['youareabouttocreatezip'] = 'Та дараах агуулга бүхий шахсан файл үүсгэх гэж байна';
$string['youaregoingtorestorefrom'] = 'Та дараах сэргээх процессыг эхлүүлэх гэж байна';
$string['youhaveupcomingactivitiesdue'] = 'Танд удахгүй болох үйл ажиллагаа байна';
$string['youhaveupcomingactivitiesdueinfo'] = 'Сайн байна уу {$a},

<br/><br/>Танд удахгүй болох үйл ажиллагаа байна:';
$string['youneedtoenrol'] = 'Та энэ үйлдлийг гүйцэтгэхийн тулд уг хичээлд бүртгүүлэх шаардлагатай.';
$string['yourlastlogin'] = 'Таны хамгийн сүүлийн нэвтрэлт';
$string['yourself'] = 'та өөрөө';
$string['yourteacher'] = 'таны {$a}';
$string['yourwordforx'] = '{$a}\'-д зориулсан таны үг';
$string['zippingbackup'] = 'Шахаж нөөцлөх';
