<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_openai', language 'sr_cr', version '4.5'.
 *
 * @package     aiprovider_openai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:generate_image:endpoint'] = 'API крајња тачка';
$string['action:generate_image:model'] = 'AI модел';
$string['action:generate_image:model_desc'] = 'Модел који се користи за генерисање слика на основу корисничких упита.';
$string['action:generate_text:endpoint'] = 'API крајња тачка';
$string['action:generate_text:model'] = 'AI модел';
$string['action:generate_text:model_desc'] = 'Модел који се користи за генерисање текстуалног одговора.';
$string['action:generate_text:systeminstruction'] = 'Системско упутство';
$string['action:generate_text:systeminstruction_desc'] = 'Ово упутство се шаље AI моделу заједно са упитом корисника. Уређивање овог упутства се не препоручује осим ако је апсолутно неопходно.';
$string['action:summarise_text:endpoint'] = 'API крајња тачка';
$string['action:summarise_text:model'] = 'AI модел';
$string['action:summarise_text:model_desc'] = 'Модел који се користи за резимирање датог текста.';
$string['action:summarise_text:systeminstruction'] = 'Системско упутство';
$string['action:summarise_text:systeminstruction_desc'] = 'Ово упутство се шаље AI моделу заједно са упитом корисника. Уређивање овог упутства се не препоручује осим ако је апсолутно неопходно.';
$string['apikey'] = 'OpenAI API кључ';
$string['apikey_desc'] = 'Преузмите кључ са <a href="https://platform.openai.com/account/api-keys">OpenAI платформе API кључева</a>.';
$string['enableglobalratelimit'] = 'Подесите ограничење коришћења AI сервиса на нивоу сајта';
$string['enableglobalratelimit_desc'] = 'Ограничите број захтева које OpenAI API провајдер може да прима на целом сајту сваког сата.';
$string['enableuserratelimit'] = 'Подесите ограничење коришћења од стране појединачног корисника';
$string['enableuserratelimit_desc'] = 'Ограничите број захтева које сваки корисник може упути сваког сата OpenAI API провајдеру.';
$string['globalratelimit'] = 'Максималан број захтева на нивоу сајта';
$string['globalratelimit_desc'] = 'Број дозвољених захтева на нивоу сајта по сату.';
$string['orgid'] = 'ID ознака OpenAI организације';
$string['orgid_desc'] = 'Преузмите ID ознаку OpenAI организације са свог <a href="https://platform.openai.com/account/org-settings">OpenAI налога</a>';
$string['pluginname'] = 'OpenAI API провајдер';
$string['privacy:metadata'] = 'Додатак за провајдера OpenAI API не чува никакве личне податке.';
$string['privacy:metadata:aiprovider_openai:externalpurpose'] = 'Ове информације се шаљу OpenAI API-ју како би се генерисао одговор. Подешавања вашег OpenAI налога могу да промене начин на који OpenAI похрањује и чува ове податке. Овај додатак не шаље експлицитно корисничке податке у OpenAI нити их чува у Moodle LMS-у.';
$string['privacy:metadata:aiprovider_openai:model'] = 'Модел који се користи за генерисање одговора.';
$string['privacy:metadata:aiprovider_openai:numberimages'] = 'Број слика коришћених у одговору, приликом генерисања слика.';
$string['privacy:metadata:aiprovider_openai:prompttext'] = 'Текстуални упит унет од стране корисника који се користи за генерисање одговора.';
$string['privacy:metadata:aiprovider_openai:responseformat'] = 'Формат одговора, приликом генерисања слика.';
$string['userratelimit'] = 'Максималан број захтева по кориснику';
$string['userratelimit_desc'] = 'Број дозвољених захтева по сату, по једном кориснику.';
