<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_shibboleth', language 'af', version '4.5'.
 *
 * @package     auth_shibboleth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_shib_auth_logo'] = 'Verifikasie metode logo';
$string['auth_shib_auth_logo_description'] = 'Verskaf \'n logo vir die Shibboleth verifikasie metode wat aan jou gebruikers bekend is. Hierdie kan die logo van jou Shibboleth federasie wees, bv. <tt>SWITCHaai Login</tt> of <tt>InCommon Login</tt> of soortgelyk.';
$string['auth_shib_auth_method'] = 'Verifikasie metode naam';
$string['auth_shib_auth_method_description'] = 'Verskaf \'n naam vir die Shibboleth verifikasie metode wat aan jou gebruikers bekend is. Hierdie kan die naam van jou Shibboleth federasie wees, bv. <tt>SWITCHaai Login</tt> of <tt>InCommon Login</tt> of soortgelyk.';
$string['auth_shib_changepasswordurl'] = 'Wagwoord verandering URL';
$string['auth_shib_contact_administrator'] = 'Indien jy nie met die gegewe organisasies geassosieer is nie en toegang tot \'n kursus op hierdie bediener verlang, kontak asseblief die <a href="mailto:{$a}">Moodle Administrateur</a>.';
$string['auth_shib_convert_data'] = 'Data wysiging API';
$string['auth_shib_convert_data_description'] = 'Jy kan hierdie API gebruik om verder die data deur Shibboleth verskaf, te wysig. Lees die <a href="{$a}">README</a> vir verdere instruksies.';
$string['auth_shib_convert_data_filepath_warning'] = 'Jy kan nie \'n lêer wat binne die huidige webwerf se data gidslêer ($CFG->dataroot) is, as die data wysiging API gebruik nie.';
$string['auth_shib_convert_data_warning'] = 'Die lêer bestaan nie, of dit is onleesbaar deur die webbediener proses!';
$string['auth_shib_idp_list'] = 'Identiteitsverskaffers';
$string['auth_shib_idp_list_description'] = 'Verskaf \'n lys van Identiteitsverskaffer entiteite ID\'s waarvan die gebruiker op die intekeningsbladsy kan kies.<br />Daar moet op elke lyn \'n komma-geskeide tal vir entiteitsID van die IdP (sien die Shibboleth metadata lêer) wees, asook die Naam van IdP soos dit in die aftreklys vertoon gaan word.<br />As \'n opsionele derde parameter kan jy die ligging van \'n Shibboleth sessie inisieerder byvoeg wat gebruik sal word indien jou Moodle installasie deel is van \'n veelvuldige federasie opset.';
$string['auth_shib_instructions'] = 'Gebruik die <a href="{$a}">Shibboleth inteken</a> om toegang via Shibboleth te verkry indien jou institusie dit ondersteun. Gebruik andersins die normale intekeningsvorm soos hier vertoon.';
$string['auth_shib_instructions_help'] = 'Hier moet jy doelgemaakte instruksies vir jou gebruikers verskaf om Shibboleth te verduidelik. Dit sal op die intekeningsbladsy onder die instruksie afdeling gewys word. Die instruksies moet \'n skakel na "<b>{$a}</b>" bevat waarop gebruikers kan klik as hulle wil inteken.';
$string['auth_shib_instructions_key'] = 'Inteken instruksies';
$string['auth_shib_integrated_wayf'] = 'Moodle WAYF diens';
$string['auth_shib_integrated_wayf_description'] = 'Indien jy hierdie ontsper, sal Moodle sy eie WAYF diens gebruik, in plaas van die een wat vir Shibboleth gekonfigureer is. Moodle sal \'n aftrek lys op hierdie alternatiewe intekeningsbladsy vertoon waar die gebruiker sy Identiteitsverskaffer moet kies.';
$string['auth_shib_logout_return_url'] = 'Alternatiewe uitteken terugkeer URL';
$string['auth_shib_logout_return_url_description'] = 'Verskaf die URL waarna Shibboleth gebruikers gestuur gaan word wanneer hulle klaar uitgeteken het. <br />Indien leeg gelaat, sal gebruikers gestuur word na die ligging waarna Moodle gebruikers stuur.';
$string['auth_shib_logout_url'] = 'Shibboleth Diensverskaffer uitteken hanteerder URL';
$string['auth_shib_logout_url_description'] = 'Verskaf die URL na die Shibboleth Diensverskaffer uitteken hanteerder, Gewoonlik is dit <tt>/Shibboleth.sso/Logout</tt>';
$string['auth_shib_no_organizations_warning'] = 'Indien jy die geintegreerde WAYF diens wil gebruik, moet jy \'n komma-geskeide lys van Identiteitsverskaffer entiteitsID\'s, hul name en opsioneel ook \'n sessie inisieerder verskaf.';
$string['auth_shib_only'] = 'Slegs Shibboleth';
$string['auth_shib_only_description'] = 'Merk hierdie opsie as \'n Shibboleth verifikasie afgedwing sal word';
$string['auth_shib_username_description'] = 'Naam van die webbediener Shibboleth omgewing veranderlike wat gebruik sal word as Moodle se gebruikersnaam';
$string['auth_shibboleth_errormsg'] = 'Kies asseblief die organisasie waarvan jy \'n lid is!';
$string['auth_shibboleth_login'] = 'Shibboleth inteken';
$string['auth_shibboleth_login_long'] = 'Teken in na Moodle via Shibboleth';
$string['auth_shibboleth_manual_login'] = 'Teken per hand in';
$string['auth_shibboleth_select_member'] = 'Ek is \'n lid van ...';
$string['auth_shibboleth_select_organization'] = 'Vir verifikasie via Shibboleth, kies asseblief jou organisasie vanaf die aftrek kieslys:';
$string['auth_shibbolethdescription'] = 'Deur hierdie metode te gebruik, word gebruikers deur middel van Shibboleth geskep en geverifieer. Vir opstellingsbesonderhede, sien die <a href="{$a}">Shibboleth README</a>.';
$string['pluginname'] = 'Shibboleth';
$string['privacy:metadata'] = 'Die Shibboleth verifikasie inprop stoor nie enige persoonlike data nie.';
$string['shib_invalid_account_error'] = 'Dit wil voorkom asof jy deur Shibboleth geverifieer is, maar Moodle het geen geldige rekening vir jou gebruikersnaam nie. Jou rekening bestaan moontlik nie, of dit is opgeskort.';
$string['shib_no_attributes_error'] = 'Dit wil voorkom asof jy deur Shibboleth geverifieer is, maar Moodle het nie enige gebruikerseienskappe ontvang nie. Bevestig asseblief dat jou Identiteitsverskaffer die nodige eienskappe ({$a}) aan die Diensverskaffer waarop Moodle hardloop verskaf, of lig die webmeester van hierdie bediener in.';
$string['shib_not_all_attributes_error'] = 'Moodle benodig sekere Shibboleth eienskappe wat nie in jou geval teenwoordig is nie. Die eienskappe is: {$a}<br />Kontak asseblief die webmeester van hierdie bediener of jou Identiteitsverskaffer.';
$string['shib_not_set_up_error'] = 'Dit wil voorkom dat Shibboleth verifikasie nie korrek ingestel is nie, omdat geen Shibboleth omgewingsveranderlikes vir hierdie bladsy teenwoordig is nie. Gaan asseblief die <a href="{$a}">README</a> na vir verdere instruksies oor hoe om Shibboleth verifikasie op te stel, of kontak die webmeester van hierdie Moodle installasie.';
