<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_musictheory', language 'af', version '4.5'.
 *
 * @package     qtype_musictheory
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abmajor'] = 'A♭ majeur';
$string['abminor'] = 'A♭ mineur';
$string['acc_b'] = '♭';
$string['acc_bb'] = '♭♭';
$string['acc_n'] = '♮';
$string['acc_sharp'] = '♯';
$string['acc_x'] = 'x';
$string['alto'] = 'Alt';
$string['altoclef'] = 'Altsleutel';
$string['anmajor'] = 'A majeur';
$string['anminor'] = 'A mineur';
$string['answerlbl'] = 'Antwoord';
$string['asharpminor'] = 'A♯ mineur';
$string['aug10'] = 'Vergrote 10de';
$string['aug11'] = 'Vergrote 11de';
$string['aug12'] = 'Vergrote 12de';
$string['aug13'] = 'Vergrote 13de';
$string['aug2'] = 'Vergrote 2de';
$string['aug3'] = 'Vergrote 3de';
$string['aug4'] = 'Vergrote 4de';
$string['aug5'] = 'Vergrote 5de';
$string['aug6'] = 'Vergrote 6de';
$string['aug6thfr'] = 'Franse Vergrote 6de';
$string['aug6thgr'] = 'Duitse Vergrote 6de';
$string['aug6thit'] = 'Italiaanse Vergrote 6de';
$string['aug7'] = 'Vergrote 7de';
$string['aug8'] = 'Vergrote oktaaf';
$string['aug9'] = 'Vergrote 9de';
$string['augmented'] = 'Vergrote';
$string['bass'] = 'Bas';
$string['bassclef'] = 'Bassleutel';
$string['bbmajor'] = 'B♭ majeur';
$string['bbminor'] = 'B♭ mineur';
$string['bnmajor'] = 'B majeur';
$string['bnminor'] = 'B mineur';
$string['cbmajor'] = 'C♭ majeur';
$string['chordquality'] = 'Akkoordkwaliteit';
$string['chordquality-random'] = 'Moontlike akkoordkwaliteite';
$string['chordquality_write_questionastext'] = 'Akkoordkwaliteit antwoordinvoer';
$string['chordquality_write_questionastext_help'] = '<p>Voer \'n komma-geskeide lys note in,
  sonder spasies, met die volgende sintaksis:</p><p>[Hoofkas letternaam][Skuifteken
  ("n" = herstellingsteken, "#" = kruis, "b" = mol, "x" = dubbel-kruis, "bb" = dubbel-mol)]4, ... </p>
 <p>Lukrake voorbeeld: <b>antwoord=>Cn4,En4,G#4</b></p>';
$string['chordquality_write_questionasui'] = 'Harmoniese funksie-antwoordinvoer';
$string['chordquality_write_questionasui_help'] = '<p>Voer note in deur op die balk te kliek nadat die tipe skuifteken in die regterkantse hulpstafie gekies is. Om \'n noot uit te wis, kliek weer daarop.</p>';
$string['chordroot'] = 'Akkoordstam';
$string['clef'] = 'Sleutel';
$string['clef-random'] = 'Moontlike sleutels';
$string['cnmajor'] = 'C majeur';
$string['cnminor'] = 'C mineur';
$string['considerregister'] = 'Sluit register in';
$string['considerregister_help'] = 'Dui aan of die noot se register
 as deel van die vraag ingesluit moet word.';
$string['correctansweris'] = 'Die korrekte antwoord is:';
$string['correctansweris_morethanone'] = 'Een moontlike korrekte antwoord is:';
$string['csharpmajor'] = 'C♯ majeur';
$string['csharpminor'] = 'C♯ mineur';
$string['dbmajor'] = 'D♭ majeur';
$string['dim10'] = 'Verminderde 10de';
$string['dim11'] = 'Verminderde 11de';
$string['dim12'] = 'Verminderde 12de';
$string['dim13'] = 'Verminderde 13de';
$string['dim2'] = 'Verminderde 2de';
$string['dim3'] = 'Verminderde 3de';
$string['dim4'] = 'Verminderde 4de';
$string['dim5'] = 'Verminderde 5de';
$string['dim6'] = 'Verminderde 6de';
$string['dim7'] = 'Verminderde 7de';
$string['dim8'] = 'Verminderde oktaaf';
$string['dim9'] = 'Verminderde 9de';
$string['diminished'] = 'Verminder';
$string['dirasc'] = 'Bo die gegewe noot';
$string['dirdesc'] = 'Onder die gegewe noot';
$string['direction'] = 'Rigting';
$string['displaykeysignature'] = 'Vertoon toonsoorttekenhandtekening';
$string['dnmajor'] = 'D majeur';
$string['dnminor'] = 'D mineur';
$string['dsharpminor'] = 'D♯ mineur';
$string['ebmajor'] = 'E♭ majeur';
$string['ebminor'] = 'E♭ mineur';
$string['emptykeysignature'] = 'Leë toonsoorttekenhandtekening';
$string['enmajor'] = 'E majeur';
$string['enminor'] = 'E mineur';
$string['fnmajor'] = 'F majeur';
$string['fnminor'] = 'F mineur';
$string['fsharpmajor'] = 'F♯ majeur';
$string['fsharpminor'] = 'F♯ mineur';
$string['gbmajor'] = 'G♭ majeur';
$string['givennoteelementgroup'] = 'Gegewe noot';
$string['gnmajor'] = 'G majeur';
$string['gnminor'] = 'G mineur';
$string['grandstaff'] = 'Groot balk';
$string['gsharpminor'] = 'G♯ mineur';
$string['harmonicfunction_write_questionastext'] = 'Harmoniese funksie-antwoordinvoer';
$string['harmonicfunction_write_questionastext_help'] = '<p>Voer \'n komma-geskeide lys note in,
  sonder spasies, met die volgende sintaksis:</p><p>[Hoofkas letternaam][Skuifteken
  ("n" = herstelteken, "#" = kruis, "b" = mol, "x" = dubbelkruis, "bb" = dubbelmol)]4, ... </p>
 <p>Lukrake voorbeeld: <b>antwoord=>Cn4,En4,G#4</b></p>';
$string['harmonicfunction_write_questionasui'] = 'Harmoniese funksie-antwoordinvoer';
$string['harmonicfunction_write_questionasui_help'] = '<p>Voer note in deur op die notebalk te kliek, nadat die
 tipe skuifteken in die regterkantse hulpstafie gekies is. Om \'n noot uit te wis, kliek weer daarop.</p>';
$string['harmonicfunctiontype-random'] = 'Moontlike harmoniese funksies';
$string['hfidentifyresponsetypes'] = 'Moontlike harmoniese funksies in antwoord';
$string['hftype_aug6th'] = 'Vergrote 6de';
$string['hftype_diatonictriad'] = 'Diatoniese drieklank';
$string['hftype_dom7th'] = 'Dominante sewende';
$string['hftype_extendeddom'] = 'Verlengde dominant (9, 11 of 13)';
$string['hftype_leadingtone7thfullydim'] = 'Leitoon sewende (ten volle verminder)';
$string['hftype_leadingtone7thhalfdim'] = 'Leitoon sewende (half verminder)';
$string['hftype_neapolitan'] = 'Napolitaans';
$string['hftype_nondom7th'] = 'Niedominante sewende';
$string['hftype_secdom7th'] = 'Sekondêre dominante (sewende)';
$string['hftype_secdomtriad'] = 'Sekondêre dominante (drieklank)';
$string['hftype_secltfullydim'] = 'Sekondêre leitoon 7de (ten volle verminder)';
$string['hftype_seclthalfdim'] = 'Sekondêre leitoon 7de (half verminder)';
$string['hftype_seclttriad'] = 'Sekondêre leitoon (drieklank)';
$string['hftype_secnondom7th'] = 'Sekondêre niedominante (sewende)';
$string['hftype_secnondomtriad'] = 'Sekondêre niedominante (drieklank)';
$string['includealterations'] = 'Sluit veranderings in';
$string['includealterations_help'] = 'Dui aan of skuiftekens as deel
 van die vraag ingesluit moet word.';
$string['includestaticnote'] = 'Sluit gegewe noot in';
$string['interval_write_questionastext'] = 'Interval-antwoordinvoer';
$string['interval_write_questionastext_help'] = '<p>Voer die antwoordnoot in, sonder spasies, met die volgende sintaksis:</p><p>[Hoofkas letternaam] [Skuifteken ("n" = herstelteken, "#" = kruis,
"b" = mol, "x" = dubbelkruis, "bb" = dubbelmol] [Register (\'n getal tussen 1 en 6, volgens
 die wetenskaplike toonhoogtenotasie)]</p><p>Voorbeelde:
 </p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['interval_write_questionasui'] = 'Interval-antwoordinvoer';
$string['interval_write_questionasui_help'] = '<p>Voer die noot in deur op die balk te kliek nadat die tipe skuifteken in die regterkantse hulpstafie gekies is. Om die noot uit te wis, kliek weer daarop.</p>';
$string['javascriptrequired'] = 'Hierdie teks moet deur \'n grafiese gebruiker-
 koppelvlak vervang word, wat vereis dat Javascript in jou blaaier ontsper is.';
$string['keyboard_input_questionasui'] = 'Sleutelbordtoevoer antwoordinvoer';
$string['keyboard_input_questionasui_help'] = '<p>Voer note in deur op die sleutelbord te kliek. Om \'n noot uit te wis, kliek weer daarop.</p>';
$string['keymode'] = 'Toonsoortteken';
$string['keysignature_write_questionastext'] = 'Toonsoorttekenhandtekening-antwoordinvoer';
$string['keysignature_write_questionastext_help'] = '<p>Voer \'n komma-geskiede lys skuiftekens
 (tussen 1 en 7 daarvan) in, sonder spasies, met die volgende sintaksis:</p><p>[Hoofkas letternaam]
 [Skuifteken ("#" = kruis, "b" = mol)] [Register (\'n getal tussen 2 en 5, volgens die wetenskaplike toonhoogtenotasie)], ... </p><p>Voorbeeld: <b>A#4,F#4,G#4</b></p>';
$string['keysignature_write_questionasui'] = 'Toonsoorttekenhandtekening-antwoordinvoer';
$string['keysignature_write_questionasui_help'] = '<p>Voer skuiftekens in deur op die balk te kliek,
 nadat die tipe skuifteken in die regterkantse hulpstafie gekies is. Om \'n skuifteken uit te wis, kliek weer
 daarop.</p>';
$string['lbl_harmonicfunction'] = 'Harmoniese funksie';
$string['maj10'] = 'Groot 10de';
$string['maj13'] = 'Groot 13de';
$string['maj2'] = 'Groot 2de';
$string['maj3'] = 'Groot 3de';
$string['maj6'] = 'Groot 6de';
$string['maj7'] = 'Groot 7de';
$string['maj9'] = 'Groot 9de';
$string['major'] = 'Groot';
$string['min10'] = 'Klein 10de';
$string['min13'] = 'Klein 13de';
$string['min2'] = 'Klein 2de';
$string['min3'] = 'Klein 3de';
$string['min6'] = 'Klein 6de';
$string['min7'] = 'Klein 7de';
$string['min9'] = 'Klein 9de';
$string['minor'] = 'Klein';
$string['mode-random'] = 'Moontlike modusse';
$string['musicqtype'] = 'Musiek-vraagtipe';
$string['musictheory_gradingstrategy'] = 'Merkstrategie';
$string['musictheory_gradingstrategy_help'] = '<p>Die merkstrategie spesifiseer hoe die vraag
 gemerk sal word.</p>
 <p><b>Alles of niks</b>:Die antwoord word met die korrekte antwoord vergelyk. As die antwoord
 korrek is, word volpunte toegeken. As die antwoord verkeerd is, word \'n nulpunt toegeken.</p>';
$string['musictheory_gradingstrategy_scale-write'] = 'Merkstrategie';
$string['musictheory_gradingstrategy_scale-write_help'] = '<p>Die merkstrategie spesifiseer hoe
 die vraag gemerk sal word.</p>
 <p><b>Alles of niks</b>: Die antwoord word met die korrekte antwoord vergelyk. As die antwoord
 korrek is, word volpunte toegeken. As die antwoord verkeerd is, word \'n nulpunt toegeken.</p>
 <p><b>Gedeeltelike punt vir elke korrekte noot</b>:
 \'n Merkstrategie wat die punt gelykop verdeel deur die aantal toonleernote wat die gebruiker moet
 invoer, en gedeeltelike punte vir elke noot toeken.</p>';
$string['musictheory_intervalelementgroup'] = 'Interval';
$string['musictheory_intervalelementgroup_help'] = 'Dui die tipe interval aan.';
$string['musictheory_intervalelementgroup_random'] = 'Moontlike intervalle';
$string['nosectonic'] = '[Geen sekondêre tonika nie]';
$string['note_write_questionastext'] = 'Nootantwoord-invoer';
$string['note_write_questionastext_help'] = '<p>Voer die antwoordnoot in, sonder spasies, met
 die volgende sintaksis:</p><p>[Hoofkas letternaam] [Skuifteken ("n" = herstelteken, "#" = kruis,
 "b" = mol, "x" = dubbelkruis, "bb" = dubbelmol)] [Register (\'n getal tussen 1 en 6, volgens
 die wetenskaplike toonhoogtenotasie)]</p><p>Voorbeelde:
 </p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['note_write_questionasui'] = 'Nootantwoord-invoer';
$string['note_write_questionasui_help'] = '<p>Voer die noot in deur op die balk te kliek, nadat
 die tipe herstelteken in die regterkantse hulpstaaf gekies is. Om die noot uit te wis, kliek weer daarop.</p>';
$string['notea'] = 'A';
$string['noteb'] = 'B';
$string['notec'] = 'C';
$string['noted'] = 'D';
$string['notee'] = 'E';
$string['notef'] = 'F';
$string['noteg'] = 'G';
$string['notelbl'] = 'Noot';
$string['per11'] = 'Rein 11de';
$string['per12'] = 'Rein 12de';
$string['per4'] = 'Rein 4de';
$string['per5'] = 'Rein 5de';
$string['per8'] = 'Rein oktaaf';
$string['perfect'] = 'Rein';
$string['pluginname'] = 'Musiekteorie';
$string['pluginname_help'] = 'Hierdie vraagtipe maak die skep van etlike tipes musiekteorie-oefeninge moontlik deur middel van \'n grafiese gebruikerkoppelvlak.';
$string['pluginname_link'] = 'question/type/musictheory';
$string['pluginnameadding'] = '\'n Musiekteorievraag word bygevoeg';
$string['pluginnameediting'] = '\'n Musiekteorievraag word gewysig';
$string['pluginnamesummary'] = 'Maak die skep van etlike tipes musiekteorie-oefeninge moontlik.';
$string['possiblescalesinresponse'] = 'Moontlike toonleertipes in antwoord';
$string['privacy:metadata'] = 'Die invoegtoepassing van Musiekteorie-vraagtipe berg geen persoonlike data nie.';
$string['qtype_chordquality-identify'] = 'Akkoordgehalte-identifikasie';
$string['qtype_chordquality-identify-random'] = 'Akkoordgehalte-identifikasie (lukraak)';
$string['qtype_chordquality-write'] = 'Skryf van akkoordgehalte';
$string['qtype_chordquality-write-random'] = 'Skryf van akkoordgehalte (lukraak)';
$string['qtype_harmonicfunction-identify'] = 'Harmoniese funksie-identifikasie';
$string['qtype_harmonicfunction-identify-random'] = 'Harmoniese funksie-identifikasie (lukraak)';
$string['qtype_harmonicfunction-write'] = 'Skryf van harmoniese funksie';
$string['qtype_harmonicfunction-write-random'] = 'Skryf van harmoniese funksie (lukraak)';
$string['qtype_interval-identify'] = 'Intervalidentifikasie';
$string['qtype_interval-identify-random'] = 'Intervalidentifikasie (lukraak)';
$string['qtype_interval-write'] = 'Skryf van interval';
$string['qtype_interval-write-random'] = 'Skryf van interval (lukraak)';
$string['qtype_keyboard-input'] = 'Sleutelbordtoevoer';
$string['qtype_keysignature-identify'] = 'Toonsoorttekenhandtekeningidentifikasie';
$string['qtype_keysignature-identify-random'] = 'Toonsoorttekenhandtekeningidentifikasie (lukraak)';
$string['qtype_keysignature-write'] = 'Skryf van toonsoorttekenhandtekening';
$string['qtype_keysignature-write-random'] = 'Skryf van toonsoorttekenhandtekening (lukraak)';
$string['qtype_musictheory_strategy_all_or_nothing'] = 'Alles of niks';
$string['qtype_musictheory_strategy_chordqualitywrite_allornothing'] = 'Alles of niks';
$string['qtype_musictheory_strategy_harmonicfunctionid_allornothing'] = 'Alles of niks';
$string['qtype_musictheory_strategy_harmonicfunctionwrite_allornothing'] = 'Alles of niks';
$string['qtype_musictheory_strategy_keyboard_allornothing'] = 'Alles of niks';
$string['qtype_musictheory_strategy_note_allornothing'] = 'Alles of niks';
$string['qtype_musictheory_strategy_scale_creditbynote'] = 'Gedeeltelike punt vir elke korrekte noot';
$string['qtype_note-identify'] = 'Nootidentifikasie';
$string['qtype_note-identify-random'] = 'Nootidentifikasie (lukraak)';
$string['qtype_note-write'] = 'Skryf van noot';
$string['qtype_note-write-random'] = 'Skryf van noot (lukraak)';
$string['qtype_scale-identify'] = 'Toonleeridentifikasie';
$string['qtype_scale-identify-random'] = 'Toonleeridentifikasie (lukraak)';
$string['qtype_scale-write'] = 'Skryf van toonleer';
$string['qtype_scale-write-random'] = 'Skryf van toonleer (lukraak)';
$string['quality-random'] = 'Moontlike kwaliteite';
$string['qualityaug'] = 'Vergroot';
$string['qualitydim'] = 'Verminder';
$string['qualitymaj'] = 'Groot';
$string['qualitymin'] = 'Klein';
$string['qualityper'] = 'Rein';
$string['questionoptions'] = 'Vraagopsies';
$string['questiontext'] = 'Vraagteks';
$string['questiontext_chordquality_identify'] = 'Identifiseer die grondtoon en kwaliteit van die volgende akkoord';
$string['questiontext_chordquality_write'] = 'Voer die volgende akkoord in';
$string['questiontext_harmonicfunction_identify'] = 'Identifiseer die volgende harmoniese funksie';
$string['questiontext_harmonicfunction_write'] = 'Voer die volgende harmoniese funksie in';
$string['questiontext_help'] = 'Hierdie veld word nie vereis nie. Indien dit leeg gelaat word, sal \'n vraagteks
 wat toepaslik is op die gegewe musiekvraagtipe outomaties
binne
 aktiwiteite vertoon word. As jy wel teks in hierdie veld invoer, sal dit die outomaties gegenereerde vraagteks vervang.';
$string['questiontext_interval_identify'] = 'Identifiseer die volgende interval';
$string['questiontext_interval_write_above'] = 'Voer die volgende interval <b>bo</b> die gegewe noot in';
$string['questiontext_interval_write_below'] = 'Voer die volgende interval <b>onder</b> die gegewe noot in';
$string['questiontext_keyboard_input'] = 'Voer die volgende noot op die sleutelbord in';
$string['questiontext_keysignature_identify_major'] = 'Bepaal die majeursleutel wat deur die volgende toonsoortteken voorgestel word';
$string['questiontext_keysignature_identify_minor'] = 'Bepaal die mineursleutel wat deur die volgende toonsoortteken voorgestel word';
$string['questiontext_keysignature_write'] = 'Voer die volgende toonsoortteken in';
$string['questiontext_note_identify'] = 'Identifiseer die volgende noot';
$string['questiontext_note_write'] = 'Voer die volgende noot in';
$string['questiontext_scale_identify'] = 'Identifiseer die volgende toonleer';
$string['questiontext_scale_write'] = 'Skryf die volgende toonleer in \'n stygende rigting';
$string['questiontext_scale_write_melodic'] = 'Skryf die volgende toonleer in beide stygende en dalende rigtings';
$string['rootposition'] = '[grondtoon]';
$string['scale_write_questionastext'] = 'Toonleerantwoordinvoer';
$string['scale_write_questionastext_help'] = '<p>Voer \'n komma-geskeide lys note in, insluitende die spesifieke tonus, sonder spasies, met die volgende sintaksis:</p><p>[Hoofkas letternaam]
 [Skuifteken ("n" = herstelteken, "#" = kruis, "b" = mol, "x" = dubbelkruis, "bb" = dubbelmol)]
 [Register (\'n getal tussen 2 en 6, volgens die wetenskaplike toonhoogtenotasie)], ... </p>
 <p>Lukrake voorbeeld: <b>Tonika = An4 antwoord=>An4,Bb4,C#5,D#5,E#5,F#5,G#5,An5</b></p>';
$string['scale_write_questionasui'] = 'Toonleerantwoord-invoer';
$string['scale_write_questionasui_help'] = '<p>Voer note in deur op die balk te kliek nadat die tipe skuifteken in die regterkantse hulpstafie gekies is. Om \'n noot uit te wis, kliek weer daarop.</p>
 <p>Let daarop dat skuiftekens oordra na daaropvolgende note.</p>';
$string['scaletype'] = 'Toonleertipe';
$string['scaletype-random'] = 'Moontlike toonleertipes';
$string['scaletype_harmonic'] = 'Harmoniese mineur';
$string['scaletype_major'] = 'Majeur';
$string['scaletype_melodic'] = 'Melodiese mineur';
$string['scaletype_natural'] = 'Natuurlike mineur';
$string['selectakey'] = 'Kies \'n sleutel';
$string['selectanoption'] = 'Kies';
$string['selectaquality'] = 'Kies \'n kwaliteit';
$string['selectasize'] = 'Kies \'n grootte';
$string['size-random'] = 'Moontlike groottes';
$string['size10'] = '10de';
$string['size11'] = '11de';
$string['size12'] = '12de';
$string['size13'] = '13de';
$string['size2'] = '2de';
$string['size3'] = '3de';
$string['size4'] = '4de';
$string['size5'] = '5de';
$string['size6'] = '6de';
$string['size7'] = '7de';
$string['size8'] = '8de';
$string['size9'] = '9de';
$string['tenor'] = 'Tenoor';
$string['tenorclef'] = 'Tenoorsleutel';
$string['tonic'] = 'Tonika';
$string['treble'] = 'Diskant';
$string['trebleclef'] = 'G-sleutel';
$string['updatemusicqtype'] = 'Werk opsies by';
$string['validation_harmonicfunctionnotsupported'] = 'Hierdie harmoniese funksie word nie ondersteun nie of is ongeldig.';
$string['validation_harmonicfunctiontypenotselected'] = 'Die funksietipe vir die spesifieke harmoniese funksie moet gekies word.';
$string['validation_interval_novalidcombo'] = 'Die gekose moontlike kwaliteite en groottes
 produseer nie minstens een geldige interval nie.';
$string['validation_intervaloutsidestaff'] = 'Die gegewe noot se register produseer \'n interval wat
 nie in die balk van die gegewe sleutel pas nie.';
$string['validation_invalidchordquality'] = 'Hierdie tipe akkoord kan nie op die gespesifiseerde grondtoon gebou word nie.';
$string['validation_invalidinterval_above'] = 'Hierdie interval kan nie bo die gegewe noot geskryf word nie.';
$string['validation_invalidinterval_below'] = 'Hierdie interval kan nie onder die gegewe noot geskryf word nie.';
$string['validation_noteoutsidekeyboard'] = 'Hierdie noot is buite die omvang van die klaviersleutelbord.';
$string['validation_noteoutsidestaff'] = 'Hierdie noot se register pas nie binne die balk
 in die gespesifiseerde sleutel nie.';
$string['validation_possiblescaletypenotselected'] = 'Die toonleertipe vir die gespesifiseerde toonleertipe moet gekies word.';
$string['validation_possiblescaletypesnotselected_random'] = 'Die moontlike toonleertipes in die antwoord
 moet alle moontlike toonleertipes in die vraag insluit.';
$string['validation_qualitymismatch'] = 'Hierdie kombinasie intervalgrootte en -kwaliteit is ongeldig.';
$string['validation_samestaticandgivennote'] = 'Die gegewe noot en die antwoord kan nie op dieselfde sleutel op die sleutelbord ooreenstem nie.';
$string['validation_scale_invalidtonic'] = 'Ongeldige tonika vir die gespesifiseerde toonleertipe.';
$string['validation_scaleoutsidestaff'] = 'Die gegewe tonika se register produseer \'n toonleer wat
 nie binne die balk van die gegewe sleutel pas nie.';
$string['validationerror_chordquality_identify'] = 'Onvolledige antwoord. Die letter, skuifteken en akkoordkwaliteit moet gekies word.';
$string['validationerror_empty'] = 'Geen antwoord is verskaf nie.';
$string['validationerror_harmonicfunction_identify'] = 'Onvolledige antwoord. Alle aftrekkieslyste moet gekies word.';
$string['validationerror_incompletechordquality'] = 'Onvolledige antwoord. Aantal note in hierdie akkoord';
$string['validationerror_incompleteharmonicfunction'] = 'Onvolledige antwoord. Aantal note in hierdie harmoniese funksie';
$string['validationerror_interval_identify'] = 'Onvolledige antwoord. Beide die kwaliteit en die grootte
 moet gekies word.';
$string['validationerror_invalidsyntax'] = 'Ongeldige antwoordsintaksis';
$string['validationerror_note_identify'] = 'Onvolledige antwoord. Die letternaam, skuifteken
 en register moet gekies word.';
$string['validationerror_note_identify_ltr_acc'] = 'Onvolledige antwoord. Beide die letternaam en skuifteken
 moet gekies word.';
$string['validationerror_note_identify_ltr_reg'] = 'Onvolledige antwoord. Beide die letternaam en register
 moet gekies word.';
$string['validationerror_notewrite_twonotesingrandstaff'] = 'Twee note is ingevoer. Voer asseblief slegs een noot in.';
$string['validationerror_scale_identify'] = 'Onvolledige antwoord. Alle aftrekkieslyste moet gekies word.';
$string['validationerror_scale_incomplete'] = 'Onvolledige antwoord. \'n Totaal van 8 note word vereis,
 insluitende die gegewe tonika.';
$string['validationerror_scale_incomplete_melodic'] = 'Onvolledige antwoord. \'n Totaal van 15 note word
 vereis, insluitende die gegewe tonika.';
$string['validationerror_whitespace'] = 'Ongeldige antwoordsintaksis: verwyder alle spasies uit jou antwoord.';
