<?php

/**
 * Thai language file
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at https://mozilla.org/MPL/2.0/.
 *
 * @package phpMyFAQ
 * @author Thanadon Somdee <jimmy@thaizone.com>
 * @copyright 2007-2024 phpMyFAQ Team
 * @license https://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link https://www.phpmyfaq.de
 * @since 2007-08-19
 * @codingStandardsIgnoreFile
 */

$PMF_LANG['metaCharset'] = 'UTF-8';
$PMF_LANG['metaLanguage'] = 'th';
$PMF_LANG['language'] = 'thai';
$PMF_LANG['direction']= 'ltr';
$PMF_LANG['nplurals'] = '1';
$PMF_LANG['msgCategory'] = 'หัวข้อ';
$PMF_LANG['msgShowAllCategories'] = 'แสดงหัวข้อทั้งหมด';
$PMF_LANG['msgSearch'] = 'ค้นหา';
$PMF_LANG['msgAddContent'] = 'เพิ่ม ข้อมูล';
$PMF_LANG['msgQuestion'] = 'ตั้งคำถาม';
$PMF_LANG['msgOpenQuestions'] = 'ดูคำถาม';
$PMF_LANG['msgHelp'] = 'คู่มือใช้งาน';
$PMF_LANG['msgContact'] = 'ติดต่อ';
$PMF_LANG['msgHome'] = 'หน้าหลัก';
$PMF_LANG['msgNews'] = 'ประกาศข่าว';
$PMF_LANG['msgUserOnline'] = 'คนที่กำลังอ่าน';
$PMF_LANG['msgXMLExport'] = 'ไฟล์ XML';
$PMF_LANG['msgBack2Home'] = 'กลับไปที่หน้าหลัก';
$PMF_LANG['msgFullCategories'] = 'หัวข้อที่มีข้อมูล';
$PMF_LANG['msgFullCategoriesIn'] = 'หัวข้อที่มีข้อมูลใน ';
$PMF_LANG['msgSubCategories'] = 'หัวข้อย่อย';
$PMF_LANG['msgEntries'] = 'ข้อมูล';
$PMF_LANG['msgEntriesIn'] = 'คำถามใน ';
$PMF_LANG['msgViews'] = 'ครั้ง';
$PMF_LANG['msgPage'] = 'หน้า ';
$PMF_LANG['msgPages'] = ' หน้า';
$PMF_LANG['msgPrevious'] = 'ย้อนกลับ';
$PMF_LANG['msgNext'] = 'ถัดไป';
$PMF_LANG['msgCategoryUp'] = 'หัวข้อหลัก';
$PMF_LANG['msgLastUpdateArticle'] = 'แก้ไขล่าสุด: ';
$PMF_LANG['msgAuthor'] = 'ผู้เขียน: ';
$PMF_LANG['msgPrinterFriendly'] = 'หน้าสำหรับพิพม์ออกทางเครื่องพิพม์';
$PMF_LANG['msgPrintArticle'] = 'พิพม์ข้อมูลนี้';
$PMF_LANG['msgMakeXMLExport'] = 'ส่งออกเป็นไฟล์ XML';
$PMF_LANG['msgAverageVote'] = 'คะแนนนิยมโดยเฉลี่ย:';
$PMF_LANG['msgVoteUsability'] = 'ให้คะแนนบทความนี้:';
$PMF_LANG['msgVoteFrom'] = 'จาก';
$PMF_LANG['msgVoteBad'] = 'ไม่น่าสนใจ';
$PMF_LANG['msgVoteGood'] = 'น่าสนใจที่สุด';
$PMF_LANG['msgVotings'] = 'ให้คะแนนน ';
$PMF_LANG['msgVoteSubmit'] = 'ให้คะแนน';
$PMF_LANG['msgVoteThanks'] = 'ขอบคุณสำหรับคะแนน!';
$PMF_LANG['msgYouCan'] = 'คุณสามารถ ';
$PMF_LANG['msgWriteComment'] = 'ให้ความเห็นบทความนี้ได้';
$PMF_LANG['msgShowCategory'] = 'เน้อหาสรุป: ';
$PMF_LANG['msgCommentBy'] = 'ความเห็น ';
$PMF_LANG['msgCommentHeader'] = 'ส่งความคิดเห็นสำหรับบทความนี้';
$PMF_LANG['msgYourComment'] = 'ความคิดเห็นของคุณ:';
$PMF_LANG['msgCommentThanks'] = 'ขอบคุณสำหรับความเห็นของคุณ';
$PMF_LANG['msgSeeXMLFile'] = 'เปิดไฟล์ XML';
$PMF_LANG['msgSend2Friend'] = 'ส่งต่อให้เพื่อน';
$PMF_LANG['msgS2FButton'] = 'ส่งอีเมล์';
$PMF_LANG['msgSearchWord'] = 'คำค้นหา';
$PMF_LANG['msgSearchFind'] = 'ผลการค้นหา ';
$PMF_LANG['msgSearchAmount'] = ' หัวข้อ จากการค้นหา';
$PMF_LANG['msgSearchAmounts'] = ' หัวข้อ จากการค้นหา';
$PMF_LANG['msgSearchCategory'] = 'หัวข้อ: ';
$PMF_LANG['msgSearchContent'] = 'เนื้อหา: ';
$PMF_LANG['msgNewContentHeader'] = 'เสนอข้อมูลใหม่ใน FAQ';
$PMF_LANG['msgNewContentAddon'] = "ข้อเสนอแนะของคุณจะไม่ปรากฏทันที แต่จะถูกตรวจสอบโดยเราก่อนเผยแพร่ ช่องที่ต้องกรอกคือช่องที่มีเครื่องหมาย *";
$PMF_LANG['msgNewContentName'] = 'ชื่อ:';
$PMF_LANG['msgNewContentMail'] = 'อีเมล์:';
$PMF_LANG['msgNewContentCategory'] = 'เลือกหัวข้อที่ต้องการ';
$PMF_LANG['msgNewContentTheme'] = 'หัวข้อหลัก:';
$PMF_LANG['msgNewContentArticle'] = 'ข้อมูลของคุณสำหรับFAQ';
$PMF_LANG['msgNewContentKeywords'] = 'คำค้น:';
$PMF_LANG['msgNewContentLink'] = 'ที่อยู่สำหรับข้อมูนี้';
$PMF_LANG['msgNewContentSubmit'] = 'ส่ง';
$PMF_LANG['msgInfo'] = 'ข้อมูลเพิ่มเติม: ';
$PMF_LANG['msgNewContentThanks'] = 'ขอบคุณสำหรับการแนะนำ';
$PMF_LANG['msgNoQuestionsAvailable'] = 'ไม่พบรายการคำถามที่ค้างไว้';
$PMF_LANG['msgNewQuestion'] = 'ตั้งคำถามของคุณด้านล่าง:';
$PMF_LANG['msgAskCategory'] = 'คำถามเกี่ยวกับหัวข้อ';
$PMF_LANG['msgAskYourQuestion'] = 'คำถามของคุณ:';
$PMF_LANG['msgAskThx4Mail'] = '<h2>ขอบคุณสำหรับคำถาม!</h2>';
$PMF_LANG['msgDate_User'] = 'วัน / คน';
$PMF_LANG['msgQuestion2'] = 'คำถาม';
$PMF_LANG['msg2answer'] = 'คำตอบ';
$PMF_LANG['msgQuestionText'] = 'คุณสามารถดูรายการคำถามที่ตั้งโดยผู้ใช้คนอื่น หากคุณตอบคำถามเหล่านั้นไว้ คำตอบของคุณจะได้รับการเพิ่มใน FAQ';
$PMF_LANG['msgHelpText'] = 'โครงสร้างของ FAQ (<strong>F</strong>requently <strong>A</strong>sked <strong>Q</strong>uestions) ไม่ซับซ้อนมาก คุณสามารถดูรายการ <strong><a href="?action=show">หัวข้อ</a></strong> หรือค้นหาใน <strong><a href="?action=search">เครื่องมือค้นหาของ FAQ</a></strong> ด้วยคำค้นที่คุณต้องการ';
$PMF_LANG['msgContactEMail'] = 'อีเมล์ถึงเว็บมาสเตอร์:';
$PMF_LANG['msgMessage'] = 'ข้อความ:';
$PMF_LANG['msgTopTen'] = '10 คำถามยอดนิยม';
$PMF_LANG['msgHomeThereAre'] = 'มีข้อมูลทั้งหมด ';
$PMF_LANG['msgHomeArticlesOnline'] = ' ข้อมูลในระบบ';
$PMF_LANG['msgNoNews'] = 'ไม่พบประกาศใหม่.';
$PMF_LANG['msgLatestArticles'] = '5 คำถามล่าสุด';
$PMF_LANG['msgMailThanks'] = 'ขอบคุณสำหรับการเสนอข้อมูลในรายการ FAQ';
$PMF_LANG['msgMailCheck'] = 'มีรายการใหม่ใน FAQ! โปรดตรวจสอบในส่วนของผู้ดูแลระบบ';
$PMF_LANG['msgMailContact'] = 'ข้อมูลของคุณได้จัดส่งให้กับผู้ดูและระบบแล้ว';
$PMF_LANG['err_noDatabase'] = 'ไม่สามารถติดต่อฐานข้อมูลได้.';
$PMF_LANG['err_noHeaders'] = 'ไม่พบหัวข้อ.';
$PMF_LANG['msgErrorNoRecords'] = 'ไม่พบข้อมูล.';
$PMF_LANG['err_badID'] = 'ID ไม่ถูกต้อง';
$PMF_LANG['err_noTopTen'] = 'ไม่พบ 10 คำถามยอดนิยม.';
$PMF_LANG['err_nothingFound'] = 'ไม่พบข้อมูล.';
$PMF_LANG['err_SaveEntries'] = 'ข้อมูลที่จำเป็น <strong>ชื่อ</strong>, <strong>อีเมล์</strong>, <strong>หัวข้อ</strong>, <strong>ชื่อเรื่อง</strong>, <strong>ข้อมูลของคุณ</strong> และ รหัสตัวอักษร<strong><a href="https://en.wikipedia.org/wiki/Captcha" title="รายละเอียดเกี่ยวกับ Captcha ใน Wikipedia" target="_blank">Captcha</a></strong>!<br><br><a href="nojavascript...history.back();">ย้อนกลับ</a><br><br>';
$PMF_LANG['err_SaveComment'] = 'ข้อมูลที่จำเป็น <strong>ชื่อ</strong>, <strong>อีเมล์</strong>, <strong>ความเห็น</strong> และ รหัสตัวอักษร <strong><a href="https://en.wikipedia.org/wiki/Captcha" title="รายละเอียดเกี่ยวกับ Captcha ใน Wikipedia" target="_blank">Captcha</a></strong>!<br><br><a href="nojavascript...history.back();">ย้อนกลับ</a><br><br>';
$PMF_LANG['err_VoteTooMuch'] = 'คุณไม่สามารถให้คะแนนได้ซ้ำได้';
$PMF_LANG['err_noVote'] = '<strong>คุณไม่สามารถให้คะแนนได้</strong> <a href="nojavascript...history.back();">คลิ๊กที่นี้</a>, เพื่อให้คะแนน.';
$PMF_LANG['err_noMailAdress'] = 'อีเมล์ของคุณไม่ถูกต้อง<br><a href="nojavascript...history.back();">กลับ</a>';
$PMF_LANG['err_sendMail'] = 'ข้อมูลที่จำเป็น <strong>ชื่อ</strong>, <strong>อีเมล์</strong>, <strong>คำถาม</strong> และ รหัสตัวอักษร <strong><a href="https://en.wikipedia.org/wiki/Captcha" title="รายละเอียดเกี่ยวกับ Captcha ใน Wikipedia" target="_blank">Captcha</a></strong>!';
$PMF_LANG['help_search'] = '<strong>ค้นหาข้อมูล:</strong><br>ที่ตรงกับ <strong style="color: Red;">คำที่1 คำที่2</strong> คุณสามารถหาข้อมูลที่ตรงความต้องการได้มากที่สุด หากระบุคำที่ต้องการมากว่า 2 คำขึ้นไป<strong>คำแนะนำ:</strong> คุณจะต้องระบุคำที่มีความยาวมากกว่า 4 ตัวอักษรเท่านั้น';
$PMF_LANG['ad'] = 'ส่วนข้องผู้ดูแลระบบ';
$PMF_LANG['ad_menu_user_administration'] = 'ผู้ใช้งาน';
$PMF_LANG['ad_menu_entry_aprove'] = 'อนุมัติรายการ FAQ';
$PMF_LANG['ad_menu_entry_edit'] = 'แก้ไข FAQs';
$PMF_LANG['ad_menu_categ_add'] = 'เพิ่ม หัวข้อ';
$PMF_LANG['msgHeaderCategoryOverview'] = 'หัวข้อ';
$PMF_LANG['ad_menu_news_add'] = 'เพิ่มข่าวประกาศ';
$PMF_LANG['ad_menu_news_edit'] = 'แก้ไขข่าวประกาศ';
$PMF_LANG['ad_menu_open'] = 'ดูคำถาม';
$PMF_LANG['ad_menu_stat'] = 'สถิติการให้คะแนน';
$PMF_LANG['ad_menu_cookie'] = 'ตั้งค่า คุกกี้';
$PMF_LANG['ad_menu_session'] = 'ดูรายการเชื่อต่อระบบ';
$PMF_LANG['ad_menu_adminlog'] = 'ดูบันทึกของผู้ดูแล';
$PMF_LANG['ad_menu_passwd'] = 'เปลี่ยนรหัสผ่าน';
$PMF_LANG['ad_menu_logout'] = 'ออกจากระบบ';
$PMF_LANG['ad_menu_startpage'] = 'หน้าหลัก';
$PMF_LANG['ad_msg_identify'] = 'โปรดยืนยันตัวคุณ';
$PMF_LANG['ad_msg_passmatch'] = 'รหัสผ่านทั้งสอง<strong>ต้องตรงกัน</strong>!';
$PMF_LANG['ad_msg_savedsuc_1'] = 'ข้อมูลของ';
$PMF_LANG['ad_msg_savedsuc_2'] = 'บันทึกไว้เรียบร้อยแล้ว';
$PMF_LANG['ad_msg_mysqlerr'] = 'เนื่องจาก <strong>ระบบฐานข้อมูลมีปัญหา</strong>, ข้อมูลส่วนตัวไม่สามารถบันทึกได้';
$PMF_LANG['ad_msg_noauth'] = 'คุณไม่ได้รับอนุญาตให้ใช้งาน';
$PMF_LANG['ad_gen_page'] = 'หน้า';
$PMF_LANG['ad_gen_of'] = 'จาก';
$PMF_LANG['ad_gen_lastpage'] = 'หน้าก่อน';
$PMF_LANG['ad_gen_nextpage'] = 'หน้าถัดไป';
$PMF_LANG['ad_gen_save'] = 'บันทึก';
$PMF_LANG['ad_gen_reset'] = 'ยกเลิก';
$PMF_LANG['ad_gen_yes'] = 'ใช่';
$PMF_LANG['ad_gen_no'] = 'ไม่ใช่';
$PMF_LANG['ad_gen_top'] = 'ส่วนบนของหน้า';
$PMF_LANG['ad_gen_ncf'] = 'ไม่พบหัวข้อที่ต้องการ!';
$PMF_LANG['ad_gen_delete'] = 'ลบ';
$PMF_LANG['ad_user'] = 'ระบบจัดการ ผู้ใช้งาน';
$PMF_LANG['ad_user_username'] = 'ผู้ใช้ที่ลงทะเบียนแล้ว';
$PMF_LANG['ad_user_rights'] = 'สิทธิผู้ใช้งาน';
$PMF_LANG['ad_user_edit'] = 'แก้ไข';
$PMF_LANG['ad_user_delete'] = 'ลบ';
$PMF_LANG['ad_user_add'] = 'เพิ่มผู้ใช้งาน';
$PMF_LANG['ad_user_profou'] = 'สถานะผู้ใช้งาน';
$PMF_LANG['ad_user_name'] = 'ชื่อ';
$PMF_LANG['ad_user_password'] = 'รหัสผ่าน';
$PMF_LANG['ad_user_confirm'] = 'ยืนยันรหัสผ่าน';
$PMF_LANG['ad_user_del_1'] = 'ผู้ใช่งาน';
$PMF_LANG['ad_user_del_2'] = 'จะถูกลบทิ้ง?';
$PMF_LANG['ad_user_del_3'] = 'คุณแน่ใจหรือไม่?';
$PMF_LANG['ad_user_deleted'] = 'ผู้ใช้ถูกลบเรียบร้อยแล้ว';
$PMF_LANG['ad_user_checkall'] = 'เลือกทั้งหมด';
$PMF_LANG['msgHeaderFAQOverview'] = 'จัดการข้อมูล';
$PMF_LANG['ad_entry_id'] = 'เลขที่';
$PMF_LANG['ad_entry_topic'] = 'หัวเรื่อง';
$PMF_LANG['ad_entry_action'] = 'ดำเนินการ';
$PMF_LANG['ad_entry_edit_1'] = 'แก้ไขข้อมูล';
$PMF_LANG['ad_entry_edit_2'] = '';
$PMF_LANG['ad_entry_theme'] = 'คำถาม:';
$PMF_LANG['ad_entry_content'] = 'คำตอบ:';
$PMF_LANG['ad_entry_keywords'] = 'คำค้น:';
$PMF_LANG['ad_entry_author'] = 'ผู้เขียน:';
$PMF_LANG['ad_entry_category'] = 'หัวข้อ:';
$PMF_LANG['ad_entry_active'] = 'เปิดใช้';
$PMF_LANG['ad_entry_date'] = 'วันที่';
$PMF_LANG['ad_entry_status'] = 'Status der FAQ';
$PMF_LANG['ad_entry_changed'] = 'แก้ไข';
$PMF_LANG['ad_entry_changelog'] = 'สถานะการแก้ไข';
$PMF_LANG['ad_entry_commentby'] = 'ความเห็น จาก';
$PMF_LANG['ad_entry_comment'] = 'ความเห็น:';
$PMF_LANG['ad_entry_save'] = 'บันทึก';
$PMF_LANG['msgDelete'] = 'ลบ';
$PMF_LANG['ad_entry_delcom_1'] = 'คุณแน่ใจหรือไม่เกี่ยกับการความเห็นของผู้ใช้';
$PMF_LANG['ad_entry_delcom_2'] = 'ถูกลบ?';
$PMF_LANG['ad_entry_commentdelsuc'] = 'ความเห็นได้ <strong>ถูกลบ</strong> เรียบร้อยแล้ว';
$PMF_LANG['ad_entry_back'] = 'กลับไปหน้าก่อนนี้';
$PMF_LANG['ad_entry_commentdelfail'] = 'ความเห็น<strong>ไม่สามารถ</strong> ลบได้';
$PMF_LANG['ad_entry_savedsuc'] = 'การแก้ไขได้รับการบันทึก<strong>เรียร้อยแล้ว</strong>.';
$PMF_LANG['ad_entry_savedfail'] = 'พบข้อผิดพลาดเกี่ยวกับ<strong>ฐานข้อมูล</strong>';
$PMF_LANG['ad_entry_del_1'] = 'คุณแน่ใจหรือไม่เกี่ยวกับหัวเรื่อง';
$PMF_LANG['ad_entry_del_2'] = 'เกี่ยวกับ';
$PMF_LANG['ad_entry_del_3'] = 'จะถูกลบ?';
$PMF_LANG['ad_entry_delsuc'] = 'ข้อมูลถูกลบ <strong>เรียบร้อย</strong>';
$PMF_LANG['ad_entry_delfail'] = 'ข้อมูลไ<strong>ไม่สามารถลบได้/strong>!';
$PMF_LANG['ad_news_header'] = 'หัวข้อประกาศข่าว:';
$PMF_LANG['ad_news_text'] = 'ข้อมูล:';
$PMF_LANG['ad_news_link_url'] = 'ลิงค์ (<strong>ไม่ต้องใส่ https://</strong>):';
$PMF_LANG['ad_news_link_title'] = 'ชื่อเรื่องของลิงค์ :';
$PMF_LANG['ad_news_link_target'] = 'หน้าหลักสำหรับลิงค์:';
$PMF_LANG['ad_news_link_window'] = 'เปิดในหน้าใหม่';
$PMF_LANG['ad_news_link_faq'] = 'เปิดหน้าในFAQ';
$PMF_LANG['ad_news_add'] = 'เพิ่มประกาศข่าว';
$PMF_LANG['ad_news_id'] = '#';
$PMF_LANG['ad_news_headline'] = 'หัวเรื่อง';
$PMF_LANG['ad_news_date'] = 'วันที่';
$PMF_LANG['ad_news_action'] = 'ดำเนินการ';
$PMF_LANG['ad_news_update'] = 'แก้ไข';
$PMF_LANG['ad_news_delete'] = 'ลบ';
$PMF_LANG['ad_news_nodata'] = 'ไม่พบข้อมูลในฐานข้อมูล';
$PMF_LANG['ad_news_updatesuc'] = 'แก้ไขประกาศข่าวแล้ว';
$PMF_LANG['ad_news_del'] = 'โปรดยืนยันการลบประกาศข่าว?';
$PMF_LANG['ad_news_yesdelete'] = 'ใช่, ต้องการลบ!';
$PMF_LANG['ad_news_nodelete'] = 'ไม่ต้องการลบ!';
$PMF_LANG['ad_news_delsuc'] = 'ประกาศข่าวถูกลบแล้ว';
$PMF_LANG['ad_news_updatenews'] = 'ประกาศข่าวได้รับการแก้ไขแล้ว';
$PMF_LANG['ad_categ_new'] = 'เพิ่มหัวข้อใหม่';
$PMF_LANG['ad_categ_catnum'] = 'หมายเลขของหัวข้อ:';
$PMF_LANG['ad_categ_subcatnum'] = 'หมายเลขของหัวข้อย่อย:';
$PMF_LANG['ad_categ_nya'] = '<em>ยังไม่เปิดใช้งาน</em>';
$PMF_LANG['ad_categ_titel'] = 'ชื่อหัวข้อ';
$PMF_LANG['ad_categ_add'] = 'เพิ่มหัวข้อ';
$PMF_LANG['ad_categ_existing'] = 'หัวข้อมีอยู่แล้ว';
$PMF_LANG['ad_categ_id'] = '#';
$PMF_LANG['ad_categ_categ'] = 'หัวข้อ';
$PMF_LANG['ad_categ_subcateg'] = 'หัวข้อย่อย';
$PMF_LANG['ad_categ_action'] = 'ดำเนินการ';
$PMF_LANG['ad_categ_update'] = 'แก้ไข';
$PMF_LANG['ad_categ_delete'] = 'ลบ';
$PMF_LANG['ad_categ_updatecateg'] = 'แก้ไขหัวข้อ';
$PMF_LANG['ad_categ_nodata'] = 'ไม่พบรายการในฐานข้อมูล';
$PMF_LANG['msgCategoryRemark'] = 'หากคุณลบหัวข้อไปแล้วจะทำให้รายการในหัวข้อนั้นไม่สามารถเปิดดูได้ คุณจะต้องกำหนดหัวข้อใหม่สำหรับข้อมูล หรือลบข้อมูลด้านในทิ้ง';
$PMF_LANG['ad_categ_edit_1'] = 'แก้ไข';
$PMF_LANG['ad_categ_edit_2'] = 'หัวข้อ';
$PMF_LANG['ad_categ_added'] = 'หัวข้อได้ถูกเพิ่มแล้ว.';
$PMF_LANG['ad_categ_updated'] = 'หัวข้อได้ถูกแก้ไขแล้ว.';
$PMF_LANG['ad_categ_del_yes'] = 'ยืนยันการลบ!';
$PMF_LANG['ad_categ_del_no'] = 'ไม่ต้องการลบ!';
$PMF_LANG['ad_categ_deletesure'] = 'โปรดยืนยันเพื่อลบหัวข้อนี้';
$PMF_LANG['ad_categ_deleted'] = 'หัวข้อถูกลบ.';
$PMF_LANG['ad_cookie_cookiesuc'] = 'คุกกี้ได้ถูกกำหนดค่า <strong>เรียบร้อยแล้ว</strong>';
$PMF_LANG['ad_cookie_already'] = 'คุกกี้ได้ถูกกำหนดค่าไว้แล้ว คุณสามารถทำรายการตามตัวเลือกดังนี้:';
$PMF_LANG['ad_cookie_again'] = 'กำหนดค่าสำหรับคุกกี้อีกครั้ง';
$PMF_LANG['ad_cookie_delete'] = 'ลบคุกกี้';
$PMF_LANG['ad_cookie_no'] = 'ไม่พบรายการคุกกี้ที่บันทึกไว้ เนื่องจากคุกกี้จำเป็นสำหรับการล๊อคอินเข้าสู่ระบบ คุณสามารถดำเนินการตามตัวเลือก ดังนี้:';
$PMF_LANG['ad_cookie_set'] = 'กำหนดค่าคุกกี้';
$PMF_LANG['ad_cookie_deleted'] = 'คุกกี้ได้ถูกลบเรียบร้อยแล้ว';
$PMF_LANG['ad_adminlog'] = 'บันทึกระบบของผู้ดูแล';
$PMF_LANG['ad_passwd_cop'] = 'เปลี่ยนรหัสผ่านของคุณ';
$PMF_LANG['ad_passwd_old'] = 'รหัสผ่านเดิม:';
$PMF_LANG['ad_passwd_new'] = 'รหัสผ่านใหม่:';
$PMF_LANG['ad_passwd_con'] = 'ยืนยันรหัสผ่านใหม่:';
$PMF_LANG['ad_passwd_change'] = 'เปลี่ยนรหัสผ่าน';
$PMF_LANG['ad_passwd_suc'] = 'รหัสผ่านถูกเปลี่ยนเรียบร้อยแล้ว.';
$PMF_LANG['ad_passwd_remark'] = '<strong>คำเตือน:</strong><br>คุกกี้ไม่สามารถแก้ไขได้!';
$PMF_LANG['ad_passwd_fail'] = 'รหัสผ่านเดิม <strong>จะต้อง</strong> ตรงกันและ รหัสผ่านใหม่กับรหัสยืนยัน <strong>ต้องเหมือนกัน</strong>.';
$PMF_LANG['ad_adus_adduser'] = 'เพิ่มผู้ใช้';
$PMF_LANG['ad_adus_name'] = 'ชื่อ:';
$PMF_LANG['ad_adus_password'] = 'รหัสผ่าน:';
$PMF_LANG['ad_adus_add'] = 'เพิ่มผู้ใช้';
$PMF_LANG['ad_adus_suc'] = 'ผู้ใช้ได้เพิ่มในระบบ <strong>เรียบร้อยแล้ว</strong>.';
$PMF_LANG['ad_adus_edit'] = 'แก้ไขข้อมูลผู้ใช้';
$PMF_LANG['ad_adus_dberr'] = '<strong>พบปัญหากับฐานข้อมูล!</strong>';
$PMF_LANG['ad_adus_exerr'] = 'ชื่อผู้ใช้ <strong>มีอยู่ในระบบ</strong> แล้ว';
$PMF_LANG['ad_sess_id'] = 'หมายเลข';
$PMF_LANG['ad_sess_sid'] = 'เซสซั่น ลำดับที่';
$PMF_LANG['ad_sess_ip'] = 'หมายเลขไอพี';
$PMF_LANG['ad_sess_time'] = 'เวลา';
$PMF_LANG['ad_sess_pageviews'] = 'หน้าที่เยี่ยมชม';
$PMF_LANG['ad_sess_search'] = 'ค้นหา';
$PMF_LANG['ad_sess_sfs'] = 'ค้นหารายการเชื่อมต่อ';
$PMF_LANG['ad_sess_s_ip'] = 'ไอพี:';
$PMF_LANG['ad_sess_s_minct'] = 'นาที. ดำเนินการ:';
$PMF_LANG['ad_sess_s_date'] = 'วัน';
$PMF_LANG['ad_sess_s_after'] = 'ก่อน';
$PMF_LANG['ad_sess_s_before'] = 'หลัง';
$PMF_LANG['ad_sess_s_search'] = 'ค้นหา';
$PMF_LANG['ad_sess_session'] = 'การเชื่อมต่อ';
$PMF_LANG['ad_sess_r'] = 'ค้นหาจากผลลัพธ์';
$PMF_LANG['ad_sess_referer'] = 'เปิดจาก:';
$PMF_LANG['ad_sess_browser'] = 'บราวเซอร์:';
$PMF_LANG['ad_sess_ai_rubrik'] = 'หัวข้อ:';
$PMF_LANG['ad_sess_ai_artikel'] = 'ข้อมูล:';
$PMF_LANG['ad_sess_ai_sb'] = 'คำค้นหา:';
$PMF_LANG['ad_sess_ai_sid'] = 'หมายเลขการเชื่อมต่อ:';
$PMF_LANG['ad_sess_back'] = 'ย้อนกลับ';
$PMF_LANG['ad_rs'] = 'สถิติการให้คะแนน';
$PMF_LANG['ad_rs_rating_1'] = 'อันดับของ';
$PMF_LANG['ad_rs_rating_2'] = 'คน ที่แสดง:';
$PMF_LANG['ad_rs_red'] = 'สีแดง';
$PMF_LANG['ad_rs_green'] = 'สีเขียว';
$PMF_LANG['ad_rs_altt'] = 'ที่ค่าเฉลี่ยน้อยกว่า 2';
$PMF_LANG['ad_rs_ahtf'] = 'ที่ค่าเฉลี่ยมากกว่า 4';
$PMF_LANG['ad_rs_no'] = 'ไม่พบรายการอันดับคะแนน';
$PMF_LANG['ad_auth_insert'] = 'ป้อนชื่อผู้ใช้ และ รหัสผ่าน.';
$PMF_LANG['ad_auth_user'] = 'ชื่อผู้ใช้:';
$PMF_LANG['ad_auth_passwd'] = 'รหัสผ่าน:';
$PMF_LANG['ad_auth_ok'] = 'ตกลง';
$PMF_LANG['ad_auth_reset'] = 'ยกเลิก';
$PMF_LANG['ad_auth_fail'] = 'ชื่อผู้ใช้ หรือ รหัสผ่าน ไม่ถูกต้อง.';
$PMF_LANG['ad_auth_sess'] = 'การเชื่อมต่อได้ถูกดำเนินการไปแล้ว';
$PMF_LANG['ad_config_edit'] = 'แก้ไขข้อมูลระบบ';
$PMF_LANG['ad_config_save'] = 'บันทึกข้อมูลระบบ';
$PMF_LANG['ad_config_reset'] = 'ยกเลิก';
$PMF_LANG['ad_config_saved'] = 'ข้อมูลระบบได้บันทึกเรียบร้อยแล้ว';
$PMF_LANG['ad_menu_editconfig'] = 'แก้ไข ข้อมูลระบบ';
$PMF_LANG['ad_att_none'] = 'ไม่มีไฟล์แนบ';
$PMF_LANG['ad_att_att'] = 'ไฟล์';
$PMF_LANG['ad_att_add'] = 'แนบไฟล์';
$PMF_LANG['ad_entryins_suc'] = 'ข้อมูลบันทึกเรียบร้อย';
$PMF_LANG['ad_entryins_fail'] = 'พบข้อผิดพลาด';
$PMF_LANG['ad_att_del'] = 'ลบ';
$PMF_LANG['ad_att_nope'] = 'ไฟล์แนบสามารถเพิ่มได้ขณะทำการเพิ่มหรือแก้ไขข้อมูลเท่านั้น';
$PMF_LANG['ad_att_delsuc'] = 'ไฟล์แนบได้ถูกลบเรียบร้อยแล้ว';
$PMF_LANG['ad_att_delfail'] = 'พบข้อผิดพลาดในการแก้ไขไฟล์แนบ';
$PMF_LANG['ad_entry_add'] = 'เพิ่ม FAQ';
$PMF_LANG['ad_csv_make'] = 'ระบบสำรองข้อมูลจะเก็บข้อมูลในฐานข้อมูล โดยจะเก็บในรูปของไฟล์ SQL ที่สามารถนำกลับมาใส่เพื่อการแก้ไขได้โดยใช้ phpMyAdmin หรือ โปรแกรม sql อื่นๆ การสำรองข้อมูลควรทำอย่างน้อยเดือนละครั้ง';
$PMF_LANG['ad_csv_link'] = 'โหลดไฟล์สำรองข้อมูล';
$PMF_LANG['ad_csv_head'] = 'สร้างไฟล์สำรองข้อมูล';
$PMF_LANG['ad_att_addto'] = 'เพิ่มไฟล์แนบในข้อมูล';
$PMF_LANG['ad_att_addto_2'] = '';
$PMF_LANG['ad_att_butt'] = 'ตกลง';
$PMF_LANG['ad_att_suc'] = 'ไฟล์ได้ถูกจัดแนบเรียบร้อยแล้ว';
$PMF_LANG['ad_att_fail'] = 'พบข้อผิดพลาดขณะทำการแนบไฟล์';
$PMF_LANG['ad_att_close'] = 'ปิดหน้าต่างนี้';
$PMF_LANG['ad_csv_restore'] = 'คุณสามารถทำไฟล์ฐานข้อมูลมาส่งกลับเข้าสู่ระบบได้ โดยการใช้ไฟล์สำรองข้อมูล  และข้อมูลที่อยู่ในระบบแล้วจะถูกเขียนทับ';
$PMF_LANG['ad_csv_file'] = 'ไฟล์';
$PMF_LANG['ad_csv_ok'] = 'ตกลง';
$PMF_LANG['ad_csv_linklog'] = 'บันทึกข้อมูลระบบ เกี่ยวกับการสำรองข้อมูล';
$PMF_LANG['ad_csv_linkdat'] = 'การสำรองข้อมูล';
$PMF_LANG['ad_csv_head2'] = 'นำข้อมูลกลับเข้าระบบ';
$PMF_LANG['ad_csv_no'] = 'ไฟล์นี้ไม่ใช่ไฟล์สำรองข้อมูลของ phpmyfaq';
$PMF_LANG['ad_csv_prepare'] = 'เตรียมการข้อมูลสำหรับฐานข้อมูล...';
$PMF_LANG['ad_csv_process'] = 'ดำเนินการกับฐานข้อมูล...';
$PMF_LANG['ad_csv_of'] = '';
$PMF_LANG['ad_csv_suc'] = 'เรียบร้อย';
$PMF_LANG['ad_csv_backup'] = 'สำรองข้อมูล';
$PMF_LANG['ad_csv_rest'] = 'นำข้อมูลสำรองกับเข้าระบบ';
$PMF_LANG['ad_menu_backup'] = 'สำรองข้อมูล';
$PMF_LANG['ad_logout'] = 'การเชื่อมต่อถูกระงับ';
$PMF_LANG['ad_news_edit'] = 'แก้ไขประกาศข่าว';
$PMF_LANG['ad_cookie'] = 'คุกกี้';
$PMF_LANG['ad_sess_head'] = 'ดูรายละเอียดการเชื่อมต่อ';
$PMF_LANG['msgAddCategory'] = 'เพิ่มหัวข้อหลัก';
$PMF_LANG['ad_kateg_rename'] = 'เปลี่ยนชื่อ';
$PMF_LANG['ad_adminlog_date'] = 'วัน';
$PMF_LANG['ad_adminlog_user'] = 'ผู้ใช้';
$PMF_LANG['ad_adminlog_ip'] = 'หมายเลขไอพี';
$PMF_LANG['ad_stat_sess'] = 'การเชื่อมต่อ';
$PMF_LANG['ad_stat_days'] = 'วัน';
$PMF_LANG['ad_stat_vis'] = 'การเชื่อมต่อ (ครั้ง)';
$PMF_LANG['ad_stat_vpd'] = 'เปิดชมต่อวัน';
$PMF_LANG['ad_stat_fien'] = 'บันทึกตอนแรก';
$PMF_LANG['ad_stat_laen'] = 'บันทึกตอนสุดท้าย';
$PMF_LANG['ad_stat_browse'] = 'รายละเอียดการเชื่อมต่อ';
$PMF_LANG['ad_stat_ok'] = 'ตกลง';
$PMF_LANG['ad_ques_take'] = 'เปิดคำถามและแก้ไข';
$PMF_LANG['no_cats'] = 'ไม่พบหัวข้อ';
$PMF_LANG['ad_log_lger'] = 'ข้อมูลผู้ใช้หรือรหัสผ่านไม่ถูกต้อง';
$PMF_LANG['ad_log_sess'] = 'สิ้นสุดการเชื่อมต่อ';
$PMF_LANG['ad_log_edit'] = '"แก้ไขผู้ใช้"-แบบฟอร์มสำหรับผู้ใช้: ';
$PMF_LANG['ad_log_crea'] = '"ข้อมูลไหม่" แบบฟอร์ม';
$PMF_LANG['ad_log_crsa'] = 'ข้อมูลใหม่ได้ถูกจัดทำขึ้นแล้ว';
$PMF_LANG['ad_log_ussa'] = 'แก้ไขข้อมูลสำหรับผู้ใชเหล่านี้: ';
$PMF_LANG['ad_log_usde'] = 'ลบผู้ใช้เหล่านี้: ';
$PMF_LANG['ad_log_beed'] = 'แบบฟอร์มสำหรับแก้ไขผู้ใช้เหล่านี้: ';
$PMF_LANG['ad_log_bede'] = 'ลบผู้ใช้เหล่านี้: ';
$PMF_LANG['msgVisits'] = 'เยี่ยมชม';
$PMF_LANG['ad_start_articles'] = 'หัวข้อ';
$PMF_LANG['ad_start_comments'] = 'ความคิดเห็น';
$PMF_LANG['ad_categ_paste'] = 'วางทับ';
$PMF_LANG['ad_categ_cut'] = 'ตัดออก';
$PMF_LANG['msgCopy'] = 'คัดลอก';
$PMF_LANG['ad_categ_process'] = 'กำลังดำเนินการ หัวข้อ...';
$PMF_LANG['err_NotAuth'] = '<strong>คุณไม่ได้รับอนุญาตให้ใช้งาน</strong>';
$PMF_LANG['msgPreviusPage'] = 'หน้าก่อนนี้';
$PMF_LANG['msgNextPage'] = 'หน้าถัดไป';
$PMF_LANG['msgPageDoublePoint'] = 'หน้า: ';
$PMF_LANG['msgMainCategory'] = 'หัวข้อหลัก';
$PMF_LANG['ad_passwdsuc'] = 'รหัสผ่านได้ถูกเปลี่ยนแล้ว';
$PMF_LANG['msgPDF'] = 'แสดงรายการแบบไฟล์ PDF';
$PMF_LANG['ad_xml_head'] = 'สำรองข้อมูลแบบ XML';
$PMF_LANG['ad_xml_hint'] = 'บันทึกรายการข้อมูลทั้งหมดในไฟล์ XML';
$PMF_LANG['ad_xml_gen'] = 'สร้างไฟล์ XML';
$PMF_LANG['ad_entry_locale'] = 'ภาษา';
$PMF_LANG['msgLanguageSubmit'] = 'เปลี่นภาษา';
$PMF_LANG['ad_entry_preview'] = 'ดูตัวอย่าง';
$PMF_LANG['ad_attach_1'] = 'โปรดเลือกที่อยู่แฟ้มสำหรับไฟล์แนบในข้อมูลระบบ';
$PMF_LANG['ad_attach_2'] = 'โปรดเลือกลิงค์สำหรับไฟล์แนบในข้อมูลระบบ';
$PMF_LANG['ad_attach_3'] = 'ไฟล์ attachment.php ไม่สามารถเปิดอ่านได้เนื่องจากระบบการยืนยันตัวตนที่แท้จริง';
$PMF_LANG['ad_attach_4'] = 'ไฟล์แนบจะต้องมีขนาดเล็กว่า %s ไบต์';
$PMF_LANG['ad_menu_export'] = 'เก็บข้อมูลของ FAQ';
$PMF_LANG['ad_export_file'] = 'ผิดพลาด: ไม่สามารถเขียนไฟล์ได้';
$PMF_LANG['ad_export_pdf'] = 'บันทึกแบบ PDF สำหรับทุกเรื่องที่มีอยู่';
$PMF_LANG['permission::add_user'] = 'เพิ่มผู้ใช้';
$PMF_LANG['permission::edit_user'] = 'แก้ไขผู้ใช้';
$PMF_LANG['permission::delete_user'] = 'ลบผู้ใช้';
$PMF_LANG['permission::add_faq'] = 'เพิ่มข้อมูล';
$PMF_LANG['permission::edit_faq'] = 'แก้ไขข้อมูล';
$PMF_LANG['permission::delete_faq'] = 'ลบข้อมูล';
$PMF_LANG['permission::viewlog'] = 'ดูข้อมูลการใช้';
$PMF_LANG['permission::adminlog'] = 'ดูข้อมูลการใช้ของผู้ดูแลระบบ';
$PMF_LANG['permission::delcomment'] = 'ลบความคิดเห็น';
$PMF_LANG['permission::addnews'] = 'เพิ่มประกาศข่าว';
$PMF_LANG['permission::editnews'] = 'แก้ไขประกาศข่าว';
$PMF_LANG['permission::delnews'] = 'ลบประกาศข่าว';
$PMF_LANG['permission::addcateg'] = 'เพิ่มหัวข้อ';
$PMF_LANG['permission::editcateg'] = 'แก้ไขหัวข้อ';
$PMF_LANG['permission::delcateg'] = 'ลบหัวข้อ';
$PMF_LANG['permission::passwd'] = 'เปลี่ยนรหัสผ่าน';
$PMF_LANG['permission::editconfig'] = 'แก้ไขข้อมูลระบบ';
$PMF_LANG['permission::addatt'] = 'เพิ่มไฟล์แนบ';
$PMF_LANG['permission::delatt'] = 'ลบไฟล์แนบ';
$PMF_LANG['permission::backup'] = 'สร้างข้อมูลสำรอง';
$PMF_LANG['permission::restore'] = 'ปรับปรุงข้อมูลสำรองสู่ระบบ';
$PMF_LANG['permission::delquestion'] = 'ลบคำถาม';
$PMF_LANG['permission::changebtrevs'] = 'แก้ไขข้อมูลฉบับปรับปรุง';
$PMF_LANG['msgAttachedFiles'] = 'ไฟล์แนบ:';
$PMF_LANG['ad_user_action'] = 'ดำเนินการ';
$PMF_LANG['msgEmail'] = 'อีเมล์:';
$PMF_LANG['ad_entry_allowComments'] = 'อนุญาตการใส่ความคิดเห็น:';
$PMF_LANG['msgWriteNoComment'] = 'คุณไม่สามารถเพิ่มความคิดเห็นบทความนี้';
$PMF_LANG['msgRealname'] = 'ชื่อจริง:';
$PMF_LANG['ad_export_generate_pdf'] = 'สร้างไฟล์ PDF';
$PMF_LANG['ad_export_full_faq'] = 'สร้างข้อมูลทั้งหมดเป็นไฟล์ PDF: ';
$PMF_LANG['err_bannedIP'] = 'หมายเลขไอพีของคุณถูกปฏิเสธการใช้งาน';
$PMF_LANG['err_SaveQuestion'] = 'ข้อมูลที่จำเป็น <strong>ชื่อ</strong>, <strong>อีเมล์</strong>, <strong>คำถาม</strong> และ รหัสตัวอักษร <strong><a href="https://en.wikipedia.org/wiki/Captcha" title="รายละเอียดเกี่ยวกับ Captcha ใน Wikipedia" target="_blank">Captcha</a></strong><br><br><a href="nojavascript...history.back();">ย้อนกลับ</a><br><br>';
$PMF_LANG['ad_entry_fontcolor'] = 'สีตัวอักษร: ';
$PMF_LANG['ad_entry_fontsize'] = 'ขนาดตัวอักษร: ';
$LANG_CONF['main.language'] = array("select", "ไฟล์ภาษา");
$LANG_CONF['main.languageDetection'] = array("checkbox", "เปิดระบบตรวจภาษาของเบาเซอร์อัตโนมัติ");
$LANG_CONF['main.titleFAQ'] = array("input", "ชื่อของเว็บ FAQ");
$LANG_CONF['main.currentVersion'] = array("print", "เวอร์ชั่น FAQ");
$LANG_CONF['main.metaDescription'] = array("input", "รายละเอียดของเว็บ FAQ");
$LANG_CONF['main.metaPublisher'] = array("input", "ขื่อผู้เขียน");
$LANG_CONF['main.administrationMail'] = array("input", "อีเมล์ของผู้ดูแลระบบ");
$LANG_CONF['main.contactInformation'] = array("area", "รายละเอียดติดต่อ");
$LANG_CONF['main.send2friendText'] = array("area", "ข้อความสำหรับหน้า send2friend");
$LANG_CONF['records.maxAttachmentSize'] = array("input", "ขนาดสูงสุดสำหรับไฟล์แนบ หน่วยเป็นไบต์ (สุงสุด %sไบต์)");
$LANG_CONF['records.disableAttachments'] = array("checkbox", "เปิดใช้ลิงค์สำหรับไฟล์แนบ");
$LANG_CONF['main.enableUserTracking'] = array("checkbox", "เปิดใช้ระบบติดตามผู้ใช้");
$LANG_CONF['main.enableAdminLog'] = array("checkbox", "เปิดใช้ระบบบันทึกการใช้งานผู้ดูแล");
$LANG_CONF['security.ipCheck'] = array("checkbox", "เปิดใช้ระบบตรวจสอบไอพีในส่วนของผู้ดูแล");
$LANG_CONF['records.numberOfRecordsPerPage'] = array("input", "จำนวนเรื่องที่แสดงในหนึ่งหน้า");
$LANG_CONF['records.numberOfShownNewsEntries'] = array("input", "จำนวนประกาศข่าว");
$LANG_CONF['security.bannedIPs'] = array("area", "ห้ามการใช้งานจากหมายเลขที่อยู่ไอพี");
$LANG_CONF['ldap.ldapSupport'] = array("checkbox", "เปิดใช้งาน LDAP (ค่าเริ่มต้น: ปิด)");
$LANG_CONF['main.referenceURL'] = array("input", "URL หลักสำหรับการตรวจสอบลิงค์ (ตัวอย่าง: https://www.example.org/faq/)");
$LANG_CONF['records.enableVisibilityQuestions'] = array("checkbox", "ปิดการแสดงผลของคำถามใหม่");
$LANG_CONF['security.permLevel'] = array("select", "ระดับการอนุญาต");
$PMF_LANG['ad_categ_new_main_cat'] = 'เป็นหัวข้อใหม่';
$PMF_LANG['ad_categ_paste_error'] = 'ไม่สามารถย้ายหัวข้อนี้ได้';
$PMF_LANG['ad_categ_move'] = 'ย้ายหัวข้อ';
$PMF_LANG['ad_categ_lang'] = 'ภาษา';
$PMF_LANG['ad_categ_desc'] = 'รายละเอียด';
$PMF_LANG['ad_categ_change'] = 'เปลี่ยนเป็น';
$PMF_LANG['lostPassword'] = 'ลืมรหัสผ่าน';
$PMF_LANG['lostpwd_err_1'] = 'พบข้อผิดพลาด: ไม่พบชื่อผู้ใช้และอีเมล์';
$PMF_LANG['lostpwd_err_2'] = 'พบข้อผิดพลาด: ข้อมูลไม่ถูกต้อง!';
$PMF_LANG['lostpwd_text_1'] = 'ขอบคุณที่แจ้งขอข้อมูลรหัสผ่าน';
$PMF_LANG['lostpwd_text_2'] = 'โปรดเปลี่ยนรหัสผ่านของคุณในส่วนของผู้ดูแลระบบ';
$PMF_LANG['lostpwd_mail_okay'] = 'ข้อมูลได้จัดส่งให้ทางอีเมล์แล้ว';
$PMF_LANG['msgButtonFetchLatestVersion'] = 'ตรวจสอบเลขเวอร์ชั้นล่าสุดจากเว็บ';
$PMF_LANG['ad_xmlrpc_latest'] = 'พบเวอร์ชั่นใหม่ล่าสุด ';
$PMF_LANG['ad_categ_select'] = 'เลือกภาษาของหัวข้อ';
$PMF_LANG['msgSitemap'] = 'ดัชนีคำถาม';
$PMF_LANG['err_inactiveArticle'] = 'ข้อมูลในฉบับปรับปรุงแก้ไขนี้ไม่สามารถนำมาแสดงได้';
$PMF_LANG['msgArticleCategories'] = 'หัวข้อสำหรับข้อมูลนี้';
$PMF_LANG['ad_entry_solution_id'] = 'ลำดับหัวข้อ';
$PMF_LANG['ad_entry_faq_record'] = 'ข้อมูล FAQ';
$PMF_LANG['ad_entry_new_revision'] = 'สร้างฉบับปรับปรุงแก้ไข?';
$PMF_LANG['ad_entry_record_administration'] = 'การจัดการข้อมูล';
$PMF_LANG['ad_entry_revision'] = 'ฉบับปรับปรุงแก้ไข';
$PMF_LANG['ad_changerev'] = 'เลือกฉบับปรับปรุงแก้ไข';
$PMF_LANG['msgCaptcha'] = 'โปรดกรอกข้อมูลตัวอักษรในภาพที่แสดงไว้';
$PMF_LANG['msgSelectCategories'] = 'ค้นหา ...';
$PMF_LANG['msgAllCategories'] = '... ทุกหัวข้อ';
$PMF_LANG['ad_you_should_update'] = 'โปรแกรม phpMyFAQ ที่คุณติดตั้งไว้ เก่าเกินไป  คุณควรปรับปรุงเป็นเวอร์ชั่นใหม่';
$PMF_LANG['msgAdvancedSearch'] = 'ค้นหาแบบพิเศษ';
$PMF_LANG['spamControlCenter'] = 'ระบบควบคุม Spam';
$LANG_CONF['spam.enableSafeEmail'] = array("checkbox", "ป้องกันการแสดงอีเมล์ (ค่าเริ่มต้น: เปิด)");
$LANG_CONF['spam.checkBannedWords'] = array("checkbox", "เปิดระบบตรวจสอบคำหยาบ (ค่าเริ่มต้น: เปิด)");
$LANG_CONF['spam.enableCaptchaCode'] = array("checkbox", "เปิดระบบกรอกรหัสอักษร (ค่าเริ่มต้น: เปิด)");
$PMF_LANG['ad_session_expiring'] = 'การเชื่อมต่อของคุณจะถูกยกเลิกใน %d นาที: คุณต้องการใช้งานต่อหรือไม่?';
$PMF_LANG['ad_stat_management'] = 'การจัดการการเชื่อมต่อ';
$PMF_LANG['ad_stat_choose'] = 'เลือกเดือนที่ต้องการ';
$PMF_LANG['ad_stat_delete'] = 'ลบข้อมูลการเชื่อมต่อที่เลือกไว้';
$PMF_LANG['ad_menu_glossary'] = 'อภิธาณศัพท์';
$PMF_LANG['ad_glossary_add'] = 'เพิ่มข้อมูลอภิธาณศัพท์';
$PMF_LANG['ad_glossary_edit'] = 'แก้ไขอภิธาณศัพท์';
$PMF_LANG['ad_glossary_item'] = 'รายการ';
$PMF_LANG['ad_glossary_definition'] = 'นิยาม';
$PMF_LANG['ad_glossary_save'] = 'บันทึกรายการ';
$PMF_LANG['ad_glossary_save_success'] = 'บันทึกรายการอภิธาณศัพท์เรียบร้อยแล้ว';
$PMF_LANG['ad_glossary_save_error'] = 'ไม่สามารถบันทึกอภิธาณศัพท์ได้เนื่องจากมีข้อผิดพลาดเกิดขึ้น';
$PMF_LANG['ad_glossary_update_success'] = 'อภิธาณศัพท์ได้รับการแก้ไขเรียบร้อยแล้ว';
$PMF_LANG['ad_glossary_update_error'] = 'ไม่สามารถแก้ไขอภิธาณศัพท์ได้เนื่องจากมีข้อผิดพลาดเกิดขึ้น';
$PMF_LANG['ad_glossary_delete'] = 'ลบรายการ';
$PMF_LANG['ad_glossary_delete_success'] = 'ลบรายการอภิธาณศัพท์เรียบร้อยแล้ว';
$PMF_LANG['ad_glossary_delete_error'] = 'ไม่สามารถลบอภิธาณศัพท์ได้เนื่องจากมีข้อผิดพลาดเกิดขึ้น';
$PMF_LANG['msgNewQuestionVisible'] = 'คำถามจะต้องตรวจสอบก่อนเปิดให้ใช้งานทั่วไป';
$PMF_LANG['msgQuestionsWaiting'] = 'รอการตรวจสอบจากผู้ดูแลระบบ:';
$PMF_LANG['ad_entry_visibility'] = 'เปิดให้ใช้งาน';
$PMF_LANG['ad_user_error_password'] = 'โปรดกรอกรหัสผ่าน';
$PMF_LANG['ad_user_error_passwordsDontMatch'] = 'รหัสผ่านไม่ถูกต้อง ';
$PMF_LANG['ad_user_error_loginInvalid'] = 'ชื่อผู้ใช้ไม่ถูกต้อง';
$PMF_LANG['ad_user_error_noEmail'] = 'โปรดกรอกอีเมล์ที่ถูกต้อง ';
$PMF_LANG['ad_user_error_noRealName'] = 'โปรดกรอกชื่อของคุณ ';
$PMF_LANG['ad_user_error_delete'] = 'ผู้ใช้งานนี้ไม่สามารถลบได้ ';
$PMF_LANG['ad_user_error_noId'] = 'คุณไม่ได้ระบุ ID ที่ต้องการ ';
$PMF_LANG['ad_user_error_protectedAccount'] = 'ชื่อผู้ใช้ได้รับการป้องกันจากการแก้ไข';
$PMF_LANG['ad_user_deleteUser'] = 'ลบผู้ใช้';
$PMF_LANG['ad_user_status'] = 'สถานะ';
$PMF_LANG['ad_user_lastModified'] = 'แก้ไขครั้งสุดท้ายเมื่อ:';
$PMF_LANG['ad_gen_cancel'] = 'ยกเลิก';
$PMF_LANG['permission::addglossary'] = 'เพิ่มรายการอภิธาณศัพท์';
$PMF_LANG['permission::editglossary'] = 'แก้ไขรายการอภิธาณศัพท์';
$PMF_LANG['permission::delglossary'] = 'ลบรายการอภิธาณศัพท์';
$PMF_LANG['ad_menu_group_administration'] = 'จัดการกลุ่มผู้ใช้';
$PMF_LANG['ad_user_loggedin'] = 'คุณเข้าสู่ระบบโดย  ';
$PMF_LANG['ad_group_details'] = 'รายละเอียดกลุ่มผู้ใช้';
$PMF_LANG['ad_group_add'] = 'เพิ่มกลุ่มผู้ใช้';
$PMF_LANG['ad_group_add_link'] = 'เพิ่มกลุ่มผู้ใช้';
$PMF_LANG['ad_group_name'] = 'ชื่อ:';
$PMF_LANG['ad_group_description'] = 'รายละเอียด:';
$PMF_LANG['ad_group_autoJoin'] = 'เข้าร่วมกลุ่มอัตโนมัติ:';
$PMF_LANG['ad_group_suc'] = 'กลุ่มผู้ใช้ได้รับการเพิ่ม <strong>เรียบร้อย</strong>';
$PMF_LANG['ad_group_error_noName'] = 'โปรดกรอกชื่อกลุ่ม ';
$PMF_LANG['ad_group_error_delete'] = 'กลุ่มผู้ใช้ไม่สามารถลบได้';
$PMF_LANG['ad_group_deleted'] = 'กลุ่มผู้ใช้ถูกลบเรียบร้อยแล้ว';
$PMF_LANG['ad_group_deleteGroup'] = 'ลบกลุ่มผู้ใช้';
$PMF_LANG['ad_group_deleteQuestion'] = 'คุณแน่ใจหรือไม่ว่าจะลบกลุ่มผู้ใช้นี้?';
$PMF_LANG['ad_user_uncheckall'] = 'ยกเลิกการเลือกทั้งหมด';
$PMF_LANG['ad_group_membership'] = 'สมาชิกกลุ่มผู้ใช้';
$PMF_LANG['ad_group_members'] = 'สมาชิก';
$PMF_LANG['ad_group_addMember'] = '+';
$PMF_LANG['ad_group_removeMember'] = '-';
$PMF_LANG['ad_export_which_cat'] = 'จำกัดจำนวนข้อมูลที่จะนำส่งข้อมูลออก (ทางเลือกเพิ่มเติม)';
$PMF_LANG['ad_export_cat_downwards'] = 'สามารถย้อนกลับได้?';
$PMF_LANG['ad_export_type'] = 'รูปแบบการนำส่งข้อมูลออก';
$PMF_LANG['ad_export_type_choose'] = 'เลือกรูปแบบที่ต้องการ:';
$PMF_LANG['ad_export_download_view'] = 'ดาวน์โหลดหรือเลือกเปิดดู?';
$PMF_LANG['ad_export_download'] = 'ดาวน์โหลด';
$PMF_LANG['ad_export_view'] = 'เปิดดู';
$PMF_LANG['ad_export_gen_xhtml'] = 'สร้างไฟล์ XHTML';
$PMF_LANG['ad_export_gen_docbook'] = 'สร้างไฟล์ Docbook';
$PMF_LANG['ad_news_data'] = 'สร้างข้อมูลประกาศข่าว';
$PMF_LANG['ad_news_author_name'] = 'ชื่อผู้เขียน:';
$PMF_LANG['ad_news_author_email'] = 'อีเมล์ผู้เขียน:';
$PMF_LANG['ad_news_set_active'] = 'เปิดใช้งาน';
$PMF_LANG['ad_news_allowComments'] = 'เปิดให้สามารถส่งคำแนะนำได้:';
$PMF_LANG['ad_news_expiration_window'] = 'กำหนดระยะเวลาให้ยกเลิกประกาศข่าวเอง (ทางเลือกเพิ่มเติม)';
$PMF_LANG['ad_news_from'] = 'จาก:';
$PMF_LANG['ad_news_to'] = 'ถึง:';
$PMF_LANG['ad_news_insertfail'] = 'พบข้อผิดพลาดในการเพิ่มประกาศข่าวใหม่ในฐานข้อมูล';
$PMF_LANG['ad_news_updatefail'] = 'พบข้อผิดพลาดในการแก้ไขประกาศข่าวใหม่ในฐานข้อมูล';
$PMF_LANG['newsShowCurrent'] = 'แสดงประกาศข่าวล่าสุด';
$PMF_LANG['newsShowArchive'] = 'แสดงประกาศข่าวที่ผ่านมาแล้ว.';
$PMF_LANG['newsArchive'] = 'รวมประกาศข่าวเก่า';
$PMF_LANG['newsWriteComment'] = 'คำแนะนำสำหรับข้อมูลนี้';
$PMF_LANG['newsCommentDate'] = 'เพิ่มเข้ามา เมื่อ: ';
$PMF_LANG['ad_record_expiration_window'] = 'เวลาให้สิ้นสุดหรือยกเลิกข้อมูลอัตโนมัติ (ทางเลือกเพิ่มเติม)';
$PMF_LANG['adminHeaderDashboard'] = 'หน้าหลัก';
$PMF_LANG['admin_mainmenu_users'] = 'ผู้ใช้งาน';
$PMF_LANG['admin_mainmenu_content'] = 'เนื้อหาข้อมูล';
$PMF_LANG['admin_mainmenu_statistics'] = 'สถิติ';
$PMF_LANG['admin_mainmenu_backup'] = 'สำรองข้อมูล';
$PMF_LANG['admin_mainmenu_configuration'] = 'ข้อมูลระบบ';
$PMF_LANG['admin_mainmenu_logout'] = 'ออกจากระบบ';
$PMF_LANG['ad_categ_owner'] = 'เจ้าของ หัวข้อ';
$PMF_LANG['adminSection'] = 'ผู้ดูแล';
$PMF_LANG['err_expiredArticle'] = 'ข้อมูลนี้สิ้นสุดหรือถูกยกเลิกแล้ว ไม่สามารถแสดงได้';
$PMF_LANG['err_expiredNews'] = 'ประกาศข่าวนี้สิ้นสุดหรือถูกยกเลิกแล้ว ไม่สามารถแสดงได้';
$PMF_LANG['err_inactiveNews'] = 'ประกาศข่าวนี้ยังไม่ได้เปิดใช้งาน ไม่สามารถแสดงได้';
$PMF_LANG['msgSearchOnAllLanguages'] = 'ค้นหาจากทุกภาษา:';
$PMF_LANG['ad_entry_tags'] = 'คำหลัก';
$PMF_LANG['msg_tags'] = 'คำหลัก';
$PMF_LANG['msg_related_articles'] = 'ข้อมูลที่เกี่ยวข้อง';
$LANG_CONF['records.numberOfRelatedArticles'] = array("input", "จำนวนข้อมูลที่เกี่ยวข้อง");
$PMF_LANG['ad_categ_trans_1'] = 'แปล';
$PMF_LANG['ad_categ_trans_2'] = 'หัวข้อ';
$PMF_LANG['ad_categ_translatecateg'] = 'แปลหัวข้อ';
$PMF_LANG['ad_categ_translate'] = 'แปล';
$PMF_LANG['ad_categ_transalready'] = 'ได้รับการแปลในภาษา: ';
$PMF_LANG['ad_categ_deletealllang'] = 'ลบในทุกภาษา';
$PMF_LANG['ad_categ_deletethislang'] = 'ลบเฉพาะภาษานี้เท่านั้น';
$PMF_LANG['ad_categ_translated'] = 'หัวข้อนี้ได้ถูกแปลเรียบร้อยแล้ว';
$PMF_LANG['msgCategoryMatrix'] = 'หัวข้อโดยสรุป';
$PMF_LANG['ad_menu_categ_structure'] = 'หัวข้อโดยสรุปและภาษาต่างๆ';
$PMF_LANG['ad_entry_userpermission'] = 'สิทธิผู้ใช้:';
$PMF_LANG['ad_entry_grouppermission'] = 'สิทธิกลุ่มผู้ใช้:';
$PMF_LANG['ad_entry_all_users'] = 'อนุญาตให้ทุกคนในผู้ใช้งาน';
$PMF_LANG['ad_entry_restricted_users'] = 'จำกัดสิทธิสำหรับ';
$PMF_LANG['ad_entry_all_groups'] = 'อนุญาตสำหรับทุกกลุ่มผู้ใช้งาน';
$PMF_LANG['ad_entry_restricted_groups'] = 'จำกัดสิทธิใช้งานสำหรับ';
$PMF_LANG['ad_session_expiration'] = 'เวลาที่จะสิ้นสุดการเชื่อมต่อ';
$PMF_LANG['ad_user_active'] = 'ใช้งานปกติ';
$PMF_LANG['ad_user_blocked'] = 'ยกเลิกใช้งาน';
$PMF_LANG['ad_user_protected'] = 'สงวนไว้';
$PMF_LANG['ad_entry_intlink'] = 'เลือกข้อมูล FAQ ที่จะเพิ่มเป็นลิงค์...';
$PMF_LANG['ad_categ_paste2'] = 'วางหัวข้อหลังจาก';
$PMF_LANG['msgCategoryRemark_overview'] = 'การเรียงลำดับหัวข้อที่ถูกต้อง ถ้าหัวข้อได้ถูกกำหนดไว้ในภาษาที่ถูกต้อง (คอลัมน์แรก)';
$PMF_LANG['msgUsersOnline'] = '%d คนทั่วไป และ %d คนที่ลงทะเบียน';
$PMF_LANG['ad_adminlog_del_older_30d'] = 'ลบรายการที่ระบบบันทึกไว้ที่นานกว่า 30 วัน';
$PMF_LANG['ad_adminlog_delete_success'] = 'ระบบบันทึกเก่าได้ถูกลบเรียบร้อยแล้ว';
$PMF_LANG['ad_adminlog_delete_failure'] = 'ไม่สามารถลบรายการในระบบบันทึกได้ เนื่องจากพบข้อผิดพลาด';
$PMF_LANG['ad_quicklinks'] = 'ลิงค์ด่วน';
$PMF_LANG['ad_quick_category'] = 'เพิ่มหัวข้อใหม่';
$PMF_LANG['ad_quick_record'] = 'เพิ่ม FAQ ใหม่';
$PMF_LANG['ad_quick_user'] = 'เพิ่มผู้ใช้ใหม่';
$PMF_LANG['ad_quick_group'] = 'เพิ่มกลุ่มผู้ใช้ใหม่';
$PMF_LANG['msgNewTranslationHeader'] = 'แนะนำการแปลภาษา';
$PMF_LANG['msgNewTranslationAddon'] = 'การแปลของคุณจะพร้อมใช้งาน หลังจากได้รับการตรวจสอบ โปรดให้ข้อมูล <strong>ชื่อของคุณ</strong>, <strong>อีเมล์ของคุณ</strong>, <strong>หัวเรื่องของการแปล</strong> และ <strong>ข้อมูลการแปลของคุณ</strong> โปรดใช้ช่องว่างในการแยกคำ ของ คำค้นหา';
$PMF_LANG['msgNewTransSourcePane'] = 'ส่วนของข้อมูลหลัก';
$PMF_LANG['msgNewTranslationPane'] = 'ส่วนของการแปล';
$PMF_LANG['msgNewTranslationName'] = 'ชื่อ:';
$PMF_LANG['msgNewTranslationMail'] = 'อีเมล์:';
$PMF_LANG['msgNewTranslationKeywords'] = 'คำค้น:';
$PMF_LANG['msgNewTranslationSubmit'] = 'ส่งข้อมูลแปลภาษา';
$PMF_LANG['msgTranslate'] = 'เสนอแปลเป็นภาษา ';
$PMF_LANG['msgTranslateSubmit'] = 'เริ่มการแปล...';
$PMF_LANG['msgNewTranslationThanks'] = 'ขอบคุณสำหรับการช่วยแปล';
$PMF_LANG['permission::addgroup'] = 'เพิ่มกลุ่มผู้ใช้';
$PMF_LANG['permission::editgroup'] = 'แก้ไขกลุ่มผู้ใช้';
$PMF_LANG['permission::delgroup'] = 'ลบกลุ่มผู้ใช้';
$PMF_LANG['ad_news_link_parent'] = 'เปิดลิงค์ในหน้าหลัก';
$PMF_LANG['ad_menu_comments'] = 'ความคิดเห็น';
$PMF_LANG['adminHeaderComments'] = 'ระบบจัดการ ความคิดเห็น';
$PMF_LANG['msgAdminCommentFaqs'] = 'ความเห็นในข้อมูลของ FAQ:';
$PMF_LANG['msgAdminCommentNews'] = 'ความเห็นในข้อมูลของประกาศข่าว:';
$PMF_LANG['ad_groups'] = 'กลุ่ม';
$LANG_CONF['records.orderby'] = array('select', 'เรียงลำดับข้อมูล (ลำดับตามคุณลักษณะ)');
$LANG_CONF['records.sortby'] = array('select', 'เรียงลำดับข้อมูล (ก่อน หรือ หลัง)');
$PMF_LANG['ad_conf_order_id'] = 'เลขที่ (ค่าปกติ)';
$PMF_LANG['ad_conf_order_thema'] = 'หัวเรื่อง';
$PMF_LANG['ad_conf_order_visits'] = 'จำนวนคนเปิดดู';
$PMF_LANG['ad_conf_order_updated'] = 'วัน';
$PMF_LANG['ad_conf_order_author'] = 'ผู้เขียน';
$PMF_LANG['ad_conf_desc'] = 'จากบนลงล่าง';
$PMF_LANG['ad_conf_asc'] = 'จากล่างขึ้นบน';
$PMF_LANG['mainControlCenter'] = 'ข้อมูลหลักของระบบ';
$PMF_LANG['recordsControlCenter'] = 'ค่าเริ่มต้นของข้อมูล FAQ';
$LANG_CONF['records.defaultActivation'] = array("checkbox", "เปิดใช้งานข้อมูลใหม่ (ค่าเริ่มต้น: ปิด)");
$LANG_CONF['records.defaultAllowComments'] = array("checkbox", "เปิดให้สามารถส่งความคิดเห็นได้ (ค่าเริ่มต้น: ไม่อนุญาต)");
$PMF_LANG['msgAllCatArticles'] = 'รายการในหัวข้อนี้';
$PMF_LANG['msgTagSearch'] = 'คำหลัก';
$PMF_LANG['ad_pmf_info'] = 'รายละเอียดเกี่ยวกับ phpMyFAQ';
$PMF_LANG['msgOnlineVersionCheck'] = 'ตรวจสอบเวอร์ชั่น';
$PMF_LANG['ad_system_info'] = 'ข้อมูลเกี่ยวกับระบบ';
$PMF_LANG['msgRegisterUser'] = 'คุณต้องการที่จะลงทะเบียนหรือไม่?';
$PMF_LANG['msgUsername'] = 'ชื่อผู้ใช้:';
$PMF_LANG['errorRegistration'] = 'ส่วนนี้จำเป็นต้องกรอก';
$PMF_LANG['submitRegister'] = 'ลงทะเบียน';
$PMF_LANG['msgUserData'] = 'ข้อมูลผู้ใช้ที่จำเป็นสำหรับการลงทะเบียน';
$PMF_LANG['captchaError'] = 'โปรดกรอกรหัสให้ถูกต้อง';
$PMF_LANG['msgRegError'] = 'พบข้อผิดพลาด โปรดแก้ไข';
$PMF_LANG['successMessage'] = 'การลงทะเบียนของคุณเสร็จสมบูรณ์  คุณจะได้รับอีเมล์ยืนยันข้อมูลที่คุณได้ลงทะเบียนไว้';
$PMF_LANG['msgRegThankYou'] = 'ขอบคุณสำหรับการลงทะเบียน';
$PMF_LANG['emailRegSubject'] = '[%sitename%] ลงทะเบียน: ผู้ใช้ใหม่';
$PMF_LANG['msgMostPopularSearches'] = 'คำที่นิยมค้นหามากที่สุด:';
$PMF_LANG['ad_menu_searchstats'] = 'สถิติการค้นหา';
$PMF_LANG['ad_searchstats_search_term'] = 'คำค้น';
$PMF_LANG['ad_searchstats_search_term_count'] = 'ครั้ง';
$PMF_LANG['ad_searchstats_search_term_lang'] = 'ภาษา';
$PMF_LANG['ad_searchstats_search_term_percentage'] = 'เปอร์เซนต์';
$PMF_LANG['ad_record_sticky'] = 'ปักหมุด';
$PMF_LANG['ad_entry_sticky'] = 'ปักหมุด';
$PMF_LANG['stickyRecordsHeader'] = 'ปักหมุด FAQs';
$PMF_LANG['ad_menu_stopwordsconfig'] = 'คำยกเว้น';
$PMF_LANG['ad_config_stopword_input'] = 'เพิ่ม คำยกเว้น ใหม่';
$PMF_LANG['msgSendMailDespiteEverything'] = 'ใช่, ไม่พบคำตอบที่เหมาะสม (ส่งอีเมล์แจ้ง)';
$PMF_LANG['msgSendMailIfNothingIsFound'] = 'คุณแน่ใจหรือไม่ทีต้องการให้แสดงคำตอบในนั้น?';
$PMF_LANG['msgChooseLanguageToTranslate'] = 'โปรดเลือกภาษาสำหรับการแปล';
$PMF_LANG['msgLangDirIsntWritable'] = 'แฟ้มภาษา ไม่สามารถเขียนได้';
$PMF_LANG['ad_menu_translations'] = 'ส่วนการแปล';
$PMF_LANG['ad_start_notactive'] = 'รอการอนุมัติ';
$PMF_LANG['msgTransToolAddNewTranslation'] = 'เพิ่มภาษาใหม่';
$PMF_LANG['msgTransToolLanguage'] = 'ภาษา';
$PMF_LANG['msgTransToolActions'] = 'ดำเนินการ';
$PMF_LANG['msgTransToolWritable'] = 'เขียนได้';
$LANG_CONF['main.enableWysiwygEditor'] = array("checkbox", "เปิดการใช้งานแบบ WYSIWYG (ค่าเริ่มต้น: เปิด)");
$PMF_LANG['msgEdit'] = 'แก้ไข';
$PMF_LANG['msgDelete'] = 'ลบ';
$PMF_LANG['msgYes'] = 'ใช่';
$PMF_LANG['msgNo'] = 'ไม่ใช่';
$PMF_LANG['msgVariable'] = 'ตัวแปร';
$PMF_LANG['msgCancel'] = 'ยกเลิก';
$PMF_LANG['msgSave'] = 'บันทึก';
$PMF_LANG['msgSaving3Dots'] = 'กำลังบันทึก ...';
$PMF_LANG['msgRemoving3Dots'] = 'กำลับลบ ...';
$PMF_LANG['msgLanguage'] = 'ภาษา';
$PMF_LANG['msgTransToolLanguageCharset'] = 'อักขระของภาษา';
$PMF_LANG['msgTransToolLanguageDir'] = 'ลักษณะทิศทางของภาษา';
$PMF_LANG['msgTransToolLanguageDesc'] = 'รายละเอียดของภาษา';
$PMF_LANG['msgTransToolAddAuthor'] = 'เพิ่มชื่อผู้เขียน';
$PMF_LANG['msgTransToolCreateTranslation'] = 'สร้างการแปลใหม่';
$PMF_LANG['msgTransToolTransCreated'] = 'แปลได้ถูกสร้างขึ้นใหม่แล้ว';
$PMF_LANG['msgTransToolCouldntCreateTrans'] = 'ไม่สามารถสร้างการแปลใหม่ได้';
$PMF_LANG['msgAdding3Dots'] = 'กำลังเพิ่ม ...';
$PMF_LANG['msgTransToolSendToTeam'] = 'ส่งการแปลให้กับทีมงาน phpMyFAQ';
$PMF_LANG['msgSending3Dots'] = 'กำลังส่ง ...';
$PMF_LANG['msgTransToolFileSent'] = 'ไฟล์ภาษาได้ถูกจัดส่งให้กับทีมงาน phpMyFAQ เรียบร้อยแล้ว ขอบคุณมากที่แบ่งปัน';
$PMF_LANG['msgTransToolErrorSendingFile'] = 'พบข้อผิดพลาดในการส่งไฟล์ภาษา';
$PMF_LANG['msgTransToolPercent'] = 'เสร็จ';
$PMF_LANG['msgAttachmentNotFound'] = 'ไฟล์ที่คุณโหลดอยู่นั้นไม่สามารถตรวจพบในเครื่องเซิฟเวอร์';
$PMF_LANG['ad_sess_noentry'] = 'ไม่พบ';
$PMF_LANG['plmsgUserOnline']['0'] = 'จำนวนคนเปิดชม %d คน';
$LANG_CONF['records.attachmentsPath'] = array("input", "ที่อยู่สำหรับที่จะบันทึกเอกสารแนบ<br><small>ระบุเป็นที่อยู่บนเว็บโดยอ้างจากหน้าหลักของเว็บ</small>");
$PMF_LANG['plmsgHomeArticlesOnline']['0'] = 'มีข้อมูลทั้งหมด %d เรื่อง ในระบบ';
$PMF_LANG['plmsgViews']['0'] = '%d ครั้ง';
$PMF_LANG['plmsgGuestOnline']['0'] = '%d ผู้ใช้งานทั่วไป';
$PMF_LANG['plmsgRegisteredOnline']['0'] = ' และ%d ผู้ลงทะเบียน';
$PMF_LANG['plmsgSearchAmount']['0'] = '%d ข้อมูล';
$PMF_LANG['plmsgPagesTotal']['0'] = ' %d หน้า';
$PMF_LANG['plmsgVotes']['0'] = '%d โหวต';
$PMF_LANG['plmsgEntries']['0'] = '%d เรื่อง';
$PMF_LANG['permission::addtranslation'] = 'เพิ่มการแปล';
$PMF_LANG['permission::edittranslation'] = 'แก้ไขการแปล';
$PMF_LANG['permission::deltranslation'] = 'ลบการแปล';
$PMF_LANG['permission::approverec'] = 'อนุมัติข้อมูล';
$PMF_LANG['ad_menu_upgrade'] = 'phpMyFAQ ปรับปรุง';
$PMF_LANG['ad_you_shouldnt_update'] = 'คุณใช้เวอร์ชั่นล่าสุดของ phpMyFAQ ไม่จำเป็นต้องปรับปรุงระบบ';
$PMF_LANG['msgSecureSwitch'] = 'เปลี่ยนใช้ระบบความปลอดภัยสูงในการเข้าใช้งาน';
$LANG_CONF['layout.templateSet'] = array("select", "เลือกเทมเพลตที่ต้องการ");
$LANG_CONF['records.enableAttachmentEncryption'] = array("checkbox", "เปิดการใช้งานเข้ารหัสของเอกสารแนบ <br><small>ยกเลิก ถ้าไม่ได้เปิดใช้เอกสารแนบ</small>");
$LANG_CONF['records.defaultAttachmentEncKey'] = array("input", 'ค่ารหัสเิริ่มต้นสำหรับเอกสารแนบ <br><small>ยกเลิก ถ้าไม่ได้เปิดใช้เอกสารแนบ</small><br><small><font color="red">คำเตือน: ไม่สามารถแก้ไขได้เมื่อเปิดใช้งานเข้ารหัสเอกสารแนบแล้ว!!!</font></small>');
$LANG_CONF['security.useSslForLogins'] = array('checkbox', "เปิดให้เข้าใช้งานสำหรับการเชื่อมต่อแบบปลอดภัยเท่านั้น? (ค่าเริ่มต้น: ปิด)");
$PMF_LANG['msgTransToolNoteFileSaving'] = 'ไฟล์จะไม่ถูกเขียน จนกว่าจะกดปุ่มบันทึก';
$PMF_LANG['msgTransToolPageBufferRecorded'] = 'หน้า %d ข้อมูล ถูกบันทึกเรียบร้อย';
$PMF_LANG['msgTransToolErrorRecordingPageBuffer'] = 'เกิดข้อผิดพลาดในการบันทึกข้อมูลหน้า %d';
$PMF_LANG['msgTransToolRecordingPageBuffer'] = 'บันทึกข้อมูลหน้า %d';
$PMF_LANG['ad_record_active'] = 'เ้ปิดใช้งาน';
$PMF_LANG['msgAttachmentInvalid'] = 'เอกสารแนบผิดพลาด โปรดแจ้งผู้ดูแลระบบ';
$PMF_LANG['list_all_users'] = 'แสดงทั้งหมด';
$PMF_LANG['records.orderingPopularFaqs.visits'] = 'ลำดับจากการเปิดดู';
$PMF_LANG['records.orderingPopularFaqs.voting'] = 'ลำดับจากการโหวต';
$PMF_LANG['msgShowHelp'] = 'โปรดแยกแต่ละคำด้วย เครื่องหมาย คอมม่า (,)';
$PMF_LANG['msgUpdateFaqDate'] = 'ปรับปรุง';
$PMF_LANG['msgKeepFaqDate'] = 'เก็บไว้';
$PMF_LANG['msgEditFaqDat'] = 'แก้ไข';
$LANG_CONF['search.numberSearchTerms'] = array('input', 'จำนวนของผลการค้นที่จะแสดง');
$LANG_CONF['records.orderingPopularFaqs'] = array("select", "เรียงลำดับเรื่องของ faq");

return $PMF_LANG;
