<?php

/**
 * The Turkish language file - try to be the best of Turkish
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at https://mozilla.org/MPL/2.0/.
 *
 * @package phpMyFAQ
 * @author Can Kirca <cankirca@gmail.com>
 * @author Zafer Gürsoy <zafergursoy@yahoo.com>
 * @author Evren Yurtesen <yurtesen@ispro.net.tr>
 * @copyright 2004-2024 phpMyFAQ Team
 * @license https://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link https://www.phpmyfaq.de
 * @since 2004-02-19
 * @codingStandardsIgnoreFile
 */

$PMF_LANG["metaCharset"] = "UTF-8";
$PMF_LANG["metaLanguage"] = "tr";
$PMF_LANG["language"] = "Turkish";
$PMF_LANG['direction'] = "ltr";
$PMF_LANG["nplurals"] = "1";

// Navigation
$PMF_LANG["msgCategory"] = "Kategoriler";
$PMF_LANG["msgShowAllCategories"] = "Tüm kategoriler";
$PMF_LANG["msgSearch"] = "Ara";
$PMF_LANG["msgAddContent"] = "Yeni SSS ekle";
$PMF_LANG["msgQuestion"] = "Soru sor";
$PMF_LANG["msgOpenQuestions"] = "Aktif sorular";
$PMF_LANG["msgHelp"] = "Yardım";
$PMF_LANG["msgContact"] = "İletişim";
$PMF_LANG["msgHome"] = "Anasayfa";
$PMF_LANG["msgNews"] = "Duyurular";
$PMF_LANG["msgUserOnline"] = " Çevrimiçi kullanıcı";
$PMF_LANG["msgBack2Home"] = "Anasayfaya dön";

// Contentpages
$PMF_LANG["msgFullCategories"] = "Kategoriler";
$PMF_LANG["msgFullCategoriesIn"] = "Categories with FAQs in ";
$PMF_LANG["msgSubCategories"] = "Alt kategoriler";
$PMF_LANG["msgEntries"] = "SSSler";
$PMF_LANG["msgEntriesIn"] = "Questions in ";
$PMF_LANG["msgViews"] = "görüntüleme";
$PMF_LANG["msgPage"] = "Sayfa ";
$PMF_LANG["msgPages"] = " Sayfa";
$PMF_LANG["msgPrevious"] = "önceki";
$PMF_LANG["msgNext"] = "sonraki";
$PMF_LANG["msgCategoryUp"] = "bir kategori yukarı";
$PMF_LANG["msgLastUpdateArticle"] = "Son güncelleme: ";
$PMF_LANG["msgAuthor"] = "Oluşturan: ";
$PMF_LANG["msgPrinterFriendly"] = "yazıcı uyumlu sürüm";
$PMF_LANG["msgPrintArticle"] = "İçeriği yazdır";
$PMF_LANG["msgMakeXMLExport"] = "XML dosyası olarak dışa aktar";
$PMF_LANG["msgAverageVote"] = "Oy ortalaması";
$PMF_LANG["msgVoteUsability"] = "Bu içeriği oyla";
$PMF_LANG["msgVoteFrom"] = "out of";
$PMF_LANG["msgVoteBad"] = "gereksiz";
$PMF_LANG["msgVoteGood"] = "idare eder";
$PMF_LANG["msgVotings"] = "Oy ";
$PMF_LANG["msgVoteSubmit"] = "Oyla";
$PMF_LANG["msgVoteThanks"] = "Oyunuz için teşekkürler!";
$PMF_LANG["msgYouCan"] = "You can ";
$PMF_LANG["msgWriteComment"] = "comment this FAQ";
$PMF_LANG["msgShowCategory"] = "Content Overview: ";
$PMF_LANG["msgCommentBy"] = "Comment of ";
$PMF_LANG["msgCommentHeader"] = "Comment this FAQ";
$PMF_LANG["msgYourComment"] = "Yorumunuz";
$PMF_LANG["msgCommentThanks"] = "Yorumunuz için teşekkürler!";
$PMF_LANG["msgSend2Friend"] = "Arkadaşınıza önerin";
$PMF_LANG["msgS2FButton"] = "e-mail gönder";

// Search
$PMF_LANG["msgSearchWord"] = "Anahtar kelime";
$PMF_LANG["msgSearchFind"] = "Şu ifade için arama sonucu ";
$PMF_LANG["msgSearchAmount"] = " arama sonucu";
$PMF_LANG["msgSearchAmounts"] = " arama sonucu";
$PMF_LANG["msgSearchCategory"] = "Kategori: ";
$PMF_LANG["msgSearchContent"] = "Cevap: ";

// new Content
$PMF_LANG["msgNewContentHeader"] = "Yeni SSS önerisi";
$PMF_LANG['msgNewContentAddon'] = "Öneriniz hemen görünmeyecek ancak yayınlanmadan önce tarafımızdan kontrol edilecektir. Zorunlu alanlar, * ile işaretlenmiş alanlardır.";
$PMF_LANG["msgNewContentName"] = "Adınız";
$PMF_LANG["msgNewContentMail"] = "E-mail adresiniz";
$PMF_LANG["msgNewContentCategory"] = "Kategori";
$PMF_LANG["msgNewContentTheme"] = "Soru";
$PMF_LANG["msgNewContentArticle"] = "Cevap";
$PMF_LANG["msgNewContentKeywords"] = "Anahtar sözcükler";
$PMF_LANG["msgNewContentLink"] = "Bu soruya ait link";
$PMF_LANG["msgNewContentSubmit"] = "gönder";
$PMF_LANG["msgInfo"] = "Detaylı bilgi: ";
$PMF_LANG["msgNewContentThanks"] = "Katkınız için teşekkürler!";
$PMF_LANG["msgNoQuestionsAvailable"] = "Şu an bekleyen soru bulunmuyor.";

// ask Question
$PMF_LANG["msgNewQuestion"] = "Lütfen aşağıda sorunuzu belirtin";
$PMF_LANG["msgAskCategory"] = "Kategori";
$PMF_LANG["msgAskYourQuestion"] = "ne sormak istersiniz?";
$PMF_LANG["msgAskThx4Mail"] = "Soru için teşekkürler!";
$PMF_LANG["msgDate_User"] = "Tarih / Kullanıcı";
$PMF_LANG["msgQuestion2"] = "Soru";
$PMF_LANG["msg2answer"] = "Cevap";
$PMF_LANG["msgQuestionText"] = "Bu sayfada, diğer kullanıcılar tarafından sorulan soruları görüntüleyebilirsiniz. Dilerseniz, cevabını bildiğiniz soruları yanıtlayarak bilgi bankamıza katkı sağlayabilirsiniz.";

// Contact
$PMF_LANG["msgContactEMail"] = "Site İletişim Formu";
$PMF_LANG["msgMessage"] = "Mesajınız";

// Startseite
$PMF_LANG["msgTopTen"] = "En popüler sorular";
$PMF_LANG["msgHomeThereAre"] = "Toplam ";
$PMF_LANG["msgHomeArticlesOnline"] = " soru bulunuyor";
$PMF_LANG["msgNoNews"] = "Yeni duyuru eklenmemiş.";
$PMF_LANG["msgLatestArticles"] = "En yeni sorular";

// E-Mailbenachrichtigung
$PMF_LANG["msgMailThanks"] = "Katkınız için teşekkürler";
$PMF_LANG["msgMailCheck"] = "Yeni bir içerik mevcut! Lütfen yönetici alanını kontrol edin!";
$PMF_LANG["msgMailContact"] = "Mesajınız yöneticiye gönderildi.";

// Fehlermeldungen
$PMF_LANG["err_noDatabase"] = "Veritabanı bağlantısı başarısız.";
$PMF_LANG["err_noHeaders"] = "Kategori bulunamadı.";
$PMF_LANG["msgErrorNoRecords"] = "Soru bulunamadı.";
$PMF_LANG["err_badID"] = "Geçersiz ID.";
$PMF_LANG["err_noTopTen"] = "Henüz popüler soru bulunmuyor.";
$PMF_LANG["err_nothingFound"] = "Kayıt bulunamadı.";
$PMF_LANG["err_SaveEntries"] = "Doldurulması zorunlu alanlar <strong>adınız</strong>, <strong>e-mail adresiniz</strong>, <strong>kategori</strong>, <strong>soru</strong>, <strong>cevap</strong> ve, eğer isteniyorsa <strong><a href=\"https://en.wikipedia.org/wiki/Captcha\" title=\"Wikipediada Captcha hakkında daha fazlasını oku\" target=\"_blank\">Captcha</a> kodu</strong>!";
$PMF_LANG["err_SaveComment"] = "Doldurulması zorunlu alanlar <strong>adınız</strong>, <strong>e-mail adresiniz</strong>, <strong>yorumunuz</strong> ve, eğer isteniyorsa <strong><a href=\"https://en.wikipedia.org/wiki/Captcha\" title=\"Wikipediada Captcha hakkında daha fazlasını oku\" target=\"_blank\">Captcha</a> kodu</strong>!";
$PMF_LANG["err_VoteTooMuch"] = "Çoklu oylar sayılmamaktadır.";
$PMF_LANG["err_noVote"] = "Soru oylanamadı!";
$PMF_LANG["err_noMailAdress"] = "E-mail adresiniz geçersiz.";
$PMF_LANG["err_sendMail"] = "Doldurulması zorunlu alanlar <strong>adınız</strong>, <strong>e-mail adresiniz</strong>, <strong>sorunuz</strong> ve, eğer isteniyorsa <strong><a href=\"https://en.wikipedia.org/wiki/Captcha\" title=\"Wikipediada Captcha hakkında daha fazlasını oku\" target=\"_blank\">Captcha</a> kodu</strong>!";

// Hilfe zur Suche
$PMF_LANG["help_search"] = "<strong>Arama ipuçları:</strong><br>Şunun gibi kelimeler <strong style=\"color: Red;\">kelime1 kelime2</strong> you can do a relevance descending search for two or more search criterion.<strong>Önemli:</strong> aranacak sözcük en az 4 karakter uzunluğunda olmalıdır.";

// Menu
$PMF_LANG["ad"] = "Yönetim";
$PMF_LANG["ad_menu_user_administration"] = "Kullanıcılar";
$PMF_LANG["ad_menu_entry_aprove"] = "Soru onayla";
$PMF_LANG["ad_menu_entry_edit"] = "Soru düzenle";
$PMF_LANG["ad_menu_categ_add"] = "Kategori ekle";
$PMF_LANG["msgHeaderCategoryOverview"] = "Kategori düzenle";
$PMF_LANG["ad_menu_news_add"] = "Duyuru ekle";
$PMF_LANG["ad_menu_news_edit"] = "Duyurular";
$PMF_LANG["ad_menu_open"] = "Yanıtsız sorular";
$PMF_LANG["ad_menu_stat"] = "İstatistikler";
$PMF_LANG["ad_menu_cookie"] = "Çerezleri ayarla";
$PMF_LANG["ad_menu_session"] = "Oturumları görüntüle";
$PMF_LANG["ad_menu_adminlog"] = "Yönetici günlüğü";
$PMF_LANG["ad_menu_passwd"] = "Parola değiştir";
$PMF_LANG["ad_menu_logout"] = "Çıkış";
$PMF_LANG["ad_menu_startpage"] = "Giriş sayfası";

// Nachrichten
$PMF_LANG["ad_msg_identify"] = "Lütfen kendinizi tanıtın.";
$PMF_LANG["ad_msg_passmatch"] = "Girilen parolalar <strong>aynı</strong> olmalıdır!";
$PMF_LANG["ad_msg_savedsuc_1"] = "Profil sahibi";
$PMF_LANG["ad_msg_savedsuc_2"] = "için yapılan değişiklikler kaydedildi.";
$PMF_LANG["ad_msg_mysqlerr"] = "Oluşan bir <strong>database</strong> hatası sebebiyle değişiklikler kaydedilemedi.";
$PMF_LANG["ad_msg_noauth"] = "Yetkiniz bulunmuyor.";

// Allgemein
$PMF_LANG["ad_gen_page"] = "Sayfa";
$PMF_LANG["ad_gen_of"] = "-";
$PMF_LANG["ad_gen_lastpage"] = "Önceki sayfa";
$PMF_LANG["ad_gen_nextpage"] = "Sonraki sayfa";
$PMF_LANG["ad_gen_save"] = "Kaydet";
$PMF_LANG["ad_gen_reset"] = "Sıfırla";
$PMF_LANG["ad_gen_yes"] = "Evet";
$PMF_LANG["ad_gen_no"] = "Hayır";
$PMF_LANG["ad_gen_top"] = "Sayfa başı";
$PMF_LANG["ad_gen_ncf"] = "Kategori bulunamadı!";
$PMF_LANG["ad_gen_delete"] = "Sil";

// Benutzerverwaltung
$PMF_LANG["ad_user"] = "Kullanıcı yönetimi";
$PMF_LANG["ad_user_username"] = "Kayıtlı kullanıcılar";
$PMF_LANG["ad_user_rights"] = "Kullanıcı yetkileri";
$PMF_LANG["ad_user_edit"] = "düzenle";
$PMF_LANG["ad_user_delete"] = "sil";
$PMF_LANG["ad_user_add"] = "Kullanıcı ekle";
$PMF_LANG["ad_user_profou"] = "Kullanıcı profili";
$PMF_LANG["ad_user_name"] = "İsim";
$PMF_LANG["ad_user_password"] = "Şifre";
$PMF_LANG["ad_user_confirm"] = "Doğrula";
$PMF_LANG["ad_user_rights"] = "Yetkiler";
$PMF_LANG["ad_user_del_1"] = "Kullanıcı";
$PMF_LANG["ad_user_del_2"] = "silinecek?";
$PMF_LANG["ad_user_del_3"] = "Emin misiniz?";
$PMF_LANG["ad_user_deleted"] = "Kullanıcı başarıyla silindi.";
$PMF_LANG["ad_user_checkall"] = "Tümünü seç";

// Beitragsverwaltung
$PMF_LANG["msgHeaderFAQOverview"] = "Soru yönetimi";
$PMF_LANG["ad_entry_id"] = "ID";
$PMF_LANG["ad_entry_topic"] = "Konu";
$PMF_LANG["ad_entry_action"] = "Eylem";
$PMF_LANG["ad_entry_edit_1"] = "Düzenle";
$PMF_LANG["ad_entry_edit_2"] = "";
$PMF_LANG["ad_entry_theme"] = "Soru";
$PMF_LANG["ad_entry_content"] = "Cevap";
$PMF_LANG["ad_entry_keywords"] = "Anahtar sözcükler";
$PMF_LANG["ad_entry_author"] = "Oluşturan";
$PMF_LANG["ad_entry_category"] = "Kategori";
$PMF_LANG["ad_entry_active"] = "Görünür";
$PMF_LANG["ad_entry_date"] = "Tarih";
$PMF_LANG["ad_entry_status"] = "Status der FAQ";
$PMF_LANG["ad_entry_changed"] = "Değişiklik?";
$PMF_LANG["ad_entry_changelog"] = "Değişiklik günlüğü";
$PMF_LANG["ad_entry_commentby"] = "Yorumlayan";
$PMF_LANG["ad_entry_comment"] = "Yorum";
$PMF_LANG["ad_entry_save"] = "kaydet";
$PMF_LANG["msgDelete"] = "Sil";
$PMF_LANG["ad_entry_delcom_1"] = "Şu kullanıcıya ait yorum silinecek";
$PMF_LANG["ad_entry_delcom_2"] = "onaylıyor musunuz??";
$PMF_LANG["ad_entry_commentdelsuc"] = "Yorum <strong>başarıyla</strong> silindi.";
$PMF_LANG["ad_entry_back"] = "İçeriğe geri dön";
$PMF_LANG["ad_entry_commentdelfail"] = "Yorum <strong>başarıyla</strong> silinemedi.";
$PMF_LANG["ad_entry_savedsuc"] = "Değişiklikler <strong>başarıyla</strong> kaydedildi.";
$PMF_LANG["ad_entry_savedfail"] = "Maalesef, bir <strong>database</strong> hatası oluştu.";
$PMF_LANG["ad_entry_del_1"] = "Are you sure that the topic";
$PMF_LANG["ad_entry_del_2"] = "of";
$PMF_LANG["ad_entry_del_3"] = "should be deleted?";
$PMF_LANG["ad_entry_delsuc"] = "Issue <strong>successfully</strong> deleted.";
$PMF_LANG["ad_entry_delfail"] = "Issue was <strong>not deleted</strong>!";
$PMF_LANG["ad_entry_back"] = "Geri";


// Newsverwaltung
$PMF_LANG["ad_news_header"] = "Article header";
$PMF_LANG["ad_news_text"] = "Text of the Record";
$PMF_LANG["ad_news_link_url"] = "Bağlantı";
$PMF_LANG["ad_news_link_title"] = "Bağlantı başlığı";
$PMF_LANG["ad_news_link_target"] = "Bağlantı hedefi";
$PMF_LANG["ad_news_link_window"] = "Bağlantı yeni pencerede açılır";
$PMF_LANG["ad_news_link_faq"] = "Bağlantı soru içerisinde";
$PMF_LANG["ad_news_add"] = "Duyuru girdisi ekle";
$PMF_LANG["ad_news_id"] = "#";
$PMF_LANG["ad_news_headline"] = "Başlık";
$PMF_LANG["ad_news_date"] = "Tarih";
$PMF_LANG["ad_news_action"] = "Eylem";
$PMF_LANG["ad_news_update"] = "güncelle";
$PMF_LANG["ad_news_delete"] = "sil";
$PMF_LANG["ad_news_nodata"] = "Veritabanında kayıt bulunamadı";
$PMF_LANG["ad_news_updatesuc"] = "Duyuru başarıyla güncellendi.";
$PMF_LANG["ad_news_del"] = "Bu duyuru öğesini silmek istediğinizden emin misiniz??";
$PMF_LANG["ad_news_yesdelete"] = "evet, sil!";
$PMF_LANG["ad_news_nodelete"] = "hayır";
$PMF_LANG["ad_news_delsuc"] = "Duyuru öğesi başarıyla silindi.";
$PMF_LANG["ad_news_updatenews"] = "Duyuru öğesi başarıyla güncellendi.";

// Kategorieverwaltung
$PMF_LANG["ad_categ_new"] = "Yeni kategori ekle";
$PMF_LANG["ad_categ_catnum"] = "Kategori no";
$PMF_LANG["ad_categ_subcatnum"] = "Alt kategori no";
$PMF_LANG["ad_categ_nya"] = "<em>henüz geçerli değil!</em>";
$PMF_LANG["ad_categ_titel"] = "Kategori başlığı";
$PMF_LANG["ad_categ_add"] = "Kategori ekle";
$PMF_LANG["ad_categ_existing"] = "Mevcut kategoriler";
$PMF_LANG["ad_categ_id"] = "#";
$PMF_LANG["ad_categ_categ"] = "Kategori";
$PMF_LANG["ad_categ_subcateg"] = "Alt kategori";
$PMF_LANG["ad_categ_titel"] = "Kategori başlığı";
$PMF_LANG["ad_categ_action"] = "Eylem";
$PMF_LANG["ad_categ_update"] = "güncelle";
$PMF_LANG["ad_categ_delete"] = "sil";
$PMF_LANG["ad_categ_updatecateg"] = "Kategori Güncelle";
$PMF_LANG["ad_categ_nodata"] = "Veritabanında kayıt bulunamadı";
$PMF_LANG["msgCategoryRemark"] = "Lütfen dikkat, bir kategoriyi sildiğinizde, kategoriye ait içerikler başka bir kategoriyle eşleştirilinceye kadar görüntülenemezler.";
$PMF_LANG["ad_categ_edit_1"] = "düzenle";
$PMF_LANG["ad_categ_edit_2"] = "Kategori";
$PMF_LANG["ad_categ_added"] = "Kategori eklendi.";
$PMF_LANG["ad_categ_updated"] = "Kategori güncellendi.";
$PMF_LANG["ad_categ_del_yes"] = "evet, sil!";
$PMF_LANG["ad_categ_del_no"] = "hayır!";
$PMF_LANG["ad_categ_deletesure"] = "Bu kategoriyi silmek istediğinizden emin misiniz??";
$PMF_LANG["ad_categ_deleted"] = "Kategori silindi.";

// Cookies
$PMF_LANG["ad_cookie_cookiesuc"] = "Çerez başarıyla <strong>ayarlandı.</strong>";
$PMF_LANG["ad_cookie_already"] = "Çerez daha önceden ayarlanmış. Yapabileceğiniz işlemler şunlar";
$PMF_LANG["ad_cookie_again"] = "Çerezi yeniden ayarla";
$PMF_LANG["ad_cookie_delete"] = "Çerez kaydını sil";
$PMF_LANG["ad_cookie_no"] = "Henüz bir çerez ayarlanmamış. Bir çerez ayarlayarak, giriş bilgilerinizin otomatik hatırlanmasını sağlayabilirsiniz. Gerçekleştirebileceğiniz işlemler";
$PMF_LANG["ad_cookie_set"] = "Çerez ayarla";
$PMF_LANG["ad_cookie_deleted"] = "Çerez başarıyla silindi.";

// Adminlog
$PMF_LANG["ad_adminlog"] = "Yönetici Günlüğü";

// Passwd
$PMF_LANG["ad_passwd_cop"] = "Şifre değiştir";
$PMF_LANG["ad_passwd_old"] = "Eski şifre";
$PMF_LANG["ad_passwd_new"] = "Yeni şifre";
$PMF_LANG["ad_passwd_con"] = "Yeni şifre tekrar";
$PMF_LANG["ad_passwd_change"] = "Şifreyi değiştir";
$PMF_LANG["ad_passwd_suc"] = "Şifre değiştirildi.";
$PMF_LANG["ad_passwd_remark"] = "<strong>DİKKAT:</strong><br>çerez yeniden ayarlanmalıdır!";
$PMF_LANG["ad_passwd_fail"] = "Eski şifre <strong>doğru</strong> girilmeli ve yeni şifreler <strong>eşleşmelidir</strong>.";

// Adduser
$PMF_LANG["ad_adus_adduser"] = "Yeni kullanıcı hesabı ekle";
$PMF_LANG["ad_adus_name"] = "Kullanıcı adı";
$PMF_LANG["ad_adus_password"] = "Şifre";
$PMF_LANG["ad_adus_add"] = "Kullanıcı ekle";
$PMF_LANG["ad_adus_suc"] = "Kullanıcı <strong>başarıyla</strong> eklendi.";
$PMF_LANG["ad_adus_edit"] = "Profili düzenle";
$PMF_LANG["ad_adus_dberr"] = "<strong>veritabanı hatası!</strong>";
$PMF_LANG["ad_adus_exerr"] = "Girilen kullanıcı adı sistemde <strong>kayıtlıdır</strong>.";

// Sessions
$PMF_LANG["ad_sess_id"] = "ID";
$PMF_LANG["ad_sess_sid"] = "Oturum ID";
$PMF_LANG["ad_sess_ip"] = "IP";
$PMF_LANG["ad_sess_time"] = "Zaman";
$PMF_LANG["ad_sess_pageviews"] = "Sayfa görüntüleme";
$PMF_LANG["ad_sess_search"] = "Arama";
$PMF_LANG["ad_sess_sfs"] = "Oturumlarda ara";
$PMF_LANG["ad_sess_s_ip"] = "IP";
$PMF_LANG["ad_sess_s_minct"] = "en az eylem";
$PMF_LANG["ad_sess_s_date"] = "Tarih";
$PMF_LANG["ad_sess_s_after"] = "sonra";
$PMF_LANG["ad_sess_s_before"] = "önce";
$PMF_LANG["ad_sess_s_search"] = "Ara";
$PMF_LANG["ad_sess_session"] = "Oturum";
$PMF_LANG["ad_sess_r"] = "Şunun için arama sonucu";
$PMF_LANG["ad_sess_referer"] = "Referer";
$PMF_LANG["ad_sess_browser"] = "Browser";
$PMF_LANG["ad_sess_ai_rubrik"] = "Kategori";
$PMF_LANG["ad_sess_ai_artikel"] = "Kayıt";
$PMF_LANG["ad_sess_ai_sb"] = "Arama terimi";
$PMF_LANG["ad_sess_ai_sid"] = "Oturum ID";
$PMF_LANG["ad_sess_back"] = "Geri";

// Statistik
$PMF_LANG["ad_rs"] = "Oylama istatistikleri";
$PMF_LANG["ad_rs_rating_1"] = "The ranking of";
$PMF_LANG["ad_rs_rating_2"] = "users shows";
$PMF_LANG["ad_rs_red"] = "Kırmızı";
$PMF_LANG["ad_rs_green"] = "Yeşil";
$PMF_LANG["ad_rs_altt"] = "20% değerinden daha düşük ortalama";
$PMF_LANG["ad_rs_ahtf"] = "%80 değerinden daha yüksek ortalama";
$PMF_LANG["ad_rs_no"] = "Değerlendirme bulunmuyor";

// Auth
$PMF_LANG["ad_auth_insert"] = "Lütfen kullanıcı adı ve şifrenizi girin.";
$PMF_LANG["ad_auth_user"] = "Kullanıcı adı";
$PMF_LANG["ad_auth_passwd"] = "Şifre";
$PMF_LANG["ad_auth_ok"] = "Tamam";
$PMF_LANG["ad_auth_reset"] = "Sıfırla";
$PMF_LANG["ad_auth_fail"] = "Geçersiz kullanıcı adı ya da şifre.";
$PMF_LANG["ad_auth_sess"] = "Oturum ID geçti.";

// Added v0.8 - 24.05.2001 - Bastian - Admin
$PMF_LANG["ad_config_edit"] = "Yapılandırmayı düzenle";
$PMF_LANG["ad_config_save"] = "Yapılandırmayı kaydet";
$PMF_LANG["ad_config_reset"] = "Sıfırla";
$PMF_LANG["ad_config_saved"] = "Yapılandırma seçenekleri başarıyla kaydedildi.";
$PMF_LANG["ad_menu_editconfig"] = "Yapılandırmayı düzenle";
$PMF_LANG["ad_att_none"] = "Eklenti mevcut değil";
$PMF_LANG["ad_att_att"] = "Eklentiler";
$PMF_LANG["ad_att_add"] = "Yeni eklenti ekle";
$PMF_LANG["ad_entryins_suc"] = "Kayıt başarıyla eklendi.";
$PMF_LANG["ad_entryins_fail"] = "Bir hata oluştu.";
$PMF_LANG["ad_att_del"] = "Sil";
$PMF_LANG["ad_att_nope"] = "Eklentiler yalnızca düzenleme sırasında eklenebilir.";
$PMF_LANG["ad_att_delsuc"] = "Seçilen eklenti başarıyla silindi.";
$PMF_LANG["ad_att_delfail"] = "Eklenti silinirken bir hata oluştu.";
$PMF_LANG["ad_entry_add"] = "Yeni soru ekle";

// Added v0.85 - 08.06.2001 - Bastian - Admin
$PMF_LANG["ad_csv_make"] = "Yedekleme fonksiyonu ile, veritabanınızın tam bir kopyasını oluşturabilirsiniz. Oluşturulan yedek dosyasının formatı SQL olduğundan, phpMyAdmin ya da SQL komut satırı istemcisiyle geri yüklenebilir. Yedekleme işleminin ayda en az bir kez yapılması önerilir.";
$PMF_LANG["ad_csv_link"] = "Yedeği indir";
$PMF_LANG["ad_csv_head"] = "Yedek oluştur";
$PMF_LANG["ad_att_addto"] = "Bir eklenti ekle";
$PMF_LANG["ad_att_addto_2"] = "";
$PMF_LANG["ad_att_att"] = "Dosya";
$PMF_LANG["ad_att_butt"] = "Tamam";
$PMF_LANG["ad_att_suc"] = "Dosya başarıyla eklendi.";
$PMF_LANG["ad_att_fail"] = "Dosya eklenirken bir hata oluştu.";
$PMF_LANG["ad_att_close"] = "Pencereyi kapat";

// Added v0.85 - 08.07.2001 - Bastian - Admin
$PMF_LANG["ad_csv_restore"] = "Bu form aracılığıyla, sistem üzerinden daha önceden alınan bir yedeği geri yükleyebilirsiniz. Önemli hatırlatma! geri yükleme sırasında önceki verilerin üzerine yazılacaktır.";
$PMF_LANG["ad_csv_file"] = "Dosya";
$PMF_LANG["ad_csv_ok"] = "Tamam";
$PMF_LANG["ad_csv_linklog"] = "yedekleme günlüğü";
$PMF_LANG["ad_csv_linkdat"] = "Yedekleme";
$PMF_LANG["ad_csv_head2"] = "Geri yükle";
$PMF_LANG["ad_csv_no"] = "Geçerli bir veritabanı yedeği değil.";
$PMF_LANG["ad_csv_prepare"] = "Veritabanı sorguları hazırlanıyor...";
$PMF_LANG["ad_csv_process"] = "Sorgular çalıştırılıyor...";
$PMF_LANG["ad_csv_of"] = "of";
$PMF_LANG["ad_csv_suc"] = "başarılı.";
$PMF_LANG["ad_csv_backup"] = "Yedekleme";
$PMF_LANG["ad_csv_rest"] = "Yedeği geri yükle";

// Added v0.8 - 25.05.2001 - Bastian - Admin
$PMF_LANG["ad_menu_backup"] = "Yedekleme";
$PMF_LANG["ad_logout"] = "Oturum başarıyla sonlandırıldı.";
$PMF_LANG["ad_news_add"] = "Duyuru ekle";
$PMF_LANG["ad_news_edit"] = "Duyuru düzenle";
$PMF_LANG["ad_cookie"] = "Çerezler";
$PMF_LANG["ad_sess_head"] = "Oturumları görüntüle";

// Added v1.1 - 06.01.2002 - Bastian
$PMF_LANG["msgHeaderCategoryOverview"] = "Soru Kategorileri";
$PMF_LANG["ad_menu_stat"] = "Oylama İstatistikleri";
$PMF_LANG["msgAddCategory"] = "Üst seviye kategori ekle";
$PMF_LANG["ad_kateg_rename"] = "Düzenle";
$PMF_LANG["ad_adminlog_date"] = "Tarih";
$PMF_LANG["ad_adminlog_user"] = "Kullanıcı";
$PMF_LANG["ad_adminlog_ip"] = "IP-Adresi";

$PMF_LANG["ad_stat_sess"] = "Oturum";
$PMF_LANG["ad_stat_days"] = "Gün";
$PMF_LANG["ad_stat_vis"] = "Oturum (Ziyaret)";
$PMF_LANG["ad_stat_vpd"] = "Günlük Ziyaret";
$PMF_LANG["ad_stat_fien"] = "İlk Günlük";
$PMF_LANG["ad_stat_laen"] = "Son Günlük";
$PMF_LANG["ad_stat_browse"] = "Oturumlara gözat";
$PMF_LANG["ad_stat_ok"] = "Tamam";

$PMF_LANG["ad_sess_time"] = "Zaman";
$PMF_LANG["ad_sess_sid"] = "ID";
$PMF_LANG["ad_sess_ip"] = "IP";

$PMF_LANG["ad_ques_take"] = "Soruyu yanıtla";
$PMF_LANG["no_cats"] = "Kategori bulunamadı.";

// Added v1.1 - 17.01.2002 - Bastian
$PMF_LANG["ad_log_lger"] = "Geçersiz kullanıcı ya da şifre.";
$PMF_LANG["ad_log_sess"] = "Oturum sona erdi.";
$PMF_LANG["ad_log_edit"] = "\"Edit User\"-Form for the following user: ";
$PMF_LANG["ad_log_crea"] = "\"New article\" form.";
$PMF_LANG["ad_log_crsa"] = "Yeni girdi oluşturuldu.";
$PMF_LANG["ad_log_ussa"] = "Şu kullanıcı için verileri güncelle: ";
$PMF_LANG["ad_log_usde"] = "Şu kullanıcı silindi: ";
$PMF_LANG["ad_log_beed"] = "Şu kullanıcı için düzenle: ";
$PMF_LANG["ad_log_bede"] = "Şu kayıt silindi: ";

$PMF_LANG["msgVisits"] = "Ziyaret";
$PMF_LANG["ad_start_articles"] = "İçerikler";
$PMF_LANG["ad_start_comments"] = "Yorumlar";


// Added v1.1 - 30.01.2002 - Bastian
$PMF_LANG["ad_categ_paste"] = "yapıştır";
$PMF_LANG["ad_categ_cut"] = "kes";
$PMF_LANG["msgCopy"] = "kopyala";
$PMF_LANG["ad_categ_process"] = "Kategoriler işleniyor...";

// Added v1.1.4 - 07.05.2002 - Thorsten
$PMF_LANG["err_NotAuth"] = "<strong>Yetkiniz bulunmuyor.</strong>";

// Added v1.2.3 - 29.11.2002 - Thorsten
$PMF_LANG["msgPreviusPage"] = "Önceki sayfa";
$PMF_LANG["msgNextPage"] = "Sonraki sayfa";
$PMF_LANG["msgPageDoublePoint"] = "Sayfa: ";
$PMF_LANG["msgMainCategory"] = "Ana kategori";

// Added v1.2.4 - 30.01.2003 - Thorsten
$PMF_LANG["ad_passwdsuc"] = "Şifreniz değiştirildi.";

// Added v1.3.0 - 04.03.2003 - Thorsten
$PMF_LANG["ad_xml_gen"] = "XML çıktısı oluştur";
$PMF_LANG["ad_entry_locale"] = "Dil";
$PMF_LANG["msgLanguageSubmit"] = "Dil değiştir";

// Added v1.3.1 - 29.04.2003 - Thorsten
$PMF_LANG["ad_attach_4"] = "Eklenti en fazla %s Byte olmalıdır.";
$PMF_LANG["ad_menu_export"] = "Soruları dışa aktar";

$PMF_LANG['permission::add_user'] = "Kullanıcı ekle";
$PMF_LANG['permission::edit_user'] = "Kullanıcı düzenle";
$PMF_LANG['permission::delete_user'] = "Kullanıcı sil";
$PMF_LANG['permission::add_faq'] = "Kayıt ekle";
$PMF_LANG['permission::edit_faq'] = "Kayıt düzenle";
$PMF_LANG['permission::delete_faq'] = "Kayıt sil";
$PMF_LANG['permission::viewlog'] = "Günlüğü görüntüle";
$PMF_LANG['permission::adminlog'] = "Yönetici günlüğünü görüntüle";
$PMF_LANG['permission::delcomment'] = "Yorumu silDelete comment";
$PMF_LANG['permission::addnews'] = "Duyuru ekle";
$PMF_LANG['permission::editnews'] = "Duyuru düzenle";
$PMF_LANG['permission::delnews'] = "Duyuru sil";
$PMF_LANG['permission::addcateg'] = "Kategori ekle";
$PMF_LANG['permission::editcateg'] = "Kategori düzenle";
$PMF_LANG['permission::delcateg'] = "Kategori sil";
$PMF_LANG['permission::passwd'] = "Şifre değiştir";
$PMF_LANG['permission::editconfig'] = "Yapılandırmayı düzenle";
$PMF_LANG['permission::addatt'] = "Eklenti ekle";
$PMF_LANG['permission::delatt'] = "Eklenti sil";
$PMF_LANG['permission::backup'] = "Yedek oluştur";
$PMF_LANG['permission::restore'] = "Yedeği geri yükle";
$PMF_LANG['permission::delquestion'] = "Yanıtsız soruları sil";
$PMF_LANG['permission::changebtrevs'] = "Sürümleri düzenle";

$PMF_LANG["msgAttachedFiles"] = "Ekli dosyalar";

// Added v1.3.3 - 27.05.2003 - Thorsten
$PMF_LANG["ad_user_action"] = "Eylem";
$PMF_LANG["msgEmail"] = "Email";
$PMF_LANG["ad_entry_allowComments"] = "Yorumlara izin ver";
$PMF_LANG["msgWriteNoComment"] = "Bu içerik için yorum yapamazsınız";
$PMF_LANG["msgRealname"] = "Gerçek adınız";
$PMF_LANG["ad_export_generate_pdf"] = "PDF oluştur";
$PMF_LANG["ad_export_full_faq"] = "soruların PDf çıktısı: ";
$PMF_LANG["err_bannedIP"] = "IP adresiniz yasaklandı.";
$PMF_LANG["err_SaveQuestion"] = "Doldurulması zorunlu alanlar <strong>adınız</strong>, <strong>e-mail adresiniz</strong>, <strong>sorunuz</strong> ve, eğer isteniyorsa <strong><a href=\"https://en.wikipedia.org/wiki/Captcha\" title=\"Wikipediada Captcha hakkında daha fazlasını oku\" target=\"_blank\">Captcha</a> kodu</strong>!";

// added v1.4.0 - 2003-12-04 by Thorsten / Mathias
$LANG_CONF['main.language'] = array("select", "Language");
$LANG_CONF["main.languageDetection"] = array("checkbox", "Enable automatic language detection");
$LANG_CONF['main.titleFAQ'] = array("input", "Title of your FAQ");
$LANG_CONF['main.currentVersion'] = array("print", "phpMyFAQ Version");
$LANG_CONF["main.metaDescription"] = array("input", "Description");
$LANG_CONF["main.metaPublisher"] = array("input", "Name of the Publisher");
$LANG_CONF['main.administrationMail'] = array("input", "Email address of the Admin");
$LANG_CONF["main.contactInformation"] = array("area", "Contact information");
$LANG_CONF["main.send2friendText"] = array("area", "Text for the send to friend page");
$LANG_CONF['records.maxAttachmentSize'] = array("input", "Maximum size for attachments in Bytes (max. %sByte)");
$LANG_CONF["records.disableAttachments"] = array("checkbox", "Enable visibilty of attachments");
$LANG_CONF["main.enableUserTracking"] = array("checkbox", "Enable user tracking");
$LANG_CONF["main.enableAdminLog"] = array("checkbox", "use Adminlog?");
$LANG_CONF["main.enableCategoryRestrictions"] = array("checkbox", "Enable category restrictions");
$LANG_CONF["security.ipCheck"] = array("checkbox", "Check the IP in administration");
$LANG_CONF["records.numberOfRecordsPerPage"] = array("input", "Number of displayed topics per page");
$LANG_CONF["records.numberOfShownNewsEntries"] = array("input", "Number of news articles");
$LANG_CONF['security.bannedIPs'] = array("area", "Ban these IPs");
$LANG_CONF["ldap.ldapSupport"] = array("checkbox", "Enable LDAP support? (default: disabled)");
$LANG_CONF["main.referenceURL"] = array("input", "URL of your FAQ (e.g.: https://www.example.org/faq/)");
$LANG_CONF["main.urlValidateInterval"] = array("input", "Interval between AJAX link verification (in seconds)");
$LANG_CONF["records.enableVisibilityQuestions"] = array("checkbox", "Disable visibility of new questions?");
$LANG_CONF['security.permLevel'] = array("select", "Permission level");

$PMF_LANG["ad_categ_new_main_cat"] = "ana kategori olarak";
$PMF_LANG["ad_categ_paste_error"] = "Bu kategori taşınamaz.";
$PMF_LANG["ad_categ_move"] = "Kategori taşı";
$PMF_LANG["ad_categ_lang"] = "Dil";
$PMF_LANG["ad_categ_desc"] = "Açıklama";
$PMF_LANG["ad_categ_change"] = "Şununla değiştir";

$PMF_LANG["lostPassword"] = "Şifrenizi mi unuttunuz?";
$PMF_LANG["lostpwd_err_1"] = "Hata: kullanıcı adı ve email adresi bulunamadı.";
$PMF_LANG["lostpwd_err_2"] = "Hata: geçersiz girdi!";
$PMF_LANG["lostpwd_text_1"] = "Talebiniz alındı.";
$PMF_LANG["lostpwd_text_2"] = "Lütfen yönetici panelinden yeni bir kişisel şifre belirleyiniz.";
$PMF_LANG["lostpwd_mail_okay"] = "Email gönderildi.";

$PMF_LANG["msgButtonFetchLatestVersion"] = "Sistem sürümünü kontrol etmek için tıklayın";
$PMF_LANG["ad_xmlrpc_latest"] = "Yeni sürüm kullanılabilir durumda";

// added v1.5.0 - 2005-07-31 by Thorsten
$PMF_LANG['ad_categ_select'] = "Kategori dilini seç";

// added v1.5.1 - 2005-09-06 by Thorsten
$PMF_LANG['msgSitemap'] = "Site haritası";

// added v1.5.2 - 2005-09-23 by Lars
$PMF_LANG['err_inactiveArticle'] = "Bu girdi görüntülenemez.";
$PMF_LANG['msgArticleCategories'] = "Bu girdiye ait kategoriler";

// added v1.6.0 - 2006-02-02 by Thorsten
$PMF_LANG['ad_entry_solution_id'] = "Benzersiz çözüm ID";
$PMF_LANG['ad_entry_faq_record'] = "Soru kaydı";
$PMF_LANG['ad_entry_new_revision'] = "Yeni sürüm oluştur?";
$PMF_LANG['ad_entry_record_administration'] = "Kayıt yönetimi";
$PMF_LANG['ad_entry_changelog'] = "Değişiklik günlüğü";
$PMF_LANG['ad_entry_revision'] = "Sürüm";
$PMF_LANG['ad_changerev'] = "Sürüm seç";
$PMF_LANG['msgCaptcha'] = "Lütfen güvenlik kodunu girin";
$PMF_LANG['msgSelectCategories'] = "Şurada ara...";
$PMF_LANG['msgAllCategories'] = "... tüm kategoriler";
$PMF_LANG['ad_you_should_update'] = "Yazılım sürümü eski, lütfen PHPMyFAQ sürümünüzü güncelleyin.";
$PMF_LANG['msgAdvancedSearch'] = "Gelişmiş arama";

// added v1.6.1 - 2006-04-25 by Matteoï and Thorsten
$PMF_LANG['spamControlCenter'] = "Spam kontrol merkezi";
$LANG_CONF["spam.enableSafeEmail"] = array("checkbox", "Print user email in a safe way.");
$LANG_CONF["spam.checkBannedWords"] = array("checkbox", "Check public form content against banned words.");
$LANG_CONF["spam.enableCaptchaCode"] = array("checkbox", "Use a captcha code to allow public form submission.");
$PMF_LANG['ad_session_expiring'] = "Oturumunuz %d dakika içerisinde sona erecek. çalışmaya devam etmek istiyor musunuz?";

// added v1.6.2 - 2006-06-13 by Matteo
$PMF_LANG['ad_stat_management'] = "Oturum yönetimi";
$PMF_LANG['ad_stat_choose'] = "Ay seçin";
$PMF_LANG['ad_stat_delete'] = "Seçilen oturumları hemen silmek istiyor musunuz?";

// added v2.0.0 - 2005-09-15 by Thorsten and by Minoru TODA
$PMF_LANG['ad_menu_glossary'] = "Terimler sözlüğü";
$PMF_LANG['ad_glossary_add'] = "Yeni terim ekle";
$PMF_LANG['ad_glossary_edit'] = "Terim düzenle";
$PMF_LANG['ad_glossary_item'] = "Başlık";
$PMF_LANG['ad_glossary_definition'] = "Açıklama";
$PMF_LANG['ad_glossary_save'] = "Kaydet";
$PMF_LANG['ad_glossary_save_success'] = "Terim başarıyla eklendi!";
$PMF_LANG['ad_glossary_save_error'] = "Terim eklenirken bir hata oluştu.";
$PMF_LANG['ad_glossary_update_success'] = "Terim başarıyla güncellendi!";
$PMF_LANG['ad_glossary_update_error'] = "Terim güncellenirken bir hata oluştu.";
$PMF_LANG['ad_glossary_delete'] = "Terimi sil";
$PMF_LANG['ad_glossary_delete_success'] = "Terim başarıyla silindi!";
$PMF_LANG['ad_glossary_delete_error'] = "Terim silinirken bir hata oluştu.";
$PMF_LANG['msgNewQuestionVisible'] = "Soru yayınlanmadan önce editör onayından geçmelidir.";
$PMF_LANG['msgQuestionsWaiting'] = "Yönetici tarafından yayına alınması beklenen: ";
$PMF_LANG['ad_entry_visibility'] = "Yayında?";

// added v2.0.0 - 2006-01-02 by Lars
$PMF_LANG['ad_user_error_password'] = "Please enter a password. ";
$PMF_LANG['ad_user_error_passwordsDontMatch'] = "Passwords do not match. ";
$PMF_LANG['ad_user_error_loginInvalid'] = "The specified user name is invalid.";
$PMF_LANG['ad_user_error_noEmail'] = "Please enter a valid mail address. ";
$PMF_LANG['ad_user_error_noRealName'] = "Please enter your real name. ";
$PMF_LANG['ad_user_error_delete'] = "User account could not be deleted. ";
$PMF_LANG['ad_user_error_noId'] = "No ID specified. ";
$PMF_LANG['ad_user_error_protectedAccount'] = "User account is protected. ";
$PMF_LANG['ad_user_deleteUser'] = "Kullanıcı Sil";
$PMF_LANG['ad_user_status'] = "Durum";
$PMF_LANG['ad_user_lastModified'] = "Son değişiklik";
$PMF_LANG['ad_gen_cancel'] = "İptal";
$PMF_LANG['permission::addglossary'] = "Sözlük girdisi ekle";
$PMF_LANG['permission::editglossary'] = "Sözlük girdisi düzenle";
$PMF_LANG['permission::delglossary'] = "Sözlük girdisi sil";
$PMF_LANG["ad_menu_group_administration"] = "Gruplar";
$PMF_LANG['ad_user_loggedin'] = "Giriş yapan kullanıcı ";
$PMF_LANG['ad_group_details'] = "Grup Ayrıntıları";
$PMF_LANG['ad_group_add'] = "Grup Ekle";
$PMF_LANG['ad_group_add_link'] = "Grup Ekle";
$PMF_LANG['ad_group_name'] = "Grup adı";
$PMF_LANG['ad_group_description'] = "Grup açıklaması";
$PMF_LANG['ad_group_autoJoin'] = "Otomatik-katılım";
$PMF_LANG['ad_group_suc'] = "Grup <strong>başarıyla</strong> eklendi.";
$PMF_LANG['ad_group_error_noName'] = "Lütfen grup adı girin. ";
$PMF_LANG['ad_group_error_delete'] = "Grup silinemedi. ";
$PMF_LANG['ad_group_deleted'] = "Grup başarıyla silindi";
$PMF_LANG['ad_group_deleteGroup'] = "Grubu sil";
$PMF_LANG['ad_group_deleteQuestion'] = "Bu grubu silmek istediğinizden emin misiniz?";
$PMF_LANG['ad_user_uncheckall'] = "Tümünü Seç";
$PMF_LANG['ad_group_membership'] = "Grup Üyeliği";
$PMF_LANG['ad_group_members'] = "Üyeler";
$PMF_LANG['ad_group_addMember'] = "ekle";
$PMF_LANG['ad_group_removeMember'] = "çıkar";

// added v2.0.0 - 2006-07-20 by Matteo
$PMF_LANG['ad_export_which_cat'] = "Dışa aktarılacak veri sayısını sınırla (isteğe bağlı)";
$PMF_LANG['ad_export_cat_downwards'] = "Alt kategoriler de eklensin mi?";
$PMF_LANG['ad_export_type'] = "Dışa aktarma biçimi";
$PMF_LANG['ad_export_type_choose'] = "Desteklenen biçimler";
$PMF_LANG['ad_export_download_view'] = "İndir veya görüntüle?";
$PMF_LANG['ad_export_download'] = "İndir";
$PMF_LANG['ad_export_view'] = "Online görüntüle";
$PMF_LANG['ad_export_gen_xhtml'] = "XHTML dosyası oluştur";

// added v2.0.0 - 2006-07-22 by Matteo
$PMF_LANG['ad_news_data'] = "Duyurular";
$PMF_LANG['ad_news_author_name'] = "Yazan";
$PMF_LANG['ad_news_author_email'] = "Email";
$PMF_LANG['ad_news_set_active'] = "Aktifleştir";
$PMF_LANG['ad_news_allowComments'] = "Yorumlara izin ver";
$PMF_LANG['ad_news_expiration_window'] = "Duyuru geçerlilik süresi (isteğe bağlı)";
$PMF_LANG['ad_news_from'] = "Şu tarihten";
$PMF_LANG['ad_news_to'] = "Şu tarihe";
$PMF_LANG['ad_news_insertfail'] = "Duyuru eklenirken bir hata oluştu.";
$PMF_LANG['ad_news_updatefail'] = "Duyuru güncellenirken bir hata oluştu.";
$PMF_LANG['newsShowCurrent'] = "Geçerli duyuruları görüntüle.";
$PMF_LANG['newsShowArchive'] = "Arşivlenen duyuruları görüntüle.";
$PMF_LANG['newsArchive'] = " Duyuru arşivi";
$PMF_LANG['newsWriteComment'] = "Bu girdiye ait yorumlar";
$PMF_LANG['newsCommentDate'] = "Eklenme: ";

// added v2.0.0 - 2006-07-29 by Matteo & Thorsten
$PMF_LANG['ad_record_expiration_window'] = "Kayıt geçerlilik zamanı (isteğe bağlı)";
$PMF_LANG['adminHeaderDashboard'] = "Anasayfa";
$PMF_LANG['admin_mainmenu_users'] = "Kullanıcılar";
$PMF_LANG['admin_mainmenu_content'] = "İçerik";
$PMF_LANG['admin_mainmenu_statistics'] = "İstatistikler";
$PMF_LANG['admin_mainmenu_backup'] = "Yedekleme";
$PMF_LANG['admin_mainmenu_configuration'] = "Yapılandırma";
$PMF_LANG['admin_mainmenu_logout'] = "Çıkış";

// added v2.0.0 - 2006-08-15 by Thorsten and Matteo
$PMF_LANG["ad_categ_owner"] = "Kategori sahibi";
$PMF_LANG['adminSection'] = "Yönetim";
$PMF_LANG['err_expiredArticle'] = "Bu girdinin geçerlilik tarihi sona erdi ve görüntülenemez";
$PMF_LANG['err_expiredNews'] = "Bu duyurunun geçerlilik tarihi sona erdi ve görüntülenemez";
$PMF_LANG['err_inactiveNews'] = "Bu duyuru taslak halinde olduğundan görüntülenemez";
$PMF_LANG['msgSearchOnAllLanguages'] = "tüm dillerde ara";
$PMF_LANG['ad_entry_tags'] = "Etiketler";
$PMF_LANG['msg_tags'] = "Etiketler";

// added v2.0.0 - 2006-09-02 by Thomas
$PMF_LANG['msg_related_articles'] = "İlişkili gönderiler";
$LANG_CONF['records.numberOfRelatedArticles'] = array("input", "Number of related entries");

// added v2.0.0 - 2006-09-09 by Rudi
$PMF_LANG['ad_categ_trans_1'] = "Çevir";
$PMF_LANG['ad_categ_trans_2'] = "Kategori";
$PMF_LANG['ad_categ_translatecateg'] = "Kategoriyi çevir";
$PMF_LANG['ad_categ_translate'] = "Çevir";
$PMF_LANG['ad_categ_transalready'] = "Şuna çevrilmiş: ";
$PMF_LANG["ad_categ_deletealllang"] = "Tüm dillerden sil?";
$PMF_LANG["ad_categ_deletethislang"] = "Yalnızca bu dilden sil?";
$PMF_LANG["ad_categ_translated"] = "Kategori tercüme edildi.";

// added v2.0.0 - 2006-09-21 by Rudi
$PMF_LANG["msgCategoryMatrix"] = "Kategori özeti";
$PMF_LANG['ad_menu_categ_structure'] = "Kategori özeti ilgili dilleri de kapsar";

// added v2.0.0 - 2006-09-26 by Thorsten
$PMF_LANG['ad_entry_userpermission'] = "Kullanıcı izinleri";
$PMF_LANG['ad_entry_grouppermission'] = "Grup izinleri";
$PMF_LANG['ad_entry_all_users'] = "Tüm kullanıcılara izin ver";
$PMF_LANG['ad_entry_restricted_users'] = "Şu kullanıcıyla sınırlandır";
$PMF_LANG['ad_entry_all_groups'] = "Tüm gruplara izin ver";
$PMF_LANG['ad_entry_restricted_groups'] = "Şu grupla sınırlandır";
$PMF_LANG['ad_session_expiration'] = "Oturum sonlanma zamanı";
$PMF_LANG['ad_user_active'] = "Etkin";
$PMF_LANG['ad_user_blocked'] = "Yasaklı";
$PMF_LANG['ad_user_protected'] = "Korumalı";

// added v2.0.0 - 2006-10-07 by Matteo
$PMF_LANG['ad_entry_intlink'] = "Bağlantı olarak eklemek istediğiniz içeriği seçin...";

//added 2.0.0 - 2006-10-10 by Rudi
$PMF_LANG["ad_categ_paste2"] = "Kendisinden sonra yapıştır";
$PMF_LANG["msgCategoryRemark_overview"] = "Eğer dil ayarları doğru yapılandırıldıysa (ilk sütunda), kategori sıralaması doğru olarak gösterilir.";

// added v2.0.0 - 2006-10-15 by Matteo
$PMF_LANG['msgUsersOnline'] = "%d Ziyaretçi ve %d Kayıtlı";
$PMF_LANG['ad_adminlog_del_older_30d'] = "30 günden eski günlük kayıtlarını sil";
$PMF_LANG['ad_adminlog_delete_success'] = "Eski günlük kayıtları başarıyla silindi.";
$PMF_LANG['ad_adminlog_delete_failure'] = "Günlük kayıtları silinirken bir hata oluştu.";

// added 2.0.0 - 2006-11-19 by Thorsten
$PMF_LANG['ad_quicklinks'] = "Hızlı linkller";
$PMF_LANG['ad_quick_category'] = "Yeni kategori ekle";
$PMF_LANG['ad_quick_record'] = "Yeni soru girdisi ekle";
$PMF_LANG['ad_quick_user'] = "Yeni kullanıcı ekle";
$PMF_LANG['ad_quick_group'] = "Yeni grup ekle";

// added v2.0.0 - 2006-12-30 by Matteo
$PMF_LANG['msgNewTranslationHeader'] = "Çeviri öner";
$PMF_LANG['msgNewTranslationAddon'] = "Çeviri öneriniz kaydedilecek, ancak yönetici onayından sonra yayınlanacaktır. doldurulması zorunlu alanlar: <strong>isim</strong>, <strong>e-mail adresi</strong>, <strong>soru çevirisi</strong> ve <strong>cevap çevirisi</strong>. lütfen anahtar kelimeleri virgülle ayırın.";
$PMF_LANG['msgNewTransSourcePane'] = "Kaynak";
$PMF_LANG['msgNewTranslationPane'] = "Çeviri";
$PMF_LANG['msgNewTranslationName'] = "Adınız";
$PMF_LANG['msgNewTranslationMail'] = "E-mail adresiniz";
$PMF_LANG['msgNewTranslationKeywords'] = "Anahtar sözcükler";
$PMF_LANG['msgNewTranslationSubmit'] = "Öneride bulun";
$PMF_LANG['msgTranslate'] = "Çevir";
$PMF_LANG['msgTranslateSubmit'] = "Çeviriye başla...";
$PMF_LANG['msgNewTranslationThanks'] = "Çeviriye katkıda bulunduğunuz için teşekkürler!";

// added v2.0.0 - 2007-02-27 by Matteo
$PMF_LANG['permission::addgroup'] = "Grup hesabı ekle";
$PMF_LANG['permission::editgroup'] = "Grup hesaplarını düzenle";
$PMF_LANG['permission::delgroup'] = "Grup hesaplarını sil";

// added v2.0.0 - 2007-02-27 by Thorsten
$PMF_LANG['ad_news_link_parent'] = "Bağlantı yeni sekmede açılır";

// added v2.0.0 - 2007-03-04 by Thorsten
$PMF_LANG['ad_menu_comments'] = "yorumlar";
$PMF_LANG['adminHeaderComments'] = "Yorum moderasyonu";
$PMF_LANG['msgAdminCommentFaqs'] = "Soru yorumları";
$PMF_LANG['msgAdminCommentNews'] = "Duyuru yorumları";
$PMF_LANG['msgPDF'] = "PDF versiyonu";
$PMF_LANG['ad_groups'] = "Gruplar";

// added v2.0.0 - 2007-03-10 by Thorsten
$LANG_CONF['records.orderby'] = array('select', 'Record sorting (according to property)');
$LANG_CONF['records.sortby'] = array('select', 'Record sorting (descending or ascending)');
$PMF_LANG['ad_conf_order_id'] = "ID (varsayılan)";
$PMF_LANG['ad_conf_order_thema'] = "Başlık";
$PMF_LANG['ad_conf_order_visits'] = "Ziyaretçi sayısı";
$PMF_LANG['ad_conf_order_updated'] = "Tarih";
$PMF_LANG['ad_conf_order_author'] = "Yazar";
$PMF_LANG['ad_conf_desc'] = "eskiden yeniye";
$PMF_LANG['ad_conf_asc'] = "yeniden eskiye";
$PMF_LANG['mainControlCenter'] = "AnasayfaMain";
$PMF_LANG['recordsControlCenter'] = "Sorular";

// added v2.0.0 - 2007-03-29 by Thorsten
$LANG_CONF['records.defaultActivation'] = array("checkbox", "Activate new records");
$LANG_CONF['records.defaultAllowComments'] = array("checkbox", "Allow comments for new records<br>(default: disallowed)");

// added v2.0.0 - 2007-04-04 by Thorsten
$PMF_LANG['msgAllCatArticles'] = "Bu kategorideki sorular";
$PMF_LANG['msgTagSearch'] = "Etiketli gönderiler";
$PMF_LANG['ad_pmf_info'] = "phpMyFAQ Bilgisi";
$PMF_LANG['msgOnlineVersionCheck'] = "Online versiyon kontrolü";
$PMF_LANG['ad_system_info'] = "System Bilgisi";

// added 2.5.0-alpha - 2008-01-25 by Elger
$PMF_LANG['msgRegisterUser'] = "Kayıt ol";
$PMF_LANG["msgUsername"] = "Kullanıcı adı";
$PMF_LANG['errorRegistration'] = "Bu alan zorunludur!";
$PMF_LANG['submitRegister'] = "Kaydı tamamla";
$PMF_LANG['msgUserData'] = "Kullanıcı hesabı için gereken bilgiler";
$PMF_LANG['captchaError'] = "Lütfen güvenlik kodunu kontrol edin!";
$PMF_LANG['msgRegError'] = "Aşağıdaki hatalar oluştu, lütfen devam etmeden önce bu hataları düzeltin";
$PMF_LANG['successMessage'] = "Kullanıcı hesabınız başarıyla oluşturuldu. Kısa süre içerisinde giriş bilgilerinizi içeren bir e-posta alacaksınız!";
$PMF_LANG['msgRegThankYou'] = "Kayıt olduğunuz için teşekkürler!";
$PMF_LANG['emailRegSubject'] = "[%sitename%] Kullanıcı hesabınız hakkında";

// added 2.5.0-alpha2 - 2009-01-24 by Thorsten
$PMF_LANG['msgMostPopularSearches'] = "En çok aranan içerikler";
$LANG_CONF['main.enableWysiwygEditor'] = array("checkbox", "Enable bundled WYSIWYG editor");

// added 2.5.0-beta - 2009-03-30 by Anatoliy
$PMF_LANG['ad_menu_searchstats'] = "Arama İstatistikleri";
$PMF_LANG['ad_searchstats_search_term'] = "Sözcük";
$PMF_LANG['ad_searchstats_search_term_count'] = "Aranma";
$PMF_LANG['ad_searchstats_search_term_lang'] = "Dil";
$PMF_LANG['ad_searchstats_search_term_percentage'] = "Yüzde";

// added 2.5.0-beta - 2009-03-31 by Anatoliy
$PMF_LANG['ad_record_sticky'] = "Sabitlenmiş";
$PMF_LANG['ad_entry_sticky'] = "Sabitlenmiş";
$PMF_LANG['stickyRecordsHeader'] = "Sabitlenmiş içerikler";

// added 2.5.0-beta - 2009-04-01 by Anatoliy
$PMF_LANG['ad_menu_stopwordsconfig'] = "Yasaklı Kelimeler";
$PMF_LANG['ad_config_stopword_input'] = "Yeni kelime ekle";

// added 2.5.0-beta - 2009-04-06 by Anatoliy
$PMF_LANG['msgSendMailDespiteEverything'] = "Hayır, aranılan cevap mevcut değil (e-posta gönderilecek)";
$PMF_LANG['msgSendMailIfNothingIsFound'] = "Aradığınız cevap arama sonuçlarında mevcut mu?";

// added 2.5.0-RC - 2009-05-11 by Anatoliy & Thorsten
$PMF_LANG['msgChooseLanguageToTranslate'] = "Lütfen tercüme için bir dil seçin";
$PMF_LANG['ad_menu_translations'] = "Arayüz Çevirisi";
$PMF_LANG['ad_start_notactive'] = "Etkinleştirme bekleniyor";

// added 2.5.0-RC - 2009-05-20 by Anatoliy
$PMF_LANG['msgTransToolAddNewTranslation'] = "Yeni çeviri ekle";
$PMF_LANG['msgTransToolLanguage'] = "Dil";
$PMF_LANG['msgTransToolActions'] = "Eylemler";
$PMF_LANG['msgTransToolWritable'] = "Yazılabilir";
$PMF_LANG['msgEdit'] = "Düzenle";
$PMF_LANG['msgDelete'] = "Sil";
$PMF_LANG['msgYes'] = "Evet";
$PMF_LANG['msgNo'] = "Hayır";
$PMF_LANG['msgVariable'] = "Değişken";
$PMF_LANG['msgCancel'] = "İptal";
$PMF_LANG['msgSave'] = "kaydet";
$PMF_LANG['msgSaving3Dots'] = "Kaydediliyor...";
$PMF_LANG['msgRemoving3Dots'] = "Siliniyor...";
$PMF_LANG['msgLanguage'] = "Dil";
$PMF_LANG['msgTransToolLanguageCharset'] = "Karakter kümesi";
$PMF_LANG['msgTransToolLanguageDir'] = "dil yönü";
$PMF_LANG['msgTransToolLanguageDesc'] = "Dil açıklaması";
$PMF_LANG['msgAuthor'] = "Çevirmen";
$PMF_LANG['msgTransToolAddAuthor'] = "Çevirmen ekle";
$PMF_LANG['msgTransToolCreateTranslation'] = "Çeviri oluştur";
$PMF_LANG['msgTransToolTransCreated'] = "Yeni çeviri başarıyla oluşturulduNew translation successfully created";
$PMF_LANG['msgTransToolCouldntCreateTrans'] = "Yeni çeviri oluşturulamadı";
$PMF_LANG['msgAdding3Dots'] = "Ekleniyor ...";
$PMF_LANG['msgTransToolSendToTeam'] = "phpMyFAQ takımına gönder";
$PMF_LANG['msgSending3Dots'] = "gönderiliyor ...";
$PMF_LANG['msgTransToolFileSent'] = "Dil dosyası phpMyFAQ takımına başarıyla gönderildi. Katkınız için teşekkür ederiz.";
$PMF_LANG['msgTransToolErrorSendingFile'] = "Dil dosyası gönderilirken hata oluştu";
$PMF_LANG['msgTransToolPercent'] = "Yüzde";

// added 2.5.0-RC3 - 2009-06-23 by Anatoliy
$LANG_CONF['records.attachmentsPath'] = array("input", "Path where attachments will be saved.<br><small>Relative path means a folder within web root</small>");

// added 2.5.0-RC3 - 2009-06-24 by Anatoliy
$PMF_LANG['msgAttachmentNotFound'] = "İndirmeye çalıştığınız dosya sunucuda mevcut değil";
$PMF_LANG['ad_sess_noentry'] = "Kayıt bulunamadı";

// added 2.6.0-alpha - 2009-07-30 by Aurimas Fišeras
//P.S. "One User online" is also possible, since sprintf just ignores extra args
$PMF_LANG["plmsgUserOnline"][0] = "%d kullanıcı çevrimiçi";
$PMF_LANG["plmsgUserOnline"][1] = "%d kullanıcı çevrimiçi";

// added 2.6.0-alpha - 2009-08-02 by Anatoliy
$LANG_CONF['layout.templateSet'] = array("select", "Template set to be used");

// added 2.6.0-alpha - 2009-08-16 by Aurimas Fišeras - Plural messages
$PMF_LANG["plmsgHomeArticlesOnline"][0] = "Toplam %d içerik mevcut";
$PMF_LANG["plmsgHomeArticlesOnline"][1] = "Toplam %d içerik mevcut";
$PMF_LANG["plmsgViews"][0] = "%d görüntüleme";
$PMF_LANG["plmsgViews"][1] = "%d görüntüleme";

// added 2.6.0-alpha - 2009-08-30 by Aurimas Fišeras - Plural messages
$PMF_LANG['plmsgGuestOnline'][0] = "%d Ziyaretçi";
$PMF_LANG['plmsgGuestOnline'][1] = "%d Ziyaretçi";
$PMF_LANG['plmsgRegisteredOnline'][0] = " ve %d Kayıtlı";
$PMF_LANG['plmsgRegisteredOnline'][1] = " ve %d Kayıtlı";
$PMF_LANG["plmsgSearchAmount"][0] = "%d arama sonucu";
$PMF_LANG["plmsgSearchAmount"][1] = "%d arama sonucu";
$PMF_LANG["plmsgPagesTotal"][0] = " %d Sayfa";
$PMF_LANG["plmsgPagesTotal"][1] = " %d Sayfa";
$PMF_LANG["plmsgVotes"][0] = "%d Oy";
$PMF_LANG["plmsgVotes"][1] = "%d Oy";
$PMF_LANG["plmsgEntries"][0] = "%d Soru";
$PMF_LANG["plmsgEntries"][1] = "%d Soru";

// added 2.6.0-alpha - 2009-09-06 by Aurimas Fišeras
$PMF_LANG['permission::addtranslation'] = "çeviri ekle";
$PMF_LANG['permission::edittranslation'] = "çeviri düzenle";
$PMF_LANG['permission::deltranslation'] = "çeviri sil";
$PMF_LANG['permission::approverec'] = "kayıt onayla";

// added 2.6.0-alpha - 2009-09-9 by Anatoliy Belsky
$LANG_CONF["records.enableAttachmentEncryption"] = array("checkbox", "Enable attachment encryption <br><small>Ignored when attachments is disabled</small>");
$LANG_CONF["records.defaultAttachmentEncKey"] = array("input", 'Default attachment encryption key <br><small>Ignored if attachment encryption is disabled</small><br><small><^font color="red">WARNING: Do not change this once set and enabled file encryption!!!</font></small>');

// added 2.6.0-alpha - 2009-09-06 by Thorsten
$PMF_LANG['ad_menu_upgrade'] = "phpMyFAQ Yükselt";
$PMF_LANG['ad_you_shouldnt_update'] = "Şu an phpMyFAQ yazılımının son sürümünü kullanıyorsunuz. Yükseltme işlemi gerekli değil.";
$LANG_CONF['security.useSslForLogins'] = array('checkbox', "Only allow logins over SSL connection?");
$PMF_LANG['msgSecureSwitch'] = "Giriş yapabilmek için güvenli moda geçin!";

// added 2.6.0-alpha - 2009-10-03 by Anatoliy Belsky
$PMF_LANG['msgTransToolNoteFileSaving'] = "Lütfen dikkat, kaydet butonuna basılıncaya kadar hiçbir dosyaya yazılmayacaktır";
$PMF_LANG['msgTransToolPageBufferRecorded'] = "Sayfa %d başarıyla önbelleğe alındı";
$PMF_LANG['msgTransToolErrorRecordingPageBuffer'] = "Sayfa %d önbelleğe alınırken hata oluştu";
$PMF_LANG['msgTransToolRecordingPageBuffer'] = "Sayfa %d önbelleğe alınıyor";

// added 2.6.0-alpha - 2009-11-02 by Anatoliy Belsky
$PMF_LANG['ad_record_active'] = "Etkin";

// added 2.6.0-alpha - 2009-11-01 by Anatoliy Belsky
$PMF_LANG['msgAttachmentInvalid'] = "Eklenti hatalı, lütfen yöneticiyle iletişim kurun";

// added 2.6.0-alpha - 2009-11-02 by max
$LANG_CONF['search.numberSearchTerms'] = array('input', 'Number of listed search terms');
$LANG_CONF['records.orderingPopularFaqs'] = array("select", "Sorting of the top FAQ's");
$PMF_LANG['list_all_users'] = "Tüm kullanıcıları listele";

$PMF_LANG['records.orderingPopularFaqs.visits'] = "En çok görüntülenen içerikleri listele";
$PMF_LANG['records.orderingPopularFaqs.voting'] = "En çok oylanan içerikleri listele";

// added 2.6.0-alpha - 2009-11-05 by Thorsten
$PMF_LANG['msgShowHelp'] = "Lütfen kelimeleri virgülle ayırın";

// added 2.6.0-RC - 2009-11-30 by Thorsten
$PMF_LANG['msgUpdateFaqDate'] = "güncelle";
$PMF_LANG['msgKeepFaqDate'] = "sakla";
$PMF_LANG['msgEditFaqDat'] = "düzenle";

// added v2.6.99 - 2010-11-24 by Gustavo Solt
$LANG_CONF['search.relevance'] = array('select', 'Sort by relevance');
$LANG_CONF["search.enableRelevance"] = array("checkbox", "Activate relevance support?");
$PMF_LANG['searchControlCenter'] = "Ara";
$PMF_LANG['search.relevance.thema-content-keywords'] = "Soru - Cevap - Anahtar sözcük";
$PMF_LANG['search.relevance.thema-keywords-content'] = "Soru - Anahtar sözcük - Cevap";
$PMF_LANG['search.relevance.content-thema-keywords'] = "Cevap - Soru - Anahtar sözcük";
$PMF_LANG['search.relevance.content-keywords-thema'] = "Cevap - Anahtar sözcük - Soru";
$PMF_LANG['search.relevance.keywords-content-thema'] = "Anahtar sözcük - Cevap - Soru";
$PMF_LANG['search.relevance.keywords-thema-content'] = "Anahtar sözcük - Soru - Cevap";

// added 2.7.0-alpha - 2010-09-13 by Thorsten
$PMF_LANG['msgLoginUser'] = "Giriş";

// added 2.7.0-alpha - 2010-12-21 by Anatoliy Belsky
$PMF_LANG["ad_menu_attachments"] = "Eklentiler";
$PMF_LANG["ad_menu_attachment_admin"] = "Dosya Eklenti yönetimi";
$PMF_LANG['msgAttachmentsFilename'] = "Dosya adı";
$PMF_LANG['msgAttachmentsFilesize'] = "Boyut";
$PMF_LANG['msgAttachmentsMimeType'] = "Tür";
$PMF_LANG['msgAttachmentsWannaDelete'] = "Bu eklentiyi silmek istediğinizden emin misiniz??";
$PMF_LANG['msgAttachmentsDeleted'] = "Eklenti <strong>başarıyla</strong> silindi.";

// added v2.7.0-alpha2 - 2010-01-12 by Gustavo Solt
$PMF_LANG['ad_menu_reports'] = "Raporlar";
$PMF_LANG["ad_stat_report_fields"] = "Alanlar";
$PMF_LANG["ad_stat_report_category"] = "Kategori";
$PMF_LANG["ad_stat_report_sub_category"] = "Alt kategori";
$PMF_LANG["ad_stat_report_translations"] = "Çeviriler";
$PMF_LANG["ad_stat_report_language"] = "Dil";
$PMF_LANG["ad_stat_report_id"] = "İçerik ID";
$PMF_LANG["ad_stat_report_sticky"] = "Sabit içerik";
$PMF_LANG["ad_stat_report_title"] = "Soru";
$PMF_LANG["ad_stat_report_creation_date"] = "Tarih";
$PMF_LANG["ad_stat_report_owner"] = "Orijinal yazarı";
$PMF_LANG["ad_stat_report_last_modified_person"] = "Son düzenleyen";
$PMF_LANG["ad_stat_report_url"] = "URL";
$PMF_LANG["ad_stat_report_visits"] = "Ziyaret";
$PMF_LANG["ad_stat_report_make_report"] = "Rapor oluştur";
$PMF_LANG["ad_stat_report_make_csv"] = "CSV olarak dışa aktar";

// added v2.7.0-alpha2 - 2010-02-05 by Thorsten Rinne
$PMF_LANG['msgRegistration'] = "Yeni Kayıt";
$PMF_LANG['msgRegistrationCredentials'] = "Kayıt olmak için, lütfen adınızı, geçerli e-mail adresinizi ve kullanıcı adınızı belirtin.";
$PMF_LANG['msgRegistrationNote'] = "Kayıt işlemini tamamlamanızın ardından, detaylar yönetici tarafından kontrol edilecek ve onaylanması durumunda yanıt alacaksınız.";

// added v2.7.0-beta - 2011-06-13 by Thorsten
$PMF_LANG['ad_entry_changelog_history'] = "Değişiklik geçmişi";

// added v2.7.0-beta2 - 2011-06-22 by Thorsten
$LANG_CONF['security.ssoSupport'] = array('checkbox', 'Single Sign On Support');
$LANG_CONF['security.ssoLogoutRedirect'] = array('input', 'Single Sign On logout redirect service URL');
$LANG_CONF['main.dateFormat'] = array('input', 'Date format (default: Y-m-d H:i)');
$LANG_CONF['security.enableLoginOnly'] = array('checkbox', 'Complete secured FAQ');

// added v2.7.0-RC - 2011-08-18 by Thorsten
$PMF_LANG['securityControlCenter'] = "Güvenlik";
$PMF_LANG['ad_search_delsuc'] = "Arama terimi başarıyla silindi.";
$PMF_LANG['ad_search_delfail'] = "Arama terimi silinemedi";

// added 2.7.1 - 2011-09-30 by Thorsten
$PMF_LANG['msg_about_faq'] = "hakkında";
$LANG_CONF['security.useSslOnly'] = array('checkbox', 'FAQ with SSL only');
$PMF_LANG['msgTableOfContent'] = "İçindekiler";

// added 2.7.5 - 2012-03-02 by Thorsten
$PMF_LANG["msgExportAllFaqs"] = "Tümünü PDF olarak yazdır";
$PMF_LANG["msgOnlineVerificationCheck"] = "Online doğrulama kontrolü";
$PMF_LANG["msgOnlineVerificationCheckButton"] = "phpMyFAQ kurulumunuzu doğrulamak için tıklayın";
$PMF_LANG["ad_verification_notokay"] = "Sisteminizde değiştirilmiş dosyalar tespit edildi";
$PMF_LANG["ad_verification_okay"] = "phpMyFAQ kurulumunuz başarıyla doğrulandı.";

// added v2.8.0-alpha - 2011-09-29 by Thorsten
$PMF_LANG['msgAdminSearchFaqs'] = "İçeriklerde ara";

// added v2.8.0-alpha - 2012-01-13 by Peter
$LANG_CONF["records.enableCloseQuestion"] = array("checkbox", "Close open question after answer?");
$LANG_CONF["records.enableDeleteQuestion"] = array("checkbox", "Delete open question after answer?");
$PMF_LANG["msg2answerFAQ"] = "Cevaplanmış";

// added v2.8.0-alpha - 2012-01-16 by Thorsten
$PMF_LANG["headerUserControlPanel"] = "Kullanıcı Paneli";

// added v2.8.0-alpha2 - 2012-03-15 by Thorsten
$PMF_LANG["rememberMe"] = "Giriş bilgilerimi hatırla";
$PMF_LANG["ad_menu_instances"] = "Çoklu site";

// added v2.8.0-alpha2 - 2012-08-06 by Thorsten
$PMF_LANG['ad_record_inactive'] = "Pasif sorular";
$LANG_CONF["main.maintenanceMode"] = array("checkbox", "Set FAQ in maintenance mode");
$PMF_LANG['msgMode'] = "Modus";
$PMF_LANG['msgMaintenanceMode'] = "Site bakımda";
$PMF_LANG['msgOnlineMode'] = "Site aktif";

// added v2.8.0-alpha3 - 2012-08-30 by Thorsten
$PMF_LANG['msgShowMore'] = "Daha fazlası";
$PMF_LANG['msgQuestionAnswered'] = "Soru yanıtlandı";
$PMF_LANG['msgMessageQuestionAnswered'] = "%s üzerinde sorduğunuz soru yanıtlandı. Lütfen şuradan kontrol edin";

// added v2.8.0-beta - 2012-12-24 by Thorsten
$LANG_CONF["records.randomSort"] = array("checkbox", "Sort FAQs randomly");
$LANG_CONF['main.enableWysiwygEditorFrontend'] = array("checkbox", "Enable bundled WYSIWYG editor in frontend");

// added v2.8.0-beta3 - 2013-01-15 by Thorsten
$LANG_CONF["main.enableGravatarSupport"] = array("checkbox", "Gravatar Support");

// added v2.8.0-RC - 2013-01-29 by Thorsten
$PMF_LANG["ad_stopwords_desc"] = "Yasaklı kelime eklemek ya da düzenlemek için bir dil seçin.";
$PMF_LANG["ad_visits_per_day"] = "Günlük ziyaret";

// added v2.8.0-RC2 - 2013-02-17 by Thorsten
$PMF_LANG["ad_instance_add"] = "Yeni bir site kopyası ekle";
$PMF_LANG["ad_instance_error_notwritable"] = "/multisite dizini yazılabilir değil.";
$PMF_LANG["ad_instance_url"] = "Yeni site adresi";
$PMF_LANG["ad_instance_path"] = "Site dizini";
$PMF_LANG["ad_instance_name"] = "Site adı";
$PMF_LANG["ad_instance_email"] = "Yönetici e-posta adresi";
$PMF_LANG["ad_instance_admin"] = "Yönetici kullanıcı adı";
$PMF_LANG["ad_instance_password"] = "Yönetici şifresi";
$PMF_LANG["ad_instance_hint"] = "Dikkat: yeni bir phpMyFAQ kopyası oluşturmak biraz zaman alacak!";
$PMF_LANG["ad_instance_button"] = "Kaydet";
$PMF_LANG["ad_instance_error_cannotdelete"] = "Kopya silinemedi ";
$PMF_LANG["ad_instance_config"] = "Yapılandırma";

// added v2.8.0-RC3 - 2013-03-03 by Thorsten
$PMF_LANG["msgAboutThisNews"] = "Hakkında";

// added v.2.8.1 - 2013-06-23 by Thorsten
$PMF_LANG["msgAccessDenied"] = "Erişim reddedildi.";

// added v.2.8.21 - 2015-02-17 by Thorsten
$PMF_LANG['msgSeeFAQinFrontend'] = "Siteyi ziyaret et";

// added v.2.9.0-alpha - 2013-12-26 by Thorsten
$PMF_LANG["msgRelatedTags"] = "Arama terimi ekle";
$PMF_LANG["msgPopularTags"] = "Aranan popüler kelimeler";
$LANG_CONF["search.enableHighlighting"] = array("checkbox", "Highlight search terms");
$LANG_CONF["records.allowCommentsForGuests"] = array("checkbox", "Allow comments for guests");
$LANG_CONF["records.allowQuestionsForGuests"] = array("checkbox", "Allow adding questions for guests");
$LANG_CONF["records.allowNewFaqsForGuests"] = array("checkbox", "Allow adding new FAQs for guests");
$PMF_LANG["ad_searchterm_del"] = "Kaydedilen tüm arama terimleri silindi";
$PMF_LANG["ad_searchterm_del_suc"] = "Tüm arama terimleri başarıyla silindi.";
$PMF_LANG["ad_searchterm_del_err"] = "Arama terimleri silinemedi.";
$LANG_CONF["records.hideEmptyCategories"] = array("checkbox", "Hide empty categories");
$LANG_CONF["search.searchForSolutionId"] = array("checkbox", "Search for solution ID");

// added v2.9.0-alpha2 - 2014-08-16 by Thorsten
$PMF_LANG["ad_tag_delete_success"] = "Etiket başarıyla silindi.";
$PMF_LANG["ad_tag_delete_error"] = "Etiket silinirken bir hata oluştu.";
$PMF_LANG["seoCenter"] = "SEO";
$LANG_CONF["seo.metaTagsHome"] = array("select", "Meta Tags start page");
$LANG_CONF["seo.metaTagsFaqs"] = array("select", "Meta Tags FAQs");
$LANG_CONF["seo.metaTagsCategories"] = array("select", "Meta Tags category pages");
$LANG_CONF["seo.metaTagsPages"] = array("select", "Meta Tags static pages");
$LANG_CONF["seo.metaTagsAdmin"] = array("select", "Meta Tags Admin");
$PMF_LANG["msgMatchingQuestions"] = "Sorunuzla ilgili olabilecek sonuçlar şunlardır";
$PMF_LANG["msgFinishSubmission"] = "Eğer gösterilecek sonuçlar aradığınız cevabı içermiyorsa, sorunuzu hemen bize iletebilirsiniz!";
$LANG_CONF['spam.manualActivation'] = array('checkbox', 'Manually activate new users (default: activated)');

// added v2.9.0-alpha2 - 2014-10-13 by Christopher Andrews ( Chris--A )
$PMF_LANG['mailControlCenter'] = "Mail kurulumu";
$LANG_CONF['mail.remoteSMTP'] = array('checkbox', 'Use remote SMTP server (default: deactivated)');
$LANG_CONF['mail.remoteSMTPServer'] = array('input', 'Server address');
$LANG_CONF['mail.remoteSMTPUsername'] = array('input', 'User name');
$LANG_CONF['mail.remoteSMTPPassword'] = array('password', 'Password');
$LANG_CONF['security.enableRegistration'] = array('checkbox', 'Enable registration for visitors');

// added v2.9.0-alpha3 - 2015-02-08 by Thorsten
$LANG_CONF['main.customPdfHeader'] = array('area', 'Custom PDF Header (HTML allowed)');
$LANG_CONF['main.customPdfFooter'] = array('area', 'Custom PDF Footer (HTML allowed)');
$LANG_CONF['records.allowDownloadsForGuests'] = array('checkbox', 'Allow downloads for guests');
$PMF_LANG["ad_msgNoteAboutPasswords"] = "Dikkat! girdiğiniz şifre kullanıcı şifresinin üzerine yazılacaktır.";
$PMF_LANG["ad_delete_all_votings"] = "Tüm oylamaları temizle";
$PMF_LANG["ad_categ_moderator"] = "Moderatörler";
$PMF_LANG['ad_clear_all_visits'] = "Tüm ziyaretleri temizle";
$PMF_LANG['ad_reset_visits_success'] = "Ziyaretçi kayıtları başarıyla sıfırlandı.";
$LANG_CONF['main.enableMarkdownEditor'] = array('checkbox', 'Enable bundled Markdown editor');

// added v2.9.0-beta - 2015-09-27 by Thorsten
$PMF_LANG['faqOverview'] = "Özet bilgi";
$PMF_LANG['ad_dir_missing'] = "%s dizini bulunamadı.";
$LANG_CONF['main.enableSmartAnswering'] = array('checkbox', 'Enable smart answering for user questions');

// added v2.9.0-beta2 - 2015-12-23 by Thorsten
$LANG_CONF['search.enableElasticsearch'] = array('checkbox', 'Enable Elasticsearch support');
$PMF_LANG['ad_menu_elasticsearch'] = "Elasticsearch yapılandırması";
$PMF_LANG['ad_es_create_index'] = "Index oluştur";
$PMF_LANG['ad_es_drop_index'] = "Index kaldır";
$PMF_LANG['ad_es_bulk_index'] = "Tam içe aktarma";
$PMF_LANG['ad_es_create_index_success'] = "Index başarıyla oluşturuldu.";
$PMF_LANG['ad_es_drop_index_success'] = "Index başarıyla kaldırıldı.";
$PMF_LANG['ad_export_generate_json'] = "JSON dosyası oluştur";
$PMF_LANG['ad_media_name_search'] = "Görsel adıyla ara";

// added v2.9.0-RC - 2016-02-19 by Thorsten
$PMF_LANG['ad_admin_notes'] = "Özel Not";
$PMF_LANG['ad_admin_notes_hint'] = " (yalnızca editörler tarafından görülebilir)";

// added 2.10.0-alpha - 2016-08-08 by Thorsten
$LANG_CONF['ldap.ldap_mapping.name'] = array('input', 'LDAP mapping for name, "cn" when using an ADS');
$LANG_CONF['ldap.ldap_mapping.username'] = array('input', 'LDAP mapping for username, "samAccountName" when using an ADS');
$LANG_CONF['ldap.ldap_mapping.mail'] = array('input', 'LDAP mapping for email, "mail" when using an ADS');
$LANG_CONF['ldap.ldap_mapping.memberOf'] = array('input', 'LDAP mapping for "member of" when using LDAP groups');
$LANG_CONF['ldap.ldap_use_domain_prefix'] = array('checkbox', 'LDAP domain prefix, e.g. "DOMAIN\username"');
$LANG_CONF['ldap.ldap_options.LDAP_OPT_PROTOCOL_VERSION'] = array('input', 'LDAP protocol version (default: 3)');
$LANG_CONF['ldap.ldap_options.LDAP_OPT_REFERRALS'] = array('input', 'LDAP referrals (default: 0)');
$LANG_CONF['ldap.ldap_use_memberOf'] = array('checkbox', 'Enable LDAP group support, e.g. "DOMAIN\username"');
$LANG_CONF['ldap.ldap_use_sasl'] = array('checkbox', 'Enable LDAP SASL support');
$LANG_CONF['ldap.ldap_use_multiple_servers'] = array('checkbox', 'Enable multiple LDAP servers support');
$LANG_CONF['ldap.ldap_use_anonymous_login'] = array('checkbox', 'Enable anonymous LDAP connections');
$LANG_CONF['ldap.ldap_use_dynamic_login'] = array('checkbox', 'Enable LDAP dynamic user binding');
$LANG_CONF['ldap.ldap_dynamic_login_attribute'] = array('input', 'LDAP attribute for dynamic user binding, "uid" when using an ADS');
$LANG_CONF['seo.enableXMLSitemap'] = array('checkbox', 'Enable XML sitemap');
$PMF_LANG['ad_category_image'] = "Kategori görseli";
$PMF_LANG["ad_user_show_home"] = "başlangıç sayfasında göster";

// added v.2.10.0-alpha - 2017-11-09 by Brian Potter (BrianPotter)
$PMF_LANG['ad_view_faq'] = "Görüntüle";

// added 3.0.0-alpha - 2018-01-04 by Thorsten
$LANG_CONF['main.enableCategoryRestrictions'] = ['checkbox', 'Enable category restrictions'];
$LANG_CONF['main.enableSendToFriend'] = ['checkbox', 'Enable send to friends'];
$PMF_LANG['msgUserRemovalText'] = "Hesabınızın silinmesini talep edebilirsiniz. BU işlem size ait tüm verilerin silinmesi için yöneticileri bilgilendirir ve manuel bir işlemdir. İşlemin tamamlanmasının ardından tarafınıza bir e-posta gönderilir. İşlem 24 saati bulabilmektedir. İşlem sonucunda size ait hesap detayları, soru ve cevap kayıtları, duyurular ve yorumlar silinmiş olacaktır.";
$PMF_LANG["msgUserRemoval"] = "Hesap silme talebi";
$PMF_LANG["ad_menu_RequestRemove"] = "Hesap silme talebi";
$PMF_LANG["msgContactRemove"] = "Yönetici ekibinden silinme talebi";
$PMF_LANG["msgContactPrivacyNote"] = "Lütfen göszden geçirin";
$PMF_LANG["msgPrivacyNote"] = "Gizlilik sözleşmesi";

// added 3.0.0-alpha2 - 2018-03-27 by Thorsten
$LANG_CONF['main.enableAutoUpdateHint'] = ['checkbox', 'Automatic check for new versions'];
$PMF_LANG['ad_quick_entry'] = "Bu kategoriye soru ekle";
$PMF_LANG['ad_user_is_superadmin'] = "Super-Yönetici";
$PMF_LANG['ad_user_overwrite_passwd'] = "Şifrenin üzerine yaz";
$LANG_CONF['records.enableAutoRevisions'] = ['checkbox', 'SSS değişikliklerinin sürümlendirilmesine izin ver'];
$PMF_LANG['permission::view_faqs'] = "Soruları görüntüle";
$PMF_LANG['permission::view_categories'] = "Kategorileri görüntüle";
$PMF_LANG['permission::view_sections'] = "Bölümleri görüntüle";
$PMF_LANG['permission::view_news'] = "Duyuruları görüntüle";
$PMF_LANG['permission::administrate_groups'] = "Grupları yönet";
$PMF_LANG['ad_group_rights'] = "Grup izinleri";

// added v3.0.0-alpha.3 - 2018-09-20 by Timo
$PMF_LANG['ad_menu_section_administration'] = "Bölüm";
$PMF_LANG['ad_section_add'] = "Bölüm ekle";
$PMF_LANG['ad_section_add_link'] = "Bölüm ekle";
$PMF_LANG['ad_sections'] = "Bölümler";
$PMF_LANG['ad_section_details'] = "Bölüm detayları";
$PMF_LANG['ad_section_name'] = "İsim";
$PMF_LANG['ad_section_description'] = "Açıklama";
$PMF_LANG['ad_section_membership'] = "Bölüm ilişkilendir";
$PMF_LANG['ad_section_members'] = "İlişkilendirmeler";
$PMF_LANG['ad_section_addMember'] = "ekle";
$PMF_LANG['ad_section_removeMember'] = "çıkar";
$PMF_LANG['ad_section_deleteSection'] = "Bölüm sil";
$PMF_LANG['ad_section_deleteQuestion'] = "Bu bölümü silmek istediğinizden emin misiniz?";
$PMF_LANG['ad_section_error_delete'] = "Bölüm silinemedi.";
$PMF_LANG['ad_section_error_noName'] = "Lütfen bir bölüm adı girin.";
$PMF_LANG['ad_section_suc'] = "Bölüm <strong>başarıyla</strong> eklendi.";
$PMF_LANG['ad_section_deleted'] = "Bölüm başarıyla silindi.";
$PMF_LANG['permission::viewadminlink'] = "Yönetici bağlantısını görüntüle";

return $PMF_LANG;
