<?php

/**
 * Taiwan Traditional Chinese language file
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at https://mozilla.org/MPL/2.0/.
 *
 * @package phpMyFAQ
 * @author Aaron Lin <devilkintw@gmail.com>
 * @author Barlos Lee <barlos.lee@gmail.com>
 * @copyright 2004-2024 phpMyFAQ Team
 * @license https://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link https://www.phpmyfaq.de
 * @since 2004-08-01
 * @codingStandardsIgnoreFile
 */

$PMF_LANG["metaCharset"] = "UTF-8";
$PMF_LANG["metaLanguage"] = "tw";
$PMF_LANG["language"] = "台灣繁體中文 Taiwan Traditioal Chinese";
$PMF_LANG['direction'] = "ltr";
$PMF_LANG["nplurals"] = "1";

// Navigation 導覽
$PMF_LANG["msgCategory"] = "分類";
$PMF_LANG["msgShowAllCategories"] = "所有分類";
$PMF_LANG["msgSearch"] = "搜尋";
$PMF_LANG["msgAddContent"] = "新增 FAQ";
$PMF_LANG["msgQuestion"] = "新增問題";
$PMF_LANG["msgOpenQuestions"] = "等待回答問題";
$PMF_LANG["msgHelp"] = "協助說明";
$PMF_LANG["msgContact"] = "聯絡本站";
$PMF_LANG["msgHome"] = "FAQ 首頁";
$PMF_LANG["msgNews"] = "FAQ 新聞";
$PMF_LANG["msgUserOnline"] = " 線上使用者";
$PMF_LANG["msgBack2Home"] = "回到首頁";

// Contentpages 內容頁面
$PMF_LANG["msgFullCategories"] = "FAQs 的分類 (Categories with FAQs)";
$PMF_LANG["msgFullCategoriesIn"] = "FAQs 分類內 (Categories with FAQs in )";
$PMF_LANG["msgSubCategories"] = "子分類";
$PMF_LANG["msgEntries"] = "FAQs";
$PMF_LANG["msgEntriesIn"] = "問題在 (Questions in )";
$PMF_LANG["msgViews"] = "閱讀(views)";
$PMF_LANG["msgPage"] = "頁(Page) ";
$PMF_LANG["msgPages"] = " 頁(Pages)";
$PMF_LANG["msgPrevious"] = "上一頁(previous)";
$PMF_LANG["msgNext"] = "下一頁(next)";
$PMF_LANG["msgCategoryUp"] = "上一層分類 (one category up)";
$PMF_LANG["msgLastUpdateArticle"] = "最後更新(Last update): ";
$PMF_LANG["msgAuthor"] = "作者: ";
$PMF_LANG["msgPrinterFriendly"] = "友善列印版本";
$PMF_LANG["msgPrintArticle"] = "列印此記錄";
$PMF_LANG["msgMakeXMLExport"] = "輸出為 XML 檔案格式";
$PMF_LANG["msgAverageVote"] = "平均評分";
$PMF_LANG["msgVoteUsability"] = "評分此 FAQ";
$PMF_LANG["msgVoteFrom"] = "來自(out of)";
$PMF_LANG["msgVoteBad"] = "完全沒有價值";
$PMF_LANG["msgVoteGood"] = "非常有價值";
$PMF_LANG["msgVotings"] = "評分 ";
$PMF_LANG["msgVoteSubmit"] = "評分";
$PMF_LANG["msgVoteThanks"] = "感謝您的評分!";
$PMF_LANG["msgYouCan"] = "您可以 ";
$PMF_LANG["msgWriteComment"] = "對此 FAQ 發表評論";
$PMF_LANG["msgShowCategory"] = "內容總覽: ";
$PMF_LANG["msgCommentBy"] = "評價來自(Comment of) ";
$PMF_LANG["msgCommentHeader"] = "評論此 FAQ";
$PMF_LANG["msgYourComment"] = "您的評論";
$PMF_LANG["msgCommentThanks"] = "非常感謝您的評論!";
$PMF_LANG["msgSeeXMLFile"] = "開啟 XML 檔案";
$PMF_LANG["msgSend2Friend"] = "寄送 FAQ 給一個朋友";
$PMF_LANG["msgS2FButton"] = "寄送 e-mail";

// Search 搜尋
$PMF_LANG["msgSearchWord"] = "關鍵字";
$PMF_LANG["msgSearchFind"] = "搜尋結果 (Search result for) ";
$PMF_LANG["msgSearchAmount"] = " 搜尋結果(search result)";
$PMF_LANG["msgSearchAmounts"] = " 搜尋結果(search results)";
$PMF_LANG["msgSearchCategory"] = "類別: ";
$PMF_LANG["msgSearchContent"] = "答案: ";

// new Content 新內容
$PMF_LANG["msgNewContentHeader"] = "提出一筆新的 FAQ";
$PMF_LANG['msgNewContentAddon'] = "您的建議不會立即出現，但會在發布前經過我們的檢查。必填欄位是標示 * 的欄位。";
$PMF_LANG["msgNewContentName"] = "您的姓名";
$PMF_LANG["msgNewContentMail"] = "Email";
$PMF_LANG["msgNewContentCategory"] = "類別";
$PMF_LANG["msgNewContentTheme"] = "您的問題";
$PMF_LANG["msgNewContentArticle"] = "您的答案";
$PMF_LANG["msgNewContentKeywords"] = "關鍵字";
$PMF_LANG["msgNewContentLink"] = "此 FAQ 的連結";
$PMF_LANG["msgNewContentSubmit"] = "送出";
$PMF_LANG["msgInfo"] = "更多資訊: ";
$PMF_LANG["msgNewContentThanks"] = "感謝您的建議!";
$PMF_LANG["msgNoQuestionsAvailable"] = "目前沒有等待回答的問題.";

// ask Question 提問題
$PMF_LANG["msgNewQuestion"] = "請於下方提問";
$PMF_LANG["msgAskCategory"] = "類別";
$PMF_LANG["msgAskYourQuestion"] = "您的問題";
$PMF_LANG["msgAskThx4Mail"] = "感謝您的提問!";
$PMF_LANG["msgDate_User"] = "日期 / 使用者";
$PMF_LANG["msgQuestion2"] = "問題";
$PMF_LANG["msg2answer"] = "回答";
$PMF_LANG["msgQuestionText"] = "您可以在這邊查看其他使用者已提過的問題，如果您回答這些問題，您的答案可能會被引用。";

// Contact 聯絡
$PMF_LANG["msgContactEMail"] = "Email FAQ 所有者";
$PMF_LANG["msgMessage"] = "您的訊息";

// Startseite 初始網站頁面
$PMF_LANG["msgTopTen"] = "最熱門的 FAQs";
$PMF_LANG["msgHomeThereAre"] = "線上有 ";
$PMF_LANG["msgHomeArticlesOnline"] = " 筆 FAQs";
$PMF_LANG["msgNoNews"] = "沒新問題就是好消息。";
$PMF_LANG["msgLatestArticles"] = "最新的 FAQs";

// E-Mail benachrichtigung / email notification / Email 訊息
$PMF_LANG["msgMailThanks"] = "非常感謝您對此 FAQ 的建議。";
$PMF_LANG["msgMailCheck"] = "FAQ 有一筆新記錄! 請進入管理員頁面查看!";
$PMF_LANG["msgMailContact"] = "您的訊息已經傳遞給管理員。";

// Fehlermeldungen / Error Message / 錯誤訊息
$PMF_LANG["err_noDatabase"] = "沒有可用資料庫連接。";
$PMF_LANG["err_noHeaders"] = "沒有發現類別。";
$PMF_LANG["msgErrorNoRecords"] = "沒有 FAQs 存在。";
$PMF_LANG["err_badID"] = "錯誤 ID。";
$PMF_LANG["err_noTopTen"] = "尚無熱門 FAQs。";
$PMF_LANG["err_nothingFound"] = "尚未有記錄.";
$PMF_LANG["err_SaveEntries"] = "必填欄位是 <strong>您的姓名</strong>，<strong>您的 email </strong>，<strong>類別</strong>，<strong>問題</strong>, <strong>您的紀錄</strong> 與，, 何時提出，<strong><a href=\"https://en.wikipedia.org/wiki/Captcha\" title=\"閱讀更多關於 Captcha 於 Wikipedia\" target=\"_blank\">Captcha</a> 驗證碼</strong>!";
$PMF_LANG["err_SaveComment"] = "必填欄位是 <strong>您的姓名</strong>，<strong>您的 email </strong>，<strong>您的評論</strong> 和，何時提出，<strong><a href=\"https://en.wikipedia.org/wiki/Captcha\" title=\"閱讀更多關於 Captcha 於 Wikipedia\" target=\"_blank\">Captcha</a> 驗證碼</strong>!";
$PMF_LANG["err_VoteTooMuch"] = "我們不統計重複評分。";
$PMF_LANG["err_noVote"] = "您沒有對此問題評分!";
$PMF_LANG["err_noMailAdress"] = "您的 email 地址不正確。";
$PMF_LANG["err_sendMail"] = "必填欄位是 <strong>您的姓名</strong>，<strong>您的 email</strong>，<strong>您的問題</strong> 和，何時提出， <strong><a href=\"https://en.wikipedia.org/wiki/Captcha\" title=\"閱讀更多關於 Captcha 於 Wikipedia\" target=\"_blank\">Captcha</a> 驗證碼</strong>!";

// Hilfe zur Suche / Help to the search / 搜尋提示幫忙
$PMF_LANG["help_search"] = "<strong>搜尋記錄:</strong><br>與一筆記錄類似 <strong style=\"color: Red;\">字串1 字串2</strong> 您也可以用兩個或更多的搜尋選項來排序。<strong>注意:</strong> 您的搜尋至少必須有四個字元，不然不會被執行。";

// Menu 選項單
$PMF_LANG["ad"] = "管理員介面";
$PMF_LANG["ad_menu_user_administration"] = "使用者";
$PMF_LANG["ad_menu_entry_aprove"] = "核准發佈 FAQs (Approve FAQs)";
$PMF_LANG["ad_menu_entry_edit"] = "編輯現有 FAQs";
$PMF_LANG["ad_menu_categ_add"] = "新增類別";
$PMF_LANG["msgHeaderCategoryOverview"] = "編輯類別";
$PMF_LANG["ad_menu_news_add"] = "新增新聞";
$PMF_LANG["ad_menu_news_edit"] = "FAQ 新聞";
$PMF_LANG["ad_menu_open"] = "待回答問題 (Open questions)";
$PMF_LANG["ad_menu_stat"] = "統計";
$PMF_LANG["ad_menu_cookie"] = "設定t cookies";
$PMF_LANG["ad_menu_session"] = "檢視連線數 ";
$PMF_LANG["ad_menu_adminlog"] = "檢視管理員日誌 Adminlog";
$PMF_LANG["ad_menu_passwd"] = "變更密碼";
$PMF_LANG["ad_menu_logout"] = "登出";
$PMF_LANG["ad_menu_startpage"] = "起始頁面";

// Nachrichten / News / 新聞
$PMF_LANG["ad_msg_identify"] = "請確認您的身分。";
$PMF_LANG["ad_msg_passmatch"] = "兩次輸入的密碼<strong>必須一致</strong>!";
$PMF_LANG["ad_msg_savedsuc_1"] = "個人檔案屬於";
$PMF_LANG["ad_msg_savedsuc_2"] = "儲存成功。";
$PMF_LANG["ad_msg_mysqlerr"] = "基於<strong>資料庫錯誤</strong>，個人檔案無法儲存。";
$PMF_LANG["ad_msg_noauth"] = "您沒有足夠的權限。";

// Allgemein / General / 一般
$PMF_LANG["ad_gen_page"] = "頁";
$PMF_LANG["ad_gen_of"] = "屬於";
$PMF_LANG["ad_gen_lastpage"] = "前一頁";
$PMF_LANG["ad_gen_nextpage"] = "下一頁";
$PMF_LANG["ad_gen_save"] = "儲存";
$PMF_LANG["ad_gen_reset"] = "重置";
$PMF_LANG["ad_gen_yes"] = "是";
$PMF_LANG["ad_gen_no"] = "否";
$PMF_LANG["ad_gen_top"] = "頁首";
$PMF_LANG["ad_gen_ncf"] = "沒有找到類別!";
$PMF_LANG["ad_gen_delete"] = "刪除";

// Benutzerverwaltung / User Administration / 使用者管理
$PMF_LANG["ad_user"] = "使用者管理";
$PMF_LANG["ad_user_username"] = "已註冊的使用者們";
$PMF_LANG["ad_user_rights"] = "使用者權限";
$PMF_LANG["ad_user_edit"] = "編輯";
$PMF_LANG["ad_user_delete"] = "刪除";
$PMF_LANG["ad_user_add"] = "新增使用者";
$PMF_LANG["ad_user_profou"] = "使用者個人檔案";
$PMF_LANG["ad_user_name"] = "姓名";
$PMF_LANG["ad_user_password"] = "密碼";
$PMF_LANG["ad_user_confirm"] = "確定";
$PMF_LANG["ad_user_rights"] = "權限";
$PMF_LANG["ad_user_del_1"] = "此位使用者";
$PMF_LANG["ad_user_del_2"] = "是否確定刪除?";
$PMF_LANG["ad_user_del_3"] = "您確定嘛";
$PMF_LANG["ad_user_deleted"] = "該名使用者已刪除成功。";
$PMF_LANG["ad_user_checkall"] = "選擇全部。";

// Beitragsverwaltung  Administration / 管理者
$PMF_LANG["msgHeaderFAQOverview"] = "FAQ 管理";
$PMF_LANG["ad_entry_id"] = "使用者帳號 ID";
$PMF_LANG["ad_entry_topic"] = "主題";
$PMF_LANG["ad_entry_action"] = "動作";
$PMF_LANG["ad_entry_edit_1"] = "編輯記錄";
$PMF_LANG["ad_entry_edit_2"] = "";
$PMF_LANG["ad_entry_theme"] = "問題";
$PMF_LANG["ad_entry_content"] = "答案";
$PMF_LANG["ad_entry_keywords"] = "關鍵字";
$PMF_LANG["ad_entry_author"] = "作者";
$PMF_LANG["ad_entry_category"] = "類別";
$PMF_LANG["ad_entry_active"] = "可被看到";
$PMF_LANG["ad_entry_date"] = "日期";
$PMF_LANG["ad_entry_status"] = "Status der FAQ";
$PMF_LANG["ad_entry_changed"] = "已變更?";
$PMF_LANG["ad_entry_changelog"] = "異動日誌 Changelog";
$PMF_LANG["ad_entry_commentby"] = "評論來自 ";
$PMF_LANG["ad_entry_comment"] = "評論";
$PMF_LANG["ad_entry_save"] = "儲存";
$PMF_LANG["msgDelete"] = "刪除";
$PMF_LANG["ad_entry_delcom_1"] = "您確定這條評論來自該使用者 (Are you sure that the comment of the user)";
$PMF_LANG["ad_entry_delcom_2"] = "要被刪除嘛? (should be deleted?)";
$PMF_LANG["ad_entry_commentdelsuc"] = "此評論<strong>成功地</strong>被刪除了。";
$PMF_LANG["ad_entry_back"] = "返回到文章";
$PMF_LANG["ad_entry_commentdelfail"] = "此評論<strong>沒有被刪除t</strong>。";
$PMF_LANG["ad_entry_savedsuc"] = "所做的異動，<strong>儲存成功</strong>。";
$PMF_LANG["ad_entry_savedfail"] = "抱歉，發生<strong>資料庫錯誤</strong>。";
$PMF_LANG["ad_entry_del_1"] = "您確定該主題";
$PMF_LANG["ad_entry_del_2"] = "屬於 (of)";
$PMF_LANG["ad_entry_del_3"] = "應該被刪除嘛?";
$PMF_LANG["ad_entry_delsuc"] = "問題<strong>刪除成功</strong>。";
$PMF_LANG["ad_entry_delfail"] = "問題<strong>沒有被刪除</strong>!";
$PMF_LANG["ad_entry_back"] = "返回";


// Newsverwaltung / News Administration / 新聞管理
$PMF_LANG["ad_news_header"] = "文章標題";
$PMF_LANG["ad_news_text"] = "記錄內容";
$PMF_LANG["ad_news_link_url"] = "連結";
$PMF_LANG["ad_news_link_title"] = "超連結標題";
$PMF_LANG["ad_news_link_target"] = "超連結目標";
$PMF_LANG["ad_news_link_window"] = "超連結以新視窗開啟";
$PMF_LANG["ad_news_link_faq"] = "超連結為內部的 FAQ";
$PMF_LANG["ad_news_add"] = "新增一筆新聞項目";
$PMF_LANG["ad_news_id"] = "#";
$PMF_LANG["ad_news_headline"] = "頭條標題 (Headline)";
$PMF_LANG["ad_news_date"] = "日期";
$PMF_LANG["ad_news_action"] = "動作";
$PMF_LANG["ad_news_update"] = "更新";
$PMF_LANG["ad_news_delete"] = "刪除";
$PMF_LANG["ad_news_nodata"] = "資料庫內沒有找到相關資料";
$PMF_LANG["ad_news_updatesuc"] = "新聞已更新成功。";
$PMF_LANG["ad_news_del"] = "您確定要刪除這條新聞項目嗎?";
$PMF_LANG["ad_news_yesdelete"] = "是的，請刪除!";
$PMF_LANG["ad_news_nodelete"] = "不要";
$PMF_LANG["ad_news_delsuc"] = "新聞已經刪除成功。 (The news has been successfully deleted.)";
$PMF_LANG["ad_news_updatenews"] = "新聞項目已更新。";

// Kategorieverwaltung / Entity Administration / 類別管理
$PMF_LANG["ad_categ_new"] = "新增類別";
$PMF_LANG["ad_categ_catnum"] = "類別編號";
$PMF_LANG["ad_categ_subcatnum"] = "子類別編號";
$PMF_LANG["ad_categ_nya"] = "<em>尚未可以使用!</em>";
$PMF_LANG["ad_categ_titel"] = "類別標題";
$PMF_LANG["ad_categ_add"] = "新增類別";
$PMF_LANG["ad_categ_existing"] = "已存在類別";
$PMF_LANG["ad_categ_id"] = "#";
$PMF_LANG["ad_categ_categ"] = "類別";
$PMF_LANG["ad_categ_subcateg"] = "子類別";
$PMF_LANG["ad_categ_titel"] = "類別標題";
$PMF_LANG["ad_categ_action"] = "動作";
$PMF_LANG["ad_categ_update"] = "更新";
$PMF_LANG["ad_categ_delete"] = "刪除";
$PMF_LANG["ad_categ_updatecateg"] = "更新類別";
$PMF_LANG["ad_categ_nodata"] = "資料庫內沒有資料";
$PMF_LANG["msgCategoryRemark"] = "請注意如果您刪除了一個類別，資料庫中儲存屬於該類別的所有問題記錄都不能被訪問。您必須重新給相關問題記錄分發新類別，或者刪除相關記錄。(Please note that existing entries will not be visible anymore, if you delete the category. You must assign a new category for the article or delete the article.)";
$PMF_LANG["ad_categ_edit_1"] = "編輯";
$PMF_LANG["ad_categ_edit_2"] = "類別";
$PMF_LANG["ad_categ_added"] = "該類別已加入。";
$PMF_LANG["ad_categ_updated"] = "該類別已更新。";
$PMF_LANG["ad_categ_del_yes"] = "是的，請刪除!";
$PMF_LANG["ad_categ_del_no"] = "不是!";
$PMF_LANG["ad_categ_deletesure"] = "您確定要刪除這個類別嗎?";
$PMF_LANG["ad_categ_deleted"] = "類別已刪除。";

// Cookies
$PMF_LANG["ad_cookie_cookiesuc"] = "網頁瀏覽器的 Cookie <strong>設定成功</strong>。";
$PMF_LANG["ad_cookie_already"] = "一個網頁瀏覽器的  Cookie 早已設定成功. 您目前有下列的選項";
$PMF_LANG["ad_cookie_again"] = "重新設定網頁瀏覽器的  Cookie";
$PMF_LANG["ad_cookie_delete"] = "刪除網頁瀏覽器的  Cookie";
$PMF_LANG["ad_cookie_no"] = "目前尚未設定網頁瀏覽器的  Cookie。 Cookie 可以在此電腦上儲存您的登錄訊息，因此您以後可以不用記登入的資訊了。您有下面的選項:<br>(There is no cookie saved yet. With a cookie you could save your login script, thus no need to remember your login details again. You now have following options:)";
$PMF_LANG["ad_cookie_set"] = "設置 cookie";
$PMF_LANG["ad_cookie_deleted"] = "網頁瀏覽器的 Cookie刪除成功。";

// Adminlog 管理者日誌
$PMF_LANG["ad_adminlog"] = "管理員日誌 (AdminLog)";

// Passwd 密碼
$PMF_LANG["ad_passwd_cop"] = "修改您的密碼";
$PMF_LANG["ad_passwd_old"] = "請輸入舊的密碼";
$PMF_LANG["ad_passwd_new"] = "請輸入新的密碼";
$PMF_LANG["ad_passwd_con"] = "請再次輸入新的密碼以供確認";
$PMF_LANG["ad_passwd_change"] = "修改密碼";
$PMF_LANG["ad_passwd_suc"] = "密碼修改成功。";
$PMF_LANG["ad_passwd_remark"] = "<strong>注意:</strong><br>必須重新設置 Cookie，新密碼才能生效。";
$PMF_LANG["ad_passwd_fail"] = "舊密碼<strong>必須</strong> 正確地輸入而且新密碼的兩次輸入必須<strong>一致</strong>。";

// Adduser 新增使用者
$PMF_LANG["ad_adus_adduser"] = "新增使用者帳號";
$PMF_LANG["ad_adus_name"] = "使用者姓名";
$PMF_LANG["ad_adus_password"] = "密碼";
$PMF_LANG["ad_adus_add"] = "新增使用者";
$PMF_LANG["ad_adus_suc"] = "使用者<strong>新增成功</strong>。";
$PMF_LANG["ad_adus_edit"] = "編輯使用者資料";
$PMF_LANG["ad_adus_dberr"] = "<strong>資料庫錯誤!</strong>";
$PMF_LANG["ad_adus_exerr"] = "使用者帳號<strong>已被註冊使用</strong>。";

// Sessions 連線(數)
$PMF_LANG["ad_sess_id"] = "ID";
$PMF_LANG["ad_sess_sid"] = "連線 ID";
$PMF_LANG["ad_sess_ip"] = "IP 位置";
$PMF_LANG["ad_sess_time"] = "時間";
$PMF_LANG["ad_sess_pageviews"] = "頁面檢視次數";
$PMF_LANG["ad_sess_search"] = "搜尋";
$PMF_LANG["ad_sess_sfs"] = "搜尋連線 (Search for sessions)";
$PMF_LANG["ad_sess_s_ip"] = "IP 位置";
$PMF_LANG["ad_sess_s_minct"] = "分鐘. 動作: (min. actions:)";
$PMF_LANG["ad_sess_s_date"] = "日期";
$PMF_LANG["ad_sess_s_after"] = "此日期之後 (after)";
$PMF_LANG["ad_sess_s_before"] = "此日期之前 (before)";
$PMF_LANG["ad_sess_s_search"] = "搜尋";
$PMF_LANG["ad_sess_session"] = "連線 Session";
$PMF_LANG["ad_sess_r"] = "搜尋符合以下條件的結果 (Search results for)";
$PMF_LANG["ad_sess_referer"] = "引用: (Referer)";
$PMF_LANG["ad_sess_browser"] = "網頁瀏覽器 (Browser:)";
$PMF_LANG["ad_sess_ai_rubrik"] = "類別";
$PMF_LANG["ad_sess_ai_artikel"] = "記錄";
$PMF_LANG["ad_sess_ai_sb"] = "搜尋字串";
$PMF_LANG["ad_sess_ai_sid"] = "連線 Session ID";
$PMF_LANG["ad_sess_back"] = "返回";

// Statistik / statistic / 統計
$PMF_LANG["ad_rs"] = "評價統計 (Rating Statistics)";
$PMF_LANG["ad_rs_rating_1"] = "等級屬於 (The ranking of)";
$PMF_LANG["ad_rs_rating_2"] = "使用者顯示: (users shows:)";
$PMF_LANG["ad_rs_red"] = "紅色";
$PMF_LANG["ad_rs_green"] = "綠色";
$PMF_LANG["ad_rs_altt"] = "平均評價等級低於 20% (with an average lower than 20%)";
$PMF_LANG["ad_rs_ahtf"] = "平均評價等級高於 80% (with an average higher than 80%)";
$PMF_LANG["ad_rs_no"] = "尚未有等級評價 (No ranking available)";

// Auth 登入
$PMF_LANG["ad_auth_insert"] = "請輸入您的登入帳號與密碼.";
$PMF_LANG["ad_auth_user"] = "登入帳號名稱";
$PMF_LANG["ad_auth_passwd"] = "密碼";
$PMF_LANG["ad_auth_ok"] = "確認 OK";
$PMF_LANG["ad_auth_reset"] = "重置";
$PMF_LANG["ad_auth_fail"] = "帳號或密碼錯誤.";
$PMF_LANG["ad_auth_sess"] = "ID 連線時間已逾時.";

// Added v0.8 - 24.05.2001 - Bastian - Admin - 管理
$PMF_LANG["ad_config_edit"] = "編輯設定";
$PMF_LANG["ad_config_save"] = "儲存設定";
$PMF_LANG["ad_config_reset"] = "重新設定";
$PMF_LANG["ad_config_saved"] = "設定已儲存成功。";
$PMF_LANG["ad_menu_editconfig"] = "編輯設定";
$PMF_LANG["ad_att_none"] = "沒有可用的附加檔案";
$PMF_LANG["ad_att_att"] = "附加檔案";
$PMF_LANG["ad_att_add"] = "新增附加檔案";
$PMF_LANG["ad_entryins_suc"] = "記錄儲存成功。";
$PMF_LANG["ad_entryins_fail"] = "發生一個錯誤。";
$PMF_LANG["ad_att_del"] = "刪除";
$PMF_LANG["ad_att_nope"] = "只能在編輯的狀態下，新增附加檔案。";
$PMF_LANG["ad_att_delsuc"] = "附加檔案刪除成功。";
$PMF_LANG["ad_att_delfail"] = "刪除附加檔案發生錯誤。(An error occurred while deleting the attachment.)";
$PMF_LANG["ad_entry_add"] = "新增新的 FAQ";

// Added v0.85 - 08.06.2001 - Bastian - Admin - 管理
$PMF_LANG["ad_csv_make"] = "備份是對目前資料庫內容完整的儲存。請每月至少做一次備份。備份格式是的 SQL 交易檔案文件，可以透過的 SQL 匯入工具程式像 phpMyAdmin 或是執行命令列程式恢復備份。<br>(A backup is a complete image of the database content. The format of the backup is a SQL transaction file, which can be imported using tools like phpMyAdmin or the commandline SQL client. A backup should be performed at least once a month.)";
$PMF_LANG["ad_csv_link"] = "下載備份";
$PMF_LANG["ad_csv_head"] = "建立一個備份";
$PMF_LANG["ad_att_addto"] = "新增一個附加檔案到此議題";
$PMF_LANG["ad_att_addto_2"] = "";
$PMF_LANG["ad_att_att"] = "檔案";
$PMF_LANG["ad_att_butt"] = "確定 OK";
$PMF_LANG["ad_att_suc"] = "檔案上傳附加成功。";
$PMF_LANG["ad_att_fail"] = "檔案上傳失敗，發生錯誤。";
$PMF_LANG["ad_att_close"] = "關閉目前的視窗";

// Added v0.85 - 08.07.2001 - Bastian - Admin - 管理
$PMF_LANG["ad_csv_restore"] = "你可以使用這個表單來恢復之前使用 phpMyFAQ 做的備份資料庫內容。請注意，目前已存在的資料將會被覆寫蓋過，而不再存在。<br> (With this form you can restore the content of the database, using a backup made with phpMyFAQ. Please note that the existing data will be overwritten.)";
$PMF_LANG["ad_csv_file"] = "檔案";
$PMF_LANG["ad_csv_ok"] = "確定 OK";
$PMF_LANG["ad_csv_linklog"] = "備份記錄檔案 (backup logfiles)";
$PMF_LANG["ad_csv_linkdat"] = "下載備份資料";
$PMF_LANG["ad_csv_head2"] = "還原恢復 (Restore)";
$PMF_LANG["ad_csv_no"] = "備份檔案看起來不像是 phpMyFAQ 的格式。 (This does not seem to be a backup of phpMyFAQ.)";
$PMF_LANG["ad_csv_prepare"] = "準備資料庫查詢動作... (Preparing the database queries...)";
$PMF_LANG["ad_csv_process"] = "查詢進行中...";
$PMF_LANG["ad_csv_of"] = "屬於 (of)";
$PMF_LANG["ad_csv_suc"] = "成功。";
$PMF_LANG["ad_csv_backup"] = "備份";
$PMF_LANG["ad_csv_rest"] = "還原一個備份";

// Added v0.8 - 25.05.2001 - Bastian - Admin - 管理
$PMF_LANG["ad_menu_backup"] = "備份";
$PMF_LANG["ad_logout"] = "連線 session 終止成功。";
$PMF_LANG["ad_news_add"] = "新增新聞 (Add news)";
$PMF_LANG["ad_news_edit"] = "編輯新聞 (Edit news)";
$PMF_LANG["ad_cookie"] = "網頁 Cookies";
$PMF_LANG["ad_sess_head"] = "檢視連線 (View sessions)";

// Added v1.1 - 06.01.2002 - Bastian - 管理
$PMF_LANG["msgHeaderCategoryOverview"] = "FAQ 類別 (FAQ Categories)";
$PMF_LANG["ad_menu_stat"] = "評價統計 (Rating Statistics)";
$PMF_LANG["msgAddCategory"] = "新增主類別 (Add top-level category)";
$PMF_LANG["ad_kateg_rename"] = "編輯 (Edit)";
$PMF_LANG["ad_adminlog_date"] = "日期 (Date)";
$PMF_LANG["ad_adminlog_user"] = "使用者 (User)";
$PMF_LANG["ad_adminlog_ip"] = "IP 位置 (IP-Address)";

$PMF_LANG["ad_stat_sess"] = "連線 Sessions";
$PMF_LANG["ad_stat_days"] = "天數";
$PMF_LANG["ad_stat_vis"] = "連線 Sessions (Visits)";
$PMF_LANG["ad_stat_vpd"] = "每日訪問人數 (Visits per Day)";
$PMF_LANG["ad_stat_fien"] = "最新的記錄 (First Log)";
$PMF_LANG["ad_stat_laen"] = "最後記錄 (Last Log)";
$PMF_LANG["ad_stat_browse"] = "瀏覽連線的  Sessions";
$PMF_LANG["ad_stat_ok"] = "確定 OK";

$PMF_LANG["ad_sess_time"] = "時間";
$PMF_LANG["ad_sess_sid"] = "連線 Session-ID";
$PMF_LANG["ad_sess_ip"] = "IP-位置";

$PMF_LANG["ad_ques_take"] = "回答此問題";
$PMF_LANG["no_cats"] = "沒有找到類別。";

// Added v1.1 - 17.01.2002 - Bastian - admin - 管理
$PMF_LANG["ad_log_lger"] = "無效的使用者名稱或是密碼。";
$PMF_LANG["ad_log_sess"] = "連線 Session 已經逾時。";
$PMF_LANG["ad_log_edit"] = "\"編輯使用者\"- 給下列使用者用的表單: (Form for the following user:) ";
$PMF_LANG["ad_log_crea"] = "\"新文章\" 表單。";
$PMF_LANG["ad_log_crsa"] = "新紀錄已建立。( New entry created.)";
$PMF_LANG["ad_log_ussa"] = "更新下列使用者的資料: (Update data for the following user:) ";
$PMF_LANG["ad_log_usde"] = "刪除下列的使用者 (Deleted the following user): ";
$PMF_LANG["ad_log_beed"] = "編輯下列使用者 (Edit form for the following user): ";
$PMF_LANG["ad_log_bede"] = "刪除下列記錄: ";

$PMF_LANG["msgVisits"] = "訪客次數 (Visits)";
$PMF_LANG["ad_start_articles"] = "文章";
$PMF_LANG["ad_start_comments"] = "評論";


// Added v1.1 - 30.01.2002 - Bastian - admin - 管理
$PMF_LANG["ad_categ_paste"] = "貼上";
$PMF_LANG["ad_categ_cut"] = "剪下";
$PMF_LANG["msgCopy"] = "複製";
$PMF_LANG["ad_categ_process"] = "處理類別中...";

// Added v1.1.4 - 07.05.2002 - Thorsten 開發者
$PMF_LANG["err_NotAuth"] = "<strong>您沒有足夠的權限。</strong>";

// Added v1.2.3 - 29.11.2002 - Thorsten 開發者
$PMF_LANG["msgPreviusPage"] = "前一頁";
$PMF_LANG["msgNextPage"] = "下一頁";
$PMF_LANG["msgPageDoublePoint"] = "頁: ";
$PMF_LANG["msgMainCategory"] = "主類別";

// Added v1.2.4 - 30.01.2003 - Thorsten 開發者
$PMF_LANG["ad_passwdsuc"] = "您的密碼已變更完成。";

// Added v1.3.0 - 04.03.2003 - Thorsten 開發者
$PMF_LANG["ad_xml_gen"] = "建立 XML 匯出檔案 (Create XML export)";
$PMF_LANG["ad_entry_locale"] = "語言";
$PMF_LANG["msgLanguageSubmit"] = "變更語言";

// Added v1.3.1 - 29.04.2003 - Thorsten 開發者
$PMF_LANG["ad_attach_4"] = "上傳附加檔案必須小於 %s Bytes。 (The attached file must be smaller than %s Bytes.)";
$PMF_LANG["ad_menu_export"] = "匯出您的 FAQ ";

$PMF_LANG['permission::add_user'] = "新增使用者";
$PMF_LANG['permission::edit_user'] = "編輯使用者";
$PMF_LANG['permission::delete_user'] = "刪除使用者";
$PMF_LANG['permission::add_faq'] = "新增記錄";
$PMF_LANG['permission::edit_faq'] = "編輯記錄";
$PMF_LANG['permission::delete_faq'] = "刪除記錄";
$PMF_LANG['permission::viewlog'] = "檢視記錄黨";
$PMF_LANG['permission::adminlog'] = "檢視管理記錄檔 (View admin log)";
$PMF_LANG['permission::delcomment'] = "刪除評論 (Delete comment)";
$PMF_LANG['permission::addnews'] = "新增新聞 (Add news)";
$PMF_LANG['permission::editnews'] = "編輯新聞";
$PMF_LANG['permission::delnews'] = "刪除新聞";
$PMF_LANG['permission::addcateg'] = "新增類別";
$PMF_LANG['permission::editcateg'] = "編輯類別";
$PMF_LANG['permission::delcateg'] = "刪除類別";
$PMF_LANG['permission::passwd'] = "變更密碼";
$PMF_LANG['permission::editconfig'] = "編輯設定";
$PMF_LANG['permission::addatt'] = "新增附加檔案";
$PMF_LANG['permission::delatt'] = "刪除附加檔案";
$PMF_LANG['permission::backup'] = "建立備份";
$PMF_LANG['permission::restore'] = "還原備份";
$PMF_LANG['permission::delquestion'] = "刪除已開啟的問題 (delete opened question)";
$PMF_LANG['permission::changebtrevs'] = "編輯版次 (Edit revisions)";

$PMF_LANG["msgAttachedFiles"] = "附加檔案";

// Added v1.3.3 - 27.05.2003 - Thorsten 開發者
$PMF_LANG["ad_user_action"] = "動作";
$PMF_LANG["msgEmail"] = "Email";
$PMF_LANG["ad_entry_allowComments"] = "允許評論";
$PMF_LANG["msgWriteNoComment"] = "您不能在此留下評論";
$PMF_LANG["msgRealname"] = "真實姓名";
$PMF_LANG["ad_export_generate_pdf"] = "建立 PDF 檔案";
$PMF_LANG["ad_export_full_faq"] = "您的 FAQ 以輸出為一個 PDF 檔案: ";
$PMF_LANG["err_bannedIP"] = "您的 IP 來源位置已被禁止訪視。";
$PMF_LANG["err_SaveQuestion"] = "必要填寫欄位為 <strong>您的姓名</strong>，<strong>您的 email 信箱</strong>，<strong>您的提示問題</strong> 和，當提出要求，<strong><a href=\"https://en.wikipedia.org/wiki/Captcha\" title=\"閱讀更多關於 Captcha 於維基 Wikipedia\" target=\"_blank\">Captcha</a> 驗證碼</strong>。";

// added v1.4.0 - 2003-12-04 by Thorsten / Mathias 開發者
$LANG_CONF["main.language"] = array("select", "語言 Language");
$LANG_CONF["main.languageDetection"] = array("checkbox", "啟用自動語言選取偵測 Enable automatic language detection");
$LANG_CONF['main.titleFAQ'] = array("input", "您的 FAQ 標題抬頭 Title of your FAQ");
$LANG_CONF['main.currentVersion'] = array("print", "phpMyFAQ 版本 phpMyFAQ Version");
$LANG_CONF["main.metaDescription"] = array("input", "描述 Description");
$LANG_CONF["main.metaPublisher"] = array("input", "發佈者姓名 Name of the Publisher");
$LANG_CONF['main.administrationMail'] = array("input", "管理員的 Email 地址 <br>Email address of the Admin");
$LANG_CONF["main.contactInformation"] = array("area", "聯絡資訊 Contact information");
$LANG_CONF["main.send2friendText"] = array("area", "寄送給朋友的文字訊息頁面 Text for the send to friend page");
$LANG_CONF['records.maxAttachmentSize'] = array("input", "上傳檔案最大容量<br>Maximum size for attachments in Bytes (max. %sByte)");
$LANG_CONF["records.disableAttachments"] = array("checkbox", "啟用放加檔案預覽 Enable visibilty of attachments");
$LANG_CONF["main.enableUserTracking"] = array("checkbox", "啟用使用者追蹤 Enable user tracking");
$LANG_CONF["main.enableAdminLog"] = array("checkbox", "使用管理日誌檔案? use Adminlog?");
$LANG_CONF["security.ipCheck"] = array("checkbox", "管理區查看 IP Check the IP in administration");
$LANG_CONF["records.numberOfRecordsPerPage"] = array("input", "每頁顯示主題數 Number of displayed topics per page");
$LANG_CONF["records.numberOfShownNewsEntries"] = array("input", "新聞文章數目 Number of news articles");
$LANG_CONF['security.bannedIPs'] = array("area", "禁止訪問 IPs 位置 Ban these IPs");
$LANG_CONF["ldap.ldapSupport"] = array("checkbox", "啟用 LDAP 支援? (預設: 關閉) <br> Enable LDAP support? (default: disabled)");
$LANG_CONF["main.referenceURL"] = array("input", "URL 網址確認 (舉例: https://www.example.org/faq/) <br>URL for link verification (e.g.: https://www.example.org/faq/)");
$LANG_CONF["main.urlValidateInterval"] = array("input", "AJAX 連結確認時間(以秒計時) <br>Interval between AJAX link verification (in seconds)");
$LANG_CONF["records.enableVisibilityQuestions"] = array("checkbox", "新問題不可被顯示? Disable visibility of new questions?");
$LANG_CONF["security.permLevel"] = array("select", "權限等級 Permission level");

$PMF_LANG["ad_categ_new_main_cat"] = "為新的主類別 (as new main category)";
$PMF_LANG["ad_categ_paste_error"] = "不可移動此類別。 (Moving this category isn't possible.)";
$PMF_LANG["ad_categ_move"] = "移動類別 (move category)";
$PMF_LANG["ad_categ_lang"] = "語言 (Language)";
$PMF_LANG["ad_categ_desc"] = "敘述 (Description)";
$PMF_LANG["ad_categ_change"] = "變更與 (Change with)";

$PMF_LANG["lostPassword"] = "忘記密碼? (Password forgotten?)";
$PMF_LANG["lostpwd_err_1"] = "錯誤: 使用者名稱 與 email 沒有找到。(Error: Username and e-mail address not found.)";
$PMF_LANG["lostpwd_err_2"] = "錯誤: 不正確的 entries! (Error: Wrong entries!)";
$PMF_LANG["lostpwd_text_1"] = "謝謝您提出您的帳號資訊需求。 (Thank you for requesting your account information.)";
$PMF_LANG["lostpwd_text_2"] = "請重設您個個人密碼於管理員區。(Please set a new personal password in the admin section of your FAQ.)";
$PMF_LANG["lostpwd_mail_okay"] = "E-Mail已寄出。( E-Mail was sent.)";

$PMF_LANG["msgButtonFetchLatestVersion"] = "點選這裡來檢查您的 phpMyFAQ 安裝的版本 (Click to check version of your phpMyFAQ installation)";
$PMF_LANG["ad_xmlrpc_latest"] = "最新版本於 (Latest version available)";

// added v1.5.0 - 2005-07-31 by Thorsten 開發者
$PMF_LANG['ad_categ_select'] = "選取類別語言";

// added v1.5.1 - 2005-09-06 by Thorsten 開發者
$PMF_LANG['msgSitemap'] = "網站地圖";

// added v1.5.2 - 2005-09-23 by Lars 開發者
$PMF_LANG['err_inactiveArticle'] = "此 entry 在修正中，目前不能對外顯示。(Access denied)";
$PMF_LANG['msgArticleCategories'] = "此 entry 所屬的類別 (Categories for this entry)";

// added v1.6.0 - 2006-02-02 by Thorsten 開發者
$PMF_LANG['ad_entry_solution_id'] = "唯一答案 ID";
$PMF_LANG['ad_entry_faq_record'] = "FAQ 記錄";
$PMF_LANG['ad_entry_new_revision'] = "建立新的修正版次? Create new revision?";
$PMF_LANG['ad_entry_record_administration'] = "記錄管理 Record administration";
$PMF_LANG['ad_entry_changelog'] = "變更記錄 Changelog";
$PMF_LANG['ad_entry_revision'] = "修正版次 Revision";
$PMF_LANG['ad_changerev'] = "選擇修正版次 Select Revision";
$PMF_LANG['msgCaptcha'] = "請輸入 captcha 驗證碼";
$PMF_LANG['msgSelectCategories'] = "搜尋 ...";
$PMF_LANG['msgAllCategories'] = "... 所有類別";
$PMF_LANG['ad_you_should_update'] = "您的 phpMyFAQ 安裝已過時，您應該更新到最新的版本。";
$PMF_LANG['msgAdvancedSearch'] = "進階搜尋";

// added v1.6.1 - 2006-04-25 by Matteo簿 and Thorsten 開發者
$PMF_LANG['spamControlCenter'] = "惡意與垃圾活動-控制台 (Spam control center)";
$LANG_CONF["spam.enableSafeEmail"] = array("checkbox", "使用安全的方式列印使用者的 email (預設: 開啟)。 <br>Print user email in a safe way (default: enabled).");
$LANG_CONF["spam.checkBannedWords"] = array("checkbox", "Check public form content against banned words (default: enabled).");
$LANG_CONF["spam.enableCaptchaCode"] = array("checkbox", "使用 captcha 驗證碼來允許開放式的回覆 (預設: 開啟) <br>Use a captcha code to allow public form submission (default: enabled).");
$PMF_LANG['ad_session_expiring'] = "您的連線 session 時間將於 %d 分鐘結束: 您想要延長繼續使用嘛? (Your session will expire in %d minutes: would you like to go on working?)";

// added v1.6.2 - 2006-06-13 by Matteo 開發者
$PMF_LANG['ad_stat_management'] = "連線 Sessions 管理";
$PMF_LANG['ad_stat_choose'] = "選擇月份";
$PMF_LANG['ad_stat_delete'] = "馬上刪除已選取的連線 sessions?";

// added v2.0.0 - 2005-09-15 by Thorsten and by Minoru TODA 開發者
$PMF_LANG['ad_menu_glossary'] = "FAQ Glossary 專門辭典";
$PMF_LANG['ad_glossary_add'] = "新增辭典項目 (Add glossary entry)";
$PMF_LANG['ad_glossary_edit'] = "編輯辭典項目 (Edit glossary entry)";
$PMF_LANG['ad_glossary_item'] = "標題 (Title)";
$PMF_LANG['ad_glossary_definition'] = "定義 (Definition)";
$PMF_LANG['ad_glossary_save'] = "儲存辭典 (Save glossary)";
$PMF_LANG['ad_glossary_save_success'] = "辭典項目儲存成功! (Glossary entry successfully saved!)";
$PMF_LANG['ad_glossary_save_error'] = "辭典項目無法儲存，因為有錯誤發生。(The glossary entry could not saved because an error occurred.)";
$PMF_LANG['ad_glossary_update_success'] = "辭典項目更新成功! (Glossary entry successfully updated!)";
$PMF_LANG['ad_glossary_update_error'] = "辭典項目無法更新，因為有錯誤發生。The glossary entry could not updated because an error occurred.";
$PMF_LANG['ad_glossary_delete'] = "刪除項目 (Delete entry)";
$PMF_LANG['ad_glossary_delete_success'] = "辭典項目已刪除成功! (Glossary entry successfully deleted!)";
$PMF_LANG['ad_glossary_delete_error'] = "辭典項目無法刪除，因為有錯誤發生。 (The glossary entry could not deleted because an error occurred.)";
$PMF_LANG['msgNewQuestionVisible'] = "The question have to be reviewed first before getting public.";
$PMF_LANG['msgQuestionsWaiting'] = "等待管理員開放公開: (Waiting for publishing by the administrators: )";
$PMF_LANG['ad_entry_visibility'] = "公開發佈? (Publish?)";

// added v2.0.0 - 2006-01-02 by Lars 開發者
$PMF_LANG['ad_user_error_password'] = "請輸入密碼。 ";
$PMF_LANG['ad_user_error_passwordsDontMatch'] = "密碼不不符合。 (Passwords do not match.) ";
$PMF_LANG['ad_user_error_loginInvalid'] = "使用者名稱是無效的。 (The specified user name is invalid.)";
$PMF_LANG['ad_user_error_noEmail'] = "請輸入一個有效的 email 地址。(Please enter a valid mail address.) ";
$PMF_LANG['ad_user_error_noRealName'] = "請輸入您的真實姓名。(Please enter your real name. )";
$PMF_LANG['ad_user_error_delete'] = "使用者帳號不能被刪除。(User account could not be deleted. )";
$PMF_LANG['ad_user_error_noId'] = "沒有指定 ID。 (No ID specified.) ";
$PMF_LANG['ad_user_error_protectedAccount'] = "使用者帳號受到保護。(User account is protected. )";
$PMF_LANG['ad_user_deleteUser'] = "刪除使用者 (Delete User)";
$PMF_LANG['ad_user_status'] = "狀態: (Status:)";
$PMF_LANG['ad_user_lastModified'] = "最後一次修改: (last modified:)";
$PMF_LANG['ad_gen_cancel'] = "取消";
$PMF_LANG['permission::addglossary'] = "增加辭典項目 (add glossary item)";
$PMF_LANG['permission::editglossary'] = "編輯辭典項目 (edit glossary item)";
$PMF_LANG['permission::delglossary'] = "刪除辭典項目 (delete glossary item)";
$PMF_LANG["ad_menu_group_administration"] = "群組 Groups";
$PMF_LANG['ad_user_loggedin'] = "登入為 (Logged in as) ";

$PMF_LANG['ad_group_details'] = "群組細節 Group Details";
$PMF_LANG['ad_group_add'] = "新增群組 Add Group";
$PMF_LANG['ad_group_add_link'] = "新增 群組Add Group";
$PMF_LANG['ad_group_name'] = "名稱: (Name:)";
$PMF_LANG['ad_group_description'] = "描述: (Description:)";
$PMF_LANG['ad_group_autoJoin'] = "自動結合: (Auto-join:)";
$PMF_LANG['ad_group_suc'] = "群組<strong>已新增成功</strong>。(Group <strong>successfully</strong> added.)";
$PMF_LANG['ad_group_error_noName'] = "請輸入群組名稱。(Please enter a group name.) ";
$PMF_LANG['ad_group_error_delete'] = "該群組不能被刪除。(Group could not be deleted.) ";
$PMF_LANG['ad_group_deleted'] = "該群組已刪除成功。(The group was successfully deleted.)";
$PMF_LANG['ad_group_deleteGroup'] = "刪除群組 (Delete Group)";
$PMF_LANG['ad_group_deleteQuestion'] = "您確定要刪除此群組? (Are you sure you want to delete this group?)";
$PMF_LANG['ad_user_uncheckall'] = "全部反選 (Unselect All)";
$PMF_LANG['ad_group_membership'] = "群組會員 (Group Membership)";
$PMF_LANG['ad_group_members'] = "組員 Members";
$PMF_LANG['ad_group_addMember'] = "+";
$PMF_LANG['ad_group_removeMember'] = "-";

// added v2.0.0 - 2006-07-20 by Matteo 開發者
$PMF_LANG['ad_export_which_cat'] = "限制 FAQ 資料被輸出 (非必要選項) <br>Limit the FAQ data to be exported (optional)";
$PMF_LANG['ad_export_cat_downwards'] = "包含子類別? Include child categories?";
$PMF_LANG['ad_export_type'] = "輸出的格式 Format of the export";
$PMF_LANG['ad_export_type_choose'] = "支援格式 Supported formats";
$PMF_LANG['ad_export_download_view'] = '下載或是檢視? Download or view inline?';
$PMF_LANG['ad_export_download'] = "下載 download";
$PMF_LANG['ad_export_view'] = "檢視 view in-line";
$PMF_LANG['ad_export_gen_xhtml'] = "建立 XHTML 檔案 create XHTML file";

// added v2.0.0 - 2006-07-22 by Matteo 開發者
$PMF_LANG['ad_news_data'] = "FAQ 新聞 News";
$PMF_LANG['ad_news_author_name'] = "作者姓名 Author name";
$PMF_LANG['ad_news_author_email'] = "作者 Author email";
$PMF_LANG['ad_news_set_active'] = "啟用 Activate";
$PMF_LANG['ad_news_allowComments'] = "允許評論 Allow comments";
$PMF_LANG['ad_news_expiration_window'] = "新聞即將過期時間視窗 (非必要) News expiration time window (optional)";
$PMF_LANG['ad_news_from'] = "來自 From";
$PMF_LANG['ad_news_to'] = "至 To";
$PMF_LANG['ad_news_insertfail'] = "插入新聞項目至資料庫，發生錯誤。An error occurred inserting the news item into the database.";
$PMF_LANG['ad_news_updatefail'] = "更新新聞項目至資料庫，發生錯誤。An error occurred updating the news item into the database.";
$PMF_LANG['newsShowCurrent'] = "顯示目前新聞。Show current news.";
$PMF_LANG['newsShowArchive'] = "顯示已封存的歷史新聞。Show archived news.";
$PMF_LANG['newsArchive'] = " 封存的新聞歷史 News archive";
$PMF_LANG['newsWriteComment'] = "評論於此項目 comment on this entry";
$PMF_LANG['newsCommentDate'] = "新增於 Added at: ";

// added v2.0.0 - 2006-07-29 by Matteo & Thorsten 開發者
$PMF_LANG['ad_record_expiration_window'] = "記錄 - 時間即將過期視窗 (非必要) Record expiration time window (optional)";
$PMF_LANG['adminHeaderDashboard'] = "控制台 Dashboard";
$PMF_LANG['admin_mainmenu_users'] = "使用者們 Users";
$PMF_LANG['admin_mainmenu_content'] = "內容 Content";
$PMF_LANG['admin_mainmenu_statistics'] = "統計 Statistics";
$PMF_LANG['admin_mainmenu_backup'] = "備份 Backup";
$PMF_LANG['admin_mainmenu_configuration'] = "設定 Configuration";
$PMF_LANG['admin_mainmenu_logout'] = "登出 Logout";

// added v2.0.0 - 2006-08-15 by Thorsten and Matteo 開發者
$PMF_LANG["ad_categ_owner"] = "類別擁有者 CategoryHelper owner";
$PMF_LANG['adminSection'] = "系統管理 Administration";
$PMF_LANG['err_expiredArticle'] = "此 entry 已過期，與不能被顯示! This entry is expired and can not be displayed";
$PMF_LANG['err_expiredNews'] = "這條新聞已過期，與不能被顯示。This news is expired and can not be displayed";
$PMF_LANG['err_inactiveNews'] = "這條新聞是在所有的修改版本內，與不能被顯示 This news is in revision and can not be displayed";
$PMF_LANG['msgSearchOnAllLanguages'] = "搜尋所有的語言 search in all languages";
$PMF_LANG['ad_entry_tags'] = "標籤 Tags";
$PMF_LANG['msg_tags'] = "標籤 Tags";

// added v2.0.0 - 2006-09-02 by Thomas 開發者
$PMF_LANG['msg_related_articles'] = "相關 Related entries";
$LANG_CONF['records.numberOfRelatedArticles'] = array("input", "相關的件數 Number of related entries");

// added v2.0.0 - 2006-09-09 by Rudi 開發者
$PMF_LANG['ad_categ_trans_1'] = "翻譯 Translate";
$PMF_LANG['ad_categ_trans_2'] = "類別 Entity";
$PMF_LANG['ad_categ_translatecateg'] = "翻譯類別 Translate Entity";
$PMF_LANG['ad_categ_translate'] = "翻譯 Translate";
$PMF_LANG['ad_categ_transalready'] = "已經被翻譯於 Already translated in: ";
$PMF_LANG["ad_categ_deletealllang"] = "刪除所有語言下的 Delete in all languages?";
$PMF_LANG["ad_categ_deletethislang"] = "只刪除在此語言下? Delete in this language only?";
$PMF_LANG["ad_categ_translated"] = "此類別已被翻譯。 The category has been translated.";

// added v2.0.0 - 2006-09-21 by Rudi 開發者
$PMF_LANG["msgCategoryMatrix"] = "類別概況 CategoryHelper overview";
$PMF_LANG['ad_menu_categ_structure'] = "類別概況包含它的語言 Entity Overview including its languages";

// added v2.0.0 - 2006-09-26 by Thorsten 開發者
$PMF_LANG['ad_entry_userpermission'] = "使用者權限 User permissions";
$PMF_LANG['ad_entry_grouppermission'] = "群組權限 Group permissions";
$PMF_LANG['ad_entry_all_users'] = "全部使用者的存取 Access for all users";
$PMF_LANG['ad_entry_restricted_users'] = "限制存取 Restricted access to";
$PMF_LANG['ad_entry_all_groups'] = "全部群組的存取 Access for all groups";
$PMF_LANG['ad_entry_restricted_groups'] = "限制存取 Restricted access to";
$PMF_LANG['ad_session_expiration'] = "連線 Session 時間終止於 Session expires in";
$PMF_LANG['ad_user_active'] = "作用中 active";
$PMF_LANG['ad_user_blocked'] = "已封鎖 blocked";
$PMF_LANG['ad_user_protected'] = "已保護 protected";

// added v2.0.0 - 2006-10-07 by Matteo 開發者
$PMF_LANG['ad_entry_intlink'] = "選取一個 FAQ 記錄，以連結的方式來插入... Select a FAQ record to insert it as a link...";

//added 2.0.0 - 2006-10-10 by Rudi 開發者
$PMF_LANG["ad_categ_paste2"] = "下一頁 Paste after";
$PMF_LANG["msgCategoryRemark_overview"] = "如果全部類別都在語言的第一欄定義，類別的正確排序會顯示出來。The correct order of categories will be shown, if all categories are defined for the actual language (first column).";

// added v2.0.0 - 2006-10-15 by Matteo 開發者
$PMF_LANG['msgUsersOnline'] = "%d 位訪客 與 %d 已註冊<br>%d Guests and %d Registered";
$PMF_LANG['ad_adminlog_del_older_30d'] = "馬上刪除超過三十天的記錄檔 Immediately delete logs older than 30 days";
$PMF_LANG['ad_adminlog_delete_success'] = "舊的紀錄檔案已刪除成功。 Older logs successfully deleted.";
$PMF_LANG['ad_adminlog_delete_failure'] = "沒有記錄檔被刪除: 執行時發生錯誤。 No logs deleted: an error occurred performing the request.";

// added 2.0.0 - 2006-11-19 by Thorsten 開發者
$PMF_LANG['ad_quicklinks'] = "快速連結 Quicklinks";
$PMF_LANG['ad_quick_category'] = "新增類別 Add new category";
$PMF_LANG['ad_quick_record'] = "新增 FAQ 記錄 Add new FAQ record";
$PMF_LANG['ad_quick_user'] = "新增使用者 Add new user";
$PMF_LANG['ad_quick_group'] = "新增群組 Add new group";

// added v2.0.0 - 2006-12-30 by Matteo 開發者
$PMF_LANG['msgNewTranslationHeader'] = "翻譯建議 Translation proposal";
$PMF_LANG['msgNewTranslationAddon'] = "您的建議尚不能直接發佈，但是當管理員收到，必填欄位是 <strong>您的姓名</strong>，<strong>您的 email</strong>，<strong>您的問題翻譯</strong> 與 <strong>您的答案翻譯</strong>。請用逗號(,)來分隔關鍵字。<br>Your proposal will not be published right away, but will be released by the administrator upon receipt. Required  fields are <strong>your Name</strong>, <strong>your email address</strong>, <strong>your question translation</strong> and <strong>your answer translation</strong>. Please separate the keywords with commas only.";
$PMF_LANG['msgNewTransSourcePane'] = "原始程式碼區 Source pane";
$PMF_LANG['msgNewTranslationPane'] = "翻譯區 Translation pane";
$PMF_LANG['msgNewTranslationName'] = "您的姓名 Your Name";
$PMF_LANG['msgNewTranslationMail'] = "您的 email : <br>Your email address";
$PMF_LANG['msgNewTranslationKeywords'] = "關鍵字 Keywords";
$PMF_LANG['msgNewTranslationSubmit'] = "送出您的提議 Submit your proposal";
$PMF_LANG['msgTranslate'] = "翻譯此 FAQTranslate this FAQ";
$PMF_LANG['msgTranslateSubmit'] = "開始翻譯工作...<br>Start translation...";
$PMF_LANG['msgNewTranslationThanks'] = "感謝您的翻譯建議!<br>Thank you for your translation proposal!";

// added v2.0.0 - 2007-02-27 by Matteo 開發者
$PMF_LANG['permission::addgroup'] = "新增群組帳號 add group accounts";
$PMF_LANG['permission::editgroup'] = "編輯群組帳號 edit group accounts";
$PMF_LANG['permission::delgroup'] = "刪除群組帳號 delete group accounts";

// added v2.0.0 - 2007-02-27 by Thorsten 開發者
$PMF_LANG['ad_news_link_parent'] = "連結以現有視窗開啟 Link opens in parent window";

// added v2.0.0 - 2007-03-04 by Thorsten 開發者
$PMF_LANG['ad_menu_comments'] = "評論 Comments";
$PMF_LANG['adminHeaderComments'] = "評論管理 Comments administration";
$PMF_LANG['msgAdminCommentFaqs'] = "FAQ 記錄下的評論 Comments in FAQ records";
$PMF_LANG['msgAdminCommentNews'] = "新聞記錄下的評論 Comments in News records";
$PMF_LANG['msgPDF'] = "PDF 版本 version";
$PMF_LANG['ad_groups'] = "群組 Groups";

// added v2.0.0 - 2007-03-10 by Thorsten 開發者
$LANG_CONF['records.orderby'] = array("select", "記錄排序 Record sorting (依照特性 according to property)");
$LANG_CONF['records.sortby'] = array("select", "記錄排序 Record sorting (由上往下 或是 由下往上 descending or ascending)");
$PMF_LANG['ad_conf_order_id'] = "ID (預設 default)";
$PMF_LANG['ad_conf_order_thema'] = "標題 Title";
$PMF_LANG['ad_conf_order_visits'] = "訪客人數 Number of visitors";
$PMF_LANG['ad_conf_order_updated'] = "日期 Date";
$PMF_LANG['ad_conf_order_author'] = "作者 Author";
$PMF_LANG['ad_conf_desc'] = "由上往下降 descending";
$PMF_LANG['ad_conf_asc'] = "由下往上升 ascending";
$PMF_LANG['mainControlCenter'] = "主設定 Main configuration";
$PMF_LANG['recordsControlCenter'] = "FAQ 記錄設定 FAQ records configuration";

// added v2.0.0 - 2007-03-29 by Thorsten 開發者
$LANG_CONF['records.defaultActivation'] = array("checkbox", "啟用新紀錄 (預設: 關閉) <br>Activate new records (default: deactivated)");
$LANG_CONF['records.defaultAllowComments'] = array("checkbox", "允許新記錄可被留下評論 (預設: 關閉) <br>Allow comments for new records (default: disallowed)");

// added v2.0.0 - 2007-04-04 by Thorsten 開發者
$PMF_LANG['msgAllCatArticles'] = "此類別下的紀錄 Records in this category";
$PMF_LANG['msgTagSearch'] = "已註記的項目 Tagged entries";
$PMF_LANG['ad_pmf_info'] = "phpMyFAQ 資訊 Information";
$PMF_LANG['msgOnlineVersionCheck'] = "官方網站線上最新版本檢查 Online version check";
$PMF_LANG['ad_system_info'] = "系統資訊 System Information";

// added 2.5.0-alpha - 2008-01-25 by Elger 開發者
$PMF_LANG['msgRegisterUser'] = "註冊 Sign up";
$PMF_LANG["msgUsername"] = "登入名稱 Login name";
$PMF_LANG['errorRegistration'] = "此欄位是必需的! This field is required!";
$PMF_LANG['submitRegister'] = "建立 Create";
$PMF_LANG['msgUserData'] = "註冊需要提供使用者資訊 User information required for registration";
$PMF_LANG['captchaError'] = "請輸入正確的 captcha 驗證碼 ! Please enter the right captcha code!";
$PMF_LANG['msgRegError'] = "下列錯誤發生，請修正: <br>Following errors occurred. Please correct them";
$PMF_LANG['successMessage'] = "您的註冊成功，您很快會收到一封確認郵件，內有您的登入資訊。<br>Your registration was successful. You will soon receive a confirmation mail with your login data!";
$PMF_LANG['msgRegThankYou'] = "感謝您的註冊! Thank you for your registration!";
$PMF_LANG['emailRegSubject'] = "[%sitename%] 註冊 Registration: 新使用者 new user";

// added 2.5.0-alpha2 - 2009-01-24 by Thorsten 開發者
$PMF_LANG['msgMostPopularSearches'] = "熱門搜尋是: The most popular searches are";
$LANG_CONF['main.enableWysiwygEditor'] = array("checkbox", "啟用內建的所見即得的文字編輯器 (WYSIWYG editor) <br> Enable bundled WYSIWYG editor (default: enabled)");

// added 2.5.0-beta - 2009-03-30 by Anatoliy 開發者
$PMF_LANG['ad_menu_searchstats'] = "搜尋統計 Search Statistics";
$PMF_LANG['ad_searchstats_search_term'] = "關鍵字 Keyword";
$PMF_LANG['ad_searchstats_search_term_count'] = "次數 Count";
$PMF_LANG['ad_searchstats_search_term_lang'] = "語言 Language";
$PMF_LANG['ad_searchstats_search_term_percentage'] = "% 百分比 Percentage";

// added 2.5.0-beta - 2009-03-31 by Anatoliy 開發者
$PMF_LANG['ad_record_sticky'] = "置頂 Sticky";
$PMF_LANG['ad_entry_sticky'] = "置頂 Sticky";
$PMF_LANG['stickyRecordsHeader'] = "置頂 FAQs Sticky FAQs";

// added 2.5.0-beta - 2009-04-01 by Anatoliy 開發者
$PMF_LANG['ad_menu_stopwordsconfig'] = "禁止字串 Stop Words";
$PMF_LANG['ad_config_stopword_input'] = "新增禁止字串 Add new stop word";

// added 2.5.0-beta - 2009-04-06 by Anatoliy 開發者
$PMF_LANG['msgSendMailDespiteEverything'] = "不，沒有合適的答案(將會以 email 寄送)。<br>No, there is still no adequate answer (will send the mail)";
$PMF_LANG['msgSendMailIfNothingIsFound'] = "需要的答案是否列在上方的結果? Is the wanted answer listed in the results above?";

// added 2.5.0-RC - 2009-05-11 by Anatoliy & Thorsten 開發者
$PMF_LANG['msgChooseLanguageToTranslate'] = "請選擇要翻譯的語言 <br>Please choose the language for translation";
$PMF_LANG['ad_menu_translations'] = "使用者介面翻譯 Interface Translation";
$PMF_LANG['ad_start_notactive'] = "等待被啟用 Waiting for activation";

// added 2.5.0-RC - 2009-05-20 by Anatoliy 開發者
$PMF_LANG['msgTransToolAddNewTranslation'] = "增加新的語言翻譯 Add new translation";
$PMF_LANG['msgTransToolLanguage'] = "語言 Language";
$PMF_LANG['msgTransToolActions'] = "動作 Actions";
$PMF_LANG['msgTransToolWritable'] = "可被寫入 Writable";
$PMF_LANG['msgEdit'] = "編輯 Edit";
$PMF_LANG['msgDelete'] = "刪除 Delete";
$PMF_LANG['msgYes'] = "是 yes";
$PMF_LANG['msgNo'] = "否 no";
$PMF_LANG['msgVariable'] = "變數 Variable";
$PMF_LANG['msgCancel'] = "取消 Cancel";
$PMF_LANG['msgSave'] = "儲存 Save";
$PMF_LANG['msgSaving3Dots'] = "儲存中 saving ...";
$PMF_LANG['msgRemoving3Dots'] = "移除中... removing ...";
$PMF_LANG['msgLanguage'] = "語言 Language";
$PMF_LANG['msgTransToolLanguageCharset'] = "語言的文字編碼字串 Language charset";
$PMF_LANG['msgTransToolLanguageDir'] = "語言方向 Language direction";
$PMF_LANG['msgTransToolLanguageDesc'] = "語言描述 Language description";
$PMF_LANG['msgAuthor'] = "作者 Author";
$PMF_LANG['msgTransToolAddAuthor'] = "新增作者 Add author";
$PMF_LANG['msgTransToolCreateTranslation'] = "建立翻譯 Create Translation";
$PMF_LANG['msgTransToolTransCreated'] = "新的翻譯已成功建立 New translation successfully created";
$PMF_LANG['msgTransToolCouldntCreateTrans'] = "無法建立新翻譯 Could not create the new translation";
$PMF_LANG['msgAdding3Dots'] = "新增中... adding ...";
$PMF_LANG['msgTransToolSendToTeam'] = "寄給 phpMyFAQ 團隊 Send to phpMyFAQ team";
$PMF_LANG['msgSending3Dots'] = "寄送中... sending ...";
$PMF_LANG['msgTransToolFileSent'] = "語言檔案已成功寄送給 phpMyFAQ 團隊，非常感謝您的分享。Language file was successfully sent to the phpMyFAQ team. Thank you very much for sharing it.";
$PMF_LANG['msgTransToolErrorSendingFile'] = "寄送語言檔案，發生問題。There was an error while sending the language file";
$PMF_LANG['msgTransToolPercent'] = "% 百分比 Percentage";

// added 2.5.0-RC3 - 2009-06-23 by Anatoliy 開發者
$LANG_CONF['records.attachmentsPath'] = array("input", "附加檔案的儲存路徑。<br><small>於網頁根目錄下的相對路徑</small>Path where attachments will be saved.<br><small>Relative path means a folder within web root</small>");

// added 2.5.0-RC3 - 2009-06-24 by Anatoliy
$PMF_LANG['msgAttachmentNotFound'] = "您嘗試下載的檔案，不在此主機上。(The file you're trying to download was not found on this server)";
$PMF_LANG['ad_sess_noentry'] = "沒有內容 (No entry)";

// added 2.6.0-alpha - 2009-07-30 by Aurimas Fi禳eras 開發者
//P.S. "One User online" is also possible, since sprintf just ignores extra args
$PMF_LANG["plmsgUserOnline"][0] = "%d 位使用者在線上 (user online)";
$PMF_LANG["plmsgUserOnline"][1] = "%d 位使用者們在線上 (users online)";

// added 2.6.0-alpha - 2009-08-02 by Anatoliy 開發者
$LANG_CONF['layout.templateSet'] = array("select", "設定要使用的佈景 (Template set to be used)");

// added 2.6.0-alpha - 2009-08-16 by Aurimas Fi禳eras - Plural messages - 複數訊息
$PMF_LANG["plmsgHomeArticlesOnline"][0] = "線上有 %d 筆 FAQ";
$PMF_LANG["plmsgHomeArticlesOnline"][1] = "線上有 %d 筆 FAQs ";
$PMF_LANG["plmsgViews"][0] = "%d 檢視";
$PMF_LANG["plmsgViews"][1] = "%d 檢視s";

// added 2.6.0-alpha - 2009-08-30 by Aurimas Fi禳eras - Plural messages - 複數訊息
$PMF_LANG['plmsgGuestOnline'][0] = "%d 位訪客";
$PMF_LANG['plmsgGuestOnline'][1] = "%d 位訪客們";
$PMF_LANG['plmsgRegisteredOnline'][0] = " 與 %d 位已註冊";
$PMF_LANG['plmsgRegisteredOnline'][1] = " 與 %d 位已註冊";
$PMF_LANG["plmsgSearchAmount"][0] = "%d 搜尋結果";
$PMF_LANG["plmsgSearchAmount"][1] = "%d 搜尋結果s";
$PMF_LANG["plmsgPagesTotal"][0] = " %d 頁";
$PMF_LANG["plmsgPagesTotal"][1] = " %d 頁s";
$PMF_LANG["plmsgVotes"][0] = "%d 票";
$PMF_LANG["plmsgVotes"][1] = "%d 票s";
$PMF_LANG["plmsgEntries"][0] = "%d FAQ";
$PMF_LANG["plmsgEntries"][1] = "%d FAQs";

// added 2.6.0-alpha - 2009-09-06 by Aurimas Fi禳eras 開發者
$PMF_LANG['permission::addtranslation'] = "新增翻譯";
$PMF_LANG['permission::edittranslation'] = "編輯翻譯";
$PMF_LANG['permission::deltranslation'] = "刪除翻譯";
$PMF_LANG['permission::approverec'] = "通過審核的記錄 (approve records)";

// added 2.6.0-alpha - 2009-09-9 by Anatoliy Belsky 開發者
$LANG_CONF["records.enableAttachmentEncryption"] = array("checkbox", "啟用附加檔案加密 <br><small>若是上傳附加檔案設定是關閉的，此選項會被忽略。</small><br>Enable attachment encryption <br><small>Ignored when attachments is disabled</small>");
$LANG_CONF["records.defaultAttachmentEncKey"] = array("input", '預設附加檔案加密金鑰 <br><small>附加檔案加密如果是關閉的，便會忽略。</small><br><small><font color="red">強烈注意: 開啟檔案加密之後，以後不可變更!!!</font></small><br>Default attachment encryption key <br><small>Ignored if attachment encryption is disabled</small><br><small><font color="red">WARNING: Do not change this once set and enabled file encryption!!!</font></small>');

// added 2.6.0-alpha - 2009-09-06 by Thorsten 開發者
$PMF_LANG['ad_menu_upgrade'] = "phpMyFAQ Upgrade";
$PMF_LANG['ad_you_shouldnt_update'] = "您已是最新的 phpMyFAQ 版本，無需升級。(You have the latest version of phpMyFAQ. You do not need to upgrade.)";
$LANG_CONF['security.useSslForLogins'] = array("checkbox", "只允許以 SSL 安全性連線登入嘛? (預設: 關閉) <br>Only allow logins over SSL connection? (default: disabled)");
$PMF_LANG['msgSecureSwitch'] = "切換到安全模式來登入! (Switch to secure mode to login!)";

// added 2.6.0-alpha - 2009-10-03 by Anatoliy Belsky 開發者
$PMF_LANG['msgTransToolNoteFileSaving'] = "請注意，請按儲存(save)按鈕才會儲存檔案。(Please note that no files will we written until you click save button)";
$PMF_LANG['msgTransToolPageBufferRecorded'] = "頁面 %d 暫存 buffer 記錄成功 (Page %d buffer recorded successfully)";
$PMF_LANG['msgTransToolErrorRecordingPageBuffer'] = "錯誤記錄頁面 %d 暫存 buffer (Error recording page %d buffer)";
$PMF_LANG['msgTransToolRecordingPageBuffer'] = "記錄頁面 %d 暫存 buffer (Recording page %d buffer)";

// added 2.6.0-alpha - 2009-11-02 by Anatoliy Belsky 開發者
$PMF_LANG['ad_record_active'] = "有作用";

// added 2.6.0-alpha - 2009-11-01 by Anatoliy Belsky 開發者
$PMF_LANG['msgAttachmentInvalid'] = "附加檔案無效，請通報管理員。(The attachment is invalid, please inform admin.)";

// added 2.6.0-alpha - 2009-11-02 by max 開發者
$LANG_CONF['search.numberSearchTerms'] = array("input", "Number of listed search terms");
$LANG_CONF['records.orderingPopularFaqs'] = array("select", "排列熱門的 FAQ's<br> Sorting of the top FAQ's");
$PMF_LANG['list_all_users'] = "列出所有使用者 (List all users)";

$PMF_LANG['records.orderingPopularFaqs.visits'] = "列出最多訪問的 entries (list most visited entries)";
$PMF_LANG['records.orderingPopularFaqs.voting'] = "列出最多得票的 entries (list most voted entries)";

// added 2.6.0-alpha - 2009-11-05 by Thorsten 開發者
$PMF_LANG['msgShowHelp'] = "請用逗號(,)來分隔字串。 (Please seperate words by comma.)";

// added 2.6.0-RC - 2009-11-30 by Thorsten 開發者
$PMF_LANG['msgUpdateFaqDate'] = "更新";
$PMF_LANG['msgKeepFaqDate'] = "保留";
$PMF_LANG['msgEditFaqDat'] = "編輯";

// added v2.6.99 - 2010-11-24 by Gustavo Solt 開發者
$LANG_CONF['search.relevance'] = array("select", "Sort by relevance");
$LANG_CONF["search.enableRelevance"] = array("checkbox", "啟用關連支援? (預設: 關閉) Activate relevance support? (default: disabled)");
$PMF_LANG['searchControlCenter'] = "搜尋";
$PMF_LANG['search.relevance.thema-content-keywords'] = "問題 - 答案 - 關鍵字";
$PMF_LANG['search.relevance.thema-keywords-content'] = "問題 - 關鍵字 - 答案";
$PMF_LANG['search.relevance.content-thema-keywords'] = "答案 - 問題 - 關鍵字";
$PMF_LANG['search.relevance.content-keywords-thema'] = "答案 - 關鍵字 - 問題";
$PMF_LANG['search.relevance.keywords-content-thema'] = "關鍵字 - 答案 - 問題";
$PMF_LANG['search.relevance.keywords-thema-content'] = "關鍵字 - 問題 - 答案";

// added 2.7.0-alpha - 2010-09-13 by Thorsten 開發者
$PMF_LANG['msgLoginUser'] = "登入 Login";

// added 2.7.0-alpha - 2010-12-21 by Anatoliy Belsky 開發者
$PMF_LANG["ad_menu_attachments"] = "FAQ 附加檔案 (Attachments)";
$PMF_LANG["ad_menu_attachment_admin"] = "附加檔案管理 (Attachment administration)";
$PMF_LANG['msgAttachmentsFilename'] = "檔案名稱";
$PMF_LANG['msgAttachmentsFilesize'] = "檔案大小";
$PMF_LANG['msgAttachmentsMimeType'] = "MIME 類型";
$PMF_LANG['msgAttachmentsWannaDelete'] = "您確定要刪除這個附加檔案嘛? ";
$PMF_LANG['msgAttachmentsDeleted'] = "附加檔案 <strong>刪除成功</strong>。";

// added v2.7.0-alpha2 - 2010-01-12 by Gustavo Solt 開發者
$PMF_LANG['ad_menu_reports'] = "報告";
$PMF_LANG["ad_stat_report_fields"] = "欄位";
$PMF_LANG["ad_stat_report_category"] = "類別";
$PMF_LANG["ad_stat_report_sub_category"] = "子類別";
$PMF_LANG["ad_stat_report_translations"] = "語言翻譯";
$PMF_LANG["ad_stat_report_language"] = "語系";
$PMF_LANG["ad_stat_report_id"] = "FAQ ID";
$PMF_LANG["ad_stat_report_sticky"] = "置頂 FAQ (Sticky FAQ)";
$PMF_LANG["ad_stat_report_title"] = "問題 ";
$PMF_LANG["ad_stat_report_creation_date"] = "日期";
$PMF_LANG["ad_stat_report_owner"] = "原始作者";
$PMF_LANG["ad_stat_report_last_modified_person"] = "上位作者";
$PMF_LANG["ad_stat_report_url"] = "URL 網址";
$PMF_LANG["ad_stat_report_visits"] = "訪問次數 (Visits)";
$PMF_LANG["ad_stat_report_make_report"] = "產生報告 (Generate Report)";
$PMF_LANG["ad_stat_report_make_csv"] = "輸出為 CSV (Export to CSV)";

// added v2.7.0-alpha2 - 2010-02-05 by Thorsten Rinne 開發者
$PMF_LANG['msgRegistration'] = "註冊 Registration";
$PMF_LANG['msgRegistrationCredentials'] = "註冊 - 請輸入您的姓名，使用者登入名稱，與有效的 email! (To register please enter your name, your loginname and a valid email address!)";
$PMF_LANG['msgRegistrationNote'] = "若是註冊成功，您會收到一個來自管理者同意的回覆 email。 (After successful registration you will receive an answer soon after Administration has authorized your registration.)";

// added v2.7.0-beta - 2011-06-13 by Thorsten 開發者
$PMF_LANG['ad_entry_changelog_history'] = "異動日誌歷史記錄 (Changelog history)";

// added v2.7.0-beta2 - 2011-06-22 by Thorsten 開發者
$LANG_CONF['security.ssoSupport'] = array("checkbox", "Single Sign On Support (default: deactivated)");
$LANG_CONF['security.ssoLogoutRedirect'] = array("input", "Single Sign On logout redirect service URL");
$LANG_CONF['main.dateFormat'] = array("input", "日期格式 (預設: 年-月-日 時:分) <br>Date format (default: Y-m-d H:i)");
$LANG_CONF['security.enableLoginOnly'] = array("checkbox", "Complete secured FAQ (default: deactivated)");

// added v2.7.0-RC - 2011-08-18 by Thorsten 開發者
$PMF_LANG['securityControlCenter'] = "安全性設定 Security configuration";
$PMF_LANG['ad_search_delsuc'] = "搜尋 term 刪除成功。(The search term was successfully deleted.)";
$PMF_LANG['ad_search_delfail'] = "搜尋 term 沒有被刪除。 (The search term was not deleted.)";

// added 2.7.1 - 2011-09-30 by Thorsten 開發者
$PMF_LANG['msg_about_faq'] = "關於此 FAQ <br>About this FAQ";
$LANG_CONF['security.useSslOnly'] = array("checkbox", "FAQ 只能使用 SSL 安全連線 (預設: 關閉不啟用)<br>FAQ with SSL only (default: deactivated)");
$PMF_LANG['msgTableOfContent'] = "目錄 (Table of Content)";

// added 2.7.5 - 2012-03-02 by Thorsten 開發者
$PMF_LANG["msgExportAllFaqs"] = "列印全部為 PDF 檔案 (Print all as PDF)";
$PMF_LANG["msgOnlineVerificationCheck"] = "您安裝的線上 phpMyFAQ 確認檢查，位於您安裝的主機上。 (Online verification check)";
$PMF_LANG["msgOnlineVerificationCheckButton"] = "點選來檢查您的 phpMyFAQ 安裝是否沒有問題 (Click to verify your phpMyFAQ installation)";
$PMF_LANG["ad_verification_notokay"] = "您的 phpMyFAQ 版本有語系檔異動: (Your version of phpMyFAQ has local changes:)";
$PMF_LANG["ad_verification_okay"] = "您的 phpMyFAQ 版本已驗證完成。 (Your version of phpMyFAQ was successfully verified.)";

// added v2.8.0-alpha - 2011-09-29 by Thorsten 開發者
$PMF_LANG['msgAdminSearchFaqs'] = "FAQs 的搜尋 (Search for FAQs)";

// added v2.8.0-alpha - 2012-01-13 by Peter 開發者
$LANG_CONF["records.enableCloseQuestion"] = array("checkbox", "待回答問題有答案後，便關?<br>Close open question after answer?");
$LANG_CONF["records.enableDeleteQuestion"] = array("checkbox", "待回答問題有答案後，便刪除? <br>Delete open question after answer?");
$PMF_LANG["msg2answerFAQ"] = "已被回答 (Answered)";

// added v2.8.0-alpha - 2012-01-16 by Thorsten 開發者
$PMF_LANG["headerUserControlPanel"] = "使用者控制台";

// added v2.8.0-alpha2 - 2012-03-15 by Thorsten 開發者
$PMF_LANG["rememberMe"] = "記住我";
$PMF_LANG["ad_menu_instances"] = "多個 FAQ 站台 (Multi-sites)";

// added v2.8.0-alpha2 - 2012-08-06 by Thorsten 開發者
$PMF_LANG['ad_record_inactive'] = "FAQS 目前沒有作用 (FAQs inactive)";
$LANG_CONF["main.maintenanceMode"] = array("checkbox", "設定 FAQ 為維護模式 Set FAQ in maintenance mode");
$PMF_LANG['msgMode'] = "樣式 (Modus)";
$PMF_LANG['msgMaintenanceMode'] = "FAQ 在維護中 (is in maintenance)";
$PMF_LANG['msgOnlineMode'] = "FAQ 在線上 (is online)";

// added v2.8.0-alpha3 - 2012-08-30 by Thorsten 開發者
$PMF_LANG['msgShowMore'] = " 顯示更多 (show more)";
$PMF_LANG['msgQuestionAnswered'] = "問題已被回答 (Question answered)";
$PMF_LANG['msgMessageQuestionAnswered'] = "您的問題 %s 已被回答，請Your question at %s was answered. Please check it here";

// added v2.8.0-alpha3 - 2012-11-03 by Thorsten
$PMF_LANG["permission"]["addattachment"] = "權限 - 新增附加檔案 Right to add attachments";
$PMF_LANG["permission"]["editattachment"] = "權限 - 編輯附加檔案 Right to edit attachments";
$PMF_LANG["permission"]["delattachment"] = "權限 - 刪除附加檔案 Right to delete attachments";
$PMF_LANG["permission"]["dlattachment"] = "權限 - 下載附加檔案  Right to download attachments";
$PMF_LANG["permission"]["reports"] = "權限 - 產生報告 Right to generate reports";
$PMF_LANG["permission"]["addfaq"] = "權限 - 可在前端新增 FAQs Right to add FAQs in frontend";
$PMF_LANG["permission"]["addquestion"] = "權限 - 可在前端新增問題 Right to add questions in frontend";
$PMF_LANG["permission"]["addcomment"] = "權限 - 可在前端新增回覆 Right to add comments in frontend";
$PMF_LANG["permission"]["editinstances"] = "權限 - 編輯多網站的 instances Right to edit multi-site instances";
$PMF_LANG["permission"]["addinstances"] = "權限 - 新增多網站的 instances Right to add multi-site instances";
$PMF_LANG["permission"]["delinstances"] = "權限 - 刪除多網站的 instances Right to delete multi-site instances";
$PMF_LANG["permission"]["export"] = "權限 - 完整輸出 FAQ Right to export the complete FAQ";

// added v2.8.0-beta - 2012-12-24 by Thorsten 開發者
$LANG_CONF["records.randomSort"] = array("checkbox", "亂數排序 FAQs (預設: 關閉)<br>Sort FAQs randomly (default: deactivated)");
$LANG_CONF['main.enableWysiwygEditorFrontend'] = array("checkbox", "前台啟用內建的所見即得編輯器 (WYSIWYG) (預設: 關閉)<br>Enable bundled WYSIWYG editor in frontend (default: disabled)");

// added v2.8.0-beta3 - 2013-01-15 by Thorsten 開發者
$LANG_CONF["main.enableGravatarSupport"] = array("checkbox", "個人頭像支援 (預設: 關閉) <br>Gravatar Support (default: disabled)");

// added v2.8.0-RC - 2013-01-29 by Thorsten 開發者
$PMF_LANG["ad_stopwords_desc"] = "請選擇一個語系，用以新增或是編輯不雅字串，字串不會顯示。 (Please select a language to add or edit stopwords.)";
$PMF_LANG["ad_visits_per_day"] = "每日到訪次數 (Visits per day)";

// added v2.8.0-RC2 - 2013-02-17 by Thorsten 開發者
$PMF_LANG["ad_instance_add"] = "新增一個 phpMyFAQ 多網站實例 (Add a new phpMyFAQ multi site instance)";
$PMF_LANG["ad_instance_error_notwritable"] = "多網站的網頁資料夾不可被寫入。<br> <br>The folder /multisite isn\'t writable.";
$PMF_LANG["ad_instance_url"] = "實例 URL 網址 (Instance URL)";
$PMF_LANG["ad_instance_path"] = "實例路徑 (Instance path)";
$PMF_LANG["ad_instance_name"] = "實例名稱 (Instance name)";
$PMF_LANG["ad_instance_email"] = "您的管理者 email (Your admin email)";
$PMF_LANG["ad_instance_admin"] = "管理者登入名稱 (Admin login name)";
$PMF_LANG["ad_instance_password"] = "管理者密碼 (Admin password)";
$PMF_LANG["ad_instance_hint"] = "注意: 需要一些時間來建立一個新的 phpMyFAQ 實例! (Caution: It will take some seconds to create a new phpMyFAQ instance!)";
$PMF_LANG["ad_instance_button"] = "儲存實例 (Save instance)";
$PMF_LANG["ad_instance_error_cannotdelete"] = "不能刪除實例 (Could not delete instance) ";
$PMF_LANG["ad_instance_config"] = "實例設定 (Instance configuration)";

// added v2.8.0-RC3 - 2013-03-03 by Thorsten 開發者
$PMF_LANG["msgAboutThisNews"] = "關於此新聞";

// added v.2.8.1 - 2013-06-23 by Thorsten 開發者
$PMF_LANG["msgAccessDenied"] = "存取拒絕。";

return $PMF_LANG;
