<?php

/**
 * @OA\Schema(
 *   schema="Expense",
 *   type="object",
 *       @OA\Property(property="id", type="string", example="Opnel5aKBz", description="The expense hashed id"),
 *       @OA\Property(property="user_id", type="string", example="", description="The user hashed id"),
 *       @OA\Property(property="assigned_user_id", type="string", example="", description="The assigned user hashed id"),
 *       @OA\Property(property="company_id", type="string", example="", description="The company hashed id"),
 *       @OA\Property(property="client_id", type="string", example="", description="The client hashed id"),
 *       @OA\Property(property="invoice_id", type="string", example="", description="The related invoice hashed id"),
 *       @OA\Property(property="bank_id", type="string", example="", description="The bank id related to this expense"),
 *       @OA\Property(property="invoice_currency_id", type="string", example="", description="The currency id of the related invoice"),
 *       @OA\Property(property="expense_currency_id", type="string", example="", description="The currency id of the expense"),
 *       @OA\Property(property="invoice_category_id", type="string", example="", description="The invoice category id"),
 *       @OA\Property(property="payment_type_id", type="string", example="", description="The payment type id"),
 *       @OA\Property(property="recurring_expense_id", type="string", example="", description="The related recurring expense this expense was created from"),
 *       @OA\Property(property="private_notes", type="string", example="", description="The private notes of the expense"),
 *       @OA\Property(property="public_notes", type="string", example="", description="The public notes of the expense"),
 *       @OA\Property(property="transaction_reference", type="string", example="", description="The transaction references of the expense"),
 *       @OA\Property(property="transcation_id", type="string", example="", description="The transaction id of the expense"),
 *       @OA\Property(property="custom_value1", type="string", example="", description="A custom value"),
 *       @OA\Property(property="custom_value2", type="string", example="", description="A custom value"),
 *       @OA\Property(property="custom_value3", type="string", example="", description="A custom value"),
 *       @OA\Property(property="custom_value4", type="string", example="", description="A custom value"),
 *       @OA\Property(property="tax_name1", type="string", example="", description="Tax name"),
 *       @OA\Property(property="tax_name2", type="string", example="", description="Tax name"),
 *       @OA\Property(property="tax_rate1", type="number", format="float", example="10.00", description="Tax rate"),
 *       @OA\Property(property="tax_rate2", type="number", format="float", example="10.00", description="Tax rate"),
 *       @OA\Property(property="tax_name3", type="string", example="", description="Tax name"),
 *       @OA\Property(property="tax_rate3", type="number", format="float", example="10.00", description="Tax rate"),
 *       @OA\Property(property="amount", type="number", format="float", example="10.00", description="The total expense amont"),
 *       @OA\Property(property="foreign_amount", type="number", format="float", example="10.00", description="The total foreign amount of the expense"),
 *       @OA\Property(property="exchange_rate", type="number", format="float", example="0.80", description="The exchange rate at the time of the expense"),
 *       @OA\Property(property="date", type="string", example="2022-12-01", description="The expense date formate Y-m-d"),
 *       @OA\Property(property="payment_date", type="string", example="", description="The date of payment for the expense, format Y-m-d"),
 *       @OA\Property(property="should_be_invoiced", type="boolean", example=true, description="Flag whether the expense should be invoiced"),
 *       @OA\Property(property="is_deleted", type="boolean", example=true, description="Boolean determining whether the expense has been deleted"),
 *       @OA\Property(property="invoice_documents", type="boolean", example=true, description="Passing the expense documents over to the invoice"),
 *       @OA\Property(property="updated_at", type="number", format="integer", example="1434342123", description="Timestamp"),
 *       @OA\Property(property="archived_at", type="number", format="integer", example="1434342123", description="Timestamp"),
 * )
 */
