<?php

namespace Checkout\Payments\Request;

use Checkout\Common\CustomerRequest;
use Checkout\Common\MarketplaceData;
use Checkout\Payments\BillingDescriptor;
use Checkout\Payments\Request\Source\AbstractRequestSource;
use Checkout\Payments\Sender\PaymentSender;
use Checkout\Payments\PaymentRecipient;
use Checkout\Payments\ProcessingSettings;
use Checkout\Payments\RiskRequest;
use Checkout\Payments\ShippingDetails;
use Checkout\Payments\ThreeDsRequest;
use DateTime;

class PaymentRequest
{
    /**
     * @var string
     */
    public $payment_context_id;

    /**
     * @var AbstractRequestSource
     */
    public $source;

    /**
     * @var int
     */
    public $amount;

    /**
     * @var string value of Currency
     */
    public $currency;

    /**
     * @var string value of PaymentType
     */
    public $payment_type;

    /**
     * @var bool
     */
    public $merchant_initiated;

    /**
     * @var string
     */
    public $reference;

    /**
     * @var string
     */
    public $description;

    /**
     * @var Authentication
     */
    public $authentication;

    /**
     * @var string value of AuthorizationType
     */
    public $authorization_type;

    /**
     * @var PartialAuthorization
     */
    public $partial_authorization;

    /**
     * @var bool
     */
    public $capture;

    /**
     * @var DateTime
     */
    public $capture_on;

    /**
     * @var CustomerRequest
     */
    public $customer;

    /**
     * @var BillingDescriptor
     */
    public $billing_descriptor;

    /**
     * @var ShippingDetails
     */
    public $shipping;

    /**
     * @var PaymentSegment
     */
    public $segment;

    /**
     * @var ThreeDsRequest
     */
    public $three_ds;

    /**
     * @var string
     */
    public $processing_channel_id;

    /**
     * @var string
     */
    public $previous_payment_id;

    /**
     * @var RiskRequest
     */
    public $risk;

    /**
     * @var string
     */
    public $success_url;

    /**
     * @var string
     */
    public $failure_url;

    /**
     * @var string
     */
    public $payment_ip;

    /**
     * @var PaymentSender
     */
    public $sender;

    /**
     * @var PaymentRecipient
     */
    public $recipient;

    /**
     * @deprecated This property will be removed in the future, and should be used {@link amount_allocations} instead
     * @var MarketplaceData
     */
    public $marketplace;

    /**
     * @var array values of AmountAllocations
     */
    public $amount_allocations;

    /**
     * @var ProcessingSettings
     */
    public $processing;

    /**
     * @var array
     */
    public $metadata;

    /**
     * @var array of Checkout\Payments\Product
     */
    public $items;

    /**
     * @var PaymentRetryRequest
     */
    public $retry;

    /**
     * @var PaymentInstruction
     */
    public $instruction;
}
