<?php

/**
 * Invoice Ninja (https://invoiceninja.com).
 *
 * @link https://github.com/invoiceninja/invoiceninja source repository
 *
 * @copyright Copyright (c) 2025. Invoice Ninja LLC (https://invoiceninja.com)
 *
 * @license https://www.elastic.co/licensing/elastic-license
 */

namespace App\Http\Controllers;

use App\Models\CompanyToken;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class LogoutController extends BaseController
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @OA\Post(
     *      path="/api/v1/logout",
     *      operationId="getLogout",
     *      tags={"logout"},
     *      summary="Gets a list of logout",
     *      description="Lists all logout",
     *      @OA\Parameter(ref="#/components/parameters/X-API-TOKEN"),
     *      @OA\Parameter(ref="#/components/parameters/X-Requested-With"),
     *      @OA\Parameter(ref="#/components/parameters/include"),
     *      @OA\Parameter(ref="#/components/parameters/index"),
     *      @OA\Response(
     *          response=200,
     *          description="Success message",
     *          @OA\Header(header="X-MINIMUM-CLIENT-VERSION", ref="#/components/headers/X-MINIMUM-CLIENT-VERSION"),
     *          @OA\Header(header="X-RateLimit-Remaining", ref="#/components/headers/X-RateLimit-Remaining"),
     *          @OA\Header(header="X-RateLimit-Limit", ref="#/components/headers/X-RateLimit-Limit"),
     *       ),
     *       @OA\Response(
     *          response=422,
     *          description="Validation error",
     *          @OA\JsonContent(ref="#/components/schemas/ValidationError"),
     *       ),
     *       @OA\Response(
     *           response="default",
     *           description="Unexpected Error",
     *           @OA\JsonContent(ref="#/components/schemas/Error"),
     *       ),
     *     )
     * @param Request $request
     * @return Response| \Illuminate\Http\JsonResponse|mixed
     */
    public function index(Request $request)
    {
        $ct = CompanyToken::with('company.tokens')
                    ->where('token', $request->header('X-API-TOKEN'))
                    ->first();

        $ct->company
                    ->tokens()
                    ->where('is_system', true)
                    ->cursor()
                    ->each(function ($ct) {
                        $ct->token = \Illuminate\Support\Str::random(64);
                        $ct->save();
                    });

        return response()->json(['message' => 'All tokens deleted'], 200);
    }
}
