<?php

/**
 * @OA\Schema(
 *   schema="Client",
 *   type="object",
 *       @OA\Property(property="id", type="string", example="Opnel5aKBz", description="The hashed id of the client"),
 *       @OA\Property(property="user_id", type="string", example="", description="The hashed id of the user"),
 *       @OA\Property(property="company_id", type="string", example="", description="The hashed id of the company"),
 *       @OA\Property(
 *       	property="contacts",
 *        	type="array",
 *        	@OA\Items(
 *           	ref="#/components/schemas/ClientContact",
 *          ),
 *       ),
 *       @OA\Property(property="name", type="string", example="Jims housekeeping", description="The client name"),
 *       @OA\Property(property="website", type="string", example="www.jims.com", description="The client website"),
 *       @OA\Property(property="private_notes", type="string", example="These are very private notes", description="Private notes on the client"),
 *       @OA\Property(property="client_hash", type="string", example="asdfkjhk342hjhbfdvmnfb1", description="The client hash"),
 *       @OA\Property(property="industry_id", type="number", example="5", description="The industry id of the client"),
 *       @OA\Property(property="size_id", type="number", example="2", description="The size id of the client"),
 *       @OA\Property(property="address1", type="string", example="", description="Address line 1"),
 *       @OA\Property(property="address2", type="string", example="", description="Address line 2"),
 *       @OA\Property(property="city", type="string", example="Beverley Hills", description="City"),
 *       @OA\Property(property="state", type="string", example="Californnia", description="State/Locality"),
 *       @OA\Property(property="postal_code", type="string", example="90210", description="Zip / Postal code"),
 *       @OA\Property(property="phone", type="string", example="555-3434-3434", description="The client phone number"),
 *       @OA\Property(property="country_id", type="number", format="integer", example="1", description="The client country id"),
 *       @OA\Property(property="custom_value1", type="string", example="Something custom", description="A custom value"),
 *       @OA\Property(property="custom_value2", type="string", example="2002-01-01", description="A custom value"),
 *       @OA\Property(property="custom_value3", type="string", example="Something custom", description="A custom value"),
 *       @OA\Property(property="custom_value4", type="string", example="Something custom", description="A custom value"),
 *       @OA\Property(property="vat_number", type="string", example="VAT123", description="The client VAT number"),
 *       @OA\Property(property="id_number", type="string", example="CLIENT_ID_NUMBER", description=" The client id number"),
 *       @OA\Property(property="number", type="string", example="", description="The client number - assigned by the system typically"),
 *       @OA\Property(property="shipping_address1", type="string", example="5 Wallaby Way", description="The shipping address line 1"),
 *       @OA\Property(property="shipping_address2", type="string", example="Suite 5", description="The shipping address line 2"),
 *       @OA\Property(property="shipping_city", type="string", example="Perth", description="The shipping city"),
 *       @OA\Property(property="shipping_state", type="string", example="Western Australia", description="The shipping state"),
 *       @OA\Property(property="shipping_postal_code", type="string", example="6110", description="The shipping postal code"),
 *       @OA\Property(property="shipping_country_id", type="number", format="integer", example="4", description="The shipping country id"),
 *       @OA\Property(property="is_deleted", type="boolean", example=true, description="Boolean flagged determining if the client has been deleted"),
 *       @OA\Property(property="balance", type="number", format="float", example="10.00", description="The client balance"),
 *       @OA\Property(property="paid_to_date", type="number", format="float", example="10.00", description="The amount the client has paid to date."),
 *       @OA\Property(property="credit_balance", type="number", format="float", example="10.00", description="An amount which is available to the client for future use."),
 *       @OA\Property(property="last_login", type="number", format="integer", example="134341234234", description="Timestamp"),
 *       @OA\Property(property="created_at", type="number", format="integer", example="134341234234", description="Timestamp"),
 *       @OA\Property(property="updated_at", type="number", format="integer", example="134341234234", description="Timestamp"),
 *       @OA\Property(property="settings",ref="#/components/schemas/CompanySettings"),
 * )
 */
