<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* ChatMessageType File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;

use Microsoft\Graph\Core\Enum;

/**
* ChatMessageType class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class ChatMessageType extends Enum
{
    /**
    * The Enum ChatMessageType
    */
    const MESSAGE = "message";
    const CHAT_EVENT = "chatEvent";
    const TYPING = "typing";
    const UNKNOWN_FUTURE_VALUE = "unknownFutureValue";
    const SYSTEM_EVENT_MESSAGE = "systemEventMessage";
}
