<?php
//
// WARNING: Do not edit by hand, this file was generated by Crank:
// https://github.com/gocardless/crank
//

namespace GoCardlessPro\Integration;

class CurrencyExchangeRatesIntegrationTest extends IntegrationTestBase
{
    public function testResourceModelExists()
    {
        $obj = new \GoCardlessPro\Resources\CurrencyExchangeRate(array());
        $this->assertNotNull($obj);
    }
    
    public function testCurrencyExchangeRatesList()
    {
        $fixture = $this->loadJsonFixture('currency_exchange_rates')->list;
        $this->stub_request($fixture);

        $service = $this->client->currencyExchangeRates();
        $response = call_user_func_array(array($service, 'list'), (array)$fixture->url_params);

        $body = $fixture->body->currency_exchange_rates;
    
        $records = $response->records;
        $this->assertInstanceOf('\GoCardlessPro\Core\ListResponse', $response);
        $this->assertInstanceOf('\GoCardlessPro\Resources\CurrencyExchangeRate', $records[0]);

        $this->assertEquals($fixture->body->meta->cursors->before, $response->before);
        $this->assertEquals($fixture->body->meta->cursors->after, $response->after);
    

    
        foreach (range(0, count($body) - 1) as $num) {
            $record = $records[$num];
            $this->assertEquals($body[$num]->rate, $record->rate);
            $this->assertEquals($body[$num]->source, $record->source);
            $this->assertEquals($body[$num]->target, $record->target);
            $this->assertEquals($body[$num]->time, $record->time);
            
        }

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
}
