<?php

/**
 * This file is a part of horstoeko/orderx.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\orderx\codelists;

/**
 * Class representing the Allowance codes
 *
 * @category Order-X
 * @package  Order-X
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/orderx
 */
class OrderAllowanceCodes
{
    /**
     * Bonus for works ahead of schedule
     */
    const BONUS_FOR_WORKS_AHEAD_OF_SCHEDULE = "41";

    /**
     * Other bonus
     */
    const OTHER_BONUS = "42";

    /**
     * Manufacturer’s consumer discount
     */
    const MANUFACTURERS_CONSUMER_DISCOUNT = "60";

    /**
     * Due to military status
     */
    const DUE_TO_MILITARY_STATUS = "62";

    /**
     * Due to work accident
     */
    const DUE_TO_WORK_ACCIDENT = "63";

    /**
     * Special agreement
     */
    const SPECIAL_AGREEMENT = "64";

    /**
     * Production error discount
     */
    const PRODUCTION_ERROR_DISCOUNT = "65";

    /**
     * New outlet discount
     */
    const NEW_OUTLET_DISCOUNT = "66";

    /**
     * Sample discount
     */
    const SAMPLE_DISCOUNT = "67";

    /**
     * End-of-range discount
     */
    const ENDOFRANGE_DISCOUNT = "68";

    /**
     * Incoterm discount
     */
    const INCOTERM_DISCOUNT = "70";

    /**
     * Point of sales threshold allowance
     */
    const POINT_OF_SALES_THRESHOLD_ALLOWANCE = "71";

    /**
     * Material surcharge/deduction
     */
    const MATERIAL_SURCHARGE_DEDUCTION = "88";

    /**
     * Discount
     */
    const DISCOUNT = "95";

    /**
     * Special rebate
     */
    const SPECIAL_REBATE = "100";

    /**
     * Fixed long term
     */
    const FIXED_LONG_TERM = "102";

    /**
     * Temporary
     */
    const TEMPORARY = "103";

    /**
     * Standard
     */
    const STANDARD = "104";

    /**
     * Yearly turnover
     */
    const YEARLY_TURNOVER = "105";
}
