<?php

/**
 * This file is a part of horstoeko/orderx.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\orderx\codelists;

/**
 * Class representing the Country Codes
 *
 * @category Order-X
 * @package  Order-X
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/orderx
 */
class OrderCountryCodes
{
    /**
     * Andorra
     */
    const ANDORRA = "AD";

    /**
     * United Arab Emirates (the)
     */
    const UNITED_ARAB_EMIRATES_THE = "AE";

    /**
     * Afghanistan
     */
    const AFGHANISTAN = "AF";

    /**
     * Antigua and Barbuda
     */
    const ANTIGUA_AND_BARBUDA = "AG";

    /**
     * Anguilla
     */
    const ANGUILLA = "AI";

    /**
     * Albania
     */
    const ALBANIA = "AL";

    /**
     * Armenia
     */
    const ARMENIA = "AM";

    /**
     * Angola
     */
    const ANGOLA = "AO";

    /**
     * Antarctica
     */
    const ANTARCTICA = "AQ";

    /**
     * Argentina
     */
    const ARGENTINA = "AR";

    /**
     * American Samoa
     */
    const AMERICAN_SAMOA = "AS";

    /**
     * Austria
     */
    const AUSTRIA = "AT";

    /**
     * Australia
     */
    const AUSTRALIA = "AU";

    /**
     * Aruba
     */
    const ARUBA = "AW";

    /**
     * Åland Islands
     */
    const LAND_ISLANDS = "AX";

    /**
     * Azerbaijan
     */
    const AZERBAIJAN = "AZ";

    /**
     * Bosnia and Herzegovina
     */
    const BOSNIA_AND_HERZEGOVINA = "BA";

    /**
     * Barbados
     */
    const BARBADOS = "BB";

    /**
     * Bangladesh
     */
    const BANGLADESH = "BD";

    /**
     * Belgium
     */
    const BELGIUM = "BE";

    /**
     * Burkina Faso
     */
    const BURKINA_FASO = "BF";

    /**
     * Bulgaria
     */
    const BULGARIA = "BG";

    /**
     * Bahrain
     */
    const BAHRAIN = "BH";

    /**
     * Burundi
     */
    const BURUNDI = "BI";

    /**
     * Benin
     */
    const BENIN = "BJ";

    /**
     * Saint Barthélemy
     */
    const SAINT_BARTHLEMY = "BL";

    /**
     * Bermuda
     */
    const BERMUDA = "BM";

    /**
     * Brunei Darussalam
     */
    const BRUNEI_DARUSSALAM = "BN";

    /**
     * Bolivia (Plurinational State of)
     */
    const BOLIVIA_PLURINATIONAL_STATE_OF = "BO";

    /**
     * Bonaire, Sint Eustatius and Saba
     */
    const BONAIRE_SINT_EUSTATIUS_AND_SABA = "BQ";

    /**
     * Brazil
     */
    const BRAZIL = "BR";

    /**
     * Bahamas (the)
     */
    const BAHAMAS_THE = "BS";

    /**
     * Bhutan
     */
    const BHUTAN = "BT";

    /**
     * Bouvet Island
     */
    const BOUVET_ISLAND = "BV";

    /**
     * Botswana
     */
    const BOTSWANA = "BW";

    /**
     * Belarus
     */
    const BELARUS = "BY";

    /**
     * Belize
     */
    const BELIZE = "BZ";

    /**
     * Canada
     */
    const CANADA = "CA";

    /**
     * Cocos (Keeling) Islands (the)
     */
    const COCOS_KEELING_ISLANDS_THE = "CC";

    /**
     * Congo (the Democratic Republic of the)
     */
    const CONGO_THE_DEMOCRATIC_REPUBLIC_OF_THE = "CD";

    /**
     * Central African Republic (the)
     */
    const CENTRAL_AFRICAN_REPUBLIC_THE = "CF";

    /**
     * Congo (the)
     */
    const CONGO_THE = "CG";

    /**
     * Switzerland
     */
    const SWITZERLAND = "CH";

    /**
     * Côte d'Ivoire
     */
    const CTE_DIVOIRE = "CI";

    /**
     * Cook Islands (the)
     */
    const COOK_ISLANDS_THE = "CK";

    /**
     * Chile
     */
    const CHILE = "CL";

    /**
     * Cameroon
     */
    const CAMEROON = "CM";

    /**
     * China
     */
    const CHINA = "CN";

    /**
     * Colombia
     */
    const COLOMBIA = "CO";

    /**
     * Costa Rica
     */
    const COSTA_RICA = "CR";

    /**
     * Cuba
     */
    const CUBA = "CU";

    /**
     * Cabo Verde
     */
    const CABO_VERDE = "CV";

    /**
     * Curaçao
     */
    const CURAAO = "CW";

    /**
     * Christmas Island
     */
    const CHRISTMAS_ISLAND = "CX";

    /**
     * Cyprus
     */
    const CYPRUS = "CY";

    /**
     * Czechia
     */
    const CZECHIA = "CZ";

    /**
     * Germany
     */
    const GERMANY = "DE";

    /**
     * Djibouti
     */
    const DJIBOUTI = "DJ";

    /**
     * Denmark
     */
    const DENMARK = "DK";

    /**
     * Dominica
     */
    const DOMINICA = "DM";

    /**
     * Dominican Republic (the)
     */
    const DOMINICAN_REPUBLIC_THE = "DO";

    /**
     * Algeria
     */
    const ALGERIA = "DZ";

    /**
     * Ecuador
     */
    const ECUADOR = "EC";

    /**
     * Estonia
     */
    const ESTONIA = "EE";

    /**
     * Egypt
     */
    const EGYPT = "EG";

    /**
     * Western Sahara*
     */
    const WESTERN_SAHARA = "EH";

    /**
     * Eritrea
     */
    const ERITREA = "ER";

    /**
     * Spain
     */
    const SPAIN = "ES";

    /**
     * Ethiopia
     */
    const ETHIOPIA = "ET";

    /**
     * Finland
     */
    const FINLAND = "FI";

    /**
     * Fiji
     */
    const FIJI = "FJ";

    /**
     * Falkland Islands (the) [Malvinas]
     */
    const FALKLAND_ISLANDS_THE_MALVINAS = "FK";

    /**
     * Micronesia (Federated States of)
     */
    const MICRONESIA_FEDERATED_STATES_OF = "FM";

    /**
     * Faroe Islands (the)
     */
    const FAROE_ISLANDS_THE = "FO";

    /**
     * France
     */
    const FRANCE = "FR";

    /**
     * Gabon
     */
    const GABON = "GA";

    /**
     * United Kingdom of Great Britain and Northern Ireland (the)
     */
    const UNITED_KINGDOM_OF_GREAT_BRITAIN_AND_NORTHERN_IRELAND_THE = "GB";

    /**
     * Grenada
     */
    const GRENADA = "GD";

    /**
     * Georgia
     */
    const GEORGIA = "GE";

    /**
     * French Guiana
     */
    const FRENCH_GUIANA = "GF";

    /**
     * Guernsey
     */
    const GUERNSEY = "GG";

    /**
     * Ghana
     */
    const GHANA = "GH";

    /**
     * Gibraltar
     */
    const GIBRALTAR = "GI";

    /**
     * Greenland
     */
    const GREENLAND = "GL";

    /**
     * Gambia (the)
     */
    const GAMBIA_THE = "GM";

    /**
     * Guinea
     */
    const GUINEA = "GN";

    /**
     * Guadeloupe
     */
    const GUADELOUPE = "GP";

    /**
     * Equatorial Guinea
     */
    const EQUATORIAL_GUINEA = "GQ";

    /**
     * Greece
     */
    const GREECE = "GR";

    /**
     * South Georgia and the South Sandwich Islands
     */
    const SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS = "GS";

    /**
     * Guatemala
     */
    const GUATEMALA = "GT";

    /**
     * Guam
     */
    const GUAM = "GU";

    /**
     * Guinea-Bissau
     */
    const GUINEABISSAU = "GW";

    /**
     * Guyana
     */
    const GUYANA = "GY";

    /**
     * Hong Kong
     */
    const HONG_KONG = "HK";

    /**
     * Heard Island and McDonald Islands
     */
    const HEARD_ISLAND_AND_MCDONALD_ISLANDS = "HM";

    /**
     * Honduras
     */
    const HONDURAS = "HN";

    /**
     * Croatia
     */
    const CROATIA = "HR";

    /**
     * Haiti
     */
    const HAITI = "HT";

    /**
     * Hungary
     */
    const HUNGARY = "HU";

    /**
     * Indonesia
     */
    const INDONESIA = "ID";

    /**
     * Ireland
     */
    const IRELAND = "IE";

    /**
     * Israel
     */
    const ISRAEL = "IL";

    /**
     * Isle of Man
     */
    const ISLE_OF_MAN = "IM";

    /**
     * India
     */
    const INDIA = "IN";

    /**
     * British Indian Ocean Territory (the)
     */
    const BRITISH_INDIAN_OCEAN_TERRITORY_THE = "IO";

    /**
     * Iraq
     */
    const IRAQ = "IQ";

    /**
     * Iran (Islamic Republic of)
     */
    const IRAN_ISLAMIC_REPUBLIC_OF = "IR";

    /**
     * Iceland
     */
    const ICELAND = "IS";

    /**
     * Italy
     */
    const ITALY = "IT";

    /**
     * Jersey
     */
    const JERSEY = "JE";

    /**
     * Jamaica
     */
    const JAMAICA = "JM";

    /**
     * Jordan
     */
    const JORDAN = "JO";

    /**
     * Japan
     */
    const JAPAN = "JP";

    /**
     * Kenya
     */
    const KENYA = "KE";

    /**
     * Kyrgyzstan
     */
    const KYRGYZSTAN = "KG";

    /**
     * Cambodia
     */
    const CAMBODIA = "KH";

    /**
     * Kiribati
     */
    const KIRIBATI = "KI";

    /**
     * Comoros (the)
     */
    const COMOROS_THE = "KM";

    /**
     * Saint Kitts and Nevis
     */
    const SAINT_KITTS_AND_NEVIS = "KN";

    /**
     * Korea (the Democratic People's Republic of)
     */
    const KOREA_THE_DEMOCRATIC_PEOPLES_REPUBLIC_OF = "KP";

    /**
     * Korea (the Republic of)
     */
    const KOREA_THE_REPUBLIC_OF = "KR";

    /**
     * Kuwait
     */
    const KUWAIT = "KW";

    /**
     * Cayman Islands (the)
     */
    const CAYMAN_ISLANDS_THE = "KY";

    /**
     * Kazakhstan
     */
    const KAZAKHSTAN = "KZ";

    /**
     * Lao People's Democratic Republic (the)
     */
    const LAO_PEOPLES_DEMOCRATIC_REPUBLIC_THE = "LA";

    /**
     * Lebanon
     */
    const LEBANON = "LB";

    /**
     * Saint Lucia
     */
    const SAINT_LUCIA = "LC";

    /**
     * Liechtenstein
     */
    const LIECHTENSTEIN = "LI";

    /**
     * Sri Lanka
     */
    const SRI_LANKA = "LK";

    /**
     * Liberia
     */
    const LIBERIA = "LR";

    /**
     * Lesotho
     */
    const LESOTHO = "LS";

    /**
     * Lithuania
     */
    const LITHUANIA = "LT";

    /**
     * Luxembourg
     */
    const LUXEMBOURG = "LU";

    /**
     * Latvia
     */
    const LATVIA = "LV";

    /**
     * Libya
     */
    const LIBYA = "LY";

    /**
     * Morocco
     */
    const MOROCCO = "MA";

    /**
     * Monaco
     */
    const MONACO = "MC";

    /**
     * Moldova (the Republic of)
     */
    const MOLDOVA_THE_REPUBLIC_OF = "MD";

    /**
     * Montenegro
     */
    const MONTENEGRO = "ME";

    /**
     * Saint Martin (French part)
     */
    const SAINT_MARTIN_FRENCH_PART = "MF";

    /**
     * Madagascar
     */
    const MADAGASCAR = "MG";

    /**
     * Marshall Islands (the)
     */
    const MARSHALL_ISLANDS_THE = "MH";

    /**
     * North Macedonia
     */
    const NORTH_MACEDONIA = "MK";

    /**
     * Mali
     */
    const MALI = "ML";

    /**
     * Myanmar
     */
    const MYANMAR = "MM";

    /**
     * Mongolia
     */
    const MONGOLIA = "MN";

    /**
     * Macao
     */
    const MACAO = "MO";

    /**
     * Northern Mariana Islands (the)
     */
    const NORTHERN_MARIANA_ISLANDS_THE = "MP";

    /**
     * Martinique
     */
    const MARTINIQUE = "MQ";

    /**
     * Mauritania
     */
    const MAURITANIA = "MR";

    /**
     * Montserrat
     */
    const MONTSERRAT = "MS";

    /**
     * Malta
     */
    const MALTA = "MT";

    /**
     * Mauritius
     */
    const MAURITIUS = "MU";

    /**
     * Maldives
     */
    const MALDIVES = "MV";

    /**
     * Malawi
     */
    const MALAWI = "MW";

    /**
     * Mexico
     */
    const MEXICO = "MX";

    /**
     * Malaysia
     */
    const MALAYSIA = "MY";

    /**
     * Mozambique
     */
    const MOZAMBIQUE = "MZ";

    /**
     * Namibia
     */
    const NAMIBIA = "NA";

    /**
     * New Caledonia
     */
    const NEW_CALEDONIA = "NC";

    /**
     * Niger (the)
     */
    const NIGER_THE = "NE";

    /**
     * Norfolk Island
     */
    const NORFOLK_ISLAND = "NF";

    /**
     * Nigeria
     */
    const NIGERIA = "NG";

    /**
     * Nicaragua
     */
    const NICARAGUA = "NI";

    /**
     * Netherlands (the)
     */
    const NETHERLANDS_THE = "NL";

    /**
     * Norway
     */
    const NORWAY = "NO";

    /**
     * Nepal
     */
    const NEPAL = "NP";

    /**
     * Nauru
     */
    const NAURU = "NR";

    /**
     * Niue
     */
    const NIUE = "NU";

    /**
     * New Zealand
     */
    const NEW_ZEALAND = "NZ";

    /**
     * Oman
     */
    const OMAN = "OM";

    /**
     * Panama
     */
    const PANAMA = "PA";

    /**
     * Peru
     */
    const PERU = "PE";

    /**
     * French Polynesia
     */
    const FRENCH_POLYNESIA = "PF";

    /**
     * Papua New Guinea
     */
    const PAPUA_NEW_GUINEA = "PG";

    /**
     * Philippines (the)
     */
    const PHILIPPINES_THE = "PH";

    /**
     * Pakistan
     */
    const PAKISTAN = "PK";

    /**
     * Poland
     */
    const POLAND = "PL";

    /**
     * Saint Pierre and Miquelon
     */
    const SAINT_PIERRE_AND_MIQUELON = "PM";

    /**
     * Pitcairn
     */
    const PITCAIRN = "PN";

    /**
     * Puerto Rico
     */
    const PUERTO_RICO = "PR";

    /**
     * Palestine, State of
     */
    const PALESTINE_STATE_OF = "PS";

    /**
     * Portugal
     */
    const PORTUGAL = "PT";

    /**
     * Palau
     */
    const PALAU = "PW";

    /**
     * Paraguay
     */
    const PARAGUAY = "PY";

    /**
     * Qatar
     */
    const QATAR = "QA";

    /**
     * Réunion
     */
    const RUNION = "RE";

    /**
     * Romania
     */
    const ROMANIA = "RO";

    /**
     * Serbia
     */
    const SERBIA = "RS";

    /**
     * Russian Federation (the)
     */
    const RUSSIAN_FEDERATION_THE = "RU";

    /**
     * Rwanda
     */
    const RWANDA = "RW";

    /**
     * Saudi Arabia
     */
    const SAUDI_ARABIA = "SA";

    /**
     * Solomon Islands
     */
    const SOLOMON_ISLANDS = "SB";

    /**
     * Seychelles
     */
    const SEYCHELLES = "SC";

    /**
     * Sudan (the)
     */
    const SUDAN_THE = "SD";

    /**
     * Sweden
     */
    const SWEDEN = "SE";

    /**
     * Singapore
     */
    const SINGAPORE = "SG";

    /**
     * Saint Helena, Ascension and Tristan da Cunha
     */
    const SAINT_HELENA_ASCENSION_AND_TRISTAN_DA_CUNHA = "SH";

    /**
     * Slovenia
     */
    const SLOVENIA = "SI";

    /**
     * Svalbard and Jan Mayen
     */
    const SVALBARD_AND_JAN_MAYEN = "SJ";

    /**
     * Slovakia
     */
    const SLOVAKIA = "SK";

    /**
     * Sierra Leone
     */
    const SIERRA_LEONE = "SL";

    /**
     * San Marino
     */
    const SAN_MARINO = "SM";

    /**
     * Senegal
     */
    const SENEGAL = "SN";

    /**
     * Somalia
     */
    const SOMALIA = "SO";

    /**
     * Suriname
     */
    const SURINAME = "SR";

    /**
     * South Sudan
     */
    const SOUTH_SUDAN = "SS";

    /**
     * Sao Tome and Principe
     */
    const SAO_TOME_AND_PRINCIPE = "ST";

    /**
     * El Salvador
     */
    const EL_SALVADOR = "SV";

    /**
     * Sint Maarten (Dutch part)
     */
    const SINT_MAARTEN_DUTCH_PART = "SX";

    /**
     * Syrian Arab Republic (the)
     */
    const SYRIAN_ARAB_REPUBLIC_THE = "SY";

    /**
     * Eswatini
     */
    const ESWATINI = "SZ";

    /**
     * Turks and Caicos Islands (the)
     */
    const TURKS_AND_CAICOS_ISLANDS_THE = "TC";

    /**
     * Chad
     */
    const CHAD = "TD";

    /**
     * French Southern Territories (the)
     */
    const FRENCH_SOUTHERN_TERRITORIES_THE = "TF";

    /**
     * Togo
     */
    const TOGO = "TG";

    /**
     * Thailand
     */
    const THAILAND = "TH";

    /**
     * Tajikistan
     */
    const TAJIKISTAN = "TJ";

    /**
     * Tokelau
     */
    const TOKELAU = "TK";

    /**
     * Timor-Leste
     */
    const TIMORLESTE = "TL";

    /**
     * Turkmenistan
     */
    const TURKMENISTAN = "TM";

    /**
     * Tunisia
     */
    const TUNISIA = "TN";

    /**
     * Tonga
     */
    const TONGA = "TO";

    /**
     * Turkey
     */
    const TURKEY = "TR";

    /**
     * Trinidad and Tobago
     */
    const TRINIDAD_AND_TOBAGO = "TT";

    /**
     * Tuvalu
     */
    const TUVALU = "TV";

    /**
     * Taiwan (Province of China)
     */
    const TAIWAN_PROVINCE_OF_CHINA = "TW";

    /**
     * Tanzania, the United Republic of
     */
    const TANZANIA_THE_UNITED_REPUBLIC_OF = "TZ";

    /**
     * Ukraine
     */
    const UKRAINE = "UA";

    /**
     * Uganda
     */
    const UGANDA = "UG";

    /**
     * United States Minor Outlying Islands (the)
     */
    const UNITED_STATES_MINOR_OUTLYING_ISLANDS_THE = "UM";

    /**
     * United States of America (the)
     */
    const UNITED_STATES_OF_AMERICA_THE = "US";

    /**
     * Uruguay
     */
    const URUGUAY = "UY";

    /**
     * Uzbekistan
     */
    const UZBEKISTAN = "UZ";

    /**
     * Holy See (the)
     */
    const HOLY_SEE_THE = "VA";

    /**
     * Saint Vincent and the Grenadines
     */
    const SAINT_VINCENT_AND_THE_GRENADINES = "VC";

    /**
     * Venezuela (Bolivarian Republic of)
     */
    const VENEZUELA_BOLIVARIAN_REPUBLIC_OF = "VE";

    /**
     * Virgin Islands (British)
     */
    const VIRGIN_ISLANDS_BRITISH = "VG";

    /**
     * Virgin Islands (U.S.)
     */
    const VIRGIN_ISLANDS_US = "VI";

    /**
     * Viet Nam
     */
    const VIET_NAM = "VN";

    /**
     * Vanuatu
     */
    const VANUATU = "VU";

    /**
     * Wallis and Futuna
     */
    const WALLIS_AND_FUTUNA = "WF";

    /**
     * Samoa
     */
    const SAMOA = "WS";

    /**
     * Yemen
     */
    const YEMEN = "YE";

    /**
     * Mayotte
     */
    const MAYOTTE = "YT";

    /**
     * South Africa
     */
    const SOUTH_AFRICA = "ZA";

    /**
     * Zambia
     */
    const ZAMBIA = "ZM";

    /**
     * Zimbabwe
     */
    const ZIMBABWE = "ZW";

    /**
     * Kosovo
     */
    const KOSOVO = "1A";
}
