<?php

namespace CleverIt\UBL\Invoice;

/**
 * Class representing PartyNameType
 *
 * ABIE
 *  Party Name. Details
 *  A class for defining the name of a party.
 *  Party Name
 * XSD Type: PartyNameType
 */
class PartyNameType
{

    /**
     * BBIE
     *  Party Name. Name
     *  The name of the party.
     *  1
     *  Party Name
     *  Name
     *  Name
     *  Name. Type
     *  Microsoft
     *
     * @var \CleverIt\UBL\Invoice\Name $name
     */
    private $name = null;

    /**
     * Gets as name
     *
     * BBIE
     *  Party Name. Name
     *  The name of the party.
     *  1
     *  Party Name
     *  Name
     *  Name
     *  Name. Type
     *  Microsoft
     *
     * @return \CleverIt\UBL\Invoice\Name
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets a new name
     *
     * BBIE
     *  Party Name. Name
     *  The name of the party.
     *  1
     *  Party Name
     *  Name
     *  Name
     *  Name. Type
     *  Microsoft
     *
     * @param \CleverIt\UBL\Invoice\Name $name
     * @return self
     */
    public function setName(\CleverIt\UBL\Invoice\Name $name)
    {
        $this->name = $name;
        return $this;
    }


}

