<?php

/**
 * This file is a part of horstoeko/orderx.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\orderx\codelists;

/**
 * Class representing the Electronic address scheme identifiers
 *
 * @category Order-X
 * @package  Order-X
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/orderx
 */
class OrderSchemeIdentifiers
{
    /**
     * System Information et Repertoire des Entreprise et des Etablissements:
     * SIRENE
     */
    const ISO_6523_0002 = '0002';

    /**
     * Codification Numerique des Etablissments Financiers En Belgique
     */
    const ISO_6523_0003 = '0003';

    /**
     * NBS/OSI NETWORK
     */
    const ISO_6523_0004 = '0004';

    /**
     * USA FED GOV OSI NETWORK
     */
    const ISO_6523_0005 = '0005';

    /**
     * USA DOD OSI NETWORK
     */
    const ISO_6523_0006 = '0006';

    /**
     * Organisationsnummer
     */
    const ISO_6523_0007 = '0007';

    /**
     * LE NUMERO NATIONAL
     */
    const ISO_6523_0008 = '0008';

    /**
     * SIRET-CODE
     */
    const ISO_6523_0009 = '0009';

    /**
     * Organizational Identifiers for Structured Names under ISO 9541 Part 2
     */
    const ISO_6523_0010 = '0010';

    /**
     * International Code Designator for the Identification of OSI-based,
     * Amateur Radio Organizations, Network Objects and Application Services.
     */
    const ISO_6523_0011 = '0011';

    /**
     * European Computer Manufacturers Association: ECMA
     */
    const ISO_6523_0012 = '0012';

    /**
     * VSA FTP CODE (FTP = File Transfer Protocol)
     */
    const ISO_6523_0013 = '0013';

    /**
     * NIST/OSI Implememts' Workshop
     */
    const ISO_6523_0014 = '0014';

    /**
     * Electronic Data Interchange: EDI
     */
    const ISO_6523_0015 = '0015';

    /**
     * EWOS Object Identifiers
     */
    const ISO_6523_0016 = '0016';

    /**
     * COMMON LANGUAGE
     */
    const ISO_6523_0017 = '0017';

    /**
     * SNA/OSI Network
     */
    const ISO_6523_0018 = '0018';

    /**
     * Air Transport Industry Services Communications Network
     */
    const ISO_6523_0019 = '0019';

    /**
     * European Laboratory for Particle Physics: CERN
     */
    const ISO_6523_0020 = '0020';

    /**
     * SOCIETY FOR WORLDWIDE INTERBANK FINANCIAL, TELECOMMUNICATION
     * S.W.I.F.T.
     */
    const ISO_6523_0021 = '0021';

    /**
     * OSF Distributed Computing Object Identification
     */
    const ISO_6523_0022 = '0022';

    /**
     * Nordic University and Research Network: NORDUnet
     */
    const ISO_6523_0023 = '0023';

    /**
     * Digital Equipment Corporation: DEC
     */
    const ISO_6523_0024 = '0024';

    /**
     * OSI ASIA-OCEANIA WORKSHOP
     */
    const ISO_6523_0025 = '0025';

    /**
     * NATO ISO 6523 ICDE coding scheme
     */
    const ISO_6523_0026 = '0026';

    /**
     * Aeronautical Telecommunications Network (ATN)
     */
    const ISO_6523_0027 = '0027';

    /**
     * International Standard ISO 6523
     */
    const ISO_6523_0028 = '0028';

    /**
     * The All-Union Classifier of Enterprises and Organisations
     */
    const ISO_6523_0029 = '0029';

    /**
     * AT&T/OSI Network
     */
    const ISO_6523_0030 = '0030';

    /**
     * EDI Partner Identification Code
     */
    const ISO_6523_0031 = '0031';

    /**
     * Telecom Australia
     */
    const ISO_6523_0032 = '0032';

    /**
     * S G W OSI Internetwork
     */
    const ISO_6523_0033 = '0033';

    /**
     * Reuter Open Address Standard
     */
    const ISO_6523_0034 = '0034';

    /**
     * ISO 6523 - ICD
     */
    const ISO_6523_0035 = '0035';

    /**
     * TeleTrust Object Identifiers
     */
    const ISO_6523_0036 = '0036';

    /**
     * LY-tunnus
     */
    const ISO_6523_0037 = '0037';

    /**
     * The Australian GOSIP Network
     */
    const ISO_6523_0038 = '0038';

    /**
     * The OZ DOD OSI Network
     */
    const ISO_6523_0039 = '0039';

    /**
     * Unilever Group Companies
     */
    const ISO_6523_0040 = '0040';

    /**
     * Citicorp Global Information Network
     */
    const ISO_6523_0041 = '0041';

    /**
     * DBP Telekom Object Identifiers
     */
    const ISO_6523_0042 = '0042';

    /**
     * HydroNETT
     */
    const ISO_6523_0043 = '0043';

    /**
     * Thai Industrial Standards Institute (TISI)
     */
    const ISO_6523_0044 = '0044';

    /**
     * ICI Company Identification System
     */
    const ISO_6523_0045 = '0045';

    /**
     * FUNLOC
     */
    const ISO_6523_0046 = '0046';

    /**
     * BULL ODI/DSA/UNIX Network
     */
    const ISO_6523_0047 = '0047';

    /**
     * OSINZ
     */
    const ISO_6523_0048 = '0048';

    /**
     * Auckland Area Health
     */
    const ISO_6523_0049 = '0049';

    /**
     * Firmenich
     */
    const ISO_6523_0050 = '0050';

    /**
     * AGFA-DIS
     */
    const ISO_6523_0051 = '0051';

    /**
     * Society of Motion Picture and Television Engineers (SMPTE)
     */
    const ISO_6523_0052 = '0052';

    /**
     * Migros_Network M_NETOPZ
     */
    const ISO_6523_0053 = '0053';

    /**
     * ISO6523 - ICDPCR
     */
    const ISO_6523_0054 = '0054';

    /**
     * Energy Net
     */
    const ISO_6523_0055 = '0055';

    /**
     * Nokia Object Identifiers (NOI)
     */
    const ISO_6523_0056 = '0056';

    /**
     * Saint Gobain
     */
    const ISO_6523_0057 = '0057';

    /**
     * Siemens Corporate Network
     */
    const ISO_6523_0058 = '0058';

    /**
     * DANZNET
     */
    const ISO_6523_0059 = '0059';

    /**
     * Data Universal Numbering System (D-U-N-S Number)
     */
    const ISO_6523_0060 = '0060';

    /**
     * SOFFEX OSI
     */
    const ISO_6523_0061 = '0061';

    /**
     * KPN OVN
     */
    const ISO_6523_0062 = '0062';

    /**
     * ascomOSINet
     */
    const ISO_6523_0063 = '0063';

    /**
     * UTC: Uniforme Transport Code
     */
    const ISO_6523_0064 = '0064';

    /**
     * SOLVAY OSI CODING
     */
    const ISO_6523_0065 = '0065';

    /**
     * Roche Corporate Network
     */
    const ISO_6523_0066 = '0066';

    /**
     * ZellwegerOSINet
     */
    const ISO_6523_0067 = '0067';

    /**
     * Intel Corporation OSI
     */
    const ISO_6523_0068 = '0068';

    /**
     * SITA Object Identifier Tree
     */
    const ISO_6523_0069 = '0069';

    /**
     * DaimlerChrysler Corporate Network
     */
    const ISO_6523_0070 = '0070';

    /**
     * LEGO /OSI NETWORK
     */
    const ISO_6523_0071 = '0071';

    /**
     * NAVISTAR/OSI Network
     */
    const ISO_6523_0072 = '0072';

    /**
     * ICD Formatted ATM address
     */
    const ISO_6523_0073 = '0073';

    /**
     * ARINC
     */
    const ISO_6523_0074 = '0074';

    /**
     * Alcanet/Alcatel-Alsthom Corporate Network
     */
    const ISO_6523_0075 = '0075';

    /**
     * Sistema Italiano di Identificazione di ogetti gestito da UNINFO
     */
    const ISO_6523_0076 = '0076';

    /**
     * Sistema Italiano di Indirizzamento di Reti OSI Gestito da UNINFO
     */
    const ISO_6523_0077 = '0077';

    /**
     * Mitel terminal or switching equipment
     */
    const ISO_6523_0078 = '0078';

    /**
     * ATM Forum
     */
    const ISO_6523_0079 = '0079';

    /**
     * UK National Health Service Scheme, (EDIRA compliant)
     */
    const ISO_6523_0080 = '0080';

    /**
     * International NSAP
     */
    const ISO_6523_0081 = '0081';

    /**
     * Norwegian Telecommunications Authority's, NTA'S, EDI, identifier
     * scheme (EDIRA compliant)
     */
    const ISO_6523_0082 = '0082';

    /**
     * Advanced Telecommunications Modules Limited, Corporate Network
     */
    const ISO_6523_0083 = '0083';

    /**
     * Athens Chamber of Commerce & Industry Scheme (EDIRA compliant)
     */
    const ISO_6523_0084 = '0084';

    /**
     * Swiss Chambers of Commerce Scheme (EDIRA) compliant
     */
    const ISO_6523_0085 = '0085';

    /**
     * United States Council for International Business (USCIB) Scheme,
     * (EDIRA compliant)
     */
    const ISO_6523_0086 = '0086';

    /**
     * National Federation of Chambers of Commerce & Industry of Belgium,
     * Scheme (EDIRA compliant)
     */
    const ISO_6523_0087 = '0087';

    /**
     * EAN Location Code
     */
    const ISO_6523_0088 = '0088';

    /**
     * The Association of British Chambers of Commerce Ltd. Scheme, (EDIRA
     * compliant)
     */
    const ISO_6523_0089 = '0089';

    /**
     * Internet IP addressing - ISO 6523 ICD encoding
     */
    const ISO_6523_0090 = '0090';

    /**
     * Cisco Sysytems / OSI Network
     */
    const ISO_6523_0091 = '0091';

    /**
     * Revenue Canada Business Number Registration (EDIRA compliant)
     */
    const ISO_6523_0093 = '0093';

    /**
     * DEUTSCHER INDUSTRIE- UND HANDELSTAG (DIHT) Scheme (EDIRA compliant)
     */
    const ISO_6523_0094 = '0094';

    /**
     * Hewlett - Packard Company Internal AM Network
     */
    const ISO_6523_0095 = '0095';

    /**
     * DANISH CHAMBER OF COMMERCE Scheme (EDIRA compliant)
     */
    const ISO_6523_0096 = '0096';

    /**
     * FTI - Ediforum Italia, (EDIRA compliant)
     */
    const ISO_6523_0097 = '0097';

    /**
     * CHAMBER OF COMMERCE TEL AVIV-JAFFA Scheme (EDIRA compliant)
     */
    const ISO_6523_0098 = '0098';

    /**
     * Siemens Supervisory Systems Network
     */
    const ISO_6523_0099 = '0099';

    /**
     * PNG_ICD Scheme
     */
    const ISO_6523_0100 = '0100';

    /**
     * South African Code Allocation
     */
    const ISO_6523_0101 = '0101';

    /**
     * HEAG
     */
    const ISO_6523_0102 = '0102';

    /**
     * BT - ICD Coding System
     */
    const ISO_6523_0104 = '0104';

    /**
     * Portuguese Chamber of Commerce and Industry Scheme (EDIRA compliant)
     */
    const ISO_6523_0105 = '0105';

    /**
     * Vereniging van Kamers van Koophandel en Fabrieken in Nederland
     * (Association of Chambers of Commerce and Industry in the Netherlands),
     * Scheme (EDIRA compliant)
     */
    const ISO_6523_0106 = '0106';

    /**
     * Association of Swedish Chambers of Commerce and Industry Scheme (EDIRA
     * compliant)
     */
    const ISO_6523_0107 = '0107';

    /**
     * Australian Chambers of Commerce and Industry Scheme (EDIRA compliant)
     */
    const ISO_6523_0108 = '0108';

    /**
     * BellSouth ICD AESA (ATM End System Address)
     */
    const ISO_6523_0109 = '0109';

    /**
     * Bell Atlantic
     */
    const ISO_6523_0110 = '0110';

    /**
     * Object Identifiers
     */
    const ISO_6523_0111 = '0111';

    /**
     * ISO register for Standards producing Organizations
     */
    const ISO_6523_0112 = '0112';

    /**
     * OriginNet
     */
    const ISO_6523_0113 = '0113';

    /**
     * Check Point Software Technologies
     */
    const ISO_6523_0114 = '0114';

    /**
     * Pacific Bell Data Communications Network
     */
    const ISO_6523_0115 = '0115';

    /**
     * PSS Object Identifiers
     */
    const ISO_6523_0116 = '0116';

    /**
     * STENTOR-ICD CODING SYSTEM
     */
    const ISO_6523_0117 = '0117';

    /**
     * ATM-Network ZN'96
     */
    const ISO_6523_0118 = '0118';

    /**
     * MCI / OSI Network
     */
    const ISO_6523_0119 = '0119';

    /**
     * Advantis
     */
    const ISO_6523_0120 = '0120';

    /**
     * Affable Software Data Interchange Codes
     */
    const ISO_6523_0121 = '0121';

    /**
     * BB-DATA GmbH
     */
    const ISO_6523_0122 = '0122';

    /**
     * BASF Company ATM-Network
     */
    const ISO_6523_0123 = '0123';

    /**
     * IOTA Identifiers for Organizations for Telecommunications Addressing
     * using the ICD system format defined in ISO/IEC 8348
     */
    const ISO_6523_0124 = '0124';

    /**
     * Henkel Corporate Network (H-Net)
     */
    const ISO_6523_0125 = '0125';

    /**
     * GTE/OSI Network
     */
    const ISO_6523_0126 = '0126';

    /**
     * Dresdner Bank Corporate Network
     */
    const ISO_6523_0127 = '0127';

    /**
     * BCNR (Swiss Clearing Bank Number)
     */
    const ISO_6523_0128 = '0128';

    /**
     * BPI (Swiss Business Partner Identification) code
     */
    const ISO_6523_0129 = '0129';

    /**
     * Directorates of the European Commission
     */
    const ISO_6523_0130 = '0130';

    /**
     * Code for the Identification of National Organizations
     */
    const ISO_6523_0131 = '0131';

    /**
     * Certicom Object Identifiers
     */
    const ISO_6523_0132 = '0132';

    /**
     * TC68 OID
     */
    const ISO_6523_0133 = '0133';

    /**
     * Infonet Services Corporation
     */
    const ISO_6523_0134 = '0134';

    /**
     * SIA Object Identifiers
     */
    const ISO_6523_0135 = '0135';

    /**
     * Cable & Wireless Global ATM End-System Address Plan
     */
    const ISO_6523_0136 = '0136';

    /**
     * Global AESA scheme
     */
    const ISO_6523_0137 = '0137';

    /**
     * France Telecom ATM End System Address Plan
     */
    const ISO_6523_0138 = '0138';

    /**
     * Savvis Communications AESA:.
     */
    const ISO_6523_0139 = '0139';

    /**
     * Toshiba Organizations, Partners, And Suppliers' (TOPAS) Code
     */
    const ISO_6523_0140 = '0140';

    /**
     * NATO Commercial and Government Entity system
     */
    const ISO_6523_0141 = '0141';

    /**
     * SECETI Object Identifiers
     */
    const ISO_6523_0142 = '0142';

    /**
     * EINESTEINet AG
     */
    const ISO_6523_0143 = '0143';

    /**
     * DoDAAC (Department of Defense Activity Address Code)
     */
    const ISO_6523_0144 = '0144';

    /**
     * DGCP (Direction Générale de la Comptabilité Publique)administrative
     * accounting identification scheme
     */
    const ISO_6523_0145 = '0145';

    /**
     * DGI (Direction Générale des Impots) code
     */
    const ISO_6523_0146 = '0146';

    /**
     * Standard Company Code
     */
    const ISO_6523_0147 = '0147';

    /**
     * ITU (International Telecommunications Union)Data Network
     * Identification Codes (DNIC)
     */
    const ISO_6523_0148 = '0148';

    /**
     * Global Business Identifier
     */
    const ISO_6523_0149 = '0149';

    /**
     * Madge Networks Ltd- ICD ATM Addressing Scheme
     */
    const ISO_6523_0150 = '0150';

    /**
     * Australian Business Number (ABN) Scheme
     */
    const ISO_6523_0151 = '0151';

    /**
     * Edira Scheme Identifier Code
     */
    const ISO_6523_0152 = '0152';

    /**
     * Concert Global Network Services ICD AESA
     */
    const ISO_6523_0153 = '0153';

    /**
     * Identification number of economic subjects: (ICO)
     */
    const ISO_6523_0154 = '0154';

    /**
     * Global Crossing AESA (ATM End System Address)
     */
    const ISO_6523_0155 = '0155';

    /**
     * AUNA
     */
    const ISO_6523_0156 = '0156';

    /**
     * ATM interconnection with the Dutch KPN Telecom
     */
    const ISO_6523_0157 = '0157';

    /**
     * Identification number of economic subject (ICO) Act on State
     * Statistics of 29 November 2'001, § 27
     */
    const ISO_6523_0158 = '0158';

    /**
     * ACTALIS Object Identifiers
     */
    const ISO_6523_0159 = '0159';

    /**
     * GTIN - Global Trade Item Number
     */
    const ISO_6523_0160 = '0160';

    /**
     * ECCMA Open Technical Directory
     */
    const ISO_6523_0161 = '0161';

    /**
     * CEN/ISSS Object Identifier Scheme
     */
    const ISO_6523_0162 = '0162';

    /**
     * US-EPA Facility Identifier
     */
    const ISO_6523_0163 = '0163';

    /**
     * TELUS Corporation
     */
    const ISO_6523_0164 = '0164';

    /**
     * FIEIE Object identifiers
     */
    const ISO_6523_0165 = '0165';

    /**
     * Swissguide Identifier Scheme
     */
    const ISO_6523_0166 = '0166';

    /**
     * Priority Telecom ATM End System Address Plan
     */
    const ISO_6523_0167 = '0167';

    /**
     * Vodafone Ireland OSI Addressing
     */
    const ISO_6523_0168 = '0168';

    /**
     * Swiss Federal Business Identification Number. Central Business names
     * Index (zefix) Identification Number
     */
    const ISO_6523_0169 = '0169';

    /**
     * Teikoku Company Code
     */
    const ISO_6523_0170 = '0170';

    /**
     * Luxembourg CP & CPS (Certification Policy and Certification Practice
     * Statement) Index
     */
    const ISO_6523_0171 = '0171';

    /**
     * Project Group “Lists of Properties” (PROLIST®)
     */
    const ISO_6523_0172 = '0172';

    /**
     * eCI@ss
     */
    const ISO_6523_0173 = '0173';

    /**
     * StepNexus
     */
    const ISO_6523_0174 = '0174';

    /**
     * Siemens AG
     */
    const ISO_6523_0175 = '0175';

    /**
     * Paradine GmbH
     */
    const ISO_6523_0176 = '0176';

    /**
     * Odette International Limited
     */
    const ISO_6523_0177 = '0177';

    /**
     * Route1 MobiNET
     */
    const ISO_6523_0178 = '0178';

    /**
     * Penango Object Identifiers
     */
    const ISO_6523_0179 = '0179';

    /**
     * Lithuanian military PKI
     */
    const ISO_6523_0180 = '0180';

    /**
     * Numéro d'identification suisse des enterprises (IDE), Swiss Unique
     * Business Identification Number (UIDB)
     */
    const ISO_6523_0183 = '0183';

    /**
     * DIGSTORG
     */
    const ISO_6523_0184 = '0184';

    /**
     * Perceval Object Code
     */
    const ISO_6523_0185 = '0185';

    /**
     * TrustPoint Object Identifiers
     */
    const ISO_6523_0186 = '0186';

    /**
     * Amazon Unique Identification Scheme
     */
    const ISO_6523_0187 = '0187';

    /**
     * Corporate Number of The Social Security and Tax Number System
     */
    const ISO_6523_0188 = '0188';

    /**
     * European Business Identifier (EBID)
     */
    const ISO_6523_0189 = '0189';

    /**
     * Organisatie Indentificatie Nummer (OIN)
     */
    const ISO_6523_0190 = '0190';

    /**
     * Company Code (Estonia)
     */
    const ISO_6523_0191 = '0191';

    /**
     * Organisasjonsnummer
     */
    const ISO_6523_0192 = '0192';

    /**
     * UBL.BE Party Identifier
     */
    const ISO_6523_0193 = '0193';

    /**
     * KOIOS Open Technical Dictionary
     */
    const ISO_6523_0194 = '0194';

    /**
     * Singapore Nationwide E-lnvoice Framework
     */
    const ISO_6523_0195 = '0195';

    /**
     * Icelandic identifier - Íslensk kennitala
     */
    const ISO_6523_0196 = '0196';

    /**
     * Name not known
     */
    const ISO_6523_0197 = '0197';

    /**
     * ERSTORG
     */
    const ISO_6523_0198 = '0198';

    /**
     * Legal Entity Identifier (LEI)
     */
    const ISO_6523_0199 = '0199';

    /**
     * Legal entity code (Lithuania)
     */
    const ISO_6523_0200 = '0200';

    /**
     * Codice Univoco Unità Organizzativa iPA
     */
    const ISO_6523_0201 = '0201';

    /**
     * Indirizzo di Posta Elettronica Certificata
     */
    const ISO_6523_0202 = '0202';

    /**
     * eDelivery Network Participant identifier
     */
    const ISO_6523_0203 = '0203';

    /**
     * Leitweg-ID
     */
    const ISO_6523_0204 = '0204';
}
