<?php

/**
 * NukeViet Content Management System
 * @version 4.x
 * @author VINADES.,JSC <contact@vinades.vn>
 * @copyright (C) 2009-2021 VINADES.,JSC. All rights reserved
 * @license GNU/GPL version 2 or any later version
 * @see https://github.com/nukeviet The NukeViet CMS GitHub project
 */

if (!defined('NV_MAINFILE')) {
    exit('Stop!!!');
}

// Chinese
$utf8_lookup_lang = [
    '起' => 'qi ', '果' => 'guo ', '热' => 're ', '院' => 'yuan ', '四' => 'si ', '回' => 'hui ', '西' => 'xi ', '国' => 'guo ',
    '高' => 'gao ', '怎' => 'zen ', '系' => 'xi ', '北' => 'bei ', '一' => 'yi ', '七' => 'qi ', '三' => 'san ', '上' => 'shang ', '下' => 'xia ',
    '不' => 'bu ', '东' => 'dong ', '子' => 'zi ', '医' => 'yi ', '字' => 'zi ', '个' => 'ge ', '十' => 'shi ', '中' => 'zhong ', '午' => 'wu ',
    '气' => 'qi ', '学' => 'xue ', '么' => 'me ', '开' => 'kai ', '水' => 'shui ', '九' => 'jiu ', '习' => 'xi ', '书' => 'shu ', '汉' => 'han ',
    '雨' => 'yu ', '买' => 'mai ', '见' => 'jian ', '视' => 'shi ', '零' => 'ling ', '觉' => 'jiao ', '了' => 'le ', '二' => 'er ', '在' => 'zai ',
    '五' => 'wu ', '些' => 'xie ', '生' => 'sheng ', '坐' => 'zuo ', '电' => 'dian ', '块' => 'kuai ', '影' => 'ying ', '很' => 'hen ', '校' => 'jiao ',
    '客' => 'ke ', '样' => 'yang ', '家' => 'jia ', '桌' => 'zhuo ', '去' => 'qu ', '京' => 'jing ', '亮' => 'liang ', '想' => 'xiang ', '友' => 'you ',
    '人' => 'ren ', '没' => 'mei ', '什' => 'shi ', '对' => 'dui ', '今' => 'jin ', '叫' => 'jiao ', '他' => 'ta ', '们' => 'men ', '面' => 'mian ',
    '候' => 'hou ', '苹' => 'ping ', '做' => 'zuo ', '小' => 'xiao ', '少' => 'shao ', '吃' => 'chi ', '同' => 'tong ', '名' => 'ming ', '后' => 'hou ',
    '吗' => 'ma ', '听' => 'ting ', '会' => 'hui ', '爱' => 'ai ', '爸' => 'ba ', '租' => 'zu ', '呢' => 'ne ', '住' => 'zhu ', '岁' => 'sui ',
    '作' => 'zuo ', '你' => 'ni ', '和' => 'he ', '茶' => 'cha ', '椅' => 'yi ', '的' => 'de ', '车' => 'che ', '站' => 'zhan ', '那' => 'na ',
    '钟' => 'zhong ', '哪' => 'na ', '狗' => 'gou ', '认' => 'ren ', '识' => 'shi ', '话' => 'hua ', '日' => 'ri ', '都' => 'dou ', '语' => 'yu ',
    '时' => 'shi ', '菜' => 'cai ', '说' => 'shui ', '请' => 'qing ', '读' => 'dou ', '儿' => 'er ', '先' => 'xian ', '钱' => 'qian ', '我' => 'wo ',
    '八' => 'ba ', '六' => 'liu ', '老' => 'lao ', '关' => 'guan ', '兴' => 'xing ', '这' => 'zhe ', '再' => 'zai ', '写' => 'xie ', '打' => 'da ',
    '商' => 'shang ', '猫' => 'mao ', '谁' => 'shei ', '明' => 'ming ', '星' => 'xing ', '昨' => 'zuo ', '飞' => 'fei ', '谢' => 'xie ', '是' => 'shi ',
    '喂' => 'wei ', '多' => 'duo ', '喜' => 'xi ', '喝' => 'he ', '大' => 'da ', '天' => 'tian ', '冷' => 'leng ', '看' => 'kan ', '太' => 'tai ',
    '几' => 'ji ', '出' => 'chu ', '女' => 'nu ', '她' => 'ta ', '好' => 'hao ', '睡' => 'shui ', '妈' => 'ma ', '工' => 'gong ', '现' => 'xian ',
    '衣' => 'yi ', '能' => 'neng ', '里' => 'li ', '分' => 'fen ', '饭' => 'fan ', '馆' => 'guan ', '姐' => 'jie ', '前' => 'qian ', '欢' => 'huan ',
    '师' => 'shi ', '脑' => 'nao ', '火' => 'huo ', '漂' => 'piao ', '月' => 'yue ', '有' => 'you ', '朋' => 'peng ', '服' => 'fu ', '年' => 'nian ',
    '期' => 'qi ', '本' => 'ben ', '米' => 'mi ', '店' => 'dian ', '机' => 'ji ', '来' => 'lai ', '杯' => 'bei ', '点' => 'dian ', '阴' => 'yin ',
    '每' => 'mei ', '比' => 'bi ', '自' => 'zi ', '因' => 'yin ', '瓜' => 'gua ', '要' => 'yao ', '足' => 'zu ', '思' => 'si ', '跑' => 'pao ',
    '丈' => 'zhang ', '路' => 'lu ', '跳' => 'tiao ', '两' => 'liang ', '息' => 'xi ', '千' => 'qian ', '孩' => 'hai ', '为' => 'wei ', '黑' => 'hei ',
    '卖' => 'mai ', '乐' => 'le ', '它' => 'ta ', '完' => 'wan ', '也' => 'ye ', '弟' => 'di ', '宜' => 'yi ', '雪' => 'xue ', '张' => 'zhang ',
    '舞' => 'wu ', '事' => 'shi ', '船' => 'chuan ', '累' => 'lei ', '汽' => 'qi ', '场' => 'chang ', '男' => 'nan ', '色' => 'se ', '您' => 'nin ',
    '踢' => 'ti ', '得' => 'de ', '室' => 'shi ', '情' => 'qing ', '介' => 'jie ', '从' => 'cong ', '可' => 'ke ', '右' => 'you ', '号' => 'hao ',
    '司' => 'si ', '以' => 'yi ', '件' => 'jian ', '票' => 'piao ', '非' => 'fei ', '泳' => 'yong ', '忙' => 'mang ', '快' => 'kuai ', '病' => 'bing ',
    '意' => 'yi ', '身' => 'shen ', '向' => 'xiang ', '蛋' => 'dan ', '就' => 'jiu ', '吧' => 'ba ', '休' => 'xiu ', '慢' => 'man ', '离' => 'li ',
    '送' => 'song ', '告' => 'gao ', '洗' => 'xi ', '员' => 'yuan ', '但' => 'dan ', '体' => 'ti ', '牛' => 'niu ', '穿' => 'chuan ', '道' => 'dao ',
    '咖' => 'ka ', '教' => 'jiao ', '药' => 'yao ', '懂' => 'dong ', '白' => 'bai ', '百' => 'bai ', '鱼' => 'yu ', '便' => 'bian ', '哥' => 'ge ',
    '斤' => 'jin ', '让' => 'rang ', '新' => 'xin ', '旁' => 'pang ', '旅' => 'lu ', '诉' => 'su ', '红' => 'hong ', '试' => 'shi ', '早' => 'zao ',
    '纸' => 'zhi ', '绍' => 'shao ', '课' => 'ke ', '经' => 'jing ', '给' => 'gei ', '题' => 'ti ', '颜' => 'yan ', '元' => 'yuan ', '边' => 'bian ',
    '公' => 'gong ', '考' => 'kao ', '共' => 'gong ', '过' => 'guo ', '迎' => 'ying ', '运' => 'yun ', '近' => 'jin ', '还' => 'hai ', '房' => 'fang ',
    '进' => 'jin ', '远' => 'yuan ', '所' => 'suo ', '笑' => 'xiao ', '手' => 'shou ', '第' => 'di ', '唱' => 'chang ', '找' => 'zhao ', '等' => 'deng ',
    '答' => 'da ', '啡' => 'fei ', '游' => 'you ', '肉' => 'rou ', '备' => 'bei ', '外' => 'wai ', '夫' => 'fu ', '晚' => 'wan ', '准' => 'zhun ',
    '真' => 'zhen ', '晴' => 'qing ', '错' => 'cuo ', '眼' => 'yan ', '着' => 'zhao ', '报' => 'bao ', '奶' => 'nai ', '睛' => 'jing ', '羊' => 'yang ',
    '玩' => 'wan ', '行' => 'hang ', '长' => 'chang ', '左' => 'zuo ', '已' => 'yi ', '表' => 'biao ', '篮' => 'lan ', '班' => 'ban ', '妹' => 'mei ',
    '妻' => 'qi ', '始' => 'shi ', '别' => 'bie ', '姓' => 'xing ', '到' => 'dao ', '次' => 'ci ', '知' => 'zhi ', '希' => 'xi ', '门' => 'men ',
    '歌' => 'ge ', '问' => 'wen ', '间' => 'jian ', '帮' => 'bang ', '正' => 'zheng ', '步' => 'bu ', '常' => 'chang ', '球' => 'qiu ', '最' => 'zui ',
    '望' => 'wang ', '床' => 'chuang ', '贵' => 'gui ', '务' => 'wu ', '动' => 'dong ', '助' => 'zhu ', '鸡' => 'ji ', '走' => 'zou ', '板' => 'ban ',
    '炼' => 'lian ', '极' => 'ji ', '超' => 'chao ', '段' => 'duan ', '越' => 'yue ', '接' => 'jie ', '阳' => 'yang ', '烧' => 'shao ', '阿' => 'a ',
    '附' => 'fu ', '康' => 'kang ', '提' => 'di ', '除' => 'chu ', '碗' => 'wan ', '澡' => 'zao ', '糕' => 'gao ', '糖' => 'tang ', '园' => 'yuan ',
    '趣' => 'qu ', '图' => 'tu ', '怕' => 'pa ', '急' => 'ji ', '怪' => 'guai ', '包' => 'bao ', '总' => 'zong ', '跟' => 'gen ', '查' => 'zha ',
    '化' => 'hua ', '万' => 'wan ', '且' => 'qie ', '世' => 'shi ', '业' => 'ye ', '黄' => 'huang ', '半' => 'ban ', '季' => 'ji ', '主' => 'zhu ',
    '然' => 'ran ', '举' => 'ju ', '单' => 'chan ', '南' => 'nan ', '难' => 'nan ', '久' => 'jiu ', '乎' => 'hu ', '安' => 'an ', '汁' => 'zhi ',
    '求' => 'qiu ', '搬' => 'ban ', '舒' => 'shu ', '定' => 'ding ', '实' => 'shi ', '照' => 'zhao ', '历' => 'li ', '般' => 'ban ', '角' => 'jue ',
    '于' => 'yu ', '熊' => 'xiong ', '云' => 'yun ', '解' => 'xie ', '地' => 'de ', '甜' => 'tian ', '当' => 'dang ', '用' => 'yong ', '坏' => 'huai ',
    '画' => 'hua ', '树' => 'shu ', '界' => 'jie ', '节' => 'jie ', '根' => 'gen ', '害' => 'hai ', '容' => 'rong ', '宾' => 'bin ', '厨' => 'chu ',
    '惯' => 'guan ', '参' => 'can ', '又' => 'you ', '双' => 'shuang ', '需' => 'xu ', '发' => 'fa ', '叔' => 'shu ', '变' => 'bian ', '口' => 'kou ',
    '句' => 'ju ', '示' => 'shi ', '礼' => 'li ', '河' => 'he ', '只' => 'zhi ', '鼻' => 'bi ', '史' => 'shi ', '虽' => 'sui ', '祝' => 'zhu ',
    '法' => 'fa ', '注' => 'zhu ', '花' => 'hua ', '静' => 'jing ', '心' => 'xin ', '必' => 'bi ', '忘' => 'wang ', '借' => 'jie ', '城' => 'cheng ',
    '鞋' => 'xie ', '疼' => 'teng ', '梯' => 'ti ', '健' => 'jian ', '感' => 'gan ', '检' => 'jian ', '愿' => 'yuan ', '层' => 'ceng ', '居' => 'ju ',
    '伞' => 'san ', '选' => 'xuan ', '秋' => 'qiu ', '种' => 'zhong ', '爬' => 'pa ', '爷' => 'ye ', '通' => 'tong ', '山' => 'shan ', '位' => 'wei ',
    '低' => 'di ', '片' => 'pian ', '周' => 'zhou ', '牙' => 'ya ', '空' => 'kong ', '遇' => 'yu ', '物' => 'wu ', '突' => 'tu ', '放' => 'fang ',
    '音' => 'yin ', '故' => 'gu ', '使' => 'shi ', '特' => 'te ', '敢' => 'gan ', '草' => 'cao ', '像' => 'xiang ', '数' => 'shu ', '瘦' => 'shou ',
    '文' => 'wen ', '境' => 'jing ', '楚' => 'chu ', '响' => 'xiang ', '鲜' => 'xian ', '楼' => 'lou ', '轻' => 'qing ', '较' => 'jiao ', '辆' => 'liang ',
    '邮' => 'you ', '哭' => 'ku ', '邻' => 'lin ', '信' => 'xin ', '议' => 'yi ', '方' => 'fang ', '记' => 'ji ', '讲' => 'jiang ', '词' => 'ci ',
    '级' => 'ji ', '旧' => 'jiu ', '该' => 'gai ', '须' => 'xu ', '顾' => 'gu ', '练' => 'lian ', '终' => 'zhong ', '结' => 'jie ', '绩' => 'ji ',
    '声' => 'sheng ', '盘' => 'pan ', '戏' => 'xi ', '铁' => 'tie ', '铅' => 'qian ', '绿' => 'lu ', '成' => 'cheng ', '或' => 'huo ', '目' => 'mu ',
    '直' => 'zhi ', '相' => 'xiang ', '者' => 'zhe ', '其' => 'qi ', '典' => 'dian ', '而' => 'er ', '迟' => 'chi ', '银' => 'yin ', '冒' => 'mao ',
    '笔' => 'bi ', '才' => 'cai ', '耳' => 'er ', '扫' => 'sao ', '清' => 'qing ', '啊' => 'a ', '调' => 'diao ', '聪' => 'cong ', '把' => 'ba ',
    '易' => 'yi ', '啤' => 'pi ', '风' => 'feng ', '渴' => 'ke ', '萄' => 'tao ', '春' => 'chun ', '筷' => 'kuai ', '简' => 'jian ', '复' => 'fu ',
    '夏' => 'xia ', '酒' => 'jiu ', '算' => 'suan ', '冬' => 'dong ', '冰' => 'bing ', '决' => 'jue ', '头' => 'tou ', '净' => 'jing ', '普' => 'pu ',
    '奇' => 'ji ', '葡' => 'pu ', '网' => 'wang ', '护' => 'hu ', '锻' => 'duan ', '如' => 'ru ', '担' => 'dan ', '育' => 'yu ', '镜' => 'jing ',
    '择' => 'ze ', '箱' => 'xiang ', '胖' => 'pang ', '环' => 'huan ', '拿' => 'na ', '街' => 'jie ', '差' => 'cha ', '己' => 'ji ', '衫' => 'shan ',
    '衬' => 'chen ', '重' => 'chong ', '满' => 'man ', '刚' => 'gang ', '饱' => 'bao ', '更' => 'geng ', '饿' => 'e ', '蓝' => 'lan ', '刮' => 'gua ',
    '刷' => 'shua ', '刻' => 'ke ', '香' => 'xiang ', '姨' => 'yi ', '婚' => 'hun ', '短' => 'duan ', '矮' => 'ai ', '市' => 'shi ', '被' => 'bei ',
    '脚' => 'jiao ', '带' => 'dai ', '灯' => 'deng ', '闻' => 'wen ', '力' => 'li ', '办' => 'ban ', '裙' => 'qun ', '理' => 'li ', '帽' => 'mao ',
    '脸' => 'lian ', '裤' => 'ku ', '换' => 'huan ', '据' => 'ju ', '演' => 'yan ', '干' => 'gan ', '平' => 'ping ', '腿' => 'tui ', '末' => 'mo ',
    '应' => 'ying ', '朵' => 'duo ', '马' => 'ma ', '加' => 'jia ', '李' => 'li ', '努' => 'nu ', '束' => 'shu ', '赛' => 'sai ', '条' => 'tiao ',
    '蕉' => 'jiao ', '骑' => 'qi ', '鸟' => 'niao ', '松' => 'song ', '破' => 'po ', '础' => 'chu ', '林' => 'lin ', '推' => 'tui ', '烟' => 'yan ',
    '硕' => 'shuo ', '趟' => 'tang ', '母' => 'mu ', '烦' => 'fan ', '度' => 'du ', '毕' => 'bi ', '座' => 'zuo ', '际' => 'ji ', '毛' => 'mao ',
    '降' => 'jiang ', '硬' => 'ying ', '确' => 'que ', '限' => 'xian ', '险' => 'xian ', '握' => 'wo ', '陪' => 'pei ', '精' => 'jing ', '随' => 'sui ',
    '至' => 'zhi ', '困' => 'kun ', '围' => 'wei ', '怀' => 'huai ', '态' => 'tai ', '激' => 'ji ', '怜' => 'lian ', '瓶' => 'ping ', '性' => 'xing ',
    '染' => 'ran ', '距' => 'ju ', '匙' => 'chi ', '恐' => 'kong ', '与' => 'yu ', '柿' => 'shi ', '专' => 'zhuan ', '区' => 'ou ', '丢' => 'diu ',
    '严' => 'yan ', '麻' => 'ma ', '孙' => 'sun ', '民' => 'min ', '丰' => 'feng ', '恼' => 'nao ', '孤' => 'gu ', '丽' => 'li ', '悉' => 'xi ',
    '言' => 'yan ', '默' => 'mo ', '博' => 'bo ', '集' => 'ji ', '卡' => 'ka ', '之' => 'zhi ', '悔' => 'hui ', '弃' => 'qi ', '弄' => 'long ',
    '乒' => 'ping ', '乓' => 'pang ', '永' => 'yong ', '乘' => 'cheng ', '印' => 'yin ', '危' => 'wei ', '式' => 'shi ', '即' => 'ji ', '却' => 'que ',
    '引' => 'yin ', '圆' => 'yuan ', '厉' => 'li ', '乱' => 'luan ', '压' => 'ya ', '厌' => 'yan ', '汗' => 'han ', '观' => 'guan ', '规' => 'gui ',
    '江' => 'jiang ', '航' => 'hang ', '污' => 'wu ', '厚' => 'hou ', '汤' => 'tang ', '原' => 'yuan ', '弹' => 'dan ', '争' => 'zheng ', '紧' => 'jin ',
    '互' => 'hu ', '亚' => 'ya ', '甚' => 'shen ', '圾' => 'ji ', '熟' => 'shou ', '址' => 'zhi ', '彩' => 'cai ', '沙' => 'sha ', '由' => 'you ',
    '申' => 'shen ', '标' => 'biao ', '坚' => 'jian ', '艺' => 'yi ', '往' => 'wang ', '撞' => 'zhuang ', '律' => 'lu ', '留' => 'liu ', '垃' => 'la ',
    '格' => 'ge ', '惊' => 'jing ', '案' => 'an ', '宽' => 'kuan ', '惜' => 'xi ', '寄' => 'ji ', '密' => 'mi ', '富' => 'fu ', '寒' => 'han ',
    '交' => 'jiao ', '疑' => 'yi ', '桥' => 'qiao ', '察' => 'cha ', '鼓' => 'gu ', '虎' => 'hu ', '及' => 'ji ', '亲' => 'qin ', '反' => 'fan ',
    '虑' => 'lu ', '桶' => 'tong ', '亿' => 'yi ', '取' => 'qu ', '受' => 'shou ', '仅' => 'jin ', '导' => 'dao ', '仍' => 'reng ', '另' => 'ling ',
    '社' => 'she ', '仔' => 'zi ', '油' => 'you ', '台' => 'tai ', '叶' => 'ye ', '播' => 'bo ', '代' => 'dai ', '燥' => 'zao ', '齐' => 'qi ',
    '神' => 'shen ', '价' => 'jia ', '任' => 'ren ', '微' => 'wei ', '份' => 'fen ', '泪' => 'lei ', '忆' => 'yi ', '倍' => 'bei ', '禁' => 'jin ',
    '泼' => 'po ', '擦' => 'ca ', '龄' => 'ling ', '福' => 'fu ', '志' => 'zhi ', '苦' => 'ku ', '值' => 'zhi ', '忽' => 'hu ', '假' => 'jia ',
    '梦' => 'meng ', '愉' => 'yu ', '基' => 'ji ', '停' => 'ting ', '将' => 'jiang ', '躺' => 'tang ', '尊' => 'zun ', '偶' => 'ou ', '尔' => 'er ',
    '尝' => 'chang ', '各' => 'ge ', '合' => 'ge ', '傅' => 'fu ', '尤' => 'you ', '程' => 'cheng ', '稍' => 'shao ', '森' => 'sen ', '棵' => 'ke ',
    '尽' => 'jin ', '否' => 'fou ', '慕' => 'mu ', '众' => 'zhong ', '优' => 'you ', '吵' => 'chao ', '吸' => 'xi ', '传' => 'chuan ', '伤' => 'shang ',
    '展' => 'zhan ', '秀' => 'xiu ', '适' => 'shi ', '洋' => 'yang ', '呀' => 'ya ', '估' => 'gu ', '科' => 'ke ', '逐' => 'zhu ', '父' => 'fu ',
    '逛' => 'guang ', '速' => 'su ', '造' => 'zao ', '积' => 'ji ', '洲' => 'zhou ', '何' => 'he ', '范' => 'fan ', '活' => 'huo ', '味' => 'wei ',
    '流' => 'liu ', '支' => 'zhi ', '命' => 'ming ', '究' => 'jiu ', '穷' => 'qiong ', '济' => 'ji ', '收' => 'shou ', '改' => 'gai ', '遍' => 'bian ',
    '窄' => 'zhai ', '效' => 'xiao ', '窗' => 'chuang ', '浪' => 'lang ', '例' => 'li ', '傲' => 'ao ', '海' => 'hai ', '散' => 'san ', '堵' => 'du ',
    '供' => 'gong ', '警' => 'jing ', '消' => 'xiao ', '邀' => 'yao ', '敲' => 'qiao ', '整' => 'zheng ', '塑' => 'su ', '植' => 'zhi ', '料' => 'liao ',
    '填' => 'tian ', '懒' => 'lan ', '墙' => 'qiang ', '增' => 'zeng ', '咱' => 'za ', '咳' => 'hai ', '咸' => 'xian ', '品' => 'pin ', '软' => 'ruan ',
    '针' => 'zhen ', '润' => 'run ', '概' => 'gai ', '竞' => 'jing ', '竟' => 'jing ', '章' => 'zhang ', '童' => 'tong ', '保' => 'bao ', '输' => 'shu ',
    '计' => 'ji ', '断' => 'duan ', '讨' => 'tao ', '俩' => 'lia ', '辛' => 'xin ', '修' => 'xiu ', '狮' => 'shi ', '许' => 'xu ', '论' => 'lun ',
    '访' => 'fang ', '证' => 'zheng ', '评' => 'ping ', '族' => 'zu ', '获' => 'huo ', '部' => 'bu ', '译' => 'yi ', '深' => 'shen ', '约' => 'yao ',
    '纪' => 'ji ', '诚' => 'cheng ', '无' => 'wu ', '既' => 'ji ', '详' => 'xiang ', '页' => 'ye ', '误' => 'wu ', '顺' => 'shun ', '顿' => 'dun ',
    '皮' => 'pi ', '组' => 'zu ', '细' => 'xi ', '织' => 'zhi ', '预' => 'yu ', '钢' => 'gang ', '钥' => 'yao ', '绝' => 'jue ', '允' => 'yun ',
    '光' => 'guang ', '士' => 'shi ', '继' => 'ji ', '克' => 'ke ', '免' => 'mian ', '盐' => 'yan ', '盒' => 'he ', '续' => 'xu ', '辣' => 'la ',
    '入' => 'ru ', '全' => 'quan ', '戚' => 'qi ', '达' => 'da ', '具' => 'ju ', '养' => 'yang ', '耐' => 'nai ', '戴' => 'dai ', '户' => 'hu ',
    '内' => 'nei ', '连' => 'lian ', '农' => 'nong ', '扔' => 'reng ', '符' => 'fu ', '售' => 'shou ', '笨' => 'ben ', '扩' => 'kuo ', '聊' => 'liao ',
    '猜' => 'cai ', '职' => 'zhi ', '扬' => 'yang ', '扮' => 'ban ', '扰' => 'rao ', '联' => 'lian ', '聘' => 'pin ', '批' => 'pi ', '渐' => 'jian ',
    '猪' => 'zhu ', '技' => 'ji ', '猴' => 'hou ', '谅' => 'liang ', '谈' => 'tan ', '温' => 'wen ', '谊' => 'yi ', '折' => 'she ', '映' => 'ying ',
    '食' => 'shi ', '处' => 'chu ', '签' => 'qian ', '肚' => 'du ', '够' => 'gou ', '省' => 'sheng ', '况' => 'kuang ', '失' => 'shi ', '湿' => 'shi ',
    '酸' => 'suan ', '凉' => 'liang ', '象' => 'xiang ', '景' => 'jing ', '减' => 'jian ', '缺' => 'que ', '著' => 'zhu ', '奋' => 'fen ', '醒' => 'xing ',
    '暂' => 'zan ', '奖' => 'jiang ', '暑' => 'shu ', '貌' => 'mao ', '暖' => 'nuan ', '暗' => 'an ', '键' => 'jian ', '抬' => 'tai ', '抱' => 'bao ',
    '抽' => 'chou ', '肤' => 'fu ', '肥' => 'fei ', '拉' => 'la ', '肯' => 'ken ', '美' => 'mei ', '拒' => 'ju ', '管' => 'guan ', '招' => 'zhao ',
    '羞' => 'xiu ', '括' => 'kuo ', '血' => 'xue ', '拾' => 'shi ', '篇' => 'pian ', '巧' => 'qiao ', '巾' => 'jin ', '嗽' => 'sou ', '袋' => 'dai ',
    '释' => 'shi ', '量' => 'liang ', '金' => 'jin ', '袜' => 'wa ', '刀' => 'dao ', '切' => 'qie ', '羡' => 'xian ', '群' => 'qun ', '划' => 'hua ',
    '饮' => 'yin ', '列' => 'lie ', '则' => 'ze ', '羽' => 'yu ', '饺' => 'jiao ', '饼' => 'bing ', '判' => 'pan ', '利' => 'li ', '替' => 'ti ',
    '制' => 'zhi ', '首' => 'shou ', '持' => 'chi ', '挂' => 'gua ', '指' => 'zhi ', '按' => 'an ', '翻' => 'fan ', '剧' => 'ju ', '剩' => 'sheng ',
    '币' => 'bi ', '帅' => 'shuai ', '脏' => 'zang ', '歉' => 'qian ', '挺' => 'ting ', '闹' => 'nao ', '止' => 'zhi ', '此' => 'ci ', '功' => 'gong ',
    '脱' => 'tuo ', '脾' => 'pi ', '死' => 'si ', '嘴' => 'zui ', '琴' => 'qin ', '授' => 'shou ', '掉' => 'diao ', '掌' => 'zhang ', '并' => 'bing ',
    '幸' => 'xing ', '漫' => 'man ', '排' => 'pai ', '幽' => 'you ', '广' => 'guang ', '负' => 'fu ', '序' => 'xu ', '责' => 'ze ', '败' => 'bai ',
    '货' => 'huo ', '术' => 'shu ', '质' => 'zhi ', '膏' => 'gao ', '底' => 'de ', '购' => 'gou ', '费' => 'fei ', '贺' => 'he ', '杂' => 'za ',
    '资' => 'zi ', '粗' => 'cu ', '码' => 'ma ', '材' => 'cai ', '村' => 'cun ', '励' => 'li ', '骄' => 'jiao ', '赚' => 'zhuan ', '研' => 'yan ',
    '验' => 'yan ', '勇' => 'yong ', '赢' => 'ying ', '骗' => 'pian ', '阅' => 'yue ', '赶' => 'gan ', '鸭' => 'ya ', '构' => 'gou ', '烂' => 'lan ',
    '勤' => 'qin ', '烈' => 'lie ', '趁' => 'chen ', '队' => 'dui ', '鸽' => 'ge ', '趋' => 'qu ', '析' => 'xi ', '枕' => 'zhen ', '控' => 'kong ',
    '措' => 'cuo ', '烛' => 'zhu ', '勺' => 'shao ', '防' => 'fang ', '阵' => 'zhen ', '阶' => 'jie ', '薄' => 'bao ', '烤' => 'kao ', '阻' => 'zu ',
    '烫' => 'tang ', '毒' => 'du ', '陆' => 'liu ', '庭' => 'ting ', '陌' => 'mo ', '描' => 'miao ', '毫' => 'hao ', '插' => 'cha ', '毯' => 'tan ',
    '粮' => 'liang ', '嚷' => 'rang ', '碍' => 'ai ', '碎' => 'sui ', '骤' => 'zhou ', '骨' => 'gu ', '糊' => 'hu ', '臭' => 'chou ', '延' => 'yan ',
    '隔' => 'ge ', '建' => 'jian ', '团' => 'tuan ', '致' => 'zhi ', '糟' => 'zao ', '枪' => 'qiang ', '固' => 'gu ', '架' => 'jia ', '怒' => 'nu ',
    '怖' => 'bu ', '髦' => 'mao ', '跃' => 'yue ', '某' => 'mou ', '柔' => 'rou ', '匀' => 'yun ', '匆' => 'cong ', '柜' => 'ju ', '藏' => 'zang ',
    '丁' => 'ding ', '恋' => 'lian ', '柴' => 'chai ', '麦' => 'mai ', '践' => 'jian ', '丑' => 'chou ', '碰' => 'peng ', '丙' => 'bing ', '丝' => 'si ',
    '恢' => 'hui ', '匹' => 'pi ', '恨' => 'hen ', '磁' => 'ci ', '存' => 'cun ', '孝' => 'xiao ', '恳' => 'ken ', '升' => 'sheng ', '恶' => 'e ',
    '临' => 'lin ', '华' => 'hua ', '协' => 'xie ', '氛' => 'fen ', '悄' => 'qiao ', '义' => 'yi ', '雄' => 'xiong ', '雇' => 'gu ', '占' => 'zhan ',
    '乏' => 'fa ', '卧' => 'wo ', '卫' => 'wei ', '宁' => 'ning ', '搞' => 'gao ', '煎' => 'jian ', '乖' => 'guai ', '宇' => 'yu ', '守' => 'shou ',
    '乙' => 'yi ', '舅' => 'jiu ', '卷' => 'juan ', '舌' => 'she ', '舍' => 'she ', '乡' => 'xiang ', '汇' => 'hui ', '宗' => 'zong ', '官' => 'guan ',
    '宙' => 'zhou ', '煤' => 'mei ', '厂' => 'chang ', '圈' => 'juan ', '宝' => 'bao ', '厅' => 'ting ', '煮' => 'zhu ', '览' => 'lan ', '雷' => 'lei ',
    '摄' => 'she ', '弯' => 'wan ', '摆' => 'bai ', '摇' => 'yao ', '厕' => 'ce ', '厘' => 'li ', '雾' => 'wu ', '弱' => 'ruo ', '池' => 'chi ',
    '土' => 'tu ', '强' => 'jiang ', '摔' => 'shuai ', '摘' => 'zhai ', '亏' => 'kui ', '素' => 'su ', '触' => 'chu ', '紫' => 'zi ', '摩' => 'mo ',
    '录' => 'lu ', '沉' => 'chen ', '甩' => 'shuai ', '均' => 'jun ', '摸' => 'mo ', '形' => 'xing ', '田' => 'tian ', '甲' => 'jia ', '沟' => 'gou ',
    '良' => 'liang ', '誉' => 'yu ', '艰' => 'jian ', '鬼' => 'gui ', '艳' => 'yan ', '彻' => 'che ', '彼' => 'bi ', '悠' => 'you ', '坦' => 'tan ',
    '撕' => 'si ', '征' => 'zheng ', '魅' => 'mei ', '待' => 'dai ', '悲' => 'bei ', '宠' => 'chong ', '踩' => 'cai ', '宣' => 'xuan ', '略' => 'lue ',
    '核' => 'he ', '型' => 'xing ', '宴' => 'yan ', '桃' => 'tao ', '厢' => 'xiang ', '宿' => 'su ', '寂' => 'ji ', '桔' => 'jie ', '惠' => 'hui ',
    '寓' => 'yu ', '惭' => 'can ', '县' => 'xian ', '产' => 'chan ', '档' => 'dang ', '疗' => 'liao ', '享' => 'xiang ', '寞' => 'mo ', '叉' => 'cha ',
    '震' => 'zhen ', '霉' => 'mei ', '鼠' => 'shu ', '虚' => 'xu ', '叙' => 'xu ', '蹲' => 'dun ', '寺' => 'si ', '燃' => 'ran ', '寻' => 'xun ',
    '古' => 'gu ', '寿' => 'shou ', '召' => 'shao ', '付' => 'fu ', '治' => 'zhi ', '虹' => 'hong ', '令' => 'ling ', '露' => 'lou ', '泉' => 'quan ',
    '祖' => 'zu ', '泛' => 'fan ', '仿' => 'fang ', '操' => 'cao ', '德' => 'de ', '青' => 'qing ', '靠' => 'kao ', '革' => 'ge ', '忍' => 'ren ',
    '倒' => 'dao ', '苗' => 'miao ', '倡' => 'chang ', '龙' => 'long ', '疯' => 'feng ', '疲' => 'pi ', '疾' => 'ji ', '域' => 'yu ', '念' => 'nian ',
    '英' => 'ying ', '痒' => 'yang ', '梨' => 'li ', '愁' => 'chou ', '培' => 'pei ', '痛' => 'tong ', '梳' => 'shu ', '躲' => 'duo ', '封' => 'feng ',
    '射' => 'she ', '棉' => 'mian ', '愤' => 'fen ', '愧' => 'kui ', '偷' => 'tou ', '棋' => 'qi ', '尖' => 'jian ', '尘' => 'chen ', '偿' => 'chang ',
    '棒' => 'bang ', '尚' => 'shang ', '傍' => 'bang ', '蛇' => 'she ', '吐' => 'tu ', '吓' => 'xia ', '税' => 'shui ', '企' => 'qi ', '慌' => 'huang ',
    '慎' => 'shen ', '尺' => 'che ', '尾' => 'wei ', '吨' => 'dun ', '局' => 'ju ', '含' => 'han ', '启' => 'qi ', '屈' => 'qu ', '伙' => 'huo ',
    '屉' => 'ti ', '届' => 'jie ', '屋' => 'wu ', '伟' => 'wei ', '慧' => 'hui ', '吹' => 'chui ', '稳' => 'wen ', '吻' => 'wen ', '私' => 'si ',
    '退' => 'tui ', '逃' => 'tao ', '慰' => 'wei ', '属' => 'shu ', '呆' => 'dai ', '鞭' => 'bian ', '洒' => 'sa ', '透' => 'tou ', '伴' => 'ban ',
    '伸' => 'shen ', '秒' => 'miao ', '秘' => 'bi ', '递' => 'di ', '途' => 'tu ', '似' => 'si ', '洞' => 'dong ', '逗' => 'dou ', '秩' => 'zhi ',
    '版' => 'ban ', '牌' => 'pai ', '称' => 'chen ', '余' => 'yu ', '佛' => 'fo ', '派' => 'pai ', '移' => 'yi ', '逻' => 'luo ', '浅' => 'jian ',
    '佣' => 'yong ', '呼' => 'hu ', '浇' => 'jiao ', '佩' => 'pei ', '测' => 'ce ', '堆' => 'dui ', '岛' => 'dao ', '浏' => 'liu ', '浓' => 'nong ',
    '政' => 'zheng ', '咐' => 'fu ', '遗' => 'yi ', '牵' => 'qian ', '敌' => 'di ', '敏' => 'min ', '催' => 'cui ', '救' => 'jiu ', '傻' => 'sha ',
    '遵' => 'zun ', '依' => 'yi ', '敬' => 'jing ', '涂' => 'tu ', '避' => 'bi ', '荐' => 'jian ', '繁' => 'fan ', '荣' => 'rong ', '塔' => 'ta ',
    '椒' => 'jiao ', '斗' => 'dou ', '斜' => 'xie ', '蜂' => 'feng ', '憾' => 'han ', '蜜' => 'mi ', '岸' => 'an ', '蜡' => 'la ', '咨' => 'zi ',
    '登' => 'deng ', '咬' => 'yao ', '皂' => 'zao ', '皇' => 'huang ', '哈' => 'ha ', '犯' => 'fan ', '侵' => 'qin ', '转' => 'zhuan ', '轮' => 'lun ',
    '立' => 'li ', '状' => 'zhuang ', '犹' => 'you ', '促' => 'cu ', '涨' => 'zhang ', '钓' => 'diao ', '载' => 'zai ', '狂' => 'kuang ', '俊' => 'jun ',
    '辅' => 'fu ', '液' => 'ye ', '辈' => 'bei ', '俗' => 'su ', '蝴' => 'hu ', '蝶' => 'die ', '哲' => 'zhe ', '辑' => 'ji ', '订' => 'ding ',
    '竹' => 'zhu ', '辞' => 'ci ', '狡' => 'jiao ', '训' => 'xun ', '讯' => 'xun ', '融' => 'rong ', '郊' => 'jiao ', '施' => 'shi ', '独' => 'du ',
    '俱' => 'ju ', '讽' => 'feng ', '设' => 'she ', '淡' => 'dan ', '狼' => 'lang ', '诊' => 'zhen ', '诗' => 'shi ', '纯' => 'chun ', '旦' => 'dan ',
    '纲' => 'gang ', '询' => 'xun ', '旬' => 'xun ', '纷' => 'fen ', '顶' => 'ding ', '壁' => 'bi ', '项' => 'xiang ', '线' => 'xian ', '领' => 'ling ',
    '绕' => 'rao ', '频' => 'pin ', '颗' => 'ke ', '统' => 'tong ', '盆' => 'pen ', '兄' => 'xiong ', '充' => 'chong ', '益' => 'yi ', '绪' => 'xu ',
    '盖' => 'gai ', '壶' => 'hu ', '兔' => 'tu ', '绳' => 'sheng ', '维' => 'wei ', '辩' => 'bian ', '模' => 'mo ', '绸' => 'chou ', '铃' => 'ling ',
    '综' => 'zong ', '横' => 'heng ', '戒' => 'jie ', '战' => 'zhan ', '兵' => 'bing ', '铜' => 'tong ', '盼' => 'pan ', '迅' => 'xun ', '盾' => 'dun ',
    '唉' => 'ai ', '返' => 'fan ', '册' => 'ce ', '违' => 'wei ', '扇' => 'shan ', '链' => 'lian ', '橡' => 'xiang ', '军' => 'jun ', '迫' => 'po ',
    '述' => 'shu ', '托' => 'tuo ', '迷' => 'mi ', '迹' => 'ji ', '耽' => 'dan ', '唯' => 'wei ', '追' => 'zhui ', '执' => 'zhi ', '扶' => 'fu ',
    '聚' => 'ju ', '献' => 'xian ', '承' => 'cheng ', '抄' => 'chao ', '筑' => 'zhu ', '猾' => 'hua ', '策' => 'ce ', '抓' => 'zhua ', '投' => 'tou ',
    '抖' => 'dou ', '抗' => 'kang ', '谓' => 'wei ', '飘' => 'piao ', '谜' => 'mi ', '肃' => 'su ', '肌' => 'ji ', '谦' => 'qian ', '谨' => 'jin ',
    '善' => 'shan ', '配' => 'pei ', '喊' => 'han ', '显' => 'xian ', '营' => 'ying ', '夕' => 'xi ', '冠' => 'guan ', '缓' => 'huan ', '夜' => 'ye ',
    '编' => 'bian ', '豆' => 'dou ', '缘' => 'yuan ', '晒' => 'shai ', '晕' => 'yun ', '眉' => 'mei ', '率' => 'shuai ', '冲' => 'chong ', '玉' => 'yu ',
    '落' => 'la ', '王' => 'wang ', '缩' => 'suo ', '冻' => 'dong ', '酱' => 'jiang ', '夸' => 'kua ', '夹' => 'jia ', '销' => 'xiao ', '锁' => 'suo ',
    '眠' => 'mian ', '豪' => 'hao ', '锅' => 'guo ', '豫' => 'yu ', '奈' => 'nai ', '醉' => 'zui ', '醋' => 'cu ', '源' => 'yuan ', '智' => 'zhi ',
    '锐' => 'rui ', '套' => 'tao ', '凡' => 'fan ', '罐' => 'guan ', '凭' => 'ping ', '罚' => 'fa ', '睁' => 'zheng ', '抢' => 'qiang ', '披' => 'pi ',
    '击' => 'ji ', '罪' => 'zui ', '置' => 'zhi ', '股' => 'gu ', '妇' => 'fu ', '拆' => 'chai ', '肩' => 'jian ', '拍' => 'pai ', '拐' => 'guai ',
    '妙' => 'miao ', '肺' => 'fei ', '拜' => 'bai ', '胁' => 'xie ', '胃' => 'wei ', '胆' => 'dan ', '拥' => 'yong ', '喷' => 'pen ', '拦' => 'lan ',
    '瞎' => 'xia ', '背' => 'bei ', '拳' => 'quan ', '胜' => 'sheng ', '巨' => 'ju ', '胡' => 'hu ', '嗓' => 'sang ', '玻' => 'bo ', '餐' => 'can ',
    '巴' => 'ba ', '衡' => 'heng ', '补' => 'bu ', '胳' => 'ge ', '胶' => 'jiao ', '胸' => 'xiong ', '珍' => 'zhen ', '采' => 'cai ', '滑' => 'gu ',
    '野' => 'ye ', '威' => 'wei ', '滚' => 'gun ', '滩' => 'tan ', '娘' => 'niang ', '妨' => 'fang ', '滴' => 'di ', '饰' => 'shi ', '创' => 'chuang ',
    '娱' => 'yu ', '初' => 'chu ', '娶' => 'qu ', '瞧' => 'qiao ', '删' => 'shan ', '翅' => 'chi ', '曾' => 'ceng ', '姑' => 'gu ', '委' => 'wei ',
    '刺' => 'ci ', '馒' => 'man ', '姥' => 'lao ', '矛' => 'mao ', '姻' => 'yin ', '欠' => 'qian ', '姿' => 'zi ', '欣' => 'xin ', '挑' => 'tiao ',
    '矩' => 'ju ', '布' => 'bu ', '剪' => 'jian ', '石' => 'dan ', '挡' => 'dang ', '挣' => 'zheng ', '脆' => 'cui ', '挤' => 'ji ', '款' => 'kuan ',
    '挥' => 'hui ', '矿' => 'kuang ', '振' => 'zhen ', '帘' => 'lian ', '歇' => 'xie ', '帝' => 'di ', '脖' => 'bo ', '嘉' => 'jia ', '闪' => 'shan ',
    '闭' => 'bi ', '闯' => 'chuang ', '灭' => 'mie ', '裁' => 'cai ', '闲' => 'xian ', '装' => 'zhuang ', '灰' => 'hui ', '席' => 'xi ', '灵' => 'ling ',
    '灾' => 'zai ', '劝' => 'quan ', '武' => 'wu ', '裔' => 'yi ', '捐' => 'juan ', '歪' => 'wai ', '幅' => 'fu ', '损' => 'sun ', '嘱' => 'zhu ',
    '捡' => 'jian ', '炒' => 'chao ', '幕' => 'mu ', '腐' => 'fu ', '裹' => 'guo ', '殊' => 'shu ', '残' => 'can ', '漏' => 'lou ', '籍' => 'ji ',
    '漠' => 'mo ', '腰' => 'yao ', '幻' => 'huan ', '幼' => 'you ', '器' => 'qi ', '朝' => 'chao ', '庆' => 'qing ', '贝' => 'bei ', '膀' => 'bang ',
    '木' => 'mu ', '贡' => 'gong ', '财' => 'cai ', '未' => 'wei ', '膊' => 'bo ', '账' => 'zhang ', '库' => 'ku ', '庙' => 'miao ', '类' => 'lei ',
    '朴' => 'po ', '府' => 'fu ', '废' => 'fei ', '贴' => 'tie ', '贷' => 'dai ', '贸' => 'mao ', '嚏' => 'ti ', '杀' => 'sha ', '权' => 'quan ',
    '劣' => 'lie ', '蔬' => 'shu ', '粒' => 'li ', '驶' => 'shi ', '嫁' => 'jia ', '粘' => 'nian ', '璃' => 'li ', '驾' => 'jia ', '赏' => 'shang ',
    '劲' => 'jin ', '劳' => 'lao ', '砍' => 'kan ', '骂' => 'ma ', '赔' => 'pei ', '势' => 'shi ', '赞' => 'zan ', '炭' => 'tan ', '炮' => 'pao ',
    '嫩' => 'nen ', '炸' => 'zha ', '赴' => 'fu ', '阐' => 'chan ', '阔' => 'kuo ', '砸' => 'za ', '烁' => 'shuo ', '枉' => 'wang ', '殴' => 'ou ',
    '蕴' => 'yun ', '掠' => 'lue ', '探' => 'tan ', '殿' => 'dian ', '掩' => 'yan ', '烘' => 'hong ', '枚' => 'mei ', '枝' => 'zhi ', '毁' => 'hui ',
    '毅' => 'yi ', '勾' => 'gou ', '勿' => 'wu ', '掰' => 'bai ', '掷' => 'zhi ', '陈' => 'chen ', '膨' => 'peng ', '揉' => 'rou ', '陋' => 'lou ',
    '烹' => 'peng ', '揍' => 'zou ', '庸' => 'yong ', '粥' => 'yu ', '廉' => 'lian ', '陡' => 'dou ', '廊' => 'lang ', '臂' => 'bi ', '碌' => 'lu ',
    '嚼' => 'jiao ', '廓' => 'kuo ', '揭' => 'jie ', '粹' => 'cui ', '碑' => 'bei ', '陵' => 'ling ', '陶' => 'tao ', '陷' => 'xian ', '援' => 'yuan ',
    '隆' => 'long ', '臣' => 'chen ', '隐' => 'yin ', '隘' => 'ai ', '隙' => 'xi ', '障' => 'zhang ', '枯' => 'ku ', '覆' => 'fu ', '瓣' => 'ban ',
    '瓦' => 'wa ', '趴' => 'pa ', '濒' => 'bin ', '瓷' => 'ci ', '怠' => 'dai ', '薪' => 'xin ', '怨' => 'yuan ', '怯' => 'qie ', '跌' => 'die ',
    '柬' => 'jian ', '跨' => 'kua ', '恍' => 'huang ', '跪' => 'gui ', '柱' => 'zhu ', '碧' => 'bi ', '恒' => 'heng ', '恕' => 'shu ', '丐' => 'gai ',
    '匪' => 'fei ', '丘' => 'qiu ', '碳' => 'tan ', '丛' => 'cong ', '恩' => 'en ', '孔' => 'kong ', '恭' => 'gong ', '孕' => 'yun ', '丧' => 'sang ',
    '隧' => 'sui ', '磅' => 'bang ', '恰' => 'qia ', '氏' => 'shi ', '焦' => 'jiao ', '磋' => 'cuo ', '氓' => 'mang ', '串' => 'chuan ', '丸' => 'wan ',
    '黎' => 'li ', '隶' => 'li ', '磕' => 'ke ', '搀' => 'chan ', '焰' => 'yan ', '搁' => 'ge ', '搂' => 'lou ', '卑' => 'bei ', '搅' => 'jiao ',
    '卓' => 'zhuo ', '氢' => 'qing ', '搏' => 'bo ', '氧' => 'yang ', '雅' => 'ya ', '磨' => 'mo ', '搓' => 'cuo ', '乌' => 'wu ', '雌' => 'ci ',
    '异' => 'yi ', '搜' => 'sou ', '煌' => 'huang ', '宅' => 'zhai ', '悟' => 'wu ', '雕' => 'diao ', '弊' => 'bi ', '舆' => 'yu ', '乞' => 'qi ',
    '宏' => 'hong ', '卸' => 'xie ', '搭' => 'da ', '舔' => 'tian ', '携' => 'xie ', '舟' => 'zhou ', '弥' => 'mi ', '弦' => 'xian ', '乳' => 'ru ',
    '觅' => 'mi ', '紊' => 'wen ', '雹' => 'bao ', '摊' => 'tan ', '予' => 'yu ', '舰' => 'jian ', '舱' => 'cang ', '圣' => 'sheng ', '舶' => 'bo ',
    '熄' => 'xi ', '索' => 'suo ', '汰' => 'tai ', '熏' => 'xun ', '井' => 'jing ', '汹' => 'xiong ', '艇' => 'ting ', '甘' => 'gan ', '摧' => 'cui ',
    '归' => 'gui ', '沃' => 'wo ', '艘' => 'sou ', '沐' => 'mu ', '甭' => 'beng ', '坑' => 'keng ', '沛' => 'pei ', '栋' => 'dong ', '彰' => 'zhang ',
    '坛' => 'tan ', '栏' => 'lan ', '坝' => 'ba ', '坟' => 'fen ', '役' => 'yi ', '踊' => 'yong ', '踌' => 'chou ', '坡' => 'po ', '踏' => 'ta ',
    '撑' => 'cheng ', '撒' => 'sa ', '畅' => 'chang ', '患' => 'huan ', '悦' => 'yue ', '魂' => 'hun ', '魄' => 'po ', '誓' => 'shi ', '畏' => 'wei ',
    '径' => 'jing ', '悬' => 'xuan ', '徊' => 'huai ', '畔' => 'pan ', '株' => 'zhu ', '畜' => 'chu ', '魔' => 'mo ', '徒' => 'tu ', '审' => 'shen ',
    '悼' => 'dao ', '徘' => 'pai ', '徙' => 'xi ', '踪' => 'zong ', '芒' => 'mang ', '垂' => 'chui ', '垄' => 'long ', '宪' => 'xian ', '宫' => 'gong ',
    '番' => 'pan ', '栽' => 'zai ', '宰' => 'zai ', '惋' => 'wan ', '宵' => 'xiao ', '畴' => 'chou ', '框' => 'kuang ', '惑' => 'huo ', '惕' => 'ti ',
    '厦' => 'sha ', '蹈' => 'dao ', '蹋' => 'ta ', '桑' => 'sang ', '疆' => 'jiang ', '惦' => 'dian ', '惧' => 'ju ', '惨' => 'can ', '惩' => 'cheng ',
    '疏' => 'shu ', '亡' => 'wang ', '惫' => 'bei ', '亦' => 'yi ', '惮' => 'dan ', '惰' => 'duo ', '桨' => 'jiang ', '亭' => 'ting ', '疙' => 'ge ',
    '熨' => 'yu ', '惹' => 're ', '虏' => 'lu ', '蹦' => 'beng ', '熬' => 'ao ', '虐' => 'nue ', '蹬' => 'deng ', '霍' => 'huo ', '仁' => 'ren ',
    '叛' => 'pan ', '沧' => 'cang ', '仇' => 'chou ', '寸' => 'cun ', '梁' => 'liang ', '沫' => 'mo ', '叠' => 'die ', '沮' => 'ju ', '霜' => 'shuang ',
    '叨' => 'dao ', '霞' => 'xia ', '虫' => 'chong ', '躁' => 'zao ', '躇' => 'chu ', '仓' => 'cang ', '叭' => 'ba ', '叮' => 'ding ', '沸' => 'fei ',
    '仗' => 'zhang ', '仙' => 'xian ', '沼' => 'zhao ', '撤' => 'che ', '沾' => 'zhan ', '沿' => 'yan ', '叹' => 'tan ', '泄' => 'xie ', '叼' => 'diao ',
    '蚀' => 'shi ', '霸' => 'ba ', '泊' => 'bo ', '仪' => 'yi ', '泌' => 'bi ', '御' => 'yu ', '仰' => 'yang ', '祥' => 'xiang ', '循' => 'xun ',
    '芦' => 'lu ', '擅' => 'shan ', '泡' => 'pao ', '波' => 'bo ', '擎' => 'qing ', '泥' => 'ni ', '祸' => 'huo ', '泰' => 'tai ', '垫' => 'dian ',
    '芽' => 'ya ', '齿' => 'chi ', '忌' => 'ji ', '泻' => 'xie ', '泽' => 'ze ', '倘' => 'tang ', '苍' => 'cang ', '苏' => 'su ', '疤' => 'ba ',
    '倦' => 'juan ', '疫' => 'yi ', '忠' => 'zhong ', '埋' => 'mai ', '苟' => 'gou ', '忧' => 'you ', '若' => 'ruo ', '债' => 'zhai ', '倾' => 'qing ',
    '症' => 'zheng ', '偏' => 'pian ', '梢' => 'shao ', '痕' => 'hen ', '愈' => 'yu ', '械' => 'xie ', '躬' => 'gong ', '痪' => 'huan ', '愚' => 'yu ',
    '痹' => 'bi ', '愣' => 'leng ', '棍' => 'gun ', '棕' => 'zong ', '吁' => 'xu ', '吉' => 'ji ', '稀' => 'xi ', '吊' => 'diao ', '尬' => 'ga ',
    '慈' => 'ci ', '吝' => 'lin ', '吞' => 'tun ', '尴' => 'gan ', '吟' => 'yin ', '尸' => 'shi ', '稚' => 'zhi ', '伍' => 'wu ', '爆' => 'bao ',
    '伏' => 'fu ', '吩' => 'fen ', '稠' => 'chou ', '伐' => 'fa ', '屁' => 'pi ', '屏' => 'bing ', '慨' => 'kai ', '禽' => 'qin ', '蛮' => 'man ',
    '洁' => 'jie ', '屑' => 'xie ', '吼' => 'hou ', '鞠' => 'ju ', '伦' => 'lun ', '秃' => 'tu ', '伪' => 'wei ', '稻' => 'dao ', '稿' => 'gao ',
    '伯' => 'bo ', '慷' => 'kang ', '呈' => 'cheng ', '逊' => 'xun ', '屡' => 'lu ', '履' => 'lu ', '伶' => 'ling ', '攀' => 'pan ', '伺' => 'ci ',
    '呕' => 'ou ', '逝' => 'shi ', '爽' => 'shuang ', '津' => 'jin ', '憋' => 'bie ', '秤' => 'cheng ', '洪' => 'hong ', '逢' => 'feng ', '攒' => 'cuan ',
    '屿' => 'yu ', '逮' => 'dai ', '岂' => 'qi ', '茂' => 'mao ', '洽' => 'qia ', '呵' => 'a ', '逼' => 'bi ', '茎' => 'jing ', '呻' => 'shen ',
    '穴' => 'xue ', '岔' => 'cha ', '岗' => 'gang ', '韧' => 'ren ', '堂' => 'tang ', '浊' => 'zhuo ', '牢' => 'lao ', '咀' => 'ju ', '牧' => 'mu ',
    '浑' => 'hun ', '攻' => 'gong ', '咋' => 'ze ', '遏' => 'e ', '窃' => 'qie ', '佳' => 'jia ', '牲' => 'sheng ', '堕' => 'duo ', '咙' => 'long ',
    '储' => 'chu ', '茫' => 'mang ', '牺' => 'xi ', '侈' => 'chi ', '堡' => 'bao ', '遣' => 'qian ', '堤' => 'di ', '遥' => 'yao ', '窜' => 'cuan ',
    '窝' => 'wo ', '浮' => 'fu ', '堪' => 'kan ', '遭' => 'zao ', '遮' => 'zhe ', '浴' => 'yu ', '敞' => 'chang ', '浸' => 'jin ', '涉' => 'she ',
    '荒' => 'huang ', '瘤' => 'liu ', '譬' => 'pi ', '涌' => 'yong ', '瘩' => 'da ', '敷' => 'fu ', '瘫' => 'tan ', '塌' => 'ta ', '涕' => 'ti ',
    '荡' => 'dang ', '涛' => 'tao ', '荧' => 'ying ', '瘸' => 'que ', '塘' => 'tang ', '椎' => 'chui ', '瘾' => 'yin ', '塞' => 'sai ', '斑' => 'ban ',
    '僵' => 'jiang ', '癌' => 'ai ', '斟' => 'zhen ', '僻' => 'pi ', '椭' => 'tuo ', '岩' => 'yan ', '墅' => 'shu ', '岳' => 'yue ', '墓' => 'mu ',
    '墟' => 'xu ', '皆' => 'jie ', '鲁' => 'lu ', '侠' => 'xia ', '侣' => 'lu ', '咽' => 'yan ', '侦' => 'zhen ', '侧' => 'ce ', '侨' => 'qiao ',
    '哀' => 'ai ', '侮' => 'wu ', '哄' => 'hong ', '哆' => 'duo ', '哇' => 'wa ', '轨' => 'gui ', '犬' => 'quan ', '峡' => 'xia ', '哎' => 'ai ',
    '钉' => 'ding ', '哑' => 'ya ', '峭' => 'qiao ', '轰' => 'hong ', '峰' => 'feng ', '竖' => 'shu ', '哟' => 'yo ', '峻' => 'jun ', '涮' => 'shuan ',
    '哦' => 'e ', '狈' => 'bei ', '哨' => 'shao ', '钞' => 'chao ', '俐' => 'li ', '辉' => 'hui ', '涵' => 'han ', '俘' => 'fu ', '斥' => 'chi ',
    '竭' => 'jie ', '端' => 'duan ', '斩' => 'zhan ', '辐' => 'fu ', '榜' => 'bang ', '淀' => 'dian ', '辖' => 'xia ', '辙' => 'che ', '讥' => 'ji ',
    '哺' => 'bu ', '斯' => 'si ', '哼' => 'heng ', '淆' => 'xiao ', '辜' => 'gu ', '郁' => 'yu ', '辟' => 'bi ', '狠' => 'hen ', '淋' => 'lin ',
    '俭' => 'jian ', '俯' => 'fu ', '讳' => 'hui ', '郎' => 'lang ', '狭' => 'xia ', '讶' => 'ya ', '淘' => 'tao ', '郑' => 'zheng ', '讼' => 'song ',
    '狱' => 'yu ', '莫' => 'mo ', '旋' => 'xuan ', '诈' => 'zha ', '旗' => 'qi ', '墨' => 'mo ', '纠' => 'jiu ', '纤' => 'qian ', '混' => 'hun ',
    '淹' => 'yan ', '纬' => 'wei ', '添' => 'tian ', '诞' => 'dan ', '旨' => 'zhi ', '菌' => 'jun ', '纳' => 'na ', '纵' => 'zong ', '诧' => 'cha ',
    '纹' => 'wen ', '纺' => 'fang ', '诫' => 'jie ', '诬' => 'wu ', '纽' => 'niu ', '旱' => 'han ', '旷' => 'kuang ', '顽' => 'wan ', '诱' => 'you ',
    '旺' => 'wang ', '绅' => 'shen ', '诵' => 'song ', '诸' => 'zhu ', '颁' => 'ban ', '颂' => 'song ', '皱' => 'zhou ', '颇' => 'po ', '颈' => 'jing ',
    '诺' => 'nuo ', '绎' => 'yi ', '诽' => 'fei ', '绑' => 'bang ', '绒' => 'rong ', '绘' => 'hui ', '颖' => 'ying ', '络' => 'lao ', '钦' => 'qin ',
    '壤' => 'rang ', '钩' => 'gou ', '盈' => 'ying ', '额' => 'e ', '兆' => 'zhao ', '绣' => 'xiu ', '壮' => 'zhuang ', '监' => 'jian ', '壳' => 'ke ',
    '榨' => 'zha ', '盗' => 'dao ', '兑' => 'dui ', '钻' => 'zuan ', '盛' => 'cheng ', '盟' => 'meng ', '辨' => 'bian ', '党' => 'dang ', '兜' => 'dou ',
    '辫' => 'bian ', '兢' => 'jing ', '辰' => 'chen ', '辱' => 'ru ', '盯' => 'ding ', '崇' => 'chong ', '辽' => 'liao ', '盲' => 'mang ', '耀' => 'yao ',
    '迁' => 'qian ', '迄' => 'qi ', '迈' => 'mai ', '截' => 'jie ', '耍' => 'shua ', '崖' => 'ya ', '兼' => 'jian ', '兽' => 'shou ', '耕' => 'geng ',
    '唆' => 'suo ', '耗' => 'hao ', '唇' => 'chun ', '螺' => 'luo ', '铭' => 'ming ', '崩' => 'beng ', '橙' => 'cheng ', '铸' => 'zhu ', '唐' => 'tang ',
    '扁' => 'bian ', '崭' => 'zhan ', '铺' => 'pu ', '扎' => 'za ', '唠' => 'lao ', '扑' => 'pu ', '扒' => 'ba ', '耸' => 'song ', '迸' => 'beng ',
    '耻' => 'chi ', '扛' => 'gang ', '猎' => 'lie ', '嵌' => 'qian ', '扣' => 'kou ', '猖' => 'chang ', '猛' => 'meng ', '聋' => 'long ', '唾' => 'tuo ',
    '扭' => 'niu ', '颠' => 'dian ', '扯' => 'che ', '颤' => 'chan ', '笼' => 'long ', '啃' => 'ken ', '渔' => 'yu ', '渗' => 'shen ', '昂' => 'ang ',
    '筋' => 'jin ', '昆' => 'kun ', '鄙' => 'bi ', '渠' => 'qu ', '筐' => 'kuang ', '渡' => 'du ', '昌' => 'chang ', '渣' => 'zha ', '筒' => 'tong ',
    '昏' => 'hun ', '谋' => 'mou ', '谍' => 'die ', '筛' => 'shai ', '谎' => 'huang ', '昔' => 'xi ', '抑' => 'yi ', '港' => 'gang ', '抒' => 'shu ',
    '啥' => 'sha ', '啦' => 'la ', '谐' => 'xie ', '抚' => 'fu ', '抛' => 'pao ', '啬' => 'se ', '飙' => 'biao ', '渺' => 'miao ', '啰' => 'luo ',
    '昧' => 'mei ', '肆' => 'si ', '啸' => 'xiao ', '萌' => 'meng ', '谣' => 'yao ', '谤' => 'bang ', '筹' => 'chou ', '谬' => 'miu ', '肖' => 'xiao ',
    '喇' => 'la ', '喉' => 'hou ', '缀' => 'chuo ', '谱' => 'pu ', '酌' => 'zhuo ', '昼' => 'zhou ', '谴' => 'qian ', '谷' => 'gu ', '湖' => 'hu ',
    '晃' => 'huang ', '酗' => 'xu ', '冤' => 'yuan ', '喘' => 'chuan ', '缔' => 'di ', '晋' => 'jin ', '酝' => 'yun ', '缚' => 'fu ', '缝' => 'feng ',
    '晓' => 'xiao ', '缠' => 'chan ', '酬' => 'chou ', '央' => 'yang ', '晤' => 'wu ', '湾' => 'wan ', '酷' => 'ku ', '晨' => 'chen ', '凄' => 'qi ',
    '夺' => 'duo ', '缴' => 'jiao ', '溃' => 'kui ', '酿' => 'niang ', '溅' => 'jian ', '凌' => 'ling ', '溉' => 'gai ', '晰' => 'xi ', '锈' => 'xiu ',
    '眨' => 'zha ', '晶' => 'jing ', '凑' => 'cou ', '奉' => 'feng ', '锋' => 'feng ', '眯' => 'mi ', '晾' => 'liang ', '奏' => 'zou ', '凝' => 'ning ',
    '董' => 'dong ', '眶' => 'kuang ', '溜' => 'liu ', '奔' => 'ben ', '暄' => 'xuan ', '葫' => 'hu ', '葬' => 'zang ', '罕' => 'han ', '锤' => 'chui ',
    '奠' => 'dian ', '奢' => 'she ', '锦' => 'jin ', '奥' => 'ao ', '凶' => 'xiong ', '凸' => 'tu ', '凹' => 'ao ', '罢' => 'ba ', '罩' => 'zhao ',
    '锲' => 'qie ', '蒂' => 'di ', '奴' => 'nu ', '抵' => 'di ', '抹' => 'mo ', '署' => 'shu ', '押' => 'ya ', '督' => 'du ', '镇' => 'zhen ',
    '妄' => 'wang ', '睦' => 'mu ', '肢' => 'zhi ', '妆' => 'zhuang ', '蒙' => 'meng ', '拄' => 'zhu ', '睬' => 'cai ', '肪' => 'fang ', '拌' => 'ban ',
    '蠢' => 'chun ', '妒' => 'du ', '睹' => 'du ', '肴' => 'yao ', '拓' => 'ta ', '拔' => 'ba ', '拖' => 'tuo ', '拘' => 'ju ', '拙' => 'zhuo ',
    '肿' => 'zhong ', '拟' => 'ni ', '胀' => 'zhang ', '箭' => 'jian ', '拢' => 'long ', '拣' => 'jian ', '拧' => 'ning ', '拨' => 'bo ', '喻' => 'yu ',
    '胎' => 'tai ', '瞒' => 'man ', '衅' => 'xin ', '镶' => 'xiang ', '川' => 'chuan ', '州' => 'zhou ', '嗅' => 'xiu ', '衍' => 'yan ', '巡' => 'xun ',
    '胞' => 'bao ', '拼' => 'pin ', '拽' => 'ye ', '巩' => 'gong ', '衔' => 'xian ', '巷' => 'xiang ', '溪' => 'xi ', '嗦' => 'suo ', '嗨' => 'hai ',
    '溶' => 'rong ', '嗯' => 'en ', '衰' => 'cui ', '衷' => 'zhong ', '暧' => 'ai ', '篷' => 'peng ', '珠' => 'zhu ', '滋' => 'zi ', '暴' => 'bao ',
    '袍' => 'pao ', '滔' => 'tao ', '娃' => 'wa ', '娇' => 'jiao ', '袖' => 'xiu ', '滞' => 'zhi ', '滤' => 'lu ', '滥' => 'lan ', '滨' => 'bin ',
    '妥' => 'tuo ', '蒸' => 'zheng ', '曝' => 'pu ', '刊' => 'kan ', '饥' => 'ji ', '蓄' => 'xu ', '刑' => 'xing ', '饪' => 'ren ', '饲' => 'si ',
    '饶' => 'rao ', '曲' => 'qu ', '姆' => 'mu ', '瞩' => 'zhu ', '瞪' => 'deng ', '馅' => 'xian ', '婆' => 'po ', '馈' => 'kui ', '瀑' => 'bao ',
    '馋' => 'chan ', '瞻' => 'zhan ', '券' => 'quan ', '刹' => 'cha ', '蓬' => 'peng ', '翔' => 'xiang ', '翘' => 'qiao ', '剂' => 'ji ', '削' => 'xiao ',
    '婪' => 'lan ', '剔' => 'ti ', '剖' => 'pou ', '挎' => 'kua ', '婴' => 'ying ', '欧' => 'ou ', '翼' => 'yi ', '挖' => 'wa ', '剥' => 'bao ',
    '挚' => 'zhi ', '欲' => 'yu ', '灌' => 'guan ', '帆' => 'fan ', '副' => 'fu ', '挠' => 'nao ', '脂' => 'zhi ', '欺' => 'qi ', '割' => 'ge ',
    '脉' => 'mai ', '挨' => 'ai ', '袭' => 'xi ', '帐' => 'zhang ', '挪' => 'nuo ', '挫' => 'cuo ', '帖' => 'tie ', '媒' => 'mei ', '袱' => 'fu ',
    '帜' => 'zhi ', '嘈' => 'cao ', '劈' => 'pi ', '挽' => 'wan ', '裂' => 'lie ', '闷' => 'men ', '捆' => 'kun ', '灶' => 'zao ', '捉' => 'zhuo ',
    '嘛' => 'ma ', '捍' => 'han ', '捎' => 'shao ', '捏' => 'nie ', '灿' => 'can ', '歧' => 'qi ', '裕' => 'yu ', '捕' => 'bu ', '炉' => 'lu ',
    '捞' => 'lao ', '炎' => 'yan ', '歹' => 'dai ', '嘲' => 'chao ', '捣' => 'dao ', '捧' => 'peng ', '漆' => 'qi ', '殃' => 'yang ', '嘿' => 'hei ',
    '簸' => 'bo ', '裳' => 'chang ', '琢' => 'zhuo ', '腔' => 'qiang ', '捷' => 'jie ', '幢' => 'chuang ', '殖' => 'zhi ', '掀' => 'xian ', '腥' => 'xing ',
    '腮' => 'sai ', '掏' => 'tao ', '掐' => 'qia ', '朗' => 'lang ', '腹' => 'fu ', '掘' => 'jue ', '噪' => 'zao ', '腻' => 'ni ', '腾' => 'teng ',
    '庄' => 'zhuang ', '庇' => 'bi ', '贤' => 'xian ', '贩' => 'fan ', '贪' => 'tan ', '蔑' => 'mie ', '贫' => 'pin ', '蔓' => 'man ', '贬' => 'bian ',
    '贯' => 'guan ', '庞' => 'pang ', '膛' => 'tang ', '朽' => 'xiu ', '膜' => 'mo ', '膝' => 'xi ', '媳' => 'xi ', '粉' => 'fen ', '贼' => 'zei ',
    '潜' => 'qian ', '贿' => 'hui ', '杆' => 'gan ', '赁' => 'lin ', '驰' => 'chi ', '驱' => 'qu ', '赂' => 'lu ', '驳' => 'bo ', '劫' => 'jie ',
    '嫂' => 'sao ', '嫉' => 'ji ', '赋' => 'fu ', '驻' => 'zhu ', '赌' => 'du ', '潮' => 'chao ', '杖' => 'zhang ', '嫌' => 'xian ', '蔼' => 'ai ',
    '蔽' => 'bi ', '杜' => 'du ', '赖' => 'lai ', '杠' => 'gang ', '砖' => 'zhuan ', '鉴' => 'jian ', '勃' => 'bo ', '赠' => 'zeng ', '勉' => 'mian ',
    '赤' => 'chi ', '澄' => 'cheng ', '澈' => 'che ', '阂' => 'he ', '骚' => 'sao ', '杰' => 'jie ', '勘' => 'kan ', '鸣' => 'ming '
];
