/**
 * @license Copyright (c) 2003-2013, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.html or http://ckeditor.com/license
 */

CKEDITOR.editorConfig = function( config ) {
    config.enterMode = CKEDITOR.ENTER_BR;
    config.language = nv_lang_interface;
    config.allowedContent = true;
    config.extraPlugins = 'video,eqneditor,switchbar,tbvdownload,cleanlink,docviewer';
    config.entities = false;
    config.image2_altRequired = false;
    config.image2_alignClasses = ['image-left', 'image-center', 'image-right'];
    config.youtube_width = '640';
    config.youtube_height = '480';
    config.youtube_related = false;
    config.youtube_older = false;
    config.youtube_privacy = false;
    config.youtube_autoplay = true;
    config.codeSnippet_theme = 'github';
    config.iframe_attributes = {
        sandbox: 'allow-scripts allow-same-origin allow-forms allow-presentation allow-popups',
        allow: 'autoplay'
    };
    config.versionCheck = false;
    // Default setting.

    config.toolbarGroups = [
        { name: 'clipboard', groups: [ 'clipboard', 'undo' ] },
        { name: 'insert', groups: [ 'insert' ] },
        { name: 'others', groups: [ 'others' ] },
        '/',
        { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
        { name: 'paragraph', groups: [ 'list', 'indent', 'blocks', 'align', 'bidi', 'paragraph' ] },
        { name: 'links', groups: [ 'links' ] },
        '/',
        { name: 'styles', groups: [ 'styles' ] },
        { name: 'colors', groups: [ 'colors' ] },
        { name: 'editing', groups: [ 'find', 'selection', 'spellchecker', 'editing' ] },
        { name: 'document', groups: [ 'mode', 'document', 'doctools' ] },
        { name: 'tools', groups: [ 'tools' ] }
    ];

    config.toolbar_Basic =
    [
        { name: 'clipboard', items : [ 'Cut','Copy','Paste','PasteText','PasteFromWord','-','Undo','Redo' ] },
        { name: 'insert', items : [ 'Image','Flash','Table','HorizontalRule','Smiley','SpecialChar','PageBreak','Iframe' ] },
        { name: 'links', items : [ 'Link','Unlink','Anchor' ] },
        '/',
        { name: 'basicstyles', items : [ 'Bold','Italic','Strike','-','RemoveFormat' ] },
        { name: 'paragraph', items : [ 'NumberedList','BulletedList','-','Outdent','Indent','-','Blockquote' ] },
        { name: 'styles', items : [ 'Font', 'FontSize', 'TextColor', 'BGColor' ] },
        { name: 'tools', items : ['SwitchBar',  'Maximize'] }
    ];
};
