<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_notifications
 */

/**
 * Block class.
 */
class Block_top_notifications
{
    /**
     * Find details of the block.
     *
     * @return ?array Map of block info (null: block is disabled).
     */
    public function info()
    {
        $info = array();
        $info['author'] = 'Chris Graham';
        $info['organisation'] = 'ocProducts';
        $info['hacked_by'] = null;
        $info['hack_version'] = null;
        $info['version'] = 1;
        $info['locked'] = false;
        $info['parameters'] = array('max');
        return $info;
    }

    /**
     * Execute the block.
     *
     * @param  array $map A map of parameters.
     * @return Tempcode The result of execution.
     */
    public function run($map)
    {
        if (is_guest()) {
            return new Tempcode();
        }

        if (!has_js()) {
            return new Tempcode();
        }

        $max = isset($map['max']) ? intval($map['max']) : 5;

        require_lang('notifications');

        require_code('notification_poller');

        list($notifications, $num_unread_web_notifications) = get_web_notifications($max);

        list($pts, $num_unread_pts) = get_pts($max);

        return do_template('BLOCK_TOP_NOTIFICATIONS', array(
            '_GUID' => '3fa04eb827741561440dbf1a65988b33',
            'NUM_UNREAD_WEB_NOTIFICATIONS' => strval($num_unread_web_notifications),
            'NOTIFICATIONS' => $notifications,

            'NUM_UNREAD_PTS' => strval($num_unread_pts),
            'PTS' => $pts,

            'MAX' => strval($max),
        ));
    }
}
