<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_cns
 */

/* This file exists to alleviate PHP memory usage. It shaves over 100KB of memory need for any Conversr request. */

/**
 * Add the specified custom field to the forum (some forums implemented this using proper custom profile fields, others through adding a new field).
 *
 * @param  object $this_ref Link to the real forum driver
 * @param  string $name The name of the new custom field
 * @param  integer $length The length of the new custom field
 * @param  BINARY $locked Whether the field is locked
 * @param  BINARY $viewable Whether the field is for viewing
 * @param  BINARY $settable Whether the field is for setting
 * @param  BINARY $required Whether the field is required
 * @param  string $description Description
 * @param  string $type The field type
 * @param  BINARY $encrypted Whether the field is encrypted
 * @param  ?string $default Default field value (null: standard for field type)
 * @return boolean Whether the custom field was created successfully
 *
 * @ignore
 */
function _helper_install_create_custom_field($this_ref, $name, $length, $locked = 1, $viewable = 0, $settable = 0, $required = 0, $description = '', $type = 'long_text', $encrypted = 0, $default = null)
{
    cns_require_all_forum_stuff();
    require_code('cns_members_action');

    $name = 'cms_' . $name;
    $id = $this_ref->connection->query_select_value_if_there('f_custom_fields', 'id', array($this_ref->connection->translate_field_ref('cf_name') => $name));
    if (is_null($id)) {
        if (is_null($default)) {
            $default = (strpos($name, 'points') !== false) ? '0' : '';
        }
        $id = cns_make_custom_field($name, $locked, $description, $default, $viewable, $viewable, $settable, $encrypted, $type, $required, 0, 0, null, '', 0, '', true);
    }
    return !is_null($id);
}

/**
 * Edit a custom profile field.
 *
 * @param  object $this_ref Link to the real forum driver
 * @param  string $old_name The name of the current custom field
 * @param  string $new_name The new name of the custom profile field (blank: do not rename)
 * @param  integer $length The new length of the custom field
 * @param  BINARY $locked Whether the field is locked
 * @param  BINARY $viewable Whether the field is for viewing
 * @param  BINARY $settable Whether the field is for setting
 * @param  BINARY $required Whether the field is required
 * @param  string $description Description
 * @param  string $type The field type
 * @param  BINARY $encrypted Whether the field is encrypted
 * @param  ?string $default Default field value (null: standard for field type)
 * @return boolean Whether the custom field was edited successfully
 * @ignore
 */
function _helper_install_edit_custom_field($this_ref, $old_name, $new_name, $length, $locked = 1, $viewable = 0, $settable = 0, $required = 0, $description = '', $type = 'long_text', $encrypted = 0, $default = null)
{
    cns_require_all_forum_stuff();
    require_code('cns_members_action2');

    $old_name = 'cms_' . $old_name;
    if ($new_name != '') {
        $new_name = 'cms_' . $new_name;
    } else {
        $new_name = 'cms_' . $old_name;
    }

    $id = $this_ref->connection->query_select_value_if_there('f_custom_fields', 'id', array($this_ref->connection->translate_field_ref('cf_name') => $old_name));
    if (!is_null($id)) {
        if (is_null($default)) {
            $default = (strpos($new_name, 'points') !== false) ? '0' : '';
        }
        cns_edit_custom_field($id, $new_name, $description, $default, $viewable, $viewable, $settable, $encrypted, $required, 0, 0, null, '', $type, 0, '');
        return true;
    }

    return false;
}

/**
 * Get an array of attributes to take in from the installer. Almost all forums require a table prefix, which the requirement there-of is defined through this function.
 * The attributes have 4 values in an array
 * - name, the name of the attribute for _config.php
 * - default, the default value (perhaps obtained through autodetection from forum config)
 * - description, a textual description of the attributes
 * - title, a textual title of the attribute
 *
 * @return array The attributes for the forum
 *
 * @ignore
 */
function _helper_install_specifics()
{
    $a = array();
    $a['name'] = 'cns_table_prefix';
    $a['default'] = function_exists('get_default_table_prefix') ? get_default_table_prefix() : 'cms_';
    $a['description'] = do_lang('MOST_DEFAULT');
    $a['title'] = do_lang('TABLE_PREFIX');

    $b = array();
    $b['name'] = 'clear_existing_forums_on_install';
    $b['default'] = 'no';
    $b['description'] = do_lang_tempcode('DESCRIPTION_CLEAR_EXISTING_FORUMS_ON_INSTALL');
    $b['title'] = do_lang_tempcode('CLEAR_EXISTING_FORUMS_ON_INSTALL');

    $c = array();
    $c['name'] = 'admin_username';
    $c['default'] = 'admin';
    $c['description'] = do_lang_tempcode('DESCRIPTION_ADMIN_USERNAME');
    $c['title'] = do_lang_tempcode('ADMIN_USERNAME');
    $c['required'] = true;

    $d = array();
    $d['name'] = 'cns_admin_password';
    $d['default'] = '';
    $d['description'] = do_lang_tempcode('DESCRIPTION_ADMIN_USERS_PASSWORD');
    $d['title'] = do_lang_tempcode('ADMIN_USERS_PASSWORD');

    return array($a, $b, $c, $d);
}

/**
 * Searches for forum auto-config at this path.
 *
 * @param  PATH $path The path in which to search
 * @return boolean Whether the forum auto-config could be found
 *
 * @ignore
 */
function _helper_install_test_load_from($path)
{
    global $PROBED_FORUM_CONFIG;
    $PROBED_FORUM_CONFIG['sql_database'] = 'cms';
    $PROBED_FORUM_CONFIG['sql_user'] = $GLOBALS['DB_STATIC_OBJECT']->db_default_user();
    $PROBED_FORUM_CONFIG['sql_pass'] = $GLOBALS['DB_STATIC_OBJECT']->db_default_password();

    $base_url = post_param_string('base_url', get_base_url());

    $PROBED_FORUM_CONFIG['board_url'] = $base_url . '/forum';
    return true;
}
