<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_database_drivers
 */

/*EXTRA FUNCTIONS: sqlsrv\_.+*/

// See sup_sqlserver tutorial for documentation on using SQL Server.

require_code('database/shared/sqlserver');

/**
 * Database Driver.
 *
 * @package    core_database_drivers
 */
class Database_Static_sqlserver extends Database_super_sqlserver
{
    public $cache_db = array();

    /**
     * Close the database connections. We don't really need to close them (will close at exit), just disassociate so we can refresh them.
     */
    public function db_close_connections()
    {
        $this->cache_db = array();
    }

    /**
     * Get a database connection. This function shouldn't be used by you, as a connection to the database is established automatically.
     *
     * @param  boolean $persistent Whether to create a persistent connection
     * @param  string $db_name The database name
     * @param  string $db_host The database host (the server)
     * @param  string $db_user The database connection username
     * @param  string $db_password The database connection password
     * @param  boolean $fail_ok Whether to on error echo an error and return with a null, rather than giving a critical error
     * @return ?array A database connection (null: failed)
     */
    public function db_get_connection($persistent, $db_name, $db_host, $db_user, $db_password, $fail_ok = false)
    {
        // Potential caching
        if (isset($this->cache_db[$db_name][$db_host])) {
            return $this->cache_db[$db_name][$db_host];
        }

        if (!function_exists('sqlsrv_connect')) {
            $error = 'The sqlserver PHP extension not installed (anymore?). You need to contact the system administrator of this server.';
            if ($fail_ok) {
                echo ((running_script('install')) && (get_param_string('type', '') == 'ajax_db_details')) ? strip_html($error) : $error;
                return null;
            }
            critical_error('PASSON', $error);
        }

        if ($db_host == '127.0.0.1' || $db_host == 'localhost' || $db_host == '0000:0000:0000:0000:0000:0000:0000:0001' || $db_host == '::1' || $db_host == '0:0:0:0:0:0:0:1') {
            $db_host = '(local)';
        }
        $db = sqlsrv_connect($db_host, ($db_user == '') ? array('Database' => $db_name) : array('UID' => $db_user, 'PWD' => $db_password, 'Database' => $db_name, 'CharacterSet' => 'UTF-8'));
        if ($db === false) {
            $err = serialize(sqlsrv_errors());
            $error = 'Could not connect to database-server (' . serialize(sqlsrv_errors()) . ')';
            if ($fail_ok) {
                echo ((running_script('install')) && (get_param_string('type', '') == 'ajax_db_details')) ? strip_html($error) : $error;
                return null;
            }
            critical_error('PASSON', $error); //warn_exit(do_lang_tempcode('CONNECT_DB_ERROR'));
        }

        sqlsrv_query($db, 'SET TEXTSIZE 20000000');

        $this->cache_db[$db_name][$db_host] = $db;
        return $db;
    }

    /**
     * This function is a very basic query executor. It shouldn't usually be used by you, as there are abstracted versions available.
     *
     * @param  string $query The complete SQL query
     * @param  array $db A DB connection
     * @param  ?integer $max The maximum number of rows to affect (null: no limit)
     * @param  ?integer $start The start row to affect (null: no specification)
     * @param  boolean $fail_ok Whether to output an error on failure
     * @param  boolean $get_insert_id Whether to get the autoincrement ID created for an insert query
     * @return ?mixed The results (null: no results), or the insert ID
     */
    public function db_query($query, $db, $max = null, $start = null, $fail_ok = false, $get_insert_id = false)
    {
        if ($max === 0) {
            return array();
        }
        $this->apply_sql_limit_clause($query, $max, $start);

        $this->rewrite_to_unicode_syntax($query);

        $bak = $GLOBALS['SUPPRESS_ERROR_DEATH'];
        $GLOBALS['SUPPRESS_ERROR_DEATH'] = true;
        $results = sqlsrv_query($db, $query, array(), array('Scrollable' => 'static'));
        $GLOBALS['SUPPRESS_ERROR_DEATH'] = $bak;
        if (($results === false) && (strtoupper(substr($query, 0, 12)) == 'INSERT INTO ') && ((strpos($query, '(id, ') !== false) || (strpos($query, '(_id, ') !== false))) {
            $pos = strpos($query, '(');
            $table_name = substr($query, 12, $pos - 13);
            @sqlsrv_query($db, 'SET IDENTITY_INSERT ' . $table_name . ' ON');
        }
        if (!is_null($start)) {
            @sqlsrv_fetch($results, SQLSRV_SCROLL_ABSOLUTE, $start - 1);
        }
        if ((($results === false) || (((strtoupper(substr(ltrim($query), 0, 7)) == 'SELECT ') || (strtoupper(substr(ltrim($query), 0, 8)) == '(SELECT '))) && ($results === true)) && (!$fail_ok)) {
            $err = serialize(sqlsrv_errors());
            if ((!running_script('upgrader')) && ((!get_mass_import_mode()) || (get_param_integer('keep_fatalistic', 0) == 1))) {
                if (!function_exists('do_lang') || is_null(do_lang('QUERY_FAILED', null, null, null, null, false))) {
                    fatal_exit(htmlentities('Query failed: ' . $query . ' : ' . $err));
                }

                fatal_exit(do_lang_tempcode('QUERY_FAILED', escape_html($query), ($err)));
            } else {
                echo htmlentities('Database query failed: ' . $query . ' [') . ($err) . htmlentities(']') . "<br />\n";
                return null;
            }
        }

        $sub = substr(ltrim($query), 0, 4);
        if (($results !== true) && (($sub === '(SEL') || ($sub === 'SELE') || ($sub === 'sele') || ($sub === 'CHEC') || ($sub === 'EXPL') || ($sub === 'REPA') || ($sub === 'DESC') || ($sub === 'SHOW')) && ($results !== false)) {
            return $this->db_get_query_rows($results, $query, $start);
        }

        if ($get_insert_id) {
            if (strtoupper(substr($query, 0, 7)) == 'UPDATE ') {
                return null;
            }

            $pos = strpos($query, '(');
            $table_name = substr($query, 12, $pos - 13);

            $res2 = sqlsrv_query($db, 'SELECT MAX(IDENTITYCOL) AS v FROM ' . $table_name);
            $ar2 = sqlsrv_fetch_array($res2, SQLSRV_FETCH_ASSOC);
            return $ar2['v'];
        }

        return null;
    }

    /**
     * Get the rows returned from a SELECT query.
     *
     * @param  resource $results The query result pointer
     * @param  string $query The complete SQL query (useful for debugging)
     * @param  ?integer $start Whether to start reading from (null: irrelevant)
     * @return array A list of row maps
     */
    public function db_get_query_rows($results, $query, $start = null)
    {
        $out = array();

        $i = 0;
        while (($row = sqlsrv_fetch_array($results, SQLSRV_FETCH_ASSOC)) !== null) {
            if ($i >= $start) {
                $out[] = $row;
            }
            $i++;
        }

        sqlsrv_free_stmt($results);

        return $out;
    }

    /**
     * Start a transaction
     *
     * @param  array $db A DB connection
     */
    public function db_start_transaction($db)
    {
        sqlsrv_begin_transaction($db);
    }

    /**
     * End a transaction
     *
     * @param  array $db A DB connection
     */
    public function db_end_transaction($db)
    {
        sqlsrv_commit($db);
    }
}
