<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/*EXTRA FUNCTIONS: TornUserinfoClass|SoapClient*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core
 */

/*
This code is not in failure.php due to the dynamic class declaration, triggering: https://bugs.php.net/bug.php?id=35634
*/

/**
 * Syndicate a spammer report out to wherever we can.
 *
 * @param  IP $ip_addr IP address to report
 * @param  ID_TEXT $username Username address to report
 * @param  EMAIL $email Email address to report
 * @param  string $reason The reason for the report (blank: none)
 * @param  boolean $trigger_error Whether to emit a Composr error, on error. Should not be 'true' for automatic spammer reports, as the spammer should not see the submission process in action!
 * @return boolean Whether it was successful
 */
function syndicate_spammer_report($ip_addr, $username, $email, $reason, $trigger_error = false)
{
    $did_something = false;

    // Syndicate to dnsbl.tornevall.org
    // ================================

    $can_do_torn = (get_option('tornevall_api_username') != '');

    if ($can_do_torn) {
        $torn_url = 'https://api.tornevall.net/3.0/dnsbl/';

        $username = get_option('tornevall_api_username');
        $password = get_option('tornevall_api_password');

        $payload = json_encode(array('ip' => array($ip_addr)));

        $_result = http_download_file($torn_url, null, $trigger_error, false, 'Composr', array($payload), null, null, null, null, null, null, null, 6.0, true, null, null, 'PUT', 'application/json');
        if ($trigger_error) {
            $result = @json_decode($_result);
            if (isset($result['response'])) {
                if (isset($result['errors'])) {
                    attach_message('dnsbl.tornevall.org: ' . $result['errors']['faultstring'], 'warn');
                }
            } else {
                attach_message('dnsbl.tornevall.org: ' . do_lang('INTERNAL_ERROR'), 'warn');
            }
        }

        $did_something = true;
    }

    // Syndicate to Stop Forum Spam
    // ============================

    $stopforumspam_key = get_option('stopforumspam_api_key');
    $can_do_stopforumspam = ($stopforumspam_key != '') && ($username != '') && ($email != '');

    if ($can_do_stopforumspam) {
        require_code('files');
        require_code('character_sets');
        $url = 'http://www.stopforumspam.com/add.php?api_key=' . urlencode($stopforumspam_key) . '&ip_addr=' . urlencode($ip_addr);
        if ($username != '') {
            $url .= '&username=' . urlencode(convert_to_internal_encoding($username, get_charset(), 'utf-8'));
        }
        if ($email != '') {
            $url .= '&email=' . urlencode(convert_to_internal_encoding($email, get_charset(), 'utf-8'));
        }
        if ($reason != '') {
            $url .= '&evidence=' . urlencode(convert_to_internal_encoding($reason, get_charset(), 'utf-8'));
        }
        $result = http_download_file($url, null, $trigger_error);
        if (($trigger_error) && ($result != '') && (strpos($result, 'data submitted successfully') === false)) {
            attach_message($result . ' [ ' . $url . ' ]', 'warn');
        }

        $did_something = true;
    }

    // ---

    // Did we get anything done?
    if (($trigger_error) && (!$did_something)) {
        attach_message(do_lang('SPAM_REPORT_NO_EMAIL_OR_USERNAME'), 'warn');
    }

    return $did_something;
}
